use lib "t/lib";
use TestAuto;

use strict;
use warnings;

use Test::More 'no_plan';

use SPVM;

my $BYTE_MAX = 127;
my $BYTE_MIN = -128;
my $SHORT_MAX = 32767;
my $SHORT_MIN = -32768;
my $INT_MAX = 2147483647;
my $INT_MIN = -2147483648;
my $LONG_MAX = 9223372036854775807;
my $LONG_MIN = -9223372036854775808;
my $FLOAT_PRECICE = 16384.5;
my $DOUBLE_PRECICE = 65536.5;

# Positive infinity(unix like system : inf, Windows : 1.#INF)
my $POSITIVE_INFINITY = 9**9**9;

my $NaN = 9**9**9 / 9**9**9;

my $nan_re = qr/(nan|ind)/i;

use SPVM 'TestCase::CoreFunc::Math';

# Start objects count
my $start_objects_count = SPVM::get_objects_count();

# Call subroutine
{
  ok(TestCase::CoreFunc::Math->test_sin());
  ok(TestCase::CoreFunc::Math->test_cos());
  ok(TestCase::CoreFunc::Math->test_tan());
}

# float
{
  ok(TestCase::CoreFunc::Math->test_float_pass_positive_infinity($POSITIVE_INFINITY));
  ok(TestCase::CoreFunc::Math->test_float_pass_nan($NaN));
  
  ok(TestCase::CoreFunc::Math->test_isinff());
  ok(TestCase::CoreFunc::Math->test_isfinitef());
  ok(TestCase::CoreFunc::Math->test_isnanf());
  
  is(SPVM::CORE->INFINITYF(), $POSITIVE_INFINITY);
  
  like(SPVM::CORE->NANF(), $nan_re);
}

# SPVM::Double
{
  ok(TestCase::CoreFunc::Math->test_double_pass_positive_infinity($POSITIVE_INFINITY));
  ok(TestCase::CoreFunc::Math->test_double_pass_nan($NaN));
  
  ok(TestCase::CoreFunc::Math->test_isinf());
  ok(TestCase::CoreFunc::Math->test_isfinite());
  ok(TestCase::CoreFunc::Math->test_isnan());
  
  is(SPVM::CORE->INFINITY(), $POSITIVE_INFINITY);
  
  like(SPVM::CORE->NAN(), $nan_re);
}

{
  ok(TestCase::CoreFunc::Math->test_byte_constant());
  ok(TestCase::CoreFunc::Math->test_short_constant());
  ok(TestCase::CoreFunc::Math->test_int_constant());
}

{
  # Check not Inf or NaN in Perl value
  like(SPVM::CORE->FLT_MAX(), qr/[0-9]/);
  like(SPVM::CORE->FLT_MIN(), qr/[0-9]/);
}

# All object is freed
my $end_objects_count = SPVM::get_objects_count();
is($end_objects_count, $start_objects_count);
