#!/usr/bin/perl -w

#This example script decodes the Base64 data and then prints it to a text file

use 5.010;
use strict;
use warnings;

use RISC::Workload;
use SOAP::Lite;
use Data::Dumper;

#Set necessary parameters
my $un = 'username';
my $pw = 'crunched password';
my $assess = 'assessmentid';
my $deviceid = 12345;

#Call get workload application subroutine
my $wa = RISC::Workload::GetWorkloadApplicationJSON($un, $pw, $assess, $deviceid);
print Dumper($wa);

#Specify the name of a file and where it is to be saved
#my $filename = 'desired-file-location\output.txt';
open(my $fh, '>', $filename) or die "Could not open file '$filename' $!";

#Decode returned data
$wa = RISC::Workload::Decode($wa);

#Add data to created file
print $fh $wa;

#Close the file connection
close $fh;

#Helpful message for locating the file that was just created
print "Complete - Check output.txt file on your Desktop to view the returned data\n";