package Google::Ads::AdWords::v201806::OfflineDataUpload;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/rm/v201806' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %externalUploadId_of :ATTR(:get<externalUploadId>);
my %uploadType_of :ATTR(:get<uploadType>);
my %uploadStatus_of :ATTR(:get<uploadStatus>);
my %uploadMetadata_of :ATTR(:get<uploadMetadata>);
my %offlineDataList_of :ATTR(:get<offlineDataList>);
my %failureReason_of :ATTR(:get<failureReason>);

__PACKAGE__->_factory(
    [ qw(        externalUploadId
        uploadType
        uploadStatus
        uploadMetadata
        offlineDataList
        failureReason

    ) ],
    {
        'externalUploadId' => \%externalUploadId_of,
        'uploadType' => \%uploadType_of,
        'uploadStatus' => \%uploadStatus_of,
        'uploadMetadata' => \%uploadMetadata_of,
        'offlineDataList' => \%offlineDataList_of,
        'failureReason' => \%failureReason_of,
    },
    {
        'externalUploadId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'uploadType' => 'Google::Ads::AdWords::v201806::OfflineDataUploadType',
        'uploadStatus' => 'Google::Ads::AdWords::v201806::OfflineDataUploadStatus',
        'uploadMetadata' => 'Google::Ads::AdWords::v201806::UploadMetadata',
        'offlineDataList' => 'Google::Ads::AdWords::v201806::OfflineData',
        'failureReason' => 'Google::Ads::AdWords::v201806::OfflineDataUploadFailureReason',
    },
    {

        'externalUploadId' => 'externalUploadId',
        'uploadType' => 'uploadType',
        'uploadStatus' => 'uploadStatus',
        'uploadMetadata' => 'uploadMetadata',
        'offlineDataList' => 'offlineDataList',
        'failureReason' => 'failureReason',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201806::OfflineDataUpload

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
OfflineDataUpload from the namespace https://adwords.google.com/api/adwords/rm/v201806.

Data representing offline transactions. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * externalUploadId


=item * uploadType


=item * uploadStatus


=item * uploadMetadata


=item * offlineDataList


=item * failureReason




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

