package Mojolicious::Command::bundle::materialize;
1;

=head1 NAME

Mojolicious::Command::bundle::materialize - Bundle materializecss

=head1 DESCRIPTION

This tutorial shows how to bundle the L<http://materializecss.com/> project
and compile the scss with L<Mojolicious::Plugin::AssetPack>.

=head1 TUTORIAL

=head2 File structure

Run these commands to set up the basic file structure:

  mkdir assets/sass/
  mkdir public/font
  cp assets/vendor/materialize/sass/materialize.scss assets/sass/main.scss
  ln -s ../../assets/vendor/materialize/font/roboto/ public/font/
  ln -s ../../assets/vendor/materialize/font/material-design-icons/ public/font/
  perl -pi -e's!components/!../vendor/materialize/sass/components/!' assets/sass/main.scss
  git add assets/sass/main.scss
  git commit -a -m"Using materializecss"

Note that the symlinks (C<ln -s>) will not work if you are shipping the
application without the C<assets/> directory.

=head2 Application

Load L<Mojolicious::Plugin::AssetPack> and define your materialize powered
assets in your L<Mojolicious> application:

  plugin AssetPack => {
    source_paths => [qw( assets )]});
  };

  app->asset("app.css" => "sass/main.scss");

  app->asset("app.js" => qw(
    http://code.jquery.com/jquery-1.11.3.min.js
    /vendor/materialize/js/velocity.min.js
    /vendor/materialize/js/waves.js
    /vendor/materialize/js/jquery.easing.1.3.js
    /vendor/materialize/js/global.js
    /vendor/materialize/js/animation.js
    /vendor/materialize/js/buttons.js
    /vendor/materialize/js/dropdown.js
    /vendor/materialize/js/forms.js
    /vendor/materialize/js/leanModal.js
    /vendor/materialize/js/tooltip.js
    /vendor/materialize/js/animation.js
    /js/main.js
  ));

L<http://code.jquery.com/jquery-1.11.3.min.js> will be fetched from web
and C</js/main.js> need to be defined in your C<assets/js/> directory.

=head2 Customization

Run these commands to have your own C<variables.scss> file:

  cp assets/vendor/materialize/sass/components/_variables.scss assets/sass/
  perl -pi -e's!../vendor/materialize/sass/components/variables!variables!' assets/sass/main.scss

Edit C<assets/sass/_variables.scss> and change what you like.

=head1 AUTHOR

Jan Henning Thorsen - C<jhthorsen@cpan.org>

=cut
