package Locale::CLDR::Ky;
# This file auto generated from Data\common\main\ky.xml
#	on Thu  2 Oct 12:11:51 pm GMT
# XML file generated 2014-08-14 15:10:07 -0500 (Thu, 14 Aug 2014)

use version;

our $VERSION = version->declare('v0.26.0');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => 'ArrayRef',
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal','spellout-cardinal-verbose','spellout-ordinal','digits-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => 'HashRef',
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'and' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(' жана =%spellout-cardinal-verbose=),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(' =%spellout-cardinal-verbose=),
				},
				'max' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(' =%spellout-cardinal-verbose=),
				},
			},
		},
		'commas' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(' жана =%spellout-cardinal-verbose=),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(, =%spellout-cardinal-verbose=),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(, ←%spellout-cardinal-verbose← миң[→%%commas→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(, =%spellout-cardinal-verbose=),
				},
				'max' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(, =%spellout-cardinal-verbose=),
				},
			},
		},
		'digits-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(−→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=#,##0==%%digits-ordinal-indicator=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=#,##0==%%digits-ordinal-indicator=),
				},
			},
		},
		'digits-ordinal-indicator' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(''инчи),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(''инчи),
				},
			},
		},
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нөл),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← бүтүн →%%z-spellout-fraction→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(бир),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(эки),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(үч),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(төрт),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(беш),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(алты),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(жети),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(сегиз),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(тогуз),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(он[ →→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(жыйырма[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(отуз[ →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(кырк[ →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(элүү[ →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(алтымыш[ →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(жетимиш[ →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(сексен[ →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(токсон[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(жүз),
				},
				'101' => {
					base_value => q(101),
					divisor => q(100),
					rule => q(←← жүз[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(←← жүз[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(миң),
				},
				'1001' => {
					base_value => q(1001),
					divisor => q(1000),
					rule => q(←← миң[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←← миң[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(миллион),
				},
				'1000001' => {
					base_value => q(1000001),
					divisor => q(1000000),
					rule => q(←← миллион[ →→]),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←← миллион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(миллиард),
				},
				'1000000001' => {
					base_value => q(1000000001),
					divisor => q(1000000000),
					rule => q(←← миллиард[ →→]),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←← миллиард[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(триллион),
				},
				'1000000000001' => {
					base_value => q(1000000000001),
					divisor => q(1000000000000),
					rule => q(←← триллион[ →→]),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←← триллион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(квадриллион),
				},
				'1000000000000001' => {
					base_value => q(1000000000000001),
					divisor => q(1000000000000000),
					rule => q(←← квадриллион[ →→]),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←← квадриллион[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-verbose' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← бүтүн →%%z-spellout-fraction→),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(жүз),
				},
				'101' => {
					base_value => q(101),
					divisor => q(100),
					rule => q(←← жүз[→%%and→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(←← жүз[→%%and→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(миң),
				},
				'1001' => {
					base_value => q(1001),
					divisor => q(1000),
					rule => q(←← миң[→%%and→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←← миң[→%%and→]),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(←← миң[→%%commas→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(миллион),
				},
				'1000001' => {
					base_value => q(1000001),
					divisor => q(1000000),
					rule => q(←← миллион[→%%commas→]),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←← миллион[→%%commas→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(миллиард),
				},
				'1000000001' => {
					base_value => q(1000000001),
					divisor => q(1000000000),
					rule => q(←← миллиард[→%%commas→]),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←← миллиард[→%%commas→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(триллион),
				},
				'1000000000001' => {
					base_value => q(1000000000001),
					divisor => q(1000000000000),
					rule => q(←← триллион[→%%commas→]),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←← триллион[→%%commas→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(квадриллион),
				},
				'1000000000000001' => {
					base_value => q(1000000000000001),
					divisor => q(1000000000000000),
					rule => q(←← квадриллион[→%%commas→]),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←← квадриллион[→%%commas→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нөлүнчү),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(биринчи),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(экинчи),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(үчүнчү),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(төртүнчү),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(бешинчи),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(алтынчы),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(жетинчи),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(сегизинчи),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(тогузунчу),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(он→%%унчу→),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(жыйырма→%%нчы→),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(отуз→%%унчу→),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(кырк→%%ынчы→),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(элүү→%%нчү→),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(алтымыш→%%ынчы→),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(жетимиш→%%инчи→),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(сексен→%%инчи→),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(токсон→%%унчу→),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(жүзүнчү),
				},
				'101' => {
					base_value => q(101),
					divisor => q(100),
					rule => q(←%spellout-numbering← жүз→%%үнчү→),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(←%spellout-numbering← жүз→%%үнчү→),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(миңиңчи),
				},
				'1001' => {
					base_value => q(1001),
					divisor => q(1000),
					rule => q(←%spellout-numbering← миң→%%иңчи→),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-numbering← миң→%%иңчи→),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(миллионунчу),
				},
				'1000001' => {
					base_value => q(1000001),
					divisor => q(1000000),
					rule => q(←%spellout-numbering← миллион→%%унчу→),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←%spellout-numbering← миллион→%%унчу→),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(миллиардынчы),
				},
				'1000000001' => {
					base_value => q(1000000001),
					divisor => q(1000000000),
					rule => q(←%spellout-numbering← миллиард→%%ынчы→),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-numbering← миллиард→%%ынчы→),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(триллионунчу),
				},
				'1000000000001' => {
					base_value => q(1000000000001),
					divisor => q(1000000000000),
					rule => q(←%spellout-numbering← триллион→%%унчу→),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-numbering← триллион→%%унчу→),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(квадриллионунчу),
				},
				'1000000000000001' => {
					base_value => q(1000000000000001),
					divisor => q(1000000000000000),
					rule => q(←%spellout-numbering← квадриллион→%%унчу→),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-numbering← квадриллион→%%унчу→),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0='инчи),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0='инчи),
				},
			},
		},
		'z-spellout-fraction' => {
			'private' => {
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ондон ←%spellout-numbering←),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(жүздөн ←%spellout-numbering←),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(миңден ←%spellout-numbering←),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(он миңден ←%spellout-numbering←),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(жүз миңден ←%spellout-numbering←),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(миллиондон ←%spellout-numbering←),
				},
				'10000000' => {
					base_value => q(10000000),
					divisor => q(10000000),
					rule => q(он миллиондон ←%spellout-numbering←),
				},
				'100000000' => {
					base_value => q(100000000),
					divisor => q(100000000),
					rule => q(жүз миллиондон ←%spellout-numbering←),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(миллиарддан ←%spellout-numbering←),
				},
				'10000000000' => {
					base_value => q(10000000000),
					divisor => q(10000000000),
					rule => q(он миллиарддан ←%spellout-numbering←),
				},
				'100000000000' => {
					base_value => q(100000000000),
					divisor => q(100000000000),
					rule => q(жүз миллиарддан ←%spellout-numbering←),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(0* ←#,##0←←),
				},
				'max' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(0* ←#,##0←←),
				},
			},
		},
		'инчи' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(инчи),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'иңчи' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(иңчи),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'нчы' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нчы),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'нчү' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нчү),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'унчу' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(унчу),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'ынчы' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ынчы),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'үнчү' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(үнчү),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'ab' => 'абхазча',
 				'af' => 'африкаанча',
 				'agq' => 'агемче',
 				'ak' => 'аканча',
 				'am' => 'амхарча',
 				'ar' => 'арабча',
 				'ar_001' => 'азыркы адабий араб тилинде',
 				'arn' => 'мапучеде',
 				'as' => 'ассамча',
 				'asa' => 'асуча',
 				'az' => 'азербайжанча',
 				'ba' => 'башкырча',
 				'be' => 'беларусча',
 				'bem' => 'бембача',
 				'bez' => 'бенача',
 				'bg' => 'болгарча',
 				'bm' => 'бамбарада',
 				'bn' => 'бангладешче',
 				'bo' => 'тибетче',
 				'br' => 'бретончо',
 				'brx' => 'бододо',
 				'bs' => 'боснийче',
 				'ca' => 'каталанча',
 				'cgg' => 'чигача',
 				'chr' => 'черокиче',
 				'ckb' => 'сорани курд',
 				'co' => 'корсиканча',
 				'cs' => 'чехче',
 				'cy' => 'уелшче',
 				'da' => 'датча',
 				'dav' => 'таитача',
 				'de' => 'немисче',
 				'de_CH' => 'жогорку немисче (Швейцария)',
 				'dje' => 'замрача',
 				'dsb' => 'төмөнкү сорбианча',
 				'dua' => 'дуалача',
 				'dyo' => 'жола-фониче',
 				'dz' => 'жонгуча',
 				'ebu' => 'эмбуча',
 				'ee' => 'эбече',
 				'el' => 'грекче',
 				'en' => 'англисче',
 				'en_GB@alt=short' => 'англисче (УБ)',
 				'en_US@alt=short' => 'англисче (АКШ)',
 				'eo' => 'эсперанто',
 				'es' => 'испанча',
 				'es_ES' => 'испанча (Европа)',
 				'et' => 'эстончо',
 				'eu' => 'баскча',
 				'fa' => 'фарсыча',
 				'fi' => 'финче',
 				'fil' => 'филипино',
 				'fj' => 'фижиче',
 				'fo' => 'фароэче',
 				'fr' => 'французча',
 				'fy' => 'батыш фризче',
 				'ga' => 'ирландча',
 				'gag' => 'гагаузча',
 				'gl' => 'галисияча',
 				'gn' => 'гуараш',
 				'gsw' => 'немисче (Швейцария)',
 				'gu' => 'гужаратча',
 				'guz' => 'гусиче',
 				'gv' => 'манксыча',
 				'ha' => 'хаусача',
 				'haw' => 'гавайча',
 				'he' => 'ивритте',
 				'hi' => 'хиндиче',
 				'hr' => 'хорватча',
 				'hsb' => 'жогорку сорбианча',
 				'ht' => 'гаитиче',
 				'hu' => 'мажарча',
 				'hy' => 'армянча',
 				'id' => 'индонезче',
 				'ig' => 'игбочо',
 				'ii' => 'носуча',
 				'is' => 'исландча',
 				'it' => 'италиянча',
 				'iu' => 'инуктитутта',
 				'ja' => 'япончо',
 				'jgo' => 'нгомбача',
 				'jmc' => 'мачамече',
 				'jv' => 'жаванизче',
 				'ka' => 'грузинче',
 				'kab' => 'кабылча',
 				'kam' => 'камбача',
 				'kde' => 'макондече',
 				'kea' => 'кабувердиче',
 				'khq' => 'койра чиниче',
 				'ki' => 'кикуйиче',
 				'kk' => 'казакча',
 				'kl' => 'калаалисутча',
 				'kln' => 'каленжиче',
 				'km' => 'кмерче',
 				'kn' => 'каннадача',
 				'ko' => 'корейче',
 				'koi' => 'коми-пермякча',
 				'kok' => 'конканиче',
 				'ks' => 'кашмирче',
 				'ksb' => 'шамабалача',
 				'ksf' => 'бафияча',
 				'ku' => 'курдча',
 				'kw' => 'корнишче',
 				'ky' => 'кыргызча',
 				'la' => 'латынча',
 				'lag' => 'лангиче',
 				'lb' => 'люксембургча',
 				'lg' => 'гандача',
 				'lkt' => 'лакотача',
 				'ln' => 'лингалача',
 				'lo' => 'лаочо',
 				'lt' => 'литовчо',
 				'lu' => 'луба-катангача',
 				'luo' => 'луочо',
 				'luy' => 'лухияча',
 				'lv' => 'латышча',
 				'mas' => 'масайча',
 				'mer' => 'меруча',
 				'mfe' => 'морисианча',
 				'mg' => 'малагасча',
 				'mgh' => 'макуача',
 				'mgo' => 'метөчө',
 				'mi' => 'маориче',
 				'mk' => 'македончо',
 				'ml' => 'малайаламча',
 				'mn' => 'моңголчо',
 				'moh' => 'мохаукча',
 				'mr' => 'маратиче',
 				'ms' => 'малайча',
 				'mt' => 'малтизче',
 				'mua' => 'мундангча',
 				'my' => 'бурмача',
 				'naq' => 'намача',
 				'nb' => 'норвежче (Букмал)',
 				'nd' => 'түндүк ндыбелче',
 				'ne' => 'непалча',
 				'nl' => 'голландча',
 				'nl_BE' => 'фламандча',
 				'nmg' => 'квасиочо',
 				'nn' => 'норвежче (Нинорск)',
 				'no' => 'норвежче',
 				'nqo' => 'нкочо',
 				'nus' => 'нуерче',
 				'nyn' => 'ныйанколчо',
 				'om' => 'оромочо',
 				'or' => 'орияча',
 				'pa' => 'пунжабиче',
 				'pl' => 'полякча',
 				'ps' => 'пашточо',
 				'pt' => 'португалча',
 				'pt_PT' => 'португалча (Европа)',
 				'qu' => 'кечуача',
 				'quc' => 'кичече',
 				'rm' => 'романшча',
 				'rn' => 'рундиче',
 				'ro' => 'румынча',
 				'ro_MD' => 'молдованча',
 				'rof' => 'ромбочо',
 				'ru' => 'орусча',
 				'rw' => 'руандача',
 				'rwk' => 'руача',
 				'sa' => 'санскритче',
 				'saq' => 'самбуруча',
 				'sbp' => 'сангуча',
 				'sd' => 'синдхиче',
 				'se' => 'түндүк самиче',
 				'seh' => 'сенача',
 				'ses' => 'койраборо сенниче',
 				'sg' => 'сангочо',
 				'sh' => 'серб-хорват',
 				'shi' => 'ташелитче',
 				'si' => 'сингалача',
 				'sk' => 'словакча',
 				'sl' => 'словенче',
 				'sma' => 'түштүк саамиче',
 				'smj' => 'лөлө саамиче',
 				'smn' => 'инари саамиче',
 				'sms' => 'сколт саамиче',
 				'sn' => 'шонача',
 				'so' => 'сомаличе',
 				'sq' => 'албанча',
 				'sr' => 'сербче',
 				'st' => 'сесото',
 				'su' => 'сунданча',
 				'sv' => 'шведче',
 				'sw' => 'суахиличе',
 				'swc' => 'конго суахаличе',
 				'ta' => 'тамилче',
 				'te' => 'телугуча',
 				'teo' => 'тесочо',
 				'tg' => 'тажикче',
 				'th' => 'тайча',
 				'ti' => 'тигриниача',
 				'tk' => 'түркмөнчө',
 				'tlh' => 'клингончо',
 				'to' => 'тонгача',
 				'tr' => 'түркчө',
 				'tt' => 'татарча',
 				'tw' => 'тви',
 				'twq' => 'тасабакча',
 				'tzm' => 'борбордук Атлас тамазитче',
 				'ug' => 'уйгурча',
 				'uk' => 'украинче',
 				'und' => 'белгисиз тилде',
 				'ur' => 'урдуча',
 				'uz' => 'өзбекче',
 				'vai' => 'вайиче',
 				'vi' => 'вьетнамча',
 				'vun' => 'вунжочо',
 				'wo' => 'уолофчо',
 				'xh' => 'косача',
 				'xog' => 'согача',
 				'yi' => 'идишче',
 				'yo' => 'йорубача',
 				'zgh' => 'марокко тамазигт адабий тилинде',
 				'zh' => 'кытайча',
 				'zh_Hans' => 'кытайча (жөнөкөйлөштүрүлгөн)',
 				'zh_Hant' => 'кытайча (салттуу)',
 				'zu' => 'зулуча',
 				'zxx' => 'тилдик мазмун жок',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'Араб',
 			'Armn' => 'Армян',
 			'Beng' => 'Бенгал',
 			'Bopo' => 'Бопомофо',
 			'Brai' => 'Брейл',
 			'Cyrl' => 'Кирилик',
 			'Deva' => 'Деванагари',
 			'Ethi' => 'Эфиоп',
 			'Geor' => 'Грузин',
 			'Grek' => 'Грек',
 			'Gujr' => 'Гужарати',
 			'Guru' => 'Гурмухи',
 			'Hang' => 'Хангул',
 			'Hani' => 'Хани',
 			'Hans' => 'Жөн. Кытай',
 			'Hans@alt=stand-alone' => 'Жөн. Кытай',
 			'Hant' => 'Салт. Кытай',
 			'Hant@alt=stand-alone' => 'Салт. Кытай',
 			'Hebr' => 'Иврит',
 			'Hira' => 'Хирагана',
 			'Jpan' => 'Жапан',
 			'Kana' => 'Катакана',
 			'Khmr' => 'Кмер',
 			'Knda' => 'Каннада',
 			'Kore' => 'Корей',
 			'Laoo' => 'Лао',
 			'Latn' => 'Латын',
 			'Mlym' => 'Малайалам',
 			'Mong' => 'Моңгол',
 			'Mymr' => 'Мйанмар',
 			'Orya' => 'Орийа',
 			'Sinh' => 'Сингала',
 			'Taml' => 'Тамил',
 			'Telu' => 'Телу',
 			'Thaa' => 'Таана',
 			'Thai' => 'Тай',
 			'Tibt' => 'Тибет',
 			'Zsym' => 'Белгилер',
 			'Zxxx' => 'Жазылбаган',
 			'Zyyy' => 'Жалпы',
 			'Zzzz' => 'Белгисиз жазуу',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Дүйнө',
 			'002' => 'Африка',
 			'003' => 'Түндүк Америка',
 			'005' => 'Түштүк Америка',
 			'009' => 'Океания',
 			'011' => 'Батыш Африка',
 			'013' => 'Борбордук Америка',
 			'014' => 'Чыгыш Африка',
 			'015' => 'Түндүк Африка',
 			'017' => 'Борбордук Африка',
 			'018' => 'Түштүк Африка',
 			'019' => 'Америка',
 			'021' => 'Түндүк Америка (регион)',
 			'029' => 'Кариб аралдары',
 			'030' => 'Чыгыш Азия',
 			'034' => 'Түштүк Азия',
 			'035' => 'Түштүк-Чыгыш Азия',
 			'039' => 'Түштүк Европа',
 			'053' => 'Австралазия',
 			'054' => 'Меланезия',
 			'057' => 'Микронезия Региону',
 			'061' => 'Полинезия',
 			'142' => 'Азия',
 			'143' => 'Борбор Азия',
 			'145' => 'Батыш Азия',
 			'150' => 'Европа',
 			'151' => 'Чыгыш Европа',
 			'154' => 'Түндүк Европа',
 			'155' => 'Батыш Европа',
 			'419' => 'Латын Америкасы',
 			'AC' => 'Ассеншин аралы',
 			'AD' => 'Андорра',
 			'AE' => 'Бириккен Араб Эмираттары',
 			'AF' => 'Афганистан',
 			'AG' => 'Антигуа жана Барбуда',
 			'AI' => 'Ангуила',
 			'AL' => 'Албания',
 			'AM' => 'Армения',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктика',
 			'AR' => 'Аргентина',
 			'AS' => 'Америка Самоасы',
 			'AT' => 'Австрия',
 			'AU' => 'Австралия',
 			'AW' => 'Аруба',
 			'AX' => 'Аланд аралдары',
 			'AZ' => 'Азербайжан',
 			'BA' => 'Босния жана Герцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельгия',
 			'BF' => 'Буркина-Фасо',
 			'BG' => 'Болгария',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сент Бартелеми',
 			'BM' => 'Бермуд аралдары',
 			'BN' => 'Бруней',
 			'BO' => 'Боливия',
 			'BQ' => 'Кариб Нидерланддары',
 			'BR' => 'Бразилия',
 			'BS' => 'Багам аралдары',
 			'BT' => 'Бутан',
 			'BV' => 'Буве аралдары',
 			'BW' => 'Ботсвана',
 			'BY' => 'Беларусь',
 			'BZ' => 'Белиз',
 			'CA' => 'Канада',
 			'CC' => 'Кокос (Килиӊ) аралдары',
 			'CD' => 'Конго-Киншаса',
 			'CD@alt=variant' => 'Конго (КДР)',
 			'CF' => 'Борбордук Африка Республикасы',
 			'CG' => 'Конго-Браззавил',
 			'CG@alt=variant' => 'Конго (Республикасы)',
 			'CH' => 'Швейцария',
 			'CI' => 'Кот-д’Ивуар',
 			'CI@alt=variant' => 'Кот-д’Ивуар (вариант)',
 			'CK' => 'Кук аралдары',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Кытай',
 			'CO' => 'Колумбия',
 			'CP' => 'Клиппертон аралы',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Капе Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'Крисмас аралы',
 			'CY' => 'Кипр',
 			'CZ' => 'Чехия',
 			'DE' => 'Германия',
 			'DG' => 'Диего Гарсия',
 			'DJ' => 'Джибути',
 			'DK' => 'Дания',
 			'DM' => 'Доминика',
 			'DO' => 'Доминика Республикасы',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута жана Мелилла',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстония',
 			'EG' => 'Египет',
 			'EH' => 'Батыш Сахара',
 			'ER' => 'Эритрея',
 			'ES' => 'Испания',
 			'ET' => 'Эфиопия',
 			'EU' => 'Европа Биримдиги',
 			'FI' => 'Финляндия',
 			'FJ' => 'Фиджи',
 			'FK' => 'Фолклэнд аралдары',
 			'FK@alt=variant' => 'Фолклэнд (Малвина) аралдары',
 			'FM' => 'Микронезия',
 			'FO' => 'Фарер аралдары',
 			'FR' => 'Франция',
 			'GA' => 'Габон',
 			'GB' => 'Улуу Британия',
 			'GB@alt=short' => 'УБ',
 			'GD' => 'Гренада',
 			'GE' => 'Грузия',
 			'GF' => 'Гвиана (Франция)',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренландия',
 			'GM' => 'Гамбия',
 			'GN' => 'Гвинея',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Экваториалдык Гвинея',
 			'GR' => 'Греция',
 			'GS' => 'Түштүк Жоржия жана Түштүк Сэндвич аралдары',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинея-Бисау',
 			'GY' => 'Гайана',
 			'HK' => 'Гонконг Кытай ААА',
 			'HK@alt=short' => 'Гонконг',
 			'HM' => 'Херд жана Макдоналд аралдары',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорватия',
 			'HT' => 'Гаити',
 			'HU' => 'Венгрия',
 			'IC' => 'Канар аралдары',
 			'ID' => 'Индонезия',
 			'IE' => 'Ирландия',
 			'IL' => 'Израиль',
 			'IM' => 'Мэн аралы',
 			'IN' => 'Индия',
 			'IO' => 'Британиянын Индия океанындагы аймагы',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исландия',
 			'IT' => 'Италия',
 			'JE' => 'Жерси',
 			'JM' => 'Ямайка',
 			'JO' => 'Иордания',
 			'JP' => 'Япония',
 			'KE' => 'Кения',
 			'KG' => 'Кыргызстан',
 			'KH' => 'Камбоджа',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморос',
 			'KN' => 'Сент-Китс жана Невис',
 			'KP' => 'Түндүк Корея',
 			'KR' => 'Түштүк Корея',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайман Аралдары',
 			'KZ' => 'Казакстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент-Люсия',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либерия',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латвия',
 			'LY' => 'Ливия',
 			'MA' => 'Марокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Черногория',
 			'MF' => 'Сент-Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалл аралдары',
 			'MK' => 'Македония',
 			'MK@alt=variant' => 'Македония (Мур. Югосл.)',
 			'ML' => 'Мали',
 			'MM' => 'Мьянма (Бирма)',
 			'MN' => 'Монголия',
 			'MO' => 'Макау Кытай ААА',
 			'MO@alt=short' => 'Макау',
 			'MP' => 'Түндүк Мариана аралдары',
 			'MQ' => 'Мартиника',
 			'MR' => 'Мавритания',
 			'MS' => 'Монсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврикий',
 			'MV' => 'Малдив аралдары',
 			'MW' => 'Малави',
 			'MX' => 'Мексика',
 			'MY' => 'Малайзия',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибия',
 			'NC' => 'Жаӊы Каледония',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк аралы',
 			'NG' => 'Нигерия',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерланддар',
 			'NO' => 'Норвегия',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуэ',
 			'NZ' => 'Жаӊы Зеландия',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француз Полинезиясы',
 			'PG' => 'Папуа Жаңы-Гвинея',
 			'PH' => 'Филлипин',
 			'PK' => 'Пакистан',
 			'PL' => 'Польша',
 			'PM' => 'Сен-Пьер жана Микелон',
 			'PN' => 'Питкэрн аралдары',
 			'PR' => 'Пуэрто-Рико',
 			'PS' => 'Палестина аймактары',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалия',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'Алыскы Океания',
 			'RE' => 'Реюнион',
 			'RO' => 'Румыния',
 			'RS' => 'Сербия',
 			'RU' => 'Россия',
 			'RW' => 'Руанда',
 			'SA' => 'Сауд Арабиясы',
 			'SB' => 'Соломон аралдары',
 			'SC' => 'Сейшелдер',
 			'SD' => 'Судан',
 			'SE' => 'Швеция',
 			'SG' => 'Сингапур',
 			'SH' => 'Ыйык Елена',
 			'SI' => 'Словения',
 			'SJ' => 'Свалбард жана Жан Майен',
 			'SK' => 'Словакия',
 			'SL' => 'Сьерра-Леоне',
 			'SM' => 'Сан Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринаме',
 			'SS' => 'Түштүк Судан',
 			'ST' => 'Сан-Томе жана Принсипи',
 			'SV' => 'Эл Салвадор',
 			'SX' => 'Синт Маартен',
 			'SY' => 'Сирия',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан да Кунья',
 			'TC' => 'Түркс жана Кайкос аралдары',
 			'TD' => 'Чад',
 			'TF' => 'Франциянын Түштүктөгү аймактары',
 			'TG' => 'Того',
 			'TH' => 'Таиланд',
 			'TJ' => 'Тажикстан',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лесте',
 			'TL@alt=variant' => 'Чыгыш Тимор',
 			'TM' => 'Түркмөнстан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Түркия',
 			'TT' => 'Тринидад жана Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайвань',
 			'TZ' => 'Танзания',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'АКШнын сырткы аралдары',
 			'US' => 'Америка Кошмо Штаттары',
 			'US@alt=short' => 'АКШ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Өзбекстан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент-Винсент жана Гренадиналар',
 			'VE' => 'Венесуэла',
 			'VG' => 'Виргин аралдары (Британия)',
 			'VI' => 'Виргин аралдары (АКШ)',
 			'VN' => 'Вьетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллис жана Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Йемен',
 			'YT' => 'Майотта',
 			'ZA' => 'Түштүк Африка Республикасы',
 			'ZM' => 'Замбия',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Белгисиз регион',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'календарь',
 			'collation' => 'иреттөө тартиби',
 			'currency' => 'валюта',
 			'numbers' => 'сандар',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{буддачылык календары},
 				'chinese' => q{кытай календары},
 				'dangi' => q{данги каленендары},
 				'ethiopic' => q{эфиоп календары},
 				'gregorian' => q{григориан календары},
 				'hebrew' => q{иврит календары},
 				'islamic' => q{ислам календары},
 				'iso8601' => q{ИСО-8601 календары},
 				'japanese' => q{япон календары},
 				'persian' => q{перс календары},
 				'roc' => q{мингуо календары},
 			},
 			'collation' => {
 				'ducet' => q{баштапкы уникод ирети},
 				'search' => q{жалпы издөө},
 				'standard' => q{иреттөө стандарты},
 			},
 			'numbers' => {
 				'arab' => q{араб-индус сандары},
 				'arabext' => q{кеңейтилген араб-индус сандары},
 				'armn' => q{армян сандары},
 				'armnlow' => q{армян сандары (саптык жазылыш)},
 				'beng' => q{бенгали сандары},
 				'deva' => q{деванагари сандары},
 				'ethi' => q{эфиоп сандары},
 				'fullwide' => q{толук эндүү сандар},
 				'geor' => q{грузин сандары},
 				'grek' => q{грек сандары},
 				'greklow' => q{грек сандары (саптык жазылыш)},
 				'gujr' => q{гужарати сандары},
 				'guru' => q{гурмухи сандары},
 				'hanidec' => q{кытай ондук сандары},
 				'hans' => q{жөнөкөйлөштүрүлгөн кытай сандары},
 				'hansfin' => q{жөнөкөйлөштүрүлгөн кытай финансы сандары},
 				'hant' => q{салттуу кытай сандары},
 				'hantfin' => q{салттуу кытай финансы сандары},
 				'hebr' => q{иврит сандары},
 				'jpan' => q{япон сандары},
 				'jpanfin' => q{япон финансы сандары},
 				'khmr' => q{кмер сандары},
 				'knda' => q{каннада сандары},
 				'laoo' => q{лао сандары},
 				'latn' => q{батыш сандары},
 				'mlym' => q{малайалам сандары},
 				'mymr' => q{мйанмар сандары},
 				'orya' => q{ория сандары},
 				'roman' => q{роман сандары},
 				'romanlow' => q{роман сандары (саптык жазылыш)},
 				'taml' => q{салттуу тамил сандары},
 				'tamldec' => q{тамил сандары},
 				'telu' => q{телугу сандары},
 				'thai' => q{тай сандары},
 				'tibt' => q{тибет сандары},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{метрикалык},
 			'UK' => q{Британия},
 			'US' => q{АКШ},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'numeric' => 'Сандык',
 			'tone' => 'Тондук',
 			'x-accents' => 'Диакриттик белгилер',
 			'x-fullwidth' => 'Кең формат',
 			'x-halfwidth' => 'Кыска формат',
 			'x-jamo' => 'Джамо',
 			'x-pinyin' => 'Пиньин',
 			'x-publishing' => 'Басмаканалык',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'тили: {0}',
 			'script' => 'жазуусу: {0}',
 			'territory' => 'региону:{0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[в ф ц щ ь])},
			index => ['А', 'Б', 'Г', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'Ӊ', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ү', 'Х', 'Ч', 'Ш', 'Ъ', 'Ы', 'Э', 'Ю', 'Я'],
			main => qr{(?^u:[а б г д е ё ж з и й к л м н ӊ о ө п р с т у ү х ч ш ъ ы э ю я])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ' ‘ ‚ " “ „ « » ( ) \[ \] \{ \} § @ * / \& #])},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'Г', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'Ӊ', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ү', 'Х', 'Ч', 'Ш', 'Ъ', 'Ы', 'Э', 'Ю', 'Я'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{„},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'acre-foot' => {
						'' => q(акр-фут),
						'one' => q({0} акр-фут),
						'other' => q({0} акр-фут),
					},
					'ampere' => {
						'' => q(ампер),
						'one' => q({0} ампер),
						'other' => q({0} ампер),
					},
					'arc-minute' => {
						'' => q(′),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'' => q(арксекунд),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'' => q(астрономикалык бирдик),
						'one' => q({0} астрономикалык бирдик),
						'other' => q({0} астрономикалык бирдик),
					},
					'bit' => {
						'' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					'byte' => {
						'' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					'calorie' => {
						'' => q(калория),
						'one' => q({0} калория),
						'other' => q({0} калория),
					},
					'carat' => {
						'' => q(карат),
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					'celsius' => {
						'' => q(Цельсий градусу),
						'one' => q({0} Цельсий градусу),
						'other' => q({0} Цельсий градусу),
					},
					'centiliter' => {
						'' => q(сантилитр),
						'one' => q({0} сантилитр),
						'other' => q({0} сантилитр),
					},
					'centimeter' => {
						'' => q(сантиметр),
						'one' => q({0} сантиметр),
						'other' => q({0} сантиметр),
					},
					'cubic-centimeter' => {
						'' => q(куб сантиметр),
						'one' => q({0} куб сантиметр),
						'other' => q({0} куб сантиметр),
					},
					'cubic-foot' => {
						'' => q(куб фут),
						'one' => q({0} куб фут),
						'other' => q({0} куб фут),
					},
					'cubic-inch' => {
						'' => q(куб дюйм),
						'one' => q({0} куб дюйм),
						'other' => q({0} куб дюйм),
					},
					'cubic-kilometer' => {
						'' => q(куб километр),
						'one' => q({0} куб километр),
						'other' => q({0} куб километр),
					},
					'cubic-meter' => {
						'' => q(куб метр),
						'one' => q({0} куб метр),
						'other' => q({0} куб метр),
					},
					'cubic-mile' => {
						'' => q(куб мил),
						'one' => q({0} куб мил),
						'other' => q({0} куб мил),
					},
					'cubic-yard' => {
						'' => q(куб ярд),
						'one' => q({0} куб ярд),
						'other' => q({0} куб ярд),
					},
					'cup' => {
						'' => q(чөйчөк),
						'one' => q({0} чөйчөк),
						'other' => q({0} чөйчөк),
					},
					'day' => {
						'' => q(күн),
						'one' => q({0} күн),
						'other' => q({0} күн),
					},
					'deciliter' => {
						'' => q(декалитр),
						'one' => q({0} декалитр),
						'other' => q({0} декалитр),
					},
					'decimeter' => {
						'' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					'degree' => {
						'' => q(градус),
						'one' => q({0} градус),
						'other' => q({0} градус),
					},
					'fahrenheit' => {
						'' => q(Фаренгейт градусу),
						'one' => q({0} Фаренгейт градусу),
						'other' => q({0} Фаренгейт градусу),
					},
					'fluid-ounce' => {
						'' => q(суюк унция),
						'one' => q({0} суюк унция),
						'other' => q({0} суюк унция),
					},
					'foodcalorie' => {
						'' => q(Калория),
						'one' => q({0} Калория),
						'other' => q({0} Калория),
					},
					'foot' => {
						'' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
					},
					'g-force' => {
						'' => q(оордук күчүнүн ылдамдануусу),
						'one' => q({0} оордук күчү),
						'other' => q({0} оордук күчү),
					},
					'gallon' => {
						'' => q(галон),
						'one' => q({0} галон),
						'other' => q({0} гал),
					},
					'gigabit' => {
						'' => q(гигабит),
						'one' => q({0} гигабит),
						'other' => q({0} гигабит),
					},
					'gigabyte' => {
						'' => q(гигабайт),
						'one' => q({0} гигабайт),
						'other' => q({0} гигабайт),
					},
					'gigahertz' => {
						'' => q(гигагерц),
						'one' => q({0} гигагерц),
						'other' => q({0} гигагерц),
					},
					'gigawatt' => {
						'' => q(гигаватт),
						'one' => q({0} гигаватт),
						'other' => q({0} гигаватт),
					},
					'gram' => {
						'' => q(грамм),
						'one' => q({0} грамм),
						'other' => q({0} грамм),
					},
					'hectare' => {
						'' => q(гектар),
						'one' => q({0} гектар),
						'other' => q({0} гектар),
					},
					'hectoliter' => {
						'' => q(гектолитр),
						'one' => q({0} гектолитр),
						'other' => q({0} гектолитр),
					},
					'hectopascal' => {
						'' => q(гектопаскаль),
						'one' => q({0} гектопаскаль),
						'other' => q({0} гектопаскаль),
					},
					'hertz' => {
						'' => q(герц),
						'one' => q({0} герц),
						'other' => q({0} герц),
					},
					'horsepower' => {
						'' => q(аттын күчү),
						'one' => q({0} аттын күчү),
						'other' => q({0} аттын күчү),
					},
					'hour' => {
						'' => q({0} саатына),
						'one' => q({0} саат),
						'other' => q({0} саат),
					},
					'inch' => {
						'' => q(дюйм),
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
					},
					'inch-hg' => {
						'' => q(дүйм сымап мамычасы),
						'one' => q({0} дүйм сымап мамычасы),
						'other' => q({0} дүйм сымап мамычасы),
					},
					'joule' => {
						'' => q(жоул),
						'one' => q({0} жоул),
						'other' => q({0} жоул),
					},
					'karat' => {
						'' => q(карат),
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					'kelvin' => {
						'' => q(Келвин градусу),
						'one' => q({0} Келвин градусу),
						'other' => q({0} Келвин градусу),
					},
					'kilobit' => {
						'' => q(килобит),
						'one' => q({0} килобит),
						'other' => q({0} килобит),
					},
					'kilobyte' => {
						'' => q(килобайт),
						'one' => q({0} килобайт),
						'other' => q({0} килобайт),
					},
					'kilocalorie' => {
						'' => q(килокалория),
						'one' => q({0} килокалория),
						'other' => q({0} килокалория),
					},
					'kilogram' => {
						'' => q(килограмм),
						'one' => q({0} килограмм),
						'other' => q({0} килограмм),
					},
					'kilohertz' => {
						'' => q(килогерц),
						'one' => q({0} килогерц),
						'other' => q({0} килогерц),
					},
					'kilojoule' => {
						'' => q(киложоул),
						'one' => q({0} киложоул),
						'other' => q({0} киложоул),
					},
					'kilometer' => {
						'' => q(километр),
						'one' => q({0} километр),
						'other' => q({0} километр),
					},
					'kilometer-per-hour' => {
						'' => q(саатына километр),
						'one' => q(саатына {0} километр),
						'other' => q(саатына {0} километр),
					},
					'kilowatt' => {
						'' => q(киловатт),
						'one' => q({0} киловатт),
						'other' => q({0} киловатт),
					},
					'kilowatt-hour' => {
						'' => q(килловат-саат),
						'one' => q({0} килловат-саат),
						'other' => q({0} килловат-саат),
					},
					'light-year' => {
						'' => q(жарык жыл),
						'one' => q({0} жарык жыл),
						'other' => q({0} жарык жыл),
					},
					'liter' => {
						'' => q(литр),
						'one' => q({0} литр),
						'other' => q({0} литр),
					},
					'liter-per-kilometer' => {
						'' => q(л/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					'lux' => {
						'' => q(люкс),
						'one' => q({0} люкс),
						'other' => q({0} люкс),
					},
					'megabit' => {
						'' => q(мегабит),
						'one' => q({0} мегабит),
						'other' => q({0} мегабит),
					},
					'megabyte' => {
						'' => q(мегабайт),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайт),
					},
					'megahertz' => {
						'' => q(мегагерц),
						'one' => q({0} мегагерц),
						'other' => q({0} мегагерц),
					},
					'megaliter' => {
						'' => q(мегалитр),
						'one' => q({0} мегалитр),
						'other' => q({0} мегалитр),
					},
					'megawatt' => {
						'' => q(мегаватт),
						'one' => q({0} мегаватт),
						'other' => q({0} мегаватт),
					},
					'meter' => {
						'' => q(метр),
						'one' => q({0} метр),
						'other' => q({0} метр),
					},
					'meter-per-second' => {
						'' => q(метр/секунд),
						'one' => q({0} метр/секунд),
						'other' => q({0} метр/секунд),
					},
					'meter-per-second-squared' => {
						'' => q(метр/квадраттык секунд),
						'one' => q({0} метр/квадраттык секунд),
						'other' => q({0} метр/квадраттык секунд),
					},
					'metric-ton' => {
						'' => q(метр тонна),
						'one' => q({0} метр тонна),
						'other' => q({0} метр тонна),
					},
					'microgram' => {
						'' => q(микрограмм),
						'one' => q({0} микрограмм),
						'other' => q({0} микрограмм),
					},
					'micrometer' => {
						'' => q(микрометр),
						'one' => q(микрометр),
						'other' => q({0} микрометр),
					},
					'microsecond' => {
						'' => q(микросекунд),
						'one' => q({0} микросекунд),
						'other' => q({0} микросекунд),
					},
					'mile' => {
						'' => q(мил),
						'one' => q({0} мил),
						'other' => q({0} мил),
					},
					'mile-per-gallon' => {
						'' => q(милге/галон),
						'one' => q({0} милге/галон),
						'other' => q({0} милге/галон),
					},
					'mile-per-hour' => {
						'' => q(мил/саат),
						'one' => q({0} мил/саат),
						'other' => q({0} мил/саат),
					},
					'milliampere' => {
						'' => q(миллиампер),
						'one' => q({0} миллиампер),
						'other' => q({0} миллиампер),
					},
					'millibar' => {
						'' => q(миллибар),
						'one' => q({0} миллибар),
						'other' => q({0} миллибар),
					},
					'milligram' => {
						'' => q(миллиграмм),
						'one' => q({0} миллиграмм),
						'other' => q({0} миллиграмм),
					},
					'milliliter' => {
						'' => q(миллилитр),
						'one' => q({0} миллилитр),
						'other' => q({0} миллилитр),
					},
					'millimeter' => {
						'' => q(миллиметр),
						'one' => q({0} миллиметр),
						'other' => q({0} миллиметр),
					},
					'millimeter-of-mercury' => {
						'' => q(сымап мамычасынын миллиметри),
						'one' => q({0} сымап мамычасынын миллиметри),
						'other' => q({0} сымап мамычасынын миллиметри),
					},
					'millisecond' => {
						'' => q(миллисекунд),
						'one' => q({0} миллисекунд),
						'other' => q({0} миллисекунд),
					},
					'milliwatt' => {
						'' => q(милливатт),
						'one' => q({0} милливатт),
						'other' => q({0} милливатт),
					},
					'minute' => {
						'' => q(мүнөт),
						'one' => q({0} мүнөт),
						'other' => q({0} мүнөт),
					},
					'month' => {
						'' => q(ай),
						'one' => q({0} ай),
						'other' => q({0} ай),
					},
					'nanometer' => {
						'' => q(нанометр),
						'one' => q({0} нанометр),
						'other' => q({0} нанометр),
					},
					'nanosecond' => {
						'' => q(наносекунд),
						'one' => q({0} наносекунд),
						'other' => q({0} наносекунд),
					},
					'nautical-mile' => {
						'' => q(деңиз мили),
						'one' => q({0} деңиз мили),
						'other' => q({0} деңиз мили),
					},
					'ohm' => {
						'' => q(ом),
						'one' => q({0} ом),
						'other' => q({0} ом),
					},
					'ounce' => {
						'' => q(унция),
						'one' => q({0} унция),
						'other' => q({0} унция),
					},
					'ounce-troy' => {
						'' => q(троя унциясы),
						'one' => q({0} троя унциясы),
						'other' => q({0} троя унциясы),
					},
					'parsec' => {
						'' => q(парсек),
						'one' => q({0} парсек),
						'other' => q({0} парсек),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'' => q(пикометр),
						'one' => q({0} пикометр),
						'other' => q({0} пикометр),
					},
					'pint' => {
						'' => q(пинта),
						'one' => q({0} пинта),
						'other' => q({0} пинта),
					},
					'pound' => {
						'' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
					},
					'pound-per-square-inch' => {
						'' => q(фунт чарчы дюймга),
						'one' => q({0} фунт чарчы дюймга),
						'other' => q({0} фунт чарчы дюймга),
					},
					'quart' => {
						'' => q(кварта),
						'one' => q({0} кварта),
						'other' => q({0} кварта),
					},
					'radian' => {
						'' => q(радиан),
						'one' => q({0} радиан),
						'other' => q({0} радиан),
					},
					'second' => {
						'' => q({0} секундуна),
						'one' => q({0} секунд),
						'other' => q({0} секунд),
					},
					'square-centimeter' => {
						'' => q(чарчы сантиметр),
						'one' => q({0} чарчы сантиметр),
						'other' => q({0} чарчы сантиметр),
					},
					'square-foot' => {
						'' => q(чарчы фут),
						'one' => q({0} чарчы фут),
						'other' => q({0} чарчы фут),
					},
					'square-inch' => {
						'' => q(чарчы дюйм),
						'one' => q({0} чарчы дюйм),
						'other' => q({0} чарчы дюйм),
					},
					'square-kilometer' => {
						'' => q(чарчы километр),
						'one' => q({0} чарчы километр),
						'other' => q({0} чарчы километр),
					},
					'square-meter' => {
						'' => q(чарчы метр),
						'one' => q({0} чарчы метр),
						'other' => q({0} чарчы метр),
					},
					'square-mile' => {
						'' => q(чарчы мил),
						'one' => q({0} чарчы мил),
						'other' => q({0} чарчы мил),
					},
					'square-yard' => {
						'' => q(чарчы ярд),
						'one' => q({0} чарчы ярд),
						'other' => q({0} чарчы ярд),
					},
					'tablespoon' => {
						'' => q(чоң кашык),
						'one' => q({0} чоң кашык),
						'other' => q({0} чоң кашык),
					},
					'teaspoon' => {
						'' => q(чай кашык),
						'one' => q({0} чай кашык),
						'other' => q({0} чай кашык),
					},
					'terabit' => {
						'' => q(терабит),
						'one' => q({0} терабит),
						'other' => q({0} терабит),
					},
					'terabyte' => {
						'' => q(терабайт),
						'one' => q({0} терабайт),
						'other' => q({0} терабайт),
					},
					'ton' => {
						'' => q(тонна),
						'one' => q({0} тонна),
						'other' => q({0} тонна),
					},
					'volt' => {
						'' => q(вольт),
						'one' => q({0} вольт),
						'other' => q({0} вольт),
					},
					'watt' => {
						'' => q(ватт),
						'one' => q({0} ватт),
						'other' => q({0} ватт),
					},
					'week' => {
						'' => q(апта),
						'one' => q({0} апта),
						'other' => q({0} апта),
					},
					'yard' => {
						'' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'' => q(жыл),
						'one' => q({0} жыл),
						'other' => q({0} жыл),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'' => q(°C),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'cubic-kilometer' => {
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-mile' => {
						'one' => q({0} чак³),
						'other' => q({0} чак³),
					},
					'day' => {
						'' => q(күн),
						'one' => q({0} к),
						'other' => q({0} к),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} фут),
						'other' => q({0} фут),
					},
					'g-force' => {
						'one' => q({0} о.к.),
						'other' => q({0} о.к.),
					},
					'gram' => {
						'' => q(грамм),
						'one' => q({0} г),
						'other' => q({0} г),
					},
					'hectare' => {
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectopascal' => {
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'horsepower' => {
						'one' => q({0} ат),
						'other' => q({0} ат),
					},
					'hour' => {
						'' => q(саат),
						'one' => q({0} с),
						'other' => q({0} с),
					},
					'inch' => {
						'one' => q({0} д),
						'other' => q({0} д),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'' => q(килограмм),
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					'kilometer' => {
						'' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'kilometer-per-hour' => {
						'' => q(км/саат),
						'one' => q({0} км/с),
						'other' => q({0} км/с),
					},
					'kilowatt' => {
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					'light-year' => {
						'one' => q({0} жар.ж.),
						'other' => q({0} жар.ж.),
					},
					'liter' => {
						'' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
					},
					'meter' => {
						'' => q(метр),
						'one' => q({0}м),
						'other' => q({0}м),
					},
					'meter-per-second' => {
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'mile' => {
						'one' => q({0} чак),
						'other' => q({0} чак),
					},
					'mile-per-hour' => {
						'one' => q({0} чак/с),
						'other' => q({0} чак/с),
					},
					'millibar' => {
						'one' => q({0} мб),
						'other' => q({0} мб),
					},
					'millimeter' => {
						'' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millisecond' => {
						'' => q(миллисек),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'minute' => {
						'' => q(мүн),
						'one' => q({0} мүн),
						'other' => q({0} мүн),
					},
					'month' => {
						'' => q(ай),
						'one' => q({0} ай),
						'other' => q({0} ай),
					},
					'ounce' => {
						'one' => q({0} унция),
						'other' => q({0} унция),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pound' => {
						'one' => q({0} фунт),
						'other' => q({0} фунт),
					},
					'second' => {
						'' => q(сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'square-foot' => {
						'one' => q({0} фут²),
						'other' => q({0} фут²),
					},
					'square-kilometer' => {
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					'square-mile' => {
						'one' => q({0} чак²),
						'other' => q({0} чак²),
					},
					'watt' => {
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					'week' => {
						'' => q(ап),
						'one' => q({0} ап),
						'other' => q({0} ап),
					},
					'yard' => {
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'' => q(жыл),
						'one' => q({0} ж.),
						'other' => q({0} ж.),
					},
				},
				'short' => {
					'acre' => {
						'' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'acre-foot' => {
						'' => q(акр-фут),
						'one' => q({0} ак. фт.),
						'other' => q({0} ак. фт.),
					},
					'ampere' => {
						'' => q(амп),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'' => q(′),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'' => q(″),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'' => q(а. б.),
						'one' => q({0} а.б.),
						'other' => q({0} а.б.),
					},
					'bit' => {
						'' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					'byte' => {
						'' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					'calorie' => {
						'' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					'carat' => {
						'' => q(карат),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					'celsius' => {
						'' => q(Цельсий град.),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'' => q(сЛ),
						'one' => q({0} сЛ),
						'other' => q({0} сЛ),
					},
					'centimeter' => {
						'' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'cubic-centimeter' => {
						'' => q(см³),
						'one' => q({0} см³),
						'other' => q({0} см³),
					},
					'cubic-foot' => {
						'' => q(фут³),
						'one' => q({0} фут³),
						'other' => q({0} фут³),
					},
					'cubic-inch' => {
						'' => q(дюйм³),
						'one' => q({0} дюйм³),
						'other' => q({0} дюйм³),
					},
					'cubic-kilometer' => {
						'' => q(куб километр),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-meter' => {
						'' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
					},
					'cubic-mile' => {
						'' => q(мил³),
						'one' => q({0} мил³),
						'other' => q({0} мил³),
					},
					'cubic-yard' => {
						'' => q(ярд³),
						'one' => q({0} ярд³),
						'other' => q({0} ярд³),
					},
					'cup' => {
						'' => q(чөйчөк),
						'one' => q({0} чөй.),
						'other' => q({0} чөй.),
					},
					'day' => {
						'' => q(күн),
						'one' => q({0} күн),
						'other' => q({0} күн),
					},
					'deciliter' => {
						'' => q(дал),
						'one' => q({0} дал),
						'other' => q({0} дал),
					},
					'decimeter' => {
						'' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					'degree' => {
						'' => q(градус),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'' => q(Ф. град),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'' => q(с. унц.),
						'one' => q({0} с. унц.),
						'other' => q({0} с. унц.),
					},
					'foodcalorie' => {
						'' => q(Кал),
						'one' => q({0} Кал),
						'other' => q({0} Кал),
					},
					'foot' => {
						'' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
					},
					'g-force' => {
						'' => q(оордук күчүнүн ылдамдануусу),
						'one' => q({0} о.к.),
						'other' => q({0} о.к.),
					},
					'gallon' => {
						'' => q(гал),
						'one' => q({0} гал),
						'other' => q({0} гал),
					},
					'gigabit' => {
						'' => q(Гбит),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					'gigabyte' => {
						'' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					'gigahertz' => {
						'' => q(Ггц),
						'one' => q({0} Ггц),
						'other' => q({0} Ггц),
					},
					'gigawatt' => {
						'' => q(ГВт),
						'one' => q({0} ГВт),
						'other' => q({0} ГВт),
					},
					'gram' => {
						'' => q(грамм),
						'one' => q({0} г),
						'other' => q({0} г),
					},
					'hectare' => {
						'' => q(гектар),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectoliter' => {
						'' => q(гл),
						'one' => q({0} гл),
						'other' => q({0} гл),
					},
					'hectopascal' => {
						'' => q(hPa),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'hertz' => {
						'' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					'horsepower' => {
						'' => q(а.к.),
						'one' => q({0} а.к.),
						'other' => q({0} а.к.),
					},
					'hour' => {
						'' => q({0}/с),
						'one' => q({0} с),
						'other' => q({0} с),
					},
					'inch' => {
						'' => q(дюйм),
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
					},
					'inch-hg' => {
						'' => q(дүйм сымап мамычасы),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'' => q(жоул),
						'one' => q({0} ж),
						'other' => q({0} ж),
					},
					'karat' => {
						'' => q(карат),
						'one' => q({0} кт),
						'other' => q({0} кт),
					},
					'kelvin' => {
						'' => q(К град.),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'' => q(кбит),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					'kilobyte' => {
						'' => q(кБайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					'kilocalorie' => {
						'' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					'kilogram' => {
						'' => q(килограмм),
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					'kilohertz' => {
						'' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					'kilojoule' => {
						'' => q(киложоул),
						'one' => q({0} кж),
						'other' => q({0} кж),
					},
					'kilometer' => {
						'' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'kilometer-per-hour' => {
						'' => q(км/саат),
						'one' => q({0} км/с),
						'other' => q({0} км/с),
					},
					'kilowatt' => {
						'' => q(кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					'kilowatt-hour' => {
						'' => q(кВ-саат),
						'one' => q({0} кВ-саат),
						'other' => q({0} кВ-саат),
					},
					'light-year' => {
						'' => q(жарык жыл),
						'one' => q({0} жар.ж.),
						'other' => q({0} жар.ж.),
					},
					'liter' => {
						'' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
					},
					'liter-per-kilometer' => {
						'' => q(л/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					'lux' => {
						'' => q(люкс),
						'one' => q({0} лк),
						'other' => q({0} лк),
					},
					'megabit' => {
						'' => q(Мбит),
						'one' => q({0} Мб),
						'other' => q({0} Мб),
					},
					'megabyte' => {
						'' => q(МБайт),
						'one' => q({0} МБ),
						'other' => q({0} МБ),
					},
					'megahertz' => {
						'' => q(МГЦ),
						'one' => q({0} МГЦ),
						'other' => q({0} МГЦ),
					},
					'megaliter' => {
						'' => q(Мл),
						'one' => q({0} Мл),
						'other' => q({0} Мл),
					},
					'megawatt' => {
						'' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					'meter' => {
						'' => q(метр),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'meter-per-second' => {
						'' => q(метр/сек.),
						'one' => q({0} м/сек.),
						'other' => q({0} м/сек.),
					},
					'meter-per-second-squared' => {
						'' => q(метр/сек²),
						'one' => q({0} м/сек²),
						'other' => q({0} м/сек²),
					},
					'metric-ton' => {
						'' => q(т),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					'microgram' => {
						'' => q(мкг),
						'one' => q({0} мкг),
						'other' => q({0} мкг),
					},
					'micrometer' => {
						'' => q(µметр),
						'one' => q({0} µм),
						'other' => q({0} µм),
					},
					'microsecond' => {
						'' => q(μсек),
						'one' => q({0}μс),
						'other' => q({0}μс),
					},
					'mile' => {
						'' => q(мил),
						'one' => q({0} мил),
						'other' => q({0} мил),
					},
					'mile-per-gallon' => {
						'' => q(мил/гал),
						'one' => q({0} мил/гал),
						'other' => q({0} мил/гал),
					},
					'mile-per-hour' => {
						'' => q(мил/саат),
						'one' => q({0} мил/с),
						'other' => q({0} мил/с),
					},
					'milliampere' => {
						'' => q(миллиамп),
						'one' => q({0} мА),
						'other' => q({0} мА),
					},
					'millibar' => {
						'' => q(миллибар),
						'one' => q({0} мбар),
						'other' => q({0} мбар),
					},
					'milligram' => {
						'' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					'milliliter' => {
						'' => q(мЛ),
						'one' => q({0} мЛ),
						'other' => q({0} мЛ),
					},
					'millimeter' => {
						'' => q(миллиметр),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millimeter-of-mercury' => {
						'' => q(с. м. мм),
						'one' => q({0} с. м. мм),
						'other' => q({0} с. м. мм),
					},
					'millisecond' => {
						'' => q(миллисекунд),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'milliwatt' => {
						'' => q(мвт),
						'one' => q({0} мвт),
						'other' => q({0} мвт),
					},
					'minute' => {
						'' => q(мүнөт),
						'one' => q({0} мүн),
						'other' => q({0} мүн),
					},
					'month' => {
						'' => q(ай),
						'one' => q({0} ай),
						'other' => q({0} ай),
					},
					'nanometer' => {
						'' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					'nanosecond' => {
						'' => q(наносек),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					'nautical-mile' => {
						'' => q(дең. мил.),
						'one' => q({0} дең. мил.),
						'other' => q({0} дең. мил.),
					},
					'ohm' => {
						'' => q(ом),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'' => q(унц.),
						'one' => q({0} унц.),
						'other' => q({0} унц.),
					},
					'ounce-troy' => {
						'' => q(тр. унц.),
						'one' => q({0} тр. унц.),
						'other' => q({0} тр. унц.),
					},
					'parsec' => {
						'' => q(парсек),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pint' => {
						'' => q(пт),
						'one' => q({0} пт),
						'other' => q({0} пт),
					},
					'pound' => {
						'' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
					},
					'pound-per-square-inch' => {
						'' => q(фчд),
						'one' => q({0} фчд),
						'other' => q({0} фчд),
					},
					'quart' => {
						'' => q(квр),
						'one' => q({0} квр),
						'other' => q({0} квр),
					},
					'radian' => {
						'' => q(рад.),
						'one' => q({0} рад),
						'other' => q({0} рад.),
					},
					'second' => {
						'' => q({0}/сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'square-centimeter' => {
						'' => q(см²),
						'one' => q({0} см²),
						'other' => q({0} см²),
					},
					'square-foot' => {
						'' => q(чарчы фут),
						'one' => q({0} фут²),
						'other' => q({0} фут²),
					},
					'square-inch' => {
						'' => q(дюйм²),
						'one' => q({0} дюйм²),
						'other' => q({0} дюйм²),
					},
					'square-kilometer' => {
						'' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'' => q(метр²),
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					'square-mile' => {
						'' => q(чарчы мил),
						'one' => q({0} мл²),
						'other' => q({0} мл²),
					},
					'square-yard' => {
						'' => q(ярд²),
						'one' => q({0} ярд²),
						'other' => q({0} ярд²),
					},
					'tablespoon' => {
						'' => q(чоң каш.),
						'one' => q({0} чоң каш.),
						'other' => q({0} чоң каш.),
					},
					'teaspoon' => {
						'' => q(чай каш.),
						'one' => q({0} чай каш.),
						'other' => q({0} чай каш.),
					},
					'terabit' => {
						'' => q(Тбит),
						'one' => q({0} Тб),
						'other' => q({0} Тб),
					},
					'terabyte' => {
						'' => q(ТБайт),
						'one' => q({0} ТБ),
						'other' => q({0} ТБ),
					},
					'ton' => {
						'' => q(тонна),
						'one' => q({0} тон.),
						'other' => q({0} тон.),
					},
					'volt' => {
						'' => q(вольт),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					'watt' => {
						'' => q(ватт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					'week' => {
						'' => q(апта),
						'one' => q({0} ап),
						'other' => q({0} ап),
					},
					'yard' => {
						'' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'' => q(жыл),
						'one' => q({0} ж.),
						'other' => q({0} ж.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ооба|о|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:жок|ж|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q( ),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(сан эмес),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'one' => '0 миӊ',
					'other' => '0 миӊ',
				},
				'10000' => {
					'one' => '00 миӊ',
					'other' => '00 миӊ',
				},
				'100000' => {
					'one' => '000 миӊ',
					'other' => '000 миӊ',
				},
				'1000000' => {
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'one' => '0 млд',
					'other' => '0 млд',
				},
				'10000000000' => {
					'one' => '00 млд',
					'other' => '00 млд',
				},
				'100000000000' => {
					'one' => '000 млд',
					'other' => '000 млд',
				},
				'1000000000000' => {
					'one' => '0 трн',
					'other' => '0 трн',
				},
				'10000000000000' => {
					'one' => '00 трн',
					'other' => '00 трн',
				},
				'100000000000000' => {
					'one' => '000 трн',
					'other' => '000 трн',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 миӊ',
					'other' => '0 миӊ',
				},
				'10000' => {
					'one' => '00 миӊ',
					'other' => '00 миӊ',
				},
				'100000' => {
					'one' => '000 миӊ',
					'other' => '000 миӊ',
				},
				'1000000' => {
					'one' => '0 миллион',
					'other' => '0 миллион',
				},
				'10000000' => {
					'one' => '00 миллион',
					'other' => '00 миллион',
				},
				'100000000' => {
					'one' => '000 миллион',
					'other' => '000 миллион',
				},
				'1000000000' => {
					'one' => '0 миллиард',
					'other' => '0 миллиард',
				},
				'10000000000' => {
					'one' => '00 миллиард',
					'other' => '00 миллиард',
				},
				'100000000000' => {
					'one' => '000 миллиард',
					'other' => '000 миллиард',
				},
				'1000000000000' => {
					'one' => '0 триллион',
					'other' => '0 триллион',
				},
				'10000000000000' => {
					'one' => '00 триллион',
					'other' => '00 триллион',
				},
				'100000000000000' => {
					'one' => '000 триллион',
					'other' => '000 триллион',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 миӊ',
					'other' => '0 миӊ',
				},
				'10000' => {
					'one' => '00 миӊ',
					'other' => '00 миӊ',
				},
				'100000' => {
					'one' => '000 миӊ',
					'other' => '000 миӊ',
				},
				'1000000' => {
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'one' => '0 млд',
					'other' => '0 млд',
				},
				'10000000000' => {
					'one' => '00 млд',
					'other' => '00 млд',
				},
				'100000000000' => {
					'one' => '000 млд',
					'other' => '000 млд',
				},
				'1000000000000' => {
					'one' => '0 трн',
					'other' => '0 трн',
				},
				'10000000000000' => {
					'one' => '00 трн',
					'other' => '00 трн',
				},
				'100000000000000' => {
					'one' => '000 трн',
					'other' => '000 трн',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '#,##0.00 ¤',
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'negative' => '#,##0.00 ¤',
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(Бириккен Араб Эмираттары дирхамы),
				'one' => q(БАЭ дирхамы),
				'other' => q(БАЭ дирхамы),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(Афганстан афганиси),
				'one' => q(Афганстан афганиси),
				'other' => q(Афганстан афганиси),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(албан леги),
				'one' => q(албан леги),
				'other' => q(албан леги),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(Армения драмы),
				'one' => q(Армения драмы),
				'other' => q(Армения драмы),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(нидерланд-антил гулдени),
				'one' => q(нидерланд-антил гулдени),
				'other' => q(нидерланд-антил гулдени),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(Ангола кванзасы),
				'one' => q(Ангола кванзасы),
				'other' => q(Ангола кванзасы),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(аргентина песосу),
				'one' => q(аргентина песосу),
				'other' => q(аргентина песосу),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(Австралия доллары),
				'one' => q(Австралия доллары),
				'other' => q(Австралия доллары),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(аруба флорини),
				'one' => q(аруба флорини),
				'other' => q(аруба флорини),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(Азербайжан манаты),
				'one' => q(Азербайжан манаты),
				'other' => q(Азербайжан манаты),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(босния-герцоговина жүгүртөлмөлүү маркасы),
				'one' => q(босния-герцоговина жүгүртөлмөлүү маркасы),
				'other' => q(босния-герцоговина жүгүртөлмөлүү маркасы),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(барбадос доллары),
				'one' => q(барбадос доллары),
				'other' => q(барбадос доллары),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(Бангладеш такасы),
				'one' => q(Бангладеш такасы),
				'other' => q(Бангладеш такасы),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(болгар левиси),
				'one' => q(болгар левиси),
				'other' => q(болгар левиси),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(Бахрейн динары),
				'one' => q(Бахрейн динары),
				'other' => q(Бахрейн динары),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(Бурунди франкы),
				'one' => q(Бурунди франкы),
				'other' => q(Бурунди франкы),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(бермуд доллары),
				'one' => q(бермуд доллары),
				'other' => q(бермуд доллары),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(Бруней доллары),
				'one' => q(Бруней доллары),
				'other' => q(Бруней доллары),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(боливия боливианосу),
				'one' => q(боливия боливианосу),
				'other' => q(боливия боливианосу),
			},
		},
		'BRL' => {
			symbol => 'BRL',
			display_name => {
				'currency' => q(бразилия реалы),
				'one' => q(бразилия реалы),
				'other' => q(бразилия реалы),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(багама доллары),
				'one' => q(багама доллары),
				'other' => q(багама доллары),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(Бутан нгултруму),
				'one' => q(Бутан нгултруму),
				'other' => q(Бутан нгултруму),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(Ботсвана пуласы),
				'one' => q(Ботсвана пуласы),
				'other' => q(Ботсвана пуласы),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(беларусь рублу),
				'one' => q(беларусь рублу),
				'other' => q(беларусь рублу),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(белиз доллары),
				'one' => q(белиз доллары),
				'other' => q(белиз доллары),
			},
		},
		'CAD' => {
			symbol => 'CAD',
			display_name => {
				'currency' => q(канада доллары),
				'one' => q(канада доллары),
				'other' => q(канада долларлары),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(Конго франкы),
				'one' => q(Конго франкы),
				'other' => q(Конго франкы),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(швейцария франкы),
				'one' => q(швейцария франкы),
				'other' => q(швейцария франкы),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(чили песосу),
				'one' => q(чили песосу),
				'other' => q(чили песосу),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(Кытай юаны),
				'one' => q(Кытай юаны),
				'other' => q(Кытай юаны),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(колумбия песосу),
				'one' => q(колумбия песосу),
				'other' => q(колумбия песосу),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(коста-рика колону),
				'one' => q(коста-рика колону),
				'other' => q(коста-рика колону),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(куба жүгүртүлмөлүү песосу),
				'one' => q(куба жүгүртүлмөлүү песосу),
				'other' => q(куба жүгүртүлмөлүү песосу),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(куба песосу),
				'one' => q(куба песосу),
				'other' => q(куба песосу),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(Кабо-Верде эскудосу),
				'one' => q(Кабо-Верде эскудосу),
				'other' => q(Кабо-Верде эскудосу),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(чех кронасы),
				'one' => q(чех кронасы),
				'other' => q(чех кронасы),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(Жибути франкы),
				'one' => q(Жибути франкы),
				'other' => q(Жибути франкы),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(дания крону),
				'one' => q(дания крону),
				'other' => q(дания крону),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(доминикан песосу),
				'one' => q(доминикан песосу),
				'other' => q(доминикан песосу),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(Алжир динары),
				'one' => q(Алжир динары),
				'other' => q(Алжир динары),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(Мисир фунту),
				'one' => q(Мисир фунту),
				'other' => q(Мисир фунту),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(Эритреа накфасы),
				'one' => q(Эритреа накфасы),
				'other' => q(Эритреа накфасы),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(Эфиопия бирри),
				'one' => q(Эфиопия бирри),
				'other' => q(Эфиопия бирри),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(Евро),
				'one' => q(евро),
				'other' => q(евро),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(Фижи доллары),
				'one' => q(Фижи доллары),
				'other' => q(Фижи доллары),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(фолкленд аралдарынын фунту),
				'one' => q(фолкленд аралдарынын фунту),
				'other' => q(фолкленд аралдарынын фунту),
			},
		},
		'GBP' => {
			symbol => 'GBP',
			display_name => {
				'currency' => q(британия фунт стерлинги),
				'one' => q(британия фунт стерлинги),
				'other' => q(британия фунт стерлинги),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(Грузия лариси),
				'one' => q(Грузия лариси),
				'other' => q(Грузия лариси),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(Гана седиси),
				'one' => q(Гана седиси),
				'other' => q(Гана седиси),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(гибралтар фунту),
				'one' => q(гибралтар фунту),
				'other' => q(гибралтар фунту),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(Гамбия даласиси),
				'one' => q(Гамбия даласиси),
				'other' => q(Гамбия даласиси),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(Гине франкы),
				'one' => q(Гине франкы),
				'other' => q(Гине франкы),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(гватемала кетсалы),
				'one' => q(гватемала кетсалы),
				'other' => q(гватемала кетсалы),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(гуйана доллары),
				'one' => q(гуйана доллары),
				'other' => q(гуйана доллары),
			},
		},
		'HKD' => {
			symbol => 'HKD',
			display_name => {
				'currency' => q(Гоӊ Коӊ доллары),
				'one' => q(Гоӊ Коӊ доллары),
				'other' => q(Гоӊ Коӊ доллары),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(гондурас лемпирасы),
				'one' => q(гондурас лемпирасы),
				'other' => q(гондурас лемпирасы),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(хорват кунасы),
				'one' => q(хорват кунасы),
				'other' => q(хорват кунасы),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(гаити гурдусу),
				'one' => q(гаити гурдусу),
				'other' => q(гаити гурдусу),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(венгр форинти),
				'one' => q(венгр форинти),
				'other' => q(венгр форинти),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(Индонезия рупийасы),
				'one' => q(Индонезия рупийасы),
				'other' => q(Индонезия рупийасы),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(Израил жаӊы шегели),
				'one' => q(Израил жаӊы шегели),
				'other' => q(Израил жаӊы шегели),
			},
		},
		'INR' => {
			symbol => 'INR',
			display_name => {
				'currency' => q(Индия руписи),
				'one' => q(Индия руписи),
				'other' => q(Индия руписи),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(Ирак динары),
				'one' => q(Ирак динары),
				'other' => q(Ирак динары),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(Иран риалы),
				'one' => q(Иран риалы),
				'other' => q(Иран риалы),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(исландия крону),
				'one' => q(исландия крону),
				'other' => q(исландия крону),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(ямайка доллары),
				'one' => q(ямайка доллары),
				'other' => q(ямайка доллары),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(Йордания динары),
				'one' => q(Йордания динары),
				'other' => q(Йордания динары),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(Жапан йени),
				'one' => q(Жапан йени),
				'other' => q(Жапан йени),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(Кения шиллинги),
				'one' => q(Кения шиллинги),
				'other' => q(Кения шиллинги),
			},
		},
		'KGS' => {
			symbol => 'сом',
			display_name => {
				'currency' => q(Кыргызстан сому),
				'one' => q(Кыргызстан сому),
				'other' => q(Кыргызстан сому),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(Камбожа риели),
				'one' => q(Камбожа риели),
				'other' => q(Камбожа риели),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(Коморос франкы),
				'one' => q(Коморос франкы),
				'other' => q(Коморос франкы),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(Түндүк Корея уону),
				'one' => q(Түндүк Корея уону),
				'other' => q(Түндүк Корея уону),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(Түштүк Корея уону),
				'one' => q(Түштүк Корея уону),
				'other' => q(Түштүк Корея уону),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(Кувейт динары),
				'one' => q(Кувейт динары),
				'other' => q(Кувейт динары),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(кайман доллары),
				'one' => q(кайман доллары),
				'other' => q(кайман доллары),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(Казакстан теӊгеси),
				'one' => q(Казакстан теӊгеси),
				'other' => q(Казакстан теӊгеси),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(Лаос киби),
				'one' => q(Лаос киби),
				'other' => q(Лаос киби),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(Ливан фунту),
				'one' => q(Ливан фунту),
				'other' => q(Ливан фунту),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(Шри Ланка руписи),
				'one' => q(Шри Ланка руписи),
				'other' => q(Шри Ланка руписи),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(Либерия доллары),
				'one' => q(Либерия доллары),
				'other' => q(Либерия доллары),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(литва литасы),
				'one' => q(литва литасы),
				'other' => q(литва литасы),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(латвия латы),
				'one' => q(латвия латы),
				'other' => q(латвия латы),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(Ливия динары),
				'one' => q(Ливия динары),
				'other' => q(Ливия динары),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(Марокко дирхамы),
				'one' => q(Марокко дирхамы),
				'other' => q(Марокко дирхамы),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(молдован лейи),
				'one' => q(молдован лейи),
				'other' => q(молдован лейи),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(Мадагаскар ариариси),
				'one' => q(Мадагаскар ариариси),
				'other' => q(Мадагаскар ариариси),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(македон денары),
				'one' => q(македон денары),
				'other' => q(македон денары),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(Мйанмар кйаты),
				'one' => q(Мйанмар кйаты),
				'other' => q(Мйанмар кйаты),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(Монгол тугриги),
				'one' => q(Монгол тугриги),
				'other' => q(Монгол тугриги),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(Макау патакасы),
				'one' => q(Макау патакасы),
				'other' => q(Макау патакасы),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(Мавритания угиясы),
				'one' => q(Мавритания угиясы),
				'other' => q(Мавритания угиясы),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(Мавританий руписи),
				'one' => q(Мавританий руписи),
				'other' => q(Мавританий руписи),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(Малдив Руфийасы),
				'one' => q(Малдив Руфийасы),
				'other' => q(Малдив Руфийасы),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(Малави квачасы),
				'one' => q(Малави квачасы),
				'other' => q(Малави квачасы),
			},
		},
		'MXN' => {
			symbol => 'MXN',
			display_name => {
				'currency' => q(мексика песосу),
				'one' => q(мексика песосу),
				'other' => q(мексика песосу),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(Малайзия ринггити),
				'one' => q(Малайзия ринггити),
				'other' => q(Малайзия ринггити),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(Мозамбик метикалы),
				'one' => q(Мозамбик метикалы),
				'other' => q(Мозамбик метикалы),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(Намибия доллары),
				'one' => q(Намибия доллары),
				'other' => q(Намибия доллары),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(Нигерия найрасы),
				'one' => q(Нигерия найрасы),
				'other' => q(Нигерия найрасы),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(никарагуа кордобасы),
				'one' => q(никарагуа кордобасы),
				'other' => q(никарагуа кордобасы),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(норвегия крону),
				'one' => q(норвегия крону),
				'other' => q(норвегия крону),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(Непал руписи),
				'one' => q(Непал руписи),
				'other' => q(Непал руписи),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(Жаӊы Зеландия доллары),
				'one' => q(Жаӊы Зеландия доллары),
				'other' => q(Жаӊы Зеландия доллары),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(Оман риалы),
				'one' => q(Оман риалы),
				'other' => q(Оман риалы),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(панама балбоасы),
				'one' => q(панама балбоасы),
				'other' => q(панама балбоасы),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(перу нуэво солу),
				'one' => q(перу нуэво солу),
				'other' => q(перу нуэво солу),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(Папуа Жаӊы Гине кинасы),
				'one' => q(Папуа Жаӊы Гине кинасы),
				'other' => q(Папуа Жаӊы Гине кинасы),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(Филиппин песосу),
				'one' => q(Филиппин песосу),
				'other' => q(Филиппин песосу),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(Пакистан руписи),
				'one' => q(Пакистан руписи),
				'other' => q(Пакистан руписи),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(польша злотыйы),
				'one' => q(польша злотыйы),
				'other' => q(польша злотыйы),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(парагвай гуараниси),
				'one' => q(парагвай гуараниси),
				'other' => q(парагвай гуараниси),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(Катар риалы),
				'one' => q(Катар риалы),
				'other' => q(Катар риалы),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(румын лейи),
				'one' => q(румын лейи),
				'other' => q(румын лейи),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(серб динары),
				'one' => q(серб динары),
				'other' => q(серб динары),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(орус рублу),
				'one' => q(орус рублу),
				'other' => q(орус рублу),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(Руанда франкы),
				'one' => q(Руанда франкы),
				'other' => q(Руанда франкы),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(Сауд риалы),
				'one' => q(Сауд риалы),
				'other' => q(Сауд риалы),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(Соломон доллары),
				'one' => q(Соломон доллары),
				'other' => q(Соломон доллары),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(Сейшел руписи),
				'one' => q(Сейшел руписи),
				'other' => q(Сейшел руписи),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(Судан фунту),
				'one' => q(Судан фунту),
				'other' => q(Судан фунту),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(швеция крону),
				'one' => q(швеция крону),
				'other' => q(швеция крону),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(Сингапур доллары),
				'one' => q(Сингапур доллары),
				'other' => q(Сингапур доллары),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(Ыйык Елена фунту),
				'one' => q(Ыйык Елена фунту),
				'other' => q(Ыйык Елена фунту),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(Сиерра-Леоне леонеси),
				'one' => q(Сиерра-Леоне леонеси),
				'other' => q(Сиерра-Леоне леонеси),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(Сомали шиллинги),
				'one' => q(Сомали шиллинги),
				'other' => q(Сомали шиллинги),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(суринам доллары),
				'one' => q(суринам доллары),
				'other' => q(суринам доллары),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(Түштүк Судан фунту),
				'one' => q(Түштүк Судан фунту),
				'other' => q(Түштүк Судан фунту),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(Сао Томе жана Принсипе добрасы),
				'one' => q(Сао Томе жана Принсипе добрасы),
				'other' => q(Сао Томе жана Принсипе добрасы),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(Сирия фунту),
				'one' => q(Сирия фунту),
				'other' => q(Сирия фунту),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(Свази лилангени),
				'one' => q(Свази лилангени),
				'other' => q(Свази эмалангени),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(Тай баты),
				'one' => q(Тай баты),
				'other' => q(Тай баты),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(Тажикстан сомониси),
				'one' => q(Тажикстан сомониси),
				'other' => q(Тажикстан сомониси),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(Түркмөнстан манаты),
				'one' => q(Түркмөнстан манаты),
				'other' => q(Түркмөнстан манаты),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(Тунис динары),
				'one' => q(Тунис динары),
				'other' => q(Тунис динары),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(Тонга паангасы),
				'one' => q(Тонга паангасы),
				'other' => q(Тонга паангасы),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(Түркия лирасы),
				'one' => q(Түркия лирасы),
				'other' => q(Түркия лирасы),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(тринидад жана тобаго доллары),
				'one' => q(тринидад жана тобаго доллары),
				'other' => q(тринидад жана тобаго доллары),
			},
		},
		'TWD' => {
			symbol => 'TWD',
			display_name => {
				'currency' => q(Тайвань жаӊы доллары),
				'one' => q(Тайвань жаӊы доллары),
				'other' => q(Тайвань жаӊы доллары),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(Танзания шиллинги),
				'one' => q(Танзания шиллинги),
				'other' => q(Танзания шиллинги),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(украин гривени),
				'one' => q(украин гривени),
				'other' => q(украин гривени),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(Уганда шиллинги),
				'one' => q(Уганда шиллинги),
				'other' => q(Уганда шиллинги),
			},
		},
		'USD' => {
			symbol => 'USD',
			display_name => {
				'currency' => q(АКШ доллары),
				'one' => q(АКШ доллары),
				'other' => q(АКШ доллары),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(уругвай песосу),
				'one' => q(уругвай песосу),
				'other' => q(уругвай песосу),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(Өзбекстан сому),
				'one' => q(Өзбекстан сому),
				'other' => q(Өзбекстан сому),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(венесуэла боливары),
				'one' => q(венесуэла боливары),
				'other' => q(венесуэла боливары),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(Вьетнам доӊу),
				'one' => q(Вьетнам доӊу),
				'other' => q(Вьетнам доӊу),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(Вануату ватусу),
				'one' => q(Вануату ватусу),
				'other' => q(Вануату ватусу),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(Самоа таласы),
				'one' => q(Самоа таласы),
				'other' => q(Самоа таласы),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(КФА ВЕАС франкы),
				'one' => q(КФА ВЕАС франкы),
				'other' => q(КФА ВЕАС франкы),
			},
		},
		'XCD' => {
			symbol => 'XCD',
			display_name => {
				'currency' => q(чыгыш кариб доллары),
				'one' => q(чыгыш кариб доллары),
				'other' => q(чыгыш кариб доллары),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(КФА ВСЕАО франкы),
				'one' => q(КФА ВСЕАО франкы),
				'other' => q(КФА ВСЕАО франкы),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(КФП франкы),
				'one' => q(КФП франкы),
				'other' => q(КФП франкы),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Белгисиз акча),
				'one' => q(Белгисиз акча),
				'other' => q(Белгисиз акча),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(Йемен риалы),
				'one' => q(Йемен риалы),
				'other' => q(Йемен риалы),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(Түштүк Африка ранды),
				'one' => q(Түштүк Африка ранды),
				'other' => q(Түштүк Африка ранды),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(Замбия квачасы),
				'one' => q(Замбия квачасы),
				'other' => q(Замбия квачасы),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'янв.',
							'фев.',
							'мар.',
							'апр.',
							'май',
							'июн.',
							'июл.',
							'авг.',
							'сен.',
							'окт.',
							'ноя.',
							'дек.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Я',
							'Ф',
							'М',
							'А',
							'М',
							'И',
							'И',
							'А',
							'С',
							'О',
							'Н',
							'Д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'январь',
							'февраль',
							'март',
							'апрель',
							'май',
							'июнь',
							'июль',
							'август',
							'сентябрь',
							'октябрь',
							'ноябрь',
							'декабрь'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'Янв',
							'Фев',
							'Мар',
							'Апр',
							'Май',
							'Июн',
							'Июл',
							'Авг',
							'Сен',
							'Окт',
							'Ноя',
							'Дек'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Я',
							'Ф',
							'М',
							'А',
							'М',
							'И',
							'И',
							'А',
							'С',
							'О',
							'Н',
							'Д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Январь',
							'Февраль',
							'Март',
							'Апрель',
							'Май',
							'Июнь',
							'Июль',
							'Август',
							'Сентябрь',
							'Октябрь',
							'Ноябрь',
							'Декабрь'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'дүй.',
						tue => 'шейш.',
						wed => 'шарш.',
						thu => 'бейш.',
						fri => 'жума',
						sat => 'ишм.',
						sun => 'жек.'
					},
					narrow => {
						mon => 'Д',
						tue => 'Ш',
						wed => 'Ш',
						thu => 'Б',
						fri => 'Ж',
						sat => 'И',
						sun => 'Ж'
					},
					short => {
						mon => 'дүй.',
						tue => 'шейш.',
						wed => 'шарш.',
						thu => 'бейш.',
						fri => 'жума',
						sat => 'ишм.',
						sun => 'жек.'
					},
					wide => {
						mon => 'дүйшөмбү',
						tue => 'шейшемби',
						wed => 'шаршемби',
						thu => 'бейшемби',
						fri => 'жума',
						sat => 'ишемби',
						sun => 'жекшемби'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'дүй.',
						tue => 'шейш.',
						wed => 'шарш.',
						thu => 'бейш.',
						fri => 'жума',
						sat => 'ишм.',
						sun => 'жек.'
					},
					narrow => {
						mon => 'Д',
						tue => 'Ш',
						wed => 'Ш',
						thu => 'Б',
						fri => 'Ж',
						sat => 'И',
						sun => 'Ж'
					},
					short => {
						mon => 'дш.',
						tue => 'шш.',
						wed => 'шр.',
						thu => 'бш.',
						fri => 'жм.',
						sat => 'иш.',
						sun => 'жк'
					},
					wide => {
						mon => 'дүйшөмбү',
						tue => 'шейшемби',
						wed => 'шаршемби',
						thu => 'бейшемби',
						fri => 'жума',
						sat => 'ишемби',
						sun => 'жекшемби'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-чей.',
						1 => '2-чей.',
						2 => '3-чей.',
						3 => '4-чей.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-чейрек',
						1 => '2-чейрек',
						2 => '3-чейрек',
						3 => '4-чейрек'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => '1-ч.',
						1 => '2-ч.',
						2 => '3-ч.',
						3 => '4-ч.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-чейрек',
						1 => '2-чейрек',
						2 => '3-чейрек',
						3 => '4-чейрек'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'pm' => q{тк},
					'am' => q{тң},
					'noon' => q{чт},
				},
				'wide' => {
					'pm' => q{түштөн кийин},
					'noon' => q{чак түш},
					'am' => q{таңкы},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'б.з.ч.',
				'1' => 'б.з.'
			},
			narrow => {
				'0' => 'б.з. ч.',
				'1' => 'б.з.'
			},
			wide => {
				'0' => 'биздин заманга чейин',
				'1' => 'биздин заман'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, G d-MMMM y-'ж'.},
			'long' => q{d-MMMM G y-'ж'.},
			'medium' => q{dd.MM.y G},
			'short' => q{dd.MM.y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d-MMMM, y-'ж'.},
			'long' => q{y MMMM d},
			'medium' => q{y MMM d},
			'short' => q{dd.MM.yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			E => q{ccc},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y-'ж'.},
			GyMMM => q{G y-'ж'. MMM},
			GyMMMEd => q{G y-'ж'. d-MMM, E},
			GyMMMd => q{G y-'ж'. d-MMM},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{dd-MM, E},
			MMM => q{LLL},
			MMMEd => q{d-MMM, E},
			MMMd => q{d-MMM},
			Md => q{dd-MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y-MM},
			yMEd => q{y-MM-dd, E},
			yMMM => q{y-'ж'. MMM},
			yMMMEd => q{y-'ж'. d-MMM, E},
			yMMMd => q{y-'ж'. d-MMM},
			yMd => q{y-MM-dd},
			yQQQ => q{y-'ж'., QQQ},
			yQQQQ => q{y-'ж'., QQQQ},
		},
		'generic' => {
			Ed => q{d, E},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y-'ж'. d-MMM, E},
			GyMMMd => q{G y-'ж'. d-MMM},
			M => q{L},
			MEd => q{MM-dd, E},
			MMM => q{LLL},
			MMMEd => q{d-MMM, E},
			MMMd => q{d-MMM},
			Md => q{MM-dd},
			d => q{d},
			y => q{y-G},
			yyyy => q{y-G},
			yyyyM => q{GGGGG y-MM},
			yyyyMEd => q{GGGGG y-MM-dd, E},
			yyyyMMM => q{G y-'ж'. MMM},
			yyyyMMMEd => q{G y-'ж'. d-MMM, E},
			yyyyMMMd => q{G y-'ж'. d-MMM},
			yyyyMd => q{GGGGG y-MM-dd},
			yyyyQQQ => q{G y-'ж'. QQQ},
			yyyyQQQQ => q{G y-'ж'. QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH-HH},
			},
			Hm => {
				H => q{HH:mm-HH:mm},
				m => q{HH:mm-HH:mm},
			},
			Hmv => {
				H => q{HH:mm-HH:mm v},
				m => q{HH:mm-HH:mm v},
			},
			Hv => {
				H => q{HH-HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM-dd, E – MM-dd, E},
				d => q{MM-dd, E – MM-dd, E},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{d-MMM - d-MMM},
				d => q{d-d-MMM},
			},
			Md => {
				M => q{dd.MM - dd.MM},
				d => q{dd.MM - dd.MM},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{a h – a h},
				h => q{a h-h},
			},
			hm => {
				a => q{a h:mm – a h:mm},
				h => q{a h:mm-h:mm},
				m => q{a h:mm-h:mm},
			},
			hmv => {
				a => q{a h:mm – a h:mm v},
				h => q{a h:mm-h:mm v},
				m => q{a h:mm-h:mm v},
			},
			hv => {
				a => q{a h – a h v},
				h => q{a h-h v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{y-MM – y-MM},
				y => q{MM.y - MM.y},
			},
			yMEd => {
				M => q{y-MM-dd, E – y-MM-dd, E},
				d => q{E, dd.MM.y - E, dd.MM.y},
				y => q{y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{MMM-MMM y-'ж'.},
				y => q{MMM y-'ж'. - MMM y-'ж'.},
			},
			yMMMEd => {
				M => q{y MMM d, E – MMM d, E},
				d => q{y MMM d, E – MMM d, E},
				y => q{y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{MMMM - MMMM y},
				y => q{MMMM y - MMMM y},
			},
			yMMMd => {
				M => q{d-MMM - d-MMM y-'ж'.},
				d => q{d-d-MMM y-'ж'.},
				y => q{d-MMM y-'ж'. - d-MMM y-'ж'.},
			},
			yMd => {
				M => q{dd.MM.y - dd.MM.y},
				d => q{dd.MM.y - dd.MM.y},
				y => q{dd.MM.y - dd.MM.y},
			},
		},
		'generic' => {
			H => {
				H => q{HH-HH},
			},
			Hm => {
				H => q{HH:mm-HH:mm},
				m => q{HH:mm-HH:mm},
			},
			Hmv => {
				H => q{HH:mm-HH:mm v},
				m => q{HH:mm-HH:mm v},
			},
			Hv => {
				H => q{HH-HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, dd.MM - E, dd.MM},
				d => q{E, dd.MM - E, dd.MM},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, d MMM - E, d MMM},
				d => q{E, d - E, d MMM},
			},
			MMMd => {
				M => q{d MMM - d MMM},
				d => q{d-d MMM},
			},
			Md => {
				M => q{dd.MM - dd.MM},
				d => q{dd.MM - dd.MM},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				h => q{h-h a},
			},
			hm => {
				h => q{h:mm-h:mm a},
				m => q{h:mm-h:mm a},
			},
			hmv => {
				h => q{h:mm-h:mm a v},
				m => q{h:mm-h:mm a v},
			},
			hv => {
				h => q{h-h a v},
			},
			y => {
				y => q{y-y G},
			},
			yM => {
				M => q{MM.y - MM.y G},
				y => q{MM.y - MM.y G},
			},
			yMEd => {
				M => q{E, dd.MM.y - E, dd.MM.y G},
				d => q{E, dd.MM.y - E, dd.MM.y G},
				y => q{E, dd.MM.y - E, dd.MM.y G},
			},
			yMMM => {
				M => q{MMM-MMM y-'ж'. G},
				y => q{MMM y-'ж'. - MMM y-'ж'. G},
			},
			yMMMEd => {
				M => q{E, d-MMM - E, d-MMM y-'ж'. G},
				d => q{E, d - E, d-MMM y-'ж'. G},
				y => q{E, d-MMM y-'ж'. - E, d-MMM y-'ж'. G},
			},
			yMMMM => {
				M => q{G y-'ж'. MMMM - MMMM},
				y => q{G y-'ж'. MMMM - y-'ж'. MMMM},
			},
			yMMMd => {
				M => q{d-MMM - d-MMM y-'ж'. G},
				d => q{d-d-MMM y-'ж'. G},
				y => q{d-MMM y-'ж'. - d-MMM y-'ж'. G},
			},
			yMd => {
				M => q{dd.MM.y - dd.MM.y G},
				d => q{dd.MM.y - dd.MM.y G},
				y => q{dd.MM.y - dd.MM.y G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} убактысы),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (+0)),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(Афганистан убактысы),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиджан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Баги#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавилл#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каир#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар эс Салаам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Жибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Эл Айун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоханнесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Жуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Картум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревилл#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишу#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровиа#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нжамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Нйаме#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сао Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Уиндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(Борбордук Африка убактысы),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(Чыгыш Африка убактысы),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(Түштүк Африка убактысы),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(Батыш Африка жайкы убактысы),
				'generic' => q(Батыш Африка убактысы),
				'standard' => q(Батыш Африка стандарт убактысы),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(Аляска жайкы убактысы),
				'generic' => q(Аляска убактысы),
				'standard' => q(Аляска стандарт убактысы),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(Амазон жайкы убактысы),
				'generic' => q(Амазон убактысы),
				'standard' => q(Амазон стандарт убактысы),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкориж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангуила#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуаина#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Галлегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луи#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуайа#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Байиа#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баийа Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белиз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бойсе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буэнос-Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кэмбриж Бей#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кайен#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайман#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чихуахуа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Атикокан#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордова#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста-Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куйаба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмарксхавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусон Грек#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Эдмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Эйрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Эл Салвадор#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глейс Бей#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нуук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Бей#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Түрк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделупе#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуайакил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гуйана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Галифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Гавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Эрмосилло#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индиана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индиана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсбург, Индиана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Телл Сити, Индиана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вивей, Индиана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсен, Индиана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Уинамак, Индиана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Жуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичелло, Кентукки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендейк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Пас#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анжелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луизвилл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуэр Принсес Куате#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоза#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехико шаары#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтерей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монсерат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Нассау#,
		},
		'America/New_York' => {
			exemplarCity => q#Нью-Йорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норониа#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Беула, Түндүк Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Сентер, Түндүк Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нью-Салем, Түндүк Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангиртуӊ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Феникс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт оф Спейн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто Велио#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуэрто-Рико#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рейни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Рэнкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолут#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта Изабел#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантиаго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сао Пауло#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Иттоккортоормиит#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сент-Бартелеми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент Жонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Санта Лючия#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент-Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент-Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Каррент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигальпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Сандер Бей#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уайтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Уиннипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Йеллоунайф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(Түндүк Америка, борбордук жайкы убактысы),
				'generic' => q(Түндүк Америка, борбордук убактысы),
				'standard' => q(Түндүк Америка, борбордук стандарт убактысы),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(Түндүк Америка, чыгыш жайкы убактысы),
				'generic' => q(Түндүк Америка, чыгыш убактысы),
				'standard' => q(Түндүк Америка, чыгыш стандарт убактысы),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(Түндүк Америка, тоо жайкы убактысы),
				'generic' => q(Түндүк Америка, тоо убактысы),
				'standard' => q(Түндүк Америка, тоо стандарт убактысы),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(Түндүк Америка, Тынч океан жайкы убактысы),
				'generic' => q(Түндүк Америка, Тынч океан убактысы),
				'standard' => q(Түндүк Америка, Тынч океан стандарт убактысы),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кейси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дэвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дүмон д-Өрвил#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моосон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#МакМөрдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Саоа#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролл#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q(Апиа күндүзгү убактысы),
				'generic' => q(Апиа убактысы),
				'standard' => q(Апиа стандарт убактысы),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(Арабия үнөмдөө убактысы),
				'generic' => q(Арабия убактысы),
				'standard' => q(Арабия стандарт убактысы),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгйербиен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(Аргентина жайкы убактысы),
				'generic' => q(Аргентина убактысы),
				'standard' => q(Аргентина стандарт убактысы),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(Батыш Аргентина жайкы убактысы),
				'generic' => q(Батыш Аргентина убактысы),
				'standard' => q(Батыш Аргентина стандарт убактысы),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(Армения жайкы убактысы),
				'generic' => q(Армения убактысы),
				'standard' => q(Армения стандарт убактысы),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алматы#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Амман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадыр#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калькутта#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чойбалсан#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#Чунцин#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дакка#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Дүйшөмбү#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#Харбин#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Гонконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Жакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Жайапура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Иерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#Кашкар#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Кандыга#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучиӊ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макау#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макассар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никосия#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпень#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхенйан#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кызылорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Рийад#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайпей#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Тегеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимпу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан-Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Үрүмчү#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Усть-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Виентиан#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(Атлантика жайкы убактысы),
				'generic' => q(Атлантика убактысы),
				'standard' => q(Атлантика стандарт убактысы),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азорс#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуда#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канари#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Капе Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарер#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкьявик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Түштүк Жоржия#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Сент Елена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стэнли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брисбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Броукен Хил#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Керри#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Юкла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мельбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сидней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(Австралия борбордук үнөмдөө убактысы),
				'generic' => q(Австралия борбордук убактысы),
				'standard' => q(Австралия борбордук стандарт убактысы),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(Австралия борбордук батыш үнөмдөө убактысы),
				'generic' => q(Австралия борбордук батыш убактысы),
				'standard' => q(Австралия борбордук батыш стандарт убактысы),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(Австралия чыгыш үнөмдөө убактысы),
				'generic' => q(Австралия чыгыш убактысы),
				'standard' => q(Австралия чыгыш стандарт убактысы),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(Австралия батыш үнөмдөө убактысы),
				'generic' => q(Австралия батыш убактысы),
				'standard' => q(Австралия батыш стандарт убактысы),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(Азербайжан жайкы убактысы),
				'generic' => q(Азербайжан убактысы),
				'standard' => q(Азербайжан стандарт убактысы),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(Азорс жайкы убактысы),
				'generic' => q(Азорс убактысы),
				'standard' => q(Азорс стандарт убактысы),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(Бангладеш жайкы убактысы),
				'generic' => q(Бангладеш убактысы),
				'standard' => q(Бангладеш стандарт убактысы),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(Бутан убактысы),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(Боливия убактысы),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(Бразилия жайкы убактысы),
				'generic' => q(Бразилия убактысы),
				'standard' => q(Бразилия стандарт убактысы),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(Бруней Даруссалам убактысы),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(Капе Верде жайкы убактысы),
				'generic' => q(Капе Верде убактысы),
				'standard' => q(Капе Верде стандарт убактысы),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(Чаморро убактысы),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(Чатам үнөмдөө убактысы),
				'generic' => q(Чатам убактысы),
				'standard' => q(Чатам стандарт убактысы),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(Чили жайкы убактысы),
				'generic' => q(Чили убактысы),
				'standard' => q(Чили стандарт убактысы),
			},
		},
		'China' => {
			long => {
				'daylight' => q(Кытай үнөмдөө убактысы),
				'generic' => q(Кытай убактысы),
				'standard' => q(Кытай стандарт убактысы),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(Чойбалсан жайкы убактысы),
				'generic' => q(Чойбалсан убактысы),
				'standard' => q(Чойбалсан стандарт убактысы),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(Крисмас убактысы),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(Кокос убактысы),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(Колумбия жайкы убактысы),
				'generic' => q(Колумбия убактысы),
				'standard' => q(Колумбия стандарт убактысы),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(Кук аралдарынын жарым жай убактысы),
				'generic' => q(Кук аралдарынын убактысы),
				'standard' => q(Кук аралдарынын стандарт убактысы),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(Куба үнөмдөө убактысы),
				'generic' => q(Куба убактысы),
				'standard' => q(Куба стандарт убактысы),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(Дэвис убактысы),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(Дүмон-д-Өрвил убактысы),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(Чыгыш Тимор убактысы),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(Истер жайкы убактысы),
				'generic' => q(Истер убактысы),
				'standard' => q(Истер стандарт убактысы),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(Экуадор убактысы),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#белгисиз шаар#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афины#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюсель#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бузинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублин#,
			long => {
				'daylight' => q(Ирландия жайкы убактысы),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хельсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Мэн аралы#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Стамбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Жерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лиссабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q(Британия жайкы убактысы),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Мальта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Мариехамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париж#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферополь#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопйе#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#София#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокгольм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Фадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Вена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вильнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожье#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(Борбордук Европа жайкы убактысы),
				'generic' => q(Борбордук Европа убактысы),
				'standard' => q(Борбордук Европа стандарт убактысы),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(Чыгыш Европа жайкы убактысы),
				'generic' => q(Чыгыш Европа убактысы),
				'standard' => q(Чыгыш Европа стандарт убактысы),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(Калининград жана Минск убактысы),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(Батыш Европа жайкы убактысы),
				'generic' => q(Батыш Европа убактысы),
				'standard' => q(Батыш Европа стандарт убактысы),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(Фолкленд жайкы убактысы),
				'generic' => q(Фолкленд убактысы),
				'standard' => q(Фолкленд стандарт убактысы),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(Фижи жайкы убактысы),
				'generic' => q(Фижи убактысы),
				'standard' => q(Фижи стандарт убактысы),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(Френч Гуйана убактысы),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(Француз Түштүгү жана Антарктика убактысы),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Гринвич универсалдуу убактысы),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(Галапагос убактысы),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(Гамбие убактысы),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(Грузия жайкы убактысы),
				'generic' => q(Грузия убактысы),
				'standard' => q(Грузия стандарт убактысы),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(Гилберт убактысы),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(Чыгыш Гренландия жайкы убактысы),
				'generic' => q(Чыгыш Гренландия убактысы),
				'standard' => q(Чыгыш Гренландия стандарт убактысы),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(Батыш Гренландия жайкы убактысы),
				'generic' => q(Батыш Гренландия убактысы),
				'standard' => q(Батыш Гренландия стандарт убактысы),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(Булуӊ убактысы),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(Гуйана убактысы),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(Гавайи-Алеут жайкы убактысы),
				'generic' => q(Гавайи-Алеут убактысы),
				'standard' => q(Гавайи-Алеут стандарт убактысы),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(Гоӊ Коӊ жайкы убактысы),
				'generic' => q(Гоӊ Коӊ убактысы),
				'standard' => q(Гоӊ Коӊ стандарт убактысы),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(Ховд жайкы убактысы),
				'generic' => q(Ховд убактысы),
				'standard' => q(Ховд стандарт убактысы),
			},
		},
		'India' => {
			long => {
				'standard' => q(Индия убактысы),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Крисмас#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Маэ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдивз#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврикий#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майотт#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюнион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(Инди океан убактысы),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(Индокытай убактысы),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(Борбордук Индонезия убактысы),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(Чыгыш Индонезия убактысы),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(Батыш Индонезия убактысы),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(Иран үнөмдөө убактысы),
				'generic' => q(Иран убактысы),
				'standard' => q(Иран стандарт убактысы),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(Иркутск жайкы убактысы),
				'generic' => q(Иркутск убактысы),
				'standard' => q(Иркутск стандарт убактысы),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(Израил үнөмдөө убактысы),
				'generic' => q(Израил убактысы),
				'standard' => q(Израил стандарт убактысы),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(Жапан үнөмдөө убактысы),
				'generic' => q(Жапан убактысы),
				'standard' => q(Жапан стандарт убактысы),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(Чыгыш Казакстан убактысы),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(Батыш Казакстан убактысы),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(Корея үнөмдөө убактысы),
				'generic' => q(Корея убактысы),
				'standard' => q(Корея стандарт убактысы),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(Косрае убактысы),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(Красноярск жайкы убактысы),
				'generic' => q(Красноярск убактысы),
				'standard' => q(Красноярск стандарт убактысы),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(Кыргызстан убактысы),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(Лайн убактысы),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(Лорд Хау үнөмдөө убактысы),
				'generic' => q(Лорд Хау убактысы),
				'standard' => q(Лорд Хау стандарт убактысы),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(Макуари убактысы),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(Магадан жайкы убактысы),
				'generic' => q(Магадан убактысы),
				'standard' => q(Магадан стандарт убактысы),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(Малайзия убактысы),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(Малдив убактысы),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(Маркезас убактысы),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(Маршалл убактысы),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(Маврикий жайкы убактысы),
				'generic' => q(Маврикий убактысы),
				'standard' => q(Маврикий стандарт убактысы),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(Мосон убактысы),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(Түндүк-чыгыш Мексика жайкы убактысы),
				'generic' => q(Түндүк-чыгыш Мексика убактысы),
				'standard' => q(Түндүк-чыгыш Мексика стандарт убактысы),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(Мексика, тынч океан жайкы убактысы),
				'generic' => q(Мексика, тынч океан убактысы),
				'standard' => q(Мексика, тынч океан стандарт убактысы),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(Улан Батор жайкы убактысы),
				'generic' => q(Улан Батор убактысы),
				'standard' => q(Улан Батор стандарт убактысы),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(Москва жайкы убактысы),
				'generic' => q(Москва убактысы),
				'standard' => q(Москва стандарт убактысы),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(Мйанмар убактысы),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(Науру убактысы),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(Непал убактысы),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(Жаӊы Каледония жайкы убактысы),
				'generic' => q(Жаӊы Каледония убактысы),
				'standard' => q(Жаӊы Каледония стандарт убактысы),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(Жаӊы Зеландия үнөмдөө убактысы),
				'generic' => q(Жаӊы Зеландия убактысы),
				'standard' => q(Жаӊы Зеландия стандарт убактысы),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(Нюфаундлэнд жайкы убактысы),
				'generic' => q(Нюфаундлэнд убактысы),
				'standard' => q(Нюфаундлэнд стандарт убактысы),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(Ниуэ убактысы),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(Норфолк убактысы),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(Фернандо де Норонья жайкы убактысы),
				'generic' => q(Фернандо де Норонья убактысы),
				'standard' => q(Фернандо де Норонья стандарт убактысы),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(Новосибирск жайкы убактысы),
				'generic' => q(Новосибирск убактысы),
				'standard' => q(Новосибирск стандарт убактысы),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(Омск жайкы убактысы),
				'generic' => q(Омск убактысы),
				'standard' => q(Омск стандарт убактысы),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апиа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Оклэнд#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Истер#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Эфат#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Эндербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фижи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбие#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гуадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Гонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Жонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Козрае#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Куажалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Мажуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркезас#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидуэй#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуэ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкэрн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпей#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Моэрсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раготонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чуук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Уейк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уолис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(Пакистан жайкы убактысы),
				'generic' => q(Пакистан убактысы),
				'standard' => q(Пакистан стандарт убактысы),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(Палау убактысы),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(Папуа-Жаңы Гвинея убактысы),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(Парагвай жайкы убактысы),
				'generic' => q(Парагвай убактысы),
				'standard' => q(Парагвай стандарт убактысы),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(Перу жайкы убактысы),
				'generic' => q(Перу убактысы),
				'standard' => q(Перу стандарт убактысы),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(Филиппинз жайкы убактысы),
				'generic' => q(Филиппинз убактысы),
				'standard' => q(Филиппинз стандарт убактысы),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(Феникс аралдарынын убактысы),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(Сен Пьер жана Микелон жайкы убактысы),
				'generic' => q(Сен Пьер жана Микелон убактысы),
				'standard' => q(Сен Пьер жана Микелон стандарт убактысы),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(Питкэрнг убактысы),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(Понапе убактысы),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(Реюнион убактысы),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(Ротера убактысы),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(Сахалин жайкы убактысы),
				'generic' => q(Сахалин убактысы),
				'standard' => q(Сахалин стандарт убактысы),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(Самоа күндүзгү убактысы),
				'generic' => q(Самоа убактысы),
				'standard' => q(Самоа стандарт убактысы),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(Сейшел убактысы),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(Сингапур убактысы),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(Соломон аралдарынын убактысы),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(Түштүк Жоржия убактысы),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(Суринаме убактысы),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(Саоа убактысы),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(Таити убактысы),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(Тайпей үнөмдөө убактысы),
				'generic' => q(Тайпей убактысы),
				'standard' => q(Тайпей стандарт убактысы),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(Тажикстан убактысы),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(Токелау убактысы),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(Тонга жайкы убактысы),
				'generic' => q(Тонга убактысы),
				'standard' => q(Тонга стандарт убактысы),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(Чуук убактысы),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(Түркмөнстан жайкы убактысы),
				'generic' => q(Түркмөнстан убактысы),
				'standard' => q(Түркмөнстан стандарт убактысы),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(Тувалу убактысы),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(Уругвай жайкы убактысы),
				'generic' => q(Уругвай убактысы),
				'standard' => q(Уругвай стандарт убактысы),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(Өзбекстан жайкы убактысы),
				'generic' => q(Өзбекстан убактысы),
				'standard' => q(Өзбекстан стандарт убактысы),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(Вануату жайкы убактысы),
				'generic' => q(Вануату убактысы),
				'standard' => q(Вануату стандарт убактысы),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(Венесуэла убактысы),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(Владивосток жайкы убактысы),
				'generic' => q(Владивосток убактысы),
				'standard' => q(Владивосток стандарт убактысы),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(Волгоград жайкы убактысы),
				'generic' => q(Волгоград убактысы),
				'standard' => q(Волгоград стандарт убактысы),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(Восток убактысы),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(Уейк убактысы),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(Уолис жана Футуна убактысы),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(Якутск жайкы убактысы),
				'generic' => q(Якутск убактысы),
				'standard' => q(Якутск стандарт убактысы),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(Екатеринбург жайкы убактысы),
				'generic' => q(Екатеринбург убактысы),
				'standard' => q(Екатеринбург стандарт убактысы),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
