package Locale::CLDR::Transformations::Any::Han::Latin;
# This file auto generated from Data\common\transforms\Han-Latin.xml
#	on Fri 20 Jun 10:43:28 pm GMT
# XML file generated 2014-03-05 23:14:25 -0600 (Wed, 05 Mar 2014)

use version;

our $VERSION = version->declare('v0.25.4');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => 'ArrayRef',
	init_arg => undef,
	default => sub { [
		qr/(?^um:\G.)/,
		{
			type => 'transform',
			data => [
				{
					from => q(Han),
					to => q(Spacedhan),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q((?^u:\u0020?文)),
					replace => q((?^u:藏)),
					result  => q(zàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:\u0020?庆)),
					replace => q((?^u:重)),
					result  => q(chóng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:\u0020?阳)),
					replace => q((?^u:沈)),
					result  => q(shěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[呵锕阿𠼞𥥩𨉚])),
					result  => q(ā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嗄])),
					result  => q(á),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[啊])),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㶼哀哎唉嗳噯埃娭挨欸溾銰鎄锿𠳳𡉓𡟓𢰇𤸖])),
					result  => q(āi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱯䠹䶣啀嘊捱敱敳溰癌皑皚騃𠊎𤸳𦩴𧪚𩪂𩮖𫘤])),
					result  => q(ái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢊䑂䨠娾昹毐濭矮蔼藹躷霭靄𣤃𦥂𦥈𧡋𩫇])),
					result  => q(ǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕌㗒㘷㝶㤅㾢㿄䀳䅬䔽䝽伌僾叆嗌塧壒嫒嬡愛懓懝暧曖爱瑷璦皧瞹砹硋碍礙艾薆譪譺鑀閡隘靉餲馤鴱𡁍𡰽𡶃𢟪𢟰𢣏𢣕𣋞𣜬𣝅𣩱𤢵𤻢𥡽𥤦𥴨𦗍𦗐𧏹𧓁𧰿𧵨𨶂𩈋𪇈𪕭])),
					result  => q(ài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鱫])),
					result  => q(ai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛺㞄㫨㸩䀂䅖䢿侒媕安峖庵桉氨痷盦盫腤菴萻葊蓭誝諳谙鞌鞍韽馣鵪鶕鹌𠽪𡯏𢰍𣚖𧩸𧫥𧫧𧮍𩽾𪁟𪘒])),
					result  => q(ān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䜙儑啽玵雸𡪁𡽜𣵱])),
					result  => q(án),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜝㽢俺唵垵埯揞罯銨铵隌𠉬𤃷𤜁𥦍𦺽𩅝𩈴])),
					result  => q(ǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟁㱘䅁䬓䮗䯥堓婩岸按晻暗案洝犴胺荌豻錌闇鮟黯𠰑𡎑𡪙𡹼𣆛𣣚𣽥𤞿𤟉𥏮𥳬𧖮𨲊𩓤𩭢𩹎])),
					result  => q(àn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[肮骯𠵫𡕉])),
					result  => q(āng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㭿䀚䒢䩕䭹卬岇昂昻𤭒𩑝𩔘])),
					result  => q(áng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䇦䭺𦫫])),
					result  => q(ǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㼜枊盎醠𠹃𡵙𢓋𣉗𣖮𩉰𩜟])),
					result  => q(àng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕭㩠䫜凹柪梎爊軪𤏶𧅃𧨲𩥊𪃨])),
					result  => q(āo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟼㠂㿰䥝䦋䵅厫嗷嗸嶅廒摮敖滶熬獒獓璈磝翱翺聱蔜螯謷謸遨鏖隞鰲鳌鷔鼇𡊛𡏼𢧴𣊁𣷫𥂢𦪈𩘮𩮯𩱏𪉑])),
					result  => q(áo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑃㤇䯠䴈媪媼抝拗芺袄襖镺𢁱𥜌𦽀𩈏𩑤𩣻𪁾])),
					result  => q(ǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘬㘭㜜㜩㠗㥿䐿䜒䫨䮯傲坳垇墺奡奥奧嫯岙岰嶴慠懊扷擙澳鏊隩驁骜𢕟𢳆𤺾𥑑𩑍𩕀𩟇𩼈])),
					result  => q(ào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[翶])),
					result  => q(ao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㭭㸭㺴㿬䰾仈八叭哵夿岜峇巴巼扒捌朳柭玐疤笆粑羓芭蚆豝釛釟鲃𠛋𠵺𡚭𢠭𢻷𤜱𤣸𤤒𦓧𧎱𧲧𨊹𩚥𩠀𩡩])),
					result  => q(bā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔜䟦䮂䳊叐坺墢妭抜拔炦犮癹胈茇菝詙跋軷颰魃鼥𢇷𥎱𦳺𧺡𧺺𩊤𩖽𩙥])),
					result  => q(bá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞎把鈀钯靶𢃳𢺞])),
					result  => q(bǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㶚䃻䆉䇑䎬䎱䩗䩻䶕坝垻壩弝欛灞爸矲罢罷耙覇跁霸鮊鲅鲌𤜕𥝧𦫙𧿏𩃴𩨜𩹏𩽷])),
					result  => q(bà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[吧紦魞𣬶𣬷])),
					result  => q(ba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓦䪹挀掰擘𢛞𨃅])),
					result  => q(bāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㿟䳆白𥬝𦣺𪡈])),
					result  => q(bái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䙓佰捭摆擺柏栢瓸百粨絔襬𠫛])),
					result  => q(bǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔥㠔䒔䢙庍拜拝敗猈稗粺蛽贁败韛𡏯𡭢𢈕𣧙𣺽𤁣𤙅𤽹𦩋𦳞𩋂𩎻𩏞])),
					result  => q(bài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗑竡薭])),
					result  => q(bai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䃑䈲扳搬攽斑斒班瘢癍般螌褩辬頒颁鳻𠔯𠚼𠦒𠺚𣪂𤡰𤦦𤫫𤳖𥹓𦎊𧇥𨭉𩔮𩿉𪄕𪉒𪒋])),
					result  => q(bān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䉽䬳坂岅昄板版瓪粄舨蝂鈑钣闆阪魬𠧫𡯘𧌿𧿨])),
					result  => q(bǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚘㪵伴办半坢姅怑扮拌柈湴瓣秚絆绊辦鉡靽𠯘𢲔𢴬𥷁𦙹𦝤𨐦𨐱𨐾𩢔])),
					result  => q(bàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[螁])),
					result  => q(ban),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙃㨍㿶䩷垹帮幇幚幫捠梆浜縍邦邫鞤𠲑𠳐𢁏𢸌𣮡𤚰𤱵𦰥𨢐𩍗])),
					result  => q(bāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㮄榜牓綁绑膀髈𣮧𦾭])),
					result  => q(bǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㭋䂜䎧䖫䧛䰷傍塝搒棒棓玤磅稖艕蒡蚌蜯謗谤鎊镑𠨵𠬣𡽲𢄎𢜗𢮏𢶶𣘙𩦠𩮗])),
					result  => q(bàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[勹包孢枹煲笣胞苞蕔褒襃闁齙龅𠅬𠣒𡶄𧵢𨚔])),
					result  => q(bāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㵡㿺䈏䥤䨌䨔䪨嫑窇薄雹𤿈𥭓𦡕𦢊])),
					result  => q(báo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙅㻄䎂䭋䭸䳈䳰䴐保堡堢媬宝宲寚寳寶怉珤緥葆褓賲靌飽饱駂鳵鴇鸨𠤏𡧖𤞥𨰦𨰻𩛞𩬽𩭼])),
					result  => q(bǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙸㫧㲒䤖儤勽報忁报抱暴曓爆菢虣蚫袌豹趵鉋鑤铇靤骲髱鮑鲍鸔𠣺𠹕𡂟𡉩𢼌𣭀𤔣𤝧𥄹𧝘𧭤𨇅𨠖𩊅𩍂𩾡𩿓𪏶])),
					result  => q(bào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[佨藵])),
					result  => q(bao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗗㽡䥯卑悲揹杯桮椑盃碑禆藣錃陂鵯鹎𢃍𣬍𤵛𤷁𤿾𥏓𥶓𦈧𦈶𦩖𧼠𩔹])),
					result  => q(bēi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤳䋳北鉳𧉥𧋲])),
					result  => q(běi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻉㔨㛝㣁㫲㰆㶔㷶㸢㸬㸽㻗㾱䔒䟺䡶䩀䰽俻倍偝偹備僃备孛悖惫愂憊昁梖焙牬犕狈狽珼琲碚糒背苝蓓被褙誖貝贝軰輩辈邶郥鄁鋇鐾钡鞁鞴骳𠋭𠐡𠢥𡋭𢂏𢴾𢻵𣎵𣖾𣬪𤜲𤰈𤳦𤹲𤿒𦮷𦾙𧶙𩇩𩖠𩚾])),
					result  => q(bèi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[呗唄禙])),
					result  => q(bei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[奔栟泍犇贲錛锛𣳰𩣺𩧼𪑖])),
					result  => q(bēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡷㮺奙本楍畚翉苯𣄏])),
					result  => q(běn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤓㨧㮥䬱倴坋坌捹撪桳渀獖笨輽逩𣴞𥢊𦯀𨋒𪊜𪎝])),
					result  => q(bèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔙䑫䨜伻傰嘣奟崩嵭痭祊絣綳閍𠜳𠡮𡡈𡶤𢆸𢉁𢐒𣂤𣨥𤙾𤡭𥛱𥞩𦅈𨕧𨸂𨹹𨻱])),
					result  => q(bēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[甭])),
					result  => q(béng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑟䋽䙀䩬䳞埄埲琣琫繃绷菶鞛𤫬𥀂𦂌𧑑𧚭𨓁𩊌𩑚])),
					result  => q(běng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㷯䨻䭰塴泵甏蠯蹦迸逬鏰镚𡎾𡾛𥖗𥦜𦝷𦺑𧩱𧻓𨆊𩂦𩗴𪔑])),
					result  => q(bèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[揼])),
					result  => q(beng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡙䚜䫾䮠偪屄楅毴螕豍逼鎞鰏鲾鵖𢟵𢡅𣚡𤝸𥏠𧤃𨲋𨻼𩧿𩭧])),
					result  => q(bī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䨆䵄荸鼻𣴨𩾳])),
					result  => q(bí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠲㪏㻶䃾䏢䘡䣥佊俾匕吡啚夶妣彼朼柀比沘疕秕笔筆箄粃聛舭貏鄙𠐌𠛡𠧅𠬈𡳄𢩒𢳋𣔓𤹦𤽊𦸣𨅗𨟵𪌄𪐄])),
					result  => q(bǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓖㘠㘩㙄㡀㢰㢶㢸㧙㪤㮿㯇㱸㳼㵥㻫㿫䀣䁹䄶䉾䊧䋔䎵䏶䕗䖩䟆䟤䠋䧗䩛䪐䫁䬛䮡䯗佖哔嗶坒堛壁奰妼婢嬖币幣庇庳廦弊弻弼彃必怭怶愊愎敝斃枈柲梐毕毖毙湢滗滭潷濞煏熚狴獘獙珌璧畀畢疪痹痺皕睤碧笓筚箅箆篦篳粊綼縪繴罼腷臂苾荜萆蓖蓽蔽薜蜌袐裨襞襣觱詖诐貱賁贔赑跸蹕躃躄避邲鄨鄪鉍鏎鐴铋閇閉閟闭陛鞸韠飶饆馝駜驆髀髲魓鮅鷝鷩鼊𠈺𠋯𠓷𠡂𠦈𠨘𠩿𠮃𠽩𡚁𡛗𡠚𡻞𡽶𢁽𢅩𢐦𢖬𢘍𢲾𢴩𣁉𣁢𣋹𣘥𣝍𣢠𣥣𣦇𣦢𣩩𣭤𣮐𣯴𤂀𤅹𤐙𤗚𤙞𤜻𤠺𤡝𤢣𤵘𤹝𤻖𥆯𥈗𥛘𥟗𥢦𥳆𥴬𥷑𦂖𦑞𦔆𦠞𦤫𦯛𦰙𦱔𧏻𧒀𧓄𧥑𧫤𧲜𧳠𨋥𨋩𨐨𨚍𨚓𨠔𨵰𨸼𩉫𩊰𩑻𩪖𩪧𩲢𪋜𪍪𪏺])),
					result  => q(bì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[匂嬶幤萞襅])),
					result  => q(bi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䟍揙煸牑猵甂砭笾箯籩編编蝙边辺邉邊鍽鞭鯾鯿鳊𠐈𠑟𢩟𢻶𣩀𤄺𦇭𨖾𨩫𪏗𪓍])),
					result  => q(biān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦚䁵匾惼扁碥稨窆糄萹藊褊貶贬鴘𠓫𠪂𡈯𡬯𡬲𡬸𢴂𤀫𥣝𥣰𦟣𦽟𨖠𪖯])),
					result  => q(biǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝸㣐㭓㲢㳎㳒㴜㵷㺹䉸䒪䛒䡢䪻便匥卞变変弁徧忭抃昪汳汴玣緶缏艑苄覍變辡辧-辩辫辮辯遍釆閞𠭹𠯴𠷖𢭥𣈠𣝜𣪭𣸇𤀲𤺇𤻶𥍚𦉙𧩰𨚕𨧕𨳲𩩯𩰍𪉱])),
					result  => q(biàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[峅炞])),
					result  => q(bian),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺣㶾䁃䁭䅺䙳䮽儦墂幖彪摽杓标標淲滮瀌灬熛爂猋瘭磦穮脿膘臕蔈藨謤贆鏢鑣镖镳颩颮颷飆-飈飑飙飚驃驫骉骠髟𠔂𠚠𢒯𣄠𤂆𤆀𤐫𥲦𦔗𦔩𦠎𦾑𧥍𨭚𩙪𩪊𩴩𩽁])),
					result  => q(biāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟽㠒㯹䔸婊檦表裱褾諘錶𢅚𥘤𧝪])),
					result  => q(biǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧼䞄俵鰾鳔𠬪𢿏𧳀𧴎𧴕])),
					result  => q(biào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[飊])),
					result  => q(biao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔡䋢䘷䳤憋虌蟞鱉鳖鼈龞𡐞𡘴𡙀𢐳𢠳𣇢𣊶𤉤𤷗𥞲𥡁𧆊𧌽𨂅𩵛𩸁𪂟])),
					result  => q(biē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䇷䏟䠥䭱別别咇徶莂蛂襒蹩𠍯𡙪𡷘𢛎𤺓𤾵𧝬𧧸𧿥𨒜𩓝𩠻𩡟𩦉𪐆])),
					result  => q(bié),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㿜瘪癟])),
					result  => q(biě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢼䌘彆𢆣])),
					result  => q(biè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㻞䚔䧬䨈傧儐宾彬斌梹椕槟檳汃滨濒濱瀕玢瑸璸砏繽缤虨豩豳賓賔邠鑌镔霦顮𠴇𡦻𡧼𢲰𣉮𣢏𣰨𥃰𧷟𨐰𨽗𩆱𩴱𪇕])),
					result  => q(bīn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䐔])),
					result  => q(bǐn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[摈擯殡殯膑臏髌髕髩鬂鬓鬢𡦆𧸈])),
					result  => q(bìn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[氞濵])),
					result  => q(bin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䔊仌仒兵冫冰掤氷𡲍𢎴𥲂𨹗𩋒𪑰])),
					result  => q(bīng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨀䴵丙怲抦摒昞昺柄炳眪禀秉稟窉苪蛃邴鈵鉼陃鞞餅餠饼𠒝𠛥𠱛𡇤𡖛𡚛𡹾𣦪𦼹𩊖𩏂𩶁])),
					result  => q(bǐng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓈䗒並併倂偋傡寎并幷庰栤棅病竝誁靐鮩𠊧𢆩𢊜𢔧𣰜𥖬𦡻𦿅𨆱𨋲𩬝𩮟])),
					result  => q(bìng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[垪鋲鞆])),
					result  => q(bing),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞈䃗䝛䭦僠剝剥哱嶓帗拨撥播波玻癶癷盋砵碆紴缽菠袚袰蹳鉢钵餑饽驋鮁鱍𠱀𠺣𡀖𢂍𤗳𤜧𥮯𦲱𧙄𧲯𨭂𩜥𩧯𩬸𩯌])),
					result  => q(bō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗘㟑㩧㩭㪍㬍㬧㴾㶿㹀㼎㼟㼣䂍䊿䌟䍸䑈䗚䙏䞳䟛䢌䢪䥬䪇䪬䬪䭯䮀䯋䰊䳁䵗䶈亳仢伯侼僰勃博嚗帛愽懪挬搏欂浡渤煿牔犦犻狛猼瓝瓟礡礴秡箔簙肑胉脖膊舶艊苩葧蔔袯袹襏襮豰踣郣鈸鉑鋍鎛鑮钹铂镈餺馎馛馞駁駮驳髆髉鵓鹁𠧛𠮭𠷺𠸳𡋯𢐾𢠺𢣞𢩞𢫯𢺽𣋵𣛓𣧧𣭷𣽡𤃵𤒔𤗺𤚽𤶋𤾝𥜖𥭖𥴮𥹸𦃙𦈞𦋉𦤚𦤣𦯉𦰬𦼭𦽮𧇚𧟱𨈩𨍭𨏫𩃶𩄿𩌏𩍿𩏯𩓐𩗀𩗒𩗓𩙦𩟕𩣡𩱚𩷚𩽛𪌰𪍡𪙍])),
					result  => q(bó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝿箥簸跛𤿑𥸥𪓜𪚷])),
					result  => q(bǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[孹檗糪蘗譒𠴸𡅂𡯳𡯷𩈔])),
					result  => q(bò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺊卜啵萡])),
					result  => q(bo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[峬庯晡誧逋鈽𠚉𥪀𧻷𩶉𩺼])),
					result  => q(bū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[轐醭鳪𥻞])),
					result  => q(bú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙛㨐䀯䋠䪁䪔卟哺喸捕补補鵏𡡐𣱶𤣰𥃨𥣌𨴪𩏮𩏵𩯏𪇰])),
					result  => q(bǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘵㚴㳍㻉㾟䊇䍌䏽䑰䒀䝵䬏䴺不佈勏吥咘埔埗埠布怖悑抪捗柨步歨歩瓿篰簿荹蔀踄部郶钚钸餔餢𠘁𠜙𢁻𢇴𤚵𤸵𥑢𥳖𥹴𧉩𨋞𨛒𩅇𩊬𩊶𩢕𩣝𩷖𩻗𫐓𫗦])),
					result  => q(bù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䃰䌨嚓擦攃𤄖𨆾𨺭𪊗])),
					result  => q(cā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[礤])),
					result  => q(cǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䵽囃遪𥗭𥩝])),
					result  => q(cà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䞗䟀䠕偲婇猜])),
					result  => q(cāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒲䴭才材溨犲纔裁財财𢎂𦬁𧵤𨙴])),
					result  => q(cái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥒䌽䐆䣋倸啋寀彩採毝睬綵跴踩采𤚀𤝭𤟖𤷕𧀊])),
					result  => q(cǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䰂埰棌縩菜蔡𡣮𤁱𨯓𩁞𩧇𪇭])),
					result  => q(cài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜗䉔䟃䱗傪参-叅喰嬠湌飡餐驂骖𠫭𥢽𦪜𦪫𩝖𩟒])),
					result  => q(cān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥇㨻㱚䏼䗝䗞䘉䙁䝳䣟䳻嬱惭慙慚残殘蚕蝅蠶蠺𠠋𠡡𢦸𢧮𢾃𣦼𥂥𦺐𧅀𧓩𨅔𨞷𩀧𩈻])),
					result  => q(cán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦧㿊䅟惨慘憯朁穇篸黪黲𡆮𥠩𥮾𨲱𩈼])),
					result  => q(cǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛑㣓㻮㽩䛹孱掺摻澯灿燦璨粲薒謲𡛝𣶡𣻬𤅒𥹛𩯞𪆶])),
					result  => q(càn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[儏爘])),
					result  => q(can),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[仓仺伧倉傖嵢沧滄獊舱艙苍蒼螥鶬鸧𠥐𤚬𦾝𩀞𩕹𩝞])),
					result  => q(cāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㵴㶓藏鑶𡽴𡾻𡿄𨤃])),
					result  => q(cáng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䅮䢢賶])),
					result  => q(càng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[欌濸罉])),
					result  => q(cang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䎭撡操糙𠀊𤒕])),
					result  => q(cāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜖㯥䄚䏆䐬嘈嶆曹曺槽漕艚蓸螬褿鏪𡮦𣈅𣉿𤡐𤵥𥕢𥲍𦋿𨎝𩞄𩠎𩫥])),
					result  => q(cáo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䒑愺懆艸草騲𠹊])),
					result  => q(cǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䒃肏襙鄵])),
					result  => q(cào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺾-⻀艹])),
					result  => q(cao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥽㨲㩍䇲䈟䊂䔴侧側冊册厕厠墄廁恻惻憡拺敇测測畟笧策筞筴箣簎粣萗萴蓛𡍫𢿸𣌧𥠉𥬰𥰡𥳯𦔎𦣧𦵪𧵡𨶨𩒄])),
					result  => q(cè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𤭢])),
					result  => q(cèi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嵾])),
					result  => q(cēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞥䅾䤁䨙䲋岑梣涔笒𣡎𦊃𨁊𨥣𨱼𩅨𩅮𩻛])),
					result  => q(cén),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[噌曽𡃆])),
					result  => q(cēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬝䁬䉕层層嶒曾竲驓𡪠𡾓𢅋𤛢𦠇𧲅])),
					result  => q(céng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣒蹭𠟂])),
					result  => q(cèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛼㮑偛叉嗏扠挿插揷杈疀肞臿艖銟鍤锸餷馇𠝞𠞊𡋨𡵌𢔣𢘹𢭅𣆗𤜫𤜯𤳵𤵾𦑈𦝥𦦘𦦜𦦱𨀸𨙳𨪺𩝟𪘾])),
					result  => q(chā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢉㢒㪯㫅䁟䅊䕓䤩垞察嵖搽查槎檫猹碴秅茬茶詧靫𠽹𡝐𡝙𡨀𢣼𣘤𣘻𣱱𤶠𥌀𥥸𥻗𦉆𦑣𦛝𦳘𨃓𨼑𩟔𪒼])),
					result  => q(chá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[衩蹅鑔镲𡌚𥑥𥫢𨩨])),
					result  => q(chǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣾㤞䒲䓭䟕䡨䶪侘奼姹岔差汊紁詫诧𣍏𤞠𤳅𥃀𧠈𧫗𧶵𨆇𩴳𪑂𪑨])),
					result  => q(chà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㼮䐤拆芆釵钗𢹓𥐟𩑐])),
					result  => q(chāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑪㾹䓱侪儕喍柴祡豺齜𡟭𡺵𤞗𤠌𨌅])),
					result  => q(chái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䜺茝])),
					result  => q(chǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㳗䘍囆瘥虿蠆袃訍𦐰𦑏𧀱𧒨𧔴𧕧𧪘𧸿])),
					result  => q(chài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚲㢟㤐㰫㺗䪜幨搀攙梴裧襜覘觇辿鉆鋓𠣄𡖞𡖤𡝫𡮿𢌚𤴿𥭔𨊝𨵍𩖌])),
					result  => q(chān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙻㢆㶣㺥䂁䜛䡲䣑䤫䧯䫮僝儃儳劖嚵婵嬋巉廛棎欃毚湹潹潺澶瀍瀺煘獑磛禅禪緾纏纒缠艬蝉蟬蟾誗讒谗躔鄽酁鋋鑱镡镵饞馋𡎻𢥋𢽝𣔵𣤱𤸦𦝟𧐲𧓋𧕃𧥓𧨗𧴃𧾡𨬖𨮻𨽊𩮏𩽝𪏁𪏂𪏋𪏦𪓄𪖎𪗂𪚃])),
					result  => q(chán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦃㯆㹌㹽䐮䑎䤘䥀䩶䵐丳产冁刬剗剷啴嘽囅嵼幝摌斺旵浐滻灛燀產産簅繟蒇蕆諂譂讇谄辴鏟铲閳闡阐骣𠁷𠋷𠐩𠑆𠑑𠑡𠹖𡍌𡶴𢁧𢱟𢷹𣃘𤚍𤯥𦆀𦈎𦢙𦸰𧈪𧬦𨄉𨇝𨔢𨩪𨪑𨲵𨷭𨼒𩝚𩥮𪙞])),
					result  => q(chǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙴㬄㸥䀡䊲䠨䱿䴼忏懴懺摲硟羼韂顫颤𢺟𤗻𤪮𤮭𤼋𥊓𧠛𨇦𨳂𩟶])),
					result  => q(chàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[壥])),
					result  => q(chan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䅛䗉䮖伥倀娼昌晿淐猖琩菖裮錩锠閶阊鯧鲳鼚𥫅𨷇𩲹𪂇𪉨])),
					result  => q(chāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻑⻒㙊㦂䗅䠆䯴仧偿償兏嘗嚐塲嫦尝常徜瑺瓺甞肠腸膓苌萇鋿鏛镸鱨鲿𠙁𢁝𥋤𦰱𦼳𨣛𨱮𪁺𪄹])),
					result  => q(cháng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺁㫤僘厂厰场場廠惝敞昶氅鋹𡭿𤢄𤿼𥗊])),
					result  => q(chǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䩨倡唱怅悵暢焻玚瑒畅畼誯韔鬯𠚊𢗺𢢌𤽣𥇔𥟚𥠴𧀄])),
					result  => q(chàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[椙蟐])),
					result  => q(chang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䜈䫸䫿䰫勦弨怊抄欩焯訬超鈔钞𠰉𢁾𤙴𦾱𨴡𩖥])),
					result  => q(chāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嘲巢巣晁朝樔漅潮牊窲罺謿轈鄛鼂鼌𡏮𡡊𡻝𡼼𣰩𥕘𥲀𦸛𨄓])),
					result  => q(cháo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㶤㷅䎐䏚吵巐炒焣煼眧麨𦙧𧧠𩈎𩱈𩱦𪍑𪎊])),
					result  => q(chǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[仦仯耖觘𡯴𤰬𥿷𦨖𨌬𨗡𨢪𨨚𪍈])),
					result  => q(chào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻋伡俥唓砗硨莗蛼車车𡷖𤥭𩒷])),
					result  => q(chē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𧙝])),
					result  => q(ché),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨋㵔䋲䞣䰩偖扯撦𦓍𩴟])),
					result  => q(chě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒤㔭㤴㥉㬚㳧㾝㿭䁤䒆䚢䛸䜠䧪勶坼屮彻徹掣撤澈烢爡瞮硩聅迠頙𢇛𢊏𣨊𤊿𤕛𤖷𤗙𤹞𥯥𥿊𦈈𦛖𧼳𨀠𨹡𩂻𩎚𩗙𪎺])),
					result  => q(chè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥲䀼䐜䑣䠳嗔抻捵琛瞋綝縝諃謓賝郴𣞟𤝚𤟸𤡳𥞁𦁄𦁟𧡬𨻖𨼌𩅌𩇖])),
					result  => q(chēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕴㫳㴴㽸䆣䒞䜟䟢䢅䢈䢻䣅䤟塵宸尘忱愖揨敐晨曟樄沈沉煁瘎臣茞莀莐蔯薼螴訦諶谌軙辰迧鈂陈陳霃鷐麎𢆺𣀍𤘣𤹛𥉜𥫹𧨡𨑌𨼤𪁏])),
					result  => q(chén),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䫈䫖墋夦硶碜磣贂趻踸醦鍖𥔪𧿒𨣔])),
					result  => q(chěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧱䞋儬儭嚫榇櫬疢衬襯讖谶趁趂齓齔龀𠋆𢎕𥗒𧆂𧭼𨼐])),
					result  => q(chèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[烥])),
					result  => q(chen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓌㛵䕝䗀䞓䟓䟫偁僜憆摚撐撑柽棦橕檉泟浾湞爯牚琤瞠称稱穪竀緽蛏蟶赪赬鏳鏿阷靗頳饓𠏧𡽊𣥺𦓬𧯒𨭃𩁷𩞦𩠏])),
					result  => q(chēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞼㲂㼩䁎䄇䆑䆵䇸䚘䧕䫆䮪丞乗乘呈城埕堘塍塖娍宬峸惩憕懲成承挰掁晟朾枨棖椉橙檙洆溗澂澄瀓珵珹畻碀程窚筬絾脀脭荿裎誠诚郕酲鋮铖騬𠕠𠳽𡝚𢐞𢻓𢾊𢿦𢿧𣀏𤆁𤗓𤿣𥢲𥥱𦦢𧶔𧹓𨁎𨅝𨌤𨞐𨹚𩙆𩤙𩨆𩫹𩯎𪁋])),
					result  => q(chéng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[侱庱徎悜睈逞騁骋𢜻𢜼𢟊𣥻])),
					result  => q(chěng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐼秤𡤿𢔤𤕀𧡈𧶸𧷒𩛦])),
					result  => q(chèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鯎])),
					result  => q(cheng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㰞㷰㺈䇪䜉䧝侙吃哧喫嗤噄媸彨彲摛瓻痴癡眵瞝笞絺胵蚩螭訵誺魑鴟鸱黐齝𡼁𣣷𤡢𥄇𥭘𦆤𦐉𦞲𧩚𧩴𧪡𧴁𨒬𩤖𩶅𪌹𫄨])),
					result  => q(chī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙜㞴㢮㮛䙙䜄䞾䪧䮈䶔䶵坻墀岻弛持歭池漦竾筂箎篪茌荎蚳謘貾赿趍踟迟遅遟遲馳驰𡂙𡉪𡌞𡎍𢓎𢔊𣉄𣲋𣹡𤈔𦐁𦑡𦱰𦳚𦵟𧋗𧎨𧛺𧭟𧺏𨘾𨨲𩚉𪌫𪏐])),
					result  => q(chí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻭⻮㘜㢁㢋㱀㶴䊼䑛䜵䜻侈卶叺呎垑尺恥欼歯粎耻胣蚇袲袳裭褫鉹齒齿𠛔𠝨𠭋𡖳𡳭𢇕𤟆𤵬𥚚𦙆𧀤𧉀𧛧𧰲𨑠𨖎𨾛𩒐𩳲])),
					result  => q(chǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒆㓼㔑㞿㡿㥡㽚䀸䟷䠠䤲䮻䰡䳵傺勅勑叱啻彳恜慗憏懘抶敕斥杘湁灻炽烾熾痓痸瘈瘛硳翄翅翤翨腟赤趩跮遫鉓銐雴飭饎饬鶒鷘𠞩𠧚𠧵𠮟𠻟𡚨𡣀𢂝𢜳𢨒𣐃𣙰𣚩𣤩𤆍𤡏𤰠𤸪𥛚𥱻𦂋𦎚𦏿𦔫𦘪𦤸𦥊𧤍𧩼𧺠𧺧𧺿𧼪𨂰𨔤𨧳𨨬𩥲𩷧𩾕𩿪𪀦𪅍𪅙𪆵𪉄𪉅𪉗𫛶])),
					result  => q(chì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[妛麶])),
					result  => q(chi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤝㳘䂌䆔䆹䘪䝑䡴充冲嘃徸忡憃憧摏沖浺珫罿翀舂艟茺衝蹖𠝤𠟍𢥞𥁵𥫯𥭥𦟛𧐍𧘂𧝎𧩃𨈮𨤩𨳁𩥫𩬤𩰀𪄻𪅈𪅖𪎽𪒒])),
					result  => q(chōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓽㹐䌬䖝䳯崇崈爞緟虫蝩蟲褈隀𡿂𢖄𢝈𣐯𨛱𩌨𩜖𩞉𩞋])),
					result  => q(chóng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[埫宠寵𠖥𢛒𦑝𧼙𨿿𩒘])),
					result  => q(chǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧤㮔揰銃铳𠑙𢡹𣑁𥅻𥬱𧼩𨖼𩩳])),
					result  => q(chòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨨㮲䀺䌷婤抽搊犨犫瘳篘𠌪𢭆𥃧𥬠𥰞𥵬𥺣𥻤𨡑𨡲])),
					result  => q(chōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐜㤽㦞㵞㿧䌧䓓䲖仇俦儔嚋嬦帱幬怞惆愁懤栦椆燽畴疇皗稠筹籌紬絒綢绸菗薵裯讎讐踌躊酧酬醻雔雠𠝽𠷎𠹝𠼡𠾉𡕐𡕪𣀓𣕾𣪐𣫐𤳝𤳠𤽯𤾊𤾦𥏈𥡀𥲅𦡴𦭸𧮻𨞪𨤷𩽀𩾂𪇘])),
					result  => q(chóu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䪮丑丒侴偢吜杻杽瞅矁醜魗𠜋𢣊𤘶𥄨𧃝𨀔𩋄𩌄])),
					result  => q(chǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䔏殠臭臰遚𥦅𨖬])),
					result  => q(chòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗙䝙䢺出初岀摴樗貙齣𠁉𠰕𠿝𤙟𩙙𩨸𪁲])),
					result  => q(chū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕏㕑㛀㡡䅳䊰䎝䟞䠂䠧刍厨媰幮廚橱櫉櫥滁犓篨耡芻蒢蒭蕏藸蜍豠趎蹰躇躕鉏鋤锄除雏雛鶵𢅥𢊍𣦠𣦡𦷝𦿀𩿿𪆷])),
					result  => q(chú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䖏䙘储儲処杵椘楚楮檚濋础礎褚鸀齭齼𠧖𢕓𤻇𧎷𨼪𩂫𪓐])),
					result  => q(chǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔘㙇㤕㾥䇍䎌䐍䜴䟣䦌亍俶傗儊嘼埱处怵憷拀搐敊斶柷欪歜滀珿琡畜矗竌竐絀绌臅蓫處触觸諔豖踀鄐閦黜𠇘𡐌𡝈𡳑𢒔𢣿𢨫𣢶𣥹𤏱𤝞𥁯𥒭𥹵𦺵𧃏𧢶𧯩𧰫𧺶𧽧𨁿𨃕𨕢𨴰𩈤𩹱𪇆])),
					result  => q(chù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[榋橻璴蟵])),
					result  => q(chu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔍䊬䵵欻歘𤁫])),
					result  => q(chuā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𠹐𠻦𣛕𣹶])),
					result  => q(chuǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䫄])),
					result  => q(chuà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[揣搋𢲽])),
					result  => q(chuāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪓膗])),
					result  => q(chuái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪜𣲂])),
					result  => q(chuǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䦤䦷䴝啜嘬膪踹𠽶𣤌𨣅])),
					result  => q(chuài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[剶巛川氚猭瑏穿𠛖𠯀𠾮𨩴𩂍])),
					result  => q(chuān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㯌㼷䁣伝传傳圌暷椽篅舡舩船輲遄𣛹𤜼𤮍𤰌𨘼])),
					result  => q(chuán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱛僢喘歂舛荈踳𣧒𥬫𧍒])),
					result  => q(chuǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[串汌玔賗釧钏鶨𣀔𤶱𥃹𥲏𦎇𦎜𦺛𧑝𨂦])),
					result  => q(chuàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䄝䆫刅摐牎牕疮瘡窓窗窻𡆪𥎒𥡟𥲡𧜧𧢆])),
					result  => q(chuāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡖䃥䚒䭚噇幢床牀𠳹𦔛𧬧𨧖𩃕𩞆𩪘𪁱])),
					result  => q(chuáng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㼽傸摤磢闖闯𠏨𠞮𡻯])),
					result  => q(chuǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䎫凔创刱剏剙創怆愴𥈄𨜾])),
					result  => q(chuàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[吹炊𤙵])),
					result  => q(chuī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝽䍋倕垂埀捶搥棰椎槌箠腄菙錘鎚锤陲顀𠄒𡍮𢏒𣇦𦉈𩌝𩗰𩭦])),
					result  => q(chuí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㷃䞼])),
					result  => q(chuǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[龡𣟈𥙋𥞃])),
					result  => q(chuì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䞺䡅䲠堾媋旾春暙杶椿橁櫄瑃箺膥萅蝽輴鰆鶞𡉐𣌚𣚆𧇶𨉩𪂹])),
					result  => q(chūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝄㝇㵮㸪䓐䔚䣨䣩䥎䫃唇浱淳湻滣漘犉純纯脣莼蒓蓴醇醕錞陙鯙鶉鹑𡗥𣌠𣘣𣮢𤘛𦎧])),
					result  => q(chún),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖺㿤䏛䐏䞐䦮䮞偆惷睶萶蠢賰𢾎𦚧𩨁])),
					result  => q(chǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪬戳踔逴𨮸𨰆])),
					result  => q(chuō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻌-⻎㚟㲋䋘䓎嚽娕娖婼惙擉歠涰磭綽繛绰腏趠輟辍辵辶酫鑡齪龊𡁇𢽸𢿭𤿫𥓑𦁶𨆬𨒢𩟫𩩟𪘛])),
					result  => q(chuò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[偨呲疵縒蠀赼趀跐骴髊齹𡃸𡰾𢫴𣜁𦍧𦑺𦒁𧠥𨒮𩨨])),
					result  => q(cī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓨㘂㘹㞖㤵䂣䈘䛐䧳䨏䭣䲿䳄垐堲嬨慈柌濨珁瓷甆磁礠祠糍茈茨薋詞词辝辞辤辭雌飺餈鴜鶿鷀鹚𠤫𠯂𡥎𢶴𣐑𥴺𥿆𧙈𨠐𩆂𩉋𩝐𪉈])),
					result  => q(cí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[佌此泚玼皉紪鮆𢓗𦐨𦐾𦼡𧺼𨒤𩢑])),
					result  => q(cǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢀㩞䓧䗹䯸䰍䳐伺佽刺刾庛朿栨次絘茦莿蛓螆賜赐𠦐𠩆𢅜𣢕𥿴𦖝𧊒𧌐𧑖𧠎𧧒𨋰𨲁𨾅𩾔𪉪𪑟])),
					result  => q(cì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜡㞱㥖䈡䐋䐫䓗䗓䡯䢨匆囪囱忩怱悤暰枞棇樅樬漗焧熜燪瑽璁瞛篵緫繱聡聦聪聰苁葱蓯蔥蟌鍯鏦騘驄骢𡟟𡹸𢊕𢐔𢔩𤧚𥍷𥎋𥡬𦇎𦗜𦝰𨂴𨍉𨑪𨑹𨡮𨦱𨱸𨲧𩬼𪻐𫓩])),
					result  => q(cōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗰㼻䉘䕺䳷丛从叢婃孮従徖從悰慒樷欉淙漎潀潨灇爜琮藂誴賨賩𠂥𠕁𠙂𠢛𠤰𡅇𡦷𡵷𢃏𣃗𣊷𤄓𥵫𦇱𧐱𧓏𨒀𩯍])),
					result  => q(cóng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𧝮])),
					result  => q(cǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[憁謥𥮨𧩪])),
					result  => q(còng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[茐])),
					result  => q(cong),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𢈾])),
					result  => q(cōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𧡣])),
					result  => q(cóu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[凑湊腠輳辏𣉅𣙘𣞜𤆑𦦅𦳿𦺀𧱪𨨯𩹀𪉮])),
					result  => q(còu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[粗觕麁麄麤𡘛𡝉𤿚𥅗𧆓𧺲])),
					result  => q(cū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䢐䣯徂殂𦯣])),
					result  => q(cú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𤛏])),
					result  => q(cǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗤䃚䙯䛤䟟䠞䥄䥘促噈憱猝瘄瘯簇縬脨蔟誎趗踧蹙蹴蹵酢醋顣鼀𠑯𠛙𡄱𡞜𢄧𢈠𢪃𤗁𤠽𥪱𥷼𥻒𥾛𦈚𦟠𦠁𧼜𪓡𪓰𪕝𪚯])),
					result  => q(cù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[撺攛汆蹿躥鋑鑹镩𥍬])),
					result  => q(cuān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠝巑櫕欑穳𢖑𨣵])),
					result  => q(cuán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸑殩熶爨窜竄篡簒𢸥𤐲𥎢-𥎤𨼉])),
					result  => q(cuàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜠䄟䙑催凗墔崔嶉慛摧榱槯獕磪縗缞鏙𢕘𤗯𤛍𥼂𧼬𧽠𨄍𨻵])),
					result  => q(cuī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㵏䊫䧽漼璀皠趡𢶓𣯧𣿒𣿓𥼺𧳚𨿐])),
					result  => q(cuǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝮㯔㯜㱖㳃㷪䃀䆊伜倅啐啛忰悴毳淬濢焠疩瘁竁粋粹紣綷翆翠脃脆脺膬膵臎萃襊顇𠗚𠞿𠟓𠩪𢂕𢄸𢡈𣃍𣰚𤎋𥨒𥳈𥻮𥼛𦦣𧎃𧑎𧚥𧜱𧹺𨅎𨊉𩤏])),
					result  => q(cuì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[乼])),
					result  => q(cui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䞭村澊皴竴踆邨𧚉𨙯])),
					result  => q(cūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[侟存拵𤿄𨀛𨚲])),
					result  => q(cún),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[刌忖])),
					result  => q(cǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䍎吋寸籿])),
					result  => q(cùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[搓撮瑳磋蹉遳醝𢤎𣨎𤠝𥭭𥰭𩯉𪒙])),
					result  => q(cuō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㭫㽨㿷䑘䠡䣜䰈䴾嵯嵳痤睉矬蒫蔖虘躦酂鹺鹾𠦏𣖵𣩈𨇃𩄝𪘓])),
					result  => q(cuó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䂳脞])),
					result  => q(cuǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟇䱜剉剒厝夎挫措斮棤歵莝莡蓌逪銼錯锉错𢒐𢚂𢯽𥕉𧚏𨛏])),
					result  => q(cuò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙮㿴䌋䐛䪚咑哒嗒噠搭撘笚耷荅褡鎝𠞈𠹥𡉑𡍲𡐿𦈘𦖿𦗧𦞂𨨹𨱏𩝣])),
					result  => q(dā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜓㩉㾑㿯䃮䵣剳匒呾妲怛沓炟畗畣笪答羍荙薘蟽詚躂达迖逹達鎉鐽阘靼鞑韃龖龘𠉤𡈐𢘇𢛁𢝉𣸉𤝰𤨑𥉌𦂀𦑻𦪭𦬹𩏒𩟐𩠅𩣯𩭣])),
					result  => q(dá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[打𥕇])),
					result  => q(dǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[大汏眔𠶫𡚻𢽇𣣴𣥾𤤊𨗾])),
					result  => q(dà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟷垯墶燵瘩繨])),
					result  => q(da),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[呆呔懛獃𠯪𣐮𦪍])),
					result  => q(dāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺞䚞䚟傣歹逮𣦶])),
					result  => q(dǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐲㞭㯂㶡㻖䈆䒫䲦代叇垈埭岱帒带帯帶廗待怠戴曃柋殆瀻玳瑇甙簤紿緿绐艜袋襶貸贷蹛軑軚軩轪迨霴靆骀鴏黛黱𠯈𠰺𠷂𡧹𢄔𢎌𣇨𣫹𤮼𤸊𥿝𦄂𦙯𧊇𧑔𨊺𨓞𨟲𨥶𨽿𩃠𩃷𪐝])),
					result  => q(dài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鮘])),
					result  => q(dai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐤㠆㴷䄡䐷䒟丹儋勯匰单単單妉媅担擔殚殫甔瘅癉眈砃箪簞耼耽聃聸褝襌躭郸鄲頕𠆛𠹆𡖓𡵕𢉑𢑝𣅟𣲥𦅼𧀻𧡪𧴸𨢿𩈊𩏥])),
					result  => q(dān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕪䃫䉞亶伔刐抌掸撢撣澸玬瓭疸紞胆膽衴赕黕黮𠇋𡦨𢋃𢻼𤢏𤲭𤺺𥄦𥐹𥱷𥳹𦽫𪆻])),
					result  => q(dǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗖㡺㲷䨢䨵䩥䭛䳉但僤啖啗啿嘾噉嚪帎弹弾彈惮憚憺旦暺柦氮沊泹淡澹狚疍癚禫窞繵腅萏蓞蛋蜑觛誕诞贉霮饏馾駳髧鴠𠆶𠈰𢅒𢎪𣇇𣋊𣛱𣱍𤁡𥨎𥲄𥲇𥳸𦋪𦻁𦽜𦾩𧂄𧭃𩄕𩅾𩈉𩕤𩩧𪒾])),
					result  => q(dàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㼕㽆噹当澢珰璫當筜簹艡蟷裆襠鐺铛𡰨𤔶𤗾𤢎𥢷𦗴𦼲𨎴𩟈𩼉𪇁])),
					result  => q(dāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䣊䣣党挡擋攩欓灙譡讜谠黨𡗍𣗋𣺼𤣞𥤗𧅗𩽳])),
					result  => q(dǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䑗䦒儅凼圵垱壋婸宕嵣愓档檔氹潒璗瓽盪瞊砀碭礑簜荡菪蕩蘯趤逿闣雼𡇈𡇵𡢈𡾕𢠽𢡂𣂳𣃉𣻍𥯕𥸈𦿆𧑘𨝦𨷾])),
					result  => q(dàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺈⺉刀刂叨忉朷氘舠釖魛鱽𣱼𦩍𩕯])),
					result  => q(dāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[捯])),
					result  => q(dáo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠀㨶㿒壔导導岛島嶋嶌嶹捣搗擣祷禂禱蹈隝隯𠐵𢭏𤹷𦦺𦦾])),
					result  => q(dǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䆃䊭䌦䧂倒到噵悼檤焘燾瓙盗盜稲稻箌纛翢翿菿衜衟軇道𠴼𡄒𣁍𣫜𤓾𤘀𤷘𥓬𥗚𥺅𦒺𧼤𨗓𨱦𩈞𩬱𩭟])),
					result  => q(dào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[屶椡槝陦])),
					result  => q(dao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嘚])),
					result  => q(dē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝵㤫㥁㯖䙷䙸得徳德恴惪棏淂鍀锝𠮊𡋩𡭂𣌏𣮊𣮰𤷙𨁽])),
					result  => q(dé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[地的脦𠵨])),
					result  => q(de),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩐扥扽])),
					result  => q(dèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔁㲪䔲䙞䳾噔嬁灯燈璒登竳簦覴豋蹬𤮘𤺌𤼶𧾊𨶿𩯇𪔏])),
					result  => q(dēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䒭戥朩等𤾢𪌷])),
					result  => q(děng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䠬䮴凳墱嶝櫈瞪磴邓鄧鐙镫隥𡦔𢯭𢿤𣩟𦩫𧄼𨄇𨎤𨮴𩍐𩞬𪑬𪒘])),
					result  => q(dèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[艠])),
					result  => q(deng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓳㫝䃅䍕䐎䧑仾低堤奃彽樀氐滴磾羝袛趆鍉镝隄鞮𠍪𠽰𡄷𡛜𡰖𣅥𣚌𣲢𤞈𥾬𥿄𩉱𩑾])),
					result  => q(dī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣙㰅㹍䊮䨀䨤䯼䴞䵠唙嘀嚁嫡廸敌敵梑涤滌狄笛篴籴糴翟苖荻蔋蔐藡覿觌豴蹢迪鏑靮頔馰髢鬄鸐𠒿𠕳𡒱𡽢𢕚𣂉𤁰𤈥𥕐𥖾𥸚𦉹𦵦𨮹𩭲𩴺𩷎𪄱])),
					result  => q(dí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪆㭽䂡䏄䢑䣌厎呧坘埞底弤抵拞掋柢牴砥聜茋菧觝詆诋軧邸阺骶𠨿𤝬𧤲𨂇𨌮])),
					result  => q(dǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢩㼵䀿䏑䑭䑯䗖䩘䩚䶍俤偙僀啇啲坔埊墑墬娣媂嶳帝弟怟慸摕旳杕梊棣渧焍玓珶甋眱睇碲祶禘第締缔腣菂蒂蔕蝃螮諦谛踶递逓遞遰釱鉪𠐑𠚭𠥖𠫜𡚙𡚷𢅊𢉆𢓧𣬴𣯵𤧛𤬵𤾠𥳠𦨢𧀶𧂨𧉛𧋍𧍝𧺽𨑩𨑼𨗼𨘬𨪾])),
					result  => q(dì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鯳])),
					result  => q(di),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嗲])),
					result  => q(diǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[傎厧嵮巅巓巔掂攧敁槇槙滇甸瘨癫癲蹎顚顛颠齻𠑘𠫉𠶧𡱇𢖩𣪀𤠶𦕒𧄺𧽍𨈀𩄠𩥄𩨋𩬑𪓼𪖚])),
					result  => q(diān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸃䍄䓦典嚸奌婰敟点猠碘蒧蕇跕踮點𠩷𢻅𣇖𤿶𥮏𦒻])),
					result  => q(diǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓠㝪㞟㶘㼭佃坫垫墊壂奠婝店惦扂橂橝殿淀澱玷琔电癜簟蜔钿阽電靛驔𠢣𡼓𢅝𢕯𣒂𣢥𣣈𣣣𣧛𣪪𤩱𥅑𥇞𥑼𥦟𥳢𥵏𦅆𦽄𧍿𩂵𩅀𩆔𪑩])),
					result  => q(diàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[椣])),
					result  => q(dian),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚋㢯㹦䂏䘟䳂凋刁叼奝弴彫殦汈琱瞗碉虭蛁貂雕鮉鯛鲷鳭鵰鼦𠚥𠚻𠶰𥮐𦨣𦶌𦸔𧘨𧘩𨸓𩀜𩾗])),
					result  => q(diāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䄪䉆屌扚𠄏𢁕𢄦𢆴𦄋𧜣])),
					result  => q(diǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒛㪕䂽䔙伄吊弔掉瘹窎窵竨蓧藋訋調调釣銱鋽鑃钓铞铫雿魡𠤼𠥑𣩰𤕷𤭈𤱩𥁮𥲟𥾯𦰏𧅈𨰑𩈮𩋙])),
					result  => q(diào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[簓])),
					result  => q(diao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦅䪓爹褺跌])),
					result  => q(diē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑙㥈㦶㩸㩹㫼㬪㲲㲳㷸䏲䞇䠟䫕䳀䴑叠喋垤堞峌嵽恎惵戜挕揲昳曡殜氎牃牒瓞畳疉疊眣碟絰绖耋胅臷艓苵蜨蝶褋詄諜谍趃蹀迭镻鰈鲽𠗛𠗨𠠯𠲷𡅥𡇓𡱷𡹭𡺑𡼄𢎆𢲼𢶣𣈍𣛻𣡟𣧈𣨂𤖒𤗨𤚊𤴍𥈖𥉺𥑇𥶺𥷕𦁜𦄔𦈅𧍱𨄌𨈈𨐁𨓊𨭓𨳺𨴗𨸅𨻗𨾤𩋞𩻵𪀒𪑧])),
					result  => q(dié),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𡖐])),
					result  => q(diě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哋眰耊𠅗𠆙])),
					result  => q(diè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[幉疂])),
					result  => q(die),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𨈖])),
					result  => q(dìn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣔䦺丁仃叮帄玎疔盯耵虰酊釘钉靪𦨍𧌾𧳉𩡯𩾚])),
					result  => q(dīng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㫀㴿奵嵿濎薡鐤頂顶鼎鼑𢑅𣆍𤐣𤛙𧇷𩠑𪔂])),
					result  => q(dǐng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝎啶定忊椗矴碇碠磸腚萣蝊訂订鋌錠铤锭顁飣饤𣢳𥇓𥯢𥳰𥸧𦩘𩜦𩠆𩸎])),
					result  => q(dìng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[聢])),
					result  => q(ding),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[丟丢銩铥𠲍𢒝])),
					result  => q(diū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚵䍶䰤东倲冬咚埬娻岽崠崬徚昸東氡氭涷笗苳菄蝀鯟鴤鶇鸫鼕𢔅𢛔𤤮𤦪𤲚𤷆𧓕𧯾𧲴𧼓𨩧𨿢𩂓𩜍𩣳])),
					result  => q(dōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖦㨂䂢䵔墥嬞懂箽董蕫諌𣿅𥳘𦡂𧄓𧳣𪐈])),
					result  => q(dǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑈㓊㢥㼯䞒侗働冻凍动動垌姛峒恫戙挏栋棟洞湩硐絧胨胴腖迵霘駧𠄉𢳾𥫎𧡍𧽿𩐤𩐵𩧲𩭩𪔦])),
					result  => q(dòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鮗鶫])),
					result  => q(dong),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨮兜兠吺唗橷篼蔸都𠍄𠱑𠾇𣂮𣘛𤝈𤾒𥆖𥉝𦄓𦆘𧡸𧯠𧯤𨁋𩔡𩮷𩳈])),
					result  => q(dōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞳㪷唞抖枓枡蚪鈄阧陡𢦍𣁵𣭗𧏆𧘞𨥪𩑯𪌉])),
					result  => q(dǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛒㢄䄈䇺䕆䛠䬦斗斣梪毭浢痘窦竇脰荳豆逗郖酘閗闘餖饾鬥鬦鬪鬬鬭𡂛𡂝𡆏𡙬𡟳𤀨𤅋𤞟𥥷𥺉𧮡𧯞𧱓𨪐𨴜𨶜𨹜𩊪𪐺])),
					result  => q(dòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[乧艔])),
					result  => q(dou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞘䦠䩲剢厾嘟督醏闍阇𠣰𡰪𣫔𤫻𥳉𦘴𦙋𦺥𧞹𧰵𧷿])),
					result  => q(dū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱩㸿㾄䓯䙱䢱䪅䫳䮷凟匵嬻椟櫝殰毒涜渎瀆牍牘犊犢独獨瓄皾碡蝳裻読讀讟读豄贕錖鑟韇韣韥騳髑黩黷𠉩𠠔𠠠𢝂𢷺𣰬𤚚𥀲𥑯𥓍𥖿𦌷𦏕𦺇𧁿𧐰𧛔𧾥𨂭𨍛𨽍𩞾𩧈𪍹])),
					result  => q(dú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䀾䈞堵帾琽睹笃篤覩賭赌𢾀𤬂𥓇𦛯])),
					result  => q(dǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓃䟻䲧妒妬度杜殬渡秺簵肚芏荰螙蠧蠹鍍镀靯𡍨𡎉𡝜𢉜𢾅𣧃𣨲𤚡𤬪𤴱𤵊𤶮𥀁𥃾𥝟𥝾𥯖𥲗𥳲𦡄𦳔𧉓𧋌𧑠𧔬𨋈𩩮𩵚𪐞])),
					result  => q(dù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟨偳剬媏端耑褍鍴𥠄𥵣𦾸𧤗𩤚])),
					result  => q(duān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[短𢭃𢷖𣠭𧶲])),
					result  => q(duǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㫁㱭䠪塅断斷椴段毈煅瑖碫簖籪緞缎腶葮躖鍛锻𠡱𢯫𨱚𨺣𩏇𩤣])),
					result  => q(duàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[襨])),
					result  => q(dùi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䂙䜃䭔垖堆塠嵟痽磓鐜鴭𠂤𠦗𡏩𡜥𢈹𢟋𤤷𤷎𤹵𥑵𧧆𩈜𩨽𪌤])),
					result  => q(duī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨃頧𠡒𡑈𦞱])),
					result  => q(duǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙂㟋㠚㬣㳔䇏䨴䨺䬈䯟兊兌兑对対對怼憝憞懟濧瀩碓祋綐薱譈鐓镦队陮隊𠏮𠜑𠫨𡁨𡷋𡼻𣝉𤄛𤮩𥹲𦡷𦶏𨹅𩄮𩅆𩅥𩅲𩈁𩊭𩐌𪒛𪒡])),
					result  => q(duì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䃦䔻䪃吨噸墩墪惇撉撴敦橔犜獤礅蜳蹲蹾驐𡼖𤭞𥂦𦼿𧝗𩞤])),
					result  => q(dūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[盹趸躉𣎴𧿗])),
					result  => q(dǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䤜伅囤庉楯沌潡炖燉盾砘踲逇遁遯鈍钝頓顿𠎻𡆰𢬼𣗁𣚪𣞇𤟢𥫬𥫱𥭒𦪔𦰭𨔡𩔂])),
					result  => q(dùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[碷])),
					result  => q(dun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙍剟咄哆嚉多夛崜掇敠毲畓裰𡌭𢳽𦍦𧢵𩢎])),
					result  => q(duō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣞䐾凙剫喥夺奪悳敓敚敪痥踱鈬鐸铎鮵𢜬𢼠𤢕𧩧𨀟𨍏𩍜𩑒𪃒𪞝])),
					result  => q(duó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖼㙐㛊㥩㻔䒳䙤䠤䤪䫂䯬亸哚嚲垛垜埵奲憜挅挆朵朶椯綞缍趓躱躲軃鍺𠛫𡶲𡺇𤛛𥿰𦖋𧊱𧙤𨉡𨦃𨲉𨹃𩃒𩬻𪘉])),
					result  => q(duǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛆㻧䅜䑨䙃䤻䩔䲊刴剁堕墮墯尮嶞惰柁柮桗炨舵跢跥跺陊陏飿饳鵽𡓉𡓷𢿎𣑧𣧷𣵺𣵻𤋨𤌃𤤸𤬾𥞛𥳔𧧇𧱫𨆅𨬍𩊜𩎫])),
					result  => q(duò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[枤𦕰])),
					result  => q(duo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䋪妸妿娿婀屙痾钶𠥍𡹣𥑺])),
					result  => q(ē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㼂䄉䕏䖸䩹䱮䳗䳘俄吪囮娥峨峩涐珴皒睋磀莪蛾訛誐譌讹迗鈋锇隲頟額额魤鰪鵝鵞鹅𠷸𡅅𧒎𧔼𧚄𧢽𧽶𧿕𨱂𨶯𩋽𩑁𩣣𩤩])),
					result  => q(é),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[噁枙砈頋騀𣄰𣘨𧙃𨵌𩒰])),
					result  => q(ě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓵㔩㖾㗁㟧㠋㣂㦍㧖㩵㮙㷈䆓䑥䑪䛖䝈䞩䣞䫷䳬偔僫匎卾厄呃呝咢咹噩垩堊堮姶屵岋峉崿廅恶悪惡愕戹扼掠搤搹櫮歞歺湂琧略砐砨硆礘腭苊萼蕚蚅蝁覨詻諤讍谔豟貖軛軶轭遌遏鄂鈪鍔鑩锷閼阏阨阸頞顎颚餓餩饿魥鰐鱷鳄鶚鹗齃齶𠥕𠥜𠰜𠱥𠱫𡀾𡅡𡪑𡪗𡴯𡾙𢃲𢨡𢼚𣢛𣤲𣦵𤂷𤎣𤡾𤪄𤭼𤸱𥋙𥑾𥓈𥔲𥯳𦊪𦛅𧊜𧌄𧍬𧠞𧨟𧭪𧼎𨂁𨃃𨌧𨤕𨸷𨺨𩇠𩉴𩊢𩋊𩐰𩕟𩕬𩖀𩚬𩨮𩪤𩸇𩸋𩸖𩽹𪀝𪅴𪘊𪘐𪙯])),
					result  => q(è),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[擜鵈])),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[誒诶])),
					result  => q(éi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[奀恩煾蒽𡟯𤇯𤫹])),
					result  => q(ēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䅰峎𡵖𡷐])),
					result  => q(ěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䬶䭓䭡摁])),
					result  => q(èn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鞥])),
					result  => q(ēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖇㧫䋩䎟䎠䮘侕儿児兒唲峏栭洏粫而聏胹荋袻輀轜陑隭髵鮞鲕鴯鸸𡦕𣩚𤽓𥅡𦓓𦓔𨎪𩰴𩱊𪕨])),
					result  => q(ér),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚷㢽䋙䌺厼尒-尔栮毦洱爾珥耳薾趰迩邇铒餌饵駬𢀪𦗼𧌣𩚪𩱓𪕔])),
					result  => q(ěr),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒃㛅䎶䏪䣵二佴刵咡弍弐樲衈誀貮貳贰鉺𠚧𢄽𣧹𦖢𪐰])),
					result  => q(èr),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[傠发彂沷発發酦醱𤿓])),
					result  => q(fā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕹㘺䇅䣹乏伐垡姂栰橃浌疺瞂砝筏罚罰罸茷藅閥阀𠞵𤇰𥩱𦪑𨀳𨋺])),
					result  => q(fá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䂲佱法灋𤣹𥎰])),
					result  => q(fǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛲珐琺蕟髪髮𧬋])),
					result  => q(fà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鍅𠲎])),
					result  => q(fa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䪛勫噃嬏帆幡憣旙旛番籓繙翻蕃藩訉轓颿飜鱕𤄫𦪖𧦟])),
					result  => q(fān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠶㸋㺕䀟䉒䊩䋣䋦䌓䕰䪤䫶䭵䮳凡-凣墦忛杋柉棥樊橎渢瀪瀿烦煩燔璠矾礬笲籵緐繁羳膰舧薠蘩蠜襎蹯鐇鐢钒鷭𢐲𢶃𣔶𥢌𥸨𥻫𥼞𥿋𦊻𦨲𧀭𧊾𧢜𨆌𨙮𨟄𩧅𩨏𪖇])),
					result  => q(fán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㽹䛀䡊反払返釩𢗰𦜒])),
					result  => q(fǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕨㛯㤆㴀㶗㼝䀀䉊䐪䒦䣲奿婏嬎梵氾汎泛滼犯畈盕笵範范販贩軓軬飯飰饭𠆩𠒾𡁈𡗹𡜀𡤎𡶉𢇪𣳜𤄑𤬨𤭍𥃵𥅒𥹇𧁉𧉤𧍙𨠒𩡫𩨩])),
					result  => q(fàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[舤])),
					result  => q(fan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䄱匚坊方枋汸淓牥芳蚄邡鈁钫鴋𥫳𩇴𩲌𪕃])),
					result  => q(fāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤃埅妨房肪防魴鰟鲂𩗧𩷸])),
					result  => q(fáng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑂㕫㧍㯐䢍䲱仿倣彷旊昉昘瓬眆紡纺舫訪访髣鶭𣄅])),
					result  => q(fǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[放趽𨾔])),
					result  => q(fàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[堏錺])),
					result  => q(fang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻜㫵䩁啡妃婓扉渄猆緋绯菲蜚裶霏非靟飛飝飞餥馡騑騛鲱𢑮𥇖𦱷𨵈𩇫𩙲𩦎𩹉𪁹])),
					result  => q(fēi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䈈淝肥腓蜰蟦𤷂𥭬𧓖𩇯𩇽])),
					result  => q(féi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥱䕁䨽匪奜悱斐朏棐榧篚翡蕜誹诽𠏿𢾺𣍧𥟍𥠶𦃄𦈗𧍃𧕒𧕿𩄼])),
					result  => q(fěi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔗㩌㵒㹃䆏䉬䑔䒈䕠䚨䛍䠊䤵䨾䰁俷剕厞吠屝废廃廢昲曊杮櫠沸濷狒疿痱癈肺胇芾萉費费鐨镄陫靅鯡鼣𠮆𡌦𢒍𢳁𣙿𤺕𤼺𥄱𥝊𥝋𧌘𧑈𧚆𧝇𨻃𩆦𩇮𩯃𩰾𩱎𩵥𪂏𫂈])),
					result  => q(fèi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[婔暃])),
					result  => q(fei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤋㬟兝兺分吩哛帉昐朆棻氛燓紛纷翂芬衯訜酚鈖雰餴饙𢁤𣬩𣯻𣱦𤔟𦐈𧿚𨳣𨷒𩡷𩢈𩰟])),
					result  => q(fēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㷊㸮䩿䴅坟墳妢岎幩朌枌梤棼橨汾濆炃焚燌羒羵肦蒶蕡蚠蚡豮豶轒鐼隫馚馩魵黂鼖鼢𠛸𢊱𢴢𣸣𥳡𦍏𦍪𦦑𦰛𧮱𧷐𨎾𩉵𩿈])),
					result  => q(fén),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥹粉黺𠵮𡨖𢚅𦶚])),
					result  => q(fěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱵㿎份偾僨奋奮弅忿愤憤瀵秎粪糞膹鱝鲼𠻫𡊄𡊅𢅯𢧝𢹔𤖘𤗸𤘝𤰪𥂙𥹻𥽒𨤘𨤚𩸂])),
					result  => q(fèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[竕躮])),
					result  => q(fen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻛㐽㒥㛔㜂㠦䀱䒠丰仹偑僼凨凬凮妦寷封峯峰崶枫桻楓檒沣沨灃烽犎猦疯瘋盽砜碸篈葑蘴蜂蠭豐鄷酆鋒鏠锋闏霻靊風飌风麷𡨛𡵞𢓱𤖀𥷜𥽈𦜁𧆉𧥹𧾳𨩥𨺢𩉧𩊩𩘵𩙐𩙣])),
					result  => q(fēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦀㵯䏎䙜䩼冯堸夆捀摓浲漨綘艂逢馮𥍮𥛝𧍯𨝭𨲫])),
					result  => q(féng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䟪唪覂諷讽𢇫𦧁𩋮𪐃])),
					result  => q(fěng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡝俸凤奉湗焨煈甮縫缝賵赗鳯鳳鴌𠣡𣿝𥊒𩐯𩪌])),
					result  => q(fèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[溄琒蘕鎽])),
					result  => q(feng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[覅])),
					result  => q(fiào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[仏坲𧥚𧼴])),
					result  => q(fó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[梻])),
					result  => q(fo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𤊻])),
					result  => q(fōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[紑裦𧉈])),
					result  => q(fóu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[否妚殕缶缹缻雬鴀𡜊𤽦𧊦𨛔𩂆])),
					result  => q(fǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕊㩤㭪㲗䃿䄮䎔䓏䓵䱐䴸伕呋垺夫妋姇娐孵尃怤懯敷旉柎玞痡砆稃筟糐紨綒肤膚荂荴衭豧趺跗邞鄜鈇鳺麩麬麱麸𡏪𡫺𡬇𢗲𣘧𣞒𤆮𤙤𥄓𥒫𥱀𥼼𦇁𦖀𦺉𧀮𧀴𨁒𩵩𩽺𩿧𪊐𫓧])),
					result  => q(fū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚕㜑㟊㠅㪄㫙䋹䌿䍖䑧䕎䘠䞞䟮䡍䨗䭮䳕䵾乀伏佛俘冹凫刜匐咈哹垘孚岪巿幅幞弗彿怫扶拂服枎柫栿桴棴榑氟泭洑浮涪澓炥烰玸琈甶畉畐癁砩祓福稪符笰箙粰紱紼絥綍绂绋罘罦翇艀艴芙芣苻茀茯莩菔葍虙蚨蜉蝠袱襆諨踾輻辐郛鉘鉜韍韨颫髴鮄鳧鴔鵩鶝黻𠬝𠲽𡞪𡠞𡦄𢀼𢁀𢂀𢌹𢏍𢒒𢞦𢰆𣀣𣀾𣆵𣑿𣭘𣹋𣻜𣿆𤉨𤝟𤠪𤱽𤶖𥄑𥘬𥦘𥧷𥪋𥪚𥰛𥾧𦊦𦊾𦎭𦐡𦑹𦨈𦨋𦨡𦩡𦮹𦲫𦳓𦽏𦿁𧖚𧥱𧳂𧴌𧼗𧼱𧿳𨌥𨵟𩂔𩂕𩉽𩋟𩋨𩎛𩐚𩓖𩖬𩖼𩜲𩠷𩢰𩳎𫚒])),
					result  => q(fú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓡㕮䋨䌗䗄䩉䫍䫝乶俌俛俯呒嘸府弣抚拊捬撨撫斧滏焤甫盙簠胕腐腑蜅輔辅郙釜釡頫鬴鳬黼𠟌𢗫𢯋𢻀𣥋𤙭𤿭𥒰𦎎𧉊𨑑𩑬𩒙𩳐𪂀])),
					result  => q(fǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻏⻖㙏㚆㤔㤱㬼㳇㷆㽬㾈䂤䒄䒇䔰䘀䝾䞜䞯䞸䟔䠵䦣䨱䭻䮛付偩傅冨副咐圑坿复妇婦媍嬔富峊復椱父祔秿竎緮縛缚腹萯蕧蚥蚹蛗蝜蝮袝複褔覆訃詂讣負賦賻负赋赙赴輹鍑鍢阜阝附陚馥駙驸鮒鰒鲋鳆𠋩𠌽𠓗𠣾𠪻𡐝𡵛𢂆𢠲𣄎𤝔𤭟𤸑𤸗𥨍𥲛𥳇𥷱𦂊𦔍𦰺𦱖𦸱𧄏𧌈𧌓𧒂𧒙𧕡𧻳𨦛𨺅𩂎𩅿𩍏𩒺𩢿𩣜𩣸𩬙𩭺𩵹𩽻𩾿𪀺𪂋𪂾𪃓𪆠𪍏])),
					result  => q(fù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[椨禣覄酜鮲])),
					result  => q(fu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[呷嘎嘠旮𡉅])),
					result  => q(gā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[噶尜錷钆𡼛])),
					result  => q(gá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[尕玍𠁥])),
					result  => q(gǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[尬魀𡯰𡯽])),
					result  => q(gà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱾䀭䐩䬵侅垓姟峐晐畡祴絯荄該该豥賅赅郂陔𧊏𧯺])),
					result  => q(gāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䪱忋改絠𡧣𢍓𢻉𦫻𨮂𨱕𨱣])),
					result  => q(gǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕢㧉㮣䏗丐乢匃匄戤摡杚概槩槪溉漑瓂盖葢蓋賌鈣钙阣隑𠌰𡒖𢅤𨞨𨸛𩕭])),
					result  => q(gài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓧㤌㶥㿻䇞䊻乹乾亁凲坩尲尴尶尷忓攼杆柑泔漧玕甘疳矸竿筸粓肝芉苷迀酐魐鳱𡯋𡶑𢧀𣗲𣦖𤮽𤯌𧾲𨝌𩖦𩚵𩠁𩢨𩴁𩴵𪔆])),
					result  => q(gān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䃭䤗䵟仠感扞擀敢桿橄澉皯秆稈笴簳衦赶趕鰔鱤鳡𠇵𠖫𣘠𥕵𥘏𥰟𥸡𥾍𦪧𦼮𨣝𨳼𩹸𪊄])),
					result  => q(gǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㽏䯎䲺倝凎干幹旰榦檊汵淦灨盰紺绀詌贑贛赣骭𣁖𣆙𣵼𣹟𤌹𦾮𧆐𧹳𩉐𪉿𪊇𪚬])),
					result  => q(gàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺱㧏㭎㼚䚗冈冮刚剛堈堽岡掆杠棡牨犅疘矼綱纲缸罁罓罡肛釭鋼鎠钢𠵹𡇬𢭈𢰌𣦐𤭛𦋳𦱌])),
					result  => q(gāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟠㟵㽘䴚岗崗港𨟼])),
					result  => q(gǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[戅戆槓焵筻𣗵])),
					result  => q(gàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤒䆁䓘槔槹橰櫜滜皋皐睾篙糕羔羙膏臯韟餻高髙鷎鷱鼛𡼗𣓌𣽎𥢐𦍱𦏦𦤎𦺆𧢌𨝲𩏤𪔘])),
					result  => q(gāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚏㚖㵆㾸夰搞暠杲槀槁檺稾稿縞缟菒藁藳镐𤱟𥓖𥢑𧚡𧜉𩓢𩔇𩕍𩫓])),
					result  => q(gǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[勂叝吿告煰祮祰禞筶誥诰郜鋯锆𡋟𡜲𡷥𢍎𢞟𣝏𧠼𩋺])),
					result  => q(gào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤎䔅仡割咯哥圪戈戓戨搁擱歌滒牫牱犵疙纥肐胳袼謌鎶鴐鴚鴿鸽𠛊𠯫𠸲𠺝𡟍𢎄𤇞𤜊𤭻𦨜𧎺𧗶𨝆𨟶𨾓𩢅𩾷𪀁𪀉𪃿])),
					result  => q(gē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖵㗆㠷㦴㭘㵧㷴䈓䐙䗘䘁䛿䨣䪂䪺䫦佮匌呄嗝塥愅挌搿敋格槅滆獦膈臵茖葛蛒裓觡諽輵轕镉閣閤阁隔革鞈鞷韐韚騔骼鬲鮯𠲱𠹓𢆜𢓜𢡍𢧧𢩓𢯹𢼛𣭝𤠇𤩲𥉅𥢸𥴩𥺊𦑜𧈌𧈑𧈖𧊧𧿩𨍮𨏚𨏴𨐥𨞛𨼣𩎎𩢛𩨀𩹺𩹿𩼙𪄎𪌣])),
					result  => q(gé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哿舸𤕒𥰮])),
					result  => q(gě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䧄个個各嗰硌箇虼铬𦓱])),
					result  => q(gè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[彁櫊])),
					result  => q(ge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[給给])),
					result  => q(gěi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[根跟𠛵])),
					result  => q(gēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哏])),
					result  => q(gén),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䫀艮𩒝𩓓])),
					result  => q(gěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㫔㮓亘亙揯茛𠄣𥃩𨒼])),
					result  => q(gèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㹴㹹䎴䢚刯庚搄浭焿畊絚緪縆羮羹耕菮賡赓鶊鹒𦣍𧙸𩜣𩱁𩱋𩱧])),
					result  => q(gēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㾘䋁䌄哽埂峺挭梗綆绠耿莄郠骾鯁鲠𠡣𡩃𢙾𢞚𣆳𥉔𥾚𦛟𦵸𧀙𧋑𩂼])),
					result  => q(gěng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䱍䱎䱭䱴堩暅更𡍷𣈶𣎄𥅨𥔂𦚸𦜷𦞌𧰨])),
					result  => q(gèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[掶椩])),
					result  => q(geng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓚㕬䂵䍔䐵䢼䰸䲲䳍供公功匑厷塨宫宮工幊弓恭愩攻杛熕玜碽糼肱蚣觥觵躬躳髸龏龔龚𠇒𡚑𢁠𢖷𤅐𤱨𥫋𥸲𦄜𦊫𦔸𦞗𦞨𦬘𧆷𧎡𧘏𨉫𨊧𨋝𨋷𨒱𨴛𩃙𩐣𩛘𪏠𪏢])),
					result  => q(gōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤨㧬㫒㭟㺬㼦䂬䡗䱋巩廾拱拲栱汞珙輁鋛鞏𢀜𢸁𤨶𤬳𥧂𥨐𦈩𦓳𨋑𨣂𩌌𫋐])),
					result  => q(gǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓋㔶㯯䇨䔈共唝羾莻貢贡𠌕𠞖𡔕𡟫𥧡𦩼𪄌])),
					result  => q(gòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[慐])),
					result  => q(gong),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡚㽛䑦䬲佝勾沟溝篝緱缑袧褠鈎鉤钩鞲韝𠛎𡗁𣕌𤖮𤫱𥬉𥴴𥿺𦩷𦽋𪚭])),
					result  => q(gōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㺃岣枸狗玽笱耇-耉芶苟蚼豿𡖑𢄇𣕉𣙱𦱣𨩦])),
					result  => q(gǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗕㝅㝤㨌䃓䝭冓坸垢够夠姤媾彀搆撀构構煹茩覯觏訽詬诟購购遘雊𣫌𤚼𤠼𥉇𥧒𦎯𦎼𦵷𧃛𧲿𧵈𩄢𪃺])),
					result  => q(gòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㼋䉉䐻估呱咕唂姑嫴孤柧橭沽泒笟箍箛罛苽菇菰蛄觚軱軲轱辜酤鈲鮕鴣鸪𠷞𠽿𡗷𢡇𣀐𥂰𥿍𦊬𦋆𦺠𧆻𧇡𧬕𨠋𨬕𨱃𨸯])),
					result  => q(gū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䜼䮩鶻𦎰𧳸])),
					result  => q(gú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻣㒴㚉㯏㾶䀇䀜䀦䀰䐨䵻䶜古唃啒嘏夃尳愲扢榖榾毂汩淈濲瀔牯皷皼盬瞽穀糓縎罟羖股脵臌蓇薣蛊蛌蠱詁诂谷轂鈷钴餶馉骨鹄鹘鼓鼔𠑹𠻧𡷓𡽂𢝳𣖫𣦩𣦭𣨍𣨺𣫀𣱫𤅱𤚱𥐬𥠳𥮝𥵠𦈔𦍩𦾫𧟣𧣡𧵎𨪷𨵐𩙏𩲱𪇗𪕷])),
					result  => q(gǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧽㽽䍛䓢僱凅固堌崓崮故梏棝牿痼祻稒錮锢雇顧顾鯝鲴𣪸𩴡])),
					result  => q(gù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[傦峠篐逧])),
					result  => q(gu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧓㶽䏦䒷䫚䯄䯏刮劀栝歄煱瓜緺聒胍趏踻銽颳騧鴰鸹𠛒𠜵𠟗𠯑𠵯𡜁𥄼𥈓𧿼𨵃𩢍𩻎])),
					result  => q(guā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𪇜])),
					result  => q(guá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒷䈑冎剐剮叧寡𠆣𠈥𠊰𠙼𠮠𣅻𧤐])),
					result  => q(guǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[卦啩坬挂掛絓罣罫褂詿诖𤆜𥝒𦊱])),
					result  => q(guà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[颪])),
					result  => q(gua),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㾩䂷乖掴摑𠛕𠦬𡇸𡧩𦮃𧱾])),
					result  => q(guāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[拐枴柺箉𦫳𧊅])),
					result  => q(guǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧔䂯䊽叏夬怪恠𡌪𡖪𢶒𣲾𥑋𥑰𧴚𩶦])),
					result  => q(guài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䚪䤽倌关冠官棺瘝癏窤蒄覌観觀观関闗關鰥鱞鳏𠴨𡅭𡠒𡭷𢇇𢉂𢺄𥈒𥍅𥎅𥜄𥷬𥿑𦺊𨷀𩖒])),
					result  => q(guān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䏓䗆䘾䦎䩪䪀䲘琯痯筦管舘莞輨錧館馆鳤𦛤𨵄])),
					result  => q(guǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㮡㴦䎚䗰䙛䙮䝺丱悹悺惯慣掼摜樌毌泴涫潅灌爟瓘盥矔礶祼罆罐貫贯遦鏆鑵雚鱹鸛鹳𠬆𣥥𣩔𣬂𤼐𥉀𥊫𨝑𨱌𪈸])),
					result  => q(guàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[侊僙光咣垙姯桄洸灮炗炚炛烡胱茪輄銧黆𤖖𧻺𨎩𨐈𨶰𩒚𩧉𪕓])),
					result  => q(guāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[广広廣犷獷臩𠏤𤳭𤴀𥀱𪇵])),
					result  => q(guǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤮㫛俇撗珖臦逛𢓯𦢎𨤡𩑈])),
					result  => q(guàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[欟])),
					result  => q(guang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻱⻲㰪䅅䲅亀傀圭妫媯嫢嬀巂帰廆归摫椝槻槼櫷歸珪瑰璝瓌皈硅窐胿膭茥螝袿規规邽郌閨闺騩鬶鬹鮭鲑龜龟𡃩𡌲𡹙𢄊𢻂𤼮𥇳𥈸𥍁𥦣𦓯𦤇𧷱𨾚𨾴𩓠𪄯𪆳𪈥𪊧])),
					result  => q(guī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻤㔳㧪㨳㲹㸵䃽䍯䞨䣀䤥佹匦匭厬垝姽宄庋庪恑攱晷朹氿湀癸瞡祪簋蛫蟡觤詭诡軌轨陒鬼𠱓𡷺𢃯𣢪𣪕𣷾𤘧𥍨𥥠𦳛𧊄𩊛𩱻𩲡𩳧𪀗])),
					result  => q(guǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪈䁛䈐䌆䐴䝿䞈䠩䳏刽刿劊劌匱嶡撌攰昋柜桂桧椢槶檜櫃炔猤癐瞶禬筀簂蓕襘貴贵跪鞼鱖鱥鳜𠐽𠪑𡗤𡧭𡬂𢠿𣄜𣦦𣧎𤡱𤱺𤱾𤲉𤻿𤿡𥎛𥜏𧡫𧹑𧻜𨇙𨋡𨲿𩉝𩍨𩏐𩏡𩔆𩪁𩳝𪏤])),
					result  => q(guì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨰㯻䃂䎾䜇丨惃滚滾磙緄绲蓘蔉衮袞袬輥辊鮌鯀鲧𠃌𡈧𡘝𢃩𣮎𥕦𦓼𦠺𦫎𩨬𩩌])),
					result  => q(gǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙥䵪棍璭睔睴謴𠞬𡻨𧬪𧸫])),
					result  => q(gùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗻㳡㿆呙咼啯嘓埚堝墎崞彉彍濄瘑蝈蟈郭鈛鍋锅𡓣𣁯𣂄𣽅𣽰𥂣𦗒𦘌𦬗𨽏𩫏𩰬𩰭𪆹𪈃])),
					result  => q(guō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕵㶁䂸䆐䬎囯囶囻国圀國帼幗慖漍聝腘膕蔮虢馘𠩥𠿤𡇄𢐚𢧰𢸗𢹖𤂁𤮋𥄍𥆘𦄰𦛢𦸈𧖻𧤯𧭕𧭣𧰒𧾛𨉹𨭗𩉕𩪐])),
					result  => q(guó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䙨䴹惈果椁槨淉猓粿綶菓蜾裹輠錁鐹餜馃𠜴𢃦𥁁𥕖𥜭𩋗𩻧𪂠𪋊])),
					result  => q(guǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㳀过過𠋜𢅗𢝸𧒖𧥵𩟂])),
					result  => q(guò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哈铪𨉣])),
					result  => q(hā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[蛤𡄟])),
					result  => q(há),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[奤])),
					result  => q(hǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[丷])),
					result  => q(ha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨟㰧㰩㱼㾂咍咳嗨𣢇𨸜])),
					result  => q(hāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜾䠽䯐䱺孩还還頦骸𠹛𧻲𧽊𧽖𩠚𩰶])),
					result  => q(hái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[海烸胲酼醢𣖻𣳠𥁐𥂧𨡬])),
					result  => q(hǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤥㧡㺔䇋亥嗐妎害氦餀饚駭骇𠀅𠔑𡕗𡾨𢞐𢩸𢻜𤵽𥩤𥩲𦐤𦤦𦤬𦷷𨀖𩞞𩡔𩪃𩹄])),
					result  => q(hài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嚡塰])),
					result  => q(hai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤷䘶䣻佄嫨憨歛炶蚶谽酣頇顸馠鼾𠵸𡬖𣝽𣢅𣢺𤞶𤸕𧭻𧮰𧮳𧵊𧹣𩈣])),
					result  => q(hān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖤㟏㟔㮀㶰㼨䈄䎏䗙䤴䥁䨡䶃函凾含咁唅圅娢寒崡嵅晗梒浛涵澏焓琀甝筨肣虷蜬邗邯鋡韓韩魽𠗴𠤮𠤾𠥴𠦊𠲒𠿑𡇜𢔈𣘞𣢟𣵷𤬯𤭙𥀐𥆡𦜆𦞞𦥖𦺦𧃙𧑚𩄙𩦊𫒶])),
					result  => q(hán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘎㘕㘚㸁㺖䍐䍑䓍丆厈喊浫罕蔊豃阚鬫𠽦𣛴𦒝𧯘𧾔])),
					result  => q(hǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑵㒈㢨㨔㪋㲦㵄㺝䎯䏷䓿䕿䗣䛞䧲䫲䮧傼哻垾屽岾悍憾捍撖撼旱晘晥暵汉汗涆漢瀚焊熯猂皔睅翰莟菡蘫蛿蜭螒譀貋釬銲鋎閈闬雗頷顄颔馯駻鶾𠢇𠹄𡁀𡣔𡷛𡻡𢀵𢃗𢄜𢇞𢎘𢔔𢧦𣐺𣒷𤀉𤌐𤳉𤿧𥇌𥉰𦋣𦒅𧂃𧰪𨁄𨛎𨢈𨸗𩎒𩕠𩖺𩗤𩞿𩭥𩹑𩹼𩾝𫘣])),
					result  => q(hàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[兯爳])),
					result  => q(han),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㰠䂫䦭夯𠡊𤵻𩠾𩲋𪐦𪕇])),
					result  => q(hāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤚䀪䘕䲳斻杭珩笐筕絎绗航苀蚢貥迒頏颃魧𤼍𦐄𦨵𧘃𧦑𨁈𨾒𪗜])),
					result  => q(háng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䟘䣈沆𡕧𤰟𥮕𩔋])),
					result  => q(hàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[垳])),
					result  => q(hang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嚆茠蒿薅薧𡽝𢻇𣭖𣭹𤡇𤢨𧯌𩮘])),
					result  => q(hāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠙㩝㬔䝥䧫儫嗥嘷噑嚎壕椃毜毫濠獆獋獔籇蚝蠔諕譹豪貉𠚃𠢕𡐒𣘫𤀃𤢭𨂜𨒑𨚙𨼍𩐮𩖸𩫕])),
					result  => q(háo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[好郝𡥆𤫧])),
					result  => q(hǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘪㙱㚪㝀㞻㬶䒵䚽䝞䧚䪽䯫傐号哠峼恏悎昊昦晧暤暭曍浩淏滈澔灏灝皓皜皞皡皥秏耗聕薃號鄗鎬顥颢鰝𡚌𡚽𡠖𣆧𣚧𤝐𤩩𤩭𥍣𦳁𧇼𧬁𨚮𨠬𩲊])),
					result  => q(hào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[竓])),
					result  => q(hao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㰤㿣䏜䶎喝嗬抲欱蠚訶诃𠀀𠳊𠵩𢥳𣣹𥘫𦘿𩐥𩑸𪖲])),
					result  => q(hē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕡㗿㥺㪃㪉㭱㮝㮫㹇㿥䃒䅂䒩䕣䞦䢔䫘䮤䶅何劾厒合咊和哬啝姀峆惒敆曷柇核楁毼河涸渮澕熆狢皬盇盉盍盒礉禾秴篕籺紇翮荷菏萂蚵螛覈訸詥貈輅郃鉌鑉闔阂阖鞨頜颌饸魺鲄鶡鹖麧齕龁龢𠘢𠚔𠧕𠰓𠳇𠶹𠻙𡇞𡇶𢄍𣏷𣲲𣿌𤈧𤖱𥝖𥝸𥞄𥞍𥟃𥻉𥽶𦃔𦇸𦒏𦛘𦛜𦳬𦼵𧇎𧇮𧊬𧝳𧪞𧭳𧮵𨋟𨍇𨜱𨜴𨨛𨴢𩅢𩌡𩩲𪈊𪘹])),
					result  => q(hé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬞㵑㷎䚂䳽佫嗃垎壑焃煂熇爀癋碋穒翯袔褐謞賀贺赫靎靏鶮鶴鸖鹤𠗂𠡀𠶾𡫥𢅰𢬲𣆈𤌾𥋿𦺞𦽅𧀔𧝂𧨂𧬂𧬱𧯉𩄸𩩒𩵢])),
					result  => q(hè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[粭靍])),
					result  => q(he),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱄嘿潶黑黒𢖛𢡀𥕙𨭆𩻤])),
					result  => q(hēi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㯊拫痕鞎𦚣])),
					result  => q(hén),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䓳佷很狠詪])),
					result  => q(hěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[恨])),
					result  => q(hèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[亨哼啈悙脝𣨉𦨾])),
					result  => q(hēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔰㶇䬖䬝䯒姮恆恒桁横橫烆胻蘅衡鑅鴴鸻𠔲𠧿𡧦𤮏𥞧𦶙𧝒𩙯𪏓])),
					result  => q(héng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[堼])),
					result  => q(hèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[涥鵆])),
					result  => q(heng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[噷])),
					result  => q(hm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䆪䎕叿吽呍哄嚝揈渹灴烘焢硡薨訇谾軣輷轟轰鍧𠐿𠹅𢝻𤃫𤟼𥓰𥔀𥕗𦐳𦑟𦑠𦒃𦕠𨌁𨎗𩐠𩒼𩓅𩖉𩗄𩘇𩙛𪈘])),
					result  => q(hōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖓㗢㢬䃔䆖䉺䞑䡌䡏䧆䨎䩑䪦䫹䫺䲨仜吰垬妅娂宏宖峵弘彋汯泓洪浤渱潂玒硔竑竤粠紅紘紭綋红纮翃翝耾苰荭葒葓蕻虹谹谼鈜鉷鋐閎闳霐霟鞃魟鴻鸿黉黌𠪷𠲓𡇳𡵓𢂔𢘌𢬀𤂲𤄏𥏕𥥈𦁷𦏺𦐌𧈽𧐬𧮴𨌆𨥺𨹁𨾊𩘎𫚉])),
					result  => q(hóng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬴䀧嗊晎𢗵𢦅𢼦𣽝𨢣𩒓𩕆𩕉])),
					result  => q(hǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㶹撔澋澒訌讧銾閧闂鬨𠳃𡺭𥈿𥥡𥰲𦕷𦶓𧊯𧋔𧾧𩒴𩗢𩰓])),
					result  => q(hòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[齁𠯜𩙡𪅺𪖙])),
					result  => q(hōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗋㤧㬋㮢㺅䂉䗔䙈䫛䳧侯喉帿猴瘊睺矦篌糇翭翵葔鄇鍭餱骺鯸𡞥𡟑𡹵𢜴𣔹𣣠𣣡𥈑𥚦𦑚𦚥𦞈𦞕𧇹𧮶𧼵𩃺𪃶𪑻])),
					result  => q(hóu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖃㸸吼犼𠴣𤘽𤙽𦍵𧻿])),
					result  => q(hǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㫗䞀䞧䪷候厚后垕堠後洉豞逅郈鮜鱟鲎鲘𠷋𥀃𥅠𧙺𧩨𩄬𩘋𪄗𪇂])),
					result  => q(hòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦆㦌㧮㧾㫚㳷㺀䓤䨚䩐䬍䰧䴣䴯乎乯匢匫呼唿嘑垀寣幠忽恗惚戯昒曶歑泘淴滹烀膴苸虍虖謼軤轷雐𠥰𠦪𡧥𡱽𡼘𢑢𢽨𣓗𣡾𤇠𤎲𤐀𤶘𥇰𦁕𦩕𧇛𧠩𧢰𧦝𧩓𨕚𨖃𩂂𩖨𩳨𩶈])),
					result  => q(hū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗅㪶㯛㽇㾰䁫䈸䉿䊀䎁䚛䞱䠒䧼䩴䭅䭌䭍喖嘝囫壶壷壺媩弧抇搰斛楜槲湖瀫焀煳狐猢瑚瓳箶糊絗縠胡葫蔛蝴螜衚觳醐鍸隺頶餬鬍魱鰗鵠鶘鶦鹕𠴱𡍐𡰅𡹹𢉢𢎵𢏯𢑹𢪏𣄟𣎚𣙶𣛫𣝗𣫈𣹬𤌍𤘵𤝘𤞲𤭱𤾅𥂤𥐿𥰪𥶜𥷆𥾨𦊧𦏗𦖼𦗣𦧘𦴉𦷳𦺟𧇰𧍵𧛞𧞒𧣼𧲥𧹾𧻰𨍲𨢋𨣗𨴬𩑶𩢪𩨔𩰯𩱍𩵬𩾻𪂒𪏻𪕉𪕮𪕱𪙈])),
					result  => q(hú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻁䗂乕俿唬汻浒滸琥萀虎虝𧆢𧆮𧌧𧰴𨛵𨝘])),
					result  => q(hǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕆㨭㷤㸦㺉䇘䊺䍓䕶䨼䪝乥互冱冴嗀嚛婟嫭嫮岵帍弖怘怙戶-戸戽扈护摢昈枑楛槴沍沪滬熩瓠祜笏簄綔芐蔰護鄠鍙雽韄頀鱯鳠鳸鸌鹱𠯳𠰛𡜂𡞠𡴱𡵘𡻮𢆰𢚪𢨥𢨦𣑂𣲑𤘔𤜷𤨖𤹣𥢟𥲉𦊂𦊘𦬚𦭈𧂔𧅰𧆯𧗌𧘢𧥮𧥯𧦚𧲇𧹲𧿓𧿠𨝞𨢤𨥛𨱀𪄮𪍂𪏳])),
					result  => q(hù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[粐錿鯱𩾇])),
					result  => q(hu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㳸哗嘩花芲蒊錵𠝐𡁑𤙕𦧹𦶎𨣄𨶱𩝨])),
					result  => q(huā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕲㟆㠏㦊㭉䔢䱻䴳䶤华姡搳撶滑猾磆華蕐螖譁釪釫鋘鏵铧驊骅鷨𠳂𢼤𤁪𥉄𥢮𦧠𦽊𧑍𧨋𧽌𩤉𪉊])),
					result  => q(huá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓰㕦㕷㚌䀨䇈䋀䛡划劃化夻婳嫿嬅崋摦杹桦槬樺澅画畫畵繣舙觟話諣譮话黊𠤎𠿜𢄶𢦚𣶩𥒶𥧰𦁊𦖍𦧵𦪠𨶬𩂤𩗐𩲏𩵏𩸄])),
					result  => q(huà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[埖婲椛璍硴糀誮])),
					result  => q(hua),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜳㠢䃶徊怀懐懷槐櫰淮瀤耲蘹褢褱踝𩌃𪊉])),
					result  => q(huái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[咶坏壊壞蘾諙𣟉𣩹𣸎𤜄𦏨𦧬𧱳𩟮])),
					result  => q(huài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㹕嚾懽欢歓歡犿獾讙貛酄驩鴅鵍𠂄𡚊𡚜𣌓𤛚𥐓𥹚𨽧𩦘𩵄𩿊𪈩])),
					result  => q(huān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡲㵹㶎㿪䝠䥧䦡䭴䴉䴋䴟圜嬛寏寰峘桓洹澴狟环環瓛糫絙綄繯缳羦荁萈萑豲貆轘郇鉮鍰鐶锾镮闤阛雈鬟鹮𠟼𡄤𡍦𡘍𡩂𡱌𢟿𤩽𦣴𦻃𦼉𨕹𩍡𩑖𩙽𩡧𪊥𪍺])),
					result  => q(huán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣪䈠攌緩缓𤀣𤼢𥶍𦑛𧡩])),
					result  => q(huǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕕㪱㬇㬊㹖㼫䀓䆠䍺䒛䠉䯘唤喚喛奂奐宦嵈幻患愌换換擐梙槵浣涣渙漶澣烉焕煥瑍痪瘓睆肒藧豢逭鯇鰀鲩𠺐𠻍𡅱𡅻𡷗𤡟𤢁𤴯𤽅𤽕𥈉𥏇𥠅𦌦𦝝𧚁𧴊𨜌])),
					result  => q(huàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[瞣])),
					result  => q(huan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠵㡃㬻䀮塃巟慌朚肓荒衁𡜋𡡄𡿰𢁹𢇟𣆖𣺬𤆴𤠛𤭉𥿪𧖬𧠬𨚳𩢯𪀞])),
					result  => q(huāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻩㞷㾮䄓䅣䅿䊗䊣䍿䑟䞹䪄䮲䳨偟兤凰喤堭墴媓崲徨惶楻湟潢煌熿獚瑝璜癀皇磺穔篁篊簧艎葟蝗蟥諻趪遑鍠鐄锽隍韹餭騜鰉鱑鳇鷬黃黄𠂸𡉚𤚝𤛥𤯷𤾑𦡽𦪗𧕸𨉤𨍧𨜔𨝴𨱑𩞩𪏍𪏒𪏙𫗮])),
					result  => q(huáng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤺䐠奛宺幌怳恍晃晄櫎炾熀詤謊谎𡧽𣄙𣉪𦟮𦵽])),
					result  => q(huǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨪㿠䁜䌙愰曂榥滉皝皩鎤𥫼𨉁])),
					result  => q(huàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[縨])),
					result  => q(huang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞀㧑㫎㷇㹆㾯䖶䜐䝅咴噅噕婎媈幑徽恢拻挥揮撝晖暉楎洃瀈灰烣煇珲睳禈翚翬蘳虺袆褘詼诙豗輝辉隓隳鰴麾𠓊𠯠𡒾𡯥𢀡𢊄𣄓𤕚𤟤𤾈𥃌𥌍𦭹𧉇𧗼𧳐𨦗𩻟𪀬𪈑𪏏𪑀𪖕])),
					result  => q(huī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[佪囘回囬廻廽恛洄烠痐茴蚘蛔蛕蜖迴逥鮰𠲛𡋙𡰋𡹎𤜡𨛤𩢱𪀟𪛂𫚔])),
					result  => q(huí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩓㷄㷐䃣䏨䛼悔檓毀毁毇燬譭𡢕𡭛𣸀𤃽𤈦𤌋𥊔𥶵𥸃𦞙𦽐𧗏𩃾𩗝𩶥𪏇])),
					result  => q(huǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑰㑹㜇㞧㤬㥣㨤㨹㩨㬩㱱㻅䂕䅏䌇䕇䛛䜋䤧䧥䩈䫭会僡儶匯卉哕喙嘒噦嚖圚嬒孈寭彗彙彚徻恚恵惠慧憓晦暳會槥橞櫘殨汇泋浍湏滙潓澮濊烩燴獩璯瘣瞺秽穢篲絵繢繪绘缋翙翽芔荟蔧蕙薈薉藱蟪詯誨諱譓譿讳诲賄贿鏸鐬闠阓靧頮顪颒餯𠍗𠧩𠽡𠿔𡏁𡜦𡥋𡹯𢄣𢅫𢊇𢕺𢟾𢻔𣋘𣨶𤆳𤜋𤸁𥀠𥔯𥱵𥴯𦂆𦒎𦡖𧏧𧖢𧧾𧬨𧭾𨊢𨍹𨗥𨘇𨘲𨵘𩆁𩇻𩒏𩒳𩔁𪊂𪔊])),
					result  => q(huì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[屷懳灳璤𣌭])),
					result  => q(hui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖧䎜䡣婚惛昏昬棔殙涽睧睯荤葷閽阍𠉣𡨩𣇲𣣏𧠚𩅴])),
					result  => q(hūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑮㨡㮯䊐䮝䰟䴷堚忶梡浑渾琿繉轋餛馄魂鼲𣝂𣨿𦟲𨋨𨏂𩧰𪌽])),
					result  => q(hún),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鯶𦃕𩽼𪑕])),
					result  => q(hǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥵䅙䅱䚠䛰䧰䫟俒倱圂慁掍混溷焝觨諢诨𡇯𣣞𦞢𦡵𦵣𧣢𨂱𨡫𩇇𩏖])),
					result  => q(hùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䦝剨劐吙嚄攉耠豁鍃锪騞𨷮𩭳])),
					result  => q(huō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䄆䄑䣶佸活秮秳𡯢𢋒𤻙𦨯𧵻])),
					result  => q(huó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[伙夥漷火邩鈥钬𤆄𤬁])),
					result  => q(huǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓉㖪㗲㘞㦎㦜㦯㨯㩇㯉㸌㺢䁨䂄䄀䉟䐸䨥䬉䰥䱛俰咟嚯嚿奯惑或捇掝旤曤楇檴沎湱濩瀖獲癨眓矆矐砉祸禍穫耯臛艧获蒦藿蠖謋貨货鑊镬閄霍靃𠙞𠯐𠵾𡄴𡓘𡪞𡿿𢃎𢛯𢝇𢞕𣄸𣉒𣤨𤁹𤊴𤏘𤐰𥇙𥊮𥒠𥙨𥝂𥽥𦑌𦒧𦞦𧆑𧤴𧯆𧯱𨐶𨘌𨙀𩆀𩞺𩟨𩟸𩪭𪒩])),
					result  => q(huò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚻㛷㦘㫷㮷䁶䂑䇫䐚䕤䗗䛴䟇丌乩僟击刉刏剞勣叽咭唧喞嗘嘰圾基墼姫姬屐嵆嵇擊敧朞机枅槣機櫅毄激犄玑璣畸畿癪矶磯禨积稘稽積笄筓箕簊緝績绩缉羁羇羈耭肌芨虀襀覉覊觭譏譤讥賫賷赍跡跻蹟躋躸迹鄿銈錤鐖鑇鑙隮雞鞿韲飢饑饥鳮鶏鷄鸄鸡齎齏齑𠀷𠋻𠍃𠔋𠚽𠟣𠴩𠷌𠼻𡇟𡫀𡳮𡿙𢁂𢆻𢡴𢨐𢩦𢼋𣇳𣪠𣬠𣰈𤋭𤌿𤳎𥘌𥡒𥨿𥫶𥰦𥳏𥺵𦌰𦠄𦳌𦺬𦼷𦿓𧐐𧗒𧫠𨅤𨊻𨍺𨐆𨮺𨲪𨳻𨹶𨻕𩉜𩐆𩚮𩜆𩠨𩨒𪅹𪌍𪔋𫌀])),
					result  => q(jī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔕㗊㗱㘍㙫㠍㠎㡮㤂㥛㧀㭲㲺㴕㻷㽺㾊䁒䐕䚐䞘䟌䣢䩯䲯䳭亟亼伋佶偮卙即卽及吉塉姞嫉岌嶯庴彶忣急愱戢揤撃擮极棘楫極槉橶檝殛汲湒潗濈焏狤疾瘠皀皍禝笈箿籍級级耤脊膌艥蒺蕀蕺藉螏襋觙诘谻趌踖蹐輯轚辑郆銡鍓鏶钑集雦雧霵鶺鷑鹡𠑃𠓞𠗏𠦫𠨠𠫷𠯉𠶻𠹋𠿠𡁰𡃃𡅺𡦪𡹪𢃺𢉗𢏞𢰒𢱣𣏡𣖷𣛔𣜇𣣝𣳃𣹜𤊵𤎗𤠎𤷉𤺷𤿠𥈂𥊬𥋥𥒡𥕂𥖙𥠋𦎢𦝖𦠾𦩧𦵾𦶍𦺩𦺴𧉆𧉍𧎿𧤏𧥄𧧩𧩦𧪠𧮭𧽑𨋉𨤹𨦮𨪏𨸚𩀖𩦤𩴃𪂺𪄸])),
					result  => q(jí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚡㞆㞛㞦㦸㨈㴉䍤䢳丮几妀嵴己幾戟挤掎撠擠泲犱穖虮蟣鈘魕魢鱾麂𠮯𠱨𢓄𢜭𤜝𤜾𥪼𥾊𧾾𨄐𨒴𨳋𩉢𩯋𪂍])),
					result  => q(jǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺔⺕㑧㒫㙨㞃㠱㡭㥍㮨㰟㲅㳵㸄㹄㻑㾵䀈䋟䐀䓽䗁䛋䜞䝸䠏䢋䤒䦇䨖䮺䰏䶓䶩伎偈兾冀剂剤劑哜嚌坖垍塈妓季寂寄峜彐彑徛忌悸惎懻技旡-旣暨暩曁梞檕檵洎济済漃漈濟瀱痵癠祭稩稷穄穊穧紀紒継繋繼纪继罽臮芰茍茤荠葪蓟蔇薊薺蘎蘮蘻裚褀覬觊計記誋諅计记跽际際霁霽驥骥髻鬾鯚鰶鰿鱀鱭鲚鲫鵋齌𠨕𠲹𠴫𠿉𡁪𡋚𡜱𡥞𡦊𡪱𡬄𡽉𢍇𢗂𢗹𢚁𢭄𢺼𢼷𣄯𣄱𣔽𣯅𣱗𣽍𤓑𤛄𤤋𤫝𤵀𥡴𥣩𥪫𥭋𥭌𥭜𥷙𦁳𦂑𦆡𦇧𦋋𦌗𦜸𦪱𦮯𦮼𦺶𦾲𧃞𧇯𧓓𧟜𧡉𧡯𧢾𧧃𧧟𧪇𧫜𧾽𨀶𨂢𨛉𨛑𨜒𨢵𨣧𩓮𩞊𩥉𩧱𩩛𩼄𩼚𪄵𪊆𪘥])),
					result  => q(jì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[亽廭樭])),
					result  => q(ji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚙㹢䂟䕒䴥乫伽佳傢加嘉埉夹夾家抸拁枷梜毠泇浃浹犌猳珈痂笳耞腵茄葭袈豭貑跏迦鉫鉿鎵镓麚𠷉𠺢𡩚𡭘𡶥𣪇𣮫𤟚𤠙𥝿𥡮𥹌𦎮𦣯𧉪𧦤𨔗𨔣𩊏𩶛𪐓𪔟])),
					result  => q(jiā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕅㪴㮖㿓䀫䕛䛟䩡唊圿忦恝戛戞扴荚莢蛱蛺袷裌跲郏郟鋏铗鞂頬頰颊餄鴶鵊𡊠𢫢𥇗𥑔𥞵𦎱𦧮𦸘𦺧𦽤𧿵𨒇𩉡𩚲𩛩𩠃𪇷𪈟])),
					result  => q(jiá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䑝仮假叚婽岬徦斚斝椵榎槚檟玾甲瘕胛賈贾鉀钾𣦉𤖰𤗜𥑐𩌍𩨹𩲣𪆲])),
					result  => q(jiǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[价價嫁幏架榢稼駕驾𢉤𢜿𢱈𢱌𥋣𦙺𦨦])),
					result  => q(jià),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[糘])),
					result  => q(jia),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓺㔋㡨㦰㭴䌑䌠䓸䔐䘋䶢䶬偂兼冿囏坚堅奸姦姧尖幵惤戋戔搛椷椾樫櫼歼殲湔瀐瀸煎熞熸牋犍猏玪瑊监監睷碊礛笺箋篯緘縑缄缣肩艰艱菅菺葌蒹蕑蕳虃覸豜豣鐧鑯間间鞬鞯韀韉餰馢鰹鲣鳒鳽鵳鶼鹣麉𠫘𠼤𠿏𡄑𡬵𢃬𢐆𢦺𢨿𢳚𣘖𣘷𣚙𣝕𣮏𣽖𤍖𤪋𥊇𥌈𥡝𦋰𦏔𦣨𦽇𧂢𧢖𧤨𧥈𧲨𨔥𨳡𨳿𨴾𩅼𩆷𩇏𩋋𩌯𩍎𩛧𩱃𪏊𪐻𪒹])),
					result  => q(jiān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔓㨵㳨㶕䄯䅐䉍䚊䟰䭠䮿䵡䵤䶠俭倹儉减剪劗囝堿弿戩戬拣挸捡揀揃撿暕枧柬梘检検檢減湕瀽瑐睑瞼硷碱礆笕筧简簡籛絸繭翦茧藆蠒裥襇襉襺詃謇謭譾谫趼蹇鐗锏鬋鰎鹸鹻鹼𠍚𠏇𠐻𠹟𠽱𡄓𡅶𡑯𡭭𡾰𢆞𢍫𢩀𢵈𣜭𣠷𣥞𣳲𤄒𥀹𥍀𥍹𥢇𥳒𥳟𥳷𦁲𦂇𦢣𦺍𦺘𧀇𧅆𧬫𧮈𨢑𨣇𨤄𨰓𩉍𩟗𩽜𪒫])),
					result  => q(jiǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻅㣤㨴㯺㰄㵎䇟䟅䤔䥜䧖䬻䭈䯡件俴健僭剑剣剱劍劎劒劔寋建徤擶旔栫楗榗毽洊涧渐溅漸澗濺瀳牮珔瞷磵箭糋繝腱臶舰艦荐葥蔪薦螹袸見覵见諓諫譼谏賎賤贱趝践踐踺轞釼鉴鋻鍳鍵鏩鐱鑑鑒鑬鑳键餞饯𠊒𢆦𣴓𣽦𤀩𤧣𤷃𥯦𥴱𥽐𦩵𦾶𧀵𧂂𧂆𧗸𧙧𨎫𨏊𨪅𨵭𨷓𩉔𩻘𪃛𪆿𪉦𪋁𪙨])),
					result  => q(jiàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[墹彅橺殱礀])),
					result  => q(jian),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㹔䗵䜫僵壃姜将將摪橿殭江浆漿畕畺疅疆礓繮缰翞茳葁薑螀螿豇韁鱂鳉𠘌𡷍𢪇𤕭𤕯𤛜𥆅𥔣𥗪𥬮𦦗𧘍𨃇𨜰])),
					result  => q(jiāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢡㯍䁰䉃䋌䒂傋奖奨奬桨槳獎耩膙蒋蔣講讲顜𡏞𡑶𣫳𤖛𥷃𩌾])),
					result  => q(jiǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䞪䥒勥匞匠夅嵹弜弶彊摾洚滰犟糡糨絳绛袶謽酱醤醬降𠼢𡲣𢘸𣚦𣨣𣩴𥞜𨯞𩝽𩴒𩷄𩷭𪀘])),
					result  => q(jiàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[杢櫤])),
					result  => q(jiang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㲬㶀䌭䍊䢒䴔䶰交僬嘄姣娇嬌峧嶕嶣憍椒浇澆焦燋礁穚簥胶膠膲艽芁茭茮蕉虠蛟蟭跤轇郊鐎驕骄鮫鲛鵁鷍鷦鷮鹪𠝑𠩏𡏭𡓖𡟠𢧱𣝞𣺳𥃪𥄉𥉼𥹜𦅃𦌆𦫶𧣦𨎦𨓩𨨴𨱓𨶲𨸋𩎔𩴧𩵰𩿑𪁉𪚰])),
					result  => q(jiāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩰㭂㳅㽱㽲䀊䘨䚩䥞佼侥僥儌剿劋孂徺徼恔憿挢捁搅摷撟撹攪敫敽敿晈暞曒湫湬灚烄煍燞狡璬皎皦矫矯絞繳绞缴脚腳臫蟜角譑賋踋鉸铰隦餃饺鱎𠕧𠜅𠞰𡙎𢀌𢄺𢅎𢯴𢻟𣁹𣏑𣧦𣩓𤃭𤉧𤶀𤶳𥂨𥃤𥅟𥇟𥉒𥏹𥳴𦗵𧂈𧎙𧎸𨇕𨖵𨝰𨶟𨶪𨺹])),
					result  => q(jiǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠐㬭㰾䂃叫呌嘂嘦噍噭嬓峤嶠挍敎教斠滘漖潐獥珓皭窌窖藠訆譥趭較轎轿较酵醮釂𠘣𡥈𡬋𢒾𢕪𢥚𢼫𤕝𤫷𥘊𥡤𥦢𦮁𧺜𧾐𨎬𨡃𨲭𩊔𩯘𩱞𪖄])),
					result  => q(jiào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[櫵纐鵤])),
					result  => q(jiao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㫸䃈䕸䥛䦈喈嗟堦媘嫅接掲揭擑椄湝煯疖痎癤皆秸稭脻菨蝔街謯阶階鶛𠙤𣶏𤭧𤮌𥷫𦁉𦈰𦝨𧞝𩘅𩩰𪉚])),
					result  => q(jiē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺋㓗㔚㘶㛃㞯㦢㨗㨩㮞㮮㸅㼪䀷䀹䂝䂶䅥䌖䕙䗻䣠䲙倢偼傑刦刧刼劫劼卩卪喼婕孑尐岊崨嵥巀幯截拮捷昅杰桀楬楶榤櫭洁滐潔疌睫碣竭節結絜结羯节莭蓵蜐蝍蠘蠞蠽衱袺訐詰誱讦踕迼鉣鍻鞊颉魝鮚鲒𠂈𠄍𠅂𠐉𠬮𠯙𡉷𡔣𡙣𡣯𡨲𡩣𡵒𡸎𡽱𢈻𢎔𢎡𢢂𢨜𢪍𢫐𢬱𢱄𢷿𢻮𣙴𣚃𣮌𣮍𣰞𣳟𤁢𥁂𥅴𥇒𥓐𥝔𥝥𥠹𥢻𥵞𥾌𦀖𦈜𦎒𦵴𦺢𦿐𧍠𧍩𧏥𧞩𧞬𧫑𧼨𧽄𧽟𧾢𧾯𨃲𨓰𨕽𨥂𩔄𩟦𩢴𩧵𩯰𩾶𪀾𪁍𪃈𪅸𪇲𪉋𪌧𪖋])),
					result  => q(jié),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[姐媎檞毑解觧飷𠎿])),
					result  => q(jiě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑘㝏㠹㾏㿍䇒䛺䯰䰺䱄䲸丯介借吤堺屆届岕庎徣悈戒楐犗玠琾界畍疥砎芥蚧蛶衸褯誡诫躤鎅骱魪𠓢𠷟𡗦𡗲𡵚𣬫𤘦𤙩𧜅𧣋𨐑𨵠𩡺𩧦𪑹𪙏])),
					result  => q(jiè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[桝])),
					result  => q(jie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻐㦗㧆㻱䃡䈥䈽䌝䘳䤺今兓埐堻嶜巾惍斤津珒矜筋紟荕衿襟觔金釒釿钅鹶黅𠂟𠰇𢎭𢦊𤣶𥂵𦈟𦘔𦞬𦩏𧗁𨆃𨭺𩀿𩤿𪉢𪑙𪖼])),
					result  => q(jīn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝻㯸㹏䌍䒺䤐䥆䭙仅侭僅儘卺厪堇嫤尽巹廑槿漌瑾盡紧緊菫蓳謹谨錦锦饉馑𢬬𣝌𥖜𥯑𨚡𪏴])),
					result  => q(jǐn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨷㬐㬜㯲㱈㴆㶦㶳䀆䆮䋮䑤䗯䝲䫴䶖伒僸凚劤劲勁唫噤嚍墐妗嬧寖搢晉晋暜枃歏殣浕浸溍濅濜烬燼琎瑨璡璶祲禁縉缙荩藎覲觐賮贐赆近进進靳齽𠞱𠞾𠢱𠢵𠬶𠾤𠾬𡢳𡺽𢉅𢙿𢬶𢱷𢽖𣓏𤄼𤘡𤧫𤵞𥧲𦎷𦧈𦽔𧔷𩖗])),
					result  => q(jìn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[壗琻砛])),
					result  => q(jin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䪫䴖京亰兢坕坙婛巠惊旌旍晶泾涇猄睛秔稉粳精経經经聙腈茎荆荊莖菁葏驚鯨鲸鵛鶁鶄麖麠鼱𠳬𡁔𢀖𢈴𣋢𣻒𤜰𤷦𥠛𦀇𦂠𦜳𦽁𦾿𧓔𧤵𩓨𩳯𩹢𪂴𪇒])),
					result  => q(jīng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘫䜘丼井儆刭剄坓宑幜憬憼景暻汫汬燛璟璥穽肼蟼警阱頚頸颈𠑱𠭉𠭗𢹘𤰳𧑊𨙷𨥙𩻱])),
					result  => q(jǐng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢣㣏㬌䔔䝼䵞俓倞傹净凈境妌婙婧弪弳径徑敬曔桱梷浄淨濪瀞獍痉痙竞竟竧竫競竸胫脛誩踁迳逕鏡镜靓靖静靚靜𠗊𠗌𠦋𠲮𠷐𣬙𥅸𥯙𥶹𦥍𦳲𨵼𩃋𩇕𩓞𩰹])),
					result  => q(jìng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[橸燝])),
					result  => q(jing),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺆冂冋坰埛扃絅蘏蘔駉駫𠕕𢂶𣕄𨴀𪔃𪕍])),
					result  => q(jiōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓏㢠㤯㯋㷗㷡䌹䢛侰僒冏囧泂浻澃炅炯烱煚煛熲窘綗褧迥逈颎𠖷𢄗𣔲𤌇𦀝𧍮𩓺𩚱])),
					result  => q(jiǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸨䆶䡂丩勼啾揂揪揫摎朻樛牞究糺糾纠萛赳阄鬏鬮鳩鸠𠃖𠕴𠖬𠚨𠠳𠿈𢀙𢜥𣁭𣟼𤴥𤴦𤴪𥠃𥤳𦭺𦱠𦱱𦱲𦽬𨳊𩏶𩏷𩭓𩱼])),
					result  => q(jiū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㺵])),
					result  => q(jiú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡱久乆九乣奺灸玖紤舏酒镹韭韮𠛩𠜉𠴄𡚮𣲄𤉥𨾉𨾞])),
					result  => q(jiǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝌㠇㩆㲃㺩䅢䆒䊆䊘䛮䬨䳎倃僦匓匛匶厩咎媨就廄廏廐慦捄救旧柩柾桕殧疚臼舅舊鯦鷲鹫麔齨𠃺𠙔𠜃𠣿𡆥𢑇𢽭𤷑𥆷𥘦𦠢𦭻𧡑𧫾𧾻𨖏𨘂𨘮𩒦𩢹𩶧])),
					result  => q(jiù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[杦欍汣𣐤])),
					result  => q(jiu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖩㞐㡹㪺䅕䝻䢸䪶凥刟匊娵婮居崌抅拘挶掬梮椐泃涺狙琚疽痀眗砠罝腒艍苴菹蜛裾趄跔踘踙鋦锔陱雎鞠鞫駒驹鮈鴡鶋𠟰𠤄𠮑𠰾𡨢𡫬𡱾𡸘𡸨𣻐𥇛𥘮𥪏𥷚𦀣𦛓𦜛𦱅𧵞𧹕𨁺𨛮𨧙𨨠𩋜𩍔𩍸𪂓𪗖])),
					result  => q(jū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺽㘲㥌㩴㮂㹼㽤䋰䎤䏱䕮䗇䜯䡞䤎䪕䰬䱡䳔䴗侷僪啹婅局巈桔椈橘檋毩毱泦淗湨焗犑狊粷菊蘜諊趜跼蹫躹輂郹閰駶驧鵙鵴鶪鼳𠋬𠜹𠨭𡉎𡨅𡳘𡶋𡿾𢩁𣎛𣖣𤜔𤼳𥢧𥮗𦅽𦙮𦥑𦺖𧄛𧤑𧷾𧻗𧽻𧾣𧿻𨋧𨍯𩛺𩧺𩫴𩬜𩭊𩳵𩷐𪀣])),
					result  => q(jú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䃊䄔䅓䢹举咀弆挙擧椇榉榘櫸欅沮矩筥聥舉莒蒟踽齟龃𡕖𡢒𢤫𢯺𣌬𥄷𥈋𥯔𥴧𦇙𦞇𧺹])),
					result  => q(jǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘌㜘㞫㠪㨿㩀㬬䀠䈮䛯䣰䱟䵕䶙乬俱倨倶具冣剧劇勮句埧埾壉姖寠屦屨岠巨巪怇怐怚惧愳懅懼拒拠据據昛歫洰澽炬犋秬窭窶簴粔耟聚苣虡蚷袓詎讵豦貗跙距踞躆遽邭醵鉅鋸鐻钜锯颶飓駏鮔𠉧𠙆𠚵𡒍𡥶𢚆𣍇𣶝𤔋𤖵𤢓𤷢𥂃𥉁𥬙𥲜𥴪𦊐𦗻𦟳𦼈𧂜𧝲𧣒𧣻𧲋𧸧𨝮𨸰𩉸𩜃𩧒𩰤𩴘𩿝𪀏𪁥])),
					result  => q(jù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[爠襷])),
					result  => q(ju),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䅌䣺勬姢娟捐涓焆瓹脧蠲裐鎸鐫镌鵑鹃𠡶𡱑𢝓𥅬𦬾𦮻𧎖𨌫𩎳𩔱])),
					result  => q(juān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㷷卷呟埍帣捲臇菤錈锩𡫂𢋄𤎱𦊌𧕲𨹵𩏗𩜇𩠉])),
					result  => q(juǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢧㢾㪻㯞䄅䌸䖭䚈䡓䳪倦劵勌奆巻慻桊淃狷獧眷睊睠絭絹縳绢罥羂蔨鄄隽雋飬餋𠔉𠢚𡘰𡡀𢍏𢎥𣙢𣚓𣜨𣬋𣬏𤲨𤺻𥁠𥆞𥱽𦦽𦳽𦼱𧭦𧯦𨆈𨤑𩏹])),
					result  => q(juàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[噘屩撅撧蹻𢱺𢴭𪨗𫏋])),
					result  => q(juē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔃㔢㟲㤜㩱㭈㭾㰐㲄㵐㷾㸕㹟㻕䀗䁷䇶䏐䏣䐘䖼䘿䙠䝌䞷䠇䡈䣤䦆䦼亅倔傕决刔劂勪匷厥噱嚼孒孓屫崛嶥弡彏憠憰戄抉挗捔掘攫斍桷橛橜欔欮殌氒決泬焳熦爑爝爴爵獗玃玦玨珏瑴疦瘚矍矡砄絕絶绝臄芵蕝蕨虳蚗蟨蟩覐覚覺觉觖觼訣譎诀谲貜赽趉趹蹶蹷躩逫鈌鐍鐝钁镢駃鴂鴃鶌鷢龣𠀔𠄌𠄑𠊬𠎮𠜾𠢤𠨊𠫃𠶸𡈅𡚠𡲗𡳾𡾜𢁪𢎹𢏷𢔱𢖦𢨏𢩯𣅡𣖬𣬎𤛦𤞴𤟎𤹋𤼗𥆌𥏘𥕲𥛯𥤘𥾮𦁐𦏅𦓐𦛲𦠒𦪘𧍕𧗫𧝃𧣸𧤼𧥎𧮫𧱝𧺐𧽸𧾵𧿺𨊿𨏹𨬐𨰜𨼎𨼱𩊺𩍷𩏺𩓻𩧏𩧡𩪗𩰨𪁠𪈴𪖜𪚅𫔎𫘝𫛞])),
					result  => q(jué),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䞵])),
					result  => q(juě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𣨢𥈾])),
					result  => q(juè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚬军君均姰桾汮皲皸皹碅莙菌蚐袀覠軍鈞銁銞鍕钧鮶鲪麇麏麕𠀹𠣕𢻸𦇘𦌺𧽔])),
					result  => q(jūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𢉦])),
					result  => q(jǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑺㒞㕙㖥㝦㴫㻒㽙䇹䐃䕑䜭䝍俊儁呁埈寯峻懏捃攈攟晙棞浚濬焌燇珺畯竣箘箟蜠郡陖餕馂駿骏鵔鵘𠨢𢹲𤮪𥇘𥚂𥜮𥡣𦴌𦵼𧥺𧯖𨌘𨛐𨲄𨶊𪍁𪕞])),
					result  => q(jùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䘔咔咖喀擖衉])),
					result  => q(kā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[佧卡胩鉲])),
					result  => q(kǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[垰裃])),
					result  => q(ka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚊䤤奒开揩鐦锎開𡙓𢔡𢾆𤡲𥻄𦂄𦈲𨴆])),
					result  => q(kāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䁗䒓凯凱剀剴嘅垲塏嵦恺愷慨暟楷蒈輆鍇鎧铠锴闓闿颽𠢲𢋝𥃣𥏪])),
					result  => q(kǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪡䡷勓忾愒愾欬炌炏烗鎎𡳂𢢚𤉫𤐩𤻜𥎆𩫀])),
					result  => q(kài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘛刊勘堪嵁戡栞龕龛𡺗𢦟𦞖𧡵𩑟])),
					result  => q(kān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙳䖔侃偘冚坎埳塪惂槛檻欿歁砍竷莰輡轗顑𠝲𡸞𣣒𣽌𥑫𥤱𥦔𧇦𧱄𨍜𩐬𩒃𩓟𩜱])),
					result  => q(kǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䀍䘓䳚墈崁看瞰矙磡衎闞𡶪𢙮𣊟𥍓𧯰𨒞𪉯])),
					result  => q(kàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝩㱂㼹䆲䗧嫝嵻康忼慷槺漮砊穅粇糠躿鏮闶鱇𠾨𡐓𡵻𤮊𥉽𥕎𥹺𨀫𨂟𨄗𨎍𨝎𨻷𩾌])),
					result  => q(kāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[扛摃𢴦])),
					result  => q(káng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䡉𠻞𡻚𣔛])),
					result  => q(kǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢜亢伉匟囥抗炕犺邟鈧钪閌𥒳𪎵])),
					result  => q(kàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䯌尻髛𩩾])),
					result  => q(kāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䯪丂拷攷栲洘烤燺稁考鲓𣐊𣧏𣨻𣩅𥬯𥹬])),
					result  => q(kǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䎋䐧犒銬铐靠鮳鯌𡭳𧋓𨘴𩝝])),
					result  => q(kào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸯䈖䌀䐦匼嗑搕柯棵榼樖牁犐珂疴瞌砢磕礚科稞窠胢苛萪薖蝌趷軻轲醘鈳錒顆颏颗髁𠏀𠲙𡸡𡻘𢈈𢩘𣧤𤖇𤰙𥃕𥝹𥠁𥧇𧎗𧨵𧵛𧿫𨍰𨏿𨢸𩏭𩜭𪍎])),
					result  => q(kē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[壳揢殼翗])),
					result  => q(ké),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞹㪙㪼㵣可坷岢嵑嶱敤渇渴炣礍𢩐𢼐𤸎𪓮])),
					result  => q(kě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕉㕎㝓㤩䆟䙐䶗克刻剋勀勊堁娔客尅恪愙氪溘碦礊緙缂艐課课锞騍骒𠛳𠡜𠡤𠢹𠩧𠪒𠪟𠳭𠶲𠷄𡞢𡱼𢩏𢾩𣩄𣲊𣹇𤛗𥊉𥔽𥦨𥯚𧈗𧛾𧜡𧠋𩭽𩰻𩱘𪃭])),
					result  => q(kè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嵙])),
					result  => q(ke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𩎤])),
					result  => q(kēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[啃垦墾恳懇肎肯肻豤錹齦龈𠳁𣍟𣥤𤀊𥖞𨼯])),
					result  => q(kěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸧掯裉褃])),
					result  => q(kèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧶㰢䃘䡩䡰劥吭坑妔挳摼牼硁硜硻誙銵鍞鏗铿阬𠠷𡷨𣢴𣫒𥉸𥑅𥒁𥒱𥥳𧀘𨋔𨌳𨌶𨍑])),
					result  => q(kēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𡞚])),
					result  => q(kěng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚚㲁䅝倥埪崆悾涳硿空箜錓鵼𠀝𢃐𢷙𢽦𥔇𦱇𧌆𧚬𪔣])),
					result  => q(kōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤟孔恐𢪬𣏺𤤲𥥅𦶐𩲧])),
					result  => q(kǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸜控鞚𤗇𦁈])),
					result  => q(kòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[躻])),
					result  => q(kong),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䁱剾彄抠摳眍瞘芤𠛅𢂁𢄠𦬅])),
					result  => q(kōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[劶口𢼃𤘘𨙫𨥴])),
					result  => q(kǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓂㰯䍍䳹冦叩宼寇扣敂滱瞉窛筘簆蔲蔻釦鷇𡠆𢚫𢟭𣻎𣿟𥊧𥲃𦴎𦶲𧥣𩀠𪄺𪇄𫃜])),
					result  => q(kòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗄㩿㪂㱠㵠䂗䉐䧊䯇刳哭圐堀崫扝枯桍矻窟胐跍郀骷鮬𠠶𡀙𡑚𡑣𡗵𡶏𡼿𢏆𢼁𣗺𥈷𥌄𥟾𥧋𦜇𦡆𧠂𧷎𩑔𩑡𩨳𪍠])),
					result  => q(kū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𦛏])),
					result  => q(kú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䇢狜苦𡞯𥯶𩇵])),
					result  => q(kǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠸䔯䵈俈喾嚳库庫廤焅瘔秙絝绔袴裤褲趶酷𠺟𥞴𧊘𧿉𧿋𨐡𨡱𩱙𪌓])),
					result  => q(kù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛻䓙䠸䯞夸姱誇𠇗𡇚𡗢𥑹𨕺𨵧])),
					result  => q(kuā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡁侉咵垮銙𢄳𩊓])),
					result  => q(kuǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐄䦚挎胯跨骻𡕒𢓢𥏤𨃖])),
					result  => q(kuà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[舿])),
					result  => q(kua),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧟䓒擓蒯𠣲𡚅𣫉𦳋𩦱])),
					result  => q(kuǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔞㙕㟴㱮䈛䭝䯤侩儈凷哙噲块塊墤巜廥快旝狯獪筷糩脍膾郐鄶鱠鲙𠜐𡼾𢾒𥢶𦔦𨛖𫐆])),
					result  => q(kuài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[圦])),
					result  => q(kuai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[宽寛寬臗髋髖𣎑𥦀])),
					result  => q(kuān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㯘䕀䥗䲌欵款歀窾𢕫𢴪𣢻𣽟𥟓])),
					result  => q(kuǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[窽鑧])),
					result  => q(kuan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑌䒰䖱䯑劻匡匩哐恇框洭硄筐誆诓軭邼𢼑𢼳𤝿𦚞𧻔𨀕𨏆𨴑𩢼𩬹])),
					result  => q(kuāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㾠忹抂狂誑诳軖鵟𣴥𦥰𨖢𩷗])),
					result  => q(kuáng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[儣夼懭])),
					result  => q(kuǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䊯䵃况卝圹壙岲懬旷昿曠況爌眖眶矌矿礦穬絖纊纩貺贶躀軦邝鄺鉱鑛黋𡶢𡾇𣍦𣒸𥈏𧥌𧿈𨇁𨥑𨨭𪍿𪏪])),
					result  => q(kuàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[砿筺絋])),
					result  => q(kuang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨒䯓亏刲岿巋悝盔窥窺聧蘬虧闚顝𡐠𡓰𡤞𥁇𧢦𩏣𪖢])),
					result  => q(kuī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙓㙺䕫䖯䟸䤆䧶䳫喹夔奎巙戣揆晆暌楏楑櫆犪睽葵藈蘷虁蝰躨逵鄈鍨鍷隗頄頯馗騤骙魁𠊾𡌤𢌳𤵮𥜶𦝢𧍜𧡦𨾎𨾗𩕜𩠮𩲅𩲷𩵉𩹍𪆴])),
					result  => q(kuí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒑㚍䠑䫥煃跬蹞頍𢜽𢼀𣄲𣥮𥪊𩓗])),
					result  => q(kuǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕟䕚䙆䙌䙡䯣䰎匮喟嘳媿嬇尯愦愧憒樻欳溃潰瞆篑簣籄聩聭聵腃蒉蕢謉鐀鑎餽饋馈𠣠𠿥𣧼𤆂𤏜𥏙𧂠𧄑𧑋𧝷𧷛𨣈])),
					result  => q(kuì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡓㱎䐊䖵䪲坤堃婫崐崑昆晜焜猑琨瑻菎蜫裈裩褌貇醌錕锟騉髠髡髨鯤鲲鵾鶤鹍𠚯𡖉𥊽𥚛𦌸𧥊𨱙𩓽𩻋𩽞𪋆])),
					result  => q(kūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩲䠅壸壼悃捆梱硱祵稇稛綑裍閫閸阃齫𦄐𧋕𨁉𩨫])),
					result  => q(kǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㫻困涃睏𢈛𣏔𣰘𣱂𩤋])),
					result  => q(kùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[堒尡潉熴])),
					result  => q(kun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗥㾧䟯䦢䯺廓懖扩拡括挄擴桰濶筈萿葀蛞闊阔霩鞟鞹頢髺鬠𠚳𠠎𡎒𡻙𢠛𤫵𥕏𦧍𦧔𨓈𨨱𨶐𩋻𪗽])),
					result  => q(kuò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[韕])),
					result  => q(kuo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕇㡴垃拉搚柆翋菈邋𣤊𤛊𤰚𦒆𩃜𩤲𩨉])),
					result  => q(lā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[剌嚹揦旯砬磖𡉆])),
					result  => q(lá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[喇藞𥗿𥘁𦎏])),
					result  => q(lǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㻋㻝䂰䃳䏀䓥䗶䱨䱫䶛揧攋楋爉瓎瘌腊臈臘蜡蝋蝲蠟辢辣鑞镴鬎鯻𠾩𡅘𢃴𢉨𤀦𤊶𥀥𥀰𥈙𥖍𦅶𦆻𦇛𦒦𧗩𧙀𧞪𧩲𨭛𩑮𩘊𩯽𪇹])),
					result  => q(là),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[啦溂鞡𤷟𩋷])),
					result  => q(la),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥎䅘䋱䠭䧒來俫倈婡崃崍庲徕徠来梾棶涞淶猍琜筙箂莱萊逨郲錸铼騋鯠鶆麳𠎙𢑬𣖤𤢗𤦃𤲓𦓹𧯲𧳕𧳟𨂐𪑚])),
					result  => q(lái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚓䂾𢅭𧵭𨦂])),
					result  => q(lǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸊䄤䓶䚅䲚唻櫴濑瀨瀬癞癩睐睞籁籟藾襰賚賴赉赖頼顂鵣𠘝𡂖𡃄𡓒𦆋𨇆𩳆𪈈])),
					result  => q(lài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑣㘓㞩㦨㳕䆾䍀䑌䦨䪍䰐儖兰厱囒婪岚嵐幱惏懢拦攔斓斕栏欄欗澜瀾灆灡燣燷璼礷篮籃籣繿葻蓝藍蘭褴襕襤襴譋讕谰躝钄镧闌阑韊𠓖𠼖𡮻𢅡𢉧𢊓𢛓𣋣𥌻𥜓𦧼𧼖𨅏𨅬𨊔𨬒𨷻𩈵𩔵𪇖])),
					result  => q(lán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛦㨫㩜㰖䌫囕壈嬾孄孏懒懶揽擥攬榄欖浨漤灠爦纜缆罱覧覽览醂顲𠓭𡒄𡓔𡽳𤑸𤣟𥦝𧮤𨎹𨣸𩟺])),
					result  => q(lǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜮㱫䃹嚂滥濫烂燗爁爛爤瓓糷鑭𢒞𢹙𤂺𤃨𥗺𧸦𨣨𩉀])),
					result  => q(làn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[襽])),
					result  => q(lan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[啷])),
					result  => q(lāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝗㟍㢃㱢㾿䆡䡙䯖䱶勆嫏廊斏桹榔欴狼琅瑯硠稂筤艆蓈蜋螂躴郎郞鋃鎯锒阆駺𢽂𥍫𥧫𦵧𨞿𨱍𩛡𩷕𪁜])),
					result  => q(láng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓪㙟㮾塱朖朗朤樃烺蓢誏𠻴𣊧𥇑𧚅])),
					result  => q(lǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㫰䍚䕞埌崀浪莨蒗閬𠺘𢳑𣻡𦺫𧻴𨶗𩲒𩳤])),
					result  => q(làng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[唥郒])),
					result  => q(lang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[捞撈])),
					result  => q(lāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗦㞠㟉㟹㨓䃕䜎䝁䲏僗劳労勞哰唠嘮崂嶗憥浶牢痨癆磱窂簩蟧醪鐒铹顟髝𠈭𡑍𢚄𢭂𣘪𤎤𤛮𤩂𥢒𨣃𨦭𨲮𪁔])),
					result  => q(láo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧯㺐䇭䕩䝤䳓䵏佬咾姥恅栳橑潦狫老耂荖轑銠铑𡂕𣠼𤶁𦒴𨡤𪀧])),
					result  => q(lǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嫪憦橯涝澇烙耢耮躼軂酪𡬘𣟽𤉍𦺜𧢋𧯍])),
					result  => q(lào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[朥珯硓粩蛯鮱𦛨])),
					result  => q(lao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[肋𡃖])),
					result  => q(lē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔹㖀㦡乐仂叻忇扐楽樂氻泐玏砳竻簕艻阞韷鰳鳓𣂒𤟓𤨙𥖪𩐾])),
					result  => q(lè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[了餎饹])),
					result  => q(le),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[勒])),
					result  => q(lēi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒍㔣㵢㹎䍣䐯䨓儽壨嫘擂檑櫑欙瓃畾礌礧縲纍纝缧罍羸蔂蘲虆蠝轠鐳鑘镭雷靁鼺𡈶𡰠𡻱𢴱𣀀𣚎𣡧𤜖𤡂𤮎𤮚𤮸𤳳𤳴𤼘𥍔𦣄𧒜𧒽𧞭𨞽𩴻])),
					result  => q(léi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒦㙼㵽㶟㼍㿔䉂䛶䣂䴎傫儡厽垒壘樏櫐灅癗磊磥礨絫耒腂蕌蕾藟蘽誄讄诔鑸鸓𠱤𡚗𡻭𡼊𡾋𡾖𡿉𡿛𢹮𣠠𣡺𤃻𤢹𥑶𥗬𦇄𦓥𦢏𨄱𨊚𨻌])),
					result  => q(lěi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑍㲕㴃䉪䒹䢮䣦䮑攂泪洡涙淚禷类累纇蘱酹銇錑頛頪類颣𡔇𣀜𣨅𥅦𥗶𥣬𥤐𨀤𨶺𩔗𩛝𩵓𪑯])),
					result  => q(lèi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嘞塁鱩])),
					result  => q(lei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘄])),
					result  => q(lēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䉄䬋塄崚棱楞碐稜薐輘𥈮𦼊𧼔𨈓𩩡])),
					result  => q(léng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[冷])),
					result  => q(lěng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䮚倰堎愣睖踜])),
					result  => q(lèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哩])),
					result  => q(lī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒿㓯㛤㠟㦒㰀㰚㴝㹈䄜䅻䉫䊍䋥䍠䍦䔆䔣䔧䖥䖽䖿䙰䣓䣫䱘䴻䵓䵩刕剓剺劙厘喱嚟囄嫠孋孷廲悡攡斄杝梨梩梸棃樆漓灕犁犂狸琍璃瓈盠睝离穲筣篱籬粚糎縭纚缡罹艃荲菞蓠蔾藜蘺蜊蟍蠡褵謧貍邌醨釐鋫錅鏫鑗離騹驪骊鯬鱺鲡鵹鸝鹂黎黧𠛘𠞙𠭰𠻗𠼝𠾆𡃷𡥽𡿎𢄡𢌈𢛮𢟢𢟤𢤂𢮃𣁟𣐬𣘬𣞴𣫥𣮉𣯤𤗫𤚓𤭜𥊈𥌛𥣥𥲧𥲪𥻿𥼅𦃇𦔓𦢱𦺙𧄚𧅯𧋎𧋠𧑇𧕮𧕯𧚩𧫬𧮛𨄛𨇎𨛫𨝏𨝖𨝟𨤫𨯽𩁟𩆲𩥬𩥴𩧋𩭇𩻌𪁐𪅆𪌱𪏼𪐅𪒔𪖂])),
					result  => q(lí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸚㾖䗍䤚䧉俚兣娌峛峢峲李欚浬澧理礼禮粴蟸裏裡豊逦邐醴里鋰锂鯉鱧鲤鳢𠚄𡆯𢏃𣀂𣀷𣿞𥎓𥎔𥴡𦎐𦕸𦪶𦫈𧅮𨓦𨛋𨴻𩳓𩷋𩽵𪕴])),
					result  => q(lǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑦㒧㔏㕸㗚㘑㟳㠣㡂㤡㤦㧰㬏㮚㯤㱹㺡㻎㻺㼖㽁㽝㾐㿛㿨䃯䅄䇐䊪䍥䍽䓞䔁䔉䕻䘈䚕䟏䟐䡃䤙䥶䬅䬆䮋䮥䰛䰜䲞䴡䶘丽例俐俪傈儮儷凓利力励勵历厉厤厯厲吏呖唎唳嚦囇坜塛壢娳婯屴岦巁悧慄戾搮攊攦攭暦曆曞朸枥栎栗栛棙櫔櫟櫪欐歴歷沥沴涖溧濿瀝爄爏犡猁珕瑮瓅瓑瓥疠疬痢癘癧皪盭矋砅砺砾磿礪礫礰禲秝立笠篥粒粝糲綟脷苈苙茘荔莅莉蒚蒞藶蚸蛎蛠蜧蝷蠇蠣蠫觻詈讈赲跞躒轢轣轹郦酈鉝鎘隶-隸雳靂靋鬁鱱鱳鳨鴗鷅麗麜𠌯𠘞𠘟𠛦𠝄𠞉𠞤𠠏𠠝𠠵𠢠𠩵𠪄𠪺𠫌𡤌𡫯𡮰𡯄𡳸𡸉𡾒𡿋𢍼𢡑𢤆𢤩𢨨𢩑𢸀𢻠𣀥𣌅𣌜𣟌𣦯𣧿𣫧𣲒𤁼𤃀𤄽𤇃𤔨𤖢𤘃𤜜𤟑𤠫𤡿𤩮𤳓𤹇𤹈𤻤𤼚𥁟𥉆𥌤𥌮𥌿𥓃𥝢𥠲𥨻𥬭𥶗𥷅𥷗𥽗𦃊𦅺𦇔𦘊𦜏𦠓𦪾𧄻𧉲𧒈𧓽𧔝𧘫𧙉𧢝𧥖𧧋𧯏𧰡𧲡𧴠𧽲𨃙𨇗𨊛𨍫𨏬𨘸𨜼𨞺𨟑𨢌𨪹𨬑𨷦𨽻𩄞𩅩𩆝𩗅𩗭𩘟𩘡𩙖𩞨𩣫𩧃𩪸𩯺𩰲𩱇𩴣𩶘𩽏𪅼𪓀𪖍𪗁𪙺𪙽𫁡])),
					result  => q(lì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[栃檪鯏])),
					result  => q(li),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[俩倆])),
					result  => q(liǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜕㝺㟀㡘㢘㥕㦁㶌㺦㼓䁠䃛䆂䏈䙺䥥䨬䭑亷劆匲匳嗹噒奁奩嫾帘廉怜慩憐梿槤櫣涟溓漣濂濓熑燫磏簾籢籨縺翴联聫聮聯臁莲蓮薕螊蠊裢褳覝謰蹥连連鎌鐮镰鬑鰱鲢𠔨𢅏𢅖𣀃𣝈𤣆𤬓𤾲𥖝𥲥𦆆𦈐𦔖𦖾𧐖𧡙𨎷𨏩𨏶𨬁𨽷𩄡𩞙𪍴𪐋𪐍𪖳𪚁𪛒])),
					result  => q(lián),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪘㯬㰈㰸䌞嬚摙敛斂琏璉羷脸臉蔹蘞裣襝鄻𠗳𤑿𤼏𩟅𪍦])),
					result  => q(liǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜃㜻㪝㱨㶑㼑僆堜媡恋戀楝殓殮浰湅潋澰瀲炼煉瑓練纞练萰蘝錬鍊鏈链鰊𠋖𠒵𡆕𡟤𣞰𣟺𣿊𤒦𤗛𤹨𥽸𦣸𧍴𧡴𧸘𧽫])),
					result  => q(liàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[聨])),
					result  => q(lian),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㹁䝶䣼䭪俍凉墚梁椋樑涼粮粱糧綡良踉輬辌𡑆𡮎𤙝𥛫𨄈𨎛𨵶𩘁𩞯])),
					result  => q(liáng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒳㔝䓣䠃䩫両两兩唡啢掚緉脼蜽裲魉魎𠓜𠯱𣓈𥈘𩗾])),
					result  => q(liǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㾗䀶䁁亮哴喨悢晾湸諒谅輌輛辆量鍄𣄴𨱉])),
					result  => q(liàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[煷簗])),
					result  => q(liang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[撩蹽])),
					result  => q(liāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙩㵳䒿䜍䜮䨅僚嘹嫽寥寮屪嵺嶚嶛廫憀敹暸漻燎獠璙疗療簝繚缭聊膋膫藔蟟豂賿蹘辽遼鐐飉髎鷯鹩𠐋𠖂𠨥𡻪𢄷𢊻𢨺𢸘𢼙𣁰𣟆𤵠𥲊𦕵𦗖𦪕𦺹𧂏𧝜𧽽𨖚𩖝𩯊𪌵])),
					result  => q(liáo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝋㶫䄦䑠䩍叾憭曢爒瞭蓼鄝釕钌镽𢻢𢿞𣎸𤑗𥗀𧘈𧡜𨣀𪌀])),
					result  => q(liǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡻䉼䎆䢧尞尥尦廖撂料炓窷镣𣩢𤊽𥛰𦌒𩕐𩴤𪖷])),
					result  => q(liào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[爎])),
					result  => q(liao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𦾳])),
					result  => q(liē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䟩咧𨤤])),
					result  => q(liě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤠㧜㬯㭞㭩㯿㲱㸹㼲㽟䁽䅀䉭䋑䜲䝓䟹䪉䴕儠冽列劣劽哷埒埓姴巤挒捩擸栵洌浖烈煭犣猎獵睙聗脟茢蛚裂趔躐迾颲鬛鬣鮤鱲鴷𠛱𠠗𡁓𡂏𡂩𡊻𡏵𡒏𡓍𡭣𡿩𢣓𣁷𣁻𣋲𣖊𣝚𣰌𤁯𤐱𤓿𤖺𤜓𤞊𤡕𤢪𤱃𤱛𥪂𥲁𥶢𥷨𥸸𦓤𦖩𧀨𧓐𧞕𧭌𧭞𧰠𨆍𨕜𩆣𩙑𩢾𩧆𩧮𩨐𩭌𩼭])),
					result  => q(liè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[挘毟烮猟])),
					result  => q(lie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[拎])),
					result  => q(līn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔂㝝㷠䚬䢯䫐䮼临冧厸啉壣崊嶙斴晽暽林淋潾瀶燐獜琳璘痳瞵矝碄磷箖粦粼繗翷臨轔辚遴邻鄰鏻隣霖驎鱗鳞麐麟𡰚𡹇𡻫𡿠𣇰𥻋𥼭𧃮𧲂𧹩𩞻𩱬𩻜])),
					result  => q(lín),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐭㨆䕲亃凛凜廩廪懍懔撛檁檩澟癛癝菻𠓮𡬜𤎭𥓆𧵧])),
					result  => q(lǐn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖁䉮䗲䚏䫰僯吝恡悋橉焛甐疄膦蔺藺賃赁蹸躏躙躪轥閵𠐼𡃦𡳞𡶱𤂶𤌎𤗷𥳞𥶒𥷖𦺸𧖔𧶆𨏨𨸻𩣖𩴠])),
					result  => q(lìn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[〇㖫㡵㥄㦭㪮㬡㯪㱥㲆㸳㻏㾉䄥䈊䉁䉖䉹䌢䍅䔖䕘䖅䙥䚖䠲䡼䡿䧙䨩䯍䰱䴇䴒䴫伶凌刢囹坽夌姈婈孁岺彾掕昤朎柃棂櫺欞泠淩澪灵燯爧狑玲琌瓴皊砱祾秢竛笭紷綾绫羚翎聆舲苓菱蔆蕶蘦蛉衑裬詅跉軨酃醽鈴錂铃閝陵零霊霛霝靈駖魿鯪鲮鴒鸰鹷麢齡齢龄龗𠄖𠠢𠡭𠱠𠻠𠻱𠾥𡈍𡕮𡿡𢌔𢔁𢩗𢹝𢺰𣌟𣣋𣬹𤃩𤖦𤜙𤣘𤧘𤫩𤫲𤿅𥌼𥤜𥤞𥥋𥩔𥺙𥾂𦉢𦫃𦫊𧆺𧕅𧖜𧟙𧨈𧰻𧱢𧾇𧾮𨠎𨱋𨽲𩂙𩃞𩆒𩆚𩆮𩆻𩆼𩇄𩇎𩊂𩑊𩖊𩖵𩚹𩜁𩟃𩪥𩬔𩲩𩵀𪅋𪋳𪋾𪌏𪕌𪛈𫐉])),
					result  => q(líng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[岭嶺袊阾領领𥵝𦊓])),
					result  => q(lǐng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[令另呤炩𠟨𤨻𤷖𧲙𨞎𩄊])),
					result  => q(lìng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[瀮蓤霗])),
					result  => q(ling),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[溜熘蹓𠺕])),
					result  => q(liū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐬㽞䉧䗜䚧䝀䬟䰘䱖䱞䶉刘劉嚠媹嵧懰旈旒榴橊沠流浏瀏琉瑠瑬璢畄留畱疁瘤癅硫磂蒥蓅藰蟉裗遛鎏鎦鏐镏镠飀飅飗馏駠駵騮驑骝鰡鶹鹠麍𠗽𠪐𢏭𢤐𢷶𣞗𣟑𣠚𣱳𤥗𥀓𥆦𥠷𥰣𥶅𥹷𦀠𦃓𦊿𦑾𧏓𧮗𨦰𨪕𨻧𩗩𩙄𩢞𪃂𪆱𪇯𪎣])),
					result  => q(liú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧕嬼柳栁桺橮熮珋綹绺罶羀鉚鋶锍飹𠛓𦊑𦊗𦌁𨋖𨍸𩖴])),
					result  => q(liǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙀㶯㽌䄂六塯廇澑畂磟翏鐂雡霤飂餾鬸鷚鹨𢔲𢞭𢣠𤮷𥌐𥛅𥥹𥧕𥨌𦉉𨢇𩆎])),
					result  => q(liù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[桞])),
					result  => q(liu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[囖])),
					result  => q(lo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻯⻰㚅㝫㡣㦕㰍䃧䆍䏊䙪䥢䪊䮾咙嚨屸嶐巃巄昽曨朧栊櫳泷湰滝漋瀧爖珑瓏癃眬矓砻礱礲窿竜笼篭簼籠聋聾胧茏蕯蘢蠪蠬襱豅躘鏧鑨隆霳靇驡鸗龍龒龙𠾐𡃡𡬍𢤲𢸭𣫣𤵸𤾭𥪢𥪻𥬆𥳌𥸉𦨩𦪽𧍰𧙥𨇘𨏠𨐇𨺚𩂽𩄺𩙘𩙠𩟭𩧪𪔳𪔷𪚑𪚓𪚘𪚝𪚠])),
					result  => q(lóng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙙㴳䡁儱垄垅壟壠拢攏竉篢陇隴龓𢤱𪐖])),
					result  => q(lǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑝㛞㟖㢅㳥哢徿挵梇贚𠮽𠱚𡱯𢙱𤼃𥦌𧚂𨛓])),
					result  => q(lòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[槞])),
					result  => q(long),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䁖瞜])),
					result  => q(lōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟺㡞㥪㲎㺏䄛䝏䣚䫫䮫䱾偻僂剅喽嘍娄婁廔慺楼樓溇漊熡耧耬艛蒌蔞蝼螻謱軁遱鞻髅髏𠞭𠳴𡇭𣫻𤋏𤠋𤬏𦎹𧁾𧢃𧰃𧷡𨻻𩏝𩨇])),
					result  => q(lóu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪹䅹塿嵝嶁搂摟甊篓簍𡗆𡰌𢈢𥕍𧯨𪍣])),
					result  => q(lǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔷屚漏瘘瘺瘻鏤镂陋𠖛𠗩𡪅𣤋𦸢𧫞𨄋𨝢𨦖𨫒𨱐])),
					result  => q(lòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[噜撸])),
					result  => q(lū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠠㢳㪭㭔㱺㿖䡎䮉䰕卢嚧垆壚庐廬攎曥栌櫚櫨泸瀘炉爐獹玈璷瓐盧矑籚纑罏胪臚舻艫芦蘆蠦轤轳鑪顱颅髗魲鱸鲈鸕鸬黸𡉴𡳴𣆐𤬛𤮧𥀵𦿊𧆣𧇄𨇖𩄅𩍼𪑄𪖌])),
					result  => q(lú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻧㔪㢚㯭䲐卤嚕塷掳擄擼樐橹櫓氌滷澛瀂硵磠艣艪蓾虏虜鏀鐪鑥镥魯鲁鹵𠿛𢋡𢟧𢲸𣥐𣱀𤣃𥶇𧀦𧫓𩯜𪉖𪉣])),
					result  => q(lǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓐㖨㛬㜙㟤㦇㪐㪖㫽㯝㯟㼾䃙䌒䍡䎑䎼䐂䘵䚄䟿䡜䩮䱚䴪侓僇剹勎勠圥坴塶娽峍廘彔录戮摝椂樚淕淥渌漉潞熝琭璐甪盝睩硉碌祿禄稑穋箓簏簬簶籙粶膔菉蔍蕗虂螰觮賂赂趢路踛蹗轆辂辘逯醁錄録錴鏕鏴陆陸露騄騼鯥鵦鵱鷺鹭鹿麓𠀽𡀔𡴆𡷏𢊩𢫫𢯅𢾬𣞓𣩏𣼟𤝮𤟘𤢊𤨍𤺼𤻱𤽺𤿴𥀔𥈛𥉶𥒨𥚊𥛞𥛪𥣤𥫰𥲎𦋔𦌕𦌟𦗓𦪇𦸐𦼋𦽂𦽎𦾞𦾷𦿖𧌉𧌍𧐳𧨹𧽥𨁸𨌠𨏔𨽐𩅄𩌫𩓪𩛼𩣱𪍄𪒏])),
					result  => q(lù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[枦氇舮鈩])),
					result  => q(lu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䕡榈氀膢藘郘閭闾馿驢驴鷜𢣻𤁵𤗬𥰠𥶆𦝼])),
					result  => q(lǘ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛎㭚㻲㾔侣侶儢吕呂屡屢履挔捋捛旅梠祣稆穞穭絽縷缕膂膐褛褸鋁铝𡡎𢈚𢙲𣭇𤾺𦛗𦭯𦳭𧃒𧈔𧜊𩄽𪈜])),
					result  => q(lǚ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔧㠥㲶䔞䥨勴垏寽嵂律慮櫖氯滤濾爈率箻綠緑繂绿膟葎虑鑢𠜈𠣊𠷈𡀿𡾅𢅞𢟳𢯰𣀞𤝽𥖼𥡢𥭐𥶌𦆾𦊼𧍶𧓻𧭜𩥆𩲦𩳡𩴐])),
					result  => q(lǜ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[焒])),
					result  => q(lü),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝈㡩㱍䖂䜌圝圞奱娈孌孪孿峦巒挛攣曫栾欒滦灓灤癴癵羉脔臠虊銮鑾鵉鸞鸾𢌕𢺈𤲶𤼙𦣋𦣏𧖘𨄄𨇼𨈌𨈎𨊟𩪾𪢮])),
					result  => q(luán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[卵𡡗])),
					result  => q(luǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[乱亂釠𠦨𡄹𡭸𢿢𣨀])),
					result  => q(luàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑼㔀㗉㨼䂮䌎䛚䤣圙擽畧稤鋝鋢锊𠢌𠼟𦊹𧎾𧐋𧐯𧑀𧕌𪅅])),
					result  => q(lüè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[抡掄])),
					result  => q(lūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖮㷍䈁䑳仑伦侖倫囵圇婨崘崙惀棆沦淪綸纶腀菕蜦踚輪轮錀陯鯩𠔕𠼩𤷔𧱜])),
					result  => q(lún),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[埨碖稐耣𤲕𦓾])),
					result  => q(lǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[溣論论𡃝𧣵])),
					result  => q(lùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[磮])),
					result  => q(lun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[啰囉罗頱𠜖𪑋])),
					result  => q(luō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑩㼈㽋䊨䯁儸攞椤欏猡玀箩籮罖羅脶腡萝蘿螺覙覶覼逻邏鏍鑼锣镙饠騾驘骡鸁𡤢𡿏𣜄𤄷𥡜𦆁𦣇𦣖𦣛𦿌𧄿𧷳𨰠𩎊𩮹𩵇𩼊𩽰𪈰𪎆𫌨])),
					result  => q(luó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒩㦬㩡㰁倮剆曪瘰癳臝蓏蠃裸躶𠻡𡆆𢅾𣂞𣜢𣨪𣵟𤔖𤔝𤗀𤨗𨟥𨬅𩉙])),
					result  => q(luǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓢㞅㪾㱻㴖㿚䀩䇔䈷䉓䌱䌴䎊嗠峈摞泺洛洜漯濼犖珞硦笿絡纙络荦落鉻雒駱骆鮥鴼鵅𠉗𠏢𠶱𠻐𡁆𢺆𢺑𣎆𣛗𣧳𤽥𤽼𥯛𧈦𧟌𧭥𧹐𨇽𨏒𩂣𩊚𩌭𩍪𪇱𪌳])),
					result  => q(luò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[呣])),
					result  => q(ḿ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[妈媽嬤嬷孖𢳀])),
					result  => q(mā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦄䗫䳸犘痲蔴蟆蟇麻𡻤𢋚𤳂𥀏𥉵𩀪𩔶𩔷𪐎𪓹])),
					result  => q(má),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻢㐷䣕䣖溤玛瑪码碼蚂螞鎷馬马鰢鷌𥧓𨰾])),
					result  => q(mǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑻㜫㨸㾺䧞䯦傌唛嘜杩榪犸獁睰礣祃禡罵閁駡骂鬕𢉿𣨜𥉊𧪨𩊃𩨲𩶞𪒜])),
					result  => q(mà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[亇吗嗎嘛嫲遤])),
					result  => q(ma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜥㦟䁲䚑䨪埋薶霾𢠼𨤢𩍃])),
					result  => q(mái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[买嘪荬蕒買鷶𠿆])),
					result  => q(mǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻨䘑䜕䨫䮮佅劢勱卖売脈脉衇賣迈邁霡霢麥麦𥇯𥌚𦏢𦙻𧱘𩈗𩊍𪄳𪒪])),
					result  => q(mài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嫚颟])),
					result  => q(mān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒼㙢䅼䊡䐽䒥䛲䟂䯶䰋僈姏悗慲樠瞒瞞蛮蠻謾谩鞔顢饅馒鬗鬘鰻鳗𢦈𤜘𥊑𥧭𥲑𦔔𧜞𧱼𨲛𨲾𩆓𩮉𪈿𪍩𪑪])),
					result  => q(mán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛧䜱屘満满滿睌矕螨蟎襔鏋𥬈𥲈𦎌𧆏𧖵𩈦𩛎])),
					result  => q(mǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗈㡢㬅㵘䕕䝡䝢䡬墁幔慢摱曼槾漫澷熳獌縵缦蔄蔓鄤鏝镘𡢚𡻩𢿜𣁜𤅎𩅍])),
					result  => q(màn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[蘰])),
					result  => q(man),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[牤𡘪𤛘𩛲])),
					result  => q(māng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝑㟌㡛㤶㻊䅒䈍䓼䵨吂哤娏尨庬忙恾杗杧氓汒浝牻狵痝盲硭笀芒茫蛖邙釯鋩铓駹𡩩𡩽𡵀𣙷𤰡𥆙𥐞𥝕𦎨𨛌𩒿𩭒𩷶])),
					result  => q(máng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟐㟿㬒䁳䒎䖟壾漭硥茻莽莾蟒蠎𠈵𡅖𣯬𥤩𥮎𦜭𩅁𩙸𩪎𪁪𪚢])),
					result  => q(mǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𠮵𥁃𥭚])),
					result  => q(màng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[猫貓𤚜])),
					result  => q(māo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝟㮘㲠䅦䭷兞堥嫹旄枆毛氂渵牦犛矛罞茅茆蝥蟊軞酕錨锚髦髳鶜𡹰𣬵𣭮𣹪𤛖𤝄𥎟𧍟𧐟𧒚𧓿𧔨𨈥𨥨𨦜𩬞𩭾])),
					result  => q(máo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚹㧇乮冇卯夘峁戼昴泖笷蓩铆𠔼𡜢𢨯𥄸𨺸])),
					result  => q(mǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒵㒻㡌㧌㪞㫯㴘㺺㿞䀤䋃䓮䡚䫉冃冐冒媢帽愗懋暓柕楙毷瑁皃眊瞀耄芼茂萺蝐袤覒貌貿贸鄚鄮𠤝𢂹𢅉𢘅𢝌𢯾𢽢𣊃𣔺𣨇𣯀𣴟𣴼𤥰𤲰𥈆𥟪𦀸𦼪𧠊𨩩𩛨𩫁𩿂𪃑])),
					result  => q(mào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[么嚒嚜濹癦麼])),
					result  => q(me),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙁㺳䊈䍙䤂呅坆堳塺娒媒嵋徾攗枚栂梅楣楳槑沒没湄湈煤猸玫珻瑂眉睂矀禖穈脄脢苺莓葿蘪郿酶鋂鎇镅霉鶥鹛黴𠪃𣟸𤚤𦼻𧳬𨉭𨜘𩋿𪂜𪃏𪉏𪎭])),
					result  => q(méi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䆀䓺䜸凂媄媺嬍嵄挴毎每浼渼燘美腜鎂镁黣𠍨𢮇𪎦])),
					result  => q(měi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㭑䀛䉋䰨䰪䵢妹媚寐抺旀昧沬煝痗眛睸祙篃蝞袂跊韎鬽魅𠊉𡲭𤽃𥞊𥧴𧭵𩈐𩎟𩫍𩲈𩴈])),
					result  => q(mèi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[躾])),
					result  => q(mei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻔䊟䫒亹扪捫玧璊菛虋鍆钔門閅门𣯩𤅣𧄸𨳔𨴺𩑥𩔉])),
					result  => q(mén),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥃㦖㱪㵍悶懑懣暪焖燜闷𧴺])),
					result  => q(mèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[们們椚])),
					result  => q(men),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙹㠓㩚䀄䇇䉚䑃䑅䒐䗈䙦䙩䟥䤓䥰䰒䲛䴌䴿䵆儚冡幪懞曚朦橗檬氋濛甍甿盟瞢矇矒礞艨莔萌萠蒙蕄蘉虻蝱鄳鄸霿靀顭饛鯍鸏鹲鼆𠐁𠐧𡚔𢄐𢤘𢿂𣊔𣞑𣰥𤼁𥄁𥌯𥌱𥣛𥭮𦆟𦊽𦢧𦫰𦱋𦳶𦴔𦷹𦿏𧀆𧁊𧂛𧂡𧞑𧭊𧲍𨞫𨢊𨢠𨣘𨨸𨼿𩄖𩟞𩦺𩴲𩶡])),
					result  => q(méng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䁅䏵勐懜懵猛獴瓾艋蜢蠓錳锰鯭𡬆𢕙𣓝𤯻𤱴𤾬𥂂𥋝𧓨𩕱])),
					result  => q(měng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜴㝱䓝䠢䥂夢夣孟梦溕霥𠖆𠵼𡒯𡬌𣽭𥉕𧀧𨮒𩆽𪅇𪇓𪈆])),
					result  => q(mèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[掹擝])),
					result  => q(meng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[咪眯瞇])),
					result  => q(mī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜷㟜㣆㸏䉲䊳䌕䍘䕳䕷䛧䤍䥸䴢冞弥彌戂擟攠瀰爢猕獼瓕祢禰糜縻罙蒾蘼詸謎谜迷醚醾醿釄镾靡鸍麊麋麛𠞧𡄣𡇒𡝠𡬐𡾱𢇲𤦀𥇆𥇎𥈕𥎖𥭫𥮜𥵨𥹄𥽰𥿫𦖬𦗕𦞟𦟂𦰴𧠟𨒲𨢥𨣾𩔢𩞇𩸹𪋗𪋢𪎗𪓬𪕈])),
					result  => q(mí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝥㠧㥝㳽䋛䭧䱊侎孊弭敉沵洣渳濔灖眫米羋脒芈葞蔝銤𡓭𢘺𣧲𥹫𨇻𨷬𪀿𪎔])),
					result  => q(mǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜆㨠㫘㳴㴵㵋㸓䁇䈿䌏䌐䖑䛑䣾䤉䮭冖冪嘧塓宓宻密峚幂幎幦榓樒櫁汨沕泌淧淿滵漞濗熐祕秘簚糸羃蔤藌蜜覓覔覛觅謐谧鼏𡊭𡲼𢆯𢞞𢱮𣓔𤛬𥁑𥉴𥉿𥧧𦣥𦸡𧐎𧕵𧱻𧵬𧶡𧷦𧼊𧽨𨢎𨣯𪅮𪑸𪒄])),
					result  => q(mì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒙㝰㮌㰃䃇䏃䫵䰓婂媔嬵宀棉檰櫋眠矈矊矏綿緜绵臱芇蝒𡒳𡯫𢣔𣡠𥊿𥌂𧭇𧸨𪁼])),
					result  => q(mián),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻪㝃㤁㨺㻰䀎䤄䩄丏偭免冕勉勔喕娩愐汅沔渑湎澠眄絻緬缅腼葂鮸麫黽黾𡕢𢃮𣧾𦬛𨟺𨡞𩋠𩾃])),
					result  => q(miǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㴐䛉糆面靣麪麵麺𡧍𡧒𣅍𥄝𥤵𥻩𦽃𨉥𩈹])),
					result  => q(miàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[喵])),
					result  => q(miāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑤䁧䖢媌描瞄緢苗鱙鶓鹋𩳸𪃦])),
					result  => q(miáo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦝杪淼渺眇秒篎緲缈藐邈𠋝𡡺𢤧𢷕𦳥𪃐])),
					result  => q(miǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[妙庙庿廟玅竗𢚋𤾛𥭝])),
					result  => q(miào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[乜吀咩哶孭𠺗])),
					result  => q(miē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𥄲])),
					result  => q(mié),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒝㩢䁾䈼䌩䘊䩏幭懱搣櫗滅灭烕篾蔑薎蠛衊覕鑖鱴鴓𡖺𡞙𡟬𢦼𢧞𢨖𤊾𤏿𥉓𥋚𥣫𥵒𥸴𥾝𦇪𧀅𧂝𨣱𩔠𩱷𪇴𪌺𪒍])),
					result  => q(miè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺠㟩㟭㨉䁕䂥䃉䋋䝧䟨䡑䡻䪸䲄姄岷崏忞怋捪敯旻旼民珉琘瑉痻盿砇碈緍緡缗罠苠鈱錉鍲鴖𣱈𣷠𤇜𤸅𦈏𦳜𧌙𩭷𪂆𪉎])),
					result  => q(mín),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞶㥸㬆僶冺刡勄悯惽愍慜憫抿敃敏暋泯湣潣皿笢簢蠠閔閩闵闽鰵鳘𠊟𢼖𢽹𣱉𣹒𤛎𤺖𤿕𥜐𦌡𦫮𧁋𧲃𨏵𪄴])),
					result  => q(mǐn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[垊笽])),
					result  => q(min),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝠䄙䆩䊅䫤䳟冥名嫇明暝朙榠洺溟猽眀眳瞑茗蓂螟覭鄍銘铭鳴鸣𥌏𥹆𥿨𦡉𧱴𪗸])),
					result  => q(míng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟰㫥佲凕姳慏酩𠋶𥥊𩣶])),
					result  => q(mǐng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䒌命椧詺𡥸𦫭𧟠𪂤])),
					result  => q(mìng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[掵])),
					result  => q(ming),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𨱯])),
					result  => q(miǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[謬谬])),
					result  => q(miù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[摸])),
					result  => q(mō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䃺䭩䯢劘嚤嚩嚰嫫庅摩摹擵模橅磨糢膜蘑謨谟饃饝馍髍魔麽𠻚𡠜𡡉𡾉𣻕𤋂𤹴𥂓𦟟𨆽𨟖𨰞𨱱𩞁𩟠])),
					result  => q(mó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䩋懡抹𡢜𢣗𣋟𩪮𪎠])),
					result  => q(mǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱳㶬㷬㷵㹮䁼䁿䏞䒬䘃䬴䮬䱅䳮䴲劰唜嗼圽塻墨妺嫼寞帓帞昩暯末枺歾歿殁沫湐漠瀎爅獏瘼皌眜眽眿瞐瞙砞礳秣粖絈纆耱茉莈莫蓦藦蛨蟔謩貃貊貘銆鏌镆陌靺驀魩默黙𠆮𠇱𠡞𠢓𠬛𡈗𡊉𡻟𢄏𢊗𢐖𢗿𣧣𣶊𤣻𤿖𥄕𥕓𥙎𥞪𥬎𥱹𥽘𦅔𦔭𦥦𦫕𦮅𧕤𧕥𧠓𧥟𧰱𧻙𧼟𧿴𩃁𩄻𩌧𩐻𩑦𩑷𩢖𩢷𩥔𩿣𪍇𪍤𪏟𪒂𪒇])),
					result  => q(mò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[尛怽魹麿])),
					result  => q(mo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哞])),
					result  => q(mōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㭌䋷䏬䗋䥐䱕侔劺恈洠牟眸瞴繆缪蛑謀谋踎鉾鍪鴾麰𠥨𢃱𣫬𥿵𦭷𧎄𨴍𩢫𩶢])),
					result  => q(móu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䍒某𠀱𦊋𦊎𦋡𦳑])),
					result  => q(mǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𥆆𦺒])),
					result  => q(mòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䱯墲毪氁𢘃𢜯𤚅𨡭𨢢])),
					result  => q(mú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟂䥈亩坶姆峔拇母牡牳畆畒畝畞畮砪胟踇鉧𠺖𢟨𤝕𤵝𧩒𧬏𧰷𧿹𨈶𩡨𩬍𪎫])),
					result  => q(mǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺫㜈㣎㧅㾇䀲䊾䑵仫募墓幕幙慔慕暮木朰楘毣沐炑牧狇目睦穆縸艒苜莯蚞鉬钼雮霂鞪𡵬𣈊𤝂𥄈𥣸𥰻𦃤𦱒𧚀𨍎𨎸𩵦𩶖𩶩])),
					result  => q(mù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[凩])),
					result  => q(mu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嗯])),
					result  => q(ń),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕶])),
					result  => q(ň),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𠮾])),
					result  => q(ǹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𧗈])),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䛔䫱嗱拏拿挐鎿镎𡰀𢜲𣸏𤓷𤔀𦬻𧘽𧤣𧦮])),
					result  => q(ná),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[乸哪雫𢡏𣡰𥑒𦙜𪐀])),
					result  => q(nǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨥㵊䇱䈫䎎䏧䖓䖧䟜䪏吶呐妠娜捺笝納纳肭蒳衲袦豽貀軜那鈉钠靹魶𠕄𠱲𠴾𡤙𡷝𢇵𣅚𣹵𤝒𤬷𤭠𤱅𤱆𤷈𤸏𤸻𥍲𥹉𥿃𦛐𦣀𧋡𧰹𨙻𨚗𩏼𩚛𩟿𩮅𩹾𪌅𪗝])),
					result  => q(nà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜨㾍䍲䘅䯮孻摨熋腉𪌞])),
					result  => q(nái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[乃倷奶妳嬭廼氖疓艿迺釢𠧤𢉓𦠸𦶅𨎡])),
					result  => q(nǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㮈㮏㲡奈柰渿耏耐萘螚褦錼鼐𡞫𡨵𡮙𣉘𣮦𥉃𦓎𦔹𦳐𨒨𩹟])),
					result  => q(nài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[囡])),
					result  => q(nān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓓㽖䔜䛁䶲侽南喃娚暔枏枬柟楠男畘莮諵难難𢪈𤌔𤱣𤽲𦶈𧇙𧕴𨴌𨴘𨵴𩹞])),
					result  => q(nán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㫱䈒䊖戁揇湳腩萳蝻赧𡆤𡆱𡆲𦝧𧹞𨠹𨦳𩈑𩈶])),
					result  => q(nǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬮婻𢬷𤿏𦍀𦛚𩅠])),
					result  => q(nàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[遖])),
					result  => q(nan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[囔])),
					result  => q(nāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䁸乪嚢囊欜蠰譨饢馕鬞𦗳𦣘𧖒])),
					result  => q(náng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㶞擃攮曩灢𩜒])),
					result  => q(nǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚂儾齉𠶬𡿝𢖧𦈃𧅺𧟘𨳆])),
					result  => q(nàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[孬])),
					result  => q(nāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞪䃩䛝䴃呶夒峱嶩巎怓憹挠撓猱硇碙蛲蟯詉譊鐃铙𡽧𡾂𢙐𢜸𢪼𤞍𤡤𤫕𥐻𥑪𧴓𨥸𩖯𩫔𫍢])),
					result  => q(náo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑎㛴㺁䜀䜧匘垴堖嫐恼悩惱獶獿瑙碯脑腦𠊦𠡷𡍍𡿺𢅈𢉵𣭺𤊲𤋫𤷻𥀮𥒢𦗮𧩣𧳦𧴙𨱵𩛋𩤘𩩀𩫺𩬷])),
					result  => q(nǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[婥淖臑閙闹鬧𣧽𥆲𩋈𩯆])),
					result  => q(nào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[脳])),
					result  => q(nao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕯䅞䎪䭆抐疒眲訥讷𢗉𣧍𧤜])),
					result  => q(nè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[呢])),
					result  => q(ne),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𠑚𠑛𡣢𢅼𨡌])),
					result  => q(néi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㼏䲎娞脮腇餒馁鮾鯘𥡭𩗔])),
					result  => q(něi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐻㨅內内氝錗𢁩𢛉𣓃𩬀])),
					result  => q(nèi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜛㯎㶧嫩嫰恁𡞾𧮠𨈗])),
					result  => q(nèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㴰䏻能𢆂𨃳])),
					result  => q(néng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𠹌𨶙])),
					result  => q(něng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㲌])),
					result  => q(nèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[妮])),
					result  => q(nī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞾㪒㹸䘦䘽䛏䝚倪坭埿婗尼屔怩棿泥淣猊秜籾聣腝臡蚭蜺觬貎跜輗郳铌霓鯓鯢鲵麑齯𠆵𠽬𡎿𣢞𣭙𤦤𦤽𦦃𨋗𩚯𩩢𩱄𩸦𩸧𩾆𫐐])),
					result  => q(ní),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩘䕥䦵伱你儗儞孴抳拟擬旎晲柅檷狔聻苨薿鈮隬馜𡥦𡥨𢅟𢘝𢣚𣡋𤙌𥜦𥜬𥷄𦆦𦰫𧃩𨀀𩉹𩋪𩍦𩯨𩰞𪏸])),
					result  => q(nǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠜㥾㦐㲻㵫䁥䘌䵑䵒伲匿堄嫟嬺屰惄愵昵暱氼溺眤睨縌胒腻膩誽迡逆𠱘𠸺𡎳𡞭𡣁𡫸𡬗𢚮𢛜𢦱𣘗𣲷𥄽𥇄𥺜𦮾𧈞𧏾𧖷𧵼𧺰𨺙𨽦𩈢𩺝𩺱𪏵𪐌𪙛])),
					result  => q(nì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[袮])),
					result  => q(ni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[拈蔫𥺴])),
					result  => q(niān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䄭䄹䬯哖年秊秥鮎鯰鲇鲶黏𠫺𦷙𨚶𩽴𪐇])),
					result  => q(nián),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜤㞋㮟䚓捻撚撵攆涊淰焾碾簐跈蹍蹨躎輦辇辗𠕟𠗋𠣇𡰫𣐏𤁥𦭁𨇍𨋚𨴞𩉄𩊫𪑮])),
					result  => q(niǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㲽䧔卄唸埝姩廿念艌鼰𡝟𣎔𤽿𥮘𦁇𨢯])),
					result  => q(niàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鵇])),
					result  => q(nian),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[娘嬢孃])),
					result  => q(niáng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𪓃])),
					result  => q(niǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䖆酿醸釀𥽬])),
					result  => q(niàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻦㒟㜵㠡㭤䃵䙚䦊䮍嫋嬝嬲樢茑蔦袅裊褭鳥鸟𠒰𡘏𡝋𡝒𡠿𢶑𢸣𣟊𥤂𥾇𨽖𩖔𩭑𪅝𪈼])),
					result  => q(niǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞙㳮尿脲𨳀])),
					result  => q(niào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[捏揑])),
					result  => q(niē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡪苶𢫻𪌿])),
					result  => q(nié),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𠈊])),
					result  => q(niě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖏㖕㖖㘝㘨㘿㙞㚔㜸㩶㮆㴪㸎䂼䄒䇣䌜䌰䡾䯀䯅䯵䳖啮喦嗫噛嚙囁囓圼孼孽嵲嶭帇惗摰敜枿槷櫱涅湼痆篞籋糱糵聂聶臬臲菍蘖蠥讘踂踗蹑躡錜鎳鑈鑷钀镊镍闑陧隉顳颞齧𠶿𡆣𡍤𡰆𡴎𡶫𡸣𡾦𡾲𡿖𡿗𢈸𣀳𣌍𣙗𣯭𣰼𤭂𤴘𤶚𤺐𥔄𥬞𥬬𥮤𦄌𦈙𦘒𦛠𦞆𦯖𦵐𧁈𧋖𧞍𧻼𨊞𨙓𨱺𨲀𨶠𨻄𩋏𩐭𩒕𩖁𩣘𪌊𪎃𪎅])),
					result  => q(niè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[巕])),
					result  => q(nie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤛䋻䚾囜您𠽝])),
					result  => q(nín),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[拰])),
					result  => q(nǐn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[脌])),
					result  => q(nin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝕㲰䆨䗿䭢儜凝咛嚀嬣宁寍寕寗寜寧拧擰柠檸狞獰甯聍聹苧薴鑏鬡鸋𡫃𣍆𤕦𤹧𤻝𥣗𥧤𦡼𧃱𧕝𧭈𫛢])),
					result  => q(níng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[橣矃𥳥𦡲𩕳])),
					result  => q(nǐng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣷㿦䔭佞侫泞濘𧑗])),
					result  => q(nìng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[澝])),
					result  => q(ning),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[妞])),
					result  => q(niū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺧㖻䒜汼牛𨷁𩲍𩵠])),
					result  => q(niú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㺲䂇䏔忸扭炄狃紐纽莥鈕钮靵𣧊𣲶𥀝𥍳𥝦𧘥𨋀𨙺𨳞𩈇𪏲])),
					result  => q(niǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䋴衂𩙷𩚖])),
					result  => q(niù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[牜])),
					result  => q(niu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㶶㺜䢉侬儂农哝噥檂欁浓濃燶禯秾穠脓膿蕽襛農辳醲𥂒𨑊𨲳𩅽𩇔𩟊𪆯𪒬])),
					result  => q(nóng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䵜繷])),
					result  => q(nǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[弄挊癑齈𠘊])),
					result  => q(nòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝹䨲羺𠲴𢉕𣻖𤟦𥀫𧂦𧃨𧅘𩆟𩒔])),
					result  => q(nóu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜌㳶啂𡝦𡨻𡭾])),
					result  => q(nǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䅶䘫䰭槈檽獳耨譳鎒鐞𢉚𪋺])),
					result  => q(nòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚢奴孥笯駑驽𥤨𥱂])),
					result  => q(nú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[伮努弩砮胬𠴂𢪦𢫓𥅄𧉭𪺹])),
					result  => q(nǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[傉怒搙𢫭𥛑𧪅𧿔])),
					result  => q(nù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𦓕])),
					result  => q(nǘ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[女籹釹钕])),
					result  => q(nǚ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㵖䖡䘐䚼䶊恧朒沑衄𥄋𥍞𦓖])),
					result  => q(nǜ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[奻])),
					result  => q(nuán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬉暖渜煖煗餪])),
					result  => q(nuǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𪋐])),
					result  => q(nuàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䖈䖋䨋疟瘧硸虐𨵫])),
					result  => q(nüè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[黁])),
					result  => q(nún),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑚㔮㰙傩儺挪梛郍𠹈𡖫𡬥𡿊𢰜𤘟𦡃𦩜𨁌𨎭𩴓])),
					result  => q(nuó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛂㡅橠𡖔𣃽𣆚𩈺𩷁])),
					result  => q(nuǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐡㖠䚥喏愞懦懧掿搦搻榒稬穤糑糥糯諾诺蹃逽锘𠸱𢜪𢾲𥑽𥻾𦀨𦂍𦓢𧣚𧣺])),
					result  => q(nuò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[喔噢])),
					result  => q(ō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哦])),
					result  => q(ó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[筽])),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䉱䌔䙔䥲塸櫙欧歐殴毆沤漚熰瓯甌謳讴鏂鴎鷗鸥𠢔𠥝𡂿𡈆𡩾𣂻𤛐𥈬𥱸𩔸])),
					result  => q(ōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[膒齵𦂕𪙃])),
					result  => q(óu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒖㼴偶吘呕嘔耦腢蕅藕𠙶𠴰𣢨𤵎𥐂𥧆𥻑𧖼𧪓𪊪])),
					result  => q(ǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䌂怄慪𣉾𣓕𣽕𤁮𩀫𩥋])),
					result  => q(òu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[藲])),
					result  => q(ou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䔤䯲啪妑皅舥葩趴𣧜𣱺𤆵𤽉𥐙𦐆𧣃𨋐𩈆])),
					result  => q(pā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[掱杷潖爬琶筢𣚒𧑡𧣣])),
					result  => q(pá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𥩙])),
					result  => q(pǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[帊帕怕袙𪗔])),
					result  => q(pà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[拍𣖐𦫖𩛇])),
					result  => q(pāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䱝俳徘排棑牌犤猅簰簲輫𣝁𥱼𥴖𦩯])),
					result  => q(pái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[廹])),
					result  => q(pǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㭛㵺䖰哌派湃蒎鎃𠂢𠸁𣏟𣲖𣴪𥯟𥿯𦔠𧵠])),
					result  => q(pài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐴㢖㽃䆺攀潘畨眅砙𤄜𤺏𥕿])),
					result  => q(pān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䃲䰉䰔媻幋搫槃洀瀊爿盘盤磐磻縏蒰蟠跘蹒蹣鎜鞶𠽲𣁦𣔚𤖭𤠍𤻷𥈼𥉟𦪹𨂝𨃞𨃟𪄀𪒀])),
					result  => q(pán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𧺾])),
					result  => q(pǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[冸判叛拚沜泮溿炍牉畔盼聁袢襻詊鋬鑻頖𡞟𢰿𤄧𥌊𦙀𨒃])),
					result  => q(pàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鵥])),
					result  => q(pan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䏺䨦乓沗滂胮膖雱霶𠗵𠦲𣂆𦣂𧿆𩅅𩐨𪐿𪔔])),
					result  => q(pāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥬㫄䅭䠙厐厖嫎庞徬旁舽螃逄鳑龎龐𡅃𢐊𤧭𧔧𨜷𩃎])),
					result  => q(páng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䒍嗙耪覫])),
					result  => q(pǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕩炐肨胖𥪴𦜍𩈈])),
					result  => q(pàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㯱㲏䫽抛拋脬𣟏𩆘])),
					result  => q(pāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚿䩝刨匏咆垉庖炰爮狍袍軳鞄麃麅𡂘𡯈𡾌𣮃𤔉𥶔𧙌𩎘𩎾𩐜𩗥𪊳])),
					result  => q(páo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[跑𢾳𦐸])),
					result  => q(pǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘐㯡䶌奅泡炮疱皰砲礟礮麭𠣳𡧙𣕅𣚇𣶐𦠖𨋛𨣙𩂞])),
					result  => q(pào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[萢褜])),
					result  => q(pao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚰呸怌柸肧胚衃醅𤬃𥹂𦙂𩎜𩵣])),
					result  => q(pēi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟝㯁䣙䫊培毰裴裵賠赔锫阫陪駍𣬆𣯱𤗏𦸪𧳏𧴥𨓿𨛬𩑢])),
					result  => q(péi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[俖𣍺])),
					result  => q(pěi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤄㧩㳈㾦䊃伂佩姵嶏帔斾旆沛浿珮笩轡辔配霈馷𢁖𢘀𢥐𥄔𨙶𩖭])),
					result  => q(pèi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[蓜])),
					result  => q(pei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖹喷噴歕𠽾])),
					result  => q(pēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[湓瓫盆葐𡺜𪂽])),
					result  => q(pén),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[呠翸])),
					result  => q(pěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[喯𠺔])),
					result  => q(pèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛁㠮㧸䍬䥋䦕匉嘭怦恲抨梈漰澎烹砰硑磞軯閛𡼜𢏳𢼩𢽩𤘾𦚝𦯰𨑎𨠟𨺀𩱀])),
					result  => q(pēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥊㱶䄘䡫䰃䴶倗堋塳弸彭憉挷朋棚椖槰樥熢硼稝竼篣篷纄膨芃莑蓬蟚蟛輣錋鑝韸韼騯髼鬅鬔鵬鹏𡂫𥕱𦪪𧌇𧚋𧴂𨂃𨍩𨎧𨎳𨲰𩄦𩐛𩖛𩡕𪔍])),
					result  => q(péng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[剻捧淎皏𡗗𢪋𣨞])),
					result  => q(pěng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㼞掽椪碰踫𣟀𤖳𥕽𨅘𩸀])),
					result  => q(pèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨢㱟䫠䯱丕伓伾劈噼坯悂憵批披抷旇炋狉砒磇礔礕秛秠紕纰翍耚豾邳鈈鈚鈹鉟銔錍铍霹駓髬魾鮍𠜱𠡄𠹦𡛡𡲮𢓖𢞗𢱧𢻹𢾱𣢋𣬮𣬼𤬭𤱍𤿎𤿐𦀘𧧺𧪫𨤽𨧦𩣚𪄆𪉔])),
					result  => q(pī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓟㮰㯅㼰䲹䴽啤埤壀岯崥朇枇毗毘毞焷狓琵疲皮篺罴羆肶脾腗膍芘蚍蚽蚾蜱螷豼貔郫阰陴魮鲏鵧鼙𠨸𠵬𡦟𡶌𢇳𢰘𣓋𣔬𣖰𣪉𣬉𤘢𤘹𤷒𤼜𥤻𥯡𦃋𦊁𦨭𦳈𦹽𧑜𧓎𧲺𧳼𧴉𨈚𨻀𩗫𩫫𪊕𪌈])),
					result  => q(pí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䚰䚹䤏䫌䰦仳匹噽嚭圮庀擗疋痞癖脴苉諀銢鴄𡊝𡛘𡺮𤴣𤿇𥀘𥔁𦘩𦘲𦰽𨑜𨲐𩔙])),
					result  => q(pǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨽㳪㵨㿙䏘䑀䑄䠘䡟䤨䴙僻嚊媲嫓屁揊淠渒潎澼甓疈睥稫譬辟釽闢鷿鸊𠪮𠯔𠯭𢾇𣹚𣹮𤂃𤖿𤘤𤚪𦤢𧾑𨐴𨵡𨵩𨸆𨺤𩜰𪇊𪖞𪛎])),
					result  => q(pì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[榌])),
					result  => q(pi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓲㾫偏囨媥犏篇翩鍂鶣𢉞𢐃𧡤𨲜])),
					result  => q(piān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛹㼐䮁楄楩胼腁諚賆跰蹁駢騈骈骿𠷊𢕨𦳄𧍲𧱩𨂯𨵸𨸇𪘀𪚏])),
					result  => q(pián),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[覑諞谝貵𡎚])),
					result  => q(piǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸤䏒片騗騙骗𠯯])),
					result  => q(piàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[魸])),
					result  => q(pian),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[剽慓旚犥缥翲螵飃飄飘魒𠷻𡢱𡣋𧌠𧽤𨮬𩗏𩙒𪋖])),
					result  => q(piāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㼼䕯䴩嫖瓢竂薸闝𣝐𨝓𩡦])),
					result  => q(piáo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㵱㹾彯殍皫瞟篻縹醥顠𣋳𦭼𪅃])),
					result  => q(piǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬓䏇僄勡嘌徱漂票𣳭𩄷𩮳𪏫])),
					result  => q(piào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[撆撇暼氕瞥𠟈𠢪𢳂𦒐𦗥𩓼𩠿])),
					result  => q(piē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䥕丿苤鐅])),
					result  => q(piě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嫳𤮕])),
					result  => q(piè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡦䎙姘拼礗穦馪驞𢣐𢬵𢶳𥖶𩰗])),
					result  => q(pīn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㰋㺍嚬娦嫔嬪獱玭琕矉薲蠙貧贫頻顰频颦𠐺𡛞𦇖𧔪𧭹𧮝𨏞𩕵])),
					result  => q(pín),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[品榀𠮰𥑓])),
					result  => q(pǐn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[汖牝聘𣎳])),
					result  => q(pìn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䛣乒俜娉涄甹砯竮聠艵頩𢖊𥪁𥭢𦀔𦥚𦥤𨂲𩈚𩩍])),
					result  => q(pīng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㵗㺸㻂䈂䍈䓑䶄凭凴呯坪屏屛帡帲幈平慿憑枰檘泙洴淜焩玶瓶甁箳簈缾胓苹荓萍蓱蘋蚲蛢評评軿輧郱鮃鲆𠗦𡊞𢆟𤭔𤳊𥵪𦚓𦶊𧂋𧏑𩂾𪋋𪔾𪕒])),
					result  => q(píng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䀻𠗥])),
					result  => q(pìng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[塀岼])),
					result  => q(ping),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗶㧊䍨䥽坡岥泊泼溌潑鉕鏺钋頗颇𠰼𠷑𡊟𢂤𤀪𤽌𥬒𦫔𧘟𧙅𨠓𨡩𨫁𨸭𩑼𩸿])),
					result  => q(pō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨇㩯嘙婆櫇皤蔢謈鄱𡼃𢱨𦃡𧂉𨅅𩕏])),
					result  => q(pó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[叵尀笸钷駊𠰐𠵳𡶆𡽠𣲳𤝯𥹖𧿽𨆵𩢘])),
					result  => q(pǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛘䄸䎅䞟䣪䣮䨰䪖䪙䯙岶敀昢洦炇烞珀破砶粕蒪迫醗釙魄𠾌𢶉𣍸𣬚𤖼𥗟𥵜𦍁𦐦𦑀𦑵𦒟𦥭𦥲𦾕𦿍𧴤𨂩𨑝𩊀𩔈])),
					result  => q(pò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[桲])),
					result  => q(po),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䬌剖娝𦵿𧠾])),
					result  => q(pōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧵䯽抔抙捊掊箁裒錇𢒷𦺎𩔻𩚭])),
					result  => q(póu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕻㰴䳝咅哣婄廍犃])),
					result  => q(pǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䮒䲕仆噗扑撲擈攴攵潽陠鯆𡜵𢼹𤆝𤾣𥼜𦬙𧭎𧱹𨁏𪒢𪔿𫚙])),
					result  => q(pū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒒㯷㲫㺪䈬䈻䑑䔕䗱䧤䴆僕匍墣濮獛璞瞨穙纀脯莆菐菩葡蒱蒲襥酺鏷镤𡰿𢈲𤗵𤰑𥐁𥣈𦮑𨛥𨽂𩪛𩯱𪋡𪖈])),
					result  => q(pú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㹒圃圤普朴樸檏氆浦溥烳諩譜谱蹼鐠镨𥐚𥛟𩑀])),
					result  => q(pǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬥曝瀑舖舗鋪铺𣋏𧙛𧦞𩂗])),
					result  => q(pù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[巬巭贌])),
					result  => q(pu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠌㥓㩻㬤㱦䗩䣛䥓䫏七倛僛凄嘁妻娸悽慼慽戚攲期柒栖桤桼棲榿槭欺沏淒漆緀萋蛣諆諿蹊迉郪鏚霋魌鶈𠀁𠎰𠐾𠔶𡖾𡫁𢴰𢻪𣉓𣏶𣛺𣶠𤘌𤳃𤳤𥇚𥉐𥉷𥖫𥤥𦖊𦸓𧋉𧒕𧕉𧠪𨞢𩒛𩺲𪄭𪅾𪒆𪒑])),
					result  => q(qī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻫⻬㖢㟓㟚㟢㩽㯦㰗䄢䅲䉻䐡䑴䓅䓫䞚䟚䡋䧵䩓䭶䭼䰇䱈䲬䳢䶒䶞亓亝俟其剘圻埼奇岐岓崎帺忯愭懠掑斉斊旂旗棊棋檱櫀歧淇濝猉玂琦琪璂畁畦疧碁碕祁祇祈祺禥竒粸綥綦綨纃耆肵脐臍艩芪萁萕蕲藄蘄蚑蚔蚚蛴蜝蜞蠐跂踑軝釮錡锜頎颀騎騏骐骑鬐鬿鯕鰭鲯鳍鵸鶀麒麡齊齐𠁭𠅚𠓪𠫸𡦍𡪵𡹉𡺸𢁒𢍁𢍑𢩡𢺷𢻋𢻚𢾦𢾪𣯆𤪌𤷍𤹸𥉙𥼘𦔌𦫡𦭲𦸗𧌞𧎪𧓑𧡺𧯯𧰙𨉸𨙸𨥦𨪌𨱜𨸒𨸔𩉬𩥂𩦋𩨝𩲪𩳣𩴪𩷾𩹵𪀩𪂛𪄖𪗅𪗆𪗍𪗏𪙧])),
					result  => q(qí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒅㫓䄎䄫䋯䎢䏿䒻䔇䡔䭫䭬乞企启呇唘啓啔啟婍屺岂晵杞棨玘盀綮綺绮芑諬豈起邔闙𠧒𡷞𡹘𡺓𥔩𥫟𦄊𦸆𧘗𧙾𧼘𨙬𩒨𩠦])),
					result  => q(qǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞓㞚㣬䀙䁈䁉䅤䌌䏅䏌䏠䒗䔾䙄䚉䚍䟄䢀䫔䰴呮咠唭噐器夡契弃忔憇憩摖暣栔棄欫气気氣汔汽泣湆湇炁甈盵矵砌碛碶磜磧磩罊芞葺蟿訖讫迄鼜𠊔𠴹𡍪𡢖𡹓𡹩𡻧𡻰𡽼𢍆𢔆𢔠𢜱𢞒𢢖𢢞𢺵𣔘𣫱𣾤𤺗𤼅𥀻𥄜𥉻𥌁𥓾𥷇𥽳𦈦𦘸𦙊𦚊𦛰𦡹𦧉𦧯𦩣𦪊𧇜𧘧𧙞𧚨𧡘𧻕𧼕𧽓𨁐𨊰𨑤𨒅𨵆𩧌𩨘𪔪])),
					result  => q(qì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[渏簯簱籏緕缼螧褄])),
					result  => q(qi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤉掐葜𠜼𠝛𡤫𢮌𣘟𣣟])),
					result  => q(qiā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[拤𡘧])),
					result  => q(qiá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[跒酠])),
					result  => q(qiǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓞㓣㓤㡊䁍䂒䨐䯊䶝冾圶帢恰愘殎洽硈髂𠕣𠜤𠝘𠳌𢼣𣁴𣨄𤫶𤵹𥎸𥦞𥴭𦝣𦸉𧩶𩥌𩩱𩮁𩷻𪘺𫈰])),
					result  => q(qià),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鞐])),
					result  => q(qia),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗔㩃㩷㪠䀒䇂䉦䞿仟佥僉兛千圱圲奷婜孅孯岍悭愆慳扦拪掔搴撁攐攑攓杄檶櫏欦汘汧牵牽瓩签箞簽籤粁臤芊茾蚈褰諐謙谦谸迁遷釺鈆鉛钎铅阡雃韆顅騫骞鬜鬝鵮鹐𠑲𠔺𠠃𠬾𢃥𢋔𢌍𢍱𢜩𢧥𣘝𣟋𣢬𣢲𤠿𤿷𥏥𥜴𥱺𥲢𦖎𧘜𧛓𧟑𧢞𧮮𧲀𧽐𨐋𨐩𨓲𨝍𨦄𨨘𩋆𩨓𩪢𪇇𪉻])),
					result  => q(qiān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦮㨜㩮㸫䁮䈤䕭䖍仱前墘媊岒忴扲拑掮揵榩橬歬潛潜濳灊箝羬蕁虔軡鈐鉗銭錢钤钱钳靬騚騝鰬黔黚𠀼𠢍𠷁𢁮𣖳𥔮𥮒𥴤𥷪𦂒𦴑𦼓𧃑𧣑𨜻𨥞𨱫𨺩𨽨𩨃𩨊𩬚𪈇])),
					result  => q(qián),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦿㧄㹂䇜䭤凵嗛嵰槏浅淺繾缱肷脥膁蜸譴谴遣𠊭𠋵𠳋𡒌𢮄𣍰𣓅𥦃𥧬𥳐𦅋𧥛𧪯𨗦𨺫𩑳𩒣𪘦])),
					result  => q(qiǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐸㜞㟻㯠䈴䊴䑶䥅䪈䵖䵛俔倩傔儙刋堑塹壍嵌悓慊棈椠槧欠歉皘篏篟綪縴芡茜蒨蔳輤鰜𢂺𢃘𣢖𣹥𧚫𧮽𨰂])),
					result  => q(qiàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[竏籖鎆鏲鑓])),
					result  => q(qian),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㳾㾤䤌呛嗆嶈戕戗戧斨枪椌槍溬牄猐玱瑲篬羌羗羫腔蜣謒跄蹌蹡錆鎗鏘锖锵镪𡬎𡺛𢈵𣫝𦯤𦳟𧇞𧱡𧽩𨄚𨶆𩣼𩩝𩿄𪁸𪎞𪙎])),
					result  => q(qiāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺦㩖丬墙墻嫱嬙廧強强樯檣漒牆艢蔃蔷薔蘠𡠥𡸤𢏄𢧅𤕽𧖑𧭚𩼒])),
					result  => q(qiáng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛨墏抢搶繈繦羟羥襁鏹𢐩𥇉𥓌𥶑])),
					result  => q(qiǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䵁唴炝熗羻𥴻𦷦])),
					result  => q(qiàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嗴獇])),
					result  => q(qiang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡑㤍䂭䫞䯨䵲劁墝墽嵪幧悄敲橇毃燆硗磽繑缲趬跷踍蹺郻鄡鄥鍫鍬鐰锹頝骹𠏖𡌔𡩇𢄹𢐟𢮉𢻤𢿣𣂇𣖄𣜽𣦜𥉾𥟅𨃤𨜑𨞶𩖇𩨟])),
					result  => q(qiāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝯䀉䎗䩌䱁乔侨僑喬嘺嫶憔桥樵橋癄瞧硚礄荍荞菬蕎藮谯趫鐈鞒鞽顦𡰑𢘟𣯹𥁢𧄍𨅣𨝱])),
					result  => q(qiáo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚽䂪䲾巧愀釥髜𡺘𢩨𥹶𦢺𨸑])),
					result  => q(qiǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚁㢗㴥䃝䆻䇌俏僺峭帩撬撽殻窍竅翘翹誚譙诮躈陗鞘韒髚𠿕𡰐𢶡𣒆𣹝𣺰𧣌𨜍𪑊])),
					result  => q(qiào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[槗犞])),
					result  => q(qiao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛗𠋧𡛠𥕑])),
					result  => q(qiē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚗䦧癿聺𡶐𨚧])),
					result  => q(qié),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[且𠀃])),
					result  => q(qiě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓶㗫㛍㤲㥦㹤㼤㾀㾜䟙䤿切匧妾怯悏惬愜挈朅洯淁穕窃竊笡箧篋緁藒蛪踥郄鍥鐑锲鯜𠁠𠩂𠲵𡂠𡐤𡝍𢲶𢺅𣠺𤴼𤷾𥪵𥿚𦆍𦼰𦿋𧑨𧚪𧫕𧻘𧻧𨄊𨉪𨖰𩣴𪑗𪙌])),
					result  => q(qiè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[倿媫籡苆])),
					result  => q(qie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓎㾣䃢䜷亲侵媇寴嵚嶔欽綅衾親誛钦顉駸骎鮼𡵑𣆲𣢐𤥓𥍯𧯃])),
					result  => q(qīn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕋㘦㢙㩒㪁㮗䔷䦦䰼勤嗪噙埁嫀庈慬懃懄捦擒斳檎溱澿珡琴琹瘽禽秦耹芩芹菦菳蚙螓蠄鈙雂靲鬵鳹鵭𠓿𠘅𣜣𣪄𤚩𤴽𥎊𥎡𥘋𥱧𨙽𨛣𨾰𩎖𪒭𪒯])),
					result  => q(qín),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝲㾛坅寑寝寢昑梫笉螼赾鋟锓𠔎𠻨𡫧𢫲𤙋𤿳𥵧𦯈𧼒𧾏𩓒𩔟𪙟])),
					result  => q(qǐn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞬㤈䈜吢吣唚抋揿搇撳沁瀙菣藽𠖶𠜘𠦎𡹢𢱶𣖯𣨠𤵂𦧋𩂈𩐙𩔝])),
					result  => q(qìn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻘䨝倾傾卿圊埥寈氢氫淸清狅蜻輕轻郬鑋靑青鲭𠑴𠨍𣫨𥃟𧕙𨆪𨓷𨻺𩑭𩗼𪏅])),
					result  => q(qīng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㯳䞍䲔剠勍夝情擎擏晴暒棾樈檠殑氰甠葝黥𣩜𧖪𩷏𩽡𪄈])),
					result  => q(qíng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩩㷫䔛䯧庼廎檾漀苘請请頃顷𠗝𡄇𡲀𢹃𩒵𩔥])),
					result  => q(qǐng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㵾䋜䡖凊庆慶掅殸碃磘磬箐罄謦靘𡄔𤭩𥱨𩇝𩇟])),
					result  => q(qìng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[櫦硘])),
					result  => q(qing),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[匔芎𥑎])),
					result  => q(qiōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑋㒌㧭㮪㷀㼇䅃䆳䊄䓖䛪䠻儝卭宆惸憌桏橩焪焭煢琼璚瓊瓗睘瞏穷穹窮竆笻筇舼茕藑藭蛩蛬赹跫邛銎𠌖𠤊𡊼𡞦𡦃𡸕𡺺𢞏𢶇𣇬𣋶𣑦𣜧𤢶𤤑𤤶𥑱𥨪𥳎𦦧𦨰𦭭𦾵𨀯𨍶𩑓𩢽𩨯𩬛𩬰𪀛])),
					result  => q(qióng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𢮍𣶆])),
					result  => q(qiòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[熍])),
					result  => q(qiong),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐀㚱㳋䆋䐐䠓䨂䲡丘丠坵媝恘楸秋秌穐篍緧萩蓲蚯蝵蟗蠤趥邱鞦鞧鰌鰍鳅鶖鹙龝𠀉𠰋𡊣𥔻𥫷𧇸𧏋𧲰𨍊𪍗𪚺])),
					result  => q(qiū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕤㛏㞗㟈㤹㥢㧨㭝㷕㺫䊵䎿䜪䟵䣇䤛俅叴唒囚崷巯巰扏梂殏毬求汓泅浗渞湭煪犰玌球璆皳盚紌絿肍莍虬虯蛷蝤裘觓觩訄訅賕赇逎逑遒酋醔釓釚銶鮂鯄鰽鼽𠗈𡲚𢈝𢘄𢛃𢦎𣧝𣭳𤕾𤞰𥥽𥭑𦬖𦰪𧔭𧣕𧤕𧺤𧻱𨒊𨟽𨱇𨲒𨺧𩒮𩔕𩗕𩵍𩾁])),
					result  => q(qiú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[搝糗𦦄𧻁𩈸𩝠])),
					result  => q(qiǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䟬䠗𨕦𪖛])),
					result  => q(qiù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[蘒釻])),
					result  => q(qiu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘗㠊㭕㸖㻃䈌䒧䒼䓚䓛䖦䢗䧢伹佉匤区區坥屈岖岨岴嶇憈抾敺曲浀祛筁粬紶胠蛆蛐袪覰覻詘誳诎趋趨躯軀镼阹駆駈驅驱髷魼鰸鱋麯麴麹黢𡱅𡳆𢌷𢴮𢼰𣮈𥬔𥶶𥺷𥽧𦛕𦛱𦸶𧌑𧐅𧠢𧾶𨄅𨧱𨱊𨸟𩖷𩣹𩪍𪌬𪛃])),
					result  => q(qū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖆㜹㣄㯫㲘䂂䆽䋧䝣䞤䟊䵶佢劬忂戵斪朐欋氍淭渠灈璖璩癯瞿磲籧絇翑胊臞菃葋蕖蘧螶蟝蠷蠼衢躣軥鑺鴝鸜鸲鼩𠍲𠏛𠣪𡡥𡱺𡲰𢌄𢎖𢦌𣖪𣯸𣰋𣰠𣰡𣰻𤨎𥃔𥗫𥧻𦄽𦐛𦔬𦕙𦣒𦼫𧄒𧊛𧕎𧝔𧲵𧾱𨎶𨐣𨞙𨞳𨼫𨼽𩇐𩉿𩢳𩧘𩴹𩵅𩽩𩿥𩿩𪀊𪁖𪄊𪆂𪉌𪌆𪍸])),
					result  => q(qú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䶚取娶竘竬蝺詓齲龋𡟥𤖬𦗛𧉧𨓭𪋄])),
					result  => q(qǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧁㫢㰦䁦䠐刞厺去呿唟耝覷觑趣閴闃阒麮鼁𠇯𤙏𩿟])),
					result  => q(qù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[衐迲])),
					result  => q(qu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒽䌯圈圏峑弮恮悛棬鐉駩𠛮𡈉𥁸𦋓𨟠𨩸𩧴])),
					result  => q(quān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒰㟫䀬䑏䟒䠰佺全啳埢姾婘孉巏惓拳搼权権權泉洤湶牷犈瑔痊硂筌絟縓荃葲蜷蠸觠詮诠跧踡輇辁醛銓铨顴颧騡鬈鰁鳈齤𠤹𠥙𡇮𡙅𡙐𡰝𡴔𡺟𢎠𢑆𣍴𤜍𤥷𤬠𤷄𥤊𦏮𦓰𧈾𧍭𨛈𨜩𩓫𩘘𩜬𪈻])),
					result  => q(quán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䅚䊎汱烇犬犭畎綣绻虇𡿨𢔑𣸋𤰝𥹳𦨚𧸾𪐂])),
					result  => q(quǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䄐券劝勧勸牶韏𢍕𦍅𨨗])),
					result  => q(quàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺨椦楾闎])),
					result  => q(quan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[缺蒛阙𥆸𥗮𧎯𩨭𩨷𩫠])),
					result  => q(quē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[瘸])),
					result  => q(qué),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕁㩁㰌㱋㱿㲉㴶㹱㾡䇎䍳䦬䧿䲵却卻埆塙墧寉崅悫愨慤搉榷灍燩琷皵硞确碏確碻礐礭趞闋闕阕雀鵲鹊𠞗𡇱𡉉𢠬𣛵𣤇𣪹𤣅𤷽𤿋𤿩𤿵𥀎𥕹𥗙𥜵𥩢𧢩𧢭𨞩𨢜𨴊𨴒𨵗𩤈𪏈𪏨𪖀])),
					result  => q(què),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟒囷夋峮逡𡈀𢛕𦽖𩎗𩤁])),
					result  => q(qūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪊㿏䭽宭帬羣群裙裠𣀄𤛭𤸷𨞗])),
					result  => q(qún),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𦃢])),
					result  => q(qǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜣㲯㸐㾆䔳䕼䖄䫇䳿呥嘫然燃繎肰蚦蚺衻袇袡髥髯𠊌𠤀𠯍𡖝𢓒𣰦𤙼𤡮𤱋𥳚𦫉𪓘𪓚𪚮])),
					result  => q(rán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒄㚩㿵䎃䒣䣸䤡冄冉姌媣染橪珃苒𠱞𡜉𡜫𤲗𥀭𥬕𨹌𩃵𩢡𩧬𩶎])),
					result  => q(rǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𥣹])),
					result  => q(ràn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[蒅])),
					result  => q(ran),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䉴儴勷瀼獽瓤禳穣穰蘘躟鬤𣰶𤬥𤰂𧟄𨟚𩆶])),
					result  => q(ráng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䑋嚷壌壤攘爙纕𣩽𤅑𥗝𨏛])),
					result  => q(rǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[懹譲讓让])),
					result  => q(ràng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㹛娆嬈桡橈荛蕘襓饒饶𦪛])),
					result  => q(ráo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑱扰擾隢𠒸𡈦𧳨𨇄])),
					result  => q(rǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[繞绕遶])),
					result  => q(rào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[惹𢞇])),
					result  => q(rě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[热熱𤑄𧧏𩭿])),
					result  => q(rè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺅䌾䛘人亻仁壬忈忎朲秂芢鈓銋魜鵀𡰥𢇦𦏀𧥷])),
					result  => q(rén),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣼䭃忍栠栣棯秹稔荏荵𠲏𢆉𦬄𩑉𩠈])),
					result  => q(rěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺶⺷㠴㶵㸾䀔䇮䋕䏕仞仭任刃刄妊姙屻岃扨杒梕牣祍紉紝絍纫纴肕腍葚衽袵訒認认讱軔軠轫靭靱韌韧飪餁饪𠯄𣅉𦍌𧴬𨉃𩵕𪔺])),
					result  => q(rèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[綛躵])),
					result  => q(ren),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[扔])),
					result  => q(rēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㭁㺱䄧䚮仍礽辸陾𠧟𠮨𠯷𠯹𣗐𥾋𧹈𨸐])),
					result  => q(réng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[芿])),
					result  => q(rèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺛⺜䒤囸日釰鈤馹驲𡆸𡉭𤝍𦨙])),
					result  => q(rì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[茸])),
					result  => q(rōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘇㝐㣑㭜㲓㲨㺎㼸䇀䇯䈶䘬䠜䡆䡥䤊䩸媶嫆嬫容嵘嵤嶸巆戎搈搑曧栄榕榮榵毧溶瀜烿熔爃狨瑢穁絨縙绒羢肜茙荣蓉蝾融螎蠑褣鎔镕駥髶𠞕𣮪𣯏𣯐𥎂𥑳𥨳𥬪𥼬𦗋𦗨𧎣𨉴𨉷𨲟𩍉𩎂𩮠𪃾])),
					result  => q(róng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㲝䢇傇冗坈宂氄軵𠰽𡊫𡊸𡖢𡦼𡫦𡭋𢐿𢦿𢫨𣭲𣯍𣰇𣲽𤘺𤘻𥎜𦔋𦶇𧉡𨋠𨌣𨍅𨍷𨒆𩚗𩼅𪕁𪕎𪗴])),
					result  => q(rǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鴧𠌚])),
					result  => q(ròng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[穃])),
					result  => q(rong),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㽥䐓䧷䰆厹媃揉柔渘煣瑈瓇禸糅葇蝚蹂輮鍒鞣騥鰇鶔𠠐𥠊𦍭𨛶𪑶])),
					result  => q(róu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[楺粈韖𡗑𢔟])),
					result  => q(rǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺼宍肉腬])),
					result  => q(ròu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨎㾒䋈䞕䰰侞儒嚅如嬬孺帤曘桇渪濡燸筎茹蒘蕠薷蝡蠕袽襦邚醹銣铷顬颥鱬鴑鴽𠟺𡄲𡜚𣖹𣚐𣭠𣽈𣽉𥙦𥞚𦤊𦭰𦳾𦷸𧊟𨚴𩄋𩶯𩸐])),
					result  => q(rú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[乳擩汝肗辱鄏𡜃𡫽𡮚𨨜𩍥𪏮𪑾])),
					result  => q(rǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦺㹘䄾入嗕媷洳溽縟缛蓐褥𢖵𢛚𣯋𩱨𩶫])),
					result  => q(rù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嶿扖杁込鳰])),
					result  => q(ru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[挼])),
					result  => q(ruá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䙇堧壖撋𢱾𣽳𤲬𥈇])),
					result  => q(ruán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓴㮕㼱㽭䎡䓴䞂䪭偄媆朊瑌瓀碝礝緛耎軟輭软阮𠤦𢘧𢡵𣃅𣡗𤧠𥊶𥎀𥎘𥩗𥯬𦺾𨒩𩏈])),
					result  => q(ruǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𨨰𨪳𨬔])),
					result  => q(ruàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䅑䬐婑桵甤緌蕤𣬘𦼆])),
					result  => q(ruí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[橤繠蕊蕋蘂蘃𡯒𣛚𥳝𧄜])),
					result  => q(ruǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓹㢻㪫㲊䂱䄲䇤䌼䓲叡壡枘汭瑞睿芮蚋蜹銳鋭锐𢣳𨧨𨳙𪏩])),
					result  => q(ruì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[瞤𥆧𩀋])),
					result  => q(rún),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𠷀])),
					result  => q(rǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠈䏰䦞橍润潤膶閏閠闰𨷎])),
					result  => q(rùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[捼])),
					result  => q(ruó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䐞偌叒弱楉渃焫爇箬篛若蒻鄀鰙鰯鶸𤍽𤣼𦩸𧃪𨀝𨴚])),
					result  => q(ruò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嵶])),
					result  => q(ruo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[仨挱挲撒𠬙𣬬𥋌])),
					result  => q(sā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[洒潵灑訯躠靸𡄳𥸗𨐖𩎕𩨞])),
					result  => q(sǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒎㚫㪪㽂䊛䙣䬃卅摋櫒泧脎萨薩虄鈒颯飒馺𠎷𠦃𠱡𠿓𡐥𡒁𢓔𢕬𢫬𢻨𣀯𣜂𥵯𥻦𦠿𦻅𦼧𧀕𧭝𨃛𨆂𨷆𩆅𩐅𩗉𩗞])),
					result  => q(sà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[隡𠮿])),
					result  => q(sa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩙䚡䰄噻塞愢揌毢毸腮顋鰓鳃𪃄])),
					result  => q(sāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗷㘔䈢])),
					result  => q(sǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[僿嗮簺賽赛𡬉𦞫])),
					result  => q(sài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嘥])),
					result  => q(sai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䈀三叁弎毵毿犙鬖𢁘𣀫𣬛𦙱𦙸𧱆𧽾𩯑])),
					result  => q(sān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧲䉈䊉䫩仐伞傘糁糂糝糣糤繖鏒鏾霰饊馓𡙘𢕕𥒬𦷻𦺻𩀲𩀼𩞀])),
					result  => q(sǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤾㪔㪚䫅俕帴悷散閐𣀧𣮠𦡨𧗋𨸃])),
					result  => q(sàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[厁壭橵毶])),
					result  => q(san),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䘮桑桒𡠏𦅇𧍨𨢆𩐷𩦌𪔬])),
					result  => q(sāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䡦䫙嗓搡磉褬鎟顙颡𡕏𣞙𤸯𥔫𦟄𩺞])),
					result  => q(sǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[丧喪𣉕𣊝])),
					result  => q(sàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[槡])),
					result  => q(sang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥰慅掻搔溞繅缫臊騒騷骚鰠鱢鳋𠋺𢔳𣉔𤠘𤢖𥰱𦏛𦞣𧂩𧖠𨪊𩙈𩙰𩮚])),
					result  => q(sāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛮䕅嫂扫掃𦺋𦾘])),
					result  => q(sǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㲧㿋埽氉瘙矂髞𢜶𢠡𢤁𢮞𣰕𦕏𧑫𨃣𨧪𩫦𪍻])),
					result  => q(sào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[螦])),
					result  => q(sao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[閪])),
					result  => q(sē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒊㥶㱇㻭䉢䔼䨛啬嗇懎擌栜歮歰洓涩澀澁濇濏瀒琗瑟璱瘷穑穡繬色譅轖銫鏼铯雭飋𠎸𠟦𠟩𠢳𠵭𠽼𠿗𡫟𡵶𢀋𢃢𢡉𣚟𣽤𤁧𤖗𤛷𤾿𥈽𥱁𥷹𥻨𦆄𦐅𧈈𧒓𧒗𧨷𨆙𩃑𩄜𩇣𩊯𩍙𩏫𩕡𩰙])),
					result  => q(sè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[渋穯])),
					result  => q(se),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[森椮槮襂𣟹𧂅])),
					result  => q(sēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𩕌])),
					result  => q(sěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䒏僧鬙])),
					result  => q(sēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𡬙])),
					result  => q(sèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠺㲚㸺䤬乷刹剎唦杀桬榝樧殺毮沙煞猀痧砂硰粆紗纱莎蔱裟鎩铩魦鯊鯋鲨𡺧𢅑𢩖𢶌𢼵𣉜𣛶𣡽𣲓𣲡𣶤𣻑𤍁𤑣𦀛𦕉𦭉𦱵𧋊𨪍𩊮𩮫𩵮𪄅𪌮])),
					result  => q(shā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[傻儍𧫝])),
					result  => q(shǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㰱㰼㵤䈉䝊䬊倽厦唼啑啥喢帹廈歃箑翜翣萐閯霎𠍽𠚺𢇗𣓉𣣮𣣺𤟃𥈊𦔯𦔰𦩿𦾚𧏫𧲌𧳛𧻵𨖷𨘉])),
					result  => q(shà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[繌])),
					result  => q(sha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩄㴓筛篩簁簛酾釃])),
					result  => q(shāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[繺𢄌])),
					result  => q(shǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬠䵘晒曬閷𧜁𨢦𩂃𩂝𩴇])),
					result  => q(shài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㰑㺑䀐䘰删刪剼嘇埏姍姗山幓彡挻搧杉柵檆潸澘煽狦珊痁笘縿羴羶脠膻舢芟苫衫跚軕邖钐鯅𣆴𣖉𣧺𣲀𥊀𦎞𦏂𦳫𦺭𧛄𧛡𧲾𨁆𨏪𨝩𨝵𩁺𩌰𪑃])),
					result  => q(shān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𧨾])),
					result  => q(shán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚒㨛㪎㴸㶒䠾晱煔熌睒覢閃闪陕陝鿃𠿞𡟨𢒉𢿈𣪶𤇄𤊼𥄘𥈚𧧵𧴭𨹈𨹊𩆤𩆫])),
					result  => q(shǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣌㣣㪨䄠䚲䡪䥇䦂䦅䱇䱉䴮傓僐剡善墠墡嬗扇掞擅樿歚汕潬灗疝磰繕缮膳蟮蟺訕謆譱讪贍赡赸鄯釤銏鐥饍騸骟鱓鱔鳝𠚹𠫹𢕻𢩢𢫔𣓒𣩧𤮜𤺪𥔱𥰢𥸣𦍸𦘹𦶋𧎥𧭽𧷶𩟋𩦐𪍶])),
					result  => q(shàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[圸敾杣閊])),
					result  => q(shan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䵰䵼伤傷商墒慯殇殤滳漡熵蔏螪觞觴謪鬺𠼬𤎘𤳈𥏫𧶜𨢩𨶼𪄲])),
					result  => q(shāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[垧扄晌賞贘赏鑜𧡮𩞃𩞧])),
					result  => q(shǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[丄上尙尚恦緔绱鞝𤔚𤵼])),
					result  => q(shàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[仩裳])),
					result  => q(shang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䈰䈾弰捎旓梢烧焼燒稍筲艄莦蛸輎颵髾鮹𠷃𡡏𢼼𥙬𥳓𦄏𨱭𨲆𩬏])),
					result  => q(shāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㲈㸛勺柖玿竰芍苕韶𢦽𤱠𦯐])),
					result  => q(sháo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪢䒚䔠少𢾐𥵦𦿃𧣪𨈘𨙹])),
					result  => q(shǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䏴䙼䬰劭卲哨娋潲睄紹綤绍袑邵𠣫𠧙𤉎𦓴𧳹𨛍])),
					result  => q(shào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[蕱])),
					result  => q(shao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[奢檨猞畬畲賒賖赊輋𠾏𡄢𥿞𨣍𩩗])),
					result  => q(shē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓭㵃䞌佘舌虵蛇蛥𠋞𢶅𣸚𥝀𦯬𦴍𦼢𧉮𧵳])),
					result  => q(shé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䬷捨舍𢉃])),
					result  => q(shě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㴇䀅䄕䜓䠶䤮厍厙射弽慑慴懾摂摄摵攝欇歙涉涻渉滠灄社蔎蠂設设赦韘騇麝𠪣𠴯𢗭𣝒𣣭𤙱𤠭𤺔𥁹𥍉𥔡𦁗𧮿𨝫𩂨𩂴𩙝𩮐])),
					result  => q(shè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[舎])),
					result  => q(she),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑗㕥㜪㮱䅸䯂伸侁兟呻妽姺娠屾峷扟敒曑柛棽氠深燊珅甡甧申眒砷穼籶籸紳绅莘葠蓡蔘薓裑訷詵诜身駪鯵鰺鲹鵢𠃫𠻝𡖬𢈯𢏎𢘊𣇗𣔗𣘘𣘲𤶴𥆣𥥍𥥿𥳱𥸬𦐹𦜊𦸂𦸯𦺷𧢹𨊘𨐍𨐔𨐕𨝐𨞲𩉼𩺵])),
					result  => q(shēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䰠什甚神𤕊])),
					result  => q(shén),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚞㚨㰂㾕哂婶嬸审宷審弞曋渖瀋瞫矤矧覾訠諗讅谂谉邥頣頥魫𠘆𡼬𢈇𢊲𢏦𢸙𣿇𤏗𥏖𥬐𧀯𩶇])),
					result  => q(shěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㰮㵕䆦侺愼慎昚椹涁渗滲瘆瘮眘祳罧肾胂脤腎蜃蜄鋠𠂧𠗿𢊖𦌀𦕽𦜜𨴐])),
					result  => q(shèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[堔榊鰰])),
					result  => q(shen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱡䲼䴤升呏声斘昇栍殅泩湦焺牲狌珄生甥笙聲苼鉎阩陞陹鵿鼪𠇷𠴢𢦑𣢡𣬺𤚣𥘥𥟎𦖞𧿘𨁠𨕻])),
					result  => q(shēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䱆憴繩绳譝𦩱𩍋])),
					result  => q(shéng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗂㮐㼳㾪䁞䚇䪿偗渻省眚𡞞𡨽𦔄𦳗𧍖𨜜𨲓𨵥])),
					result  => q(shěng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䞉剩剰勝圣墭嵊晠榺琞盛聖胜蕂貹賸𠓸𠓽𤯡𦕡𦛙𧡶𧪝𨚱𪅻])),
					result  => q(shèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[曻橳竔])),
					result  => q(sheng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䌤䌳䏉䗐䙾䴓呞失尸屍师師施浉湤湿溮溼濕狮獅瑡絁葹蒒蓍虱蝨褷襹詩诗邿釶鈟鉇鉈鍦鯴鰤鲺鳲鳾鶳鸤𠇳𠓤𠷇𡂓𡟕𡠋𢀕𢧏𢺿𢻫𢼉𢼊𣁒𣤘𤹌𥍸𥛨𥜰𦌿𦒈𧍀𧜂𧠜𧠡𧩹𩒂𩥐𩬭𪀔𪓻𪓿𫚕])),
					result  => q(shī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻝⻟⻠㖷㵓䂖䄷䈕䖨䦹䲽䶡乭十埘塒姼实実寔實峕拾时旹時榯湜溡炻石祏莳蒔蚀蝕識识辻遈鉐食飠饣鰣鲥鼫鼭𠥿𠩔𠯰𠰴𡀗𡚼𡫵𡺔𢨝𢻘𣏚𣧚𤸤𥇲𥐘𦔂𧄹𨙩])),
					result  => q(shí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕜㹬㹷䂠䒨乨使兘史始宩屎矢笶豕鉂駛驶𠘪𡰯𡱁𡶈𢁓𣆘𥑏𦰯𦳊𨴯𩭐𩰢𪊢𪗧])),
					result  => q(shǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺬-⺮㒾㔺㱁㳏㸷㹝䁺䊓䏡䛈䟗䤭䤱䩃䭄世丗亊事仕似侍冟势勢卋叓呩嗜噬士奭媞嬕室崼市式弑弒徥忕恀恃戺拭揓是昰枾柹柿栻氏澨烒眂眎眡睗示礻筮簭舐舓螫襫視视觢試誓諟諡謚试谥豉貰贳軾轼适逝適遾釈释釋鈰鉃鉽銴铈飾餙餝饰𠀍𠁗𠡥𠰚𡅵𡉸𡣪𡷈𢂑𢃰𢝬𣬐𤆰𤉏𤑦𤖻𤜣𤢼𤯄𤯜𥅔𥅞𥥥𥫴𥰰𥼶𥿅𦚨𦿇𧊖𧝊𧞲𧧅𧳅𧵋𧻸𨒍𨒧𨟂𨱡𨸝𨽄𩋡𩗎𩛌𩛏])),
					result  => q(shì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[佦匙嵵榁煶竍篒籂鮖鰘𥫽])),
					result  => q(shi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧃収收𠈅𤙘𤚔𤱜𥅪])),
					result  => q(shōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝊䭭垨守手艏首𡭮𥅷𥾹𦣻𧵃𩠶])),
					result  => q(shǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖟㥅䛵兽受售壽夀寿授涭狩獸痩瘦綬绶鏉𠱔𣒻𥙰𥨝𧈙𧌅𧚯𧜃𧤙𧯼𨱒𩴍𪈀])),
					result  => q(shòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺘扌獣])),
					result  => q(shou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑐㸡㼡䨹䱙书倏倐儵叔姝尗抒掓摅攄書杸枢梳樞橾殊殳毹淑焂瑹疎疏紓綀纾舒菽蔬跾踈軗輸输鄃陎鮛鵨𠘧𠙎𡧔𢞣𣉛𣰿𤕟𤱐𤴙𥳕𥿇𦈌𦈷𦍄𦐣𦤂𦶕𦺗𧠣𨁀𨐅𨛭𩛅𩳅𩷌𩾈𪅰])),
					result  => q(shū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒔㯮䃞䴰塾婌孰熟璹秫贖赎𡒒𡦛𢧇𣤯𧇝𨶝𨷙𩢻])),
					result  => q(shú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㻿䑕䝪䞖属屬暏暑曙潻癙署薥薯藷蜀襡襩钃黍鼠鼡𡤽𡱆𢋂𣀻𤻃𥍝𥣋𦺪𧄔𧑓𧒑𨽉])),
					result  => q(shǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛸㜐㡏㣽㫹㵂㶖㷂㽰㾁䉀䘤䜹䝂䠼䢞䢤䩱侸凁咰墅尌庶庻怷恕戍捒数數朮术束树樹沭漱潄澍濖竖竪絉腧荗蒁虪術裋豎述鉥錰鏣隃鶐𠊪𠐊𠲌𠾢𡂡𡊍𡔪𡣈𢠫𣏗𣻚𤍓𤗪𤘷𤞉𦒶𦠦𧗱𧞀𧞫𧼯𨅒𨔦𪌶𪐧])),
					result  => q(shù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[瀭糬蠴鱪鱰])),
					result  => q(shu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕞刷唰𠛚])),
					result  => q(shuā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[耍𤔙𩈥𩉆𩤤])),
					result  => q(shuǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[誜])),
					result  => q(shuà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㲤摔衰𤠠𤸬𤺀𨄮])),
					result  => q(shuāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[甩])),
					result  => q(shuǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䢦卛帅帥蟀𠌭𢕅𢕑𣘚𣼧𧍓𧗿𧜠𩘱])),
					result  => q(shuài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[拴栓閂闩𢩠𣔫𣟴𣠸])),
					result  => q(shuān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䧠涮腨𡭐𢮛𤅲𦺲𨄔𨏉])),
					result  => q(shuàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕠䉶䌮䝄双孀孇欆礵艭雙霜騻驦骦鷞鸘鹴𧄐𧕟𨇯𩅪𩆿𩽧])),
					result  => q(shuāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䔪䗮䫪塽慡樉漺爽縔𠗾𡑽𥡠𥱶𦄍𦆌𧴅])),
					result  => q(shuǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦼灀𥲚𧕺])),
					result  => q(shuàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鏯])),
					result  => q(shuang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[脽誰谁𧀣])),
					result  => q(shuí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[水𡯑𡱊𢏅𤆙𥫸𦙙])),
					result  => q(shuǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥨㽷䬽䭨䳠帨涗涚睡瞓祱稅税裞𠻜𢇤𥌘𦣢𨓚𨿠𩟥𩩞])),
					result  => q(shuì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺡⺢氵氺閖])),
					result  => q(shui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[吮𨺠])),
					result  => q(shǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥧䀢䀵䑞䴄橓瞚瞬舜蕣順顺鬊𨝜])),
					result  => q(shùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哾說説说])),
					result  => q(shuō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㮶䀥䁻妁搠朔槊欶烁爍獡矟硕碩箾蒴鎙鑠铄𠲾𠲿𣀝𣝇𣷥𣸛𣻘𤡯𤢴𥌞𦂗𦃗𦋞𨨺𩟧𪎒])),
					result  => q(shuò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺯⺰㟃㠼㴲㺇㺨㽄䇁䔮䡳䫢䲉丝俬凘厮厶司咝嘶噝媤廝思撕斯楒榹泀澌燍磃禗禠私籭糹絲緦纟缌罳蕬虒蛳蜤螄蟖蟴鉰鋖鐁锶颸飔騦鷥鸶鼶𠀓𠖓𡡒𢊀𢛥𢠹𢦲𣂖𣚄𤆟𤣵𥄶𥐀𥕶𥝠𥠱𥯨𦇲𦇵𦭡𦮺𦸷𦽕𧀚𧝤𨮭𩅰𩆵𩺛𪆁𪆗𪕳𪖉])),
					result  => q(sī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[死𣣑])),
					result  => q(sǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺒㕽㚶㣈㭒㸻㹑䇃䎣䏤䦙亖佀価儩兕嗣四姒娰孠寺巳杫柶汜泗泤洍涘瀃牭祀禩竢笥耜肂肆蕼覗貄釲鈶鈻飤飼饲駟驷𠋡𠭈𠳎𢍭𣙼𣩠𣱻𣽷𤱸𥒲𥙉𥹊𧀩𧣛𧱅𧳙𨽼𩵗𩸟𪊍])),
					result  => q(sì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[恖銯])),
					result  => q(si),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣝䯳䯷倯凇娀崧嵩庺忪憽松枀柗梥檧淞濍硹菘蜙鍶鬆𢓣𢔋𢤄𣚜𣽫𤾥𧊕𧌻𨠤𨱛𨱿𩃭𪀚])),
					result  => q(sōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞞𩩺𪨊])),
					result  => q(sóng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧐㨦㩳䉥䜬傱嵷怂悚愯慫楤竦耸聳駷𡷽𡾼𢖗𢱤𥳺𨴏])),
					result  => q(sǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㮸䛦䢠宋訟誦讼诵送頌颂餸𠳼𡇝𦯕𦷴𩃍𩠌])),
					result  => q(sòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[枩鎹])),
					result  => q(song),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䈭䐹䑹䗏䤹䩳䬒䮟䱸嗖廀廋捜搜摉摗溲獀艘蒐蓃螋鄋醙鎪锼颼颾飕餿馊騪𠘂𠝬𡠼𡣂𢲷𢴼𣔱𣮬𣯜𧳶𧽏𨡻𨤇𩗣𩘠𩙫𩨄𩮃𩮶𩮸])),
					result  => q(sōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛐㟬䈹䉤䏂傁叜叟嗾擞擻櫢瞍籔薮藪𠋢𠌞𠌟𠪇𤕇𥈟𥖻𦺌𨺦])),
					result  => q(sǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嗽瘶膄𥯪𧔅])),
					result  => q(sòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢝㲞䌚䲆囌櫯甦稣穌窣苏蘇蘓酥𢋈𢸫𣩷𤼀𧔖𧺷𩲵])),
					result  => q(sū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[俗𠐍𦎄])),
					result  => q(sú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𣷶])),
					result  => q(sǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑉㑛㓘㔄㕖㜚㝛㨞㪩㬘㯈㴋㴑㴼䃤䅇䎘䏋䑿䔎䛾䥔傃僳嗉塐塑夙嫊宿愫愬憟梀榡樎樕橚殐泝洬涑溯溸潚潥玊珟璛碿簌粛粟素縤肃肅膆莤蔌藗觫訴謖诉谡趚蹜速遡遬鋉餗驌骕鱐鷫鹔𡎮𡖯𢎎𢖏𢚑𢢒𣝝𣫎𣯼𣶘𣿈𤌂𤛝𤠚𤡃𤢂𤢘𤤐𤥔𤭴𤸮𦌉𦌊𧀌𧐁𧐒𧐴𧜦𧞺𧥆𧩝𧼭𧽷𨱈𩐫𩐼𩘰𩘹𩙨𩝥𩳒𪁽𪄑𪅄𪋝𪌔𪍛𪐮𪖶𫂙𫗧])),
					result  => q(sù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鯂])),
					result  => q(su),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䝜狻痠酸𤶤𦾹𨠡𩆑𪘑𪘝])),
					result  => q(suān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[匴𠥘])),
					result  => q(suǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[祘笇筭算蒜𥳪𥴵𩈲])),
					result  => q(suàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺙䧌䪎倠哸夊浽滖濉熣眭睢綏芕荽荾葰虽雖鞖𠌱𠨌𡝓𣮄𣯯𤯖𦉎𦵭𦸏𧈧𨾡𩃃𩌩𩏘𩞅𩮴])),
					result  => q(suī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㵦㻟䜔䢫瓍绥遀隋随隨𥶻𧲈𩙇])),
					result  => q(suí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䭉䯝瀡膸髄髓𠕸𧃚𨾬])),
					result  => q(suǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒸㞸㥞㴚㻪㻽䅗䉌䍁䔹䠔䡵䥙亗埣嬘岁嵗旞檅檖歲歳澻煫燧璲睟砕碎祟禭穂穗穟繀繐繸襚誶譢谇賥遂邃鐆鐩隧韢𠭥𡑞𡶣𡷼𡹖𡻕𢅕𢇥𢈼𢒱𢟩𣄧𣩡𤡪𤬫𤻄𥊴𥕸𥢍𥤼𥴦𦃒𦄑𦅵𦇀𧌢𧡏𧨧𧸙𨆏𨣢𨷃𩍚𩎰𩏚𩏲𩗶𩝌])),
					result  => q(suì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[孙孫搎槂狲猻荪蓀蕵薞飧飱𧎤])),
					result  => q(sūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔼㦏䁚䐣损損榫笋筍箰簨鎨隼鶽𠣬𣕍𦠆])),
					result  => q(sǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛖䓾䔋䯯傞唆嗍娑摍桫梭睃簑簔縮缩羧莏蓑趖髿鮻𠈱𠱗𢘿𣒹𣯌𤀤𥁲𥆝𥇇𦟱𧨀𩌢])),
					result  => q(suō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𩡾])),
					result  => q(suó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪽㮦䂹䅴䈗䖛䞆䞽䣔䵀乺唢嗩惢所暛溑琐瑣璅索褨鎈鎍鎖鎻鏁锁𠋲𠝿𠞯𠩄𡩡𡱳𢚭𢱡𢱢𤸴𤺫𥔭𥰼𦅊𦵫𧎫𧎳𧛻𧴪𧴲𨻈𨻨𩋝𩌆𩌈𩘝𩙭𩪈𩮛𩹳𪍔𪍟𪍨])),
					result  => q(suǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䐝溹蜶逤𠗼𠘺𢷾𪍌])),
					result  => q(suò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嗦琑])),
					result  => q(suo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㯚䌈他嚃塌她它榙溻牠祂褟趿铊闧𡌩𢞠𦈖𦭟𦱆𧪦])),
					result  => q(tā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[蹹𨓬])),
					result  => q(tá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗳㺚塔墖溚獭獺鰨鳎𦑼𨶀𨸉𩥑𩨌𩫊𩷽𩺗])),
					result  => q(tǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒓㛥㣛㣵㧺㭼㯓㳠㹺㿹䂿䈋䈳䍇䍝䎓䑜䑽䓠䜚䳴䵬䶀䶁亣嚺崉拓挞搨撻榻橽毾涾澾濌狧禢誻譶跶踏蹋躢遝遢錔闒闥闼鞜鞳鮙𠉂𠴲𠷍𢃕𢺉𣗶𣝋𣥂𣥷𣯚𤄥𤒻𤛣𤠐𤠟𤿽𥗓𦍒𦐇𦑇𦑲𦑶𦧛𦧞𦧟𦧥𦧱𦨎𦪙𦶑𦾽𧌏𧔣𧖆𧮑𨃚𨆰𨌭𨔯𨙎𨰏𨵝𩋅𩌇𩌉𩌐𩌘𩎽𪂌𪔕𪘁])),
					result  => q(tà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[侤咜])),
					result  => q(ta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[囼孡胎𧉟𧭏𩬠])),
					result  => q(tāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒗㙵㣍㬃㷘㸀䈚䑓儓冭台坮嬯抬擡旲枱檯炱炲箈籉臺苔菭薹跆邰颱駘鮐鲐𡒢𢖤𣣿𩿡𪒴])),
					result  => q(tái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘆𤗿])),
					result  => q(tǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑷㥭䣭太夳忲态態汰泰溙燤肽舦酞鈦钛𡇷𦒰𧉑𧮼𪐥])),
					result  => q(tài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[粏])),
					result  => q(tai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘱㨏㳩㴂㵅䆱䑙坍怹抩摊擹攤滩灘痑瘫癱舑貪贪𠫶𣢌𣵢𣸙𣼚𣽯𦙇𦧏𦧴𦨸𦸁𦼎])),
					result  => q(tān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㲜㷋㽎㽑䃪䉡䊤䕊倓坛墰墵壇壜婒惔憛昙曇榃檀潭燂痰磹罈罎藫覃談譚譠谈谭貚郯醈醰錟锬顃餤𠻪𡅄𡊨𢅀𢇧𢇰𤐔𥩒𥰨𥹠𥼟𥼮𦗡𧂇𧣁𧣹𧰘𧽼𨝸𩖖𩠽𩡄𩡝𩪺𪍵])),
					result  => q(tán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㫜㲭䏙䞡䦔嗿坦忐憳憻毯璮菼袒襢醓鉭钽𤎥𦃖𦌪𧫿𧺟𨁴𨅍𨡍𨣕𩑰𩒢])),
					result  => q(tǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛶䐺䗊䜖傝僋叹嘆埮探歎湠炭碳舕賧𣁗𣞔𣴽𧥞𨂞𩤞𪉧])),
					result  => q(tàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓥䞶䠀劏嘡坣汤湯羰耥薚蝪蹚鏜鐋铴镗鞺鼞𢴳𦳝𨲗])),
					result  => q(tāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑽㙶㜍㭻㲥㼺䅯䉎䌅䕋䣘䧜傏唐啺堂塘搪棠榶樘橖溏漟煻瑭磄禟篖糃糖糛膅膛蓎螗螳赯踼鄌醣鎕闛隚餳餹饄饧鶶𠗶𠢃𠹔𢻿𣙟𤚫𤠯𥋡𦪀𧱵𨆉𨌩𨍴𨎋𨶈𩘜𩥁𩹶𪕹])),
					result  => q(táng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒉㼒㿩伖倘偒傥儻帑戃曭淌爣矘躺鎲钂镋𡿓𢠵𣎲𤾉𨎖])),
					result  => q(tǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䟖摥烫燙趟𨉱])),
					result  => q(tàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣠㫦㹗䀞䈱䑬䤾夲嫍幍弢慆掏搯槄涛滔濤瑫絛縚縧绦詜謟轁鞱韜韬飸饕𠇏𠓝𠗆𠚜𠞞𠬢𡺫𤘸𤙎𦍷𦺰𨌨𩎢𩏾𩥅𩹴])),
					result  => q(tāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䄻䛌䛬䬞匋咷啕桃梼檮洮淘祹綯绹萄蜪裪迯逃醄鋾錭陶鞀鞉饀駣騊鼗𡍒𢔇𣰺𤚟𤴻𤵟𥰜𨡒𩘿𩙧𩛽𪌼])),
					result  => q(táo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䚯䵚討讨])),
					result  => q(tǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚐套𣨔𣺮])),
					result  => q(tào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥂㧹忑忒慝特蚮螣蟘貣鋱铽𠈸𢘋𣘱𤙰𥊸𥌩])),
					result  => q(tè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[熥膯鼟𢚺𤃶𤳘𦡪𪔶])),
					result  => q(tēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䒅䕨䠮䲍䲢儯幐滕漛疼痋籐籘縢腾藤誊謄邆駦騰驣鰧𢟱𢥂𣽨𤹤𥉋𦪝𦫀𧈜𧭔𨃗𩩻𩴝𪒿])),
					result  => q(téng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[霯])),
					result  => q(tèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[虅])),
					result  => q(teng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔸䖙䢰䴘剔擿梯踢锑鷈鷉𠞄𢱦𤗢𨁃𨔛𩓂𩤽𪖦])),
					result  => q(tī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖒㡗㣢䅠䔶䚣䛱䨑䬫䬾䱱偍厗啼嗁崹徲惿提漽瑅碮禵稊綈緹绨缇罤苐荑蕛蝭褆謕趧蹄蹏遆醍銻鍗題题騠鮷鯷鳀鴺鵜鶗鶙鷤鹈𡰎𣄍𣖅𣖸𣸒𣹲𤗘𤚢𤟥𤟾𤭌𥉘𥳳𥶛𦌢𦻀𧀠𧀰𧋘𧔩𧙣𧡨𨠏𨪉𨴼𩋣𩛑𩛶𩝊𩿷𫘨𫛸])),
					result  => q(tí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䌡䪆体挮躰軆骵體鮧𡥩𣈡𣉆])),
					result  => q(tǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗣㬱㯩䎮䙗䯜䶏䶑倜剃嚏嚔屉屜悌悐惕惖戻掦揥替朑楴歒殢洟涕瓋籊薙裼褅趯迏逖逷髰鬀𡲕𡲿𡸑𢝹𢞖𢧑𢳓𣜹𣤖𣧂𥉈𥡦𥫵𧛒𧝆𧝐𧨱𧼮𨲎𨲞𩬲𩮜𪍲𪕩])),
					result  => q(tì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嵜笹])),
					result  => q(ti),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬲䀖䋬䚶兲天婖添酟靔靝黇𡙒𢓍𣊖𦊊𦧒𦧝𦬞𪅉𪎾])),
					result  => q(tiān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧂䑚䟧䡒䡘䥖䧃塡填屇恬搷沺湉璳甛甜田畋畑畠盷磌窴緂胋菾鈿闐阗鷆鷏𢇶𤤦𤫞𥧑𥪧𦗀𦳇𧨸𧰊𨉾𨌈𩚣𪌩])),
					result  => q(tián),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖭㙉㥏䄼䄽䐌䠄倎唺忝悿晪殄淟琠痶睓腆舔覥觍賟錪鍩靦餂𠗘𡒧𤲖𥪌𥳫𥵶𧉂𧌎𧨩𧹖𨆁𨡁𨡏𨹻𩈍𩉁])),
					result  => q(tiǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐁㮇㶺掭睼舚𤘠𦔿𦗁𦧖𨸱])),
					result  => q(tiàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[碵鴫])),
					result  => q(tian),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬸佻庣恌挑旫祧聎𠛪𡯿𡳏𢈄𢓝𣂁𣂥𦩄𨋫])),
					result  => q(tiāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟘䒒䖺䟭䩦䯾䱔岧岹条條樤祒笤芀萔蓚蓨蜩趒迢鋚鎥鞗髫鯈鰷鲦齠龆𠤺𠧪𡠊𣒼𣟐𣬸𥶏𦴚𧌁𩲤])),
					result  => q(tiáo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸠䠷嬥宨斢晀朓窕窱脁誂𢳙𢺫])),
					result  => q(tiǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[眺粜糶絩覜跳𢖈𥎺𨾾𪌪])),
					result  => q(tiào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[螩])),
					result  => q(tiao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[帖怗聑萜貼贴𦝒])),
					result  => q(tiē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䩞])),
					result  => q(tié),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䥫僣蛈銕鋨鐡鐵铁驖鴩𢶋])),
					result  => q(tiě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䴴䵿呫飻餮𤝓𦧢𦧤𪎋])),
					result  => q(tiè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓅䋼䯕厅厛听庁廰廳桯汀烃烴町綎耓聴聼聽艼鞓𠄚𤘖𥑈𦉬𦗟𧰩𨊡𩨑])),
					result  => q(tīng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㹶㼗䗴䱓亭停婷嵉庭廷楟榳渟筳聤莛葶蜓蝏諪邒閮霆鼮𣂴𤗞𥥶𥴑𦐿𦝞𧓴𧖨𧶺𨉬𨓍𩆆𩐴𩹇])),
					result  => q(tíng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䅍䦐䵺侹圢娗挺梃涏烶珽甼脡艇誔頲颋𠕊𠘋𡈼𡔛𢽄𣄿𣉡𤱹𥫙𨁗𨳑𨳝𨸁𩑙𩒞𪊶])),
					result  => q(tǐng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𢬫𥆑𦕢])),
					result  => q(tìng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嗵囲炵痌蓪通𡠙𢄟𣌾𣻢𥲆𧳆𧳿𨀜])),
					result  => q(tōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠉㠽㤏㸗㼧㼿䂈䆚䮵䳋䴀䶱仝佟僮勭同哃峂峝庝彤晍曈朣桐橦氃浵潼烔燑犝狪獞眮瞳砼秱童筩粡膧茼蚒詷赨酮鉖鉵銅铜餇鮦鲖𠖄𡦜𢈉𢏕𢓘𣑸𣪯𤱇𥩌𥫂𦏆𦒍𦨴𧇌𧊚𧋒𧋚𧌝𨚯𨜳𨝯𨠌𩍅𩩅𩻡𪀭])),
					result  => q(tóng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛚㣚㪌捅桶樋筒統綂统𢳟𨈹𪌢])),
					result  => q(tǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[恸慟憅痛衕𥦁])),
					result  => q(tòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[偷偸婾媮鋀鍮𡇧𨱎])),
					result  => q(tōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓱㢏䕱䵉亠头投緰頭骰𡷠𣪌𦈕𨯲𨷩𪁞𪉘𪎨])),
					result  => q(tóu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㪗㳆㼥䚵䱏妵敨紏蘣钭飳黈𩜶𩿢𪌘])),
					result  => q(tǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖣䞬䟝綉透𣛾𧺢𨔙])),
					result  => q(tòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟮㻬䛢䞮凸唋堗宊嶀怢捸涋湥痜禿秃突葖鋵鵚鼵𠊲𠞀𠟶𠫓𠳶𠸂𡸂𢬳𣅝𣒇𣲱𤷿𥥛𥨜𥯝𦩤𧳌𪉍])),
					result  => q(tū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㭸㻌㻠㻯䅷䖘䠈䣄䣝䤅䩣䳜凃図图圕-圗塗屠峹嵞庩廜徒悇捈揬梌涂潳瘏稌筡腯荼菟蒤跿途酴鈯鍎馟駼鵌鶟鷋鷵𠫮𠻬𡇩𡺴𢝀𣈥𣔻𣥳𤙛𤟪𥂋𥧣𦔅𦝬𧛗𧧶𨑒𨝛𨨷𨱄𨴩𩥽𪑏])),
					result  => q(tú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[吐土圡釷钍𨙭])),
					result  => q(tǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[兎兔堍迌鵵𩣮𩸃𩾅])),
					result  => q(tù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[汢莵])),
					result  => q(tu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䝎䵊䵎湍煓猯貒𧰄𪏖])),
					result  => q(tuān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩛䊜剸团団團慱抟摶槫檲漙篿糰鏄鷒鷻𡁴𣶣𧐕𧓘𧽢𨪒𩃘𩘯𩜵𩠊𩠹𪈋])),
					result  => q(tuán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䜝䵯疃𢣎𤱝])),
					result  => q(tuǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[彖湪褖𧳩])),
					result  => q(tuàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞜推蓷藬𧆸𨌴])),
					result  => q(tuī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢈㢑㿗䀃䅪尵弚穨蘈蹪隤頹頺頽颓魋𡷜𢉭𢊮𢟴𤗴𤸉𥢢𥶐𧝋𧮓𨆨𨗞𨘃𨽟𩓬𩘺𩙬])),
					result  => q(tuí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞂㱣㾼㿉俀僓腿蹆骽𡯵])),
					result  => q(tuǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥆㷟侻娧煺蛻蜕褪退駾𠺙𢓇𢠮𤍐𥲣𦖦𦜄𩳕])),
					result  => q(tuì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬿吞呑啍噋暾朜涒焞黗𣋄𧑒𨧐𨹙𩷵𪏆])),
					result  => q(tūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩔㹠㼊坉屯忳臀臋芚豘豚軘霕飩饨魨鲀𠭿𡉒𥴫𥸵𦍓𦜴𦟓𧰭𨙲𨳘𩂄𩖤𪌋𪎴𪎶])),
					result  => q(tún),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖔氽畽𢞋𢥽𣵞𦜯𦟙])),
					result  => q(tǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧷旽𤶕𨁇𪑒])),
					result  => q(tùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䜏䴱乇仛侂咃托扡拕拖挩捝杔汑沰涶脫脱莌袥託讬飥饦驝魠𠈁𠰹𠴻𢄿𢩷𢸨𤣯𧦭𨒙𨞌𩟰𩢵𩧐𪌂])),
					result  => q(tuō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸰㸱㼠㾃䍫䡐䪑䭾䰿佗坨堶岮槖橐沱沲狏砣砤碢紽袉跎迱酡陀陁馱駄駝駞騨驒驮驼鮀鴕鸵鼉鼍鼧𡩆𡹬𢏜𢑠𢩻𣶦𤝛𤤩𤱡𥓿𥞒𦑑𦚐𧔳𧕦𧣖𧤓𧧉𧿶𨈷𨉋𨹔𩃰𩃱𩉺𩎼𩢊𩿽𪘕𪘗])),
					result  => q(tuó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟎䓕妥媠嫷庹彵椭楕橢鬌鰖鵎𡐏𡛵𢓰𣟁𣷿𤱧𤹢𦝦𨁡𨺖])),
					result  => q(tuǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[唾柝毤毻箨籜萚蘀跅𣗸𣟄𣮆𥩀𦚈𧜲𧿧𨂫𩅡𩱾])),
					result  => q(tuò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䨟䯉䵷劸嗗娲媧挖搲攨洼溛漥畖穵窊窪蛙鼃𠴺𡁌𡚟𣢉𤬿𤮰𥤺𦞭𧧊𨩶𩨚𩩤𩿺])),
					result  => q(wā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[娃𣢚𤞇𩨾])),
					result  => q(wá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧚㼘佤咓瓦邷𣐎𦘵𦚩𨀄])),
					result  => q(wǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䍪䎳䚴䠚嗢聉腽膃袜襪韈韤𠹁𡧗𤬦𤿗𥥟𥿉𦤙𦫪])),
					result  => q(wà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哇屲瓲])),
					result  => q(wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖞㗏䴜喎歪竵𤟷𨵞𪉭])),
					result  => q(wāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[崴𢱉𨂿𨈕])),
					result  => q(wǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䠿䶐外夞顡𠨃𠰻𤤫𤷹𦘍𩔀𩕕𪑷])),
					result  => q(wài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘤䘎剜塆壪婠帵弯彎湾潫灣蜿豌𠝪𠠪𡇿𡤶𢺯𣡩𧯡𨂺𨈊𨉝𩅦])),
					result  => q(wān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝴䯈丸刓完岏抏捖汍烷玩琓紈纨翫芄頑顽𠒢𢓃𢓆𤥙𤻆𥤸𧲦𧿙𨩯𩾞𪐬])),
					result  => q(wán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜶㽜㿸䅋䑱䖤䗕䘼䛷䝹䩊䳃倇唍埦婉宛惋挽晚晩晼梚椀琬畹皖盌睕碗綩綰绾脘菀萖踠輓鋄鋔𡩄𡸥𢛙𢨔𤗍𥟶𦜐𦣾𧚇𧠆𨌔𨥧𨩵𨩻𩊁𩣵𪂦𪂧𪋅𪎛𪑉])),
					result  => q(wǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸘䛃䥑䯛万卍卐妧忨捥澫脕腕萬薍蟃貦贃贎輐錽鎫𠣉𡆅𢀗𢯲𣥃𤧩𥆶𥝄𦂔𦙵𦲯𦽞𧹗𨞼𩈬𩢄])),
					result  => q(wàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[杤笂邜])),
					result  => q(wan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺏⺐尣尩-尫汪𠕿𡝝𡯁𤷀𥆚𪁘])),
					result  => q(wāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[亡亾仼兦彺王莣蚟𡷢𦣦𦯌𧎕𩵭])),
					result  => q(wáng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺲⺴㓁㲿㳹㴏䋄䋞䒽䰣往徃徍惘暀枉棢瀇網网罒罔菵蛧蝄誷輞辋魍𡔞𢁶𢼟𣢫𣶈𣷪𥾼𦖉𦣩𦬣𧈿𧧜𨕿𨳠𩖩])),
					result  => q(wǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䤑妄忘旺望朢盳迋𢛛𣥊𥆜𥲠𦓋𧧄𧫢])),
					result  => q(wàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[焹])),
					result  => q(wang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕒㙎㙗㟪㣦㮃䋿䫋䴧偎危喴威媙巍微愄揋揻椳楲渨溦烓煨燰萎葨葳薇蜲蝛覣詴逶隇隈鰃鰄鳂𠳿𢼸𣫪𦈓𦓽𦩬𧍥𧚷𧛚𧟼𧤖𨖿𨻒𩹥𩼌𪑭])),
					result  => q(wēi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻙㣲䉠䑊䔺䙟䜅䝐䥩䧦唯喡囗围圍圩媁峗峞嵬帏帷幃惟桅欈沩洈涠湋溈潍潙潿濰犩琟癓硙磑維维蓶覹违違鄬醀鍏闈闱霺韋韦鮠𠄿𠙕𠥎𡇦𡚈𡼱𢾁𣄺𣲗𥅵𥌰𧝕𧞸𧢒𧢧𧲗𧳞𨠥𨱖𨴓𨿭𩀣𩀶𩁌𩋾𩎵𩏉𩠯𩴞𩽎])),
					result  => q(wéi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖐㙔㛱㞇㞑㠕㨊㬙㭏㱬䃬䇻䈧䍴䍷䞔䦱䪘䬿䵋伟伪偉偽僞儰厃壝委娓寪尾屗崣嵔徫愇撱斖暐梶椲洧浘濻瀢炜煒猥玮瑋痏痿硊磈緯纬腲艉芛苇荱葦蒍蔿薳蘤諉诿踓鍡韑韙韡韪頠颹骩-骫鮪鲔𠆟𡂗𡷕𢊯𢯷𢸦𣨙𤁿𤛲𤸆𤺉𤼒𥊪𥒮𥯜𥯤𦇅𦢿𦾛𧐌𧲄𨗨𨝀𨟗𨪈𨵋𩏏𩏿𩗘𩜧𩟟𩲂𩹷𩼂])),
					result  => q(wěi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥜㦣㷉䊊䗽䘙䙿䜜䡺䪋䬑䭳䮹䲁䵳为位卫叞味喂媦尉慰懀未渭為煟熭爲犚猬璏畏碨緭罻胃苿菋蔚藯蘶蜼蝟螱衛衞褽謂讆讏谓躗躛軎轊鏏霨餧餵饖魏鮇鳚𠹤𡔱𡶎𢉝𢍚𢙓𢣘𢲴𣈎𣩪𣽴𤀷𤜂𤻅𥉖𥧙𥶽𦝛𦠻𦩝𦪒𦳢𧍫𧒭𧔥𧕞𧲝𧳪𧴖𧸽𨃄𨚘𨢉𨾂𩑵𩗜𩤸𩨅𩲄𩹂𪂄𪑐])),
					result  => q(wèi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[墛嶶捤煀縅])),
					result  => q(wei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬈㼔塭昷榅殟温溫瑥瘟蕰豱輼轀辒鞰鰛鰮鳁𥁕𨜵𩥈𪉸])),
					result  => q(wēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䎹䎽䘇䰚匁彣文炆玟珳琝瘒紋纹聞芠蚉蚊螡蟁閺閿闅闦闻阌雯馼駇魰鳼鴍鼤𢾿𣜺𤵒𨶭𩢌𩭋𪉃])),
					result  => q(wén),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗃㝧䐇䦟刎吻呡忟抆桽稳穏穩紊肳脗𡁋𣶌𥦊𥧚𥬼𦝮𦟕𦮶𨆲])),
					result  => q(wěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡈問妏揾搵汶渂璺莬问顐𠐢𤛁𥃮𦦯𨟸𨸩])),
					result  => q(wèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[呚鈫鎾])),
					result  => q(wen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㮬㺋䈵䩺䱵嗡滃翁螉鎓鶲鹟𠰈𡻐𥕀𧚐𧛹𨜺𩔚𩰎])),
					result  => q(wēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘢㜲㹙䐥勜塕奣嵡暡瞈聬蓊𡩥𤌏𦞡𩄘𩡓𩮬])),
					result  => q(wěng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[瓮甕罋蕹齆𡍻𦧅𨞑])),
					result  => q(wèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㹻倭唩挝撾涡涹渦猧窝窩莴萵蜗蝸踒𠷏𡁮𡑟𤉦𩭝])),
					result  => q(wō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦱㧴䂺䰀婐我捰𠪧𡖲𢦴𢫷𣇫𣚝𥑣𥟿𧶕𨁟𩭏𩮑])),
					result  => q(wǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠛㱧䀑䁊䠎䮸仴偓卧媉幄捾握擭斡枂楃沃涴渥濣焥瓁瞃硪肟腛臒臥雘齷龌𠿟𡎔𣁳𣂽𤆏𤡓𤻌𥄗𥪍𦤨𦯏𦰖𦳹𦷵𧤒𧥋𨌝𩈱𩐦𩟓𩷯𪁕𪎤])),
					result  => q(wò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𥦷])),
					result  => q(wòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺎⺑㮧䖚䡧乌剭呜嗚圬屋巫弙杇歍汙汚污洿烏窏箼螐誣诬邬鄔鎢钨鰞鴮𠛆𠞆𡈎𢁢𤣬𥁡𥎮𥟽𦶀𦼇𧆹𧑕𧨆𩝷𪄝𪑱])),
					result  => q(wū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㷻㹳㻍䉑䍢䓊䦜䫓䮏吳吴吾呉唔娪无梧毋洖浯無珸璑祦禑芜茣莁蕪蜈蟱誈譕郚铻鯃鵐鷡鹀鼯𠘻𡷤𢃀𢋹𢓲𣟒𤭑𥕻𥭠𥲐𦥁𦨳𦷽𧳎𨼊𨿏𩒾𩳌𩶭𩻚])),
					result  => q(wú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐅㑄㒇㬳㵲䒉䟼䳇五仵伍侮俉倵儛午啎妩娬嫵庑廡忤怃憮捂摀旿橆武潕熓牾玝珷瑦甒碔舞躌鵡鹉𠥢𠯃𠵦𡈞𢑟𢜮𢨂𢩈𢫸𣲘𣺀𤆡𤸼𦌬𧴇𧺴𧽋𨖴𨡡𨶇𩠟𩵱])),
					result  => q(wǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐳㡔㽾䃖䎸䑁䛩䜑䦍䨁䳱伆兀务務勿卼坞塢奦婺寤屼岉嵍嵨忢悞悟悮戊扤敄晤杌溩焐熃物痦矹窹粅芴蘁誤误迕逜遻鋈阢隖雺雾霚霧靰騖骛鶩鹜鼿齀𠒄𠼘𡬫𡯇𡵉𢄓𢗳𢙁𢝴𣨓𣬽𣯎𤵐𥎈𥏒𥒀𥾕𦆞𦎦𦨉𦬂𧈭𧎻𧐙𧰈𨂣𨑥𨧗𨨡𨲬𩄯𩓦𩗽𩝕])),
					result  => q(wù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[乄錻])),
					result  => q(wu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻃㓾㕃㕧㗩㗭㘊㚀㛓㛫㛭㜎㜯㪧㬛㮩㯕㰿㱆㱤㲸㴔㴧㶉㺣㾷㿽䁯䂀䏩䐅䐖䒊䖒䖷䙵䛊䛥䭒䳶䶋俙傒僖兮凞卥厀吸唏唽嘻噏夕奚嬆嬉屖嵠嶲巇希徆徯忚怸恓息悉悕惁惜憙扱扸捿昔晞晰晳曦析桸榽樨橀欷氥汐浠淅溪潝烯焁焈焟焬煕熄熈熙熹-熻燨爔牺犀犧狶琋瘜皙睎瞦硒磎稀穸窸粞糦緆縘繥羲翕肸肹膝舾莃菥蒠蜥螅螇蟋蠵西覀觹觽觿譆谿豀豨豯貕赥郗鄎酅醯釸錫鏭鑴锡隵雟餏饻鵗鸂鼷𠆱𠔃𠔍𠘕𠜗𠟊𠨚𠩺𠬬𠴭𠶨𠺒𡁱𡏛𡗞𡗳𡘡𡩤𡳚𡻎𢀊𢋼𢑧𢗴𢜣𢡁𢨟𢬾𢹍𣅾𣎮𣟵𣢁𣢂𣢍𣢎𣢑𣤳𣤴𣨗𤃪𤄬𤓔𤓚𤠓𤡡𤢀𤥒𤬕𤬘𤮆𤮙𤲺𤳥𤶈𤶰𤷡𤹊𤺊𥄖𥄛𥈻𥋟𥰝𦐠𦙝𦜱𦞽𦠪𦤈𦩭𦮐𦼗𧀬𧈼𧥤𧯗𧲘𧶖𧹨𧻶𧿝𨀙𨋦𨡂𨳛𨵎𨻁𩅖𩒽𩗊𩗱𩭡𩽨𩾼𪃼𪄛])),
					result  => q(xī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔒㠄㦻㩗㽯㿇䏮䒁䚫䫣习媳嶍席椺槢檄漝習蒵蓆薂袭襲覡觋謵趘郋鎴隰霫飁騱騽驨鰼鳛𢙅𣒃𣳬𥺚𦪿𦸚𧋐𧐔𧿅𨛳𨻥𩲁𪄶𪓷𪕯])),
					result  => q(xí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䢄喜囍壐屣徙憘暿枲歖洗漇玺璽矖禧縰葈葸蓰蟢諰謑蹝躧鈢鉨鉩铣鱚𠉢𠪙𡅕𢊚𢒩𢒲𣯪𤟧𤤱𤨐𦱓𧣩𧺨𨜐𨞘𨮪𩎉𪖥𫍰])),
					result  => q(xǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑶㙾㚛㣟㤸㦦㭡㰥㸍䀌䈪䊠䐼䓇䜁䧍䨳䬣䮎䲪䵱係匸卌呬咥喺嚱墍屃屭忥怬恄慀戏戱戲椞欯滊潟澙熂犔盻矽磶禊稧系細綌繫细绤翖舃舄蕮虩衋覤赩趇郤釳闟阋隙隟霼餼饩鬩黖𠤴𠦜𡃢𡘐𡙋𡜧𡝧𡦎𡶯𢤋𢧽𢭁𣚔𣢓𣣉𣤢𣳦𤄎𤌷𤡬𥈜𥋁𥎃𥪦𥮬𥰥𥻥𥿭𦃝𦞝𦷲𧂙𧈅𧈍𧉁𧎵𧚃𧤟𧦁𧧹𧪢𧬈𧬊𧯈𧯊𧱲𧹶𧹽𨐛𨰿𨷘𩊿𩍆𩎥𩛹𩦇𩿛𪅲])),
					result  => q(xì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻄橲渓犠礂鯑])),
					result  => q(xi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔠㰨㰰䠍傄煆煵疨瞎虲虾蝦谺閕颬鰕𠽫𣢗𤗭𥁆𧇍𧦎𧪕𧯋𨳉𩮂])),
					result  => q(xiā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗇㘡㽠䖎䖖䘥䛅䪗䫗侠俠匣峡峽敮暇柙炠烚狎狭狹珨瑕硖硤碬磍祫筪縀縖翈舝舺蕸赮轄辖遐鍜鎋陜陿霞騢魻鶷黠𠢆𠩘𡈮𢈙𢈤𢑓𢘉𢚌𢝅𢻗𣹱𤙇𤪆𤪍𥯾𥰶𦦕𦵯𦾏𧆥𧔂𧕱𨲑𩉾𩎲𩏓𩐀𩝛𪗾𪘘])),
					result  => q(xiá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[閜])),
					result  => q(xiǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙈㙤㰺丅下乤吓嚇夏夓懗疜睱罅鎼鏬𡏘𡨄𡺷𢗄𢩹𤟝𥻴𧈄𧪹𧫒𨩽𨻲𨽯𩄗𪄂])),
					result  => q(xià),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[圷梺溊])),
					result  => q(xia),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔾㰹㲔㷿㸝㺤㾾㿌䂅䄳䆎䉳䊱䩂䯭䯹䵌仙仚佡僊先嘕奾嬐屳廯忺憸掀攕暹杴枮氙珗祆秈籼纎纖纤苮莶薟褼襳訮跹蹮躚酰銛鍁铦锨韯韱馦鮮鱻鲜鶱𠏓𠏡𠫄𢒆𢕖𢖎𢫿𢹚𣑹𣔙𣞘𣮾𣰷𤈷𥑻𥟕𥬍𦒜𦧐𦸊𧫹𧱀𧸂𨁅𨇤𨚾𩈖𪄏𪄷])),
					result  => q(xiān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘅㘋㛾㡉㢺㭹㮭㯗㰊㳄㳭㵪䕔䝨䦥䲗伭咸唌啣妶娴娹婱嫌嫺嫻弦憪挦撏涎澖燅甉痫癇癎瞯礥稴絃胘舷藖蚿蛝衔衘誸諴賢贒贤輱醎銜閑閒闲鷳鷴鷼鹇鹹麙𠓌𠛑𠷢𠿢𡫹𡰲𡿤𢅮𢎙𢐐𢖋𢛆𢮂𣊺𤉌𥲋𥻧𦎵𦑘𦠹𦱁𦽭𧂞𧈁𧼏𨺘𩝈𩤥𩤦𩦂𩱆𪂶𪔩])),
					result  => q(xián),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧥㫫㬎㭠㶍㿅䗾䘆䚚䜢䢾䥪䧋冼尟尠崄嶮幰搟攇显櫶毨灦烍燹狝猃獫獮玁禒筅箲藓蘚蚬譣赻跣銑鍌险険險韅顕顯𠠁𡗏𡸃𡾮𢁗𢥌𢷑𣕎𣟲𣭡𤓤𤞤𤼂𥜲𦭶𧕇𧖙𨙡𩏩𩨡𩶤])),
					result  => q(xiǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡾㦑㦓㪇㬗㺌㽉䁂䃱䃸䉯䏹䐄䙹䤼䦘䧟䧮䨘䨷䱤䵇䶟伣僩僴县咞哯垷壏姭娊娨宪岘峴憲撊晛橌涀瀗献獻现現県睍硍粯糮絤綫線縣线缐羡羨腺臔臽苋莧蜆誢豏鋧錎限陥陷餡馅麲鼸𠚆𠜎𠯟𡐖𡒓𡞣𢋮𢕭𢖝𢚀𣆕𤁦𤑃𤟅𥓒𥙆𥦶𥰳𥻇𥽏𦋈𦩢𧠒𧻒𧾨𨍒𨏥𨐊𨖱𨘙𨘞𨵬𨸄𩤊𩦹𩧩𪎉𪾢])),
					result  => q(xiàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[僲繊鑦])),
					result  => q(xian),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐮䬕乡厢啌廂忀欀湘瓖相稥箱緗缃膷芗葙薌襄郷鄉鄊鄕鑲镶香驤骧麘𢪷𤉪𤷼𥫖𩑇𩡌𩡠𪂼])),
					result  => q(xiāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟄䔗䜶佭庠栙瓨祥絴翔詳详跭𡹷𢭎𤝷𤭬𤰅𦍲𦍴𦎈𨀘𩾬])),
					result  => q(xiáng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗽䊑䐟䖮享亯响想晑曏蠁銄響飨餉饗饟饷鮝鯗鱶鲞𠸮𢞡𤍀𥊾𥿧𦕺𩝾𩞥])),
					result  => q(xiǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟟䢽䦳䴂像勨向嚮塂姠嶑巷橡珦缿萫蚃蟓衖襐象銗鐌闀項项鱌𢄵𢛖𢠷𣂝𣅰𣨳𤖽𤩪𥀾𥗵𥣟𦺣𦺨𧖿𧬰𨉽𨖶𨙵𨛜𨧑𨷄𨷿])),
					result  => q(xiàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[楿鱜])),
					result  => q(xiang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕺㚠㩋㪣㲖㹲㺒䌃䎄䨭䬘䴛侾呺哓哮嘋嘐嘵嚣嚻囂婋宯宵庨彇憢揱枭枵梟櫹歊毊消潇瀟灱灲焇猇獢痚痟硝硣穘窙箫簘簫綃绡翛膮萧萷蕭藃虈虓蟂蟏蟰蠨踃逍銷销霄驍骁髇髐魈鴞鴵鸮𠈬𠑪𠹎𡟣𡣾𡯩𡷸𡼚𢓮𢪶𢭦𢸳𣕇𣠎𤑳𤞚𤠖𤡔𤣠𤺃𥆔𦏷𦐺𦟞𧄤𧳍𧵱𨊅𨴹𨶅𩋍𩙚𩙮𩧓𩫂𩫳𩱴𩾒𩾓𩾾𪁎])),
					result  => q(xiāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚣㬵㮁䒝䟁崤殽洨淆笅筊訤誵郩𠴳𡦝𡧕𢛘𣏠𣔷𤕢𤷤𥾤𦺔𧍂𨠦])),
					result  => q(xiáo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺌⺍䒕䥵小晓暁曉皛皢筱筿篠謏𡱉𤽳𥔑𥕾𧡼𧢬𧩮𩵖𫍲])),
					result  => q(xiǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔅㗛㤊㵿䉰䊥䕧俲傚効咲啸嘨嘯孝效敩斅斆校歗涍熽笑肖詨誟鞩𠏕𠴡𡥍𡦳𢹳𢽾𣂬𣟇𣤡𣱓𣿣𤟞𤣌𤿨𥽁𦢩𦦛𦯪𦱜𧱐𨅋𪊷𪛀])),
					result  => q(xiào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[恷滧])),
					result  => q(xiao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗨㨝㱔㾚些揳楔歇猲蝎蠍𡭥𣆟𣒄𣣩𤺎𥌨𥗧𦪬𧓂𧳧𨧥𩫲])),
					result  => q(xiē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐖㖿㙝㙦㢵㥟㨙㩦㩪㭨䀘䔑䕵䙎䙽䝱䡡䦖䩤偕劦勰协協嗋垥奊峫恊愶拹挟挾携撷擕擷攜斜旪熁燲瑎綊緳纈缬翓胁脅脇膎蝢衺襭諧讗谐邪鞋鞵頡龤𠖹𠗉𡀺𡰢𡸔𢂐𢓬𢥘𢯉𢴲𢿡𣣲𣫴𣹩𣻠𤙒𤞡𤢺𤣑𤮯𤱷𥆥𥊯𥢹𦋅𦚫𦳃𧀺𧏂𧏃𧐃𧑦𧟃𧷑𨁂𨏳𨵚𨵪𨷥𩋘𩋧𩤠𩰳𩷂𩺫𪆋])),
					result  => q(xié),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕐㝍䥱䥾写冩寫藛𣞐𣬕𧭠])),
					result  => q(xiě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒠㓔㔎㖑㙰㞒㞕㡜㣯㣰㦪㰔㰡㳦㳿㴬㴮㴽㸉㽊䁋䉏䉣䊝䕈䙊䙝䚸䦏䩧䪥䲒䵦亵伳偞偰僁卨卸噧塮娎媟屑屓屟屧嶰廨徢懈暬械榍榭泄泻洩渫澥瀉瀣灺炧烲焎燮爕獬祄禼糏紲絏絬緤繲绁缷薢薤蟹蠏褉褻謝谢躞邂鞢韰駴齂齘齛齥𠅱𠑄𠨆𠲊𠸴𠿇𡃂𡄕𡗼𡛶𡞘𡟩𡣹𡤋𡽖𢌀𢖆𢗊𢜨𢞜𢤯𢤰𢬿𢹒𣣶𣽒𤑪𤗈𤡧𤫉𥀺𥇱𥍆𥎎𦁛𦔼𦖐𦚡𦞚𦩌𦵱𧀢𧌊𧌋𧌖𧍁𧓺𧖁𧛼𧜔𧜵𧝫𧭸𧷧𨇨𨈙𨤴𨳚𨼬𩂪𩃖𩍝𩎃𩐁𩐉𩙜𩽍𪙥])),
					result  => q(xiè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[夑脋])),
					result  => q(xie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛙㭢䅽䜣俽妡嬜廞心忻惞新昕杺欣歆炘盺芯薪訢辛邤鈊鋅鑫锌馨馫𠑰𠷓𡌜𢗀𢠝𢭧𣂗𣂜𣃄𤙖𤙣𦁍𦰸𨊳𩾽𩿃])),
					result  => q(xīn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚯㜦枔襑鐔𤫨𩖣])),
					result  => q(xín),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[伈𨓇])),
					result  => q(xǐn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐰㔤㛛㭄㾙䒖䚱䛨䜗伩信囟孞焮煡脪舋衅訫軐釁阠顖馸𡈏𢋆𢩲𣥇𤜢𤣲𤴾𤷓𤹩𦉝𦜓𦞤𦢯𦤟𧗹𧳄𧴢𩟍])),
					result  => q(xìn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺖⺗噺忄])),
					result  => q(xin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙚㷣䃏䕟䗌垶惺星曐煋猩瑆皨箵篂腥蛵觪觲鍟騂骍鮏鯹𠬋𡃳𣨾𤏽𤙡𥠀𦂅𦈒𦖤𦩠𧌚𧛟𨌍𨞾])),
					result  => q(xīng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐩㓝㣜㼛䣆䤯侀刑型娙形洐滎硎荥行邢郉鈃鉶銒鋞钘铏陉陘𠀦𡶭𣸝𤬐𤶲𦈨𦈵𧊞𧊽𧗦𩩋])),
					result  => q(xíng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝭㨘䳙擤睲醒𢜫𥨕])),
					result  => q(xǐng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓑㼬䁄䂔䓷䛭䰢倖兴姓婞嬹幸性悻杏涬緈臖興荇莕𢙼𣢝𩈡])),
					result  => q(xìng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哘裄謃])),
					result  => q(xing),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐫㚾兄兇凶匈哅忷恟汹洶胷胸訩詾讻賯𦙄𦵡𧘮𧵣𧿖𨥍𩌠𩴂])),
					result  => q(xiōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䧺熊雄𧞞𧰯])),
					result  => q(xióng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[焽])),
					result  => q(xiǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[夐敻焸詗诇𠓙𡨳𡪰𡬁𢢹𢿌𣅷𤔫𤛪𥃴𥥧𥦥𦈤𦓈𦬺𧽒𩧊])),
					result  => q(xiòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱗㳜㵻㹋㾋䏫䐰䗛䡭休俢修咻庥樇烋烌羞脙脩臹貅銝鎀鏅飍饈馐髤髹鱃鵂鸺𡔨𡜨𡟞𡯐𢊒𢕦𥌪𥞼𦟤𦪋𧌌𩘭𩛢𩡎𩢮𩭘𩮄𪀪𪘆])),
					result  => q(xiū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[苬])),
					result  => q(xiú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱙朽滫糔綇𣧬𦈋𪕦])),
					result  => q(xiǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗜嗅岫峀溴珛琇璓秀繍繡绣螑袖褎褏銹鏥鏽锈齅𢓵𤚯𧙏𪁮])),
					result  => q(xiù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鮴])),
					result  => q(xiu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㥠㰭㽳䇓䈝䏏䱬吁嘘噓墟媭嬃幁戌揟旴晇楈欨歔湑疞盱窢縃繻胥蕦虗虚虛蝑裇訏諝譃谞鑐需須頊须顼驉鬚魆魖𠧰𠾫𢄼𢖳𢨁𢨰𢩕𣅤𣚏𣰃𤚉𤟠𤡣𥈈𥕰𥮪𥳗𦄼𦅏𦈡𦘼𦪡𦰰𦰲𦲰𧆜𧙆𧟬𧪮𨂠𨅑𨞣𨬗𨼋𩂉𩑕𩒇𩒧𩓣𩖕𩾊𪆛𪙫])),
					result  => q(xū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䍱俆徐蒣𣆒𥅺𨌎])),
					result  => q(xú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑔㑯㞰䅡䋶䔓䧁偦冔呴姁暊栩珝盨稰糈許詡许诩鄦醑𡹲𤸀𥚩𦠷𧕼𨋾𨍐𩝔𩠋𩰠])),
					result  => q(xǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐨㕛㖅㗵㘧㜅㜿㞊㳚㵰㷦㺷䂆䎉䘏䙒䛙䢕䣱䣴䦗䦽䬄䳳伵侐勖勗卹叙喣垿壻婿序怴恤慉敍敘旭昫朂槒欰殈汿沀洫溆漵潊烅烼煦獝珬盢瞁瞲稸絮緒緖續绪续聟芧蓄藇藚訹賉酗銊魣鱮𠆐𠜄𠷙𠹘𡦁𡱣𣊞𣢊𣨤𣸃𤆞𤇳𤡶𤬱𤭽𤲸𤷇𥄵𥆛𥇏𥇿𥊊𥍟𥎕𥎗𦑍𦕓𦜃𦝳𦯅𧁃𧆡𧊥𧏺𧧓𧶍𧹭𧹴𧼑𨜿𨣦𨴎𨵮𨷔𨹘𨻍𩌮𩌲𩍳𩔴𩔼𩣊𩪉𩽆𪖩𫚈])),
					result  => q(xù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[続聓蓿])),
					result  => q(xu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓩㝁㦥㩊㻹䁔䆭䚙䚭䳦儇吅喧塇媗宣弲愃愋懁揎昍暄梋煊瑄睻矎禤箮縇翧翾萱萲蓒蕿藼蘐蝖蠉諠諼譞谖軒轩鋗鍹駽𡈣𡬳𢏧𢙂𢰊𤟿𦐽𦑙𧑩𧤎𧾎𩋱𩕖𩕪𩤡])),
					result  => q(xuān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔯㘣㳬㹡䁢䗠䮄䲂䲻嫙悬懸旋暶檈漩玄玹琁璇璿痃蜁𠗻𠣖𠥞𡈴𡾥𣟳𧉎𧐗𧔤𧜽𧟨𩙢])),
					result  => q(xuán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔵㧋㾌䠣咺晅烜癣癬选選顈𢈋𣉖𣎓𥥾𥶷𦌔𧡚𧡢𩘒])),
					result  => q(xuǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧦㯀㳙䀏䃠䍗䍻䝮䧎䩙䩰怰昡楥楦泫渲炫琄眩眴碹絢縼繏绚蔙衒袨讂贙鉉鏇铉镟鞙颴𠵷𢂄𢳄𤂿𥌭𦈝𦛔𧾆𨁁𨊼𨹆𩃚𩉥𩋢𩋫𩑹𪍧])),
					result  => q(xuàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鰚])),
					result  => q(xuan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗾㻡削疶蒆薛辥辪靴鞾𢪎𥄒𪃅])),
					result  => q(xuē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖸㰒㶅㿱䋉䱑乴壆学學岤峃嶨斈泶澩燢穴茓袕觷踅雤鷽鸴𢯳𢼺𥀣𦥯𧉢𧸗])),
					result  => q(xué),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䨮雪鱈鳕])),
					result  => q(xuě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕰㞽䆝䆷䎀䒸䛎䤕䦑䫼䬂䭥吷坹桖瀥狘血謔谑趐𣧌𣧡𣧵𣪨𣺭𤀰𥄎𥄴𥅧𦐍𦰾𧔗𧮞𨑣𨭁𩌊𩖱𩖶])),
					result  => q(xuè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[樰膤艝轌])),
					result  => q(xue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䗼䠝䵫勋勛勲勳坃埙塤壎壦曛焄熏燻獯矄窨纁臐蔒薫薰蘍醺駨𡑎𡺕𤑕𦘶𧰣𩪱𫄸])),
					result  => q(xūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖊㜄㡄㨚㰬㵌㽦䋸䖲䘩䙉偱噚寻尋峋巡廵循恂揗攳旬杊栒桪槆樳毥洵浔潃潯灥燖珣璕畃紃荀荨蟳詢询鄩馴驯鱏鱘鲟𣌨𣖼𤃺𤛧𤿟𥒘𥙣𥳍𥾡𦅀𦅑𦠅𦳣𧾝𧾠𧾩𨀴𨼔𩖰𪀠𪀽])),
					result  => q(xún),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢲䛜䞊䭀伨侚卂噀奞巺巽徇愻殉殾汛潠爋狥稄蕈訊訓訙训讯賐迅迿逊遜鑂顨鵕𠊫𠹀𡿼𢏤𣹯𦫯𧥿𧸩𨺮𩊻𩠇𩷰𩾄𩾧𪇑])),
					result  => q(xùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嚑])),
					result  => q(xun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝞㳌㾎䃁䆘丫压吖圧垭埡壓孲庘押枒桠椏錏鐚鴉鴨鵶鸦鸭𠋗𠜲𣏎𤵭𥇠𨨙𨸺𩭯𩿔])),
					result  => q(yā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧎䄰伢厑厓堐岈崕崖涯漄牙猚玡琊瑘睚笌芽蚜衙齖𤘅𤘆𧓪𧬬𨖭𩃐𪗹𪘲])),
					result  => q(yá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㿿䪵厊哑唖啞庌痖瘂蕥雅𤴓𤹎𧧝𨁶])),
					result  => q(yǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㰳䅉䝟䢝䦪䰲亚亜亞俹劜圔圠娅婭挜掗揠氩氬犽猰砑稏窫聐襾訝讶軋轧迓铔齾𠄮𠮜𠵣𡇼𡴭𡶦𡷻𡸗𡹄𢛄𢛟𢮊𣉩𥏝𥐕𥒧𦉟𦉧𦜖𧈝𨓴𩨠𩮝𪆰])),
					result  => q(yà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺂⺄乛呀])),
					result  => q(ya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖶㤿㮒㸶䅧䊙䑍䗎䞛偣剦啱嫣嬮崦恹懕懨淊淹湮漹烟焉焑煙猒珚硽篶胭腌臙菸鄢醃閹阉黫𠛭𠝢𢤍𣩙𤎄𤟟𤡖𥷀𦎣𦏥𦛞𦝪𧹬𧺅𨣻𨽑𩈯𩣲])),
					result  => q(yān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻈㗴㘖㘙㝚㫟㳂㶄㺂㿕㿼䀋䀽䂴䇾䉷䓂䖗䗡䢥䦲䫡严厳嚴塩壛壧妍姸娫娮孍岩嵒嵓巌巖巗延揅昖楌檐櫩沿湺炎狿琂盐研硏碞礹筵簷綖芫莚蔅虤蜒言訁詽讠郔閆閻阎顏顔颜鹽麣黬𠘥𠰖𡣽𢉘𢌨𣡞𣡶𣥡𣭻𣼞𤅸𤖝𤡥𤢋𤯐𤲩𥕼𥤟𥴿𥶿𦌚𦛣𦫤𧇱𧍢𧎘𧬌𧴣𧻃𨡄𨤎𨷽𨸮𩩄𩩴𪂈])),
					result  => q(yán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕣㚧㢂㫃㭺䁙䄋䌪䍾䎦䗺䣍䤷䲓䶮乵俨偃儼兖兗匽厣厴噞夵奄嵃嶖巘巚弇愝戭扊抁掩揜曮棪椼檿沇渰渷演琰甗眼縯罨萒蝘衍裺褗躽遃郾酓隒顩験魇魘鰋鶠黡黤黭黶鼴鼹齞齴龑𠆲𠍛𠻤𡙶𡹶𢅠𢇘𢈂𢯼𢸴𢾑𣃧𣃳𣄉𣄑𣝎𣼠𤂠𤗎𤟇𤫣𤯇𤸹𥀬𥃿𥍻𥜒𥣘𥤴𥯃𦁙𦏹𦖈𦧡𧊔𧞣𧠦𧥜𧽉𧽞𧾤𨀅𨁹𨂪𨃰𨒄𨟹𨠭𨺥𩗷𩻖𪒝𪒠𪗙𪗤])),
					result  => q(yǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛪㢛㦔㬫㰽㷔㷳㷼䂩䛳䜩䞁䢭䨄䳛䳡䳺䴏䶫偐傿厌厭咽唁喭嚥堰墕妟姲嬊嬿宴彥彦敥晏暥曕曣椻溎滟灎灔灧灩烻焔焰焱燄燕爓牪砚硯艳艶艷葕覎觃觾諺讌讞谚谳豓豔贋贗赝酀酽醶醼釅闫隁雁餍饜騐騴驗驠验鬳鳫鴈鴳鷃鷰𡚇𢇈𢔂𢜰𣃾𣄝𣡕𤅊𤜵𤬝𦁏𦑎𦖧𧩅𨁍𨡎𨡣𨪶𨴣𨶁𨻂𨻳𩃀𩒖𩜽𩩶𩪴𩳢𩸞𪁡𪑈𪙊])),
					result  => q(yàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[樮欕熖軅])),
					result  => q(yan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒕䱀咉央姎抰殃泱眏秧胦鉠雵鞅鴦鸯𠮴𣐫𤢐𤸡𥃽𦴊𧲱𩲴𪓛𪚻])),
					result  => q(yāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟅㦹㬕䁑䖹䬗佯劷垟崵崸徉扬揚敭旸昜暘杨楊氜洋炀烊煬珜疡瘍眻禓羊羏蛘諹輰鍚鐊钖阦阳陽霷颺飏鰑鴹鸉𡩶𡹕𢏙𢽕𣉚𤞢𤢮𥂸𥒞𥬴𥳜𦍕𦍹𦭵𦼴𨋽𨒫𩋬𩤟𩴨𪕫])),
					result  => q(yáng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔦䍩䑆䒋仰佒傟养坱岟慃懩攁柍楧氧氱炴痒癢紻蝆軮養駚𠢴𣃝𦏱𦯒𧓲𧵌𨱝𩊑𩧫])),
					result  => q(yǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨾㺊㿮䬺䭐䵮怏恙样様樣漾瀁羕詇𠍵𡠘𡡂𢟣𢵇𣗹𥠜𥥵𧥴𧫛𨋕𨎔𨖌])),
					result  => q(yàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[奍礢羪])),
					result  => q(yang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺓㙘䌁䙅䛂䳩吆喓夭妖幺枖楆殀祅腰葽訞邀鴁𠕻𠣑𡆩𡝩𡢹𡣠𢆷𢆽𣨘𥹱𦔷𧍔𧷋𨓳𩑗𩜸])),
					result  => q(yāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑸㑾㨱䂚䆙䋂䌊䌛䔄䖴䚺䚻䠛䢣䬙倄傜嗂垚堯姚媱尧尭峣嶢嶤徭愮揺搖摇暚榣烑爻猺珧瑤瑶窑窯窰繇肴蘨謠謡谣軺轺遙遥邎銚鎐顤颻飖餆餚鰩鳐𠌠𠏈𠑐𡔜𡝛𡩸𡺯𢈆𢊙𢋇𢑈𣣳𤚭𤫺𤬔𤬖𦆸𦾺𦾾𧄎𧤮𧽎𨍳𨘔𨹋𩋃𩥣𩲻𩿕])),
					result  => q(yáo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝔㟱㢓㫏㫐㴭㹓䁏䁘䆗䆞䯚䴠䶧仸偠咬婹宎岆崾抭杳柼榚溔狕眑窅窈舀苭蓔闄騕鴢鷕鼼齩𠢩𡛙𡨇𢂊𥤣𥦖𦥝𦦌𧠽𨱧𩢒𩨴𩩼𩬗𪐯])),
					result  => q(yǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔽㞁㵸㿑㿢曜熎燿獟矅穾窔筄纅耀艞药葯薬藥袎要覞詏讑鑰钥靿鷂鹞𠍩𠟋𠹑𡶂𢅹𢝍𢺇𤂼𤄶𤒝𤾫𥁒𥃺𥌺𥤹𥪯𥬓𦇬𦡱𦤋𧇠𧢢𩑴𩯛𩳔𪖐])),
					result  => q(yào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䭇倻噎掖暍椰潱蠮𧏽𧒐𨶮𨸌𩜺])),
					result  => q(yē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡋㱌䓉䥺捓揶擨爷爺耶釾鋣鎁铘𣚋𣩯𤑷𥯘𦕆𦰳𨈺𩸾])),
					result  => q(yé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙒也冶吔嘢埜壄漜野𠥇𡑀𢀘𤝉𧐓])),
					result  => q(yě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻚㖡㗼㥷㩎㪑㱉㸣䁆䈎䊦䎨䢡䤳䤶䥟䥡䧨䭎䭟䱒䲜业亱僷叶啘嚈堨墷夜嶪嶫抴擛擪擫晔曄曅曗曳曵枼枽楪業歋殗液澲烨燁爗皣瞱瞸礏腋葉謁谒邺鄓鄴鍱鎑鐷靥靨頁页餣饁馌驜鵺鸈𠀸𠄅𠟪𠱝𡀽𡁁𡛌𡛽𡽣𢉥𢢜𢪧𢱴𣎩𣐂𣚕𣩫𣰛𤝇𤝱𤳪𥌅𥠍𥮧𦀕𦂡𦠜𦤪𧎭𧔦𧗖𨂒𨉅𨼥𨽀𩉂𩐱𩑃𩘏𩱝𩼋𩼴𪋫𪍅𪑦𪒲])),
					result  => q(yè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[亪])),
					result  => q(ye),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙠㛄㥋㳖㾨䃜䉗䒾䔱䚷䧇䪰䫑一乊伊依医吚咿噫壱壹夁嫛嬄弌悘揖檹欹毉洢漪猗瑿祎禕稦繄蛜衣衤譩郼醫銥铱鷖鹥黟黳𠰄𠲔𠲖𠿣𡄵𡜬𢊘𢣉𢨮𣐿𣘦𣢷𧉅𧜤𧫦𧮒𩕲𩥯𩮵𪁚𪈨])),
					result  => q(yī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐌㚦㝖㞔㥴㦾㰘㹫㺿㼢䄬䇵䔟䞅䣡䧅䩟䬁䬮䮊䱌䲑䴊乁仪侇儀冝凒匜咦圯夷姨媐宐宜宧寲峓嶬嶷巸弬彛-彞怡恞扅拸暆柂栘桋椸沂沶熪狋珆瓵疑痍眙移箷簃羠耛胰萓蛦螔衪袘觺訑詑詒誃謻讉诒貤貽贻跠迆迤迻遗遺鏔頉頤顊颐飴饴鸃𠄱𠅌𠈶𠍫𠏩𠐀𠗺𠛃𠜁𠤕𠤗𠤘𠩗𠪗𠲻𠼪𡬓𡱐𡷪𡻣𢂒𢓡𢕷𢖅𢞉𢩼𢱁𣐓𣐵𣕁𣙛𣢭𣸘𤆾𤇴𤈙𤖪𤘊𤝻𥃸𥄻𥄿𥌟𥙁𥙇𥫃𥹋𦚟𦟧𦡫𧓗𧡇𧣟𧣬𧦧𧳁𧷅𨛯𨜽𨠑𨠶𨣬𨳷𩓧𩔦𩖹𩖾𩗑𩚇𩛮𩤒𩸨𩼨𪀓𪐔𪘬𫍟])),
					result  => q(yí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕈㠖㠯㫊㰝㰻䉝䝝䧧䭲䰙乙以佁倚偯崺已庡扆攺敼旑旖椅檥矣礒笖肔舣艤苡苢蚁螘蟻裿踦輢轙逘酏釔鉯钇顗鳦齮𠮙𠯋𡼎𢙇𢦕𢷔𤝳𥏜𥑴𥫜𥰧𦮸𧔮𩛆𩠂𩡣𩾠𪐣𪘃𪙴])),
					result  => q(yǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐹㑊㑜㑥㓷㔴㖂㘁㘈㙪㙯㚤㛕㛳㜋㜒㝣㡫㡼㢞㣇㣻㦉㦤㱅㱞㱲㲼㳑㴁㴒㵝㵩㶠㹭㽈䄁䄩䄿䆿䇩䇼䉨䋚䋵䌻䎈䓃䓈䓹䔬䕍䖁䖊䖌䗑䗟䗷䘝䘸䝘䝯䢃䣧䦴䬥䭂䭞䭿䯆䰯䴬䵝乂义亄亦亿伇伿佚佾俋億兿刈劓劮勚勩呓呭呹唈囈圛坄垼埶埸墿奕嫕嬑嬟寱屹峄嶧帟帠幆廙异弈弋役忆怈怿悒悥意憶懌懿抑挹捙掜撎敡斁易晹曀曎杙枍枻栧栺棭榏槸檍欥欭歝殔殪殹毅泆洂浂浥浳湙溢潩澺瀷炈焲熠熤熼燚燡燱獈玴異疫痬瘗瘞瘱癔益睪瞖硛秇穓竩縊繶繹绎缢羛義羿翊翌翳翼耴肄肊膉臆艗艺芅苅蓺薏藙藝蘙虉蛡蜴螠衵袣裔裛褹襼訲訳詍詣誼譯議讛议译诣谊豙豛豷賹贀跇軼轶逸邑醳醷釴鈠鎰鐿镒镱陭隿霬靾饐駅驛驿骮鮨鯣鶂鶃鷁鷊鷧鷾鹝鹢黓齸𠂆𠍳𠓋𠚮𠡔𠡝𠥦𠨾𠩫𠲚𠲺𠶷𠽜𡄻𡉛𡊁𡊶𡍡𡥁𡾾𢀁𢂗𢂼𢄅𢇙𢇚𢇸𢈶𢍰𢎀𢎃𢎉𢏗𢓀𢖫𢖴𢖺𢗎𢘽𢡃𢨳𢩮𣎅𣚘𣡊𣤪𣦌𣧄𣨟𣫙𣶫𣷩𣿉𤑹𤣨𤣮𤤺𤥿𤧕𤬩𤴧𤶛𤷅𤸸𤻂𤼌𥃠𥅓𥍴𥒵𥘒𥘠𥜃𥜥𥟘𥡪𥥌𥥴𥩖𥫝𥱃𥸊𥾐𥿹𦌩𦎝𦏸𦓻𦔜𦔥𦘳𦙨𦠉𦥱𦨇𦭥𦶂𧃟𧅖𧆦𧈻𧊣𧊤𧋏𧑌𧙡𧢂𧬇𧱊𧱏𧷥𧺎𧺝𧾰𨋯𨜶𨣠𨦯𨱁𨹝𨻊𨻏𨽹𩂒𩂹𩈭𩋌𩍖𩎭𩎷𩘧𩚂𩟉𩣞𩧭𩪟𩪣𩳇𩴜𩴮𩷍𩷘𩾘𩾢𪀕𪁛𪎈𪐘𪒕𪕶𪗷𫍙])),
					result  => q(yì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻂匇椬畩籎萟辷鶍])),
					result  => q(yi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧢㶏䄄䓰䜾䤃侌凐喑噾囙因垔堙姻婣愔慇摿栶歅殷氤洇溵瘖禋秵筃絪緸茵荫蔭裀諲銦铟闉阥阴陰陻隂霒霠鞇音韾駰骃𠖟𡇂𡈲𡋪𡖣𢉩𣱜𣸊𤝎𦈑𧊭𩃬])),
					result  => q(yīn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐺㕂㖗㙬㝙㞤㸒㹜㹞䓄䕾䖐䖜䪩䴦乑冘吟噖嚚圁垠夤婬寅峾崟崯斦檭殥泿淫滛烎犾狺珢璌碒苂荶蔩蟫訔訚訡誾鄞鈝銀银霪鷣齗龂𠪚𡐔𡓓𡓿𡸛𢂨𢓕𢝯𣓆𣘴𣽮𤷏𥤷𥮍𦟘𧦸𧩬𨓮𨛊𨟏𨦆𩂢𪘎𪙾𪛊])),
					result  => q(yín),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺃㐆㥯㦩㧈㱃䇙䌥䒡䨸乚吲尹嶾廴引朄檃櫽淾濥濦瘾癮磤蘟蚓螾讔赺趛輑鈏隐隠隱靷飮飲饮𠃊𠽨𡼽𢋻𢓙𢛦𣔸𤂹𤻘𥖵𥬜𦈠𦾻𨈧𨏈𨐐𨒦𨡢𩖄𩚕𪙤])),
					result  => q(yǐn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒚㡥㣧㥼㪦㴈䕃䚿䡛䲟印垽堷廕慭憖憗懚檼洕湚猌癊胤茚蒑酳鮣𡩘𢌲𢪪𢳃𢷍𣦫𣱐𤢦𤯸𤵯𦜲𦝴𧥸𧦹𨋙𨟴𨢂𩂥𩐞𩬵𪔰𪔽])),
					result  => q(yìn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[粌])),
					result  => q(yin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡕䁐䓨䣐䦫䧹䪯䴍偀啨嘤嚶婴媖嫈嬰孆孾应応應撄攖朠桜樱櫻渶煐瑛璎瓔甇甖碤礯緓纓绬缨罂罃罌膺英莺蘡蝧蠳褮譍譻賏鍈鑍锳霙韺鴬鶑鶧鶯鷪鷹鸎鸚鹦鹰𠠜𠮳𠸄𡎘𢄋𤜉𤣎𤭫𥌽𥌾𥍼𥐑𦔃𦦿𧓀𧕄𧢛𧮆𧯀𨍞𨟙𨵛𩄪𩹅])),
					result  => q(yīng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨕㵬㶈㹚㿘䁝䃷䊔䑉䕦䤰僌営塋嬴攍楹櫿溁溋滢潆濙濚濴瀅瀛瀠瀯瀴熒營瑩盁盈籝籯縈茔荧莹萤-萦萾蓥藀蛍蝇蝿螢蠅覮謍贏赢迎鎣𡃅𡺡𢥏𣲜𤟣𤹜𦖽𦝚𧅋𧕍𧭓𨜏𩸥𩻷])),
					result  => q(yíng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢍㲟㹵䀴䚆䨍䬬䭊䭗䭘巊廮影摬梬浧潁璄瘿癭矨穎郢頴颍颕颖𠝟𡂚𣟤𣤵𤁽𤌌𥏎𦡺𦢆𨠸𩖍𩘑𩳍𪊵])),
					result  => q(yǐng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑞䙬䤝䵴噟媵映暎硬膡鐛鞕鱦𠊶𡀘𡁊𡄖𢣙𣋋𤇾𤹥𥚿𦩩𨪄𩋹])),
					result  => q(yìng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[愥攚灐灜珱縄軈])),
					result  => q(ying),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哟唷喲])),
					result  => q(yō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐯㜉㟾㴩㻾㽫䗸䧡佣傭嗈噰墉壅嫞庸廱慵拥擁槦滽澭灉痈癕癰臃邕郺鄘鏞镛雍雝饔鱅鳙鷛𠆌𢀍𢢓𢧳𣋿𤛑𥑿𥧱𦃽𦤘𧝸𧴄𧴗𩍓𩟀𩟷𪄉𪇛𪪝])),
					result  => q(yōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝘䗤喁揘牅顒颙鰫𧲤𧺸𨦡𩔔𩤛𪅟])),
					result  => q(yóng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙲㦷㴄㷏䞻俑傛勇勈咏埇塎嵱彮恿悀惥愑愹慂柡栐永泳涌湧甬硧禜蛹詠踊踴鯒鲬𠳀𠹍𣏀𦨤𦨬𧖇𧗴𧻹𨓨𨤂𨴭𩆄𩜳])),
					result  => q(yǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞲㶲用苚醟𡵜𥁎𥥝𧙇𨶽𩬮])),
					result  => q(yòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[怺砽])),
					result  => q(yong),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗀㱊㳊㴗䥳优優呦嚘幽忧怮悠憂攸櫌泑滺瀀纋耰逌鄾麀𠘳𠨦𠮫𡺒𡺖𢆶𢋣𢿚𣁨𤄘𤣙𥣯𥽟𦎓𧀥𧍘𩘈𩤹𩽇])),
					result  => q(yōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒡㕱㘥㚭㛜㫍㳺㽕㾞䍃䑻䖻䚃䢊䢟偤尢尤峳怣斿楢櫾沋油浟游犹猶猷由疣秞肬莜莸蕕蚰蝣訧輏輶逰遊邮郵鈾铀駀魷鮋鱿鲉𠧠𠧴𡇀𡈙𡈰𡈵𡋧𡯙𢓿𢖟𢟅𣏞𣓐𣧗𤘜𤤧𤸈𥯞𥴕𦑸𦥣𦳧𦳷𦵵𦷿𦸙𧡹𧰰𧳫𨑫𨗰𨘁𨘵𨙂𨛕𨸙𩗚𩘓𩥘𩹊𩿬])),
					result  => q(yóu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㮋㰶㶭䅎䒴䬀䱂䳑丣卣友庮懮有栯梄槱湵牖禉羐羑聈脜苃莠蜏酉銪铕黝𠖋𠢢𡊧𢪥𣅺𣢄𣢜𣣜𣣸𣤎𣧥𣸠𣿤𤍕𤪎𤱎𥜚𥝘𦏇𦩲𧆕𧠶𨡴])),
					result  => q(yǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺀㓜㕗㤑㹨㺠䀁䆜䛻䞥亴佑侑又右哊唀囿姷宥峟幼柚牰狖祐糿蚴誘诱貁迶酭釉鼬𡜳𡯉𢈓𣅄𣓛𤤬𤴨𥙾𦳩𧅲𧆘𩑣𩜷𩲎𩴑𩴙])),
					result  => q(yòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[孧牗蒏])),
					result  => q(you),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝼㰲䆰䣿䩽唹扜毺淤瘀盓穻箊紆纡虶迂迃陓𤕘𤥽𧈯𨖛𩂧])),
					result  => q(yū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻥㚥㤤㥚㥥㪀㬂㬰㳛㶛㷒㺞㺮㻀㼶䁩䂛䃋䄏䄨䍂䏸䐳䔡䗨䜽䢓䩒䬔䰻䱷䲣乻于亐伃余俞兪堣堬妤娛娯娱嬩崳嵎嵛愉愚扵揄於旕旟杅桙楡楰榆欤歈歟歶渔渝湡漁澞牏狳玗玙瑜璵畭盂睮硢禺窬竽籅羭腴臾舁舆艅茰萮萸蕍蘛虞蝓螸衧褕覦觎諛謣谀踰輿逾邘酑鍝隅雓雩餘馀騟骬髃魚鮽鰅鱼鷠鸆𠎳𠧇𠸹𡁎𡂊𡑾𢊧𢋅𢎻𢔢𢹏𢾄𣄊𣟰𣢒𤚎𤜹𤧙𥔢𥝨𥯮𥷔𦈣𦋯𦏻𦦫𦩞𦱃𧃠𧊠𧍪𧙶𧞏𧰇𧾚𨊱𨜖𨨶𨰸𨵦𨶢𨾌𩟳𩡃𩢶𩤺𩥭𩦡𩦢𩨈𩨗𩨙𩺰𪃍𪃎𪇝𪉐𪊻𪑝])),
					result  => q(yú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻗㑨㒁㒜㔱㙑㝢㠘㡰㣃㦛㲾㺄㼌䣁䥏䨞与予伛俁俣偊傴匬噳圄圉宇寙屿峿嶼庾懙敔斔斞楀瑀瘐祤禹窳羽與萭蘌語语貐鄅鋙雨頨麌齬龉𠋟𠱐𡷎𡻢𢮁𣢦𣨝𤗃𤹪𥒾𥛩𦀡𦥉𦦲𦭳𦳅𧱬𨝈𨵉𩃯𩩑𩩘𩵎𪂕𪋬])),
					result  => q(yǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺺⺻㚜㠨㤢㥔㦽㧒㽣䁌䂊䈅䉛䋖䋭䍞䖇䘘䘱䘻䛕䜡䞝䢖䢩䤋䨒䫻䮇䮙䴁䵥俼儥喅喐喩喻噊圫域堉妪媀嫗寓峪嶎庽彧御忬悆惐愈慾戫昱棛棜棫櫲欎欝欲毓浴淢淯滪潏澦灪焴煜燏燠爩狱獄玉琙瘉癒矞砡硲礇礖礜禦秗稢稶穥篽籞籲緎繘罭聿肀育艈芋芌茟蒮蓣蓹蕷薁蜟蜮裕誉諭譽谕豫軉輍轝逳遇遹郁醧鈺銉鋊錥鐭钰閾阈霱預预飫饇饫馭驈驭鬰鬱鬻魊鱊鳿鴥鴪鵒鷸鸒鹆鹬龥𠀛𠊏𠏚𠕦𠫣𠽵𡇺𡈨𡋬𡒃𡒊𡔴𡨣𡨿𡬊𡬞𡿥𡿯𢌻𢒰𢔥𢔬𢔴𢖡𢛨𢡎𢯮𢺴𣋉𣍛𣕃𣝑𣡉𣣎𣩺𤀝𤞞𤳕𤸒𥆉𥉑𥎐𥘄𥙿𥝍𥷞𥸤𥸪𥹔𦈸𦋢𦎘𦏜𦒑𦡭𦦩𦱀𦱂𧉣𧐄𧑐𧗪𧫊𧶠𧼫𧿷𨄯𨉗𨗝𨞓𨩬𨪎𨮔𩈕𩊇𩋉𩋤𩎹𩏟𩏴𩘤𩘳𩘻𩚄𩛪𩛭𩝗𩟑𩰪𩱌𩱱𩲾𪁀𪂉𪂵𪋉𪋮𪑆𪑌𪓊])),
					result  => q(yù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[挧澚荢鯲])),
					result  => q(yu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠾㾓䡝䥉䨊冤剈囦嬽寃悁惌棩淵渁渆渊渕灁眢箢葾蒬蜎蜵裷駌鳶鴛鵷鸢鸳鹓鼘鼝𡈒𡢊𡣬𡷡𢍈𢏮𢱽𣹠𥿎𨀮𨓯𨖳𩛟𩝸𪀈𪔗𪔙])),
					result  => q(yuān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟶㥳㹉䖠䦾䬧䱲䲮䳒䳣元円原厡厵员員园圆圎園圓垣塬媴嫄援杬榞榬橼櫞沅湲源溒爰猨猿獂笎緣縁缘羱茒蒝薗蚖蝝蝯螈袁謜貟贠轅辕邍邧鎱騵魭鶢鶰黿鼋𠝳𠩠𢆀𢗯𢷻𤬌𦍼𦿂𧉗𧔞𧳭𧻚𨕗𨸘𨻣𩉯𩍻𩰵𪄁𪔅𪕀])),
					result  => q(yuán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䛄䛇䩩盶远逺遠鋺𠒜𡯱𩌑𩐘𩔃])),
					result  => q(yuǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㤪㥐㭇䅈䏍䬇䬼傆噮垸夗妴媛怨愿掾瑗禐肙苑衏裫褑褤院願𡈓𢂱𢐄𢕋𥭞𧙮𩕾𩘍𩟁])),
					result  => q(yuàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[酛鈨])),
					result  => q(yuan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[彟彠曰曱矱箹約约𠏃𡡕𢁞𢾔𦚢𧨄𩚈𩜌𪘳])),
					result  => q(yuē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𢯵])),
					result  => q(yuě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺝㜧㜰㬦㰛㹊䆕䆢䋐䋤䖃䟑䟠䠯䡇䢁䢲䤦䥃䶳刖妜嬳岄岳嶽恱悅悦戉抈捳月樾瀹爚玥礿禴篗籆籥籰粤粵蘥蚎蚏越跀跃躍軏鈅鉞钺閱閲阅鸑鸙黦龠𠔠𠨲𠩉𠪶𠯲𠾲𠿋𡆦𡆽𡛟𢦰𣌗𣎱𣐋𣤰𣦏𣨡𣻮𤑓𤓝𥆟𥩡𥸘𦋩𦣜𦤕𧀲𧅚𧇓𧕋𧤽𧹊𨁑𨈋𨊸𨒋𨙄𨳕𨷲𨸀𨸎𨿁𩁯𩎙𩓥𩱪𩱲𩿠𪁑𪒥𫐄])),
					result  => q(yuè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚃奫晕暈氲氳煴縕缊蒀蒕蝹贇赟頵馧𠚓𥠺𨍆𨷐𩁴])),
					result  => q(yūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛣㜏䉙䢵云勻匀囩妘愪昀榲橒沄涢溳澐熉畇眃秐筠筼篔紜縜纭耘耺芸蒷蕓郧鄖鋆雲饂𠣐𡖒𣖆𤈶𥐩𥬀𧥼𧬞𧶊𨛡])),
					result  => q(yún),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩈䆬䇖䞫䤞䨶䪳允喗夽抎殒殞狁磒荺褞賱鈗阭陨隕霣馻齳𠱳𧉃𧼐𩂿𪏔𪏚𪘩])),
					result  => q(yǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㚺㞌㟦䚋䩵䲰傊孕恽惲愠慍枟熅熨緷緼腪蕴薀藴蘊运運郓鄆酝醖醞韗韞韫韵韻餫𠈤𡅙𡢘𡲪𡽅𣂊𣍯𤶧𤸫𦅿𦈉𧡡𩏅𩏆𩴉𪉂𪍝])),
					result  => q(yùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[抣繧])),
					result  => q(yun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞉㦫匝咂帀拶沞紥紮臜臢迊鉔魳𠯗𠽷𣤷𣤺𦠛𦾬𧌃𨠿𩞶])),
					result  => q(zā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䕹䞙䨿䪞偺喒囋囐嶻杂砸磼襍雑雜雥韴𡁕𢶍𢹼𢽜𣴖𣸐𤄔𤠀𥷩𧬩𧾁𩇺𪚇])),
					result  => q(zá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[咋𠷿])),
					result  => q(zǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[哉栽渽災灾烖甾睵菑賳𡿧𢎋𢦏𢦒𣔮𦞁𦳦])),
					result  => q(zāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱰䏁䣬䮨宰崽𠎶𣅃𣪮𤌊𤝖])),
					result  => q(zǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䵧侢傤儎再在扗洅縡載载酨𡉄𤞳𧯥𨀬𨚵𩛥𩛳])),
					result  => q(zài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䍼䐶兂簪簮糌鐕鐟𡡖𥸢])),
					result  => q(zān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[咱])),
					result  => q(zán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㳫䭕儧儹噆寁揝撍攅攒攢昝桚沯礸趱趲𢄤𣸄𨖋𨘄])),
					result  => q(zǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔆㜺㟛㣅䬤暂暫濽灒瓉瓒瓚禶襸讃讚賛贊赞蹔鄼酇錾鏨饡𠼗𥎑𥜙𥳋𧄽𨙏𩛻𩯒𩯳])),
					result  => q(zàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㮜匨牂羘臧蔵賍賘贓贜赃髒𡁧𡅆𢈜𢍿𣻟𤃼𤛻𦟃𪓅])),
					result  => q(zāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[駔驵])),
					result  => q(zǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㘸塟奘弉脏臓臟葬銺𤞛𧕨𨌄])),
					result  => q(zàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡟㯾㷮䜊傮糟蹧遭醩𡐋𣍖𣩒𥀛𦵩𨠷𪙡])),
					result  => q(zāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䥣凿鑿])),
					result  => q(záo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䖣䗢䲃早枣棗澡璪繰薻藻蚤𠙬𢄀𢑖𤞋𤩨𧈹𧎮𨎮𨐉𨚰])),
					result  => q(zǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[唕唣喿噪慥梍灶燥皁皂竃竈簉艁譟趮躁造𠴵𡌣𡨗𢲵𢵥𣴢𤍜𤟀𥖨𦯑𨒽])),
					result  => q(zào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[栆])),
					result  => q(zao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖽㟙㣱㳻㺓䇥䕉䕪䯔䰹䶦则則唶啧嘖嫧帻幘択择擇樍沢泎泽溭澤皟瞔矠礋笮箦簀舴荝蠌襗諎謮責賾责赜迮鸅齚齰𠟻𡸦𣛸𣤈𣼦𣿐𤖓𤢟𤾀𥍱𥎍𥼃𦔈𦟜𧶷𨕠𨖊𩂖𩄾𩌪𩔳𪌟])),
					result  => q(zé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㳁仄夨崱庂捑昃昗汄𠨻𡵗𡸈𡹨𢧠𢮚𢯩𣆽𣬿𥟔𩾸])),
					result  => q(zè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[伬蔶])),
					result  => q(ze),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[戝蠈賊贼鯽鰂鱡鲗𢨗𦽒𧒿𨆎])),
					result  => q(zéi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㻸])),
					result  => q(zēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[怎])),
					result  => q(zěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[譖譛谮])),
					result  => q(zèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[囎])),
					result  => q(zen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䎖増增憎橧熷璔矰磳繒缯罾譄鄫𡡑𡾽𤎯𦀓𦼏𧢐𨲯])),
					result  => q(zēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㽪])),
					result  => q(zěng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䙢䰝甑贈赠鋥锃𪒟𪙭])),
					result  => q(zèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鱛])),
					result  => q(zeng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗬㦋㪥㾴䐒䵙䶥偧劄吒哳喳奓扎抯挓揸摣柤査楂樝渣皶皻觰譇齄齇𠭯𠯩𠽣𢄄𤹡𥡧𥹁𦟰𦳏𧩫𧬅𩮎𪗭𪗵])),
					result  => q(zhā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㱜㳐䥷䮜䮢札煠牐甴箚耫蚻譗鍘铡閘闸𠍹𠓣𠝚𠢙𠢡𠰏𡎫𡟢𢧖𢧻𣟦𣧖𣽛𤁳𤡨𤵦𧄠𧉫𧶇𧼰𧼶𧽅𩃡𩃹𩥠𩩥𩳶𩿤])),
					result  => q(zhá),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㴙㷢䋾䕢䛽䱹厏拃搩眨砟苲踷鮓鮺鲊鲝𤈩𥀈𥀉𦂉𦑯𧨿𨂵𨅓𩻢𩼫])),
					result  => q(zhǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡸䃎䄍䆛䖳乍咤宱搾柞栅榨溠灹炸痄蚱詐诈醡霅𡗸𢕮𣛽𤰦𧧻𧨊𧿌𨋘𨡗𩬟𩶱𩽽])),
					result  => q(zhà),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒀䔝捚摘斋斎榸齋𠞶𠵠𠷒𡅓𢋿𢴨𤞮𤻦𨅪𩝿𩱳𪗒𪗓𪘇𪘨𪚎])),
					result  => q(zhāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡯宅檡𦑱𩏪𩏽𪀥])),
					result  => q(zhái),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䍉窄鉙𠏰𤢒𥞅𧲻𧻍𩬫])),
					result  => q(zhǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩟䐱债債寨瘵砦𠑞𡍥𢯌𣩭𥍪𥰾𦤧𨝋𪑽])),
					result  => q(zhài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[夈粂])),
					result  => q(zhai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣶㮵䦓䩇䱳䶨噡嶦惉旃旜栴毡氈氊沾瞻粘薝蛅詀詹譫谵趈邅閚霑飦饘驙魙鱣鳣鸇鹯𠌲𠟧𡅹𡕁𡭞𢧗𣢤𣮿𤘇𥙡𥶕𦧚𦪣𧋱𧒝𧮪𧽆𧾍𨊈𩉗𩔣𩼼𪃋𪉜𪏉𪡏𫗴])),
					result  => q(zhān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[讝])),
					result  => q(zhán),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔊㜊㞡㠭䁪䁴䆄䎒䟋䡀䩅䩆䱼嫸展崭嶃嶄搌斩斬椫榐橏琖盏盞輾醆颭飐黵𠟉𡽻𢅺𣀁𣛷𥇢𥴐𥿜𦈻𦗢𧎰𧔡𧖉𧬆𧲮𨣁𨣚𨫀𨭖𨺿𩕊])),
					result  => q(zhǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㟞㺘㻵䋎䗃䘺䪌䱠佔偡占嶘战戦戰栈桟棧湛站綻绽菚蘸虥虦覱譧輚轏驏𡁳𡓦𢈽𢤚𣳤𤖆𤜇𧀡𧂁𧙭𧝑𧮺𧸪𨇩𨼈𨼮𩆯𩥇𩨍𩰃𪗦𪘪])),
					result  => q(zhàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䛫傽墇嫜张張彰慞暲樟漳獐璋章粻蔁蟑遧鄣餦騿鱆麞𡈠𢕎𢕔𢷢𣌞𤍤𧐊𧽣𨄰𩌬𪅂𫗠])),
					result  => q(zhāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⻓仉掌涨漲礃長长𠫝𡑄𢩰𣾦𤓯𤕄𥳶𦺡𩭫])),
					result  => q(zhǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙣㽴丈仗嶂帐帳幛扙杖涱痮瘬瘴瞕胀脹賬账障𠅹𡚹𢪾])),
					result  => q(zhàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[幥粀鏱鐣])),
					result  => q(zhang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䞴佋啁妱巶招昭皽盄窼釗鉊鍣钊駋𡖎𢗈𣋍𤍒𤿘𥏨𦗔𦺓𨱻])),
					result  => q(zhāo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕚䈃䝖找沼爪瑵𠕖𢁬𦬔𧳻])),
					result  => q(zhǎo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑿㡽㷖㷹䃍䈇䍜䍮䑲兆召垗旐曌枛棹櫂炤照燳狣瞾笊罩羄肁肇肈詔诏赵趙鮡𠕭𠟅𠠄𠻥𡱜𢡰𣠜𤙔𥵤𦹫𧳝𨹸𩘀𩙩])),
					result  => q(zhào),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[⺤⺥爫罀])),
					result  => q(zhao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸙嗻嫬蜇遮𠌮𡂭𨰵])),
					result  => q(zhē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞏㡇㢎㪿㭙㭯㯙㯰㸞䇽䊞䎲䐑䐲䓆䜆䝃䝕䮰厇哲啠喆嚞埑悊折摺晢晣歽矺砓磔籷粍虴蛰蟄袩詟謫謺讁讋谪輒輙轍辄辙銸馲鮿𠚱𠝝𠞃𠯓𠽻𠾀𡇠𡘭𡜯𡝊𢟯𢢍𢫰𢬴𣙵𣠞𣻩𤜤𤟍𤮱𥏯𥐽𥕣𥛧𥤋𥧮𦅄𦔮𦗑𦗗𦞥𦠣𦬃𧎴𧑧𧤠𧲢𨅊𨐃𨵊𩊵𩐶𩢐𩣩𪐏𪚥])),
					result  => q(zhé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[乽啫禇者褶襵赭锗𩤜])),
					result  => q(zhě),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䂞䏳䗪䠦䩾䵭柘樜浙淛潪蔗蟅这這鷓鹧𣇧𣶋𥑡𥭙𦠟𦠠𦯍])),
					result  => q(zhè),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[着著𡄡])),
					result  => q(zhe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㖘㘰㲀䂦䃌䈯侦偵嫃寊帪搸斟栕桢桭楨榛樼殝浈潧澵獉珍珎瑧甄眞真砧碪祯禎禛箴籈胗臻葴蒖蓁薽貞贞轃遉酙針鉁錱鍼针靕鱵𠛶𠸸𡇑𡇖𡈿𡻈𣓀𣿎𤚨𥪘𦳳𦸮𧮬𨱅𩇜𪇳𪉕])),
					result  => q(zhēn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𠵧])),
					result  => q(zhén),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㐱㪛㱽䂧䑐䠴䪴䪾䫬屒弫抮昣枕畛疹眕稹紾絼縥缜聄袗裖診诊軫轸駗鬒黰𠘱𠠹𠬓𢏈𣬻𣱽𤷌𥅘𥌃𥖘𧠝𧤛𨏤𩒀𩒈𩬖𪑳])),
					result  => q(zhěn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㓄㣀㮳㯢㴨㼉䀕䊶䏖䝩䟴䨯䲴䳲侲圳塦挋振揕敶朕栚瑱甽眹紖纼誫賑赈酖鎭鎮镇阵陣震鴆鸩𣃵𣏖𣒅𥤤𨌑𨳌𨸬𩄛𩊡𩊨𩑘𩒪𩾺𪁧𪐲])),
					result  => q(zhèn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[萙鋴])),
					result  => q(zhen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㬹䆸䇰䋊䋫䍵䱢争佂埩姃媜峥崝崢征徰徴徵怔挣掙揁炡烝爭狰猙癥眐睁睜筝箏篜聇蒸诤踭鉦錚钲铮鬇鯖𠑅𠲜𡪺𢁿𢓞𢮐𢾧𤪡𦓺𦙫𦚦𦜎𦡅𦱊𧗆𧗲𧘿𧪣𧯫𨌢𨛰𨜓𨟃𨢹𨺟𩗲𩘼𩘽𩚫𩺄])),
					result  => q(zhēng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䡕愸抍拯掟撜整晸氶糽𠏫𤸲𤿆𨀧𨋬𩗵])),
					result  => q(zhěng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡠㡧㱏㽀䂻䈣䥌䥭䦛䦶塣帧幀政正症証諍證证郑鄭鴊𠔻𢌦𢏰𢹑𥊼𥒛𧶄𨚣𨧭𩏠𪎻])),
					result  => q(zhèng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[凧])),
					result  => q(zheng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩼㯄㲍㴯㸟㽻䓋䓜䓡䝷䞠䟡䣽䧴䵹之倁卮吱坧巵戠搘支枝栀梔椥榰汁汥泜疷知祗祬禔秓秖秪稙綕織织肢胑胝脂臸芝蘵蜘衼隻馶鳷鴲鵄鼅𠦧𠰅𢎈𤵋𤽁𥃫𥇭𥘡𥝑𥝮𥻬𥾣𦏤𦝔𦭜𦯫𦴀𧌔𧐉𧱒𧹛𧽦𨌌𨕕𨜎𨟾𨢮𩍲𩍵𩙾𪂅𪉆𪒊𫛛])),
					result  => q(zhī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙷㜼㥀䐈䟈䵂侄値值儨嗭埴執墌妷姪嬂慹执摭植樴殖淔漐犆瓡直禃絷縶聀职職膱蟙褁貭跖踯蹠躑軄釞鉄馽𡁉𡂣𡈊𡌴𡏀𡖻𡰹𡸜𢃜𣖭𣖿𣳀𣽚𤃲𥏅𥮖𦳮𧀿𧃐𧏸𧓸𧾂𨂂𨤱𨼓𩯈𪗨𪙹])),
					result  => q(zhí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㕄㡳㡶㫑㮹㲛䅩䇛䛗䤠䳅劧只咫址坁夂帋怾恉扺抧指旨枳止汦沚洔淽疻砋祉紙纸芷藢衹襧訨趾軹轵酯阯黹𠮡𠼠𡙑𡱔𢇨𢛍𢰙𢷸𢽃𢽗𢾫𣔐𣖌𣚠𣲵𤶓𤸓𥒗𥔊𦐖𦰘𧊙𧛢𧜚𧝉𧠴𧸅𧸕𨎌𨬚𨰛𨵂𩬺𪑜])),
					result  => q(zhǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗌㗧㘉㛿㜱㝂㣥㨁㨖㴛㿃䄺䆈䇧䉅䉜䎺䏯䐭䑇䓌䕌䘭䚦䚳䝰䞃䡹䥍䦯䩢䬹䭁䱃䱥䲀乿偫傂制劕厔垁墆娡寘峙崻帙帜幟庢庤廌彘徏徝志忮憄懥懫扻挃挚掷搱摯擲擳旘晊智柣栉桎梽楖櫍櫛治洷滍滞滯潌瀄炙熫狾猘瓆畤疐痔痣礩祑秩秲秷稚稺穉窒筫紩緻置翐膣至致芖蛭螲袟袠製覟觗觯觶誌豑豒豸質贄质贽跱踬躓軽輊轾迣郅銍鋕鑕铚锧阤陟雉駤騭騺驇骘鯯鴙鷙鸷𠊤𠊷𠋤𠍜𠓶𠘖𠚅𡀹𡂒𡍶𡏚𡑘𡖧𡠗𡠹𡮞𡽆𢄢𢄱𢅁𢊁𢍧𢐂𢕞𢖇𢖿𢙺𢚨𢡒𢧤𢯶𢴠𢴧𢻙𣗻𣥰𣨋𤆒𤓕𤖞𤛱𤞂𤞌𤦄𤦮𤧜𤴛𤴟𤴢𤿙𥇕𥍭𥎹𥏄𥏊𥏰𥏷𥒓𥠈𥠽𥣮𥭡𥴒𥹩𥿮𦃘𦛧𦜋𦟔𦤻𦥎-𦥐𦭮𦯯𧙁𧠫𧣭𧣾𧤡𧨰𧫡𧸲𨁷𨃯𨆧𨎉𨑨𨒉𨖹𨟊𨡐𨧵𨫔𨻆𨿛𩊝𩊴𩋩𩧄𩷓𩹈𩻼𪁊𪁓𪁩𪏀𪗻])),
					result  => q(zhì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[俧凪徔謢])),
					result  => q(zhi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㹣䇗䈺䝦中伀刣妐幒彸忠柊汷泈炂盅籦終终舯蔠螤螽衳衷蹱鈡銿鍾鐘钟锺鼨𠛀𡖌𢁷𢃭𢨱𣷡𤝅𤯚𥗦𥷈𦉂𦬕𧆼𧑆𨳗𩅞𩅧])),
					result  => q(zhōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㣫冢喠塚塜尰歱煄瘇种種穜肿腫踵𠊥𡰒𡻑𣹞𤺄])),
					result  => q(zhǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㲴䱰仲众偅堹妕媑狆眾祌筗茽蚛衆衶諥重𠱧𡥿𢝆𣱧𤚏𥻝𦌋𦔉𧬤𧳮𨉢𩾋𩿀])),
					result  => q(zhòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[迚])),
					result  => q(zhong),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㨄䎇䑼䓟䧓侜周喌州徟掫洲淍烐珘盩矪粥舟謅譸诌诪賙赒輈輖辀週郮銂霌騆鵃鸼𠚴𠣘𠤍𠱙𡀑𢏝𢐫𢽧𥌆𥑸𥺝𥺞𥼫𥿦𦩈𦭴𧇟𧣷𧧔𧻖𨉜𨏺𨦞𩢸𩧳𩶣𪆀])),
					result  => q(zhōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㛩妯軸轴𡊡𥖠𥾓])),
					result  => q(zhóu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㫶䖞帚晭疛睭箒肘菷鯞𢫧𣥯𦈺𧳜𨥇])),
					result  => q(zhǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑇㑳㤘㥮㼙㾭䈙䋓䎻䛆䩜䶇伷僽冑呪咒咮噣宙昼晝甃皱皺籀籒籕粙紂縐纣绉胄荮葤詋詶酎駎驟骤𠊣𢃸𢓟𢷗𢼲𣆔𣻱𤏲𥀙𥣙𥲝𦁖𦂈𦅸𧛸𧭍𩊄𩋰𩍌𩍧𩗪𩧨𪇞])),
					result  => q(zhòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[炿駲])),
					result  => q(zhou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㦵㧣㶆䃴䇬䐗䡤䣷侏劯朱株槠橥櫧櫫洙潴瀦猪珠硃秼絑茱蛛蝫蠩袾誅諸诛诸豬跦邾銖铢駯鮢鯺鴸鼄𠧀𡴅𡻌𢔪𤝹𤥮𥛂𦧙𧑤𩊣𩋵𩴀𪋏𪋑𪏿])),
					result  => q(zhū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䌵䕽䘚䟉䠱䥮䮱孎曯欘泏灟炢烛燭爥瘃窋竹竺笁笜築舳茿蠋蠾躅逐鱁𠮌𠷅𡎺𡧨𢲿𣤁𣵸𣽆𥞏𥾅𦬸𧏿𨞕𨲈𩞈𩲠𩲬𩳥𩶄])),
					result  => q(zhú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔉㵭䘢䰞丶主劚嘱囑宔拄斸渚濐煑煮瞩矚罜詝陼麈𠰍𡺐𢁼𣔯𤆼𤲑𥋛𦅷𦉐𧉞𩒊𩨻𪋰])),
					result  => q(zhǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑏㝉㤖㫂㹥㺛㾻㿾䇠䇡䍆䎷䐢䘄䝒䝬䪒䬡䭖伫佇住助坾壴嵀杼柱樦殶注炷疰眝砫祝祩竚筑筯箸篫紵紸纻羜翥苎莇蛀註貯贮跓軴迬鉒鋳鑄铸霔馵駐驻麆𠩈𠴦𡤗𡱱𡸌𡻠𢚻𢥃𢩄𣥼𤋰𤎧𤕞𤳯𤾄𥩣𥯸𥵟𥹍𦙴𧈚𨆄𨈫𨙔𨭅𩶂𪊹𪚹])),
					result  => q(zhù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[墸])),
					result  => q(zhu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[抓檛簻膼髽𥬲𥮣])),
					result  => q(zhuā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𡎬𣑃])),
					result  => q(zhuǎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[拽])),
					result  => q(zhuāi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[跩])),
					result  => q(zhuǎi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𢶀])),
					result  => q(zhuài),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䏝专叀塼嫥専專瑼甎砖磗磚膞蟤諯鄟顓颛鱄𡭇𡰞𢂘𢞬𤮳𥫛])),
					result  => q(zhuān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䡱孨竱転轉转𡇰𡤛𣕏𦄯𦓝𦝏𨷱𩧜])),
					result  => q(zhuǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䉵䧘僎啭囀堟撰灷瑑篆篹籑腞蒃襈譔賺赚饌馔𠊩𠨎𡢀𢐎𣂵𣚢𤂤𤩄𤪪𥛥𦁆𦧸𧂍𧸖𩔊𩳏𩻝])),
					result  => q(zhuàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[妆妝娤庄桩梉樁湷粧糚荘莊装裝𣞝𣻛𦚏𩮱])),
					result  => q(zhuāng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𢙳])),
					result  => q(zhuǎng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[壮壯壵戇撞漴焋状狀𠌴𢤤𣴣𣶍𤘲𤶜𦀜𩅃𩯲𪁈𪉉])),
					result  => q(zhuàng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[庒])),
					result  => q(zhuang),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㗓㚝㮅䨨䶆追錐锥隹騅骓鵻𣨫𨾻𩪀𪋇])),
					result  => q(zhuī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[沝𩬳])),
					result  => q(zhuǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㩾㾽䄌坠墜娷惴桘甀畷硾礈笍綴縋缀缒膇諈譵贅赘轛醊錣鑆餟𡑻𢊅𣝸𣦬𤺅𥟒𦥻𧿲𨪗𨺵𩛵𩜀])),
					result  => q(zhuì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㡒宒窀肫衠諄谆迍𥇜])),
					result  => q(zhūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[准埻準綧])),
					result  => q(zhǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[稕訰𥚠])),
					result  => q(zhùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[凖])),
					result  => q(zhun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑁㓸䂐䦃䪼䫎䮓倬卓拙捉桌棁棳涿炪穛穱蠿𠭴𣄻𥞺𥼚𧱰])),
					result  => q(zhuō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㒂㣿㧻㭬㹿㺟䅵䆯䐁䕴䟾䮕䶂丵叕啄啅圴妰娺彴撯擆擢斀斫斱斲斵晫梲椓槕櫡汋浊浞濁濯灂灼烵犳琸硺禚窡篧籗籱罬茁蠗諁諑謶诼酌鋜鐯鐲镯鵫鷟𠡑𠿡𡷿𢁁𢢗𢧈𢳇𢺡𢽚𣃈𣃑𤃮𤉐𤏸𥇍𥋮𥐊𥗁𥢔𥮥𥯩𥷘𥷮𦜰𦰹𦳡𧂒𧃔𧘑𧞐𧢼𧨳𨑽𨖮𨡸𨢬𨧧𨮿𨺝𩆸𩋁𩑂𩩔𩲃𩷹])),
					result  => q(zhuó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧳劅𤓦])),
					result  => q(zhuò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[窧])),
					result  => q(zhuo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㠿㰣㽧㿳䅔䆅䎩䖪䣎䰵乲兹咨嗞姕姿孜孳孶嵫栥椔淄湽滋澬玆璾禌秶稵粢紎緇缁茊茲葘觜訾諮谘貲資赀资趑趦輜輺辎鄑鈭錙鍿鎡锱镃頾頿髭鯔鰦鲻鶅鼒齍龇𠀢𡗈𡙛𡸟𢱆𣚀𣚁𣣊𣥨𣯃𣳩𥀖𥕁𥚉𥻍𥼩𥼻𦖺𦺱𧀗𧕓𧛏𧣤𧥕𧹌𧿞𨀥𨍢𨚖𨝳𨩲𩄚𩜊𪅵𪑿𪕊𪗉𪗋𪗐])),
					result  => q(zī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[蓻])),
					result  => q(zí),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㜽㞨㧗㺭㾅䔂䘣䦻仔吇呰啙姉姊杍梓榟滓矷秄秭笫籽紫耔胏虸訿釨𠂔𠡸𡉗𡪒𣖨𣸆𥞎𥫞𥬳𥲕𧆰𨹀𩐍])),
					result  => q(zǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㧘㰷㱴䅆䐉倳剚字恣渍漬牸眥眦胔胾自芓茡𡸪𢼱𣄮𣓊𣣌𥿩𦍺𦎸𦣹𧂐𧧕𧨴𨧫])),
					result  => q(zì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[子崰橴])),
					result  => q(zi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㙡㚇㣭㨑㯶䁓䈦䑸䗥倧堫宗嵏嵕嵸惾朡棕椶熧猣磫稯綜緃緵综翪腙葼蝬豵踨踪蹤鍐鑁騌騣骔鬃鬉鬷鯮鯼𠕌𠵻𡕰𡞧𣯨𥍺𥓻𥚾𦡙𧺣𨌰𨺡𩦲𩮀𩰽𪖁])),
					result  => q(zōng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㢔㷓㹅䙕䰌偬傯总惣愡捴揔搃摠総縂總蓗鏓𥠡𨍈𨎢𩭤])),
					result  => q(zǒng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䍟䝋倊昮猔疭瘲碂粽糉糭縦縱纵錝𠏭𠡻𣀒𤡆𦖸𩋯𩤗])),
					result  => q(zòng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[潈])),
					result  => q(zong),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㻓棷棸箃緅菆諏诹邹郰鄒鄹陬騶驺鯫鲰黀齱齺𠂑𣙻𣠏𥋜𥶈𨃘𨜗𨽁])),
					result  => q(zōu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[走赱𧌗𨑿])),
					result  => q(zǒu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㔌㔿㵵䠫奏揍楱𨂡𩼦𪃆])),
					result  => q(zòu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鯐])),
					result  => q(zou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[租葅蒩𪙳])),
					result  => q(zū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㞺㰵㵀䚝䯿䱣傶卆卒哫崒崪族箤足踤踿鏃镞𠻏𡻬𢅪𢫵𢳈𣢰𣤶𣨛𤬧𤽱𥞯𥣆𥼀𦑋𧎲𧐈𧑙𧗎𧞰𧺒𨃭𨄕𨧰𨨳𨩰𩐡𩥿𩩠𩺯𪋍𪘧])),
					result  => q(zú),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䔃䖕俎爼珇祖組组詛诅阻靻𢉺𣇙𤓵𤱌𥛜𥼪𨂀])),
					result  => q(zǔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[𦵬𧇈𧇿𩲲])),
					result  => q(zù),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鎺])),
					result  => q(zu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䡽躜鑽钻𡉺𣀶𣪁𨉖𩎑])),
					result  => q(zuān),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸇䂎䌣䰖籫繤纂纉纘缵𦆈𦙉𨰭])),
					result  => q(zuǎn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䤸攥鑚])),
					result  => q(zuàn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㭰䘒䮔厜嗺朘樶纗蟕𡙭𢈡𣖱𥍋𦸺𧻝𩣷])),
					result  => q(zuī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[嘴噿嶊嶵璻𠲋𠾋𠿘𡽛𢊛𦈬𦏳𨿇𩲨𪋌])),
					result  => q(zuǐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝡㠑㰎䘹晬最栬槜檇檌祽稡絊罪蕞辠酔酻醉鋷錊𡡔𡽁𣩑𥳣𥳵𦙈𧎹𨢅𩚻𪓌])),
					result  => q(zuì),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[枠穝])),
					result  => q(zui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[墫壿尊嶟樽繜罇遵鐏鱒鳟鷷𤮐𦨆𨱔])),
					result  => q(zūn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[䔿僔噂撙譐𠟃𦢐])),
					result  => q(zǔn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[捘銌𠱜𥊭𥞘𥢎𦪚𩯄])),
					result  => q(zùn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[鶎])),
					result  => q(zun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㵶𠹠𩛠])),
					result  => q(zuō),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㸲䋏䎰䝫䞢䞰捽昨椊琢秨稓筰莋鈼𡪳𢂃𣠹𣹧𤿀𦁎𦦹𧮙𨞒𪎇])),
					result  => q(zuó),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㝾佐唨左繓𠂇𥙀𦈛𧲭𨀨])),
					result  => q(zuǒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[㑅㘀㘴㤰㭮䔘䟶作侳做唑坐岝岞座怍祚糳胙葃葄袏阼飵𠱯𡯨𡹥𥅁𥥏𥽿𦥬𧃘𨐳𨝨𪎲])),
					result  => q(zuò),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:[咗蓙])),
					result  => q(zuo),
					revisit => 0,
				},
			]
		},
	] },
);

no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
