package Locale::CLDR::Bs::Cyrl v0.25.1;
# This file auto generated from Data\common\main\bs_Cyrl.xml
#	on Sat 10 May 10:21:26 pm GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use v5.10;
use mro 'c3';
use utf8;

use Moose;

extends('Locale::CLDR::Bs');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'афарски',
 				'ab' => 'абказијски',
 				'ace' => 'ачинески',
 				'ach' => 'аколи',
 				'ada' => 'адангмејски',
 				'ady' => 'адигејски',
 				'ae' => 'авестански',
 				'af' => 'африканерски',
 				'afh' => 'африхили',
 				'ain' => 'аину',
 				'ak' => 'акан',
 				'akk' => 'акадијски',
 				'ale' => 'аљут',
 				'alt' => 'јужни алтаи',
 				'am' => 'амхарски',
 				'an' => 'арагонежански',
 				'ang' => 'староенглески',
 				'anp' => 'ангика',
 				'ar' => 'арапски',
 				'arc' => 'армајски',
 				'arn' => 'ароканијски',
 				'arp' => 'арапахо',
 				'arw' => 'аравак',
 				'as' => 'асемијски',
 				'ast' => 'астуријски',
 				'av' => 'аварски',
 				'awa' => 'авадхи',
 				'ay' => 'ајмара',
 				'az' => 'азербејџански',
 				'az@alt=short' => 'азерски',
 				'ba' => 'башкир',
 				'bal' => 'балучи',
 				'ban' => 'балинезијски',
 				'bas' => 'баса',
 				'be' => 'белоруски',
 				'bej' => 'беја',
 				'bem' => 'бемба',
 				'bg' => 'бугарски',
 				'bho' => 'бојпури',
 				'bi' => 'бислама',
 				'bik' => 'бикол',
 				'bin' => 'бини',
 				'bla' => 'сисика',
 				'bm' => 'бамбара',
 				'bn' => 'бенгласки',
 				'bo' => 'тибетански',
 				'br' => 'бретонски',
 				'bra' => 'брај',
 				'bs' => 'босански',
 				'bua' => 'буриат',
 				'bug' => 'бугинежански',
 				'byn' => 'блин',
 				'ca' => 'каталонски',
 				'cad' => 'кадо',
 				'car' => 'карипски',
 				'cch' => 'атсамски',
 				'ce' => 'чеченски',
 				'ceb' => 'цебуано',
 				'ch' => 'чаморо',
 				'chb' => 'чибча',
 				'chg' => 'чагатаи',
 				'chk' => 'чукески',
 				'chm' => 'мари',
 				'chn' => 'чинукски',
 				'cho' => 'чоктавски',
 				'chp' => 'чипвијански',
 				'chr' => 'чероки',
 				'chy' => 'чејенски',
 				'co' => 'корзикански',
 				'cop' => 'коптски',
 				'cr' => 'кри',
 				'crh' => 'кримеански турски',
 				'cs' => 'чешки',
 				'csb' => 'кашубијански',
 				'cu' => 'старословенски',
 				'cv' => 'чувашки',
 				'cy' => 'велшки',
 				'da' => 'дански',
 				'dak' => 'дакота',
 				'dar' => 'даргва',
 				'de' => 'немачки',
 				'de_AT' => 'Аустријски немачки',
 				'de_CH' => 'Швајцарски високи немачки',
 				'del' => 'делавер',
 				'den' => 'славски',
 				'dgr' => 'догриб',
 				'din' => 'динка',
 				'doi' => 'догри',
 				'dsb' => 'ниски сорбијански',
 				'dua' => 'дуала',
 				'dum' => 'средњи холандски',
 				'dv' => 'дивехијски',
 				'dyu' => 'ђула',
 				'dz' => 'џонга',
 				'ee' => 'еве',
 				'efi' => 'ефикски',
 				'egy' => 'староегипатски',
 				'eka' => 'екајук',
 				'el' => 'грчки',
 				'elx' => 'еламитски',
 				'en' => 'енглески',
 				'en_AU' => 'Аустралијски енглески',
 				'en_CA' => 'Канадски енглески',
 				'en_GB' => 'Британски енглески',
 				'en_US' => 'САД енглески',
 				'enm' => 'средњи енглески',
 				'eo' => 'есперанто',
 				'es' => 'шпански',
 				'es_419' => 'Латино-амерички шпански',
 				'es_ES' => 'Иберијски шпански',
 				'et' => 'естонски',
 				'eu' => 'баскијски',
 				'ewo' => 'евондо',
 				'fa' => 'персијски',
 				'fan' => 'фанг',
 				'fat' => 'фанти',
 				'ff' => 'фулах',
 				'fi' => 'фински',
 				'fil' => 'тагалог',
 				'fj' => 'фиджијски',
 				'fo' => 'фарски',
 				'fon' => 'фон',
 				'fr' => 'француски',
 				'fr_CA' => 'Канадски француски',
 				'fr_CH' => 'Швајцарски француски',
 				'frm' => 'средњи француски',
 				'fro' => 'старофранцуски',
 				'frr' => 'северно-фризијски',
 				'frs' => 'источни фризијски',
 				'fur' => 'фриулијски',
 				'fy' => 'фризијски',
 				'ga' => 'ирски',
 				'gaa' => 'га',
 				'gay' => 'гајо',
 				'gba' => 'гбаја',
 				'gd' => 'шкотски галски',
 				'gez' => 'џиз',
 				'gil' => 'гилбертшки',
 				'gl' => 'галски',
 				'gmh' => 'средњи високи немачки',
 				'gn' => 'гварани',
 				'goh' => 'старонемачки',
 				'gon' => 'гонди',
 				'gor' => 'горонтало',
 				'got' => 'готски',
 				'grb' => 'гребо',
 				'grc' => 'старогрчки',
 				'gsw' => 'швајцарски немачки',
 				'gu' => 'гуџарати',
 				'gv' => 'манкс',
 				'gwi' => 'гвич\'ин',
 				'ha' => 'хауса',
 				'hai' => 'хаида',
 				'haw' => 'хавајски',
 				'he' => 'хебрејски',
 				'hi' => 'хинди',
 				'hil' => 'хилигајнон',
 				'hit' => 'хитите',
 				'hmn' => 'хмонг',
 				'ho' => 'хири моту',
 				'hr' => 'хрватски',
 				'hsb' => 'горњи сорбијски',
 				'ht' => 'хаитски',
 				'hu' => 'мађарски',
 				'hup' => 'хупа',
 				'hy' => 'јерменски',
 				'hz' => 'хереро',
 				'ia' => 'интерлингва',
 				'iba' => 'ибан',
 				'id' => 'индонежански',
 				'ie' => 'међујезички',
 				'ig' => 'игбо',
 				'ii' => 'сичуан ји',
 				'ik' => 'унупиак',
 				'ilo' => 'илоко',
 				'inh' => 'ингвишки',
 				'io' => 'идо',
 				'is' => 'исландски',
 				'it' => 'италијански',
 				'iu' => 'инуктитут',
 				'ja' => 'јапански',
 				'jbo' => 'лојбан',
 				'jpr' => 'јудео-персијски',
 				'jrb' => 'јудео-арапски',
 				'jv' => 'јавански',
 				'ka' => 'грузијски',
 				'kaa' => 'кара-калпашки',
 				'kab' => 'кабиле',
 				'kac' => 'качин',
 				'kaj' => 'ђу',
 				'kam' => 'камба',
 				'kaw' => 'кави',
 				'kbd' => 'кабардијски',
 				'kcg' => 'тјап',
 				'kfo' => 'коро',
 				'kg' => 'конго',
 				'kha' => 'каси',
 				'kho' => 'котанешки',
 				'ki' => 'кикују',
 				'kj' => 'куањама',
 				'kk' => 'козачки',
 				'kl' => 'калалисут',
 				'km' => 'кмерски',
 				'kmb' => 'кимбунду',
 				'kn' => 'канада',
 				'ko' => 'корејски',
 				'kok' => 'конкани',
 				'kos' => 'косреански',
 				'kpe' => 'кпеле',
 				'kr' => 'канури',
 				'krc' => 'карачај-балкар',
 				'krl' => 'карелијски',
 				'kru' => 'курукх',
 				'ks' => 'кашмирски',
 				'ku' => 'курдски',
 				'kum' => 'кумик',
 				'kut' => 'кутенаи',
 				'kv' => 'коми',
 				'kw' => 'корнишки',
 				'ky' => 'киргиски',
 				'la' => 'латински',
 				'lad' => 'ладино',
 				'lah' => 'ланда',
 				'lam' => 'ламба',
 				'lb' => 'луксембуршки',
 				'lez' => 'лезгиан',
 				'lg' => 'ганда',
 				'li' => 'лимбургиш',
 				'ln' => 'лингала',
 				'lo' => 'лаоски',
 				'lol' => 'монго',
 				'loz' => 'лози',
 				'lt' => 'литвански',
 				'lu' => 'луба-катанга',
 				'lua' => 'луба-лулуа',
 				'lui' => 'луисено',
 				'lun' => 'лунда',
 				'luo' => 'луо',
 				'lus' => 'лушаи',
 				'lv' => 'летонски',
 				'mad' => 'мадурешки',
 				'mag' => 'магахи',
 				'mai' => 'маитили',
 				'mak' => 'макасар',
 				'man' => 'мандинго',
 				'mas' => 'масаи',
 				'mdf' => 'мокша',
 				'mdr' => 'мандар',
 				'men' => 'менде',
 				'mg' => 'малагасијски',
 				'mga' => 'средњи ирски',
 				'mh' => 'маршалски',
 				'mi' => 'маорски',
 				'mic' => 'микмак',
 				'min' => 'минангкабау',
 				'mk' => 'македонски',
 				'ml' => 'малајалам',
 				'mn' => 'монголски',
 				'mnc' => 'манчу',
 				'mni' => 'манипури',
 				'moh' => 'махавски',
 				'mos' => 'моси',
 				'mr' => 'марати',
 				'ms' => 'малајски',
 				'mt' => 'мелтешки',
 				'mul' => 'више језика',
 				'mus' => 'кришки',
 				'mwl' => 'мирандешки',
 				'mwr' => 'марвари',
 				'my' => 'бурмански',
 				'myv' => 'ерзија',
 				'na' => 'науру',
 				'nap' => 'неаполитански',
 				'nb' => 'норвешки бокмал',
 				'nd' => 'северни ндебеле',
 				'nds' => 'ниски немачки',
 				'ne' => 'непалски',
 				'new' => 'невари',
 				'ng' => 'ндонга',
 				'nia' => 'ниас',
 				'niu' => 'ниуеан',
 				'nl' => 'холандски',
 				'nl_BE' => 'фламански',
 				'nn' => 'норвешки њорск',
 				'no' => 'норвешки',
 				'nog' => 'ногаи',
 				'non' => 'стари норски',
 				'nqo' => 'н’ко',
 				'nr' => 'јужни ндебеле',
 				'nso' => 'северни сото',
 				'nv' => 'навахо',
 				'nwc' => 'класични невари',
 				'ny' => 'њања',
 				'nym' => 'њамвези',
 				'nyn' => 'њанколе',
 				'nyo' => 'њоро',
 				'nzi' => 'нзима',
 				'oc' => 'провансалски',
 				'oj' => 'ојибва',
 				'om' => 'оромо',
 				'or' => 'оријски',
 				'os' => 'осетски',
 				'osa' => 'осаге',
 				'ota' => 'отомански турски',
 				'pa' => 'панџабски',
 				'pag' => 'пангасински',
 				'pal' => 'пахлави',
 				'pam' => 'пампанга',
 				'pap' => 'папиаменто',
 				'pau' => 'палауански',
 				'peo' => 'староперсијски',
 				'phn' => 'феничански',
 				'pi' => 'пали',
 				'pl' => 'пољски',
 				'pon' => 'понпејски',
 				'pro' => 'старопровансалски',
 				'ps' => 'паштунски',
 				'ps@alt=variant' => 'пашто',
 				'pt' => 'португалски',
 				'pt_BR' => 'Бразилски португалски',
 				'pt_PT' => 'Иберијски португалски',
 				'qu' => 'квенча',
 				'raj' => 'рађастани',
 				'rap' => 'рапануи',
 				'rar' => 'раротонган',
 				'rm' => 'рето-романски',
 				'rn' => 'рунди',
 				'ro' => 'румунски',
 				'ro_MD' => 'молдавски',
 				'rom' => 'романи',
 				'root' => 'рут',
 				'ru' => 'руски',
 				'rup' => 'ароманијски',
 				'rw' => 'кинјаруанда',
 				'sa' => 'санскрит',
 				'sad' => 'сандаве',
 				'sah' => 'јакут',
 				'sam' => 'самаритански арамејски',
 				'sas' => 'сасак',
 				'sat' => 'сантали',
 				'sc' => 'сардињаски',
 				'scn' => 'сицилијански',
 				'sco' => 'шкотски',
 				'sd' => 'синди',
 				'se' => 'северни сами',
 				'sel' => 'селкап',
 				'sg' => 'санго',
 				'sga' => 'староирски',
 				'sh' => 'српскохрватски',
 				'shn' => 'шан',
 				'si' => 'сингалески',
 				'sid' => 'сидамо',
 				'sk' => 'словачки',
 				'sl' => 'словеначки',
 				'sm' => 'самоански',
 				'sma' => 'јужни сами',
 				'smj' => 'луле сами',
 				'smn' => 'инари сами',
 				'sms' => 'сколтски језик',
 				'sn' => 'шона',
 				'snk' => 'сонинке',
 				'so' => 'сомалски',
 				'sog' => 'соџијенски',
 				'sq' => 'албански',
 				'sr' => 'српски',
 				'srn' => 'сранански тонго',
 				'srr' => 'серер',
 				'ss' => 'свати',
 				'st' => 'сесото',
 				'su' => 'судански',
 				'suk' => 'сукума',
 				'sus' => 'сусу',
 				'sux' => 'сумерски',
 				'sv' => 'шведски',
 				'sw' => 'свахили',
 				'swb' => 'коморски',
 				'syc' => 'класични сиријски',
 				'syr' => 'сиријски',
 				'ta' => 'тамилски',
 				'te' => 'телугу',
 				'tem' => 'тимне',
 				'ter' => 'терено',
 				'tet' => 'тетум',
 				'tg' => 'тађик',
 				'th' => 'тајландски',
 				'ti' => 'тигриња',
 				'tig' => 'тигре',
 				'tiv' => 'тив',
 				'tk' => 'туркменски',
 				'tkl' => 'токелау',
 				'tl' => 'тагалски',
 				'tlh' => 'клингонски',
 				'tli' => 'тлингит',
 				'tmh' => 'тамашек',
 				'tn' => 'тсвана',
 				'to' => 'тонга',
 				'tog' => 'њаса тонга',
 				'tpi' => 'ток писин',
 				'tr' => 'турски',
 				'ts' => 'тсонга',
 				'tsi' => 'тсимшиан',
 				'tt' => 'татарски',
 				'tum' => 'тумбука',
 				'tvl' => 'тувалу',
 				'tw' => 'тви',
 				'ty' => 'тахићански',
 				'tyv' => 'тувинијски',
 				'udm' => 'удмурт',
 				'ug' => 'ујгурски',
 				'uga' => 'угаритски',
 				'uk' => 'украјински',
 				'umb' => 'умбунду',
 				'und' => 'непознат или неважећи језик',
 				'ur' => 'урду',
 				'uz' => 'узбечки',
 				'vai' => 'ваи',
 				've' => 'венда',
 				'vi' => 'вијетнамски',
 				'vo' => 'волапук',
 				'vot' => 'вотски',
 				'wa' => 'валун',
 				'wal' => 'валамо',
 				'war' => 'варај',
 				'was' => 'вашо',
 				'wo' => 'волоф',
 				'xal' => 'калмик',
 				'xh' => 'ксхоса',
 				'yao' => 'јао',
 				'yap' => 'јапешки',
 				'yi' => 'јидиш',
 				'yo' => 'јоруба',
 				'yue' => 'кантонски',
 				'za' => 'жуанг',
 				'zap' => 'запотечки',
 				'zbl' => 'блисимболи',
 				'zen' => 'зенага',
 				'zh' => 'кинески',
 				'zh_Hans' => 'кинески (поједностављен)',
 				'zh_Hant' => 'кинески (традиционални)',
 				'zu' => 'зулу',
 				'zun' => 'зуни',
 				'zxx' => 'без лингвистичког садржаја',
 				'zza' => 'заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'арапско писмо',
 			'Arab@alt=variant' => 'персијско-арапско',
 			'Armi' => 'империјско арамејско писмо',
 			'Armn' => 'јерменско писмо',
 			'Avst' => 'авестанско писмо',
 			'Bali' => 'балијско писмо',
 			'Batk' => 'батак писмо',
 			'Beng' => 'бенгалско писмо',
 			'Blis' => 'блисимболично писмо',
 			'Bopo' => 'бопомофо писмо',
 			'Brah' => 'браманско писмо',
 			'Brai' => 'Брајево писмо',
 			'Bugi' => 'бугинско писмо',
 			'Buhd' => 'бухидско писмо',
 			'Cakm' => 'чакманско писмо',
 			'Cans' => 'уједињени канадски абориџински силабици',
 			'Cari' => 'каријско писмо',
 			'Cham' => 'чамско писмо',
 			'Cher' => 'Чероки',
 			'Cirt' => 'цирт писмо',
 			'Copt' => 'коптичко писмо',
 			'Cprt' => 'кипарско писмо',
 			'Cyrl' => 'Ћирилица',
 			'Cyrs' => 'Старословенска црквена ћирилица',
 			'Deva' => 'Деванагари',
 			'Dsrt' => 'Дезерет',
 			'Egyd' => 'египатско народно писмо',
 			'Egyh' => 'египатско хијератско писмо',
 			'Egyp' => 'египатски хијероглифи',
 			'Ethi' => 'етиопско писмо',
 			'Geok' => 'грузијско кхутсури писмо',
 			'Geor' => 'грузијско писмо',
 			'Glag' => 'глагољица',
 			'Goth' => 'Готика',
 			'Grek' => 'грчко писмо',
 			'Gujr' => 'гујарати писмо',
 			'Guru' => 'гурмуки писмо',
 			'Hang' => 'хангул',
 			'Hani' => 'хан',
 			'Hano' => 'хануно',
 			'Hans' => 'поједностављено кинеско писмо',
 			'Hans@alt=stand-alone' => 'поједностављени хан',
 			'Hant' => 'традиционално кинеско писмо',
 			'Hant@alt=stand-alone' => 'традиционални хан',
 			'Hebr' => 'хебрејско писмо',
 			'Hira' => 'Хирагана',
 			'Hmng' => 'пахав хмонг писмо',
 			'Hrkt' => 'Катакана или Хирагана',
 			'Hung' => 'старомађарско писмо',
 			'Inds' => 'индушко писмо',
 			'Ital' => 'стари италик',
 			'Java' => 'јаванско писмо',
 			'Jpan' => 'јапанско писмо',
 			'Kali' => 'кајах-ли писмо',
 			'Kana' => 'Катакана',
 			'Khar' => 'карошти писмо',
 			'Khmr' => 'кмерско писмо',
 			'Knda' => 'каннада писмо',
 			'Kore' => 'корејско писмо',
 			'Kthi' => 'каити',
 			'Lana' => 'ланна писмо',
 			'Laoo' => 'лаошко писмо',
 			'Latf' => 'латиница (фрактур варијанта)',
 			'Latg' => 'галска латиница',
 			'Latn' => 'Латиница',
 			'Lepc' => 'лепча писмо',
 			'Limb' => 'лимбу писмо',
 			'Lina' => 'линеарно А писмо',
 			'Linb' => 'линеарно Б писмо',
 			'Lyci' => 'лисијско писмо',
 			'Lydi' => 'лидијско писмо',
 			'Mand' => 'мандеанско писмо',
 			'Mani' => 'манихејско писмо',
 			'Maya' => 'мајански хијероглифи',
 			'Mero' => 'мероитик писмо',
 			'Mlym' => 'малајалам писмо',
 			'Mong' => 'монголско писмо',
 			'Moon' => 'месечево писмо',
 			'Mtei' => 'меитеи мајек писмо',
 			'Mymr' => 'мијанмарско писмо',
 			'Nkoo' => 'н’ко писмо',
 			'Ogam' => 'огамско писмо',
 			'Olck' => 'ол чики писмо',
 			'Orkh' => 'орконско писмо',
 			'Orya' => 'оријанско писмо',
 			'Osma' => 'осмањанско писмо',
 			'Perm' => 'старо пермикско писмо',
 			'Phag' => 'пагс-па писмо',
 			'Phli' => 'писани пахлави',
 			'Phlp' => 'псалтер пахлави',
 			'Phlv' => 'пахлави писмо',
 			'Phnx' => 'Феничанско писмо',
 			'Plrd' => 'поралд фонетско писмо',
 			'Prti' => 'писани партиан',
 			'Rjng' => 'рејанг писмо',
 			'Roro' => 'ронгоронго писмо',
 			'Runr' => 'рунско писмо',
 			'Samr' => 'самаританско писмо',
 			'Sara' => 'сарати писмо',
 			'Saur' => 'саураштра писмо',
 			'Sgnw' => 'знаковно писмо',
 			'Shaw' => 'шавијанско писмо',
 			'Sinh' => 'синхала писмо',
 			'Sund' => 'суданско писмо',
 			'Sylo' => 'силоти нагри писмо',
 			'Syrc' => 'сиријско писмо',
 			'Syre' => 'сиријско естрангело писмо',
 			'Syrj' => 'западносиријско писмо',
 			'Syrn' => 'писмо источне Сирије',
 			'Tagb' => 'тагбанва писмо',
 			'Tale' => 'таи ле писмо',
 			'Talu' => 'нови таи луе',
 			'Taml' => 'тамилско писмо',
 			'Tavt' => 'таи виет писмо',
 			'Telu' => 'телугу писмо',
 			'Teng' => 'тенгвар писмо',
 			'Tfng' => 'тифинаг писмо',
 			'Tglg' => 'Тагалог',
 			'Thaa' => 'тхана писмо',
 			'Thai' => 'тајландско писмо',
 			'Tibt' => 'тибетанско писмо',
 			'Ugar' => 'угаритско писмо',
 			'Vaii' => 'ваи писмо',
 			'Visp' => 'видљиви говор',
 			'Xpeo' => 'староперсијско писмо',
 			'Xsux' => 'сумерско-акадско кунеиформ писмо',
 			'Yiii' => 'ји писмо',
 			'Zinh' => 'наследно писмо',
 			'Zmth' => 'математичка нотација',
 			'Zsym' => 'симболи',
 			'Zxxx' => 'Неписани језик',
 			'Zyyy' => 'заједничко писмо',
 			'Zzzz' => 'Непознато или неважеће писмо',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Свет',
 			'002' => 'Африка',
 			'003' => 'Северноамерички континент',
 			'005' => 'Јужна Америка',
 			'009' => 'Океанија',
 			'011' => 'Западна Африка',
 			'013' => 'Централна Америка',
 			'014' => 'Источна Африка',
 			'015' => 'Северна Африка',
 			'017' => 'Централна Африка',
 			'018' => 'Јужна Африка',
 			'019' => 'Америке',
 			'021' => 'Северна Америка',
 			'029' => 'Кариби',
 			'030' => 'Источна Азија',
 			'034' => 'Јужна Азија',
 			'035' => 'Југоисточна Азија',
 			'039' => 'Јужна Европа',
 			'053' => 'Аустралија и Нови Зеланд',
 			'054' => 'Меланезија',
 			'057' => 'Микронезијски регион',
 			'061' => 'Полинезија',
 			'142' => 'Азија',
 			'143' => 'Централна Азија',
 			'145' => 'Западна Азија',
 			'150' => 'Европа',
 			'151' => 'Источна Европа',
 			'154' => 'Северна Европа',
 			'155' => 'Западна Европа',
 			'419' => 'Латинска Америка',
 			'AC' => 'Острво Асенсион',
 			'AD' => 'Андора',
 			'AE' => 'Уједињени Арапски Емирати',
 			'AF' => 'Авганистан',
 			'AG' => 'Антигве и Барбуда',
 			'AI' => 'Ангвила',
 			'AL' => 'Албанија',
 			'AM' => 'Арменија',
 			'AN' => 'Холандски Антили',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктик',
 			'AR' => 'Аргентина',
 			'AS' => 'Америчка Самоа',
 			'AT' => 'Аустрија',
 			'AU' => 'Аустралија',
 			'AW' => 'Аруба',
 			'AX' => 'Аландска острва',
 			'AZ' => 'Азербејџан',
 			'BA' => 'Босна и Херцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Белгија',
 			'BF' => 'Буркина Фасо',
 			'BG' => 'Бугарска',
 			'BH' => 'Бахреин',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Свети Бартоломеј',
 			'BM' => 'Бермуда',
 			'BN' => 'Брунеј',
 			'BO' => 'Боливија',
 			'BR' => 'Бразил',
 			'BS' => 'Бахами',
 			'BT' => 'Бутан',
 			'BV' => 'Буве Острва',
 			'BW' => 'Боцвана',
 			'BY' => 'Белорусија',
 			'BZ' => 'Белизе',
 			'CA' => 'Канада',
 			'CC' => 'Кокос (Келинг) Острва',
 			'CD' => 'Конго - Киншаса',
 			'CD@alt=variant' => 'Конго (ДРК)',
 			'CF' => 'Централно Афричка Република',
 			'CG' => 'Конго - Бразавил',
 			'CG@alt=variant' => 'Конго (Република)',
 			'CH' => 'Швајцарска',
 			'CI' => 'Обала Слоноваче',
 			'CK' => 'Кукова Острва',
 			'CL' => 'Чиле',
 			'CM' => 'Камерун',
 			'CN' => 'Кина',
 			'CO' => 'Колумбија',
 			'CP' => 'Острво Клипертон',
 			'CR' => 'Костарика',
 			'CU' => 'Куба',
 			'CV' => 'Капе Верде',
 			'CX' => 'Божићна острва',
 			'CY' => 'Кипар',
 			'CZ' => 'Чешка',
 			'DE' => 'Немачка',
 			'DG' => 'Дијего Гарсија',
 			'DJ' => 'Џибути',
 			'DK' => 'Данска',
 			'DM' => 'Доминика',
 			'DO' => 'Доминиканска Република',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута и Мелиља',
 			'EC' => 'Еквадор',
 			'EE' => 'Естонија',
 			'EG' => 'Египат',
 			'EH' => 'Западна Сахара',
 			'ER' => 'Еритреја',
 			'ES' => 'Шпанија',
 			'ET' => 'Етиопија',
 			'EU' => 'Европска Унија',
 			'FI' => 'Финска',
 			'FJ' => 'Фиџи',
 			'FK' => 'Фокландска острва',
 			'FK@alt=variant' => 'Фокландска (Малвинска) острва',
 			'FM' => 'Микронезија',
 			'FO' => 'Фарска Острва',
 			'FR' => 'Француска',
 			'GA' => 'Габон',
 			'GB' => 'Велика Британија',
 			'GD' => 'Гренада',
 			'GE' => 'Грузија',
 			'GF' => 'Француска Гвајана',
 			'GG' => 'Гурнси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланд',
 			'GM' => 'Гамбија',
 			'GN' => 'Гвинеја',
 			'GP' => 'Гваделупе',
 			'GQ' => 'Екваторијална Гвинеја',
 			'GR' => 'Грчка',
 			'GS' => 'Јужна Џорџија и Јужна Сендвич Острва',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинеја-Бисао',
 			'GY' => 'Гвајана',
 			'HK' => 'Хонг Конг С. А. Р. Кина',
 			'HK@alt=short' => 'Хонг Конг',
 			'HM' => 'Херд и Мекдоналд Острва',
 			'HN' => 'Хондурас',
 			'HR' => 'Хрватска',
 			'HT' => 'Хаити',
 			'HU' => 'Мађарска',
 			'IC' => 'Канарска острва',
 			'ID' => 'Индонезија',
 			'IE' => 'Ирска',
 			'IL' => 'Израел',
 			'IM' => 'Острво Ман',
 			'IN' => 'Индија',
 			'IO' => 'Британска територија у Индијском океану',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланд',
 			'IT' => 'Италија',
 			'JE' => 'Џерси',
 			'JM' => 'Јамајка',
 			'JO' => 'Јордан',
 			'JP' => 'Јапан',
 			'KE' => 'Кенија',
 			'KG' => 'Киргизстан',
 			'KH' => 'Камбоџа',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморска Острва',
 			'KN' => 'Сент Китс и Невис',
 			'KP' => 'Северна Кореја',
 			'KR' => 'Јужна Кореја',
 			'KW' => 'Кувајт',
 			'KY' => 'Кајманска Острва',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Либан',
 			'LC' => 'Сент Луција',
 			'LI' => 'Лихтенштајн',
 			'LK' => 'Шри Ланка',
 			'LR' => 'Либерија',
 			'LS' => 'Лесото',
 			'LT' => 'Литванија',
 			'LU' => 'Луксембург',
 			'LV' => 'Летонија',
 			'LY' => 'Либија',
 			'MA' => 'Мароко',
 			'MC' => 'Монако',
 			'MD' => 'Молдавија',
 			'ME' => 'Црна Гора',
 			'MF' => 'Сент Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалска Острва',
 			'MK' => 'Македонија',
 			'ML' => 'Мали',
 			'MM' => 'Мијанмар (Бурма)',
 			'MN' => 'Монголија',
 			'MO' => 'Макао С. А. Р. Кина',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Северна Маријанска Острва',
 			'MQ' => 'Мартиник',
 			'MR' => 'Мауританија',
 			'MS' => 'Монсерат',
 			'MT' => 'Малта',
 			'MU' => 'Маурицијус',
 			'MV' => 'Малдиви',
 			'MW' => 'Малави',
 			'MX' => 'Мексико',
 			'MY' => 'Малезија',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибија',
 			'NC' => 'Нова Каледонија',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк Острво',
 			'NG' => 'Нигерија',
 			'NI' => 'Никарагва',
 			'NL' => 'Холандија',
 			'NO' => 'Норвешка',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуе',
 			'NZ' => 'Нови Зеланд',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француска Полинезија',
 			'PG' => 'Папуа Нова Гвинеја',
 			'PH' => 'Филипини',
 			'PK' => 'Пакистан',
 			'PL' => 'Пољска',
 			'PM' => 'Сен Пјер и Микелон',
 			'PN' => 'Питкерн',
 			'PR' => 'Порто Рико',
 			'PS' => 'Палестинске територије',
 			'PT' => 'Португалија',
 			'PW' => 'Палау',
 			'PY' => 'Парагвај',
 			'QA' => 'Катар',
 			'QO' => 'Остала океанија',
 			'RE' => 'Реинион',
 			'RO' => 'Румунија',
 			'RS' => 'Србија',
 			'RU' => 'Русија',
 			'RW' => 'Руанда',
 			'SA' => 'Саудијска Арабија',
 			'SB' => 'Соломонска Острва',
 			'SC' => 'Сејшели',
 			'SD' => 'Судан',
 			'SE' => 'Шведска',
 			'SG' => 'Сингапур',
 			'SH' => 'Света Јелена',
 			'SI' => 'Словенија',
 			'SJ' => 'Свалбард и Јанмајен Острва',
 			'SK' => 'Словачка',
 			'SL' => 'Сијера Леоне',
 			'SM' => 'Сан Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалија',
 			'SR' => 'Суринам',
 			'SS' => 'Јужни Судан',
 			'ST' => 'Сао Томе и Принципе',
 			'SV' => 'Салвадор',
 			'SY' => 'Сирија',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан да Куња',
 			'TC' => 'Туркс и Кајкос Острва',
 			'TD' => 'Чад',
 			'TF' => 'Француске Јужне Територије',
 			'TG' => 'Того',
 			'TH' => 'Тајланд',
 			'TJ' => 'Таџикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Источни Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турска',
 			'TT' => 'Тринидад и Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тајван',
 			'TZ' => 'Танзанија',
 			'UA' => 'Украјина',
 			'UG' => 'Уганда',
 			'UM' => 'Мања удаљена острва САД',
 			'US' => 'Сједињене Америчке Државе',
 			'UY' => 'Уругвај',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент Винсент и Гренадини',
 			'VE' => 'Венецуела',
 			'VG' => 'Британска Девичанска Острва',
 			'VI' => 'С.А.Д. Девичанска Острва',
 			'VN' => 'Вијетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Валис и Футуна Острва',
 			'WS' => 'Самоа',
 			'YE' => 'Јемен',
 			'YT' => 'Мајоте',
 			'ZA' => 'Јужноафричка Република',
 			'ZM' => 'Замбија',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Непозната или неважећа област',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'Традиционална немачка ортографија',
 			'1994' => 'Стандарднизована ресијанска ортографија',
 			'1996' => 'Немачка ортографија из 1996',
 			'1606NICT' => 'Француски из касног средњег века до 1606.',
 			'1694ACAD' => 'Рани модерни француски',
 			'1959ACAD' => 'Академски',
 			'AREVELA' => 'Источни арменијски',
 			'AREVMDA' => 'Западно јерменска',
 			'BAKU1926' => 'Уједињен турски латинични алфабет',
 			'BISKE' => 'Сан Ђорђио/Била дијалект',
 			'BOONT' => 'Бунтлинг',
 			'FONIPA' => 'ИПА фонетика',
 			'FONUPA' => 'УПА фонетика',
 			'KKCOR' => 'Уобичајена ортографија',
 			'LIPAW' => 'Липовички дијалект ресијански',
 			'MONOTON' => 'Монотоник',
 			'NEDIS' => 'Натисоне дијалект',
 			'NJIVA' => 'Гњива/Њива дијалкект',
 			'OSOJS' => 'Осеако/Осојане дијалект',
 			'POLYTON' => 'Политоник',
 			'POSIX' => 'Компјутер',
 			'REVISED' => 'Ревидирана ортографија',
 			'ROZAJ' => 'Ресијан',
 			'SAAHO' => 'Сахо',
 			'SCOTLAND' => 'Шкотски стандардни Енглески',
 			'SCOUSE' => 'Скауз',
 			'SOLBA' => 'Столвица/Солбица дијалект',
 			'TARASK' => 'Тараскијевичка ортографија',
 			'UCCOR' => 'Уједињена ортографија',
 			'UCRCOR' => 'Уједињена ревидирана ортографија',
 			'VALENCIA' => 'Валенцијска',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'Календар',
 			'collation' => 'Сортирање',
 			'currency' => 'Валута',
 			'numbers' => 'Бројеви',
 			'x' => 'Приватна употреба',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{Будистички календар},
 				'chinese' => q{Кинески календар},
 				'coptic' => q{коптски календар},
 				'ethiopic' => q{етиопски календар},
 				'ethiopic-amete-alem' => q{етиопски амет алем календар},
 				'gregorian' => q{Грегоријански календар},
 				'hebrew' => q{Хебрејски календар},
 				'indian' => q{Индијски национални календар},
 				'islamic' => q{Исламски календар},
 				'islamic-civil' => q{Исламски цивилни календар},
 				'japanese' => q{Јапански календар},
 				'persian' => q{персијски календар},
 				'roc' => q{Календар Републике Кине},
 			},
 			'collation' => {
 				'big5han' => q{Традиционално кинеско сортирање},
 				'dictionary' => q{Редослед сортирања у речнику},
 				'ducet' => q{Подразумевани Unicode редослед сортирања},
 				'gb2312han' => q{Поједностављено кинеско сортирање},
 				'phonebook' => q{Сортирање као телефонски именик},
 				'pinyin' => q{Пињин сортирање},
 				'reformed' => q{Реформисани редослед сортирања},
 				'search' => q{Опште намењена претрага},
 				'stroke' => q{Сортирање по броју црта},
 				'traditional' => q{Традиционално сортирање},
 				'unihan' => q{Редослед сортирања радикалним цртицама},
 			},
 			'numbers' => {
 				'arab' => q{арапско-индијске цифре},
 				'arabext' => q{продужене арапско-индијске цифре},
 				'armn' => q{јерменски бројеви},
 				'armnlow' => q{мали јерменски бројеви},
 				'beng' => q{бенгалске цифре},
 				'deva' => q{девангари цифре},
 				'ethi' => q{етиопски бројеви},
 				'fullwide' => q{цифре пуне ширине},
 				'geor' => q{грузијски бројеви},
 				'grek' => q{грчки бројеви},
 				'greklow' => q{мали грчки бројеви},
 				'gujr' => q{гуџаратске цифре},
 				'guru' => q{гурмуки цифре},
 				'hanidec' => q{кинески децимални бројеви},
 				'hans' => q{поједностављени кинески бројеви},
 				'hansfin' => q{поједностављени кинески финансијски бројеви},
 				'hant' => q{традиционални кинески бројеви},
 				'hantfin' => q{традиционални кинески финансијски бројеви},
 				'hebr' => q{хебрејски бројеви},
 				'jpan' => q{јапански бројеви},
 				'jpanfin' => q{јапански финансијски бројеви},
 				'khmr' => q{кмерске цифре},
 				'knda' => q{канада цифре},
 				'laoo' => q{лаошке цифре},
 				'latn' => q{западне цифре},
 				'mlym' => q{малајалам цифре},
 				'mong' => q{монголске цифре},
 				'mymr' => q{мијанмарске цифре},
 				'orya' => q{орија цифре},
 				'roman' => q{римски бројеви},
 				'romanlow' => q{мали римски бројеви},
 				'taml' => q{тамилски бројеви},
 				'telu' => q{телугу цифре},
 				'thai' => q{тајске цифре},
 				'tibt' => q{тибетанске цифре},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Метрички},
 			'UK' => q{империјални},
 			'US' => q{САД},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'БГН (BGN)',
 			'numeric' => 'Нумеричка',
 			'tone' => 'Тон',
 			'ungegn' => 'УНГЕГН (BGN)',
 			'x-accents' => 'Акценти',
 			'x-fullwidth' => 'пуна ширина',
 			'x-halfwidth' => 'пола ширине',
 			'x-jamo' => 'Џамо',
 			'x-pinyin' => 'Пинјин',
 			'x-publishing' => 'Издавачки',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => '{0}',
 			'script' => '{0}',
 			'territory' => '{0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		no warnings 'experimental::regex_sets';
		return {
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Ђ', 'Е', 'Ж', 'З', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ћ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'],
			main => qr{(?^u:[а б в г д ђ е ж з и ј к л љ м н њ о п р с т ћ у ф х ц ч џ ш])},
		};
	},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
		};
	},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{„},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‚},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'day' => {
						'few' => q({0} дана),
						'many' => q({0} дана),
						'one' => q({0} дан),
						'other' => q({0} дан),
					},
					'hour' => {
						'few' => q({0} сата),
						'many' => q({0} сати),
						'one' => q({0} сат),
						'other' => q({0} сат),
					},
					'minute' => {
						'few' => q({0} минута),
						'many' => q({0} минута),
						'one' => q({0} минут),
						'other' => q({0} минут),
					},
					'month' => {
						'few' => q({0} месеца),
						'many' => q({0} месеци),
						'one' => q({0} месец),
						'other' => q({0} месец),
					},
					'second' => {
						'few' => q({0} секунде),
						'many' => q({0} секунди),
						'one' => q({0} секунда),
						'other' => q({0} секунда),
					},
					'week' => {
						'few' => q({0} недеље),
						'many' => q({0} недеља),
						'one' => q({0} недеља),
						'other' => q({0} недеља),
					},
					'year' => {
						'few' => q({0} године),
						'many' => q({0} година),
						'one' => q({0} година),
						'other' => q({0} година),
					},
				},
				'short' => {
					'day' => {
						'few' => q({0} дана),
						'many' => q({0} дана),
						'one' => q({0} дан),
						'other' => q({0} дан),
					},
					'hour' => {
						'few' => q({0} сата),
						'many' => q({0} сати),
						'one' => q({0} сат),
						'other' => q({0} сат),
					},
					'minute' => {
						'few' => q({0} мин),
						'many' => q({0} мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
					},
					'month' => {
						'few' => q({0} мес),
						'many' => q({0} мес),
						'one' => q({0} мес),
						'other' => q({0} мес),
					},
					'second' => {
						'few' => q({0} сек),
						'many' => q({0} сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'week' => {
						'few' => q({0} нед),
						'many' => q({0} нед),
						'one' => q({0} нед),
						'other' => q({0} нед),
					},
					'year' => {
						'few' => q({0} год),
						'many' => q({0} год),
						'one' => q({0} год),
						'other' => q({0} год),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:да|д|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:не|н|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				end => q({0} и {1}),
				2 => q({0} и {1}),
		} }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q(.),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'few' => '0',
					'many' => '0',
					'one' => '0',
					'other' => '0',
				},
				'10000' => {
					'few' => '00 хиљ',
					'many' => '00 хиљ',
					'one' => '00 хиљ',
					'other' => '00 хиљ',
				},
				'100000' => {
					'few' => '000 хиљ',
					'many' => '000 хиљ',
					'one' => '000 хиљ',
					'other' => '000 хиљ',
				},
				'1000000' => {
					'few' => '0 мил',
					'many' => '0 мил',
					'one' => '0 мил',
					'other' => '0 мил',
				},
				'10000000' => {
					'few' => '00 мил',
					'many' => '00 мил',
					'one' => '00 мил',
					'other' => '00 мил',
				},
				'100000000' => {
					'few' => '000 мил',
					'many' => '000 мил',
					'one' => '000 мил',
					'other' => '000 мил',
				},
				'1000000000' => {
					'few' => '0 млрд',
					'many' => '0 млрд',
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'few' => '00 млрд',
					'many' => '00 млрд',
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'few' => '000 млрд',
					'many' => '000 млрд',
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'few' => '0 бил',
					'many' => '0 бил',
					'one' => '0 бил',
					'other' => '0 бил',
				},
				'10000000000000' => {
					'few' => '00 бил',
					'many' => '00 бил',
					'one' => '00 бил',
					'other' => '00 бил',
				},
				'100000000000000' => {
					'few' => '000 бил',
					'many' => '000 бил',
					'one' => '000 бил',
					'other' => '000 бил',
				},
			},
			'long' => {
				'1000' => {
					'few' => '0',
					'many' => '0',
					'one' => '0',
					'other' => '0',
				},
				'10000' => {
					'few' => '00 хиљ',
					'many' => '00 хиљ',
					'one' => '00 хиљ',
					'other' => '00 хиљ',
				},
				'100000' => {
					'few' => '000 хиљ',
					'many' => '000 хиљ',
					'one' => '000 хиљ',
					'other' => '000 хиљ',
				},
				'1000000' => {
					'few' => '0 мил',
					'many' => '0 мил',
					'one' => '0 мил',
					'other' => '0 мил',
				},
				'10000000' => {
					'few' => '00 мил',
					'many' => '00 мил',
					'one' => '00 мил',
					'other' => '00 мил',
				},
				'100000000' => {
					'few' => '000 мил',
					'many' => '000 мил',
					'one' => '000 мил',
					'other' => '000 мил',
				},
				'1000000000' => {
					'few' => '0 млрд',
					'many' => '0 млрд',
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'few' => '00 млрд',
					'many' => '00 млрд',
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'few' => '000 млрд',
					'many' => '000 млрд',
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'few' => '0 бил',
					'many' => '0 бил',
					'one' => '0 бил',
					'other' => '0 бил',
				},
				'10000000000000' => {
					'few' => '00 бил',
					'many' => '00 бил',
					'one' => '00 бил',
					'other' => '00 бил',
				},
				'100000000000000' => {
					'few' => '000 бил',
					'many' => '000 бил',
					'one' => '000 бил',
					'other' => '000 бил',
				},
			},
			'short' => {
				'1000' => {
					'few' => '0',
					'many' => '0',
					'one' => '0',
					'other' => '0',
				},
				'10000' => {
					'few' => '00 хиљ',
					'many' => '00 хиљ',
					'one' => '00 хиљ',
					'other' => '00 хиљ',
				},
				'100000' => {
					'few' => '000 хиљ',
					'many' => '000 хиљ',
					'one' => '000 хиљ',
					'other' => '000 хиљ',
				},
				'1000000' => {
					'few' => '0 мил',
					'many' => '0 мил',
					'one' => '0 мил',
					'other' => '0 мил',
				},
				'10000000' => {
					'few' => '00 мил',
					'many' => '00 мил',
					'one' => '00 мил',
					'other' => '00 мил',
				},
				'100000000' => {
					'few' => '000 мил',
					'many' => '000 мил',
					'one' => '000 мил',
					'other' => '000 мил',
				},
				'1000000000' => {
					'few' => '0 млрд',
					'many' => '0 млрд',
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'few' => '00 млрд',
					'many' => '00 млрд',
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'few' => '000 млрд',
					'many' => '000 млрд',
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'few' => '0 бил',
					'many' => '0 бил',
					'one' => '0 бил',
					'other' => '0 бил',
				},
				'10000000000000' => {
					'few' => '00 бил',
					'many' => '00 бил',
					'one' => '00 бил',
					'other' => '00 бил',
				},
				'100000000000000' => {
					'few' => '000 бил',
					'many' => '000 бил',
					'one' => '000 бил',
					'other' => '000 бил',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'negative' => '#,##0.00 ¤',
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(Андорска пезета),
				'few' => q(андорске пезете),
				'many' => q(андорских пезета),
				'one' => q(андорска пезета),
				'other' => q(андорске пезете),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(Уједињени арапски емирати дирхам),
				'few' => q(УАЕ дирама),
				'many' => q(УАЕ дирама),
				'one' => q(УАЕ дирам),
				'other' => q(УАЕ дирама),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(Авганистански авган \(1927–2002\)),
				'few' => q(авганистанска авгана \(1927–2002\)),
				'many' => q(авганистанских авгана \(1927–2002\)),
				'one' => q(авганистански авган \(1927–2002\)),
				'other' => q(авганистанских авгана \(1927–2002\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(Авганистански авган),
				'few' => q(авганистанска авгана),
				'many' => q(авганистанских авгана),
				'one' => q(авганистански авган),
				'other' => q(авганистански авгани),
			},
		},
		'ALK' => {
			display_name => {
				'few' => q(стара албанска лека),
				'many' => q(старих албанских лека),
				'one' => q(стари албански лек),
				'other' => q(старих албанских лека),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(Албански лек),
				'few' => q(Албанске леке),
				'many' => q(Албанских лека),
				'one' => q(албански лек),
				'other' => q(албански лек),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(Јерменски драм),
				'few' => q(Јерменска драма),
				'many' => q(Јерменских драма),
				'one' => q(јерменски драм),
				'other' => q(арменијска драма),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(Холандски антили гилдер),
				'few' => q(холандска антила),
				'many' => q(холандско-антилских гилдера),
				'one' => q(холандско-антилски гилдер),
				'other' => q(холандско-антилских гилдера),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(анголска кванза),
				'few' => q(анголијске кванзе),
				'many' => q(анголијских кванзи),
				'one' => q(анголијска кванза),
				'other' => q(анголијских кванзи),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(анголијска кванза \(1977–1990\)),
				'few' => q(анголијске кванзе \(1977–1990\)),
				'many' => q(анголијских кванзи \(1977–1990\)),
				'one' => q(анголијска кванза \(1977–1990\)),
				'other' => q(анголијских кванзи \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(Анголијска нова кванза \(1990–2000\)),
				'few' => q(анголијске нове кванзе),
				'many' => q(анголијских нових кванзи),
				'one' => q(анголијска нова кванза),
				'other' => q(анголијских нових кванзи),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(Анголска кванза реађустадо \(1995–1999\)),
				'few' => q(анголијске кванзе реађустадо),
				'many' => q(анголијских кванзи реађустадо),
				'one' => q(анголијска кванза реађустадо),
				'other' => q(анголијских кванзи реађустадо),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(Аргентински аустрал),
				'few' => q(аргентинска аустрала),
				'many' => q(аргентинских аустрала),
				'one' => q(аргентински аустрал),
				'other' => q(аргентинских аустрала),
			},
		},
		'ARL' => {
			display_name => {
				'few' => q(аргентинска пезос леја),
				'many' => q(аргентинских пезос леја),
				'one' => q(аргентински пезос леј),
				'other' => q(аргентинских пезос леја),
			},
		},
		'ARM' => {
			display_name => {
				'few' => q(аргентинска пезос монеда национал),
				'many' => q(аргентинских пезос монеда национала),
				'one' => q(аргентински пезос монедо национал),
				'other' => q(аргентинских пезос монеда национала),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(аргентински пезо \(1983–1985\)),
				'few' => q(аргентинска пезоса \(1983–1985\)),
				'many' => q(аргентинских пезоса \(1983–1985\)),
				'one' => q(аргентински пезо \(1983–1985\)),
				'other' => q(аргентинских пезоса \(1983–1985\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(аргентински пезо),
				'few' => q(аргентинска пезоса),
				'many' => q(аргентинских пезоса),
				'one' => q(аргентински пезос),
				'other' => q(аргентинских пезоса),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(Аустријски шилинг),
				'few' => q(аустријска шилинга),
				'many' => q(аустријских шилинга),
				'one' => q(аустријски шилинг),
				'other' => q(аустријских шилинга),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(Аустралијски долар),
				'few' => q(Аустралијска долара),
				'many' => q(Аустралијских долара),
				'one' => q(аустралијски долар),
				'other' => q(аустралијских долара),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(Арубански флорин),
				'few' => q(арубанска флорина),
				'many' => q(арубанских флорина),
				'one' => q(арубански флорин),
				'other' => q(арубанских флорина),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(Азербејџански манат \(1993–2006\)),
				'few' => q(азербејџанска маната \(1993–2006\)),
				'many' => q(азербејџанских маната \(1993–2006\)),
				'one' => q(азербејџански манат \(1993–2006\)),
				'other' => q(азербејџанских маната \(1993–2006\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(Азербејџански манат),
				'few' => q(азербејџанска маната),
				'many' => q(азербејџанских маната),
				'one' => q(азербејџански манат),
				'other' => q(азербејџанских маната),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(Босанско-Херцеговачки динар),
				'few' => q(босанско-херцеговачка динара),
				'many' => q(босанско-херцеговачких динара),
				'one' => q(босанско-херцеговачки динар),
				'other' => q(босанско-херцеговачких динара),
			},
		},
		'BAM' => {
			symbol => 'КМ',
			display_name => {
				'currency' => q(Конвертибилна марка),
				'few' => q(босанско-херцеговачке конвертибилне марк),
				'many' => q(босанско-херцеговачких конвертабилних марака),
				'one' => q(босанско-херцеговачка конвертибилна марка),
				'other' => q(босанско-херцеговачких конвертибилних марака),
			},
		},
		'BAN' => {
			display_name => {
				'few' => q(босанско-херцеговачка нова динара),
				'many' => q(босанско-херцеговачких нових динара),
				'one' => q(босанско-херцеговачки нови динар),
				'other' => q(босанско-херцеговачких нових динара),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(Барбадошки долар),
				'few' => q(барбадошка долара),
				'many' => q(барбадошких долара),
				'one' => q(барбадошки долар),
				'other' => q(барбадошких долара),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(Бангладешка така),
				'few' => q(бангладешке таке),
				'many' => q(бангладешких така),
				'one' => q(бангладешка така),
				'other' => q(бангладешких така),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(Белгијски франак \(конвертибилни\)),
				'few' => q(белгијска франка \(конвертибилна\)),
				'many' => q(белгијских франака \(конвертибилних\)),
				'one' => q(белгијски франак \(конвертибилни\)),
				'other' => q(белгијских франака \(конвертибилних\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(Белгијски франак),
				'few' => q(белгијска франка),
				'many' => q(белгијских франака),
				'one' => q(белгијски франак),
				'other' => q(белгијских франака),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(Белгијски франак \(финансијски\)),
				'few' => q(белгијска франка \(финансијска\)),
				'many' => q(белгијских франака \(финансијских\)),
				'one' => q(белгијски франак \(финансијски\)),
				'other' => q(белгијских франака \(финансијских\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(Бугарски тврди лев),
				'few' => q(бугарска тврда лева),
				'many' => q(бугарских тврдих лева),
				'one' => q(бугарски тврди лев),
				'other' => q(бугарских тврдих лева),
			},
		},
		'BGM' => {
			display_name => {
				'few' => q(бугарска социјалистичка лева),
				'many' => q(бугарских социјалистичких лева),
				'one' => q(бугарски социјалистички лев),
				'other' => q(бугарских социјалистичких лева),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(Бугарски лев),
				'few' => q(бугарска лева),
				'many' => q(бугарских лева),
				'one' => q(бугарски лев),
				'other' => q(бугарских лева),
			},
		},
		'BGO' => {
			display_name => {
				'few' => q(стара бугарска лева),
				'many' => q(старих бугарских лева),
				'one' => q(стари бугарски лев),
				'other' => q(старих бугарских лева),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(Бахреински динар),
				'few' => q(бахреинских динара),
				'many' => q(бахреинских динара),
				'one' => q(бахреинских динара),
				'other' => q(бахреинских динара),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(Бурундски франак),
				'few' => q(бурундска франка),
				'many' => q(бурундских франака),
				'one' => q(бурундски франак),
				'other' => q(бурундски франци),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(Бермудски долар),
				'few' => q(бермудска долара),
				'many' => q(бермудских долара),
				'one' => q(бермудски долар),
				'other' => q(бермудских долара),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(Брунејски долар),
				'few' => q(брунејска долара),
				'many' => q(брунејских долара),
				'one' => q(брунејски долар),
				'other' => q(брунејских долара),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(Боливијски Боливиано),
				'few' => q(боливијска боливиана),
				'many' => q(боливијских боливиана),
				'one' => q(боливијски боливиано),
				'other' => q(боливијских боливиана),
			},
		},
		'BOL' => {
			display_name => {
				'few' => q(стара боливијска боливијана),
				'many' => q(старих боливијских боливијана),
				'one' => q(стари боливијски боливијано),
				'other' => q(старих боливијских боливијана),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(Боливијски пезо),
				'few' => q(боливијска пезоса),
				'many' => q(боливијских пезоса),
				'one' => q(боливијски пезо),
				'other' => q(боливијских пезоса),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(Боливијски мвдол),
				'few' => q(боливијска мвдола),
				'many' => q(боливијских мвдола),
				'one' => q(боливијски мвдол),
				'other' => q(боливијских мвдола),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(Бразилски нови крузеиро \(1967–1986\)),
				'few' => q(бразилска нова крузеира),
				'many' => q(бразилских нових крузеира),
				'one' => q(бразилски нови крузеиро),
				'other' => q(бразилских нових крузеира),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(Бразилијски крузадо),
				'few' => q(бразилска крузадоса),
				'many' => q(бразилских крузадоса),
				'one' => q(бразилски крузадос),
				'other' => q(бразилских крузадоса),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(Бразилски крузеиро \(1990–1993\)),
				'few' => q(бразилска крузеира \(1990–1993\)),
				'many' => q(бразилских крузеира \(1990–1993\)),
				'one' => q(бразилски крузеиро \(1990–1993\)),
				'other' => q(бразилских крузеира \(1990–1993\)),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(Бразилски Реал),
				'few' => q(бразилска реала),
				'many' => q(бразилских реала),
				'one' => q(бразилски реал),
				'other' => q(бразилских реала),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(Бразилијски нови крузадо),
				'few' => q(бразилска нова крузада),
				'many' => q(бразилских нових крузада),
				'one' => q(бразилски нови крузадо),
				'other' => q(бразилских нових крузада),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(Бразилски крузеиро),
				'few' => q(бразилска крузеира),
				'many' => q(бразилских крузеира),
				'one' => q(бразилски крузеиро),
				'other' => q(бразилских крузеира),
			},
		},
		'BRZ' => {
			display_name => {
				'few' => q(стара бразилска крузеира),
				'many' => q(старих бразилских крузеира),
				'one' => q(стари бразилски крузеиро),
				'other' => q(старих бразилских крузеира),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(Бахамски долар),
				'few' => q(бахамска долара),
				'many' => q(бахамских долара),
				'one' => q(бахамски долар),
				'other' => q(бахамских долара),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(Бутански нгултрум),
				'few' => q(бутанска нгултрума),
				'many' => q(бутанских нгултрума),
				'one' => q(бутански нгултрум),
				'other' => q(бутанских нгултра),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(Бурмански кјат),
				'few' => q(бурманска кјата),
				'many' => q(бурманских кјата),
				'one' => q(бурмански кјат),
				'other' => q(бурманских кјата),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(Боцванска пула),
				'few' => q(боцванске пуле),
				'many' => q(боцванских пула),
				'one' => q(боцванска пула),
				'other' => q(боцванских пула),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(Белоруска нова рубља \(1994–1999\)),
				'few' => q(белоруске нове рубља),
				'many' => q(белоруских нових рубљи),
				'one' => q(белоруска нова рубља),
				'other' => q(белоруских нових рубљи),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(Белоруска рубља),
				'few' => q(белоруске рубље),
				'many' => q(белоруских рубљи),
				'one' => q(белоруска рубља),
				'other' => q(белоруске рубље),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(Белизе долар),
				'few' => q(белизеанска долара),
				'many' => q(белизеанских долара),
				'one' => q(белизеански долар),
				'other' => q(белизеанских долара),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(Канадски долар),
				'few' => q(канадска долара),
				'many' => q(Канадских долара),
				'one' => q(канадски долар),
				'other' => q(канадских долара),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(Конголски франак),
				'few' => q(конголска франка),
				'many' => q(конголских франака),
				'one' => q(конголски франак),
				'other' => q(конголских франака),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(WIR евро),
				'few' => q(WIR евра),
				'many' => q(WIR евра),
				'one' => q(WIR евро),
				'other' => q(WIR евра),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(Швајцарски франак),
				'few' => q(швајцарска франка),
				'many' => q(швајцарских франака),
				'one' => q(швајцарски франак),
				'other' => q(швајцарских франака),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(WIR франак),
				'few' => q(WIR франка),
				'many' => q(WIR франака),
				'one' => q(WIR франак),
				'other' => q(WIR франака),
			},
		},
		'CLE' => {
			display_name => {
				'few' => q(чилеанска ескуда),
				'many' => q(чилеанских ескуда),
				'one' => q(чилеански ескудо),
				'other' => q(чилеанских ескуда),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(Чилеовски унидадес се фоменто),
				'few' => q(чилеанска унидадес де фомента),
				'many' => q(чилеанских унидадес де фомента),
				'one' => q(чилеански унидадес де фоменто),
				'other' => q(чилеански унидадеси де фоменто),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(Чилеански пезо),
				'few' => q(чилеанска пезоса),
				'many' => q(чилеанских пезоса),
				'one' => q(чилеански пезо),
				'other' => q(чилеански пезоси),
			},
		},
		'CNX' => {
			display_name => {
				'few' => q(долара кинеске народне банке),
				'many' => q(долара кинеске народне банке),
				'one' => q(долар кинеске народне банке),
				'other' => q(долара кинеске народне банке),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(Кинески јуан ренминби),
				'few' => q(кинеска јуан),
				'many' => q(кинеских јуана),
				'one' => q(кинески јуан),
				'other' => q(кинеских јуана),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(Колумбијски пезо),
				'few' => q(колумбијска пезоса),
				'many' => q(колумбијских пезоса),
				'one' => q(колумбијски пезо),
				'other' => q(колумбијских пезоса),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(Унидад де валоршки реал),
				'few' => q(нидад де валор реала),
				'many' => q(унидад де валоршких реала),
				'one' => q(унидад де валоршки реал),
				'other' => q(унидад де валоршких реала),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(Костарикански колон),
				'few' => q(костариканска колона),
				'many' => q(костариканских колона),
				'one' => q(костарикански колон),
				'other' => q(костарикански колони),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(Стари српски динар),
				'few' => q(стара српска динара),
				'many' => q(старих српских динара),
				'one' => q(стари српски динар),
				'other' => q(старих српских динара),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(Чехословачка тврда круна),
				'few' => q(чехословачке тврде круне),
				'many' => q(чехословачких тврдих круна),
				'one' => q(чехословачка тврда круна),
				'other' => q(чехословачких тврдих круна),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(кубански конвертибилни песо),
				'few' => q(кубански конвертибилни пезос),
				'many' => q(кубанских конвертибилних пезоса),
				'one' => q(кубански конвертибилни песо),
				'other' => q(кубански конвертибилни пезос),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(Кубански пезо),
				'few' => q(кубанска пезоса),
				'many' => q(кубанских пезоса),
				'one' => q(кубански пезос),
				'other' => q(кубанских пезоса),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(Зеленортски ескудо),
				'few' => q(зеленортска ескуда),
				'many' => q(зеленортских ескуда),
				'one' => q(зеленортски ескудо),
				'other' => q(зеленортских ескуда),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(Кипарска фунта),
				'few' => q(кипарске фунте),
				'many' => q(кипарских фунти),
				'one' => q(кипарска фунта),
				'other' => q(кипарских фунти),
			},
		},
		'CZK' => {
			symbol => 'Кч',
			display_name => {
				'currency' => q(Чешка круна),
				'few' => q(чешке круне),
				'many' => q(чешких круна),
				'one' => q(чешка круна),
				'other' => q(чешких круне),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(Источно-немачка марка),
				'few' => q(источно-немачке марке),
				'many' => q(источно-немачких марака),
				'one' => q(источно-немачка марка),
				'other' => q(источно-немачких марака),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Немачка марка),
				'few' => q(немачке марке),
				'many' => q(немачких марака),
				'one' => q(немачка марка),
				'other' => q(немачких марака),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(Џибутански франак),
				'few' => q(џибутска франка),
				'many' => q(џибутских франака),
				'one' => q(џибутски франак),
				'other' => q(џибутски франци),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(Данска круна),
				'few' => q(данске круне),
				'many' => q(данских круна),
				'one' => q(данска круна),
				'other' => q(данских круна),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(Доминикански пезо),
				'few' => q(доминиканска пезоса),
				'many' => q(доминиканских пезоса),
				'one' => q(доминикански пезо),
				'other' => q(доминиканских пезоса),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(Алжирски динар),
				'few' => q(алжирска динара),
				'many' => q(алжирских динара),
				'one' => q(алжирски динар),
				'other' => q(алжирских динара),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(Еквадорски сакр),
				'few' => q(еквадорска сакра),
				'many' => q(еквадорских сакра),
				'one' => q(еквадорски сакр),
				'other' => q(еквадорских сакра),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(Еквадорски унидад де валор константе),
				'few' => q(еквадорска унидад де валор константа),
				'many' => q(еквадорских унидад де валор константа),
				'one' => q(еквадорски унидад де валор константе),
				'other' => q(еквадорских унидад де валор константа),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(Естонска кроон),
				'few' => q(естонске круне),
				'many' => q(естонских круна),
				'one' => q(естонска круна),
				'other' => q(естонских круна),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(Египатска фунта),
				'few' => q(египатске фунте),
				'many' => q(египатских фунти),
				'one' => q(египатска фунта),
				'other' => q(египатских фунти),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(Еритреанска накфа),
				'few' => q(еритрејске накфе),
				'many' => q(еритрејских накфи),
				'one' => q(еритрејска накфа),
				'other' => q(еритреанских накфки),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(Шпанска пезета \(рачун\)),
				'few' => q(шпанске пезете \(А рачун\)),
				'many' => q(шпанских пезета \(А рачун\)),
				'one' => q(шпанска пезета \(А рачун\)),
				'other' => q(шпанских пезета \(А рачун\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(Шпанска пезета \(конвертибилнирачун\)),
				'few' => q(шпанске пезете \(конвертибилан рачун\)),
				'many' => q(шпанских пезета \(конвертибилан рачун\)),
				'one' => q(шпанска пезета \(конвертибилан рачун\)),
				'other' => q(шпанских пезета \(конвертибилан рачун\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(Шпанска пезета),
				'few' => q(шпанска пезета),
				'many' => q(шпанских пезета),
				'one' => q(шпанска пезета),
				'other' => q(шпанске пезете),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(етиопијски бир),
				'few' => q(етиопијска бира),
				'many' => q(етиопијских бира),
				'one' => q(етиопијски бир),
				'other' => q(етиопијских бира),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(Евро),
				'few' => q(евра),
				'many' => q(евра),
				'one' => q(евро),
				'other' => q(евра),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Финска марка),
				'few' => q(финске марке),
				'many' => q(финских марака),
				'one' => q(финска марка),
				'other' => q(финских марака),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(Фиџи долар),
				'few' => q(фиџи долара),
				'many' => q(фиџи долара),
				'one' => q(фиџи долар),
				'other' => q(фиџи долара),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(Фокландска острва фунта),
				'few' => q(фолкландске фунте),
				'many' => q(фолкландских фунти),
				'one' => q(фолкландска фунта),
				'other' => q(фолкландских фунти),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Француски франак),
				'few' => q(француска франка),
				'many' => q(француских франака),
				'one' => q(француски франак),
				'other' => q(француских франака),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(Британска фунта стерлинга),
				'few' => q(британске фунте стерлинга),
				'many' => q(британских фунти стерлинга),
				'one' => q(британска фунта стерлинга),
				'other' => q(британских фунти стерлинга),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(Грузијски купон ларит),
				'few' => q(грузијска купон ларита),
				'many' => q(грузијских купон ларита),
				'one' => q(грузијски купон ларит),
				'other' => q(грузијских купон ларита),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(Грузијски лари),
				'few' => q(грузијска лариса),
				'many' => q(грузијских лариса),
				'one' => q(грузијски ларис),
				'other' => q(грузијских лариса),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(Гански цеди \(1979–2007\)),
				'few' => q(ганска цеда \(1979–2007\)),
				'many' => q(ганских цеда \(1979–2007\)),
				'one' => q(гански цед \(1979–2007\)),
				'other' => q(ганских цеда \(1979–2007\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(Гански цеди),
				'few' => q(ганска цеда),
				'many' => q(ганских цеда),
				'one' => q(гански цед),
				'other' => q(ганских цеда),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(Гибралташка фунта),
				'few' => q(гибралтарске фунте),
				'many' => q(гибралтарских фунти),
				'one' => q(гибралтарска фунта),
				'other' => q(гибралтарских фунти),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(Гамбијски даласи),
				'few' => q(гамбијска даласа),
				'many' => q(гамбијских даласа),
				'one' => q(гамбијски далас),
				'other' => q(гамбијских даласа),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(Гвинејски франак),
				'few' => q(гвинејска франка),
				'many' => q(гвинејских франака),
				'one' => q(гвинејски франак),
				'other' => q(гвинејски франци),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(Гвинејски сили),
				'few' => q(гвинејска сила),
				'many' => q(гвинејских сила),
				'one' => q(гвинејски сили),
				'other' => q(гвинејских сила),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(Екваторијално-гвинејски еквеле),
				'few' => q(екваторијално-гвинејска еквела),
				'many' => q(екваторијално-гвинејских еквела),
				'one' => q(екваторијално-гвинејски еквеле),
				'other' => q(екваторијално-гвинејских еквела),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(Грчка драхма),
				'few' => q(грчке драхме),
				'many' => q(драхми),
				'one' => q(грчка драхма),
				'other' => q(грчких драхми),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(Гватемалски квецал),
				'few' => q(гватемалска квецала),
				'many' => q(гватемалских квецала),
				'one' => q(гватемалски квецал),
				'other' => q(гватемалских квецала),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(португалска гвинеја ескудо),
				'few' => q(португалско-гвинејска ескуда),
				'many' => q(португалских гвинеја ескудо),
				'one' => q(португалско-гвинејски ескудо),
				'other' => q(португалско-гвинејских ескуда),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(Гвинеја Бисао Пезо),
				'few' => q(гвинеја-бисаошка пезоса),
				'many' => q(гвинеја-бисаошких пезоса),
				'one' => q(гвинеја-бисаошки пезо),
				'other' => q(гвинеја-бисаошких пезоса),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(Гујански долар),
				'few' => q(гвајанска долара),
				'many' => q(гвајанских долара),
				'one' => q(гвајански долар),
				'other' => q(гвајанских долара),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(Хонгконшки долар),
				'few' => q(хонгконшка долара),
				'many' => q(хонгконшких долара),
				'one' => q(хонгконшки долар),
				'other' => q(хонгконшких долара),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(Хондурашка лемпира),
				'few' => q(хондурашка лемпира),
				'many' => q(хондурашких лемпира),
				'one' => q(хондурашки лемпир),
				'other' => q(хондурашких лемпира),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(Хрватски динар),
				'few' => q(хрватска динара),
				'many' => q(хрватских динара),
				'one' => q(хрватски динар),
				'other' => q(хрватских динара),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(Хрватска куна),
				'few' => q(хрватске куне),
				'many' => q(хрватских куна),
				'one' => q(хрватска куна),
				'other' => q(хрватских куна),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(Хаићански гурд),
				'few' => q(хаићанска гурда),
				'many' => q(хаићанских гурда),
				'one' => q(хаићански гурд),
				'other' => q(хаићанских гурда),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(Мађарска форинта),
				'few' => q(мађарске форинте),
				'many' => q(мађарских форинти),
				'one' => q(мађарска форинта),
				'other' => q(мађарске форинте),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(Индонезијска рупиа),
				'few' => q(индонежанске рупије),
				'many' => q(индонежанских рупија),
				'one' => q(индонежанска рупија),
				'other' => q(индонежанске рупије),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Ирска фунта),
				'few' => q(ирске фунте),
				'many' => q(ирских фунти),
				'one' => q(ирска фунта),
				'other' => q(ирских фунти),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(Израелска фунта),
				'few' => q(израелске фунте),
				'many' => q(израелских фунти),
				'one' => q(израелска фунта),
				'other' => q(израелских фунти),
			},
		},
		'ILR' => {
			display_name => {
				'currency' => q(стари израелски шекели),
				'few' => q(стари израелски шекели),
				'many' => q(стари израелски шекели),
				'one' => q(стари израелски шекели),
				'other' => q(стари израелски шекели),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(Израелски нови шекел),
				'few' => q(израелска нова шекела),
				'many' => q(израелских нових шекела),
				'one' => q(израелски нови шекел),
				'other' => q(израелских нових шекела),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(Индијски Рупи),
				'few' => q(индијске рупије),
				'many' => q(индијских рупија),
				'one' => q(индијска рупија),
				'other' => q(индијских рупија),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(Ирачки динар),
				'few' => q(ирачка динара),
				'many' => q(ирачких динара),
				'one' => q(ирачки динар),
				'other' => q(ирачки динари),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(Ирански риал),
				'few' => q(иранска ријала),
				'many' => q(иранских ријала),
				'one' => q(ирански ријал),
				'other' => q(иранијски ријали),
			},
		},
		'ISJ' => {
			display_name => {
				'currency' => q(стара исландска круна),
				'few' => q(стара исландска круна),
				'many' => q(стара исландска круна),
				'one' => q(стара исландска круна),
				'other' => q(стара исландска круна),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(Исландска круна),
				'few' => q(исландске круне),
				'many' => q(исландских круна),
				'one' => q(исландска круна),
				'other' => q(исландске круне),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(Италијанска лира),
				'few' => q(италијанске лире),
				'many' => q(италијанских лира),
				'one' => q(италијанска лира),
				'other' => q(италијанске лире),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(Јамајски долар),
				'few' => q(јамајска долара),
				'many' => q(јамајских долара),
				'one' => q(јамајски долар),
				'other' => q(јамајских долара),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(Јордански динар),
				'few' => q(јорданских динара),
				'many' => q(јорданских динара),
				'one' => q(јорданских динара),
				'other' => q(јорданских динара),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(Јапански јен),
				'few' => q(јапанска јена),
				'many' => q(јапанских јена),
				'one' => q(јапански јен),
				'other' => q(јапански јен),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(Кенијски шилинг),
				'few' => q(кенијска шилинга),
				'many' => q(кенијских шилинга),
				'one' => q(кенијски шилинг),
				'other' => q(кенијских шилинга),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(Киргистански сом),
				'few' => q(киргистанска сома),
				'many' => q(киргистанских сома),
				'one' => q(киргистански сом),
				'other' => q(киргистанских сома),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(Камбоџијски риел),
				'few' => q(камбоџанска ријела),
				'many' => q(камбоџанских ријела),
				'one' => q(камбоџански ријел),
				'other' => q(камбоџанских ријела),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(Коморски франак),
				'few' => q(коморанска франка),
				'many' => q(коморанских франака),
				'one' => q(коморански франак),
				'other' => q(коморански франци),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(Севернокорејски вон),
				'few' => q(севернокорејска вона),
				'many' => q(севернокорејских вона),
				'one' => q(севернокорејски вон),
				'other' => q(севернокорејски вон),
			},
		},
		'KRH' => {
			display_name => {
				'few' => q(јужнокорејска хвана),
				'many' => q(јужнокорејских хвана),
				'one' => q(јужнокорејски хван),
				'other' => q(јужнокорејских хвана),
			},
		},
		'KRO' => {
			display_name => {
				'few' => q(стара јужнокорејска вона),
				'many' => q(старих јужнокорејских вона),
				'one' => q(стари јужнокорејски вон),
				'other' => q(старих јужнокорејских вона),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(Јужнокорејски Вон),
				'few' => q(јужнокорејска вона),
				'many' => q(јужнокорејских вона),
				'one' => q(јужнокорејски вон),
				'other' => q(јужнокорејски вон),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(Кувајтски динар),
				'few' => q(кувајтских динара),
				'many' => q(кувајтских динара),
				'one' => q(кувајтских динара),
				'other' => q(кувајтских динара),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(Кајманска острва долар),
				'few' => q(кајманска долара),
				'many' => q(кајманских долара),
				'one' => q(кајмански долар),
				'other' => q(кајманских долара),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(Казахстански тенџ),
				'few' => q(казахстанске тенџе),
				'many' => q(казахстанских тенџи),
				'one' => q(казахстанска тенџа),
				'other' => q(казахстанских тенџи),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(Лаошки кип),
				'few' => q(лаошка кипа),
				'many' => q(лаошких кипа),
				'one' => q(лаошки кип),
				'other' => q(лаошки кипи),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(Лебанска фунта),
				'few' => q(лебанске фунте),
				'many' => q(лебанских фунти),
				'one' => q(лебанска фунта),
				'other' => q(лебанске фунте),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(Шриланкански рупи),
				'few' => q(шриланканска рупија),
				'many' => q(шриланканских рупија),
				'one' => q(шриланкански рупиј),
				'other' => q(шриланканских рупија),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(Либеријски долар),
				'few' => q(либеријска долара),
				'many' => q(либеријских долара),
				'one' => q(либеријски долар),
				'other' => q(либеријских долара),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Лесото лоти),
				'few' => q(лесотска лотиса),
				'many' => q(лесотских лотиса),
				'one' => q(лесотски лотис),
				'other' => q(лесотских лотиса),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(Литвански литас),
				'few' => q(литванска литаса),
				'many' => q(литванских литаса),
				'one' => q(литвански литас),
				'other' => q(литванских литаса),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(Литвански талонас),
				'few' => q(литванска талонаса),
				'many' => q(литванских талонаса),
				'one' => q(литвански талонас),
				'other' => q(литванских талонаса),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(Луксембуршки конвертибилни франак),
				'few' => q(луксембуршка конвертибилна франка),
				'many' => q(луксембуршких конвертибилних франака),
				'one' => q(луксембуршки конвертибилни франак),
				'other' => q(луксембуршких конвертибилних франака),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(Луксембуршки франак),
				'few' => q(луксембуршка франка),
				'many' => q(луксембуршких франака),
				'one' => q(луксембуршки франак),
				'other' => q(луксембуршки франци),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(Луксембуршки финансијски франак),
				'few' => q(луксембуршка финансијска франка),
				'many' => q(луксембуршких финансијских франака),
				'one' => q(луксембуршки финансијски франак),
				'other' => q(луксембуршких финансијских франака),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(Латвијски лати),
				'few' => q(латвијска лата),
				'many' => q(латвијских лата),
				'one' => q(латвијски лат),
				'other' => q(латвијских лата),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(атвијска рубља),
				'few' => q(латвијске рубље),
				'many' => q(латвијских рубљи),
				'one' => q(латвијска рубља),
				'other' => q(латвијских рубљи),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(Либијски динар),
				'few' => q(либијских динара),
				'many' => q(либијских динара),
				'one' => q(либијских динара),
				'other' => q(либијских динара),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(Марокански дирхам),
				'few' => q(мароканске дирхаме),
				'many' => q(мароканских дирхама),
				'one' => q(мароканска дирхама),
				'other' => q(мароканских дирхама),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(Марокански франак),
				'few' => q(мароканска франка),
				'many' => q(мароканских франака),
				'one' => q(марокански франак),
				'other' => q(мароканских франака),
			},
		},
		'MCF' => {
			display_name => {
				'few' => q(монегасканска франка),
				'many' => q(монегасканских франака),
				'one' => q(монегаскански франак),
				'other' => q(монегасканских франака),
			},
		},
		'MDC' => {
			display_name => {
				'few' => q(молдованска купона),
				'many' => q(молдованских купона),
				'one' => q(молдовански купон),
				'other' => q(молдованских купона),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(Молдовски љу),
				'few' => q(молдовска леија),
				'many' => q(молдовских леија),
				'one' => q(молдовски леи),
				'other' => q(молдовских леија),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(Малагасијски ариари),
				'few' => q(малагашајска ариарија),
				'many' => q(малагашајских ариарија),
				'one' => q(малагашајски ариариј),
				'other' => q(малагашајски ариарији),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(Малагасијски франак),
				'few' => q(малагашајска франка),
				'many' => q(малагашајских франака),
				'one' => q(малагашајски франак),
				'other' => q(малагашајски франци),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(Македонски денар),
				'few' => q(македонска денара),
				'many' => q(македонских денара),
				'one' => q(македонски денар),
				'other' => q(македонских динара),
			},
		},
		'MKN' => {
			display_name => {
				'few' => q(стара македонска денара),
				'many' => q(старих македонских денара),
				'one' => q(стари македонски денар),
				'other' => q(старих македонских денара),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(Малијански франак),
				'few' => q(малијска франка),
				'many' => q(малијских франака),
				'one' => q(малијски франак),
				'other' => q(малијских франака),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(Мјанмашки кјат),
				'few' => q(мијанмашка кјата),
				'many' => q(мијанмашких кјата),
				'one' => q(мијанмашки кјат),
				'other' => q(мијанмашки кјати),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(Монголски тугрик),
				'few' => q(монголијска тугрика),
				'many' => q(монголијских тугрика),
				'one' => q(монголијски тугрик),
				'other' => q(монголијски тугрици),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(Маканишка патака),
				'few' => q(маканешке патаке),
				'many' => q(маканешких патака),
				'one' => q(маканешка патака),
				'other' => q(маканешких патака),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(Мауританијска угвија),
				'few' => q(мауританијске угвиље),
				'many' => q(мауританијских угвиља),
				'one' => q(мауританијска угвиља),
				'other' => q(мауританијске угвиље),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(Малтешка лира),
				'few' => q(малтешке лире),
				'many' => q(малтешких лира),
				'one' => q(малтешка лира),
				'other' => q(малтешких лира),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(Малтешка фунта),
				'few' => q(малтешке фунте),
				'many' => q(малтешких фунти),
				'one' => q(малтешка фунта),
				'other' => q(малтешких фунти),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(Маурицијски рупи),
				'few' => q(мауританијске рупије),
				'many' => q(мауританијских рупија),
				'one' => q(мауританијска рупија),
				'other' => q(мауританијске рупије),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(Малдивијска руфија),
				'few' => q(малдивска руфијаса),
				'many' => q(малдивских руфијаса),
				'one' => q(малдивски руфијас),
				'other' => q(малдивских руфијаса),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(Малавијска квача),
				'few' => q(малавијске кваче),
				'many' => q(малавијских квача),
				'one' => q(малавијска квача),
				'other' => q(малавијских квача),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(Мексички пезо),
				'few' => q(мексичка пезоса),
				'many' => q(мексичких пезоса),
				'one' => q(мексички пезо),
				'other' => q(мексичких пезоса),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(Мексички сребрни пезо \(1861–1992\)),
				'few' => q(мексичка сребрна пезоса),
				'many' => q(мексичких сребрних пезоса),
				'one' => q(мексички сребрни пезо),
				'other' => q(мексичких сребрних пезоса),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(Мексички унидад де инверсион \(UDI\)),
				'few' => q(мексичка унидадс де инверзиона),
				'many' => q(мексичких унидадс де инверзиона),
				'one' => q(мексички унидадс де инверзион),
				'other' => q(мексичких унидадс де инверзиона),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(Малезијски ринггит),
				'few' => q(малезијска ринггита),
				'many' => q(малезијских ринггита),
				'one' => q(малезијски ринггит),
				'other' => q(малезијских ринггита),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(Мозамбијски ескудо),
				'few' => q(мозамбијска ескуда),
				'many' => q(мозамбијских ескуда),
				'one' => q(мозамбијски ескудо),
				'other' => q(мозамбијских ескуда),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(Стари мозамбијски метикал),
				'few' => q(стара мозамбијска метикала),
				'many' => q(старих мозамбијских метикала),
				'one' => q(стари мозамбијски метикал),
				'other' => q(старих мозамбијских метикала),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(Мозамбијски метикал),
				'few' => q(мозамбијска метикала),
				'many' => q(мозамбијских метикала),
				'one' => q(мозамбијски метикал),
				'other' => q(мозамбијских метикала),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(намбијски долар),
				'few' => q(намибијска долара),
				'many' => q(намибијских долара),
				'one' => q(намибијски долар),
				'other' => q(намибијских долара),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(Нигеријска наира),
				'few' => q(нигеријске наире),
				'many' => q(нигеријских наира),
				'one' => q(нигеријска наира),
				'other' => q(нигеријских наира),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(Никарагванска кордоба),
				'few' => q(никарагванске кордобе),
				'many' => q(никарагванских кордоба),
				'one' => q(никарагванска кордоба),
				'other' => q(никарагванских кордоба),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(Никарагванска златна кордоба),
				'few' => q(никарагванске златне кордобе),
				'many' => q(никарагванских златних кордоба),
				'one' => q(никарагванска златна кордоба),
				'other' => q(никарагванских златних кордоба),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(Холандски гулден),
				'few' => q(холандска гулдена),
				'many' => q(холандских гулдена),
				'one' => q(холандски гулден),
				'other' => q(холандских гулдена),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(Норвешка круна),
				'few' => q(норвешке круне),
				'many' => q(норвешких круна),
				'one' => q(норвешка круна),
				'other' => q(норвешких круна),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(Непалски рупи),
				'few' => q(непалске рупије),
				'many' => q(непалских рупија),
				'one' => q(непалска рупија),
				'other' => q(непалских рупија),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(Новозеландски долар),
				'few' => q(новозеландска долара),
				'many' => q(новозеландских долара),
				'one' => q(новозеландски долар),
				'other' => q(новозеландских долара),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(Омански ријал),
				'few' => q(оманских ријала),
				'many' => q(оманских ријала),
				'one' => q(оманских ријала),
				'other' => q(оманских ријала),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(Панамска балбоа),
				'few' => q(панамске балбое),
				'many' => q(панамских балбоа),
				'one' => q(панамска балбоа),
				'other' => q(панамских балбоа),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(Перуански инти),
				'few' => q(перувијска интија),
				'many' => q(перувијских интија),
				'one' => q(перувијски инти),
				'other' => q(перувијских интија),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(Перуански нуево сол),
				'few' => q(перуанска нуево сола),
				'many' => q(перуанских нуево сола),
				'one' => q(перуански нуево сол),
				'other' => q(перуанских нуево сола),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(Перуански сол),
				'few' => q(перуанска сола),
				'many' => q(перуанских сола),
				'one' => q(перуански сол),
				'other' => q(перуанских сола),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(Папуа ново-гвинејшка кина),
				'few' => q(папуа ново гвинејска долара),
				'many' => q(папуа ново гвинејских долара),
				'one' => q(папуа ново гвинејски долар),
				'other' => q(папуа ново гвинејских долара),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(Филипински пезо),
				'few' => q(филипинска пезоса),
				'many' => q(филипинских пезоса),
				'one' => q(филипински пезо),
				'other' => q(филипинских пезоса),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(Пакистански рупи),
				'few' => q(пакистанске рупије),
				'many' => q(пакистанских рупија),
				'one' => q(пакистанска рупија),
				'other' => q(пакистанске рупије),
			},
		},
		'PLN' => {
			symbol => 'зл',
			display_name => {
				'currency' => q(Пољски злот),
				'few' => q(пољска злота),
				'many' => q(пољских злота),
				'one' => q(пољски злот),
				'other' => q(пољских злота),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(Пољски злоти \(1950–1995\)),
				'few' => q(пољска злота \(1950–1995\)),
				'many' => q(пољских злота \(1950–1995\)),
				'one' => q(пољски злот \(1950–1995\)),
				'other' => q(пољских злота \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(Португалски ескудо),
				'few' => q(португалска ескуда),
				'many' => q(португалских ескуда),
				'one' => q(португалски ескудо),
				'other' => q(португалских ескуда),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(Парагвајски гуарни),
				'few' => q(парагвајска гваранија),
				'many' => q(парагвајских гваранија),
				'one' => q(парагвајски гвараниј),
				'other' => q(парагвајски гваранији),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(Катаршки ријал),
				'few' => q(катарска ријала),
				'many' => q(катарских ријала),
				'one' => q(катарски ријал),
				'other' => q(катарских ријала),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(Родејскидолар),
				'few' => q(родежанска долара),
				'many' => q(родежанских долара),
				'one' => q(родежански долар),
				'other' => q(родежанских долара),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(Стари румунски љу),
				'few' => q(стара румунска леија),
				'many' => q(старих румунских леија),
				'one' => q(стари румунски леиј),
				'other' => q(старих румунских леија),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(Румунски леу),
				'few' => q(румунска леија),
				'many' => q(румунских леија),
				'one' => q(румунски леи),
				'other' => q(румунских леија),
			},
		},
		'RSD' => {
			symbol => 'дин.',
			display_name => {
				'currency' => q(Српски динар),
				'few' => q(српска динара),
				'many' => q(српских динара),
				'one' => q(српски динар),
				'other' => q(српски динари),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(Руска рубља),
				'few' => q(руске рубље),
				'many' => q(руских рубљи),
				'one' => q(руска рубља),
				'other' => q(руских рубљи),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(Руска рубља \(1991–1998\)),
				'few' => q(руске рубље \(1991–1998\)),
				'many' => q(руских рубљи \(1991–1998\)),
				'one' => q(руска рубља \(1991–1998\)),
				'other' => q(руских рубљи \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(Руандански франак),
				'few' => q(руанданска франка),
				'many' => q(руанданских франака),
				'one' => q(руандански франак),
				'other' => q(руандански франци),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(Саудијски ријал),
				'few' => q(саудијска ријала),
				'many' => q(саудијских ријала),
				'one' => q(саудијски ријал),
				'other' => q(саудијских ријала),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(Соломонско-острвски долар),
				'few' => q(соломонско-острвска долара),
				'many' => q(соломонско-острвских долара),
				'one' => q(соломонско-острвски долар),
				'other' => q(соломонско-острвских долара),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(Сејшелска рупија),
				'few' => q(сејшелске рупије),
				'many' => q(сејшелских рупија),
				'one' => q(сејшелска рупија),
				'other' => q(сејшелских рупија),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(Стари судански динар),
				'few' => q(стара суданска динара),
				'many' => q(старих суданских динара),
				'one' => q(стари судански динар),
				'other' => q(старих суданских динара),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(Суданска фунта),
				'few' => q(суданске фунте),
				'many' => q(суданских фунти),
				'one' => q(суданска фунта),
				'other' => q(суданских фунти),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(Стара суданска фунта),
				'few' => q(старе суданске фунте),
				'many' => q(старих суданских фунти),
				'one' => q(стара суданска фунта),
				'other' => q(старих суданских фунти),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(Шведска круна),
				'few' => q(шведске круне),
				'many' => q(шведских круна),
				'one' => q(шведска круна),
				'other' => q(шведских круна),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(Сингапурски долар),
				'few' => q(сингапурска долара),
				'many' => q(сингапурских долара),
				'one' => q(сингапурски долар),
				'other' => q(сингапурских долара),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(Св. јеленска фунта),
				'few' => q(св. јеленске фунте),
				'many' => q(св. јеленских фунти),
				'one' => q(св. јеленска фунта),
				'other' => q(св. јеленских фунти),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(Словеначки толар),
				'few' => q(словеначка толара),
				'many' => q(словеначких толара),
				'one' => q(словеначки толар),
				'other' => q(словеначких толара),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(Словачка круна),
				'few' => q(словачке круне),
				'many' => q(словачких круна),
				'one' => q(словачка круна),
				'other' => q(словачких круна),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(Сијера-леоншки леоне),
				'few' => q(сијералеонска леона),
				'many' => q(сијералеонских леона),
				'one' => q(сијералеонски леоне),
				'other' => q(сијералеонски леони),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(СОмалијски шилинг),
				'few' => q(сомалијска шилинга),
				'many' => q(сомалијских шилинга),
				'one' => q(сомалијски шилинг),
				'other' => q(сомалијски шилинзи),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(СУринамски долар),
				'few' => q(суринамска долара),
				'many' => q(суринамских долара),
				'one' => q(суринамски долар),
				'other' => q(суринамских долара),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(Суринамски гилдер),
				'few' => q(суринамска гилдера),
				'many' => q(суринамских гилдера),
				'one' => q(суринамски гилдер),
				'other' => q(суринамских гилдера),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(Сао Томе и Принципе добра),
				'few' => q(сао томе и принципе добра),
				'many' => q(сао томе и принципе добра),
				'one' => q(сао томе и принципе добар),
				'other' => q(сао томе и принципе добри),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(Совјетска рубља),
				'few' => q(совјетске рубље),
				'many' => q(совјетских рубљи),
				'one' => q(совјетска рубља),
				'other' => q(совјетских рубљи),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(Салвадорски колон),
				'few' => q(салвадорска колона),
				'many' => q(салвадорских колона),
				'one' => q(салвадорски колон),
				'other' => q(салвадорских колона),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(Сиријска фунта),
				'few' => q(сиријске фунте),
				'many' => q(сиријских фунти),
				'one' => q(сиријска фунта),
				'other' => q(сиријске фунте),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(Свази лилангени),
				'few' => q(свази емалангена),
				'many' => q(свази емалангена),
				'one' => q(свази емаланген),
				'other' => q(свази емалангена),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(Таи бахт),
				'few' => q(таи бахта),
				'many' => q(таи бахта),
				'one' => q(таи бахт),
				'other' => q(таи бахта),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(Таџихистанска рубља),
				'few' => q(таџихистанске рубље),
				'many' => q(таџихистанских рубљи),
				'one' => q(таџихистанска рубља),
				'other' => q(таџихистанских рубљи),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(Таљихистански сомони),
				'few' => q(таџихистанска сомона),
				'many' => q(таџихистанских сомона),
				'one' => q(таџихистански сомон),
				'other' => q(таџихистанских сомона),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(Туркменистански манат \(1993–2009\)),
				'few' => q(туркменистанска маната \(1993–2009\)),
				'many' => q(туркменистанских маната \(1993–2009\)),
				'one' => q(туркменистански манат \(1993–2009\)),
				'other' => q(туркменистански манат \(1993–2009\)),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(Туркменистански манат),
				'few' => q(туркменистански манат),
				'many' => q(туркменистанских маната),
				'one' => q(туркменистански манат),
				'other' => q(туркменистанских маната),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(Тунизијски долар),
				'few' => q(тунежанских динара),
				'many' => q(тунежанских динара),
				'one' => q(тунежанских динара),
				'other' => q(тунежанских динара),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(Тонгоншка Панга),
				'few' => q(тонгашке панге),
				'many' => q(тонгашких панга),
				'one' => q(тонгашка панга),
				'other' => q(тонгашких панга),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(Тиморшки ескудо),
				'few' => q(тиморшка ескуда),
				'many' => q(тиморшких ескуда),
				'one' => q(тиморшки ескудо),
				'other' => q(тиморшких ескуда),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(Стара турска лира),
				'few' => q(старе турске лире),
				'many' => q(старих турских лира),
				'one' => q(стара турска лира),
				'other' => q(стара турска лира),
			},
		},
		'TRY' => {
			symbol => 'Тл',
			display_name => {
				'currency' => q(Турска лира),
				'few' => q(турске лире),
				'many' => q(турских лира),
				'one' => q(турска лира),
				'other' => q(турских лира),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(Тринидад тобагошки долар),
				'few' => q(тринидад-тобагошка долара),
				'many' => q(тринидад-тобагошких долара),
				'one' => q(тринидад-тобагошки долар),
				'other' => q(тринидад-тобагошких долара),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(Нови тајвански долар),
				'few' => q(нова тајванска долара),
				'many' => q(нових тајванских долара),
				'one' => q(нови тајвански долар),
				'other' => q(нови тајвански долари),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(Танзанијски шилинг),
				'few' => q(танзанијска шилинга),
				'many' => q(танзанијских шилинга),
				'one' => q(танзанијски шилинг),
				'other' => q(танзанијски шилинзи),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(Украјинска хривња),
				'few' => q(украјинске кривње),
				'many' => q(украјинских кривњи),
				'one' => q(украјинска кривња),
				'other' => q(украјинских кривњи),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(Украјински карбованети),
				'few' => q(украјинска карбованцива),
				'many' => q(украјинских карбованцива),
				'one' => q(украјински карбованец),
				'other' => q(украјинских карбованцива),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(Угандски шилинг \(1966–1987\)),
				'few' => q(угандијска шилинга \(1966–1987\)),
				'many' => q(угандијских шилинга \(1966–1987\)),
				'one' => q(угандијски шилинг \(1966–1987\)),
				'other' => q(угандијских шилинга \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(Угандски шилинг),
				'few' => q(угандијска шилинга),
				'many' => q(угандијских шилинга),
				'one' => q(угандијски шилинг),
				'other' => q(угандијски шилинзи),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(Амерички долар),
				'few' => q(америчка долара),
				'many' => q(америчких долара),
				'one' => q(амерички долар),
				'other' => q(америчких долара),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(САД долар \(следећи дан\)),
				'few' => q(САД долара \(следећи дан\)),
				'many' => q(САД долара \(следећи дан\)),
				'one' => q(САД долар \(следећи дан\)),
				'other' => q(САД долара \(следећи дан\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(САД долар \(исти дан\)),
				'few' => q(САД долара \(исти дан\)),
				'many' => q(САД долара \(исти дан\)),
				'one' => q(САД долар \(исти дан\)),
				'other' => q(САД долара \(исти дан\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(Уругвајски пезо ен унидадес индексадас),
				'few' => q(уругвајска пезоса ен унидадес индексадеса),
				'many' => q(уругвајских пезоса ен унидадес индексадеса),
				'one' => q(уругвајски пезо ен унидадес индексадес),
				'other' => q(угвајских пезоса ен унидадес индексадеса),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(Уругвајски пезо \(1975–1993\)),
				'few' => q(уругвајска пезоса \(1975–1993\)),
				'many' => q(уругвајских пезоса \(1975–1993\)),
				'one' => q(уругвајски пезо \(1975–1993\)),
				'other' => q(уругвајских пезоса \(1975–1993\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(Уругвајски пезо),
				'few' => q(уругвајска пезоса),
				'many' => q(уругвајских пезоса),
				'one' => q(уругвајски пезо),
				'other' => q(уругвајских пезоса),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(Узбекистански сом),
				'few' => q(узбекистанска сома),
				'many' => q(узбекистанских сома),
				'one' => q(узбекистански сом),
				'other' => q(узбекистански сом),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(Венецуелански боливар \(1871–2008\)),
				'few' => q(венецуеланска боливара \(1871–2008\)),
				'many' => q(венецуеланских боливара \(1871–2008\)),
				'one' => q(венецуелански боливар \(1871–2008\)),
				'other' => q(венецуеланских боливара \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(Венецуелански боливар),
				'few' => q(венецуеланска боливара),
				'many' => q(венецуеланских боливара),
				'one' => q(венецуелански боливар),
				'other' => q(венецуеланских боливара),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(Вијетнамски донг),
				'few' => q(вијетнамска донга),
				'many' => q(вијетнамских донга),
				'one' => q(вијетнамски донг),
				'other' => q(вијетнамски донг),
			},
		},
		'VNN' => {
			display_name => {
				'few' => q(стара вијетнамска донга),
				'many' => q(старих вијетнамских донга),
				'one' => q(стари вијетнамски донг),
				'other' => q(старих вијетнамских донга),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(Вануатски вату),
				'few' => q(вануату ватуа),
				'many' => q(вануату ватуа),
				'one' => q(вануату вату),
				'other' => q(вануату ватуи),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(Самоанска тала),
				'few' => q(самоанске тале),
				'many' => q(самоанских тала),
				'one' => q(самоанска тала),
				'other' => q(самоанских тала),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(CFA франак BEAC),
				'few' => q(CFA франка BEAC),
				'many' => q(CFA франака BEAC),
				'one' => q(CFA франак BEAC),
				'other' => q(CFA франци BEAC),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(Сребро),
				'few' => q(сребра),
				'many' => q(сребра),
				'one' => q(сребро),
				'other' => q(сребра),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(Злато),
				'few' => q(злата),
				'many' => q(злата),
				'one' => q(злато),
				'other' => q(злата),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(Европска композитна јединица),
				'few' => q(европске композитне јединице),
				'many' => q(европских композитних јединица),
				'one' => q(европска композитна јединица),
				'other' => q(европских композитних јединица),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(Европска новчана јединица),
				'few' => q(европске новчане јединице \(XBB\)),
				'many' => q(европских новчаних јединица \(XBB\)),
				'one' => q(европска новчана јединица \(XBB\)),
				'other' => q(европске новчане јединице \(XBB\)),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(Европска јединица рачуна \(XBC\)),
				'few' => q(европске јединице рачуна \(XBC\)),
				'many' => q(европских јединица рачуна \(XBC\)),
				'one' => q(европска јединица рачуна \(XBC\)),
				'other' => q(европских јединица рачуна \(XBC\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(Европска јединица рачуна \(XBD\)),
				'few' => q(европске јединице рачуна \(XBD\)),
				'many' => q(европских јединица рачуна \(XBD\)),
				'one' => q(европска јединица рачуна \(XBD\)),
				'other' => q(европских јединица рачуна \(XBD\)),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(Источно-карибски долар),
				'few' => q(источно-карибска долара),
				'many' => q(источно-карибских долара),
				'one' => q(источно-карибски долар),
				'other' => q(источно-карибских долара),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(Посебна цртаћа права),
				'few' => q(посебна цртаћа права),
				'many' => q(посебних цртаћих права),
				'one' => q(посебно цртаће право),
				'other' => q(посебних цртаћих права),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(Европска валутна јединица),
				'few' => q(европске новчане јединице \(XEU\)),
				'many' => q(европских новчаних јединица \(XEU\)),
				'one' => q(европска новчана јединица \(XEU\)),
				'other' => q(европских новчаних јединица),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(Француски златни франак),
				'few' => q(француска златна франка),
				'many' => q(француских златних франака),
				'one' => q(француски златни франак),
				'other' => q(француских златних франака),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(Француски UIC-франак),
				'few' => q(француска UIC-франка),
				'many' => q(француских UIC-франака),
				'one' => q(француски UIC-франак),
				'other' => q(француских UIC-франака),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(CFA франак BCEAO),
				'few' => q(CFA франка BCEAO),
				'many' => q(CFA франака BCEAO),
				'one' => q(CFA франак BCEAO),
				'other' => q(CFA франци BCEAO),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(Паладијум),
				'few' => q(паладијума),
				'many' => q(паладијума),
				'one' => q(паладијум),
				'other' => q(паладијума),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(CFP франак),
				'few' => q(CFP франка),
				'many' => q(CFP франака),
				'one' => q(CFP франак),
				'other' => q(CFP франци),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(Платина),
				'few' => q(платине),
				'many' => q(платина),
				'one' => q(платина),
				'other' => q(платина),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(RINET фонд),
				'few' => q(RINET фонда),
				'many' => q(RINET фондова),
				'one' => q(RINET фонд),
				'other' => q(RINET фондова),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(Код тестиране валуте),
				'few' => q(кода тестиране валуте),
				'many' => q(кодова тестиране валуте),
				'one' => q(код тестиране валуте),
				'other' => q(кодова тестиране валуте),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Непозната или неважећа валута),
				'few' => q(непознате или неважеће валуте),
				'many' => q(непознатих или неважећих валута),
				'one' => q(непозната или неважећа валута),
				'other' => q(непознатих или неважећих валута),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(Јеменски динар),
				'few' => q(јеменска долара),
				'many' => q(јеменских долара),
				'one' => q(јеменски долар),
				'other' => q(јеменских долара),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(Јеменски риал),
				'few' => q(јеменска ријала),
				'many' => q(јеменских ријала),
				'one' => q(јеменски ријал),
				'other' => q(јеменски ријали),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(Југословенски тврди динар),
				'few' => q(југословенска тврда динара),
				'many' => q(југословенских тврдих динара),
				'one' => q(југословенски тврди динар),
				'other' => q(југословенских тврдих динара),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(Југословенски нови динар),
				'few' => q(југословенска нова динара),
				'many' => q(југословенских нових динара),
				'one' => q(југословенски нови динар),
				'other' => q(југословенских нових динара),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(Југословенски конвертибилни динар),
				'few' => q(југословенска конвертибилна динара),
				'many' => q(југословенских конвертибилних динара),
				'one' => q(југословенски конвертибилни динар),
				'other' => q(југословенских конвертибилних динара),
			},
		},
		'YUR' => {
			display_name => {
				'few' => q(југословенска реформирана динара),
				'many' => q(југословенских реформираних динара),
				'one' => q(југословенски реформирани динар),
				'other' => q(југословенских реформираних динара),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(Јужно-афрички ранд \(финансијски\)),
				'few' => q(јужноафричка ранда \(финансијска\)),
				'many' => q(јужноафричких ранда \(финансијских\)),
				'one' => q(јужноафрички ранд \(финансијски\)),
				'other' => q(јужноафричких ранда \(финансијских\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(Јужно-афрички ранд),
				'few' => q(јужно-афричка ранда),
				'many' => q(јужно-афричких ранда),
				'one' => q(јужно-афрички ранд),
				'other' => q(јужно-афричких ранда),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замбијска квача \(1968–2012\)),
				'few' => q(замбијске кваче \(1968–2012\)),
				'many' => q(замбијских квача \(1968–2012\)),
				'one' => q(замбијска квача \(1968–2012\)),
				'other' => q(замбијске кваче \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(Замбијска квача),
				'few' => q(замбијске кваче),
				'many' => q(замбијских квача),
				'one' => q(замбијска квача),
				'other' => q(замбијске кваче),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(Заирски нови заир),
				'few' => q(заирска нова заира),
				'many' => q(заирских нових заира),
				'one' => q(заирски нови заир),
				'other' => q(заирских нових заира),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(Заирски заир),
				'few' => q(заирска заира),
				'many' => q(заирских заира),
				'one' => q(заирски заир),
				'other' => q(заирских заира),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(Зимбабвејски долар),
				'few' => q(зимбабвејска долара),
				'many' => q(зимбабвејских долара),
				'one' => q(зимбабвејски долар),
				'other' => q(зимбабвејски долари),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(2008\)),
				'few' => q(зимбабвејска долара \(2008\)),
				'many' => q(зимбабвејских долара \(2008\)),
				'one' => q(зимбабвејски долар \(2008\)),
				'other' => q(зимбабвејских долара \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					wide => {
						nonleap => [
							'Таут',
							'Баба',
							'Хатор',
							'Киахк',
							'Тоба',
							'Амшир',
							'Барамхат',
							'Барамуда',
							'Башанс',
							'Паона',
							'Епеп',
							'Месра',
							'Наси'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'Мескерем',
							'Текемт',
							'Хедар',
							'Тахсас',
							'Тер',
							'Јекатит',
							'Мегабит',
							'Миазиа',
							'Генбот',
							'Сене',
							'Хамле',
							'Нехасе',
							'Пагумен'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'јан',
							'феб',
							'мар',
							'апр',
							'мај',
							'јун',
							'јул',
							'авг',
							'сеп',
							'окт',
							'нов',
							'дец'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануар',
							'фебруар',
							'март',
							'април',
							'мај',
							'јуни',
							'јули',
							'август',
							'септембар',
							'октобар',
							'новембар',
							'децембар'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'Тишри',
							'Хешван',
							'Кислев',
							'Тевет',
							'Шеват',
							'Адар I',
							'Адар',
							'Нисан',
							'Ијар',
							'Сиван',
							'Тамуз',
							'Ав',
							'Елул'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'Адар II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'Чаитра',
							'Ваисака',
							'Јиаиста',
							'Асада',
							'Сравана',
							'Бадра',
							'Асвина',
							'Картика',
							'Аргајана',
							'Пауза',
							'Мага',
							'Фалгуна'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Мух.',
							'Саф.',
							'Реб. 1',
							'Реб 2',
							'Џум. 1',
							'Џум. 2',
							'Реџ.',
							'Ша.',
							'Рам.',
							'Ше.',
							'Зул-к.',
							'Зул-х.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Мурахам',
							'Сафар',
							'Рабиʻ I',
							'Рабиʻ II',
							'Јумада I',
							'Јумада II',
							'Рађаб',
							'Шаʻбан',
							'Рамадан',
							'Шавал',
							'Дуʻл-Киʻда',
							'Дуʻл-хиђа'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					wide => {
						nonleap => [
							'Мухарем',
							'Сафер',
							'Реби 1',
							'Реби 2',
							'Џумаде 1',
							'Џумаде 2',
							'Реџеб',
							'Шаʻбан',
							'Рамазан',
							'Шевал',
							'Зул-каде',
							'Зул-хиџе'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'Фаравадин',
							'Ордибехешт',
							'Кордад',
							'Тир',
							'Мордад',
							'Шахривар',
							'Мехр',
							'Абан',
							'Азар',
							'Деј',
							'Бахман',
							'Есфанд'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'пон',
						tue => 'уто',
						wed => 'сри',
						thu => 'чет',
						fri => 'пет',
						sat => 'суб',
						sun => 'нед'
					},
					wide => {
						mon => 'понедељак',
						tue => 'уторак',
						wed => 'сриједа',
						thu => 'четвртак',
						fri => 'петак',
						sat => 'субота',
						sun => 'недеља'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'п',
						tue => 'у',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'К1',
						1 => 'К2',
						2 => 'К3',
						3 => 'К4'
					},
					narrow => {0 => '1.',
						1 => '2.',
						2 => '3.',
						3 => '4.'
					},
					wide => {0 => 'Прво тромесечје',
						1 => 'Друго тромесечје',
						2 => 'Треће тромесечје',
						3 => 'Четврто тромесечје'
					},
				},
				'stand-alone' => {
					narrow => {0 => '1.',
						1 => '2.',
						2 => '3.',
						3 => '4.'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'pm' => q{поподне},
					'am' => q{пре подне},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'БЕ'
			},
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'п. н. е.',
				'1' => 'н. е.'
			},
			narrow => {
				'0' => 'п.н.е.',
				'1' => 'н.е.'
			},
			wide => {
				'0' => 'Пре нове ере',
				'1' => 'Нове ере'
			},
		},
		'hebrew' => {
		},
		'indian' => {
			abbreviated => {
				'0' => 'САКА'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'АХ'
			},
		},
		'japanese' => {
			abbreviated => {
				'0' => 'Таика (645-650)',
				'1' => 'Хакучи (650-671)',
				'2' => 'Хакухо (672-686)',
				'3' => 'Шучо (686-701)',
				'4' => 'Таихо (701-704)',
				'5' => 'Кеиун (704-708)',
				'6' => 'Вадо (708-715)',
				'7' => 'Реики (715-717)',
				'8' => 'Јоро (717-724)',
				'9' => 'Јинки (724-729)',
				'10' => 'Темпио (729-749)',
				'11' => 'Темпио-кампо (749-749)',
				'12' => 'Темпио-шохо (749-757)',
				'13' => 'Темпио-хођи (757-765)',
				'14' => 'Темпо-ђинго (765-767)',
				'15' => 'Ђинго-кеиун (767-770)',
				'16' => 'Хоки (770-780)',
				'17' => 'Тен-о (781-782)',
				'18' => 'Енрјаку (782-806)',
				'19' => 'Даидо (806-810)',
				'20' => 'Конин (810-824)',
				'21' => 'Тенчо (824-834)',
				'22' => 'Шова (834-848)',
				'23' => 'Кајо (848-851)',
				'24' => 'Нињу (851-854)',
				'25' => 'Саико (854-857)',
				'26' => 'Тенан (857-859)',
				'27' => 'Јоган (859-877)',
				'28' => 'Генкеи (877-885)',
				'29' => 'Ниња (885-889)',
				'30' => 'Кампјо (889-898)',
				'31' => 'Шотаи (898-901)',
				'32' => 'Енђи (901-923)',
				'33' => 'Енчо (923-931)',
				'34' => 'Шохеи (931-938)',
				'35' => 'Тенгјо (938-947)',
				'36' => 'Тенриаку (947-957)',
				'37' => 'Тентоку (957-961)',
				'38' => 'Ова (961-964)',
				'39' => 'Кохо (964-968)',
				'40' => 'Ана (968-970)',
				'41' => 'Тенроку (970-973)',
				'42' => 'Тен-ен (973-976)',
				'43' => 'Јоген (976-978)',
				'44' => 'Тенген (978-983)',
				'45' => 'Еикан (983-985)',
				'46' => 'Кана (985-987)',
				'47' => 'Еи-ен (987-989)',
				'48' => 'Еисо (989-990)',
				'49' => 'Шорјаку (990-995)',
				'50' => 'Чотоку (995-999)',
				'51' => 'Чохо (999-1004)',
				'52' => 'Канко (1004-1012)',
				'53' => 'Чова (1012-1017)',
				'54' => 'Канин (1017-1021)',
				'55' => 'Ђиан (1021-1024)',
				'56' => 'Мању (1024-1028)',
				'57' => 'Чоген (1028-1037)',
				'58' => 'Чорјаку (1037-1040)',
				'59' => 'Чокју (1040-1044)',
				'60' => 'Кантоку (1044-1046)',
				'61' => 'Еишо (1046-1053)',
				'62' => 'Тенђи (1053-1058)',
				'63' => 'Кохеи (1058-1065)',
				'64' => 'Ђирјаку (1065-1069)',
				'65' => 'Енкју (1069-1074)',
				'66' => 'Шохо (1074-1077)',
				'67' => 'Шорјаку (1077-1081)',
				'68' => 'Еишо (1081-1084)',
				'69' => 'Отоку (1084-1087)',
				'70' => 'Канђи (1087-1094)',
				'71' => 'Кахо (1094-1096)',
				'72' => 'Еичо (1096-1097)',
				'73' => 'Шотоку (1097-1099)',
				'74' => 'Кова (1099-1104)',
				'75' => 'Чођи (1104-1106)',
				'76' => 'Кашо (1106-1108)',
				'77' => 'Тенин (1108-1110)',
				'78' => 'Тен-еи (1110-1113)',
				'79' => 'Еикју (1113-1118)',
				'80' => 'Ђен-еи (1118-1120)',
				'81' => 'Хоан (1120-1124)',
				'82' => 'Тенђи (1124-1126)',
				'83' => 'Даиђи (1126-1131)',
				'84' => 'Теншо (1131-1132)',
				'85' => 'Чошао (1132-1135)',
				'86' => 'Хоен (1135-1141)',
				'87' => 'Еиђи (1141-1142)',
				'88' => 'Кођи (1142-1144)',
				'89' => 'Тењо (1144-1145)',
				'90' => 'Кјуан (1145-1151)',
				'91' => 'Нинпеи (1151-1154)',
				'92' => 'Кјују (1154-1156)',
				'93' => 'Хоген (1156-1159)',
				'94' => 'Хеиђи (1159-1160)',
				'95' => 'Еирјаку (1160-1161)',
				'96' => 'Охо (1161-1163)',
				'97' => 'Чокан (1163-1165)',
				'98' => 'Еиман (1165-1166)',
				'99' => 'Нин-ан (1166-1169)',
				'100' => 'Као (1169-1171)',
				'101' => 'Шоан (1171-1175)',
				'102' => 'Анген (1175-1177)',
				'103' => 'Ђишо (1177-1181)',
				'104' => 'Јова (1181-1182)',
				'105' => 'Ђуеи (1182-1184)',
				'106' => 'Генрјуку (1184-1185)',
				'107' => 'Бунђи (1185-1190)',
				'108' => 'Кенкју (1190-1199)',
				'109' => 'Шођи (1199-1201)',
				'110' => 'Кенин (1201-1204)',
				'111' => 'Генкју (1204-1206)',
				'112' => 'Кен-еи (1206-1207)',
				'113' => 'Шоген (1207-1211)',
				'114' => 'Кенрјаку (1211-1213)',
				'115' => 'Кенпо (1213-1219)',
				'116' => 'Шокју (1219-1222)',
				'117' => 'Ђу (1222-1224)',
				'118' => 'Ђенин (1224-1225)',
				'119' => 'Кароку (1225-1227)',
				'120' => 'Антеи (1227-1229)',
				'121' => 'Канки (1229-1232)',
				'122' => 'Ђоеи (1232-1233)',
				'123' => 'Темпуку (1233-1234)',
				'124' => 'Бунрјаку (1234-1235)',
				'125' => 'Катеи (1235-1238)',
				'126' => 'Рјакунин (1238-1239)',
				'127' => 'Ен-о (1239-1240)',
				'128' => 'Нињи (1240-1243)',
				'129' => 'Канген (1243-1247)',
				'130' => 'Хођи (1247-1249)',
				'131' => 'Кенчо (1249-1256)',
				'132' => 'Коген (1256-1257)',
				'133' => 'Шока (1257-1259)',
				'134' => 'Шоген (1259-1260)',
				'135' => 'Бун-о (1260-1261)',
				'136' => 'Кочо (1261-1264)',
				'137' => 'Бун-еи (1264-1275)',
				'138' => 'Кенђи (1275-1278)',
				'139' => 'Коан (1278-1288)',
				'140' => 'Шу (1288-1293)',
				'141' => 'Еинин (1293-1299)',
				'142' => 'Шоан (1299-1302)',
				'143' => 'Кенген (1302-1303)',
				'144' => 'Каген (1303-1306)',
				'145' => 'Токуђи (1306-1308)',
				'146' => 'Енкеи (1308-1311)',
				'147' => 'Очо (1311-1312)',
				'148' => 'Шова (1312-1317)',
				'149' => 'Бунпо (1317-1319)',
				'150' => 'Ђено (1319-1321)',
				'151' => 'Ђенкјо (1321-1324)',
				'152' => 'Шочу (1324-1326)',
				'153' => 'Кареки (1326-1329)',
				'154' => 'Гентоку (1329-1331)',
				'155' => 'Генко (1331-1334)',
				'156' => 'Кему (1334-1336)',
				'157' => 'Енген (1336-1340)',
				'158' => 'Кококу (1340-1346)',
				'159' => 'Шохеи (1346-1370)',
				'160' => 'Кентоку (1370-1372)',
				'161' => 'Бучу (1372-1375)',
				'162' => 'Тењу (1375-1379)',
				'163' => 'Корјаку (1379-1381)',
				'164' => 'Кова (1381-1384)',
				'165' => 'Генчу (1384-1392)',
				'166' => 'Меитоку (1384-1387)',
				'167' => 'Какеи (1387-1389)',
				'168' => 'Ку (1389-1390)',
				'169' => 'Меитоку (1390-1394)',
				'170' => 'Оеи (1394-1428)',
				'171' => 'Шочо (1428-1429)',
				'172' => 'Еикјо (1429-1441)',
				'173' => 'Какитсу (1441-1444)',
				'174' => 'Бун-ан (1444-1449)',
				'175' => 'Хотоку (1449-1452)',
				'176' => 'Кјотоку (1452-1455)',
				'177' => 'Кошо (1455-1457)',
				'178' => 'Чороку (1457-1460)',
				'179' => 'Каншо (1460-1466)',
				'180' => 'Буншо (1466-1467)',
				'181' => 'Онин (1467-1469)',
				'182' => 'Бунмеи (1469-1487)',
				'183' => 'Чокјо (1487-1489)',
				'184' => 'Ентоку (1489-1492)',
				'185' => 'Меио (1492-1501)',
				'186' => 'Бунки (1501-1504)',
				'187' => 'Еишо (1504-1521)',
				'188' => 'Таиеи (1521-1528)',
				'189' => 'Кјороку (1528-1532)',
				'190' => 'Тенмон (1532-1555)',
				'191' => 'Кођи (1555-1558)',
				'192' => 'Еироку (1558-1570)',
				'193' => 'Генки (1570-1573)',
				'194' => 'Теншо (1573-1592)',
				'195' => 'Бунроку (1592-1596)',
				'196' => 'Кеичо (1596-1615)',
				'197' => 'Генва (1615-1624)',
				'198' => 'Кан-еи (1624-1644)',
				'199' => 'Шохо (1644-1648)',
				'200' => 'Кеиан (1648-1652)',
				'201' => 'Шу (1652-1655)',
				'202' => 'Меирјаку (1655-1658)',
				'203' => 'Мањи (1658-1661)',
				'204' => 'Канбун (1661-1673)',
				'205' => 'Енпо (1673-1681)',
				'206' => 'Тенва (1681-1684)',
				'207' => 'Јокјо (1684-1688)',
				'208' => 'Генроку (1688-1704)',
				'209' => 'Хоеи (1704-1711)',
				'210' => 'Шотоку (1711-1716)',
				'211' => 'Кјохо (1716-1736)',
				'212' => 'Генбун (1736-1741)',
				'213' => 'Канпо (1741-1744)',
				'214' => 'Енкјо (1744-1748)',
				'215' => 'Кан-ен (1748-1751)',
				'216' => 'Хорјаку (1751-1764)',
				'217' => 'Меива (1764-1772)',
				'218' => 'Ан-еи (1772-1781)',
				'219' => 'Тенмеи (1781-1789)',
				'220' => 'Кансеи (1789-1801)',
				'221' => 'Кјова (1801-1804)',
				'222' => 'Бунка (1804-1818)',
				'223' => 'Бунсеи (1818-1830)',
				'224' => 'Тенпо (1830-1844)',
				'225' => 'Кока (1844-1848)',
				'226' => 'Каеи (1848-1854)',
				'227' => 'Ансеи (1854-1860)',
				'228' => 'Ман-ен (1860-1861)',
				'229' => 'Бункју (1861-1864)',
				'230' => 'Генђи (1864-1865)',
				'231' => 'Кеико (1865-1868)',
				'232' => 'Меиђи',
				'233' => 'Таишо',
				'234' => 'Шова',
				'235' => 'Хаисеи'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'АП'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'Пре РК',
				'1' => 'РК'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, dd. MMMM y. G},
			'long' => q{dd. MMMM y. G},
			'medium' => q{dd.MM.y. G},
			'short' => q{d.M.y. GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, dd. MMMM y.},
			'long' => q{dd. MMMM y.},
			'medium' => q{dd.MM.y.},
			'short' => q{d.M.yy.},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
			'full' => q{EEEE, dd. MMMM y. G},
			'long' => q{dd. MMMM y. G},
			'medium' => q{dd.MM.y. G},
			'short' => q{dd.MM.y. G},
		},
		'japanese' => {
			'full' => q{EEEE, MMMM d, y G},
			'long' => q{MMMM d, y G},
			'medium' => q{MMM d, y G},
			'short' => q{M/d/yy G},
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'islamic' => {
			Ed => q{E, dd.},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, dd.MM.},
			MMM => q{LLL},
			MMMEd => q{E, dd. MMM},
			MMMd => q{dd. MMM},
			Md => q{dd.MM.},
			d => q{d},
			hm => q{hh:mm a},
			hms => q{hh:mm:ss a},
			ms => q{mm:ss},
			y => q{y. G},
			yM => q{MM.y. G},
			yMEd => q{E, dd.MM.y. G},
			yMMM => q{MMM y. G},
			yMMMEd => q{E, dd. MMM y. G},
			yMMMd => q{dd. MMM y. G},
			yMd => q{dd.MM.y. G},
			yQQQ => q{y G QQQ},
			yQQQQ => q{y G QQQQ},
		},
		'gregorian' => {
			Ed => q{E, d.},
			Gy => q{y. G},
			GyMMM => q{MMM y. G},
			GyMMMEd => q{E, dd. MMM y. G},
			GyMMMd => q{dd. MMM y. G},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, dd.MM.},
			MMM => q{LLL},
			MMMEd => q{E, dd. MMM},
			MMMd => q{dd. MMM},
			Md => q{dd.MM.},
			d => q{d},
			h => q{hh a},
			hm => q{hh:mm a},
			hms => q{hh:mm:ss a},
			ms => q{mm:ss},
			y => q{y.},
			yM => q{MM.y.},
			yMEd => q{E, dd.MM.y.},
			yMMM => q{MMM y.},
			yMMMEd => q{E, dd. MMM y.},
			yMMMd => q{dd. MMM y.},
			yMd => q{dd.MM.y.},
			yQQQ => q{y QQQ},
			yQQQQ => q{y QQQQ},
		},
		'generic' => {
			Ed => q{E, d.},
			Gy => q{y. G},
			GyMMM => q{MMM y. G},
			GyMMMEd => q{E, dd. MMM y. G},
			GyMMMd => q{dd. MMM y. G},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, dd.MM.},
			MMM => q{LLL},
			MMMEd => q{E, dd. MMM},
			MMMd => q{dd. MMM},
			Md => q{dd.MM.},
			d => q{d},
			h => q{hh a},
			hm => q{hh:mm a},
			hms => q{hh:mm:ss a},
			ms => q{mm:ss},
			y => q{y. G},
			yyyy => q{y. G},
			yyyyM => q{MM.y. G},
			yyyyMEd => q{E, dd.MM.y. G},
			yyyyMMM => q{MMM y. G},
			yyyyMMMEd => q{E, dd. MMM y. G},
			yyyyMMMd => q{dd. MMM y. G},
			yyyyMd => q{dd.MM.y. G},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH-HH},
			},
			Hm => {
				H => q{HH:mm-HH:mm},
				m => q{HH:mm-HH:mm},
			},
			Hmv => {
				H => q{HH:mm-HH:mm v},
				m => q{HH:mm-HH:mm v},
			},
			Hv => {
				H => q{HH-HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, d.M - E, d.M},
				d => q{E, d.M - E, d.M},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, dd. MMM - E, dd. MMM},
				d => q{E, dd. - E, dd. MMM},
			},
			MMMd => {
				M => q{dd. MMM - dd. MMM},
				d => q{dd.-dd. MMM},
			},
			Md => {
				M => q{d.M - d.M},
				d => q{d.M - d.M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{hh a - hh a},
				h => q{hh-hh a},
			},
			hm => {
				a => q{hh:mm a - hh:mm a},
				h => q{hh:mm-hh:mm a},
				m => q{hh:mm-hh:mm a},
			},
			hmv => {
				a => q{hh:mm a - hh:mm a v},
				h => q{hh:mm-hh:mm a v},
				m => q{hh:mm-hh:mm a v},
			},
			hv => {
				a => q{hh a - hh a v},
				h => q{hh-hh a v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{MM.-MM. y.},
				y => q{MM.y. - MM.y.},
			},
			yMEd => {
				M => q{E, d.M.y. - E, d.M.y.},
				d => q{E, d.M.y. - E, d.M.y.},
				y => q{E, d.M.y. - E, d.M.y.},
			},
			yMMM => {
				M => q{MMM-MMM y.},
				y => q{MMM y. - MMM y.},
			},
			yMMMEd => {
				M => q{E, dd. MMM - E, dd. MMM y.},
				d => q{E, dd. - E, dd. MMM y.},
				y => q{E, dd. MMM y. - E, dd. MMM y.},
			},
			yMMMM => {
				M => q{MMMM-MMMM y.},
				y => q{MMMM y. - MMMM y.},
			},
			yMMMd => {
				M => q{dd. MMM - dd. MMM y.},
				d => q{dd.-dd. MMM y.},
				y => q{dd. MMM y. - dd. MMM y.},
			},
			yMd => {
				M => q{d.M.y. - d.M.y.},
				d => q{d.M.y. - d.M.y.},
				y => q{d.M.y. - d.M.y.},
			},
		},
		'generic' => {
			H => {
				H => q{HH-HH},
			},
			Hm => {
				H => q{HH:mm-HH:mm},
				m => q{HH:mm-HH:mm},
			},
			Hmv => {
				H => q{HH:mm-HH:mm v},
				m => q{HH:mm-HH:mm v},
			},
			Hv => {
				H => q{HH-HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, d.M - E, d.M},
				d => q{E, d.M - E, d.M},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, dd. MMM - E, dd. MMM},
				d => q{E, dd. - E, dd. MMM},
			},
			MMMd => {
				M => q{dd. MMM - dd. MMM},
				d => q{dd.-dd. MMM},
			},
			Md => {
				M => q{d.M - d.M},
				d => q{d.M - d.M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{hh a - hh a},
				h => q{hh-hh a},
			},
			hm => {
				a => q{hh:mm a - hh:mm a},
				h => q{hh:mm-hh:mm a},
				m => q{hh:mm-hh:mm a},
			},
			hmv => {
				a => q{hh:mm a - hh:mm a v},
				h => q{hh:mm-hh:mm a v},
				m => q{hh:mm-hh:mm a v},
			},
			hv => {
				a => q{hh a - hh a v},
				h => q{hh-hh a v},
			},
			y => {
				y => q{y-y G},
			},
			yM => {
				M => q{MM.-MM. y. G},
				y => q{MM.y. - MM.y. G},
			},
			yMEd => {
				M => q{E, d.M.y. - E, d.M.y. G},
				d => q{E, d.M.y. - E, d.M.y. G},
				y => q{E, d.M.y. - E, d.M.y. G},
			},
			yMMM => {
				M => q{MMM-MMM y. G},
				y => q{MMM y. - MMM y. G},
			},
			yMMMEd => {
				M => q{E, dd. MMM - E, dd. MMM y. G},
				d => q{E, dd. - E, dd. MMM y. G},
				y => q{E, dd. MMM y. - E, dd. MMM y. G},
			},
			yMMMM => {
				M => q{MMMM-MMMM y. G},
				y => q{MMMM y. - MMMM y. G},
			},
			yMMMd => {
				M => q{dd. MMM - dd. MMM y. G},
				d => q{dd.-dd. MMM y. G},
				y => q{dd. MMM y. - dd. MMM y. G},
			},
			yMd => {
				M => q{d.M.y. - d.M.y. G},
				d => q{d.M.y. - d.M.y. G},
				y => q{d.M.y. - d.M.y. G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HHmm;-HHmm),
		gmtFormat => q(GMT{0}),
		regionFormat => q(Време у земљи: {0}),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(Акре летње рачунање времена),
				'generic' => q(Акре време),
				'standard' => q(Акре стандардно време),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(Авганистанско време),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиџан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Акра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Адис Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмера#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Бангуи#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисао#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантир#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Бразавил#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Буџумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каиро#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Казабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-ес-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Џибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ел Ајун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габорон#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Јоханесбург#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Картум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревил#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лумумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадиш#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровија#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Најроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нџамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Нијамеј#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Навакшут#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сао Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(Централно-афричко време),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(Источно-афричко време),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(Јужно-афричко време),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(Западно-афричко летње рачунање времена),
				'generic' => q(Западно-афричко време),
				'standard' => q(Западно-афричко стандардно време),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(Аљашко летње време),
				'generic' => q(Аљашко време),
				'standard' => q(Аљашко стандардно време),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(Алмати летње рачунање времена),
				'generic' => q(Алмати време),
				'standard' => q(Алмати стандардно време),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(Амазон летње рачунање времена),
				'generic' => q(Амазон време),
				'standard' => q(Амазон стандардно време),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Енкориџ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангвила#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигва#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагвајана#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла Риоја#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Гелегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луи#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуаија#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Бахиа#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белизе#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Сејблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бојзи#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос Аирес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембриџ Беј#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кајен#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кајманска острва#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чихуахуа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал Харбур#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Костарика#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куиаба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кирасо#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмарксхаген#,
		},
		'America/Dawson' => {
			exemplarCity => q#Досон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Досон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детроит#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Еирунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Салвадор#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глејс Беј#,
		},
		'America/Godthab' => {
			exemplarCity => q#Готхаб#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Беј#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гвадалупе#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гвајакил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гуана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Хермосиљо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Кнокс, Индијана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индијана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Петерсбург, Индијана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вевај, Индијана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винценес, Индијана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индијана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Иквалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Јамајка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуи#,
		},
		'America/Juneau' => {
			exemplarCity => q#Жуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичело, Кентаки#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Паз#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос Анђелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луивиле#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масејо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагва#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоза#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мексико Сити#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтереј#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсерат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Насау#,
		},
		'America/New_York' => {
			exemplarCity => q#Њујорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Нороња#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бијула, Северна Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Центар, Северна Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нови Салем, Северна Даткоа#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртунг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамирбо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Феникс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт оф Спејн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто Вељо#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Порто Рико#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рејни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифе#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Ресолут#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантијаго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сао Паоло#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорезбисунд#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Св. Бартоломeј#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Св. Џон#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Св. Луција#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Св. Тома#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Курент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигалпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандер Беј#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Вајтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Винипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Јакутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Јелоунајф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(Централно летње рачунање времена),
				'generic' => q(Централно време),
				'standard' => q(Централно стандардно време),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(Источно летње рачунање времена),
				'generic' => q(Источно време),
				'standard' => q(Источно стандардно време),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(Планинско летње рачунање времена),
				'generic' => q(Планинско време),
				'standard' => q(Планинско стандардно време),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(Пацифичко летње рачунање времена),
				'generic' => q(Пацифичко време),
				'standard' => q(Пацифичко стандардно време),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(Анадир летње рачунање времена),
				'generic' => q(Анадир време),
				'standard' => q(Анадир стандардно време),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Касеј#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дејвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Димон д’Урвил#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Мосон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Макмурдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Шова#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q(Акватау летње рачунање времена),
				'generic' => q(Акватау време),
				'standard' => q(Акватау стандардно време),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(Акутобе летње рачунање времена),
				'generic' => q(Акутобе време),
				'standard' => q(Акутобе стандардно време),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(Арабијско летње рачунање времена),
				'generic' => q(Арабијско време),
				'standard' => q(Арабијско стандардно време),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгјербјен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(Аргентина летње рачунање времена),
				'generic' => q(Аргентина време),
				'standard' => q(Аргентина стандардно време),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(Западна Аргентина летње рачунање времена),
				'generic' => q(Западна Аргентина време),
				'standard' => q(Западна Аргентина стандардно време),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(Арменија летње рачунање времена),
				'generic' => q(Арменија време),
				'standard' => q(Арменија стандардно време),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмати#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Аман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Акутобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахреин#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Банкок#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бејрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Брунеји#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калкута#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чојбалсан#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#Чонгкинг#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубаи#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#Харбин#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонг Конг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркуцк#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Џакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Џајапура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Јерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#Кашгар#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Краснојарск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувајт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макау#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никозија#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пном Пен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пјонгјанг#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кизилорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Ријад#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шангај#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тајпеј#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Техеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимпу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумкви#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вијентијан#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Јакутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Јекатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Јереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(Атланско лтње рачунање времена),
				'generic' => q(Атланско време),
				'standard' => q(Атланско стандардно време),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азори#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуда#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канарска острва#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Зеленортска Острва#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарска острва#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадера#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рејкјавик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Јужна Џорџија#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Св. Јелена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Бризбејн#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен Хил#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Курие#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Иукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хов#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мелбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сиднеј#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(Аустралијско централно летње рачунање времена),
				'generic' => q(Аустралијско централно време),
				'standard' => q(Аустралијско централно стандардно време),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(Аустралијско централно западно летње рачунање времена),
				'generic' => q(Аустралијско централно западно време),
				'standard' => q(Аустралијско централно западно стандардно време),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(Аустралијско источно летње рачунање времена),
				'generic' => q(Аустралијско источно време),
				'standard' => q(Аустралијско источно стандардно време),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(Аустралијско западно летње рачунање времена),
				'generic' => q(Аустралијско западно време),
				'standard' => q(Аустралијско западно стандардно време),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(Азербејџан летње рачунање времена),
				'generic' => q(Азербејџан време),
				'standard' => q(Азербејџан стандардно време),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(Азори летње рачунање времена),
				'generic' => q(Азори време),
				'standard' => q(Азори стандардно време),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(Бангладеш летње рачунање времена),
				'generic' => q(Бангладеш време),
				'standard' => q(Бангладеш стандардно време),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(Бутан време),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(Боливија време),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(Бразилија летње рачунање времена),
				'generic' => q(Бразилија време),
				'standard' => q(Бразилија стандардно време),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(Брунеј Дарусалум време),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(Зеленортско летње рачунање времена),
				'generic' => q(Зелениртско време),
				'standard' => q(Зелениртско стандардно време),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(Чаморо време),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(Чатам летње рачунање времена),
				'generic' => q(Чатам време),
				'standard' => q(Чатам стандардно време),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(Чиле летње рачунање времена),
				'generic' => q(Чиле време),
				'standard' => q(Чиле стандардно време),
			},
		},
		'China' => {
			long => {
				'daylight' => q(Кина летње рачунање времена),
				'generic' => q(Кина време),
				'standard' => q(Кинеско стандардно време),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(Чојбалсан летње рачунање времена),
				'generic' => q(Чојбалсан време),
				'standard' => q(Чојбалсан стандардно време),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(Божићна острва време),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(Кокос (Келинг) Острва време),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(Колумбија летње рачунање времена),
				'generic' => q(Колумбија време),
				'standard' => q(Колумбија стандардно време),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(Кукова острва полу-летње рачунање времена),
				'generic' => q(Кукова острва време),
				'standard' => q(Кукова острва стандардно време),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(Куба летње рачунање времена),
				'generic' => q(Куба време),
				'standard' => q(Куба стандардно време),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(Дејвис време),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(Димон д’Урвил време),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(Источни тимор време),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(Ускршња острва летње рачунање времена),
				'generic' => q(Ускршња острва време),
				'standard' => q(Ускршња острва стандардно време),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(Еквадор време),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Непознат или неважећи град#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андора#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Атина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Београд#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брисел#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Букурешт#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будимпешта#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишињев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенхаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Даблин#,
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернзи#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Острво Ман#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Џерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Кијев#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лисабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Љубљана#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Луксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Малта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Марихамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париз#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Праг#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сарајево#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферопол#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопље#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софија#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокхолм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Талин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуз#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Беч#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Виљнус#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожје#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цирих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(Средњеевропско летње рачунање времена),
				'generic' => q(Средњеевропско време),
				'standard' => q(Средњеевропско стандардно време),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(Источноевропско летње рачунање времена),
				'generic' => q(Источноевропско време),
				'standard' => q(Источноевропско стандардно време),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(Западноевропско летње рачунање времена),
				'generic' => q(Западноевропско време),
				'standard' => q(Западноевропско стандардно време),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(Фолкландска Острва летње рачунање времена),
				'generic' => q(Фолкландска Острва време),
				'standard' => q(Фолкландска Острва стандардно време),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(Фиџи летње рачунање времена),
				'generic' => q(Фиџи време),
				'standard' => q(Фиџи стандардно време),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(Француска Гвајана време),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(Француско јужно и антарктичко време),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Гринвич средње време),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(Галапагос време),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(Гамбијер време),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(Грузија летње рачунање времена),
				'generic' => q(Грузија време),
				'standard' => q(Грузија стандардно време),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(Гилберт острва време),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(Источни Гренланд летње рачунање времена),
				'generic' => q(Источни Гренланд време),
				'standard' => q(Источни Гренланд стандардно време),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(Западни Гренланд летње рачунање времена),
				'generic' => q(Западни Гренланд време),
				'standard' => q(Западни Гренланд стандардно време),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(Гуам стандардно време),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(Залив време),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(Гвајана време),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(Хавајско-алеутско летње рачунање времена),
				'generic' => q(Хавајско-алеутско време),
				'standard' => q(Хавајско-алеутско стандардно време),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(Хонгконшко летње рачунање времена),
				'generic' => q(Хонг Конг време),
				'standard' => q(Хонг Конг стандардно време),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(Ховд летње рачунање времена),
				'generic' => q(Ховд време),
				'standard' => q(Ховд стандардно време),
			},
		},
		'India' => {
			long => {
				'standard' => q(Индијско стандардно време),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Божић#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдиви#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маурицијус#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Мајот#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реунион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(Индијско океанско време),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(Индокина време),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(Централно-индонезијско време),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(Источно-индонезијско време),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(Западно-индонезијско време),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(Иран летње рачунање времена),
				'generic' => q(Иран време),
				'standard' => q(Иран стандардно време),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(Иркуцк летње рачунање времена),
				'generic' => q(Иркуцк време),
				'standard' => q(Иркуцк стандардно време),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(Израелско летње рачунање времена),
				'generic' => q(Израелско време),
				'standard' => q(Израелско стандардно време),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(Јапанско летње рачунање времена),
				'generic' => q(Јапанско време),
				'standard' => q(Јапанско стандардно време),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(Петропавловско-камчатско летње рачунање вемена),
				'generic' => q(Петропавловско-камчатско време),
				'standard' => q(Петропавловско-камчатско стандардно време),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(Источно-казахстанско време),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(Западно-казахстанско време),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(Корејско летње рачунање времена),
				'generic' => q(Кореја време),
				'standard' => q(Корејско стандардно време),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(Кошре време),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(Краснојарск летње рачунање времена),
				'generic' => q(Краснојарск време),
				'standard' => q(Краснојарск стандардно време),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(Киргизстан време),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(Шри Ланка време),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(Лине Острва време),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(Лорд Хов летње рачунање времена),
				'generic' => q(Лорд Хов време),
				'standard' => q(Лорд Хов стандардно време),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(Макао летње рачунање вемена),
				'generic' => q(Макао време),
				'standard' => q(Макао стандардно време),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(Макверијско време),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(Магадан летње рачунање вемена),
				'generic' => q(Магадан време),
				'standard' => q(Магадан стандардно време),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(Малезија време),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(Малдиви време),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(Маркиз време),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(Маршалска Острва време),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(Маурицијус летње рачунање времена),
				'generic' => q(Маурицијус време),
				'standard' => q(Маурицијус стандардно време),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(Мосон време),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(Улан Батор летње рачунање времена),
				'generic' => q(Улан Батор време),
				'standard' => q(Улан Батор стандардно време),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(Москва летње рачунање времена),
				'generic' => q(Москва време),
				'standard' => q(Москва стандардно време),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(Мијанмар време),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(Науру време),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(Непал време),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(Нова Каледонија летње рачунање времена),
				'generic' => q(Нова Каледонија време),
				'standard' => q(Нова Каледонија стандардно време),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(Нови Зеланд летње рачунање времена),
				'generic' => q(Нови Зеланд време),
				'standard' => q(Нови Зеланд стандардно време),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(Њуфаундленд летње рачунање времена),
				'generic' => q(Њуфаундленд време),
				'standard' => q(Њуфаундленд стандардно време),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(Ниуе време),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(Норфолк Острво време),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(Фернандо де Нороња летње рачунање времена),
				'generic' => q(Фернандо де Нороња време),
				'standard' => q(Фернандо де Нороња стандардно време),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(Северна Маријанска Острва време),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(Новосибирск летње рачунање времена),
				'generic' => q(Новосибирск време),
				'standard' => q(Новосибирск стандардно време),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(Омск летње рачунање времена),
				'generic' => q(Омск време),
				'standard' => q(Омск стандардно време),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апија#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окланд#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Катхам#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Ускршње острво#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефат#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Ендербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиџи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбије#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Џонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Кошре#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваџалејин#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Мајуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркиз#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидвеј#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкаирн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понапе#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Морзби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сајпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Тахити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Трук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Вејк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Валис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(Пакистан летње рачунање времена),
				'generic' => q(Пакистан време),
				'standard' => q(Пакистан стандардно време),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(Палау време),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(Папуа Нова Гвинеја време),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(Парагвај летње рачунање времена),
				'generic' => q(Парагвај време),
				'standard' => q(Парагвај стандардно време),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(Перу летње рачунање времена),
				'generic' => q(Перу време),
				'standard' => q(Перу стандардно време),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(Филипини летње рачунање времена),
				'generic' => q(Филипини време),
				'standard' => q(Филипини стандардно време),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(Феникс острва време),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(Сен Пјер и Микелон летње рачунање вемена),
				'generic' => q(Сен Пјер и Микелон време),
				'standard' => q(Сен Пјер и Микелон стандардно време),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(Питкерн време),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(Понапе време),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(Кизилорда летње рачунање времена),
				'generic' => q(Кизилорда време),
				'standard' => q(Кизилорда стандардно време),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(Реинион време),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(Ротера време),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(Сахалин летње рачунање времена),
				'generic' => q(Сахалин време),
				'standard' => q(Сахалин стандардно време),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(Самара летње рачунање времена),
				'generic' => q(Самара време),
				'standard' => q(Самара стандардно време),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(Самоа летње рачунање времена),
				'generic' => q(Самоа време),
				'standard' => q(Самоа стандардно време),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(Сејшели време),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(Сингапур стандардно време),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(Соломонска Острва време),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(Јужна Џорџија време),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(Суринам време),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(Шова време),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(Тахити време),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(Таипеи летње рачунање времена),
				'generic' => q(Таипеи време),
				'standard' => q(Таипеи стандардно веме),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(Таџикистан време),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(Токелау време),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(Тонга летње рачунање времена),
				'generic' => q(Тонга време),
				'standard' => q(Тонга стандардно време),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(Трук време),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(Туркменистан летње рачунање времена),
				'generic' => q(Туркменистан време),
				'standard' => q(Туркменистан стандардно време),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(Тувалу време),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(Уругвај летње рачунање времена),
				'generic' => q(Уругвај време),
				'standard' => q(Уругвај стандардно време),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(Узбекистан летње рачунање времена),
				'generic' => q(Узбекистан време),
				'standard' => q(Узбекистан стандардно време),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(Вануату летње рачунање времена),
				'generic' => q(Вануату време),
				'standard' => q(Вануату стандардно време),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(Венецуела време),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(Владивосток летње рачунање времена),
				'generic' => q(Владивосток време),
				'standard' => q(Владивосток стандардно време),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(Волгоград летње рачунање времена),
				'generic' => q(Волгоград време),
				'standard' => q(Волгоград стандардно време),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(Восток време),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(Вејк острво време),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(Валис и Футуна Острва време),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(Јакутск летње рачунање времена),
				'generic' => q(Јакутск време),
				'standard' => q(Јакутск стандардно време),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(Јекатеринбург летње рачунање времена),
				'generic' => q(Јекатеринбург време),
				'standard' => q(Јекатеринбург стандардно време),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
