package Locale::CLDR::Transformations::Ies_jes_1964::Ethi::Latn;
# This file auto generated from Data\common\transforms\und-Ethi-t-und-latn-m0-ies-jes-1964.xml
#	on Wed 28 Feb 12:16:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^umi:\G[ሀ-፼ⶓ-ⶖ])/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFD),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(([ሀ-ሇ])፟),
					result  => q(h),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ለ-ሏⶀ])፟),
					result  => q(l),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ሐ-ሗ])፟),
					result  => q(ḥ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([መ-ሟⶁᎀ-ᎃፙ])፟),
					result  => q(m),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ሠ-ሧ])፟),
					result  => q(ś),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ረ-ሯⶂፘ])፟),
					result  => q(r),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ሰ-ሷⶃ])፟),
					result  => q(s),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ሸ-ሿⶄ])፟),
					result  => q(š),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ቀ-ቍ])፟),
					result  => q(q),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ቐ-ቝ])፟),
					result  => q(q̌),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([በ-ቧⶅᎄ-ᎇ])፟),
					result  => q(b),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ቨ-ቯ])፟),
					result  => q(v),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ተ-ቷ])፟),
					result  => q(t),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ቸ-ቿ])፟),
					result  => q(č),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ኀ-ኍ])፟),
					result  => q(ḫ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ነ-ኗ])፟),
					result  => q(n),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ኘ-ኟ])፟),
					result  => q(ñ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ከ-ኵ])፟),
					result  => q(k),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ኸ-ዅ])፟),
					result  => q(x),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ወ-ዏ])፟),
					result  => q(w),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ዘ-ዟⶋ])፟),
					result  => q(z),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ዠ-ዧ])፟),
					result  => q(ž),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([የ-ዯ])፟),
					result  => q(y),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ደ-ዷⶌ])፟),
					result  => q(d),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ጀ-ጇⶎ])፟),
					result  => q(j),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ገ-ጕጏ])፟),
					result  => q(g),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ጘ-ጟⶓ-ⶖ])፟),
					result  => q(ŋ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ጠ-ጧⶏ])፟),
					result  => q(ṭ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ጨ-ጯⶐ])፟),
					result  => q(č̣),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ጰ-ጷⶑ])፟),
					result  => q(p̣),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ጸ-ጿ])፟),
					result  => q(ṣ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ፀ-ፇ])፟),
					result  => q(ẓ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ፈ-ፏፚᎈ-ᎋ])፟),
					result  => q(f),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ፐ-ፗᎌ-ᎏ])፟),
					result  => q(p),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፟),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሀ),
					result  => q(h\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሁ),
					result  => q(h\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሂ),
					result  => q(h\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሃ),
					result  => q(h\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሄ),
					result  => q(h\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ህ),
					result  => q(h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ህ),
					result  => q(h\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሆ),
					result  => q(h\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ለ),
					result  => q(l\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሉ),
					result  => q(l\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሊ),
					result  => q(l\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ላ),
					result  => q(l\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሌ),
					result  => q(l\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ል),
					result  => q(l),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ል),
					result  => q(l\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሎ),
					result  => q(l\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሏ),
					result  => q(l\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሐ),
					result  => q(ḥ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሑ),
					result  => q(ḥ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሒ),
					result  => q(ḥ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሓ),
					result  => q(ḥ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሔ),
					result  => q(ḥ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ሕ),
					result  => q(ḥ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሕ),
					result  => q(ḥ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሖ),
					result  => q(ḥ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሗ),
					result  => q(ḥ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(መ),
					result  => q(m\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሙ),
					result  => q(m\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሚ),
					result  => q(m\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ማ),
					result  => q(m\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሜ),
					result  => q(m\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ም),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ም),
					result  => q(m\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሞ),
					result  => q(m\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሟ),
					result  => q(m\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፙ),
					result  => q(my\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሠ),
					result  => q(ś\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሡ),
					result  => q(ś\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሢ),
					result  => q(ś\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሣ),
					result  => q(ś\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሤ),
					result  => q(ś\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ሥ),
					result  => q(ś),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሥ),
					result  => q(ś\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሦ),
					result  => q(ś\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሧ),
					result  => q(ś\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ረ),
					result  => q(r\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሩ),
					result  => q(r\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሪ),
					result  => q(r\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ራ),
					result  => q(r\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሬ),
					result  => q(r\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ር),
					result  => q(r),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ር),
					result  => q(r\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሮ),
					result  => q(r\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሯ),
					result  => q(r\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፘ),
					result  => q(ry\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሰ),
					result  => q(s\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሱ),
					result  => q(s\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሲ),
					result  => q(s\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሳ),
					result  => q(s\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሴ),
					result  => q(s\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ስ),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ስ),
					result  => q(s\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሶ),
					result  => q(s\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሷ),
					result  => q(s\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሸ),
					result  => q(š\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሹ),
					result  => q(š\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሺ),
					result  => q(š\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሻ),
					result  => q(š\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሼ),
					result  => q(š\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ሽ),
					result  => q(š),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሽ),
					result  => q(š\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሾ),
					result  => q(š\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሿ),
					result  => q(š\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቐ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቑ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቒ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቓ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቔ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ቕ),
					result  => q(q̌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቕ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቖ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቘ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቝ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቚ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቛ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቜ),
					result  => q(q̌\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቀ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቁ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቂ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቃ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቄ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ቅ),
					result  => q(q),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቅ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቆ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቈ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቍ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቊ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቋ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቌ),
					result  => q(q\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(በ),
					result  => q(b\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቡ),
					result  => q(b\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቢ),
					result  => q(b\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ባ),
					result  => q(b\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቤ),
					result  => q(b\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ብ),
					result  => q(b),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ብ),
					result  => q(b\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቦ),
					result  => q(b\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቧ),
					result  => q(b\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቨ),
					result  => q(v\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቩ),
					result  => q(v\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቪ),
					result  => q(v\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቫ),
					result  => q(v\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቬ),
					result  => q(v\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ቭ),
					result  => q(v),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቭ),
					result  => q(v\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቮ),
					result  => q(v\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቯ),
					result  => q(v\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ተ),
					result  => q(t\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቱ),
					result  => q(t\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቲ),
					result  => q(t\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ታ),
					result  => q(t\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቴ),
					result  => q(t\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ት),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ት),
					result  => q(t\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቶ),
					result  => q(t\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቷ),
					result  => q(t\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጨ),
					result  => q(č̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጩ),
					result  => q(č̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጪ),
					result  => q(č̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጫ),
					result  => q(č̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጬ),
					result  => q(č̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጭ),
					result  => q(č̣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጭ),
					result  => q(č̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጮ),
					result  => q(č̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጯ),
					result  => q(č̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቸ),
					result  => q(č\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቹ),
					result  => q(č\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቺ),
					result  => q(č\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቻ),
					result  => q(č\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቼ),
					result  => q(č\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ች),
					result  => q(č),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ች),
					result  => q(č\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቾ),
					result  => q(č\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቿ),
					result  => q(č\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኀ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኁ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኂ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኃ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኄ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ኅ),
					result  => q(ḫ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኅ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኆ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኈ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኍ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኊ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኋ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኌ),
					result  => q(ḫ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ነ),
					result  => q(n\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኑ),
					result  => q(n\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኒ),
					result  => q(n\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ና),
					result  => q(n\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኔ),
					result  => q(n\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ን),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ን),
					result  => q(n\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኖ),
					result  => q(n\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኗ),
					result  => q(n\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኘ),
					result  => q(ñ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኙ),
					result  => q(ñ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኚ),
					result  => q(ñ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኛ),
					result  => q(ñ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኜ),
					result  => q(ñ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ኝ),
					result  => q(ñ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኝ),
					result  => q(ñ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኞ),
					result  => q(ñ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኟ),
					result  => q(ñ\'),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(አ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኡ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኢ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኣ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኤ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(እ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኦ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኧ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(አ),
					result  => q(ʾ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኡ),
					result  => q(ʾ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኢ),
					result  => q(ʾ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኣ),
					result  => q(ʾ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኤ),
					result  => q(ʾ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(እ),
					result  => q(ʾ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኦ),
					result  => q(ʾ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኧ),
					result  => q(ʾ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ከ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኩ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኪ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ካ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኬ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ክ),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ክ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኮ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኰ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኵ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኲ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኳ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኴ),
					result  => q(k\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኸ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኹ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኺ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኻ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኼ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ኽ),
					result  => q(x),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኽ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኾ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዀ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዅ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዂ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዃ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዄ),
					result  => q(x\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ወ),
					result  => q(w\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዉ),
					result  => q(w\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዊ),
					result  => q(w\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዋ),
					result  => q(w\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዌ),
					result  => q(w\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ው),
					result  => q(w),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ው),
					result  => q(w\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዎ),
					result  => q(w\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዐ),
					result  => q(ʿ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዑ),
					result  => q(ʿ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዒ),
					result  => q(ʿ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዓ),
					result  => q(ʿ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዔ),
					result  => q(ʿ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዕ),
					result  => q(ʿ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዖ),
					result  => q(ʿ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዘ),
					result  => q(z\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዙ),
					result  => q(z\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዚ),
					result  => q(z\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዛ),
					result  => q(z\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዜ),
					result  => q(z\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ዝ),
					result  => q(z),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዝ),
					result  => q(z\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዞ),
					result  => q(z\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዟ),
					result  => q(z\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዠ),
					result  => q(ž\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዡ),
					result  => q(ž\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዢ),
					result  => q(ž\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዣ),
					result  => q(ž\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዤ),
					result  => q(ž\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ዥ),
					result  => q(ž),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዥ),
					result  => q(ž\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዦ),
					result  => q(ž\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዧ),
					result  => q(ž\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(የ),
					result  => q(y\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዩ),
					result  => q(y\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዪ),
					result  => q(y\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ያ),
					result  => q(y\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዬ),
					result  => q(y\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ይ),
					result  => q(y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ይ),
					result  => q(y\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዮ),
					result  => q(y\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ደ),
					result  => q(d\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዱ),
					result  => q(d\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዲ),
					result  => q(d\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዳ),
					result  => q(d\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዴ),
					result  => q(d\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ድ),
					result  => q(d),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ድ),
					result  => q(d\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዶ),
					result  => q(d\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዷ),
					result  => q(d\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጀ),
					result  => q(j\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጁ),
					result  => q(j\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጂ),
					result  => q(j\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጃ),
					result  => q(j\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጄ),
					result  => q(j\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጅ),
					result  => q(j),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጅ),
					result  => q(j\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጆ),
					result  => q(j\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጇ),
					result  => q(j\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ገ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጉ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጊ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጋ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጌ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ግ),
					result  => q(g),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ግ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጎ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጐ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጕ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጒ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጓ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጔ),
					result  => q(g\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጘ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጙ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጚ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጛ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጜ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጝ),
					result  => q(ŋ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጝ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጞ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ⶓ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ⶖ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ⶔ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጟ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ⶕ),
					result  => q(ŋ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጠ),
					result  => q(ṭ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጡ),
					result  => q(ṭ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጢ),
					result  => q(ṭ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጣ),
					result  => q(ṭ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጤ),
					result  => q(ṭ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጥ),
					result  => q(ṭ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጥ),
					result  => q(ṭ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጦ),
					result  => q(ṭ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጧ),
					result  => q(ṭ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጰ),
					result  => q(p̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጱ),
					result  => q(p̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጲ),
					result  => q(p̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጳ),
					result  => q(p̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጴ),
					result  => q(p̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጵ),
					result  => q(p̣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጵ),
					result  => q(p̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጶ),
					result  => q(p̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጷ),
					result  => q(p̣\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፀ),
					result  => q(ẓ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፁ),
					result  => q(ẓ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፂ),
					result  => q(ẓ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፃ),
					result  => q(ẓ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፄ),
					result  => q(ẓ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ፅ),
					result  => q(ẓ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፅ),
					result  => q(ẓ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፆ),
					result  => q(ẓ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጸ),
					result  => q(ṣ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጹ),
					result  => q(ṣ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጺ),
					result  => q(ṣ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጻ),
					result  => q(ṣ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጼ),
					result  => q(ṣ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጽ),
					result  => q(ṣ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጽ),
					result  => q(ṣ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጾ),
					result  => q(ṣ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጿ),
					result  => q(ṣ\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፈ),
					result  => q(f\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፉ),
					result  => q(f\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፊ),
					result  => q(f\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፋ),
					result  => q(f\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፌ),
					result  => q(f\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ፍ),
					result  => q(f),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፍ),
					result  => q(f\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፎ),
					result  => q(f\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፏ),
					result  => q(f\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፚ),
					result  => q(fy\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፐ),
					result  => q(p\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፑ),
					result  => q(p\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፒ),
					result  => q(p\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፓ),
					result  => q(p\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፔ),
					result  => q(p\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ፕ),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፕ),
					result  => q(p\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፖ),
					result  => q(p\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፗ),
					result  => q(p\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፳),
					result  => q(20),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፴),
					result  => q(30),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፵),
					result  => q(40),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፶),
					result  => q(50),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፷),
					result  => q(60),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፸),
					result  => q(70),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፹),
					result  => q(80),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፺),
					result  => q(90),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፪),
					result  => q(2),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፫),
					result  => q(3),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፬),
					result  => q(4),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፭),
					result  => q(5),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፮),
					result  => q(6),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፯),
					result  => q(7),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፰),
					result  => q(8),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፱),
					result  => q(9),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፼),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፻),
					result  => q(100),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፲),
					result  => q(10),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፩),
					result  => q(1),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(።),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፣),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፥),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፦),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፤),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፡),
					result  => q(\'),
					revisit => 0,
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
