package Locale::CLDR::Transformations::Any::Es_fonipa::Zh;
# This file auto generated from Data\common\transforms\es_FONIPA-zh.xml
#	on Wed 28 Feb 12:16:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^um:\G.)/,
		{
			type => 'transform',
			data => [
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(ð),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɣ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ŋ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(θ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɾ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ff),
					result  => q(f),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kk),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mm),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nn),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pp),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tt),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tʧ),
					result  => q(ʧ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(aa),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(oi̯),
					result  => q(oi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(oo),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(uu),
					result  => q(u),
					revisit => 0,
				},
				{
					before  => q([^dgktx]),
					after   => q(),
					replace => q(ei̯),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q([^-\ .$]),
					after   => q(),
					replace => q(eu̯),
					result  => q(eu),
					revisit => 0,
				},
				{
					before  => q([^-\ .$]),
					after   => q(),
					replace => q(ou̯),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q([^j]),
					after   => q(),
					replace => q(ui),
					result  => q(wi),
					revisit => 0,
				},
				{
					before  => q([^[-\ $]]),
					after   => q([bp]),
					replace => q(m),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(s[θs]),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q([^ʧ]),
					after   => q(),
					replace => q(jo),
					result  => q(io),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(Null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(an[^[aeijouw]]),
					replace => q(j),
					result  => q(i),
					revisit => 0,
				},
				{
					before  => q([g.$]),
					after   => q(),
					replace => q(wai̯),
					result  => q(wai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(wai̯),
					result  => q(uai̯),
					revisit => 0,
				},
				{
					before  => q([g.$]),
					after   => q(),
					replace => q(wau̯),
					result  => q(wau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(wau̯),
					result  => q(uau̯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(jau̯),
					result  => q(iau̯),
					revisit => 0,
				},
				{
					before  => q([^jw]),
					after   => q([^n]),
					replace => q(ao),
					result  => q(au̯),
					revisit => 0,
				},
				{
					before  => q([^jw]),
					after   => q(n[aeijouw]),
					replace => q(ao),
					result  => q(au̯),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(Null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(\'),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ai̯),
					result  => q(艾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(an),
					result  => q(安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(au̯),
					result  => q(奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(a),
					result  => q(阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bai̯),
					result  => q(拜),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ban),
					result  => q(班),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bau̯),
					result  => q(包),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ba),
					result  => q(巴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ben),
					result  => q(本),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(be),
					result  => q(贝),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(bin),
					result  => q(宾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bi),
					result  => q(比),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bja),
					result  => q(比亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(bjen),
					result  => q(比恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bje),
					result  => q(别),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bju),
					result  => q(比乌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(bon),
					result  => q(邦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bo),
					result  => q(博),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(bun),
					result  => q(本),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bu),
					result  => q(布),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(bwan),
					result  => q(布安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bwa),
					result  => q(布阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(bwen),
					result  => q(布恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bwe),
					result  => q(布埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(bwin),
					result  => q(布因),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bwi),
					result  => q(布伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bwo),
					result  => q(博),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(b),
					result  => q(布),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βai̯),
					result  => q(瓦伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(βan),
					result  => q(万),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βau̯),
					result  => q(沃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βa),
					result  => q(瓦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(βen),
					result  => q(文),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βe),
					result  => q(韦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(βin),
					result  => q(温),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βi),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βja),
					result  => q(维亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(βjen),
					result  => q(维恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βje),
					result  => q(维耶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βju),
					result  => q(维乌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(βon),
					result  => q(翁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βo),
					result  => q(沃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(βun),
					result  => q(文),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βu),
					result  => q(武),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(βwan),
					result  => q(万),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βwa),
					result  => q(瓦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(βwen),
					result  => q(文),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βwe),
					result  => q(武埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βwi),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(βwo),
					result  => q(沃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(β),
					result  => q(夫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dai̯),
					result  => q(代),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(dan),
					result  => q(丹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dau̯),
					result  => q(道),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(da),
					result  => q(达),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dei̯),
					result  => q(代),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(den),
					result  => q(登),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(de),
					result  => q(德),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(din),
					result  => q(丁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(di),
					result  => q(迪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dja),
					result  => q(迪亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(djen),
					result  => q(迪恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dje),
					result  => q(迭),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dju),
					result  => q(迪乌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(don),
					result  => q(东),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(do),
					result  => q(多),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(dun),
					result  => q(敦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(du),
					result  => q(杜),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(dwan),
					result  => q(端),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dwa),
					result  => q(杜阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(dwen),
					result  => q(敦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dwe),
					result  => q(杜埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dwi),
					result  => q(杜伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dwo),
					result  => q(多),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([-\ $]),
					replace => q(d),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d),
					result  => q(德),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ei̯),
					result  => q(埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(en),
					result  => q(恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(eu̯),
					result  => q(欧),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(e),
					result  => q(埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fai̯),
					result  => q(法伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(fan),
					result  => q(凡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fau̯),
					result  => q(福),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fa),
					result  => q(法),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fe),
					result  => q(费),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(fin),
					result  => q(芬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fi),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fja),
					result  => q(菲亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(fjen),
					result  => q(菲恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fje),
					result  => q(菲耶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fju),
					result  => q(菲乌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(fon),
					result  => q(丰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fo),
					result  => q(福),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(fun),
					result  => q(丰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fu),
					result  => q(富),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(fwan),
					result  => q(富安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fwa),
					result  => q(富阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(fwen),
					result  => q(丰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fwe),
					result  => q(富埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fwi),
					result  => q(富伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fwo),
					result  => q(福),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([-\ $]),
					replace => q(f),
					result  => q(夫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(f),
					result  => q(弗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gai̯),
					result  => q(盖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(gan),
					result  => q(甘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gau̯),
					result  => q(高),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ga),
					result  => q(加),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gei̯),
					result  => q(盖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(gen),
					result  => q(根),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ge),
					result  => q(格),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(gin),
					result  => q(金),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gi),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gja),
					result  => q(吉亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(gjen),
					result  => q(吉恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gje),
					result  => q(吉耶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gju),
					result  => q(吉乌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(gon),
					result  => q(贡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(go),
					result  => q(戈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(gun),
					result  => q(贡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gu),
					result  => q(古),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([$]),
					replace => q(gwan),
					result  => q(古安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(gwan),
					result  => q(关),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gwa),
					result  => q(瓜),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(gwen),
					result  => q(古恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gwe),
					result  => q(圭),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gwi),
					result  => q(圭),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gwo),
					result  => q(果),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(g),
					result  => q(格),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(in),
					result  => q(因),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(i),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝai̯),
					result  => q(亚伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʝan),
					result  => q(扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝau̯),
					result  => q(尧),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝa),
					result  => q(亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʝen),
					result  => q(延),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝe),
					result  => q(耶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʝin),
					result  => q(因),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝi),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʝon),
					result  => q(永),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝo),
					result  => q(约),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʝun),
					result  => q(云),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝu),
					result  => q(尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʝwan),
					result  => q(元),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝwa),
					result  => q(尤阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʝwen),
					result  => q(云),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝwe),
					result  => q(尤埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝwi),
					result  => q(尤伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝwo),
					result  => q(约),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʝ),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kai̯),
					result  => q(凯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(kan),
					result  => q(坎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kau̯),
					result  => q(考),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ka),
					result  => q(卡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kei̯),
					result  => q(凯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ken),
					result  => q(肯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ke),
					result  => q(克),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(kin),
					result  => q(金),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ki),
					result  => q(基),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kja),
					result  => q(基亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(kjen),
					result  => q(基恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kje),
					result  => q(基耶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kju),
					result  => q(基乌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(kon),
					result  => q(孔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ko),
					result  => q(科),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(kun),
					result  => q(昆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ku),
					result  => q(库),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(kwan),
					result  => q(宽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kwa),
					result  => q(夸),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(kwen),
					result  => q(昆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kwe),
					result  => q(库埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(kwin),
					result  => q(昆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kwi),
					result  => q(奎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kwo),
					result  => q(阔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(k),
					result  => q(克),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^n]),
					replace => q(lae),
					result  => q(莱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lai̯),
					result  => q(莱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(lan),
					result  => q(兰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lau̯),
					result  => q(劳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(la),
					result  => q(拉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(len),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(le),
					result  => q(莱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(lin),
					result  => q(林),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(li),
					result  => q(利),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lja),
					result  => q(利亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ljen),
					result  => q(连),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lje),
					result  => q(列),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lju),
					result  => q(柳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(lon),
					result  => q(隆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lo),
					result  => q(洛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(lun),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lu),
					result  => q(卢),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(lwan),
					result  => q(卢安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lwa),
					result  => q(卢阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(lwen),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lwe),
					result  => q(卢埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lwi),
					result  => q(卢伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lwo),
					result  => q(洛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(l),
					result  => q(尔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʎan),
					result  => q(良),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎau̯),
					result  => q(廖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎa),
					result  => q(利亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʎen),
					result  => q(连),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎe),
					result  => q(列),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʎin),
					result  => q(林),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎi),
					result  => q(利),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʎon),
					result  => q(利翁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎo),
					result  => q(略),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎu),
					result  => q(柳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʎwan),
					result  => q(柳安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎwa),
					result  => q(柳阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʎwen),
					result  => q(柳恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎwe),
					result  => q(柳埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎwi),
					result  => q(柳伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎwo),
					result  => q(略),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎ),
					result  => q(尔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mai̯),
					result  => q(迈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(man),
					result  => q(曼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(martin),
					result  => q(马丁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mau̯),
					result  => q(毛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ma),
					result  => q(马),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(men),
					result  => q(门),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(me),
					result  => q(梅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(min),
					result  => q(明),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mi),
					result  => q(米),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mja),
					result  => q(米亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(mjen),
					result  => q(缅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mje),
					result  => q(米耶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mju),
					result  => q(缪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(mon),
					result  => q(蒙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mo),
					result  => q(莫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(mun),
					result  => q(蒙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mu),
					result  => q(穆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(mwan),
					result  => q(穆安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mwa),
					result  => q(穆阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(mwen),
					result  => q(门),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mwe),
					result  => q(穆埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(mwin),
					result  => q(穆因),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mwi),
					result  => q(穆伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mwo),
					result  => q(莫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(m),
					result  => q(姆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nai̯),
					result  => q(奈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(nan),
					result  => q(南),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nau̯),
					result  => q(瑙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(na),
					result  => q(纳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(nen),
					result  => q(嫩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ne),
					result  => q(内),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(nin),
					result  => q(宁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ni),
					result  => q(尼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nja),
					result  => q(尼亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(njen),
					result  => q(年),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nje),
					result  => q(涅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nju),
					result  => q(纽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(non),
					result  => q(农),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(no),
					result  => q(诺),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(nun),
					result  => q(嫩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nu),
					result  => q(努),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(nwan),
					result  => q(努安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nwa),
					result  => q(努阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(nwen),
					result  => q(农),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nwe),
					result  => q(努埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nwi),
					result  => q(努伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nwo),
					result  => q(诺),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(n),
					result  => q(恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ɲan),
					result  => q(尼扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲau̯),
					result  => q(尼奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲa),
					result  => q(尼亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ɲen),
					result  => q(年),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲe),
					result  => q(涅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ɲin),
					result  => q(宁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲi),
					result  => q(尼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ɲon),
					result  => q(尼翁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲo),
					result  => q(尼奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲu),
					result  => q(纽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ɲwan),
					result  => q(纽安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲwa),
					result  => q(纽阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ɲwen),
					result  => q(纽恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲwe),
					result  => q(纽埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲwi),
					result  => q(纽伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲwo),
					result  => q(尼奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(on),
					result  => q(翁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ou̯),
					result  => q(欧),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(o),
					result  => q(奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pai̯),
					result  => q(派),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(pan),
					result  => q(潘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pau̯),
					result  => q(保),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pa),
					result  => q(帕),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(pen),
					result  => q(彭),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pe),
					result  => q(佩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(pin),
					result  => q(平),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pi),
					result  => q(皮),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pja),
					result  => q(皮亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(pjen),
					result  => q(皮恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pje),
					result  => q(彼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pju),
					result  => q(皮乌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(pon),
					result  => q(蓬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(po),
					result  => q(波),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(pun),
					result  => q(蓬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pu),
					result  => q(普),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(pwan),
					result  => q(普安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pwa),
					result  => q(普阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(pwen),
					result  => q(蓬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pwe),
					result  => q(普埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pwi),
					result  => q(普伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pwo),
					result  => q(波),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(p),
					result  => q(普),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rai̯),
					result  => q(赖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ran),
					result  => q(兰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rau̯),
					result  => q(劳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ra),
					result  => q(拉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ren),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(re),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(rin),
					result  => q(林),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ri),
					result  => q(里),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rja),
					result  => q(里亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(rjen),
					result  => q(连),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rje),
					result  => q(列),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rju),
					result  => q(留),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ron),
					result  => q(龙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ro),
					result  => q(罗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(run),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ru),
					result  => q(鲁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(rwan),
					result  => q(鲁安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rwa),
					result  => q(鲁阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(rwen),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rwe),
					result  => q(鲁埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rwi),
					result  => q(鲁伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rwo),
					result  => q(罗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(r),
					result  => q(R),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sai̯),
					result  => q(赛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(san),
					result  => q(桑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sau̯),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sa),
					result  => q(萨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(sen),
					result  => q(森),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(se),
					result  => q(塞),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(sin),
					result  => q(辛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(si),
					result  => q(西),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sja),
					result  => q(西亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(sjen),
					result  => q(先),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sje),
					result  => q(谢),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sju),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(son),
					result  => q(松),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(so),
					result  => q(索),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(sun),
					result  => q(孙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(su),
					result  => q(苏),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(swan),
					result  => q(苏安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(swa),
					result  => q(苏阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(swen),
					result  => q(孙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(swe),
					result  => q(苏埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(swi),
					result  => q(绥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(swo),
					result  => q(索),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(s),
					result  => q(斯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tai̯),
					result  => q(泰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(tan),
					result  => q(坦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tau̯),
					result  => q(陶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ta),
					result  => q(塔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tei̯),
					result  => q(泰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ten),
					result  => q(滕),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(te),
					result  => q(特),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(tin),
					result  => q(廷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ti),
					result  => q(蒂),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tja),
					result  => q(蒂亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(tjen),
					result  => q(蒂恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tje),
					result  => q(铁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tju),
					result  => q(蒂乌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ton),
					result  => q(通),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(to),
					result  => q(托),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tsa),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(tsen),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tse),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(tsin),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tsi),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tso),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(tsun),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tsu),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ts),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(tun),
					result  => q(通),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tu),
					result  => q(图),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(twan),
					result  => q(图安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(twa),
					result  => q(图阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(twen),
					result  => q(通),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(twe),
					result  => q(图埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(twi),
					result  => q(图伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(two),
					result  => q(托),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t),
					result  => q(特),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧai̯),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʧan),
					result  => q(钱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧau̯),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧa),
					result  => q(查),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʧen),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧe),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʧin),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧi),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʧjan),
					result  => q(钱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧja),
					result  => q(恰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʧjen),
					result  => q(钱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧje),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʧjon),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧju),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʧon),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧo),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʧun),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧu),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʧwan),
					result  => q(丘安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧwa),
					result  => q(丘阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(ʧwen),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧwe),
					result  => q(丘埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧwi),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧwo),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʧ),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(un),
					result  => q(温),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(u),
					result  => q(乌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(wan),
					result  => q(万),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(wa),
					result  => q(瓦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(wen),
					result  => q(温),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(we),
					result  => q(韦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(win),
					result  => q(温),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(wi),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(won),
					result  => q(翁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(wo),
					result  => q(沃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xai̯),
					result  => q(海),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(xan),
					result  => q(汉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xau̯),
					result  => q(豪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xa),
					result  => q(哈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xei̯),
					result  => q(黑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(xen),
					result  => q(亨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xe),
					result  => q(赫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(xin),
					result  => q(欣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xi),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xja),
					result  => q(希亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(xjen),
					result  => q(希恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xje),
					result  => q(希耶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xju),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(xon),
					result  => q(洪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xo),
					result  => q(霍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(xun),
					result  => q(洪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xu),
					result  => q(胡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(xwan),
					result  => q(胡安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xwa),
					result  => q(华),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[aeijouw]]),
					replace => q(xwen),
					result  => q(洪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xwe),
					result  => q(胡埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xwi),
					result  => q(惠),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xwo),
					result  => q(霍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(x),
					result  => q(赫),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(Null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(R),
					result  => q(尔),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(Null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q([-\ $]),
					after   => q(),
					replace => q(东),
					result  => q(栋),
					revisit => 0,
				},
				{
					before  => q([-\ $]),
					after   => q(),
					replace => q(南),
					result  => q(楠),
					revisit => 0,
				},
				{
					before  => q([-\ $]),
					after   => q(),
					replace => q(西),
					result  => q(锡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([-\ $]),
					replace => q(海),
					result  => q(亥),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
