package Locale::CLDR::Transformations::Alaloc::Ethi::Latn;
# This file auto generated from Data\common\transforms\und-Ethi-t-und-latn-m0-alaloc.xml
#	on Thu 25 Jan  8:49:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^umi:\G\p{Ethiopic})/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFD),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(([ሀ-ሇ])፟),
					result  => q(h),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ለ-ሏⶀ])፟),
					result  => q(l),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ሐ-ሗ])፟),
					result  => q(ḥ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([መ-ሟⶁᎀ-ᎃፙ])፟),
					result  => q(m),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ሠ-ሧ])፟),
					result  => q(ś),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ረ-ሯⶂፘ])፟),
					result  => q(r),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ሰ-ሷⶃ])፟),
					result  => q(s),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ሸ-ሿⶄ])፟),
					result  => q(š),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ቀ-ቍ])፟),
					result  => q(q),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ቐ-ቝ])፟),
					result  => q(q̄),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([በ-ቧⶅᎄ-ᎇ])፟),
					result  => q(b),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ቨ-ቯ])፟),
					result  => q(v),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ተ-ቷ])፟),
					result  => q(t),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ቸ-ቿ])፟),
					result  => q(c),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ኀ-ኍ])፟),
					result  => q(ẖ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ነ-ኗ])፟),
					result  => q(n),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ኘ-ኟ])፟),
					result  => q(ñ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ከ-ኵ])፟),
					result  => q(k),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ኸ-ዅ])፟),
					result  => q(x),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ወ-ዏ])፟),
					result  => q(w),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ዘ-ዟⶋ])፟),
					result  => q(z),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ዠ-ዧ])፟),
					result  => q(ž),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([የ-ዯ])፟),
					result  => q(y),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ደ-ዷⶌ])፟),
					result  => q(d),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ጀ-ጇⶎ])፟),
					result  => q(ǧ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ገ-ጕጏ])፟),
					result  => q(g),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ጠ-ጧⶏ])፟),
					result  => q(ṭ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ጨ-ጯⶐ])፟),
					result  => q(ċ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ጰ-ጷⶑ])፟),
					result  => q(p̣),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ጸ-ጿ])፟),
					result  => q(ṣ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ፀ-ፇ])፟),
					result  => q(ṡ),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ፈ-ፏፚᎈ-ᎋ])፟),
					result  => q(f),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([ፐ-ፗᎌ-ᎏ])፟),
					result  => q(p),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፟),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሐ),
					result  => q(ḥa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሑ),
					result  => q(ḥu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሒ),
					result  => q(ḥi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሓ),
					result  => q(ḥā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሔ),
					result  => q(ḥé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ሕ),
					result  => q(ḥ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሕ),
					result  => q(ḥe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሖ),
					result  => q(ḥo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሗ),
					result  => q(ḥwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ለ),
					result  => q(la),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሉ),
					result  => q(lu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሊ),
					result  => q(li),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ላ),
					result  => q(lā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሌ),
					result  => q(lé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ል),
					result  => q(l),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ል),
					result  => q(le),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሎ),
					result  => q(lo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሏ),
					result  => q(lwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(መ),
					result  => q(ma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሙ),
					result  => q(mu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሚ),
					result  => q(mi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ማ),
					result  => q(mā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሜ),
					result  => q(mé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ም),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ም),
					result  => q(me),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሞ),
					result  => q(mo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፙ),
					result  => q(mya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሟ),
					result  => q(mwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሠ),
					result  => q(śa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሡ),
					result  => q(śu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሢ),
					result  => q(śi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሣ),
					result  => q(śā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሤ),
					result  => q(śé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሦ),
					result  => q(śo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ሥ),
					result  => q(ś),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሥ),
					result  => q(śe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሧ),
					result  => q(śwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ረ),
					result  => q(ra),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሩ),
					result  => q(ru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሪ),
					result  => q(ri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ራ),
					result  => q(rā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሬ),
					result  => q(ré),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ር),
					result  => q(r),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ር),
					result  => q(re),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሮ),
					result  => q(ro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሯ),
					result  => q(rwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፘ),
					result  => q(rya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሸ),
					result  => q(ša),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሹ),
					result  => q(šu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሺ),
					result  => q(ši),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሻ),
					result  => q(šā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሼ),
					result  => q(šé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ሽ),
					result  => q(š),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሽ),
					result  => q(še),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሾ),
					result  => q(šo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሿ),
					result  => q(šwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሰ),
					result  => q(sa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሱ),
					result  => q(su),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሲ),
					result  => q(si),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሳ),
					result  => q(sā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሴ),
					result  => q(sé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ስ),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ስ),
					result  => q(se),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሶ),
					result  => q(so),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሷ),
					result  => q(swā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቐ),
					result  => q(q̄a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቑ),
					result  => q(q̄u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቒ),
					result  => q(q̄i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቓ),
					result  => q(q̄ā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቔ),
					result  => q(q̄é),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ቕ),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቕ),
					result  => q(q̄e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቖ),
					result  => q(q̄o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቘ),
					result  => q(q̄wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቝ),
					result  => q(q̄we),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቚ),
					result  => q(q̄wi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቛ),
					result  => q(q̄wā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቜ),
					result  => q(q̄wé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቀ),
					result  => q(qa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቁ),
					result  => q(qu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቂ),
					result  => q(qi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቃ),
					result  => q(qā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቄ),
					result  => q(qé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ቅ),
					result  => q(q),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቅ),
					result  => q(qe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቆ),
					result  => q(qo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቈ),
					result  => q(qwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቍ),
					result  => q(qwe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቊ),
					result  => q(qwi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቋ),
					result  => q(qwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቌ),
					result  => q(qwé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(በ),
					result  => q(ba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቡ),
					result  => q(bu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቢ),
					result  => q(bi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ባ),
					result  => q(bā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቤ),
					result  => q(bé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ብ),
					result  => q(b),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ብ),
					result  => q(be),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቦ),
					result  => q(bo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቧ),
					result  => q(bwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቨ),
					result  => q(va),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቩ),
					result  => q(vu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቪ),
					result  => q(vi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቫ),
					result  => q(vā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቬ),
					result  => q(vé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ቭ),
					result  => q(v),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቭ),
					result  => q(ve),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቮ),
					result  => q(vo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቯ),
					result  => q(vwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጠ),
					result  => q(ṭa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጡ),
					result  => q(ṭu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጢ),
					result  => q(ṭi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጣ),
					result  => q(ṭā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጤ),
					result  => q(ṭé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጥ),
					result  => q(ṭ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጥ),
					result  => q(ṭe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጦ),
					result  => q(ṭo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጧ),
					result  => q(ṭwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ተ),
					result  => q(ta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቱ),
					result  => q(tu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቲ),
					result  => q(ti),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ታ),
					result  => q(tā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቴ),
					result  => q(té),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ት),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ት),
					result  => q(te),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቶ),
					result  => q(to),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቷ),
					result  => q(twā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጨ),
					result  => q(ċa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጩ),
					result  => q(ċu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጪ),
					result  => q(ċi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጫ),
					result  => q(ċā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጬ),
					result  => q(ċé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጭ),
					result  => q(ċ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጭ),
					result  => q(ċe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጮ),
					result  => q(ċo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጯ),
					result  => q(ċwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቸ),
					result  => q(ca),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቹ),
					result  => q(cu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቺ),
					result  => q(ci),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቻ),
					result  => q(cā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቼ),
					result  => q(cé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ች),
					result  => q(c),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ች),
					result  => q(ce),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቾ),
					result  => q(co),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቿ),
					result  => q(cwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኀ),
					result  => q(ẖa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኁ),
					result  => q(ẖu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኂ),
					result  => q(ẖi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኃ),
					result  => q(ẖā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኄ),
					result  => q(ẖé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ኅ),
					result  => q(ẖ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኅ),
					result  => q(ẖe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኆ),
					result  => q(ẖo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኈ),
					result  => q(ẖwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኍ),
					result  => q(ẖwe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኊ),
					result  => q(ẖwi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኋ),
					result  => q(ẖwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኌ),
					result  => q(ẖwé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሀ),
					result  => q(ha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሁ),
					result  => q(hu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሂ),
					result  => q(hi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሃ),
					result  => q(hā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሄ),
					result  => q(hé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ህ),
					result  => q(h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ህ),
					result  => q(he),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሆ),
					result  => q(ho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኘ),
					result  => q(ña),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኙ),
					result  => q(ñu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኚ),
					result  => q(ñi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኛ),
					result  => q(ñā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኜ),
					result  => q(ñé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ኝ),
					result  => q(ñ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኝ),
					result  => q(ñe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኞ),
					result  => q(ño),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኟ),
					result  => q(ñwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ነ),
					result  => q(na),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኑ),
					result  => q(nu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኔ),
					result  => q(né),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኒ),
					result  => q(ni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ና),
					result  => q(nā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኖ),
					result  => q(no),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ን),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ን),
					result  => q(ne),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኗ),
					result  => q(nwā),
					revisit => 0,
				},
				{
					before  => q([^:Letter:]),
					after   => q(),
					replace => q(ኣ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኧ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^:Letter:]),
					after   => q(),
					replace => q(አ),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኡ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኤ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኢ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(እ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኦ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኣ),
					result  => q(\ʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(አ),
					result  => q(\ʼa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኡ),
					result  => q(\ʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኤ),
					result  => q(\ʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኢ),
					result  => q(\ʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(እ),
					result  => q(\ʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኦ),
					result  => q(\ʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኧ),
					result  => q(\ʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ከ),
					result  => q(ka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኩ),
					result  => q(ku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኪ),
					result  => q(ki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ካ),
					result  => q(kā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኬ),
					result  => q(ké),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ክ),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ክ),
					result  => q(ke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኮ),
					result  => q(ko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኰ),
					result  => q(kwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኵ),
					result  => q(kwe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኲ),
					result  => q(kwi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኳ),
					result  => q(kwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኴ),
					result  => q(kwé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኸ),
					result  => q(xa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኹ),
					result  => q(xu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኺ),
					result  => q(xi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኻ),
					result  => q(xā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኼ),
					result  => q(xé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ኽ),
					result  => q(x),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኽ),
					result  => q(xe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኾ),
					result  => q(xo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዀ),
					result  => q(xwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዅ),
					result  => q(xwe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዂ),
					result  => q(xwi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዃ),
					result  => q(xwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዄ),
					result  => q(xwé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ወ),
					result  => q(wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዉ),
					result  => q(wu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዊ),
					result  => q(wi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዋ),
					result  => q(wā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዌ),
					result  => q(wé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ው),
					result  => q(w),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ው),
					result  => q(we),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዎ),
					result  => q(wo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዐ),
					result  => q(\ʻa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዑ),
					result  => q(\ʻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዒ),
					result  => q(\ʻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዓ),
					result  => q(\ʻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዔ),
					result  => q(\ʻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዕ),
					result  => q(\ʻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዖ),
					result  => q(\ʻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዘ),
					result  => q(za),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዙ),
					result  => q(zu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዚ),
					result  => q(zi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዛ),
					result  => q(zā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዜ),
					result  => q(zé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ዝ),
					result  => q(z),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዝ),
					result  => q(ze),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዞ),
					result  => q(zo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዟ),
					result  => q(zwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዠ),
					result  => q(ža),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዡ),
					result  => q(žu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዢ),
					result  => q(ži),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዣ),
					result  => q(žā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዤ),
					result  => q(žé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ዥ),
					result  => q(ž),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዥ),
					result  => q(že),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዦ),
					result  => q(žo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዧ),
					result  => q(žwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(የ),
					result  => q(ya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዩ),
					result  => q(yu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዪ),
					result  => q(yi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ያ),
					result  => q(yā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዬ),
					result  => q(yé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ይ),
					result  => q(y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ይ),
					result  => q(ye),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዮ),
					result  => q(yo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ደ),
					result  => q(da),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዱ),
					result  => q(du),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዲ),
					result  => q(di),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዳ),
					result  => q(dā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዴ),
					result  => q(dé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ድ),
					result  => q(d),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ድ),
					result  => q(de),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዶ),
					result  => q(do),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዷ),
					result  => q(dwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጀ),
					result  => q(ǧa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጁ),
					result  => q(ǧu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጂ),
					result  => q(ǧi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጃ),
					result  => q(ǧā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጄ),
					result  => q(ǧé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጅ),
					result  => q(ǧ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጅ),
					result  => q(ǧe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጆ),
					result  => q(ǧo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጇ),
					result  => q(ǧwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ገ),
					result  => q(ga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጉ),
					result  => q(gu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጊ),
					result  => q(gi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጋ),
					result  => q(gā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጌ),
					result  => q(gé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ግ),
					result  => q(g),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ግ),
					result  => q(ge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጎ),
					result  => q(go),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጐ),
					result  => q(gwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጕ),
					result  => q(gwe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጒ),
					result  => q(gwi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጓ),
					result  => q(gwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጔ),
					result  => q(gwé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጰ),
					result  => q(p̣a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጱ),
					result  => q(p̣u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጲ),
					result  => q(p̣i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጳ),
					result  => q(p̣ā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጴ),
					result  => q(p̣é),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጵ),
					result  => q(p̣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጵ),
					result  => q(p̣e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጶ),
					result  => q(p̣o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጷ),
					result  => q(p̣wā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፀ),
					result  => q(ṡa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፁ),
					result  => q(ṡu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፂ),
					result  => q(ṡi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፃ),
					result  => q(ṡā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፄ),
					result  => q(ṡé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ፅ),
					result  => q(ṡ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፅ),
					result  => q(ṡe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፆ),
					result  => q(ṡo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጸ),
					result  => q(ṣa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጹ),
					result  => q(ṣu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጺ),
					result  => q(ṣi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጻ),
					result  => q(ṣā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጼ),
					result  => q(ṣé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ጽ),
					result  => q(ṣ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጽ),
					result  => q(ṣe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጾ),
					result  => q(ṣo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጿ),
					result  => q(ṣwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፈ),
					result  => q(fa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፉ),
					result  => q(fu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፊ),
					result  => q(fi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፋ),
					result  => q(fā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፌ),
					result  => q(fé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ፍ),
					result  => q(f),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፍ),
					result  => q(fe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፎ),
					result  => q(fo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፚ),
					result  => q(fya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፏ),
					result  => q(fwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፐ),
					result  => q(pa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፑ),
					result  => q(pu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፒ),
					result  => q(pi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፓ),
					result  => q(pā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፔ),
					result  => q(pé),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ፕ),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፕ),
					result  => q(pe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፖ),
					result  => q(po),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፗ),
					result  => q(pwā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፼),
					result  => q(10000),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፲፻),
					result  => q(1000),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፻),
					result  => q(100),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፲),
					result  => q(10),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፳),
					result  => q(20),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፴),
					result  => q(30),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፵),
					result  => q(40),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፶),
					result  => q(50),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፷),
					result  => q(60),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፸),
					result  => q(70),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፹),
					result  => q(80),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፺),
					result  => q(90),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፩),
					result  => q(1),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፪),
					result  => q(2),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፫),
					result  => q(3),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፬),
					result  => q(4),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፭),
					result  => q(5),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፮),
					result  => q(6),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፯),
					result  => q(7),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፰),
					result  => q(8),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፱),
					result  => q(9),
					revisit => 0,
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
