package Locale::CLDR::Transformations::Ungegn::Latn::Grek;
# This file auto generated from Data\common\transforms\Greek_Latin_UNGEGN.xml
#	on Sun 16 Dec  4:04:05 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^um:\G.)/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFD),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q([Νν]),
					after   => q([GKXCgkxc]),
					replace => q(\'),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([Ππ]),
					after   => q([Ss]),
					replace => q(\'),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(U),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(W),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q((?:[aeiouyAEIOUY]|(?:[αεηιουω]|[ΑΕΗΙΟΥΩ]))),
					replace => q(U),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q((?:[aeiouyAEIOUY]|(?:[αεηιουω]|[ΑΕΗΙΟΥΩ]))),
					replace => q(W),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Q),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(J),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(C),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(H),
					result  => q(),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(w),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(u),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q((?:[aeiouyAEIOUY]|(?:[αεηιουω]|[ΑΕΗΙΟΥΩ]))),
					replace => q(w),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q((?:[aeiouyAEIOUY]|(?:[αεηιουω]|[ΑΕΗΙΟΥΩ]))),
					replace => q(u),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(q),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(j),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(c),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(h),
					result  => q(),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(CH),
					result  => q(Χ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ch),
					result  => q(Χ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ch),
					result  => q(χ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(F),
					result  => q(Φ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(f),
					result  => q(φ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(T),
					result  => q(Τ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t),
					result  => q(τ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(S),
					result  => q(Σ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(s),
					result  => q(σ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(s̱),
					result  => q(ς),
					revisit => 0,
				},
				{
					before  => q(\p{L} (?:[\']|[\p{Mn}\p{Me}]) *),
					after   => q(),
					replace => q(s),
					result  => q(ς),
					revisit => 0,
				},
				{
					before  => q(\p{L} (?:[\']|[\p{Mn}\p{Me}]) *),
					after   => q(),
					replace => q(s̱),
					result  => q(σ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[\']|[\p{Mn}\p{Me}]) * \p{L}),
					replace => q(s),
					result  => q(σ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[\']|[\p{Mn}\p{Me}]) * \p{L}),
					replace => q(s̱),
					result  => q(ς),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ŝ),
					result  => q(ϻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ŝ),
					result  => q(Ϻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(š),
					result  => q(ϸ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Š),
					result  => q(Ϸ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(R),
					result  => q(Ρ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(r),
					result  => q(ρ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(P),
					result  => q(Π),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(p),
					result  => q(π),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(O),
					result  => q(Ο),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(o),
					result  => q(ο),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(X),
					result  => q(Ξ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(x),
					result  => q(ξ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(N),
					result  => q(Ν),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(N\'),
					result  => q(Ν),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(n),
					result  => q(ν),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(M),
					result  => q(Μ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(m),
					result  => q(μ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(L),
					result  => q(Λ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(l),
					result  => q(λ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(K),
					result  => q(Κ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(k),
					result  => q(κ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(I),
					result  => q(Ι),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(i),
					result  => q(ι),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(TH),
					result  => q(Θ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Th),
					result  => q(Θ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(th),
					result  => q(θ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Z),
					result  => q(Ζ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(z),
					result  => q(ζ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(E),
					result  => q(Ε),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(e),
					result  => q(ε),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(D),
					result  => q(Δ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d),
					result  => q(δ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(G),
					result  => q(Γ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([GKXCgkxc]),
					replace => q(N),
					result  => q(Γ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(g),
					result  => q(γ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([GKXCgkxc]),
					replace => q(n),
					result  => q(γ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(V),
					result  => q(Β),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(v),
					result  => q(β),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(A),
					result  => q(Α),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(a),
					result  => q(α),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Y),
					result  => q(Υ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(y),
					result  => q(υ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(U̱),
					result  => q(Υ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(V̱),
					result  => q(Υ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(((?:(?![̈])[\p{Mn}]))*f̱),
					result  => q(υ$1),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(((?:(?![̈])[\p{Mn}]))*v̱),
					result  => q(υ$1),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(oU),
					result  => q(οΥ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ou),
					result  => q(Ου),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(OU),
					result  => q(ΟΥ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ou),
					result  => q(ου),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(B),
					result  => q(ΜΠ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([\p{Mn} \p{Me}] * (?:(?=[\p{Ll}])[\p{latin}\p{greek}])),
					replace => q(B),
					result  => q(Μπ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(b),
					result  => q(μπ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(O̱),
					result  => q(Ω),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(o̱),
					result  => q(ω),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ps),
					result  => q(ψ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(PS),
					result  => q(Ψ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ps),
					result  => q(Ψ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(I̱),
					result  => q(Η),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(i̱),
					result  => q(η),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\:),
					result  => q(·),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\?̱),
					result  => q(\?),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\:̱),
					result  => q(\:),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
