=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Sr - Package for language Serbian

=cut

package Locale::CLDR::Locales::Sr;
# This file auto generated from Data\common\main\sr.xml
#	on Wed 28 Feb 12:16:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
    is => 'ro',
    isa => ArrayRef,
    init_arg => undef,
    default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal-masculine','spellout-cardinal-neuter','spellout-cardinal-feminine','spellout-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
    is => 'ro',
    isa => HashRef,
    init_arg => undef,
    default => sub {
        use bigfloat;
        return {
		'ordi' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(и),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' и =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' и =%spellout-ordinal=),
				},
			},
		},
		'ordti' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ти),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'spellout-cardinal-feminine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(једна),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(две),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљаду[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-masculine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(један),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(три),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(четири),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(пет),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(шест),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(седам),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(осам),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(девет),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(десет),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(једанаест),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(дванаест),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(тринаест),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(четрнаест),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(петнаест),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(шеснаест),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(седамнаест),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(осамнаест),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(деветнаест),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљаду[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-neuter' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(једно),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљаду[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нулти),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(први),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(други),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(трећи),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(четврти),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(пети),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(шести),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(седми),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(осми),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(девети),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(десети),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(једанаести),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(дванаести),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(тринаести),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(четрнаести),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(петнаести),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(шеснаести),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(седамнаести),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(осамнаести),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(деветнаести),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет→%%ordi→),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет→%%ordi→),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет→%%ordi→),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет→%%ordi→),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет→%%ordi→),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет→%%ordi→),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет→%%ordi→),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет→%%ordi→),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто→%%ordti→),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста→%%ordti→),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста→%%ordti→),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто→%%ordti→),
				},
				'max' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто→%%ordti→),
				},
			},
		},
    } },
);

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'афарски',
 				'ab' => 'абхаски',
 				'ace' => 'ацешки',
 				'ach' => 'аколи',
 				'ada' => 'адангме',
 				'ady' => 'адигејски',
 				'ae' => 'авестански',
 				'af' => 'африканс',
 				'afh' => 'африхили',
 				'agq' => 'агем',
 				'ain' => 'аину',
 				'ak' => 'акански',
 				'akk' => 'акадијски',
 				'ale' => 'алеутски',
 				'alt' => 'јужноалтајски',
 				'am' => 'амхарски',
 				'an' => 'арагонски',
 				'ang' => 'староенглески',
 				'ann' => 'оболо',
 				'anp' => 'ангика',
 				'ar' => 'арапски',
 				'ar_001' => 'савремени стандардни арапски',
 				'arc' => 'арамејски',
 				'arn' => 'мапуче',
 				'arp' => 'арапахо',
 				'ars' => 'најдиарапски',
 				'arw' => 'аравачки',
 				'as' => 'асамски',
 				'asa' => 'асу',
 				'ast' => 'астуријски',
 				'atj' => 'атикамеку',
 				'av' => 'аварски',
 				'awa' => 'авади',
 				'ay' => 'ајмара',
 				'az' => 'азербејџански',
 				'az@alt=short' => 'азерски',
 				'ba' => 'башкирски',
 				'bal' => 'белучки',
 				'ban' => 'балијски',
 				'bas' => 'баса',
 				'be' => 'белоруски',
 				'bej' => 'беџа',
 				'bem' => 'бемба',
 				'bez' => 'бена',
 				'bg' => 'бугарски',
 				'bgc' => 'харијански',
 				'bgn' => 'западни белучки',
 				'bho' => 'боџпури',
 				'bi' => 'бислама',
 				'bik' => 'бикол',
 				'bin' => 'бини',
 				'bla' => 'сисика',
 				'bm' => 'бамбара',
 				'bn' => 'бенгалски',
 				'bo' => 'тибетански',
 				'br' => 'бретонски',
 				'bra' => 'брај',
 				'brx' => 'бодо',
 				'bs' => 'босански',
 				'bua' => 'бурјатски',
 				'bug' => 'бугијски',
 				'byn' => 'блински',
 				'ca' => 'каталонски',
 				'cad' => 'кадо',
 				'car' => 'карипски',
 				'cay' => 'кајуга',
 				'cch' => 'атсам',
 				'ccp' => 'чакма',
 				'ce' => 'чеченски',
 				'ceb' => 'себуански',
 				'cgg' => 'чига',
 				'ch' => 'чаморо',
 				'chb' => 'чипча',
 				'chg' => 'чагатај',
 				'chk' => 'чучки',
 				'chm' => 'мари',
 				'chn' => 'чинучки',
 				'cho' => 'чоктавски',
 				'chp' => 'чипевјански',
 				'chr' => 'чероки',
 				'chy' => 'чејенски',
 				'ckb' => 'централни курдски',
 				'clc' => 'чилкотин',
 				'co' => 'корзикански',
 				'cop' => 'коптски',
 				'cr' => 'кри',
 				'crg' => 'мичиф',
 				'crh' => 'кримскотатарски',
 				'crj' => 'југоисточни кри',
 				'crk' => 'плаинскри',
 				'crl' => 'североисточни кри',
 				'crm' => 'музкри',
 				'crr' => 'каролиншки алгонквијан',
 				'crs' => 'сејшелски креолски француски',
 				'cs' => 'чешки',
 				'csb' => 'кашупски',
 				'csw' => 'мочварни кри',
 				'cu' => 'црквенословенски',
 				'cv' => 'чувашки',
 				'cy' => 'велшки',
 				'da' => 'дански',
 				'dak' => 'дакота',
 				'dar' => 'даргински',
 				'dav' => 'таита',
 				'de' => 'немачки',
 				'de_AT' => 'аустријски немачки',
 				'de_CH' => 'швајцарски високи немачки',
 				'del' => 'делаверски',
 				'den' => 'слејви',
 				'dgr' => 'догрипски',
 				'din' => 'динка',
 				'dje' => 'зарма',
 				'doi' => 'догри',
 				'dsb' => 'доњолужичкосрпски',
 				'dua' => 'дуала',
 				'dum' => 'средњехоландски',
 				'dv' => 'малдивски',
 				'dyo' => 'џола фоњи',
 				'dyu' => 'ђула',
 				'dz' => 'џонга',
 				'dzg' => 'дазага',
 				'ebu' => 'ембу',
 				'ee' => 'еве',
 				'efi' => 'ефички',
 				'egy' => 'староегипатски',
 				'eka' => 'екаџук',
 				'el' => 'грчки',
 				'elx' => 'еламитски',
 				'en' => 'енглески',
 				'en_GB' => 'енглески (Велика Британија)',
 				'en_GB@alt=short' => 'енглески (УК)',
 				'en_US' => 'енглески (Сједињене Америчке Државе)',
 				'en_US@alt=short' => 'енглески (САД)',
 				'enm' => 'средњеенглески',
 				'eo' => 'есперанто',
 				'es' => 'шпански',
 				'es_ES' => 'шпански (Европа)',
 				'et' => 'естонски',
 				'eu' => 'баскијски',
 				'ewo' => 'евондо',
 				'fa' => 'персијски',
 				'fa_AF' => 'дари',
 				'fan' => 'фанг',
 				'fat' => 'фанти',
 				'ff' => 'фула',
 				'fi' => 'фински',
 				'fil' => 'филипински',
 				'fj' => 'фиџијски',
 				'fo' => 'фарски',
 				'fon' => 'фон',
 				'fr' => 'француски',
 				'frc' => 'кајунски француски',
 				'frm' => 'средњефранцуски',
 				'fro' => 'старофранцуски',
 				'frr' => 'севернофризијски',
 				'frs' => 'источнофризијски',
 				'fur' => 'фриулски',
 				'fy' => 'западни фризијски',
 				'ga' => 'ирски',
 				'gaa' => 'га',
 				'gag' => 'гагауз',
 				'gay' => 'гајо',
 				'gba' => 'гбаја',
 				'gd' => 'шкотски гелски',
 				'gez' => 'геез',
 				'gil' => 'гилбертски',
 				'gl' => 'галицијски',
 				'gmh' => 'средњи високонемачки',
 				'gn' => 'гварани',
 				'goh' => 'старонемачки',
 				'gon' => 'гонди',
 				'gor' => 'горонтало',
 				'got' => 'готски',
 				'grb' => 'гребо',
 				'grc' => 'старогрчки',
 				'gsw' => 'немачки (Швајцарска)',
 				'gu' => 'гуџарати',
 				'guz' => 'гуси',
 				'gv' => 'манкс',
 				'gwi' => 'гвичински',
 				'ha' => 'хауса',
 				'hai' => 'хаида',
 				'haw' => 'хавајски',
 				'hax' => 'јужни хаида',
 				'he' => 'хебрејски',
 				'hi' => 'хинди',
 				'hi_Latn@alt=variant' => 'хинглиш',
 				'hil' => 'хилигајнонски',
 				'hit' => 'хетитски',
 				'hmn' => 'хмоншки',
 				'ho' => 'хири моту',
 				'hr' => 'хрватски',
 				'hsb' => 'горњолужичкосрпски',
 				'ht' => 'хаићански',
 				'hu' => 'мађарски',
 				'hup' => 'хупа',
 				'hur' => 'халкомелем',
 				'hy' => 'јерменски',
 				'hz' => 'хереро',
 				'ia' => 'интерлингва',
 				'iba' => 'ибански',
 				'ibb' => 'ибибио',
 				'id' => 'индонежански',
 				'ie' => 'интерлингве',
 				'ig' => 'игбо',
 				'ii' => 'сечуански ји',
 				'ik' => 'инупик',
 				'ikt' => 'западноканадски инуктитут',
 				'ilo' => 'илоко',
 				'inh' => 'ингушки',
 				'io' => 'идо',
 				'is' => 'исландски',
 				'it' => 'италијански',
 				'iu' => 'инуктитутски',
 				'ja' => 'јапански',
 				'jbo' => 'ложбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачаме',
 				'jpr' => 'јудео-персијски',
 				'jrb' => 'јудео-арапски',
 				'jv' => 'јавански',
 				'ka' => 'грузијски',
 				'kaa' => 'кара-калпашки',
 				'kab' => 'кабиле',
 				'kac' => 'качински',
 				'kaj' => 'џу',
 				'kam' => 'камба',
 				'kaw' => 'кави',
 				'kbd' => 'кабардијски',
 				'kcg' => 'тјап',
 				'kde' => 'маконде',
 				'kea' => 'зеленортски',
 				'kfo' => 'коро',
 				'kg' => 'конго',
 				'kgp' => 'каинганг',
 				'kha' => 'каси',
 				'kho' => 'котанешки',
 				'khq' => 'којра чиини',
 				'ki' => 'кикују',
 				'kj' => 'квањама',
 				'kk' => 'казашки',
 				'kkj' => 'како',
 				'kl' => 'гренландски',
 				'kln' => 'каленџински',
 				'km' => 'кмерски',
 				'kmb' => 'кимбунду',
 				'kn' => 'канада',
 				'ko' => 'корејски',
 				'koi' => 'коми-пермски',
 				'kok' => 'конкани',
 				'kos' => 'косренски',
 				'kpe' => 'кпеле',
 				'kr' => 'канури',
 				'krc' => 'карачајско-балкарски',
 				'kri' => 'крио',
 				'krl' => 'карелски',
 				'kru' => 'курук',
 				'ks' => 'кашмирски',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафија',
 				'ksh' => 'келнски',
 				'ku' => 'курдски',
 				'kum' => 'кумички',
 				'kut' => 'кутенај',
 				'kv' => 'коми',
 				'kw' => 'корнволски',
 				'kwk' => 'кваквала',
 				'ky' => 'киргиски',
 				'la' => 'латински',
 				'lad' => 'ладино',
 				'lag' => 'ланги',
 				'lah' => 'ланда',
 				'lam' => 'ламба',
 				'lb' => 'луксембуршки',
 				'lez' => 'лезгински',
 				'lg' => 'ганда',
 				'li' => 'лимбуршки',
 				'lil' => 'лилут',
 				'lkt' => 'лакота',
 				'lmo' => 'ломбард',
 				'ln' => 'лингала',
 				'lo' => 'лаоски',
 				'lol' => 'монго',
 				'lou' => 'луизијански креолски',
 				'loz' => 'лози',
 				'lrc' => 'северни лури',
 				'lsm' => 'самиа',
 				'lt' => 'литвански',
 				'lu' => 'луба-катанга',
 				'lua' => 'луба-лулуа',
 				'lui' => 'луисењо',
 				'lun' => 'лунда',
 				'luo' => 'луо',
 				'lus' => 'мизо',
 				'luy' => 'лујиа',
 				'lv' => 'летонски',
 				'mad' => 'мадурски',
 				'mag' => 'магахи',
 				'mai' => 'маитили',
 				'mak' => 'макасарски',
 				'man' => 'мандинго',
 				'mas' => 'масајски',
 				'mdf' => 'мокша',
 				'mdr' => 'мандар',
 				'men' => 'менде',
 				'mer' => 'меру',
 				'mfe' => 'морисјен',
 				'mg' => 'малгашки',
 				'mga' => 'средњеирски',
 				'mgh' => 'макува-мито',
 				'mgo' => 'мета',
 				'mh' => 'маршалски',
 				'mi' => 'маорски',
 				'mic' => 'микмак',
 				'min' => 'минангкабау',
 				'mk' => 'македонски',
 				'ml' => 'малајалам',
 				'mn' => 'монголски',
 				'mnc' => 'манџурски',
 				'mni' => 'манипурски',
 				'moe' => 'инуајмун',
 				'moh' => 'мохочки',
 				'mos' => 'моси',
 				'mr' => 'марати',
 				'ms' => 'малајски',
 				'mt' => 'малтешки',
 				'mua' => 'мунданг',
 				'mul' => 'Више језика',
 				'mus' => 'кришки',
 				'mwl' => 'мирандски',
 				'mwr' => 'марвари',
 				'my' => 'бурмански',
 				'myv' => 'ерзја',
 				'mzn' => 'мазандерански',
 				'na' => 'науруски',
 				'nap' => 'напуљски',
 				'naq' => 'нама',
 				'nb' => 'норвешки букмол',
 				'nd' => 'северни ндебеле',
 				'nds' => 'нисконемачки',
 				'nds_NL' => 'нискосаксонски',
 				'ne' => 'непалски',
 				'new' => 'невари',
 				'ng' => 'ндонга',
 				'nia' => 'ниас',
 				'niu' => 'ниуејски',
 				'nl' => 'холандски',
 				'nl_BE' => 'фламански',
 				'nmg' => 'квасио',
 				'nn' => 'норвешки нинорск',
 				'nnh' => 'нгиембун',
 				'no' => 'норвешки',
 				'nog' => 'ногајски',
 				'non' => 'старонордијски',
 				'nqo' => 'нко',
 				'nr' => 'јужни ндебеле',
 				'nso' => 'северни сото',
 				'nus' => 'нуер',
 				'nv' => 'навахо',
 				'nwc' => 'класични неварски',
 				'ny' => 'њанџа',
 				'nym' => 'њамвези',
 				'nyn' => 'њанколе',
 				'nyo' => 'њоро',
 				'nzi' => 'нзима',
 				'oc' => 'окситански',
 				'oj' => 'оџибве',
 				'ojb' => 'северозападни оџибва',
 				'ojc' => 'централни оџибва',
 				'ojs' => 'оџикри',
 				'ojw' => 'западни оџибва',
 				'oka' => 'оканган',
 				'om' => 'оромо',
 				'or' => 'одија',
 				'os' => 'осетински',
 				'osa' => 'осаге',
 				'ota' => 'османски турски',
 				'pa' => 'пенџапски',
 				'pag' => 'пангасинански',
 				'pal' => 'пахлави',
 				'pam' => 'пампанга',
 				'pap' => 'папијаменто',
 				'pau' => 'палауски',
 				'pcm' => 'нигеријски пиџин',
 				'peo' => 'староперсијски',
 				'phn' => 'феничански',
 				'pi' => 'пали',
 				'pis' => 'пиџин',
 				'pl' => 'пољски',
 				'pon' => 'понпејски',
 				'pqm' => 'малисепасамакводи',
 				'prg' => 'пруски',
 				'pro' => 'староокситански',
 				'ps' => 'паштунски',
 				'ps@alt=variant' => 'пашто',
 				'pt' => 'португалски',
 				'pt_PT' => 'португалски (Португал)',
 				'qu' => 'кечуа',
 				'quc' => 'киче',
 				'raj' => 'раџастански',
 				'rap' => 'рапануи',
 				'rar' => 'раротонгански',
 				'rhg' => 'рохингја',
 				'rm' => 'романш',
 				'rn' => 'кирунди',
 				'ro' => 'румунски',
 				'ro_MD' => 'молдавски',
 				'rof' => 'ромбо',
 				'rom' => 'ромски',
 				'ru' => 'руски',
 				'rup' => 'цинцарски',
 				'rw' => 'кињаруанда',
 				'rwk' => 'руа',
 				'sa' => 'санскрит',
 				'sad' => 'сандаве',
 				'sah' => 'саха',
 				'sam' => 'самаријански арамејски',
 				'saq' => 'самбуру',
 				'sas' => 'сасак',
 				'sat' => 'сантали',
 				'sba' => 'нгамбај',
 				'sbp' => 'сангу',
 				'sc' => 'сардински',
 				'scn' => 'сицилијански',
 				'sco' => 'шкотски',
 				'sd' => 'синди',
 				'sdh' => 'јужнокурдски',
 				'se' => 'северни сами',
 				'seh' => 'сена',
 				'sel' => 'селкупски',
 				'ses' => 'којраборо сени',
 				'sg' => 'санго',
 				'sga' => 'староирски',
 				'sh' => 'српскохрватски',
 				'shi' => 'ташелхит',
 				'shn' => 'шански',
 				'si' => 'синхалешки',
 				'sid' => 'сидамо',
 				'sk' => 'словачки',
 				'sl' => 'словеначки',
 				'slh' => 'јужни лашутсид',
 				'sm' => 'самоански',
 				'sma' => 'јужни сами',
 				'smj' => 'луле сами',
 				'smn' => 'инари сами',
 				'sms' => 'сколт сами',
 				'sn' => 'шона',
 				'snk' => 'сонинке',
 				'so' => 'сомалски',
 				'sog' => 'согдијски',
 				'sq' => 'албански',
 				'sr' => 'српски',
 				'srn' => 'сранан тонго',
 				'srr' => 'серерски',
 				'ss' => 'свази',
 				'ssy' => 'сахо',
 				'st' => 'сесото',
 				'str' => 'стреицсалиш',
 				'su' => 'сундански',
 				'suk' => 'сукума',
 				'sus' => 'сусу',
 				'sux' => 'сумерски',
 				'sv' => 'шведски',
 				'sw' => 'свахили',
 				'sw_CD' => 'кисвахили',
 				'swb' => 'коморски',
 				'syc' => 'сиријачки',
 				'syr' => 'сиријски',
 				'ta' => 'тамилски',
 				'tce' => 'јужни тачон',
 				'te' => 'телугу',
 				'tem' => 'тимне',
 				'teo' => 'тесо',
 				'ter' => 'терено',
 				'tet' => 'тетум',
 				'tg' => 'таџички',
 				'tgx' => 'тагиш',
 				'th' => 'тајски',
 				'tht' => 'тахлтан',
 				'ti' => 'тигриња',
 				'tig' => 'тигре',
 				'tiv' => 'тив',
 				'tk' => 'туркменски',
 				'tkl' => 'токелау',
 				'tl' => 'тагалог',
 				'tlh' => 'клингонски',
 				'tli' => 'тлингит',
 				'tmh' => 'тамашек',
 				'tn' => 'цвана',
 				'to' => 'тонгански',
 				'tog' => 'њаса тонга',
 				'tok' => 'токипона',
 				'tpi' => 'ток писин',
 				'tr' => 'турски',
 				'trv' => 'тароко',
 				'ts' => 'цонга',
 				'tsi' => 'цимшиан',
 				'tt' => 'татарски',
 				'ttm' => 'северни тучон',
 				'tum' => 'тумбука',
 				'tvl' => 'тувалу',
 				'tw' => 'тви',
 				'twq' => 'тасавак',
 				'ty' => 'тахићански',
 				'tyv' => 'тувински',
 				'tzm' => 'централноатласки тамашек',
 				'udm' => 'удмуртски',
 				'ug' => 'ујгурски',
 				'uga' => 'угаритски',
 				'uk' => 'украјински',
 				'umb' => 'умбунду',
 				'und' => 'непознат језик',
 				'ur' => 'урду',
 				'uz' => 'узбечки',
 				'vai' => 'ваи',
 				've' => 'венда',
 				'vi' => 'вијетнамски',
 				'vo' => 'волапик',
 				'vot' => 'водски',
 				'vun' => 'вунџо',
 				'wa' => 'валонски',
 				'wae' => 'валсерски',
 				'wal' => 'волајта',
 				'war' => 'варајски',
 				'was' => 'вашо',
 				'wbp' => 'варлпири',
 				'wo' => 'волоф',
 				'wuu' => 'ву кинески',
 				'xal' => 'калмички',
 				'xh' => 'коса',
 				'xog' => 'сога',
 				'yao' => 'јао',
 				'yap' => 'јапски',
 				'yav' => 'јангбен',
 				'ybb' => 'јемба',
 				'yi' => 'јидиш',
 				'yo' => 'јоруба',
 				'yrl' => 'нингату',
 				'yue' => 'кантонски',
 				'yue@alt=menu' => 'кантонски кинески',
 				'za' => 'џуаншки',
 				'zap' => 'запотечки',
 				'zbl' => 'блисимболи',
 				'zen' => 'зенага',
 				'zgh' => 'стандардни марокански тамазигт',
 				'zh' => 'кинески',
 				'zh@alt=menu' => 'мандарински кинески',
 				'zh_Hans' => 'поједностављени кинески',
 				'zh_Hans@alt=long' => 'поједностављени мандарински кинески',
 				'zh_Hant' => 'традиционални кинески',
 				'zh_Hant@alt=long' => 'традиционални мандарински кинески',
 				'zu' => 'зулу',
 				'zun' => 'зуни',
 				'zxx' => 'без лингвистичког садржаја',
 				'zza' => 'заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'адлам',
 			'Arab' => 'арапско писмо',
 			'Arab@alt=variant' => 'персијско-арапско писмо',
 			'Aran' => 'насталик',
 			'Armi' => 'империјско арамејско писмо',
 			'Armn' => 'јерменско писмо',
 			'Avst' => 'авестанско писмо',
 			'Bali' => 'балијско писмо',
 			'Batk' => 'батак писмо',
 			'Beng' => 'бенгалско писмо',
 			'Blis' => 'блисимболично писмо',
 			'Bopo' => 'бопомофо писмо',
 			'Brah' => 'браманско писмо',
 			'Brai' => 'брајево писмо',
 			'Bugi' => 'бугинско писмо',
 			'Buhd' => 'бухидско писмо',
 			'Cakm' => 'чакма',
 			'Cans' => 'уједињени канадски абориџински силабици',
 			'Cari' => 'каријско писмо',
 			'Cham' => 'чамско писмо',
 			'Cher' => 'чероки',
 			'Cirt' => 'цирт писмо',
 			'Copt' => 'коптичко писмо',
 			'Cprt' => 'кипарско писмо',
 			'Cyrl' => 'ћирилица',
 			'Cyrs' => 'Старословенска црквена ћирилица',
 			'Deva' => 'деванагари',
 			'Dsrt' => 'Дезерет',
 			'Egyd' => 'египатско народно писмо',
 			'Egyh' => 'египатско хијератско писмо',
 			'Egyp' => 'египатски хијероглифи',
 			'Ethi' => 'етиопско писмо',
 			'Geok' => 'грузијско кхутсури писмо',
 			'Geor' => 'грузијско писмо',
 			'Glag' => 'глагољица',
 			'Goth' => 'Готика',
 			'Grek' => 'грчко писмо',
 			'Gujr' => 'гуџаратско писмо',
 			'Guru' => 'гурмуки писмо',
 			'Hanb' => 'ханб',
 			'Hang' => 'хангул',
 			'Hani' => 'хан',
 			'Hano' => 'хануно',
 			'Hans' => 'поједностављено кинеско писмо',
 			'Hans@alt=stand-alone' => 'поједностављено хан писмо',
 			'Hant' => 'традиционално кинеско писмо',
 			'Hant@alt=stand-alone' => 'традиционално хан писмо',
 			'Hebr' => 'хебрејско писмо',
 			'Hira' => 'хирагана',
 			'Hmng' => 'пахав хмонг писмо',
 			'Hrkt' => 'јапанска слоговна писма',
 			'Hung' => 'старомађарско писмо',
 			'Inds' => 'индушко писмо',
 			'Ital' => 'стари италик',
 			'Jamo' => 'џамо',
 			'Java' => 'јаванско писмо',
 			'Jpan' => 'јапанско писмо',
 			'Kali' => 'кајах-ли писмо',
 			'Kana' => 'катакана',
 			'Khar' => 'карошти писмо',
 			'Khmr' => 'кмерско писмо',
 			'Knda' => 'канада писмо',
 			'Kore' => 'корејско писмо',
 			'Kthi' => 'каити',
 			'Lana' => 'ланна писмо',
 			'Laoo' => 'лаошко писмо',
 			'Latf' => 'латиница (фрактур варијанта)',
 			'Latg' => 'галска латиница',
 			'Latn' => 'латиница',
 			'Lepc' => 'лепча писмо',
 			'Limb' => 'лимбу писмо',
 			'Lina' => 'линеарно А писмо',
 			'Linb' => 'линеарно Б писмо',
 			'Lyci' => 'лисијско писмо',
 			'Lydi' => 'лидијско писмо',
 			'Mand' => 'мандеанско писмо',
 			'Mani' => 'манихејско писмо',
 			'Maya' => 'мајански хијероглифи',
 			'Mero' => 'мероитик писмо',
 			'Mlym' => 'малајаламско писмо',
 			'Mong' => 'монголско писмо',
 			'Moon' => 'месечево писмо',
 			'Mtei' => 'меитеи мајек',
 			'Mymr' => 'мијанмарско писмо',
 			'Nkoo' => 'нко',
 			'Ogam' => 'огамско писмо',
 			'Olck' => 'ол чики',
 			'Orkh' => 'орконско писмо',
 			'Orya' => 'оријанско писмо',
 			'Osma' => 'осмањанско писмо',
 			'Perm' => 'старо пермикско писмо',
 			'Phag' => 'пагс-па писмо',
 			'Phli' => 'писани пахлави',
 			'Phlp' => 'псалтер пахлави',
 			'Phlv' => 'пахлави писмо',
 			'Phnx' => 'Феничанско писмо',
 			'Plrd' => 'поралд фонетско писмо',
 			'Prti' => 'писани партиан',
 			'Rjng' => 'рејанг писмо',
 			'Rohg' => 'ханифи',
 			'Roro' => 'ронгоронго писмо',
 			'Runr' => 'рунско писмо',
 			'Samr' => 'самаританско писмо',
 			'Sara' => 'сарати писмо',
 			'Saur' => 'саураштра писмо',
 			'Sgnw' => 'знаковно писмо',
 			'Shaw' => 'шавијанско писмо',
 			'Sinh' => 'синхалско писмо',
 			'Sund' => 'сунданско писмо',
 			'Sylo' => 'силоти нагри писмо',
 			'Syrc' => 'сиријско писмо',
 			'Syre' => 'сиријско естрангело писмо',
 			'Syrj' => 'западносиријско писмо',
 			'Syrn' => 'писмо источне Сирије',
 			'Tagb' => 'тагбанва писмо',
 			'Tale' => 'таи ле писмо',
 			'Talu' => 'нови таи луе',
 			'Taml' => 'тамилско писмо',
 			'Tavt' => 'таи виет писмо',
 			'Telu' => 'телугу писмо',
 			'Teng' => 'тенгвар писмо',
 			'Tfng' => 'тифинаг',
 			'Tglg' => 'Тагалог',
 			'Thaa' => 'тана писмо',
 			'Thai' => 'тајландско писмо',
 			'Tibt' => 'тибетанско писмо',
 			'Ugar' => 'угаритско писмо',
 			'Vaii' => 'ваи',
 			'Visp' => 'видљиви говор',
 			'Xpeo' => 'староперсијско писмо',
 			'Xsux' => 'сумерско-акадско кунеиформ писмо',
 			'Yiii' => 'ји',
 			'Zinh' => 'наследно писмо',
 			'Zmth' => 'математичка нотација',
 			'Zsye' => 'емоџи',
 			'Zsym' => 'симболи',
 			'Zxxx' => 'неписани језик',
 			'Zyyy' => 'заједничко писмо',
 			'Zzzz' => 'непознато писмо',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'свет',
 			'002' => 'Африка',
 			'003' => 'Северноамерички континент',
 			'005' => 'Јужна Америка',
 			'009' => 'Океанија',
 			'011' => 'Западна Африка',
 			'013' => 'Централна Америка',
 			'014' => 'Источна Африка',
 			'015' => 'Северна Африка',
 			'017' => 'Централна Африка',
 			'018' => 'Јужна Африка',
 			'019' => 'Северна и Јужна Америка',
 			'021' => 'Северна Америка',
 			'029' => 'Кариби',
 			'030' => 'Источна Азија',
 			'034' => 'Јужна Азија',
 			'035' => 'Југоисточна Азија',
 			'039' => 'Јужна Европа',
 			'053' => 'Аустралија и Нови Зеланд',
 			'054' => 'Меланезија',
 			'057' => 'Микронезијски регион',
 			'061' => 'Полинезија',
 			'142' => 'Азија',
 			'143' => 'Централна Азија',
 			'145' => 'Западна Азија',
 			'150' => 'Европа',
 			'151' => 'Источна Европа',
 			'154' => 'Северна Европа',
 			'155' => 'Западна Европа',
 			'202' => 'Подсахарска Африка',
 			'419' => 'Латинска Америка',
 			'AC' => 'Острво Асенсион',
 			'AD' => 'Андора',
 			'AE' => 'Уједињени Арапски Емирати',
 			'AF' => 'Авганистан',
 			'AG' => 'Антигва и Барбуда',
 			'AI' => 'Ангвила',
 			'AL' => 'Албанија',
 			'AM' => 'Јерменија',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктик',
 			'AR' => 'Аргентина',
 			'AS' => 'Америчка Самоа',
 			'AT' => 'Аустрија',
 			'AU' => 'Аустралија',
 			'AW' => 'Аруба',
 			'AX' => 'Оландска Острва',
 			'AZ' => 'Азербејџан',
 			'BA' => 'Босна и Херцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Белгија',
 			'BF' => 'Буркина Фасо',
 			'BG' => 'Бугарска',
 			'BH' => 'Бахреин',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Свети Бартоломеј',
 			'BM' => 'Бермуда',
 			'BN' => 'Брунеј',
 			'BO' => 'Боливија',
 			'BQ' => 'Карипска Холандија',
 			'BR' => 'Бразил',
 			'BS' => 'Бахами',
 			'BT' => 'Бутан',
 			'BV' => 'Острво Буве',
 			'BW' => 'Боцвана',
 			'BY' => 'Белорусија',
 			'BZ' => 'Белизе',
 			'CA' => 'Канада',
 			'CC' => 'Кокосова (Килингова) Острва',
 			'CD' => 'Конго - Киншаса',
 			'CD@alt=variant' => 'Конго (ДРК)',
 			'CF' => 'Централноафричка Република',
 			'CG' => 'Конго - Бразавил',
 			'CG@alt=variant' => 'Конго (Република)',
 			'CH' => 'Швајцарска',
 			'CI' => 'Обала Слоноваче (Кот д’Ивоар)',
 			'CI@alt=variant' => 'Обала Слоноваче',
 			'CK' => 'Кукова Острва',
 			'CL' => 'Чиле',
 			'CM' => 'Камерун',
 			'CN' => 'Кина',
 			'CO' => 'Колумбија',
 			'CP' => 'Острво Клипертон',
 			'CR' => 'Костарика',
 			'CU' => 'Куба',
 			'CV' => 'Зеленортска Острва',
 			'CW' => 'Курасао',
 			'CX' => 'Божићно Острво',
 			'CY' => 'Кипар',
 			'CZ' => 'Чешка',
 			'CZ@alt=variant' => 'Чешка Република',
 			'DE' => 'Немачка',
 			'DG' => 'Дијего Гарсија',
 			'DJ' => 'Џибути',
 			'DK' => 'Данска',
 			'DM' => 'Доминика',
 			'DO' => 'Доминиканска Република',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута и Мелиља',
 			'EC' => 'Еквадор',
 			'EE' => 'Естонија',
 			'EG' => 'Египат',
 			'EH' => 'Западна Сахара',
 			'ER' => 'Еритреја',
 			'ES' => 'Шпанија',
 			'ET' => 'Етиопија',
 			'EU' => 'Европска унија',
 			'EZ' => 'Еврозона',
 			'FI' => 'Финска',
 			'FJ' => 'Фиџи',
 			'FK' => 'Фокландска Острва',
 			'FK@alt=variant' => 'Фокландска (Малвинска) острва',
 			'FM' => 'Микронезија',
 			'FO' => 'Фарска Острва',
 			'FR' => 'Француска',
 			'GA' => 'Габон',
 			'GB' => 'Уједињено Краљевство',
 			'GB@alt=short' => 'УК',
 			'GD' => 'Гренада',
 			'GE' => 'Грузија',
 			'GF' => 'Француска Гвајана',
 			'GG' => 'Гернзи',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланд',
 			'GM' => 'Гамбија',
 			'GN' => 'Гвинеја',
 			'GP' => 'Гваделуп',
 			'GQ' => 'Екваторијална Гвинеја',
 			'GR' => 'Грчка',
 			'GS' => 'Јужна Џорџија и Јужна Сендвичка Острва',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинеја-Бисао',
 			'GY' => 'Гвајана',
 			'HK' => 'САР Хонгконг (Кина)',
 			'HK@alt=short' => 'Хонгконг',
 			'HM' => 'Острво Херд и Мекдоналдова острва',
 			'HN' => 'Хондурас',
 			'HR' => 'Хрватска',
 			'HT' => 'Хаити',
 			'HU' => 'Мађарска',
 			'IC' => 'Канарска Острва',
 			'ID' => 'Индонезија',
 			'IE' => 'Ирска',
 			'IL' => 'Израел',
 			'IM' => 'Острво Ман',
 			'IN' => 'Индија',
 			'IO' => 'Британска територија Индијског океана',
 			'IO@alt=chagos' => 'архипелаг Чагос',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланд',
 			'IT' => 'Италија',
 			'JE' => 'Џерзи',
 			'JM' => 'Јамајка',
 			'JO' => 'Јордан',
 			'JP' => 'Јапан',
 			'KE' => 'Кенија',
 			'KG' => 'Киргистан',
 			'KH' => 'Камбоџа',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморска Острва',
 			'KN' => 'Сент Китс и Невис',
 			'KP' => 'Северна Кореја',
 			'KR' => 'Јужна Кореја',
 			'KW' => 'Кувајт',
 			'KY' => 'Кајманска Острва',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Либан',
 			'LC' => 'Света Луција',
 			'LI' => 'Лихтенштајн',
 			'LK' => 'Шри Ланка',
 			'LR' => 'Либерија',
 			'LS' => 'Лесото',
 			'LT' => 'Литванија',
 			'LU' => 'Луксембург',
 			'LV' => 'Летонија',
 			'LY' => 'Либија',
 			'MA' => 'Мароко',
 			'MC' => 'Монако',
 			'MD' => 'Молдавија',
 			'ME' => 'Црна Гора',
 			'MF' => 'Свети Мартин (Француска)',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалска Острва',
 			'MK' => 'Северна Македонија',
 			'ML' => 'Мали',
 			'MM' => 'Мијанмар (Бурма)',
 			'MN' => 'Монголија',
 			'MO' => 'САР Макао (Кина)',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Северна Маријанска Острва',
 			'MQ' => 'Мартиник',
 			'MR' => 'Мауританија',
 			'MS' => 'Монсерат',
 			'MT' => 'Малта',
 			'MU' => 'Маурицијус',
 			'MV' => 'Малдиви',
 			'MW' => 'Малави',
 			'MX' => 'Мексико',
 			'MY' => 'Малезија',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибија',
 			'NC' => 'Нова Каледонија',
 			'NE' => 'Нигер',
 			'NF' => 'Острво Норфок',
 			'NG' => 'Нигерија',
 			'NI' => 'Никарагва',
 			'NL' => 'Холандија',
 			'NO' => 'Норвешка',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуе',
 			'NZ' => 'Нови Зеланд',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француска Полинезија',
 			'PG' => 'Папуа Нова Гвинеја',
 			'PH' => 'Филипини',
 			'PK' => 'Пакистан',
 			'PL' => 'Пољска',
 			'PM' => 'Сен Пјер и Микелон',
 			'PN' => 'Питкерн',
 			'PR' => 'Порторико',
 			'PS' => 'Палестинске територије',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалија',
 			'PW' => 'Палау',
 			'PY' => 'Парагвај',
 			'QA' => 'Катар',
 			'QO' => 'Океанија (удаљена острва)',
 			'RE' => 'Реинион',
 			'RO' => 'Румунија',
 			'RS' => 'Србија',
 			'RU' => 'Русија',
 			'RW' => 'Руанда',
 			'SA' => 'Саудијска Арабија',
 			'SB' => 'Соломонска Острва',
 			'SC' => 'Сејшели',
 			'SD' => 'Судан',
 			'SE' => 'Шведска',
 			'SG' => 'Сингапур',
 			'SH' => 'Света Јелена',
 			'SI' => 'Словенија',
 			'SJ' => 'Свалбард и Јан Мајен',
 			'SK' => 'Словачка',
 			'SL' => 'Сијера Леоне',
 			'SM' => 'Сан Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалија',
 			'SR' => 'Суринам',
 			'SS' => 'Јужни Судан',
 			'ST' => 'Сао Томе и Принципе',
 			'SV' => 'Салвадор',
 			'SX' => 'Свети Мартин (Холандија)',
 			'SY' => 'Сирија',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан да Куња',
 			'TC' => 'Острва Туркс и Каикос',
 			'TD' => 'Чад',
 			'TF' => 'Француске Јужне Територије',
 			'TG' => 'Того',
 			'TH' => 'Тајланд',
 			'TJ' => 'Таџикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лесте (Источни Тимор)',
 			'TL@alt=variant' => 'Источни Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турска',
 			'TT' => 'Тринидад и Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тајван',
 			'TZ' => 'Танзанија',
 			'UA' => 'Украјина',
 			'UG' => 'Уганда',
 			'UM' => 'Удаљена острва САД',
 			'UN' => 'Уједињене нације',
 			'UN@alt=short' => 'УН',
 			'US' => 'Сједињене Државе',
 			'US@alt=short' => 'САД',
 			'UY' => 'Уругвај',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент Винсент и Гренадини',
 			'VE' => 'Венецуела',
 			'VG' => 'Британска Девичанска Острва',
 			'VI' => 'Америчка Девичанска Острва',
 			'VN' => 'Вијетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Валис и Футуна',
 			'WS' => 'Самоа',
 			'XA' => 'Псеудоакценти',
 			'XB' => 'Псеудобиди',
 			'XK' => 'Косово',
 			'YE' => 'Јемен',
 			'YT' => 'Мајот',
 			'ZA' => 'Јужноафричка Република',
 			'ZM' => 'Замбија',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Непознат регион',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'Традиционална немачка ортографија',
 			'1994' => 'Стандарднизована ресијанска ортографија',
 			'1996' => 'Немачка ортографија из 1996',
 			'1606NICT' => 'Француски из касног средњег века до 1606.',
 			'1694ACAD' => 'Рани модерни француски',
 			'1959ACAD' => 'Академски',
 			'AREVELA' => 'Источни арменијски',
 			'AREVMDA' => 'Западно јерменска',
 			'BAKU1926' => 'Уједињен турски латинични алфабет',
 			'BISKE' => 'Сан Ђорђио/Била дијалект',
 			'BOONT' => 'Бунтлинг',
 			'FONIPA' => 'ИПА фонетика',
 			'FONUPA' => 'УПА фонетика',
 			'KKCOR' => 'Уобичајена ортографија',
 			'LIPAW' => 'Липовички дијалект ресијански',
 			'MONOTON' => 'Монотоник',
 			'NEDIS' => 'Натисоне дијалект',
 			'NJIVA' => 'Гњива/Њива дијалкект',
 			'OSOJS' => 'Осеако/Осојане дијалект',
 			'POLYTON' => 'Политоник',
 			'POSIX' => 'Компјутер',
 			'REVISED' => 'Ревидирана ортографија',
 			'ROZAJ' => 'Ресијан',
 			'SAAHO' => 'Сахо',
 			'SCOTLAND' => 'Шкотски стандардни Енглески',
 			'SCOUSE' => 'Скауз',
 			'SOLBA' => 'Столвица/Солбица дијалект',
 			'TARASK' => 'Тараскијевичка ортографија',
 			'UCCOR' => 'Уједињена ортографија',
 			'UCRCOR' => 'Уједињена ревидирана ортографија',
 			'VALENCIA' => 'Валенцијска',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'календар',
 			'cf' => 'формат валуте',
 			'colalternate' => 'сортирање уз игнорисање симбола',
 			'colbackwards' => 'сортирање према обрнутим акцентима',
 			'colcasefirst' => 'ређање према малом/великом слову',
 			'colcaselevel' => 'сортирање према малом/великом слову',
 			'collation' => 'редослед сортирања',
 			'colnormalization' => 'нормализовано сортирање',
 			'colnumeric' => 'нумеричко сортирање',
 			'colstrength' => 'сортирање према јачини',
 			'currency' => 'валута',
 			'hc' => 'приказивање времена (12- или 24-часовно)',
 			'lb' => 'стил прелома реда',
 			'ms' => 'систем мерних јединица',
 			'numbers' => 'бројеви',
 			'timezone' => 'Временска зона',
 			'va' => 'Варијанта локалитета',
 			'x' => 'Приватна употреба',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{будистички календар},
 				'chinese' => q{кинески календар},
 				'coptic' => q{коптски календар},
 				'dangi' => q{данги календар},
 				'ethiopic' => q{етиопски календар},
 				'ethiopic-amete-alem' => q{етиопски амет алем календар},
 				'gregorian' => q{грегоријански календар},
 				'hebrew' => q{хебрејски календар},
 				'indian' => q{Индијски национални календар},
 				'islamic' => q{исламски календар},
 				'islamic-civil' => q{исламски цивилни календар},
 				'islamic-tbla' => q{исламски астрономски календар},
 				'islamic-umalqura' => q{исламски календар (Umm al-Qura)},
 				'iso8601' => q{ISO-8601 календар},
 				'japanese' => q{јапански календар},
 				'persian' => q{персијски календар},
 				'roc' => q{календар Републике Кине},
 			},
 			'cf' => {
 				'account' => q{рачуноводствени формат валуте},
 				'standard' => q{стандардни формат валуте},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{Сортирај симболе},
 				'shifted' => q{Сортирање уз игнорисање симбола},
 			},
 			'colbackwards' => {
 				'no' => q{Сортирај акценте нормално},
 				'yes' => q{Сортирај акценте обрнуто},
 			},
 			'colcasefirst' => {
 				'lower' => q{Сортирај прво мала слова},
 				'no' => q{Сортирај нормалан редослед великих и малих слова},
 				'upper' => q{Сортирај прво велика слова},
 			},
 			'colcaselevel' => {
 				'no' => q{Сортирај без обзира на велика и мала слова},
 				'yes' => q{Сортирај мала и велика слова},
 			},
 			'collation' => {
 				'big5han' => q{традиционално кинеско сортирање},
 				'compat' => q{претходни редослед сортирања, због компатибилности},
 				'dictionary' => q{редослед сортирања у речнику},
 				'ducet' => q{подразумевани Unicode редослед сортирања},
 				'eor' => q{европска правила редоследа},
 				'gb2312han' => q{поједностављено кинеско сортирање},
 				'phonebook' => q{сортирање као телефонски именик},
 				'phonetic' => q{фонетски редослед сортирања},
 				'pinyin' => q{пинјин сортирање},
 				'reformed' => q{реформисани редослед сортирања},
 				'search' => q{претрага опште намене},
 				'searchjl' => q{Претрага према хангул почетном сугласнику},
 				'standard' => q{стандардни редослед сортирања},
 				'stroke' => q{сортирање по броју потеза},
 				'traditional' => q{традиционално сортирање},
 				'unihan' => q{редослед сортирања радикалних потеза},
 				'zhuyin' => q{жујин},
 			},
 			'colnormalization' => {
 				'no' => q{Сортирај без нормализације},
 				'yes' => q{Сортирај Unicode нормализовано},
 			},
 			'colnumeric' => {
 				'no' => q{Сортирај цифре појединачно},
 				'yes' => q{Сортирај цифре нумерички},
 			},
 			'colstrength' => {
 				'identical' => q{Сортирај све},
 				'primary' => q{Сортирај само основна слова},
 				'quaternary' => q{Сортирај акценте/мала и велика слова/ширину/кана симболе},
 				'secondary' => q{Сортирај акценте},
 				'tertiary' => q{Сортирај акценте/мала и велика слова/ширину},
 			},
 			'd0' => {
 				'fwidth' => q{пуна ширина},
 				'hwidth' => q{пола ширине},
 				'npinyin' => q{Нумеричка},
 			},
 			'hc' => {
 				'h11' => q{12-часовни систем (0-11)},
 				'h12' => q{12-часовни систем (1-12)},
 				'h23' => q{24-часовни систем (0-23)},
 				'h24' => q{24-часовни систем (1-24)},
 			},
 			'lb' => {
 				'loose' => q{размакнути стил прелома реда},
 				'normal' => q{нормални стил прелома реда},
 				'strict' => q{строги стил прелома реда},
 			},
 			'm0' => {
 				'bgn' => q{БГН (BGN)},
 				'ungegn' => q{УНГЕГН (BGN)},
 			},
 			'ms' => {
 				'metric' => q{метрички},
 				'uksystem' => q{империјални},
 				'ussystem' => q{амерички},
 			},
 			'numbers' => {
 				'arab' => q{арапско-индијске цифре},
 				'arabext' => q{продужене арапско-индијске цифре},
 				'armn' => q{јерменски бројеви},
 				'armnlow' => q{мали јерменски бројеви},
 				'beng' => q{бенгалске цифре},
 				'cakm' => q{чакма цифре},
 				'deva' => q{девангари цифре},
 				'ethi' => q{етиопски бројеви},
 				'finance' => q{Финансијски бројеви},
 				'fullwide' => q{цифре пуне ширине},
 				'geor' => q{грузијски бројеви},
 				'grek' => q{грчки бројеви},
 				'greklow' => q{мали грчки бројеви},
 				'gujr' => q{гуџаратске цифре},
 				'guru' => q{гурмуки цифре},
 				'hanidec' => q{кинески децимални бројеви},
 				'hans' => q{поједностављени кинески бројеви},
 				'hansfin' => q{поједностављени кинески финансијски бројеви},
 				'hant' => q{традиционални кинески бројеви},
 				'hantfin' => q{традиционални кинески финансијски бројеви},
 				'hebr' => q{хебрејски бројеви},
 				'java' => q{јаванске цифре},
 				'jpan' => q{јапански бројеви},
 				'jpanfin' => q{јапански финансијски бројеви},
 				'khmr' => q{кмерске цифре},
 				'knda' => q{канада цифре},
 				'laoo' => q{лаошке цифре},
 				'latn' => q{западне цифре},
 				'mlym' => q{малајалам цифре},
 				'mong' => q{монголске цифре},
 				'mtei' => q{митеи мајек цифре},
 				'mymr' => q{мијанмарске цифре},
 				'native' => q{локалне цифре},
 				'olck' => q{ол чики цифре},
 				'orya' => q{орија цифре},
 				'roman' => q{римски бројеви},
 				'romanlow' => q{мали римски бројеви},
 				'taml' => q{тамилски бројеви},
 				'tamldec' => q{тамилске цифре},
 				'telu' => q{телугу цифре},
 				'thai' => q{тајске цифре},
 				'tibt' => q{тибетанске цифре},
 				'traditional' => q{Традиционални бројеви},
 				'vaii' => q{ваи цифре},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{Метрички},
 			'UK' => q{УК},
 			'US' => q{САД},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Језик: {0}',
 			'script' => 'Писмо: {0}',
 			'region' => 'Регион: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[{а̂} {е̂} {и̂} {о̂} {у̂}]},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Ђ', 'Е', 'Ж', 'З', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ћ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'],
			main => qr{[а б в г д ђ е ж з и ј к л љ м н њ о п р с т ћ у ф х ц ч џ ш]},
			punctuation => qr{[\- ‐‑ – , ; \: ! ? . … ‘‚ “„ ( ) \[ \] \{ \} * #]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Д', 'Ђ', 'Е', 'Ж', 'З', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ћ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'], };
},
);


has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{„},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h.mm',
				hms => 'h.mm.ss',
				ms => 'm.ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(главни правац),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(главни правац),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(киби{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(киби{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(меби{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(меби{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(гиби{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(гиби{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(теби{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(теби{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(пеби{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(пеби{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(ексби{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(ексби{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(зеби{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(зеби{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(јобе{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(јобе{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(деци{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(деци{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(пико{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(пико{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(фемто{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(фемто{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ато{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ато{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(центи{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(центи{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(зепто{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(зепто{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(јокто{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(јокто{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(ронто{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(ронто{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(мили{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(мили{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(квекто{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(квекто{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(микро{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(микро{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(нано{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(нано{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(екса{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(екса{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(хекто{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(хекто{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(зета{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(зета{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(јота{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(јота{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(рона{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(рона{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(кило{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(кило{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(квета{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(квета{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(гига{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(гига{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'1' => q(feminine),
						'few' => q({0} ге сила),
						'one' => q({0} ге сила),
						'other' => q({0} ге сила),
					},
					# Core Unit Identifier
					'g-force' => {
						'1' => q(feminine),
						'few' => q({0} ге сила),
						'one' => q({0} ге сила),
						'other' => q({0} ге сила),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'1' => q(inanimate),
						'few' => q({0} метра у секунди на квадрат),
						'name' => q(метри у секунди на квадрат),
						'one' => q({0} метар у секунди на квадрат),
						'other' => q({0} метара у секунди на квадрат),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'1' => q(inanimate),
						'few' => q({0} метра у секунди на квадрат),
						'name' => q(метри у секунди на квадрат),
						'one' => q({0} метар у секунди на квадрат),
						'other' => q({0} метара у секунди на квадрат),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'1' => q(inanimate),
						'few' => q({0} лучна минута),
						'name' => q(лучни минути),
						'one' => q({0} лучни минут),
						'other' => q({0} лучних минута),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'1' => q(inanimate),
						'few' => q({0} лучна минута),
						'name' => q(лучни минути),
						'one' => q({0} лучни минут),
						'other' => q({0} лучних минута),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'1' => q(feminine),
						'few' => q({0} лучне секунде),
						'name' => q(лучне секунде),
						'one' => q({0} лучна секунда),
						'other' => q({0} лучних секунди),
					},
					# Core Unit Identifier
					'arc-second' => {
						'1' => q(feminine),
						'few' => q({0} лучне секунде),
						'name' => q(лучне секунде),
						'one' => q({0} лучна секунда),
						'other' => q({0} лучних секунди),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'1' => q(inanimate),
						'few' => q({0} степена),
						'one' => q({0} степен),
						'other' => q({0} степени),
					},
					# Core Unit Identifier
					'degree' => {
						'1' => q(inanimate),
						'few' => q({0} степена),
						'one' => q({0} степен),
						'other' => q({0} степени),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'1' => q(inanimate),
						'few' => q({0} радијана),
						'name' => q(радијани),
						'one' => q({0} радијан),
						'other' => q({0} радијана),
					},
					# Core Unit Identifier
					'radian' => {
						'1' => q(inanimate),
						'few' => q({0} радијана),
						'name' => q(радијани),
						'one' => q({0} радијан),
						'other' => q({0} радијана),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'1' => q(inanimate),
						'few' => q({0} обртаја),
						'name' => q(обртај),
						'one' => q({0} обртај),
						'other' => q({0} обртаја),
					},
					# Core Unit Identifier
					'revolution' => {
						'1' => q(inanimate),
						'few' => q({0} обртаја),
						'name' => q(обртај),
						'one' => q({0} обртај),
						'other' => q({0} обртаја),
					},
					# Long Unit Identifier
					'area-acre' => {
						'few' => q({0} акера),
						'one' => q({0} акер),
						'other' => q({0} акера),
					},
					# Core Unit Identifier
					'acre' => {
						'few' => q({0} акера),
						'one' => q({0} акер),
						'other' => q({0} акера),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'1' => q(inanimate),
						'few' => q({0} хектара),
						'one' => q({0} хектар),
						'other' => q({0} хектара),
					},
					# Core Unit Identifier
					'hectare' => {
						'1' => q(inanimate),
						'few' => q({0} хектара),
						'one' => q({0} хектар),
						'other' => q({0} хектара),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'1' => q(inanimate),
						'few' => q({0} квадратна центиметра),
						'name' => q(квадратни центиметри),
						'one' => q({0} квадратни центиметар),
						'other' => q({0} квадратних центиметара),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'1' => q(inanimate),
						'few' => q({0} квадратна центиметра),
						'name' => q(квадратни центиметри),
						'one' => q({0} квадратни центиметар),
						'other' => q({0} квадратних центиметара),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'few' => q({0} квадратне стопе),
						'one' => q({0} квадратна стопа),
						'other' => q({0} квадратних стопа),
					},
					# Core Unit Identifier
					'square-foot' => {
						'few' => q({0} квадратне стопе),
						'one' => q({0} квадратна стопа),
						'other' => q({0} квадратних стопа),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'few' => q({0} квадратна инча),
						'name' => q(квадратни инчи),
						'one' => q({0} квадратни инч),
						'other' => q({0} квадратних инча),
					},
					# Core Unit Identifier
					'square-inch' => {
						'few' => q({0} квадратна инча),
						'name' => q(квадратни инчи),
						'one' => q({0} квадратни инч),
						'other' => q({0} квадратних инча),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'1' => q(inanimate),
						'few' => q({0} квадратна километра),
						'one' => q({0} квадратни километар),
						'other' => q({0} квадратних километара),
						'per' => q({0} по квадратном километру),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'1' => q(inanimate),
						'few' => q({0} квадратна километра),
						'one' => q({0} квадратни километар),
						'other' => q({0} квадратних километара),
						'per' => q({0} по квадратном километру),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'1' => q(inanimate),
						'few' => q({0} квадратна метра),
						'one' => q({0} квадратни метар),
						'other' => q({0} квадратних метара),
					},
					# Core Unit Identifier
					'square-meter' => {
						'1' => q(inanimate),
						'few' => q({0} квадратна метра),
						'one' => q({0} квадратни метар),
						'other' => q({0} квадратних метара),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'few' => q({0} квадратне миље),
						'name' => q(квадратне миље),
						'one' => q({0} квадратна миља),
						'other' => q({0} квадратних миља),
						'per' => q({0} по квадратној миљи),
					},
					# Core Unit Identifier
					'square-mile' => {
						'few' => q({0} квадратне миље),
						'name' => q(квадратне миље),
						'one' => q({0} квадратна миља),
						'other' => q({0} квадратних миља),
						'per' => q({0} по квадратној миљи),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'few' => q({0} квадратна јарда),
						'name' => q(квадратни јарди),
						'one' => q({0} квадратни јард),
						'other' => q({0} квадратних јарди),
					},
					# Core Unit Identifier
					'square-yard' => {
						'few' => q({0} квадратна јарда),
						'name' => q(квадратни јарди),
						'one' => q({0} квадратни јард),
						'other' => q({0} квадратних јарди),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'1' => q(feminine),
						'few' => q({0} ставке),
						'name' => q(ставке),
						'one' => q({0} ставка),
						'other' => q({0} ставки),
					},
					# Core Unit Identifier
					'item' => {
						'1' => q(feminine),
						'few' => q({0} ставке),
						'name' => q(ставке),
						'one' => q({0} ставка),
						'other' => q({0} ставки),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'1' => q(inanimate),
						'few' => q({0} карата),
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					# Core Unit Identifier
					'karat' => {
						'1' => q(inanimate),
						'few' => q({0} карата),
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'few' => q({0} милиграма по децилитру),
						'name' => q(милиграми по децилитру),
						'one' => q({0} милиграм по децилитру),
						'other' => q({0} милиграма по децилитру),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'few' => q({0} милиграма по децилитру),
						'name' => q(милиграми по децилитру),
						'one' => q({0} милиграм по децилитру),
						'other' => q({0} милиграма по децилитру),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'1' => q(inanimate),
						'few' => q({0} милимола по литри),
						'name' => q(милимол по литри),
						'one' => q({0} милимол по литри),
						'other' => q({0} милимола по литри),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'1' => q(inanimate),
						'few' => q({0} милимола по литри),
						'name' => q(милимол по литри),
						'one' => q({0} милимол по литри),
						'other' => q({0} милимола по литри),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'1' => q(inanimate),
						'few' => q({0} мола),
						'name' => q(моли),
						'one' => q({0} мол),
						'other' => q({0} мола),
					},
					# Core Unit Identifier
					'mole' => {
						'1' => q(inanimate),
						'few' => q({0} мола),
						'name' => q(моли),
						'one' => q({0} мол),
						'other' => q({0} мола),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'1' => q(inanimate),
						'few' => q({0} процената),
						'one' => q({0} проценат),
						'other' => q({0} процената),
					},
					# Core Unit Identifier
					'percent' => {
						'1' => q(inanimate),
						'few' => q({0} процената),
						'one' => q({0} проценат),
						'other' => q({0} процената),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'1' => q(inanimate),
						'few' => q({0} промила),
						'one' => q({0} промил),
						'other' => q({0} промила),
					},
					# Core Unit Identifier
					'permille' => {
						'1' => q(inanimate),
						'few' => q({0} промила),
						'one' => q({0} промил),
						'other' => q({0} промила),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'1' => q(feminine),
						'few' => q({0} честице на милион),
						'name' => q(честица на милион),
						'one' => q({0} честица на милион),
						'other' => q({0} честица на милион),
					},
					# Core Unit Identifier
					'permillion' => {
						'1' => q(feminine),
						'few' => q({0} честице на милион),
						'name' => q(честица на милион),
						'one' => q({0} честица на милион),
						'other' => q({0} честица на милион),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'1' => q(inanimate),
					},
					# Core Unit Identifier
					'permyriad' => {
						'1' => q(inanimate),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'1' => q(inanimate),
						'few' => q({0} литра на 100 километара),
						'name' => q(литри на 100 километара),
						'one' => q({0} литар на 100 километара),
						'other' => q({0} литара на 100 километара),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'1' => q(inanimate),
						'few' => q({0} литра на 100 километара),
						'name' => q(литри на 100 километара),
						'one' => q({0} литар на 100 километара),
						'other' => q({0} литара на 100 километара),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'1' => q(inanimate),
						'few' => q({0} литра по километру),
						'name' => q(литри по километру),
						'one' => q({0} литар по километру),
						'other' => q({0} литара по километру),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'1' => q(inanimate),
						'few' => q({0} литра по километру),
						'name' => q(литри по километру),
						'one' => q({0} литар по километру),
						'other' => q({0} литара по километру),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'few' => q({0} миље по галону),
						'name' => q(миља по галону),
						'one' => q({0} миља по галону),
						'other' => q({0} миља по галону),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'few' => q({0} миље по галону),
						'name' => q(миља по галону),
						'one' => q({0} миља по галону),
						'other' => q({0} миља по галону),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'few' => q({0} миље по империјалном галону),
						'name' => q(миља по империјалном галону),
						'one' => q({0} миља по империјалном галону),
						'other' => q({0} миља по империјалном галону),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'few' => q({0} миље по империјалном галону),
						'name' => q(миља по империјалном галону),
						'one' => q({0} миља по империјалном галону),
						'other' => q({0} миља по империјалном галону),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'1' => q(inanimate),
						'few' => q({0} бита),
						'name' => q(битови),
						'one' => q({0} бит),
						'other' => q({0} битова),
					},
					# Core Unit Identifier
					'bit' => {
						'1' => q(inanimate),
						'few' => q({0} бита),
						'name' => q(битови),
						'one' => q({0} бит),
						'other' => q({0} битова),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'1' => q(inanimate),
						'few' => q({0} бајта),
						'name' => q(бајтови),
						'one' => q({0} бајт),
						'other' => q({0} бајтова),
					},
					# Core Unit Identifier
					'byte' => {
						'1' => q(inanimate),
						'few' => q({0} бајта),
						'name' => q(бајтови),
						'one' => q({0} бајт),
						'other' => q({0} бајтова),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'1' => q(inanimate),
						'few' => q({0} гигабита),
						'name' => q(гигабитови),
						'one' => q({0} гигабит),
						'other' => q({0} гигабитова),
					},
					# Core Unit Identifier
					'gigabit' => {
						'1' => q(inanimate),
						'few' => q({0} гигабита),
						'name' => q(гигабитови),
						'one' => q({0} гигабит),
						'other' => q({0} гигабитова),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'1' => q(inanimate),
						'few' => q({0} гигабајта),
						'name' => q(гигабајти),
						'one' => q({0} гигабајт),
						'other' => q({0} гигабајтова),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'1' => q(inanimate),
						'few' => q({0} гигабајта),
						'name' => q(гигабајти),
						'one' => q({0} гигабајт),
						'other' => q({0} гигабајтова),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'1' => q(inanimate),
						'few' => q({0} килобита),
						'name' => q(килобитови),
						'one' => q({0} килобит),
						'other' => q({0} килобитова),
					},
					# Core Unit Identifier
					'kilobit' => {
						'1' => q(inanimate),
						'few' => q({0} килобита),
						'name' => q(килобитови),
						'one' => q({0} килобит),
						'other' => q({0} килобитова),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'1' => q(inanimate),
						'few' => q({0} килобајта),
						'name' => q(килобајти),
						'one' => q({0} килобајт),
						'other' => q({0} килобајтова),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'1' => q(inanimate),
						'few' => q({0} килобајта),
						'name' => q(килобајти),
						'one' => q({0} килобајт),
						'other' => q({0} килобајтова),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'1' => q(inanimate),
						'few' => q({0} мегабита),
						'name' => q(мегабитови),
						'one' => q({0} мегабит),
						'other' => q({0} мегабитова),
					},
					# Core Unit Identifier
					'megabit' => {
						'1' => q(inanimate),
						'few' => q({0} мегабита),
						'name' => q(мегабитови),
						'one' => q({0} мегабит),
						'other' => q({0} мегабитова),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'1' => q(inanimate),
						'few' => q({0} мегабајта),
						'name' => q(мегабајти),
						'one' => q({0} мегабајт),
						'other' => q({0} мегабајтова),
					},
					# Core Unit Identifier
					'megabyte' => {
						'1' => q(inanimate),
						'few' => q({0} мегабајта),
						'name' => q(мегабајти),
						'one' => q({0} мегабајт),
						'other' => q({0} мегабајтова),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'1' => q(inanimate),
						'few' => q({0} петабајта),
						'name' => q(петабајти),
						'one' => q({0} петабајт),
						'other' => q({0} петабајтова),
					},
					# Core Unit Identifier
					'petabyte' => {
						'1' => q(inanimate),
						'few' => q({0} петабајта),
						'name' => q(петабајти),
						'one' => q({0} петабајт),
						'other' => q({0} петабајтова),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'1' => q(inanimate),
						'few' => q({0} терабита),
						'name' => q(терабитови),
						'one' => q({0} терабит),
						'other' => q({0} терабитова),
					},
					# Core Unit Identifier
					'terabit' => {
						'1' => q(inanimate),
						'few' => q({0} терабита),
						'name' => q(терабитови),
						'one' => q({0} терабит),
						'other' => q({0} терабитова),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'1' => q(inanimate),
						'few' => q({0} терабајта),
						'name' => q(терабајти),
						'one' => q({0} терабајт),
						'other' => q({0} терабајта),
					},
					# Core Unit Identifier
					'terabyte' => {
						'1' => q(inanimate),
						'few' => q({0} терабајта),
						'name' => q(терабајти),
						'one' => q({0} терабајт),
						'other' => q({0} терабајта),
					},
					# Long Unit Identifier
					'duration-century' => {
						'1' => q(inanimate),
						'few' => q({0} века),
						'name' => q(векови),
						'one' => q({0} век),
						'other' => q({0} векова),
					},
					# Core Unit Identifier
					'century' => {
						'1' => q(inanimate),
						'few' => q({0} века),
						'name' => q(векови),
						'one' => q({0} век),
						'other' => q({0} векова),
					},
					# Long Unit Identifier
					'duration-day' => {
						'1' => q(inanimate),
						'few' => q({0} дана),
						'name' => q(дани),
						'one' => q({0} дан),
						'other' => q({0} дана),
						'per' => q({0}/дневно),
					},
					# Core Unit Identifier
					'day' => {
						'1' => q(inanimate),
						'few' => q({0} дана),
						'name' => q(дани),
						'one' => q({0} дан),
						'other' => q({0} дана),
						'per' => q({0}/дневно),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'1' => q(feminine),
						'few' => q({0} деценије),
						'name' => q(деценије),
						'one' => q({0} деценија),
						'other' => q({0} деценија),
					},
					# Core Unit Identifier
					'decade' => {
						'1' => q(feminine),
						'few' => q({0} деценије),
						'name' => q(деценије),
						'one' => q({0} деценија),
						'other' => q({0} деценија),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'1' => q(inanimate),
						'few' => q({0} сата),
						'one' => q({0} сат),
						'other' => q({0} сати),
						'per' => q({0}/сат),
					},
					# Core Unit Identifier
					'hour' => {
						'1' => q(inanimate),
						'few' => q({0} сата),
						'one' => q({0} сат),
						'other' => q({0} сати),
						'per' => q({0}/сат),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'1' => q(feminine),
						'few' => q({0} микросекунде),
						'name' => q(микросекунде),
						'one' => q({0} микросекунда),
						'other' => q({0} микросекунди),
					},
					# Core Unit Identifier
					'microsecond' => {
						'1' => q(feminine),
						'few' => q({0} микросекунде),
						'name' => q(микросекунде),
						'one' => q({0} микросекунда),
						'other' => q({0} микросекунди),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'1' => q(feminine),
						'few' => q({0} милисекунде),
						'name' => q(милисекунде),
						'one' => q({0} милисекунда),
						'other' => q({0} милисекунди),
					},
					# Core Unit Identifier
					'millisecond' => {
						'1' => q(feminine),
						'few' => q({0} милисекунде),
						'name' => q(милисекунде),
						'one' => q({0} милисекунда),
						'other' => q({0} милисекунди),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'1' => q(inanimate),
						'few' => q({0} минута),
						'name' => q(минути),
						'one' => q({0} минут),
						'other' => q({0} минута),
						'per' => q({0} у минуту),
					},
					# Core Unit Identifier
					'minute' => {
						'1' => q(inanimate),
						'few' => q({0} минута),
						'name' => q(минути),
						'one' => q({0} минут),
						'other' => q({0} минута),
						'per' => q({0} у минуту),
					},
					# Long Unit Identifier
					'duration-month' => {
						'1' => q(inanimate),
						'few' => q({0} месеца),
						'one' => q({0} месец),
						'other' => q({0} месеци),
						'per' => q({0} месечно),
					},
					# Core Unit Identifier
					'month' => {
						'1' => q(inanimate),
						'few' => q({0} месеца),
						'one' => q({0} месец),
						'other' => q({0} месеци),
						'per' => q({0} месечно),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'1' => q(feminine),
						'few' => q({0} наносекунде),
						'name' => q(наносекунде),
						'one' => q({0} наносекунда),
						'other' => q({0} наносекунди),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'1' => q(feminine),
						'few' => q({0} наносекунде),
						'name' => q(наносекунде),
						'one' => q({0} наносекунда),
						'other' => q({0} наносекунди),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'1' => q(inanimate),
						'few' => q({0} квартала),
						'name' => q(квартали),
						'one' => q({0} квартал),
						'other' => q({0} квартала),
					},
					# Core Unit Identifier
					'quarter' => {
						'1' => q(inanimate),
						'few' => q({0} квартала),
						'name' => q(квартали),
						'one' => q({0} квартал),
						'other' => q({0} квартала),
					},
					# Long Unit Identifier
					'duration-second' => {
						'1' => q(feminine),
						'few' => q({0} секунде),
						'name' => q(секунде),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
						'per' => q({0}/у секунди),
					},
					# Core Unit Identifier
					'second' => {
						'1' => q(feminine),
						'few' => q({0} секунде),
						'name' => q(секунде),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
						'per' => q({0}/у секунди),
					},
					# Long Unit Identifier
					'duration-week' => {
						'1' => q(feminine),
						'few' => q({0} недеље),
						'name' => q(недеље),
						'one' => q({0} недеља),
						'other' => q({0} недеља),
						'per' => q({0} недељно),
					},
					# Core Unit Identifier
					'week' => {
						'1' => q(feminine),
						'few' => q({0} недеље),
						'name' => q(недеље),
						'one' => q({0} недеља),
						'other' => q({0} недеља),
						'per' => q({0} недељно),
					},
					# Long Unit Identifier
					'duration-year' => {
						'1' => q(feminine),
						'few' => q({0} године),
						'name' => q(године),
						'one' => q({0} година),
						'other' => q({0} година),
						'per' => q({0} годишње),
					},
					# Core Unit Identifier
					'year' => {
						'1' => q(feminine),
						'few' => q({0} године),
						'name' => q(године),
						'one' => q({0} година),
						'other' => q({0} година),
						'per' => q({0} годишње),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'1' => q(inanimate),
						'few' => q({0} ампера),
						'name' => q(ампери),
						'one' => q({0} ампер),
						'other' => q({0} ампера),
					},
					# Core Unit Identifier
					'ampere' => {
						'1' => q(inanimate),
						'few' => q({0} ампера),
						'name' => q(ампери),
						'one' => q({0} ампер),
						'other' => q({0} ампера),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'1' => q(inanimate),
						'few' => q({0} милиампера),
						'name' => q(милиампери),
						'one' => q({0} милиампер),
						'other' => q({0} милиампера),
					},
					# Core Unit Identifier
					'milliampere' => {
						'1' => q(inanimate),
						'few' => q({0} милиампера),
						'name' => q(милиампери),
						'one' => q({0} милиампер),
						'other' => q({0} милиампера),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'1' => q(inanimate),
						'few' => q({0} ома),
						'name' => q(оми),
						'one' => q({0} ом),
						'other' => q({0} ома),
					},
					# Core Unit Identifier
					'ohm' => {
						'1' => q(inanimate),
						'few' => q({0} ома),
						'name' => q(оми),
						'one' => q({0} ом),
						'other' => q({0} ома),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'1' => q(inanimate),
						'few' => q({0} волта),
						'name' => q(волти),
						'one' => q({0} волт),
						'other' => q({0} волти),
					},
					# Core Unit Identifier
					'volt' => {
						'1' => q(inanimate),
						'few' => q({0} волта),
						'name' => q(волти),
						'one' => q({0} волт),
						'other' => q({0} волти),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(Британска термална јединица),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(Британска термална јединица),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'1' => q(feminine),
						'few' => q({0} калорије),
						'name' => q(калорије),
						'one' => q({0} калорија),
						'other' => q({0} калорија),
					},
					# Core Unit Identifier
					'calorie' => {
						'1' => q(feminine),
						'few' => q({0} калорије),
						'name' => q(калорије),
						'one' => q({0} калорија),
						'other' => q({0} калорија),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'few' => q({0} електронволта),
						'name' => q(електронволти),
						'one' => q({0} електронволт),
						'other' => q({0} електронволти),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'few' => q({0} електронволта),
						'name' => q(електронволти),
						'one' => q({0} електронволт),
						'other' => q({0} електронволти),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'few' => q({0} калорије),
						'name' => q(Калорије),
						'one' => q({0} калорија),
						'other' => q({0} калорија),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'few' => q({0} калорије),
						'name' => q(Калорије),
						'one' => q({0} калорија),
						'other' => q({0} калорија),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'1' => q(inanimate),
						'few' => q({0} џула),
						'name' => q(џули),
						'one' => q({0} џул),
						'other' => q({0} џула),
					},
					# Core Unit Identifier
					'joule' => {
						'1' => q(inanimate),
						'few' => q({0} џула),
						'name' => q(џули),
						'one' => q({0} џул),
						'other' => q({0} џула),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'few' => q({0} килокалорије),
						'name' => q(килокалорије),
						'one' => q({0} килокалорија),
						'other' => q({0} килокалорија),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'few' => q({0} килокалорије),
						'name' => q(килокалорије),
						'one' => q({0} килокалорија),
						'other' => q({0} килокалорија),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'1' => q(inanimate),
						'few' => q({0} килоџула),
						'name' => q(килоџули),
						'one' => q({0} килоџул),
						'other' => q({0} килоџула),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'1' => q(inanimate),
						'few' => q({0} килоџула),
						'name' => q(килоџули),
						'one' => q({0} килоџул),
						'other' => q({0} килоџула),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'1' => q(inanimate),
						'few' => q({0} киловат-сата),
						'name' => q(киловат-сати),
						'one' => q({0} киловат-сат),
						'other' => q({0} киловат-сати),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'1' => q(inanimate),
						'few' => q({0} киловат-сата),
						'name' => q(киловат-сати),
						'one' => q({0} киловат-сат),
						'other' => q({0} киловат-сати),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(US therms),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(US therms),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'1' => q(inanimate),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'1' => q(inanimate),
					},
					# Long Unit Identifier
					'force-newton' => {
						'1' => q(inanimate),
						'few' => q({0} њутна),
						'name' => q(њутни),
						'one' => q({0} њутн),
						'other' => q({0} њутна),
					},
					# Core Unit Identifier
					'newton' => {
						'1' => q(inanimate),
						'few' => q({0} њутна),
						'name' => q(њутни),
						'one' => q({0} њутн),
						'other' => q({0} њутна),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'few' => q({0} фунте силе),
						'name' => q(фунти силе),
						'one' => q({0} фунта силе),
						'other' => q({0} фунти силе),
					},
					# Core Unit Identifier
					'pound-force' => {
						'few' => q({0} фунте силе),
						'name' => q(фунти силе),
						'one' => q({0} фунта силе),
						'other' => q({0} фунти силе),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'1' => q(inanimate),
						'few' => q({0} гигахерца),
						'name' => q(гигахерци),
						'one' => q({0} гигахерц),
						'other' => q({0} гигахерца),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'1' => q(inanimate),
						'few' => q({0} гигахерца),
						'name' => q(гигахерци),
						'one' => q({0} гигахерц),
						'other' => q({0} гигахерца),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'1' => q(inanimate),
						'few' => q({0} херца),
						'name' => q(херци),
						'one' => q({0} херц),
						'other' => q({0} херца),
					},
					# Core Unit Identifier
					'hertz' => {
						'1' => q(inanimate),
						'few' => q({0} херца),
						'name' => q(херци),
						'one' => q({0} херц),
						'other' => q({0} херца),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'1' => q(inanimate),
						'few' => q({0} килохерца),
						'name' => q(килохерци),
						'one' => q({0} килохерц),
						'other' => q({0} килохерца),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'1' => q(inanimate),
						'few' => q({0} килохерца),
						'name' => q(килохерци),
						'one' => q({0} килохерц),
						'other' => q({0} килохерца),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'1' => q(inanimate),
						'few' => q({0} мегахерца),
						'name' => q(мегахерци),
						'one' => q({0} мегахерц),
						'other' => q({0} мегахерца),
					},
					# Core Unit Identifier
					'megahertz' => {
						'1' => q(inanimate),
						'few' => q({0} мегахерца),
						'name' => q(мегахерци),
						'one' => q({0} мегахерц),
						'other' => q({0} мегахерца),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(тачке),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(тачке),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'few' => q({0} ppcm),
						'name' => q(тачке по центиметру),
						'one' => q({0} тачка по центиметру),
						'other' => q({0} dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'few' => q({0} ppcm),
						'name' => q(тачке по центиметру),
						'one' => q({0} тачка по центиметру),
						'other' => q({0} dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'few' => q({0} ppi),
						'name' => q(тачке по инчу),
						'one' => q({0} тачка по инчу),
						'other' => q({0} dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'few' => q({0} ppi),
						'name' => q(тачке по инчу),
						'one' => q({0} тачка по инчу),
						'other' => q({0} dpi),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'1' => q(inanimate),
					},
					# Core Unit Identifier
					'em' => {
						'1' => q(inanimate),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'1' => q(inanimate),
						'few' => q({0} мегапиксела),
						'name' => q(мегапиксели),
						'one' => q({0} мегапиксел),
						'other' => q({0} мегапиксела),
					},
					# Core Unit Identifier
					'megapixel' => {
						'1' => q(inanimate),
						'few' => q({0} мегапиксела),
						'name' => q(мегапиксели),
						'one' => q({0} мегапиксел),
						'other' => q({0} мегапиксела),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'1' => q(inanimate),
						'few' => q({0} пиксела),
						'name' => q(пиксели),
						'one' => q({0} пиксел),
						'other' => q({0} пиксела),
					},
					# Core Unit Identifier
					'pixel' => {
						'1' => q(inanimate),
						'few' => q({0} пиксела),
						'name' => q(пиксели),
						'one' => q({0} пиксел),
						'other' => q({0} пиксела),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'1' => q(inanimate),
						'few' => q({0} пиксела на центиметар),
						'name' => q(пиксели по центиметру),
						'one' => q({0} пиксел на центиметар),
						'other' => q({0} пиксела на центиметар),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'1' => q(inanimate),
						'few' => q({0} пиксела на центиметар),
						'name' => q(пиксели по центиметру),
						'one' => q({0} пиксел на центиметар),
						'other' => q({0} пиксела на центиметар),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'few' => q({0} пиксела по инчу),
						'name' => q(пиксели по инчу),
						'one' => q({0} пиксел по инчу),
						'other' => q({0} пиксела по инчу),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'few' => q({0} пиксела по инчу),
						'name' => q(пиксели по инчу),
						'one' => q({0} пиксел по инчу),
						'other' => q({0} пиксела по инчу),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'few' => q({0} астрономске јединице),
						'name' => q(астрономске јединице),
						'one' => q({0} астрономска јединица),
						'other' => q({0} астрономских јединица),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'few' => q({0} астрономске јединице),
						'name' => q(астрономске јединице),
						'one' => q({0} астрономска јединица),
						'other' => q({0} астрономских јединица),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'1' => q(inanimate),
						'few' => q({0} центиметра),
						'name' => q(центиметри),
						'one' => q({0} центиметар),
						'other' => q({0} центиметара),
					},
					# Core Unit Identifier
					'centimeter' => {
						'1' => q(inanimate),
						'few' => q({0} центиметра),
						'name' => q(центиметри),
						'one' => q({0} центиметар),
						'other' => q({0} центиметара),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'1' => q(inanimate),
						'few' => q({0} дециметра),
						'name' => q(дециметри),
						'one' => q({0} дециметар),
						'other' => q({0} дециметара),
					},
					# Core Unit Identifier
					'decimeter' => {
						'1' => q(inanimate),
						'few' => q({0} дециметра),
						'name' => q(дециметри),
						'one' => q({0} дециметар),
						'other' => q({0} дециметара),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'few' => q({0} полупречник Земље),
						'name' => q(полупречник Земље),
						'one' => q({0} полупречник Земље),
						'other' => q({0} полупречника Земље),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'few' => q({0} полупречник Земље),
						'name' => q(полупречник Земље),
						'one' => q({0} полупречник Земље),
						'other' => q({0} полупречника Земље),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'few' => q({0} хвата),
						'name' => q(хвати),
						'one' => q({0} хват),
						'other' => q({0} хвати),
					},
					# Core Unit Identifier
					'fathom' => {
						'few' => q({0} хвата),
						'name' => q(хвати),
						'one' => q({0} хват),
						'other' => q({0} хвати),
					},
					# Long Unit Identifier
					'length-foot' => {
						'few' => q({0} стопе),
						'name' => q(стопе),
						'one' => q({0} стопа),
						'other' => q({0} стопа),
					},
					# Core Unit Identifier
					'foot' => {
						'few' => q({0} стопе),
						'name' => q(стопе),
						'one' => q({0} стопа),
						'other' => q({0} стопа),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'few' => q({0} фурлонга),
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонга),
					},
					# Core Unit Identifier
					'furlong' => {
						'few' => q({0} фурлонга),
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонга),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'1' => q(inanimate),
						'few' => q({0} километра),
						'name' => q(километри),
						'one' => q({0} километар),
						'other' => q({0} километара),
					},
					# Core Unit Identifier
					'kilometer' => {
						'1' => q(inanimate),
						'few' => q({0} километра),
						'name' => q(километри),
						'one' => q({0} километар),
						'other' => q({0} километара),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'few' => q({0} светлосне године),
						'name' => q(светлосне године),
						'one' => q({0} светлосна година),
						'other' => q({0} светлосних година),
					},
					# Core Unit Identifier
					'light-year' => {
						'few' => q({0} светлосне године),
						'name' => q(светлосне године),
						'one' => q({0} светлосна година),
						'other' => q({0} светлосних година),
					},
					# Long Unit Identifier
					'length-meter' => {
						'1' => q(inanimate),
						'few' => q({0} метра),
						'name' => q(метри),
						'one' => q({0} метар),
						'other' => q({0} метара),
					},
					# Core Unit Identifier
					'meter' => {
						'1' => q(inanimate),
						'few' => q({0} метра),
						'name' => q(метри),
						'one' => q({0} метар),
						'other' => q({0} метара),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'1' => q(inanimate),
						'few' => q({0} микрометра),
						'name' => q(микрометри),
						'one' => q({0} микрометар),
						'other' => q({0} микрометара),
					},
					# Core Unit Identifier
					'micrometer' => {
						'1' => q(inanimate),
						'few' => q({0} микрометра),
						'name' => q(микрометри),
						'one' => q({0} микрометар),
						'other' => q({0} микрометара),
					},
					# Long Unit Identifier
					'length-mile' => {
						'few' => q({0} миље),
						'one' => q({0} миља),
						'other' => q({0} миља),
					},
					# Core Unit Identifier
					'mile' => {
						'few' => q({0} миље),
						'one' => q({0} миља),
						'other' => q({0} миља),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'1' => q(feminine),
						'few' => q({0} скандинавске миље),
						'name' => q(скандинавска миља),
						'one' => q({0} скандинавска миља),
						'other' => q({0} скандинавских миља),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'1' => q(feminine),
						'few' => q({0} скандинавске миље),
						'name' => q(скандинавска миља),
						'one' => q({0} скандинавска миља),
						'other' => q({0} скандинавских миља),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'1' => q(inanimate),
						'few' => q({0} милиметра),
						'name' => q(милиметри),
						'one' => q({0} милиметар),
						'other' => q({0} милиметара),
					},
					# Core Unit Identifier
					'millimeter' => {
						'1' => q(inanimate),
						'few' => q({0} милиметра),
						'name' => q(милиметри),
						'one' => q({0} милиметар),
						'other' => q({0} милиметара),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'1' => q(inanimate),
						'few' => q({0} нанометра),
						'name' => q(нанометри),
						'one' => q({0} нанометар),
						'other' => q({0} нанометара),
					},
					# Core Unit Identifier
					'nanometer' => {
						'1' => q(inanimate),
						'few' => q({0} нанометра),
						'name' => q(нанометри),
						'one' => q({0} нанометар),
						'other' => q({0} нанометара),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'few' => q({0} наутичке миље),
						'name' => q(наутичке миље),
						'one' => q({0} наутичка миља),
						'other' => q({0} наутичких миља),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'few' => q({0} наутичке миље),
						'name' => q(наутичке миље),
						'one' => q({0} наутичка миља),
						'other' => q({0} наутичких миља),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'few' => q({0} парсека),
						'one' => q({0} парсек),
						'other' => q({0} парсека),
					},
					# Core Unit Identifier
					'parsec' => {
						'few' => q({0} парсека),
						'one' => q({0} парсек),
						'other' => q({0} парсека),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'1' => q(inanimate),
						'few' => q({0} пикометра),
						'one' => q({0} пикометар),
						'other' => q({0} пикометара),
					},
					# Core Unit Identifier
					'picometer' => {
						'1' => q(inanimate),
						'few' => q({0} пикометра),
						'one' => q({0} пикометар),
						'other' => q({0} пикометара),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'few' => q({0} сунчева полупречника),
						'name' => q(сунчеви полупречници),
						'one' => q({0} сунчев полупречник),
						'other' => q({0} сунчевих полупречника),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'few' => q({0} сунчева полупречника),
						'name' => q(сунчеви полупречници),
						'one' => q({0} сунчев полупречник),
						'other' => q({0} сунчевих полупречника),
					},
					# Long Unit Identifier
					'length-yard' => {
						'few' => q({0} јарда),
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					# Core Unit Identifier
					'yard' => {
						'few' => q({0} јарда),
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					# Long Unit Identifier
					'light-candela' => {
						'1' => q(feminine),
						'few' => q({0} канделе),
						'name' => q(кандела),
						'one' => q({0} кандела),
						'other' => q({0} кандела),
					},
					# Core Unit Identifier
					'candela' => {
						'1' => q(feminine),
						'few' => q({0} канделе),
						'name' => q(кандела),
						'one' => q({0} кандела),
						'other' => q({0} кандела),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'1' => q(inanimate),
						'few' => q({0} лумена),
						'name' => q(лумен),
						'one' => q({0} лумен),
						'other' => q({0} лумена),
					},
					# Core Unit Identifier
					'lumen' => {
						'1' => q(inanimate),
						'few' => q({0} лумена),
						'name' => q(лумен),
						'one' => q({0} лумен),
						'other' => q({0} лумена),
					},
					# Long Unit Identifier
					'light-lux' => {
						'1' => q(inanimate),
						'few' => q({0} лукса),
						'name' => q(лукс),
						'one' => q({0} лукс),
						'other' => q({0} лукса),
					},
					# Core Unit Identifier
					'lux' => {
						'1' => q(inanimate),
						'few' => q({0} лукса),
						'name' => q(лукс),
						'one' => q({0} лукс),
						'other' => q({0} лукса),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'1' => q(inanimate),
						'few' => q({0} карата),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					# Core Unit Identifier
					'carat' => {
						'1' => q(inanimate),
						'few' => q({0} карата),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'few' => q({0} далтона),
						'name' => q(далтони),
						'one' => q({0} далтон),
						'other' => q({0} далтона),
					},
					# Core Unit Identifier
					'dalton' => {
						'few' => q({0} далтона),
						'name' => q(далтони),
						'one' => q({0} далтон),
						'other' => q({0} далтона),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'few' => q({0} масе земље),
						'name' => q(масе земље),
						'one' => q({0} маса земље),
						'other' => q({0} маса земље),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'few' => q({0} масе земље),
						'name' => q(масе земље),
						'one' => q({0} маса земље),
						'other' => q({0} маса земље),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'few' => q({0} грејна),
						'one' => q({0} грејн),
						'other' => q({0} грејна),
					},
					# Core Unit Identifier
					'grain' => {
						'few' => q({0} грејна),
						'one' => q({0} грејн),
						'other' => q({0} грејна),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'1' => q(inanimate),
						'few' => q({0} грама),
						'one' => q({0} грам),
						'other' => q({0} грама),
						'per' => q({0} по граму),
					},
					# Core Unit Identifier
					'gram' => {
						'1' => q(inanimate),
						'few' => q({0} грама),
						'one' => q({0} грам),
						'other' => q({0} грама),
						'per' => q({0} по граму),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'1' => q(inanimate),
						'few' => q({0} килограма),
						'name' => q(килограми),
						'one' => q({0} килограм),
						'other' => q({0} килограма),
						'per' => q({0} по килограму),
					},
					# Core Unit Identifier
					'kilogram' => {
						'1' => q(inanimate),
						'few' => q({0} килограма),
						'name' => q(килограми),
						'one' => q({0} килограм),
						'other' => q({0} килограма),
						'per' => q({0} по килограму),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'1' => q(inanimate),
						'few' => q({0} микрограма),
						'name' => q(микрограми),
						'one' => q({0} микрограм),
						'other' => q({0} микрограма),
					},
					# Core Unit Identifier
					'microgram' => {
						'1' => q(inanimate),
						'few' => q({0} микрограма),
						'name' => q(микрограми),
						'one' => q({0} микрограм),
						'other' => q({0} микрограма),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'1' => q(inanimate),
						'few' => q({0} милиграма),
						'name' => q(милиграми),
						'one' => q({0} милиграм),
						'other' => q({0} милиграма),
					},
					# Core Unit Identifier
					'milligram' => {
						'1' => q(inanimate),
						'few' => q({0} милиграма),
						'name' => q(милиграми),
						'one' => q({0} милиграм),
						'other' => q({0} милиграма),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'few' => q({0} унце),
						'name' => q(унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
						'per' => q({0} по унци),
					},
					# Core Unit Identifier
					'ounce' => {
						'few' => q({0} унце),
						'name' => q(унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
						'per' => q({0} по унци),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'few' => q({0} фине унце),
						'name' => q(фине унце),
						'one' => q({0} фина унца),
						'other' => q({0} финих унци),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'few' => q({0} фине унце),
						'name' => q(фине унце),
						'one' => q({0} фина унца),
						'other' => q({0} финих унци),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'few' => q({0} фунте),
						'name' => q(фунте),
						'one' => q({0} фунта),
						'other' => q({0} фунти),
						'per' => q({0} по фунти),
					},
					# Core Unit Identifier
					'pound' => {
						'few' => q({0} фунте),
						'name' => q(фунте),
						'one' => q({0} фунта),
						'other' => q({0} фунти),
						'per' => q({0} по фунти),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'few' => q({0} масе сунца),
						'name' => q(масе сунца),
						'one' => q({0} маса сунца),
						'other' => q({0} маса сунца),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'few' => q({0} масе сунца),
						'name' => q(масе сунца),
						'one' => q({0} маса сунца),
						'other' => q({0} маса сунца),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'few' => q({0} америчке тоне),
						'name' => q(америчке тоне),
						'one' => q({0} америчка тона),
						'other' => q({0} америчких тона),
					},
					# Core Unit Identifier
					'stone' => {
						'few' => q({0} америчке тоне),
						'name' => q(америчке тоне),
						'one' => q({0} америчка тона),
						'other' => q({0} америчких тона),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'few' => q({0} тоне),
						'name' => q(тоне),
						'one' => q({0} тона),
						'other' => q({0} тона),
					},
					# Core Unit Identifier
					'ton' => {
						'few' => q({0} тоне),
						'name' => q(тоне),
						'one' => q({0} тона),
						'other' => q({0} тона),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'1' => q(feminine),
						'few' => q({0} метричке тоне),
						'name' => q(метричке тоне),
						'one' => q({0} метричка тона),
						'other' => q({0} метричких тона),
					},
					# Core Unit Identifier
					'tonne' => {
						'1' => q(feminine),
						'few' => q({0} метричке тоне),
						'name' => q(метричке тоне),
						'one' => q({0} метричка тона),
						'other' => q({0} метричких тона),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'1' => q(inanimate),
						'few' => q({0} гигавата),
						'name' => q(гигавати),
						'one' => q({0} гигават),
						'other' => q({0} гигавати),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'1' => q(inanimate),
						'few' => q({0} гигавата),
						'name' => q(гигавати),
						'one' => q({0} гигават),
						'other' => q({0} гигавати),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'few' => q({0} коњске снаге),
						'name' => q(коњске снаге),
						'one' => q({0} коњска снага),
						'other' => q({0} коњских снага),
					},
					# Core Unit Identifier
					'horsepower' => {
						'few' => q({0} коњске снаге),
						'name' => q(коњске снаге),
						'one' => q({0} коњска снага),
						'other' => q({0} коњских снага),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'1' => q(inanimate),
						'few' => q({0} киловата),
						'name' => q(киловати),
						'one' => q({0} киловат),
						'other' => q({0} киловати),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'1' => q(inanimate),
						'few' => q({0} киловата),
						'name' => q(киловати),
						'one' => q({0} киловат),
						'other' => q({0} киловати),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'1' => q(inanimate),
						'few' => q({0} мегавата),
						'name' => q(мегавати),
						'one' => q({0} мегават),
						'other' => q({0} мегавати),
					},
					# Core Unit Identifier
					'megawatt' => {
						'1' => q(inanimate),
						'few' => q({0} мегавата),
						'name' => q(мегавати),
						'one' => q({0} мегават),
						'other' => q({0} мегавати),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'1' => q(inanimate),
						'few' => q({0} миливата),
						'name' => q(миливати),
						'one' => q({0} миливат),
						'other' => q({0} миливати),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'1' => q(inanimate),
						'few' => q({0} миливата),
						'name' => q(миливати),
						'one' => q({0} миливат),
						'other' => q({0} миливати),
					},
					# Long Unit Identifier
					'power-watt' => {
						'1' => q(inanimate),
						'few' => q({0} вата),
						'name' => q(вати),
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					# Core Unit Identifier
					'watt' => {
						'1' => q(inanimate),
						'few' => q({0} вата),
						'name' => q(вати),
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(квадратни {0}),
						'few' => q(квадратна {0}),
						'one' => q(квадратни {0}),
						'other' => q(квадратних {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(квадратни {0}),
						'few' => q(квадратна {0}),
						'one' => q(квадратни {0}),
						'other' => q(квадратних {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(кубни {0}),
						'few' => q(кубна {0}),
						'one' => q(кубни {0}),
						'other' => q(кубних {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(кубни {0}),
						'few' => q(кубна {0}),
						'one' => q(кубни {0}),
						'other' => q(кубних {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'1' => q(feminine),
						'few' => q({0} атмосфере),
						'name' => q(атмосфере),
						'one' => q({0} атмосфера),
						'other' => q({0} атмосфера),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'1' => q(feminine),
						'few' => q({0} атмосфере),
						'name' => q(атмосфере),
						'one' => q({0} атмосфера),
						'other' => q({0} атмосфера),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'1' => q(inanimate),
						'few' => q({0} бара),
						'name' => q(бари),
						'one' => q({0} бар),
						'other' => q({0} бара),
					},
					# Core Unit Identifier
					'bar' => {
						'1' => q(inanimate),
						'few' => q({0} бара),
						'name' => q(бари),
						'one' => q({0} бар),
						'other' => q({0} бара),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'1' => q(inanimate),
						'few' => q({0} хектопаскала),
						'name' => q(хектопаскали),
						'one' => q({0} хектопаскал),
						'other' => q({0} хектопаскала),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'1' => q(inanimate),
						'few' => q({0} хектопаскала),
						'name' => q(хектопаскали),
						'one' => q({0} хектопаскал),
						'other' => q({0} хектопаскала),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'few' => q({0} инча живиног стуба),
						'name' => q(инчи живиног стуба),
						'one' => q({0} инч живиног стуба),
						'other' => q({0} инча живиног стуба),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'few' => q({0} инча живиног стуба),
						'name' => q(инчи живиног стуба),
						'one' => q({0} инч живиног стуба),
						'other' => q({0} инча живиног стуба),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'1' => q(inanimate),
						'few' => q({0} килопаскала),
						'name' => q(килопаскали),
						'one' => q({0} килопаскал),
						'other' => q({0} килопаскала),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'1' => q(inanimate),
						'few' => q({0} килопаскала),
						'name' => q(килопаскали),
						'one' => q({0} килопаскал),
						'other' => q({0} килопаскала),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'1' => q(inanimate),
						'few' => q({0} мегапаскала),
						'name' => q(мегапаскали),
						'one' => q({0} мегапаскал),
						'other' => q({0} мегапаскала),
					},
					# Core Unit Identifier
					'megapascal' => {
						'1' => q(inanimate),
						'few' => q({0} мегапаскала),
						'name' => q(мегапаскали),
						'one' => q({0} мегапаскал),
						'other' => q({0} мегапаскала),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'1' => q(inanimate),
						'few' => q({0} милибара),
						'name' => q(милибари),
						'one' => q({0} милибар),
						'other' => q({0} милибара),
					},
					# Core Unit Identifier
					'millibar' => {
						'1' => q(inanimate),
						'few' => q({0} милибара),
						'name' => q(милибари),
						'one' => q({0} милибар),
						'other' => q({0} милибара),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'few' => q({0} милиметра живиног стуба),
						'name' => q(милиметри живиног стуба),
						'one' => q({0} милиметар живиног стуба),
						'other' => q({0} милиметара живиног стуба),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'few' => q({0} милиметра живиног стуба),
						'name' => q(милиметри живиног стуба),
						'one' => q({0} милиметар живиног стуба),
						'other' => q({0} милиметара живиног стуба),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'1' => q(inanimate),
						'few' => q({0} паскала),
						'name' => q(паскали),
						'one' => q({0} паскал),
						'other' => q({0} паскала),
					},
					# Core Unit Identifier
					'pascal' => {
						'1' => q(inanimate),
						'few' => q({0} паскала),
						'name' => q(паскали),
						'one' => q({0} паскал),
						'other' => q({0} паскала),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'few' => q({0} фунте по квадратном инчу),
						'name' => q(фунте по квадратном инчу),
						'one' => q({0} фунта по квадратном инчу),
						'other' => q({0} фунти по квадратном инчу),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'few' => q({0} фунте по квадратном инчу),
						'name' => q(фунте по квадратном инчу),
						'one' => q({0} фунта по квадратном инчу),
						'other' => q({0} фунти по квадратном инчу),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'few' => q(Б {0}),
						'name' => q(Бофор),
						'one' => q(Бофор {0}),
						'other' => q(Бофор {0}),
					},
					# Core Unit Identifier
					'beaufort' => {
						'few' => q(Б {0}),
						'name' => q(Бофор),
						'one' => q(Бофор {0}),
						'other' => q(Бофор {0}),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'1' => q(inanimate),
						'few' => q({0} километра на сат),
						'name' => q(километри на сат),
						'one' => q({0} километар на сат),
						'other' => q({0} километара на сат),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'1' => q(inanimate),
						'few' => q({0} километра на сат),
						'name' => q(километри на сат),
						'one' => q({0} километар на сат),
						'other' => q({0} километара на сат),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'few' => q({0} чвора),
						'name' => q(чвор),
						'one' => q({0} чвор),
						'other' => q({0} чворова),
					},
					# Core Unit Identifier
					'knot' => {
						'few' => q({0} чвора),
						'name' => q(чвор),
						'one' => q({0} чвор),
						'other' => q({0} чворова),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'1' => q(inanimate),
						'few' => q({0} метра у секунди),
						'one' => q({0} метар у секунди),
						'other' => q({0} метара у секунди),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'1' => q(inanimate),
						'few' => q({0} метра у секунди),
						'one' => q({0} метар у секунди),
						'other' => q({0} метара у секунди),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'few' => q({0} миље на сат),
						'one' => q({0} миља на сат),
						'other' => q({0} миља на сат),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'few' => q({0} миље на сат),
						'one' => q({0} миља на сат),
						'other' => q({0} миља на сат),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'1' => q(inanimate),
						'few' => q({0} степена Целзијуса),
						'name' => q(степени Целзијуса),
						'one' => q({0} степен Целзијуса),
						'other' => q({0} степени Целзијуса),
					},
					# Core Unit Identifier
					'celsius' => {
						'1' => q(inanimate),
						'few' => q({0} степена Целзијуса),
						'name' => q(степени Целзијуса),
						'one' => q({0} степен Целзијуса),
						'other' => q({0} степени Целзијуса),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'few' => q({0} степена Фаренхајта),
						'one' => q({0} степен Фаренхајта),
						'other' => q({0} степени Фаренхајта),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'few' => q({0} степена Фаренхајта),
						'one' => q({0} степен Фаренхајта),
						'other' => q({0} степени Фаренхајта),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'1' => q(inanimate),
					},
					# Core Unit Identifier
					'generic' => {
						'1' => q(inanimate),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'1' => q(inanimate),
						'few' => q({0} келвина),
						'name' => q(келвин),
						'one' => q({0} келвин),
						'other' => q({0} келвина),
					},
					# Core Unit Identifier
					'kelvin' => {
						'1' => q(inanimate),
						'few' => q({0} келвина),
						'name' => q(келвин),
						'one' => q({0} келвин),
						'other' => q({0} келвина),
					},
					# Long Unit Identifier
					'times' => {
						'1' => q({0}-{1}),
					},
					# Core Unit Identifier
					'times' => {
						'1' => q({0}-{1}),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'1' => q(inanimate),
						'few' => q({0} њутн-метра),
						'name' => q(њутн-метри),
						'one' => q({0} њутн-метар),
						'other' => q({0} њутн-метара),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'1' => q(inanimate),
						'few' => q({0} њутн-метра),
						'name' => q(њутн-метри),
						'one' => q({0} њутн-метар),
						'other' => q({0} њутн-метара),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'few' => q({0} фунте силе стопе),
						'name' => q(фунта-стопе),
						'one' => q({0} фунта силе стопе),
						'other' => q({0} фунти силе стопе),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'few' => q({0} фунте силе стопе),
						'name' => q(фунта-стопе),
						'one' => q({0} фунта силе стопе),
						'other' => q({0} фунти силе стопе),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'few' => q({0} акер стопе),
						'name' => q(акер стопе),
						'one' => q({0} акер стопа),
						'other' => q({0} акер стопа),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'few' => q({0} акер стопе),
						'name' => q(акер стопе),
						'one' => q({0} акер стопа),
						'other' => q({0} акер стопа),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'few' => q({0} барела),
						'name' => q(барели),
						'one' => q({0} барел),
						'other' => q({0} барела),
					},
					# Core Unit Identifier
					'barrel' => {
						'few' => q({0} барела),
						'name' => q(барели),
						'one' => q({0} барел),
						'other' => q({0} барела),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'few' => q({0} бушела),
						'name' => q(бушели),
						'one' => q({0} бушел),
						'other' => q({0} бушела),
					},
					# Core Unit Identifier
					'bushel' => {
						'few' => q({0} бушела),
						'name' => q(бушели),
						'one' => q({0} бушел),
						'other' => q({0} бушела),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'1' => q(inanimate),
						'few' => q({0} центилитра),
						'name' => q(центилитри),
						'one' => q({0} центилитар),
						'other' => q({0} центилитара),
					},
					# Core Unit Identifier
					'centiliter' => {
						'1' => q(inanimate),
						'few' => q({0} центилитра),
						'name' => q(центилитри),
						'one' => q({0} центилитар),
						'other' => q({0} центилитара),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'1' => q(inanimate),
						'few' => q({0} кубна центиметра),
						'name' => q(кубни центиметри),
						'one' => q({0} кубни центиметар),
						'other' => q({0} кубних центиметара),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'1' => q(inanimate),
						'few' => q({0} кубна центиметра),
						'name' => q(кубни центиметри),
						'one' => q({0} кубни центиметар),
						'other' => q({0} кубних центиметара),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'few' => q({0} кубне стопе),
						'name' => q(кубне стопе),
						'one' => q({0} кубна стопа),
						'other' => q({0} кубних стопа),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'few' => q({0} кубне стопе),
						'name' => q(кубне стопе),
						'one' => q({0} кубна стопа),
						'other' => q({0} кубних стопа),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'few' => q({0} кубна инча),
						'name' => q(кубни инчи),
						'one' => q({0} кубни инч),
						'other' => q({0} кубних инча),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'few' => q({0} кубна инча),
						'name' => q(кубни инчи),
						'one' => q({0} кубни инч),
						'other' => q({0} кубних инча),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'1' => q(inanimate),
						'few' => q({0} кубна километра),
						'name' => q(кубни километри),
						'one' => q({0} кубни километар),
						'other' => q({0} кубних километара),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'1' => q(inanimate),
						'few' => q({0} кубна километра),
						'name' => q(кубни километри),
						'one' => q({0} кубни километар),
						'other' => q({0} кубних километара),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'1' => q(inanimate),
						'few' => q({0} кубна метра),
						'name' => q(кубни метри),
						'one' => q({0} кубни метар),
						'other' => q({0} кубних метара),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'1' => q(inanimate),
						'few' => q({0} кубна метра),
						'name' => q(кубни метри),
						'one' => q({0} кубни метар),
						'other' => q({0} кубних метара),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'few' => q({0} кубне миље),
						'name' => q(кубне миље),
						'one' => q({0} кубна миља),
						'other' => q({0} кубних миља),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'few' => q({0} кубне миље),
						'name' => q(кубне миље),
						'one' => q({0} кубна миља),
						'other' => q({0} кубних миља),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'few' => q({0} кубна јарда),
						'name' => q(кубни јарди),
						'one' => q({0} кубни јард),
						'other' => q({0} кубних јарди),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'few' => q({0} кубна јарда),
						'name' => q(кубни јарди),
						'one' => q({0} кубни јард),
						'other' => q({0} кубних јарди),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'few' => q({0} шоље),
						'one' => q({0} шоља),
						'other' => q({0} шоља),
					},
					# Core Unit Identifier
					'cup' => {
						'few' => q({0} шоље),
						'one' => q({0} шоља),
						'other' => q({0} шоља),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'1' => q(feminine),
						'few' => q({0} метричке шоље),
						'name' => q(метричка шоља),
						'one' => q({0} метричка шоља),
						'other' => q({0} метричких шоља),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'1' => q(feminine),
						'few' => q({0} метричке шоље),
						'name' => q(метричка шоља),
						'one' => q({0} метричка шоља),
						'other' => q({0} метричких шоља),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'1' => q(inanimate),
						'few' => q({0} децилитра),
						'name' => q(децилитри),
						'one' => q({0} децилитар),
						'other' => q({0} децилитара),
					},
					# Core Unit Identifier
					'deciliter' => {
						'1' => q(inanimate),
						'few' => q({0} децилитра),
						'name' => q(децилитри),
						'one' => q({0} децилитар),
						'other' => q({0} децилитара),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'few' => q({0} десертне кашичице),
						'name' => q(десертна кашичица),
						'one' => q({0} десертна кашичица),
						'other' => q({0} десертних кашичица),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'few' => q({0} десертне кашичице),
						'name' => q(десертна кашичица),
						'one' => q({0} десертна кашичица),
						'other' => q({0} десертних кашичица),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'few' => q({0} империјске десертне кашичице),
						'name' => q(империјска десертна кашичица),
						'one' => q({0} империјска десертна кашичица),
						'other' => q({0} империјских десертних кашичица),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'few' => q({0} империјске десертне кашичице),
						'name' => q(империјска десертна кашичица),
						'one' => q({0} империјска десертна кашичица),
						'other' => q({0} империјских десертних кашичица),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'few' => q({0} драма течности),
						'one' => q({0} драм течности),
						'other' => q({0} драма течности),
					},
					# Core Unit Identifier
					'dram' => {
						'few' => q({0} драма течности),
						'one' => q({0} драм течности),
						'other' => q({0} драма течности),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'few' => q({0} унце течности),
						'name' => q(унце течности),
						'one' => q({0} унца течности),
						'other' => q({0} унци течности),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'few' => q({0} унце течности),
						'name' => q(унце течности),
						'one' => q({0} унца течности),
						'other' => q({0} унци течности),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'few' => q({0} империјске унце течности),
						'name' => q(империјске унце течности),
						'one' => q({0} империјска унца течности),
						'other' => q({0} империјских унци течности),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'few' => q({0} империјске унце течности),
						'name' => q(империјске унце течности),
						'one' => q({0} империјска унца течности),
						'other' => q({0} империјских унци течности),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'few' => q({0} галона),
						'name' => q(галони),
						'one' => q({0} галон),
						'other' => q({0} галона),
						'per' => q({0} по галону),
					},
					# Core Unit Identifier
					'gallon' => {
						'few' => q({0} галона),
						'name' => q(галони),
						'one' => q({0} галон),
						'other' => q({0} галона),
						'per' => q({0} по галону),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'few' => q({0} имп. галона),
						'name' => q(империјални галон),
						'one' => q({0} имп. галон),
						'other' => q({0} имп. галона),
						'per' => q({0} по имп. галону),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'few' => q({0} имп. галона),
						'name' => q(империјални галон),
						'one' => q({0} имп. галон),
						'other' => q({0} имп. галона),
						'per' => q({0} по имп. галону),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'1' => q(inanimate),
						'few' => q({0} хектолитра),
						'name' => q(хектолитри),
						'one' => q({0} хектолитар),
						'other' => q({0} хектолитара),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'1' => q(inanimate),
						'few' => q({0} хектолитра),
						'name' => q(хектолитри),
						'one' => q({0} хектолитар),
						'other' => q({0} хектолитара),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'1' => q(inanimate),
						'few' => q({0} литра),
						'one' => q({0} литар),
						'other' => q({0} литара),
						'per' => q({0} по литри),
					},
					# Core Unit Identifier
					'liter' => {
						'1' => q(inanimate),
						'few' => q({0} литра),
						'one' => q({0} литар),
						'other' => q({0} литара),
						'per' => q({0} по литри),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'1' => q(inanimate),
						'few' => q({0} мегалитра),
						'name' => q(мегалитри),
						'one' => q({0} мегалитар),
						'other' => q({0} мегалитара),
					},
					# Core Unit Identifier
					'megaliter' => {
						'1' => q(inanimate),
						'few' => q({0} мегалитра),
						'name' => q(мегалитри),
						'one' => q({0} мегалитар),
						'other' => q({0} мегалитара),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'1' => q(inanimate),
						'few' => q({0} милилитра),
						'name' => q(милилитри),
						'one' => q({0} милилитар),
						'other' => q({0} милилитара),
					},
					# Core Unit Identifier
					'milliliter' => {
						'1' => q(inanimate),
						'few' => q({0} милилитра),
						'name' => q(милилитри),
						'one' => q({0} милилитар),
						'other' => q({0} милилитара),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'few' => q({0} пинте),
						'name' => q(пинте),
						'one' => q({0} пинта),
						'other' => q({0} пинти),
					},
					# Core Unit Identifier
					'pint' => {
						'few' => q({0} пинте),
						'name' => q(пинте),
						'one' => q({0} пинта),
						'other' => q({0} пинти),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'1' => q(feminine),
						'few' => q({0} метричке пинте),
						'name' => q(метричке пинте),
						'one' => q({0} метричка пинта),
						'other' => q({0} метричких пинти),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'1' => q(feminine),
						'few' => q({0} метричке пинте),
						'name' => q(метричке пинте),
						'one' => q({0} метричка пинта),
						'other' => q({0} метричких пинти),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'few' => q({0} кварта),
						'name' => q(кварти),
						'one' => q({0} кварат),
						'other' => q({0} кварата),
					},
					# Core Unit Identifier
					'quart' => {
						'few' => q({0} кварта),
						'name' => q(кварти),
						'one' => q({0} кварат),
						'other' => q({0} кварата),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'few' => q({0} империјске четвртине),
						'name' => q(империјска четвртина),
						'one' => q({0} империјска четвртина),
						'other' => q({0} империјских четвртина),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'few' => q({0} империјске четвртине),
						'name' => q(империјска четвртина),
						'one' => q({0} империјска четвртина),
						'other' => q({0} империјских четвртина),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'few' => q({0} кашике),
						'name' => q(кашике),
						'one' => q({0} кашика),
						'other' => q({0} кашика),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'few' => q({0} кашике),
						'name' => q(кашике),
						'one' => q({0} кашика),
						'other' => q({0} кашика),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'few' => q({0} кашичице),
						'name' => q(кашичице),
						'one' => q({0} кашичица),
						'other' => q({0} кашичица),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'few' => q({0} кашичице),
						'name' => q(кашичице),
						'one' => q({0} кашичица),
						'other' => q({0} кашичица),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'few' => q({0} L/100km),
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'few' => q({0} L/100km),
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'few' => q({0} mpg Imp),
						'name' => q(mpg Imp),
						'one' => q({0} mpg Imp),
						'other' => q({0} mpg Imp),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'few' => q({0} mpg Imp),
						'name' => q(mpg Imp),
						'one' => q({0} mpg Imp),
						'other' => q({0} mpg Imp),
					},
					# Long Unit Identifier
					'duration-day' => {
						'few' => q({0} д),
						'name' => q(д),
						'one' => q({0} д),
						'other' => q({0} д),
					},
					# Core Unit Identifier
					'day' => {
						'few' => q({0} д),
						'name' => q(д),
						'one' => q({0} д),
						'other' => q({0} д),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'few' => q({0} ч),
						'name' => q(ч),
						'one' => q({0} ч),
						'other' => q({0} ч),
					},
					# Core Unit Identifier
					'hour' => {
						'few' => q({0} ч),
						'name' => q(ч),
						'one' => q({0} ч),
						'other' => q({0} ч),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'few' => q({0} м),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					# Core Unit Identifier
					'minute' => {
						'few' => q({0} м),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					# Long Unit Identifier
					'duration-month' => {
						'few' => q({0} м),
						'name' => q(м.),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					# Core Unit Identifier
					'month' => {
						'few' => q({0} м),
						'name' => q(м.),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'few' => q({0} к),
						'one' => q({0} к),
						'other' => q({0} к),
					},
					# Core Unit Identifier
					'quarter' => {
						'few' => q({0} к),
						'one' => q({0} к),
						'other' => q({0} к),
					},
					# Long Unit Identifier
					'duration-second' => {
						'few' => q({0} с),
						'name' => q(с),
						'one' => q({0} с),
						'other' => q({0} с),
					},
					# Core Unit Identifier
					'second' => {
						'few' => q({0} с),
						'name' => q(с),
						'one' => q({0} с),
						'other' => q({0} с),
					},
					# Long Unit Identifier
					'duration-week' => {
						'few' => q({0} н),
						'name' => q(н.),
						'one' => q({0} н),
						'other' => q({0} н),
					},
					# Core Unit Identifier
					'week' => {
						'few' => q({0} н),
						'name' => q(н.),
						'one' => q({0} н),
						'other' => q({0} н),
					},
					# Long Unit Identifier
					'duration-year' => {
						'few' => q({0} г),
						'name' => q(г.),
						'one' => q({0} г),
						'other' => q({0} г),
					},
					# Core Unit Identifier
					'year' => {
						'few' => q({0} г),
						'name' => q(г.),
						'one' => q({0} г),
						'other' => q({0} г),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(eV),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(eV),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(фурлонг),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(фурлонг),
					},
					# Long Unit Identifier
					'length-inch' => {
						'few' => q({0} in),
						'name' => q(in),
						'one' => q({0} in),
						'other' => q({0} in),
					},
					# Core Unit Identifier
					'inch' => {
						'few' => q({0} in),
						'name' => q(in),
						'one' => q({0} in),
						'other' => q({0} in),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'few' => q({0} ly),
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					# Core Unit Identifier
					'light-year' => {
						'few' => q({0} ly),
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					# Long Unit Identifier
					'length-mile' => {
						'few' => q({0} миље),
						'one' => q({0} миља),
						'other' => q({0} миља),
					},
					# Core Unit Identifier
					'mile' => {
						'few' => q({0} миље),
						'one' => q({0} миља),
						'other' => q({0} миља),
					},
					# Long Unit Identifier
					'length-yard' => {
						'few' => q({0} yd),
						'name' => q(yd),
						'one' => q({0} yd),
						'other' => q({0} yd),
					},
					# Core Unit Identifier
					'yard' => {
						'few' => q({0} yd),
						'name' => q(yd),
						'one' => q({0} yd),
						'other' => q({0} yd),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(g),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(g),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'few' => q({0} унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					# Core Unit Identifier
					'ounce' => {
						'few' => q({0} унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'few' => q({0} кс),
						'one' => q({0} кс),
						'other' => q({0} кс),
					},
					# Core Unit Identifier
					'horsepower' => {
						'few' => q({0} кс),
						'one' => q({0} кс),
						'other' => q({0} кс),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'few' => q({0} fl oz Imp),
						'name' => q(Imp fl oz),
						'one' => q({0} fl oz Imp),
						'other' => q({0} fl oz Imp),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'few' => q({0} fl oz Imp),
						'name' => q(Imp fl oz),
						'one' => q({0} fl oz Imp),
						'other' => q({0} fl oz Imp),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'few' => q({0}/gal Imp),
						'name' => q(Imp gal),
						'one' => q({0}/gal Imp),
						'other' => q({0}/gal Imp),
						'per' => q({0}/gal Imp),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'few' => q({0}/gal Imp),
						'name' => q(Imp gal),
						'one' => q({0}/gal Imp),
						'other' => q({0}/gal Imp),
						'per' => q({0}/gal Imp),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'few' => q({0} џигера),
						'one' => q({0} џигера),
						'other' => q({0} џигера),
					},
					# Core Unit Identifier
					'jigger' => {
						'few' => q({0} џигера),
						'one' => q({0} џигера),
						'other' => q({0} џигера),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(l),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(l),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'few' => q({0} pn),
						'one' => q({0} pn),
						'other' => q({0} pn),
					},
					# Core Unit Identifier
					'pinch' => {
						'few' => q({0} pn),
						'one' => q({0} pn),
						'other' => q({0} pn),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'few' => q({0} qt Imp),
						'one' => q({0} qt Imp),
						'other' => q({0} qt Imp),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'few' => q({0} qt Imp),
						'one' => q({0} qt Imp),
						'other' => q({0} qt Imp),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(правац),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(правац),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(ге сила),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(ге сила),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(лучни мин),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(лучни мин),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(лучне сек),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(лучне сек),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(степени),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(степени),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(акери),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(акери),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'few' => q({0} дунама),
						'name' => q(дунами),
						'one' => q({0} дунам),
						'other' => q({0} дунама),
					},
					# Core Unit Identifier
					'dunam' => {
						'few' => q({0} дунама),
						'name' => q(дунами),
						'one' => q({0} дунам),
						'other' => q({0} дунама),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(хектари),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(хектари),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(квадратне стопе),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(квадратне стопе),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(квадратни километри),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(квадратни километри),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(квадратни метри),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(квадратни метри),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'few' => q({0} ставке),
						'name' => q(ставка),
						'one' => q({0} ставка),
						'other' => q({0} ставки),
					},
					# Core Unit Identifier
					'item' => {
						'few' => q({0} ставке),
						'name' => q(ставка),
						'one' => q({0} ставка),
						'other' => q({0} ставки),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(проценат),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(проценат),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(промил),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(промил),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'few' => q({0} L/100 km),
						'name' => q(L/100 km),
						'one' => q({0} L/100 km),
						'other' => q({0} L/100 km),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'few' => q({0} L/100 km),
						'name' => q(L/100 km),
						'one' => q({0} L/100 km),
						'other' => q({0} L/100 km),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'few' => q({0} mpg),
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'few' => q({0} mpg),
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}И),
						'north' => q({0}С),
						'south' => q({0}Ј),
						'west' => q({0}З),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}И),
						'north' => q({0}С),
						'south' => q({0}Ј),
						'west' => q({0}З),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'few' => q({0} b),
						'name' => q(бит),
						'one' => q({0} b),
						'other' => q({0} b),
					},
					# Core Unit Identifier
					'bit' => {
						'few' => q({0} b),
						'name' => q(бит),
						'one' => q({0} b),
						'other' => q({0} b),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'few' => q({0} B),
						'name' => q(бајт),
						'one' => q({0} B),
						'other' => q({0} B),
					},
					# Core Unit Identifier
					'byte' => {
						'few' => q({0} B),
						'name' => q(бајт),
						'one' => q({0} B),
						'other' => q({0} B),
					},
					# Long Unit Identifier
					'duration-century' => {
						'few' => q({0} в),
						'name' => q(в.),
						'one' => q({0} в),
						'other' => q({0} в),
					},
					# Core Unit Identifier
					'century' => {
						'few' => q({0} в),
						'name' => q(в.),
						'one' => q({0} в),
						'other' => q({0} в),
					},
					# Long Unit Identifier
					'duration-day' => {
						'few' => q({0} дана),
						'name' => q(д.),
						'one' => q({0} дан),
						'other' => q({0} дана),
						'per' => q({0}/д),
					},
					# Core Unit Identifier
					'day' => {
						'few' => q({0} дана),
						'name' => q(д.),
						'one' => q({0} дан),
						'other' => q({0} дана),
						'per' => q({0}/д),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'few' => q({0} дец.),
						'name' => q(дец.),
						'one' => q({0} дец.),
						'other' => q({0} дец.),
					},
					# Core Unit Identifier
					'decade' => {
						'few' => q({0} дец.),
						'name' => q(дец.),
						'one' => q({0} дец.),
						'other' => q({0} дец.),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'few' => q({0} сата),
						'name' => q(сати),
						'one' => q({0} сат),
						'other' => q({0} сати),
						'per' => q({0}/ч),
					},
					# Core Unit Identifier
					'hour' => {
						'few' => q({0} сата),
						'name' => q(сати),
						'one' => q({0} сат),
						'other' => q({0} сати),
						'per' => q({0}/ч),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'few' => q({0} мин),
						'name' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					# Core Unit Identifier
					'minute' => {
						'few' => q({0} мин),
						'name' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					# Long Unit Identifier
					'duration-month' => {
						'few' => q({0} мес.),
						'name' => q(месеци),
						'one' => q({0} мес.),
						'other' => q({0} мес.),
						'per' => q({0}/м),
					},
					# Core Unit Identifier
					'month' => {
						'few' => q({0} мес.),
						'name' => q(месеци),
						'one' => q({0} мес.),
						'other' => q({0} мес.),
						'per' => q({0}/м),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'few' => q({0} кв),
						'name' => q(кв),
						'one' => q({0} кв),
						'other' => q({0} кв),
						'per' => q({0}/к),
					},
					# Core Unit Identifier
					'quarter' => {
						'few' => q({0} кв),
						'name' => q(кв),
						'one' => q({0} кв),
						'other' => q({0} кв),
						'per' => q({0}/к),
					},
					# Long Unit Identifier
					'duration-second' => {
						'few' => q({0} сек),
						'name' => q(сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
						'per' => q({0}/с),
					},
					# Core Unit Identifier
					'second' => {
						'few' => q({0} сек),
						'name' => q(сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
						'per' => q({0}/с),
					},
					# Long Unit Identifier
					'duration-week' => {
						'few' => q({0} нед.),
						'name' => q(нед.),
						'one' => q({0} нед.),
						'other' => q({0} нед.),
						'per' => q({0}/н),
					},
					# Core Unit Identifier
					'week' => {
						'few' => q({0} нед.),
						'name' => q(нед.),
						'one' => q({0} нед.),
						'other' => q({0} нед.),
						'per' => q({0}/н),
					},
					# Long Unit Identifier
					'duration-year' => {
						'few' => q({0} год.),
						'name' => q(год.),
						'one' => q({0} год),
						'other' => q({0} год.),
						'per' => q({0}/год),
					},
					# Core Unit Identifier
					'year' => {
						'few' => q({0} год.),
						'name' => q(год.),
						'one' => q({0} год),
						'other' => q({0} год.),
						'per' => q({0}/год),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(A),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(A),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(V),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(V),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(електронволт),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(електронволт),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'few' => q({0} Cal),
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'few' => q({0} Cal),
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(J),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(J),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'few' => q({0} US therms),
						'one' => q({0} US therm),
						'other' => q({0} US therms),
					},
					# Core Unit Identifier
					'therm-us' => {
						'few' => q({0} US therms),
						'one' => q({0} US therm),
						'other' => q({0} US therms),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(њутн),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(њутн),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'few' => q({0} тачке),
						'name' => q(тачка),
						'one' => q({0} тачка),
						'other' => q({0} тачака),
					},
					# Core Unit Identifier
					'dot' => {
						'few' => q({0} тачке),
						'name' => q(тачка),
						'one' => q({0} тачка),
						'other' => q({0} тачака),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'few' => q({0} ppcm),
						'name' => q(dpcm),
						'one' => q({0} ppcm),
						'other' => q({0} dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'few' => q({0} ppcm),
						'name' => q(dpcm),
						'one' => q({0} ppcm),
						'other' => q({0} dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'few' => q({0} ppi),
						'name' => q(dpi),
						'one' => q({0} ppi),
						'other' => q({0} dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'few' => q({0} ppi),
						'name' => q(dpi),
						'one' => q({0} ppi),
						'other' => q({0} dpi),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'few' => q({0} ај),
						'name' => q(ај),
						'one' => q({0} ај),
						'other' => q({0} ај),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'few' => q({0} ај),
						'name' => q(ај),
						'one' => q({0} ај),
						'other' => q({0} ај),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(хв),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(хв),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(фурлонзи),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(фурлонзи),
					},
					# Long Unit Identifier
					'length-inch' => {
						'few' => q({0} инча),
						'name' => q(инчи),
						'one' => q({0} инч),
						'other' => q({0} инча),
					},
					# Core Unit Identifier
					'inch' => {
						'few' => q({0} инча),
						'name' => q(инчи),
						'one' => q({0} инч),
						'other' => q({0} инча),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'few' => q({0} сг),
						'name' => q(светлосне год.),
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					# Core Unit Identifier
					'light-year' => {
						'few' => q({0} сг),
						'name' => q(светлосне год.),
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(m),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(m),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(миље),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(миље),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(парсеци),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(парсеци),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(пикометри),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(пикометри),
					},
					# Long Unit Identifier
					'length-yard' => {
						'few' => q({0} јрд),
						'name' => q(јарди),
						'one' => q({0} јрд),
						'other' => q({0} јрд),
					},
					# Core Unit Identifier
					'yard' => {
						'few' => q({0} јрд),
						'name' => q(јарди),
						'one' => q({0} јрд),
						'other' => q({0} јрд),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(карати),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(карати),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(грејн),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(грејн),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(грами),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(грами),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(W),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(W),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'few' => q(Б {0}),
						'name' => q(Bf),
						'one' => q(Б {0}),
						'other' => q(Б {0}),
					},
					# Core Unit Identifier
					'beaufort' => {
						'few' => q(Б {0}),
						'name' => q(Bf),
						'one' => q(Б {0}),
						'other' => q(Б {0}),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(метри у секунди),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(метри у секунди),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(миље на сат),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(миље на сат),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(степени Фаренхајта),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(степени Фаренхајта),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'few' => q({0} ш.),
						'name' => q(шоље),
						'one' => q({0} ш.),
						'other' => q({0} ш.),
					},
					# Core Unit Identifier
					'cup' => {
						'few' => q({0} ш.),
						'name' => q(шоље),
						'one' => q({0} ш.),
						'other' => q({0} ш.),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'few' => q({0} дес. каш.),
						'name' => q(дес. каш.),
						'one' => q({0} дес. каш.),
						'other' => q({0} дес. каш.),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'few' => q({0} дес. каш.),
						'name' => q(дес. каш.),
						'one' => q({0} дес. каш.),
						'other' => q({0} дес. каш.),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'few' => q({0} имп. дес. каш.),
						'name' => q(имп. дес. каш.),
						'one' => q({0} имп. дес. каш.),
						'other' => q({0} имп. дес. каш.),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'few' => q({0} имп. дес. каш.),
						'name' => q(имп. дес. каш.),
						'one' => q({0} имп. дес. каш.),
						'other' => q({0} имп. дес. каш.),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(драм течности),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(драм течности),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'few' => q({0} капи),
						'name' => q(кап),
						'one' => q({0} кап),
						'other' => q({0} капи),
					},
					# Core Unit Identifier
					'drop' => {
						'few' => q({0} капи),
						'name' => q(кап),
						'one' => q({0} кап),
						'other' => q({0} капи),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'few' => q({0} fl oz),
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'few' => q({0} fl oz),
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'few' => q({0} gal),
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Core Unit Identifier
					'gallon' => {
						'few' => q({0} gal),
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'few' => q({0} џигера),
						'name' => q(џигер),
						'one' => q({0} џигер),
						'other' => q({0} џигера),
					},
					# Core Unit Identifier
					'jigger' => {
						'few' => q({0} џигера),
						'name' => q(џигер),
						'one' => q({0} џигер),
						'other' => q({0} џигера),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(литри),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(литри),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'few' => q({0} прстохвата),
						'name' => q(прстохват),
						'one' => q({0} прстохват),
						'other' => q({0} прстохвата),
					},
					# Core Unit Identifier
					'pinch' => {
						'few' => q({0} прстохвата),
						'name' => q(прстохват),
						'one' => q({0} прстохват),
						'other' => q({0} прстохвата),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'few' => q({0} каш.),
						'name' => q(каш.),
						'one' => q({0} каш.),
						'other' => q({0} каш.),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'few' => q({0} каш.),
						'name' => q(каш.),
						'one' => q({0} каш.),
						'other' => q({0} каш.),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'few' => q({0} кашич.),
						'name' => q(кашич.),
						'one' => q({0} кашич.),
						'other' => q({0} кашич.),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'few' => q({0} кашич.),
						'name' => q(кашич.),
						'one' => q({0} кашич.),
						'other' => q({0} кашич.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:да|д|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:не|н|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0} и {1}),
				2 => q({0} и {1}),
		} }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'group' => q(.),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'few' => '0 хиљаде',
					'one' => '0 хиљада',
					'other' => '0 хиљада',
				},
				'10000' => {
					'few' => '00 хиљаде',
					'one' => '00 хиљада',
					'other' => '00 хиљада',
				},
				'100000' => {
					'few' => '000 хиљаде',
					'one' => '000 хиљада',
					'other' => '000 хиљада',
				},
				'1000000' => {
					'few' => '0 милиона',
					'one' => '0 милион',
					'other' => '0 милиона',
				},
				'10000000' => {
					'few' => '00 милиона',
					'one' => '00 милион',
					'other' => '00 милиона',
				},
				'100000000' => {
					'few' => '000 милиона',
					'one' => '000 милион',
					'other' => '000 милиона',
				},
				'1000000000' => {
					'few' => '0 милијарде',
					'one' => '0 милијарда',
					'other' => '0 милијарди',
				},
				'10000000000' => {
					'few' => '00 милијарде',
					'one' => '00 милијарда',
					'other' => '00 милијарди',
				},
				'100000000000' => {
					'few' => '000 милијарде',
					'one' => '000 милијарда',
					'other' => '000 милијарди',
				},
				'1000000000000' => {
					'few' => '0 билиона',
					'one' => '0 билион',
					'other' => '0 билиона',
				},
				'10000000000000' => {
					'few' => '00 билиона',
					'one' => '00 билион',
					'other' => '00 билиона',
				},
				'100000000000000' => {
					'few' => '000 билиона',
					'one' => '000 билион',
					'other' => '000 билиона',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 хиљ'.'',
					'other' => '0 хиљ'.'',
				},
				'10000' => {
					'one' => '00 хиљ'.'',
					'other' => '00 хиљ'.'',
				},
				'100000' => {
					'one' => '000 хиљ'.'',
					'other' => '000 хиљ'.'',
				},
				'1000000' => {
					'one' => '0 мил'.'',
					'other' => '0 мил'.'',
				},
				'10000000' => {
					'one' => '00 мил'.'',
					'other' => '00 мил'.'',
				},
				'100000000' => {
					'one' => '000 мил'.'',
					'other' => '000 мил'.'',
				},
				'1000000000' => {
					'one' => '0 млрд'.'',
					'other' => '0 млрд'.'',
				},
				'10000000000' => {
					'one' => '00 млрд'.'',
					'other' => '00 млрд'.'',
				},
				'100000000000' => {
					'one' => '000 млрд'.'',
					'other' => '000 млрд'.'',
				},
				'1000000000000' => {
					'one' => '0 бил'.'',
					'other' => '0 бил'.'',
				},
				'10000000000000' => {
					'one' => '00 бил'.'',
					'other' => '00 бил'.'',
				},
				'100000000000000' => {
					'one' => '000 бил'.'',
					'other' => '000 бил'.'',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##0.00 ¤)',
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(Андорска пезета),
				'few' => q(андорске пезете),
				'one' => q(андорска пезета),
				'other' => q(андорске пезете),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(дирхам УАЕ),
				'few' => q(дирхама УАЕ),
				'one' => q(дирхам УАЕ),
				'other' => q(дирхама УАЕ),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(Авганистански авгани \(1927–2002\)),
				'few' => q(авганистанска авгана \(1927–2002\)),
				'one' => q(aвганистански авгани \(1927–2002\)),
				'other' => q(авганистанских авгана \(1927–2002\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(авганистански авгани),
				'few' => q(авганистанска авгана),
				'one' => q(aвганистански авгани),
				'other' => q(авганистанских авгана),
			},
		},
		'ALK' => {
			display_name => {
				'few' => q(стара албанска лека),
				'one' => q(стари албански лек),
				'other' => q(старих албанских лека),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(албански лек),
				'few' => q(албанска лека),
				'one' => q(албански лек),
				'other' => q(албанских лека),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(јерменски драм),
				'few' => q(јерменска драма),
				'one' => q(јерменски драм),
				'other' => q(јерменска драма),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(холандскоантилски гулден),
				'few' => q(холандскоантилска гулдена),
				'one' => q(холандскоантилски гулден),
				'other' => q(холандскоантилских гулдена),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(анголска кванза),
				'few' => q(анголске кванзе),
				'one' => q(анголска кванза),
				'other' => q(анголских кванзи),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(Анголијска кванза \(1977–1990\)),
				'few' => q(анголијске кванзе \(1977–1990\)),
				'one' => q(анголијска кванза \(1977–1990\)),
				'other' => q(анголијских кванзи \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(Анголијска нова кванза \(1990–2000\)),
				'few' => q(анголијске нове кванзе),
				'one' => q(анголијска нова кванза),
				'other' => q(анголијских нових кванзи),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(Анголијска кванза реађустадо \(1995–1999\)),
				'few' => q(анголијске кванзе реађустадо \(1995–1999\)),
				'one' => q(анголијска кванза реађустадо \(1995–1999\)),
				'other' => q(анголијских кванзи реађустадо \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(Аргентински аустрал),
				'few' => q(аргентинска аустрала),
				'one' => q(аргентински аустрал),
				'other' => q(аргентинских аустрала),
			},
		},
		'ARL' => {
			display_name => {
				'currency' => q(Аргентински пезос леј),
				'few' => q(аргентинска пезос леја),
				'one' => q(аргентински пезос леј),
				'other' => q(аргентинских пезос леја),
			},
		},
		'ARM' => {
			display_name => {
				'currency' => q(Аргентински пезос монедо национал),
				'few' => q(аргентинска пезос монеда национал),
				'one' => q(аргентински пезос монедо национал),
				'other' => q(аргентинских пезос монеда национала),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(Аргентински пезо \(1983–1985\)),
				'few' => q(аргентинска пезоса \(1983–1985\)),
				'one' => q(аргентински пезо \(1983–1985\)),
				'other' => q(аргентинских пезоса \(1983–1985\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(аргентински пезос),
				'few' => q(аргентинска пезоса),
				'one' => q(аргентински пезос),
				'other' => q(аргентинских пезоса),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(Аустријски шилинг),
				'few' => q(аустријска шилинга),
				'one' => q(аустријски шилинг),
				'other' => q(аустријских шилинга),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(аустралијски долар),
				'few' => q(аустралијска долара),
				'one' => q(аустралијски долар),
				'other' => q(аустралијских долара),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(арубански флорин),
				'few' => q(арубанска флорина),
				'one' => q(арубански флорин),
				'other' => q(арубанских флорина),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(Азербејџански манат \(1993–2006\)),
				'few' => q(азербејџанска маната \(1993–2006\)),
				'one' => q(азербејџански манат \(1993–2006\)),
				'other' => q(азербејџанских маната \(1993–2006\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(азербејџански манат),
				'few' => q(азербејџанска маната),
				'one' => q(азербејџански манат),
				'other' => q(азербејџанских маната),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(Босанско-Херцеговачки динар),
				'few' => q(босанско-херцеговачка динара),
				'one' => q(босанско-херцеговачки динар),
				'other' => q(босанско-херцеговачких динара),
			},
		},
		'BAM' => {
			symbol => 'КМ',
			display_name => {
				'currency' => q(босанско-херцеговачка конвертибилна марка),
				'few' => q(босанско-херцеговачке конвертибилне маркe),
				'one' => q(босанско-херцеговачка конвертибилна марка),
				'other' => q(босанско-херцеговачких конвертибилних марака),
			},
		},
		'BAN' => {
			display_name => {
				'currency' => q(Босанско-херцеговачки нови динар),
				'few' => q(босанско-херцеговачка нова динара),
				'one' => q(босанско-херцеговачки нови динар),
				'other' => q(босанско-херцеговачких нових динара),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(барбадошки долар),
				'few' => q(барбадошка долара),
				'one' => q(барбадошки долар),
				'other' => q(барбадошких долара),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(бангладешка така),
				'few' => q(бангладешке таке),
				'one' => q(бангладешка така),
				'other' => q(бангладешких така),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(Белгијски франак \(конвертибилни\)),
				'few' => q(белгијска франка \(конвертибилна\)),
				'one' => q(белгијски франак \(конвертибилни\)),
				'other' => q(белгијских франака \(конвертибилних\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(Белгијски франак),
				'few' => q(белгијска франка),
				'one' => q(белгијски франак),
				'other' => q(белгијских франака),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(Белгијски франак \(финансијски\)),
				'few' => q(белгијска франка \(финансијска\)),
				'one' => q(белгијски франак \(финансијски\)),
				'other' => q(белгијских франака \(финансијских\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(Бугарски тврди лев),
				'few' => q(бугарска тврда лева),
				'one' => q(бугарски тврди лев),
				'other' => q(бугарских тврдих лева),
			},
		},
		'BGM' => {
			display_name => {
				'currency' => q(Бугарски социјалистички лев),
				'few' => q(бугарска социјалистичка лева),
				'one' => q(бугарски социјалистички лев),
				'other' => q(бугарских социјалистичких лева),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(бугарски лев),
				'few' => q(бугарска лева),
				'one' => q(бугарски лев),
				'other' => q(бугарских лева),
			},
		},
		'BGO' => {
			display_name => {
				'currency' => q(Стари бугарски лев),
				'few' => q(стара бугарска лева),
				'one' => q(стари бугарски лев),
				'other' => q(старих бугарских лева),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(бахреински динар),
				'few' => q(бахреинскa динара),
				'one' => q(бахреински динар),
				'other' => q(бахреинских динара),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(бурундски франак),
				'few' => q(бурундска франка),
				'one' => q(бурундски франак),
				'other' => q(бурундских франакa),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(бермудски долар),
				'few' => q(бермудска долара),
				'one' => q(бермудски долар),
				'other' => q(бермудских долара),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(брунејски долар),
				'few' => q(брунејска долара),
				'one' => q(брунејски долар),
				'other' => q(брунејских долара),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(боливијски боливијано),
				'few' => q(боливијска боливијана),
				'one' => q(боливијски боливијано),
				'other' => q(боливијских боливијана),
			},
		},
		'BOL' => {
			display_name => {
				'currency' => q(Стари боливијски боливијано),
				'few' => q(стара боливијска боливијана),
				'one' => q(стари боливијски боливијано),
				'other' => q(старих боливијских боливијана),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(Боливијски пезо),
				'few' => q(боливијска пезоса),
				'one' => q(боливијски пезо),
				'other' => q(боливијских пезоса),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(Боливијски мвдол),
				'few' => q(боливијска мвдола),
				'one' => q(боливијски мвдол),
				'other' => q(боливијских мвдола),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(Бразилски нови крузеиро \(1967–1986\)),
				'few' => q(бразилска нова крузеира \(1967–1986\)),
				'one' => q(бразилски нови крузеиро \(1967–1986\)),
				'other' => q(бразилских нових крузеира \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(Бразилијски крузадо),
				'few' => q(бразилска крузадоса),
				'one' => q(бразилски крузадос),
				'other' => q(бразилских крузадоса),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(Бразилски крузеиро \(1990–1993\)),
				'few' => q(бразилска крузеира \(1990–1993\)),
				'one' => q(бразилски крузеиро \(1990–1993\)),
				'other' => q(бразилских крузеира \(1990–1993\)),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(бразилски реал),
				'few' => q(бразилска реала),
				'one' => q(бразилски реал),
				'other' => q(бразилских реала),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(Бразилијски нови крузадо),
				'few' => q(бразилска нова крузада),
				'one' => q(бразилски нови крузадо),
				'other' => q(бразилских нових крузада),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(Бразилски крузеиро),
				'few' => q(бразилска крузеира),
				'one' => q(бразилски крузеиро),
				'other' => q(бразилских крузеира),
			},
		},
		'BRZ' => {
			display_name => {
				'currency' => q(Стари бразилски крузеиро),
				'few' => q(стара бразилска крузеира),
				'one' => q(стари бразилски крузеиро),
				'other' => q(старих бразилских крузеира),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(бахамски долар),
				'few' => q(бахамска долара),
				'one' => q(бахамски долар),
				'other' => q(бахамских долара),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(бутански нгултрум),
				'few' => q(бутанска нгултрума),
				'one' => q(бутански нгултрум),
				'other' => q(бутанских нгултрума),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(Бурмански кјат),
				'few' => q(бурманска кјата),
				'one' => q(бурмански кјат),
				'other' => q(бурманских кјата),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(боцванска пула),
				'few' => q(боцванске пуле),
				'one' => q(боцванска пула),
				'other' => q(боцванских пула),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(Белоруска нова рубља \(1994–1999\)),
				'few' => q(белоруске нове рубља \(1994–1999\)),
				'one' => q(белоруска нова рубља \(1994–1999\)),
				'other' => q(белоруских нових рубљи \(1994–1999\)),
			},
		},
		'BYN' => {
			symbol => 'р.',
			display_name => {
				'currency' => q(белоруска рубља),
				'few' => q(белоруске рубље),
				'one' => q(белоруска рубља),
				'other' => q(белоруских рубљи),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(Белоруска рубља \(2000–2016\)),
				'few' => q(белоруске рубље \(2000–2016\)),
				'one' => q(белоруска рубља \(2000–2016\)),
				'other' => q(белоруских рубљи \(2000–2016\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(белиски долар),
				'few' => q(белиска долара),
				'one' => q(белиски долар),
				'other' => q(белиских долара),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(канадски долар),
				'few' => q(канадска долара),
				'one' => q(канадски долар),
				'other' => q(канадских долара),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(конгоански франак),
				'few' => q(конгоанска франка),
				'one' => q(конгоански франак),
				'other' => q(конгоанских франака),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(WIR евро),
				'few' => q(WIR евра),
				'one' => q(WIR евро),
				'other' => q(WIR евра),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(швајцарски франак),
				'few' => q(швајцарска франка),
				'one' => q(швајцарски франак),
				'other' => q(швајцарских франака),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(WIR франак),
				'few' => q(WIR франка),
				'one' => q(WIR франак),
				'other' => q(WIR франака),
			},
		},
		'CLE' => {
			display_name => {
				'currency' => q(Чилеански ескудо),
				'few' => q(чилеанска ескуда),
				'one' => q(чилеански ескудо),
				'other' => q(чилеанских ескуда),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(Чилеовски унидадес се фоменто),
				'few' => q(чилеанска унидадес де фомента),
				'one' => q(чилеански унидадес де фоменто),
				'other' => q(чилеански унидадеси де фоменто),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(чилеански пезос),
				'few' => q(чилеанска пезоса),
				'one' => q(чилеански пезос),
				'other' => q(чилеанских пезоса),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(кинески јуан \(острвски\)),
				'few' => q(кинеска јуана \(острвска\)),
				'one' => q(кинески јуан \(острвски\)),
				'other' => q(кинеских јуана \(острвских\)),
			},
		},
		'CNX' => {
			display_name => {
				'currency' => q(Долар кинеске народне банке),
				'few' => q(долара кинеске народне банке),
				'one' => q(долар кинеске народне банке),
				'other' => q(долара кинеске народне банке),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(кинески јуан),
				'few' => q(кинеска јуана),
				'one' => q(кинески јуан),
				'other' => q(кинеских јуана),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(колумбијски пезос),
				'few' => q(колумбијска пезоса),
				'one' => q(колумбијски пезос),
				'other' => q(колумбијских пезоса),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(Унидад де валоршки реал),
				'few' => q(нидад де валор реала),
				'one' => q(унидад де валоршки реал),
				'other' => q(унидад де валоршких реала),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(костарикански колон),
				'few' => q(костариканска колона),
				'one' => q(костарикански колон),
				'other' => q(костариканских колона),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(Стари српски динар),
				'few' => q(стара српска динара),
				'one' => q(стари српски динар),
				'other' => q(старих српских динара),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(Чехословачка тврда круна),
				'few' => q(чехословачке тврде круне),
				'one' => q(чехословачка тврда круна),
				'other' => q(чехословачких тврдих круна),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(кубански конвертибилни пезос),
				'few' => q(кубанска конвертибилна пезоса),
				'one' => q(кубански конвертибилни пезос),
				'other' => q(кубанских конвертибилних пезоса),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(кубански пезос),
				'few' => q(кубанска пезоса),
				'one' => q(кубански пезос),
				'other' => q(кубанских пезоса),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(зеленортски ескудо),
				'few' => q(зеленортска ескуда),
				'one' => q(зеленортски ескудо),
				'other' => q(зеленортских ескуда),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(Кипарска фунта),
				'few' => q(кипарске фунте),
				'one' => q(кипарска фунта),
				'other' => q(кипарских фунти),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(чешка круна),
				'few' => q(чешке круне),
				'one' => q(чешка круна),
				'other' => q(чешких крунa),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(Источно-немачка марка),
				'few' => q(источно-немачке марке),
				'one' => q(источно-немачка марка),
				'other' => q(источно-немачких марака),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Немачка марка),
				'few' => q(немачке марке),
				'one' => q(немачка марка),
				'other' => q(немачких марака),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(џибутски франак),
				'few' => q(џибутска франка),
				'one' => q(џибутски франак),
				'other' => q(џибутских франака),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(данска круна),
				'few' => q(данске круне),
				'one' => q(данска круна),
				'other' => q(данских круна),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(доминикански пезос),
				'few' => q(доминиканска пезоса),
				'one' => q(доминикански пезос),
				'other' => q(доминиканских пезоса),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(алжирски динар),
				'few' => q(алжирска динара),
				'one' => q(алжирски динар),
				'other' => q(алжирских динара),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(Еквадорски сакр),
				'few' => q(еквадорска сакра),
				'one' => q(еквадорски сакр),
				'other' => q(еквадорских сакра),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(Еквадорски унидад де валор константе),
				'few' => q(еквадорска унидад де валор константа),
				'one' => q(еквадорски унидад де валор константе),
				'other' => q(еквадорских унидад де валор константа),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(Естонска кроон),
				'few' => q(естонске круне),
				'one' => q(естонска круна),
				'other' => q(естонских круна),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(египатска фунта),
				'few' => q(египатске фунте),
				'one' => q(египатска фунта),
				'other' => q(египатских фунти),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(еритрејска накфа),
				'few' => q(еритрејске накфе),
				'one' => q(еритрејска накфа),
				'other' => q(еритрејских накфи),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(Шпанска пезета \(рачун\)),
				'few' => q(шпанске пезете \(А рачун\)),
				'one' => q(шпанска пезета \(А рачун\)),
				'other' => q(шпанских пезета \(А рачун\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(Шпанска пезета \(конвертибилнирачун\)),
				'few' => q(шпанске пезете \(конвертибилан рачун\)),
				'one' => q(шпанска пезета \(конвертибилан рачун\)),
				'other' => q(шпанских пезета \(конвертибилан рачун\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(Шпанска пезета),
				'few' => q(шпанска пезета),
				'one' => q(шпанска пезета),
				'other' => q(шпанске пезете),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(етиопијски бир),
				'few' => q(етиопска бира),
				'one' => q(етиопски бир),
				'other' => q(етиопских бира),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(Евро),
				'few' => q(евра),
				'one' => q(евро),
				'other' => q(евра),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Финска марка),
				'few' => q(финске марке),
				'one' => q(финска марка),
				'other' => q(финских марака),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(фиџијски долар),
				'few' => q(фиџијска долара),
				'one' => q(фиџијски долар),
				'other' => q(фиџијских долара),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(фолкландска фунта),
				'few' => q(фокландске фунте),
				'one' => q(фокландска фунта),
				'other' => q(фокландских фунти),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Француски франак),
				'few' => q(француска франка),
				'one' => q(француски франак),
				'other' => q(француских франака),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(британска фунта),
				'few' => q(британске фунте),
				'one' => q(британска фунта),
				'other' => q(британских фунти),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(Грузијски купон ларит),
				'few' => q(грузијска купон ларита),
				'one' => q(грузијски купон ларит),
				'other' => q(грузијских купон ларита),
			},
		},
		'GEL' => {
			symbol => 'ლ',
			display_name => {
				'currency' => q(грузијски лари),
				'few' => q(грузијска ларија),
				'one' => q(грузијски лари),
				'other' => q(грузијских ларија),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(Гански цеди \(1979–2007\)),
				'few' => q(ганска цеда \(1979–2007\)),
				'one' => q(гански цед \(1979–2007\)),
				'other' => q(ганских цеда \(1979–2007\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(гански седи),
				'few' => q(ганска седија),
				'one' => q(гански седи),
				'other' => q(ганских седија),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(гибралтарска фунта),
				'few' => q(гибралтарске фунте),
				'one' => q(гибралтарска фунта),
				'other' => q(гибралтарских фунти),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(гамбијски даласи),
				'few' => q(гамбијских даласија),
				'one' => q(гамбијски даласи),
				'other' => q(гамбијских даласија),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(гвинејски франак),
				'few' => q(гвинејска франка),
				'one' => q(гвинејски франак),
				'other' => q(гвинејских франака),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(Гвинејски сили),
				'few' => q(гвинејска сила),
				'one' => q(гвинејски сили),
				'other' => q(гвинејских сила),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(Екваторијално-гвинејски еквеле),
				'few' => q(екваторијално-гвинејска еквела),
				'one' => q(екваторијално-гвинејски еквеле),
				'other' => q(екваторијално-гвинејских еквела),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(Грчка драхма),
				'few' => q(грчке драхме),
				'one' => q(грчка драхма),
				'other' => q(грчких драхми),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(гватемалски кецал),
				'few' => q(гватемалска кецала),
				'one' => q(гватемалски кецал),
				'other' => q(гватемалских кецала),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(Португалска гвинеја ескудо),
				'few' => q(португалско-гвинејска ескуда),
				'one' => q(португалско-гвинејски ескудо),
				'other' => q(португалско-гвинејских ескуда),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(Гвинеја Бисао Пезо),
				'few' => q(гвинеја-бисаошка пезоса),
				'one' => q(гвинеја-бисаошки пезо),
				'other' => q(гвинеја-бисаошких пезоса),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(гвајански долар),
				'few' => q(гвајанска долара),
				'one' => q(гвајански долар),
				'other' => q(гвајанских долара),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(хонгконшки долар),
				'few' => q(хонгконшка долара),
				'one' => q(хонгконшки долар),
				'other' => q(хонгконшких долара),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(хондурашка лемпира),
				'few' => q(хондурашке лемпире),
				'one' => q(хондурашка лемпира),
				'other' => q(хондурашких лемпира),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(Хрватски динар),
				'few' => q(хрватска динара),
				'one' => q(хрватски динар),
				'other' => q(хрватских динара),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(хрватска куна),
				'few' => q(хрватске куне),
				'one' => q(хрватска куна),
				'other' => q(хрватских куна),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(хаићански гурд),
				'few' => q(хаићанска гурда),
				'one' => q(хаићански гурд),
				'other' => q(хаићанских гурда),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(мађарска форинта),
				'few' => q(мађарске форинте),
				'one' => q(мађарска форинта),
				'other' => q(мађарских форинти),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(индонежанска рупија),
				'few' => q(индонежанске рупије),
				'one' => q(индонежанска рупија),
				'other' => q(индонежанских рупијa),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Ирска фунта),
				'few' => q(ирске фунте),
				'one' => q(ирска фунта),
				'other' => q(ирских фунти),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(Израелска фунта),
				'few' => q(израелске фунте),
				'one' => q(израелска фунта),
				'other' => q(израелских фунти),
			},
		},
		'ILR' => {
			display_name => {
				'currency' => q(Стари израелски шекели),
				'few' => q(стари израелски шекели),
				'one' => q(стари израелски шекели),
				'other' => q(стари израелски шекели),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(израелски нови шекел),
				'few' => q(израелска нова шекела),
				'one' => q(израелски нови шекел),
				'other' => q(израелских нових шекела),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(индијска рупија),
				'few' => q(индијске рупије),
				'one' => q(индијска рупија),
				'other' => q(индијских рупија),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ирачки динар),
				'few' => q(ирачка динара),
				'one' => q(ирачки динар),
				'other' => q(ирачких динара),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ирански ријал),
				'few' => q(иранска ријала),
				'one' => q(ирански ријал),
				'other' => q(иранских ријала),
			},
		},
		'ISJ' => {
			display_name => {
				'currency' => q(Стара исландска круна),
				'few' => q(стара исландска круна),
				'one' => q(стара исландска круна),
				'other' => q(стара исландска круна),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(исландска круна),
				'few' => q(исландске круне),
				'one' => q(исландска круна),
				'other' => q(исландских круна),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(Италијанска лира),
				'few' => q(италијанске лире),
				'one' => q(италијанска лира),
				'other' => q(италијанске лире),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(јамајчански долар),
				'few' => q(jамајчанска долара),
				'one' => q(jамајчански долар),
				'other' => q(jамајчанскиx долара),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(јордански динар),
				'few' => q(јорданскa динара),
				'one' => q(јордански динар),
				'other' => q(јорданских динара),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(јапански јен),
				'few' => q(јапанска јена),
				'one' => q(јапански јен),
				'other' => q(јапанских јена),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(кенијски шилинг),
				'few' => q(кенијска шилинга),
				'one' => q(кенијски шилинг),
				'other' => q(кенијских шилинга),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(киргистански сом),
				'few' => q(киргистанска сома),
				'one' => q(киргистански сом),
				'other' => q(киргистанских сома),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(камбоџански ријел),
				'few' => q(камбоџанска ријела),
				'one' => q(камбоџански ријел),
				'other' => q(камбоџанских ријела),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(коморски франак),
				'few' => q(коморскa франкa),
				'one' => q(коморски франак),
				'other' => q(коморских франакa),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(севернокорејски вон),
				'few' => q(севернокорејска вона),
				'one' => q(севернокорејски вон),
				'other' => q(севернокорејских вона),
			},
		},
		'KRH' => {
			display_name => {
				'currency' => q(Јужнокорејски хван),
				'few' => q(јужнокорејска хвана),
				'one' => q(јужнокорејски хван),
				'other' => q(јужнокорејских хвана),
			},
		},
		'KRO' => {
			display_name => {
				'currency' => q(Стари јужнокорејски вон),
				'few' => q(стара јужнокорејска вона),
				'one' => q(стари јужнокорејски вон),
				'other' => q(старих јужнокорејских вона),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(јужнокорејски вон),
				'few' => q(јужнокорејска вона),
				'one' => q(јужнокорејски вон),
				'other' => q(јужнокорејских вона),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(кувајтски динар),
				'few' => q(кувајтскa динара),
				'one' => q(кувајтски динар),
				'other' => q(кувајтских динара),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(кајмански долар),
				'few' => q(кајманска долара),
				'one' => q(кајмански долар),
				'other' => q(кајманских долара),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(казахстански тенге),
				'few' => q(казахстанска тенгеа),
				'one' => q(казахстански тенге),
				'other' => q(казахстанских тенгеа),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(лаоски кип),
				'few' => q(лаоска кипа),
				'one' => q(лаоски кип),
				'other' => q(лаоских кипа),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(либанска фунта),
				'few' => q(либанскe фунтe),
				'one' => q(либанскa фунтa),
				'other' => q(либанских фунти),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(шриланчанска рупија),
				'few' => q(шриланчанске рупије),
				'one' => q(шриланчанска рупија),
				'other' => q(шриланчанских рупија),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(либеријски долар),
				'few' => q(либеријска долара),
				'one' => q(либеријски долар),
				'other' => q(либеријских долара),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(лесотски лоти),
				'few' => q(лесотска лотија),
				'one' => q(лесотски лоти),
				'other' => q(лесотских лотија),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(Литвански литас),
				'few' => q(литванска литаса),
				'one' => q(литвански литас),
				'other' => q(литванских литаса),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(Литвански талонас),
				'few' => q(литванска талонаса),
				'one' => q(литвански талонас),
				'other' => q(литванских талонаса),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(Луксембуршки конвертибилни франак),
				'few' => q(луксембуршка конвертибилна франка),
				'one' => q(луксембуршки конвертибилни франак),
				'other' => q(луксембуршких конвертибилних франака),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(Луксембуршки франак),
				'few' => q(луксембуршка франка),
				'one' => q(луксембуршки франак),
				'other' => q(луксембуршки франци),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(Луксембуршки финансијски франак),
				'few' => q(луксембуршка финансијска франка),
				'one' => q(луксембуршки финансијски франак),
				'other' => q(луксембуршких финансијских франака),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(Латвијски лати),
				'few' => q(латвијска лата),
				'one' => q(латвијски лат),
				'other' => q(латвијских лата),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(Латвијска рубља),
				'few' => q(латвијске рубље),
				'one' => q(латвијска рубља),
				'other' => q(латвијских рубљи),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(либијски динар),
				'few' => q(либијскa динарa),
				'one' => q(либијски динар),
				'other' => q(либијских динарa),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(марокански дирхам),
				'few' => q(мароканска дирхама),
				'one' => q(марокански дирхам),
				'other' => q(мароканских дирхама),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(Марокански франак),
				'few' => q(мароканска франка),
				'one' => q(марокански франак),
				'other' => q(мароканских франака),
			},
		},
		'MCF' => {
			display_name => {
				'currency' => q(Монегаскански франак),
				'few' => q(монегасканска франка),
				'one' => q(монегаскански франак),
				'other' => q(монегасканских франака),
			},
		},
		'MDC' => {
			display_name => {
				'currency' => q(Молдовански купон),
				'few' => q(молдованска купона),
				'one' => q(молдовански купон),
				'other' => q(молдованских купона),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(молдавски леј),
				'few' => q(молдaвскa леја),
				'one' => q(молдaвски леј),
				'other' => q(молдaвских леја),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(малгашки аријари),
				'few' => q(малгашка аријарија),
				'one' => q(малгашки аријари),
				'other' => q(малгашких аријарија),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(Малагасијски франак),
				'few' => q(малагашајска франка),
				'one' => q(малагашајски франак),
				'other' => q(малагашајски франци),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(македонски денар),
				'few' => q(македонска денара),
				'one' => q(македонски денар),
				'other' => q(македонских денара),
			},
		},
		'MKN' => {
			display_name => {
				'currency' => q(Стари македонски денар),
				'few' => q(стара македонска денара),
				'one' => q(стари македонски денар),
				'other' => q(старих македонских денара),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(Малијански франак),
				'few' => q(малијска франка),
				'one' => q(малијски франак),
				'other' => q(малијских франака),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(мјанмарски кјат),
				'few' => q(мјанмарскa кјатa),
				'one' => q(мјанмарски кјат),
				'other' => q(мјанмарских кјатa),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(монголски тугрик),
				'few' => q(монголскa тугрика),
				'one' => q(монголски тугрик),
				'other' => q(монголских тугрика),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(макаоска патака),
				'few' => q(макаоске патаке),
				'one' => q(макаоска патака),
				'other' => q(макаоских патака),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(Мауританијска oгија \(1973–2017\)),
				'few' => q(мауританијскe oгијe \(1973–2017\)),
				'one' => q(мауританијска oгија \(1973–2017\)),
				'other' => q(мауританијских oгијa \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(мауританска огија),
				'few' => q(мауританске огије),
				'one' => q(мауританска огија),
				'other' => q(мауританских огија),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(Малтешка лира),
				'few' => q(малтешке лире),
				'one' => q(малтешка лира),
				'other' => q(малтешких лира),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(Малтешка фунта),
				'few' => q(малтешке фунте),
				'one' => q(малтешка фунта),
				'other' => q(малтешких фунти),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(маурицијска рупија),
				'few' => q(маурицијскe рупијe),
				'one' => q(маурицијска рупија),
				'other' => q(маурицијских рупија),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(малдивска руфија),
				'few' => q(малдивскe руфијe),
				'one' => q(малдивскa руфија),
				'other' => q(малдивских руфија),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(малавијска квача),
				'few' => q(малавијске кваче),
				'one' => q(малавијска квача),
				'other' => q(малавијских квача),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(мексички пезос),
				'few' => q(мексичка пезоса),
				'one' => q(мексички пезос),
				'other' => q(мексичких пезоса),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(Мексички сребрни пезо \(1861–1992\)),
				'few' => q(мексичка сребрна пезоса),
				'one' => q(мексички сребрни пезо),
				'other' => q(мексичких сребрних пезоса),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(Мексички унидад де инверсион \(UDI\)),
				'few' => q(мексичка унидадс де инверзиона),
				'one' => q(мексички унидадс де инверзион),
				'other' => q(мексичких унидадс де инверзиона),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(малезијски рингит),
				'few' => q(малезијска рингита),
				'one' => q(малезијски рингит),
				'other' => q(малезијских рингита),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(Мозамбијски ескудо),
				'few' => q(мозамбијска ескуда),
				'one' => q(мозамбијски ескудо),
				'other' => q(мозамбијских ескуда),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(Стари мозамбијски метикал),
				'few' => q(стара мозамбијска метикала),
				'one' => q(стари мозамбијски метикал),
				'other' => q(старих мозамбијских метикала),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(мозамбички метикал),
				'few' => q(мозамбичка метикала),
				'one' => q(мозамбички метикал),
				'other' => q(мозамбичких метикала),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(намибијски долар),
				'few' => q(намибијска долара),
				'one' => q(намибијски долар),
				'other' => q(намибијских долара),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(нигеријска наира),
				'few' => q(нигеријске наире),
				'one' => q(нигеријска наира),
				'other' => q(нигеријских наира),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(никарагванска кордоба \(1988–1991\)),
				'few' => q(никарагванске кордобе \(1988–1991\)),
				'one' => q(никарагванска кордоба \(1988–1991\)),
				'other' => q(никарагванских кордоба \(1988–1991\)),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(никарагванска кордоба),
				'few' => q(никарагванске кордобе),
				'one' => q(никарагванска кордоба),
				'other' => q(никарагванских кордоба),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(Холандски гулден),
				'few' => q(холандска гулдена),
				'one' => q(холандски гулден),
				'other' => q(холандских гулдена),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(норвешка круна),
				'few' => q(норвешке круне),
				'one' => q(норвешка круна),
				'other' => q(норвешких круна),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(непалска рупија),
				'few' => q(непалске рупије),
				'one' => q(непалска рупија),
				'other' => q(непалских рупија),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(новозеландски долар),
				'few' => q(новозеландска долара),
				'one' => q(новозеландски долар),
				'other' => q(новозеландских долара),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(омански ријал),
				'few' => q(оманскa ријала),
				'one' => q(омански ријал),
				'other' => q(оманских ријала),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(панамска балбоа),
				'few' => q(панамске балбое),
				'one' => q(панамска балбоа),
				'other' => q(панамских балбоа),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(Перуански инти),
				'few' => q(перувијска интија),
				'one' => q(перувијски инти),
				'other' => q(перувијских интија),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(перуански сол),
				'few' => q(перуанска сола),
				'one' => q(перуански сол),
				'other' => q(перуанских сола),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(Перуански сол \(1863–1965\)),
				'few' => q(перуанска сола \(1863–1965\)),
				'one' => q(перуански сол \(1863–1965\)),
				'other' => q(перуанских сола \(1863–1965\)),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(папуанска кина),
				'few' => q(папуанскe кинe),
				'one' => q(папуанска кина),
				'other' => q(папуанских кинa),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(филипински пезос),
				'few' => q(филипинска пезоса),
				'one' => q(филипински пезос),
				'other' => q(филипинских пезоса),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(пакистанска рупија),
				'few' => q(пакистанске рупије),
				'one' => q(пакистанска рупија),
				'other' => q(пакистанских рупија),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(пољски злот),
				'few' => q(пољска злота),
				'one' => q(пољски злот),
				'other' => q(пољских злота),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(Пољски злоти \(1950–1995\)),
				'few' => q(пољска злота \(1950–1995\)),
				'one' => q(пољски злот \(1950–1995\)),
				'other' => q(пољских злота \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(Португалски ескудо),
				'few' => q(португалска ескуда),
				'one' => q(португалски ескудо),
				'other' => q(португалских ескуда),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(парагвајски гварани),
				'few' => q(парагвајска гваранија),
				'one' => q(парагвајски гварани),
				'other' => q(парагвајских гваранија),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(катарски ријал),
				'few' => q(катарска ријала),
				'one' => q(катарски ријал),
				'other' => q(катарских ријала),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(Родејскидолар),
				'few' => q(родежанска долара),
				'one' => q(родежански долар),
				'other' => q(родежанских долара),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(Румунски леј \(1952–2006\)),
				'few' => q(румунскa леја \(1952–2006\)),
				'one' => q(румунски леј \(1952–2006\)),
				'other' => q(румунских леја \(1952–2006\)),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(румунски леј),
				'few' => q(румунскa леја),
				'one' => q(румунски леј),
				'other' => q(румунских леја),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(српски динар),
				'few' => q(српска динара),
				'one' => q(српски динар),
				'other' => q(српских динара),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(руска рубља),
				'few' => q(руске рубље),
				'one' => q(руска рубља),
				'other' => q(руских рубљи),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(Руска рубља \(1991–1998\)),
				'few' => q(руске рубље \(1991–1998\)),
				'one' => q(руска рубља \(1991–1998\)),
				'other' => q(руских рубљи \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(руандски франак),
				'few' => q(руандскa франка),
				'one' => q(руандски франак),
				'other' => q(руандских франака),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(саудијски ријал),
				'few' => q(саудијска ријала),
				'one' => q(саудијски ријал),
				'other' => q(саудијских ријала),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(соломонски долар),
				'few' => q(соломонска долара),
				'one' => q(соломонски долар),
				'other' => q(соломонских долара),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(сејшелска рупија),
				'few' => q(сејшелске рупије),
				'one' => q(сејшелска рупија),
				'other' => q(сејшелских рупија),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(Стари судански динар),
				'few' => q(стара суданска динара),
				'one' => q(стари судански динар),
				'other' => q(старих суданских динара),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(суданска фунта),
				'few' => q(суданске фунте),
				'one' => q(суданска фунта),
				'other' => q(суданских фунти),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(Стара суданска фунта),
				'few' => q(старе суданске фунте),
				'one' => q(стара суданска фунта),
				'other' => q(старих суданских фунти),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(шведска круна),
				'few' => q(шведске круне),
				'one' => q(шведска круна),
				'other' => q(шведских круна),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(сингапурски долар),
				'few' => q(сингапурска долара),
				'one' => q(сингапурски долар),
				'other' => q(сингапурских долара),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(фунта Свете Јелене),
				'few' => q(фунте Свете Јелене),
				'one' => q(фунта Свете Јелене),
				'other' => q(фунти Свете Јелене),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(Словеначки толар),
				'few' => q(словеначка толара),
				'one' => q(словеначки толар),
				'other' => q(словеначких толара),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(Словачка круна),
				'few' => q(словачке круне),
				'one' => q(словачка круна),
				'other' => q(словачких круна),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(сијералеонски леоне),
				'few' => q(сијералеонска леона),
				'one' => q(сијералеонски леоне),
				'other' => q(сијералеонских леона),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(сијералеонски леоне \(1964—2022\)),
				'few' => q(сијералеонска леона \(1964—2022\)),
				'one' => q(сијералеонски леоне \(1964—2022\)),
				'other' => q(сијералеонских леона \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(сомалијски шилинг),
				'few' => q(сомалијска шилинга),
				'one' => q(сомалијски шилинг),
				'other' => q(сомалијских шилинга),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(суринамски долар),
				'few' => q(суринамска долара),
				'one' => q(суринамски долар),
				'other' => q(суринамских долара),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(Суринамски гилдер),
				'few' => q(суринамска гилдера),
				'one' => q(суринамски гилдер),
				'other' => q(суринамских гилдера),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(јужносуданска фунта),
				'few' => q(јужносуданскe фунтe),
				'one' => q(јужносуданска фунта),
				'other' => q(јужносуданских фунти),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(Саотомска добра \(1977–2017\)),
				'few' => q(саотомске добре \(1977–2017\)),
				'one' => q(саотомска добра \(1977–2017\)),
				'other' => q(саотомских добри \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(саотомска добра),
				'few' => q(саотомске добре),
				'one' => q(саотомска добра),
				'other' => q(саотомских добри),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(Совјетска рубља),
				'few' => q(совјетске рубље),
				'one' => q(совјетска рубља),
				'other' => q(совјетских рубљи),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(Салвадорски колон),
				'few' => q(салвадорска колона),
				'one' => q(салвадорски колон),
				'other' => q(салвадорских колона),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(сиријска фунта),
				'few' => q(сиријске фунте),
				'one' => q(сиријска фунта),
				'other' => q(сиријских фунти),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(свазилендски лилангени),
				'few' => q(свазилендска лилангенија),
				'one' => q(свазилендски лилангени),
				'other' => q(свазилендских лилангенија),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(тајландски бат),
				'few' => q(тајландска бата),
				'one' => q(тајландски бат),
				'other' => q(тајландских бата),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(Таџихистанска рубља),
				'few' => q(таџихистанске рубље),
				'one' => q(таџихистанска рубља),
				'other' => q(таџихистанских рубљи),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(таџикистански сомон),
				'few' => q(таџикистанска сомона),
				'one' => q(таџикистански сомон),
				'other' => q(таџикистанских сомона),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(Туркменистански манат \(1993–2009\)),
				'few' => q(туркменистанска маната \(1993–2009\)),
				'one' => q(туркменистански манат \(1993–2009\)),
				'other' => q(туркменистански манат \(1993–2009\)),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(туркменистански манат),
				'few' => q(туркменистанскa манатa),
				'one' => q(туркменистански манат),
				'other' => q(туркменистанских маната),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(туниски динар),
				'few' => q(туниска динара),
				'one' => q(туниски динар),
				'other' => q(туниских динара),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(тонганска панга),
				'few' => q(тонганске панге),
				'one' => q(тонганска панга),
				'other' => q(тонганских панги),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(Тиморшки ескудо),
				'few' => q(тиморшка ескуда),
				'one' => q(тиморшки ескудо),
				'other' => q(тиморшких ескуда),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(Турска лира \(1922–2005\)),
				'few' => q(турске лире \(1922–2005\)),
				'one' => q(турска лира \(1922–2005\)),
				'other' => q(турских лира \(1922–2005\)),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(турска лира),
				'few' => q(турске лире),
				'one' => q(турска лира),
				'other' => q(турских лира),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(Тринидад-тобагошки долар),
				'few' => q(тринидад-тобагошка долара),
				'one' => q(тринидад-тобагошки долар),
				'other' => q(тринидад-тобагошких долара),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(нови тајвански долар),
				'few' => q(нова тајванска долара),
				'one' => q(нови тајвански долар),
				'other' => q(нових тајванских долара),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(танзанијски шилинг),
				'few' => q(танзанијска шилинга),
				'one' => q(танзанијски шилинг),
				'other' => q(танзанијских шилинга),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(украјинска гривна),
				'few' => q(украјинскe гривнe),
				'one' => q(украјинска гривна),
				'other' => q(украјинских хривњи),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(Украјински карбованети),
				'few' => q(украјинска карбованцива),
				'one' => q(украјински карбованец),
				'other' => q(украјинских карбованцива),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(Угандски шилинг \(1966–1987\)),
				'few' => q(угандијска шилинга \(1966–1987\)),
				'one' => q(угандијски шилинг \(1966–1987\)),
				'other' => q(угандијских шилинга \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(угандски шилинг),
				'few' => q(угандскa шилинга),
				'one' => q(угандски шилинг),
				'other' => q(угандских шилинга),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(амерички долар),
				'few' => q(америчка долара),
				'one' => q(амерички долар),
				'other' => q(америчких долара),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(САД долар \(следећи дан\)),
				'few' => q(САД долара \(следећи дан\)),
				'one' => q(САД долар \(следећи дан\)),
				'other' => q(САД долара \(следећи дан\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(САД долар \(исти дан\)),
				'few' => q(САД долара \(исти дан\)),
				'one' => q(САД долар \(исти дан\)),
				'other' => q(САД долара \(исти дан\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(Уругвајски пезо ен унидадес индексадас),
				'few' => q(уругвајска пезоса ен унидадес индексадеса),
				'one' => q(уругвајски пезо ен унидадес индексадес),
				'other' => q(угвајских пезоса ен унидадес индексадеса),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(Уругвајски пезо \(1975–1993\)),
				'few' => q(уругвајска пезоса \(1975–1993\)),
				'one' => q(уругвајски пезо \(1975–1993\)),
				'other' => q(уругвајских пезоса \(1975–1993\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(уругвајски пезос),
				'few' => q(уругвајска пезоса),
				'one' => q(уругвајски пезос),
				'other' => q(уругвајских пезоса),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(узбекистански сом),
				'few' => q(узбекистанска сома),
				'one' => q(узбекистански сом),
				'other' => q(узбекистанских сома),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(Венецуелански боливар \(1871–2008\)),
				'few' => q(венецуеланска боливара \(1871–2008\)),
				'one' => q(венецуелански боливар \(1871–2008\)),
				'other' => q(венецуеланских боливара \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(Венецуелански боливар \(2008–2018\)),
				'few' => q(венецуеланска боливара \(2008–2018\)),
				'one' => q(венецуелански боливар \(2008–2018\)),
				'other' => q(венецуеланских боливара \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(венецуелански боливар),
				'few' => q(венецуеланска боливара),
				'one' => q(венецуелански боливар),
				'other' => q(венецуеланских боливара),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(вијетнамски донг),
				'few' => q(вијетнамска донга),
				'one' => q(вијетнамски донг),
				'other' => q(вијетнамских донга),
			},
		},
		'VNN' => {
			display_name => {
				'currency' => q(Вијетнамски донг \(1978–1985\)),
				'few' => q(вијетнамска донга \(1978–1985\)),
				'one' => q(вијетнамски донг \(1978–1985\)),
				'other' => q(вијетнамских донга \(1978–1985\)),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(вануатски вату),
				'few' => q(вануатскa ватуa),
				'one' => q(вануатски вату),
				'other' => q(вануатских ватуa),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(самоанска тала),
				'few' => q(самоанске тале),
				'one' => q(самоанска тала),
				'other' => q(самоанских тала),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(централноафрички франак),
				'few' => q(централноафричка франка),
				'one' => q(централноафрички франак),
				'other' => q(централноафричких франака),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(Сребро),
				'few' => q(сребра),
				'one' => q(сребро),
				'other' => q(сребра),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(Злато),
				'few' => q(злата),
				'one' => q(злато),
				'other' => q(злата),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(Европска композитна јединица),
				'few' => q(европске композитне јединице),
				'one' => q(европска композитна јединица),
				'other' => q(европских композитних јединица),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(Европска новчана јединица),
				'few' => q(европске новчане јединице \(XBB\)),
				'one' => q(европска новчана јединица \(XBB\)),
				'other' => q(европске новчане јединице \(XBB\)),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(Европска јединица рачуна \(XBC\)),
				'few' => q(европске јединице рачуна \(XBC\)),
				'one' => q(европска јединица рачуна \(XBC\)),
				'other' => q(европских јединица рачуна \(XBC\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(Европска јединица рачуна \(XBD\)),
				'few' => q(европске јединице рачуна \(XBD\)),
				'one' => q(европска јединица рачуна \(XBD\)),
				'other' => q(европских јединица рачуна \(XBD\)),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(источнокарипски долар),
				'few' => q(источнокарипскa доларa),
				'one' => q(источнокарипски долар),
				'other' => q(источнокарипскиx доларa),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(Посебна цртаћа права),
				'few' => q(посебна цртаћа права),
				'one' => q(посебно цртаће право),
				'other' => q(посебних цртаћих права),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(Европска валутна јединица),
				'few' => q(европске новчане јединице \(XEU\)),
				'one' => q(европска новчана јединица \(XEU\)),
				'other' => q(европских новчаних јединица),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(Француски златни франак),
				'few' => q(француска златна франка),
				'one' => q(француски златни франак),
				'other' => q(француских златних франака),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(Француски UIC-франак),
				'few' => q(француска UIC-франка),
				'one' => q(француски UIC-франак),
				'other' => q(француских UIC-франака),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(западноафрички франак),
				'few' => q(западноафричка франка),
				'one' => q(западноафрички франак),
				'other' => q(западноафричких франака),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(Паладијум),
				'few' => q(паладијума),
				'one' => q(паладијум),
				'other' => q(паладијума),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(CFP франак),
				'few' => q(CFP франка),
				'one' => q(CFP франак),
				'other' => q(CFP франака),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(Платина),
				'few' => q(платине),
				'one' => q(платина),
				'other' => q(платина),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(RINET фонд),
				'few' => q(RINET фонда),
				'one' => q(RINET фонд),
				'other' => q(RINET фондова),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(Код тестиране валуте),
				'few' => q(кода тестиране валуте),
				'one' => q(код тестиране валуте),
				'other' => q(кодова тестиране валуте),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Непозната валута),
				'few' => q(непознате валуте),
				'one' => q(непозната јединица валуте),
				'other' => q(непознатих валута),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(Јеменски динар),
				'few' => q(јеменска долара),
				'one' => q(јеменски долар),
				'other' => q(јеменских долара),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(јеменски ријал),
				'few' => q(јеменска ријала),
				'one' => q(јеменски ријал),
				'other' => q(jеменских ријала),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(Југословенски тврди динар),
				'few' => q(југословенска тврда динара),
				'one' => q(југословенски тврди динар),
				'other' => q(југословенских тврдих динара),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(Југословенски нови динар),
				'few' => q(југословенска нова динара),
				'one' => q(југословенски нови динар),
				'other' => q(југословенских нових динара),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(Југословенски конвертибилни динар),
				'few' => q(југословенска конвертибилна динара),
				'one' => q(југословенски конвертибилни динар),
				'other' => q(југословенских конвертибилних динара),
			},
		},
		'YUR' => {
			display_name => {
				'currency' => q(Југословенски реформирани динар),
				'few' => q(југословенска реформирана динара),
				'one' => q(југословенски реформирани динар),
				'other' => q(југословенских реформираних динара),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(Јужно-афрички ранд \(финансијски\)),
				'few' => q(јужноафричка ранда \(финансијска\)),
				'one' => q(јужноафрички ранд \(финансијски\)),
				'other' => q(јужноафричких ранда \(финансијских\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(јужноафрички ранд),
				'few' => q(јужноафричка ранда),
				'one' => q(јужноафрички ранд),
				'other' => q(јужноафричких ранда),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замбијска квача \(1968–2012\)),
				'few' => q(замбијске кваче \(1968–2012\)),
				'one' => q(замбијска квача \(1968–2012\)),
				'other' => q(замбијских квача \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(замбијска квача),
				'few' => q(замбијске кваче),
				'one' => q(замбијска квача),
				'other' => q(замбијских квача),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(Заирски нови заир),
				'few' => q(заирска нова заира),
				'one' => q(заирски нови заир),
				'other' => q(заирских нових заира),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(Заирски заир),
				'few' => q(заирска заира),
				'one' => q(заирски заир),
				'other' => q(заирских заира),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(1980–2008\)),
				'few' => q(зимбабвејска долара \(1980–2008\)),
				'one' => q(зимбабвејски долар \(1980–2008\)),
				'other' => q(зимбабвејских долара \(1980–2008\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(2009\)),
				'few' => q(зимбабвејска долара \(2009\)),
				'one' => q(зимбабвејски долар \(2009\)),
				'other' => q(зимбабвејских долара \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(2008\)),
				'few' => q(зимбабвејска долара \(2008\)),
				'one' => q(зимбабвејски долар \(2008\)),
				'other' => q(зимбабвејских долара \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					wide => {
						nonleap => [
							'Таут',
							'Баба',
							'Хатор',
							'Киахк',
							'Тоба',
							'Амшир',
							'Барамхат',
							'Барамуда',
							'Башанс',
							'Паона',
							'Епеп',
							'Месра',
							'Наси'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'Мескерем',
							'Текемт',
							'Хедар',
							'Тахсас',
							'Тер',
							'Јекатит',
							'Мегабит',
							'Миазиа',
							'Генбот',
							'Сене',
							'Хамле',
							'Нехасе',
							'Пагумен'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'јан',
							'феб',
							'мар',
							'апр',
							'мај',
							'јун',
							'јул',
							'авг',
							'сеп',
							'окт',
							'нов',
							'дец'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануар',
							'фебруар',
							'март',
							'април',
							'мај',
							'јун',
							'јул',
							'август',
							'септембар',
							'октобар',
							'новембар',
							'децембар'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'Тишри',
							'Хешван',
							'Кислев',
							'Тевет',
							'Шеват',
							'Адар I',
							'Адар',
							'Нисан',
							'Ијар',
							'Сиван',
							'Тамуз',
							'Ав',
							'Елул'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'Чаитра',
							'Ваисака',
							'Јиаиста',
							'Асада',
							'Сравана',
							'Бадра',
							'Асвина',
							'Картика',
							'Аргајана',
							'Пауза',
							'Мага',
							'Фалгуна'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Мух.',
							'Саф.',
							'Реб. 1',
							'Реб. 2',
							'Џум. 1',
							'Џум. 2',
							'Реџ.',
							'Ша.',
							'Рам.',
							'Ше.',
							'Зул-к.',
							'Зул-х.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Мухарем',
							'Сафар',
							'Рабиʻ I',
							'Рабиʻ II',
							'Јумада I',
							'Јумада II',
							'Рађаб',
							'Шаʻбан',
							'Рамадан',
							'Шавал',
							'Дуʻл-Киʻда',
							'Дуʻл-хиђа'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					wide => {
						nonleap => [
							'Мухарем',
							'Сафер',
							'Реби 1',
							'Реби 2',
							'Џумаде 1',
							'Џумаде 2',
							'Реџеб',
							'Шаʻбан',
							'Рамазан',
							'Шевал',
							'Зул-каде',
							'Зул-хиџе'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'Фаравадин',
							'Ордибехешт',
							'Кордад',
							'Тир',
							'Мордад',
							'Шахривар',
							'Мехр',
							'Абан',
							'Азар',
							'Деј',
							'Бахман',
							'Есфанд'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'пон',
						tue => 'уто',
						wed => 'сре',
						thu => 'чет',
						fri => 'пет',
						sat => 'суб',
						sun => 'нед'
					},
					short => {
						mon => 'по',
						tue => 'ут',
						wed => 'ср',
						thu => 'че',
						fri => 'пе',
						sat => 'су',
						sun => 'не'
					},
					wide => {
						mon => 'понедељак',
						tue => 'уторак',
						wed => 'среда',
						thu => 'четвртак',
						fri => 'петак',
						sat => 'субота',
						sun => 'недеља'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'п',
						tue => 'у',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1. кв.',
						1 => '2. кв.',
						2 => '3. кв.',
						3 => '4. кв.'
					},
					wide => {0 => 'први квартал',
						1 => 'други квартал',
						2 => 'трећи квартал',
						3 => 'четврти квартал'
					},
				},
				'stand-alone' => {
					narrow => {0 => '1.',
						1 => '2.',
						2 => '3.',
						3 => '4.'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'japanese') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{по подне},
					'evening1' => q{увече},
					'midnight' => q{поноћ},
					'morning1' => q{ујутро},
					'night1' => q{ноћу},
					'noon' => q{подне},
				},
				'narrow' => {
					'afternoon1' => q{по подне},
					'evening1' => q{увече},
					'midnight' => q{поноћ},
					'morning1' => q{ујутру},
					'night1' => q{ноћу},
					'noon' => q{подне},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{поподне},
					'evening1' => q{вече},
					'morning1' => q{јутро},
					'night1' => q{ноћ},
				},
				'narrow' => {
					'am' => q{пре подне},
					'pm' => q{по подне},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'БЕ'
			},
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'п. н. е.',
				'1' => 'н. е.'
			},
			narrow => {
				'0' => 'п.н.е.',
				'1' => 'н.е.'
			},
			wide => {
				'0' => 'пре нове ере',
				'1' => 'нове ере'
			},
		},
		'hebrew' => {
		},
		'indian' => {
			abbreviated => {
				'0' => 'САКА'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'АХ'
			},
		},
		'japanese' => {
			abbreviated => {
				'0' => 'Таика (645–650)',
				'1' => 'Хакучи (650–671)',
				'2' => 'Хакухо (672–686)',
				'3' => 'Шучо (686–701)',
				'4' => 'Таихо (701–704)',
				'5' => 'Кеиун (704–708)',
				'6' => 'Вадо (708–715)',
				'7' => 'Реики (715–717)',
				'8' => 'Јоро (717–724)',
				'9' => 'Јинки (724–729)',
				'10' => 'Темпио (729–749)',
				'11' => 'Темпио-кампо (749-749)',
				'12' => 'Темпио-шохо (749-757)',
				'13' => 'Темпио-хођи (757-765)',
				'14' => 'Темпо-ђинго (765-767)',
				'15' => 'Ђинго-кеиун (767-770)',
				'16' => 'Хоки (770–780)',
				'17' => 'Тен-о (781-782)',
				'18' => 'Енрјаку (782–806)',
				'19' => 'Даидо (806–810)',
				'20' => 'Конин (810–824)',
				'21' => 'Тенчо (824–834)',
				'22' => 'Шова (834–848)',
				'23' => 'Кајо (848–851)',
				'24' => 'Нињу (851–854)',
				'25' => 'Саико (854–857)',
				'26' => 'Тенан (857–859)',
				'27' => 'Јоган (859–877)',
				'28' => 'Генкеи (877–885)',
				'29' => 'Ниња (885–889)',
				'30' => 'Кампјо (889–898)',
				'31' => 'Шотаи (898–901)',
				'32' => 'Енђи (901–923)',
				'33' => 'Енчо (923–931)',
				'34' => 'Шохеи (931–938)',
				'35' => 'Тенгјо (938–947)',
				'36' => 'Тенриаку (947–957)',
				'37' => 'Тентоку (957–961)',
				'38' => 'Ова (961–964)',
				'39' => 'Кохо (964–968)',
				'40' => 'Ана (968–970)',
				'41' => 'Тенроку (970–973)',
				'42' => 'Тен-ен (973-976)',
				'43' => 'Јоген (976–978)',
				'44' => 'Тенген (978–983)',
				'45' => 'Еикан (983–985)',
				'46' => 'Кана (985–987)',
				'47' => 'Еи-ен (987-989)',
				'48' => 'Еисо (989–990)',
				'49' => 'Шорјаку (990–995)',
				'50' => 'Чотоку (995–999)',
				'51' => 'Чохо (999–1004)',
				'52' => 'Канко (1004–1012)',
				'53' => 'Чова (1012–1017)',
				'54' => 'Канин (1017–1021)',
				'55' => 'Ђиан (1021–1024)',
				'56' => 'Мању (1024–1028)',
				'57' => 'Чоген (1028–1037)',
				'58' => 'Чорјаку (1037–1040)',
				'59' => 'Чокју (1040–1044)',
				'60' => 'Кантоку (1044–1046)',
				'61' => 'Еишо (1046–1053)',
				'62' => 'Тенђи (1053–1058)',
				'63' => 'Кохеи (1058–1065)',
				'64' => 'Ђирјаку (1065–1069)',
				'65' => 'Енкју (1069–1074)',
				'66' => 'Шохо (1074–1077)',
				'67' => 'Шорјаку (1077–1081)',
				'68' => 'Еишо (1081–1084)',
				'69' => 'Отоку (1084–1087)',
				'70' => 'Канђи (1087–1094)',
				'71' => 'Кахо (1094–1096)',
				'72' => 'Еичо (1096–1097)',
				'73' => 'Шотоку (1097–1099)',
				'74' => 'Кова (1099–1104)',
				'75' => 'Чођи (1104–1106)',
				'76' => 'Кашо (1106–1108)',
				'77' => 'Тенин (1108–1110)',
				'78' => 'Тен-еи (1110-1113)',
				'79' => 'Еикју (1113–1118)',
				'80' => 'Ђен-еи (1118-1120)',
				'81' => 'Хоан (1120–1124)',
				'82' => 'Тенђи (1124–1126)',
				'83' => 'Даиђи (1126–1131)',
				'84' => 'Теншо (1131–1132)',
				'85' => 'Чошао (1132–1135)',
				'86' => 'Хоен (1135–1141)',
				'87' => 'Еиђи (1141–1142)',
				'88' => 'Кођи (1142–1144)',
				'89' => 'Тењо (1144–1145)',
				'90' => 'Кјуан (1145–1151)',
				'91' => 'Нинпеи (1151–1154)',
				'92' => 'Кјују (1154–1156)',
				'93' => 'Хоген (1156–1159)',
				'94' => 'Хеиђи (1159–1160)',
				'95' => 'Еирјаку (1160–1161)',
				'96' => 'Охо (1161–1163)',
				'97' => 'Чокан (1163–1165)',
				'98' => 'Еиман (1165–1166)',
				'99' => 'Нин-ан (1166-1169)',
				'100' => 'Као (1169–1171)',
				'101' => 'Шоан (1171–1175)',
				'102' => 'Анген (1175–1177)',
				'103' => 'Ђишо (1177–1181)',
				'104' => 'Јова (1181–1182)',
				'105' => 'Ђуеи (1182–1184)',
				'106' => 'Генрјуку (1184–1185)',
				'107' => 'Бунђи (1185–1190)',
				'108' => 'Кенкју (1190–1199)',
				'109' => 'Шођи (1199–1201)',
				'110' => 'Кенин (1201–1204)',
				'111' => 'Генкју (1204–1206)',
				'112' => 'Кен-еи (1206-1207)',
				'113' => 'Шоген (1207–1211)',
				'114' => 'Кенрјаку (1211–1213)',
				'115' => 'Кенпо (1213–1219)',
				'116' => 'Шокју (1219–1222)',
				'117' => 'Ђу (1222–1224)',
				'118' => 'Ђенин (1224–1225)',
				'119' => 'Кароку (1225–1227)',
				'120' => 'Антеи (1227–1229)',
				'121' => 'Канки (1229–1232)',
				'122' => 'Ђоеи (1232–1233)',
				'123' => 'Темпуку (1233–1234)',
				'124' => 'Бунрјаку (1234–1235)',
				'125' => 'Катеи (1235–1238)',
				'126' => 'Рјакунин (1238–1239)',
				'127' => 'Ен-о (1239-1240)',
				'128' => 'Нињи (1240–1243)',
				'129' => 'Канген (1243–1247)',
				'130' => 'Хођи (1247–1249)',
				'131' => 'Кенчо (1249–1256)',
				'132' => 'Коген (1256–1257)',
				'133' => 'Шока (1257–1259)',
				'134' => 'Шоген (1259–1260)',
				'135' => 'Бун-о (1260-1261)',
				'136' => 'Кочо (1261–1264)',
				'137' => 'Бун-еи (1264-1275)',
				'138' => 'Кенђи (1275–1278)',
				'139' => 'Коан (1278–1288)',
				'140' => 'Шу (1288–1293)',
				'141' => 'Еинин (1293–1299)',
				'142' => 'Шоан (1299–1302)',
				'143' => 'Кенген (1302–1303)',
				'144' => 'Каген (1303–1306)',
				'145' => 'Токуђи (1306–1308)',
				'146' => 'Енкеи (1308–1311)',
				'147' => 'Очо (1311–1312)',
				'148' => 'Шова (1312–1317)',
				'149' => 'Бунпо (1317–1319)',
				'150' => 'Ђено (1319–1321)',
				'151' => 'Ђенкјо (1321–1324)',
				'152' => 'Шочу (1324–1326)',
				'153' => 'Кареки (1326–1329)',
				'154' => 'Гентоку (1329–1331)',
				'155' => 'Генко (1331–1334)',
				'156' => 'Кему (1334–1336)',
				'157' => 'Енген (1336–1340)',
				'158' => 'Кококу (1340–1346)',
				'159' => 'Шохеи (1346–1370)',
				'160' => 'Кентоку (1370–1372)',
				'161' => 'Бучу (1372–1375)',
				'162' => 'Тењу (1375–1379)',
				'163' => 'Корјаку (1379–1381)',
				'164' => 'Кова (1381–1384)',
				'165' => 'Генчу (1384–1392)',
				'166' => 'Меитоку (1384–1387)',
				'167' => 'Какеи (1387–1389)',
				'168' => 'Ку (1389–1390)',
				'169' => 'Меитоку (1390–1394)',
				'170' => 'Оеи (1394–1428)',
				'171' => 'Шочо (1428–1429)',
				'172' => 'Еикјо (1429–1441)',
				'173' => 'Какитсу (1441–1444)',
				'174' => 'Бун-ан (1444-1449)',
				'175' => 'Хотоку (1449–1452)',
				'176' => 'Кјотоку (1452–1455)',
				'177' => 'Кошо (1455–1457)',
				'178' => 'Чороку (1457–1460)',
				'179' => 'Каншо (1460–1466)',
				'180' => 'Буншо (1466–1467)',
				'181' => 'Онин (1467–1469)',
				'182' => 'Бунмеи (1469–1487)',
				'183' => 'Чокјо (1487–1489)',
				'184' => 'Ентоку (1489–1492)',
				'185' => 'Меио (1492–1501)',
				'186' => 'Бунки (1501–1504)',
				'187' => 'Еишо (1504–1521)',
				'188' => 'Таиеи (1521–1528)',
				'189' => 'Кјороку (1528–1532)',
				'190' => 'Тенмон (1532–1555)',
				'191' => 'Кођи (1555–1558)',
				'192' => 'Еироку (1558–1570)',
				'193' => 'Генки (1570–1573)',
				'194' => 'Теншо (1573–1592)',
				'195' => 'Бунроку (1592–1596)',
				'196' => 'Кеичо (1596–1615)',
				'197' => 'Генва (1615–1624)',
				'198' => 'Кан-еи (1624-1644)',
				'199' => 'Шохо (1644–1648)',
				'200' => 'Кеиан (1648–1652)',
				'201' => 'Шу (1652–1655)',
				'202' => 'Меирјаку (1655–1658)',
				'203' => 'Мањи (1658–1661)',
				'204' => 'Канбун (1661–1673)',
				'205' => 'Енпо (1673–1681)',
				'206' => 'Тенва (1681–1684)',
				'207' => 'Јокјо (1684–1688)',
				'208' => 'Генроку (1688–1704)',
				'209' => 'Хоеи (1704–1711)',
				'210' => 'Шотоку (1711–1716)',
				'211' => 'Кјохо (1716–1736)',
				'212' => 'Генбун (1736–1741)',
				'213' => 'Канпо (1741–1744)',
				'214' => 'Енкјо (1744–1748)',
				'215' => 'Кан-ен (1748-1751)',
				'216' => 'Хорјаку (1751–1764)',
				'217' => 'Меива (1764–1772)',
				'218' => 'Ан-еи (1772-1781)',
				'219' => 'Тенмеи (1781–1789)',
				'220' => 'Кансеи (1789–1801)',
				'221' => 'Кјова (1801–1804)',
				'222' => 'Бунка (1804–1818)',
				'223' => 'Бунсеи (1818–1830)',
				'224' => 'Тенпо (1830–1844)',
				'225' => 'Кока (1844–1848)',
				'226' => 'Каеи (1848–1854)',
				'227' => 'Ансеи (1854–1860)',
				'228' => 'Ман-ен (1860-1861)',
				'229' => 'Бункју (1861–1864)',
				'230' => 'Генђи (1864–1865)',
				'231' => 'Кеико (1865–1868)',
				'232' => 'Меиђи',
				'233' => 'Таишо',
				'234' => 'Шова',
				'235' => 'Хаисеи',
				'236' => 'Реива'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'АП'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'Пре РК',
				'1' => 'РК'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, d. MMMM y. G},
			'long' => q{d. MMMM y. G},
			'medium' => q{d.MM.y. G},
			'short' => q{d.M.y. GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d. MMMM y.},
			'long' => q{d. MMMM y.},
			'medium' => q{d. M. y.},
			'short' => q{d.M.yy.},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
			'full' => q{EEEE, MMMM d, y G},
			'long' => q{MMMM d, y G},
			'medium' => q{MMM d, y G},
			'short' => q{M/d/yy G},
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bhm => q{hh:mm B},
			Bhms => q{hh:mm:ss B},
			EBhm => q{E hh:mm B},
			EBhms => q{E hh:mm:ss B},
			Ed => q{E d.},
			Ehm => q{E hh:mm a},
			Ehms => q{E hh:mm:ss a},
			Gy => q{y. G},
			GyMMM => q{MMM y. G},
			GyMMMEd => q{E, d. MMM y. G},
			GyMMMd => q{d. MMM y. G},
			GyMd => q{d.M.y. GGGGG},
			MEd => q{E, d.M.},
			MMMEd => q{E, d. MMM},
			MMMMEd => q{E, d. MMMM},
			MMMMd => q{d. MMMM},
			MMMd => q{d. MMM},
			MMMdd => q{dd.MMM},
			MMdd => q{MM-dd},
			Md => q{d.M.},
			h => q{h a},
			hm => q{hh:mm a},
			hms => q{hh:mm:ss a},
			y => q{y. G},
			yyyy => q{y. G},
			yyyyM => q{M.y. GGGGG},
			yyyyMEd => q{E, d.M.y. GGGGG},
			yyyyMM => q{MM.y. G},
			yyyyMMM => q{MMM y. G},
			yyyyMMMEd => q{E, d. MMM y. G},
			yyyyMMMM => q{MMMM y. G},
			yyyyMMMd => q{d. MMM y. G},
			yyyyMMdd => q{dd.MM.y. G},
			yyyyMd => q{d.M.y. GGGGG},
			yyyyQQQ => q{QQQ, y. G},
			yyyyQQQQ => q{QQQQ y. G},
		},
		'gregorian' => {
			Bhm => q{hh:mm B},
			Bhms => q{hh:mm:ss B},
			E => q{E},
			EBhm => q{E hh:mm B},
			EBhms => q{E hh:mm:ss B},
			Ed => q{E d.},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y. G},
			GyMMM => q{MMM y. G},
			GyMMMEd => q{E, d. MMM y. G},
			GyMMMd => q{d. MMM y. G},
			GyMd => q{d.MM.y. GGGGG},
			MEd => q{E, d. M.},
			MMMEd => q{E d. MMM},
			MMMMEd => q{E, d. MMMM},
			MMMMW => q{W. 'седмица' 'у' MMMM.},
			MMMMd => q{d. MMMM},
			MMMd => q{d. MMM},
			MMMdd => q{dd.MMM},
			MMdd => q{dd.MM.},
			Md => q{d. M.},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			y => q{y.},
			yM => q{M. y.},
			yMEd => q{E, d. M. y.},
			yMM => q{MM.y.},
			yMMM => q{MMM y.},
			yMMMEd => q{E, d. MMM y.},
			yMMMM => q{MMMM y.},
			yMMMd => q{d. MMM y.},
			yMMdd => q{dd.MM.y.},
			yMd => q{d. M. y.},
			yQQQ => q{QQQ y.},
			yQQQQ => q{QQQQ y.},
			yw => q{w. 'седмица' 'у' Y.},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d.M – E, d.M},
				d => q{E, d.M – E, d.M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, dd. MMM – E, dd. MMM},
				d => q{E, dd. – E, dd. MMM},
			},
			MMMd => {
				M => q{d. MMM – d. MMM},
				d => q{d – d. MMM},
			},
			Md => {
				M => q{d.M – d.M},
				d => q{d.M – d.M},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y – y. G},
			},
			yM => {
				M => q{M.y – M.y. GGGGG},
				y => q{M.y – M.y. GGGGG},
			},
			yMEd => {
				M => q{E, d.M.y – E, d.M.y. GGGGG},
				d => q{E, d.M.y – E, d.M.y. GGGGG},
				y => q{E, d.M.y – E, d.M.y. GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y. G},
				y => q{MMM y – MMM y. G},
			},
			yMMMEd => {
				M => q{E, d. MMM – E, d. MMM y. G},
				d => q{E, d. MMM – E, d. MMM y. G},
				y => q{E, d. MMM y – E, d. MMM y. G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y. G},
				y => q{MMMM y. – MMMM y. G},
			},
			yMMMd => {
				M => q{d. MMM – d. MMM y. G},
				d => q{d–d. MMM y. G},
				y => q{d. MMM y. – d. MMM y. G},
			},
			yMd => {
				M => q{d.M.y. – d.M.y.},
				d => q{d.M.y – d.M.y. GGGGG},
				y => q{d.M.y – d.M.y. GGGGG},
			},
		},
		'gregorian' => {
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d. M. – E, d. M.},
				d => q{E, d. M. – E, d. M.},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, dd. MMM – E, dd. MMM},
				d => q{E, dd. – E, dd. MMM},
			},
			MMMd => {
				M => q{dd. MMM – dd. MMM},
				d => q{dd.–dd. MMM},
			},
			Md => {
				M => q{d. M. – d. M.},
				d => q{d. M. – d. M.},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			yM => {
				M => q{M – M. y.},
				y => q{M.y. – M.y.},
			},
			yMEd => {
				M => q{E, d. M. y. – E, d. M. y.},
				d => q{E, d. M. y. – E, d. M. y.},
				y => q{E, d. M. y. – E, d. M. y.},
			},
			yMMM => {
				M => q{MMM–MMM y.},
				y => q{MMM y. – MMM y.},
			},
			yMMMEd => {
				M => q{E, dd. MMM – E, dd. MMM y.},
				d => q{E, dd. – E, dd. MMM y.},
				y => q{E, dd. MMM y. – E, dd. MMM y.},
			},
			yMMMM => {
				M => q{MMMM – MMMM y.},
				y => q{MMMM y. – MMMM y.},
			},
			yMMMd => {
				M => q{dd. MMM – dd. MMM y.},
				d => q{dd.–dd. MMM y.},
				y => q{dd. MMM y. – dd. MMM y.},
			},
			yMd => {
				M => q{d. M. y. – d. M. y.},
				d => q{d. M. y. – d. M. y.},
				y => q{d. M. y. – d. M. y.},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q({0}, летње време),
		regionFormat => q({0}, стандардно време),
		'Acre' => {
			long => {
				'daylight' => q#Акре летње рачунање времена#,
				'generic' => q#Акре време#,
				'standard' => q#Акре стандардно време#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#Авганистан време#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиџан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Акра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Адис Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмера#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Бангуи#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисао#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантир#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Бразавил#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Буџумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каиро#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Казабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-ес-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Џибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ел Ајун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габорон#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Јоханесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Џуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Картум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревил#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадиш#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровија#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Најроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нџамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Нијамеј#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сао Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Централно-афричко време#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Источно-афричко време#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Јужно-афричко време#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Западно-афричко летње време#,
				'generic' => q#Западно-афричко време#,
				'standard' => q#Западно-афричко стандардно време#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Аљаска, летње време#,
				'generic' => q#Аљаска#,
				'standard' => q#Аљаска, стандардно време#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#Алмати летње рачунање времена#,
				'generic' => q#Алмати време#,
				'standard' => q#Алмати стандардно време#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Амазон, летње време#,
				'generic' => q#Амазон време#,
				'standard' => q#Амазон, стандардно време#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Енкориџ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангвила#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигва#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагвајана#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Гаљегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луи#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуаија#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Баија#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баија Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белизе#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Сејблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бојзи#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос Ајрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембриџ Беј#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кајен#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кајманска Острва#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чихуахуа#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#Сиудад Хуарез#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал Харбур#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Костарика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куиаба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Курасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмарксхаген#,
		},
		'America/Dawson' => {
			exemplarCity => q#Досон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Досон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детроит#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Еирунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Салвадор#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт Нелсон#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глејс Беј#,
		},
		'America/Godthab' => {
			exemplarCity => q#Готхаб#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Беј#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гвадалупе#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гвајакил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гвајана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Хермосиљо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индијана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индијана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсбург, Индијана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити, Индијана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вевај, Индијана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винценес, Индијана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индијана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Иквалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Јамајка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуи#,
		},
		'America/Juneau' => {
			exemplarCity => q#Жуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичело, Кентаки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендајк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Паз#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос Анђелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луивиле#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуер Принсиз Квортер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масејо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагва#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мексико Сити#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтереј#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсерат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Насау#,
		},
		'America/New_York' => {
			exemplarCity => q#Њујорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Нороња#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бијула, Северна Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Центар, Северна Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нови Салем, Северна Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртунг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Финикс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт о Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт оф Спејн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто Вељо#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Порто Рико#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Пунта Аренас#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рејни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифе#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Ресолут#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта Изабел#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантјаго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сао Паоло#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорезбисунд#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Св. Бартоломeј#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Св. Џон#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Св. Луција#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Св. Тома#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Курент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигалпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Тул#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандер Беј#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Вајтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Винипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Јакутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Јелоунајф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Северноамеричко централно летње време#,
				'generic' => q#Северноамеричко централно време#,
				'standard' => q#Северноамеричко централно стандардно време#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Северноамеричко источно летње време#,
				'generic' => q#Северноамеричко источно време#,
				'standard' => q#Северноамеричко источно стандардно време#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Северноамеричко планинско летње време#,
				'generic' => q#Северноамеричко планинско време#,
				'standard' => q#Северноамеричко планинско стандардно време#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Северноамеричко пацифичко летње време#,
				'generic' => q#Северноамеричко пацифичко време#,
				'standard' => q#Северноамеричко пацифичко стандардно време#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#Анадир летње рачунање времена#,
				'generic' => q#Анадир време#,
				'standard' => q#Анадир стандардно време#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кејси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дејвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Димон д’Урвил#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Меквори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Мосон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Макмурдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Шова#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Трол#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Апија, летње време#,
				'generic' => q#Апија време#,
				'standard' => q#Апија, стандардно време#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#Акватау летње рачунање времена#,
				'generic' => q#Акватау време#,
				'standard' => q#Акватау стандардно време#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#Акутобе летње рачунање времена#,
				'generic' => q#Акутобе време#,
				'standard' => q#Акутобе стандардно време#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Арабијско летње време#,
				'generic' => q#Арабијско време#,
				'standard' => q#Арабијско стандардно време#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгјербјен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Аргентина, летње време#,
				'generic' => q#Аргентина време#,
				'standard' => q#Аргентина, стандардно време#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Западна Аргентина, летње време#,
				'generic' => q#Западна Аргентина време#,
				'standard' => q#Западна Аргентина, стандардно време#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Јерменија, летње време#,
				'generic' => q#Јерменија време#,
				'standard' => q#Јерменија, стандардно време#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмати#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Аман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Акутобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атирау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахреин#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнаул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бејрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Брунеј#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калкута#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чојбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубаи#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Фамагуста#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонгконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркуцк#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Џакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Џајапура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Јерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандига#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Краснојарск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувајт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никозија#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузњецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пном Пен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтијанак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пјонгјанг#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#Костанај#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кизилорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Ријад#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шангај#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Средњеколимск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тајпеј#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Техеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимпу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томск#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумћи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вијентијан#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Јакутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Јекатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Јереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлантско летње време#,
				'generic' => q#Атлантско време#,
				'standard' => q#Атлантско стандардно време#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азори#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуда#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канарска острва#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Зеленортска Острва#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарска Острва#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадеира#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рејкјавик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Јужна Џорџија#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Света Јелена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделејд#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Бризбејн#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен Хил#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Кари#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Иукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мелбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сиднеј#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Аустралијско централно летње време#,
				'generic' => q#Аустралијско централно време#,
				'standard' => q#Аустралијско централно стандардно време#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Аустралијско централно западно летње време#,
				'generic' => q#Аустралијско централно западно време#,
				'standard' => q#Аустралијско централно западно стандардно време#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Аустралијско источно летње време#,
				'generic' => q#Аустралијско источно време#,
				'standard' => q#Аустралијско источно стандардно време#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Аустралијско западно летње време#,
				'generic' => q#Аустралијско западно време#,
				'standard' => q#Аустралијско западно стандардно време#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Азербејџан, летње време#,
				'generic' => q#Азербејџан време#,
				'standard' => q#Азербејџан, стандардно време#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Азори, летње време#,
				'generic' => q#Азори време#,
				'standard' => q#Азори, стандардно време#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Бангладеш, летње време#,
				'generic' => q#Бангладеш време#,
				'standard' => q#Бангладеш, стандардно време#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Бутан време#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Боливија време#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Бразилија, летње време#,
				'generic' => q#Бразилија време#,
				'standard' => q#Бразилија, стандардно време#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Брунеј Дарусалум време#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Зеленортска Острва, летње време#,
				'generic' => q#Зеленортска Острва време#,
				'standard' => q#Зеленортска Острва, стандардно време#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Чаморо време#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Чатам, летње време#,
				'generic' => q#Чатам време#,
				'standard' => q#Чатам, стандардно време#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Чиле, летње време#,
				'generic' => q#Чиле време#,
				'standard' => q#Чиле, стандардно време#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Кина, летње време#,
				'generic' => q#Кина време#,
				'standard' => q#Кинеско стандардно време#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#Чојбалсан, летње време#,
				'generic' => q#Чојбалсан време#,
				'standard' => q#Чојбалсан, стандардно време#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Божићно острво време#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Кокос (Келинг) Острва време#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Колумбија, летње време#,
				'generic' => q#Колумбија време#,
				'standard' => q#Колумбија, стандардно време#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Кукова острва, полу-летње време#,
				'generic' => q#Кукова острва време#,
				'standard' => q#Кукова острва, стандардно време#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Куба, летње време#,
				'generic' => q#Куба#,
				'standard' => q#Куба, стандардно време#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Дејвис време#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Димон д’Урвил време#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Источни тимор време#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Ускршња острва, летње време#,
				'generic' => q#Ускршња острва време#,
				'standard' => q#Ускршња острва, стандардно време#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Еквадор време#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Координисано универзално време#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Непознат град#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андора#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Астракан#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Атина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Београд#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брисел#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Букурешт#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будимпешта#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бисинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишињев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенхаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Даблин#,
			long => {
				'daylight' => q#Ирска, стандардно време#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернзи#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Острво Ман#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Џерзи#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калињинград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Кијев#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Киров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лисабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Љубљана#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#Британија, летње време#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Луксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Малта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Марихамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париз#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Праг#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сарајево#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферопољ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопље#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софија#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокхолм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Талин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Уљановск#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуз#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Беч#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вилњус#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожје#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цирих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Средњеевропско летње време#,
				'generic' => q#Средњеевропско време#,
				'standard' => q#Средњеевропско стандардно време#,
			},
			short => {
				'daylight' => q#CEST#,
				'generic' => q#CET#,
				'standard' => q#CET#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Источноевропско летње време#,
				'generic' => q#Источноевропско време#,
				'standard' => q#Источноевропско стандардно време#,
			},
			short => {
				'daylight' => q#EEST#,
				'generic' => q#EET#,
				'standard' => q#EET#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Време даљег истока Европе#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Западноевропско летње време#,
				'generic' => q#Западноевропско време#,
				'standard' => q#Западноевропско стандардно време#,
			},
			short => {
				'daylight' => q#WEST#,
				'generic' => q#WET#,
				'standard' => q#WET#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Фолкландска Острва, летње време#,
				'generic' => q#Фолкландска Острва време#,
				'standard' => q#Фолкландска Острва, стандардно време#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Фиџи, летње време#,
				'generic' => q#Фиџи време#,
				'standard' => q#Фиџи, стандардно време#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Француска Гвајана време#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Француско јужно и антарктичко време#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Средње време по Гриничу#,
			},
			short => {
				'standard' => q#GMT#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Галапагос време#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Гамбије време#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Грузија, летње време#,
				'generic' => q#Грузија време#,
				'standard' => q#Грузија, стандардно време#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Гилберт острва време#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Источни Гренланд, летње време#,
				'generic' => q#Источни Гренланд#,
				'standard' => q#Источни Гренланд, стандардно време#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Западни Гренланд, летње време#,
				'generic' => q#Западни Гренланд#,
				'standard' => q#Западни Гренланд, стандардно време#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#Гуам стандардно време#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Заливско време#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Гвајана време#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Хавајско-алеутско летње време#,
				'generic' => q#Хавајско-алеутско време#,
				'standard' => q#Хавајско-алеутско стандардно време#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Хонг Конг, летње време#,
				'generic' => q#Хонг Конг време#,
				'standard' => q#Хонг Конг, стандардно време#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Ховд, летње време#,
				'generic' => q#Ховд време#,
				'standard' => q#Ховд, стандардно време#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Индијско стандардно време#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Божић#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдиви#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маурицијус#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Мајот#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реунион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Индијско океанско време#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Индокина време#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Централно-индонезијско време#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Источно-индонезијско време#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Западно-индонезијско време#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Иран, летње време#,
				'generic' => q#Иран време#,
				'standard' => q#Иран, стандардно време#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Иркуцк, летње време#,
				'generic' => q#Иркуцк време#,
				'standard' => q#Иркуцк, стандардно време#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Израелско летње време#,
				'generic' => q#Израелско време#,
				'standard' => q#Израелско стандардно време#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Јапанско летње време#,
				'generic' => q#Јапанско време#,
				'standard' => q#Јапанско стандардно време#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#Петропавловско-камчатско летње рачунање времена#,
				'generic' => q#Петропавловско-камчатско време#,
				'standard' => q#Петропавловско-камчатско стандардно време#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Источно-казахстанско време#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Западно-казахстанско време#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Корејско летње време#,
				'generic' => q#Корејско време#,
				'standard' => q#Корејско стандардно време#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Кошре време#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Краснојарск, летње време#,
				'generic' => q#Краснојарск време#,
				'standard' => q#Краснојарск, стандардно време#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Киргистан време#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#Шри Ланка време#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Острва Лајн време#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Лорд Хов, летње време#,
				'generic' => q#Лорд Хов време#,
				'standard' => q#Лорд Хов, стандардно време#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#Макао летње рачунање времена#,
				'generic' => q#Макао време#,
				'standard' => q#Макао стандардно време#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#Острво Маквери време#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Магадан, летње време#,
				'generic' => q#Магадан време#,
				'standard' => q#Магадан, стандардно време#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Малезија време#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Малдиви време#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Маркиз време#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Маршалска Острва време#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Маурицијус, летње време#,
				'generic' => q#Маурицијус време#,
				'standard' => q#Маурицијус, стандардно време#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Мосон време#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#Северозападни Мексико, летње време#,
				'generic' => q#Северозападни Мексико#,
				'standard' => q#Северозападни Мексико, стандардно време#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Мексички Пацифик, летње време#,
				'generic' => q#Мексички Пацифик#,
				'standard' => q#Мексички Пацифик, стандардно време#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Улан Батор, летње време#,
				'generic' => q#Улан Батор време#,
				'standard' => q#Улан Батор, стандардно време#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Москва, летње време#,
				'generic' => q#Москва време#,
				'standard' => q#Москва, стандардно време#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Мијанмар време#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Науру време#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Непал време#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Нова Каледонија, летње време#,
				'generic' => q#Нова Каледонија време#,
				'standard' => q#Нова Каледонија, стандардно време#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Нови Зеланд, летње време#,
				'generic' => q#Нови Зеланд време#,
				'standard' => q#Нови Зеланд, стандардно време#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Њуфаундленд, летње време#,
				'generic' => q#Њуфаундленд#,
				'standard' => q#Њуфаундленд, стандардно време#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Ниуе време#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#Норфолк Острво, летње време#,
				'generic' => q#Норфолк Острво време#,
				'standard' => q#Норфолк Острво, стандардно време#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Фернандо де Нороња, летње време#,
				'generic' => q#Фернандо де Нороња време#,
				'standard' => q#Фернандо де Нороња, стандардно време#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#Северна Маријанска Острва време#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Новосибирск, летње време#,
				'generic' => q#Новосибирск време#,
				'standard' => q#Новосибирск, стандардно време#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Омск, летње време#,
				'generic' => q#Омск време#,
				'standard' => q#Омск, стандардно време#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апија#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окланд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Буганвил#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатам#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Ускршње острво#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефат#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Ендербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиџи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбије#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Џонстон#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#Кантон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Кошре#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваџалејин#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Мајуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркиз#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидвеј#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкерн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понапе#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Морзби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сајпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Тахити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Трук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Вејк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Валис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Пакистан, летње време#,
				'generic' => q#Пакистан време#,
				'standard' => q#Пакистан, стандардно време#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Палау време#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Папуа Нова Гвинеја време#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Парагвај, летње време#,
				'generic' => q#Парагвај време#,
				'standard' => q#Парагвај, стандардно време#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Перу, летње време#,
				'generic' => q#Перу време#,
				'standard' => q#Перу, стандардно време#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Филипини, летње време#,
				'generic' => q#Филипини време#,
				'standard' => q#Филипини, стандардно време#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Феникс острва време#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Сен Пјер и Микелон, летње време#,
				'generic' => q#Сен Пјер и Микелон#,
				'standard' => q#Сен Пјер и Микелон, стандардно време#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Питкерн време#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Понпеј време#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Пјонгјаншко време#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#Кизилорда летње рачунање времена#,
				'generic' => q#Кизилорда време#,
				'standard' => q#Кизилорда стандардно време#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Реинион време#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Ротера време#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Сахалин, летње време#,
				'generic' => q#Сахалин време#,
				'standard' => q#Сахалин, стандардно време#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#Самара летње рачунање времена#,
				'generic' => q#Самара време#,
				'standard' => q#Самара стандардно време#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Самоа, летње време#,
				'generic' => q#Самоа време#,
				'standard' => q#Самоа, стандардно време#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Сејшели време#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Сингапур, стандардно време#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Соломонска Острва време#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Јужна Џорџија време#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Суринам време#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Шова време#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Тахити време#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Тајпеј, летње време#,
				'generic' => q#Тајпеј време#,
				'standard' => q#Тајпеј, стандардно време#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Таџикистан време#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Токелау време#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Тонга, летње време#,
				'generic' => q#Тонга време#,
				'standard' => q#Тонга, стандардно време#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Чуук време#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Туркменистан, летње време#,
				'generic' => q#Туркменистан време#,
				'standard' => q#Туркменистан, стандардно време#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Тувалу време#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Уругвај, летње време#,
				'generic' => q#Уругвај време#,
				'standard' => q#Уругвај, стандардно време#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Узбекистан, летње време#,
				'generic' => q#Узбекистан време#,
				'standard' => q#Узбекистан, стандардно време#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Вануату, летње време#,
				'generic' => q#Вануату време#,
				'standard' => q#Вануату, стандардно време#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Венецуела време#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Владивосток, летње време#,
				'generic' => q#Владивосток време#,
				'standard' => q#Владивосток, стандардно време#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Волгоград, летње време#,
				'generic' => q#Волгоград време#,
				'standard' => q#Волгоград, стандардно време#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Восток време#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Вејк острво време#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Валис и Футуна Острва време#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Јакутск, летње време#,
				'generic' => q#Јакутск време#,
				'standard' => q#Јакутск, стандардно време#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Јекатеринбург, летње време#,
				'generic' => q#Јекатеринбург време#,
				'standard' => q#Јекатеринбург, стандардно време#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#Јукон#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
