#!perl -T
use strict;
use warnings FATAL => 'all';
use Test::More;

eval "use Imager::File::PNG";
plan skip_all => "Imager::File::PNG required" if $@;
plan tests => 6;

use_ok 'Spreadsheet::HTML';

my %file = ( file => 't/data/simple.png', sorted_attrs => 1 );
my $html = '<table border="0" cellpadding="0" cellspacing="0"><tr><th height="8" style="background-color: #000000" width="16">&nbsp;</th><th height="8" style="background-color: #000000" width="16">&nbsp;</th><th height="8" style="background-color: #000000" width="16">&nbsp;</th><th height="8" style="background-color: #000000" width="16">&nbsp;</th><th height="8" style="background-color: #000000" width="16">&nbsp;</th><th height="8" style="background-color: #000000" width="16">&nbsp;</th><th height="8" style="background-color: #000000" width="16">&nbsp;</th><th height="8" style="background-color: #000000" width="16">&nbsp;</th></tr><tr><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td></tr><tr><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td></tr><tr><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td></tr><tr><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td></tr><tr><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #FF0000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td></tr><tr><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td></tr><tr><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td><td height="8" style="background-color: #000000" width="16">&nbsp;</td></tr></table>';

my $table = new_ok 'Spreadsheet::HTML', [ %file ];

is $table->generate,
    $html,
    "loaded simple PNG image via method"
;

is Spreadsheet::HTML::generate( %file ),
    $html,
    "loaded simple PNG image via procedure"
;

$html = '<table border="0" cellpadding="0" cellspacing="0"><tr><th height="8" style="background-color: #000000" width="16">1</th><th height="8" style="background-color: #000000" width="16">2</th><th height="8" style="background-color: #000000" width="16">3</th><th height="8" style="background-color: #000000" width="16">4</th><th height="8" style="background-color: #000000" width="16">5</th><th height="8" style="background-color: #000000" width="16">6</th><th height="8" style="background-color: #000000" width="16">7</th><th height="8" style="background-color: #000000" width="16">8</th></tr><tr><td height="8" style="background-color: #000000" width="16">9</td><td height="8" style="background-color: #000000" width="16">10</td><td height="8" style="background-color: #000000" width="16">11</td><td height="8" style="background-color: #000000" width="16">12</td><td height="8" style="background-color: #000000" width="16">13</td><td height="8" style="background-color: #000000" width="16">14</td><td height="8" style="background-color: #000000" width="16">15</td><td height="8" style="background-color: #000000" width="16">16</td></tr><tr><td height="8" style="background-color: #000000" width="16">17</td><td height="8" style="background-color: #000000" width="16">18</td><td height="8" style="background-color: #FF0000" width="16">19</td><td height="8" style="background-color: #FF0000" width="16">20</td><td height="8" style="background-color: #FF0000" width="16">21</td><td height="8" style="background-color: #FF0000" width="16">22</td><td height="8" style="background-color: #000000" width="16">23</td><td height="8" style="background-color: #000000" width="16">24</td></tr><tr><td height="8" style="background-color: #000000" width="16">25</td><td height="8" style="background-color: #000000" width="16">26</td><td height="8" style="background-color: #FF0000" width="16">27</td><td height="8" style="background-color: #FF0000" width="16">28</td><td height="8" style="background-color: #FF0000" width="16">29</td><td height="8" style="background-color: #FF0000" width="16">30</td><td height="8" style="background-color: #000000" width="16">31</td><td height="8" style="background-color: #000000" width="16">32</td></tr><tr><td height="8" style="background-color: #000000" width="16">33</td><td height="8" style="background-color: #000000" width="16">34</td><td height="8" style="background-color: #FF0000" width="16">35</td><td height="8" style="background-color: #FF0000" width="16">36</td><td height="8" style="background-color: #FF0000" width="16">37</td><td height="8" style="background-color: #FF0000" width="16">38</td><td height="8" style="background-color: #000000" width="16">39</td><td height="8" style="background-color: #000000" width="16">40</td></tr><tr><td height="8" style="background-color: #000000" width="16">41</td><td height="8" style="background-color: #000000" width="16">42</td><td height="8" style="background-color: #FF0000" width="16">43</td><td height="8" style="background-color: #FF0000" width="16">44</td><td height="8" style="background-color: #FF0000" width="16">45</td><td height="8" style="background-color: #FF0000" width="16">46</td><td height="8" style="background-color: #000000" width="16">47</td><td height="8" style="background-color: #000000" width="16">48</td></tr><tr><td height="8" style="background-color: #000000" width="16">49</td><td height="8" style="background-color: #000000" width="16">50</td><td height="8" style="background-color: #000000" width="16">51</td><td height="8" style="background-color: #000000" width="16">52</td><td height="8" style="background-color: #000000" width="16">53</td><td height="8" style="background-color: #000000" width="16">54</td><td height="8" style="background-color: #000000" width="16">55</td><td height="8" style="background-color: #000000" width="16">56</td></tr><tr><td height="8" style="background-color: #000000" width="16">57</td><td height="8" style="background-color: #000000" width="16">58</td><td height="8" style="background-color: #000000" width="16">59</td><td height="8" style="background-color: #000000" width="16">60</td><td height="8" style="background-color: #000000" width="16">61</td><td height="8" style="background-color: #000000" width="16">62</td><td height="8" style="background-color: #000000" width="16">63</td><td height="8" style="background-color: #000000" width="16">64</td></tr></table>';

is $table->generate( data => [ 1 .. 64 ], wrap => 8 ),
    $html,
    "added data to simple PNG image via method"
;

is Spreadsheet::HTML::generate( %file, data => [ 1 .. 64 ], wrap => 8 ),
    $html,
    "added data to simple PNG image via procedure"
;
