package Stancer::Exceptions::InvalidCardExpiration;

use 5.020;
use strict;
use warnings;

# ABSTRACT: Exception thrown on miss-validation with card expiration.
our $VERSION = '1.0.0'; # VERSION

use Moo;

extends 'Stancer::Exceptions::InvalidArgument';

use namespace::clean;

has '+log_level' => (
    default => 'debug',
);

has '+message' => (
    default => 'Expiration is invalid.',
);

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Stancer::Exceptions::InvalidCardExpiration - Exception thrown on miss-validation with card expiration.

=head1 VERSION

version 1.0.0

=head1 USAGE

=head2 Logging



We use the L<Log::Any> framework for logging events.
You may tell where it should log using any available L<Log::Any::Adapter> module.

For example, to log everything to a file you just have to add a line to your script, like this:
    #! /usr/bin/env perl
    use Log::Any::Adapter (File => '/var/log/payment.log');
    use Stancer::Exceptions::InvalidCardExpiration;

You must import C<Log::Any::Adapter> before our libraries, to initialize the logger instance before use.

You can choose your log level on import directly:
    use Log::Any::Adapter (File => '/var/log/payment.log', log_level => 'info');

Read the L<Log::Any> documentation to know what other options you have.

=cut

=head1 SECURITY

=over

=item *

Never, never, NEVER register a card or a bank account number in your database.

=item *

Always uses HTTPS in card/SEPA in communication.

=item *

Our API will never give you a complete card/SEPA number, only the last four digits.
If you need to keep track, use these last four digit.

=back

=cut

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=Stancer> or by email to
L<bug-stancer@rt.cpan.org|mailto:bug-stancer@rt.cpan.org>.

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Joel Da Silva <jdasilva@corp.free.fr>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Iliad78.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
