package Apache::fork;

use strict;
use Exporter ();
@Apache::fork::EXPORT = qw(fork forkoption);
$Apache::fork::VERSION = '1.00';

*import = \&Exporter::import;

if($ENV{MOD_PERL}) {
    *fork = \&Apache::fork;
    *forkoption = \&Apache::forkoption;
}
else {
    *forkoption = sub {};
    *fork = \&CORE::fork;
}

1;

__END__

=head1 NAME

Apache::fork - Override Perl's built-in fork()

=head1 SYNOPSIS

 use Apache::fork;

=head1 DESCRIPTION

The B<fork> function defined in this module will override Perl's
built-in B<fork> function so that any children resulting from a fork()
will (optionally) close any open listening http sockets (main server
and virtuals) and/or kill the child httpd process with exit() is called.

TOGGLING:
forkoption(int) usage:

int can be one of the following...

0 = Nothing, perform your normal fork().
1 = Have the child resulting from a fork close all listening sockets.
2 = Have the child resulting from a fork() die with exit() is called.
3 = Do both 1 and 2.

Default is 3.

NOTE: forkoption is NOT reset to default between hits, why?  So you 
could set it in a perlscript and have it last acro                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          