/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import com.javonet.utils.HandlerUtils;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public class CreateInstanceHandler
extends AbstractHandler {
    private final int requiredArgumentsCount = 1;

    @Override
    public Object process(Command command) throws Exception {
        if (command.getPayload().length < 1) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 1);
        }
        Class objectClass = (Class)command.getPayload()[0];
        if (command.getPayload().length == 1) {
            return objectClass.newInstance();
        }
        Object[] arguments = Arrays.stream(command.getPayload()).skip(1L).toArray();
        try {
            Class<?>[] argumentTypes = HandlerUtils.getArgumentTypesAsPrimitives(arguments);
            Constructor constructor = objectClass.getConstructor(argumentTypes);
            return constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            try {
                Class<?>[] argumentTypes = HandlerUtils.getArgumentTypesAsBoxed(arguments);
                Constructor constructor = objectClass.getConstructor(argumentTypes);
                return constructor.newInstance(arguments);
            }
            catch (NoSuchMethodException ex) {
                Constructor<?>[] constructors = objectClass.getConstructors();
                StringBuilder message = new StringBuilder("Constructor with arguments " + Arrays.toString(arguments) + " not found in class " + objectClass.getName() + ". Available constructors:\n");
                for (Constructor<?> constructor : constructors) {
                    message.append(constructor.getName()).append(" with arguments ").append(Arrays.toString(constructor.getParameterTypes())).append("\n");
                }
                throw new NoSuchMethodException(message.toString());
            }
        }
    }
}

