/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.tools;

import com.javonet.sdk.Javonet;
import com.javonet.sdk.tools.HttpConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SdkExceptionHelper {
    private static final String address = "https://dc.services.visualstudio.com/v2/track";
    private static final String instrumentationKey = "2c751560-90c8-40e9-b5dd-534566514723";

    public static Future<Integer> sendExceptionToAppInsights(Exception e, String licenseKey) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Integer> future = executor.submit(() -> {
            try {
                String nodeName;
                HttpConnection connection = new HttpConnection(address);
                String javonetVersion = Javonet.class.getPackage().getImplementationVersion();
                if (javonetVersion == null) {
                    javonetVersion = "2.0.0";
                }
                try {
                    nodeName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException ex) {
                    ex.printStackTrace();
                    nodeName = "Unknown Host";
                }
                String operationName = "JavonetSdkException";
                String osName = System.getProperty("os.name");
                String callingRuntimeName = "Java";
                String eventMessage = e.getMessage();
                ZonedDateTime nowGMT = ZonedDateTime.now(ZoneId.of("GMT"));
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
                String formattedDateTime = nowGMT.format(formatter);
                String jsonPayload = String.format("{\"name\":\"AppEvents\",\"time\":\"%s\",\"iKey\":\"%s\",\"tags\":{\"ai.application.ver\":\"%s\",\"ai.cloud.roleInstance\":\"%s\",\"ai.operation.id\":\"0\",\"ai.operation.parentId\":\"0\",\"ai.operation.name\":\"%s\",\"ai.internal.sdkVersion\":\"javonet:2\",\"ai.internal.nodeName\":\"%s\"},\"data\":{\"baseType\":\"EventData\",\"baseData\":{\"ver\":2,\"name\":\"%s\",\"properties\":{\"OperatingSystem\":\"%s\",\"LicenseKey\":\"%s\",\"CallingTechnology\":\"%s\"}}}}", formattedDateTime, instrumentationKey, javonetVersion, nodeName, operationName, nodeName, eventMessage, osName, licenseKey, callingRuntimeName);
                int responseCode = connection.send(jsonPayload);
                return responseCode;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        });
        executor.shutdown();
        return future;
    }
}

