use utf8;
use strict;
use warnings;
use Test::More qw(no_plan);
use lib 'lib';
use aliased 'Javonet::Core::Protocol::TypeDeserializer' => 'TypeDeserializer', qw(deserializeInt deserializeString);
use aliased 'Javonet::Sdk::Core::StringEncodingMode' => 'StringEncodingMode', qw(get_string_encoding_mode);

cmp_ok(scalar test_typedeserializer_int_bytearray_2137(), '==', 2137, 'int deserialization test');
cmp_ok(scalar test_typedeserializer_double_bytearray_22dot4(), 'eq', 22.4, 'Double deserialization test');
cmp_ok(scalar test_typedeserializer_float_bytearray_0dot2137(), 'eq', 0.2137, 'Float deserialization test');
cmp_ok(scalar test_typedeserializer_string_bytearray_JAVONET(), 'eq', 'JAVONET', 'string deserialization test');
cmp_ok(scalar test_typedeserializer_string2_bytearray_nonasciistring(), 'eq', 'Ť¿ϻÐßĦŁ', 'non-ascii string deserialization test');

sub test_typedeserializer_int_bytearray_2137{

    my @array = (89,8,0,0);
    my $result = TypeDeserializer->deserializeInt(\@array);

    return $result;
}

sub test_typedeserializer_double_bytearray_22dot4{
    my @array = (102,102,102,102,102,102,54,64);
    my $result = TypeDeserializer->deserializeDouble(\@array);
    return $result;
}

sub test_typedeserializer_float_bytearray_0dot2137{
    my @array = (44, 212, 90, 62);
    my $result = TypeDeserializer->deserializeFloat(\@array);
    return sprintf("%.4f", $result);
}

sub test_typedeserializer_string_bytearray_JAVONET {
    my @array = (74, 65, 86, 79, 78, 69, 84);
    my $result = TypeDeserializer->deserializeString(StringEncodingMode->get_string_encoding_mode("UTF8"), \@array);
    return $result;
}

sub test_typedeserializer_string2_bytearray_nonasciistring{
    my @array = (197, 164, 194, 191, 207, 187, 195, 144, 195, 159, 196, 166, 197, 129);
    my $result = TypeDeserializer->deserializeString(StringEncodingMode->get_string_encoding_mode("UTF8"), \@array);
    return $result;
}

done_testing();
