package Daje::Plugin::GenerateSQL;
use Mojo::Base -base, -signatures;

# Daje::Plugin::GenerateSQL - It's new $module
#
# SYNOPSIS
#
#  use Daje::Plugin::GenerateSQL;
#
# DESCRIPTION
# ===========
#
# Daje::Plugin::GenerateSQL is ...
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
#
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

use Daje::Plugin::Input::ConfigManager;
use Daje::Tools::Filechanged;
use Daje::Plugin::SQL::Manager;
use Daje::Plugin::Output::Table;
use Config::Tiny;

our $VERSION = "0.02";

has 'config_path';
has 'config_manager';

sub process ($self) {

    $self->_load_config();
    my $files_list = $self->_load_file_list();
    my $length = scalar @{$files_list};
    for (my $i = 0; $i < $length; $i++) {
        if ($self->_process_sql(@{$files_list}[$i])) {
            $self->config_manager->save_new_hash(@{$files_list}[$i]);
        }
    }

    return;
}

sub _process_sql($self, $file) {
    my $sql = "";
    eval {
        my $table = $self->_load_table($file);
        $table->generate_table();
        $sql = $table->sql();
    };
    die "Create sql failed '$@'" if $@;

    eval {
        Daje::Plugin::Output::Table->new(
            config => $self->config,
            file   => $file,
            sql    => $sql,
        )->save_file();
    };
    die "Could not create output '$@'"  if $@;

    return 1;
}

sub _load_table($self, $file) {

    my $json = $self->config_manager->load_json($file);
    my $template = $self->_load_templates(
        'Daje::Generate::Templates::Sql',
        "table,foreign_key,index,section,file"
    );
    my $table;
    eval {
        $table = Daje::Plugin::SQL::Manager->new(
            template => $template,
            json     => $json,
        );
    };
    die "process_sql failed '$@" if $@;

    return $table;
}

sub _load_file_list($self) {

    eval {
        my $config_manager = Daje::Plugin::Input::ConfigManager->new(
            source_path => $self->config->{PATH}->{sql_source_dir},
            filetype    => '*.json'
        );
        $config_manager->load_changed_files();
        $self->config_manager($config_manager);
    };
    die "could not load changed files '$@" if $@;

    return $self->config_manager->changed_files();
}



1;
__END__

=



#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Plugin::GenerateSQL


=head1 DESCRIPTION

Daje::Plugin::GenerateSQL - It's new $module

SYNOPSIS

 use Daje::Plugin::GenerateSQL;


Daje::Plugin::GenerateSQL is ...



=head1 REQUIRES

L<Config::Tiny> 

L<Daje::Plugin::Output::Table> 

L<Daje::Plugin::SQL::Manager> 

L<Daje::Tools::Filechanged> 

L<Daje::Plugin::Input::ConfigManager> 

L<Mojo::Base> 


=head1 METHODS

=head2 process

 process();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify

it under the same terms as Perl itself.



=cut

