package Daje::Plugin::Perl::Generate::Fields;
use Mojo::Base 'Daje::Plugin::Perl::Base::Common', -base, -signatures;

our $VERSION = '0.01';

has 'select';
has 'primary_key';
has 'foreign_keys';

sub generate($self) {
    $self->_get_fields();
}

sub _get_fields($self) {
    my $column_names = $self->json->{column_names};
    my $length = scalar @{$column_names};
    for (my $i = 0; $i < $length; $i++) {
        if (index(@{$column_names}[$i]->{column_name},'_pkey') > -1){
            $self->primary_key("@{$column_names}[$i]->{column_name}");
        }
        if (index(@{$column_names}[$i]->{column_name},'_fkey') > -1){
            push (@{$self->foreign_keys}, @{$column_names}[$i]->{column_name});
        }
        my $select = "";
        if (length($self->select()) > 0) {
            $select = "$self->select()" . ", '" . @{$column_names}[$i]->{column_name} . "'";
        } else {
            $select = "'" . @{$column_names}[$i]->{column_name} . "'";
        }
        $self->select($select);
    }
}
1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Plugin::Perl::Generate::Fields


=head1 REQUIRES

L<Mojo::Base> 


=head1 METHODS

=head2 generate($self)

 generate($self)();


=cut

