## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Et_ec v1.1.1;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Et_ec::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Et_ec> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package
since this pattern is generated from the source at
L<svn://tug.org/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/ptex/hyph-et.ec.tex>

The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
% pTeX-friendly hyphenation patterns
%
% language: estonian (et)
% encoding: ec
%
% This file has been auto-generated from hyph-et.tex
% with a script [texmf]/scripts/generic/hyph-utf8/generate-ptex-patterns.rb
% See the original file for details about author, licence etc.
%
\bgroup
\lccode"E4="E4
\lccode"F5="F5
\lccode"F6="F6
\lccode"FC="FC
\lccode"B2="B2
\lccode"BA="BA
\patterns{
.aa4
.aasta5
.ahe4li
.al4a
.al4gas
.antiik5
.ap3l
.ap3r
.art5r
.au3a
.eba3
.ee4
.eela4
.ek3l
.ek5r
.gu4a
.hie5
.idi4
.inim5a
.ise5e
.is4o
.ja4e
.ja4t
.ka4e
.ka2o
.ke5hi
.kip5r
.ku4pl
.ku5sa
.kusee4
.la4pl
.le4e
.le5hi
.lemmik5
.le5se
.l^^f5pp3
.ma4a
.maa5a
.ma5j
.mi5sa
.mo4e
.nek3
.ni4p
.nisu5
.noa3
.oa3
.oo4
.pap4p
.pea3a
.raadio5
.re4a
.re2o
.rep3r
.re5so
.r^^fc5hi
.sak5r
.sap3r
.se4a
.sk4
.skaa5
.so5li
.sp4
.st4
.teoo4
.tet3r
.tina5
.toa3
.ts4
.tsi4s
.turba5
.tus2
.tu3sa
.ul4ga
.ulu4k
.um2b
.uu4
.vaa3l
.vask3
.vere3
.^^f5ppe5
.^^e4^^e44
.^^f5^^f54
.^^f6^^f64
.^^fchi4s
.^^fcle3e
.^^fcr2
.^^fc^^fc4
aaa5l
a1aas
4aab
aa4bi.
5aadel.
aadio5a
a1ae
a4aer
aa4fe
aa4gan
aa2h
aa4has
aa1i
aai4g
aa4is
a5ait
aa2j
aa2la
aa4lae
aala4r
aa4las
aa4leh
aa4lek
aa4lel
aalg4
aali4ke
aal3k
a5allik
aal3t4
aa2l3^^f5
aa4l^^fc
aa4mad
aa4man
aa4mee
a5ameer
aa4m^^f6
4aan
aa4nam
aa4nat
a5andm
aan4duu
aa5ni
aant4
aa4pek
aa4pen
aa4ra4b
aa4raf
aa4raj
aara4l
a5arter
aa2r3^^f5
aa4r^^f6
aa4r^^fc
aa4sab
aa4sai
aa4sar
aa2se4
aa4so
3aas5ta
a5a4sul
aa4sut
aa4s^^fc
4aat
aa4taa
aa4tas
aa4teh
5aatom
aa4t^^f5
aa4t^^fch
a1au
aa^^b2i5
a1b
4a3ba
a5be
3abie
a4bij
5abs
a1d
a4dad
a4deo
a2der
a3di
adu4r
adu3se
a4d^^f6
a5eali
ae2d
3aed.
2aee
a3ees
ae4f
1aeg.
ae4ga4j
ae4gi
3aegn
2a1e2h
4aei
4aek
a3eks
2ael
a5elani
ae2le
ae4lo
ae4lu.
4ae2m
4aen
ae4pi
ae2s
a3esi
4aett
a1f
a4fek
a1g
3a4gent
agia4
a3go
5agreg
agud4
1a2hi.
ah4kar
5ahnu
4ai.
ai2a
5aian
ai4hu
ai4ke
ai4kl
a3ilm
ai4lu
ai4me.
aimp4
4ain.
a5inf
a5inime
4ains
a3inse
ai4pr
ai2sa
5aistin
aist4r
ai4va
a1j
a3ja.
a4jale
5ajalo
a4jalu
1a2jam
4ajo
ajut4
a1k
akaa4s
a4kaat
ak4as
3aken.
a3ki
ak4kis
ak4kr
a3klas
ak4lau
a5klii
a3krii
ak3ro
4aks
ak4te4l
a2ku.
aku4map
a5kvali
3alald
ala4mas
a4la^^fch
ale4le
al4et
alet4t
5algat
al4ged
a3li
ali4san
a4liste
5allee.
al4le4h
al4luj
al2l^^fc
a4lob
als4
4alt
4alu.
a4lud
1alun
al^^fc4h
a4l^^fct
a1m
4am.
a5ma.
a4maad
3ametn
amit4
am4o
am4pal
5amper.
4am^^fc
2an.
3anal^^fc
5anatoom
an4das
an4deo
an4dog
2ane
a4neh
a3ni
a4niso
4anj
an4kr
3anku
an4nah
4ano
anos4
3ansam
4anst
3anten
5antilo
ao4d
ao4he
a3oht
ao4j
ao2le
ao2lu
ao2m
a3oma
ao4nu
aoo4p
ao2pe
a5opera
ao2r
a5oras
a1osa
ao4su
a1ots
a1p
a2par
5aparaa
a5part
a3parv
a3pi
a3pla
a3po
ap4pal
ap4pin
ap4pis
ap3ri
ap3ron
a4pru
a3p^^e4
4ara
arak4k
a4rase
5areng
3aretu
3arhit
2ari
ari4al
ari4ap
4ark
ar4kel
5armast
5armee.
a4ro4l
1arst
5artikk
3arua
3arvam
5arvestus
1arvu
ar4v^^e4^^e4
asa4las
a4same
a4sau
ase4ma
as5ema.
1a2sen
a4seos
a4sese
a4sett
3a4setu
as4f^^e4
1a2si.
asi4ala
asi3an
a4sind
asip4
5asjan
ask^^f54
as4k^^f5l
a5slaav
a4sok
as3ole
aso4p
as4pet
as3pl
as2po
a3spor
as4san
ass5t
4asti
5astme
ast4rak
a4su4b
a4sud
asui4
a4suss
a5suu
a1t
a3ta
a4ta^^ba
5ateljee
atii4v
atmi4k
5atroo
at4ros
at4rus
at4soo
ats4p
at4s^^fc
att4s
4atu
au2a
aua3l
au4ba.
4aud
au4de.
a3ui
4au2j
au4ke
aulu3
aulus4
au4p^^fc4
a5urg
aus4o
au2su
a3usul
1auto
autoo4
auto5s
aut4r
a1v
av4a
a4vans
a3var
a4veh
a1^^f52
a1^^f62
a1^^e42
a1^^fc2
a^^ba4ni
4a1^^b2
5baa
baa4g
baa4k
baa4s
bab4
bae4
bag4
ba4he
ba4ju.
ba3k4r
bak4s
bak4v
bap4l
bap4r
ba4r^^f5
basa4s
bas4ko
bas4pe
bat4r
4bb
2bd
be3a4
beb2
bef4
beg4
be4l^^fc4
be2ra2
berk4
bero4
be4r^^f54
be4si
be4st
bes4tis
bet4r
4bf
4bh
bha4
bi4ala
bia4v
2bi1e
bi4en
4bin^^f5
bi4pla
bis4a
bi4si
bis4k
2b1j
2b1k
2b1l
bl4e
blet4
b2lon
2bm
2bn
4bort
2bp
2b1r
3brig
bros4
2bs
b3so
2bt4
4buks
bu4l^^f5
3bum
buse5
bu4si4
bus4kr
2b3v
1da
daa2
da5ab
daala4
da4do
dae4
daf4
d5ain
da4leh
da4lum
da4lus
5dam
4dann
da4num
dao4
darat4
4darb
dar4de
4da4re
4daru
2darv
d3arv.
4dasen
da4sum
2d5b2
2dd
1de
dea2
2deaa
de5av
ded4
2dee.
dee4le
4dehe
dek3l
dek4s
5del.
de4lau
4de4lek
4deluv
de4pr
dep5ressi
dere4
de4rel
de4rep
5dero
deru4
2df
2d5g
2d1h
1di
dia4v
did4
dig4
dii4g
diina4
dii4sa
dii4su
4dilm
4dini
di2os
di4plo
dis4ai
di4sar
di4sas
dis4pr
dit4r
2d1j
2d3k4
dkop4
2d1l
dle4v
dlust4
2d1m
dmee4
dmi4k
2d1n
1do
do4h
doi4r
2dos
d3osa
5dosk
2d3p4
2d1r4
5draama.
drao4
3dreen
d4rel
d2ren
3drena
2d1s4
dsar4
2d3t2
1du
du4b
due4
2d5uks
d4u2s
du4s1a
du4see
dusk4
2d1v
2d^^f5
d^^f54l
4d^^e4
2d^^fcl
d^^fc4li
4d^^fc4r
5d^^fc^^fc
4d^^ba
2d2^^b2
3d^^b2em
eaa2
ea3aj
e1aas
ea2b
e3abi
e1ae
ea2hi
e1ai
ea2j
eak4s
eak4v
ea2la
e3ala.
e1a4lu
ea2me
e5amet
e5ann
ea4nu
eao4
ea2pa
e1ar
ea4re
ea2s
e4ass
e5aste
e5asut
e3au
ea2v
e3ava.
e1b
e1d
ed4a
e3eali
e3ees
ee4fe
eei4
eek4r
ee2la
3eelar
e5elekt
eel5uu
ee4nai
ee4nal
ee4nam
ee4no
eent4
ee4pai
e5e4pit
5eepos
ee4ral
eer5ap
ee4ros
ee4rot
ee4sin
e5esine
ee4s5ist
5eeskir
ee4s^^fc
ee4t^^f5m
ee4t^^e4
e1f
e1g
egaa4
egas4t
e4goi
4eha
e2he.
e2hi
e3hin
5ehist
1e4hit
5ehiti
eh4ta4
4eh^^e4
ei4dul
ei4e
eie5ri
ei2ga
e3iga.
ei4ha
ei4he
e3ilm
ei2lu
ei4mem
5eine.
ei4roo
e5i4sa.
ei4sist
ei4tau
ei4t^^f5
ei4va.
e3j
e3ka
e4kahi
e3ke
ek4kap
ek2l
ek4lo
e3k4o
ek3re
e3krii
4eks.
5eksam.
3eksem
eksi3k
3ekska
eksp3r
5ekstr
ek4t^^fcl
e3k^^fc
elaa4v
e4lagr
e2lam
3elamu
el4an
5elanik
eleis4
e4leks
5elektro
3eleme
5elevaato
e3li
e4lid
elii4t
el4kus
e4l4ob
elo4p
els4t
elt2r
el4t^^fc
e2lu
1elu.
e5lub
elu5i4
1e4lun
e3lus.
e4luss
el5uss.
el4^^fch
e1m
5emand.
e5mat
emne3
emos4
emp4r
5emuls
endus3
5enelas
e5nem
3energ
e4nese
e4nesl
enk5l
enk4r
en4sal
en4tos
en4t^^fc
eo5a
eo4ja
e3o4le
eo2lu
eo2ma
eoo4p
eo5pl
e3osa.
e3osak
e5osali
e5osav
eos4f
e3ots.
e1p
e3pl
e4pli
ep4lu
e1r
e3raa
5erakon
5erald
e4rao
erei2
erek4
5ergut
erih4
eri4uu
er4nau
e4ro4r
erp4
er2pr
ers4k
er4taa
er4tak
er4tes
e4rud
es1an
1e2se.
e5sek
e5sen
e5sil
eska4j
eska4s
eske4
es5kel
esk3l
esk3r
es2k5^^f6
es4laa
es3ole
es4or
es2po
e3spor
es4sist
4est
es4t^^fc
e3su
esup4
e1t
e3t4a
e2ten
5etendus.
etii4s
et2ra
et4sin
et4soo
et4s^^fc
et4taj
1ette
et4tru
et4t^^e4
et4t^^fc
4etu
e4t^^f54d
e4t^^fcm
eu4de
e3u2j
e3u2l
e5u2n
eu4p
eu4s
e5usk
e3uu
e1v
e3v4a
e1^^f52
e3^^f64
e1^^e42
e1^^fc4
e1^^b2
5faa
faa4n
4fa4d
2ff
1fi
fii4t
4fj
4fk
2f1l
f2lo
5floora
2f1n
1fo
folk5
fo4ro
2f1r
f2re
3frees
2fs
2f1t
ftat4
3fu
3gaa
gaa4r
4gaast
4gab
4gaed
gag4
2gah
ga2hi
gai4g
ga5is
ga3k4
5gam
ga3o
ga3p
4gart
4garv
g4as
4ga4suk
5gata
gat4r
gau4
ga4va.
ga4van
2g3b
2gd4
gea4
ge4du.
gek4
ge5kl
4gekse
ge4lah
gela4s
ge4leh
ge3lu
ge4l^^e4
ge4nan
geok4
ge4or
4geos
4gerg
ge4rus
4gf
4gg
2g1h
gi2aj
gii4s
gi3k
4ginf
4gint
gio4r
gi3pl
gi4san
gi4sil
gi4s^^f6
git4r
gi4vaj
2g1j
2g1k
2g1l
g4l^^fct
2g1m
2g1n
gne4ta
gne4te4
4goh
go4le
go4ma
go4po
2g1p4
2g1r
g2ran
5granaa
3g2rav
g2ru
3grup
4g1s4
2g1t2
g3tr
3gu
gub4
gue4
gu5i
gu4nel
gu3o
gup4
gu4sen
gu4s^^e4
guu4j
2g1v
2g3^^f54
4g^^e4
g^^fc4l
3ha
haa4ri
haa4s
hal4lai
5har
hasa4
hat4r
1he
hee4m
hee4s
hei4s
hek4v
2hel.
hels4
het4r
4h1h
hhe4l
1hi
hia2
hii4s
5hil
5him
hio2
hi4san
hi4sar
hise4l
hi4st4
hi4s^^fc
5hits
h1j
hjaa4
4hk
h4kal
h4kas
h4kis
hk3l
h4ko4
hk3r
hks4
hkt4
h4kusk
h4ku4su
h4k^^f5
h4k^^e4
h1l
hle4n
4h1m
h4mo4
h4m^^fc
h1n
hnika5
1ho
hom4o
4hp4
hrs4
4ht
h2ta
hta2j
h5tak
hta4l
ht5ar
hta4su
h4teg
hte4n
hte4r
h4tid
h4to
h4tr
ht5s4
h4t^^f6
h4t^^e4
1hu
hu3a
hue4
hui4d
huk4l
hup4
hu3sa
2h1v
hvad4
hvast4
hve4l
h4vini
h4vo
hvu4s
1h^^f5
3h^^f6
1h^^e4
3h^^fc
4ia
iaa2
iaa4l
ia5alane
i3aast
i5a4bi
ia4bo
i1ae
ia2g
ia2h
i3aine
i1a2j
ia4kr
i3akt
i1a2la
i5alb
i3alli
i1a2lu
ia2me
i5amet.
ia2na
i5andj
i5andm
ia4ne
i5anne
ia2p4
i3apar
ia5pr
ia2re
i3arm
ia4ru
i1arv
ia2s
ias4ke
i5aste.
i3asu
ia4tel
iat4r
i1au
iau4l
i5a4vaj
i5avald
i1b
i4bad
i4bau
i1d
5ideaa
idii4
idlu4
ie2
i3eali
i1eel
iei4
i1eks
i5elani
i1elu
i3eos
ie4ri
iers4
i3esi
ie5so
i5ess
ie4st
i3eten
ietu4s
i1f
i1g
i4ga4g
i5gar
5igatsu
i4gav
ig4ram
ih4le
ih4te
ih4tin
ii4a
ii4deo
ii4du.
iie3
ii4es
ii4gaa
ii4ga4s
ii4ha
iika4
ii4kis
iik4ro
iiks4t
iikt4
ii4lab
ii4lad
ii4lae
ii4last
ii4leh
ii4lel
ii4les
ii2l^^f54
ii4l^^fc
ii4mai
iimat4
ii4met
ii4nai
ii4nau
i5inde
i5inf
ii3ni
i5inimen
iinit4
iink4
iino4
ii4nol
ii4nos
ii4n^^f5
ii4pr
ii4ran
ii4rau
iirs4
ii4r^^fc
ii4san
iise4l
ii4sev
ii4sik.
ii2ta
ii4teh
iito4
ii4tom
ii4tos
iit5re
ii4t^^f5
ii4t^^fc
ii4ves
ii4vet
ii2vo
i1j
i1k
i4kalu
i4ka4re
i4kark
i4kaut
i4k5elu
ike4si
i3klaa
i3klas
ik4ler
i5klub
ikop4
ikos4
i4kov
i3kre
ik3ro
ik4sar
iks4k
iks4po
ik3t2r
i3ku
iku3a
il4a
ila4s
i4lasi
ilia4
i4lisi
il4kan
il4k^^f5
ille5s
illo4
5ilme.
il4mot
3ilmut
ilo5g2
ilp3l
il4ti
i5lun
ilu3sa
5ilustu
il^^fc4h
i1m
i4melu
imi4g
imisu4
i4mo4l
5imper
i1n
ind3al
5indeks
inde4r
ind4re
2ine
inee4s
i4neh
i4neks
ini4k^^fc
i2nim
ini4mas
i4nime
5inimene
5iniml
i4nini
inna5a
inni4si
3insen
1insp
1inst
3inven
io4de
io4h
i3oht
i5ohv
io4j
i5oks.
io2le
i3olek
io2lu
i5oluk
io4l^^fc
io2ma
i5oman
ioo4da
ioo4ne
iooni3
io2p
i3oper
i5ork
i1osa
ios4f
ios4p
ios4t
iost4r
io4su
i3ots.
i3otsi
io4t^^fc
i1p
i3pla
ip4lu
ip4ro
ip4sas
ipse4
ip4sep
ip4sus
i4ra4b
i4rase
ir4dis
ir4n^^f5
i2rui
iruu4
isaa4v
isa4ja
i4sana
isa4re
i4sarh
i4selo
i3sem
iset4s
isi4g
i2so
3isola
i5soli
is5oma
iso4r
i3sot
i3s4pek
is3pl
i3s4por
is3sp
5istand
i5s4tiil
5istme
ist4ru
ist4se
i5stsee
5istutu
i3su
i4s^^f5m
i2s^^fc4l
is^^fc4r
2it
itaa2
itee4l
it4rak
it4ras
it2ru4
its3k
it4so
itte1
itt4s
iu4b
iu2da
iu4gi
iu2j
i3uju
iu4la
iu4mar
iu4me4
iu2mo
iu4ni
iu4pu
iu5sa
i5uss.
iu2su
iuti4
i3uu
i1v
i4vad
i4vakt
i4va4lus
i4vant
i4vau
i4veh
ive4l
iviil5
i4v^^fc
i1^^f52
i1^^e44
i1^^fc2
i1^^ba
j4a
3jaa
ja1aj
jaa4l
jaa4r
jaa4s
jab4
jad4
ja5el
jae4r
jag4
ja3i2
ja5kra
5jama
5jame
jao4h
ja3p4
jas4ke
jas4tii
jat4r
jat4su
jau4b
jau4l
je3lu
3jo
joo4k
jue4
5juma
ju4sei
juse4l
5j^^f5
5j^^e4
1ka
kaa4da
kaa3de
ka5aj
ka4al
kaa4ra
kaa4sis
kaa4ta
4kader
4kaed
4kaeg
kae3lu
kag4
kahe5i
4kaia
2kain
ka5ist
kaitse5
ka4jav
ka4ju.
k5a4lus
ka4pl
ka2pr
4karm
4kaset
k5asj
kat4r
2k3b
2kd4
1k2e
ke4el
kee3lu
2kehi
4keks
ke4laj
ke4lak
ke4lok
4kemb
2ken.
5kene
keo2
kes2k
kesk3a4
ket5ra
ket4te4
2kf4
4kg
2k1h4
1ki
kie4
kik4r
4kinf
kio4
ki4pr
kis4a
ki4san
ki4sik
4kiste
kit4r
kiu4d
kiu3su
2k1j
4k1k
k3kra
kks4
kku4ro
2k1l4
k2la
k3la.
3klaas
k3lai
3k4lamb
k3lan
3klapp
5klassi
k3lat
5klaver
kle4a
k4lee
k2lei
3kleit
k3lem
k4lib
5klibu
klig4
k2lii
3kliim
5kliiste
k3lik
k3lin
k4link
k2lo
k3loom
3klots
k2lub
k3lus.
klu4sa
klu4s^^f5
k4lut
2k1m
2k1n
knaa4
k4nip
1ko
2koks
k4ol
ko4len
koo4sa
4ko4rie
4korpi
k5osa.
ko4va
2k3p4
2k2r
k4raan
5kraana
3kraav
3krab
3k4rae
k3rai
3kramp
4kran
k3rau
5kredii
3k4reem
4kreg
5k4res
k5ret
4krip
5kristal
k4roh
3krohv
k4rook
k3rut
3kruu
3kruvi
4k3r^^fc
4k1s
k5sae
k4sai
ksek4
ksi2k
ksika4
ksit4
ksk4l
ks5k^^f5
ksp5lo
ks2pr
kst3r
ks4t^^fc
2kt
kt2ra
1ku
kui4s
4kujuj
4kujum
kuk3la
4kuks
kul2d
2kulp
kumi4su4
kummi5
3kus
ku4siv
kut4r
kuu4ni
kuuse5
4ku^^ba
2k1v
k4van
3kvart
5kviitu
1k^^f5
k^^f54de.
2k^^f5i
k5^^f5is
4k^^f5p
1k^^f6
4k^^f6d
1k^^e4
k^^e4i5s
2k^^e4k
4k^^e4m
1k^^fc
2k^^fche
4k^^fcle
4k^^fcll.
2k^^ba4
4k^^b2
1la
5laag
la4aj
laa2r
laar5a
laa4sa
2laav
5laava
4ladj
5ladu
lae4r
3laev
4lahv
lai5ek5
lai4ga
la4jap
la4jav
la3k4r
lak4v
la4la.
4lald
la4les
4lals
la4lus
3lama
3lamp
4lams
la4nes
2lani
lap4l
4l1arv
4lar^^fc
la4sas
4lasb
la4sei
la4sem
4lasen
l2asi
4la4sut
3lau
5laud
lau4n
lau5su
4lavh
2l1b
l4bau
lb4lo
4l1d
l4dala
l5dist
l4don
l4d^^fc
1le
le1a2
3lee
leek5l
lee4le
leep5r
le3hi
4lehit
5leht
3lej
4lekk
5leks.
4lektr
lektri5
4lele
le4lek
5lema.
le4mor
lenaa4
leo2
le3oh
le5olu
le4pl
le2s
4lese.
le3s^^f5
3let
4lette
4l1f
lfoo4
lf4t
l1g
l4gae
l4gai
l4gall
l4gann
l4gase
lgas4k
l4ge4le
l4gi4d
l2go
l4gu4j
2l1h
1li
li4ala
li5am
lia4v
3lid
li4dan
li4ga.
4liia
liie4
5liig
lii4na
5lik.
likai4
li3kla
lik4ro
4lilm
4li4lus
limi4s
4linf
4linim
4lins
lin4te
4linv
lio4k
li3p4l
li4sah
li4sik
4lisol
li4suj
li4s^^f5l
li4s^^f6
lit4r
li5tu
2li^^bae
2l1j
lja1a
lja5os
2l1k
lkk4
l4kli
lk4lu
l3kr
2l1l
l5ler
lli3tr
l2lor
l4lots
llp4
lls4
llt4
l3lu
l4l^^e4^^e4
2l1m
lmaa4v
lmat4
l4mau
l4meks
lmp4
2l1n
1lo
lod4r
lof4
lo4gal
4loha
4lohv
5loi
lok4r
2lo2l
l1ole
l3olij
3lolo
lo4man
5loog
loo4ram
4lord
4lorn
2losa
l3osa.
2l1p
l3plaa
lp4le
l4puk
2l1r
lrih4
2l1s
ls4ka
lske4
ls4o
lste4
2lt
l4tau
lti4l
l4tok
lt4sel
lt4sis
l4tuk
l4t^^f5m
l4t^^e4^^e4
l4t^^fct
1lu
3lua
lu3al
lud4
lue4
3lug4
4luhk
4luim
lu4juk
4luk.
3lukk
2lun
lu4nin
lu4nio
luo3r
lu4rau
lu4see
lus4tii
lu4sum
lu4s^^f6
3luta
lut4r
3luu
2l1v
lvel4
1l^^f5
4l^^f5d
4l^^f5ie
5l^^f5ik
4l^^f5is
4l^^f5it
l^^f54l
l^^f53pe
l^^f5p2p
1l^^f6
4l^^f6e
1l^^e4
4l^^e4n
l^^e4n4gi
l^^e4^^e4ne5
1l^^fc
l^^fc3h
l^^fc4ma
1ma
3maa
maa2b4
ma3abi
maa3la
maa3p
ma4bi
ma1e2
mag4l
5mahl
4mahv
4majam
4ma4ju.
ma3kl
mak4v
3mal
ma4la.
mal4ma
ma4om
ma3pl
4mart
4marv
ma5se
ma5sin
ma4st
4ma4sul
ma4s^^e4
4maut
2m1b
mbat4
mbe2r3
mblu4
mbo4j
mb5usa
2md4
1me
me1a4
me4an
3mee
mee5la
mee4s
me3hi
4mekv
mers4
mert4
me5s4o
m4et
4met.
4metl
2metn
met4se
4mett
me5u4
2m1f
4mg4
2m1h
1mi
mia4m
mia4r
4mide
mi4kaj
mi4nah
4minf
mi3ni
mip4
mi2s
mis1a2
mi3si
mi4sig
mi4sih
4mi4sik
mi4sil
mis3k4
mis4tii
mist4r
mis3ts
mitte3
2m1j
2m3k4
2m1l
2m1m
m4maat
mma4s
mm4e
mme4r
mmika4
mmi4kal
m4mor
2m1n4
1mo
4moh
mo4ha
m3oks
4morg
4morn
mo3sa
2mp
mpa4l
m4pap
mp3l
mp3r
2m1r
mruu4
2m1s
ms4o
ms4p
2m1t2
m5ts
1mu
mua4
mu5ah
mud4
mue4
mui4m
4muls
mup4
5mus
mut4ra
2m1v
m^^f54d
4m^^f5ig
4m^^f5p
3m^^f6
4m^^f6k
3m^^e4
4m^^e4k
m^^e4r4gel
3m^^fc
4m^^fch
4m^^ba
1na
n4aa
na5ah
naa4lu
naa4r5a
nad4
na5ei
nag4l
nah4ke
nai4d
nai4si
na4kru
2nal4^^fc
4na4mer
na4mii
n5amiid
nants5a
na3o4
nap4l
na4ret
4narv
n4as
4nasb
nass4
nat4ra
nau4b
4nb4
4n1d
n4daas
n4dab
n4dae
nda4ko
nda4l
n4dau
ndif4
ndip4
n4do4r
n4duj
ndu4s^^f5
n4d^^fc
1ne
5ne.
nea2
nee3la
nee4le
nee3lu
nei4v
ne4lah
4nelas
ne4lek
neo4d
ne4pl
2nerg
n4es
ne4tan
ne4t^^f5m
2n1f
2n1g
n4gai
n4gall
n4gase
n4gau
ng4l^^fc
n4go4r
ng3r
ngud4
ngus4t
n2g^^fc
2n1h
1ni
ni3ap
nia4v
nig4
nii4g
nii4tu
nikkel5
4nilm
5nima
nima4s
5nimet
3nimi
ni4mig
4niml
4nint
ni4sid
nis4ke
4nisl
2n1j
2nk
n4ka4n
nk3r
nk4se
nkst4
2n1l4
2n1m
2n1n
nna3e
nna5i
nnak4r
n4ne4f
nnio4
nnk4
1no
4nob
nod4
4noks
noo4na
n4or
2n3p4
2n1r
2ns
n4salp
ns4e
nsk5r
n3so
nso4r
nste4
ns4tee
ns4tem
nstis4
nst3r
ns4tu
nsu4s
2nt
ntaa4r
n4teh
nte4l
ntig4
n4tiso
n4tots
n4tr
nt3ra
nt3re
nt4sab
nt4sal
nt4san
nt4sar
nt5s^^fc
ntt4
n4t^^fch
n4t^^fck
1nu
nu4da
nui4g
nur2k
nus4p
2n1v
1n^^f5
n^^f54l
4n^^f5li
1n^^f6
1n^^e4
1n^^fc
4n^^fcl
4n^^ba
4n^^b2
oa2
oa4a
o1ae
o5aku
o3anal
o5apa
oau4b
o1b
oba4s
1obj
4o1d
odaa4
odaal3
o4deh
odu4s^^f5
od4^^b2
oe5a4
oe4fe
oe2l
o3ele
oe4mi
oe4mu
o4eo
oe4rah
oe4r^^f5
oe4si
oet4r
o1f
of5r
o1g
og4la
og4li
3ohaka
oh5to
5ohvits
oi2ta
oiu5a
o1j
oju2s
okast4
okku5
ok3la
ok5liin
okoos4
ok3r
ok4re
ok4ri
o5kris
ok4ru
o3la
o4lae
olag4
ola4las
ola4su
ol4do
ole4an
3olek.
o4lend
olig4
o3lii
olii4g
o4li4lu
o3lis
4olj
ol4lae
ollis4
ol4l^^fc
ol4mai
4o3lo
ol4tam
ol4tar
1olu.
5olukor
o4luks
ol^^f54
o4l^^e4
3omadu
om4baj
om4ban
o4mok
ona4a
o4naj
ona4ko
o4neh
o4nele
on4gos
onit4r
oniu4
onsoo4
ont4re
o4nuu
2o2o
oo1a
oo4kal
ook4r
oo4k^^e4^^e4
oo4lau
oo4lee
oo4lig
oo4list
oo4log
oo4l^^f5
oo4l^^fc
oo4nah
oo4nar
oo4nau
oon4dee
oonk4
oono4
oo4noh
oons4
oon5t4
o5opti
oo4rat
oo4ree
oo3sa
oo4sel
oo4t^^f5
o3pa
op5last.
op4lu
op3ra
op3ri
o2r3ai
o4ralg
ora4mii
o4rana
5orav
3order
1org
org4r
oria4
3orju
5orkeste
3orna
or4nel
or4tal
ort3r
oru4s
or4v^^f5
o2sa
o4sake
3osako
4o3sau
4ose
o4seks
4osf
o2si.
4osin
3oskus
4osl
4oso
o4sok
os1ol
os4pa
4oss
os4saj
os4s^^fc
os5taas
os4tem
4osto
ost4ru
5osuti
4os^^f5
oto5a
otok4
ot2ra
o3tran
3otsa
o5ts^^f6
ot4ta
ot4teo
otus4ta
ot^^fc4l
ou4b
ou4n
o1v
ovaa4l
ovio4
ovol4
o4vu4n
o3^^f54
o^^fc2
1pa
paa4ka
pa3a2m
paa4tel
pa4e
pa4lus
pans4
pa4pr
5paras
3park
4parta
pa4sp
4pb
4pd
1pe
pe2a
pea5j
peas4
pe4au
pea3v
pe4f
4pektr
pela4
4pe4lev
pel4t
pe4l^^fc4
p4em
pe4ol
5perd
pe4tap
peti4k
2pf4
pg4
2ph
1pi
pii4v
pik5r
pin2d
pin4gis
pip3r
pis5ta
piu4g
2p1j
2p1k
2p2l4
4pla.
p4laa
p5laasi
3plaat
p4lak
p3lam
p5lane.
3plasm
5plastik
plek2
3plekk
4p3lem
p3li
5pliia
pliig4
3plok
p3lom
p3lu
3pluus
4pl^^f5
2p1m
2p1n
p4neu
1p4o
5po4e
3pon
3poo
poo4la
poola4v
pordi5
4p1p
ppa4k
p4pas
ppe3a
ppee4
pp3l
p2p3r
pps4
p4pud
p4p^^f5
p4p^^fc
p2r4
2pra
3praa
3prag
3prakt
p5rau
p4rep
p4resi
4prib
2prii
p5riit
p4rog
p4roo
4p4ros
3p4rot
4prum
5pruu
2p1s
ps4a
p4sor
3p2s^^fc
2p1t
p4tak
3pu
pua4
pu4da
puha4
pui4t
puk4k
pul4ti
4purt
pus4p
2p1v
3p^^f5
p^^f5hi3
p4^^f5i
p^^f5i4s
p^^f5li4
5p^^f6
1p^^e4
p^^e4r4gu
4p^^e4s
3p^^fc
p^^fc3he
4p^^ba
4p^^b2
1ra
raal3a
4raale
5raalne
raa4lu
raamatu5
raa4ta4
4raatt
raa4tu
4raav
5raa^^b2
raie3
2rain
r3aine
rai4si
r5a4la.
ral4t
ra4lus
3rame
ran4dem
ra3om
4rapa
ra4pl
4rapt
4rarb
ra4ren
4rars
2rarv
ra4sal
4rasen
ra4sis
rast4r
ra4suk
ra4sul
ra4sut
5ratas
ratiiv5a
rat4sen
raua3
rau2d
raud5o
2rauk
4raum
4raur
rau4te
5ravi
2r1b
r4bae
4r1d
r4dae
r2dar
rde3a
rd4re
r4duj
r4d^^fc
1re
5re.
5rea
reb2
ree4le
ree4ma.
ree4man
3reer
3reet
5reg
2rehi
rei4se
rek3l
4reks
re4lai
re4liit
5relv
re4m^^e4^^e4
4repp
re2pr
rep3re
re4sin
re3te
ret4k
re4tr
ret5s
2r1f
rf4r
2r1g
r4gae
rg3ah
rga4re
r4geh
rgi4me
r5g2ra
2r1h
1ri
3ria
ri3am
ri5ast
5rid
2rig
ri4ga.
3rige
rig4r
2riib
5riie
4riinu
ri4kis
ri3k4r
4rilm
3rim
ri5oks
rio4r
3rip
rip4li
4rip2p
4ri4sa.
ri4sah
ri4sar
ri4ses
4risol
ri4tol
ri3t2r
5riu
5riv
4ri^^f6
2r1j
2r1k
r4kad
rk5ain
rka4se
r4kek
rkt4
2r1l
2r1m
r4mald
r4me4le
r4mig
rmo4ra
rmo4s
rmp4
rms4
2r1n
r4nad
r4neh
rnk4
1ro
roa4
ro3e2
rok4k
rol4la
rol4le
4romb
2romi
ro4nop
roo4ga
4rosa
ros4po
ro5staati
rost4r
4ro^^ba
2r1p
rp5ret
2r1r
r3ri
2rs
rsaa4l
rs4l
rs4o
r5s2po
rs4tak
2rt
r4tah
r4tos
rt2r
rt4ra
r4tri
rt5roo
rt4sai
1ru
2rua4
rud4
r4uj
ru3kr
3ruma
4rumb
2rumm
4rump
5rus.
ru4set
ru4sin
ru4sul
rut4r
ruum5a
4ruur
2r1v
rva4la
rva4lu
r4vann
rvas5k
rvis4k
r4voh
r4vok
1r^^f5
2r^^f52l
r5^^f5li
r^^f5n4gu
4r^^f5r
3r^^f6
4r^^f6k
r^^f6^^f64pe
r^^f6^^f6p5l
1r^^e4
4r^^e44r
1r^^fc
4r^^fck
4r^^fcm
4r^^fc4r
4r^^ba
4r^^b2
1sa
3s2aa
saa5j
saa4lu
sa4an
4s3aas
3saba
sa4bi.
4sabo
s4ad
5sada
4sade
s5ader
2s1ae
sae4l
5sa5ga
s4age
sa4gu
4sahv
3sai.
4saia
s1ain
s4ajan
sa4ju.
sak4ro
5saks
4saku.
sa4k^^e4^^e4
4s3a4la.
4salas
s4alat
5salat.
sa4lev
4salla
4sallu
3salt
sa4lum
5salv
3s4am
4samp
4sank
4s5ann
s4ant
4santi
s4anu
sa4num
sa2pr
sa4ris
s4arv.
sar4va
sase4
3sasti
sas4tii
sa4suk
sa4sum
3sat
4satl
s5avald
2s3b2
2s3d2
1se
3sead
se3ala
s5eali
se5aval
se4du.
4seela
see4le
s5eeln
see4ma
4seepi
3seer
see4si
see4ta4
4se4fe
5seg
sega5a
2seh
3seha
3seho
5sehu
5seh^^e4
3sei
sei4d
sei4si
3seka
se3kl
4s5eksp
se4laj
4selek
5seli
4sellu
3selt
2selu
4sens
se5oh
seo4k
se5om
seo4p
seo4r
3sep
sepat4
4serem
4sese.
se4si.
4se4sin
s5esit
ses4k
3sest
4s5eten
se3t2r
4sette
2s1f2
2s1g2
2s1h
1si
3sia
sia4h
sie4
5sign
sig4ra
s5i4ha.
sii4g
sii4sa
sii4se
4siits
sii4tu
si4ket
siko4d
siks4p
sikt4
sik4vi
4sinim
s5inime
4sins
sio4le
si4pro
4sirr
5siru
4si4sa.
si3se
s5i4sik
sis2p
sisse3
s5istuj
5sisu
2s1j
sja5ar
2s1k
4ska
5skaa5la
ska4no
5skeem.
s4kela
5skelet
s5ken
ski4g
sk2l
s5klas
5skler
skuk4
3skulp
sku4si
2s1l
4s1m
sma4sa
2s1n
sne4p
1so
3sobi
3soe
s1oht
3soi
s5oks.
2so2l
s3olek
s3olij
5solo
so3lut
so2ma
3son
3soo
soo5o
4so4pe
so4pr
5sor.
s3orj
3sort
2s1os
4sotsu
2s1p
s5per
2s1r
2s1s
ssel4l
ss2f^^e4
ssin4
s4sinf
ssk4
ss4ke
ss2p
s5spor
ss2t
s5stat
ss4ti
sst5r
s4suss
2s1t
s2taa
3staad
5staa^^b2
s4tain
4stam
5standard
3start
s4tati
5statis
s4teno
5stepp
stet4
s4toh
s4top
s4tot
5streik
5strek
5struktu
st4so
stt4
stu2s
stu4s5a
3stuud
st^^e44
s4t^^e4r
s4t^^fch
1su
sua2
su4bar
sud4r
su4du
su5e
su4jul
4suks
s5uks.
5sulg
sul4ga
sun4de4
su4nis
supe4
supe5s
su4pr
4surb
5sus.
sus4aa
su4ses
s5uss.
sus4ti
su4sun
sut4r
sut4^^fc
4suug
suu4ra
suusa3
2s1v
svus4t
1s^^f5
5s^^f5da
s^^f54de
4s3^^f5h
3s^^f5id
4s^^f5ie
2s1^^f5ig
2s5^^f5is
3s^^f5it
s^^f52l
2s3^^f5li
3s^^f5lm
3s^^f5n
2s1^^f5p
5s^^f5r
s^^f5sa4
2s3^^f5u
1s^^f6
4s^^f6d
s^^f62k
2s^^f6n
1s^^e4
4s^^e4k
4s^^e4m
1s^^fc
4s^^fca
5s^^fcd
5s^^fcg
2s^^fch
s3^^fchi
2s^^fck
s3^^fcks
s^^fc4la
s^^fcl5di
s^^fc3lem
4s^^fclo
s^^fc4ra
3s^^fcs
3s^^fc^^fc
4s^^ba
1ta
3ta.
3taat.
2tabi
4t3aed
t3aine
4tais
4ta4ko
t2al
4ta4laj
ta4lev
tal4las
ta3lu
ta4lus
3tam
5tama
4tanda
ta4ot
ta4pla
ta4pr
4ta4ret
4tarm
2tart
ta4se4r
ta4ses
ta4set
ta4sis
ta4s^^fc
2taut
3tav
ta4vaj
2t1b4
2td2
1t2e
te4aa
tea4g
tea4h
te3an
te5as
3tee
tee5lu
te4et
te3hi
tehi4s
te3kl
tek4r
tek4v
tel4ke
te4lok
te3lu.
4tepiv
tep4l
2tepp
3ter
5ter.
te5r4a
terd4
4terg
ters4
tes4a
te4sin
tes4k
2t1f
4t1g4
2t1h
th^^f5l4
3ti
tia2
ti3e
tii2k
tii4ma
tii4sa
tii4ve
tik4o
ti3k4r
tik4vi
4tilm
5tima
4tinf
tin4ga
ti4sai
tisa4v
ti4sik
titee4
2t1j
2t1k2
t3kl
t3kr
2t1l4
tlu4
2t1m
tmika4
tmis3
2t1n
3t2o
4to4da
toen4
tog6
4toks.
toksi5k
to4lek
to4lu.
to4lum
tonis4
to4o
too4no
too4pe
to4rau
tos4p
tost4
2t3p4
2t1r
t4rad
t2raf
3trafo
t4rahh
5trall
t2ran
3trans
t4rate
5traum
t2re
3treen
t4rei
5treim
3trep
t3rig
5triib
5triip
5trikoo.
tri4pl
t4ross
3trumm
5t4rup
3t2ruu
3t2r^^fc
4tr^^fc^^fc
2t1s
t3s2a
ts4aa
tsa5is
t4saju
tsa4lan
3tsehh
tse3la
5tsellu
5tsemen
4tsena
5tsensu
tsig4
5tsiitsi
t4sink
5tsiste
ts4laa
t2soo
t4sor
tsp4
t4suss
2t1t
t4tad
ttee2
ttes2
t5tsem
3tu
4tuim
tu4raj
tus1a
tu4s5ee
tu2si
tus3s
4t5uss.
tus3t2
tu5su
tu4s^^e44
tus^^fc4
4tutop
4tuud
tuule5
2t1v
1t^^f5
5t^^f5b
2t^^f5i
t^^f54l
4t^^f54n
4t^^f5p
2t5^^f5un
1t^^f6
4t^^f6e
4t^^f6k
t^^f6^^f65k
t^^f6^^f63p
1t^^e4
t^^e4h4t3a
t^^e45ke
4t^^e4m
1t^^fc
t^^fc5he.
t^^fc3hi
2t1^^ba
t2^^bae
5t^^baek
3t^^baem
uaa4
u3aast
ua2b
u5abi
u1ae
ua4he
uai4k
u3ain
ua2ja
u3akt
ua2l
u3all
u3amet
u1an
ua4nu
u5apar
ua2re
ua5ree
u5art
ua2s
u3ast
u1au
uau4d
ua2v
u5avald
u1b
u4dalu
u4deh
udeo4
udo4r
u5eal
u3eel
u3eks
ue2ma
ueo4
ue4r
u1f
u1g
u4gi4d
ug2ra
u5graa
u4g^^fc
uh4tem
uh4ter
uh4tin
uh4tis
uidu5
ui2ga
ui4h
u3iha
u3ilm
5uim.
uina2
uinas5
ui4si
3uisut
uite4h
ui4to
ui4vala
ui4vel
ui4vo
u1j
u5ja
u4juj
u4jum
3ujumi
u1k
ukaa4s
ukii4g
ukki5
ukop4
u3kraa
u5kro
uku4sa
uk4vi
ul4a
ul4deh
uldi4
ul4kr
ul4len
ul4lui
ultra5
u3lu
uluo4
4u1m
umaf4
u4mau
5umbroh
umet4
umf4
umia4
umit4
um5p4r
unaa4
unaal5
un4dak
un4dan
un4das
un4do
u4ni.
u1o2
uo4h
u2or
u3org
u1p
u3pla
up3le
uppe4
up4pis
uraa4l
u4rag
ura4ju
u4rala
u4rap
ur5auk
ura4va
3urb.
urde3
urea4
u4reos
ures4k
u4rett
urgas4
5urge.
u4ri4met
u4rini
uris4k
urka4v
uro4r
u4rulu
u2sa2
u5sa.
usad4
u4sae
u4salu
us5aste
u3sea
useg4
us5elek
u4sett
u3setu
u5sev
us4f^^e4
us5g
u4si4d
usi4g
u4si4h
us5ind
usi4va
us3kr
u2so
us5o2h
us3ole
uso4r
us3p4
u3s4por
usui4
3usuli
u4suss
u2s^^f5
u2s^^fc
us3^^fch
u1t
ut4kl
utos2
utot4
ut4ru
ut4so
utt4r
utu4s
ut^^fc4h
uu5al
4uud
uu4du.
uu4kak
uuk5ri
uu4mal
uu4mis
uu4p^^fc
uu4ran
uu4ras
uu4rau
uu4rav
uu3sa
uusa3k
uus4ke
u3uss.
uu4sul
4uut
uu4tas
uu4tis
uu4t^^fch
u5uuri
u1v
u4vau
u1^^f52
u^^e42
u3^^e4r
u1^^fc2
u^^ba4l
vaa4re4
va4as
4vabi
vae4r
vag4
va5he
4vaia
4v3ain
vak4v
va4la.
va4lai
4valdi
val4ga4
va4l^^fc
vana5i
vane2
4vanku
van4ta
van4te
vap4r
v4ar
4varm
var4p
2vart
4varuh
4varve
va4sas
vas4k
vast4r
vat4r
4vatud
vau4d
vav4
4vb
2v1d
3ve
vee3a
vee3k
vee5la
vee3sp
4vehi
vei4sa
ve4ol
veot4
ve4rah
ves4p
2vf
2vg4
2v1h
3vi
via2
vid4
4videa
vip4
vi3pl
vir4k
vi4sak
vis4ko4d
2v1j
2v1k
2v1l
2v1m
2v1n
voo5lu
2v5p
2v1r
2v1s
2v1t2
v3tr
vu4sa
vu4su4
2v1v
3v^^f5
4v^^f5ig
4v^^f54li
4v^^f5m
v^^f5r4k5
3v^^e4
v^^e4^^e44re4
v^^e4^^e44ru
3zo
zook4
zoos4
^^f51b
^^f5be3
^^f51d
^^f5ea4
^^f5e4lan
^^f5e3lu
^^f5et2
^^f5eu4
^^f51g
^^f5h4vu
^^f5i4a
^^f5i4b
^^f5ie5k
3^^f5iel
3^^f5igu
^^f5i4ko
^^f5ise4
^^f5i4su4
^^f51j
^^f5k4k^^f5
^^f5l2d
^^f54lim
^^f54lit
^^f5l4mad
3^^f5mbl
^^f5net4s
^^f52p
^^f53pa
^^f5pi5e
^^f5p2pa
4^^f5p3r
^^f5randa5
^^f5ra4s
^^f5r4da
^^f5r4gaa
^^f5r4gar
^^f5r4go
4^^f5s
^^f5s4a
^^f54t^^fc4
^^f5ude3
^^f51v4
^^f5^^f55p
^^f5^^f5re4
^^f5^^f54rel
^^f5^^f54ta
^^f6a2
^^f61b
^^f61d
5^^f62dee
^^f6di4k
3^^f6eld
^^f6ep4
^^f6et4r
^^f61g4
^^f61h
^^f6i4a
^^f6i4g
^^f6i4s
^^f61j
^^f61k
^^f62kon
3^^f6kono
^^f6k4v
^^f61l
^^f6li2s
^^f6lis5a
^^f61m
^^f6o2
^^f62p3au
^^f6p4lu
^^f64raa
^^f64rau
^^f6r4da
^^f6r4dell
^^f6r4e
^^f64ri4l
^^f64ro4
^^f64r^^e4
^^f64r^^fcl
^^f6s4tii
^^f64to4
^^f64t^^fc4
^^f61v
^^f63^^f5
^^f6^^f63a
^^f6^^f63e4
^^f6^^f65i
3^^f6^^f6lan
^^f6^^f63o
^^f6^^f6t4r
^^f6^^fc4
^^e4a4
^^e41b
^^e4bus5
^^e4but4
^^e41d
^^e4e3a4
^^e4e1o
^^e41g
^^e4ga4ri
^^e4he5a
^^e4idi4s
^^e4ike3
^^e4i4lo
^^e4i4lu
^^e4i2s
^^e4isa4
^^e4i4s^^f5
^^e4i4tar
^^e43j
^^e42ke
3^^e4ke.
^^e45ker
^^e44k^^f5
^^e4li2s
^^e4l4ko
5^^e4mbl
^^e44nah
^^e4n4deo
^^e4net4
^^e4n4to4
^^e4ok4
^^e44ra5a
^^e4ra3o4
^^e44rar
^^e4re4lis
^^e4ret4
^^e4rge4l
^^e4rii4
^^e4ri4kl
^^e4ri4sel
^^e44riste
^^e4r4kar
^^e44ro
5^^e4rrit
^^e4r4ta
^^e4r2va
^^e44r^^f5
^^e4s4ko
^^e4s4nai
^^e4s4p
^^e4s4san
^^e4s4so
^^e4t4ri
^^e4u4d
^^e41v
^^e4vee4
^^e4^^e44kin
^^e4^^e4o4
^^e4^^e44rase
5^^e4^^e4ris.
^^fcaa4
^^fc1b
^^fcdame5
^^fc1g
^^fc2h
^^fche5i4
1^^fchen
3^^fchik.
^^fc3hit
^^fc1j
^^fckan4
^^fck4kas
^^fck3l
^^fcl2d
^^fcld5a2
^^fc2le
3^^fclek
^^fc5lel
^^fcle4mas
1^^fcles
^^fcles^^e44
^^fcl4gav
^^fcl4gee
^^fc4lih
^^fclii4
3^^fcliko
^^fc4li^^f5
^^fcl5kl
^^fcl5la
^^fcl4mei
^^fclo4r
^^fclp4
^^fclt4
^^fcma4rak
^^fcma4ru
^^fcmi4ko
^^fc5ne
^^fcni4s
^^fcot4
^^fcp3l
^^fcp5p4
^^fcp3r
^^fcpsu4
^^fcrd4
^^fcrik4
^^fcs4o
^^fcs4pr
^^fcs4tal
^^fcs4tas
^^fcta4r
^^fctee4l
5^^fctlev
^^fc4t3r
^^fct4ru
^^fc1v
^^fc4^^fc
^^fc^^fc2l3a2
^^fc^^fc4le
^^fc^^fc4lo
^^fc^^fc4pe
1^^baa
4^^bab
1^^bae
5^^baee
5^^baer
4^^baf
1^^bai
4^^baj
4^^bak
4^^bal
4^^bam
4^^ban
3^^bao
4^^bap
4^^bat
5^^ba^^f6
5^^ba^^fc
2^^ba^^ba
3^^b2a
4^^b2ak
4^^b2au
1^^b2e
3^^b24i
^^b2is4k
4^^b2k
5^^b2o
4^^b2t
3^^b2u4
}
\egroup

