# ABSTRACT: Extend File::ShareDir to Local Libraries

package File::Share;
$File::Share::VERSION = '0.12';
use strict;
use warnings;

use base 'Exporter';
our @EXPORT_OK   = qw[
    dist_dir
    dist_file
    module_dir
    module_file
    class_dir
    class_file
];
our %EXPORT_TAGS = (
    all => [ @EXPORT_OK ],
    ALL => [ @EXPORT_OK ],
);

use File::ShareDir 1.03 ();
use Cwd qw[abs_path];
use File::Spec ();

sub dist_dir {
    my ($dist) = @_;
    (my $inc = $dist) =~ s!(-|::)!/!g;
    $inc .= '.pm';
    my $path = $INC{$inc} || '';
    if ($path and
        $path =~ s!(\S.*?)[\\/]?\bb?lib\b.*!$1! and
        -d "$path/lib" and
        -e "$path/share"
    ) {
        return abs_path "$path/share";
    }
    else {
        return File::ShareDir::dist_dir($dist);
    }
}

sub dist_file {
    my ($dist, $file) = @_;
    my $dir = dist_dir($dist);
    return File::Spec->catfile( $dir, $file );
}

sub module_dir {
    die "File::Share::module_dir not yet supported";
}

sub module_file {
    die "File::Share::module_file not yet supported";
}

1;
