use SDL;

class Game::QFG::Message {

	has $.originator is rw; 
	has $.acceptor is rw; 
	has $.friend-or-foe is rw; 
	has $.msg-body is rw; 

	method BUILD($originator, $acceptor, $friend-or-foe, $msg-body) {

		$.originator = $originator; 
		$.acceptor = $acceptor; 
		$.friend-or-foe = $friend-or-foe;
		$.msg-body = $msg-body;

	}

	multi method split-message {

		return (self.originator, self.acceptor, self.friend-or-foe, self.msg-body);

	}

	multi method split-message($msg) {

		return ($msg.originator, $msg.acceptor, $msg.friend-or-foe, $msg.msg-body);

	}

	method originator {
		return $.originator;
	}

	method acceptor {
		return $.acceptor;
	}
	
	method friend-or-foe {
		return $.friend-or-foe;
	}

	method msg-body {
		return $.msg-body;
	}

}
