use v6.c;
use Mathx::Stat::DistributionPopulation;

class Bayes::Learn::Action is Mathx::Stat::DistributionPopulation {

	has $.actionthreshold;

	method BUILD(:@actiondistrib) {
		$.actionthreshold = 0.0000001;
		@.population = @actiondistrib;
	}

	### Bayesian Expected Loss E[A] * Loss(p,a) of action a
	method BayesianLoss($believedp) { ### believedp is about an action between [0,1]

		my $sum = 0.0;

		### Int 0->a (2*(a-p)) where p is a distribution
		loop (my $a = 0; $a < $believedp; $a+=$.actionthreshold) {
			$sum += 2*($a -$believedp) * $believedp;
		}
		### +
		### Int a->1 (p-a) where p is a distribution
		loop (my $a = $believedp; $a < 1; $a+=$.actionthreshold) {
			$sum += ($believedp - $a) * $believedp;
		}

		return $sum;
	}

	method RiskCondP($m,$n) { ### P(B|A) in a conditional distribution 

		my $sum = 0.0;

		my $prob = Mathx::Stat::Probability.new(@.population);
		my $believedp = $prob.CalculatedCondP($m, $n);

		### Int 0->a (2*(a-p)) where p is a distribution
		loop (my $a = 0; $a < $believedp; $a+=$.actionthreshold) {
			$sum += 2*($a -$believedp) * $beliebedp;
		}
		### +
		### Int a->1 (p-a) where p is a distribution
		loop (my $a = $believedp; $a < 1; $a+=$.actionthreshold) {
			$sum += ($believedp - $a) * $believedp;
		}

		return $sum;
	}

}
