/* ------------------------------------------------------------------------
@NAME       : macros.c
@DESCRIPTION: Front-end to the standard PCCTS symbol table code (sym.c)
              to abstract my "macro table".
@GLOBALS    : 
@CALLS      : 
@CREATED    : 1997/01/12, Greg Ward
@MODIFIED   : 
@VERSION    : $Id: macros.c,v 1.3 1997/02/07 03:21:42 greg Exp $
-------------------------------------------------------------------------- */
#include <stdlib.h>
#include <string.h>
#include "sym.h"
#include "prototypes.h"
#include "error.h"

#define DEBUG 0
#define NUM_MACROS 547
#define STRING_SIZE 4096


void init_macros (void)
{
   zzs_init (NUM_MACROS, STRING_SIZE);
}


void done_macros (void)
{
   zzs_done ();
}


void add_macro (AST *macrodef)
{
   Sym   *new_rec;
   char  *macro, *text;

   macro = macrodef->down->text;
   text = macrodef->down->down->text;

#if DEBUG
   printf ("add_macro: macro = %p (%s)\n"
           "            text = %p (%s)\n",
           macro, macro, text, text);
#endif

   if (zzs_get (macro))
   {
      content_warning (macrodef, 
                       "overriding existing definition of macro \"%s\"", 
                       macro);
   }

   /* 
    * We strdup the supplied text because it comes from an AST node, which
    * is freed up as soon as we're done processing the current entry.
    */

   new_rec = zzs_newadd (macro);
   new_rec->text = strdup (text);
#if DEBUG
   printf ("           saved = %p (%s)\n", new_rec->text, new_rec->text);
#endif
}


int macro_length (char *macro)
{
   Sym   *sym;

#if DEBUG
   printf ("macro_length: looking up \"%s\"\n", macro);
#endif

   sym = zzs_get (macro);
   if (sym)
      return strlen (sym->text);
   else
      return 0;   
}


char *macro_text (AST *macro_use)
{
   char  *macro;
   Sym   *sym;

   macro = macro_use->text;
   sym = zzs_get (macro);
   if (!sym)
   {
      content_warning (macro_use, "undefined macro \"%s\"", macro);
      return NULL;
   }

   return sym->text;
}
