package HTML::FormHandler::Field::Duration;
# ABSTRACT: DateTime::Duration from HTML form values

use Moose;
extends 'HTML::FormHandler::Field::Compound';
use DateTime;

our $VERSION = '0.01';


sub validate {
    my ($self) = @_;

    my @dur_parms;
    foreach my $child ( $self->all_fields ) {
        unless ( $child->has_value && $child->value =~ /^\d+$/ ) {
            $self->add_error( "Invalid value for [_1]: [_2]", $self->loc_label, $child->loc_label );
            next;
        }
        push @dur_parms, ( $child->accessor => $child->value );
    }

    # set the value
    my $duration = DateTime::Duration->new(@dur_parms);
    $self->_set_value($duration);
}

__PACKAGE__->meta->make_immutable;
use namespace::autoclean;
1;


__END__
=pod

=head1 NAME

HTML::FormHandler::Field::Duration - DateTime::Duration from HTML form values

=head1 VERSION

version 0.32002

=head1 SubFields

Subfield names:

  years, months, weeks, days, hours, minutes, seconds, nanoseconds

For example:

   has 'duration' => ( type => 'Duration' );
   has 'duration.hours' => ( type => 'Int', range_start => 0,
        range_end => 23 );
   has 'duration.minutes' => ( type => 'Int', range_start => 0,
        range_end => 59 );

=head1 AUTHOR

FormHandler Contributors - see HTML::FormHandler

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2010 by Gerda Shank.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

