package HTML::FormHandler::Widget::Field::Checkbox;

use Moose::Role;
use namespace::autoclean;

with 'HTML::FormHandler::Widget::Field::Role::HTMLAttributes';

sub render {
    my $self = shift;
    my $result = shift || $self->result;
    my $checkbox_value = $self->checkbox_value;

    my $output = '<input type="checkbox" name="'
        . $self->html_name . '" id="' . $self->id . '" value="'
        . $self->html_filter($checkbox_value) . '"';
    $output .= ' checked="checked"'
        if $result->fif eq $checkbox_value;
    $output .= $self->_add_html_attributes;
    $output .= ' />';

    return $self->wrap_field( $result, $output );
}

1;
