package App::SeismicUnixGui::sunix::migration::sumigtopo2d;

=head2 SYNOPSIS

PACKAGE NAME: 

AUTHOR:  

DATE:

DESCRIPTION:

Version:

=head2 USE

=head3 NOTES

=head4 Examples

=head2 SYNOPSIS

=head3 SEISMIC UNIX NOTES
 SUMIGTOPO2D - Kirchhoff Depth Migration of 2D postack/prestack data	

	     from the (variable topography) recording surface		



    sumigtopo2d  infile=  outfile=  [parameters] 			



 Required parameters:							

 infile=stdin		file for input seismic traces			

 outfile=stdout	file for common offset migration output  	

 ttfile		file for input traveltime tables		

   The following 9 parameters describe traveltime tables:		

 fzt 			first depth sample in traveltime table		

 nzt 			number of depth samples in traveltime table	

 dzt			depth interval in traveltime table		

 fxt			first lateral sample in traveltime table	

 nxt			number of lateral samples in traveltime table	

 dxt			lateral interval in traveltime table		

 fs 			x-coordinate of first source			

 ns 			number of sources				

 ds 			x-coordinate increment of sources		



 fxi                   x-coordinate of the first input trace           

 dxi                   horizontal spacing of input data                

 nxi                   number of input trace locations in surface      



 Optional Parameters:							

 dt= or from header (dt) 	time sampling interval of input data	

 ft= or from header (ft) 	first time sample of input data		

 dxm= or from header (d2) 	sampling interval of midpoints 		

 surf="0,0;99999,0"  Recording surface "x1,z1;x2,z2;x3,z3;...

 fzo=fzt               z-coordinate of first point in output trace 	

 dzo=0.2*dzt		vertical spacing of output trace 		

 nzo=5*(nzt-1)+1 	number of points in output trace		",	

 fxo=fxt               x-coordinate of first output trace 		

 dxo=0.5*dxt		horizontal spacing of output trace 		

 nxo=2*(nxt-1)+1  	number of output traces 			",	

 off0=0               	first offest in output 				

 doff=99999		offset increment in output 			

 noff=1       		number of offsets in output 			",	

 fmax=0.25/dt		frequency-highcut for input traces		

 offmax=99999		maximum absolute offset allowed in migration 	

 aperx=nxt*dxt/2  	migration lateral aperature 			

 angmax=60		migration angle aperature from vertical 	

 v0=1500(m/s)		reference velocity value at surface		",	

 dvz=0.0  		reference velocity vertical gradient		

 ls=1	                flag for line source				

 jpfile=stderr		job print file name 				

 mtr=100  		print verbal information at every mtr traces	

 ntr=100000		maximum number of input traces to be migrated	



 Notes:								

 1. Traveltime tables were generated by program rayt2dtopo (or any 	

    other one that considers topography )on relatively coarse grids,	

    with dimension ns*nxt*nzt. In the migration process, traveltimes	

    are interpolated into shot/gephone positions and output grids.	

 2. Input seismic traces must be SU format and can be any type of 	

    gathers (common shot, common offset, common CDP, and so on).	", 

 3. Migrated traces are output in CDP gathers if velocity analysis	

    is required, with dimension nxo*noff*nzo.  			", 

 4. If the offset value of an input trace is not in the offset array 	

    of output, the nearest one in the array is chosen. 		

 5. Amplitudes are computed using the reference velocity profile, v(z),

    specified by the parameters v0= and dvz=.				

 6. Input traces must specify source and receiver positions via the header

    fields tr.sx and tr.gx. Offset is computed automatically.		





 Author:  Zhenyue Liu, 03/01/95,  Colorado School of Mines



	    Trino Salinas, 07/01/96, Colorado School of Mines,

          extended the code to migrate data from a nonflat 

          recording surface.



 References :



 Bleistein, N., Cohen, J., and Hagin, F., 1987, Two and one-half

   dimensional Born inversion with arbitrary reference: Geophysics,

   52, 26-36.



 Liu,Z., 1993, A Kirchhoff approach to seismic modeling and 

   pre-stack depth migration: CWP Annual Report, CWP, Colorado

   School of Mines.



 Wiggins, J. W., 1984, Kirchhoff integral extrapolation and

   migration of nonplanar data: Geophysics, 49, 1239-

   1248.



=head2 User's notes (Juan Lorenzo)
untested

=cut


=head2 CHANGES and their DATES

=cut

use Moose;
our $VERSION = '0.0.1';


=head2 Import packages

=cut

use aliased 'App::SeismicUnixGui::misc::L_SU_global_constants';

use App::SeismicUnixGui::misc::SeismicUnix qw($go $in $off $on $out $ps $to $suffix_ascii $suffix_bin $suffix_ps $suffix_segy $suffix_su);
use aliased 'App::SeismicUnixGui::configs::big_streams::Project_config';


=head2 instantiation of packages

=cut

my $get					= L_SU_global_constants->new();
my $Project				= Project_config->new();
my $DATA_SEISMIC_SU		= $Project->DATA_SEISMIC_SU();
my $DATA_SEISMIC_BIN	= $Project->DATA_SEISMIC_BIN();
my $DATA_SEISMIC_TXT	= $Project->DATA_SEISMIC_TXT();

my $PS_SEISMIC      	= $Project->PS_SEISMIC();

my $var				= $get->var();
my $on				= $var->{_on};
my $off				= $var->{_off};
my $true			= $var->{_true};
my $false			= $var->{_false};
my $empty_string	= $var->{_empty_string};

=head2 Encapsulated
hash of private variables

=cut

my $sumigtopo2d			= {
	_angmax					=> '',
	_aperx					=> '',
	_doff					=> '',
	_dt					=> '',
	_dvz					=> '',
	_dxm					=> '',
	_dxo					=> '',
	_dzo					=> '',
	_fmax					=> '',
	_ft					=> '',
	_fxo					=> '',
	_fzo					=> '',
	_infile					=> '',
	_jpfile					=> '',
	_ls					=> '',
	_mtr					=> '',
	_noff					=> '',
	_ntr					=> '',
	_nxo					=> '',
	_nzo					=> '',
	_off0					=> '',
	_offmax					=> '',
	_outfile					=> '',
	_surf					=> '',
	_v0					=> '',
	_Step					=> '',
	_note					=> '',

};

=head2 sub Step

collects switches and assembles bash instructions
by adding the program name

=cut

 sub  Step {

	$sumigtopo2d->{_Step}     = 'sumigtopo2d'.$sumigtopo2d->{_Step};
	return ( $sumigtopo2d->{_Step} );

 }


=head2 sub note

collects switches and assembles bash instructions
by adding the program name

=cut

 sub  note {

	$sumigtopo2d->{_note}     = 'sumigtopo2d'.$sumigtopo2d->{_note};
	return ( $sumigtopo2d->{_note} );

 }



=head2 sub clear

=cut

 sub clear {

		$sumigtopo2d->{_angmax}			= '';
		$sumigtopo2d->{_aperx}			= '';
		$sumigtopo2d->{_doff}			= '';
		$sumigtopo2d->{_dt}			= '';
		$sumigtopo2d->{_dvz}			= '';
		$sumigtopo2d->{_dxm}			= '';
		$sumigtopo2d->{_dxo}			= '';
		$sumigtopo2d->{_dzo}			= '';
		$sumigtopo2d->{_fmax}			= '';
		$sumigtopo2d->{_ft}			= '';
		$sumigtopo2d->{_fxo}			= '';
		$sumigtopo2d->{_fzo}			= '';
		$sumigtopo2d->{_infile}			= '';
		$sumigtopo2d->{_jpfile}			= '';
		$sumigtopo2d->{_ls}			= '';
		$sumigtopo2d->{_mtr}			= '';
		$sumigtopo2d->{_noff}			= '';
		$sumigtopo2d->{_ntr}			= '';
		$sumigtopo2d->{_nxo}			= '';
		$sumigtopo2d->{_nzo}			= '';
		$sumigtopo2d->{_off0}			= '';
		$sumigtopo2d->{_offmax}			= '';
		$sumigtopo2d->{_outfile}			= '';
		$sumigtopo2d->{_surf}			= '';
		$sumigtopo2d->{_v0}			= '';
		$sumigtopo2d->{_Step}			= '';
		$sumigtopo2d->{_note}			= '';
 }


=head2 sub angmax 


=cut

 sub angmax {

	my ( $self,$angmax )		= @_;
	if ( $angmax ne $empty_string ) {

		$sumigtopo2d->{_angmax}		= $angmax;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' angmax='.$sumigtopo2d->{_angmax};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' angmax='.$sumigtopo2d->{_angmax};

	} else { 
		print("sumigtopo2d, angmax, missing angmax,\n");
	 }
 }


=head2 sub aperx 


=cut

 sub aperx {

	my ( $self,$aperx )		= @_;
	if ( $aperx ne $empty_string ) {

		$sumigtopo2d->{_aperx}		= $aperx;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' aperx='.$sumigtopo2d->{_aperx};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' aperx='.$sumigtopo2d->{_aperx};

	} else { 
		print("sumigtopo2d, aperx, missing aperx,\n");
	 }
 }


=head2 sub doff 


=cut

 sub doff {

	my ( $self,$doff )		= @_;
	if ( $doff ne $empty_string ) {

		$sumigtopo2d->{_doff}		= $doff;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' doff='.$sumigtopo2d->{_doff};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' doff='.$sumigtopo2d->{_doff};

	} else { 
		print("sumigtopo2d, doff, missing doff,\n");
	 }
 }


=head2 sub dt 


=cut

 sub dt {

	my ( $self,$dt )		= @_;
	if ( $dt ne $empty_string ) {

		$sumigtopo2d->{_dt}		= $dt;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' dt='.$sumigtopo2d->{_dt};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' dt='.$sumigtopo2d->{_dt};

	} else { 
		print("sumigtopo2d, dt, missing dt,\n");
	 }
 }


=head2 sub dvz 


=cut

 sub dvz {

	my ( $self,$dvz )		= @_;
	if ( $dvz ne $empty_string ) {

		$sumigtopo2d->{_dvz}		= $dvz;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' dvz='.$sumigtopo2d->{_dvz};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' dvz='.$sumigtopo2d->{_dvz};

	} else { 
		print("sumigtopo2d, dvz, missing dvz,\n");
	 }
 }


=head2 sub dxm 


=cut

 sub dxm {

	my ( $self,$dxm )		= @_;
	if ( $dxm ne $empty_string ) {

		$sumigtopo2d->{_dxm}		= $dxm;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' dxm='.$sumigtopo2d->{_dxm};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' dxm='.$sumigtopo2d->{_dxm};

	} else { 
		print("sumigtopo2d, dxm, missing dxm,\n");
	 }
 }


=head2 sub dxo 


=cut

 sub dxo {

	my ( $self,$dxo )		= @_;
	if ( $dxo ne $empty_string ) {

		$sumigtopo2d->{_dxo}		= $dxo;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' dxo='.$sumigtopo2d->{_dxo};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' dxo='.$sumigtopo2d->{_dxo};

	} else { 
		print("sumigtopo2d, dxo, missing dxo,\n");
	 }
 }


=head2 sub dzo 


=cut

 sub dzo {

	my ( $self,$dzo )		= @_;
	if ( $dzo ne $empty_string ) {

		$sumigtopo2d->{_dzo}		= $dzo;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' dzo='.$sumigtopo2d->{_dzo};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' dzo='.$sumigtopo2d->{_dzo};

	} else { 
		print("sumigtopo2d, dzo, missing dzo,\n");
	 }
 }


=head2 sub fmax 


=cut

 sub fmax {

	my ( $self,$fmax )		= @_;
	if ( $fmax ne $empty_string ) {

		$sumigtopo2d->{_fmax}		= $fmax;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' fmax='.$sumigtopo2d->{_fmax};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' fmax='.$sumigtopo2d->{_fmax};

	} else { 
		print("sumigtopo2d, fmax, missing fmax,\n");
	 }
 }


=head2 sub ft 


=cut

 sub ft {

	my ( $self,$ft )		= @_;
	if ( $ft ne $empty_string ) {

		$sumigtopo2d->{_ft}		= $ft;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' ft='.$sumigtopo2d->{_ft};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' ft='.$sumigtopo2d->{_ft};

	} else { 
		print("sumigtopo2d, ft, missing ft,\n");
	 }
 }


=head2 sub fxo 


=cut

 sub fxo {

	my ( $self,$fxo )		= @_;
	if ( $fxo ne $empty_string ) {

		$sumigtopo2d->{_fxo}		= $fxo;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' fxo='.$sumigtopo2d->{_fxo};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' fxo='.$sumigtopo2d->{_fxo};

	} else { 
		print("sumigtopo2d, fxo, missing fxo,\n");
	 }
 }


=head2 sub fzo 


=cut

 sub fzo {

	my ( $self,$fzo )		= @_;
	if ( $fzo ne $empty_string ) {

		$sumigtopo2d->{_fzo}		= $fzo;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' fzo='.$sumigtopo2d->{_fzo};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' fzo='.$sumigtopo2d->{_fzo};

	} else { 
		print("sumigtopo2d, fzo, missing fzo,\n");
	 }
 }


=head2 sub infile 


=cut

 sub infile {

	my ( $self,$infile )		= @_;
	if ( $infile ne $empty_string ) {

		$sumigtopo2d->{_infile}		= $infile;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' infile='.$sumigtopo2d->{_infile};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' infile='.$sumigtopo2d->{_infile};

	} else { 
		print("sumigtopo2d, infile, missing infile,\n");
	 }
 }


=head2 sub jpfile 


=cut

 sub jpfile {

	my ( $self,$jpfile )		= @_;
	if ( $jpfile ne $empty_string ) {

		$sumigtopo2d->{_jpfile}		= $jpfile;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' jpfile='.$sumigtopo2d->{_jpfile};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' jpfile='.$sumigtopo2d->{_jpfile};

	} else { 
		print("sumigtopo2d, jpfile, missing jpfile,\n");
	 }
 }


=head2 sub ls 


=cut

 sub ls {

	my ( $self,$ls )		= @_;
	if ( $ls ne $empty_string ) {

		$sumigtopo2d->{_ls}		= $ls;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' ls='.$sumigtopo2d->{_ls};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' ls='.$sumigtopo2d->{_ls};

	} else { 
		print("sumigtopo2d, ls, missing ls,\n");
	 }
 }


=head2 sub mtr 


=cut

 sub mtr {

	my ( $self,$mtr )		= @_;
	if ( $mtr ne $empty_string ) {

		$sumigtopo2d->{_mtr}		= $mtr;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' mtr='.$sumigtopo2d->{_mtr};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' mtr='.$sumigtopo2d->{_mtr};

	} else { 
		print("sumigtopo2d, mtr, missing mtr,\n");
	 }
 }


=head2 sub noff 


=cut

 sub noff {

	my ( $self,$noff )		= @_;
	if ( $noff ne $empty_string ) {

		$sumigtopo2d->{_noff}		= $noff;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' noff='.$sumigtopo2d->{_noff};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' noff='.$sumigtopo2d->{_noff};

	} else { 
		print("sumigtopo2d, noff, missing noff,\n");
	 }
 }


=head2 sub ntr 


=cut

 sub ntr {

	my ( $self,$ntr )		= @_;
	if ( $ntr ne $empty_string ) {

		$sumigtopo2d->{_ntr}		= $ntr;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' ntr='.$sumigtopo2d->{_ntr};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' ntr='.$sumigtopo2d->{_ntr};

	} else { 
		print("sumigtopo2d, ntr, missing ntr,\n");
	 }
 }


=head2 sub nxo 


=cut

 sub nxo {

	my ( $self,$nxo )		= @_;
	if ( $nxo ne $empty_string ) {

		$sumigtopo2d->{_nxo}		= $nxo;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' nxo='.$sumigtopo2d->{_nxo};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' nxo='.$sumigtopo2d->{_nxo};

	} else { 
		print("sumigtopo2d, nxo, missing nxo,\n");
	 }
 }


=head2 sub nzo 


=cut

 sub nzo {

	my ( $self,$nzo )		= @_;
	if ( $nzo ne $empty_string ) {

		$sumigtopo2d->{_nzo}		= $nzo;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' nzo='.$sumigtopo2d->{_nzo};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' nzo='.$sumigtopo2d->{_nzo};

	} else { 
		print("sumigtopo2d, nzo, missing nzo,\n");
	 }
 }


=head2 sub off0 


=cut

 sub off0 {

	my ( $self,$off0 )		= @_;
	if ( $off0 ne $empty_string ) {

		$sumigtopo2d->{_off0}		= $off0;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' off0='.$sumigtopo2d->{_off0};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' off0='.$sumigtopo2d->{_off0};

	} else { 
		print("sumigtopo2d, off0, missing off0,\n");
	 }
 }


=head2 sub offmax 


=cut

 sub offmax {

	my ( $self,$offmax )		= @_;
	if ( $offmax ne $empty_string ) {

		$sumigtopo2d->{_offmax}		= $offmax;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' offmax='.$sumigtopo2d->{_offmax};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' offmax='.$sumigtopo2d->{_offmax};

	} else { 
		print("sumigtopo2d, offmax, missing offmax,\n");
	 }
 }


=head2 sub outfile 


=cut

 sub outfile {

	my ( $self,$outfile )		= @_;
	if ( $outfile ne $empty_string ) {

		$sumigtopo2d->{_outfile}		= $outfile;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' outfile='.$sumigtopo2d->{_outfile};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' outfile='.$sumigtopo2d->{_outfile};

	} else { 
		print("sumigtopo2d, outfile, missing outfile,\n");
	 }
 }


=head2 sub surf 


=cut

 sub surf {

	my ( $self,$surf )		= @_;
	if ( $surf ne $empty_string ) {

		$sumigtopo2d->{_surf}		= $surf;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' surf='.$sumigtopo2d->{_surf};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' surf='.$sumigtopo2d->{_surf};

	} else { 
		print("sumigtopo2d, surf, missing surf,\n");
	 }
 }


=head2 sub v0 


=cut

 sub v0 {

	my ( $self,$v0 )		= @_;
	if ( $v0 ne $empty_string ) {

		$sumigtopo2d->{_v0}		= $v0;
		$sumigtopo2d->{_note}		= $sumigtopo2d->{_note}.' v0='.$sumigtopo2d->{_v0};
		$sumigtopo2d->{_Step}		= $sumigtopo2d->{_Step}.' v0='.$sumigtopo2d->{_v0};

	} else { 
		print("sumigtopo2d, v0, missing v0,\n");
	 }
 }


=head2 sub get_max_index

max index = number of input variables -1
 
=cut
 
sub get_max_index {
 	  my ($self) = @_;
	my $max_index = 24;

    return($max_index);
}
 
 
1;
