package Sim::OPT::Report;
# Copyright (C) 2008-2015 by Gian Luca Brunetti and Politecnico di Milano.
# This is the module Sim::OPT::Retrieve of Sim::OPT, a program for detailed metadesign managing parametric explorations through the ESP-r building performance simulation platform and performing optimization by block coordinate descent.
# This is free software.  You can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 
use v5.14;
# use v5.20;
use Exporter;
use vars qw( $VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS );
use Math::Trig;
use Math::Round;
use List::Util qw[ min max reduce shuffle];
use List::MoreUtils qw(uniq);
use List::AllUtils qw(sum);
use Statistics::Basic qw(:all);
use Set::Intersection;
use List::Compare;
use IO::Tee;
use File::Copy qw( move copy );
use Sim::OPT;
use Sim::OPT::Morph;
use Sim::OPT::Sim;
use Sim::OPT::Descend;
use Sim::OPT::Takechance;
use Data::Dumper;
#$Data::Dumper::Indent = 0;
#$Data::Dumper::Useqq  = 1;
#$Data::Dumper::Terse  = 1;
use Data::Dump qw(dump);
use feature 'say';
no strict; 
no warnings;
use warnings::unused;
@ISA = qw(Exporter); # our @adamkISA = qw(Exporter);
#%EXPORT_TAGS = ( DEFAULT => [qw( &opt &prepare )]); # our %EXPORT_TAGS = ( 'all' => [ qw( ) ] );
#@EXPORT   = qw(); # our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw( retrieve report get_files );

$VERSION = '0.51.09'; # our $VERSION = '';
$ABSTRACT = 'Sim::OPT::Report is the module used by Sim::OPT to retrieve simulation results.';

#########################################################################################
# HERE FOLLOWS THE CONTENT OF "Retrieve.pm", Sim::OPT::Retrieve
##############################################################################


sub retrieve
{	
	my $swap = shift; #say TOFILE "swapINRETRIEVE: " . dump($swap);
	my %dat = %$swap;
	my @instances = @{ $dat{instances} }; #say "scalar(\@instances): " . scalar(@instances);
	my $countcase = $dat{countcase}; #say TOFILE "dump(\$countcase): " . dump($countcase); # IT WILL BE SHADOWED. CUT ZZZ
	my $countblock = $dat{countblock}; #say TOFILE "dump(\$countblock): " . dump($countblock); # IT WILL BE SHADOWED. CUT ZZZ		
	my %dirfiles = %{ $dat{dirfiles} }; #say "dump(\%dirfiles): " . dump(%dirfiles); 
		
	$configfile = $main::configfile; #say "dump(\$configfile): " . dump($configfile);
	@sweeps = @main::sweeps; #say TOFILE "dump(\@sweeps): " . dump(@sweeps);
	@varinumbers = @main::varinumbers; #say "dump(\@varinumbers): " . dump(@varinumbers);
	@mediumiters = @main::mediumiters;
	@rootnames = @main::rootnames; #say "dump(\@rootnames): " . dump(@rootnames);
	%vals = %main::vals; #say "dump(\%vals): " . dump(%vals);
	
	$mypath = $main::mypath;  #say TOFILE "dumpINRETRIEVE(\$mypath): " . dump($mypath);
	$exeonfiles = $main::exeonfiles; #say TOFILE "dumpINRETRIEVE(\$exeonfiles): " . dump($exeonfiles);
	$generatechance = $main::generatechance; 
	$file = $main::file;
	$preventsim = $main::preventsim;
	$fileconfig = $main::fileconfig; #say TOFILE "dumpINRETRIEVE(\$fileconfig): " . dump($fileconfig); # NOW GLOBAL. TO MAKE IT PRIVATE, FIX PASSING OF PARAMETERS IN CONTRAINTS PROPAGATION SECONDARY SUBROUTINES
	$outfile = $main::outfile;
	$tofile = $main::tofile;
	$report = $main::report;
	$simnetwork = $main::simnetwork;
	
	$tee = new IO::Tee(\*STDOUT, ">>$tofile"); # GLOBAL ZZZ
	
	#open( OUTFILE, ">>$outfile" ) or die "Can't open $outfile: $!"; 
	open( TOFILE, ">>$tofile" ) or die "Can't open $tofile: $!"; 
	#say "\nNow in Sim::OPT::Report::retrieve.\n";
	say $tee "\n#Now in Sim::OPT::Report_retrieve.\n";
	
	%dowhat = %main::dowhat;
	
	#my $evalfiletemp = $dowhat{evalfile};
	#my $evalfile;
	#unless ( ( "$^O" eq "MSWin32" ) or ( "$^O" eq "MSWin64" ) ) 
	#{
	#	$evalfile = $mypath . "/" . $evalfiletemp;
	#}
	#else
	#{
	#	$evalfile = $mypath . "\\" . $evalfiletemp;
	#}
	#say $tee "AS \$evalfile I HAVE $evalfile";
	#
	#if ( -e $evalfile )
	#{
	#	say $tee "NOW EVALING $evalfile";
	#	say $tee `cat $evalfile`;
	#	eval { `cat $evalfile` };
	#}
				
	%simtitles = %main::simtitles; #say $tee "dumpINRETRIEVE(\%simtitles): " . dump(%simtitles);
	%retrievedata = %main::retrievedata;
	@keepcolumns = @main::keepcolumns;
	@weights = @main::weights;
	@weightsaim = @main::weightsaim;
	@varthemes_report = @main::varthemes_report;
	@varthemes_variations = @vmain::arthemes_variations;
	@varthemes_steps = @main::varthemes_steps;
	@rankdata = @main::rankdata; # CUT ZZZ
	@rankcolumn = @main::rankcolumn;
	%reportdata = %main::reportdata; #say $tee "dump(\%reportdata): " . dump(%reportdata);
	@files_to_filter = @main::files_to_filter;
	@filter_reports = @main::filter_reports;
	@base_columns = @main::base_columns;
	@maketabledata = @main::maketabledata;
	@filter_columns = @main::filter_columns;
	%vals = %main::vals;
	
	my @simcases = @{ $dirfiles{simcases} }; #say $tee "dump(\@simcases): " . dump(@simcases);
	my @simstruct = @{ $dirfiles{simstruct} }; #say $tee "dump(\@simstruct): " . dump(@simstruct);
	my @morphcases = @{ $dirfiles{morphcases} };
	my @morphstruct = @{ $dirfiles{morphstruct} };
	my @retcases = @{ $dirfiles{retcases} };
	my @retstruct = @{ $dirfiles{retstruct} };
	my @repcases = @{ $dirfiles{repcases} };
	my @repstruct = @{ $dirfiles{repstruct} };
	my @mergecases = @{ $dirfiles{mergecases} };
	my @mergestruct = @{ $dirfiles{mergestruct} };
	my @descendcases = @{ $dirfiles{descendcases} };
	my @descendstruct = @{ $dirfiles{descendstruct} };
	
	my $morphlist = $dirfiles{morphlist}; #say $tee "dump(\$morphlist): " . dump($morphlist);
	my $morphblock = $dirfiles{morphblock};
	my $simlist = $dirfiles{simlist}; #say $tee "dump(\$simlist): " . dump($simlist);
	my $simblock = $dirfiles{simblock};
	my $retlist = $dirfiles{retlist};
	my $retblock = $dirfiles{retblock};
	my $replist = $dirfiles{replist};
	my $repblock = $dirfiles{repblock};
	my $descendlist = $dirfiles{descendlist};
	my $descendblock = $dirfiles{descendblock};
	
	my $skipfile = $vals{skipfile}; #say $tee "dump(\$skipfile): " . dump($skipfile);
	my $skipsim = $vals{skipsim}; #say $tee "dump(\$skipsim): " . dump($skipsim);
	my $skipreport = $vals{skipreport}; #say $tee "dump(\$skipreport): " . dump($skipreport);	
	my %notecases;
	
	#my $getpars = shift;
	#eval( $getpars );

	#if ( fileno (MORPHLIST)
	
	my $countinstance = 0;
	foreach my $instance (@instances)
	{
		#say TOFILE "\nNow in Sim::OPT::Retrieve. INSTANCES\n";
		my %d = %{$instance};
		my $countcase = $d{countcase}; #say TOFILE "dump(\$countcase): " . dump($countcase);
		my $countblock = $d{countblock}; #say TOFILE "dump(\$countblock): " . dump($countblock);
		my @miditers = @{ $d{miditers} }; #say $tee "dump(\@miditers): " . dump(@miditers);
		my @winneritems = @{ $d{winneritems} }; #say TOFILE "dumpIN( \@winneritems) " . dump(@winneritems);
		my $countvar = $d{countvar}; #say TOFILE "dump(\$countvar): " . dump($countvar);
		my $countstep = $d{countstep}; #say TOFILE "dump(\$countstep): " . dump($countstep);						
		my $to = $d{to}; #say TOFILE "dump(\$to): " . dump($to);
		my $origin = $d{origin}; #say TOFILE "dump(\$origin): " . dump($origin);
		my @uplift = @{ $d{uplift} }; #say TOFILE "dump(\@uplift): " . dump(@uplift);
		#eval($getparshere);
		
		my $skip = $vals{$countvar}{skip}; #say $tee "dumpinreport(\$skip): " . dump($skip);
		
		my $rootname = Sim::OPT::getrootname(\@rootnames, $countcase); #say TOFILE "dump(\$rootname): " . dump($rootname);
		my @blockelts = Sim::OPT::getblockelts(\@sweeps, $countcase, $countblock); #say TOFILE "dumpIN( \@blockelts) " . dump(@blockelts);
		my @blocks = Sim::OPT::getblocks(\@sweeps, $countcase);  #say TOFILE "dumpIN( \@blocks) " . dump(@blocks);
		my $toitem = Sim::OPT::getitem(\@winneritems, $countcase, $countblock); #say TOFILE "dump(\$toitem): " . dump($toitem);
		my $from = Sim::OPT::getline($toitem); #say $tee "dumpIN(\$from): " . dump($from);
		my %varnums = Sim::OPT::getcase(\@varinumbers, $countcase); #say TOFILE "dumpIN---(\%varnums): " . dump(%varnums); 
		my %mids = Sim::OPT::getcase(\@miditers, $countcase); #say TOFILE "dumpIN---(\%mids): " . dump(%mids); 
		#eval($getfly);
		
		my $stepsvar = Sim::OPT::getstepsvar($countvar, $countcase, \@varinumbers); #say TOFILE "dump(\$stepsvar): " . dump($stepsvar); 
		my $varnumber = $countvar; #say TOFILE "dump---(\$varnumber): " . dump($varnumber) . "\n\n";  # LEGACY VARIABLE
		
		my $numberof_simtools = scalar ( keys %{ $dowhat{simtools} } ); #say $tee "\$numberof_simtools " . dump( $numberof_simtools );
		
		my $counttool = 1;
		while ( $counttool <= $numberof_simtools )
		{	
			my $skip = $vals{$countvar}{$counttool}{skip}; #say $tee "dumpinsim(\$skip): " . dump($skip);
			if ( not ( eval ( $skipsim{$counttool} )))
			{
				my $tooltype = $dowhat{simtools}{$counttool}; #say $tee "\$tooltype " . dump( $tooltype );

				sub retrieve_temperatures_results 
				{
					my ( $result, $resfile, $retrdata_ref, $reporttitle, $themereport, $counttheme, $countreport, $retfile ) = @_;
					my @retrdata = @$retrdata_ref;
					
					#say "INRETRIEVE0\$countcase : " . dump($countcase);
					#say "INRETRIEVE1\@rootnames : " . dump(@rootnames);
					#say "INRETRIEVE1\$countblock : " . dump($countblock);
					#say "INRETRIEVE1\@sweeps : " . dump(@sweeps);
					#say "INRETRIEVE1\@varinumbers : " . dump(@varinumbers);
					#say "INRETRIEVE1\@miditers : " . dump(@miditers);
					#say "INRETRIEVE1\@winneritems : " . dump(@winneritems);
					#say "INRETRIEVE1\@morphcases : " . dump(@morphcases);
					#say "INRETRIEVE1\@morphstruct : " . dump(@morphstruct);

					unless (-e "$retfile")
					{
						my $printthis = 
"res -file $resfile -mode script<<YYY

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
c
g
a
a
b
a
b
e
b
f
>
a
$retfile
!
-
-
-
-
-
-
-
-
YYY
";
						if ($exeonfiles eq "y")
						{ 	
							say $tee "#Retrieving temperature results.";
							print `$printthis`;
						}
						print $tee "
			#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", simulation period $counttheme, retrieve period $countreport\n
			$printthis";

					}
				}

				sub retrieve_comfort_results
				{
					my ( $result, $resfile, $retrdata_ref, $reporttitle, $stripcheck, $themereport, $counttheme, $countreport, $retfile ) = @_;
					
					my @retrdata = @$retrdata_ref;

					unless (-e "$retfile")
					{
						my $printthis =
"res -file $resfile -mode script<<ZZZ

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
c
g
c
a

b


a
>
a
$retfile
!
-
-
-
-
-
-
-
-
ZZZ
";
						if ($exeonfiles eq "y") 
						{ 
							say $tee "Retrieving comfort results.";
							print `$printthis`;
						}
						print TOFILE "
		#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", simulation period $counttheme, retrieve period $countreport\n
		$printthis";
					}
				}

				sub retrieve_stats_results
				{	
					my ( $result, $resfile, $retrdata_ref, $reporttitle, $themereport, $counttheme, $countreport, $retfile, $semaphorego1, $semaphorego2, $semaphorestop1, $semaphorestop2, $textpattern, $afterlines ) = @_;
					#print $tee " IN RETRIEVE STATS: \$sim: $sim, \$resfile: $resfile, \$result: $result, \$reporttitle: $reporttitle, \$themereport: $themereport, \$counttheme: $counttheme, \$countreport, $countreport, \$retfile : $retfile \n";
					#print $tee "\%retrievedata: " . dump( %retrievedata ); 
					my @retrdata = @$retrdata_ref; #say $tee "\@retrdata " . dump(@retrdata);
					my $printthis;
					
					if ( $themereport eq "loads" )
					{
						unless (-e "$retfile")
						{
							$printthis =
"res -file $resfile -mode script<<TTT

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
d
>
a
$retfile
$retfile
l
a
-
-
-
-
-
TTT
";
						}
					}
					elsif ( $themereport eq "tempsstats" )
					{
						unless (-e "$retfile")
						{
							$printthis =
"res -file $resfile -mode script<<TTT

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
d
>
a
$retfile
$retfile
m
-
-
-
-
TTT
";
						}
					}
					if ($exeonfiles eq "y") 
					{
						#say "Retrieving $themereport results.";
						say $tee "#Retrieving $themereport results.";
						print `$printthis`;
					}
					print $tee " 
		#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", simulation period $counttheme, retrieve period $countreport\n
		$printthis
		";

				}
				
				sub retrieve_adhoc
				{	
					my ( $result, $resfile, $retrdata_ref, $reporttitle, $themereport, $counttheme, $countreport, $retfile, $semaphorego1, $semaphorego2, $semaphorestop1, $semaphorestop2, $textpattern, $afterlines ) = @_;
					#my ( $result, $resfile, $retrdata_ref, $reporttitle, $themereport, $counttheme, $countreport, $retfile, $semaphorego1, $semaphorego2, $semaphorestop1, $semaphorestop2, $textpattern, $afterlines, $adhoclines ) = @_;
					#print $tee " IN RETRIEVE ADHOC: \$sim: $sim, \$resfile: $resfile, \$result: $result, \$reporttitle: $reporttitle, \$themereport: $themereport, \$counttheme: $counttheme, \$countreport, $countreport, \$retfile : $retfile \n";
					#print $tee "\%retrievedata: " . dump( %retrievedata ); 
					my @retrdata = @$retrdata_ref; #say $tee "\@retrdata " . dump(@retrdata);
					#my $insert = eval { $adhoclines }; say $tee "\$insert: $insert";
					my $printthis;
					unless (-e "$retfile")
					{
						if ( $themereport eq "radent" )
						{
							$printthis =
"res -file $resfile -mode script<<TTT

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
c
g
d
a
>
a
$retfile
$retfile

!
-
-
-
-
-
TTT
";
			
							print $tee " 
#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", simulation period $counttheme, retrieve period $countreport\n
$printthis
";
					
							if ($exeonfiles eq "y") 
							{
								#say "Retrieving $themereport results.";
								say $tee "#Retrieving $themereport results.";
								print `$printthis`;
							}
						}
						elsif ( $themereport eq "radabs" )
						{
							$printthis =
"res -file $resfile -mode script<<TTT

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
c
g
d
c
>
a
$retfile
$retfile

!
-
-
-
-
-
TTT
";
			
						print $tee " 
#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", simulation period $counttheme, retrieve period $countreport\n
$printthis
";
					
							if ($exeonfiles eq "y") 
							{
								#say "Retrieving $themereport results.";
								say $tee "#Retrieving $themereport results.";
								print `$printthis`;
							}
						}
						elsif ( $themereport eq "airtemp" )
						{
							$printthis =
"res -file $resfile -mode script<<TTT

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
c
g
b
e
>
a
$retfile
$retfile

!
-
-
-
-
-
TTT
";
			
						print $tee " 
#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", simulation period $counttheme, retrieve period $countreport\n
$printthis
";
					
							if ($exeonfiles eq "y") 
							{
								#say "Retrieving $themereport results.";
								say $tee "#Retrieving $themereport results.";
								print `$printthis`;
							}
						}
						elsif ( $themereport eq "radtemp" )
						{
							$printthis =
"res -file $resfile -mode script<<TTT

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
c
g
b
e
>
a
$retfile
$retfile

!
-
-
-
-
-
TTT
";
			
						print $tee " 
#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", simulation period $counttheme, retrieve period $countreport\n
$printthis
";
					
							if ($exeonfiles eq "y") 
							{
								#say "Retrieving $themereport results.";
								say $tee "#Retrieving $themereport results.";
								print `$printthis`;
							}
						}
						elsif ( $themereport eq "restemp" )
						{
							$printthis =
"res -file $resfile -mode script<<TTT

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
c
g
b
e
>
a
$retfile
$retfile

!
-
-
-
-
-
TTT
";
			
						print $tee " 
#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", simulation period $counttheme, retrieve period $countreport\n
$printthis
";
					
							if ($exeonfiles eq "y") 
							{
								#say "Retrieving $themereport results.";
								say $tee "#Retrieving $themereport results.";
								print `$printthis`;
							}
						}
					}
				}
				
				#say $tee "\nNow in Sim::OPT::Retrieve. INSIDE";
				my @resfiles = @{ $simstruct[$countcase][$countblock][$countinstance][$counttool] }; #say $tee "SAY\@resfiles " . dump(@resfiles); 
				#say $tee "SAY\@simcases " . dump( @simcases ); say $tee "SAY\@simstruct " . dump(@simstruct); 
				
				#say $tee "\%retrievedata " . dump( %retrievedata );
				#say $tee "\$retrievedata{\$counttool} " . dump( $retrievedata{$counttool} );
				
				if ( $retrievedata{$counttool} )
				{
					if ( $tooltype eq "esp-r" )
					{
						my $counttheme = 0;
						#say $tee "INRETRIEVE \@{ \$retrievedata{\$counttool} } " . dump( @{ $retrievedata{$counttool} } );
						foreach my $retrievedatum ( @{ $retrievedata{$counttool} } )
						{	
							#say $tee "INRETRIEVE \$retrievedatum " . dump( $retrievedatum );
							my $reportdata_ref_ref = $reportdata{$counttool}->[$counttheme]; #say $tee "\$reportdata_ref_ref " . dump($reportdata_ref_ref);
							my @retrievedatarefs = @{$retrievedatum}; #say $tee "\@retrievedatarefs " . dump(@retrievedatarefs);
							my $simtitle = $simtitles{$counttool}->[ $counttheme ][0]; #say $tee "\$simtitle " . dump($simtitle);
							my @sims = @{ $simtitles{$counttool}->[ $counttheme ] }[1..4]; #say $tee "\@sims " . dump(@sims);
							
							my $resfile = $resfiles[ 0 ]; #say $tee "\HERE\$resfile " . dump($resfile);
							
							#if ( not ( eval ( $skipreport ) ) )
							if ( -e $resfile ) 
							{
								
								my $countreport = 0;
								foreach my $retrievedataref (@retrievedatarefs)
								{
									#say $tee "\$retrievedataref " . dump($retrievedataref);
									my @retrdata = @$retrievedataref; #say $tee "\@retrdata " . dump(@retrdata);
									my $sim = $sims[$countreport]; #say $tee "\$sim-RESFILE" . dump($sim); 
									my $targetprov = $sim;
									$targetprov =~ s/$mypath\///;
									my $result = "$mypath" . "/$targetprov"; #say $tee "\$result " . dump($result); 
									
									#if ( fileno (RETLIST) )
									#if (not (-e $retlist ) )
									#{
									#	if ( $countblock == 0 )
									#	{
											open( RETLIST, ">>$retlist"); # or die;
									#	}
									#	else 
									#	{
									#		open( RETLIST, ">>$retlist"); # or die;
									#	}
									#}
									
									#if ( fileno (RETLIST) ) # SAME LEVEL OF RETLIST. JUST ANOTHER CONTAINER.
									#if (not (-e $retblock ) )
									#{
									#	if ( $countblock == 0 )
									#	{
											open( RETBLOCK, ">>$retblock"); # or die;
									#	}
									#	else 
									#	{
									#		open( RETBLOCK, ">>$retblock"); # or die;
									#	}
									#}
									#say $tee "COUNTREPORT! " . dump([$countreport]);				
									my $reportdata_ref = $reportdata_ref_ref->[$countreport]; #say $tee "\$reportdata_ref" . dump($reportdata_ref); 
									my @reportdata = @$reportdata_ref;  #say $tee "\@reportdata" . dump(@reportdata); 
									
									my $countitem = 0;
									foreach my $item ( @reportdata )
									{
										
										
										my %datarep = %$item; #say $tee "\%datarep" . dump(%datarep); 
										my $reporttitle = $datarep{reporttitle}; #say $tee "\$reporttitle! " . dump($reporttitle); ###DDD HERE
										my $themereport = $datarep{themereport}; #say $tee "\$themereport " . dump($themereport); 
										my $semaphorego1 = $datarep{semaphorego1}; #say $tee "\$semaphorego1 " . dump($semaphorego1); 
										my $semaphorego2 = $datarep{semaphorego2}; #say $tee "\$semaphorego2 " . dump($semaphorego2); 
										my $semaphorestop1 = $datarep{semaphorestop1}; #say $tee "\$semaphorestop1 " . dump($semaphorestop1); 
										my $semaphorestop2 = $datarep{semaphorestop2}; #say $tee "\$semaphorestop2 " . dump($semaphorestop2); 
										my $textpattern = $datarep{textpattern}; #say $tee "\$textpattern " . dump($textpattern); 
										my $afterlines = $datarep{afterlines}; #say $tee "\$afterlines " . dump($afterlines); 
										#my $adhoclines = $datarep{adhoclines}; say $tee "\$adhoclines " . dump($adhoclines); 
										my $retfile = "$resfile-$reporttitle-$themereport.grt"; #say $tee "\$retfile " . dump($retfile); say TOFILE "\$retfile " . dump($retfile); say TOFILE "\$retfile " . dump($retfile);
										
										$retstruct[$countcase][$countblock][ $countinstance ][$counttheme][$countreport][$countitem][$counttool] = $retfile;
										print RETBLOCK "$retfile\n";
										
										if ( not ($retfile ~~ @retcases ) )
										{
											push ( @retcases, $retfile );
											say RETLIST "$retfile";
										}
										
										if ( not ( $retfile ~~ @{ $notecases[ $countcase ][ $countblock ][ $counttool ][ $countinstance ] } ) )
										{
											
											push ( @{ $notecases[ $countcase ][ $countblock ][ $counttool ][ $countinstance ] } , 
																				{
																					retfile => $retfile,
																					reporttitle => $reporttitle,
																					themereport => $themereport,
																					semaphorego1 => $semaphorego1,
																					semaphorego2 => $semaphorego2,
																					semaphorestop1 => $semaphorestop1,
																					semaphorestop2 => $semaphorestop2,
																					textpattern => $textpattern,
																					afterlines => $afterlines,
																					#adhoclines => $adhoclines,
																				} );
										}
										
										unless ( ( $dowhat{inactivateres} eq "y" ) or ( -e $retfile ) )
										{
											say "#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", parameter $countvar at iteration $countstep for tool $tooltype. Instance $countinstance: going to write $retfile.\ ";
												
											if ( $themereport eq "temps" ) 
											{
												 retrieve_temperatures_results( $result, $resfile, \@retrdata, $reporttitle, $themereport, $counttheme, $countreport, $retfile ); 
											}
											elsif ( $themereport eq "comfort"  ) 
											{ 
												retrieve_comfort_results( $result, $resfile, \@retrdata, $reporttitle, $themereport, $counttheme, $countreport, $retfile ); 
											}
											elsif ( ( ( $themereport eq "loads" ) or ( $themereport eq "tempsstats"  ) ) )
											{ 
												retrieve_stats_results( $result, $resfile, \@retrdata, $reporttitle, $themereport, $counttheme, 
															$countreport, $retfile, $semaphorego1, $semaphorego2, $semaphorestop1, $semaphorestop2, $textpattern, $afterlines ); 
											}
											elsif ( ( $themereport eq "radent" ) or ( $themereport eq "radabs" ) or ( $themereport eq "airtemp" ) or ( $themereport eq "radtemp" ) or ( $themereport eq "restemp" ) )
											{ 
												#say $tee "RETRIEVING ADHOC";
												retrieve_adhoc( $result, $resfile, \@retrdata, $reporttitle, $themereport, $counttheme, 
															$countreport, $retfile, $semaphorego1, $semaphorego2, $semaphorestop1, $semaphorestop2, $textpattern, $afterlines ); 
															#$countreport, $retfile, $semaphorego1, $semaphorego2, $semaphorestop1, $semaphorestop2, $textpattern, $afterlines, $adhoclines ); 
											}
										}
										$countitem++;
									}
									$countreport++;
								}
							}
							$counttheme++;
						}
						$counttool++;
					}
					elsif ( ( $tooltype eq "generic" ) or ( $tooltype eq "energyplus" ) )
					{	#use warnings; use strict;
						#say $tee "USING ENERGYPLUS" ;
						my @retfiles = @{ $simstruct[$countcase][$countblock][$countinstance][$counttool] }; #say $tee "SAY\@retfiles " . dump(@retfiles); 
						$retstruct[$countcase][$countblock][$countinstance][$counttool]  = $simstruct[$countcase][$countblock][$countinstance][$counttool] ; 
						my $counttheme = 0;
						foreach my $retrievedatum ( @{ $retrievedata{$counttool} } )
						{
							my $reportdata_ref_ref__ = $reportdata{$counttool}; #say $tee "\$reportdata_ref_ref__ " . dump($reportdata_ref_ref__);
							my @retrievedatarefs = @{$retrievedatum}; #say $tee "\@retrievedatarefs " . dump(@retrievedatarefs);
							my $simtitle = $simtitles{$counttool}->[ $counttheme ][0]; #say $tee "\$simtitle " . dump($simtitle);
							my @sims = @{ $simtitles{$counttool}->[ $counttheme ] }[1..4]; #say $tee "\@sims " . dump(@sims);
							
							my $resfile = $resfiles[ $counttheme ]; #say $tee "\HERE\$resfile " . dump($resfile);
							
							
							my $countpart = 0;
							foreach ( @$reportdata_ref_ref__ )
							{
								$reportdata_ref_ref = $reportdata{$counttool}->[$countpart];
							
							
							
								if ( -e $resfile ) 
								{
									

									my @retrdata = @$retrievedataref; #say $tee "\@retrdata " . dump(@retrdata);
					
									open( RETLIST, ">>$retlist"); # or die;
									open( RETBLOCK, ">>$retblock"); # or die;
																					
									my $reportdata_ref = $reportdata_ref_ref->[$countreport]; #say $tee "\$reportdata_ref" . dump($reportdata_ref); 
									my @reportdata = @$reportdata_ref;  #say $tee "\@reportdata" . dump(@reportdata); 
									@retcases = uniq( @retcases );
									my $retfile = "$resfile"; #say $tee "\$retfile " . dump($retfile); 
									if ( not ($retfile ~~ @retcases ) )
									{
										push ( @retcases, $retfile );
										say RETLIST "$retfile";
									}
									my @provbag;
									
									push ( @provbag, $retfile );
										
									my $countitem = 0;
									foreach my $item ( @reportdata )
									{
										my %datarep = %$item; #say $tee "\%datarep" . dump(%datarep); 
										my $reporttitle = $datarep{reporttitle}; #say $tee "\$reporttitle! " . dump($reporttitle); ###DDD HERE
										my $themereport = $datarep{themereport}; #say $tee "\$themereport " . dump($themereport); 
										my $semaphorego1 = $datarep{semaphorego1}; #say $tee "\$semaphorego1 " . dump($semaphorego1); 
										my $semaphorego2 = $datarep{semaphorego2}; #say $tee "\$semaphorego2 " . dump($semaphorego2); 
										my $semaphorestop1 = $datarep{semaphorestop1}; #say $tee "\$semaphorestop1 " . dump($semaphorestop1); 
										my $semaphorestop2 = $datarep{semaphorestop2}; #say $tee "\$semaphorestop2 " . dump($semaphorestop2); 
										my $textpattern = $datarep{textpattern}; #say $tee "\$textpattern " . dump($textpattern); 
										my $afterlines = $datarep{afterlines}; #say $tee "\$afterlines " . dump($afterlines);  
										#say TOFILE "\$retfile " . dump($retfile); say TOFILE "\$retfile " . dump($retfile);
										
										print RETBLOCK "$retfile\n";
		
										
										#if ( not ( $retfile ~~ @provbag ) ) 
										#{
											
											push ( @{ $notecases[ $countcase ][ $countblock ][ $counttool ][ $countinstance ] } , 
																				{
																					retfile => $retfile,
																					reporttitle => $reporttitle,
																					themereport => $themereport,
																					semaphorego1 => $semaphorego1,
																					semaphorego2 => $semaphorego2,
																					semaphorestop1 => $semaphorestop1,
																					semaphorestop2 => $semaphorestop2,
																					textpattern => $textpattern,
																					afterlines => $afterlines
																				} );
										#}
										$countitem++;
									}


								}
								else  
								{ 
									say "A RESULT FILE NAMED $resfile DOES NOT EXIST. EXITING.";
								}
								
							
							
								$countpart++;
							}
							
							
							
							$counttheme++;
						}
						$counttool++;
					}
				}	
			}
		}
		$countinstance++;
	}
	
	print `rm -f $mypath/*.par`;
	print TOFILE "rm -f $mypath/*.par\n";
	close OUTFILE;
	close TOFILE;
	close RETLIST;
	close RETBLOCK;
	#say $tee "INEXIT \@retcases " . dump( @retcases ); 
	#say $tee "\@retstruct " . dump( @retstruct ); 
	say $tee "\@notecases " . dump( @notecases ); 
	return ( \@retcases, \@retstruct, \@notecases );
}	# END SUB RETRIEVE


sub report # This function retrieves the results of interest from the texts files created by the "retrieve" function
{
	my $swap = shift; #say TOFILE "swapINDESCEND: " . dump($swap);
	my %dat = %$swap;
	my @instances = @{ $dat{instances} }; #say "scalar(\@instances): " . scalar(@instances);
	my $countcase = $dat{countcase}; #say "dump(\$countcase): " . dump($countcase); # IT WILL BE SHADOWED. CUT ZZZ
	my $countblock = $dat{countblock}; #say "dump(\$countblock): " . dump($countblock); # IT WILL BE SHADOWED. CUT ZZZ		
	my %dirfiles = %{ $dat{dirfiles} }; #say "dump(\%dirfiles): " . dump(%dirfiles); 
		
	$configfile = $main::configfile; #say "dump(\$configfile): " . dump($configfile);
	@sweeps = @main::sweeps; #say "dump(\@sweeps): " . dump(@sweeps);
	@varinumbers = @main::varinumbers; #say "dump(\@varinumbers): " . dump(@varinumbers);
	@mediumiters = @main::mediumiters;
	@rootnames = @main::rootnames; #say "dump(\@rootnames): " . dump(@rootnames);
	%vals = %main::vals; #say "dump(\%vals): " . dump(%vals);
	
	$mypath = $main::mypath;  #say TOFILE "dumpINDESCEND(\$mypath): " . dump($mypath);
	$exeonfiles = $main::exeonfiles; #say TOFILE "dumpINDESCEND(\$exeonfiles): " . dump($exeonfiles);
	$generatechance = $main::generatechance; 
	$file = $main::file;
	$preventsim = $main::preventsim;
	$fileconfig = $main::fileconfig; #say TOFILE "dumpINDESCEND(\$fileconfig): " . dump($fileconfig); # NOW GLOBAL. TO MAKE IT PRIVATE, FIX PASSING OF PARAMETERS IN CONTRAINTS PROPAGATION SECONDARY SUBROUTINES
	$outfile = $main::outfile;
	$tofile = $main::tofile;
	$report = $main::report;
	$simnetwork = $main::simnetwork;
	
	$tee = new IO::Tee(\*STDOUT, ">>$tofile"); # GLOBAL ZZZ
	
	#open( OUTFILE, ">>$outfile" ) or die "Can't open $outfile: $!"; 
	open( TOFILE, ">>$tofile" ) or die "Can't open $tofile: $!";  
	say $tee "\nNow in Sim::OPT::Report::report.\n";
	#say TOFILE "\n#Now in Sim::OPT::Report::report.\n";
	
	%dowhat = %main::dowhat;

	%simtitles = %main::simtitles; #say $tee "dumpINRETRIEVE(\%simtitles): " . dump(%simtitles);
	%retrievedata = %main::retrievedata;
	@keepcolumns = @main::keepcolumns;
	@weights = @main::weights;
	@weightsaim = @main::weightsaim;
	@varthemes_report = @main::varthemes_report;
	@varthemes_variations = @vmain::arthemes_variations;
	@varthemes_steps = @main::varthemes_steps;
	@rankdata = @main::rankdata; # CUT ZZZ
	@rankcolumn = @main::rankcolumn;
	%reportdata = %main::reportdata; #say $tee "dump(\%reportdata): " . dump(%reportdata);
	@files_to_filter = @main::files_to_filter;
	@filter_reports = @main::filter_reports;
	@base_columns = @main::base_columns;
	@maketabledata = @main::maketabledata;
	@filter_columns = @main::filter_columns;
	%notecases = %main::notecases;
	
	my @simcases = @{ $dirfiles{simcases} }; #say "dump(\@simcases): " . dump(@simcases);
	my @simstruct = @{ $dirfiles{simstruct} }; #say "dump(\@simstruct): " . dump(@simstruct);
	my @INREPORT = @{ $dirfiles{morphcases} };
	my @morphstruct = @{ $dirfiles{morphstruct} };
	my @retcases = @{ $dirfiles{retcases} }; #say TOFILE "dumpINREPORT::report(\@retcases): " . dump(@retcases); 
	my @retstruct = @{ $dirfiles{retstruct} }; #say TOFILE "dumpINREPORT::report(\@retstruct): " . dump(@retstruct);
	my @repcases = @{ $dirfiles{repcases} };
	my @repstruct = @{ $dirfiles{repstruct} };
	my @mergecases = @{ $dirfiles{mergecases} };
	my @mergestruct = @{ $dirfiles{mergestruct} };
	my @descendcases = @{ $dirfiles{descendcases} };
	my @descendstruct = @{ $dirfiles{descendstruct} };
	my @notecases = @{ $dirfiles{notecases} }; #say TOFILE "dumpINREPORT::report(\@notecases): " . dump(@notecases);
	
	my $morphlist = $dirfiles{morphlist}; #say "dump(\$dat{morphlist}): " . dump($dat{morphlist});
	my $morphblock = $dirfiles{morphblock};
	my $simlist = $dirfiles{simlist}; #say "dump(\$simlist): " . dump($simlist);
	my $simblock = $dirfiles{simblock};
	my $retlist = $dirfiles{retlist}; #say TOFILE "dumpINREPORT::report(\$retlist): " . dump($retlist); 
	my $retblock = $dirfiles{retblock};
	my $replist = $dirfiles{replist};
	my $repblock = $dirfiles{repblock};
	my $descendlist = $dirfiles{descendlist};
	my $descendblock = $dirfiles{descendblock};
	
	my @repfilemem;
	my @linecontent;
	$" = " ";
	my $repfile;
	#my @convey;
	my $countinstance = 0;
	foreach my $instance ( @instances )
	{
		
		my %d = %{$instance};
		my $countcase = $d{countcase}; #say TOFILE "dump(\$countcase): " . dump($countcase);
		my $countblock = $d{countblock}; #say TOFILE "dump(\$countblock): " . dump($countblock);
		my @miditers = @{ $d{miditers} }; #say TOFILE "dump(\@miditers): " . dump(@miditers);
		my @winneritems = @{ $d{winneritems} }; #say TOFILE "dumpIN( \@winneritems) " . dump(@winneritems);
		my $countvar = $d{countvar}; #say TOFILE "dump(\$countvar): " . dump($countvar);
		my $countstep = $d{countstep}; #say TOFILE "dump(\$countstep): " . dump($countstep);						
		my $to = $d{to}; #say TOFILE "dump(\$to): " . dump($to);
		my $origin = $d{origin}; #say TOFILE "dump(\$origin): " . dump($origin);
		my @uplift = @{ $d{uplift} }; #say TOFILE "dump(\@uplift): " . dump(@uplift);
		my $rootname = Sim::OPT::getrootname(\@rootnames, $countcase); #say TOFILE "dump(\$rootname): " . dump($rootname);
		my @blockelts = Sim::OPT::getblockelts(\@sweeps, $countcase, $countblock); #say TOFILE "dumpIN( \@blockelts) " . dump(@blockelts);
		my @blocks = Sim::OPT::getblocks(\@sweeps, $countcase);  #say TOFILE "dumpIN( \@blocks) " . dump(@blocks);
		my $toitem = Sim::OPT::getitem(\@winneritems, $countcase, $countblock); #say TOFILE "dump(\$toitem): " . dump($toitem);
		my $from = Sim::OPT::getline($toitem); #say TOFILE "dumpIN(\$from): " . dump($from);
		my %varnums = Sim::OPT::getcase(\@varinumbers, $countcase); #say TOFILE "dumpIN---(\%varnums): " . dump(%varnums); 
		my %mids = Sim::OPT::getcase(\@miditers, $countcase); #say TOFILE "dumpIN---(\%mids): " . dump(%mids); 
		
		my $stepsvar = Sim::OPT::getstepsvar($countvar, $countcase, \@varinumbers); #say TOFILE "dump(\$stepsvar): " . dump($stepsvar); 
		my $varnumber = $countvar; #say TOFILE "dump---(\$varnumber): " . dump($varnumber) . "\n\n";  # LEGACY VARIABLE

		say $tee "#Processing reports for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", instance " . ($countinstance + 1);
		
		open( REPLIST, ">>$replist" ) or die( "$!" ); #say TOFILE "dump---(\$replist): " . dump($replist) . "\n\n";  
		open( REPBLOCK, ">>$repblock" ) or die( "$!" ); #say TOFILE "dump---(\$repblock): " . dump($repblock) . "\n\n";
		
		unless ( ( "$^O" eq "MSWin32" ) or ( "$^O" eq "MSWin64" ) ) 
		{
			$repfile = "$mypath/$file-report-$countcase-$countblock.txt";  #say TOFILE "dump---(\$repfile): " . dump($repfile) . "\n\n";
		}
		else
		{
			$repfile = "$mypath\\$file-report-$countcase-$countblock.txt";  #say TOFILE "dump---(\$repfile): " . dump($repfile) . "\n\n";
		}
		
		open( REPFILE, ">>$repfile") or die "Can't open $repfile $!";
		@repcases = uniq( @repcases );
		
		say REPBLOCK "$repfile";
		if ( not ( $repfile ~~ @repcases ) )
		{
			push ( @repcases, $repfile );
			say REPLIST "$repfile";
		}
		
		if ( not ( $repfile ~~ @{ $repstruct[$countcase][$countblock] } ) )
		{
			push ( @{ $repstruct[$countcase][$countblock] }, $repfile );
		}
		my $signalnewinstance = 1;
		
		#open( REPFILE, ">>$repfile") or die "Can't open $repfile $!";
		
		#say $tee "INREPORT dump---(\@notecases): " . dump( @notecases ) . "\n\n";  
		
		my $numberof_simtools = scalar ( keys %{ $dowhat{simtools} } ); #say $tee "\$numberof_simtools " . dump( $numberof_simtools );
		#my @mergestruct;
		my $counttool = 1;
		while ( $counttool <= $numberof_simtools )
		{	
			#uniq( @{ $notecases[ $countcase ][ $countblock ][ $counttool ][ $countinstance ] } );
			my $skip = $vals{$countvar}{$counttool}{skip}; #say $tee "dumpinsim(\$skip): " . dump($skip);
			if ( not ( eval ( $skipsim{$counttool} )))
			{
				my $tooltype = $dowhat{simtools}{$counttool}; #say $tee "\$tooltype " . dump( $tooltype );
				#@{ $notecases[ $countcase ][ $countblock ][ $counttool ][ $countinstance ] } = uniq( @{ $notecases[ $countcase ][ $countblock ][ $counttool ][ $countinstance ] }  );
				#say $tee "\$notecases[ \$countcase ][ \$countblock ][ \$countinstance ][ \$counttool ] } : " . dump( $notecases[ $countcase ][ $countblock ][ $countinstance ][ $counttool ] );
				
				#foreach $ret_ref ( sort { $a->{retfile} <=> $b->{retfile} } ( @{ $notecases[ $countcase ][ $countblock ][ $counttool ][ $countinstance ] } ) )
				foreach $ret_ref ( ( @{ $notecases[ $countcase ][ $countblock ][ $counttool ][ $countinstance ] } ) )
				{
					
					#say $tee "INREPORT \$ret_ref " . dump( $ret_ref );
					%retitem = %$ret_ref; #say $tee "dump---(\@retitem): " . dump(@retitem) . "\n\n";  
					my $retfile = $retitem{retfile}; #say $tee "dump---(\$retfile): " . dump($retfile) . "\n\n";  
					my $reporttitle = $retitem{reporttitle}; #say $tee "dump---(\$reporttitle): " . dump($reporttitle) . "\n\n";  
					my $themereport = $retitem{themereport}; #say $tee "dump---(\$themereport): " . dump($themereport) . "\n\n";  
					my $semaphorego1 = $retitem{semaphorego1}; #say $tee "dump---(\$semaphorego1): " . dump($semaphorego1) . "\n\n";  
					my $semaphorego2 = $retitem{semaphorego2}; #say $tee "dump---(\$semaphorego2): " . dump($semaphorego2) . "\n\n";  
					my $semaphorestop1 = $retitem{semaphorestop1}; #say $tee "dump---(\$semaphorestop1): " . dump($semaphorestop1) . "\n\n";
					my $semaphorestop2 = $retitem{semaphorestop2}; #say $tee "dump---(\$semaphorestop2): " . dump($semaphorestop2) . "\n\n";  
					my $textpattern = $retitem{textpattern}; #say $tee "dump---(\$textpattern): " . dump($textpattern) . "\n\n";  
					my $afterlines = $retitem{afterlines}; #say $tee "INREPORT dump---(\$afterlines): " . dump($afterlines) . "\n\n";  
					#my $adhoclines = $retitem{adhoclines}; #say $tee "dump---(\$adhoclines): " . dump($adhoclines) . "\n\n";
					
					if ( $signalnewinstance == 1 )
					{
						push ( @{ $mergestruct[$countcase][$countblock][$countinstance] }, "$retfile " );
						$signalnewinstance--;
					}
					
					my ( $semaphore1, $semaphore2 );
					
					if ( -e $retfile ) #if ( not ( eval ( $skipreport ) ) )
					{	say $tee "#Inspecting results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", instance " . ($countinstance + 1) . ", file $retfile, to report $themereport." ;
						open( RETFILE, "$retfile" ) or die( "$!" );
						my @lines = <RETFILE>;
						close RETFILE;
						#say TOFILE "RETFILE! " ;
						my $countline = 0;
						my $signalhit = 0;
						my $foundhit = 0;
						my $countlin = 0;
						my $countli = 0;
						foreach my $line ( @lines )
						{
							$line =~ s/^\s+//;
							chomp( $line ); 
							#$line = $line . " ";
							#say TOFILE "\$line: $line";
							
							if ( ( not ( defined( $semaphorego1 ) ) ) or ( $semaphorego1 eq "" ) or ( $line =~ m/$semaphorego1/ ) )
							{
								$semaphore1 = "on";  #say $tee "ON1: ";
							}
							
							if ( $semaphore1 eq "on" )
							{
								if ( ( not ( defined( $semaphorego2 ) ) ) or ( $semaphorego2 eq "" ) or ( $line =~ m/$semaphorego2/ ) )
								{
									$semaphore2 = "on"; #say $tee "ON2: ";
								}
							}
														
							if ( ( $line =~ m/$semaphorestop1/ ) and ( defined( $semaphorestop1 ) ) and ( $semaphorestop1 ne "" ) )
							{
								$semaphore1 = "off"; #say $tee "OFF1: ";
							}
							
							if ( ( $line =~ m/$semaphorestop2/ ) and ( defined( $semaphorestop2 ) ) and ( $semaphorestop2 ne "" ) )
							{
								$semaphore2 = "off"; #say $tee "OFF2: ";
							}
						
							chomp( $line ); chomp( $line ); 
							#$line = $line . " ";
							
							if ( ( not ( defined ( $afterlines ) ) ) or ( $afterlines eq "" ) )
							{
								#say $tee "NOT DEFINED AFTERLINES FOR \$themereport $themereport";
								if ( ( $textpattern ne "" ) and ( $line =~ m/^$textpattern/ ) and ( $semaphore1 eq "on" ) and ( $semaphore2 eq "on" ) )
								{	#print $tee "HIT REPORT1! "; #say TOFILE $line;
									chomp( $line ); chomp( $line ); 
									if ( $foundhit == 0 )
									{	
										push ( @{ $mergestruct[$countcase][$countblock][ $countinstance ] }, "$themereport,$line" );
									}
									else
									{
										push ( @{ $mergestruct[$countcase][$countblock][ $countinstance ] }, $line );
									}
									$foundhit++;
								}
							}
							else
							{
								#print $tee "AFTERLINES ARE DEFINED FOR \$themereport $themereport ";
								if ( ( $textpattern ne "" ) and ( $line =~ m/^$textpattern/ ) and ( $semaphore1 eq "on" ) and ( $semaphore2 eq "on" ) )
								{	#print TOFILE "HIT REPORT1! "; #say TOFILE $line;
									$signalhit++;
								}
								
								if ( ( $semaphore1 eq "on" ) and ( $semaphore2 eq "on" ) and ( $signalhit > 0 ) )
								{
									#print TOFILE "WORKING FOR A SIGNALLED HIT "; #say TOFILE $line;
									if ( not ( ref( $afterlines ) ) )
									{	#say $tee "NOT REF BUT DEFINED AFTERLINES FOR \$themereport $themereport";
										if ( ( $afterlines ne "" ) and ( $countline == ( $afterlines - 1) ) )
										{	#print TOFILE "HIT REPORT2! "; #say TOFILE $line;
											chomp( $line );
											push ( @{ $mergestruct[$countcase][$countblock][ $countinstance ] }, "$themereport,$line" );
											$countli++;
										}
									}
									else
									{	#say $tee "REF AND DEFINED AFTERLINES FOR \$themereport $themereport";
										my @afterlins = @$afterlines;  #say $tee "\@afterlins " . dump( @afterlins );
										my @bringer;
										foreach my $afterlin ( @afterlins )
										{	#say $tee "FOREACH \$afterlin: $afterlin";
											if ( not ( $afterlin =~ /-/ ) )
											{
												push ( @bringer, $afterlin );
											}
											else
											{
												#say $tee "SPLITTING \$afterlin: $afterlin";
												my ( $count, $endel ) = split( /-/, $afterlin );
												while ( $count <= $endel )
												{
													push ( @bringer, $count );
													$count++;
												}
											}
											
											my $countlocal = 0;
											foreach my $afterl ( @bringer )
											{
												#say $tee "NOW USING \@bringer @bringer";
												if ( $countline == ( $afterl - 1 ) )
												{
													chomp( $line );
													if ( $countlocal == 0 )
													{
														push ( @{ $mergestruct[$countcase][$countblock][ $countinstance ] }, "$themereport,$line" );
													}
													else
													{
														push ( @{ $mergestruct[$countcase][$countblock][ $countinstance ] }, $line );
													}
												}
												$counlin++;
												$countlocal++;
											}
										}
									}
								}
							}
							$countline++; #say TOFILE "ON3 COUNTLINE: $countline";
						}
					}
					else 
					{ 
						open ( NOTFOUND, ">>./notfound.txt" ) or die $! ;
						say NOTFOUND $retfile;
						#say $tee "CAN'T FIND NO RES FILE $retfile TO OPEN" and die $!; 
					}
				}
			}
			$counttool++;
		}
		#say $tee "\@mergestruct: " . dump(@mergestruct); 
		say $tee "\@{ \$mergestruct[\$countcase][\$countblock][\$countinstance] } : " . dump(@{ $mergestruct[$countcase][$countblock][ $countinstance ] });
		
		unless ( $dowhat{inactivateret} eq "y" )
		{
			
			foreach my $thing ( @{ $mergestruct[$countcase][$countblock][ $countinstance ] } )
			{
				$thing =~ s/\n/ /g ; $thing =~ s/\n/ /g ; $thing =~ s/\r/ /g ; $thing =~ s/\r/ /g ;
				$thing =~ s/\r\n/ /g; $thing =~ s/\r\n/ /g;
				print REPFILE $thing;
				print REPFILE ",";
			}
			print REPFILE "\n";
		
		#my $lin;
		#foreach my $thing ( @{ $mergestruct[$countcase][$countblock][ $countinstance ] } )
		#{
		#	$thing =~ s/\n/ /g ; 
		#	$lin = $lin . $thing . " ";
		#}
		#push ( @{ $convey[ $countcase ][ $counblock ] }, $lin );
			say "#Reporting results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", parameter $countvar at iteration $countstep. Instance $countinstance: writing $repfile. ";
		}
		$countinstance++;
	}
	
	#if ( @repfilemem ~~ @mergecases ) 
	#{ 
	#	push ( @mergecases,  @repfilemem );
	#}
	#say TOFILE "\@repfilemem ~~ \@mergecases.";
	
	#foreach ( sort ( @{ $convey[ $countcase ][ $counblock ] } ) )
	#{
		print REPFILE "$_\n"; #say TOFILE " INSTANCE " . dump($_);
	#}
	
	close REPFILE;
		
	#say TOFILE "HEREIS \@repcases " . dump(@repcases); say TOFILE "\@repstruct " . dump(@repstruct); say TOFILE "\@mergestruct " . dump(@mergestruct);
	#say TOFILE "\@mergecases " . dump(@mergecases); say TOFILE "\$repfile: " . dump($repfile);
	close TOFILE;
	close OUTFILE;
	return ( \@repcases, \@repstruct, \@mergestruct, \@mergecases, $repfile ); 
} # END SUB report;

sub get_files # UNUSED. LEGACY. CUT.
{
	say $tee "Extracting statistics for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", instance: " . ( $countinstance + 1);
	my ( $themereport, $countcase, $countblock, $counttheme, $countreport, $retfile, $repfile, 
		$simtitle, $reporttitle, $simdatum, $retrievsref, $countinstance, $swap, $loadsortemps ) = @_;
		
	#say TOFILE "#CALLED-REPSTRUCT " . dump(@repstruct); # ZZZ	
	#say TOFILE "CALLED-\$themereport: " . dump($themereport);
	#say TOFILE "CALLED-\$countcase: " . dump($countcase);
	#say TOFILE "CALLED-\$countblock: " . dump($countblock);
	#say TOFILE "CALLED-\$themereport " . dump($themereport);
	#say TOFILE "CALLED-\$counttheme " . dump($counttheme);
	#say TOFILE "CALLED-\$countreport " . dump($countreport);
	#say TOFILE "CALLED-\$retfile: " . dump($retfile);
	#say TOFILE "CALLED-\$repfile: " . dump($repfile);
	#say TOFILE "CALLED-\$loadsortemps " . dump($loadsortemps);
	#say TOFILE "repfilemem CALLED " . dump( @repfilemem );
				
	my @repfilemem = @$swap; #say TOFILE "CALLED-\@repfilemem " . dump(@repfilemem);
	my @retrievs = @$retrievsref;
	
	my @measurements_to_report = $retrievs[0]; #say TOFILE "CALLED-\@measurements_to_report " . dump(@measurements_to_report);
	my $dates_to_report = $simtitle; #say TOFILE "CALLED-\$dates_to_report " . dump($dates_to_report);
	
	#say TOFILE "CALLED\$loadsortemps: " . $loadsortemps; say TOFILE "\$retfile! " . $retfile;
	open( RETFILE,  "$retfile" ) or die "Can't open $retfile $!";
	my @lines_to_inspect = <RETFILE>; #say TOFILE "CALLED-\@lines_to_inspect " . dump(@lines_to_inspect);

	my @countcolumns;
	my $countzones = 0;
	my $countlines = 0;
	foreach my $line_to_inspect (@lines_to_inspect) 
	{
		if ( $line_to_inspect )
		{
			
			$line_to_inspect =~ s/^\s+//g;### DO THIS? ZZZ
			$line_to_inspect =~ s/\s*$//;      #remove trailing whitespace
			#$line_to_inspect =~ s/\ {2,}/ /g;  #remove multiple literal spaces
			$line_to_inspect =~ s/\t{2,}/\t/g; #say TOFILE "line_to_inspect: $line_to_inspect";		 
			
			if ( $themereport eq "temps" ) # NEVER CHECKED IF IT STILL WORKS AFTER SOME USES
			{
				my @roww = split( /\s+/, $line_to_inspect );
				if ( $countlines == 1 )
				{
					$file_and_period = $roww[5];
				} 
				elsif ( $countlines == 3 )
				{
					my $countcolumn = 0;
					foreach $elt_of_row (@roww)
					{    #
						foreach $column (@columns_to_report)
						{
							if ( $elt_of_row eq $column )
							{
								push @countcolumns, $countcolumn;
								if ( $elt_of_row eq $columns_to_report[0] )
								{
									$title_of_column = "$elt_of_row";
								} else
								{
									$title_of_column =  "$elt_of_row-" . "$file_and_period";
								}
								push ( @{ $repfilemem[$countinstance] }, "$title_of_column\t" );
							}
						}
						$countcolumn = $countcolumn + 1;
					}
					#push ( @{ $repfilemem[$countlines] }, "\n" );
				} 
				elsif ( $countlines > 3 )
				{
					foreach $columnumber (@countcolumns)
					{
						if ( $columnumber =~ /\d/ )
						{
							push ( @{ $repfilemem[$countinstance] }, "$roww[$columnumber]\t" );
						}
					}
					#push ( @{ $repfilemem[$countlines] }, "\n" );
				}
				$countlines++;
			}
			
			if ( $themereport eq "comfort" ) # NEVER CHECKED IF IT STILL WORKS AFTER SOME USES
			{				
				my @roww = split( /\s+/, $line_to_inspect );

				if ( $countlines == 1 )
				{
					$file_and_period = $roww[5];
				} 
				elsif ( $countlines == 3 )
				{
					my $countcolumn = 0;
					foreach $elt_of_row (@roww)
					{    #
						foreach $column (@columns_to_report)
						{
							if ( $elt_of_row eq $column )
							{
								push @countcolumns, $countcolumn;
								if ( $elt_of_row eq $columns_to_report[0] )
								{
									$title_of_column = "$elt_of_row";
								} 
								else
								{
									$title_of_column =
									  "$elt_of_row-" . "$file_and_period";
								}
								push ( @{ $repfilemem[$countinstance] }, "$title_of_column\t" );
							}
						}
						$countcolumn = $countcolumn + 1;
					}
					#push ( @{ $repfilemem[$countlines] }, "\n" );
				} 
				elsif ( $countlines > 3 )
				{
					foreach $columnumber (@countcolumns)
					{
						if ( $columnumber =~ /\d/ )
						{
							push ( @{ $repfilemem[$countinstance] }, "$roww[$columnumber]\t" );
						}
					}
					#push ( @{ $repfilemem[$countlines] }, "\n" );
				}
				$countlines++;
			}
			
			my $line_to_report;
			#say TOFILE "\$loadsortemps: $loadsortemps";
			if ( ( $themereport eq "loads" ) or ( $themereport eq "tempsstats" ) ) 
			{	
				if ( $line_to_inspect =~ /^$loadsortemps/ )
				{
					$line_to_report = "$retfile " . " $themereport $reporttitle " . $line_to_inspect . " " ;
					$line_to_report =~ s/--//g;
					$line_to_report =~ s/\s+/ /g;  #remove multiple literal spaces
					$line_to_report =~ s/ /,/g;  #remove multiple literal spaces
					push ( @{ $repfilemem[$countinstance] }, $line_to_report );
				}
				$countlines++;
			}
		}
	}
	#say TOFILE "LEAVING \@repfilemem " . dump(@repfilemem);
	return (@repfilemem); 
} # END SUB get_files

1;

__END__

=head1 NAME

Sim::OPT::Report.

=head1 SYNOPSIS

  use Sim::OPT;
  opt;

=head1 DESCRIPTION

Sim::OPT::Report is the module used by Sim::OPT to retrieve simulation results. Sim::OPT::Report performs two kinds of action. The first, which is required only by certain simulation programs, is that of making the simulation program write the results in a user-specified text format. This functionality is platform-specific and is presently implemented only for ESP-r (EnergyPlus does not require that). The second functionality is that of gathering the results in a user-specified manner. That functionality is based on pattern-matching and is not simulation-program-specific.

=head2 EXPORT

"retrieve" "report".

=head1 SEE ALSO

Two annotated examples ("esp.pl" for ESP-r and "ep.pl" for EnergyPlus) can be found packed in the "optw.tar.gz" file in "examples" directory in this distribution. They constitute the available documentation. Additionally, reference to the source code may be made.

=head1 AUTHOR

Gian Luca Brunetti, E<lt>gianluca.brunetti@polimi.itE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008-2015 by Gian Luca Brunetti and Politecnico di Milano. This is free software.  You can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2 or later.


=cut
