#
# (c) Jan Gehring <jan.gehring@gmail.com>
#
# vim: set ts=2 sw=2 tw=0:
# vim: set expandtab:

package Rex::Test::Base::has_service_running;

use strict;
use warnings;

our $VERSION = '1.3.3_04'; # TRIAL VERSION

use Rex -base;
use base qw(Rex::Test::Base);

sub new {
  my $that  = shift;
  my $proto = ref($that) || $that;
  my $self  = {@_};

  bless( $self, $proto );

  my ( $pkg, $file ) = caller(0);

  return $self;
}

sub run_test {
  my ( $self, $service ) = @_;
  local $::QUIET = 1;
  $self->ok( service( $service, "status" ) == 1, "Service $service running." );
}

1;
