#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MP',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 56 => 0x69 },
	'about' => { 218 => 'about' },
	'abspeakaudiofilepath' => { 223 => 'absPeakAudioFilePath' },
	'accessorytype' => { 168 => 0x53 },
	'actionadvised' => { 67 => 0x2a },
	'activearea' => { 61 => 0xc68d },
	'actived-lighting' => { 125 => 0x22, 143 => 0x24 },
	'actived-lightingmode' => { 143 => 0x25 },
	'addaspectratioinfo' => { 38 => 0x80e },
	'additionalmodelinformation' => { 211 => 'AdditionalModelInformation' },
	'addoriginaldecisiondata' => { 38 => 0x80f, 39 => 0x11, 40 => 0x13, 43 => 0x14 },
	'address' => { 91 => 'Address' },
	'adjustmentmode' => { 193 => [0x15,0x22] },
	'adultcontentwarning' => { 214 => 'AdultContentWarning', 217 => 'adultContentWarning' },
	'advancedraw' => { 145 => 0x76a43203 },
	'advancedscenemode' => { 168 => 0x3d },
	'advisory' => { 221 => 'Advisory' },
	'ae_iso' => { 170 => 0x2 },
	'aeaperture' => { 170 => 0x1 },
	'aebautocancel' => { 38 => 0x104 },
	'aebbracketvalue' => { 35 => 0x11 },
	'aebsequence' => { 38 => 0x105 },
	'aebsequenceautocancel' => { 36 => 0x9, 37 => 0x9, 39 => 0x8, 40 => 0x9, 43 => 0x9, 44 => 0x7 },
	'aebshotcount' => { 38 => 0x106 },
	'aebxv' => { 170 => 0x4 },
	'aeexposuretime' => { 170 => 0x0 },
	'aeextra' => { 170 => 0x7 },
	'aelock' => { 133 => '733.2', 134 => '752.2', 152 => 0x201, 181 => 0x48 },
	'aelockbutton' => { 133 => '733.1', 134 => '752.1' },
	'aemaxaperture' => { 170 => 0x9 },
	'aemaxaperture2' => { 170 => 0xa },
	'aemeteringmode' => { 170 => 0xc },
	'aemeteringsegments' => { 181 => 0x209 },
	'aeminaperture' => { 170 => 0xb },
	'aeminexposuretime' => { 170 => 0x5 },
	'aeprogrammode' => { 170 => 0x6 },
	'aesetting' => { 14 => 0x21 },
	'aexv' => { 170 => 0x3 },
	'af-cpriorityselection' => { 132 => '791.1' },
	'af-onformb-d10' => { 132 => '793.1' },
	'af-spriorityselection' => { 132 => '791.2' },
	'afactivation' => { 132 => '792.1' },
	'afadjustment' => { 181 => 0x72 },
	'afaperture' => { 123 => 0x5, 124 => 0x5 },
	'afarea' => { 194 => 0x11 },
	'afareaillumination' => { 134 => '763.3' },
	'afareamode' => { 108 => 0x0, 109 => 0x5, 134 => 0x2fc },
	'afareamodesetting' => { 133 => 0x2e4 },
	'afareas' => { 152 => 0x304 },
	'afassist' => { 36 => 0x5, 44 => 0x5, 133 => '729.2', 134 => '748.2' },
	'afassistbeam' => { 38 => 0x50e, 39 => 0x4, 40 => 0x5, 41 => 0x4, 42 => 0x4, 43 => 0x5 },
	'afassistilluminator' => { 132 => '792.4' },
	'afassistlamp' => { 168 => 0x31 },
	'afdefocus' => { 171 => 0x6 },
	'afduringliveview' => { 38 => 0x511 },
	'affinetuneadj' => { 132 => 0x2d1 },
	'afintegrationtime' => { 171 => 0x7 },
	'afmicroadjactive' => { 1 => 0x1 },
	'afmicroadjustment' => { 38 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2 },
	'afmode' => { 168 => 0xf, 193 => 0x5 },
	'afonaelockbuttonswitch' => { 38 => 0x702 },
	'afpoint' => { 14 => 0x13, 57 => 0x18, 108 => 0x1, 155 => 0x308 },
	'afpointactivationarea' => { 37 => 0x11, 43 => 0x11 },
	'afpointareaexpansion' => { 38 => 0x508 },
	'afpointautoselection' => { 38 => 0x50b },
	'afpointbrightness' => { 38 => 0x50d },
	'afpointdisplayduringfocus' => { 38 => 0x50c },
	'afpointillumination' => { 37 => 0xa, 132 => '792.3' },
	'afpointmode' => { 174 => 0x3 },
	'afpointposition' => { 58 => 0x2021, 168 => 0x4d },
	'afpointregistration' => { 36 => 0x7 },
	'afpoints' => { 102 => 0x10 },
	'afpointselected' => { 181 => 0xe },
	'afpointselected2' => { 174 => 0x4 },
	'afpointselection' => { 37 => 0xb, 132 => '791.3' },
	'afpointselectionmethod' => { 38 => 0x50f, 39 => 0xc, 40 => 0xd, 43 => 0xd },
	'afpointsinfocus' => { 35 => 0xe, 108 => 0x2, 171 => 0xb, 181 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 11 => 0x38 },
	'afpointspotmetering' => { 37 => 0xd },
	'afpointsunknown1' => { 171 => 0x0 },
	'afpointsunknown2' => { 171 => 0x2 },
	'afpointsused' => { 109 => 0x8 },
	'afpredictor' => { 171 => 0x4 },
	'afresponse' => { 125 => 0xad },
	'afresult' => { 157 => 0x1038 },
	'afsearch' => { 152 => 0x303 },
	'aggregationtype' => { 215 => 'aggregationType' },
	'agreement' => { 217 => 'agreement' },
	'aiservocontinuousshooting' => { 37 => 0x15 },
	'aiservoimagepriority' => { 38 => 0x503 },
	'aiservotrackingmethod' => { 38 => 0x504 },
	'aiservotrackingsensitivity' => { 37 => 0x14, 38 => 0x502 },
	'album' => { 223 => 'album' },
	'alreadyapplied' => { 206 => 'AlreadyApplied' },
	'alternatetitle' => { 215 => 'alternateTitle' },
	'alttapename' => { 223 => 'altTapeName' },
	'alttimecodetimeformat' => { 223 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 223 => 'altTimecodeTimeValue' },
	'alttimecodevalue' => { 223 => 'altTimecodeValue' },
	'anti-blur' => { 195 => 0xb04b },
	'antialiasstrength' => { 61 => 0xc632 },
	'aperturerange' => { 38 => 0x10d },
	'apertureringuse' => { 174 => '1.4' },
	'aperturevalue' => { 47 => 0x2, 61 => 0x9202, 157 => 0x1002, 209 => 'ApertureValue' },
	'applekeywords' => { 161 => 'AAPL:Keywords' },
	'applicationnotes' => { 61 => 0x2bc, 169 => 0x2bc },
	'applicationrecordversion' => { 67 => 0x0 },
	'applyshootingmeteringmode' => { 38 => 0x10e },
	'approximatefnumber' => { 166 => 0x313 },
	'armidentifier' => { 68 => 0x78 },
	'armversion' => { 68 => 0x7a },
	'artfilter' => { 152 => 0x529 },
	'artist' => { 61 => 0x13b, 163 => 'Artist', 219 => 'Artist', 223 => 'artist' },
	'artworkcopyrightnotice' => { 211 => 'ArtworkOrObjectAOCopyrightNotice' },
	'artworkcreator' => { 211 => 'ArtworkOrObjectAOCreator' },
	'artworkdatecreated' => { 211 => 'ArtworkOrObjectAODateCreated' },
	'artworksource' => { 211 => 'ArtworkOrObjectAOSource' },
	'artworksourceinventoryno' => { 211 => 'ArtworkOrObjectAOSourceInvNo' },
	'artworktitle' => { 211 => 'ArtworkOrObjectAOTitle' },
	'aspectframe' => { 156 => 0x1113 },
	'aspectratio' => { 156 => 0x1112 },
	'asshoticcprofile' => { 61 => 0xc68f },
	'asshotneutral' => { 61 => 0xc628 },
	'asshotpreprofilematrix' => { 61 => 0xc690 },
	'asshotprofilename' => { 61 => 0xc6f6 },
	'asshotwhitexy' => { 61 => 0xc629 },
	'assignfuncbutton' => { 38 => 0x70b },
	'assistbuttonfunction' => { 36 => 0xd },
	'attributionname' => { 205 => 'attributionName' },
	'attributionurl' => { 205 => 'attributionURL' },
	'audio' => { 168 => 0x20 },
	'audiochanneltype' => { 223 => 'audioChannelType' },
	'audiocompression' => { 85 => 'Compression' },
	'audiocompressor' => { 223 => 'audioCompressor' },
	'audioduration' => { 67 => 0x99 },
	'audiomoddate' => { 223 => 'audioModDate' },
	'audiooutcue' => { 67 => 0x9a },
	'audiosamplerate' => { 223 => 'audioSampleRate' },
	'audiosampletype' => { 223 => 'audioSampleType' },
	'audiosamplingrate' => { 67 => 0x97 },
	'audiosamplingresolution' => { 67 => 0x98 },
	'audiotype' => { 67 => 0x96 },
	'author' => { 87 => 'Author', 161 => 'Author', 163 => 'Author', 189 => 'Author', 212 => 'Author' },
	'authorsposition' => { 213 => 'AuthorsPosition' },
	'autoaperture' => { 178 => '0.1' },
	'autobracket' => { 193 => 0x19 },
	'autobracketing' => { 65 => 0x1100, 181 => 0x18 },
	'autobracketmodem' => { 132 => '811.2' },
	'autobracketorder' => { 132 => '811.3', 134 => '750.2' },
	'autobracketrelease' => { 125 => 0x8a },
	'autobracketset' => { 132 => '811.1', 134 => '750.1' },
	'autobrightness' => { 206 => 'AutoBrightness' },
	'autocontrast' => { 206 => 'AutoContrast' },
	'autoexposure' => { 206 => 'AutoExposure' },
	'autoexposurebracketing' => { 35 => 0x10 },
	'autofocus' => { 109 => 0x6, 155 => 0x209 },
	'autofp' => { 134 => '755.3' },
	'autoiso' => { 35 => 0x1, 58 => 0x3008, 133 => '730.1', 134 => '749.1' },
	'autoisomax' => { 133 => '730.2', 134 => '749.2' },
	'autoisominshutterspeed' => { 133 => '730.3', 134 => '749.3' },
	'autolightingoptimizer' => { 9 => 0xbe, 10 => 0xbf, 12 => 0xbf, 38 => 0x204, 56 => 0x6f },
	'autolightingoptimizeron' => { 56 => 0x6e },
	'autoredeye' => { 145 => 0xfe28a44f },
	'autorotate' => { 35 => 0x1b },
	'autoshadows' => { 206 => 'AutoShadows' },
	'auxiliarylens' => { 125 => 0x82 },
	'avaperturesetting' => { 174 => 0x13 },
	'avsettingwithoutlens' => { 38 => 0x707 },
	'azimuth' => { 95 => 'Azimuth' },
	'babyage' => { 168 => [0x8010,0x33] },
	'baseexposurecompensation' => { 174 => 0x15 },
	'baseiso' => { 35 => 0x2, 51 => 0x101c },
	'baselineexposure' => { 61 => 0xc62a },
	'baselinenoise' => { 61 => 0xc62b },
	'baselinesharpness' => { 61 => 0xc62c },
	'baseurl' => { 221 => 'BaseURL' },
	'batteryadbodyload' => { 172 => 0x3 },
	'batteryadbodynoload' => { 172 => 0x2 },
	'batteryadgripload' => { 172 => 0x5 },
	'batteryadgripnoload' => { 172 => 0x4 },
	'batteryorder' => { 132 => '802.3' },
	'batterystates' => { 172 => 0x1 },
	'bayergreensplit' => { 61 => 0xc62d },
	'bayerpattern' => { 71 => 0xf902, 105 => 0x17 },
	'beatspliceparamsriseindecibel' => { 223 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimedurationscale' => { 223 => 'beatSpliceParamsRiseInTimeDurationScale' },
	'beatspliceparamsriseintimedurationvalue' => { 223 => 'beatSpliceParamsRiseInTimeDurationValue' },
	'beatspliceparamsusefilebeatsmarker' => { 223 => 'beatSpliceParamsUseFileBeatsMarker' },
	'beep' => { 132 => '803.1', 133 => '729.1', 134 => '748.1' },
	'bestqualityscale' => { 61 => 0xc65c },
	'bestshotmode' => { 58 => 0x3007 },
	'bitdepth' => { 92 => 'BitDepth', 105 => 0x11, 130 => 0x41 },
	'bitspercomponent' => { 69 => 0x87 },
	'bitspersample' => { 61 => 0x102, 219 => 'BitsPerSample' },
	'blacklevel' => { 61 => 0xc61a, 157 => 0x1012 },
	'blacklevel2' => { 156 => 0x600, 160 => 0x600 },
	'blackpoint' => { 181 => 0x200 },
	'bluebalance' => { 115 => 0x271, 157 => 0x1018, 169 => 0x12, 181 => 0x1b },
	'bluecurvelimits' => { 55 => 0x1fe },
	'bluecurvepoints' => { 55 => 0x1d4 },
	'bluehue' => { 206 => 'BlueHue' },
	'bluesaturation' => { 206 => 'BlueSaturation' },
	'blurwarning' => { 65 => 0x1300 },
	'bodyfirmwareversion' => { 153 => 0x104, 154 => 0x100, 157 => 0x104 },
	'bracketmode' => { 24 => 0x3 },
	'bracketsequence' => { 58 => 0x301d },
	'bracketshotnumber' => { 24 => 0x5, 174 => 0x9 },
	'bracketstep' => { 100 => 0xe },
	'bracketvalue' => { 24 => 0x4 },
	'brightness' => { 61 => 0xfe53, 86 => 'Brightness', 100 => 0x2c, 127 => 0x34, 206 => 'Brightness' },
	'brightnessadj' => { 55 => 0x114, 138 => 0x0, 148 => 0x2d },
	'brightnessvalue' => { 61 => 0x9203, 157 => 0x1003, 209 => 'BrightnessValue' },
	'bulbduration' => { 35 => 0x18 },
	'burstmode' => { 73 => 0xa, 168 => 0x2a },
	'burstmode2' => { 73 => 0x18 },
	'buttonfunctioncontroloff' => { 38 => 0x70a },
	'bwfilter' => { 100 => 0x2a, 106 => 0x39 },
	'bwmode' => { 157 => 0x203 },
	'by-line' => { 67 => 0x50 },
	'by-linetitle' => { 67 => 0x55 },
	'bytecount' => { 215 => 'byteCount' },
	'calibrationilluminant1' => { 61 => 0xc65a },
	'calibrationilluminant2' => { 61 => 0xc65b },
	'cameracalibrationsig' => { 61 => 0xc6f3 },
	'cameracolorcalibration01' => { 16 => 0x4b, 17 => 0xa4, 18 => 0x85, 19 => 0xa8, 20 => 0xba },
	'cameracolorcalibration02' => { 16 => 0x4f, 17 => 0xa8, 18 => 0x89, 19 => 0xac, 20 => 0xbf },
	'cameracolorcalibration03' => { 16 => 0x53, 17 => 0xac, 18 => 0x8d, 19 => 0xb0, 20 => 0xc4 },
	'cameracolorcalibration04' => { 16 => 0x57, 17 => 0xb0, 18 => 0x91, 19 => 0xb4, 20 => 0xc9 },
	'cameracolorcalibration05' => { 16 => 0x5b, 17 => 0xb4, 18 => 0x95, 19 => 0xb8, 20 => 0xce },
	'cameracolorcalibration06' => { 16 => 0x5f, 17 => 0xb8, 18 => 0x99, 19 => 0xbc, 20 => 0xd3 },
	'cameracolorcalibration07' => { 16 => 0x63, 17 => 0xbc, 18 => 0x9d, 19 => 0xc0, 20 => 0xd8 },
	'cameracolorcalibration08' => { 16 => 0x67, 17 => 0xc0, 18 => 0xa1, 19 => 0xc4, 20 => 0xdd },
	'cameracolorcalibration09' => { 16 => 0x6b, 17 => 0xc4, 18 => 0xa5, 19 => 0xc8, 20 => 0xe2 },
	'cameracolorcalibration10' => { 16 => 0x6f, 17 => 0xc8, 18 => 0xa9, 19 => 0xcc, 20 => 0xe7 },
	'cameracolorcalibration11' => { 16 => 0x73, 17 => 0xcc, 18 => 0xad, 19 => 0xd0, 20 => 0xec },
	'cameracolorcalibration12' => { 16 => 0x77, 17 => 0xd0, 18 => 0xb1, 19 => 0xd4, 20 => 0xf1 },
	'cameracolorcalibration13' => { 16 => 0x7b, 17 => 0xd4, 18 => 0xb5, 19 => 0xd8, 20 => 0xf6 },
	'cameracolorcalibration14' => { 16 => 0x7f, 17 => 0xd8, 18 => 0xb9, 19 => 0xdc, 20 => 0xfb },
	'cameracolorcalibration15' => { 16 => 0x83, 17 => 0xdc, 18 => 0xbd, 19 => 0xe0, 20 => 0x100 },
	'cameraid' => { 157 => 0x209, 192 => 0x209 },
	'cameraiso' => { 14 => 0x10 },
	'cameraorientation' => { 2 => 0x30, 7 => 0x30, 8 => 0x30, 9 => 0x31, 10 => 0x31, 11 => 0x27, 12 => 0x31 },
	'cameraparameters' => { 157 => 0x2050 },
	'cameraprofile' => { 206 => 'CameraProfile' },
	'cameraprofiledigest' => { 206 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 61 => 0xc62f, 202 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 152 => 0x0 },
	'cameratemperature' => { 2 => 0x18, 5 => 0x18, 7 => 0x18, 8 => 0x18, 9 => 0x19, 10 => 0x19, 12 => 0x19, 166 => 0x320, 181 => 0x47 },
	'cameratype' => { 35 => 0x1a, 157 => 0x207 },
	'cameratype2' => { 153 => 0x100 },
	'canonexposuremode' => { 14 => 0x14 },
	'canonfiledescription' => { 51 => 0x805 },
	'canonfilelength' => { 27 => 0xe },
	'canonfirmwareversion' => { 27 => 0x7, 51 => 0x80b },
	'canonflashinfo' => { 51 => 0x1028 },
	'canonflashmode' => { 14 => 0x4 },
	'canonimagesize' => { 4 => 0x39, 14 => 0xa },
	'canonimagetype' => { 27 => 0x6, 51 => 0x815 },
	'canonmodelid' => { 27 => 0x10, 51 => 0x1834 },
	'canonvrd' => { 62 => 'CanonVRD' },
	'caption-abstract' => { 67 => 0x78 },
	'captionwriter' => { 213 => 'CaptionWriter' },
	'casioimagesize' => { 58 => 0x9 },
	'catalogsets' => { 201 => 'CatalogSets' },
	'categories' => { 27 => 0x23 },
	'category' => { 67 => 0xf, 213 => 'Category' },
	'ccdboardversion' => { 166 => 0x331 },
	'ccdscanmode' => { 157 => 0x1039 },
	'ccdsensitivity' => { 135 => 0x6 },
	'ccdversion' => { 166 => 0x330 },
	'celllength' => { 61 => 0x109 },
	'cellwidth' => { 61 => 0x108 },
	'centerafarea' => { 134 => '763.1' },
	'centerweightedareasize' => { 132 => '797.1', 134 => '754.3' },
	'certificate' => { 227 => 'Certificate' },
	'cfapattern' => { 61 => 0xa302 },
	'cfapatterncolumns' => { 209 => 'CFAPatternColumns' },
	'cfapatternrows' => { 209 => 'CFAPatternRows' },
	'cfapatternvalues' => { 209 => 'CFAPatternValues' },
	'channel' => { 215 => 'channel' },
	'channels' => { 85 => 'Channels' },
	'checkmark' => { 55 => 0x26a },
	'childfontfiles' => { 228 => 'FontsChildFontFiles' },
	'chromablurradius' => { 61 => 0xc631 },
	'chromaticaberration' => { 56 => 0x66 },
	'chromaticaberrationb' => { 206 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 56 => 0x6b },
	'chromaticaberrationon' => { 56 => 0x62 },
	'chromaticaberrationr' => { 206 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 56 => 0x6a },
	'chrominancenoisereduction' => { 56 => 0x5e },
	'chrominancenr_tiff_jpeg' => { 56 => 0x60 },
	'city' => { 67 => 0x5a, 91 => 'City', 213 => 'City' },
	'clarity' => { 206 => 'Clarity' },
	'classifystate' => { 67 => 0xe1 },
	'clmodeshootingspeed' => { 132 => '800.2' },
	'cmcontrast' => { 160 => 0x2022 },
	'cmexposurecompensation' => { 160 => 0x2000 },
	'cmhue' => { 160 => 0x2021 },
	'cmsaturation' => { 160 => 0x2020 },
	'cmsharpness' => { 160 => 0x2023 },
	'cmwhitebalance' => { 160 => 0x2001 },
	'cmwhitebalancecomp' => { 160 => 0x2002 },
	'cmwhitebalancegraypoint' => { 160 => 0x2010 },
	'codec' => { 99 => 'Codec' },
	'codedcharacterset' => { 68 => 0x5a },
	'coloraberrationcontrol' => { 145 => 0xc89224b },
	'coloradjustment' => { 193 => 0x14 },
	'coloradjustmentmode' => { 192 => 0x210 },
	'coloranta' => { 228 => 'ColorantsA' },
	'colorantb' => { 228 => 'ColorantsB' },
	'colorantblack' => { 228 => 'ColorantsBlack' },
	'colorantblue' => { 228 => 'ColorantsBlue' },
	'colorantcyan' => { 228 => 'ColorantsCyan' },
	'colorantgreen' => { 228 => 'ColorantsGreen' },
	'colorantl' => { 228 => 'ColorantsL' },
	'colorantmagenta' => { 228 => 'ColorantsMagenta' },
	'colorantmode' => { 228 => 'ColorantsMode' },
	'colorantred' => { 228 => 'ColorantsRed' },
	'colorantswatchname' => { 228 => 'ColorantsSwatchName' },
	'coloranttype' => { 228 => 'ColorantsType' },
	'colorantyellow' => { 228 => 'ColorantsYellow' },
	'colorbalance' => { 86 => 'ColorBalance' },
	'colorbalanceadj' => { 145 => 0x76a43202 },
	'colorbalanceblue' => { 100 => 0x1e },
	'colorbalancegreen' => { 100 => 0x1d },
	'colorbalancered' => { 100 => 0x1c },
	'colorblur' => { 56 => 0x65 },
	'colorbooster' => { 145 => 0x5f0e7d23 },
	'colorboostlevel' => { 139 => 0x1 },
	'colorboosttype' => { 139 => 0x0 },
	'colorclass' => { 184 => 0xde },
	'colorcontrol' => { 157 => 0x102b },
	'colordataversion' => { 18 => 0x0, 19 => 0x0 },
	'coloreffect' => { 168 => 0x28 },
	'colorfilter' => { 57 => 0x17, 100 => 0x29, 106 => 0x38, 183 => 0x17 },
	'colorgain' => { 130 => 0x51 },
	'colorhue' => { 125 => 0x8d },
	'colorimetricreference' => { 61 => 0xc6bf },
	'colormatrix' => { 156 => 0x200, 157 => 0x1011 },
	'colormatrix2' => { 160 => 0x200 },
	'colormatrixa' => { 181 => 0x203 },
	'colormatrixb' => { 181 => 0x204 },
	'colormatrixnumber' => { 157 => 0x1019 },
	'colormode' => { 58 => 0x3015, 65 => 0x1210, 73 => 0x66, 100 => 0x28, 103 => 0x16, 104 => 0x101, 106 => 0x7, 125 => 0x3, 135 => 0x4, 157 => 0x101, 168 => 0x32, 195 => 0xb029, 213 => 'ColorMode' },
	'colormoirereduction' => { 146 => 0x15 },
	'colormoirereductionmode' => { 146 => 0x5 },
	'colornoisereduction' => { 206 => 'ColorNoiseReduction' },
	'colornoisereductionintensity' => { 146 => 0x18 },
	'colornoisereductionsharpness' => { 146 => 0x1c },
	'colorplanes' => { 64 => 0x2 },
	'colorprofile' => { 100 => 0x33 },
	'colorrepresentation' => { 69 => 0x3c },
	'colorreproduction' => { 195 => 0xb020 },
	'colorsequence' => { 69 => 0x41 },
	'colorspace' => { 21 => 0x3, 27 => 0xb4, 51 => 0x10b4, 61 => 0xa001, 92 => 'ColorSpace', 101 => 0x2f, 102 => 0x25, 125 => 0x1e, 152 => 0x507, 181 => 0x37, 193 => 0xb, 209 => 'ColorSpace' },
	'colortempasshot' => { 16 => 0x1d, 17 => 0x26, 18 => 0x43, 19 => 0x43, 20 => 0x4b },
	'colortempauto' => { 16 => 0x22, 17 => 0x1c, 18 => 0x48, 19 => 0x48, 20 => 0x50 },
	'colortempcloudy' => { 16 => 0x31, 17 => 0x35, 18 => 0x5c, 19 => 0x61, 20 => 0x69 },
	'colortempcustom' => { 18 => 0x84 },
	'colortempcustom1' => { 16 => 0x45 },
	'colortempcustom2' => { 16 => 0x4a },
	'colortempdaylight' => { 16 => 0x27, 17 => 0x2b, 18 => 0x52, 19 => 0x57, 20 => 0x5f },
	'colortemperature' => { 2 => 0x73, 3 => [0x48,0x4e], 4 => 0x37, 5 => 0x62, 6 => 0x37, 7 => 0x73, 8 => 0x73, 9 => 0x77, 10 => 0x73, 11 => 0x58, 12 => 0x73, 27 => 0xae, 33 => 0x9, 51 => 0x10ae, 65 => 0x1005, 72 => 0x846, 86 => 'ColorTemperature', 101 => [0x6e,0x49], 102 => 0x3f, 103 => 0x5e, 104 => 0x10b, 106 => 0x3c, 166 => 0x321, 181 => 0x50, 195 => 0xb021 },
	'colortemperaturebg' => { 157 => 0x1013 },
	'colortemperaturerg' => { 157 => 0x1014 },
	'colortempflash' => { 16 => 0x40, 17 => 0x49, 18 => 0x70, 19 => 0x75, 20 => 0x7d },
	'colortempflashdata' => { 18 => 0x24a },
	'colortempfluorescent' => { 16 => 0x3b, 17 => 0x3f, 18 => 0x66, 19 => 0x6b, 20 => 0x73 },
	'colortempkelvin' => { 17 => 0x44, 18 => 0x6b, 19 => 0x70, 20 => 0x78 },
	'colortempmeasured' => { 18 => 0x4d, 19 => 0x4d, 20 => 0x55 },
	'colortemppc1' => { 17 => 0x94, 18 => 0x75 },
	'colortemppc2' => { 17 => 0x99, 18 => 0x7a },
	'colortemppc3' => { 17 => 0x9e, 18 => 0x7f },
	'colortempshade' => { 16 => 0x2c, 17 => 0x30, 18 => 0x57, 19 => 0x5c, 20 => 0x64 },
	'colortemptungsten' => { 16 => 0x36, 17 => 0x3a, 18 => 0x61, 19 => 0x66, 20 => 0x6e },
	'colortempunknown' => { 17 => 0x21, 19 => 0x52, 20 => 0x5a },
	'colortempunknown10' => { 17 => 0x76, 19 => 0xa2, 20 => 0xaa },
	'colortempunknown11' => { 17 => 0x7b, 19 => 0xa7, 20 => 0xaf },
	'colortempunknown12' => { 17 => 0x80, 20 => 0xb4 },
	'colortempunknown13' => { 17 => 0x85, 20 => 0xb9 },
	'colortempunknown14' => { 17 => 0x8a },
	'colortempunknown15' => { 17 => 0x8f },
	'colortempunknown16' => { 17 => 0xa3 },
	'colortempunknown2' => { 17 => 0x4e, 19 => 0x7a, 20 => 0x82 },
	'colortempunknown3' => { 17 => 0x53, 19 => 0x7f, 20 => 0x87 },
	'colortempunknown4' => { 17 => 0x58, 19 => 0x84, 20 => 0x8c },
	'colortempunknown5' => { 17 => 0x5d, 19 => 0x89, 20 => 0x91 },
	'colortempunknown6' => { 17 => 0x62, 19 => 0x8e, 20 => 0x96 },
	'colortempunknown7' => { 17 => 0x67, 19 => 0x93, 20 => 0x9b },
	'colortempunknown8' => { 17 => 0x6c, 19 => 0x98, 20 => 0xa0 },
	'colortempunknown9' => { 17 => 0x71, 19 => 0x9d, 20 => 0xa5 },
	'colortone' => { 4 => 0x6f, 6 => 0x77, 14 => 0x2a, 21 => 0x2 },
	'colortoneadj' => { 55 => 0x11e },
	'colortonefaithful' => { 11 => 0x107 },
	'colortonelandscape' => { 11 => 0x105 },
	'colortoneneutral' => { 11 => 0x106 },
	'colortoneportrait' => { 11 => 0x104 },
	'colortonestandard' => { 11 => 0x103 },
	'colortoneuserdef1' => { 11 => 0x109 },
	'colortoneuserdef2' => { 11 => 0x10a },
	'colortoneuserdef3' => { 11 => 0x10b },
	'commanddials' => { 134 => '753.1' },
	'commanddialsaperturesetting' => { 132 => '807.3' },
	'commanddialschangemainsub' => { 132 => '807.2' },
	'commanddialsmenuandplayback' => { 132 => '807.4' },
	'commanddialsreverserotation' => { 132 => '807.1' },
	'commanderchannel' => { 134 => '758.2' },
	'commandergroupa_manualoutput' => { 134 => '761.2' },
	'commandergroupa_ttl-aacomp' => { 134 => '761.1' },
	'commandergroupamode' => { 134 => '759.2' },
	'commandergroupb_manualoutput' => { 134 => '762.2' },
	'commandergroupb_ttl-aacomp' => { 134 => '762.1' },
	'commandergroupbmode' => { 134 => '759.3' },
	'commanderinternalflash' => { 134 => '759.1' },
	'commanderinternalmanualoutput' => { 134 => '760.2' },
	'commanderinternalttlcomp' => { 134 => '760.1' },
	'comment' => { 0 => 0x2, 62 => 'Comment', 87 => 'Comment', 163 => 'Comment' },
	'complianceprofile' => { 215 => 'complianceProfile' },
	'componentsconfiguration' => { 61 => 0x9101, 92 => 'Components', 209 => 'ComponentsConfiguration' },
	'componentversion' => { 51 => 0x80c },
	'composer' => { 223 => 'composer' },
	'compressedbitsperpixel' => { 61 => 0x9102, 209 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 104 => 0x40, 157 => 0x40 },
	'compression' => { 61 => 0x103, 219 => 'Compression' },
	'compressionfactor' => { 152 => 0x50d },
	'compressionratio' => { 92 => 'Compression', 157 => 0x1034 },
	'constrainedcropheight' => { 55 => 0x266, 184 => 0xd6 },
	'constrainedcropwidth' => { 55 => 0x262, 184 => 0xd5 },
	'contact' => { 67 => 0x76 },
	'contentlocationcode' => { 67 => 0x1a },
	'contentlocationname' => { 67 => 0x1b },
	'continuousdrive' => { 14 => 0x5 },
	'continuousshootingspeed' => { 38 => 0x610 },
	'continuousshotlimit' => { 38 => 0x611 },
	'contrast' => { 4 => 0x73, 6 => 0x75, 14 => 0xd, 57 => 0xc, 58 => [0x3012,0x20], 61 => [0xa408,0xfe54], 65 => [0x1004,0x1006], 86 => 'Contrast', 100 => 0x20, 101 => 0x31, 102 => 0x27, 103 => 0x19, 106 => 0x2, 127 => 0x33, 157 => 0x1029, 168 => [0x2c,0x39], 181 => 0x20, 183 => 0xc, 193 => 0xd, 194 => 0x1d, 206 => 'Contrast', 209 => 'Contrast' },
	'contrastadj' => { 55 => 0x115, 148 => 0x2c },
	'contrastfaithful' => { 11 => 0xec },
	'contrastlandscape' => { 11 => 0xea },
	'contrastmonochrome' => { 11 => 0xed },
	'contrastneutral' => { 11 => 0xeb },
	'contrastportrait' => { 11 => 0xe9 },
	'contrastsetting' => { 152 => 0x505, 160 => 0x1012 },
	'contraststandard' => { 11 => 0xe8 },
	'contrastuserdef1' => { 11 => 0xee },
	'contrastuserdef2' => { 11 => 0xef },
	'contrastuserdef3' => { 11 => 0xf0 },
	'contributedmediadurationscale' => { 223 => 'contributedMediaDurationScale' },
	'contributedmediadurationvalue' => { 223 => 'contributedMediaDurationValue' },
	'contributedmediamanaged' => { 223 => 'contributedMediaManaged' },
	'contributedmediapath' => { 223 => 'contributedMediaPath' },
	'contributedmediastarttimescale' => { 223 => 'contributedMediaStartTimeScale' },
	'contributedmediastarttimevalue' => { 223 => 'contributedMediaStartTimeValue' },
	'contributedmediatrack' => { 223 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 223 => 'contributedMediaWebStatement' },
	'contributor' => { 207 => 'contributor' },
	'contributors' => { 87 => 'Contributors' },
	'controlledvocabularyterm' => { 211 => 'CVterm' },
	'controllerboardversion' => { 166 => 0x332 },
	'controlmode' => { 35 => 0x12 },
	'conversionlens' => { 168 => 0x35 },
	'converter' => { 61 => 0xfe4d, 135 => 0xb, 206 => 'Converter' },
	'converttograyscale' => { 206 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 61 => 0x8298, 87 => 'Copyright', 163 => 'Copyright', 189 => 'Copyright', 212 => 'Copyright', 215 => 'copyright', 217 => 'copyright', 219 => 'Copyright', 223 => 'copyright' },
	'copyrightflag' => { 187 => 0x40a },
	'copyrightnotice' => { 67 => 0x74 },
	'copyrightownerid' => { 214 => 'CopyrightOwnerCopyrightOwnerID' },
	'copyrightownerimageid' => { 214 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 214 => 'CopyrightOwnerCopyrightOwnerName' },
	'copyrightregistrationnumber' => { 214 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 214 => 'CopyrightStatus' },
	'coringfilter' => { 156 => 0x310, 157 => 0x102d, 160 => 0x310 },
	'coringvalues' => { 156 => 0x311, 160 => 0x311 },
	'corporateentity' => { 215 => 'corporateEntity' },
	'country' => { 91 => 'Country', 213 => 'Country' },
	'country-primarylocationcode' => { 67 => 0x64 },
	'country-primarylocationname' => { 67 => 0x65 },
	'countrycode' => { 185 => 'CountryCode', 210 => 'CountryCode' },
	'coverage' => { 207 => 'coverage' },
	'coverdate' => { 215 => 'coverDate' },
	'coverdisplaydate' => { 215 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 181 => 0x28 },
	'crc32' => { 208 => 'crc32' },
	'createdate' => { 61 => 0x9004, 87 => 'CreateDate', 161 => 'CreationDate', 189 => 'CreationDate', 221 => 'CreateDate' },
	'creationdate' => { 212 => 'CreationDate', 215 => 'creationDate' },
	'creationtime' => { 163 => 'Creation Time' },
	'creativestyle' => { 194 => 0x1a },
	'creator' => { 161 => 'Creator', 189 => 'Creator', 207 => 'creator', 212 => 'Creator' },
	'creatoraddress' => { 210 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcity' => { 210 => 'CreatorContactInfoCiAdrCity' },
	'creatorcountry' => { 210 => 'CreatorContactInfoCiAdrCtry' },
	'creatorpostalcode' => { 210 => 'CreatorContactInfoCiAdrPcode' },
	'creatorregion' => { 210 => 'CreatorContactInfoCiAdrRegion' },
	'creatortool' => { 221 => 'CreatorTool' },
	'creatorworkemail' => { 210 => 'CreatorContactInfoCiEmailWork' },
	'creatorworktelephone' => { 210 => 'CreatorContactInfoCiTelWork' },
	'creatorworkurl' => { 210 => 'CreatorContactInfoCiUrlWork' },
	'credit' => { 67 => 0x6e, 213 => 'Credit' },
	'creditline' => { 217 => 'creditLine' },
	'creditlinereq' => { 226 => 'CreditLineReq' },
	'creditlinerequired' => { 214 => 'CreditLineRequired' },
	'cropactive' => { 55 => 0x244 },
	'cropangle' => { 206 => 'CropAngle' },
	'cropaspectratio' => { 55 => 0x260 },
	'cropbottom' => { 64 => 0x9, 140 => 0x36, 184 => 0xdc, 206 => 'CropBottom' },
	'cropheight' => { 55 => 0x24c, 156 => 0x615, 160 => 0x615, 206 => 'CropHeight' },
	'crophispeed' => { 125 => 0x1b },
	'cropleft' => { 55 => 0x246, 64 => 0x6, 140 => 0x1e, 156 => 0x612, 160 => 0x612, 184 => 0xd9, 206 => 'CropLeft' },
	'cropoutputheight' => { 140 => 0xce },
	'cropoutputheightinches' => { 140 => 0x96 },
	'cropoutputpixels' => { 140 => 0xd6 },
	'cropoutputresolution' => { 140 => 0xb6 },
	'cropoutputscale' => { 140 => 0xbe },
	'cropoutputwidth' => { 140 => 0xc6 },
	'cropoutputwidthinches' => { 140 => 0x8e },
	'cropright' => { 64 => 0x8, 140 => 0x2e, 184 => 0xdb, 206 => 'CropRight' },
	'croprotation' => { 64 => 0xb },
	'cropscaledresolution' => { 140 => 0x9e },
	'cropsourceresolution' => { 140 => 0xae },
	'croptop' => { 55 => 0x248, 64 => 0x7, 140 => 0x26, 156 => 0x613, 160 => 0x613, 184 => 0xda, 206 => 'CropTop' },
	'cropunit' => { 206 => 'CropUnit' },
	'cropunits' => { 206 => 'CropUnits' },
	'cropwidth' => { 55 => 0x24a, 156 => 0x614, 160 => 0x614, 206 => 'CropWidth' },
	'currenticcprofile' => { 61 => 0xc691 },
	'currentpreprofilematrix' => { 61 => 0xc692 },
	'curves' => { 145 => 0x76a43201 },
	'custom1' => { 214 => 'Custom1' },
	'custom10' => { 214 => 'Custom10' },
	'custom2' => { 214 => 'Custom2' },
	'custom3' => { 214 => 'Custom3' },
	'custom4' => { 214 => 'Custom4' },
	'custom5' => { 214 => 'Custom5' },
	'custom6' => { 214 => 'Custom6' },
	'custom7' => { 214 => 'Custom7' },
	'custom8' => { 214 => 'Custom8' },
	'custom9' => { 214 => 'Custom9' },
	'customrendered' => { 61 => 0xa401, 209 => 'CustomRendered' },
	'customsaturation' => { 152 => 0x503 },
	'd-lightinghq' => { 145 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 141 => 0x2 },
	'd-lightinghqhighlight' => { 141 => 0x1 },
	'd-lightinghqselected' => { 145 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 141 => 0x0 },
	'd-lightinghs' => { 145 => 0xce5554aa },
	'd-lightinghsadjustment' => { 142 => 0x0 },
	'd-lightinghscolorboost' => { 142 => 0x1 },
	'datacompressionmethod' => { 69 => 0x6e },
	'dataimprint' => { 100 => 0x34 },
	'date' => { 181 => 0x6, 207 => 'date' },
	'dateacquired' => { 202 => 'DateAcquired' },
	'datecreated' => { 67 => 0x37, 213 => 'DateCreated' },
	'datedisplayformat' => { 137 => 0x3 },
	'daterecieved' => { 215 => 'dateRecieved' },
	'datesent' => { 68 => 0x46 },
	'datestampmode' => { 27 => 0x1c },
	'datetime' => { 219 => 'DateTime' },
	'datetimedigitized' => { 209 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 54 => 0x0, 61 => 0x9003, 84 => 0x14, 87 => 'OriginalDate', 209 => 'DateTimeOriginal' },
	'datetimestamp' => { 73 => 0x64 },
	'daylightsavings' => { 137 => 0x2 },
	'declination' => { 95 => 'Declination' },
	'decposition' => { 100 => 0x32 },
	'defaultcroporigin' => { 61 => 0xc61f },
	'defaultcropsize' => { 61 => 0xc620 },
	'defaultscale' => { 61 => 0xc61e },
	'defringe' => { 206 => 'Defringe' },
	'deletedimagecount' => { 125 => 0xa6, 131 => 0x6e },
	'derivedfromalternatepaths' => { 224 => 'DerivedFromAlternatePaths' },
	'derivedfromdocumentid' => { 224 => 'DerivedFromDocumentID' },
	'derivedfromfilepath' => { 224 => 'DerivedFromFilePath' },
	'derivedfromfrompart' => { 224 => 'DerivedFromFromPart' },
	'derivedfrominstanceid' => { 224 => 'DerivedFromInstanceID' },
	'derivedfromlastmodifydate' => { 224 => 'DerivedFromLastModifyDate' },
	'derivedfrommanager' => { 224 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 224 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 224 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 224 => 'DerivedFromManageUI' },
	'derivedfrommaskmarkers' => { 224 => 'DerivedFromMaskMarkers' },
	'derivedfrompartmapping' => { 224 => 'DerivedFromPartMapping' },
	'derivedfromrenditionclass' => { 224 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 224 => 'DerivedFromRenditionParams' },
	'derivedfromtopart' => { 224 => 'DerivedFromToPart' },
	'derivedfromversionid' => { 224 => 'DerivedFromVersionID' },
	'description' => { 163 => 'Description', 207 => 'description' },
	'destination' => { 68 => 0x5 },
	'destinationcity' => { 181 => 0x24 },
	'destinationcitycode' => { 183 => 0x1001 },
	'destinationdst' => { 181 => 0x26 },
	'developmentdynamicrange' => { 65 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 209 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 209 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 209 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 38 => 0x706 },
	'digitalcreationdate' => { 67 => 0x3e },
	'digitalcreationtime' => { 67 => 0x3f },
	'digitaldeehighlightadj' => { 130 => 0x202 },
	'digitaldeeshadowadj' => { 130 => 0x200 },
	'digitaldeethreshold' => { 130 => 0x201 },
	'digitalgain' => { 33 => 0xb },
	'digitalgem' => { 120 => 0x0 },
	'digitalice' => { 130 => 0x100 },
	'digitalimageguid' => { 211 => 'DigImageGUID' },
	'digitalroc' => { 129 => 0x0 },
	'digitalsourcefiletype' => { 211 => 'DigitalSourcefileType' },
	'digitalzoom' => { 14 => 0xc, 57 => 0xa, 73 => 0x68, 86 => 'DigitalZoom', 100 => 0xc, 125 => 0x86, 135 => 0xa, 157 => 0x204, 181 => 0x1e, 183 => 0xa, 192 => 0x204 },
	'digitalzoomon' => { 192 => 0x21b },
	'digitalzoomratio' => { 61 => 0xa404, 209 => 'DigitalZoomRatio' },
	'directory' => { 62 => 'Directory' },
	'directoryindex' => { 2 => 0x137, 5 => 0x17e, 7 => 0x13f, 8 => 0x133, 9 => 0x1df, 10 => [0x1a3,0x1a7], 12 => [0x1a3,0x1c7] },
	'directorynumber' => { 116 => 0x6 },
	'disclaimer' => { 163 => 'Disclaimer' },
	'displayaperture' => { 14 => 0x23 },
	'displayedunitsx' => { 188 => 0x2 },
	'displayedunitsy' => { 188 => 0x6 },
	'distance1' => { 73 => 0x28 },
	'distance2' => { 73 => 0x2c },
	'distance3' => { 73 => 0x30 },
	'distance4' => { 73 => 0x34 },
	'distortioncorrection' => { 56 => 0x67, 152 => 0x50b },
	'distortioncorrection2' => { 156 => 0x1011 },
	'distortioncorrectionon' => { 56 => 0x63 },
	'distributor' => { 215 => 'distributor' },
	'dngbackwardversion' => { 61 => 0xc613 },
	'dnglensinfo' => { 61 => 0xc630 },
	'dngversion' => { 61 => 0xc612 },
	'document' => { 163 => 'Document' },
	'documenthistory' => { 67 => 0xe7 },
	'documentid' => { 224 => 'DocumentID' },
	'documentname' => { 61 => 0x10d },
	'documentnotes' => { 67 => 0xe6 },
	'doi' => { 215 => 'doi' },
	'dotrange' => { 61 => 0x150 },
	'drivemode' => { 100 => 0x6, 103 => 0x1e, 152 => 0x600, 181 => 0x34, 193 => 0x3 },
	'drivemode2' => { 174 => 0x7 },
	'dspfirmwareversion' => { 181 => 0x27 },
	'duration' => { 85 => 'Duration', 99 => 'Duration' },
	'durationscale' => { 223 => 'durationScale' },
	'durationvalue' => { 223 => 'durationValue' },
	'dynamicafarea' => { 132 => '791.4' },
	'dynamicrange' => { 65 => 0x1400 },
	'dynamicrangeexpansion' => { 181 => 0x69 },
	'dynamicrangemax' => { 55 => 0x7c },
	'dynamicrangemin' => { 55 => 0x7a },
	'dynamicrangeoptimizer' => { 195 => 0xb025 },
	'dynamicrangesetting' => { 65 => 0x1402 },
	'e-dialinprogram' => { 174 => '1.3' },
	'easyexposurecompensation' => { 132 => '796.4' },
	'easymode' => { 14 => 0xb },
	'edgenoisereduction' => { 146 => 0x4 },
	'edition' => { 215 => 'edition' },
	'editorialupdate' => { 67 => 0x8 },
	'editstatus' => { 67 => 0x7, 185 => 'EditStatus' },
	'effectivelv' => { 181 => 0x2d },
	'effectivemaxaperture' => { 123 => 0x12, 124 => 0x13 },
	'eissn' => { 215 => 'eIssn' },
	'elevation' => { 95 => 'Elevation' },
	'email' => { 87 => 'EMail' },
	'embargodate' => { 215 => 'embargoDate', 217 => 'embargoDate' },
	'endingpage' => { 215 => 'endingPage' },
	'enduserid' => { 214 => 'EndUserEndUserID' },
	'endusername' => { 214 => 'EndUserEndUserName' },
	'engineer' => { 223 => 'engineer' },
	'enhancedarktones' => { 138 => 0x8 },
	'enhancement' => { 57 => 0x16, 58 => 0x3016 },
	'enhancer' => { 156 => 0x300 },
	'enhancervalues' => { 156 => 0x301 },
	'envelopenumber' => { 68 => 0x28 },
	'envelopepriority' => { 68 => 0x3c },
	'enveloperecordversion' => { 68 => 0x0 },
	'epsonimageheight' => { 157 => 0x20c },
	'epsonimagewidth' => { 157 => 0x20b },
	'epsonsoftware' => { 157 => 0x20d },
	'equipmentinstitution' => { 198 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 198 => 'EquipmentManufacturer' },
	'equipmentversion' => { 153 => 0x0 },
	'ettlii' => { 38 => 0x304, 39 => 0xd, 40 => 0xe, 41 => 0x7, 42 => 0x7, 43 => 0xe },
	'event' => { 201 => 'Event', 211 => 'Event', 215 => 'event' },
	'evsteps' => { 174 => '1.2', 176 => 0x0 },
	'evstepsize' => { 134 => '748.7' },
	'exclusivityenddate' => { 217 => 'exclusivityEndDate' },
	'excursiontolerance' => { 69 => 0x82 },
	'exif' => { 62 => 'EXIF' },
	'exifbyteorder' => { 62 => 'ExifByteOrder' },
	'exifcamerainfo' => { 67 => 0xe8 },
	'exifimageheight' => { 61 => 0xa003, 209 => 'PixelYDimension' },
	'exifimagewidth' => { 61 => 0xa002, 209 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 62 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 61 => 0x9000, 209 => 'ExifVersion' },
	'exitpupilposition' => { 123 => 0x4, 124 => 0x4 },
	'expirationdate' => { 67 => 0x25, 215 => 'expirationDate', 217 => 'expirationDate' },
	'expirationtime' => { 67 => 0x26 },
	'exposure' => { 61 => 0xfe51, 206 => 'Exposure' },
	'exposureadj' => { 143 => 0x0 },
	'exposureadj2' => { 143 => 0x12 },
	'exposurebracketstepsize' => { 174 => 0x8 },
	'exposurebracketvalue' => { 125 => 0x19 },
	'exposurecompensation' => { 35 => 0x6, 47 => 0x0, 61 => 0x9204, 73 => 0x24, 86 => 'ExposureComp', 100 => 0xd, 101 => 0x53, 102 => 0x1e, 103 => 0x1, 157 => 0x1006, 181 => 0x16, 193 => [0xc,0x35], 209 => 'ExposureBiasValue' },
	'exposurecontrolstepsize' => { 132 => '796.2' },
	'exposuredelaymode' => { 132 => '800.1', 134 => '754.4' },
	'exposuredifference' => { 125 => 0xe },
	'exposureindex' => { 61 => 0xa215, 209 => 'ExposureIndex' },
	'exposurelevelincrements' => { 36 => 0x6, 37 => 0x6, 38 => 0x101, 39 => 0x5, 40 => 0x6, 41 => 0x5, 42 => 0x5, 43 => 0x6, 44 => 0x4 },
	'exposuremode' => { 61 => 0xa402, 86 => 'ExposureMode', 100 => 0x1, 101 => 0xa, 102 => 0x0, 103 => 0x0, 152 => 0x200, 193 => 0x8, 195 => 0xb041, 209 => 'ExposureMode' },
	'exposuremodeinmanual' => { 38 => 0x10b },
	'exposureprogram' => { 61 => 0x8822, 194 => 0x3c, 209 => 'ExposureProgram' },
	'exposureshift' => { 152 => 0x203 },
	'exposuretime' => { 2 => 0x4, 3 => 0x4, 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x6, 35 => 0x16, 61 => 0x829a, 71 => 0xfd05, 73 => 0x20, 74 => 0xfa24, 76 => 0xf104, 79 => 0x12, 81 => 0x38, 84 => 0x10, 86 => 'ExposureTime', 100 => 0x9, 101 => 0x35, 102 => 0x48, 181 => 0x12, 193 => 0x32, 209 => 'ExposureTime' },
	'exposuretime2' => { 193 => 0x33 },
	'exposurevalue' => { 72 => 0x3 },
	'exposurewarning' => { 65 => 0x1302 },
	'exrauto' => { 65 => 0x1033 },
	'exrmode' => { 65 => 0x1034 },
	'extendedwbdetect' => { 152 => 0x902 },
	'extender' => { 153 => 0x301 },
	'extenderfirmwareversion' => { 153 => 0x304 },
	'extendermagnification' => { 88 => 'Magnification' },
	'extendermake' => { 88 => 'Make' },
	'extendermodel' => { 88 => 'Model', 153 => 0x303 },
	'extenderserialnumber' => { 88 => 'SerialNumber', 153 => 0x302 },
	'externalflash' => { 155 => 0x1201 },
	'externalflashae1' => { 157 => 0x101f },
	'externalflashae1_0' => { 157 => 0x101b },
	'externalflashae2' => { 157 => 0x1020 },
	'externalflashae2_0' => { 157 => 0x101c },
	'externalflashbounce' => { 155 => 0x1204, 157 => 0x1026, 177 => 0x1a },
	'externalflashexposurecomp' => { 177 => 0x19 },
	'externalflashfirmware' => { 117 => 0x6, 118 => 0x6, 119 => 0x6 },
	'externalflashflags' => { 117 => 0x8, 118 => 0x8, 119 => 0x8 },
	'externalflashguidenumber' => { 155 => 0x1203, 177 => '24.1' },
	'externalflashgvalue' => { 157 => 0x1025 },
	'externalflashmode' => { 157 => 0x1028, 177 => 0x2 },
	'externalflashzoom' => { 155 => 0x1205, 157 => 0x1027 },
	'externalsensorbrightnessvalue' => { 166 => 0x311 },
	'face0position' => { 22 => 0x8 },
	'face1position' => { 22 => 0xa, 164 => 0x1 },
	'face2position' => { 22 => 0xc, 164 => 0x5 },
	'face3position' => { 22 => 0xe, 164 => 0x9 },
	'face4position' => { 22 => 0x10, 164 => 0xd },
	'face5position' => { 22 => 0x12, 164 => 0x11 },
	'face6position' => { 22 => 0x14 },
	'face7position' => { 22 => 0x16 },
	'face8position' => { 22 => 0x18 },
	'facedetect' => { 156 => 0x1200 },
	'facedetectarea' => { 156 => 0x1201 },
	'facedetectframeheight' => { 22 => 0x4 },
	'facedetectframewidth' => { 22 => 0x3 },
	'facepositions' => { 65 => 0x4103 },
	'facesdetected' => { 22 => 0x2, 23 => 0x2, 65 => 0x4100, 168 => 0x3f },
	'facesrecognized' => { 165 => 0x0 },
	'ffid' => { 208 => 'ffid' },
	'fieldcount' => { 157 => 0x103f },
	'filedatarate' => { 223 => 'fileDataRate' },
	'fileformat' => { 49 => 0x0, 68 => 0x14 },
	'fileindex' => { 2 => 0x143, 5 => 0x172, 7 => 0x133, 8 => 0x13f, 9 => 0x1d3, 10 => [0x197,0x19b], 12 => [0x197,0x1bb] },
	'filemodifydate' => { 62 => 'FileModifyDate' },
	'filename' => { 62 => 'FileName' },
	'filenameasdelivered' => { 214 => 'FileNameAsDelivered' },
	'filenumber' => { 24 => 0x1, 27 => 0x8, 51 => 0x1817, 116 => 0x8 },
	'filenumbermemory' => { 100 => 0x1a },
	'filenumbersequence' => { 132 => '802.2' },
	'filesource' => { 61 => 0xa300, 65 => 0x8000, 209 => 'FileSource' },
	'fileversion' => { 68 => 0x16 },
	'fillflashautoreduction' => { 36 => 0xe, 37 => 0xe, 44 => 0xa },
	'filllight' => { 206 => 'FillLight' },
	'fillorder' => { 61 => 0x10a },
	'filmmode' => { 65 => 0x1401, 168 => 0x42 },
	'filmtype' => { 130 => 0x2 },
	'filter' => { 58 => 0x3017 },
	'filtereffect' => { 24 => 0xe, 127 => 0x37 },
	'filtereffectmonochrome' => { 11 => 0xff },
	'finderdisplayduringexposure' => { 37 => 0x1 },
	'finetuneoptcenterweighted' => { 132 => '797.2' },
	'finetuneoptmatrixmetering' => { 132 => '798.1' },
	'finetuneoptspotmetering' => { 132 => '798.2' },
	'finetunestepsize' => { 132 => '796.3' },
	'firmware' => { 157 => 0x405, 193 => [0x17,0x3b], 204 => 'Firmware' },
	'firmwaredate' => { 57 => 0x15, 58 => 0x2001 },
	'firmwareid' => { 105 => 0x0 },
	'firmwarerevision' => { 11 => 0xa4, 27 => 0x1e },
	'firmwareversion' => { 2 => 0x10b, 5 => 0x136, 7 => 0xff, 8 => 0x107, 72 => 0xce5, 84 => 0x57, 86 => 'FirmwareVersion', 168 => 0x2 },
	'firstpublicationdate' => { 214 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 67 => 0x16 },
	'flash' => { 61 => 0x9209, 101 => 0x1f, 102 => 0x15 },
	'flashactivity' => { 14 => 0x1c },
	'flashbatterylevel' => { 18 => 0x249 },
	'flashbias' => { 168 => 0x24 },
	'flashbits' => { 14 => 0x1d },
	'flashchargelevel' => { 157 => 0x1010 },
	'flashcommandermode' => { 117 => '9.1', 118 => '9.1', 119 => '9.1' },
	'flashcompensation' => { 204 => 'FlashCompensation' },
	'flashcontrolmode' => { 117 => '9.2', 118 => '9.2', 119 => '9.2', 152 => 0x404 },
	'flashdevice' => { 157 => 0x1005 },
	'flashdistance' => { 58 => 0x2034 },
	'flashenergy' => { 61 => 0xa20b, 209 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 125 => 0x18 },
	'flashexposurecomp' => { 35 => 0xf, 65 => 0x1011, 89 => 'ExposureComp', 100 => 0x23, 104 => 0x104, 117 => 0xa, 118 => 0xa, 119 => 0xa, 125 => 0x12, 152 => 0x401, 157 => 0x1023, 181 => 0x4d, 193 => 0x3a, 195 => 0x104 },
	'flashexposurecompset' => { 170 => 0xe },
	'flashexposurelock' => { 24 => 0x19 },
	'flashfired' => { 73 => 0x5d, 89 => 'Fired', 100 => 0x14, 134 => '590.3', 168 => 0x8007, 209 => 'FlashFired' },
	'flashfiring' => { 38 => 0x306, 39 => 0x6, 40 => 0x7, 43 => 0x7 },
	'flashfirmwareversion' => { 153 => 0x1002 },
	'flashfocallength' => { 117 => 0xb, 118 => 0xc, 119 => 0xc },
	'flashfunction' => { 209 => 'FlashFunction' },
	'flashgroupacontrolmode' => { 117 => 0xf, 118 => '16.1', 119 => '17.1' },
	'flashgroupaexposurecomp' => { 117 => 0x11, 118 => 0x12, 119 => 0x13 },
	'flashgroupaoutput' => { 117 => 0x11, 118 => 0x12, 119 => 0x13 },
	'flashgroupbcontrolmode' => { 117 => 0x10, 118 => '17.1', 119 => '18.1' },
	'flashgroupbexposurecomp' => { 117 => 0x12, 118 => 0x13, 119 => 0x14 },
	'flashgroupboutput' => { 117 => 0x12, 118 => 0x13, 119 => 0x14 },
	'flashgroupccontrolmode' => { 118 => '17.2', 119 => '18.2' },
	'flashgroupcexposurecomp' => { 118 => 0x14, 119 => 0x15 },
	'flashgroupcoutput' => { 118 => 0x14, 119 => 0x15 },
	'flashguidenumber' => { 35 => 0xd, 48 => 0x0, 89 => 'GuideNumber' },
	'flashintensity' => { 57 => [0x19,0x5], 152 => 0x405 },
	'flashlevel' => { 133 => 0x2e2 },
	'flashmake' => { 89 => 'Make' },
	'flashmanufacturer' => { 202 => 'FlashManufacturer' },
	'flashmetering' => { 100 => 0x3f },
	'flashmeteringsegments' => { 181 => 0x20a },
	'flashmode' => { 57 => 0x4, 73 => 0x5c, 89 => 'Mode', 100 => 0x2, 101 => 0x20, 102 => 0x16, 125 => 0x87, 152 => 0x400, 157 => 0x1004, 181 => 0xc, 183 => 0x4, 190 => 0x20, 192 => 0x225, 194 => 0x23, 209 => 'FlashMode' },
	'flashmodel' => { 89 => 'Model', 153 => 0x1001, 202 => 'FlashModel' },
	'flashoptions' => { 174 => 0x2 },
	'flashoptions2' => { 174 => 0x10 },
	'flashoutput' => { 18 => 0x248, 35 => 0x21, 117 => 0xa, 118 => 0xa, 119 => 0xa },
	'flashpixversion' => { 61 => 0xa000, 209 => 'FlashpixVersion' },
	'flashredeyemode' => { 209 => 'FlashRedEyeMode' },
	'flashremotecontrol' => { 152 => 0x403 },
	'flashreturn' => { 209 => 'FlashReturn' },
	'flashserialnumber' => { 89 => 'SerialNumber', 153 => 0x1003 },
	'flashsetting' => { 125 => 0x8 },
	'flashshutterspeed' => { 132 => '810.2', 134 => '755.2' },
	'flashstatus' => { 177 => 0x0 },
	'flashsyncspeed' => { 132 => '810.1' },
	'flashsyncspeedav' => { 36 => 0x3, 38 => 0x10f, 39 => 0x2, 40 => 0x3, 41 => 0x2, 42 => 0x2, 43 => 0x3, 44 => 0x6 },
	'flashthreshold' => { 48 => 0x1 },
	'flashtype' => { 89 => 'Type', 125 => 0x9, 153 => 0x1000 },
	'flashwarning' => { 134 => '755.1', 168 => 0x62 },
	'flickerreduce' => { 192 => 0x218 },
	'fliphorizontal' => { 145 => 0x76a43206 },
	'fnumber' => { 2 => 0x3, 5 => 0x3, 7 => 0x3, 8 => 0x3, 9 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x5, 35 => 0x15, 61 => 0x829d, 71 => 0xfd04, 73 => 0x1e, 74 => 0xfa23, 76 => 0xf103, 79 => 0x13, 81 => 0x3c, 84 => 0xc, 93 => 'FNumber', 100 => 0xa, 101 => 0x36, 102 => 0x47, 181 => 0x13, 193 => 0x31, 209 => 'FNumber' },
	'focallength' => { 2 => 0x1d, 3 => 0xa, 4 => 0x9, 5 => 0x1d, 6 => 0x9, 7 => 0x1d, 8 => 0x1d, 9 => 0x1e, 10 => 0x1e, 11 => 0x28, 12 => 0x1e, 26 => 0x1, 58 => 0x1d, 61 => 0x920a, 79 => 0x1d, 93 => 'FocalLength', 100 => 0x12, 123 => 0xa, 124 => 0xb, 178 => 0x9, 181 => 0x1d, 209 => 'FocalLength' },
	'focallengthin35mmformat' => { 61 => 0xa405, 209 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 153 => 0x103, 157 => 0x205 },
	'focalplaneresolutionunit' => { 61 => 0xa210, 209 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 61 => 0xa20e, 209 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 26 => 0x2 },
	'focalplanexunknown' => { 26 => 0x2 },
	'focalplaneyresolution' => { 61 => 0xa20f, 209 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 26 => 0x3 },
	'focalplaneyunknown' => { 26 => 0x3 },
	'focaltype' => { 4 => 0x2d, 26 => 0x0 },
	'focalunits' => { 14 => 0x19 },
	'focus' => { 135 => 0x8 },
	'focusarea' => { 100 => 0x31 },
	'focusareaselection' => { 134 => '763.2' },
	'focuscontinuous' => { 14 => 0x20 },
	'focusdistance' => { 93 => 'FocusDistance', 100 => 0x13, 123 => 0x9, 124 => 0xa, 155 => 0x305 },
	'focusdistancelower' => { 2 => 0x45, 5 => 0x45, 7 => 0x45, 8 => 0x45, 9 => 0x52, 10 => 0x52, 12 => 0x52, 35 => 0x14 },
	'focusdistanceupper' => { 2 => 0x43, 5 => 0x43, 7 => 0x43, 8 => 0x43, 9 => 0x50, 10 => 0x50, 12 => 0x50, 35 => 0x13 },
	'focusinfoversion' => { 155 => 0x0 },
	'focusingscreen' => { 37 => 0x0, 38 => 0x80b, 43 => 0x0 },
	'focusmode' => { 14 => 0x7, 57 => 0x3, 58 => [0x3003,0xd], 65 => 0x1021, 73 => 0x38, 86 => 'FocusMode', 100 => 0x30, 102 => 0xe, 125 => 0x7, 152 => 0x301, 157 => 0x100b, 168 => 0x7, 181 => 0xd, 183 => 0x3 },
	'focusmode2' => { 174 => '3.1' },
	'focusmodesetting' => { 133 => 0x2e3 },
	'focuspixel' => { 65 => 0x1023 },
	'focuspointwrap' => { 132 => '792.2' },
	'focusposition' => { 123 => 0x8, 124 => 0x8, 181 => 0x10 },
	'focusprocess' => { 152 => 0x302 },
	'focusrange' => { 14 => 0x12, 157 => 0x100a },
	'focussetting' => { 193 => 0x6 },
	'focusstepcount' => { 155 => 0x301, 157 => 0x100e },
	'focusstepinfinity' => { 155 => 0x303 },
	'focusstepnear' => { 155 => 0x304 },
	'focustrackinglockon' => { 132 => '791.5' },
	'focuswarning' => { 65 => 0x1301 },
	'foldername' => { 100 => 0x27 },
	'fontcomposite' => { 228 => 'FontsComposite' },
	'fontface' => { 228 => 'FontsFontFace' },
	'fontfamily' => { 228 => 'FontsFontFamily' },
	'fontfilename' => { 228 => 'FontsFontFileName' },
	'fontname' => { 228 => 'FontsFontName' },
	'fonttype' => { 228 => 'FontsFontType' },
	'fontversion' => { 228 => 'FontsVersionString' },
	'for' => { 189 => 'For' },
	'format' => { 207 => 'format' },
	'forwardmatrix1' => { 61 => 0xc714 },
	'forwardmatrix2' => { 61 => 0xc715 },
	'framenum' => { 184 => 0xd7 },
	'framenumber' => { 65 => 0x8003, 181 => 0x29 },
	'freebytes' => { 51 => 0x1 },
	'freememorycardimages' => { 101 => [0x37,0x54], 102 => [0x2d,0x4a] },
	'fujiflashmode' => { 65 => 0x1010 },
	'fullsizeimage' => { 92 => 'data' },
	'fullsizeimagename' => { 92 => '1Name' },
	'fullsizeimagetype' => { 92 => '0Type' },
	'functionbutton' => { 134 => '753.2' },
	'gainbase' => { 156 => 0x610 },
	'gaincontrol' => { 61 => 0xa407, 209 => 'GainControl' },
	'gamma' => { 61 => 0xa500 },
	'gammacompensatedvalue' => { 69 => 0x91 },
	'genre' => { 215 => 'genre', 223 => 'genre' },
	'geography' => { 216 => 'geography' },
	'geotag' => { 62 => 'Geotag' },
	'geotime' => { 62 => 'Geotime' },
	'globalaltitude' => { 187 => 0x419 },
	'globalangle' => { 187 => 0x40d },
	'gpsaltitude' => { 66 => 0x6, 90 => 'Altitude', 209 => 'GPSAltitude' },
	'gpsaltituderef' => { 66 => 0x5, 209 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 66 => 0x1c, 209 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 66 => 0x1d },
	'gpsdatetime' => { 90 => 'DateTime', 209 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 66 => 0x18, 90 => 'Bearing', 209 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 66 => 0x17, 209 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 66 => 0x1a, 90 => 'Distance', 209 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 66 => 0x19, 209 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 66 => 0x14, 209 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 66 => 0x13 },
	'gpsdestlongitude' => { 66 => 0x16, 209 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 66 => 0x15 },
	'gpsdifferential' => { 66 => 0x1e, 90 => 'Differential', 209 => 'GPSDifferential' },
	'gpsdop' => { 66 => 0xb, 209 => 'GPSDOP' },
	'gpsimgdirection' => { 66 => 0x11, 209 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 66 => 0x10, 209 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 66 => 0x2, 90 => 'Latitude', 209 => 'GPSLatitude' },
	'gpslatituderef' => { 66 => 0x1 },
	'gpslongitude' => { 66 => 0x4, 90 => 'Longitude', 209 => 'GPSLongitude' },
	'gpslongituderef' => { 66 => 0x3 },
	'gpsmapdatum' => { 66 => 0x12, 90 => 'Datum', 209 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 66 => 0xa, 90 => 'MeasureMode', 209 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 66 => 0x1b, 209 => 'GPSProcessingMethod' },
	'gpssatellites' => { 66 => 0x8, 90 => 'Satellites', 209 => 'GPSSatellites' },
	'gpsspeed' => { 66 => 0xd, 90 => 'Speed', 209 => 'GPSSpeed' },
	'gpsspeedref' => { 66 => 0xc, 209 => 'GPSSpeedRef' },
	'gpsstatus' => { 66 => 0x9, 209 => 'GPSStatus' },
	'gpstimestamp' => { 66 => 0x7 },
	'gpstrack' => { 66 => 0xf, 90 => 'Heading', 209 => 'GPSTrack' },
	'gpstrackref' => { 66 => 0xe, 209 => 'GPSTrackRef' },
	'gpsversionid' => { 66 => 0x0, 209 => 'GPSVersionID' },
	'gradation' => { 152 => 0x50f },
	'graymixeraqua' => { 206 => 'GrayMixerAqua' },
	'graymixerblue' => { 206 => 'GrayMixerBlue' },
	'graymixergreen' => { 206 => 'GrayMixerGreen' },
	'graymixermagenta' => { 206 => 'GrayMixerMagenta' },
	'graymixerorange' => { 206 => 'GrayMixerOrange' },
	'graymixerpurple' => { 206 => 'GrayMixerPurple' },
	'graymixerred' => { 206 => 'GrayMixerRed' },
	'graymixeryellow' => { 206 => 'GrayMixerYellow' },
	'grayresponseunit' => { 61 => 0x122 },
	'greencurvelimits' => { 55 => 0x1c4 },
	'greencurvepoints' => { 55 => 0x19a },
	'greenhue' => { 206 => 'GreenHue' },
	'greensaturation' => { 206 => 'GreenSaturation' },
	'griddisplay' => { 132 => '803.3', 134 => '754.1' },
	'halftonehints' => { 61 => 0x141 },
	'hasalternative' => { 215 => 'hasAlternative' },
	'hascorrection' => { 215 => 'hasCorrection' },
	'hascrop' => { 206 => 'HasCrop' },
	'hasextendedxmp' => { 225 => 'HasExtendedXMP' },
	'haspreviousversion' => { 215 => 'hasPreviousVersion' },
	'hassettings' => { 206 => 'HasSettings' },
	'hastranslation' => { 215 => 'hasTranslation' },
	'headline' => { 67 => 0x69, 213 => 'Headline' },
	'hierarchicalsubject' => { 199 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 9 => 0xbb, 10 => 0xbd, 12 => 0xbd, 38 => 0x202, 125 => 0xb1, 181 => 0x71 },
	'highlight' => { 193 => 0xf },
	'highlightprotection' => { 144 => 0x6 },
	'highlightrecovery' => { 206 => 'HighlightRecovery' },
	'highlighttonepriority' => { 9 => 0x7, 10 => 0x7, 12 => 0x7, 38 => 0x203 },
	'history' => { 213 => 'History' },
	'historyaction' => { 224 => 'HistoryAction' },
	'historychanged' => { 224 => 'HistoryChanged' },
	'historyinstanceid' => { 224 => 'HistoryInstanceID' },
	'historyparameters' => { 224 => 'HistoryParameters' },
	'historysoftwareagent' => { 224 => 'HistorySoftwareAgent' },
	'historywhen' => { 224 => 'HistoryWhen' },
	'hometowncity' => { 58 => 0x3006, 181 => 0x23 },
	'hometowncitycode' => { 183 => 0x1000 },
	'hometowndst' => { 181 => 0x25 },
	'hostcomputer' => { 61 => 0x13c },
	'hue' => { 106 => 0x3b },
	'hueadj' => { 148 => 0x2f },
	'hueadjustment' => { 101 => 0x4a, 102 => 0x40, 125 => 0x92, 127 => 0x36 },
	'hueadjustmentaqua' => { 206 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 206 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 206 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 206 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 206 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 206 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 206 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 206 => 'HueAdjustmentYellow' },
	'huesetting' => { 160 => 0x1011 },
	'icc_profile' => { 62 => 'ICC_Profile' },
	'iccprofilename' => { 213 => 'ICCProfile' },
	'identifier' => { 207 => 'identifier', 221 => 'Identifier' },
	'illumination' => { 134 => '748.5' },
	'imageadjustment' => { 125 => 0x80, 135 => 0x5 },
	'imagealterationconstraints' => { 214 => 'ImageAlterationConstraints' },
	'imageareaoffset' => { 181 => 0x38 },
	'imageauthentication' => { 125 => 0x20 },
	'imageboundary' => { 125 => 0x16 },
	'imagecount' => { 125 => 0xa5 },
	'imagecreatorid' => { 214 => 'ImageCreatorImageCreatorID' },
	'imagecreatorimageid' => { 214 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 214 => 'ImageCreatorImageCreatorName' },
	'imagedatasize' => { 125 => 0xa2 },
	'imagedescription' => { 61 => 0x10e, 219 => 'ImageDescription' },
	'imageduplicationconstraints' => { 214 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 145 => 0xfe443a45 },
	'imagefileconstraints' => { 214 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 214 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 214 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 61 => 0x101, 105 => 0xc, 219 => 'ImageLength' },
	'imagehistory' => { 61 => 0x9213 },
	'imageidnumber' => { 166 => 0x340 },
	'imagenumber' => { 11 => 0xd0, 61 => 0x9211, 86 => 'ImageNumber', 101 => 0xae, 102 => 0x5e, 204 => 'ImageNumber' },
	'imagenumber2' => { 102 => 0x62 },
	'imageoptimization' => { 125 => 0xa9 },
	'imageorientation' => { 67 => 0x83 },
	'imageprocessing' => { 125 => 0x1a, 181 => 0x32 },
	'imageprocessingcount' => { 181 => 0x41 },
	'imageprocessingversion' => { 156 => 0x0 },
	'imagequality' => { 86 => 'ImageQuality', 134 => '708.1', 168 => 0x1 },
	'imagequality2' => { 152 => 0x603 },
	'imagereview' => { 133 => '729.4', 134 => '748.4' },
	'imagereviewtime' => { 133 => 0x2db },
	'imagesize' => { 92 => 'ImageSize' },
	'imagesizerestriction' => { 217 => 'imageSizeRestriction' },
	'imagesourcedata' => { 61 => 0x935c },
	'imagestabilization' => { 14 => 0x22, 58 => 0x3020, 86 => 'ImageStabilization', 101 => 0xbd, 102 => 0x71, 103 => 0x57, 104 => [0x18,0x107,0x113], 125 => 0xac, 155 => 0x1600, 168 => 0x1a, 195 => 0xb026 },
	'imagesupplierid' => { 214 => 'ImageSupplierImageSupplierID' },
	'imagesupplierimageid' => { 214 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 214 => 'ImageSupplierImageSupplierName' },
	'imagetone' => { 181 => 0x4f },
	'imagetype' => { 67 => 0x82, 214 => 'ImageType' },
	'imageuniqueid' => { 27 => 0x28, 61 => 0xa420, 209 => 'ImageUniqueID' },
	'imagewidth' => { 61 => 0x100, 105 => 0xe, 219 => 'ImageWidth' },
	'incrementaltemperature' => { 206 => 'IncrementalTemperature' },
	'incrementaltint' => { 206 => 'IncrementalTint' },
	'industry' => { 215 => 'industry', 216 => 'industry' },
	'infinitylensstep' => { 157 => 0x103b },
	'infobuttonwhenshooting' => { 38 => 0x409 },
	'ingredientsalternatepaths' => { 224 => 'IngredientsAlternatePaths' },
	'ingredientsdocumentid' => { 224 => 'IngredientsDocumentID' },
	'ingredientsfilepath' => { 224 => 'IngredientsFilePath' },
	'ingredientsfrompart' => { 224 => 'IngredientsFromPart' },
	'ingredientsinstanceid' => { 224 => 'IngredientsInstanceID' },
	'ingredientslastmodifydate' => { 224 => 'IngredientsLastModifyDate' },
	'ingredientsmanager' => { 224 => 'IngredientsManager' },
	'ingredientsmanagervariant' => { 224 => 'IngredientsManagerVariant' },
	'ingredientsmanageto' => { 224 => 'IngredientsManageTo' },
	'ingredientsmanageui' => { 224 => 'IngredientsManageUI' },
	'ingredientsmaskmarkers' => { 224 => 'IngredientsMaskMarkers' },
	'ingredientspartmapping' => { 224 => 'IngredientsPartMapping' },
	'ingredientsrenditionclass' => { 224 => 'IngredientsRenditionClass' },
	'ingredientsrenditionparams' => { 224 => 'IngredientsRenditionParams' },
	'ingredientstopart' => { 224 => 'IngredientsToPart' },
	'ingredientsversionid' => { 224 => 'IngredientsVersionID' },
	'initialzoomsetting' => { 132 => '799.3' },
	'inkset' => { 61 => 0x14c },
	'instanceid' => { 224 => 'InstanceID' },
	'instructions' => { 213 => 'Instructions' },
	'instrument' => { 223 => 'instrument' },
	'intellectualgenre' => { 210 => 'IntellectualGenre' },
	'interchangecolorspace' => { 69 => 0x40 },
	'internalflash' => { 100 => 0x2b, 132 => '813.1', 133 => '737.1', 134 => '756.1', 155 => 0x1208 },
	'internalflashae1' => { 157 => 0x1021 },
	'internalflashae1_0' => { 157 => 0x101d },
	'internalflashae2' => { 157 => 0x1022 },
	'internalflashae2_0' => { 157 => 0x101e },
	'internalflashmode' => { 177 => 0x1 },
	'internalflashstrength' => { 177 => 0x3 },
	'internalflashtable' => { 157 => 0x1024 },
	'internalserialnumber' => { 27 => 0x96, 34 => 0x9, 65 => 0x10, 153 => 0x102, 168 => 0x25, 173 => 0x4 },
	'interopindex' => { 61 => 0x1 },
	'interopversion' => { 61 => 0x2 },
	'intervallength' => { 100 => 0x10 },
	'intervalmode' => { 100 => 0x26 },
	'intervalnumber' => { 100 => 0x11 },
	'introtimescale' => { 223 => 'introTimeScale' },
	'introtimevalue' => { 223 => 'introTimeValue' },
	'iptc-naa' => { 61 => 0x83bb, 169 => 0x83bb },
	'iptcbitspersample' => { 69 => 0x56 },
	'iptcdigest' => { 187 => 0x425 },
	'iptcimageheight' => { 69 => 0x1e },
	'iptcimagerotation' => { 69 => 0x66 },
	'iptcimagewidth' => { 69 => 0x14 },
	'iptclastedited' => { 211 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 69 => 0xa },
	'iptcpixelheight' => { 69 => 0x32 },
	'iptcpixelwidth' => { 69 => 0x28 },
	'isbn' => { 215 => 'isbn' },
	'iscorrectionof' => { 215 => 'isCorrectionOf' },
	'iso' => { 2 => 0x6, 4 => 0x75, 5 => 0x6, 6 => 0x79, 7 => 0x6, 8 => 0x6, 9 => 0x6, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x0, 57 => 0x14, 58 => [0x3014,0x14], 61 => 0x8827, 71 => 0xfd06, 72 => 0x1784, 73 => 0x60, 74 => [0xfa2e,0xfa46], 75 => [0x27,0x28], 76 => 0xf105, 79 => 0x14, 81 => 0x4e, 84 => 0x34, 86 => 'ISO', 100 => 0x8, 121 => 0x0, 125 => 0x2, 169 => 0x17, 181 => 0x14, 183 => 0x14, 209 => 'ISOSpeedRatings' },
	'iso2' => { 121 => 0x6, 131 => 0x256, 132 => 0x25c },
	'isoexpansion' => { 38 => 0x103, 39 => 0x7, 40 => 0x8, 43 => 0x8, 121 => 0x4 },
	'isoexpansion2' => { 121 => 0xa },
	'isofloor' => { 174 => 0x6 },
	'isoselection' => { 125 => 0xf },
	'isosetting' => { 73 => 0x5e, 86 => 'ISOSetting', 100 => 0x24, 101 => 0x26, 102 => 0x1c, 106 => 0x6, 125 => 0x13, 174 => '17.3', 190 => 0x27, 194 => 0x16 },
	'isospeedexpansion' => { 37 => 0x3 },
	'isospeedincrements' => { 38 => 0x102 },
	'isospeedrange' => { 38 => 0x103 },
	'isostepsize' => { 132 => '796.1' },
	'isovalue' => { 157 => 0x1001 },
	'issn' => { 215 => 'issn' },
	'issueidentifier' => { 215 => 'issueIdentifier' },
	'issuename' => { 215 => 'issueName' },
	'istranslationof' => { 215 => 'isTranslationOf' },
	'jobid' => { 67 => 0xb8 },
	'jobrefid' => { 222 => 'JobRefId' },
	'jobrefname' => { 222 => 'JobRefName' },
	'jobrefurl' => { 222 => 'JobRefUrl' },
	'jpegquality' => { 4 => 0x66 },
	'jpgfromraw' => { 51 => 0x2007, 59 => 'JpgFromRaw', 169 => 0x2e },
	'jpgfromrawlength' => { 61 => [0x117,0x202] },
	'jpgfromrawstart' => { 61 => [0x111,0x201] },
	'jpgrecordedpixels' => { 174 => 0xe },
	'key' => { 223 => 'key' },
	'keyword' => { 215 => 'keyword' },
	'keywords' => { 67 => 0x19, 87 => 'Keywords', 161 => 'Keywords', 189 => 'Keywords', 212 => 'Keywords' },
	'killdate' => { 215 => 'killDate' },
	'kodakimageheight' => { 71 => 0xf908, 73 => 0xe, 74 => [0xfa1e,0xfa52], 80 => 0x70 },
	'kodakimagewidth' => { 71 => 0xf907, 73 => 0xc, 74 => [0xfa1d,0xfa51], 80 => 0x6c },
	'kodakinfotype' => { 71 => 0xfa00 },
	'kodakmaker' => { 80 => 0x8 },
	'kodakmodel' => { 73 => 0x0, 80 => 0x28 },
	'label' => { 163 => 'Label', 221 => 'Label' },
	'language' => { 207 => 'language' },
	'languageidentifier' => { 67 => 0x87 },
	'lastfilenumber' => { 100 => 0x1b },
	'lastkeywordiptc' => { 202 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 202 => 'LastKeywordXMP' },
	'lasturl' => { 224 => 'LastURL' },
	'lc1' => { 178 => 0x2 },
	'lc10' => { 178 => 0xb },
	'lc11' => { 178 => 0xc },
	'lc12' => { 178 => 0xd },
	'lc14' => { 178 => 0xf },
	'lc15' => { 178 => 0x10 },
	'lc2' => { 178 => 0x3 },
	'lc3' => { 178 => 0x4 },
	'lc4' => { 178 => 0x5 },
	'lc5' => { 178 => 0x6 },
	'lc6' => { 178 => 0x7 },
	'lc7' => { 178 => 0x8 },
	'lcddisplayatpoweron' => { 38 => 0x811, 42 => 0xa },
	'lcddisplayreturntoshoot' => { 43 => 0x12 },
	'lcdillumination' => { 132 => '807.5' },
	'lcdilluminationduringbulb' => { 38 => 0x408 },
	'lcdpanels' => { 37 => 0x8 },
	'lcheditor' => { 145 => 0x8ae85e },
	'legacyiptcdigest' => { 213 => 'LegacyIPTCDigest' },
	'lens' => { 61 => 0xfdea, 125 => 0x84, 193 => 0xa, 204 => 'Lens' },
	'lensafstopbutton' => { 36 => 0x11, 37 => 0x13, 38 => 0x506, 39 => 0x10, 40 => 0x12, 43 => 0x13, 44 => 0x9 },
	'lensaperturerange' => { 193 => 0x30 },
	'lensdistortionparams' => { 157 => 0x206 },
	'lensdrivenoaf' => { 38 => 0x505 },
	'lensfirmwareversion' => { 153 => 0x204 },
	'lensfstops' => { 122 => 0x7, 123 => 0xc, 124 => 0xd, 125 => 0x8b, 178 => '0.3' },
	'lensid' => { 204 => 'LensID' },
	'lensidnumber' => { 122 => 0x6, 123 => 0xb, 124 => 0xc },
	'lensinfo' => { 204 => 'LensInfo' },
	'lenskind' => { 178 => 0x1 },
	'lensmake' => { 93 => 'Make' },
	'lensmanufacturer' => { 202 => 'LensManufacturer' },
	'lensmodel' => { 2 => 0x937, 7 => 0x92b, 8 => 0x933, 27 => 0x95, 93 => 'Model', 202 => 'LensModel' },
	'lensproperties' => { 153 => 0x20b },
	'lensserialnumber' => { 93 => 'SerialNumber', 153 => 0x202, 168 => 0x52 },
	'lenstemperature' => { 157 => 0x1008 },
	'lenstype' => { 2 => 0xe3, 3 => 0xd, 4 => 0xd, 5 => 0x112, 6 => 0xd, 7 => 0xd7, 8 => 0xdf, 9 => 0xf7, 10 => 0xeb, 11 => [0xd,0x98], 12 => 0xe7, 14 => 0x16, 104 => 0x10c, 125 => 0x83, 153 => 0x201, 166 => 0x310, 168 => 0x51, 179 => 0x0, 180 => 0x0, 181 => 0x3f, 195 => 0xb027 },
	'levelgaugepitch' => { 152 => 0x904 },
	'levelgaugeroll' => { 152 => 0x903 },
	'license' => { 205 => 'license' },
	'licenseeid' => { 214 => 'LicenseeLicenseeID' },
	'licenseeimageid' => { 214 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 214 => 'LicenseeImageNotes' },
	'licenseename' => { 214 => 'LicenseeLicenseeName' },
	'licenseenddate' => { 214 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 214 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 214 => 'LicenseeTransactionID' },
	'licenseid' => { 214 => 'LicenseID' },
	'licensestartdate' => { 214 => 'LicenseStartDate' },
	'licensetransactiondate' => { 214 => 'LicenseTransactionDate' },
	'licensetype' => { 208 => 'licensetype' },
	'licensorcity' => { 214 => 'LicensorLicensorCity' },
	'licensorcountry' => { 214 => 'LicensorLicensorCountry' },
	'licensoremail' => { 214 => 'LicensorLicensorEmail' },
	'licensorextendedaddress' => { 214 => 'LicensorLicensorExtendedAddress' },
	'licensorid' => { 214 => 'LicensorLicensorID' },
	'licensorimageid' => { 214 => 'LicensorImageID' },
	'licensorname' => { 214 => 'LicensorLicensorName' },
	'licensornotes' => { 214 => 'LicensorNotes' },
	'licensorpostalcode' => { 214 => 'LicensorLicensorPostalCode' },
	'licensorregion' => { 214 => 'LicensorLicensorRegion' },
	'licensorstreetaddress' => { 214 => 'LicensorLicensorStreetAddress' },
	'licensortelephone1' => { 214 => 'LicensorLicensorTelephone1' },
	'licensortelephone2' => { 214 => 'LicensorLicensorTelephone2' },
	'licensortelephonetype1' => { 214 => 'LicensorLicensorTelephoneType1' },
	'licensortelephonetype2' => { 214 => 'LicensorLicensorTelephoneType2' },
	'licensortransactionid' => { 214 => 'LicensorTransactionID' },
	'licensorurl' => { 214 => 'LicensorLicensorURL' },
	'lightcondition' => { 157 => 0x1009 },
	'lightreading' => { 181 => 0x15 },
	'lightsource' => { 61 => 0x9208, 125 => 0x90, 160 => 0x1000, 209 => 'LightSource' },
	'lightsourcespecial' => { 192 => 0x21d },
	'lightvaluecenter' => { 157 => 0x103d },
	'lightvalueperiphery' => { 157 => 0x103e },
	'linearresponselimit' => { 61 => 0xc62e },
	'liveviewexposuresimulation' => { 38 => 0x810 },
	'liveviewshooting' => { 24 => 0x13 },
	'localcaption' => { 67 => 0x79 },
	'localizedcameramodel' => { 61 => 0xc615 },
	'location' => { 201 => 'Location', 210 => 'Location', 215 => 'location' },
	'locationcreatedcity' => { 211 => 'LocationCreatedCity' },
	'locationcreatedcountrycode' => { 211 => 'LocationCreatedCountryCode' },
	'locationcreatedcountryname' => { 211 => 'LocationCreatedCountryName' },
	'locationcreatedprovincestate' => { 211 => 'LocationCreatedProvinceState' },
	'locationcreatedsublocation' => { 211 => 'LocationCreatedSublocation' },
	'locationcreatedworldregion' => { 211 => 'LocationCreatedWorldRegion' },
	'locationshowncity' => { 211 => 'LocationShownCity' },
	'locationshowncountrycode' => { 211 => 'LocationShownCountryCode' },
	'locationshowncountryname' => { 211 => 'LocationShownCountryName' },
	'locationshownprovincestate' => { 211 => 'LocationShownProvinceState' },
	'locationshownsublocation' => { 211 => 'LocationShownSublocation' },
	'locationshownworldregion' => { 211 => 'LocationShownWorldRegion' },
	'lockmicrophonebutton' => { 38 => 0x709 },
	'logcomment' => { 223 => 'logComment' },
	'longexposurenoisereduction' => { 38 => 0x201, 39 => 0x1, 40 => 0x2, 41 => 0x1, 42 => 0x1, 43 => 0x2, 44 => 0x1, 195 => 0xb04e },
	'longfocal' => { 3 => 0x10, 4 => 0x13, 5 => 0x115, 6 => 0x13, 7 => 0xda, 9 => 0xfa, 10 => 0xee, 11 => 0x95, 12 => 0xea, 14 => 0x17 },
	'loop' => { 223 => 'loop' },
	'luminanceadjustmentaqua' => { 206 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 206 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 206 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 206 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 206 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 206 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 206 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 206 => 'LuminanceAdjustmentYellow' },
	'luminancenoisereduction' => { 56 => 0x5f },
	'luminancenr_tiff_jpeg' => { 56 => 0x6d },
	'luminancesmoothing' => { 206 => 'LuminanceSmoothing' },
	'm16cversion' => { 166 => 0x333 },
	'macro' => { 65 => 0x1020, 157 => 0x202, 190 => 0x21, 192 => 0x202, 195 => 0xb040 },
	'macromode' => { 14 => 0x1, 100 => 0xb, 152 => 0x300, 168 => 0x1c },
	'magnifiedview' => { 40 => 0x11, 42 => 0x9 },
	'maindialexposurecomp' => { 134 => '748.6' },
	'make' => { 52 => 0x0, 61 => 0x10f, 86 => 'Make', 163 => 'Make', 169 => 0x10f, 219 => 'Make' },
	'makernote' => { 209 => 'MakerNote' },
	'makernotecanon' => { 60 => 'MakN', 61 => 0x927c },
	'makernotecasio' => { 60 => 'MakN', 61 => 0x927c },
	'makernotecasio2' => { 60 => 'MakN', 61 => 0x927c },
	'makernotefujifilm' => { 60 => 'MakN', 61 => 0x927c },
	'makernotehp' => { 60 => 'MakN', 61 => 0x927c },
	'makernotehp2' => { 60 => 'MakN', 61 => 0x927c },
	'makernotehp4' => { 60 => 'MakN', 61 => 0x927c },
	'makernotehp6' => { 60 => 'MakN', 61 => 0x927c },
	'makernoteisl' => { 60 => 'MakN', 61 => 0x927c },
	'makernotejvc' => { 60 => 'MakN', 61 => 0x927c },
	'makernotejvctext' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak10' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak1a' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak1b' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak2' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak3' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak4' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak5' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak6a' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak6b' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak7' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak8a' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak8b' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodak9' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekodakunknown' => { 60 => 'MakN', 61 => 0x927c },
	'makernotekyocera' => { 60 => 'MakN', 61 => 0x927c },
	'makernoteleica' => { 60 => 'MakN', 61 => 0x927c },
	'makernoteleica2' => { 60 => 'MakN', 61 => 0x927c },
	'makernoteleica3' => { 60 => 'MakN', 61 => 0x927c },
	'makernoteminolta' => { 60 => 'MakN', 61 => 0x927c },
	'makernoteminolta2' => { 60 => 'MakN', 61 => 0x927c },
	'makernoteminolta3' => { 60 => 'MakN', 61 => 0x927c },
	'makernotenikon' => { 60 => 'MakN', 61 => 0x927c },
	'makernotenikon2' => { 60 => 'MakN', 61 => 0x927c },
	'makernotenikon3' => { 60 => 'MakN', 61 => 0x927c },
	'makernoteoffset' => { 192 => 0xff },
	'makernoteolympus' => { 60 => 'MakN', 61 => 0x927c },
	'makernoteolympus2' => { 60 => 'MakN', 61 => 0x927c },
	'makernotepanasonic' => { 60 => 'MakN', 61 => 0x927c },
	'makernotepanasonic2' => { 60 => 'MakN', 61 => 0x927c },
	'makernotepentax' => { 60 => 'MakN', 61 => 0x927c },
	'makernotepentax2' => { 60 => 'MakN', 61 => 0x927c },
	'makernotepentax3' => { 60 => 'MakN', 61 => 0x927c },
	'makernotepentax4' => { 60 => 'MakN', 61 => 0x927c },
	'makernotericoh' => { 60 => 'MakN', 61 => 0x927c },
	'makernotericohtext' => { 60 => 'MakN', 61 => 0x927c },
	'makernotesafety' => { 61 => 0xc635 },
	'makernotesamsung' => { 60 => 'MakN', 61 => 0x927c },
	'makernotesanyo' => { 60 => 'MakN', 61 => 0x927c },
	'makernotesanyoc4' => { 60 => 'MakN', 61 => 0x927c },
	'makernotesanyopatch' => { 60 => 'MakN', 61 => 0x927c },
	'makernotesigma' => { 60 => 'MakN', 61 => 0x927c },
	'makernotesony' => { 60 => 'MakN', 61 => 0x927c },
	'makernotesony2' => { 60 => 'MakN', 61 => 0x927c },
	'makernotesony3' => { 60 => 'MakN', 61 => 0x927c },
	'makernotesony4' => { 60 => 'MakN', 61 => 0x927c },
	'makernotesonysrf' => { 60 => 'MakN', 61 => 0x927c },
	'makernotetype' => { 191 => 0x1 },
	'makernoteunknown' => { 60 => 'MakN', 61 => 0x927c },
	'makernoteversion' => { 104 => 0x0, 125 => 0x1, 157 => 0x0, 168 => 0x8000, 191 => 0x2, 193 => 0x1d },
	'managedfromalternatepaths' => { 224 => 'ManagedFromAlternatePaths' },
	'managedfromdocumentid' => { 224 => 'ManagedFromDocumentID' },
	'managedfromfilepath' => { 224 => 'ManagedFromFilePath' },
	'managedfromfrompart' => { 224 => 'ManagedFromFromPart' },
	'managedfrominstanceid' => { 224 => 'ManagedFromInstanceID' },
	'managedfromlastmodifydate' => { 224 => 'ManagedFromLastModifyDate' },
	'managedfrommanager' => { 224 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 224 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 224 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 224 => 'ManagedFromManageUI' },
	'managedfrommaskmarkers' => { 224 => 'ManagedFromMaskMarkers' },
	'managedfrompartmapping' => { 224 => 'ManagedFromPartMapping' },
	'managedfromrenditionclass' => { 224 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 224 => 'ManagedFromRenditionParams' },
	'managedfromtopart' => { 224 => 'ManagedFromToPart' },
	'managedfromversionid' => { 224 => 'ManagedFromVersionID' },
	'manager' => { 224 => 'Manager' },
	'managervariant' => { 224 => 'ManagerVariant' },
	'manageto' => { 224 => 'ManageTo' },
	'manageui' => { 224 => 'ManageUI' },
	'manometerpressure' => { 152 => 0x900 },
	'manometerreading' => { 152 => 0x901 },
	'manualflash' => { 155 => 0x1209 },
	'manualflashoutput' => { 14 => 0x29, 133 => '737.2', 134 => '756.2' },
	'manualflashstrength' => { 152 => 0x406 },
	'manualfocusdistance' => { 125 => 0x85, 157 => 0x100c, 192 => 0x223 },
	'manualtv' => { 37 => 0x5, 38 => 0x705 },
	'manufacturedate' => { 173 => 0x1 },
	'marked' => { 212 => 'Marked', 227 => 'Marked' },
	'markerscomment' => { 223 => 'markersComment' },
	'markerscuepointparamskey' => { 223 => 'markersCuePointParamsKey' },
	'markerscuepointparamsvalue' => { 223 => 'markersCuePointParamsValue' },
	'markerscuepointtype' => { 223 => 'markersCuePointType' },
	'markersduration' => { 223 => 'markersDuration' },
	'markerslocation' => { 223 => 'markersLocation' },
	'markersname' => { 223 => 'markersName' },
	'markersprobability' => { 223 => 'markersProbability' },
	'markersspeaker' => { 223 => 'markersSpeaker' },
	'markersstarttime' => { 223 => 'markersStartTime' },
	'markerstarget' => { 223 => 'markersTarget' },
	'markerstype' => { 223 => 'markersType' },
	'maskedareas' => { 61 => 0xc68e },
	'masterdocumentid' => { 67 => 0xb9 },
	'mastergain' => { 130 => 0x50 },
	'maxaperture' => { 14 => 0x1a, 76 => 0x6103, 93 => 'MaxAperture', 100 => 0x17, 178 => '14.1' },
	'maxapertureatcurrentfocal' => { 153 => 0x20a },
	'maxapertureatmaxfocal' => { 65 => 0x1407, 93 => 'MaxApertureAtMaxFocal', 122 => 0xb, 123 => 0x10, 124 => 0x11, 153 => 0x206 },
	'maxapertureatminfocal' => { 65 => 0x1406, 122 => 0xa, 123 => 0xf, 124 => 0x10, 153 => 0x205 },
	'maxaperturevalue' => { 61 => 0x9205, 209 => 'MaxApertureValue' },
	'maxavailheight' => { 211 => 'MaxAvailHeight' },
	'maxavailwidth' => { 211 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 132 => '801.1' },
	'maxfocallength' => { 65 => 0x1405, 93 => 'MaxFocalLength', 122 => 0x9, 123 => 0xe, 124 => 0xf, 153 => 0x208 },
	'maximumdensityrange' => { 69 => 0x8c },
	'maxpagesizeh' => { 228 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 228 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 228 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 61 => 0x119 },
	'mb-d10batteries' => { 132 => '802.4' },
	'mb-d80batteries' => { 134 => '754.5' },
	'mcuversion' => { 122 => 0xc, 123 => 0x11, 124 => 0x12 },
	'md5digest' => { 94 => 'zmd5' },
	'measuredev' => { 35 => 0x3, 51 => 0x1814, 86 => 'MeasuredEV' },
	'measuredev2' => { 35 => 0x17 },
	'measuredlv' => { 166 => 0x312 },
	'measuredrggb' => { 28 => 0x1 },
	'measuredrggbdata' => { 18 => 0x287 },
	'mediaconstraints' => { 214 => 'MediaConstraints' },
	'mediasummarycode' => { 214 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 36 => 0xb, 39 => 0xa, 40 => 0xb, 43 => 0xb },
	'menubuttonreturn' => { 44 => 0xb },
	'metadatadate' => { 221 => 'MetadataDate' },
	'metadatamoddate' => { 223 => 'metadataModDate' },
	'metering' => { 133 => 0x2df },
	'meteringmode' => { 14 => 0x11, 61 => 0x9207, 73 => 0x1c, 100 => 0x7, 101 => 0x25, 152 => 0x202, 181 => 0x17, 193 => 0x9, 209 => 'MeteringMode' },
	'meteringmode2' => { 174 => '2.1' },
	'meteringmode3' => { 174 => '16.1' },
	'meteringtime' => { 132 => '812.2', 133 => '732.2', 134 => '751.2' },
	'mieversion' => { 94 => '0Vers' },
	'minaperture' => { 14 => 0x1b, 93 => 'MinAperture', 178 => '0.2' },
	'minfocallength' => { 65 => 0x1404, 93 => 'MinFocalLength', 122 => 0x8, 123 => 0xd, 124 => 0xe, 153 => 0x207 },
	'minoltadate' => { 100 => 0x15 },
	'minoltaimagesize' => { 100 => 0x4, 101 => 0xc, 102 => 0x2, 104 => 0x103 },
	'minoltamodelid' => { 100 => 0x25 },
	'minoltaquality' => { 100 => 0x5, 101 => 0xd, 102 => 0x3, 104 => [0x102,0x103], 157 => [0x102,0x103] },
	'minoltatime' => { 100 => 0x16 },
	'minormodelagedisclosure' => { 214 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 61 => 0x118 },
	'mirrorlockup' => { 36 => 0xc, 37 => 0xc, 38 => 0x60f, 39 => 0xb, 40 => 0xc, 41 => 0x6, 42 => 0x6, 43 => 0xc, 44 => 0x3 },
	'moddate' => { 212 => 'ModDate' },
	'model' => { 52 => 0x6, 61 => 0x110, 86 => 'Model', 163 => 'Model', 169 => 0x110, 219 => 'Model' },
	'modelage' => { 211 => 'ModelAge' },
	'modelingflash' => { 132 => '811.4', 134 => '755.4' },
	'modelreleaseid' => { 214 => 'ModelReleaseID' },
	'modelreleasestatus' => { 214 => 'ModelReleaseStatus' },
	'modificationdate' => { 215 => 'modificationDate' },
	'modifiedcolortemp' => { 29 => 0x9 },
	'modifieddigitalgain' => { 29 => 0xb },
	'modifiedparamflag' => { 25 => 0x1 },
	'modifiedpicturestyle' => { 29 => 0xa },
	'modifiedsaturation' => { 152 => 0x504 },
	'modifiedsensorbluelevel' => { 29 => 0x5 },
	'modifiedsensorredlevel' => { 29 => 0x4 },
	'modifiedsharpness' => { 29 => 0x2 },
	'modifiedsharpnessfreq' => { 29 => 0x3 },
	'modifiedtonecurve' => { 29 => 0x1 },
	'modifiedwhitebalance' => { 29 => 0x8 },
	'modifiedwhitebalanceblue' => { 29 => 0x7 },
	'modifiedwhitebalancered' => { 29 => 0x6 },
	'modifydate' => { 61 => 0x132, 87 => 'ModifyDate', 161 => 'ModDate', 162 => 'tIME', 189 => 'ModDate', 221 => 'ModifyDate' },
	'moirefilter' => { 61 => 0xfe58, 206 => 'MoireFilter' },
	'monitorofftime' => { 132 => '808.2', 133 => '732.1', 134 => '751.1' },
	'monochromecontrast' => { 56 => 0x3c },
	'monochromefiltereffect' => { 56 => 0x3a },
	'monochromelinear' => { 56 => 0x3d },
	'monochromesharpness' => { 56 => 0x3e },
	'monochrometoningeffect' => { 56 => 0x3b },
	'monthdaycreated' => { 73 => 0x12, 81 => 0xe },
	'morepermissions' => { 205 => 'morePermissions' },
	'multiexposureautogain' => { 126 => 0x3 },
	'multiexposuremode' => { 126 => 0x1 },
	'multiexposureshots' => { 126 => 0x2 },
	'multipleexposuremode' => { 156 => 0x101c },
	'multipleexposureset' => { 174 => '10.1' },
	'multisample' => { 130 => 0x40 },
	'multiselector' => { 132 => '799.4' },
	'multiselectorplaybackmode' => { 132 => '799.2' },
	'multiselectorshootmode' => { 132 => '799.1' },
	'mycolormode' => { 30 => 0x2 },
	'nativedigest' => { 209 => 'NativeDigest', 219 => 'NativeDigest' },
	'ncdfileinfo' => { 72 => 0x414 },
	'ndfilter' => { 35 => 0x1c },
	'nearlensstep' => { 157 => 0x103c },
	'nefcompression' => { 125 => 0x93 },
	'newsphotoversion' => { 69 => 0x0 },
	'nickname' => { 221 => 'Nickname' },
	'nikoncaptureversion' => { 125 => 0xe09 },
	'nikoniccprofile' => { 125 => 0xe1d },
	'nikonimagesize' => { 134 => 0x2c4 },
	'noisefilter' => { 152 => 0x527 },
	'noisereduction' => { 24 => 0x8, 65 => 0x100b, 101 => 0xb0, 102 => 0x60, 103 => 0x3f, 125 => 0x95, 145 => 0x753dcbc0, 146 => 0x17, 152 => 0x50a, 157 => 0x103a, 168 => 0x2d, 181 => 0x49 },
	'noisereduction2' => { 156 => 0x1010 },
	'noisereductionapplied' => { 61 => 0xc6f7 },
	'noisereductionintensity' => { 146 => 0x9 },
	'noisereductionmethod' => { 146 => 0x11 },
	'noisereductionsharpness' => { 146 => 0xd },
	'nomemorycard' => { 132 => '812.1', 133 => '729.3', 134 => '748.3' },
	'nominalmaxaperture' => { 178 => 0xa },
	'nominalminaperture' => { 178 => '10.1' },
	'notes' => { 197 => 'Notes' },
	'npages' => { 228 => 'NPages' },
	'nullrecord' => { 51 => 0x0 },
	'number' => { 215 => 'number' },
	'numberofbeats' => { 223 => 'numberOfBeats' },
	'numfacepositions' => { 164 => 0x0 },
	'numindexentries' => { 69 => 0x54 },
	'object' => { 215 => 'object' },
	'objectattributereference' => { 67 => 0x4 },
	'objectcycle' => { 67 => 0x4b },
	'objectdistance' => { 57 => 0x6, 58 => 0x2022 },
	'objectname' => { 67 => 0x5 },
	'objectpreviewdata' => { 67 => 0xca },
	'objectpreviewfileformat' => { 67 => 0xc8 },
	'objectpreviewfileversion' => { 67 => 0xc9 },
	'objecttypereference' => { 67 => 0x3 },
	'oecfcolumns' => { 209 => 'OECFColumns' },
	'oecfnames' => { 209 => 'OECFNames' },
	'oecfrows' => { 209 => 'OECFRows' },
	'oecfvalues' => { 209 => 'OECFValues' },
	'offsetschema' => { 61 => 0xea1d },
	'oldsubfiletype' => { 61 => 0xff },
	'olympusimageheight' => { 157 => 0x102f },
	'olympusimagewidth' => { 157 => 0x102e },
	'onetouchwb' => { 157 => 0x302 },
	'opticalzoom' => { 74 => 0xfa3d, 76 => [0x6006,0xf006], 77 => 0x1000, 78 => 0xf, 81 => 0x1e, 93 => 'OpticalZoom' },
	'opticalzoomcode' => { 35 => 0xa },
	'opticalzoommode' => { 168 => 0x34 },
	'opticalzoomon' => { 192 => 0x219 },
	'optionenddate' => { 217 => 'optionEndDate' },
	'ordernumber' => { 65 => 0x8002 },
	'organisationinimagecode' => { 211 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 211 => 'OrganisationInImageName' },
	'organization' => { 215 => 'organization' },
	'orientation' => { 61 => 0x112, 169 => 0x112, 219 => 'Orientation' },
	'originaldecisiondata' => { 59 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 27 => 0x83 },
	'originaldocumentid' => { 224 => 'OriginalDocumentID' },
	'originalfilename' => { 51 => 0x816, 72 => 0x3e9, 82 => 0x20 },
	'originalimageheight' => { 64 => 0x1 },
	'originalimagewidth' => { 64 => 0x0 },
	'originalrawfiledata' => { 61 => 0xc68c },
	'originalrawfiledigest' => { 61 => 0xc71d },
	'originalrawfilename' => { 61 => 0xc68b },
	'originaltransmissionreference' => { 67 => 0x67 },
	'originatingprogram' => { 67 => 0x41 },
	'originplatform' => { 215 => 'originPlatform' },
	'os' => { 208 => 'os' },
	'otherconditions' => { 214 => 'OtherConditions' },
	'otherconstraints' => { 214 => 'OtherConstraints' },
	'otherimageinfo' => { 214 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 214 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 214 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 214 => 'OtherLicenseRequirements' },
	'outcuescale' => { 223 => 'outCueScale' },
	'outcuevalue' => { 223 => 'outCueValue' },
	'outputimageheight' => { 110 => 0x3 },
	'outputimagewidth' => { 110 => 0x2 },
	'outputresolution' => { 110 => 0x4 },
	'owner' => { 227 => 'Owner' },
	'ownerid' => { 67 => 0xbc },
	'ownername' => { 27 => 0x9, 51 => 0x810, 61 => 0xfde8, 86 => 'OwnerName', 204 => 'OwnerName' },
	'padding' => { 61 => 0xea1c },
	'pageimage' => { 221 => 'PageInfoImage' },
	'pageimageformat' => { 221 => 'PageInfoFormat' },
	'pageimageheight' => { 221 => 'PageInfoHeight' },
	'pageimagepagenumber' => { 221 => 'PageInfoPageNumber' },
	'pageimagewidth' => { 221 => 'PageInfoWidth' },
	'pagename' => { 61 => 0x11d },
	'pagenumber' => { 61 => 0x129 },
	'pagerange' => { 215 => 'pageRange' },
	'panasonicexifversion' => { 168 => 0x26 },
	'panasonicrawversion' => { 169 => 0x1 },
	'panasonictitle' => { 61 => 0xc6d2 },
	'panasonictitle2' => { 61 => 0xc6d3 },
	'panoramadirection' => { 31 => 0x5 },
	'panoramaframenumber' => { 31 => 0x2 },
	'panoramamode' => { 73 => 0x3c, 152 => 0x601 },
	'parametricdarks' => { 206 => 'ParametricDarks' },
	'parametrichighlights' => { 206 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 206 => 'ParametricHighlightSplit' },
	'parametriclights' => { 206 => 'ParametricLights' },
	'parametricmidtonesplit' => { 206 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 206 => 'ParametricShadows' },
	'parametricshadowsplit' => { 206 => 'ParametricShadowSplit' },
	'patientid' => { 198 => 'PatientID' },
	'patientsbirthdate' => { 198 => 'PatientDOB' },
	'patientsname' => { 198 => 'PatientName' },
	'patientssex' => { 198 => 'PatientSex' },
	'pdfversion' => { 212 => 'PDFVersion' },
	'pentaximagesize' => { 181 => 0x9 },
	'pentaxmodelid' => { 173 => 0x0, 181 => 0x5 },
	'pentaxmodeltype' => { 181 => 0x1 },
	'pentaxversion' => { 181 => 0x0 },
	'people' => { 201 => 'People' },
	'peripheralillumination' => { 56 => 0x68 },
	'peripheralilluminationon' => { 56 => 0x64 },
	'permissions' => { 217 => 'permissions' },
	'person' => { 215 => 'person' },
	'personinimage' => { 211 => 'PersonInImage' },
	'pf0customfuncregistration' => { 46 => 0x1 },
	'pf10retainprogramshift' => { 46 => 0xb },
	'pf13drivepriority' => { 46 => 0xe },
	'pf14disablefocussearch' => { 46 => 0xf },
	'pf15disableafassistbeam' => { 46 => 0x10 },
	'pf16autofocuspointshoot' => { 46 => 0x11 },
	'pf17disableafpointsel' => { 46 => 0x12 },
	'pf18enableautoafpointsel' => { 46 => 0x13 },
	'pf19continuousshootspeed' => { 46 => 0x14 },
	'pf19shootingspeedhigh' => { 45 => 0xa },
	'pf19shootingspeedlow' => { 45 => 0x9 },
	'pf1disableshootingmodes' => { 46 => 0x2 },
	'pf1value' => { 45 => 0x1 },
	'pf20limitcontinousshots' => { 46 => 0x15 },
	'pf20maxcontinousshots' => { 45 => 0xb },
	'pf21enablequietoperation' => { 46 => 0x16 },
	'pf23felocktime' => { 45 => 0xd },
	'pf23postreleasetime' => { 45 => 0xe },
	'pf23settimerlengths' => { 46 => 0x18 },
	'pf23shutterbuttontime' => { 45 => 0xc },
	'pf24lightlcdduringbulb' => { 46 => 0x19 },
	'pf25aemode' => { 45 => 0xf },
	'pf25afmode' => { 45 => 0x12 },
	'pf25afpointsel' => { 45 => 0x13 },
	'pf25colormatrix' => { 45 => 0x17 },
	'pf25defaultclearsettings' => { 46 => 0x1a },
	'pf25drivemode' => { 45 => 0x11 },
	'pf25imagesize' => { 45 => 0x14 },
	'pf25meteringmode' => { 45 => 0x10 },
	'pf25parameters' => { 45 => 0x16 },
	'pf25wbmode' => { 45 => 0x15 },
	'pf26shortenreleaselag' => { 46 => 0x1b },
	'pf27reversedialrotation' => { 46 => 0x1c },
	'pf27value' => { 45 => 0x18 },
	'pf28noquickdialexpcomp' => { 46 => 0x1d },
	'pf29quickdialswitchoff' => { 46 => 0x1e },
	'pf2disablemeteringmodes' => { 46 => 0x3 },
	'pf2value' => { 45 => 0x2 },
	'pf30enlargementmode' => { 46 => 0x1f },
	'pf31originaldecisiondata' => { 46 => 0x20 },
	'pf3manualexposuremetering' => { 46 => 0x4 },
	'pf3value' => { 45 => 0x3 },
	'pf4exposuretimelimits' => { 46 => 0x5 },
	'pf4exposuretimemax' => { 45 => 0x5 },
	'pf4exposuretimemin' => { 45 => 0x4 },
	'pf5aperturelimits' => { 46 => 0x6 },
	'pf5aperturemax' => { 45 => 0x7 },
	'pf5aperturemin' => { 45 => 0x6 },
	'pf6presetshootingmodes' => { 46 => 0x7 },
	'pf7bracketcontinuousshoot' => { 46 => 0x8 },
	'pf8bracketshots' => { 45 => 0x8 },
	'pf8setbracketshots' => { 46 => 0x9 },
	'pf9changebracketsequence' => { 46 => 0xa },
	'phonenumber' => { 87 => 'Phone' },
	'photoeffect' => { 14 => 0x28 },
	'photoeffects' => { 145 => 0xab5eca5e },
	'photoeffectsblue' => { 147 => 0x8 },
	'photoeffectsgreen' => { 147 => 0x6 },
	'photoeffectsred' => { 147 => 0x4 },
	'photoeffectstype' => { 147 => 0x0 },
	'photoinfoplayback' => { 132 => '807.6' },
	'photometricinterpretation' => { 61 => 0x106, 219 => 'PhotometricInterpretation' },
	'photoshopquality' => { 186 => 0x0 },
	'pictinfo' => { 192 => 0x208 },
	'picturecontrol' => { 145 => 0xe2173c47 },
	'picturecontrolactive' => { 148 => 0x0 },
	'picturecontroladjust' => { 127 => 0x30 },
	'picturecontrolbase' => { 127 => 0x18 },
	'picturecontrolmode' => { 148 => 0x13 },
	'picturecontrolname' => { 127 => 0x4 },
	'picturecontrolquickadjust' => { 127 => 0x31 },
	'picturefinish' => { 101 => 0x71 },
	'picturemode' => { 65 => 0x1031, 152 => 0x520, 181 => [0xb,0x33] },
	'picturemode2' => { 174 => 0x0 },
	'picturemodebwfilter' => { 152 => 0x525 },
	'picturemodecontrast' => { 152 => 0x523 },
	'picturemodehue' => { 152 => 0x522 },
	'picturemodesaturation' => { 152 => 0x521 },
	'picturemodesharpness' => { 152 => 0x524 },
	'picturemodetone' => { 152 => 0x526 },
	'picturestyle' => { 3 => [0x4b,0x51], 4 => 0x6c, 5 => 0x86, 6 => 0x73, 9 => 0xab, 10 => 0xa7, 11 => 0x6c, 12 => 0xa7, 33 => 0xa, 56 => 0x2 },
	'planarconfiguration' => { 61 => 0x11c, 219 => 'PlanarConfiguration' },
	'platenames' => { 228 => 'PlateNames' },
	'plusversion' => { 214 => 'Version' },
	'pngwarning' => { 163 => 'Warning' },
	'postalcode' => { 91 => 'PostalCode' },
	'postcropvignetteamount' => { 206 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 206 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 206 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 206 => 'PostCropVignetteRoundness' },
	'powersource' => { 172 => 0x0 },
	'precaptureframes' => { 157 => 0x300 },
	'predictor' => { 61 => 0x13d },
	'prefs' => { 67 => 0xdd, 185 => 'Prefs' },
	'preservedfilename' => { 224 => 'PreservedFileName' },
	'previewapplicationname' => { 61 => 0xc716 },
	'previewapplicationversion' => { 61 => 0xc717 },
	'previewcolorspace' => { 61 => 0xc71a },
	'previewdatetime' => { 61 => 0xc71b },
	'previewheight' => { 74 => 0xfa58 },
	'previewimage' => { 58 => 0x2000, 59 => 'PreviewImage', 60 => 'MakN', 61 => 0x927c, 62 => 'PreviewImage', 63 => 0x4, 96 => 'data', 104 => 0x81, 157 => 0x280, 195 => 0x2001 },
	'previewimageborders' => { 181 => 0x3e },
	'previewimageheight' => { 32 => 0x4 },
	'previewimagelength' => { 32 => 0x2, 58 => 0x3, 61 => [0x117,0x202], 104 => 0x89, 128 => 0x202, 152 => 0x102, 157 => 0x1037, 181 => 0x3, 190 => 0x1e, 193 => 0x1b },
	'previewimagename' => { 96 => '1Name' },
	'previewimagesize' => { 58 => 0x2, 79 => 0x2, 96 => 'ImageSize', 181 => 0x2, 193 => 0x1c },
	'previewimagestart' => { 32 => 0x5, 58 => 0x4, 61 => [0x111,0x201], 104 => 0x88, 128 => 0x201, 152 => 0x101, 157 => 0x1036, 181 => 0x4, 190 => 0x1c, 193 => 0x1a },
	'previewimagetype' => { 96 => '0Type' },
	'previewimagevalid' => { 152 => 0x100, 157 => 0x1035 },
	'previewimagewidth' => { 32 => 0x3 },
	'previewquality' => { 32 => 0x1 },
	'previewsettingsdigest' => { 61 => 0xc719 },
	'previewsettingsname' => { 61 => 0xc718 },
	'previewwidth' => { 74 => 0xfa57 },
	'primaryafpoint' => { 109 => 0x7 },
	'primarychromaticities' => { 61 => 0x13f, 219 => 'PrimaryChromaticities' },
	'printim' => { 61 => 0xc4a5 },
	'privatertkinfo' => { 199 => 'privateRTKInfo' },
	'processingsoftware' => { 61 => 0xb },
	'producer' => { 161 => 'Producer', 212 => 'Producer' },
	'productid' => { 68 => 0x32 },
	'productioncode' => { 173 => 0x2 },
	'productorserviceconstraints' => { 214 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 61 => 0xc6f4 },
	'profilecopyright' => { 61 => 0xc6fe },
	'profileembedpolicy' => { 61 => 0xc6fd },
	'profilehuesatmapdata1' => { 61 => 0xc6fa },
	'profilehuesatmapdata2' => { 61 => 0xc6fb },
	'profilehuesatmapdims' => { 61 => 0xc6f9 },
	'profilelooktabledata' => { 61 => 0xc726 },
	'profilelooktabledims' => { 61 => 0xc725 },
	'profilename' => { 61 => 0xc6f8 },
	'profiletonecurve' => { 61 => 0xc6fc },
	'programiso' => { 168 => 0x3c },
	'programline' => { 174 => '1.1' },
	'programmode' => { 106 => 0x5 },
	'programshift' => { 125 => 0xd },
	'programversion' => { 67 => 0x46 },
	'projectrefpath' => { 223 => 'projectRefPath' },
	'projectreftype' => { 223 => 'projectRefType' },
	'propertyreleaseid' => { 214 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 214 => 'PropertyReleaseStatus' },
	'province-state' => { 67 => 0x5f },
	'publicationdate' => { 215 => 'publicationDate' },
	'publicationname' => { 215 => 'publicationName' },
	'publisher' => { 207 => 'publisher' },
	'pulldown' => { 223 => 'pullDown' },
	'quality' => { 0 => 0x1, 14 => 0x3, 57 => 0x2, 58 => 0x3002, 65 => 0x1000, 73 => 0x9, 125 => 0x4, 135 => 0x3, 157 => 0x201, 166 => 0x300, 181 => 0x8, 183 => 0x2, 193 => 0x16, 195 => [0x102,0xb047] },
	'qualitymode' => { 58 => 0x8 },
	'quantizationmethod' => { 69 => 0x78 },
	'quickadjust' => { 148 => 0x2a },
	'quickcontroldialinmeter' => { 38 => 0x703 },
	'quickshot' => { 192 => 0x213 },
	'rasterizedcaption' => { 67 => 0x7d },
	'rating' => { 61 => 0x4746, 184 => 0xdf, 208 => 'rating', 221 => 'Rating' },
	'ratingpercent' => { 61 => 0x4749, 202 => 'Rating' },
	'rawandjpgrecording' => { 36 => 0x8, 174 => 0xd },
	'rawbrightnessadj' => { 55 => 0x38 },
	'rawcoloradj' => { 55 => 0x2e },
	'rawcolortoneadj' => { 56 => 0xd },
	'rawcontrastadj' => { 56 => 0xf },
	'rawcropbottom' => { 184 => 0xd4 },
	'rawcropleft' => { 184 => 0xd1 },
	'rawcropright' => { 184 => 0xd3 },
	'rawcroptop' => { 184 => 0xd2 },
	'rawcustomsaturation' => { 55 => 0x30 },
	'rawcustomtone' => { 55 => 0x34 },
	'rawdatauniqueid' => { 61 => 0xc65d },
	'rawdepth' => { 105 => 0x10 },
	'rawdevautogradation' => { 159 => 0x119 },
	'rawdevcolorspace' => { 158 => 0x108, 159 => 0x109 },
	'rawdevcontrastvalue' => { 158 => 0x106, 159 => 0x105 },
	'rawdeveditstatus' => { 158 => 0x10b },
	'rawdevengine' => { 158 => 0x109, 159 => 0x10b },
	'rawdevexposurebiasvalue' => { 158 => 0x100, 159 => 0x100 },
	'rawdevgradation' => { 159 => 0x112 },
	'rawdevgraypoint' => { 158 => 0x103, 159 => 0x104 },
	'rawdevmemorycoloremphasis' => { 158 => 0x105, 159 => 0x108 },
	'rawdevnoisereduction' => { 158 => 0x10a, 159 => 0x10a },
	'rawdevpicturemode' => { 159 => 0x10c },
	'rawdevpm_bwfilter' => { 159 => 0x110 },
	'rawdevpmcontrast' => { 159 => 0x10e },
	'rawdevpmnoisefilter' => { 159 => 0x120 },
	'rawdevpmpicturetone' => { 159 => 0x111 },
	'rawdevpmsaturation' => { 159 => 0x10d },
	'rawdevpmsharpness' => { 159 => 0x10f },
	'rawdevsaturation3' => { 159 => 0x113 },
	'rawdevsaturationemphasis' => { 158 => 0x104, 159 => 0x107 },
	'rawdevsettings' => { 158 => 0x10c },
	'rawdevsharpnessvalue' => { 158 => 0x107, 159 => 0x106 },
	'rawdevversion' => { 158 => 0x0, 159 => 0x0 },
	'rawdevwbfineadjustment' => { 158 => 0x102, 159 => 0x103 },
	'rawdevwhitebalance' => { 159 => 0x101 },
	'rawdevwhitebalancevalue' => { 158 => 0x101, 159 => 0x102 },
	'rawfile' => { 61 => 0xfe4c },
	'rawfilename' => { 206 => 'RawFileName' },
	'rawhighlightpoint' => { 56 => 0x12 },
	'rawimagecenter' => { 125 => 0x99 },
	'rawimagedigest' => { 61 => 0xc71c },
	'rawimagesize' => { 181 => 0x39 },
	'rawinfoversion' => { 160 => 0x0 },
	'rawjpgheight' => { 53 => 0x4 },
	'rawjpgquality' => { 24 => 0x6, 53 => 0x1 },
	'rawjpgsize' => { 24 => 0x7, 53 => 0x2 },
	'rawjpgwidth' => { 53 => 0x3 },
	'rawlinear' => { 56 => 0x10 },
	'rawmeasuredrggb' => { 17 => 0x26a, 19 => 0x280 },
	'rawsaturationadj' => { 56 => 0xe },
	'rawshadowpoint' => { 56 => 0x13 },
	'rawsharpnessadj' => { 56 => 0x11 },
	'recognizedface1age' => { 165 => 0x20 },
	'recognizedface1name' => { 165 => 0x4 },
	'recognizedface1position' => { 165 => 0x18 },
	'recognizedface2age' => { 165 => 0x50 },
	'recognizedface2name' => { 165 => 0x34 },
	'recognizedface2position' => { 165 => 0x48 },
	'recognizedface3age' => { 165 => 0x80 },
	'recognizedface3name' => { 165 => 0x64 },
	'recognizedface3position' => { 165 => 0x78 },
	'recognizedfaceflags' => { 168 => 0x63 },
	'recordid' => { 51 => 0x1804 },
	'recordingmode' => { 57 => 0x1, 183 => 0x1 },
	'recordmode' => { 14 => 0x9, 58 => 0x3000 },
	'recordshutterrelease' => { 192 => 0x217 },
	'redbalance' => { 115 => 0x270, 157 => 0x1017, 169 => 0x11, 181 => 0x1c },
	'redcurvelimits' => { 55 => 0x18a },
	'redcurvepoints' => { 55 => 0x160 },
	'redeyecorrection' => { 149 => 0x0 },
	'redeyeinfo' => { 206 => 'RedEyeInfo' },
	'redhue' => { 206 => 'RedHue' },
	'redsaturation' => { 206 => 'RedSaturation' },
	'referenceblackwhite' => { 61 => 0x214, 219 => 'ReferenceBlackWhite' },
	'referencedate' => { 67 => 0x2f },
	'referencenumber' => { 67 => 0x32 },
	'references' => { 87 => 'References' },
	'referenceservice' => { 67 => 0x2d },
	'regionconstraints' => { 214 => 'RegionConstraints' },
	'regionpersondisplayname' => { 200 => 'RegionInfoRegionsPersonDisplayName' },
	'regionrectangle' => { 200 => 'RegionInfoRegionsRectangle' },
	'registryitemid' => { 211 => 'RegistryIdRegItemId' },
	'registryorganisationid' => { 211 => 'RegistryIdRegOrgId' },
	'relatedaudiofile' => { 85 => 'data' },
	'relatedaudiofilename' => { 85 => '1Name' },
	'relatedaudiofiletype' => { 85 => '0Type' },
	'relatedimagefileformat' => { 61 => 0x1000 },
	'relatedimageheight' => { 61 => 0x1002 },
	'relatedimagewidth' => { 61 => 0x1001 },
	'relatedsoundfile' => { 61 => 0xa004, 209 => 'RelatedSoundFile' },
	'relatedvideofile' => { 99 => 'data' },
	'relatedvideofilename' => { 99 => '1Name' },
	'relatedvideofiletype' => { 99 => '0Type' },
	'relation' => { 207 => 'relation' },
	'relativepeakaudiofilepath' => { 223 => 'relativePeakAudioFilePath' },
	'relativetimestampscale' => { 223 => 'relativeTimestampScale' },
	'relativetimestampvalue' => { 223 => 'relativeTimestampValue' },
	'releasebuttontousedial' => { 132 => '807.8' },
	'releasedate' => { 67 => 0x1e, 223 => 'releaseDate' },
	'releasesetting' => { 51 => 0x1016 },
	'releasetime' => { 67 => 0x23 },
	'remoteonduration' => { 133 => '732.4', 134 => '752.3' },
	'renditionclass' => { 224 => 'RenditionClass' },
	'renditionofalternatepaths' => { 224 => 'RenditionOfAlternatePaths' },
	'renditionofdocumentid' => { 224 => 'RenditionOfDocumentID' },
	'renditionoffilepath' => { 224 => 'RenditionOfFilePath' },
	'renditionoffrompart' => { 224 => 'RenditionOfFromPart' },
	'renditionofinstanceid' => { 224 => 'RenditionOfInstanceID' },
	'renditionoflastmodifydate' => { 224 => 'RenditionOfLastModifyDate' },
	'renditionofmanager' => { 224 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 224 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 224 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 224 => 'RenditionOfManageUI' },
	'renditionofmaskmarkers' => { 224 => 'RenditionOfMaskMarkers' },
	'renditionofpartmapping' => { 224 => 'RenditionOfPartMapping' },
	'renditionofrenditionclass' => { 224 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 224 => 'RenditionOfRenditionParams' },
	'renditionoftopart' => { 224 => 'RenditionOfToPart' },
	'renditionofversionid' => { 224 => 'RenditionOfVersionID' },
	'renditionparams' => { 224 => 'RenditionParams' },
	'repeatingflashcount' => { 117 => 0xd, 118 => 0xe, 119 => 0xe, 134 => '757.2' },
	'repeatingflashoutput' => { 134 => '757.1' },
	'repeatingflashrate' => { 117 => 0xc, 118 => 0xd, 119 => 0xd, 134 => '758.1' },
	'resampleparamsquality' => { 223 => 'resampleParamsQuality' },
	'resaved' => { 192 => 0x21e },
	'resolution' => { 92 => 'Resolution' },
	'resolutionmode' => { 193 => 0x4 },
	'resolutionunit' => { 61 => 0x128, 70 => 0x2, 219 => 'ResolutionUnit' },
	'restrictions' => { 217 => 'restrictions' },
	'retouchhistory' => { 125 => 0x9e },
	'retouchinfo' => { 206 => 'RetouchInfo' },
	'reuse' => { 214 => 'Reuse' },
	'reuseallowed' => { 226 => 'ReuseAllowed' },
	'reuseprohibited' => { 217 => 'reuseProhibited' },
	'reverseindicators' => { 132 => '802.1' },
	'revision' => { 208 => 'revision' },
	'rgbcurvelimits' => { 55 => 0x238 },
	'rgbcurvepoints' => { 55 => 0x20e },
	'ricohdate' => { 190 => 0x6 },
	'ricohimageheight' => { 190 => 0x2 },
	'ricohimagewidth' => { 190 => 0x0 },
	'rightascension' => { 95 => 'RightAscension' },
	'rights' => { 207 => 'rights' },
	'rightsagent' => { 215 => 'rightsAgent', 217 => 'rightsAgent' },
	'rightsowner' => { 217 => 'rightsOwner' },
	'romoperationmode' => { 51 => 0x80d },
	'rotation' => { 13 => 0x17, 50 => 0x3, 55 => 0x26e, 64 => 0x4, 95 => 'Rotation', 101 => [0x65,0x50], 102 => 0x46, 103 => 0x5a, 134 => '590.1', 145 => 0x76a43207, 168 => 0x30, 174 => '17.2', 184 => 0xd8, 194 => 0x3f },
	'routing' => { 189 => 'Routing' },
	'rowsperstrip' => { 61 => 0x116 },
	'rpp' => { 203 => 'rpp' },
	'safetyshift' => { 38 => 0x108 },
	'safetyshiftinavortv' => { 36 => 0x10, 37 => 0x10, 39 => 0xf, 40 => 0x10, 43 => 0x10 },
	'samplebits' => { 85 => 'SampleBits' },
	'samplerate' => { 85 => 'SampleRate' },
	'samplesperpixel' => { 61 => 0x115, 219 => 'SamplesPerPixel' },
	'samplestructure' => { 69 => 0x5a },
	'sanyoquality' => { 192 => 0x201 },
	'sanyothumbnail' => { 192 => 0x100 },
	'saturation' => { 4 => 0x6e, 6 => 0x76, 14 => 0xe, 21 => 0x1, 57 => 0xd, 58 => [0x3013,0x1f], 61 => [0xa409,0xfe55], 65 => 0x1003, 86 => 'Saturation', 100 => 0x1f, 101 => 0x32, 102 => 0x28, 103 => 0x1a, 106 => 0x1, 125 => [0x94,0xaa], 127 => 0x35, 168 => 0x40, 181 => 0x1f, 183 => 0xd, 190 => 0x28, 193 => 0x10, 194 => 0x1e, 206 => 'Saturation', 209 => 'Saturation' },
	'saturationadj' => { 55 => 0x116, 144 => 0x1, 148 => 0x2e },
	'saturationadjustmentaqua' => { 206 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 206 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 206 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 206 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 206 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 206 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 206 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 206 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 11 => 0xfe },
	'saturationlandscape' => { 11 => 0xfc },
	'saturationneutral' => { 11 => 0xfd },
	'saturationportrait' => { 11 => 0xfb },
	'saturationsetting' => { 160 => 0x1010 },
	'saturationstandard' => { 11 => 0xfa },
	'saturationuserdef1' => { 11 => 0x100 },
	'saturationuserdef2' => { 11 => 0x101 },
	'saturationuserdef3' => { 11 => 0x102 },
	'saveid' => { 224 => 'SaveID' },
	'scaletype' => { 223 => 'scaleType' },
	'scanimageenhancer' => { 130 => 0x60 },
	'scanningdirection' => { 69 => 0x64 },
	'scene' => { 210 => 'Scene', 223 => 'scene' },
	'scenearea' => { 155 => 0x211, 157 => 0x1031 },
	'sceneassist' => { 125 => 0x9c },
	'scenecapturetype' => { 61 => 0xa406, 209 => 'SceneCaptureType' },
	'scenedetect' => { 155 => 0x210, 157 => 0x1030 },
	'scenedetectdata' => { 155 => 0x212, 157 => 0x1033 },
	'scenemode' => { 74 => 0xfa02, 104 => 0x100, 125 => 0x8f, 152 => 0x509, 157 => 0x403, 168 => 0x8001, 195 => 0xb023 },
	'scenemodeused' => { 76 => [0x6002,0xf002] },
	'sceneselect' => { 192 => 0x21f },
	'scenetype' => { 61 => 0xa301, 209 => 'SceneType' },
	'section' => { 215 => 'section' },
	'securityclassification' => { 61 => 0x9212 },
	'selectableafpoint' => { 38 => 0x509 },
	'selftimer' => { 14 => 0x2, 58 => 0x3001, 168 => 0x2e, 192 => 0x214 },
	'selftimer2' => { 35 => 0x1d },
	'selftimermode' => { 61 => 0x882b },
	'selftimertime' => { 51 => 0x1806, 132 => '808.1', 133 => '732.3', 134 => '751.3' },
	'seminfo' => { 61 => 0x8546 },
	'sensingmethod' => { 61 => 0xa217, 209 => 'SensingMethod' },
	'sensitivityadjust' => { 181 => 0x40 },
	'sensitivitysteps' => { 174 => '17.4', 176 => 0x1 },
	'sensorbluelevel' => { 33 => 0x5 },
	'sensorcleaning' => { 44 => 0xd },
	'sensorfullheight' => { 71 => 0xf904 },
	'sensorfullwidth' => { 71 => 0xf903 },
	'sensorheight' => { 71 => 0xf901, 74 => 0xfa21, 105 => 0x8 },
	'sensorpixelsize' => { 125 => 0x9a },
	'sensorredlevel' => { 33 => 0x4 },
	'sensorsize' => { 86 => 'SensorSize' },
	'sensortemperature' => { 155 => 0x1500, 157 => 0x1007 },
	'sensorwidth' => { 71 => 0xf900, 74 => 0xfa20, 105 => 0xa },
	'sequencenumber' => { 35 => 0x9, 58 => 0x301c, 65 => 0x1101, 73 => 0x1d, 168 => 0x2b },
	'sequenceshotinterval' => { 192 => 0x224 },
	'sequentialshot' => { 192 => 0x20e },
	'serialnumber' => { 27 => 0xc, 51 => 0x180b, 61 => 0xfde9, 71 => 0xfa04, 74 => 0xfa19, 83 => 0x0, 84 => 0xa8, 86 => 'SerialNumber', 125 => 0xa0, 153 => 0x101, 157 => [0x404,0x101a], 166 => 0x303, 193 => 0x2, 204 => 'SerialNumber' },
	'serialnumberformat' => { 27 => 0x15, 51 => 0x183b },
	'seriesdatetime' => { 198 => 'SeriesDateTime' },
	'seriesdescription' => { 198 => 'SeriesDescription' },
	'seriesmodality' => { 198 => 'SeriesModality' },
	'seriesnumber' => { 198 => 'SeriesNumber' },
	'serviceidentifier' => { 68 => 0x1e },
	'setbuttoncrosskeysfunc' => { 41 => 0x0, 42 => 0x0 },
	'setbuttonwhenshooting' => { 36 => 0x1, 38 => 0x704, 44 => 0xc },
	'setfunctionwhenshooting' => { 39 => 0x0, 40 => 0x1, 43 => 0x1 },
	'shadingcompensation' => { 152 => 0x50c },
	'shadingcompensation2' => { 156 => 0x1012 },
	'shadow' => { 193 => 0xe },
	'shadowprotection' => { 144 => 0x0 },
	'shadows' => { 61 => 0xfe52, 206 => 'Shadows' },
	'shadowscale' => { 61 => 0xc633 },
	'shadowtint' => { 206 => 'ShadowTint' },
	'shakereduction' => { 182 => 0x1 },
	'sharpendetail' => { 206 => 'SharpenDetail' },
	'sharpenedgemasking' => { 206 => 'SharpenEdgeMasking' },
	'sharpeningadj' => { 148 => 0x2b },
	'sharpenradius' => { 206 => 'SharpenRadius' },
	'sharpness' => { 3 => [0x42,0x48], 4 => 0x72, 6 => 0x74, 14 => 0xf, 33 => 0x2, 57 => 0xb, 58 => [0x3011,0x21], 61 => [0xa40a,0xfe56], 65 => 0x1001, 73 => 0x6b, 81 => 0x37, 86 => 'Sharpness', 100 => 0x21, 101 => 0x30, 102 => 0x26, 103 => 0x18, 106 => 0x3, 125 => 0x6, 127 => 0x32, 157 => 0x100f, 168 => 0x41, 181 => 0x21, 183 => 0xb, 190 => 0x22, 191 => 0x1003, 193 => 0x11, 194 => 0x1c, 206 => 'Sharpness', 209 => 'Sharpness' },
	'sharpnessadj' => { 55 => 0x25a },
	'sharpnessfactor' => { 157 => 0x102a },
	'sharpnessfaithful' => { 11 => 0xf5 },
	'sharpnessfrequency' => { 3 => [0x41,0x47], 33 => 0x3 },
	'sharpnesslandscape' => { 11 => 0xf3 },
	'sharpnessmonochrome' => { 11 => 0xf6 },
	'sharpnessneutral' => { 11 => 0xf4 },
	'sharpnessportrait' => { 11 => 0xf2 },
	'sharpnesssetting' => { 152 => 0x506, 160 => 0x1013 },
	'sharpnessstandard' => { 11 => 0xf1 },
	'sharpnessuserdef1' => { 11 => 0xf7 },
	'sharpnessuserdef2' => { 11 => 0xf8 },
	'sharpnessuserdef3' => { 11 => 0xf9 },
	'shootinginfodisplay' => { 132 => '803.2' },
	'shootingmode' => { 86 => 'ShootingMode', 125 => 0x89, 168 => 0x1f },
	'shootingmodesetting' => { 133 => '734.1' },
	'shortdescription' => { 208 => 'shortdescription' },
	'shortdocumentid' => { 67 => 0xba },
	'shortfocal' => { 3 => 0xe, 4 => 0x11, 5 => 0x113, 6 => 0x11, 7 => 0xd8, 9 => 0xf8, 10 => 0xec, 11 => 0x93, 12 => 0xe8, 14 => 0x18 },
	'shortownername' => { 11 => 0xac },
	'shortreleasetimelag' => { 38 => 0x80d },
	'shotdate' => { 223 => 'shotDate' },
	'shotlocation' => { 223 => 'shotLocation' },
	'shotname' => { 223 => 'shotName' },
	'shutter-aelock' => { 36 => 0x4, 38 => 0x701, 39 => 0x3, 40 => 0x4, 41 => 0x3, 42 => 0x3, 43 => 0x4, 44 => 0x2 },
	'shutteraelbutton' => { 37 => 0x4 },
	'shutterbuttonafonbutton' => { 38 => 0x701 },
	'shuttercount' => { 5 => 0x176, 24 => 0x1, 131 => [0x6a,0x157,0x276], 132 => 0x279, 133 => 0x246, 134 => 0x24a, 181 => 0x5d },
	'shuttercurtainsync' => { 36 => 0xf, 37 => 0xf, 38 => 0x305, 39 => 0xe, 40 => 0xf, 41 => 0x8, 42 => 0x8, 43 => 0xf, 44 => 0x8 },
	'shuttermode' => { 73 => 0x1b },
	'shutterreleasebuttonae-l' => { 132 => '807.7' },
	'shutterreleasemethod' => { 51 => 0x1010 },
	'shutterreleasenocfcard' => { 36 => 0x2, 37 => 0x2, 44 => 0xf },
	'shutterreleasetiming' => { 51 => 0x1011 },
	'shutterspeedrange' => { 38 => 0x10c },
	'shutterspeedvalue' => { 47 => 0x1, 61 => 0x9201, 157 => 0x1000, 209 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 213 => 'SidecarForExtension' },
	'similarityindex' => { 67 => 0xe4 },
	'slaveflashmeteringsegments' => { 181 => 0x20b },
	'slowshutter' => { 35 => 0x8 },
	'slowsync' => { 65 => 0x1030 },
	'smoothness' => { 61 => 0xfe57, 206 => 'Smoothness' },
	'software' => { 61 => 0x131, 87 => 'Software', 163 => 'Software', 193 => 0x18, 219 => 'Software' },
	'softwareversion' => { 192 => 0x207 },
	'sonydatetime' => { 196 => 0x6 },
	'sonyimagesize' => { 194 => 0x54 },
	'source' => { 67 => 0x73, 163 => 'Source', 207 => 'source', 208 => 'source', 213 => 'Source' },
	'spatialfrequencyresponsecolumns' => { 209 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 209 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 209 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 209 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 223 => 'speakerPlacement' },
	'specialinstructions' => { 67 => 0x28 },
	'specialmode' => { 157 => 0x200, 192 => 0x200 },
	'spectralsensitivity' => { 61 => 0x8824, 209 => 'SpectralSensitivity' },
	'splittoningbalance' => { 206 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 206 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 206 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 206 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 206 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 100 => 0x2d },
	'spotfocuspointy' => { 100 => 0x2e },
	'spotmeteringmode' => { 14 => 0x27 },
	'spotmeterlinktoafpoint' => { 38 => 0x107 },
	'sractive' => { 174 => '17.1' },
	'srawquality' => { 14 => 0x2e },
	'srfocallength' => { 182 => 0x3 },
	'srhalfpresstime' => { 182 => 0x2 },
	'srresult' => { 182 => 0x0 },
	'startingpage' => { 215 => 'startingPage' },
	'starttimecodetimeformat' => { 223 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 223 => 'startTimecodeTimeValue' },
	'starttimecodevalue' => { 223 => 'startTimecodeValue' },
	'state' => { 91 => 'State', 213 => 'State' },
	'status' => { 201 => 'Status' },
	'storagemethod' => { 105 => 0x12 },
	'straightenangle' => { 145 => 0x2fc08431 },
	'stretchmode' => { 223 => 'stretchMode' },
	'studydatetime' => { 198 => 'StudyDateTime' },
	'studydescription' => { 198 => 'StudyDescription' },
	'studyid' => { 198 => 'StudyID' },
	'studyphysician' => { 198 => 'StudyPhysician' },
	'sub-location' => { 67 => 0x5c },
	'subfiledata' => { 94 => 'data' },
	'subfiledirectory' => { 94 => '1Directory' },
	'subfilemimetype' => { 94 => '2MIME' },
	'subfilename' => { 94 => '1Name' },
	'subfileresource' => { 94 => 'rsrc' },
	'subfiletype' => { 61 => 0xfe, 94 => '0Type' },
	'subject' => { 161 => 'Subject', 189 => 'Subject', 207 => 'subject', 212 => 'Subject' },
	'subjectarea' => { 61 => 0x9214, 209 => 'SubjectArea' },
	'subjectcode' => { 210 => 'SubjectCode' },
	'subjectdistance' => { 61 => 0x9206, 73 => 0x3e, 209 => 'SubjectDistance' },
	'subjectdistancerange' => { 61 => 0xa40c, 209 => 'SubjectDistanceRange' },
	'subjectlocation' => { 61 => 0xa214, 209 => 'SubjectLocation' },
	'subjectprogram' => { 100 => 0x22 },
	'subjectreference' => { 67 => 0xc },
	'subsectime' => { 61 => 0x9290 },
	'subsectimedigitized' => { 61 => 0x9292 },
	'subsectimeoriginal' => { 61 => 0x9291 },
	'subsection1' => { 215 => 'subsection1' },
	'subsection2' => { 215 => 'subsection2' },
	'subsection3' => { 215 => 'subsection3' },
	'subsection4' => { 215 => 'subsection4' },
	'superimposeddisplay' => { 36 => 0xa, 38 => 0x510, 39 => 0x9, 40 => 0xa, 43 => 0xa, 44 => 0xe },
	'supermacro' => { 27 => 0x1a },
	'supplementalcategories' => { 67 => 0x14, 213 => 'SupplementalCategories' },
	'supplementaltype' => { 69 => 0x37 },
	'svisosetting' => { 174 => 0x14 },
	'switchtoregisteredafpoint' => { 37 => 0x12, 38 => 0x50a },
	'tagged' => { 184 => 0xdd },
	'tapename' => { 223 => 'tapeName' },
	'targetaperture' => { 35 => 0x4 },
	'targetcompressionratio' => { 49 => 0x1 },
	'targetdistancesetting' => { 51 => 0x1807 },
	'targetexposuretime' => { 35 => 0x5 },
	'targetimagetype' => { 51 => 0x100a },
	'teaser' => { 215 => 'teaser' },
	'teleconverter' => { 104 => 0x105, 195 => 0x105 },
	'temperature' => { 206 => 'Temperature' },
	'tempo' => { 223 => 'tempo' },
	'termsandconditionstext' => { 214 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 214 => 'TermsAndConditionsURL' },
	'textstamp' => { 168 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 61 => 0x107 },
	'thumbnailfilename' => { 51 => 0x817 },
	'thumbnailformat' => { 221 => 'ThumbnailsFormat' },
	'thumbnailheight' => { 74 => 0xfa55, 221 => 'ThumbnailsHeight' },
	'thumbnailimage' => { 51 => 0x2008, 59 => 'ThumbnailImage', 63 => 0x3, 97 => 'data', 157 => 0x100, 221 => 'ThumbnailsImage' },
	'thumbnailimagename' => { 97 => '1Name' },
	'thumbnailimagesize' => { 97 => 'ImageSize' },
	'thumbnailimagetype' => { 97 => '0Type' },
	'thumbnailimagevalidarea' => { 27 => 0x13 },
	'thumbnaillength' => { 61 => 0x202 },
	'thumbnailoffset' => { 61 => 0x201 },
	'thumbnailwidth' => { 74 => 0xfa54, 221 => 'ThumbnailsWidth' },
	'ticker' => { 215 => 'ticker' },
	'tilelength' => { 61 => 0x143 },
	'tilewidth' => { 61 => 0x142 },
	'time' => { 72 => 0x401, 181 => 0x7 },
	'timecreated' => { 67 => 0x3c, 73 => 0x14, 81 => 0x10, 185 => 'TimeCreated' },
	'timeperiod' => { 215 => 'timePeriod' },
	'timerfunctionbutton' => { 133 => '734.2' },
	'timerlength' => { 38 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 223 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 223 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 223 => 'timeScaleParamsQuality' },
	'timesent' => { 68 => 0x50 },
	'timesignature' => { 223 => 'timeSignature' },
	'timesincepoweron' => { 168 => 0x29 },
	'timestamp' => { 5 => 0x45e, 11 => 0x11c, 163 => 'TimeStamp' },
	'timestamp1' => { 5 => 0x45a },
	'timezone' => { 137 => 0x0 },
	'timezonecode' => { 54 => 0x1 },
	'timezoneinfo' => { 54 => 0x2 },
	'timezoneoffset' => { 61 => 0x882a },
	'tint' => { 206 => 'Tint' },
	'title' => { 87 => 'Title', 161 => 'Title', 163 => 'Title', 189 => 'Title', 207 => 'title', 212 => 'Title' },
	'tonecomp' => { 125 => 0x81 },
	'tonecurve' => { 33 => 0x1, 181 => 0x402, 206 => 'ToneCurve' },
	'tonecurveactive' => { 55 => 0x110 },
	'tonecurvefilename' => { 72 => 0x1391 },
	'tonecurvename' => { 206 => 'ToneCurveName' },
	'tonecurveproperty' => { 55 => 0x3c },
	'tonecurves' => { 181 => 0x403 },
	'toningeffect' => { 24 => 0xf, 125 => 0xb3, 127 => 0x38 },
	'toningeffectmonochrome' => { 11 => 0x108 },
	'toningsaturation' => { 127 => 0x39 },
	'totalzoom' => { 73 => 0x62 },
	'tracknumber' => { 223 => 'trackNumber' },
	'tracksframerate' => { 223 => 'TracksFrameRate' },
	'tracksmarkerscomment' => { 223 => 'TracksMarkersComment' },
	'tracksmarkerscuepointparamskey' => { 223 => 'TracksMarkersCuePointParamsKey' },
	'tracksmarkerscuepointparamsvalue' => { 223 => 'TracksMarkersCuePointParamsValue' },
	'tracksmarkerscuepointtype' => { 223 => 'TracksMarkersCuePointType' },
	'tracksmarkersduration' => { 223 => 'TracksMarkersDuration' },
	'tracksmarkerslocation' => { 223 => 'TracksMarkersLocation' },
	'tracksmarkersname' => { 223 => 'TracksMarkersName' },
	'tracksmarkersprobability' => { 223 => 'TracksMarkersProbability' },
	'tracksmarkersspeaker' => { 223 => 'TracksMarkersSpeaker' },
	'tracksmarkersstarttime' => { 223 => 'TracksMarkersStartTime' },
	'tracksmarkerstarget' => { 223 => 'TracksMarkersTarget' },
	'tracksmarkerstype' => { 223 => 'TracksMarkersType' },
	'trackstrackname' => { 223 => 'TracksTrackName' },
	'trackstracktype' => { 223 => 'TracksTrackType' },
	'trailersignature' => { 94 => 'zmie' },
	'transferfunction' => { 61 => 0x12d, 219 => 'TransferFunction' },
	'transform' => { 168 => [0x8012,0x59] },
	'transmissionreference' => { 213 => 'TransmissionReference' },
	'trapped' => { 161 => 'Trapped', 212 => 'Trapped' },
	'travelday' => { 168 => 0x36 },
	'ttl_da_adown' => { 177 => 0x5 },
	'ttl_da_aup' => { 177 => 0x4 },
	'ttl_da_bdown' => { 177 => 0x7 },
	'ttl_da_bup' => { 177 => 0x6 },
	'tvexposuretimesetting' => { 174 => 0x12 },
	'type' => { 207 => 'type' },
	'uniquecameramodel' => { 61 => 0xc614 },
	'uniquedocumentid' => { 67 => 0xbb },
	'uniqueobjectname' => { 68 => 0x64 },
	'unknownblock' => { 156 => 0x1103 },
	'unknowncompensation' => { 193 => 0xc },
	'unknownev' => { 72 => 0x1 },
	'unknownnumber' => { 51 => 0x180b },
	'unsharp1color' => { 150 => 0x13 },
	'unsharp1halowidth' => { 150 => 0x19 },
	'unsharp1intensity' => { 150 => 0x17 },
	'unsharp1threshold' => { 150 => 0x1b },
	'unsharp2color' => { 150 => 0x2e },
	'unsharp2halowidth' => { 150 => 0x34 },
	'unsharp2intensity' => { 150 => 0x32 },
	'unsharp2threshold' => { 150 => 0x36 },
	'unsharp3color' => { 150 => 0x49 },
	'unsharp3halowidth' => { 150 => 0x4f },
	'unsharp3intensity' => { 150 => 0x4d },
	'unsharp3threshold' => { 150 => 0x51 },
	'unsharp4color' => { 150 => 0x64 },
	'unsharp4halowidth' => { 150 => 0x6a },
	'unsharp4intensity' => { 150 => 0x68 },
	'unsharp4threshold' => { 150 => 0x6c },
	'unsharpcount' => { 150 => 0x0 },
	'unsharpmask' => { 145 => 0x76a43200 },
	'urgency' => { 67 => 0xa, 213 => 'Urgency' },
	'url' => { 87 => 'URL', 163 => 'URL', 187 => 0x40b, 215 => 'url' },
	'usablemeteringmodes' => { 38 => 0x10a },
	'usableshootingmodes' => { 38 => 0x109 },
	'usage' => { 216 => 'usage' },
	'usagefee' => { 217 => 'usageFee' },
	'usageterms' => { 227 => 'UsageTerms' },
	'usercomment' => { 51 => 0x805, 61 => 0x9286, 209 => 'UserComment' },
	'userdef1picturestyle' => { 11 => 0x10c },
	'userdef2picturestyle' => { 11 => 0x10e },
	'userdef3picturestyle' => { 11 => 0x110 },
	'userfields' => { 201 => 'UserFields' },
	'userprofile' => { 166 => 0x302 },
	'usmlenselectronicmf' => { 37 => 0x7, 38 => 0x501 },
	'utmeasting' => { 98 => 'Easting' },
	'utmmapdatum' => { 98 => 'Datum' },
	'utmnorthing' => { 98 => 'Northing' },
	'utmzone' => { 98 => 'Zone' },
	'uv-irfiltercorrection' => { 166 => 0x325 },
	'validbits' => { 156 => 0x611, 157 => 0x102c },
	'validpixeldepth' => { 160 => 0x611 },
	'variousmodes' => { 73 => 0x26 },
	'variousmodes2' => { 73 => 0x3a },
	'variprogram' => { 125 => 0xab },
	'version' => { 65 => 0x0, 189 => 'Version', 206 => 'Version' },
	'versionid' => { 224 => 'VersionID' },
	'versionidentifier' => { 215 => 'versionIdentifier' },
	'versionscomments' => { 224 => 'VersionsComments' },
	'versionseventaction' => { 224 => 'VersionsEventAction' },
	'versionseventchanged' => { 224 => 'VersionsEventChanged' },
	'versionseventinstanceid' => { 224 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 224 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 224 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 224 => 'VersionsEventWhen' },
	'versionsmodifier' => { 224 => 'VersionsModifier' },
	'versionsmodifydate' => { 224 => 'VersionsModifyDate' },
	'versionsversion' => { 224 => 'VersionsVersion' },
	'vibrance' => { 206 => 'Vibrance' },
	'vibrationreduction' => { 131 => [0x75,0x82,0x1ae], 133 => '586.1', 134 => '590.2', 136 => 0x4 },
	'videoalphamode' => { 223 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 223 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 223 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 223 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 223 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 223 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 223 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 223 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 223 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 223 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 223 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 223 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 223 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 223 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 223 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 223 => 'videoColorSpace' },
	'videocompressor' => { 223 => 'videoCompressor' },
	'videofieldorder' => { 223 => 'videoFieldOrder' },
	'videoframerate' => { 223 => 'videoFrameRate' },
	'videoframesizeh' => { 223 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 223 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 223 => 'videoFrameSizeW' },
	'videomoddate' => { 223 => 'videoModDate' },
	'videopixelaspectratio' => { 223 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 223 => 'videoPixelDepth' },
	'viewfinderwarning' => { 132 => '803.4', 134 => '754.2' },
	'viewinfoduringexposure' => { 38 => 0x407 },
	'vignetteamount' => { 206 => 'VignetteAmount' },
	'vignettecontrol' => { 125 => 0x2a, 145 => 0x76a43205 },
	'vignettecontrolintensity' => { 145 => 0xac6bd5c0 },
	'vignettemidpoint' => { 206 => 'VignetteMidpoint' },
	'voicememo' => { 192 => 0x216 },
	'volume' => { 215 => 'volume' },
	'vr_0x66' => { 131 => 0x66 },
	'vrdoffset' => { 27 => 0xd0 },
	'wb_gbrglevels' => { 107 => 0x4 },
	'wb_glevel' => { 156 => 0x11f },
	'wb_glevel3000k' => { 156 => 0x113 },
	'wb_glevel3300k' => { 156 => 0x114 },
	'wb_glevel3600k' => { 156 => 0x115 },
	'wb_glevel3900k' => { 156 => 0x116 },
	'wb_glevel4000k' => { 156 => 0x117 },
	'wb_glevel4300k' => { 156 => 0x118 },
	'wb_glevel4500k' => { 156 => 0x119 },
	'wb_glevel4800k' => { 156 => 0x11a },
	'wb_glevel5300k' => { 156 => 0x11b },
	'wb_glevel6000k' => { 156 => 0x11c },
	'wb_glevel6600k' => { 156 => 0x11d },
	'wb_glevel7500k' => { 156 => 0x11e },
	'wb_grbglevels' => { 114 => 0x0 },
	'wb_rbgglevels' => { 111 => 0x0 },
	'wb_rblevels' => { 125 => 0xc, 156 => 0x100 },
	'wb_rblevels3000k' => { 156 => 0x102 },
	'wb_rblevels3300k' => { 156 => 0x103 },
	'wb_rblevels3600k' => { 156 => 0x104 },
	'wb_rblevels3900k' => { 156 => 0x105 },
	'wb_rblevels4000k' => { 156 => 0x106 },
	'wb_rblevels4300k' => { 156 => 0x107 },
	'wb_rblevels4500k' => { 156 => 0x108 },
	'wb_rblevels4800k' => { 156 => 0x109 },
	'wb_rblevels5300k' => { 156 => 0x10a },
	'wb_rblevels6000k' => { 156 => 0x10b },
	'wb_rblevels6600k' => { 156 => 0x10c },
	'wb_rblevels7500k' => { 156 => 0x10d },
	'wb_rblevelsauto' => { 160 => 0x110 },
	'wb_rblevelscloudy' => { 160 => 0x121 },
	'wb_rblevelscoolwhitefluor' => { 160 => 0x132 },
	'wb_rblevelscwb1' => { 156 => 0x10e },
	'wb_rblevelscwb2' => { 156 => 0x10f },
	'wb_rblevelscwb3' => { 156 => 0x110 },
	'wb_rblevelscwb4' => { 156 => 0x111 },
	'wb_rblevelsdaylightfluor' => { 160 => 0x130 },
	'wb_rblevelsdaywhitefluor' => { 160 => 0x131 },
	'wb_rblevelseveningsunlight' => { 160 => 0x124 },
	'wb_rblevelsfineweather' => { 160 => 0x122 },
	'wb_rblevelsshade' => { 160 => 0x120 },
	'wb_rblevelstungsten' => { 160 => 0x123 },
	'wb_rblevelsused' => { 160 => 0x100 },
	'wb_rblevelswhitefluorescent' => { 160 => 0x133 },
	'wb_rgbglevels' => { 113 => 0x0 },
	'wb_rgblevels' => { 167 => 0xd },
	'wb_rggblevels' => { 107 => 0x4, 112 => 0x0 },
	'wb_rggblevelsasshot' => { 16 => 0x19, 17 => 0x22, 18 => 0x3f, 19 => 0x3f, 20 => 0x47 },
	'wb_rggblevelsauto' => { 15 => 0x0, 16 => 0x1e, 17 => 0x18, 18 => 0x44, 19 => 0x44, 20 => 0x4c },
	'wb_rggblevelscloudy' => { 15 => 0xc, 16 => 0x2d, 17 => 0x31, 18 => 0x58, 19 => 0x5d, 20 => 0x65, 181 => 0x20f },
	'wb_rggblevelscustom' => { 15 => 0x1c, 18 => 0x80 },
	'wb_rggblevelscustom1' => { 16 => 0x41 },
	'wb_rggblevelscustom2' => { 16 => 0x46 },
	'wb_rggblevelsdaylight' => { 15 => 0x4, 16 => 0x23, 17 => 0x27, 18 => 0x4e, 19 => 0x53, 20 => 0x5b, 181 => 0x20d },
	'wb_rggblevelsflash' => { 15 => 0x18, 16 => 0x3c, 17 => 0x45, 18 => 0x6c, 19 => 0x71, 20 => 0x79, 181 => 0x214 },
	'wb_rggblevelsfluorescent' => { 15 => 0x14, 16 => 0x37, 17 => 0x3b, 18 => 0x62, 19 => 0x67, 20 => 0x6f },
	'wb_rggblevelsfluorescentd' => { 181 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 181 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 181 => 0x213 },
	'wb_rggblevelskelvin' => { 15 => 0x20, 17 => 0x40, 18 => 0x67, 19 => 0x6c, 20 => 0x74 },
	'wb_rggblevelsmeasured' => { 18 => 0x49, 19 => 0x49, 20 => 0x51 },
	'wb_rggblevelspc1' => { 17 => 0x90, 18 => 0x71 },
	'wb_rggblevelspc2' => { 17 => 0x95, 18 => 0x76 },
	'wb_rggblevelspc3' => { 17 => 0x9a, 18 => 0x7b },
	'wb_rggblevelsshade' => { 15 => 0x8, 16 => 0x28, 17 => 0x2c, 18 => 0x53, 19 => 0x58, 20 => 0x60, 181 => 0x20e },
	'wb_rggblevelstungsten' => { 15 => 0x10, 16 => 0x32, 17 => 0x36, 18 => 0x5d, 19 => 0x62, 20 => 0x6a, 181 => 0x210 },
	'wb_rggblevelsunknown' => { 17 => 0x1d, 19 => 0x4e, 20 => 0x56 },
	'wb_rggblevelsunknown10' => { 17 => 0x72, 19 => 0x9e, 20 => 0xa6 },
	'wb_rggblevelsunknown11' => { 17 => 0x77, 19 => 0xa3, 20 => 0xab },
	'wb_rggblevelsunknown12' => { 17 => 0x7c, 20 => 0xb0 },
	'wb_rggblevelsunknown13' => { 17 => 0x81, 20 => 0xb5 },
	'wb_rggblevelsunknown14' => { 17 => 0x86 },
	'wb_rggblevelsunknown15' => { 17 => 0x8b },
	'wb_rggblevelsunknown16' => { 17 => 0x9f },
	'wb_rggblevelsunknown2' => { 17 => 0x4a, 19 => 0x76, 20 => 0x7e },
	'wb_rggblevelsunknown3' => { 17 => 0x4f, 19 => 0x7b, 20 => 0x83 },
	'wb_rggblevelsunknown4' => { 17 => 0x54, 19 => 0x80, 20 => 0x88 },
	'wb_rggblevelsunknown5' => { 17 => 0x59, 19 => 0x85, 20 => 0x8d },
	'wb_rggblevelsunknown6' => { 17 => 0x5e, 19 => 0x8a, 20 => 0x92 },
	'wb_rggblevelsunknown7' => { 17 => 0x63, 19 => 0x8f, 20 => 0x97 },
	'wb_rggblevelsunknown8' => { 17 => 0x68, 19 => 0x94, 20 => 0x9c },
	'wb_rggblevelsunknown9' => { 17 => 0x6d, 19 => 0x99, 20 => 0xa1 },
	'wbadjbluebalance' => { 151 => 0x8 },
	'wbadjcolortemp' => { 55 => 0x1a },
	'wbadjlighting' => { 151 => 0x15 },
	'wbadjlightingsubtype' => { 151 => 0x14 },
	'wbadjmode' => { 151 => 0x10 },
	'wbadjredbalance' => { 151 => 0x0 },
	'wbadjrgblevels' => { 55 => 0x8 },
	'wbadjtemperature' => { 151 => 0x18 },
	'wbadjtint' => { 151 => 0x25 },
	'wbadjustab' => { 168 => 0x46 },
	'wbadjustgm' => { 168 => 0x47 },
	'wbbluelevel' => { 166 => 0x324, 168 => 0x8006, 169 => 0x26 },
	'wbbracketmode' => { 24 => 0x9 },
	'wbbracketvalueab' => { 24 => 0xc },
	'wbbracketvaluegm' => { 24 => 0xd },
	'wbfinetuneactive' => { 55 => 0x24 },
	'wbfinetunesaturation' => { 55 => 0x28 },
	'wbfinetunetone' => { 55 => 0x2c },
	'wbgreenlevel' => { 166 => 0x323, 168 => 0x8005, 169 => 0x25 },
	'wbmediaimagesizesetting' => { 38 => 0x708 },
	'wbmode' => { 106 => 0x4, 157 => 0x1015 },
	'wbredlevel' => { 166 => 0x322, 168 => 0x8004, 169 => 0x24 },
	'wbscale' => { 107 => 0x0 },
	'wbshiftab' => { 33 => 0xc, 175 => 0x10 },
	'wbshiftgm' => { 33 => 0xd },
	'wbshiftmg' => { 175 => 0x11 },
	'webstatement' => { 227 => 'WebStatement' },
	'whitebalance' => { 2 => 0x6f, 3 => [0x44,0x4a], 4 => 0x36, 5 => 0x5e, 6 => 0x36, 7 => 0x6f, 8 => 0x6f, 9 => 0x73, 10 => 0x6f, 11 => 0x54, 12 => 0x6f, 33 => 0x8, 35 => 0x7, 57 => 0x7, 58 => [0x19,0x2012], 61 => [0xa403,0xfe4e], 65 => 0x1002, 73 => 0x40, 100 => 0x3, 101 => 0xe, 102 => 0x4, 103 => 0xb, 125 => 0x5, 135 => 0x7, 166 => 0x304, 168 => 0x3, 181 => 0x19, 183 => 0x7, 190 => 0x26, 193 => [0x3c,0x7], 206 => 'WhiteBalance', 209 => 'WhiteBalance' },
	'whitebalance2' => { 152 => 0x500 },
	'whitebalanceadj' => { 55 => 0x18, 145 => 0x76a43204 },
	'whitebalancebias' => { 58 => 0x2011, 157 => 0x304, 168 => 0x23 },
	'whitebalanceblue' => { 33 => 0x7 },
	'whitebalancebracket' => { 152 => 0x502, 157 => 0x303 },
	'whitebalancecomp' => { 160 => 0x1001 },
	'whitebalancefinetune' => { 65 => 0x100a, 125 => 0xb, 195 => 0x112 },
	'whitebalancemode' => { 181 => 0x1a },
	'whitebalancered' => { 33 => 0x6 },
	'whitebalanceset' => { 174 => 0xa },
	'whitebalancetemperature' => { 152 => 0x501 },
	'whiteboard' => { 157 => 0x301 },
	'whitelevel' => { 61 => 0xc61d },
	'whitepoint' => { 61 => 0x13e, 181 => 0x201, 219 => 'WhitePoint' },
	'widefocuszone' => { 100 => 0x2f },
	'widerange' => { 192 => 0x20f },
	'wordcount' => { 215 => 'wordCount' },
	'workcolorspace' => { 55 => 0x270 },
	'worldtimelocation' => { 168 => 0x3a, 181 => 0x22 },
	'writer-editor' => { 67 => 0x7a },
	'x3filllight' => { 193 => 0x12 },
	'xmp' => { 62 => 'XMP' },
	'xmptoolkit' => { 220 => 'xmptk' },
	'xpauthor' => { 61 => 0x9c9d },
	'xpcomment' => { 61 => 0x9c9c },
	'xpkeywords' => { 61 => 0x9c9e },
	'xposition' => { 61 => 0x11e },
	'xpsubject' => { 61 => 0x9c9f },
	'xptitle' => { 61 => 0x9c9b },
	'xresolution' => { 61 => 0x11a, 70 => 0x3, 188 => 0x0, 219 => 'XResolution' },
	'xyresolution' => { 64 => 0x3 },
	'ycbcrcoefficients' => { 61 => 0x211, 219 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 61 => 0x213, 219 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 61 => 0x212, 219 => 'YCbCrSubSampling' },
	'yearcreated' => { 73 => 0x10, 81 => 0xc },
	'yposition' => { 61 => 0x11f },
	'yresolution' => { 61 => 0x11b, 70 => 0x5, 188 => 0x4, 219 => 'YResolution' },
	'zonematching' => { 104 => 0x10a, 106 => 0x3a, 195 => 0xb024 },
	'zonematchingon' => { 102 => 0x75 },
	'zoomsourcewidth' => { 14 => 0x24 },
	'zoomstepcount' => { 155 => 0x300, 157 => 0x100d },
	'zoomtargetwidth' => { 14 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_stream' => 1,
	'abstract' => 1,
	'acdsee' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'afareaheight' => 1,
	'afareaheights' => 1,
	'afareawidth' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afimageheight' => 1,
	'afimagewidth' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afmicroadj' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'applicationdata' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosamplebits' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiovendorid' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitflag' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'cameramodel' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'chapter' => 1,
	'characterset' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'charset' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'company' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cropx' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropy' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'cuepoint' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'djvuversion' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'entrypoint' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipment2' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrafieldlength' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetinfo' => 1,
	'facerecinfo' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileattributes' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filenamelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileversionnumber' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focusinfo2' => 1,
	'focuspos' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'gradientbasedcorractive' => 1,
	'gradientbasedcorramount' => 1,
	'gradientbasedcorrbrightness' => 1,
	'gradientbasedcorrclarity' => 1,
	'gradientbasedcorrcontrast' => 1,
	'gradientbasedcorrexposure' => 1,
	'gradientbasedcorrhue' => 1,
	'gradientbasedcorrmaskcenterweight' => 1,
	'gradientbasedcorrmaskdabs' => 1,
	'gradientbasedcorrmaskflow' => 1,
	'gradientbasedcorrmaskfullx' => 1,
	'gradientbasedcorrmaskfully' => 1,
	'gradientbasedcorrmaskradius' => 1,
	'gradientbasedcorrmaskvalue' => 1,
	'gradientbasedcorrmaskwhat' => 1,
	'gradientbasedcorrmaskzerox' => 1,
	'gradientbasedcorrmaskzeroy' => 1,
	'gradientbasedcorrsaturation' => 1,
	'gradientbasedcorrsharpness' => 1,
	'gradientbasedcorrwhat' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'howpublished' => 1,
	'http-equiv' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'illustrator' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessing2' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'includedfileid' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internalname' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isoinfo' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'itch' => 1,
	'item' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastkeyframetime' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'libraryid' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mp' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikon_0x00b9' => 1,
	'nikon_avitags_0x000d' => 1,
	'nikon_avitags_0x000e' => 1,
	'nikon_avitags_0x0015' => 1,
	'nikon_avitags_0x0017' => 1,
	'nikon_avitags_0x0019' => 1,
	'nikon_avitags_0x001c' => 1,
	'nikon_avitags_0x801a' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikoncaptureoutput' => 1,
	'nikondata' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'noise' => 1,
	'noiseprofile' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2200' => 1,
	'olympus2300' => 1,
	'olympus2400' => 1,
	'olympus2500' => 1,
	'olympus2600' => 1,
	'olympus2700' => 1,
	'olympus2800' => 1,
	'olympus2900' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'osversion' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintcorrectionactive' => 1,
	'paintcorrectionamount' => 1,
	'paintcorrectionbrightness' => 1,
	'paintcorrectionclarity' => 1,
	'paintcorrectioncontrast' => 1,
	'paintcorrectionexposure' => 1,
	'paintcorrectionhue' => 1,
	'paintcorrectionmaskcenterweight' => 1,
	'paintcorrectionmaskdabs' => 1,
	'paintcorrectionmaskflow' => 1,
	'paintcorrectionmaskfullx' => 1,
	'paintcorrectionmaskfully' => 1,
	'paintcorrectionmaskradius' => 1,
	'paintcorrectionmaskvalue' => 1,
	'paintcorrectionmaskwhat' => 1,
	'paintcorrectionmaskzerox' => 1,
	'paintcorrectionmaskzeroy' => 1,
	'paintcorrectionsaturation' => 1,
	'paintcorrectionsharpness' => 1,
	'paintcorrectionwhat' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'petype' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'pictureinfo' => 1,
	'pieceinfo' => 1,
	'pitchangle' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2_2' => 1,
	'rawdevelopment' => 1,
	'rawdevelopment2' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfo2' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'realtimestreamingprotocol' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'renderingintent' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollangle' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sampletable' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationinfo' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'school' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300' => 1,
	'shotinfod40' => 1,
	'shotinfod80' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'svgversion' => 1,
	'synchronizedlyrictext' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'tdat' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodenumber' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknownjunk' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videosampledesc' => 1,
	'videosize' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grgblevels' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wcsprofiles' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'x' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zipversion' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2009, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
