# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl t/Canon.t'

######################### We start with some black magic to print on failure.

# Change "1..N" below to so that N matches last test number

BEGIN { $| = 1; print "1..3\n"; $Image::ExifTool::noConfig = 1; }
END {print "not ok 1\n" unless $loaded;}

# test 1: Load ExifTool
use Image::ExifTool 'ImageInfo';
use Image::ExifTool::Canon;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

use t::TestLib;

my $testname = 'Canon';
my $testnum = 1;

# test 2: Extract information from Canon1DmkIII.jpg
{
    ++$testnum;
    my $exifTool = new Image::ExifTool;
    my $info = $exifTool->ImageInfo('t/images/Canon1DmkIII.jpg');
    print 'not ' unless check($exifTool, $info, $testname, $testnum);
    print "ok $testnum\n";
}

# test 3: Write CanonCustom2 information
{
    ++$testnum;
    my @writeInfo = (
        [ISOSpeedRange => 'Enable; 1600; 200'],
        [TimerLength => 'Enable; 6 sec: 5; 16 sec: 20; After release: 6'],
    );
    print 'not ' unless writeCheck(\@writeInfo, $testname, $testnum, 't/images/Canon1DmkIII.jpg', 1);
    print "ok $testnum\n";
}


# end
