BEGIN {				# Magic Perl CORE pragma
    if ($ENV{PERL_CORE}) {
        chdir 't' if -d 't';
        @INC = '../lib';
    }
}

use Test::More tests => 11;

BEGIN { use_ok('PerlIO::via::QuotedPrint') }

my $file = 'test.qp';

my $decoded = <<EOD;
This is a tst for quoted-printable text that has hrdly any speial characters
in it.
EOD

my $encoded = <<EOD;
This is a t=E9st for quoted-printable text that has h=E0rdly any spe=E7ial =
characters
in it.
EOD

# Create the encoded test-file

ok(
 open( my $out,'>:via(PerlIO::via::QuotedPrint)', $file ),
 "opening '$file' for writing"
);

ok( (print $out $decoded),		'print to file' );
ok( close( $out ),			'closing encoding handle' );

# Check encoding without layers

{
local $/ = undef;
ok( open( my $test,$file ),		'opening without layer' );
is( $encoded,readline( $test ),		'check encoded content' );
ok( close( $test ),			'close test handle' );
}

# Check decoding _with_ layers

ok(
 open( my $in,'<:via(PerlIO::via::QuotedPrint)', $file ),
 "opening '$file' for reading"
);
is( $decoded,join( '',<$in> ),		'check decoding' );
ok( close( $in ),			'close decoding handle' );

# Remove whatever we created now

ok( unlink( $file ),			"remove test file '$file'" );
