=head1 NAME

SQL::Routine::L::en - Localization of SQL::Routine for English

=cut

######################################################################

package SQL::Routine::L::en;
use 5.006;
use strict;
use warnings;
our $VERSION = '0.19';

######################################################################

=head1 DEPENDENCIES

Perl Version: 5.006

Standard Modules: I<none>

Nonstandard Modules: I<This module has no enforced dependencies, but it is
designed to be used by Locale::KeyedText when that module localizes error
messages generated by SQL::Routine.>

=head1 COPYRIGHT AND LICENSE

This file is part of the SQL::Routine library (libSQLRT).

SQL::Routine is Copyright (c) 1999-2004, Darren R. Duncan.  All rights
reserved. Address comments, suggestions, and bug reports to
B<perl@DarrenDuncan.net>, or visit "http://www.DarrenDuncan.net" for more
information.

SQL::Routine is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License (GPL) version 2 as published by the
Free Software Foundation (http://www.fsf.org/).  You should have received a
copy of the GPL as part of the SQL::Routine distribution, in the file named
"LICENSE"; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA.

Linking SQL::Routine statically or dynamically with other modules is making a
combined work based on SQL::Routine.  Thus, the terms and conditions of the GPL
cover the whole combination.  As a special exception, the copyright holders of
SQL::Routine give you permission to link SQL::Routine with independent modules,
regardless of the license terms of these independent modules, and to copy and
distribute the resulting combined work under terms of your choice, provided
that every copy of the combined work is accompanied by a complete copy of the
source code of SQL::Routine (the version of SQL::Routine used to produce the
combined work), being distributed under the terms of the GPL plus this
exception.  An independent module is a module which is not derived from or
based on SQL::Routine, and which is fully useable when not linked to
SQL::Routine in any form.

Any versions of SQL::Routine that you modify and distribute must carry
prominent notices stating that you changed the files and the date of any
changes, in addition to preserving this original copyright notice and other
credits. SQL::Routine is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.

While it is by no means required, the copyright holders of SQL::Routine would
appreciate being informed any time you create a modified version of
SQL::Routine that you are willing to distribute, because that is a practical
way of suggesting improvements to the standard version.

=cut

######################################################################

my $CC = 'SQL::Routine::Container';
my $CN = 'SQL::Routine::Node';
my $ABSINTF = 'using abstract interface';

my %text_strings = (
	'SRT_C_GET_NODE_NO_ARG_TYPE' => 
		"$CC.get_node(): missing NODE_TYPE argument",
	'SRT_C_GET_NODE_NO_ARG_ID' => 
		"$CC.get_node(): missing NODE_ID argument",
	'SRT_C_GET_NODE_BAD_TYPE' => 
		"$CC.get_node(): invalid NODE_TYPE argument; there is no Node Type named '{ARGNTYPE}'",

	'SRT_C_GET_CH_NODES_BAD_TYPE' => 
		"$CC.get_child_nodes(): invalid NODE_TYPE argument; there is no Node Type named '{ARGNTYPE}'",

	'SRT_C_GET_NFNI_NO_ARG_TYPE' => 
		"$CC.get_next_free_node_id(): missing NODE_TYPE argument",
	'SRT_C_GET_NFNI_BAD_TYPE' => 
		"$CC.get_next_free_node_id(): invalid NODE_TYPE argument; there is no Node Type named '{ARGNTYPE}'",

	'SRT_C_BUILD_CH_ND_NO_PSND' => 
		"$CC.build_child_node(): invalid NODE_TYPE argument; a '{ARGNTYPE}' Node does not ".
		"have a pseudo-Node parent and can not be made a direct child of a Container",

	'SRT_N_NEW_NODE_NO_ARGS' => 
		"$CN.new_node(): missing NODE_TYPE argument",
	'SRT_N_NEW_NODE_BAD_TYPE' => 
		"$CN.new_node(): invalid NODE_TYPE argument; there is no Node Type named '{ARGNTYPE}'",

	'SRT_N_DEL_NODE_IN_CONT' => 
		"$CN.delete_node(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"this Node can not be deleted because it is ".
		"still in a Container; you must take it from there first",

	'SRT_N_CLEAR_NODE_ID_IN_CONT' => 
		"$CN.clear_node_id(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"you can not clear the Node Id because the Node is in a Container",

	'SRT_N_SET_NODE_ID_NO_ARGS' => 
		"$CN.set_node_id(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing NEW_ID argument",
	'SRT_N_SET_NODE_ID_BAD_ARG' => 
		"$CN.set_node_id(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid NEW_ID argument; a Node Id may only be a positive integer; ".
		"you tried to set it to '{ARG}'",
	'SRT_N_SET_NODE_ID_DUPL_ID' => 
		"$CN.set_node_id(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid NEW_ID argument; the Node Id value of '{ARG}' you tried to set ".
		"is already in use by another '{NTYPE}' Node in the same Container; it must be unique",

	'SRT_N_EXP_LIT_AT_NO_ARGS' => 
		"$CN.expected_literal_attribute_type(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTR_NAME argument",
	'SRT_N_EXP_LIT_AT_INVAL_NM' => 
		"$CN.expected_literal_attribute_type(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_NAME argument; there is no literal attribute named '{ATNM}' in this Node",

	'SRT_N_SET_LIT_AT_NO_ARG_VAL' => 
		"$CN.set_literal_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTR_VALUE argument",
	'SRT_N_SET_LIT_AT_INVAL_V_BOOL' => 
		"$CN.set_literal_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_VALUE argument; this Node's literal attribute named '{ATNM}' may only be ".
		"a boolean value, as expressed by '0' or '1'; you tried to set it to '{ARG}'",
	'SRT_N_SET_LIT_AT_INVAL_V_UINT' => 
		"$CN.set_literal_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_VALUE argument; this Node's literal attribute named '{ATNM}' may only be ".
		"a non-negative integer; you tried to set it to '{ARG}'",
	'SRT_N_SET_LIT_AT_INVAL_V_SINT' => 
		"$CN.set_literal_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_VALUE argument; this Node's literal attribute named '{ATNM}' may only be ".
		"an integer; you tried to set it to '{ARG}'",

	'SRT_N_SET_LIT_ATS_NO_ARGS' => 
		"$CN.set_literal_attributes(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTRS argument",
	'SRT_N_SET_LIT_ATS_BAD_ARGS' => 
		"$CN.set_literal_attributes(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTRS argument; it is not a hash ref, but rather is '{ARG}",

	'SRT_N_EXP_ENUM_AT_NO_ARGS' => 
		"$CN.expected_enumerated_attribute_type(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTR_NAME argument",
	'SRT_N_EXP_ENUM_AT_INVAL_NM' => 
		"$CN.expected_enumerated_attribute_type(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_NAME argument; there is no enumerated attribute named '{ATNM}' in this Node",

	'SRT_N_SET_ENUM_AT_NO_ARG_VAL' => 
		"$CN.set_enumerated_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTR_VALUE argument",
	'SRT_N_SET_ENUM_AT_INVAL_V' => 
		"$CN.set_enumerated_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_VALUE argument; this Node's enumerated attribute named '{ATNM}' may only be ".
		"a '{ENUMTYPE}' value; you tried to set it to '{ARG}'",

	'SRT_N_SET_ENUM_ATS_NO_ARGS' => 
		"$CN.set_enumerated_attributes(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTRS argument",
	'SRT_N_SET_ENUM_ATS_BAD_ARGS' => 
		"$CN.set_enumerated_attributes(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTRS argument; it is not a hash ref, but rather is '{ARG}'",

	'SRT_N_EXP_NREF_AT_NO_ARGS' => 
		"$CN.expected_node_ref_attribute_type(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTR_NAME argument",
	'SRT_N_EXP_NREF_AT_INVAL_NM' => 
		"$CN.expected_node_ref_attribute_type(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_NAME argument; there is no Node attribute named '{ATNM}' in this Node",

	'SRT_N_SET_NREF_AT_NO_ARG_VAL' => 
		"$CN.set_node_ref_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTR_VALUE argument",
	'SRT_N_SET_NREF_AT_WRONG_NODE_TYPE' => 
		"$CN.set_node_ref_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_VALUE argument; this Node's Node ref attribute named '{ATNM}' may only ".
		"reference a '{EXPNTYPE}' Node, but you tried to set it to a '{ARGNTYPE}' Node",
	'SRT_N_SET_NREF_AT_DIFF_CONT' => 
		"$CN.set_node_ref_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_VALUE argument; that Node is not in ".
		"the same Container as this current Node, so they can not be linked",
	'SRT_N_SET_NREF_AT_ONE_CONT' => 
		"$CN.set_node_ref_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_VALUE argument; a Node that is in a ".
		"Container can not be linked to one that is not",
	'SRT_N_SET_NREF_AT_MISS_NID' => 
		"$CN.set_node_ref_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_VALUE argument; the given Node ".
		"lacks a Node Id, and one is required to link to it from this one",
	'SRT_N_SET_NREF_AT_BAD_ARG_VAL' => 
		"$CN.set_node_ref_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_VALUE argument; '{ARG}' is not a Node ref, ".
		"and a Node Id may only be a positive integer",
	'SRT_N_SET_NREF_AT_NONEX_NID' => 
		"$CN.set_node_ref_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_VALUE argument; '{ARG}' is not a Node ref, ".
		"and it does not match the Id of any '{EXPNTYPE}' Node in this Container",
	'SRT_N_SET_NREF_AT_CIRC_REF' => 
		"$CN.set_node_ref_attribute(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_VALUE argument; that Node is a direct ".
		"or indirect child of this current Node, so they can not be linked; ".
		"if they were linked, that would result in a circular reference chain",

	'SRT_N_SET_NREF_ATS_NO_ARGS' => 
		"$CN.set_node_ref_attributes(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTRS argument",
	'SRT_N_SET_NREF_ATS_BAD_ARGS' => 
		"$CN.set_node_ref_attributes(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTRS argument; it is not a hash ref, but rather is '{ARG}'",

	'SRT_ABSINTF_N_SET_NREF_AT_NO_ID_MATCH' => 
		"$CN.set_node_ref_attribute(), $ABSINTF: concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTRS argument element; when trying to set '{ATNM}' attribute, ".
		"'{ARG}' is not a Node ref and it does not ".
		"match the id of any existing '{EXPNTYPE}' Node",

	'SRT_N_EXP_AT_MT_NO_ARGS' => 
		"$CN.expected_attribute_major_type(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTR_NAME argument",
	'SRT_N_EXP_AT_MT_INVAL_NM' => 
		"$CN.expected_attribute_major_type(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_NAME argument; there is no attribute named '{ATNM}' in this Node",

	'SRT_N_SET_ATS_NO_ARGS' => 
		"$CN.set_attributes(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTRS argument",
	'SRT_ABSINTF_N_SET_ATS_BAD_ARGS' => 
		"$CN.set_attributes(), $ABSINTF: concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTRS argument; it is not a hash ref, but rather is '{ARG}'; ".
		"also, Nodes of the current type have no default ".
		"attribute to associate the given value with",
	'SRT_N_SET_ATS_BAD_ARGS' => 
		"$CN.set_attributes(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTRS argument; it is not a hash ref, but rather is '{ARG}'",

	'SRT_N_SET_PP_NODE_ATNM_NO_ARGS' => 
		"$CN.set_pp_node_attribute_name(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing ATTR_NAME argument",
	'SRT_N_SET_PP_NODE_ATNM_INVAL_NM' => 
		"$CN.set_pp_node_attribute_name(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_NAME argument; either there is no Node attribute named '{ATNM}' in this Node, ".
		"or that attribute can not be used as the primary parent Node",
	'SRT_N_SET_PP_NODE_ATNM_CIRC_REF' => 
		"$CN.set_pp_node_attribute_name(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid ATTR_NAME argument; this Node's Node ref attribute named '{ATNM}' is valued ".
		"with a Node that is a direct or indirect child of this current Node, so that Node ".
		"can not become the primary parent of this current Node; ".
		"if it was, that would result in a circular reference chain",

	'SRT_N_EST_PP_NODE_ATNM_NO_ARGS' => 
		"$CN.estimate_pp_node_attribute_name(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing NEW_PARENT argument",
	'SRT_N_EST_PP_NODE_ATNM_BAD_ARG' => 
		"$CN.estimate_pp_node_attribute_name(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid NEW_PARENT argument; it is not a Node object, but rather is '{ARG}'",

	'SRT_N_PI_CONT_NO_ARGS' => 
		"$CN.put_in_container(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing NEW_CONTAINER argument",
	'SRT_N_PI_CONT_BAD_ARG' => 
		"$CN.put_in_container(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid NEW_CONTAINER argument; it is not a Container object, but rather is '{ARG}'",
	'SRT_N_PI_CONT_HAVE_ALREADY' => 
		"$CN.put_in_container(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"this Node already lives in a Container; you ".
		"must take this Node from there before putting it in a different one",
	'SRT_N_PI_CONT_NO_NODE_ID' => 
		"$CN.put_in_container(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"this Node can not be put in a Container yet as this Node has no NODE_ID defined, ".
		"and the given Container is not configured to auto-set missing Node Ids",
	'SRT_N_PI_CONT_DUPL_ID' => 
		"$CN.put_in_container(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"this Node can not be put into the given Container ".
		"because it has the same Node Id value as another '{NTYPE}' Node already ".
		"in the same Container; one of these Node Ids needs to be changed first",
	'SRT_N_PI_CONT_NONEX_AT_NREF' => 
		"$CN.put_in_container(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"this Node can not be put into the given Container ".
		"because the Node attribute named '{ATNM}' expects to link to a '{EXPNTYPE}' Node ".
		"with a Node Id of '{EXPNID}', but no such Node exists in the given Container",

	'SRT_N_TF_CONT_HAS_CHILD' => 
		"$CN.take_from_container(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"this Node can not be taken from its Container yet because it has child Nodes of its own",

	'SRT_N_MOVE_PRE_SIB_NO_CONT' => 
		"$CN.move_before_sibling(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"this Node is not in a Container and therefore ".
		"it is not present in any child list; it has no siblings",
	'SRT_N_MOVE_PRE_SIB_NO_S_ARG' => 
		"$CN.move_before_sibling(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing SIBLING argument",
	'SRT_N_MOVE_PRE_SIB_BAD_S_ARG' => 
		"$CN.move_before_sibling(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid SIBLING argument; it is not a Node object, but rather is '{ARG}'",
	'SRT_N_MOVE_PRE_SIB_S_DIFF_CONT' => 
		"$CN.move_before_sibling(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid SIBLING argument; that Node is not in ".
		"the same Container (if any) as this current Node, so they can not be siblings",
	'SRT_N_MOVE_PRE_SIB_BAD_P_ARG' => 
		"$CN.move_before_sibling(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid PARENT argument; it is not a Node object, but rather is '{ARG}'",
	'SRT_N_MOVE_PRE_SIB_P_DIFF_CONT' => 
		"$CN.move_before_sibling(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid PARENT argument; that Node is not in ".
		"the same Container (if any) as this current Node, so they can not be related",
	'SRT_N_MOVE_PRE_SIB_NO_P_ARG_OR_PP_OR_PS' => 
		"$CN.move_before_sibling(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"no PARENT argument was given, and this current Node ".
		"has no primary parent Node or parent pseudo-Node for it to default to",
	'SRT_N_MOVE_PRE_SIB_P_NOT_P' => 
		"$CN.move_before_sibling(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid PARENT argument; this current Node is not a child of that Node",
	'SRT_N_MOVE_PRE_SIB_S_NOT_S' => 
		"$CN.move_before_sibling(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid SIBLING argument; this current Node does not share PARENT ".
		"(or its primary parent) with that Node",

	'SRT_N_GET_CH_NODES_BAD_TYPE' => 
		"$CN.get_child_nodes(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid NODE_TYPE argument; there is no Node Type named '{NTYPE}'",

	'SRT_N_ADD_CH_NODE_NO_ARGS' => 
		"$CN.add_child_node(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"missing NEW_CHILD argument",
	'SRT_N_ADD_CH_NODE_BAD_ARG' => 
		"$CN.add_child_node(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"invalid NEW_CHILD argument; it is not a Node object, but rather is '{ARG}'",
	'SRT_N_ADD_CH_NODE_NO_EST' => 
		"$CN.add_child_node(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"this current Node can not be the primary parent of the given Node",

	'SRT_N_ASDC_NID_VAL_NO_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"its Node ID must be given a value",
	'SRT_N_ASDC_PP_NODE_ATNM_NOT_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"its Primary Parent Node Attribute Name must be given a value ".
		"(this Node type does not have a pseudo-Node parent)",
	'SRT_N_ASDC_PP_TOO_MANY_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"{NUMVALS} of its primary parent Node attributes ({ATNMS}) are set; ".
		"you must change all but one of them to be undefined/null",
	'SRT_N_ASDC_PP_ZERO_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"none of its primary parent Node attributes ({ATNMS}) are are set; ".
		"you must give a value to exactly one of them",
	'SRT_N_ASDC_SI_VAL_NO_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"this Node's surrogate id attribute named '{ATNM}' must always be given a value",
	'SRT_N_ASDC_MA_VAL_NO_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; the '{ATNM}' attribute must always be given a value",

	'SRT_N_ASDC_MUTEX_TOO_MANY_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"{NUMVALS} of its attributes ({ATNMS}) in the mutual-exclusivity group '{MUTEX}' are set; ".
		"you must change all but one of them to be undefined/null",
	'SRT_N_ASDC_MUTEX_ZERO_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"none of its attributes ({ATNMS}) in the mutual-exclusivity group '{MUTEX}' are set; ".
		"you must give a value to exactly one of them",

	'SRT_N_ASDC_LATDP_DEP_ON_IS_NULL' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"the depended-on attribute '{DEP_ON}' is undef/null so all of its dependents must be too; ".
		"you must clear these {NUMVALS} attributes: {ATNMS}",
	'SRT_N_ASDC_LATDP_DEP_ON_HAS_WRONG_VAL' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"the depended-on attribute '{DEP_ON}' has a value of '{DEP_ON_VAL}', which is different ".
		"than the value(s) that certain dependents require for being set; ".
		"you must clear these {NUMVALS} attributes: {ATNMS}",
	'SRT_N_ASDC_LATDP_TOO_MANY_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"the depended-on attribute '{DEP_ON}' has a value of '{DEP_ON_VAL}', which means that ".
		"only one of these {NUMVALS} currently set dependent attributes may be set: {ATNMS}",
	'SRT_N_ASDC_LATDP_ZERO_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"the depended-on attribute '{DEP_ON}' has a value of '{DEP_ON_VAL}', which means that ".
		"exactly one of these dependent attributes must be set: {ATNMS}",

	'SRT_N_ASDC_SI_NON_DISTINCT' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; at least two of its child Nodes have ".
		"an identical surrogate id value ('{VALUE}'); you must change ".
		"either the '{C1NTYPE}' Node with Id '{C1NID}' or the '{C2NTYPE}' Node with Id '{C2NID}'",
	'SRT_N_ASDC_SI_NON_DISTINCT_PSN' => 
		"$CN.assert_deferrable_constraints(): concerning the '{PSNTYPE}' pseudo-Node; ".
		"a deferrable constraint was violated; at least two of its child Nodes have ".
		"an identical surrogate id value ('{VALUE}'); you must change ".
		"either the '{C1NTYPE}' Node with Id '{C1NID}' or the '{C2NTYPE}' Node with Id '{C2NID}'",

	'SRT_N_ASDC_CH_N_TOO_FEW_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; this Node has too few ({COUNT}) ".
		"primary-child '{CNTYPE}' Nodes; you must have at least {EXPNUM} of them",
	'SRT_N_ASDC_CH_N_TOO_MANY_SET' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; this Node has too many ({COUNT}) ".
		"primary-child '{CNTYPE}' Nodes; you must have no more than {EXPNUM} of them",

	'SRT_N_ASDC_MUDI_NON_DISTINCT' => 
		"$CN.assert_deferrable_constraints(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"a deferrable constraint was violated; ".
		"at least two of its child Nodes have identical attribute set values ('{VALUES}') ".
		"with respect to the mutual-distinct child group '{MUDI}'; you must change ".
		"either the '{C1NTYPE}' Node with Id '{C1NID}' or the '{C2NTYPE}' Node with Id '{C2NID}'",
	'SRT_N_ASDC_MUDI_NON_DISTINCT_PSN' => 
		"$CN.assert_deferrable_constraints(): concerning the '{PSNTYPE}' pseudo-Node; ".
		"a deferrable constraint was violated; ".
		"at least two of its child Nodes have identical attribute set values ('{VALUES}') ".
		"with respect to the mutual-distinct child group '{MUDI}'; you must change ".
		"either the '{C1NTYPE}' Node with Id '{C1NID}' or the '{C2NTYPE}' Node with Id '{C2NID}'",

	'SRT_N_BUILD_ND_NOT_IN_CONT' => 
		"$CN.build_node(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"you can not invoke this method on this Node because it is not in a Container",

	'SRT_N_BUILD_CH_ND_NOT_IN_CONT' => 
		"$CN.build_child_node(): concerning the '{NTYPE}' Node with Id '{NID}'; ".
		"you can not invoke this method on this Node because it is not in a Container",
);

######################################################################

sub get_text_by_key {
	return( $text_strings{$_[1]} );
}

######################################################################

1;
__END__

=head1 SYNOPSIS

	use Locale::KeyedText;
	use SQL::Routine;

	# do work ...

	my $translator = Locale::KeyedText->new_translator( ['SQL::Routine::L::'], ['en'] );

	# do work ...

	eval {
		# do work with SQL::Routine, which may throw an exception ...
	};
	if( my $error_message_object = $@ ) {
		# examine object here if you want and programmatically recover...

		# or otherwise do the next few lines...
		my $error_user_text = $translator->translate_message( $error_message_object );
		# display $error_user_text to user by some appropriate means
	}

	# continue working, which may involve using SQL::Routine some more ...

=head1 DESCRIPTION

The SQL::Routine::L::en Perl 5 module contains localization data for
SQL::Routine.  It is designed to be interpreted by Locale::KeyedText.

This class is optional and you can still use SQL::Routine effectively without 
it, especially if you plan to either show users different error messages than this 
class defines, or not show them anything because you are "handling it".

=head1 SYNTAX

This class does not export any functions or methods, so you need to call them
using object notation.  This means using B<Class-E<gt>function()> for functions
and B<$object-E<gt>method()> for methods.  If you are inheriting this class for
your own modules, then that often means something like B<$self-E<gt>method()>.  

=head1 FUNCTIONS

=head2 get_text_by_key( MSG_KEY )

	my $user_text_template = SQL::Routine::L::en->get_text_by_key( 'foo' );

This function takes a Message Key string in MSG_KEY and returns the associated
user text template string, if there is one, or undef if not.

=head1 SEE ALSO

perl(1), Locale::KeyedText, SQL::Routine.

=cut
