
use strict;
use warnings;

use Module::Build 0.3601;
use lib 'inc'; use Silki::Build;

my %module_build_args = (
  'build_requires' => {
    'MIME::Base64' => '0',
    'Module::Build' => '0.3601',
    'Test::More' => '0.88',
    'Test::Most' => '0'
  },
  'configure_requires' => {
    'Module::Build' => '0.3601'
  },
  'dist_abstract' => 'Silki is a Catalyst-based wiki hosting platform',
  'dist_author' => [
    'Dave Rolsky <autarch@urth.org>'
  ],
  'dist_name' => 'Silki',
  'dist_version' => '0.03',
  'license' => 'open_source',
  'module_name' => 'Silki',
  'recommends' => {},
  'requires' => {
    'Algorithm::Diff' => '0',
    'Apache2::ServerUtil' => '0',
    'Authen::Passphrase' => '0',
    'CSS::Minifier' => '0',
    'Catalyst::Action::REST' => '0',
    'Catalyst::Plugin::AuthenCookie' => '0',
    'Catalyst::Plugin::RedirectAndDetach' => '0',
    'Catalyst::Plugin::Session' => '0.27',
    'Catalyst::Plugin::Session::AsObject' => '0',
    'Catalyst::Plugin::Session::State::URI' => '0',
    'Catalyst::Plugin::Session::Store::DBI' => '0',
    'Catalyst::Plugin::SubRequest' => '0',
    'Catalyst::Plugin::Unicode' => '0',
    'Catalyst::Runtime' => '5.8',
    'Catalyst::View::Mason' => '0',
    'CatalystX::RoleApplicator' => '0',
    'Config::INI::Reader' => '0',
    'DBD::Mock' => '0',
    'DBD::Pg' => '0',
    'DBI' => '0',
    'Data::Dump' => '0',
    'Data::Dumper' => '0',
    'Data::Localize' => '0.00016',
    'Data::Page' => '0',
    'Data::Page::FlickrLike' => '0',
    'DateTime' => '0',
    'DateTime::Format::Pg' => '0',
    'DateTime::Format::W3CDTF' => '0.05',
    'DateTime::Locale' => '0',
    'Digest::SHA' => '0',
    'Email::Address' => '0',
    'Email::Date' => '0',
    'Email::MIME::CreateHTML' => '0',
    'Email::MessageID' => '0',
    'Email::Sender::Simple' => '0',
    'Email::Valid' => '0',
    'Exception::Class' => '0',
    'Fey' => '0',
    'Fey::DBIManager' => '0',
    'Fey::Loader' => '0',
    'Fey::ORM' => '0.32',
    'File::HomeDir' => '0',
    'File::MimeInfo' => '0',
    'File::Slurp' => '0',
    'File::Which' => '0',
    'HTML::DOM' => '0',
    'HTML::Entities' => '0',
    'HTML::FillInForm' => '0',
    'HTML::FormatText' => '0',
    'HTML::Mason' => '0',
    'HTML::TreeBuilder' => '0',
    'HTTP::Status' => '0',
    'IPC::System::Simple' => '0',
    'Image::Magick' => '0',
    'Image::Thumbnail' => '0',
    'JSAN::ServerSide' => '0.04',
    'JSON::XS' => '0',
    'JavaScript::Minifier::XS' => '0',
    'JavaScript::Squish' => '0',
    'Lingua::EN::Inflect' => '0',
    'List::AllUtils' => '0',
    'Log::Dispatch' => '0',
    'Markdent' => '0',
    'Moose' => '0',
    'MooseX::ClassAttribute' => '0',
    'MooseX::MetaDescription' => '0',
    'MooseX::Params::Validate' => '0',
    'MooseX::Role::Parameterized' => '0',
    'MooseX::SemiAffordanceAccessor' => '0',
    'MooseX::Singleton' => '0',
    'MooseX::StrictConstructor' => '0',
    'MooseX::Types' => '0',
    'MooseX::Types::Moose' => '0',
    'MooseX::Types::Path::Class' => '0',
    'Net::Akismet::Protocol' => '0',
    'Net::Interface' => '0',
    'Number::Format' => '0',
    'Path::Class' => '0',
    'Scalar::Util' => '0',
    'String::Diff' => '0',
    'Sub::Exporter' => '0',
    'Text::Autoformat' => '0',
    'Text::TOC' => '0.04',
    'Tie::IxHash' => '0',
    'Time::HiRes' => '0',
    'URI' => '0',
    'URI::Escape' => '0',
    'URI::FromHash' => '0',
    'XML::Atom::SimpleFeed' => '0',
    'autodie' => '0',
    'namespace::autoclean' => '0'
  },
  'script_files' => [
    'bin/silki_create.pl',
    'bin/silki_server.pl',
    'bin/silki_cgi.pl',
    'bin/silki_fastcgi.pl',
    'bin/silki_test.pl'
  ],
  'share_dir' => 'share'
);


my $build = Silki::Build->new(%module_build_args);

$build->create_build_script;
