package Locales::DB::Territory::bo;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Territory::bo::VERSION = '0.09';

$Locales::DB::Territory::bo::cldr_version = '2.0';

%Locales::DB::Territory::bo::code_to_name = (
    'ac' => "Ascension\ Island",
    'ad' => 'ཨེན་ཌོ་ར།',
    'ae' => "ཨ་རབ།\ ཨི་མི་རཊ྄།\ ཆིག་སྒྲིལ་རྒྱལ་ཁབ།",
    'af' => 'ཨཕ་ག་ནི་སྟཱན།',
    'ag' => "ཨེན་ཊི་གུ་དང་།\ བྷར་བུ་ཌ།",
    'ai' => 'ཨང་གུའི་ལ།',
    'al' => 'ཨལ་བཱ་ནི་ཡ།',
    'am' => 'ཨར་མེ་ནི་ཡ།',
    'an' => "Netherlands\ Antilles",
    'ao' => 'ཨང་གཽ་ལ།',
    'aq' => 'ལྷོ་རྩེའི་མཐའ་གླིང་།',
    'ar' => 'ཨར་ཇེན་ཊི་ན།',
    'as' => "American\ Samoa",
    'at' => 'ཨསྟྲི་ཡ།',
    'au' => 'ཨསྟྲེ་ལི་ཡ།',
    'aw' => 'ཨ་རུ་བ།',
    'ax' => "\Ã\land\ Islands",
    'az' => 'ཨཛར་བཡེ་ཇན།',
    'ba' => 'བོསྣི་ཡ་དང་ཧརྫོ་གོ་ཝི་ན།',
    'bb' => 'བཱརྦ་ཌོས྄།',
    'bd' => 'བངྒ་ལ་དེཤ།',
    'be' => 'བེལ་ཇི་ཡམ།',
    'bf' => "བརཀི་ན།\ ཕསོ།",
    'bg' => 'བུལ་ག་རི་ཡ།',
    'bh' => 'བྷཱ་རེན།',
    'bi' => 'བུ་རུན་ཌི།',
    'bj' => 'བཱེ་ནིན།',
    'bl' => "Saint\ Barth\Ã\©lemy",
    'bm' => 'བར་མུ་ཌ།',
    'bn' => 'བུ་རུ་ནེ།',
    'bo' => 'བོ་ལི་ཝིཡ།',
    'bq' => "British\ Antarctic\ Territory",
    'br' => 'བ་རཱ་ཛིལ།',
    'bs' => 'བྷཱ་མས྄།',
    'bt' => 'འབྲུག་ཡུལ།',
    'bv' => "Bouvet\ Island",
    'bw' => 'བོཙ་ཝ་ན།',
    'by' => 'བེ་ལུ་རུ་སུ།',
    'bz' => 'བེ་ལིཛ།',
    'ca' => 'ཁེ་ན་ཌ།',
    'cc' => "Cocos\ \[Keeling\]\ Islands",
    'cd' => "Congo\ \[DRC\]",
    'cf' => "Central\ African\ Republic",
    'cg' => "Congo\ \[Republic\]",
    'ch' => 'ཧྲུད་ཧྲི།',
    'ci' => "ཀོ་ཊེ་ཌི།\ ཨི་ཝོ་རེ།",
    'ck' => "ཀཱུག\ གླིང་ཕྲེན་རྒྱལ་ཁབ།",
    'cl' => 'ཅི་ལི།',
    'cm' => 'ཀ་མེ་རུན།',
    'cn' => 'རྒྱ་ནག',
    'co' => 'ཀོ་ལོམ་བི་ཡ།',
    'cp' => "Clipperton\ Island",
    'cr' => 'ཀོ་ས྄ཊ་རི་ཀ།',
    'cs' => "Serbia\ and\ Montenegro",
    'ct' => "Canton\ and\ Enderbury\ Islands",
    'cu' => 'ཁྱུའུ་བ།',
    'cv' => "Cape\ Verde",
    'cx' => "Christmas\ Island",
    'cy' => 'སཱཡེ་པ་རས྄།',
    'cz' => 'ཅཻག་སྤྱི་མཐུན་རྒྱལ་ཁབ།',
    'dd' => "East\ Germany",
    'de' => 'འཇར་མན་',
    'dg' => "Diego\ Garcia",
    'dj' => 'ཛི་བུ་ཏི།',
    'dk' => 'ཌེན་མཱརྐ།',
    'dm' => 'ཌོ་མིན་ནི་ཀ།',
    'do' => 'ཌོ་མིནནི་ཀན་སྤྱི་མཐུན་རྒྱལ་ཁབ།',
    'dz' => 'ཨལ་ཇི་རི་ཡ།',
    'ea' => "Ceuta\ and\ Melilla",
    'ec' => 'ཨི་ཁྭ་ཌོར།',
    'ee' => 'ཨིསྟོ་ནི་ཡ།',
    'eg' => 'ཨི་ཇིབྚ།',
    'eh' => "Western\ Sahara",
    'er' => 'ཨེ་རི་ཏྲེ་ཨ།',
    'es' => 'སི་པན།',
    'et' => 'ཨི་ཐིའོ་པི་ཡ།',
    'eu' => "European\ Union",
    'fi' => 'ཕིན་ལན྄ཌ།',
    'fj' => 'ཕི་ཇི།',
    'fk' => 'ཕལྐ་ལནྜ་གླིང་ཕྲན།',
    'fm' => 'Micronesia',
    'fo' => "Faroe\ Islands",
    'fq' => "French\ Southern\ and\ Antarctic\ Territories",
    'fr' => 'ཕ་རཱན་སི།',
    'fx' => "Metropolitan\ France",
    'ga' => 'གེ་བཽན།',
    'gb' => 'དབྱིན་ཇི་',
    'gd' => 'གྷ་རི་ན་ཌ།',
    'ge' => 'ཇོར་ཇི་ཡ།',
    'gf' => "French\ Guiana",
    'gg' => 'Guernsey',
    'gh' => 'གྷ་ན།',
    'gi' => 'ཇིབ་རཱལ་ཊར།',
    'gl' => 'Greenland',
    'gm' => 'གྷམ་བི་ཡ།',
    'gn' => 'གྷི་ནི་ཡ།',
    'gp' => 'Guadeloupe',
    'gq' => "Equatorial\ Guinea",
    'gr' => 'གྷི་རཱི་སི།',
    'gs' => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt' => 'གྷོ་ཊེ་མ་ལ།',
    'gu' => 'Guam',
    'gw' => 'གྷི་ནི་ཡ་བིས྄་སོ།',
    'gy' => 'གྷུ་ཡཱ་ན།',
    'hk' => 'ཧོང་ཀོང༌།',
    'hm' => "Heard\ Island\ and\ McDonald\ Islands",
    'hn' => 'ཧོན་དུ་རས྄།',
    'hr' => 'ཀུརོ་ཤི་ཡ།',
    'ht' => 'ཧེ་ཏི།',
    'hu' => 'ཧངྒ་རི།',
    'ic' => "Canary\ Islands",
    'id' => 'ཨིན་ཌོ་ནེ་ཤི་ཡ།',
    'ie' => 'ཨ་ཡར་ལནཌ།',
    'il' => 'ཨི་ཛ྄་རེལ།',
    'im' => "Isle\ of\ Man",
    'in' => 'རྒྱ་གར་',
    'io' => "British\ Indian\ Ocean\ Territory",
    'iq' => 'ཨི་རག།',
    'ir' => 'ཨི་རཱན།',
    'is' => 'ཨ་ཨི་སི་ལནད།',
    'it' => 'ཨི་ཀྲར་ལི་',
    'je' => 'Jersey',
    'jm' => 'ཛ་མེ་ཀ།',
    'jo' => 'ཇོར་ཌན།',
    'jp' => 'རི་པིན་',
    'jt' => "Johnston\ Island",
    'ke' => 'ཁེན་ཉི་ཡ།',
    'kg' => 'ཁིར་གིཛ་སྟཱན།',
    'kh' => 'ཀམ་བོ་ཌི་ཡ།',
    'ki' => 'ཀི་རི་བཱ་ཏི།',
    'km' => 'Comoros',
    'kn' => "སེནྚ།\ ཀིཊྚས྄།\ དང༌།\ ནེ་བིས྄།",
    'kp' => "North\ Korea",
    'kr' => "ཀོ་རི་ཡ།\ ལྷོ་མ།",
    'kw' => 'ཀུ་ཝེད་རྒྱལ་ཁབ།',
    'ky' => 'ཁེ་མེན་གླིང་ཕྲན།',
    'kz' => 'ཁ་ཛཱག་སྟཱན།',
    'la' => 'ལཱ་འོས།',
    'lb' => 'ལེབ་ནོན།',
    'lc' => "སེནྚ།\ ལུ་ཤི་ཡ།",
    'li' => 'ལེག་ཏེན་ཚིན།',
    'lk' => 'ཤྲཱི་ལངྐ་།',
    'lr' => 'ལི་བེ་རི་ཡ།',
    'ls' => 'ལེ་སོ་ཐོ།',
    'lt' => 'ལི་ཐུ་ཨེ་ནི་ཡ།',
    'lu' => 'ལཀ་ཛམ་བོརྒ།',
    'lv' => 'ལཏ་བི་ཡ།',
    'ly' => 'ལི་བི་ཡ།',
    'ma' => 'མོ་རོ་ཀྐོ།',
    'mc' => 'མོ་ན་ཀོ།',
    'md' => 'Moldova',
    'me' => 'Montenegro',
    'mf' => "Saint\ Martin",
    'mg' => 'མ་དཱ་གྷསྐཱར།',
    'mh' => 'མཱར་ཤལ་གླིང་ཕྲེན།',
    'mi' => "Midway\ Islands",
    'mk' => "Macedonia\ \[FYROM\]",
    'ml' => 'མ་ལི།',
    'mm' => 'འབར་མ།',
    'mn' => 'སོག་ཡུལ།',
    'mo' => 'མེ་ཀའོ།',
    'mp' => "Northern\ Mariana\ Islands",
    'mq' => 'Martinique',
    'mr' => 'མཽ་རི་ཏ་ནི་ཡ།',
    'ms' => 'Montserrat',
    'mt' => 'མལ་ཊ།',
    'mu' => 'མཽ་རིཤས྄།',
    'mv' => 'མལ་དྭིབ།',
    'mw' => 'མཱ་ལཱ་ཝི།',
    'mx' => 'མེཀ་སི་ཀོ།',
    'my' => 'མ་ལེ་ཤི་ཡ།',
    'mz' => 'མོ་ཛམ་བིག།',
    'na' => 'ན་མི་བི་ཡ།',
    'nc' => "New\ Caledonia",
    'ne' => 'ནའི་ཇར།',
    'nf' => "Norfolk\ Island",
    'ng' => 'ནཱའི་ཇི་རི་ཡ།',
    'ni' => 'ནི་ཀ་ར་གུ་ཨ།',
    'nl' => 'ཧའོ་ལན།',
    'no' => 'ནོར་ཝེ།',
    'np' => 'བར་ཡུལ་',
    'nq' => "Dronning\ Maud\ Land",
    'nr' => 'ནཽ་རུ།',
    'nt' => "Neutral\ Zone",
    'nu' => 'ནིའུ་ཝ།',
    'nz' => 'ནིའུ་ཛི་ལན྄ཌ།',
    'om' => 'ཨོ་མན།',
    'pa' => 'པ་ནཱ་མ།',
    'pc' => "Pacific\ Islands\ Trust\ Territory",
    'pe' => 'པེ་རུ།',
    'pf' => "French\ Polynesia",
    'pg' => "པ་པུ་ཨ།\ ནིའུ།\ གྷི་ནི།",
    'ph' => 'ཕི་ལི་པིནས྄།',
    'pk' => 'པཀི་སྟཱན།',
    'pl' => 'པོ་ལནྜ།',
    'pm' => "Saint\ Pierre\ and\ Miquelon",
    'pn' => "Pitcairn\ Islands",
    'pr' => "Puerto\ Rico",
    'ps' => "Palestinian\ Territories",
    'pt' => 'པོར་ཏུ་གྷལ།',
    'pu' => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw' => 'པ་ལཽ།',
    'py' => 'པཱ་ར་གེ།',
    'pz' => "Panama\ Canal\ Zone",
    'qa' => 'ཀ་ཏཱར།',
    'qo' => "Outlying\ Oceania",
    're' => "R\Ã\©union",
    'ro' => 'རོ་མཱ་ནིཡ།',
    'rs' => 'སེར་བི་ཡ།',
    'ru' => 'ཨུ་རུ་སུ་',
    'rw' => 'རུ་ཝན་ཌ།',
    'sa' => 'སཽ་དྷི་ཨ་རཱ་བི་ཡ།',
    'sb' => "སོ་ལོ་མོན།\ གླིང་ཕྲན་ཚོ་ཁག།",
    'sc' => 'སཱ་ཤཻལ།',
    'sd' => 'སུ་དཱན།',
    'se' => 'ཧྲུའི་ཏན།',
    'sg' => 'སིངྒ་པུར།',
    'sh' => "སེནྚ།\ ཧེ་ལི་ན།",
    'si' => 'ས་ལཽ་ཝེ་ནི་ཡ།',
    'sj' => "Svalbard\ and\ Jan\ Mayen",
    'sk' => 'ས་ལཽ་ཝཀྱ།',
    'sl' => "སེ་ཡར་ར།\ ལིའོན།",
    'sm' => 'སན་མེ་རི་ནོ།',
    'sn' => 'སེ་ནི་གྷལ།',
    'so' => 'སོ་མཱལི་ཡ།',
    'sr' => 'སུ་རི་ནཱམ།',
    'st' => "ས་འོ་ཏོད་མད།\ དང༌།\ པ྄རིན་སི་པེ།",
    'su' => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv' => "ཨེལ།\ སཱལ་ཝ་ཌོར།",
    'sy' => 'Syria',
    'sz' => 'Swaziland',
    'ta' => "Tristan\ da\ Cunha",
    'tc' => "Turks\ and\ Caicos\ Islands",
    'td' => 'ཅཻཌ།',
    'tf' => "French\ Southern\ Territories",
    'tg' => 'Togo',
    'th' => 'Thailand',
    'tj' => 'Tajikistan',
    'tk' => 'Tokelau',
    'tl' => "East\ Timor",
    'tm' => 'Turkmenistan',
    'tn' => 'Tunisia',
    'to' => 'Tonga',
    'tr' => 'ཏུརཀི།',
    'tt' => "Trinidad\ and\ Tobago",
    'tv' => 'ཐུ་ཝ་ལུ།',
    'tw' => 'Taiwan',
    'tz' => 'Tanzania',
    'ua' => 'ཡུ་ཀྲན།',
    'ug' => 'ཡུ་གན་ཌ།',
    'um' => "U\.S\.\ Minor\ Outlying\ Islands",
    'us' => 'ཨ་མེ་རི་ཀ་',
    'uy' => 'ཨུ་རུ་གྷེ།',
    'uz' => 'ཨུཛ་བེ་ཀིསྟཱན།',
    'va' => 'ཝེ་ཊི་ཀན།',
    'vc' => "སེནྚ།\ ཝིན་སན།\ དང༌།\ གྷིརིན་ཌིན།",
    'vd' => "North\ Vietnam",
    've' => 'ཝེ་ནི་ཛུའེ་ལ།',
    'vg' => "British\ Virgin\ Islands",
    'vi' => "U\.S\.\ Virgin\ Islands",
    'vn' => 'བི་དི་ནམ།',
    'vu' => 'ཝ་ནུ་ཨ་ཐུ།',
    'wf' => "Wallis\ and\ Futuna",
    'wk' => "Wake\ Island",
    'ws' => 'ནུ་བ་ས་མོ་འ།',
    'yd' => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye' => 'ཡེ་མེན།',
    'yt' => 'Mayotte',
    'za' => "ལྷོ་\ ཨཕྲི་ཀ།",
    'zm' => 'ཛམ་བི་ཡ།',
    'zw' => 'ཛིམ་བྷཱ་བེ།',
    'zz' => 'མིའི་ཤེས་རྟོགས་མ་བྱུང་བའི་ཁོར་ཡུག',
);

%Locales::DB::Territory::bo::name_to_code = (
    'americansamoa'                                                                                       => 'as',
    'ascensionisland'                                                                                     => 'ac',
    'bouvetisland'                                                                                        => 'bv',
    'britishantarcticterritory'                                                                           => 'bq',
    'britishindianoceanterritory'                                                                         => 'io',
    'britishvirginislands'                                                                                => 'vg',
    'canaryislands'                                                                                       => 'ic',
    'cantonandenderburyislands'                                                                           => 'ct',
    'capeverde'                                                                                           => 'cv',
    'centralafricanrepublic'                                                                              => 'cf',
    'ceutaandmelilla'                                                                                     => 'ea',
    'christmasisland'                                                                                     => 'cx',
    'clippertonisland'                                                                                    => 'cp',
    'cocoskeelingislands'                                                                                 => 'cc',
    'comoros'                                                                                             => 'km',
    'congodrc'                                                                                            => 'cd',
    'congorepublic'                                                                                       => 'cg',
    'diegogarcia'                                                                                         => 'dg',
    'dronningmaudland'                                                                                    => 'nq',
    'eastgermany'                                                                                         => 'dd',
    'easttimor'                                                                                           => 'tl',
    'equatorialguinea'                                                                                    => 'gq',
    'europeanunion'                                                                                       => 'eu',
    'faroeislands'                                                                                        => 'fo',
    'frenchguiana'                                                                                        => 'gf',
    'frenchpolynesia'                                                                                     => 'pf',
    'frenchsouthernandantarcticterritories'                                                               => 'fq',
    'frenchsouthernterritories'                                                                           => 'tf',
    'greenland'                                                                                           => 'gl',
    'guadeloupe'                                                                                          => 'gp',
    'guam'                                                                                                => 'gu',
    'guernsey'                                                                                            => 'gg',
    'heardislandandmcdonaldislands'                                                                       => 'hm',
    'isleofman'                                                                                           => 'im',
    'jersey'                                                                                              => 'je',
    'johnstonisland'                                                                                      => 'jt',
    'macedoniafyrom'                                                                                      => 'mk',
    'martinique'                                                                                          => 'mq',
    'mayotte'                                                                                             => 'yt',
    'metropolitanfrance'                                                                                  => 'fx',
    'micronesia'                                                                                          => 'fm',
    'midwayislands'                                                                                       => 'mi',
    'moldova'                                                                                             => 'md',
    'montenegro'                                                                                          => 'me',
    'montserrat'                                                                                          => 'ms',
    'netherlandsantilles'                                                                                 => 'an',
    'neutralzone'                                                                                         => 'nt',
    'newcaledonia'                                                                                        => 'nc',
    'norfolkisland'                                                                                       => 'nf',
    'northernmarianaislands'                                                                              => 'mp',
    'northkorea'                                                                                          => 'kp',
    'northvietnam'                                                                                        => 'vd',
    'outlyingoceania'                                                                                     => 'qo',
    'pacificislandstrustterritory'                                                                        => 'pc',
    'palestinianterritories'                                                                              => 'ps',
    'panamacanalzone'                                                                                     => 'pz',
    "people\â\\sdemocraticrepublicofyemen"                                                           => 'yd',
    'pitcairnislands'                                                                                     => 'pn',
    'puertorico'                                                                                          => 'pr',
    "r\Ã\©union"                                                                                        => 're',
    "saintbarth\Ã\©lemy"                                                                                => 'bl',
    'saintmartin'                                                                                         => 'mf',
    'saintpierreandmiquelon'                                                                              => 'pm',
    'serbiaandmontenegro'                                                                                 => 'cs',
    'southgeorgiaandthesouthsandwichislands'                                                              => 'gs',
    'svalbardandjanmayen'                                                                                 => 'sj',
    'swaziland'                                                                                           => 'sz',
    'syria'                                                                                               => 'sy',
    'taiwan'                                                                                              => 'tw',
    'tajikistan'                                                                                          => 'tj',
    'tanzania'                                                                                            => 'tz',
    'thailand'                                                                                            => 'th',
    'togo'                                                                                                => 'tg',
    'tokelau'                                                                                             => 'tk',
    'tonga'                                                                                               => 'to',
    'trinidadandtobago'                                                                                   => 'tt',
    'tristandacunha'                                                                                      => 'ta',
    'tunisia'                                                                                             => 'tn',
    'turkmenistan'                                                                                        => 'tm',
    'turksandcaicosislands'                                                                               => 'tc',
    "u\.s\.minoroutlyingislands"                                                                          => 'um',
    "u\.s\.miscellaneouspacificislands"                                                                   => 'pu',
    "u\.s\.virginislands"                                                                                 => 'vi',
    'unionofsovietsocialistrepublics'                                                                     => 'su',
    'wakeisland'                                                                                          => 'wk',
    'wallisandfutuna'                                                                                     => 'wf',
    'westernsahara'                                                                                       => 'eh',
    "\Ã\landislands"                                                                                   => 'ax',
    'ཀ་ཏཱར།'                                                                                  => 'qa',
    'ཀ་མེ་རུན།'                                                                         => 'cm',
    'ཀམ་བོ་ཌི་ཡ།'                                                                   => 'kh',
    'ཀཱུགགླིང་ཕྲེན་རྒྱལ་ཁབ།'                                  => 'ck',
    'ཀི་རི་བཱ་ཏི།'                                                                => 'ki',
    'ཀུ་ཝེད་རྒྱལ་ཁབ།'                                                       => 'kw',
    'ཀུརོ་ཤི་ཡ།'                                                                      => 'hr',
    'ཀོ་ཊེ་ཌི།ཨི་ཝོ་རེ།'                                              => 'ci',
    'ཀོ་རི་ཡ།ལྷོ་མ།'                                                          => 'kr',
    'ཀོ་ལོམ་བི་ཡ།'                                                                => 'co',
    'ཀོ་ས྄ཊ་རི་ཀ།'                                                                => 'cr',
    'ཁ་ཛཱག་སྟཱན།'                                                                   => 'kz',
    'ཁིར་གིཛ་སྟཱན།'                                                             => 'kg',
    'ཁེ་ན་ཌ།'                                                                               => 'ca',
    'ཁེ་མེན་གླིང་ཕྲན།'                                                    => 'ky',
    'ཁེན་ཉི་ཡ།'                                                                         => 'ke',
    'ཁྱུའུ་བ།'                                                                            => 'cu',
    'གེ་བཽན།'                                                                               => 'ga',
    'གྷ་ན།'                                                                                     => 'gh',
    'གྷ་རི་ན་ཌ།'                                                                      => 'gd',
    'གྷམ་བི་ཡ།'                                                                         => 'gm',
    'གྷི་ནི་ཡ་བིས྄་སོ།'                                                 => 'gw',
    'གྷི་ནི་ཡ།'                                                                         => 'gn',
    'གྷི་རཱི་སི།'                                                                   => 'gr',
    'གྷུ་ཡཱ་ན།'                                                                         => 'gy',
    'གྷོ་ཊེ་མ་ལ།'                                                                   => 'gt',
    'ཅི་ལི།'                                                                                  => 'cl',
    'ཅཻག་སྤྱི་མཐུན་རྒྱལ་ཁབ།'                                  => 'cz',
    'ཅཻཌ།'                                                                                        => 'td',
    'ཇིབ་རཱལ་ཊར།'                                                                   => 'gi',
    'ཇོར་ཇི་ཡ།'                                                                         => 'ge',
    'ཇོར་ཌན།'                                                                               => 'jo',
    'ཌེན་མཱརྐ།'                                                                         => 'dk',
    'ཌོ་མིན་ནི་ཀ།'                                                                => 'dm',
    'ཌོ་མིནནི་ཀན་སྤྱི་མཐུན་རྒྱལ་ཁབ།'          => 'do',
    'ཏུརཀི།'                                                                                  => 'tr',
    'ཐུ་ཝ་ལུ།'                                                                            => 'tv',
    'དབྱིན་ཇི་'                                                                         => 'gb',
    'ན་མི་བི་ཡ།'                                                                      => 'na',
    'ནའི་ཇར།'                                                                               => 'ne',
    'ནཱའི་ཇི་རི་ཡ།'                                                             => 'ng',
    'ནི་ཀ་ར་གུ་ཨ།'                                                                => 'ni',
    'ནིའུ་ཛི་ལན྄ཌ།'                                                             => 'nz',
    'ནིའུ་ཝ།'                                                                               => 'nu',
    'ནུ་བ་ས་མོ་འ།'                                                                => 'ws',
    'ནོར་ཝེ།'                                                                               => 'no',
    'ནཽ་རུ།'                                                                                  => 'nr',
    'པ་ནཱ་མ།'                                                                               => 'pa',
    'པ་པུ་ཨ།ནིའུ།གྷི་ནི།'                                           => 'pg',
    'པ་ལཽ།'                                                                                     => 'pw',
    'པཀི་སྟཱན།'                                                                         => 'pk',
    'པཱ་ར་གེ།'                                                                            => 'py',
    'པེ་རུ།'                                                                                  => 'pe',
    'པོ་ལནྜ།'                                                                               => 'pl',
    'པོར་ཏུ་གྷལ།'                                                                   => 'pt',
    'ཕ་རཱན་སི།'                                                                         => 'fr',
    'ཕལྐ་ལནྜ་གླིང་ཕྲན།'                                                 => 'fk',
    'ཕི་ཇི།'                                                                                  => 'fj',
    'ཕི་ལི་པིནས྄།'                                                                => 'ph',
    'ཕིན་ལན྄ཌ།'                                                                         => 'fi',
    'བ་རཱ་ཛིལ།'                                                                         => 'br',
    'བངྒ་ལ་དེཤ།'                                                                      => 'bd',
    'བར་མུ་ཌ།'                                                                            => 'bm',
    'བར་ཡུལ་'                                                                               => 'np',
    'བརཀི་ན།ཕསོ།'                                                                   => 'bf',
    'བཱརྦ་ཌོས྄།'                                                                      => 'bb',
    'བཱེ་ནིན།'                                                                            => 'bj',
    'བི་དི་ནམ།'                                                                         => 'vn',
    'བུ་རུ་ནེ།'                                                                         => 'bn',
    'བུ་རུན་ཌི།'                                                                      => 'bi',
    'བུལ་ག་རི་ཡ།'                                                                   => 'bg',
    'བེ་ལིཛ།'                                                                               => 'bz',
    'བེ་ལུ་རུ་སུ།'                                                                => 'by',
    'བེལ་ཇི་ཡམ།'                                                                      => 'be',
    'བོ་ལི་ཝིཡ།'                                                                      => 'bo',
    'བོཙ་ཝ་ན།'                                                                            => 'bw',
    'བོསྣི་ཡ་དང་ཧརྫོ་གོ་ཝི་ན།'                            => 'ba',
    'བྷཱ་མས྄།'                                                                            => 'bs',
    'བྷཱ་རེན།'                                                                            => 'bh',
    'མ་དཱ་གྷསྐཱར།'                                                                => 'mg',
    'མ་ལི།'                                                                                     => 'ml',
    'མ་ལེ་ཤི་ཡ།'                                                                      => 'my',
    'མལ་ཊ།'                                                                                     => 'mt',
    'མལ་དྭིབ།'                                                                            => 'mv',
    'མཱ་ལཱ་ཝི།'                                                                         => 'mw',
    'མཱར་ཤལ་གླིང་ཕྲེན།'                                                 => 'mh',
    'མིའི་ཤེས་རྟོགས་མ་བྱུང་བའི་ཁོར་ཡུག' => 'zz',
    'མེ་ཀའོ།'                                                                               => 'mo',
    'མེཀ་སི་ཀོ།'                                                                      => 'mx',
    'མོ་ན་ཀོ།'                                                                            => 'mc',
    'མོ་ཛམ་བིག།'                                                                      => 'mz',
    'མོ་རོ་ཀྐོ།'                                                                      => 'ma',
    'མཽ་རི་ཏ་ནི་ཡ།'                                                             => 'mr',
    'མཽ་རིཤས྄།'                                                                         => 'mu',
    'ཛ་མེ་ཀ།'                                                                               => 'jm',
    'ཛམ་བི་ཡ།'                                                                            => 'zm',
    'ཛི་བུ་ཏི།'                                                                         => 'dj',
    'ཛིམ་བྷཱ་བེ།'                                                                   => 'zw',
    'ཝ་ནུ་ཨ་ཐུ།'                                                                      => 'vu',
    'ཝེ་ཊི་ཀན།'                                                                         => 'va',
    'ཝེ་ནི་ཛུའེ་ལ།'                                                             => 've',
    'འཇར་མན་'                                                                               => 'de',
    'འབར་མ།'                                                                                  => 'mm',
    'འབྲུག་ཡུལ།'                                                                      => 'bt',
    'ཡུ་ཀྲན།'                                                                               => 'ua',
    'ཡུ་གན་ཌ།'                                                                            => 'ug',
    'ཡེ་མེན།'                                                                               => 'ye',
    'རི་པིན་'                                                                               => 'jp',
    'རུ་ཝན་ཌ།'                                                                            => 'rw',
    'རོ་མཱ་ནིཡ།'                                                                      => 'ro',
    'རྒྱ་གར་'                                                                               => 'in',
    'རྒྱ་ནག'                                                                                  => 'cn',
    'ལཀ་ཛམ་བོརྒ།'                                                                   => 'lu',
    'ལཏ་བི་ཡ།'                                                                            => 'lv',
    'ལཱ་འོས།'                                                                               => 'la',
    'ལི་ཐུ་ཨེ་ནི་ཡ།'                                                          => 'lt',
    'ལི་བི་ཡ།'                                                                            => 'ly',
    'ལི་བེ་རི་ཡ།'                                                                   => 'lr',
    'ལེ་སོ་ཐོ།'                                                                         => 'ls',
    'ལེག་ཏེན་ཚིན།'                                                                => 'li',
    'ལེབ་ནོན།'                                                                            => 'lb',
    'ལྷོ་རྩེའི་མཐའ་གླིང་།'                                        => 'aq',
    'ལྷོ་ཨཕྲི་ཀ།'                                                                   => 'za',
    'ཤྲཱི་ལངྐ་།'                                                                      => 'lk',
    'ས་འོ་ཏོད་མད།དང༌།པ྄རིན་སི་པེ།'                => 'st',
    'ས་ལཽ་ཝཀྱ།'                                                                         => 'sk',
    'ས་ལཽ་ཝེ་ནི་ཡ།'                                                             => 'si',
    'སན་མེ་རི་ནོ།'                                                                => 'sm',
    'སཱ་ཤཻལ།'                                                                               => 'sc',
    'སཱཡེ་པ་རས྄།'                                                                   => 'cy',
    'སི་པན།'                                                                                  => 'es',
    'སིངྒ་པུར།'                                                                         => 'sg',
    'སུ་དཱན།'                                                                               => 'sd',
    'སུ་རི་ནཱམ།'                                                                      => 'sr',
    'སེ་ནི་གྷལ།'                                                                      => 'sn',
    'སེ་ཡར་ར།ལིའོན།'                                                          => 'sl',
    'སེནྚ།ཀིཊྚས྄།དང༌།ནེ་བིས྄།'                            => 'kn',
    'སེནྚ།ཝིན་སན།དང༌།གྷིརིན་ཌིན།'                   => 'vc',
    'སེནྚ།ལུ་ཤི་ཡ།'                                                             => 'lc',
    'སེནྚ།ཧེ་ལི་ན།'                                                             => 'sh',
    'སེར་བི་ཡ།'                                                                         => 'rs',
    'སོ་མཱལི་ཡ།'                                                                      => 'so',
    'སོ་ལོ་མོན།གླིང་ཕྲན་ཚོ་ཁག།'                         => 'sb',
    'སོག་ཡུལ།'                                                                            => 'mn',
    'སཽ་དྷི་ཨ་རཱ་བི་ཡ།'                                                 => 'sa',
    'ཧངྒ་རི།'                                                                               => 'hu',
    'ཧའོ་ལན།'                                                                               => 'nl',
    'ཧེ་ཏི།'                                                                                  => 'ht',
    'ཧོང་ཀོང༌།'                                                                         => 'hk',
    'ཧོན་དུ་རས྄།'                                                                   => 'hn',
    'ཧྲུད་ཧྲི།'                                                                         => 'ch',
    'ཧྲུའི་ཏན།'                                                                         => 'se',
    'ཨ་མེ་རི་ཀ་'                                                                      => 'us',
    'ཨ་ཡར་ལནཌ།'                                                                         => 'ie',
    'ཨ་རབ།ཨི་མི་རཊ྄།ཆིག་སྒྲིལ་རྒྱལ་ཁབ།' => 'ae',
    'ཨ་རུ་བ།'                                                                               => 'aw',
    'ཨ་ཨི་སི་ལནད།'                                                                => 'is',
    'ཨང་གུའི་ལ།'                                                                      => 'ai',
    'ཨང་གཽ་ལ།'                                                                            => 'ao',
    'ཨཕ་ག་ནི་སྟཱན།'                                                             => 'af',
    'ཨཛར་བཡེ་ཇན།'                                                                   => 'az',
    'ཨར་ཇེན་ཊི་ན།'                                                                => 'ar',
    'ཨར་མེ་ནི་ཡ།'                                                                   => 'am',
    'ཨལ་ཇི་རི་ཡ།'                                                                   => 'dz',
    'ཨལ་བཱ་ནི་ཡ།'                                                                   => 'al',
    'ཨསྟྲི་ཡ།'                                                                            => 'at',
    'ཨསྟྲེ་ལི་ཡ།'                                                                   => 'au',
    'ཨི་ཀྲར་ལི་'                                                                      => 'it',
    'ཨི་ཁྭ་ཌོར།'                                                                      => 'ec',
    'ཨི་ཇིབྚ།'                                                                            => 'eg',
    'ཨི་ཐིའོ་པི་ཡ།'                                                             => 'et',
    'ཨི་ཛ྄་རེལ།'                                                                      => 'il',
    'ཨི་རག།'                                                                                  => 'iq',
    'ཨི་རཱན།'                                                                               => 'ir',
    'ཨིན་ཌོ་ནེ་ཤི་ཡ།'                                                       => 'id',
    'ཨིསྟོ་ནི་ཡ།'                                                                   => 'ee',
    'ཨུ་རུ་གྷེ།'                                                                      => 'uy',
    'ཨུ་རུ་སུ་'                                                                         => 'ru',
    'ཨུཛ་བེ་ཀིསྟཱན།'                                                          => 'uz',
    'ཨེ་རི་ཏྲེ་ཨ།'                                                                => 'er',
    'ཨེན་ཊི་གུ་དང་།བྷར་བུ་ཌ།'                               => 'ag',
    'ཨེན་ཌོ་ར།'                                                                         => 'ad',
    'ཨེལ།སཱལ་ཝ་ཌོར།'                                                          => 'sv',
    'ཨོ་མན།'                                                                                  => 'om',
);

1;

