package Locales::DB::Language::gu;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::gu::VERSION = '0.09';

$Locales::DB::Language::gu::cldr_version = '2.0';

%Locales::DB::Language::gu::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ અને\ \{1\}",
            'end'    => "\{0\}\ અને\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\"",
        'alternate_quotation_start' => "\"",
        'quotation_end'             => "\'",
        'quotation_start'           => "\'"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => 'ના',
        'yesstr' => 'હા'
    },
);

%Locales::DB::Language::gu::code_to_name = (
    'aa'    => 'અફાર',
    'ab'    => 'અબખાજિયન',
    'ace'   => 'અચીની',
    'ach'   => 'અકોલી',
    'ada'   => 'અદાંગ્મી',
    'ady'   => 'અદિઘે',
    'ae'    => 'અવેસ્તન',
    'af'    => 'આફ્રિકન્સ',
    'afa'   => "અફ્રો\-એશિયાટીક\ ભાષાઓ",
    'afh'   => 'અફ્રિહિલી',
    'agq'   => 'Aghem',
    'ain'   => 'એનૂ',
    'ak'    => 'અકન',
    'akk'   => 'અક્કાદીયાન',
    'ale'   => 'અલેઉત',
    'alg'   => "એલ્ગોક્વિયન\ ભાષા",
    'alt'   => "દક્ષિણ\ અલ્તાઇ",
    'am'    => 'એમ્હારિક',
    'an'    => 'અર્ગોનીઝ',
    'ang'   => "જુની\ અંગ્રેજી",
    'anp'   => 'અંગીકા',
    'apa'   => "અપાચે\ ભાષા",
    'ar'    => 'અરબી',
    'arc'   => 'અર્માઇક',
    'arn'   => 'એરોકૈનિયન',
    'arp'   => 'અરાપાહો',
    'art'   => "કૃત્રિમ\ ભાષા",
    'arw'   => 'અરાવક',
    'as'    => 'આસામી',
    'asa'   => 'Asu',
    'ast'   => 'અસ્તુરિયન',
    'ath'   => "અથાપાસ્કાન\ ભાષા",
    'aus'   => "ઓસ્ટ્રેલિયન\ ભાષા",
    'av'    => 'અવેરિક',
    'awa'   => 'અવધી',
    'ay'    => 'આયમારા',
    'az'    => 'અઝેરી',
    'ba'    => 'બષ્ખિર',
    'bad'   => 'બાંદા',
    'bai'   => "બમિલેકે\ ભાષા",
    'bal'   => 'બલૂચી',
    'ban'   => 'બાલિનીસ',
    'bas'   => 'બસા',
    'bat'   => "બાલ્ટિક\ ભાષા",
    'be'    => 'બેલારુશિયન',
    'bej'   => 'બેજા',
    'bem'   => 'બેમ્બા',
    'ber'   => 'બર્બર',
    'bez'   => 'Bena',
    'bg'    => 'બલ્ગેરિયન',
    'bh'    => 'બિહારી',
    'bho'   => 'ભોજપુરી',
    'bi'    => 'બિસ્લામા',
    'bik'   => 'બિકોલ',
    'bin'   => 'બિની',
    'bla'   => 'સિક્સિકા',
    'bm'    => 'બામ્બારા',
    'bn'    => 'બંગાળી',
    'bnt'   => 'બન્ટુ',
    'bo'    => 'તિબેટી',
    'br'    => 'બ્રેટોન',
    'bra'   => 'બ્રજ',
    'brx'   => 'Bodo',
    'bs'    => 'બોસ્નિયન',
    'btk'   => 'બતાક',
    'bua'   => 'બુરિયાત',
    'bug'   => 'બગિનીસ',
    'byn'   => 'બ્લિન',
    'ca'    => 'કતલાન',
    'cad'   => 'કડ્ડો',
    'cai'   => "મધ્ય\ અમેરિકન\ ઇંડિયન\ ભાષા",
    'car'   => 'કરિબ',
    'cau'   => "કાકેશિયન\ ભાષા",
    'cay'   => 'Cayuga',
    'cch'   => 'અત્સમ',
    'ce'    => 'ચેચન',
    'ceb'   => 'સિબુઆનો',
    'cel'   => "સેલ્ટિક\ ભાષા",
    'cgg'   => 'Chiga',
    'ch'    => 'કેમોરો',
    'chb'   => 'ચિબ્ચા',
    'chg'   => 'છગાતાઇ',
    'chk'   => 'ચૂકીસે',
    'chm'   => 'મારી',
    'chn'   => "ચિનૂક\ જાર્ગન",
    'cho'   => 'ચોક્તૌ',
    'chp'   => 'શિપેવ્યાન',
    'chr'   => 'શેરોકી',
    'chy'   => 'શેયેન્ન',
    'cmc'   => "ચાર્મિક\ ભાષા",
    'co'    => 'કોર્સિકન',
    'cop'   => 'કોપ્ટિક',
    'cpe'   => "અંગ્રેજી\ આધારિત\ ક્રેઓલ\ અથવા\ પિજિન",
    'cpf'   => "ફ્રેંચ\ આધારિત\ ક્રેઓલ\ અથવા\ પિજિન",
    'cpp'   => "પાર્ટુગીઝ\ આધારિત\ ક્રેઓલ\ અથવા\ પિજિન",
    'cr'    => 'ક્રી',
    'crh'   => "ક્રિમીન\ તુર્કી",
    'crp'   => "ક્રેઓલ\ અથવા\ પિજિન",
    'cs'    => 'ચેક',
    'csb'   => 'કાશુબિયન',
    'cu'    => "ચર્ચ\ સ્લાવિક",
    'cus'   => "કુશિતિક\ ભાષા",
    'cv'    => 'ચૂવાશ',
    'cy'    => 'વેલ્શ',
    'da'    => 'ડેનિશ',
    'dak'   => 'દાકોતા',
    'dar'   => 'દાર્ગવા',
    'dav'   => 'Taita',
    'day'   => 'દાયક',
    'de'    => 'જર્મન',
    'de_at' => "ઓસ્ટ્રિઅન\ જર્મન",
    'de_ch' => "સ્વિસ\ હાય\ જર્મન",
    'del'   => 'દેલેવેર',
    'den'   => 'સ્લેવ',
    'dgr'   => 'ડોગ્રિબ',
    'din'   => 'દિન્કા',
    'dje'   => 'Zarma',
    'doi'   => 'ડોગ્રી',
    'dra'   => "દ્રવિડિઅન\ ભાષા",
    'dsb'   => "નિમ્ન\ સોર્બિયન",
    'dua'   => 'દુઆલા',
    'dum'   => "મધ્ય\ ડચ",
    'dv'    => 'દિવેહી',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'ડ્યુલા',
    'dz'    => 'ઝોંગખા',
    'ebu'   => 'Embu',
    'ee'    => 'ઇવે',
    'efi'   => 'એફિક',
    'egy'   => "પ્રાચીન\ ઇજીપ્શિયન",
    'eka'   => 'એકાજુક',
    'el'    => 'ગ્રીક',
    'elx'   => 'એલામાઇટ',
    'en'    => 'અંગ્રેજી',
    'en_au' => "ઓસ્ટ્રેલિયન\ અંગ્રેજી",
    'en_ca' => "કેનેડિયન\ અંગ્રેજી",
    'en_gb' => "બ્રિટિશ\ અંગ્રેજી",
    'en_us' => "યુ\ એસ\ અંગ્રેજી",
    'enm'   => "મિડિલ\ અંગ્રેજી",
    'eo'    => 'એસ્પેરાન્ટો',
    'es'    => 'સ્પેનિશ',
    'es_es' => "ઇબેરિયન\ સ્પેનિશ",
    'et'    => 'એસ્ટોનિયન',
    'eu'    => 'બાસ્ક',
    'ewo'   => 'ઇવોન્ડો',
    'fa'    => 'પર્શિયન',
    'fan'   => 'ફેંગ',
    'fat'   => 'ફન્ટી',
    'ff'    => 'ફુલાહ',
    'fi'    => 'ફિનિશ',
    'fil'   => 'ફિલિપિનો',
    'fiu'   => "ફિન્નો\-ઉગ્રીયન\ ભાષા",
    'fj'    => 'ફિજીયન',
    'fo'    => 'ફોરિસ્ત',
    'fon'   => 'ફોન',
    'fr'    => 'ફ્રેન્ચ',
    'fr_ca' => "કેનેડિયન\ ફ્રેંચ",
    'fr_ch' => "સ્વિસ\ ફ્રેંચ",
    'frm'   => "મિડિલ\ ફ્રેંચ",
    'fro'   => "જૂની\ ફ્રેંચ",
    'frr'   => "નોર્ધર્ન\ ફ્રિશિયન",
    'frs'   => "પૂર્વ\ ફ્રિશિયન",
    'fur'   => 'ફ્રિયુલિયાન',
    'fy'    => "પશ્ચિમી\ ફ્રિશિયન",
    'ga'    => 'આઇરિશ',
    'gaa'   => 'ગા',
    'gay'   => 'ગાયો',
    'gba'   => 'બાયા',
    'gd'    => "સ્કોટ્સ\ ગેલિક",
    'gem'   => "જર્મેનિક\ ભાષા",
    'gez'   => 'ગીઝ',
    'gil'   => 'જિલ્બરટીઝ',
    'gl'    => 'ગેલિશિયન',
    'gmh'   => "મધ્ય\ હાઇ\ જર્મન",
    'gn'    => 'ગુઆરાની',
    'goh'   => "જૂની\ હાઇ\ જર્મન",
    'gon'   => 'ગોંડી',
    'gor'   => 'ગોરોન્તાલો',
    'got'   => 'ગોથિક',
    'grb'   => 'ગ્રેબો',
    'grc'   => "પ્રાચીન\ ગ્રીક",
    'gsw'   => "સ્વિસ\ જર્મન",
    'gu'    => 'ગુજરાતી',
    'guz'   => 'Gusii',
    'gv'    => 'માંક્સ',
    'gwi'   => "ગ્વિચ\'ઇન",
    'ha'    => 'હૌસા',
    'hai'   => 'હૈડા',
    'haw'   => 'હાવાઇયન',
    'he'    => 'હીબ્રુ',
    'hi'    => 'હિન્દી',
    'hil'   => 'હિલિગેનોન',
    'him'   => 'હિમાચલી',
    'hit'   => 'હિટ્ટિતે',
    'hmn'   => 'મોંગ',
    'ho'    => "હિરી\ મોટૂ",
    'hr'    => 'ક્રોએશિયન',
    'hsb'   => "અપ્પર\ સોર્બિયન",
    'ht'    => 'હૈતીયન',
    'hu'    => 'હંગેરિયન',
    'hup'   => 'હૂપા',
    'hy'    => 'આર્મેનિયન',
    'hz'    => 'હેરેરો',
    'ia'    => 'ઇંટરલિંગુઆ',
    'iba'   => 'ઇબાન',
    'id'    => 'ઇન્ડોનેશિયન',
    'ie'    => 'ઇંટરલિંગ',
    'ig'    => 'ઇગ્બો',
    'ii'    => "સિચુઆન\ યી",
    'ijo'   => 'ઇજો',
    'ik'    => 'ઇનુપિયાક',
    'ilo'   => 'ઇલોકો',
    'inc'   => "ભારતીય\ ભાષા",
    'ine'   => "ઇંડો\-યુરોપીયન\ ભાષા",
    'inh'   => 'ઇંગુશ',
    'io'    => 'ઇડૌ',
    'ira'   => "ઇરાની\ ભાષા",
    'iro'   => "ઇરોક્વોઇયન\ ભાષા",
    'is'    => 'આઇસલેન્ડિક',
    'it'    => 'ઇટાલિયન',
    'iu'    => 'ઇનુકિટૂટ',
    'ja'    => 'જાપાનીઝ',
    'jbo'   => 'લોજ્બાન',
    'jmc'   => 'Machame',
    'jpr'   => "જુદેઓ\-પર્શિયન",
    'jrb'   => "જુદેઓ\-અરબી",
    'jv'    => 'જાવાનીસ',
    'ka'    => 'જ્યોર્જિઅન',
    'kaa'   => "કારા\-કલ્પક",
    'kab'   => 'કબાઇલ',
    'kac'   => 'કાચિન',
    'kaj'   => 'જ્જુ',
    'kam'   => 'કમ્બા',
    'kar'   => 'કારેન',
    'kaw'   => 'કાવી',
    'kbd'   => 'કબાર્ડિયન',
    'kcg'   => 'ત્યાપ',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'કોરો',
    'kg'    => 'કોંગો',
    'kha'   => 'ખાસી',
    'khi'   => "ખોસિયન\ ભાષા",
    'kho'   => 'ખોતાનીસ',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'કિકુયૂ',
    'kj'    => 'ક્વાન્યામા',
    'kk'    => 'કઝાક',
    'kl'    => 'કલાલ્લિસુત',
    'kln'   => 'Kalenjin',
    'km'    => 'ખ્મેર',
    'kmb'   => 'કિમ્બન્દુ',
    'kn'    => 'કન્નડા',
    'ko'    => 'કોરિયન',
    'kok'   => 'કોંકણી',
    'kos'   => 'કોસરિયન',
    'kpe'   => 'ક્પેલ્લે',
    'kr'    => 'કનુરી',
    'krc'   => "કરાચય\-બલ્કાર",
    'krl'   => 'કરેલિયન',
    'kro'   => 'ક્રૂ',
    'kru'   => 'કુરૂખ',
    'ks'    => 'કશ્મીરી',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'કુર્દિશ',
    'kum'   => 'કુમીક',
    'kut'   => 'કુતેનાઇ',
    'kv'    => 'કોમી',
    'kw'    => 'કોર્નિશ',
    'ky'    => 'કિરગીઝ',
    'la'    => 'લેટિન',
    'lad'   => 'લાદીનો',
    'lag'   => 'Langi',
    'lah'   => 'લાહન્ડા',
    'lam'   => 'લામ્બા',
    'lb'    => 'લક્ઝેમબર્ગિશ',
    'lez'   => 'લેઝધીયન',
    'lg'    => 'ગાંડા',
    'li'    => 'લિંબૂર્ગિશ',
    'ln'    => 'લિંગાલા',
    'lo'    => 'લાઓથિયન',
    'lol'   => 'મોગો',
    'loz'   => 'લોઝી',
    'lt'    => 'લિથુનિયન',
    'lu'    => "લ્યૂબા\ કટાંગા",
    'lua'   => "લૂબા\-લુલુઆ",
    'lui'   => 'લુઇસેનો',
    'lun'   => 'લુન્ડા',
    'luo'   => 'લ્યુઓ',
    'lus'   => 'લુશાઇ',
    'luy'   => 'Luyia',
    'lv'    => 'લાતવિયન',
    'mad'   => 'માદુરીસ',
    'mag'   => 'મગહી',
    'mai'   => 'મૈથિલી',
    'mak'   => 'મકાસર',
    'man'   => 'મન્ડિન્ગો',
    'map'   => 'ઓસ્ટ્રોનેશિયન',
    'mas'   => 'મસાઇ',
    'mdf'   => 'મોક્ષ',
    'mdr'   => 'મંડાર',
    'men'   => 'મેન્ડે',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'મલાગસી',
    'mga'   => "મિડિલ\ આઇરિશ",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'માર્શલીઝ',
    'mi'    => 'માઓરી',
    'mic'   => 'મિકમેક',
    'min'   => 'મિનાંગ્કાબાઉ',
    'mis'   => "વિવિધ\ ભાષા",
    'mk'    => 'મેસેડોનિયન',
    'mkh'   => "મોન\-ખ્મેર\ ભાષા",
    'ml'    => 'મલયાલમ',
    'mn'    => 'મોંગોલિયન',
    'mnc'   => 'માન્ચુ',
    'mni'   => 'મનિપૂરી',
    'mno'   => "મનોબો\ ભાષા",
    'mo'    => 'મોલડાવિયન',
    'moh'   => 'મોહૌક',
    'mos'   => 'મોસ્સી',
    'mr'    => 'મરાઠી',
    'ms'    => 'મલય',
    'mt'    => 'માલ્ટિઝ',
    'mua'   => 'Mundang',
    'mul'   => "બહુવિધ\ ભાષા",
    'mun'   => "મુન્ડા\ ભાષા",
    'mus'   => 'ક્રિક',
    'mwl'   => 'મિરાંડી',
    'mwr'   => 'મારવાડી',
    'my'    => 'બર્મીઝ',
    'myn'   => "માયા\ ભાષા",
    'myv'   => 'એર્ઝયા',
    'na'    => 'નાઉરૂ',
    'nah'   => 'નહઆત્લ',
    'nai'   => "ઉતરી\ અમેરીકન\ ઇંડિયન\ ભાષા",
    'nap'   => 'નેપોલિટાન',
    'naq'   => 'Nama',
    'nb'    => "નોર્વેજીયન\ બોકમાલ",
    'nd'    => "ઉતર\ દેબેલ",
    'nds'   => "લો\ જર્મન",
    'ne'    => 'નેપાળી',
    'new'   => 'નેવારી',
    'ng'    => 'ડોન્ગા',
    'nia'   => 'નિયાસ',
    'nic'   => "નાઇગર\-કોર્ડોફેનિયન\ ભાષા",
    'niu'   => 'નિયુઆન',
    'nl'    => 'ડચ',
    'nl_be' => 'ફ્લેમિશ',
    'nmg'   => 'Kwasio',
    'nn'    => "નૉર્વેજીયન\ નાયનૉર્સ્ક",
    'no'    => 'નૉર્વેજીયન',
    'nog'   => 'નોગાઇ',
    'non'   => "જૂની\ નોર્સ",
    'nqo'   => "એન\'કો",
    'nr'    => "દક્ષિણ\ દેબેલ",
    'nso'   => "ઉતરી\ સોથો",
    'nub'   => "ન્યુબિયાન\ ભાષા",
    'nus'   => 'Nuer',
    'nv'    => 'નાવાજો',
    'nwc'   => "પરંપરાગત\ નેવારી",
    'ny'    => 'ન્યાન્જા',
    'nym'   => 'ન્યામવેઝી',
    'nyn'   => 'ન્યાનકોલ',
    'nyo'   => 'ન્યોરો',
    'nzi'   => 'ન્ઝિમા',
    'oc'    => 'ઑકીટન',
    'oj'    => 'ઓઝિંબ્વા',
    'om'    => 'ઓરોમો',
    'or'    => 'ઉડિયા',
    'os'    => 'ઓસ્સેટિક',
    'osa'   => 'ઓસેજ',
    'ota'   => "ઓટોમાન\ તુર્કિશ",
    'oto'   => "ઓટોમિયન\ ભાષા",
    'pa'    => 'પંજાબી',
    'paa'   => "પાપુન\ ભાષા",
    'pag'   => 'પંગાસીનાન',
    'pal'   => 'પહલવી',
    'pam'   => 'પમ્પાન્ગા',
    'pap'   => 'પાપિયામેન્ટો',
    'pau'   => 'પલાઉઆન',
    'peo'   => "જૂની\ પર્શિયન",
    'phi'   => "ફિલિપીની\ ભાષા",
    'phn'   => 'ફોનિશિયન',
    'pi'    => 'પાલી',
    'pl'    => 'પોલીશ',
    'pon'   => 'પોહપિએન',
    'pra'   => "પ્રક્રૃત\ ભાષા",
    'pro'   => "જુની\ પ્રોવેન્સલ",
    'ps'    => 'પુશ્ટો',
    'pt'    => 'પોર્ટુગીઝ',
    'pt_br' => "બ્રાઝિલીયન\ પોર્ટુગીઝ",
    'pt_pt' => "ઇબેરિયન\ પોર્ટુગીઝ",
    'qu'    => 'ક્વેચુઆ',
    'raj'   => 'રાજસ્થાની',
    'rap'   => 'રાપાનુઇ',
    'rar'   => 'રારોટોંગન',
    'rm'    => "રહેટો\ રોમાન્સ",
    'rn'    => 'રૂન્દી',
    'ro'    => 'રોમાનિયન',
    'roa'   => "રોમાંસ\ ભાષા",
    'rof'   => 'Rombo',
    'rom'   => 'રોમાની',
    'ru'    => 'રશિયન',
    'rup'   => 'અરોમેનિયન',
    'rw'    => 'કિન્યારવાન્ડા',
    'rwk'   => 'Rwa',
    'sa'    => 'સંસ્કૃત',
    'sad'   => 'સોંડવે',
    'sah'   => 'યાકૂત',
    'sai'   => "દક્ષિણ\ અમેરીકન\ ઇંડિયન\ ભાષા",
    'sal'   => "સલીશન\ ભાષા",
    'sam'   => "સામરિટાન\ અરેમિક",
    'saq'   => 'Samburu',
    'sas'   => 'સાસાક',
    'sat'   => 'સંતાલી',
    'sbp'   => 'Sangu',
    'sc'    => 'સાર્દિનિયન',
    'scn'   => 'સિસિલિયાન',
    'sco'   => 'સ્કોટ્સ',
    'sd'    => 'સિંધી',
    'se'    => "નૉર્થન\ સામી",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'સેલ્કપ',
    'sem'   => "સેમિટિક\ ભાષા",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'સાંગો',
    'sga'   => "જૂની\ આયરિશ",
    'sgn'   => "સાંકેતિક\ ભાષા",
    'sh'    => "સર્બો\-ક્રોએશિયન",
    'shi'   => 'Tachelhit',
    'shn'   => 'શેન',
    'si'    => 'સિંહલી',
    'sid'   => 'સિદામો',
    'sio'   => "સિઉઆન\ ભાષા",
    'sit'   => "ચીની\-ટિબેટી\ ભાષા",
    'sk'    => 'સ્લોવૅક',
    'sl'    => 'સ્લોવેનિયન',
    'sla'   => "સ્લોવિક\ ભાષા",
    'sm'    => 'સામોન',
    'sma'   => "દક્ષિણ\ સામી",
    'smi'   => "સામી\ ભાષા",
    'smj'   => "લ્યુલ\ સામી",
    'smn'   => "ઇનારી\ સામી",
    'sms'   => "સ્કોલ્ટ\ સામી",
    'sn'    => 'શોના',
    'snk'   => 'સોનિન્કે',
    'so'    => 'સોમાલી',
    'sog'   => 'સોગ્ડિએન',
    'son'   => 'સોન્ઘાઇ',
    'sq'    => 'અલ્બેનિયન',
    'sr'    => 'સર્બિયન',
    'srn'   => "સ્રાનન\ ટોન્ગો",
    'srr'   => 'સેરેર',
    'ss'    => 'સ્વાતી',
    'ssa'   => "નીલો\-સહારન\ ભાષા",
    'ssy'   => 'Saho',
    'st'    => "સદર્ન\ સોથો",
    'su'    => 'સંડેનીઝ',
    'suk'   => 'સુકુમા',
    'sus'   => 'સુસુ',
    'sux'   => 'સુમેરિયન',
    'sv'    => 'સ્વીડિશ',
    'sw'    => 'સ્વાહિલી',
    'swb'   => 'કોમોરિયન',
    'swc'   => "Congo\ Swahili",
    'syc'   => "પરંપરાગત\ સિરિએક",
    'syr'   => 'સિરિએક',
    'ta'    => 'તમિલ',
    'tai'   => "તાઇ\ ભાષા",
    'te'    => 'તેલુગુ',
    'tem'   => 'ટિમ્ને',
    'teo'   => 'Teso',
    'ter'   => 'તેરેનો',
    'tet'   => 'તેતુમ',
    'tg'    => 'તાજીક',
    'th'    => 'થાઈ',
    'ti'    => 'ટાઇગ્રિનિયા',
    'tig'   => 'ટાઇગ્રે',
    'tiv'   => 'તિવ',
    'tk'    => 'તુર્કમેન',
    'tkl'   => 'તોકેલાઉ',
    'tl'    => 'ટાગાલોગ',
    'tlh'   => 'ક્લિંગન',
    'tli'   => 'લિંગિત',
    'tmh'   => 'તામાશેખ',
    'tn'    => 'ત્સ્વાના',
    'to'    => 'ટોંગા',
    'tog'   => "ન્યાસા\ ટોન્ગા",
    'tpi'   => "ટોક\ પિસિન",
    'tr'    => 'ટર્કીશ',
    'trv'   => 'Taroko',
    'ts'    => 'સોંગા',
    'tsi'   => 'સિમ્શિયન',
    'tt'    => 'તતાર',
    'tum'   => 'તમ્બૂકા',
    'tup'   => "ટ્યૂપી\ ભાષા",
    'tut'   => "અલ્ટેઇક\ ભાષા",
    'tvl'   => 'તુવાલુ',
    'tw'    => 'ટ્વાઇ',
    'twq'   => 'Tasawaq',
    'ty'    => 'તાહિતિયન',
    'tyv'   => 'ટુવીનિયન',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'ઉદમુર્ત',
    'ug'    => 'વિઘર',
    'uga'   => 'યુગેરિટિક',
    'uk'    => 'યુક્રેનિયન',
    'umb'   => 'ઉમ્બુન્ડૂ',
    'und'   => "અજ્ઞાત\ અથવા\ અમાન્ય\ ભાષા",
    'ur'    => 'ઉર્દુ',
    'uz'    => 'ઉઝ્બેક',
    'vai'   => 'વાઇ',
    've'    => 'વેન્દા',
    'vi'    => 'વિયેતનામીસ',
    'vo'    => 'વોલાપુક',
    'vot'   => 'વોટિક',
    'vun'   => 'Vunjo',
    'wa'    => 'વાલૂન',
    'wae'   => 'Walser',
    'wak'   => "વાકાશન\ ભાષા",
    'wal'   => 'વલામો',
    'war'   => 'વારે',
    'was'   => 'વાશો',
    'wen'   => "સોર્બિયન\ ભાષા",
    'wo'    => 'વોલોફ',
    'xal'   => 'કાલ્મિક',
    'xh'    => 'ખોસા',
    'xog'   => 'Soga',
    'yao'   => 'યાઓ',
    'yap'   => 'યાપીસ',
    'yav'   => 'Yangben',
    'yi'    => 'યીદ્દીશ',
    'yo'    => 'યોરૂબા',
    'ypk'   => "યૂપિક\ ભાષા",
    'yue'   => 'કેંટોનીઝ',
    'za'    => 'ઝુઆગ',
    'zap'   => 'ઝેપોટેક',
    'zbl'   => 'બ્લિસિમ્બોલ્સ',
    'zen'   => 'ઝેનાગા',
    'zh'    => 'ચાઇનીઝ',
    'znd'   => 'ઝન્ડે',
    'zu'    => 'ઝુલુ',
    'zun'   => 'ઝૂની',
    'zxx'   => "કોઇ\ ભાષાશાસ્ત્રીય\ સામગ્રી\ નથી",
    'zza'   => 'ઝાઝા',
);

%Locales::DB::Language::gu::name_to_code = (
    'aghem'                                                                                      => 'agq',
    'asu'                                                                                        => 'asa',
    'bafia'                                                                                      => 'ksf',
    'bena'                                                                                       => 'bez',
    'bodo'                                                                                       => 'brx',
    'cayuga'                                                                                     => 'cay',
    'centralmoroccotamazight'                                                                    => 'tzm',
    'chiga'                                                                                      => 'cgg',
    'colognian'                                                                                  => 'ksh',
    'congoswahili'                                                                               => 'swc',
    'embu'                                                                                       => 'ebu',
    'gusii'                                                                                      => 'guz',
    'jolafonyi'                                                                                  => 'dyo',
    'kabuverdianu'                                                                               => 'kea',
    'kalenjin'                                                                                   => 'kln',
    'koyraborosenni'                                                                             => 'ses',
    'koyrachiini'                                                                                => 'khq',
    'kwasio'                                                                                     => 'nmg',
    'langi'                                                                                      => 'lag',
    'luyia'                                                                                      => 'luy',
    'machame'                                                                                    => 'jmc',
    'makhuwameetto'                                                                              => 'mgh',
    'makonde'                                                                                    => 'kde',
    'meru'                                                                                       => 'mer',
    'morisyen'                                                                                   => 'mfe',
    'mundang'                                                                                    => 'mua',
    'nama'                                                                                       => 'naq',
    'nuer'                                                                                       => 'nus',
    'rombo'                                                                                      => 'rof',
    'rwa'                                                                                        => 'rwk',
    'saho'                                                                                       => 'ssy',
    'samburu'                                                                                    => 'saq',
    'sangu'                                                                                      => 'sbp',
    'sena'                                                                                       => 'seh',
    'seneca'                                                                                     => 'see',
    'shambala'                                                                                   => 'ksb',
    'soga'                                                                                       => 'xog',
    'tachelhit'                                                                                  => 'shi',
    'taita'                                                                                      => 'dav',
    'taroko'                                                                                     => 'trv',
    'tasawaq'                                                                                    => 'twq',
    'teso'                                                                                       => 'teo',
    'vunjo'                                                                                      => 'vun',
    'walser'                                                                                     => 'wae',
    'yangben'                                                                                    => 'yav',
    'zarma'                                                                                      => 'dje',
    'અંગીકા'                                                                         => 'anp',
    'અંગ્રેજી'                                                                   => 'en',
    'અંગ્રેજીઆધારિતક્રેઓલઅથવાપિજિન'    => 'cpe',
    'અકન'                                                                                  => 'ak',
    'અકોલી'                                                                            => 'ach',
    'અક્કાદીયાન'                                                             => 'akk',
    'અચીની'                                                                            => 'ace',
    'અજ્ઞાતઅથવાઅમાન્યભાષા'                               => 'und',
    'અઝેરી'                                                                            => 'az',
    'અત્સમ'                                                                            => 'cch',
    'અથાપાસ્કાનભાષા'                                                 => 'ath',
    'અદાંગ્મી'                                                                   => 'ada',
    'અદિઘે'                                                                            => 'ady',
    'અપાચેભાષા'                                                                => 'apa',
    'અપ્પરસોર્બિયન'                                                    => 'hsb',
    'અફાર'                                                                               => 'aa',
    'અફ્રિહિલી'                                                                => 'afh',
    'અફ્રોએશિયાટીકભાષાઓ'                                     => 'afa',
    'અબખાજિયન'                                                                   => 'ab',
    'અરબી'                                                                               => 'ar',
    'અરાપાહો'                                                                      => 'arp',
    'અરાવક'                                                                            => 'arw',
    'અરોમેનિયન'                                                                => 'rup',
    'અર્ગોનીઝ'                                                                   => 'an',
    'અર્માઇક'                                                                      => 'arc',
    'અલેઉત'                                                                            => 'ale',
    'અલ્ટેઇકભાષા'                                                          => 'tut',
    'અલ્બેનિયન'                                                                => 'sq',
    'અવધી'                                                                               => 'awa',
    'અવેરિક'                                                                         => 'av',
    'અવેસ્તન'                                                                      => 'ae',
    'અસ્તુરિયન'                                                                => 'ast',
    'આઇરિશ'                                                                            => 'ga',
    'આઇસલેન્ડિક'                                                             => 'is',
    'આફ્રિકન્સ'                                                                => 'af',
    'આયમારા'                                                                         => 'ay',
    'આર્મેનિયન'                                                                => 'hy',
    'આસામી'                                                                            => 'as',
    'ઇંગુશ'                                                                            => 'inh',
    'ઇંટરલિંગ'                                                                   => 'ie',
    'ઇંટરલિંગુઆ'                                                             => 'ia',
    'ઇંડોયુરોપીયનભાષા'                                           => 'ine',
    'ઇગ્બો'                                                                            => 'ig',
    'ઇજો'                                                                                  => 'ijo',
    'ઇટાલિયન'                                                                      => 'it',
    'ઇડૌ'                                                                                  => 'io',
    'ઇનારીસામી'                                                                => 'smn',
    'ઇનુકિટૂટ'                                                                   => 'iu',
    'ઇનુપિયાક'                                                                   => 'ik',
    'ઇન્ડોનેશિયન'                                                          => 'id',
    'ઇબાન'                                                                               => 'iba',
    'ઇબેરિયનપોર્ટુગીઝ'                                           => 'pt_pt',
    'ઇબેરિયનસ્પેનિશ'                                                 => 'es_es',
    'ઇરાનીભાષા'                                                                => 'ira',
    'ઇરોક્વોઇયનભાષા'                                                 => 'iro',
    'ઇલોકો'                                                                            => 'ilo',
    'ઇવે'                                                                                  => 'ee',
    'ઇવોન્ડો'                                                                      => 'ewo',
    'ઉઝ્બેક'                                                                         => 'uz',
    'ઉડિયા'                                                                            => 'or',
    'ઉતરદેબેલ'                                                                   => 'nd',
    'ઉતરીઅમેરીકનઇંડિયનભાષા'                            => 'nai',
    'ઉતરીસોથો'                                                                   => 'nso',
    'ઉદમુર્ત'                                                                      => 'udm',
    'ઉમ્બુન્ડૂ'                                                                => 'umb',
    'ઉર્દુ'                                                                            => 'ur',
    'એકાજુક'                                                                         => 'eka',
    'એનકો'                                                                               => 'nqo',
    'એનૂ'                                                                                  => 'ain',
    'એફિક'                                                                               => 'efi',
    'એમ્હારિક'                                                                   => 'am',
    'એરોકૈનિયન'                                                                => 'arn',
    'એર્ઝયા'                                                                         => 'myv',
    'એલામાઇટ'                                                                      => 'elx',
    'એલ્ગોક્વિયનભાષા'                                              => 'alg',
    'એસ્ટોનિયન'                                                                => 'et',
    'એસ્પેરાન્ટો'                                                          => 'eo',
    'ઑકીટન'                                                                            => 'oc',
    'ઓઝિંબ્વા'                                                                   => 'oj',
    'ઓટોમાનતુર્કિશ'                                                    => 'ota',
    'ઓટોમિયનભાષા'                                                          => 'oto',
    'ઓરોમો'                                                                            => 'om',
    'ઓસેજ'                                                                               => 'osa',
    'ઓસ્ટ્રિઅનજર્મન'                                                 => 'de_at',
    'ઓસ્ટ્રેલિયનઅંગ્રેજી'                                  => 'en_au',
    'ઓસ્ટ્રેલિયનભાષા'                                              => 'aus',
    'ઓસ્ટ્રોનેશિયન'                                                    => 'map',
    'ઓસ્સેટિક'                                                                   => 'os',
    'કઝાક'                                                                               => 'kk',
    'કડ્ડો'                                                                            => 'cad',
    'કતલાન'                                                                            => 'ca',
    'કનુરી'                                                                            => 'kr',
    'કન્નડા'                                                                         => 'kn',
    'કબાઇલ'                                                                            => 'kab',
    'કબાર્ડિયન'                                                                => 'kbd',
    'કમ્બા'                                                                            => 'kam',
    'કરાચયબલ્કાર'                                                          => 'krc',
    'કરિબ'                                                                               => 'car',
    'કરેલિયન'                                                                      => 'krl',
    'કલાલ્લિસુત'                                                             => 'kl',
    'કશ્મીરી'                                                                      => 'ks',
    'કાકેશિયનભાષા'                                                       => 'cau',
    'કાચિન'                                                                            => 'kac',
    'કારાકલ્પક'                                                                => 'kaa',
    'કારેન'                                                                            => 'kar',
    'કાલ્મિક'                                                                      => 'xal',
    'કાવી'                                                                               => 'kaw',
    'કાશુબિયન'                                                                   => 'csb',
    'કિકુયૂ'                                                                         => 'ki',
    'કિન્યારવાન્ડા'                                                    => 'rw',
    'કિમ્બન્દુ'                                                                => 'kmb',
    'કિરગીઝ'                                                                         => 'ky',
    'કુતેનાઇ'                                                                      => 'kut',
    'કુમીક'                                                                            => 'kum',
    'કુરૂખ'                                                                            => 'kru',
    'કુર્દિશ'                                                                      => 'ku',
    'કુશિતિકભાષા'                                                          => 'cus',
    'કૃત્રિમભાષા'                                                          => 'art',
    'કેંટોનીઝ'                                                                   => 'yue',
    'કેનેડિયનઅંગ્રેજી'                                           => 'en_ca',
    'કેનેડિયનફ્રેંચ'                                                 => 'fr_ca',
    'કેમોરો'                                                                         => 'ch',
    'કોંકણી'                                                                         => 'kok',
    'કોંગો'                                                                            => 'kg',
    'કોઇભાષાશાસ્ત્રીયસામગ્રીનથી'             => 'zxx',
    'કોપ્ટિક'                                                                      => 'cop',
    'કોમી'                                                                               => 'kv',
    'કોમોરિયન'                                                                   => 'swb',
    'કોરિયન'                                                                         => 'ko',
    'કોરો'                                                                               => 'kfo',
    'કોર્નિશ'                                                                      => 'kw',
    'કોર્સિકન'                                                                   => 'co',
    'કોસરિયન'                                                                      => 'kos',
    'ક્પેલ્લે'                                                                   => 'kpe',
    'ક્રિક'                                                                            => 'mus',
    'ક્રિમીનતુર્કી'                                                    => 'crh',
    'ક્રી'                                                                               => 'cr',
    'ક્રૂ'                                                                               => 'kro',
    'ક્રેઓલઅથવાપિજિન'                                              => 'crp',
    'ક્રોએશિયન'                                                                => 'hr',
    'ક્લિંગન'                                                                      => 'tlh',
    'ક્વાન્યામા'                                                             => 'kj',
    'ક્વેચુઆ'                                                                      => 'qu',
    'ખાસી'                                                                               => 'kha',
    'ખોતાનીસ'                                                                      => 'kho',
    'ખોસા'                                                                               => 'xh',
    'ખોસિયનભાષા'                                                             => 'khi',
    'ખ્મેર'                                                                            => 'km',
    'ગા'                                                                                     => 'gaa',
    'ગાંડા'                                                                            => 'lg',
    'ગાયો'                                                                               => 'gay',
    'ગીઝ'                                                                                  => 'gez',
    'ગુઆરાની'                                                                      => 'gn',
    'ગુજરાતી'                                                                      => 'gu',
    'ગેલિશિયન'                                                                   => 'gl',
    'ગોંડી'                                                                            => 'gon',
    'ગોથિક'                                                                            => 'got',
    'ગોરોન્તાલો'                                                             => 'gor',
    'ગ્રીક'                                                                            => 'el',
    'ગ્રેબો'                                                                         => 'grb',
    'ગ્વિચઇન'                                                                      => 'gwi',
    'ચર્ચસ્લાવિક'                                                          => 'cu',
    'ચાઇનીઝ'                                                                         => 'zh',
    'ચાર્મિકભાષા'                                                          => 'cmc',
    'ચિનૂકજાર્ગન'                                                          => 'chn',
    'ચિબ્ચા'                                                                         => 'chb',
    'ચીનીટિબેટીભાષા'                                                 => 'sit',
    'ચૂકીસે'                                                                         => 'chk',
    'ચૂવાશ'                                                                            => 'cv',
    'ચેક'                                                                                  => 'cs',
    'ચેચન'                                                                               => 'ce',
    'ચોક્તૌ'                                                                         => 'cho',
    'છગાતાઇ'                                                                         => 'chg',
    'જર્મન'                                                                            => 'de',
    'જર્મેનિકભાષા'                                                       => 'gem',
    'જાપાનીઝ'                                                                      => 'ja',
    'જાવાનીસ'                                                                      => 'jv',
    'જિલ્બરટીઝ'                                                                => 'gil',
    'જુદેઓઅરબી'                                                                => 'jrb',
    'જુદેઓપર્શિયન'                                                       => 'jpr',
    'જુનીઅંગ્રેજી'                                                       => 'ang',
    'જુનીપ્રોવેન્સલ'                                                 => 'pro',
    'જૂનીઆયરિશ'                                                                => 'sga',
    'જૂનીનોર્સ'                                                                => 'non',
    'જૂનીપર્શિયન'                                                          => 'peo',
    'જૂનીફ્રેંચ'                                                             => 'fro',
    'જૂનીહાઇજર્મન'                                                       => 'goh',
    'જ્જુ'                                                                               => 'kaj',
    'જ્યોર્જિઅન'                                                             => 'ka',
    'ઝન્ડે'                                                                            => 'znd',
    'ઝાઝા'                                                                               => 'zza',
    'ઝુઆગ'                                                                               => 'za',
    'ઝુલુ'                                                                               => 'zu',
    'ઝૂની'                                                                               => 'zun',
    'ઝેનાગા'                                                                         => 'zen',
    'ઝેપોટેક'                                                                      => 'zap',
    'ઝોંગખા'                                                                         => 'dz',
    'ટર્કીશ'                                                                         => 'tr',
    'ટાઇગ્રિનિયા'                                                          => 'ti',
    'ટાઇગ્રે'                                                                      => 'tig',
    'ટાગાલોગ'                                                                      => 'tl',
    'ટિમ્ને'                                                                         => 'tem',
    'ટુવીનિયન'                                                                   => 'tyv',
    'ટોંગા'                                                                            => 'to',
    'ટોકપિસિન'                                                                   => 'tpi',
    'ટ્યૂપીભાષા'                                                             => 'tup',
    'ટ્વાઇ'                                                                            => 'tw',
    'ડચ'                                                                                     => 'nl',
    'ડેનિશ'                                                                            => 'da',
    'ડોગ્રિબ'                                                                      => 'dgr',
    'ડોગ્રી'                                                                         => 'doi',
    'ડોન્ગા'                                                                         => 'ng',
    'ડ્યુલા'                                                                         => 'dyu',
    'તતાર'                                                                               => 'tt',
    'તમિલ'                                                                               => 'ta',
    'તમ્બૂકા'                                                                      => 'tum',
    'તાઇભાષા'                                                                      => 'tai',
    'તાજીક'                                                                            => 'tg',
    'તામાશેખ'                                                                      => 'tmh',
    'તાહિતિયન'                                                                   => 'ty',
    'તિબેટી'                                                                         => 'bo',
    'તિવ'                                                                                  => 'tiv',
    'તુર્કમેન'                                                                   => 'tk',
    'તુવાલુ'                                                                         => 'tvl',
    'તેતુમ'                                                                            => 'tet',
    'તેરેનો'                                                                         => 'ter',
    'તેલુગુ'                                                                         => 'te',
    'તોકેલાઉ'                                                                      => 'tkl',
    'ત્યાપ'                                                                            => 'kcg',
    'ત્સ્વાના'                                                                   => 'tn',
    'થાઈ'                                                                                  => 'th',
    'દક્ષિણઅમેરીકનઇંડિયનભાષા'                      => 'sai',
    'દક્ષિણઅલ્તાઇ'                                                       => 'alt',
    'દક્ષિણદેબેલ'                                                          => 'nr',
    'દક્ષિણસામી'                                                             => 'sma',
    'દાકોતા'                                                                         => 'dak',
    'દાયક'                                                                               => 'day',
    'દાર્ગવા'                                                                      => 'dar',
    'દિન્કા'                                                                         => 'din',
    'દિવેહી'                                                                         => 'dv',
    'દુઆલા'                                                                            => 'dua',
    'દેલેવેર'                                                                      => 'del',
    'દ્રવિડિઅનભાષા'                                                    => 'dra',
    'નહઆત્લ'                                                                         => 'nah',
    'નાઇગરકોર્ડોફેનિયનભાષા'                            => 'nic',
    'નાઉરૂ'                                                                            => 'na',
    'નાવાજો'                                                                         => 'nv',
    'નિમ્નસોર્બિયન'                                                    => 'dsb',
    'નિયાસ'                                                                            => 'nia',
    'નિયુઆન'                                                                         => 'niu',
    'નીલોસહારનભાષા'                                                    => 'ssa',
    'નેપાળી'                                                                         => 'ne',
    'નેપોલિટાન'                                                                => 'nap',
    'નેવારી'                                                                         => 'new',
    'નૉર્થનસામી'                                                             => 'se',
    'નૉર્વેજીયન'                                                             => 'no',
    'નૉર્વેજીયનનાયનૉર્સ્ક'                               => 'nn',
    'નોગાઇ'                                                                            => 'nog',
    'નોર્ધર્નફ્રિશિયન'                                           => 'frr',
    'નોર્વેજીયનબોકમાલ'                                           => 'nb',
    'ન્ઝિમા'                                                                         => 'nzi',
    'ન્યાનકોલ'                                                                   => 'nyn',
    'ન્યાન્જા'                                                                   => 'ny',
    'ન્યામવેઝી'                                                                => 'nym',
    'ન્યાસાટોન્ગા'                                                       => 'tog',
    'ન્યુબિયાનભાષા'                                                    => 'nub',
    'ન્યોરો'                                                                         => 'nyo',
    'પંગાસીનાન'                                                                => 'pag',
    'પંજાબી'                                                                         => 'pa',
    'પમ્પાન્ગા'                                                                => 'pam',
    'પરંપરાગતનેવારી'                                                 => 'nwc',
    'પરંપરાગતસિરિએક'                                                 => 'syc',
    'પર્શિયન'                                                                      => 'fa',
    'પલાઉઆન'                                                                         => 'pau',
    'પશ્ચિમીફ્રિશિયન'                                              => 'fy',
    'પહલવી'                                                                            => 'pal',
    'પાપિયામેન્ટો'                                                       => 'pap',
    'પાપુનભાષા'                                                                => 'paa',
    'પાર્ટુગીઝઆધારિતક્રેઓલઅથવાપિજિન' => 'cpp',
    'પાલી'                                                                               => 'pi',
    'પુશ્ટો'                                                                         => 'ps',
    'પૂર્વફ્રિશિયન'                                                    => 'frs',
    'પોર્ટુગીઝ'                                                                => 'pt',
    'પોલીશ'                                                                            => 'pl',
    'પોહપિએન'                                                                      => 'pon',
    'પ્રક્રૃતભાષા'                                                       => 'pra',
    'પ્રાચીનઇજીપ્શિયન'                                           => 'egy',
    'પ્રાચીનગ્રીક'                                                       => 'grc',
    'ફન્ટી'                                                                            => 'fat',
    'ફિજીયન'                                                                         => 'fj',
    'ફિનિશ'                                                                            => 'fi',
    'ફિન્નોઉગ્રીયનભાષા'                                        => 'fiu',
    'ફિલિપિનો'                                                                   => 'fil',
    'ફિલિપીનીભાષા'                                                       => 'phi',
    'ફુલાહ'                                                                            => 'ff',
    'ફેંગ'                                                                               => 'fan',
    'ફોન'                                                                                  => 'fon',
    'ફોનિશિયન'                                                                   => 'phn',
    'ફોરિસ્ત'                                                                      => 'fo',
    'ફ્રિયુલિયાન'                                                          => 'fur',
    'ફ્રેંચઆધારિતક્રેઓલઅથવાપિજિન'          => 'cpf',
    'ફ્રેન્ચ'                                                                      => 'fr',
    'ફ્લેમિશ'                                                                      => 'nl_be',
    'બંગાળી'                                                                         => 'bn',
    'બગિનીસ'                                                                         => 'bug',
    'બતાક'                                                                               => 'btk',
    'બન્ટુ'                                                                            => 'bnt',
    'બમિલેકેભાષા'                                                          => 'bai',
    'બર્બર'                                                                            => 'ber',
    'બર્મીઝ'                                                                         => 'my',
    'બલૂચી'                                                                            => 'bal',
    'બલ્ગેરિયન'                                                                => 'bg',
    'બષ્ખિર'                                                                         => 'ba',
    'બસા'                                                                                  => 'bas',
    'બહુવિધભાષા'                                                             => 'mul',
    'બાંદા'                                                                            => 'bad',
    'બામ્બારા'                                                                   => 'bm',
    'બાયા'                                                                               => 'gba',
    'બાલિનીસ'                                                                      => 'ban',
    'બાલ્ટિકભાષા'                                                          => 'bat',
    'બાસ્ક'                                                                            => 'eu',
    'બિકોલ'                                                                            => 'bik',
    'બિની'                                                                               => 'bin',
    'બિસ્લામા'                                                                   => 'bi',
    'બિહારી'                                                                         => 'bh',
    'બુરિયાત'                                                                      => 'bua',
    'બેજા'                                                                               => 'bej',
    'બેમ્બા'                                                                         => 'bem',
    'બેલારુશિયન'                                                             => 'be',
    'બોસ્નિયન'                                                                   => 'bs',
    'બ્રજ'                                                                               => 'bra',
    'બ્રાઝિલીયનપોર્ટુગીઝ'                                  => 'pt_br',
    'બ્રિટિશઅંગ્રેજી'                                              => 'en_gb',
    'બ્રેટોન'                                                                      => 'br',
    'બ્લિન'                                                                            => 'byn',
    'બ્લિસિમ્બોલ્સ'                                                    => 'zbl',
    'ભારતીયભાષા'                                                             => 'inc',
    'ભોજપુરી'                                                                      => 'bho',
    'મંડાર'                                                                            => 'mdr',
    'મકાસર'                                                                            => 'mak',
    'મગહી'                                                                               => 'mag',
    'મધ્યઅમેરિકનઇંડિયનભાષા'                            => 'cai',
    'મધ્યડચ'                                                                         => 'dum',
    'મધ્યહાઇજર્મન'                                                       => 'gmh',
    'મનિપૂરી'                                                                      => 'mni',
    'મનોબોભાષા'                                                                => 'mno',
    'મન્ડિન્ગો'                                                                => 'man',
    'મરાઠી'                                                                            => 'mr',
    'મલય'                                                                                  => 'ms',
    'મલયાલમ'                                                                         => 'ml',
    'મલાગસી'                                                                         => 'mg',
    'મસાઇ'                                                                               => 'mas',
    'માંક્સ'                                                                         => 'gv',
    'માઓરી'                                                                            => 'mi',
    'માદુરીસ'                                                                      => 'mad',
    'માન્ચુ'                                                                         => 'mnc',
    'માયાભાષા'                                                                   => 'myn',
    'મારવાડી'                                                                      => 'mwr',
    'મારી'                                                                               => 'chm',
    'માર્શલીઝ'                                                                   => 'mh',
    'માલ્ટિઝ'                                                                      => 'mt',
    'મિકમેક'                                                                         => 'mic',
    'મિડિલઅંગ્રેજી'                                                    => 'enm',
    'મિડિલઆઇરિશ'                                                             => 'mga',
    'મિડિલફ્રેંચ'                                                          => 'frm',
    'મિનાંગ્કાબાઉ'                                                       => 'min',
    'મિરાંડી'                                                                      => 'mwl',
    'મુન્ડાભાષા'                                                             => 'mun',
    'મેન્ડે'                                                                         => 'men',
    'મેસેડોનિયન'                                                             => 'mk',
    'મૈથિલી'                                                                         => 'mai',
    'મોંગ'                                                                               => 'hmn',
    'મોંગોલિયન'                                                                => 'mn',
    'મોક્ષ'                                                                            => 'mdf',
    'મોગો'                                                                               => 'lol',
    'મોનખ્મેરભાષા'                                                       => 'mkh',
    'મોલડાવિયન'                                                                => 'mo',
    'મોસ્સી'                                                                         => 'mos',
    'મોહૌક'                                                                            => 'moh',
    'યાઓ'                                                                                  => 'yao',
    'યાકૂત'                                                                            => 'sah',
    'યાપીસ'                                                                            => 'yap',
    'યીદ્દીશ'                                                                      => 'yi',
    'યુએસઅંગ્રેજી'                                                       => 'en_us',
    'યુક્રેનિયન'                                                             => 'uk',
    'યુગેરિટિક'                                                                => 'uga',
    'યૂપિકભાષા'                                                                => 'ypk',
    'યોરૂબા'                                                                         => 'yo',
    'રશિયન'                                                                            => 'ru',
    'રહેટોરોમાન્સ'                                                       => 'rm',
    'રાજસ્થાની'                                                                => 'raj',
    'રાપાનુઇ'                                                                      => 'rap',
    'રારોટોંગન'                                                                => 'rar',
    'રૂન્દી'                                                                         => 'rn',
    'રોમાંસભાષા'                                                             => 'roa',
    'રોમાનિયન'                                                                   => 'ro',
    'રોમાની'                                                                         => 'rom',
    'લક્ઝેમબર્ગિશ'                                                       => 'lb',
    'લાઓથિયન'                                                                      => 'lo',
    'લાતવિયન'                                                                      => 'lv',
    'લાદીનો'                                                                         => 'lad',
    'લામ્બા'                                                                         => 'lam',
    'લાહન્ડા'                                                                      => 'lah',
    'લિંગાલા'                                                                      => 'ln',
    'લિંગિત'                                                                         => 'tli',
    'લિંબૂર્ગિશ'                                                             => 'li',
    'લિથુનિયન'                                                                   => 'lt',
    'લુઇસેનો'                                                                      => 'lui',
    'લુન્ડા'                                                                         => 'lun',
    'લુશાઇ'                                                                            => 'lus',
    'લૂબાલુલુઆ'                                                                => 'lua',
    'લેઝધીયન'                                                                      => 'lez',
    'લેટિન'                                                                            => 'la',
    'લોજર્મન'                                                                      => 'nds',
    'લોજ્બાન'                                                                      => 'jbo',
    'લોઝી'                                                                               => 'loz',
    'લ્યુઓ'                                                                            => 'luo',
    'લ્યુલસામી'                                                                => 'smj',
    'લ્યૂબાકટાંગા'                                                       => 'lu',
    'વલામો'                                                                            => 'wal',
    'વાઇ'                                                                                  => 'vai',
    'વાકાશનભાષા'                                                             => 'wak',
    'વારે'                                                                               => 'war',
    'વાલૂન'                                                                            => 'wa',
    'વાશો'                                                                               => 'was',
    'વિઘર'                                                                               => 'ug',
    'વિયેતનામીસ'                                                             => 'vi',
    'વિવિધભાષા'                                                                => 'mis',
    'વેન્દા'                                                                         => 've',
    'વેલ્શ'                                                                            => 'cy',
    'વોટિક'                                                                            => 'vot',
    'વોલાપુક'                                                                      => 'vo',
    'વોલોફ'                                                                            => 'wo',
    'શિપેવ્યાન'                                                                => 'chp',
    'શેન'                                                                                  => 'shn',
    'શેયેન્ન'                                                                      => 'chy',
    'શેરોકી'                                                                         => 'chr',
    'શોના'                                                                               => 'sn',
    'સંડેનીઝ'                                                                      => 'su',
    'સંતાલી'                                                                         => 'sat',
    'સંસ્કૃત'                                                                      => 'sa',
    'સદર્નસોથો'                                                                => 'st',
    'સર્બિયન'                                                                      => 'sr',
    'સર્બોક્રોએશિયન'                                                 => 'sh',
    'સલીશનભાષા'                                                                => 'sal',
    'સાંકેતિકભાષા'                                                       => 'sgn',
    'સાંગો'                                                                            => 'sg',
    'સામરિટાનઅરેમિક'                                                 => 'sam',
    'સામીભાષા'                                                                   => 'smi',
    'સામોન'                                                                            => 'sm',
    'સાર્દિનિયન'                                                             => 'sc',
    'સાસાક'                                                                            => 'sas',
    'સિંધી'                                                                            => 'sd',
    'સિંહલી'                                                                         => 'si',
    'સિઉઆનભાષા'                                                                => 'sio',
    'સિક્સિકા'                                                                   => 'bla',
    'સિચુઆનયી'                                                                   => 'ii',
    'સિદામો'                                                                         => 'sid',
    'સિબુઆનો'                                                                      => 'ceb',
    'સિમ્શિયન'                                                                   => 'tsi',
    'સિરિએક'                                                                         => 'syr',
    'સિસિલિયાન'                                                                => 'scn',
    'સુકુમા'                                                                         => 'suk',
    'સુમેરિયન'                                                                   => 'sux',
    'સુસુ'                                                                               => 'sus',
    'સેમિટિકભાષા'                                                          => 'sem',
    'સેરેર'                                                                            => 'srr',
    'સેલ્કપ'                                                                         => 'sel',
    'સેલ્ટિકભાષા'                                                          => 'cel',
    'સોંગા'                                                                            => 'ts',
    'સોંડવે'                                                                         => 'sad',
    'સોગ્ડિએન'                                                                   => 'sog',
    'સોનિન્કે'                                                                   => 'snk',
    'સોન્ઘાઇ'                                                                      => 'son',
    'સોમાલી'                                                                         => 'so',
    'સોર્બિયનભાષા'                                                       => 'wen',
    'સ્કોટ્સ'                                                                      => 'sco',
    'સ્કોટ્સગેલિક'                                                       => 'gd',
    'સ્કોલ્ટસામી'                                                          => 'sms',
    'સ્પેનિશ'                                                                      => 'es',
    'સ્રાનનટોન્ગો'                                                       => 'srn',
    'સ્લેવ'                                                                            => 'den',
    'સ્લોવિકભાષા'                                                          => 'sla',
    'સ્લોવૅક'                                                                      => 'sk',
    'સ્લોવેનિયન'                                                             => 'sl',
    'સ્વાતી'                                                                         => 'ss',
    'સ્વાહિલી'                                                                   => 'sw',
    'સ્વિસજર્મન'                                                             => 'gsw',
    'સ્વિસફ્રેંચ'                                                          => 'fr_ch',
    'સ્વિસહાયજર્મન'                                                    => 'de_ch',
    'સ્વીડિશ'                                                                      => 'sv',
    'હંગેરિયન'                                                                   => 'hu',
    'હાવાઇયન'                                                                      => 'haw',
    'હિટ્ટિતે'                                                                   => 'hit',
    'હિન્દી'                                                                         => 'hi',
    'હિમાચલી'                                                                      => 'him',
    'હિરીમોટૂ'                                                                   => 'ho',
    'હિલિગેનોન'                                                                => 'hil',
    'હીબ્રુ'                                                                         => 'he',
    'હૂપા'                                                                               => 'hup',
    'હેરેરો'                                                                         => 'hz',
    'હૈડા'                                                                               => 'hai',
    'હૈતીયન'                                                                         => 'ht',
    'હૌસા'                                                                               => 'ha',
);

1;
