package Locales::DB::Language::or;

# Auto generated from CLDR

$Locales::DB::Language::or::VERSION = '0.01';

$Locales::DB::Language::or::cldr_version = '1.7.1';

%Locales::DB::Language::or::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => 'ନା',
        'yesstr' => 'ହଁ'
    },
);

%Locales::DB::Language::or::code_to_name = (
    'aa'    => 'ଅଫାର୍',
    'ab'    => 'ଆବ୍ଖାଜିଆନ୍',
    'ace'   => 'ଆଚାଇନୀଜ୍',
    'ach'   => 'ଆକୋଲି',
    'ada'   => 'ଆଦାଙ୍ଗେମ୍',
    'ady'   => 'ଅଦ୍ୟଘେ',
    'ae'    => 'ଅବେସ୍ତନ',
    'af'    => 'ଆଫ୍ରିକାନସ୍',
    'afa'   => "ଆଫ୍ରୋ\ ଏସିଆଟିକ୍\ ଭାଷା",
    'afh'   => 'ଆଫ୍ରିହିଲି',
    'ain'   => 'ଆଇନୁ',
    'ak'    => 'ଅକନ୍',
    'akk'   => 'ଆକାଡିଆନ୍',
    'ale'   => 'ଆଲେଇଟୁ',
    'alg'   => "ଏଲ୍ଗୋନକ୍ବିନା\ ଭାଷା",
    'alt'   => "ଦକ୍ଷିଣ\ ଆଲ୍ଟାଇ",
    'am'    => 'ଆମହାରକି',
    'an'    => 'ଆର୍ଗୋନୀ',
    'ang'   => "ପୁରୁଣା\ ଇଁରାଜୀ",
    'anp'   => 'ଅଁଗୀକା',
    'apa'   => "ଆପାଚୀ\ ଭାଷା",
    'ar'    => 'ଆରବିକ୍',
    'arc'   => 'ଆରାମାଇକ୍',
    'arn'   => 'ଆରାଉକାନିଆନ୍',
    'arp'   => 'ଆରାପାହୋ',
    'art'   => "କୃତ୍ରିମ\ ଭାଷା",
    'arw'   => 'ଆରୱକ',
    'as'    => 'ଆସାମୀ',
    'ast'   => 'ଆଷ୍ଟୁରିଆନ୍',
    'ath'   => "ଆଥପାସ୍କାନ୍\ ଭାଷା",
    'aus'   => "ଅଷ୍ଟ୍ରେଲିଆନ୍\ ଭାଷା",
    'av'    => 'ଆଭାରିକ୍',
    'awa'   => 'ଆୱାଧି',
    'ay'    => 'ଆୟମାରା',
    'az'    => 'ଆଜେରବାଇଜାନି',
    'ba'    => 'ବଶଖିର୍',
    'bad'   => 'ବାନ୍ଦା',
    'bai'   => "ବମିଲେକେ\ ଭାଷା",
    'bal'   => 'ବାଲୁଚି',
    'ban'   => 'ବାଲିନୀଜ୍',
    'bas'   => 'ବାସା',
    'bat'   => "ବାଲାଟିକ୍\ ଭାଷା",
    'be'    => 'ବେଲାରୁଷିଆନ୍',
    'bej'   => 'ବେଜା',
    'bem'   => 'ବେମ୍ବା',
    'ber'   => 'ବେରବର୍',
    'bg'    => 'ବୁଲଗେରିଆନ୍',
    'bh'    => 'ବିହାରୀ',
    'bho'   => 'ଭୋଜପୁରୀ',
    'bi'    => 'ବିସଲାମା',
    'bik'   => 'ବିକୋଲ୍',
    'bin'   => 'ବିନି',
    'bla'   => 'ବିକ୍ସିକା',
    'bm'    => 'ବାମ୍ବାରା',
    'bn'    => 'ବଙ୍ଗାଳୀ',
    'bnt'   => 'ବାଣ୍ଟୁ',
    'bo'    => 'ତିବେତାନ୍',
    'br'    => 'ବ୍ରେଟନ୍',
    'bra'   => 'ବ୍ରାଜ୍',
    'bs'    => 'କାଟଲାନ୍',
    'btk'   => 'ବାଟାକ୍',
    'bua'   => 'ବୁରିଆଟ୍',
    'bug'   => 'ବୁଗୀନୀଜ୍',
    'byn'   => 'ବ୍ଲିନ୍',
    'ca'    => 'କାଟାଲାନ୍',
    'cad'   => 'କାଡୋ',
    'cai'   => "ମଧ୍ୟ\ ଆମେରିକା\ ଭାରତୀୟ\ ଭାଷା",
    'car'   => 'କାରିବ୍',
    'cau'   => "କାକୋଶୀ\ ଭାଷା",
    'cch'   => 'ଆତ୍ସମ୍',
    'ce'    => 'ଚେଚନ୍',
    'ceb'   => 'ସୀବୁଆନୋ',
    'cel'   => "କେଲ୍ଟ\ ଭାଷା",
    'ch'    => 'ଚାମୋରୋ',
    'chb'   => 'ଚିବ୍ଚା',
    'chg'   => 'ଛଗତାଇ',
    'chk'   => 'ଚୁକୀସେ',
    'chm'   => 'ମାରୀ',
    'chn'   => "ଚିନୁକ୍\ ଜାରଗାଁନ୍",
    'cho'   => 'ଚୋଟୱା',
    'chp'   => 'ଚିପେୱାନ୍',
    'chr'   => 'ଚେରୋକୀ',
    'chy'   => 'ଚେଚେନା',
    'cmc'   => "ଚାମିକ୍\ ଭାଷା",
    'co'    => 'କୋର୍ସିକାନ୍',
    'cop'   => 'କପ୍ଟିକ୍',
    'cpe'   => "ଇଁରାଜୀ\ ଆଧାରିତ\ କ୍ରେଓଲ୍\ କିମ୍ବା\ ପିଜିନ୍",
    'cpf'   => "ଫ୍ରେଞ୍ଚ\ ଆଧାରିତ\ କ୍ରେଓଲ୍\ କିମ୍ବା\ ପିଜିନ୍",
    'cpp'   => "ପର୍ତ୍ତୁଗ୍ରୀଜ୍\ ଆଧାରିତ\ କ୍ରେଓଲ୍\ କିମ୍ବା\ ପିଜିନ୍",
    'cr'    => 'କ୍ରୀ',
    'crh'   => "କ୍ରୀମିନ୍\ ତୁର୍କୀସ୍",
    'crp'   => "କ୍ରେଓଲ୍\ କିମ୍ବା\ ପିଜିନ୍",
    'cs'    => 'ଚେକ୍',
    'csb'   => 'କାଶୁବିଆନ୍',
    'cu'    => "ଚର୍ଚ୍ଚ\ ସ୍ଲାଭିକ୍",
    'cus'   => "କୁଶିତିକ୍\ ଭାଷା",
    'cv'    => 'ଚୁଭାଶ୍',
    'cy'    => 'ୱେଲ୍ସ',
    'da'    => 'ଡାନ୍ନିସ୍',
    'dak'   => 'ଡାକୋଟା',
    'dar'   => 'ଡାରାଗ୍ୱା',
    'day'   => 'ଡାୟକ୍',
    'de'    => 'ଜର୍ମାନ୍',
    'de_at' => "ଅଷ୍ଟ୍ରିଆନ୍\ ଜର୍ମାନ",
    'de_ch' => "ସ୍ବିସ୍\ ହାଇ\ ଜର୍ମାନ୍",
    'del'   => 'ଡେଲାୱେର୍',
    'den'   => 'ସ୍ଲେଭ୍',
    'dgr'   => 'ଡୋଗ୍ରିବ୍',
    'din'   => 'ଦିଙ୍କା',
    'doi'   => 'ଡୋଗ୍ରୀ',
    'dra'   => "ଦ୍ରାବିଡିଆନ୍\ ଭାଷା",
    'dsb'   => "ନିଚଳା\ ସର୍ବିଆନ୍",
    'dua'   => 'ଡୁଆନା',
    'dum'   => "ମଧ୍ୟ\ ପର୍ତ୍ତୁଗାଲୀ",
    'dv'    => 'ଡିଭେହୀ',
    'dyu'   => 'ଡୁଆଲା',
    'dz'    => 'ଭୂଟାନୀ',
    'ee'    => 'ଇୱେ',
    'efi'   => 'ଏଫିକ୍',
    'egy'   => "ପ୍ରାଚୀନ୍\ ମିଶିରି",
    'eka'   => 'ଏକାଜୁକ୍',
    'el'    => 'ଗ୍ରୀକ୍',
    'elx'   => 'ଏଲାମାଇଟ୍',
    'en'    => 'ଇଂରାଜୀ',
    'en_au' => "ଅଷ୍ଟ୍ରେଲିଆନ୍\ ଇଁରାଜୀ",
    'en_ca' => "କାନାଡିଆନ୍\ ଇଁରାଜୀ",
    'en_gb' => "ବ୍ରିଟିଶ୍\ ଇଁରାଜୀ",
    'en_us' => "ୟୁ\.ଏସ୍\.\ ଇଁରାଜୀ",
    'enm'   => "ମଧ୍ୟ\ ଇଁରାଜୀ",
    'eo'    => 'ଏସ୍ପାରେଣ୍ଟୋ',
    'es'    => 'ସ୍ପାନିସ୍',
    'es_es' => "ଲେବେରିଆନ୍\ ସ୍ପାନିଶ୍",
    'et'    => 'ଏସ୍ତୋନିଆନ୍',
    'eu'    => 'ବାସ୍କ୍ୱି',
    'ewo'   => 'ଇୱୋଣ୍ଡୋ',
    'fa'    => 'ପର୍ସିଆନ୍',
    'fan'   => 'ଫାଙ୍ଗ',
    'fat'   => 'ଫାଣ୍ଟି',
    'ff'    => 'ଫୁଲାହ',
    'fi'    => 'ଫିନ୍ନିସ୍',
    'fil'   => 'ଫିଲିପିନୋ',
    'fiu'   => "ଫାଣ୍ଟିଫିନ୍ନୋ\-ଉଗ୍ରୀଆନ୍\ ଭାଷା",
    'fj'    => 'ଫିଜି',
    'fo'    => 'ଫାରୋଏସେ',
    'fon'   => 'ଫନ୍',
    'fr'    => 'ଫ୍ରେଞ୍ଚ',
    'fr_ca' => "କାନାଡିଆନ୍\ ଫ୍ରେଞ୍ଚ",
    'fr_ch' => "ସ୍ବିସ୍\ ଫ୍ରେଞ୍ଚ୍",
    'frm'   => "ମଧ୍ୟ\ ଫ୍ରେଞ୍ଚ",
    'fro'   => "ପୁରୁଣା\ ଫ୍ରେଞ୍ଚ",
    'frr'   => "ଉତ୍ତର\ ଫ୍ରିସିୟାନ୍",
    'frs'   => "ପୂର୍ବ\ ଫ୍ରିସିୟାନ୍",
    'fur'   => 'ଫ୍ରିୟୁଲୀୟାନ୍',
    'fy'    => "ପଶ୍ଚିମ\ ଫ୍ରିସିୟନ୍",
    'ga'    => 'ଇରିସ୍',
    'gaa'   => 'ଗା',
    'gay'   => 'ଗାୟୋ',
    'gba'   => 'ଗବାୟା',
    'gd'    => "ସ୍କଟିସ୍\ ଗାଏଲିକ୍",
    'gem'   => "ଜର୍ମାନିକ୍\ ଭାଷା",
    'gez'   => 'ଗୀଜ୍',
    'gil'   => 'ଜିବ୍ରାଟୀଜ୍',
    'gl'    => 'ଗାଲସିଆନ୍',
    'gmh'   => "ମିଡିଲ୍\ ହାଇ\ ଜର୍ମାନ୍",
    'gn'    => 'ଗୁଆରାନୀ',
    'goh'   => "ପୁରୁଣା\ ହାଇ\ ଜର୍ମାନ୍",
    'gon'   => 'ଗୋଣ୍ଡି',
    'gor'   => 'ଗୋରୋଣ୍ଟାଲୋ',
    'got'   => 'ଗୋଥିକ୍',
    'grb'   => 'ଗ୍ରେବୋ',
    'grc'   => "ପ୍ରାଚୀନ୍\ ୟୁନାନୀ",
    'gsw'   => "ସ୍ବିସ୍\ ଜର୍ମାନ୍",
    'gu'    => 'ଗୁଜୁରାଟୀ',
    'gv'    => 'ମାଁକ୍ସ',
    'gwi'   => "ସ୍ବିଚ୍\ ଇନ୍",
    'ha'    => 'ହୌସା',
    'hai'   => 'ହାଇଡା',
    'haw'   => 'ହାୱାଇନ୍',
    'he'    => 'ହେବ୍ର୍ୟୁ',
    'hi'    => 'ହିନ୍ଦୀ',
    'hil'   => 'ହିଲିଗୈନନ୍',
    'him'   => 'ହିମାଚଳୀ',
    'hit'   => 'ହିତୀତେ',
    'hmn'   => 'ହଁଙ୍ଗ',
    'ho'    => "ହିରି\ ମୋଟୁ",
    'hr'    => 'କ୍ରୋଆଟିଆନ୍',
    'hsb'   => "ଉପର\ ସର୍ବିଆନ୍",
    'ht'    => 'ହୈତାୟିନ୍',
    'hu'    => 'ହଙ୍ଗେରିଆନ୍',
    'hup'   => 'ହୁପା',
    'hy'    => 'ଆର୍ମେନିଆନ୍',
    'hz'    => 'ହେରେରୋ',
    'ia'    => 'ଇର୍ଣ୍ଟଲିଙ୍ଗୁଆ',
    'iba'   => 'ଇବାନ୍',
    'id'    => 'ଇଣ୍ଡୋନେସିଆନ୍',
    'ie'    => 'ଇର୍ଣ୍ଟରଲିଙ୍ଗୁଇ',
    'ig'    => 'ଇଗ୍ବୋ',
    'ii'    => "ସିଚୁଆନ୍\ ୟୀ",
    'ijo'   => 'ଇଜୋ',
    'ik'    => 'ଇନୁପିୟାକ୍',
    'ilo'   => 'ଇଲୋକୋ',
    'inc'   => "ଇଣ୍ଡିକ୍\ ଭାଷା",
    'ine'   => "ଇଣ୍ଡୋ\-ୟୁରୋପୀୟ\ ଭାଷା",
    'inh'   => 'ଇଁଙ୍ଗୁଶ୍',
    'io'    => 'ଇଡୋ',
    'ira'   => "ଇରାନୀ\ ଭାଷା",
    'iro'   => "ଇରୋକ୍ୱୋୟାନ୍\ ଭାଷା",
    'is'    => 'ଆଇସଲାଣ୍ଡିକ୍',
    'it'    => 'ଇଟାଲିଆନ୍',
    'iu'    => 'ଇନକୀଟୁତ୍',
    'ja'    => 'ଜାପାନୀଜ୍',
    'jbo'   => 'ଲୋଜବାନ୍',
    'jpr'   => "ଜୁଡେଓ\-ପର୍ସିଆନ୍",
    'jrb'   => "ଜୁଡେଓ\-ଆରବୀକ୍",
    'jv'    => 'ଜାଭାନୀଜ୍',
    'ka'    => 'ଜର୍ଜିଆନ୍',
    'kaa'   => "କାରା\-କଲ୍ପକ୍",
    'kab'   => 'କବାଇଲ୍',
    'kac'   => 'କଚିନ୍',
    'kaj'   => 'ଜ୍ଜୁ',
    'kam'   => 'କମ୍ବା',
    'kar'   => 'କାରେନ୍',
    'kaw'   => 'କାୱି',
    'kbd'   => 'କାବାର୍ଡିଆନ୍',
    'kcg'   => 'ତ୍ୟାପ୍',
    'kfo'   => 'କୋରୋ',
    'kg'    => 'କଙ୍ଗୋ',
    'kha'   => 'ଖାସୀ',
    'khi'   => "ଖୋସୀୟାନ୍\ ଭାଷା",
    'kho'   => 'ଖୋତାନୀଜ୍',
    'ki'    => 'କୀକୁୟୁ',
    'kj'    => 'କ୍ୱାନ୍ୟାମ୍',
    'kk'    => 'କାଜାକ୍',
    'kl'    => 'ଗ୍ରୀନଲାଣ୍ଡିକ୍',
    'km'    => 'ଖ୍ମେର୍',
    'kmb'   => 'କିମ୍ବୁଣ୍ଡୁ',
    'kn'    => 'କନ୍ନଡ',
    'ko'    => 'କୋରିଆନ୍',
    'kok'   => 'କୋନକାନୀ',
    'kos'   => 'କୋସରୈନ୍',
    'kpe'   => 'କୈପେଲେ',
    'kr'    => 'କନୁରୀ',
    'krc'   => "କରାଚୟ\-ବଲ୍କାର",
    'krl'   => 'କାରେଲିୟାନ୍',
    'kro'   => 'କ୍ରୁ',
    'kru'   => 'କୁରୁଖ',
    'ks'    => 'କାଶ୍ମିରୀ',
    'ku'    => 'କୁର୍ଦ୍ଦିଶ୍',
    'kum'   => 'କୁମୀକ୍',
    'kut'   => 'କୁତେନାଉ',
    'kv'    => 'କୋମି',
    'kw'    => 'କୋର୍ନିସ୍',
    'ky'    => 'କିରଗିଜ୍',
    'la'    => 'ଲାଟିନ୍',
    'lad'   => 'ଲାଦିନୋ',
    'lah'   => 'ଲାହାଣ୍ଡା',
    'lam'   => 'ଲାମ୍ବା',
    'lb'    => 'ଲକ୍ସେମବର୍ଗିସ୍',
    'lez'   => 'ଲେଜଗିୟାନ୍',
    'lg'    => 'ଗନ୍ଦା',
    'li'    => 'ଲିମ୍ବୁର୍ଗିସ୍',
    'ln'    => 'ଲିଙ୍ଗାଲା',
    'lo'    => 'ଲାଓ',
    'lol'   => 'ମଙ୍ଗୋ',
    'loz'   => 'ଲୋଜି',
    'lt'    => 'ଲିଥୁଆନିଆନ୍',
    'lu'    => "ଲ୍ୟୁବା\-କାଟାଙ୍ଗା",
    'lua'   => "ଲୁବା\-ଲୁଲୁଆ",
    'lui'   => 'ଲୁଇସେନୋ',
    'lun'   => 'ଲୁଣ୍ଡା',
    'luo'   => 'ଲୁଓ',
    'lus'   => 'ଲୁସାଉ',
    'lv'    => 'ଲାଟଭିଆନ୍',
    'mad'   => 'ମାଦୁରୀସ୍',
    'mag'   => 'ମାଗାହୀ',
    'mai'   => 'ମୈଥିଳୀ',
    'mak'   => 'ମକାସର୍',
    'man'   => 'ମାଣ୍ଡିଙ୍ଗୋ',
    'map'   => 'ଅଷ୍ଟ୍ରୋନେସିଆନ୍',
    'mas'   => 'ମାସାଇ',
    'mdf'   => 'ମୋକ୍ଷ',
    'mdr'   => 'ମନ୍ଦାର',
    'men'   => 'ମେଣ୍ଡେ',
    'mfe'   => 'Morisyen',
    'mg'    => 'ମାଲାଗାସୀ',
    'mga'   => "ମଧ୍ୟ\ ଇରିଶ୍",
    'mh'    => 'ମାର୍ଶାଲୀଜ୍',
    'mi'    => 'ମାଓରୀ',
    'mic'   => 'ମିକମୌକ୍',
    'min'   => 'ମିନାଙ୍ଗାବାଉ',
    'mis'   => "ବିବିଧ\ ଭାଷା",
    'mk'    => 'ମାକଡୋନିଆନ୍',
    'mkh'   => "ମଁନ୍\-ଖ୍ମେର୍\ ଭାଷା",
    'ml'    => 'ମାଲାୟଲମ୍',
    'mn'    => 'ମଙ୍ଗୋଲିଆନ୍',
    'mnc'   => 'ମାଞ୍ଚୁ',
    'mni'   => 'ମଣିପୁରୀ',
    'mno'   => "ମନୋବୋ\ ଭାଷା",
    'mo'    => 'ମୋଲଡୋଭିଆନ୍',
    'moh'   => 'ମୋହୌକ',
    'mos'   => 'ମୋସି',
    'mr'    => 'ମରାଠୀ',
    'ms'    => 'ମାଲୟ',
    'mt'    => 'ମାଲଟୀଜ୍',
    'mul'   => "ବିବିଧ\ ଭାଷାମାନ",
    'mun'   => "ମୁଣ୍ଡା\ ଭାଷା",
    'mus'   => 'କ୍ରୀକ୍',
    'mwl'   => 'ମିରାଣ୍ଡିଜ୍',
    'mwr'   => 'ମାରୱାରୀ',
    'my'    => 'ବର୍ମୀଜ୍',
    'myn'   => "ମାୟା\ ଭାଷା",
    'myv'   => 'ଏର୍ଜୟା',
    'na'    => 'ନାଉରୁ',
    'nah'   => 'ନାଉହାତି',
    'nai'   => "ଉତ୍ତର\ ଆମେରିକା\ ଇଣ୍ଡିଆନ୍\ ଭାଷା",
    'nap'   => 'ନୀପୋଲିଟାନ୍',
    'nb'    => "ନରୱେଜିଆନ୍\ ବୋକମଲ୍",
    'nd'    => "ଉତ୍ତର\ ନେଡବେଲେ",
    'nds'   => "ଲୋ\ ଜର୍ମାନ୍",
    'ne'    => 'ନେପାଳୀ',
    'new'   => 'ନେୱାରୀ',
    'ng'    => 'ଡୋଙ୍ଗା',
    'nia'   => 'ନୀୟାସ୍',
    'nic'   => "ନାଇଜର୍\-କୋର୍ଡୋଫୌନିୟାନ୍\ ଭାଷା",
    'niu'   => 'ନିୟୁଆନ୍',
    'nl'    => 'ଡଚ୍',
    'nl_be' => 'ଫ୍ଲେମିଶ୍',
    'nn'    => "ନରୱେଜିଆନ୍\ ନିୟୋର୍ସ୍କ",
    'no'    => 'ନରୱେଜିଆନ୍',
    'nog'   => 'ନୋଗାଇ',
    'non'   => "ପୁରୁଣା\ ନର୍ସ",
    'nqo'   => 'ଏନ୍କୋ',
    'nr'    => "ଦକ୍ଷିଣ\ ନେଡବେଲେ",
    'nso'   => "ଉତ୍ତରୀ\ ସୋଥୋ",
    'nub'   => "ନ୍ୟୁବିଆନ୍\ ଭାଷା",
    'nv'    => 'ନାଭାଜୋ',
    'nwc'   => "ପାରମ୍ପରିକ\ ନେୱାରୀ",
    'ny'    => 'ନିୟାଞ୍ଜ',
    'nym'   => 'ନ୍ୟାମୱେଜୀ',
    'nyn'   => 'ନ୍ୟାନକୋଲ୍',
    'nyo'   => 'ନ୍ୟାରୋ',
    'nzi'   => 'ଞ୍ଜିମା',
    'oc'    => 'ଓସିଟାନ୍',
    'oj'    => 'ଓଜିୱା',
    'om'    => 'ଓରୋମୋ',
    'or'    => 'ଓଡ଼ିଆ',
    'os'    => 'ଓସେଟିକ୍',
    'osa'   => 'ୱୌସେଜ୍',
    'ota'   => "ଓଟ୍ଟୋମନ୍\ ତୁର୍କିସ୍",
    'oto'   => "ଓଟ୍ଟୋମିଆନ୍\ ଭାଷା",
    'pa'    => 'ପଞ୍ଜାବୀ',
    'paa'   => "ପାପୁଆନ୍\ ଭାଷା",
    'pag'   => 'ପାଙ୍ଗାସିନିଆନ୍',
    'pal'   => 'ପାହ୍ଲାଭି',
    'pam'   => 'ପାମ୍ପାଙ୍ଗା',
    'pap'   => 'ପାପିୟାମିଣ୍ଟୋ',
    'pau'   => 'ପାଲାଉଆନ୍',
    'peo'   => "ପୁରୁଣା\ ପର୍ସିଆନ୍",
    'phi'   => "ଫିଲିପାଇନ୍\ ଭାଷା",
    'phn'   => 'ଫୋନେସିଆନ୍',
    'pi'    => 'ପାଲି',
    'pl'    => 'ପୋଲିଶ୍',
    'pon'   => 'ପୋହପିଏନ୍',
    'pra'   => "ପ୍ରାକୃତ\ ଭାଷା",
    'pro'   => "ପୁରୁଣା\ ପ୍ରେଭେନେସିଆଲ୍",
    'ps'    => 'ପାସ୍ତୋ',
    'pt'    => 'ପର୍ତ୍ତୁଗ୍ରୀଜ୍',
    'pt_br' => "ବ୍ରାଜିଲିଆନ୍\ ପର୍ତ୍ତୁଗୀଜ୍",
    'pt_pt' => "ଲେବେରିଆନ୍\ ପର୍ତ୍ତୁଗୀଜ୍",
    'qu'    => 'କ୍ୱେଚୁଆ',
    'raj'   => 'ରାଜସ୍ଥାନୀ',
    'rap'   => 'ରାପାନୁଇ',
    'rar'   => 'ରାରୋତୋଙ୍ଗନ୍',
    'rm'    => "ରେହେଟୋ\-ରୋମାନ୍ସ",
    'rn'    => 'ରୁଣ୍ଡି',
    'ro'    => 'ରୋମାନିଆନ୍',
    'roa'   => "ରୋମାନ୍ସ\ ଭାଷା",
    'rom'   => 'ରୋମାନି',
    'ru'    => 'ରଷିଆନ୍',
    'rup'   => 'ଆରୋମାନିଆନ୍',
    'rw'    => 'କିନ୍ୟାରୱାଣ୍ଡା',
    'sa'    => 'ସଂସ୍କୃତ',
    'sad'   => 'ସଣ୍ଡାୱେ',
    'sah'   => 'ୟାକୁଟ୍',
    'sai'   => "ଦକ୍ଷିଣ\ ଆମେରିକା\ ଇଣ୍ଡିଆନ୍\ ଭାଷା",
    'sal'   => "ଶଲୀସନ୍\ ଭାଷା",
    'sam'   => "ସାମୌରିଟନ୍\ ଆରମାଇକ୍",
    'sas'   => 'ସାସାକ୍',
    'sat'   => 'ସାନ୍ତାଳି',
    'sc'    => 'ସର୍ଦିନିଆନ୍',
    'scn'   => 'ସିଶିଲିଆନ୍',
    'sco'   => 'ସ୍କଟସ୍',
    'sd'    => 'ସିନ୍ଧୀ',
    'se'    => "ଉତ୍ତର\ ସାମି",
    'sel'   => 'ସେଲ୍କପ୍',
    'sem'   => "ସେମିଟିକ୍\ ଭାଷା",
    'sg'    => 'ସାଙ୍ଗୋ',
    'sga'   => "ପୁରୁଣା\ ଇରିଶ୍",
    'sgn'   => "ସାଙ୍କେତିକ\ ଭାଷା",
    'sh'    => "ସର୍ବୋ\-କ୍ରୋଆଟିଆନ୍",
    'shn'   => 'ଶାନ୍',
    'si'    => 'ସିଂହଳ',
    'sid'   => 'ସିଦାମୋ',
    'sio'   => "ସିଓନ୍\ ଭାଷା",
    'sit'   => "ସିନୋ\-ତିବ୍ବେତାନ୍\ ଭାଷା",
    'sk'    => 'ସ୍ଲୋଭାକ୍',
    'sl'    => 'ସ୍ଲୋଭେନିଆନ୍',
    'sla'   => "ସାଲ୍ଭିକ୍\ ଭାଷା",
    'sm'    => 'ସାମୋଆନ୍',
    'sma'   => "ଦକ୍ଷିଣ\ ସାମି",
    'smi'   => "ସାମି\ ଭାଷା",
    'smj'   => "ଲୁଲେ\ ସାମି",
    'smn'   => "ଇନାରୀ\ ସାମି",
    'sms'   => "ସ୍କୋଲ୍ଟ\ ସାମୀ",
    'sn'    => 'ଶୋନା',
    'snk'   => 'ସୋନିଙ୍କେ',
    'so'    => 'ସୋମାଲିଆ',
    'sog'   => 'ସୋଗଡିଏନ୍',
    'son'   => 'ସୋଙ୍ଘାଇ',
    'sq'    => 'ଆଲବାନିଆନ୍',
    'sr'    => 'ସର୍ବିଆନ୍',
    'srn'   => "ଶାରାନା\ ଟୋଙ୍ଗୋ",
    'srr'   => 'ଶେରେର୍',
    'ss'    => 'ସ୍ବାତୀ',
    'ssa'   => "ନୀଲ୍\ ସାହାରି\ ଭାଷା",
    'st'    => 'ସେସୋଥୋ',
    'su'    => 'ସୁଦାନୀଜ୍',
    'suk'   => 'ସୁକୁମା',
    'sus'   => 'ଶୁଶୁ',
    'sux'   => 'ସୁମେରିଆନ୍',
    'sv'    => 'ସ୍ୱେଡିସ୍',
    'sw'    => 'ସ୍ୱାହିଲ୍',
    'syc'   => "କ୍ଲାସିକାଲ୍\ ସିରିକ୍",
    'syr'   => 'ସିରିକ୍',
    'ta'    => 'ତାମିଲ୍',
    'tai'   => "ତାଇ\ ଭାଷା",
    'te'    => 'ତେଲୁଗୁ',
    'tem'   => 'ତିମନେ',
    'ter'   => 'ତେରେନୋ',
    'tet'   => 'ତେତୁମ୍',
    'tg'    => 'ତାଜିକ୍',
    'th'    => 'ଥାଇ',
    'ti'    => 'ଟ୍ରିଗିନିଆ',
    'tig'   => 'ଟାଇଗ୍ରେ',
    'tiv'   => 'ତୀଭ୍',
    'tk'    => 'ତୁର୍କମେନ୍',
    'tkl'   => 'ଟୋକେଲାଉ',
    'tl'    => 'ଟାଗାଲଗ୍',
    'tlh'   => 'କ୍ଲିଙ୍ଗନ୍',
    'tli'   => 'ତ୍ଲିଙ୍ଗିଟ୍',
    'tmh'   => 'ତାମାଶେକ୍',
    'tn'    => 'ସେସ୍ବାନା',
    'to'    => 'ଟୋଙ୍ଗା',
    'tog'   => "ନ୍ୟାସା\ ଟୋଙ୍ଗୋ",
    'tpi'   => "ଟୋକ୍\ ପିସିନ୍",
    'tr'    => 'ତୁର୍କିସ୍',
    'trv'   => 'Taroko',
    'ts'    => 'ସୋଂଗା',
    'tsi'   => 'ତିସିମିସିଆନ୍',
    'tt'    => 'ତାତାର୍',
    'tum'   => 'ଟୁମ୍ବୁକା',
    'tup'   => "ଟୁପି\ ଭାଷା",
    'tut'   => "ଆଲ୍ଟିକ୍\ ଭାଷା",
    'tvl'   => 'ତୁଭାଲୁ',
    'tw'    => 'ତ୍ୱି',
    'ty'    => 'ତାହିତିଆନ୍',
    'tyv'   => 'ତୁଭିନିଆନ୍',
    'udm'   => 'ଉଦମୂର୍ତ୍ତ',
    'ug'    => 'ୟୁଘୁର୍',
    'uga'   => 'ୟୁଗୋରଟିକ୍',
    'uk'    => 'ୟୁକ୍ରାନିଆନ୍',
    'umb'   => 'ଉମ୍ବୁଣ୍ଡୁ',
    'und'   => "ଅଜଣା\ ଏବଂ\ ଅବୈଧ\ ଭାଷା",
    'ur'    => 'ଉର୍ଦ୍ଦୁ',
    'uz'    => 'ଉଜବେକ୍',
    'vai'   => 'ଭାଇ',
    've'    => 'ଭେଣ୍ଡା',
    'vi'    => 'ଭିଏତନାମିଜ୍',
    'vo'    => 'ବୋଲାପୁକ',
    'vot'   => 'ଭୋଟିକ୍',
    'wa'    => 'ୱାଲୁନ୍',
    'wak'   => "ୱାକଶନ୍\ ଭାଷା",
    'wal'   => 'ୱାଲମୋ',
    'war'   => 'ୱାରୈ',
    'was'   => 'ୱାସୋ',
    'wen'   => "ସର୍ବିଆନ୍\ ଭାଷା",
    'wo'    => 'ୱୋଲଫ୍',
    'xal'   => 'କାଲ୍ମୀକ୍',
    'xh'    => 'ଖୋସା',
    'yao'   => 'ୟାଓ',
    'yap'   => 'ୟାପୀସ୍',
    'yi'    => 'ୟିଡିସ୍',
    'yo'    => 'ୟୋରୁବା',
    'ypk'   => "ୟୁପିକ୍\ ଭାଷା",
    'za'    => 'ଜୁଆଙ୍ଗ',
    'zap'   => 'ଜାପୋଟେକ୍',
    'zbl'   => 'ବ୍ଲିସିମ୍ବଲସ୍',
    'zen'   => 'ଜେନାଗା',
    'zh'    => 'ଚାଇନୀଜ୍',
    'znd'   => 'ଜାଣ୍ଡେ',
    'zu'    => 'ଜୁଲୁ',
    'zun'   => 'ଜୁନୀ',
    'zxx'   => "କୌଣସି\ ଲିଙ୍ଗୁଇଷ୍ଟ\ ସାମଗ୍ରୀ\ ନାହିଁ",
    'zza'   => 'ଜାଜା',
);

%Locales::DB::Language::or::name_to_code = (
    'morisyen'                                                                                                           => 'mfe',
    'taroko'                                                                                                             => 'trv',
    'ଅଁଗୀକା'                                                                                                 => 'anp',
    'ଅକନ୍'                                                                                                       => 'ak',
    'ଅଜଣାଏବଂଅବୈଧଭାଷା'                                                                      => 'und',
    'ଅଦ୍ୟଘେ'                                                                                                 => 'ady',
    'ଅଫାର୍'                                                                                                    => 'aa',
    'ଅବେସ୍ତନ'                                                                                              => 'ae',
    'ଅଷ୍ଟ୍ରିଆନ୍ଜର୍ମାନ'                                                                   => 'de_at',
    'ଅଷ୍ଟ୍ରେଲିଆନ୍ଇଁରାଜୀ'                                                             => 'en_au',
    'ଅଷ୍ଟ୍ରେଲିଆନ୍ଭାଷା'                                                                   => 'aus',
    'ଅଷ୍ଟ୍ରୋନେସିଆନ୍'                                                                         => 'map',
    'ଆଇନୁ'                                                                                                       => 'ain',
    'ଆଇସଲାଣ୍ଡିକ୍'                                                                                  => 'is',
    'ଆକାଡିଆନ୍'                                                                                           => 'akk',
    'ଆକୋଲି'                                                                                                    => 'ach',
    'ଆଚାଇନୀଜ୍'                                                                                           => 'ace',
    'ଆଜେରବାଇଜାନି'                                                                                  => 'az',
    'ଆତ୍ସମ୍'                                                                                                 => 'cch',
    'ଆଥପାସ୍କାନ୍ଭାଷା'                                                                         => 'ath',
    'ଆଦାଙ୍ଗେମ୍'                                                                                        => 'ada',
    'ଆପାଚୀଭାଷା'                                                                                        => 'apa',
    'ଆଫ୍ରିକାନସ୍'                                                                                     => 'af',
    'ଆଫ୍ରିହିଲି'                                                                                        => 'afh',
    'ଆଫ୍ରୋଏସିଆଟିକ୍ଭାଷା'                                                                => 'afa',
    'ଆବ୍ଖାଜିଆନ୍'                                                                                     => 'ab',
    'ଆଭାରିକ୍'                                                                                              => 'av',
    'ଆମହାରକି'                                                                                              => 'am',
    'ଆରବିକ୍'                                                                                                 => 'ar',
    'ଆରାଉକାନିଆନ୍'                                                                                  => 'arn',
    'ଆରାପାହୋ'                                                                                              => 'arp',
    'ଆରାମାଇକ୍'                                                                                           => 'arc',
    'ଆରୋମାନିଆନ୍'                                                                                     => 'rup',
    'ଆର୍ଗୋନୀ'                                                                                              => 'an',
    'ଆର୍ମେନିଆନ୍'                                                                                     => 'hy',
    'ଆରୱକ'                                                                                                       => 'arw',
    'ଆଲବାନିଆନ୍'                                                                                        => 'sq',
    'ଆଲେଇଟୁ'                                                                                                 => 'ale',
    'ଆଲ୍ଟିକ୍ଭାଷା'                                                                                  => 'tut',
    'ଆଷ୍ଟୁରିଆନ୍'                                                                                     => 'ast',
    'ଆସାମୀ'                                                                                                    => 'as',
    'ଆୟମାରା'                                                                                                 => 'ay',
    'ଆୱାଧି'                                                                                                    => 'awa',
    'ଇଁଙ୍ଗୁଶ୍'                                                                                           => 'inh',
    'ଇଁରାଜୀଆଧାରିତକ୍ରେଓଲ୍କିମ୍ବାପିଜିନ୍'                      => 'cpe',
    'ଇଂରାଜୀ'                                                                                                 => 'en',
    'ଇଗ୍ବୋ'                                                                                                    => 'ig',
    'ଇଜୋ'                                                                                                          => 'ijo',
    'ଇଟାଲିଆନ୍'                                                                                           => 'it',
    'ଇଡୋ'                                                                                                          => 'io',
    'ଇଣ୍ଡିକ୍ଭାଷା'                                                                                  => 'inc',
    'ଇଣ୍ଡୋନେସିଆନ୍'                                                                               => 'id',
    'ଇଣ୍ଡୋୟୁରୋପୀୟଭାଷା'                                                                   => 'ine',
    'ଇନକୀଟୁତ୍'                                                                                           => 'iu',
    'ଇନାରୀସାମି'                                                                                        => 'smn',
    'ଇନୁପିୟାକ୍'                                                                                        => 'ik',
    'ଇବାନ୍'                                                                                                    => 'iba',
    'ଇରାନୀଭାଷା'                                                                                        => 'ira',
    'ଇରିସ୍'                                                                                                    => 'ga',
    'ଇରୋକ୍ୱୋୟାନ୍ଭାଷା'                                                                      => 'iro',
    'ଇର୍ଣ୍ଟରଲିଙ୍ଗୁଇ'                                                                         => 'ie',
    'ଇର୍ଣ୍ଟଲିଙ୍ଗୁଆ'                                                                            => 'ia',
    'ଇଲୋକୋ'                                                                                                    => 'ilo',
    'ଇୱେ'                                                                                                          => 'ee',
    'ଇୱୋଣ୍ଡୋ'                                                                                              => 'ewo',
    'ଉଜବେକ୍'                                                                                                 => 'uz',
    'ଉତ୍ତରଆମେରିକାଇଣ୍ଡିଆନ୍ଭାଷା'                                           => 'nai',
    'ଉତ୍ତରନେଡବେଲେ'                                                                               => 'nd',
    'ଉତ୍ତରଫ୍ରିସିୟାନ୍'                                                                      => 'frr',
    'ଉତ୍ତରସାମି'                                                                                        => 'se',
    'ଉତ୍ତରୀସୋଥୋ'                                                                                     => 'nso',
    'ଉଦମୂର୍ତ୍ତ'                                                                                        => 'udm',
    'ଉପରସର୍ବିଆନ୍'                                                                                  => 'hsb',
    'ଉମ୍ବୁଣ୍ଡୁ'                                                                                        => 'umb',
    'ଉର୍ଦ୍ଦୁ'                                                                                              => 'ur',
    'ଏକାଜୁକ୍'                                                                                              => 'eka',
    'ଏନ୍କୋ'                                                                                                    => 'nqo',
    'ଏଫିକ୍'                                                                                                    => 'efi',
    'ଏର୍ଜୟା'                                                                                                 => 'myv',
    'ଏଲାମାଇଟ୍'                                                                                           => 'elx',
    'ଏଲ୍ଗୋନକ୍ବିନାଭାଷା'                                                                   => 'alg',
    'ଏସ୍ତୋନିଆନ୍'                                                                                     => 'et',
    'ଏସ୍ପାରେଣ୍ଟୋ'                                                                                  => 'eo',
    'ଓଜିୱା'                                                                                                    => 'oj',
    'ଓଟ୍ଟୋମନ୍ତୁର୍କିସ୍'                                                                   => 'ota',
    'ଓଟ୍ଟୋମିଆନ୍ଭାଷା'                                                                         => 'oto',
    'ଓଡ଼ିଆ'                                                                                                    => 'or',
    'ଓରୋମୋ'                                                                                                    => 'om',
    'ଓସିଟାନ୍'                                                                                              => 'oc',
    'ଓସେଟିକ୍'                                                                                              => 'os',
    'କଙ୍ଗୋ'                                                                                                    => 'kg',
    'କଚିନ୍'                                                                                                    => 'kac',
    'କନୁରୀ'                                                                                                    => 'kr',
    'କନ୍ନଡ'                                                                                                    => 'kn',
    'କପ୍ଟିକ୍'                                                                                              => 'cop',
    'କବାଇଲ୍'                                                                                                 => 'kab',
    'କମ୍ବା'                                                                                                    => 'kam',
    'କରାଚୟବଲ୍କାର'                                                                                  => 'krc',
    'କାକୋଶୀଭାଷା'                                                                                     => 'cau',
    'କାଜାକ୍'                                                                                                 => 'kk',
    'କାଟଲାନ୍'                                                                                              => 'bs',
    'କାଟାଲାନ୍'                                                                                           => 'ca',
    'କାଡୋ'                                                                                                       => 'cad',
    'କାନାଡିଆନ୍ଇଁରାଜୀ'                                                                      => 'en_ca',
    'କାନାଡିଆନ୍ଫ୍ରେଞ୍ଚ'                                                                   => 'fr_ca',
    'କାବାର୍ଡିଆନ୍'                                                                                  => 'kbd',
    'କାରାକଲ୍ପକ୍'                                                                                     => 'kaa',
    'କାରିବ୍'                                                                                                 => 'car',
    'କାରେନ୍'                                                                                                 => 'kar',
    'କାରେଲିୟାନ୍'                                                                                     => 'krl',
    'କାଲ୍ମୀକ୍'                                                                                           => 'xal',
    'କାଶୁବିଆନ୍'                                                                                        => 'csb',
    'କାଶ୍ମିରୀ'                                                                                           => 'ks',
    'କାୱି'                                                                                                       => 'kaw',
    'କିନ୍ୟାରୱାଣ୍ଡା'                                                                            => 'rw',
    'କିମ୍ବୁଣ୍ଡୁ'                                                                                     => 'kmb',
    'କିରଗିଜ୍'                                                                                              => 'ky',
    'କୀକୁୟୁ'                                                                                                 => 'ki',
    'କୁତେନାଉ'                                                                                              => 'kut',
    'କୁମୀକ୍'                                                                                                 => 'kum',
    'କୁରୁଖ'                                                                                                    => 'kru',
    'କୁର୍ଦ୍ଦିଶ୍'                                                                                     => 'ku',
    'କୁଶିତିକ୍ଭାଷା'                                                                               => 'cus',
    'କୃତ୍ରିମଭାଷା'                                                                                  => 'art',
    'କେଲ୍ଟଭାଷା'                                                                                        => 'cel',
    'କୈପେଲେ'                                                                                                 => 'kpe',
    'କୋନକାନୀ'                                                                                              => 'kok',
    'କୋମି'                                                                                                       => 'kv',
    'କୋରିଆନ୍'                                                                                              => 'ko',
    'କୋରୋ'                                                                                                       => 'kfo',
    'କୋର୍ନିସ୍'                                                                                           => 'kw',
    'କୋର୍ସିକାନ୍'                                                                                     => 'co',
    'କୋସରୈନ୍'                                                                                              => 'kos',
    'କୌଣସିଲିଙ୍ଗୁଇଷ୍ଟସାମଗ୍ରୀନାହିଁ'                                  => 'zxx',
    'କ୍ରୀ'                                                                                                       => 'cr',
    'କ୍ରୀକ୍'                                                                                                 => 'mus',
    'କ୍ରୀମିନ୍ତୁର୍କୀସ୍'                                                                   => 'crh',
    'କ୍ରୁ'                                                                                                       => 'kro',
    'କ୍ରେଓଲ୍କିମ୍ବାପିଜିନ୍'                                                          => 'crp',
    'କ୍ରୋଆଟିଆନ୍'                                                                                     => 'hr',
    'କ୍ଲାସିକାଲ୍ସିରିକ୍'                                                                   => 'syc',
    'କ୍ଲିଙ୍ଗନ୍'                                                                                        => 'tlh',
    'କ୍ୱାନ୍ୟାମ୍'                                                                                     => 'kj',
    'କ୍ୱେଚୁଆ'                                                                                              => 'qu',
    'ଖାସୀ'                                                                                                       => 'kha',
    'ଖୋତାନୀଜ୍'                                                                                           => 'kho',
    'ଖୋସା'                                                                                                       => 'xh',
    'ଖୋସୀୟାନ୍ଭାଷା'                                                                               => 'khi',
    'ଖ୍ମେର୍'                                                                                                 => 'km',
    'ଗନ୍ଦା'                                                                                                    => 'lg',
    'ଗବାୟା'                                                                                                    => 'gba',
    'ଗା'                                                                                                             => 'gaa',
    'ଗାଲସିଆନ୍'                                                                                           => 'gl',
    'ଗାୟୋ'                                                                                                       => 'gay',
    'ଗୀଜ୍'                                                                                                       => 'gez',
    'ଗୁଆରାନୀ'                                                                                              => 'gn',
    'ଗୁଜୁରାଟୀ'                                                                                           => 'gu',
    'ଗୋଣ୍ଡି'                                                                                                 => 'gon',
    'ଗୋଥିକ୍'                                                                                                 => 'got',
    'ଗୋରୋଣ୍ଟାଲୋ'                                                                                     => 'gor',
    'ଗ୍ରୀକ୍'                                                                                                 => 'el',
    'ଗ୍ରୀନଲାଣ୍ଡିକ୍'                                                                            => 'kl',
    'ଗ୍ରେବୋ'                                                                                                 => 'grb',
    'ଚର୍ଚ୍ଚସ୍ଲାଭିକ୍'                                                                         => 'cu',
    'ଚାଇନୀଜ୍'                                                                                              => 'zh',
    'ଚାମିକ୍ଭାଷା'                                                                                     => 'cmc',
    'ଚାମୋରୋ'                                                                                                 => 'ch',
    'ଚିନୁକ୍ଜାରଗାଁନ୍'                                                                         => 'chn',
    'ଚିପେୱାନ୍'                                                                                           => 'chp',
    'ଚିବ୍ଚା'                                                                                                 => 'chb',
    'ଚୁକୀସେ'                                                                                                 => 'chk',
    'ଚୁଭାଶ୍'                                                                                                 => 'cv',
    'ଚେକ୍'                                                                                                       => 'cs',
    'ଚେଚନ୍'                                                                                                    => 'ce',
    'ଚେଚେନା'                                                                                                 => 'chy',
    'ଚେରୋକୀ'                                                                                                 => 'chr',
    'ଚୋଟୱା'                                                                                                    => 'cho',
    'ଛଗତାଇ'                                                                                                    => 'chg',
    'ଜର୍ଜିଆନ୍'                                                                                           => 'ka',
    'ଜର୍ମାନିକ୍ଭାଷା'                                                                            => 'gem',
    'ଜର୍ମାନ୍'                                                                                              => 'de',
    'ଜାଜା'                                                                                                       => 'zza',
    'ଜାଣ୍ଡେ'                                                                                                 => 'znd',
    'ଜାପାନୀଜ୍'                                                                                           => 'ja',
    'ଜାପୋଟେକ୍'                                                                                           => 'zap',
    'ଜାଭାନୀଜ୍'                                                                                           => 'jv',
    'ଜିବ୍ରାଟୀଜ୍'                                                                                     => 'gil',
    'ଜୁଆଙ୍ଗ'                                                                                                 => 'za',
    'ଜୁଡେଓଆରବୀକ୍'                                                                                  => 'jrb',
    'ଜୁଡେଓପର୍ସିଆନ୍'                                                                            => 'jpr',
    'ଜୁନୀ'                                                                                                       => 'zun',
    'ଜୁଲୁ'                                                                                                       => 'zu',
    'ଜେନାଗା'                                                                                                 => 'zen',
    'ଜ୍ଜୁ'                                                                                                       => 'kaj',
    'ଞ୍ଜିମା'                                                                                                 => 'nzi',
    'ଟାଇଗ୍ରେ'                                                                                              => 'tig',
    'ଟାଗାଲଗ୍'                                                                                              => 'tl',
    'ଟୁପିଭାଷା'                                                                                           => 'tup',
    'ଟୁମ୍ବୁକା'                                                                                           => 'tum',
    'ଟୋକେଲାଉ'                                                                                              => 'tkl',
    'ଟୋକ୍ପିସିନ୍'                                                                                     => 'tpi',
    'ଟୋଙ୍ଗା'                                                                                                 => 'to',
    'ଟ୍ରିଗିନିଆ'                                                                                        => 'ti',
    'ଡଚ୍'                                                                                                          => 'nl',
    'ଡାକୋଟା'                                                                                                 => 'dak',
    'ଡାନ୍ନିସ୍'                                                                                           => 'da',
    'ଡାରାଗ୍ୱା'                                                                                           => 'dar',
    'ଡାୟକ୍'                                                                                                    => 'day',
    'ଡିଭେହୀ'                                                                                                 => 'dv',
    'ଡୁଆନା'                                                                                                    => 'dua',
    'ଡୁଆଲା'                                                                                                    => 'dyu',
    'ଡେଲାୱେର୍'                                                                                           => 'del',
    'ଡୋଗ୍ରିବ୍'                                                                                           => 'dgr',
    'ଡୋଗ୍ରୀ'                                                                                                 => 'doi',
    'ଡୋଙ୍ଗା'                                                                                                 => 'ng',
    'ତାଇଭାଷା'                                                                                              => 'tai',
    'ତାଜିକ୍'                                                                                                 => 'tg',
    'ତାତାର୍'                                                                                                 => 'tt',
    'ତାମାଶେକ୍'                                                                                           => 'tmh',
    'ତାମିଲ୍'                                                                                                 => 'ta',
    'ତାହିତିଆନ୍'                                                                                        => 'ty',
    'ତିବେତାନ୍'                                                                                           => 'bo',
    'ତିମନେ'                                                                                                    => 'tem',
    'ତିସିମିସିଆନ୍'                                                                                  => 'tsi',
    'ତୀଭ୍'                                                                                                       => 'tiv',
    'ତୁଭାଲୁ'                                                                                                 => 'tvl',
    'ତୁଭିନିଆନ୍'                                                                                        => 'tyv',
    'ତୁର୍କମେନ୍'                                                                                        => 'tk',
    'ତୁର୍କିସ୍'                                                                                           => 'tr',
    'ତେତୁମ୍'                                                                                                 => 'tet',
    'ତେରେନୋ'                                                                                                 => 'ter',
    'ତେଲୁଗୁ'                                                                                                 => 'te',
    'ତ୍ଲିଙ୍ଗିଟ୍'                                                                                     => 'tli',
    'ତ୍ୟାପ୍'                                                                                                 => 'kcg',
    'ତ୍ୱି'                                                                                                       => 'tw',
    'ଥାଇ'                                                                                                          => 'th',
    'ଦକ୍ଷିଣଆମେରିକାଇଣ୍ଡିଆନ୍ଭାଷା'                                        => 'sai',
    'ଦକ୍ଷିଣଆଲ୍ଟାଇ'                                                                               => 'alt',
    'ଦକ୍ଷିଣନେଡବେଲେ'                                                                            => 'nr',
    'ଦକ୍ଷିଣସାମି'                                                                                     => 'sma',
    'ଦିଙ୍କା'                                                                                                 => 'din',
    'ଦ୍ରାବିଡିଆନ୍ଭାଷା'                                                                      => 'dra',
    'ନରୱେଜିଆନ୍'                                                                                        => 'no',
    'ନରୱେଜିଆନ୍ନିୟୋର୍ସ୍କ'                                                             => 'nn',
    'ନରୱେଜିଆନ୍ବୋକମଲ୍'                                                                      => 'nb',
    'ନାଇଜର୍କୋର୍ଡୋଫୌନିୟାନ୍ଭାଷା'                                           => 'nic',
    'ନାଉରୁ'                                                                                                    => 'na',
    'ନାଉହାତି'                                                                                              => 'nah',
    'ନାଭାଜୋ'                                                                                                 => 'nv',
    'ନିଚଳାସର୍ବିଆନ୍'                                                                            => 'dsb',
    'ନିୟାଞ୍ଜ'                                                                                              => 'ny',
    'ନିୟୁଆନ୍'                                                                                              => 'niu',
    'ନୀପୋଲିଟାନ୍'                                                                                     => 'nap',
    'ନୀଲ୍ସାହାରିଭାଷା'                                                                         => 'ssa',
    'ନୀୟାସ୍'                                                                                                 => 'nia',
    'ନେପାଳୀ'                                                                                                 => 'ne',
    'ନେୱାରୀ'                                                                                                 => 'new',
    'ନୋଗାଇ'                                                                                                    => 'nog',
    'ନ୍ୟାନକୋଲ୍'                                                                                        => 'nyn',
    'ନ୍ୟାମୱେଜୀ'                                                                                        => 'nym',
    'ନ୍ୟାରୋ'                                                                                                 => 'nyo',
    'ନ୍ୟାସାଟୋଙ୍ଗୋ'                                                                               => 'tog',
    'ନ୍ୟୁବିଆନ୍ଭାଷା'                                                                            => 'nub',
    'ପଞ୍ଜାବୀ'                                                                                              => 'pa',
    'ପର୍ତ୍ତୁଗ୍ରୀଜ୍'                                                                            => 'pt',
    'ପର୍ତ୍ତୁଗ୍ରୀଜ୍ଆଧାରିତକ୍ରେଓଲ୍କିମ୍ବାପିଜିନ୍' => 'cpp',
    'ପର୍ସିଆନ୍'                                                                                           => 'fa',
    'ପଶ୍ଚିମଫ୍ରିସିୟନ୍'                                                                      => 'fy',
    'ପାଙ୍ଗାସିନିଆନ୍'                                                                            => 'pag',
    'ପାପିୟାମିଣ୍ଟୋ'                                                                               => 'pap',
    'ପାପୁଆନ୍ଭାଷା'                                                                                  => 'paa',
    'ପାମ୍ପାଙ୍ଗା'                                                                                     => 'pam',
    'ପାରମ୍ପରିକନେୱାରୀ'                                                                      => 'nwc',
    'ପାଲାଉଆନ୍'                                                                                           => 'pau',
    'ପାଲି'                                                                                                       => 'pi',
    'ପାସ୍ତୋ'                                                                                                 => 'ps',
    'ପାହ୍ଲାଭି'                                                                                           => 'pal',
    'ପୁରୁଣାଇଁରାଜୀ'                                                                               => 'ang',
    'ପୁରୁଣାଇରିଶ୍'                                                                                  => 'sga',
    'ପୁରୁଣାନର୍ସ'                                                                                     => 'non',
    'ପୁରୁଣାପର୍ସିଆନ୍'                                                                         => 'peo',
    'ପୁରୁଣାପ୍ରେଭେନେସିଆଲ୍'                                                          => 'pro',
    'ପୁରୁଣାଫ୍ରେଞ୍ଚ'                                                                            => 'fro',
    'ପୁରୁଣାହାଇଜର୍ମାନ୍'                                                                   => 'goh',
    'ପୂର୍ବଫ୍ରିସିୟାନ୍'                                                                      => 'frs',
    'ପୋଲିଶ୍'                                                                                                 => 'pl',
    'ପୋହପିଏନ୍'                                                                                           => 'pon',
    'ପ୍ରାକୃତଭାଷା'                                                                                  => 'pra',
    'ପ୍ରାଚୀନ୍ମିଶିରି'                                                                         => 'egy',
    'ପ୍ରାଚୀନ୍ୟୁନାନୀ'                                                                         => 'grc',
    'ଫନ୍'                                                                                                          => 'fon',
    'ଫାଙ୍ଗ'                                                                                                    => 'fan',
    'ଫାଣ୍ଟି'                                                                                                 => 'fat',
    'ଫାଣ୍ଟିଫିନ୍ନୋଉଗ୍ରୀଆନ୍ଭାଷା'                                           => 'fiu',
    'ଫାରୋଏସେ'                                                                                              => 'fo',
    'ଫିଜି'                                                                                                       => 'fj',
    'ଫିନ୍ନିସ୍'                                                                                           => 'fi',
    'ଫିଲିପାଇନ୍ଭାଷା'                                                                            => 'phi',
    'ଫିଲିପିନୋ'                                                                                           => 'fil',
    'ଫୁଲାହ'                                                                                                    => 'ff',
    'ଫୋନେସିଆନ୍'                                                                                        => 'phn',
    'ଫ୍ରିୟୁଲୀୟାନ୍'                                                                               => 'fur',
    'ଫ୍ରେଞ୍ଚ'                                                                                              => 'fr',
    'ଫ୍ରେଞ୍ଚଆଧାରିତକ୍ରେଓଲ୍କିମ୍ବାପିଜିନ୍'                   => 'cpf',
    'ଫ୍ଲେମିଶ୍'                                                                                           => 'nl_be',
    'ବଙ୍ଗାଳୀ'                                                                                              => 'bn',
    'ବମିଲେକେଭାଷା'                                                                                  => 'bai',
    'ବର୍ମୀଜ୍'                                                                                              => 'my',
    'ବଶଖିର୍'                                                                                                 => 'ba',
    'ବାଟାକ୍'                                                                                                 => 'btk',
    'ବାଣ୍ଟୁ'                                                                                                 => 'bnt',
    'ବାନ୍ଦା'                                                                                                 => 'bad',
    'ବାମ୍ବାରା'                                                                                           => 'bm',
    'ବାଲାଟିକ୍ଭାଷା'                                                                               => 'bat',
    'ବାଲିନୀଜ୍'                                                                                           => 'ban',
    'ବାଲୁଚି'                                                                                                 => 'bal',
    'ବାସା'                                                                                                       => 'bas',
    'ବାସ୍କ୍ୱି'                                                                                           => 'eu',
    'ବିକୋଲ୍'                                                                                                 => 'bik',
    'ବିକ୍ସିକା'                                                                                           => 'bla',
    'ବିନି'                                                                                                       => 'bin',
    'ବିବିଧଭାଷା'                                                                                        => 'mis',
    'ବିବିଧଭାଷାମାନ'                                                                               => 'mul',
    'ବିସଲାମା'                                                                                              => 'bi',
    'ବିହାରୀ'                                                                                                 => 'bh',
    'ବୁଗୀନୀଜ୍'                                                                                           => 'bug',
    'ବୁରିଆଟ୍'                                                                                              => 'bua',
    'ବୁଲଗେରିଆନ୍'                                                                                     => 'bg',
    'ବେଜା'                                                                                                       => 'bej',
    'ବେମ୍ବା'                                                                                                 => 'bem',
    'ବେରବର୍'                                                                                                 => 'ber',
    'ବେଲାରୁଷିଆନ୍'                                                                                  => 'be',
    'ବୋଲାପୁକ'                                                                                              => 'vo',
    'ବ୍ରାଜିଲିଆନ୍ପର୍ତ୍ତୁଗୀଜ୍'                                                 => 'pt_br',
    'ବ୍ରାଜ୍'                                                                                                 => 'bra',
    'ବ୍ରିଟିଶ୍ଇଁରାଜୀ'                                                                         => 'en_gb',
    'ବ୍ରେଟନ୍'                                                                                              => 'br',
    'ବ୍ଲିନ୍'                                                                                                 => 'byn',
    'ବ୍ଲିସିମ୍ବଲସ୍'                                                                               => 'zbl',
    'ଭାଇ'                                                                                                          => 'vai',
    'ଭିଏତନାମିଜ୍'                                                                                     => 'vi',
    'ଭୂଟାନୀ'                                                                                                 => 'dz',
    'ଭେଣ୍ଡା'                                                                                                 => 've',
    'ଭୋଜପୁରୀ'                                                                                              => 'bho',
    'ଭୋଟିକ୍'                                                                                                 => 'vot',
    'ମଁନ୍ଖ୍ମେର୍ଭାଷା'                                                                         => 'mkh',
    'ମକାସର୍'                                                                                                 => 'mak',
    'ମଙ୍ଗୋ'                                                                                                    => 'lol',
    'ମଙ୍ଗୋଲିଆନ୍'                                                                                     => 'mn',
    'ମଣିପୁରୀ'                                                                                              => 'mni',
    'ମଧ୍ୟଆମେରିକାଭାରତୀୟଭାଷା'                                                    => 'cai',
    'ମଧ୍ୟଇଁରାଜୀ'                                                                                     => 'enm',
    'ମଧ୍ୟଇରିଶ୍'                                                                                        => 'mga',
    'ମଧ୍ୟପର୍ତ୍ତୁଗାଲୀ'                                                                      => 'dum',
    'ମଧ୍ୟଫ୍ରେଞ୍ଚ'                                                                                  => 'frm',
    'ମନୋବୋଭାଷା'                                                                                        => 'mno',
    'ମନ୍ଦାର'                                                                                                 => 'mdr',
    'ମରାଠୀ'                                                                                                    => 'mr',
    'ମାଁକ୍ସ'                                                                                                 => 'gv',
    'ମାଓରୀ'                                                                                                    => 'mi',
    'ମାକଡୋନିଆନ୍'                                                                                     => 'mk',
    'ମାଗାହୀ'                                                                                                 => 'mag',
    'ମାଞ୍ଚୁ'                                                                                                 => 'mnc',
    'ମାଣ୍ଡିଙ୍ଗୋ'                                                                                     => 'man',
    'ମାଦୁରୀସ୍'                                                                                           => 'mad',
    'ମାରୀ'                                                                                                       => 'chm',
    'ମାର୍ଶାଲୀଜ୍'                                                                                     => 'mh',
    'ମାରୱାରୀ'                                                                                              => 'mwr',
    'ମାଲଟୀଜ୍'                                                                                              => 'mt',
    'ମାଲାଗାସୀ'                                                                                           => 'mg',
    'ମାଲାୟଲମ୍'                                                                                           => 'ml',
    'ମାଲୟ'                                                                                                       => 'ms',
    'ମାସାଇ'                                                                                                    => 'mas',
    'ମାୟାଭାଷା'                                                                                           => 'myn',
    'ମିକମୌକ୍'                                                                                              => 'mic',
    'ମିଡିଲ୍ହାଇଜର୍ମାନ୍'                                                                   => 'gmh',
    'ମିନାଙ୍ଗାବାଉ'                                                                                  => 'min',
    'ମିରାଣ୍ଡିଜ୍'                                                                                     => 'mwl',
    'ମୁଣ୍ଡାଭାଷା'                                                                                     => 'mun',
    'ମେଣ୍ଡେ'                                                                                                 => 'men',
    'ମୈଥିଳୀ'                                                                                                 => 'mai',
    'ମୋକ୍ଷ'                                                                                                    => 'mdf',
    'ମୋଲଡୋଭିଆନ୍'                                                                                     => 'mo',
    'ମୋସି'                                                                                                       => 'mos',
    'ମୋହୌକ'                                                                                                    => 'moh',
    'ରଷିଆନ୍'                                                                                                 => 'ru',
    'ରାଜସ୍ଥାନୀ'                                                                                        => 'raj',
    'ରାପାନୁଇ'                                                                                              => 'rap',
    'ରାରୋତୋଙ୍ଗନ୍'                                                                                  => 'rar',
    'ରୁଣ୍ଡି'                                                                                                 => 'rn',
    'ରେହେଟୋରୋମାନ୍ସ'                                                                            => 'rm',
    'ରୋମାନି'                                                                                                 => 'rom',
    'ରୋମାନିଆନ୍'                                                                                        => 'ro',
    'ରୋମାନ୍ସଭାଷା'                                                                                  => 'roa',
    'ଲକ୍ସେମବର୍ଗିସ୍'                                                                            => 'lb',
    'ଲାଓ'                                                                                                          => 'lo',
    'ଲାଟଭିଆନ୍'                                                                                           => 'lv',
    'ଲାଟିନ୍'                                                                                                 => 'la',
    'ଲାଦିନୋ'                                                                                                 => 'lad',
    'ଲାମ୍ବା'                                                                                                 => 'lam',
    'ଲାହାଣ୍ଡା'                                                                                           => 'lah',
    'ଲିଙ୍ଗାଲା'                                                                                           => 'ln',
    'ଲିଥୁଆନିଆନ୍'                                                                                     => 'lt',
    'ଲିମ୍ବୁର୍ଗିସ୍'                                                                               => 'li',
    'ଲୁଇସେନୋ'                                                                                              => 'lui',
    'ଲୁଓ'                                                                                                          => 'luo',
    'ଲୁଣ୍ଡା'                                                                                                 => 'lun',
    'ଲୁବାଲୁଲୁଆ'                                                                                        => 'lua',
    'ଲୁଲେସାମି'                                                                                           => 'smj',
    'ଲୁସାଉ'                                                                                                    => 'lus',
    'ଲେଜଗିୟାନ୍'                                                                                        => 'lez',
    'ଲେବେରିଆନ୍ପର୍ତ୍ତୁଗୀଜ୍'                                                       => 'pt_pt',
    'ଲେବେରିଆନ୍ସ୍ପାନିଶ୍'                                                                => 'es_es',
    'ଲୋଜବାନ୍'                                                                                              => 'jbo',
    'ଲୋଜର୍ମାନ୍'                                                                                        => 'nds',
    'ଲୋଜି'                                                                                                       => 'loz',
    'ଲ୍ୟୁବାକାଟାଙ୍ଗା'                                                                         => 'lu',
    'ଶଲୀସନ୍ଭାଷା'                                                                                     => 'sal',
    'ଶାନ୍'                                                                                                       => 'shn',
    'ଶାରାନାଟୋଙ୍ଗୋ'                                                                               => 'srn',
    'ଶୁଶୁ'                                                                                                       => 'sus',
    'ଶେରେର୍'                                                                                                 => 'srr',
    'ଶୋନା'                                                                                                       => 'sn',
    'ସଂସ୍କୃତ'                                                                                              => 'sa',
    'ସଣ୍ଡାୱେ'                                                                                              => 'sad',
    'ସର୍ଦିନିଆନ୍'                                                                                     => 'sc',
    'ସର୍ବିଆନ୍'                                                                                           => 'sr',
    'ସର୍ବିଆନ୍ଭାଷା'                                                                               => 'wen',
    'ସର୍ବୋକ୍ରୋଆଟିଆନ୍'                                                                      => 'sh',
    'ସାଙ୍କେତିକଭାଷା'                                                                            => 'sgn',
    'ସାଙ୍ଗୋ'                                                                                                 => 'sg',
    'ସାନ୍ତାଳି'                                                                                           => 'sat',
    'ସାମିଭାଷା'                                                                                           => 'smi',
    'ସାମୋଆନ୍'                                                                                              => 'sm',
    'ସାମୌରିଟନ୍ଆରମାଇକ୍'                                                                   => 'sam',
    'ସାଲ୍ଭିକ୍ଭାଷା'                                                                               => 'sla',
    'ସାସାକ୍'                                                                                                 => 'sas',
    'ସିଂହଳ'                                                                                                    => 'si',
    'ସିଓନ୍ଭାଷା'                                                                                        => 'sio',
    'ସିଚୁଆନ୍ୟୀ'                                                                                        => 'ii',
    'ସିଦାମୋ'                                                                                                 => 'sid',
    'ସିନୋତିବ୍ବେତାନ୍ଭାଷା'                                                             => 'sit',
    'ସିନ୍ଧୀ'                                                                                                 => 'sd',
    'ସିରିକ୍'                                                                                                 => 'syr',
    'ସିଶିଲିଆନ୍'                                                                                        => 'scn',
    'ସୀବୁଆନୋ'                                                                                              => 'ceb',
    'ସୁକୁମା'                                                                                                 => 'suk',
    'ସୁଦାନୀଜ୍'                                                                                           => 'su',
    'ସୁମେରିଆନ୍'                                                                                        => 'sux',
    'ସେମିଟିକ୍ଭାଷା'                                                                               => 'sem',
    'ସେଲ୍କପ୍'                                                                                              => 'sel',
    'ସେସୋଥୋ'                                                                                                 => 'st',
    'ସେସ୍ବାନା'                                                                                           => 'tn',
    'ସୋଂଗା'                                                                                                    => 'ts',
    'ସୋଗଡିଏନ୍'                                                                                           => 'sog',
    'ସୋଙ୍ଘାଇ'                                                                                              => 'son',
    'ସୋନିଙ୍କେ'                                                                                           => 'snk',
    'ସୋମାଲିଆ'                                                                                              => 'so',
    'ସ୍କଟସ୍'                                                                                                 => 'sco',
    'ସ୍କଟିସ୍ଗାଏଲିକ୍'                                                                         => 'gd',
    'ସ୍କୋଲ୍ଟସାମୀ'                                                                                  => 'sms',
    'ସ୍ପାନିସ୍'                                                                                           => 'es',
    'ସ୍ବାତୀ'                                                                                                 => 'ss',
    'ସ୍ବିଚ୍ଇନ୍'                                                                                        => 'gwi',
    'ସ୍ବିସ୍ଜର୍ମାନ୍'                                                                            => 'gsw',
    'ସ୍ବିସ୍ଫ୍ରେଞ୍ଚ୍'                                                                         => 'fr_ch',
    'ସ୍ବିସ୍ହାଇଜର୍ମାନ୍'                                                                   => 'de_ch',
    'ସ୍ଲେଭ୍'                                                                                                 => 'den',
    'ସ୍ଲୋଭାକ୍'                                                                                           => 'sk',
    'ସ୍ଲୋଭେନିଆନ୍'                                                                                  => 'sl',
    'ସ୍ୱାହିଲ୍'                                                                                           => 'sw',
    'ସ୍ୱେଡିସ୍'                                                                                           => 'sv',
    'ହଁଙ୍ଗ'                                                                                                    => 'hmn',
    'ହଙ୍ଗେରିଆନ୍'                                                                                     => 'hu',
    'ହାଇଡା'                                                                                                    => 'hai',
    'ହାୱାଇନ୍'                                                                                              => 'haw',
    'ହିତୀତେ'                                                                                                 => 'hit',
    'ହିନ୍ଦୀ'                                                                                                 => 'hi',
    'ହିମାଚଳୀ'                                                                                              => 'him',
    'ହିରିମୋଟୁ'                                                                                           => 'ho',
    'ହିଲିଗୈନନ୍'                                                                                        => 'hil',
    'ହୁପା'                                                                                                       => 'hup',
    'ହେବ୍ର୍ୟୁ'                                                                                           => 'he',
    'ହେରେରୋ'                                                                                                 => 'hz',
    'ହୈତାୟିନ୍'                                                                                           => 'ht',
    'ହୌସା'                                                                                                       => 'ha',
    'ୟାଓ'                                                                                                          => 'yao',
    'ୟାକୁଟ୍'                                                                                                 => 'sah',
    'ୟାପୀସ୍'                                                                                                 => 'yap',
    'ୟିଡିସ୍'                                                                                                 => 'yi',
    "ୟୁ\.ଏସ୍\.ଇଁରାଜୀ"                                                                              => 'en_us',
    'ୟୁକ୍ରାନିଆନ୍'                                                                                  => 'uk',
    'ୟୁଗୋରଟିକ୍'                                                                                        => 'uga',
    'ୟୁଘୁର୍'                                                                                                 => 'ug',
    'ୟୁପିକ୍ଭାଷା'                                                                                     => 'ypk',
    'ୟୋରୁବା'                                                                                                 => 'yo',
    'ୱାକଶନ୍ଭାଷା'                                                                                     => 'wak',
    'ୱାରୈ'                                                                                                       => 'war',
    'ୱାଲମୋ'                                                                                                    => 'wal',
    'ୱାଲୁନ୍'                                                                                                 => 'wa',
    'ୱାସୋ'                                                                                                       => 'was',
    'ୱେଲ୍ସ'                                                                                                    => 'cy',
    'ୱୋଲଫ୍'                                                                                                    => 'wo',
    'ୱୌସେଜ୍'                                                                                                 => 'osa',
);

1;
