package Locales::DB::Language::el;

# Auto generated from CLDR

$Locales::DB::Language::el::VERSION = '0.01';

$Locales::DB::Language::el::cldr_version = '1.7.1';

%Locales::DB::Language::el::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Γλώσσα\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Περιοχή\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "όχι\:ό",
        'yesstr' => "ναι\:ν"
    },
);

%Locales::DB::Language::el::code_to_name = (
    'aa'    => 'Αφάρ',
    'ab'    => 'Αμπχαζικά',
    'ace'   => 'Αχινίζ',
    'ach'   => 'Ακολί',
    'ada'   => 'Αντάνγκμε',
    'ady'   => 'Αντιγκέα',
    'ae'    => 'Αβεστάν',
    'af'    => 'Αφρικάανς',
    'afa'   => "Αφροασιατική\ γλώσσα",
    'afh'   => 'Αφριχίλι',
    'ain'   => 'Αϊνού',
    'ak'    => 'Ακάν',
    'akk'   => 'Ακάντιαν',
    'ale'   => 'Αλούτ',
    'alg'   => "Γλώσσα\ Αλγκονκιάν",
    'alt'   => "Νότια\ Αλαταϊκά",
    'am'    => 'Αμαρικά',
    'an'    => 'Αραγκονικά',
    'ang'   => "Παλαιά\ Αγγλικά",
    'anp'   => 'Ανγκικά',
    'apa'   => "Γλώσσα\ Απάτσι",
    'ar'    => 'Αραβικά',
    'arc'   => 'Αραμαϊκά',
    'arn'   => 'Αρουκάνιαν',
    'arp'   => 'Αράπαχο',
    'art'   => "Τεχνητή\ γλώσσα",
    'arw'   => 'Αραγουάκ',
    'as'    => 'Ασαμεζικά',
    'ast'   => 'Αστουριανά',
    'ath'   => "Γλώσσα\ Αθαπάσκαν",
    'aus'   => "Αυστραλιανή\ γλώσσα",
    'av'    => 'Άβαρικ',
    'awa'   => 'Αγουαντί',
    'ay'    => 'Αϊμάρα',
    'az'    => 'Αζερμπαϊτζανικά',
    'ba'    => 'Μπασκίρ',
    'bad'   => 'Μπάντα',
    'bai'   => "Γλώσσα\ Μπαμιλέκ",
    'bal'   => 'Μπαλούτσι',
    'ban'   => 'Μπαλινίζ',
    'bas'   => 'Μπάσα',
    'bat'   => "Βαλτική\ γλώσσα",
    'be'    => 'Λευκορωσικά',
    'bej'   => 'Μπέζα',
    'bem'   => 'Μπέμπα',
    'ber'   => 'Μπέρμπερ',
    'bg'    => 'Βουλγαρικά',
    'bh'    => 'Μπιχάρι',
    'bho'   => 'Μποζπούρι',
    'bi'    => 'Μπισλάμα',
    'bik'   => 'Μπικόλ',
    'bin'   => 'Μπίνι',
    'bla'   => 'Σικσίκα',
    'bm'    => 'Μπαμπάρα',
    'bn'    => 'Μπενγκάλι',
    'bnt'   => 'Μπαντού',
    'bo'    => 'Θιβετιανά',
    'br'    => 'Βρετονικά',
    'bra'   => 'Μπρατζ',
    'bs'    => 'Βοσνιακά',
    'btk'   => 'Μπατάκ',
    'bua'   => 'Μπουριάτ',
    'bug'   => 'Μπουγκίζ',
    'byn'   => 'Μπλιν',
    'ca'    => 'Καταλανικά',
    'cad'   => 'Κάντο',
    'cai'   => "Ινδιανική\ γλώσσα\ Κεντρικής\ Αμερικής",
    'car'   => 'Καρίμπ',
    'cau'   => "Καυκάσια\ γλώσσα",
    'cch'   => 'Ατσάμ',
    'ce'    => 'Τσέτσνιαν',
    'ceb'   => 'Κεμπουάνο',
    'cel'   => "Κελτική\ γλώσσα",
    'ch'    => 'Καμόρρο',
    'chb'   => 'Τσίμπτσα',
    'chg'   => 'Τσαγκατάι',
    'chk'   => 'Τσουκίζι',
    'chm'   => 'Μάρι',
    'chn'   => "Ιδιωματικά\ Σινούκ",
    'cho'   => 'Τσοκτάου',
    'chp'   => 'Τσίπιουαν',
    'chr'   => 'Τσερόκι',
    'chy'   => 'Σεγιέν',
    'cmc'   => "Χαμική\ γλώσσα",
    'co'    => 'Κορσικανικά',
    'cop'   => 'Κοπτικά',
    'cpe'   => "Κρεόλ\ ή\ Πίντγκιν\ βάσει\ Αγγλικών",
    'cpf'   => "Κρεόλ\ ή\ Πίντγκιν\ βάσει\ Γαλλικών",
    'cpp'   => "Κρεόλ\ και\ Πίντγκιν\ βάσει\ Πορτογαλικών",
    'cr'    => 'Κρι',
    'crh'   => "Τουρκικά\ Κριμαίας",
    'crp'   => "Κρεόλ\ ή\ Πίντγκιν",
    'cs'    => 'Τσεχικά',
    'csb'   => 'Κασούμπιαν',
    'cu'    => "Εκκλησιαστικά\ Σλαβικά",
    'cus'   => "Γλώσσα\ Κουσιτίκ",
    'cv'    => 'Χουβάς',
    'cy'    => 'Ουαλικά',
    'da'    => 'Δανικά',
    'dak'   => 'Ντακότα',
    'dar'   => 'Ντάργκουα',
    'day'   => 'Νταγιάκ',
    'de'    => 'Γερμανικά',
    'de_at' => "Γερμανικά\ Αυστρίας",
    'de_ch' => "Γερμανικά\ Ελβετίας",
    'del'   => 'Ντέλαγουερ',
    'den'   => 'Σλαβικά',
    'dgr'   => 'Ντόγκριμπ',
    'din'   => 'Ντίνκα',
    'doi'   => 'Ντόγκρι',
    'dra'   => "Γλώσσα\ Ντραβίδιαν",
    'dsb'   => "Γλώσσα\ Κάτω\ Λουσατίας",
    'dua'   => 'Ντουάλα',
    'dum'   => "Μέσα\ Ολλανδικά",
    'dv'    => 'Ντιβέχι',
    'dyu'   => 'Ντογιούλα',
    'dz'    => 'Ντζόνγκχα',
    'ee'    => 'Γι',
    'efi'   => 'Εφίκ',
    'egy'   => "Αρχαία\ Αιγυπτιακά",
    'eka'   => 'Εκατζούκ',
    'el'    => 'Ελληνικά',
    'elx'   => 'Ελαμάιτ',
    'en'    => 'Αγγλικά',
    'en_au' => "Αγγλικά\ Αυστραλίας",
    'en_ca' => "Αγγλικά\ Καναδά",
    'en_gb' => "Αγγλικά\ Ηνωμένου\ Βασιλείου",
    'en_us' => "Αγγλικά\ Η\.Π\.Α\.",
    'enm'   => "Μέσα\ Αγγλικά",
    'eo'    => 'Εσπεράντο',
    'es'    => 'Ισπανικά',
    'es_es' => "Ισπανικά\ Ιβηρικής",
    'et'    => 'Εσθονικά',
    'eu'    => 'Βασκικά',
    'ewo'   => 'Εγουόντο',
    'fa'    => 'Περσικά',
    'fan'   => 'Φανγκ',
    'fat'   => 'Φάντι',
    'ff'    => 'Φουλάχ',
    'fi'    => 'Φινλανδικά',
    'fil'   => 'Φιλιππινεζικά',
    'fiu'   => "Φιννο\-Ούγκριαν",
    'fj'    => 'Φίτζι',
    'fo'    => 'Φαρόε',
    'fon'   => 'Φον',
    'fr'    => 'Γαλλικά',
    'fr_ca' => "Γαλλικά\ Καναδά",
    'fr_ch' => "Γαλλικά\ Ελβετίας",
    'frm'   => "Μέσα\ Γαλλικά",
    'fro'   => "Παλαιά\ Γαλλικά",
    'frr'   => "Βόρεια\ Φριζιανά",
    'frs'   => "Ανατολικά\ Φριζιανά",
    'fur'   => 'Φριούλιαν',
    'fy'    => "Δυτικά\ Φριζιανά",
    'ga'    => 'Ιρλανδικά',
    'gaa'   => 'Γκα',
    'gay'   => 'Γκάγιο',
    'gba'   => 'Γκμπάγια',
    'gd'    => "Σκωτικά\ Κελτικά",
    'gem'   => "Γερμανική\ γλώσσα",
    'gez'   => 'Γκιζ',
    'gil'   => 'Γκιλμπερτίζ',
    'gl'    => 'Γαλικιανά',
    'gmh'   => "Μέσα\ Άνω\ Γερμανικά",
    'gn'    => 'Γκουαρανί',
    'goh'   => "Παλαιά\ Άνω\ Γερμανικά",
    'gon'   => 'Γκόντι',
    'gor'   => 'Γκοροντάλο',
    'got'   => 'Γοτθικά',
    'grb'   => 'Γκρίμπο',
    'grc'   => "Αρχαία\ Ελληνικά",
    'gsw'   => "Ελβετικά\ Γερμανικά",
    'gu'    => 'Γκουγιαράτι',
    'gv'    => 'Μανξ',
    'gwi'   => 'Γκουίτσιν',
    'ha'    => 'Χάουσα',
    'hai'   => 'Χάιντα',
    'haw'   => 'Χαβανεζικά',
    'he'    => 'Εβραϊκά',
    'hi'    => 'Χίντι',
    'hil'   => 'Χιλιγκαγιόν',
    'him'   => 'Χιματσάλι',
    'hit'   => 'Χιτίτε',
    'hmn'   => 'Χμονγκ',
    'ho'    => "Χίρι\ Μότου",
    'hr'    => 'Κροατικά',
    'hsb'   => "Γλώσσα\ Άνω\ Λουσατίας",
    'ht'    => 'Αϊτιανά',
    'hu'    => 'Ουγγρικά',
    'hup'   => 'Χούπα',
    'hy'    => 'Αρμενικά',
    'hz'    => 'Χερέρο',
    'ia'    => 'Ιντερλίνγκουα',
    'iba'   => 'Ιμπάν',
    'id'    => 'Ινδονησιακά',
    'ie'    => 'Ιντερλίνγκουε',
    'ig'    => 'Ίγκμπο',
    'ii'    => "Σικουάν\ Γι",
    'ijo'   => 'Ιζό',
    'ik'    => 'Ινουπιάκ',
    'ilo'   => 'Ιλόκο',
    'inc'   => "Ινδική\ γλώσσα",
    'ine'   => "Ινδοευρωπαϊκή\ γλώσσα",
    'inh'   => 'Ινγκούς',
    'io'    => 'Ίντο',
    'ira'   => "Ιρανική\ γλώσσα",
    'iro'   => "Γλώσσα\ Ιροκόιαν",
    'is'    => 'Ισλανδικά',
    'it'    => 'Ιταλικά',
    'iu'    => 'Ινουκτιτούτ',
    'ja'    => 'Ιαπωνικά',
    'jbo'   => 'Λόζμπαν',
    'jpr'   => "Ιουδαϊκά\-Περσικά",
    'jrb'   => "Ιουδαϊκά\-Αραβικά",
    'jv'    => 'Ιαβανεζικά',
    'ka'    => 'Γεωργιανά',
    'kaa'   => "Κάρα\-Καλπάκ",
    'kab'   => 'Καμπίλε',
    'kac'   => 'Κατσίν',
    'kaj'   => 'Τζου',
    'kam'   => 'Κάμπα',
    'kar'   => 'Καρέν',
    'kaw'   => 'Κάουι',
    'kbd'   => 'Καμπαρντιανά',
    'kcg'   => 'Τουάπ',
    'kfo'   => 'Κόρο',
    'kg'    => 'Κονγκό',
    'kha'   => 'Κάσι',
    'khi'   => "Γλώσσα\ Κοϊσάν",
    'kho'   => 'Κοτανικά',
    'ki'    => 'Κικούγιου',
    'kj'    => 'Κουανιγιάμα',
    'kk'    => 'Καζακικά',
    'kl'    => 'Καλααλισούτ',
    'km'    => 'Καμποτζιανά',
    'kmb'   => 'Κιμπούντου',
    'kn'    => 'Κανάντα',
    'ko'    => 'Κορεατικά',
    'kok'   => 'Κονκάνι',
    'kos'   => 'Κοσραενικά',
    'kpe'   => 'Κπέλε',
    'kr'    => 'Κανούρι',
    'krc'   => "Καρατσάι\-Μπαλκάρ",
    'krl'   => 'Καρελιακά',
    'kro'   => 'Κρου',
    'kru'   => 'Κουρούχ',
    'ks'    => 'Κασμίρι',
    'ku'    => 'Κουρδικά',
    'kum'   => 'Κουμγιούκ',
    'kut'   => 'Κουτενάι',
    'kv'    => 'Κόμι',
    'kw'    => 'Κόρνις',
    'ky'    => 'Κυργιζικά',
    'la'    => 'Λατινικά',
    'lad'   => 'Λαδίνο',
    'lah'   => 'Λάχδα',
    'lam'   => 'Λάμπα',
    'lb'    => 'Λουξεμβουργικά',
    'lez'   => 'Λαζγκιάν',
    'lg'    => 'Γκάντα',
    'li'    => 'Λιμβουργιανά',
    'ln'    => 'Λινγκάλα',
    'lo'    => 'Λαοθιανά',
    'lol'   => 'Μόνγκο',
    'loz'   => 'Λόζι',
    'lt'    => 'Λιθουανικά',
    'lu'    => "Λούμπα\-Κατάνγκα",
    'lua'   => "Λούμπα\-Λουλούα",
    'lui'   => 'Λουισένο',
    'lun'   => 'Λούντα',
    'luo'   => 'Λούο',
    'lus'   => 'Λουσάι',
    'lv'    => 'Λετονικά',
    'mad'   => 'Μαντουρίζ',
    'mag'   => 'Μαγκάχι',
    'mai'   => 'Μαϊτχίλι',
    'mak'   => 'Μακαζάρ',
    'man'   => 'Μαντίνγκο',
    'map'   => 'Οστρονέζιαν',
    'mas'   => 'Μασάι',
    'mdf'   => 'Μόκσα',
    'mdr'   => 'Μανδάρ',
    'men'   => 'Μέντε',
    'mfe'   => 'Morisyen',
    'mg'    => 'Μαλαγάσι',
    'mga'   => "Μέσα\ Ιρλανδικά",
    'mh'    => 'Μάρσαλ',
    'mi'    => 'Μάορι',
    'mic'   => 'Μικμάκ',
    'min'   => 'Μινανγκαμπάου',
    'mis'   => "Διάφορες\ γλώσσες",
    'mk'    => 'Σλαβομακεδονικά',
    'mkh'   => "Γλώσσα\ Μον\-Χμερ",
    'ml'    => 'Μαλαγιαλάμ',
    'mn'    => 'Μογγολικά',
    'mnc'   => 'Μαντσού',
    'mni'   => 'Μανιπούρι',
    'mno'   => "Γλώσσα\ Μανόμπο",
    'mo'    => 'Μολδαβικά',
    'moh'   => 'Μοχόκ',
    'mos'   => 'Μόσι',
    'mr'    => 'Μαράθι',
    'ms'    => 'Μαλάι',
    'mt'    => 'Μαλτεζικά',
    'mul'   => "Πολλαπλές\ γλώσσες",
    'mun'   => "Γλώσσα\ Μούντα",
    'mus'   => 'Κρικ',
    'mwl'   => 'Μιραντεζικά',
    'mwr'   => 'Μαργουάρι',
    'my'    => 'Βιρμανικά',
    'myn'   => "Γλώσσα\ Μάγιαν",
    'myv'   => 'Έρζυα',
    'na'    => 'Ναούρου',
    'nah'   => 'Ναχουάτλ',
    'nai'   => "Ινδιανική\ γλώσσα\ Βόρειας\ Αμερικής",
    'nap'   => 'Ναπολιτανικά',
    'nb'    => "Νορβηγικά\ Μποκμάλ",
    'nd'    => "Ντεμπέλε\ Βορρά",
    'nds'   => "Κάτω\ Γερμανικά",
    'ne'    => 'Νεπάλι',
    'new'   => 'Νεγουάρι',
    'ng'    => 'Ντόνγκα',
    'nia'   => 'Νίας',
    'nic'   => "Γλώσσα\ Νίγηρα\-Κορδοφάνιαν",
    'niu'   => 'Νιούεαν',
    'nl'    => 'Ολλανδικά',
    'nl_be' => 'Φλαμανδικά',
    'nn'    => "Νορβηγικά\ Νινόρσκ",
    'no'    => 'Νορβηγικά',
    'nog'   => 'Νογκάι',
    'non'   => "Παλαιά\ Νορβηγικά",
    'nqo'   => "Ν\'Κο",
    'nr'    => "Ντεμπέλε\ Νότου",
    'nso'   => "Βόρεια\ Σόθο",
    'nub'   => "Γλώσσα\ Νούμπιαν",
    'nv'    => 'Νάβαχο',
    'nwc'   => "Κλασικά\ Νεουάρι",
    'ny'    => 'Νιάντζα',
    'nym'   => 'Νιαμγουέζι',
    'nyn'   => 'Νιανκόλε',
    'nyo'   => 'Νιόρο',
    'nzi'   => 'Νζίμα',
    'oc'    => 'Οκσιτανικά',
    'oj'    => 'Οζιβίγουα',
    'om'    => 'Ορόμο',
    'or'    => 'Ορίγια',
    'os'    => 'Οσετικά',
    'osa'   => 'Οσάζ',
    'ota'   => "Οθωμανικά\ Τουρκικά",
    'oto'   => "Οθωμανική\ γλώσσα",
    'pa'    => 'Παντζαπικά',
    'paa'   => 'Παπούα',
    'pag'   => 'Πανγκασινάν',
    'pal'   => 'Παχλάβι',
    'pam'   => 'Παμπάνγκα',
    'pap'   => 'Παπιαμέντο',
    'pau'   => 'Παλάουαν',
    'peo'   => "Αρχαία\ Περσικά",
    'phi'   => "Φιλιππινεζική\ γλώσσα",
    'phn'   => 'Φοινικικά',
    'pi'    => 'Πάλι',
    'pl'    => 'Πολωνικά',
    'pon'   => 'Ποχπέιαν',
    'pra'   => "Γλώσσα\ Πράκριτ",
    'pro'   => "Παλαιά\ Προβενσιάλ",
    'ps'    => 'Πάστο',
    'pt'    => 'Πορτογαλικά',
    'pt_br' => "Πορτογαλικά\ Βραζιλίας",
    'pt_pt' => "Πορτογαλικά\ Ιβηρικής",
    'qu'    => 'Κετσούα',
    'raj'   => 'Ραζασθάνι',
    'rap'   => 'Ραπανούι',
    'rar'   => 'Ραροτονγκάν',
    'rm'    => "Ρετο\-Ρομανικά",
    'rn'    => 'Ρούντι',
    'ro'    => 'Ρουμανικά',
    'roa'   => "Ρομανική\ γλώσσα",
    'rom'   => 'Ρομανί',
    'ru'    => 'Ρωσικά',
    'rup'   => 'Αρομανικά',
    'rw'    => 'Κινιαρβάντα',
    'sa'    => 'Σανσκριτικά',
    'sad'   => 'Σαντάγουε',
    'sah'   => 'Γιακούτ',
    'sai'   => "Ινδιανική\ γλώσσα\ Νότιας\ Αμερικής",
    'sal'   => "Γλώσσα\ Σαλισάν",
    'sam'   => "Σαμαρίτικα\ Αραμαϊκά",
    'sas'   => 'Σασάκ',
    'sat'   => 'Σαντάλι',
    'sc'    => 'Σαρδινικά',
    'scn'   => 'Σικελιανά',
    'sco'   => 'Σκωτικά',
    'sd'    => 'Σίντι',
    'se'    => "Βόρεια\ Σάμι",
    'sel'   => 'Σελκούπ',
    'sem'   => "Σημητική\ γλώσσα",
    'sg'    => 'Σάνγκο',
    'sga'   => "Παλαιά\ Ιρλανδικά",
    'sgn'   => "Νοηματική\ γλώσσα",
    'sh'    => 'Σερβοκροατικά',
    'shn'   => 'Σαν',
    'si'    => 'Σινχαλεζικά',
    'sid'   => 'Σιντάμο',
    'sio'   => "Γλώσσα\ Σιουάν",
    'sit'   => "Σινοθιβετιανή\ γλώσσα",
    'sk'    => 'Σλοβακικά',
    'sl'    => 'Σλοβενικά',
    'sla'   => "Σλαβική\ γλώσσα",
    'sm'    => 'Σαμόαν',
    'sma'   => "Νότια\ Σάμι",
    'smi'   => "Γλώσσα\ Σάμι",
    'smj'   => "Λούλε\ Σάμι",
    'smn'   => "Ινάρι\ Σάμι",
    'sms'   => "Σκολτ\ Σάμι",
    'sn'    => 'Σχόνα',
    'snk'   => 'Σονίνκε',
    'so'    => 'Σομάλι',
    'sog'   => 'Σογκντιέν',
    'son'   => 'Σονγκχάι',
    'sq'    => 'Αλβανικά',
    'sr'    => 'Σερβικά',
    'srn'   => "Σρανάρ\ Τόνγκο",
    'srr'   => 'Σερέρ',
    'ss'    => 'Σουάτι',
    'ssa'   => "Νιλο\-Σαχαριανή\ γλώσσα",
    'st'    => "Νότια\ Σόθο",
    'su'    => 'Σουδανικά',
    'suk'   => 'Σουκούμα',
    'sus'   => 'Σούσου',
    'sux'   => 'Σουμερικά',
    'sv'    => 'Σουηδικά',
    'sw'    => 'Σουαχίλι',
    'syc'   => "Κλασικά\ Συριακά",
    'syr'   => 'Συριακά',
    'ta'    => 'Ταμίλ',
    'tai'   => "Ταϊλανδική\ γλώσσα",
    'te'    => 'Τελούγκου',
    'tem'   => 'Τίμνε',
    'ter'   => 'Τερένο',
    'tet'   => 'Τέτουμ',
    'tg'    => 'Τατζίκ',
    'th'    => 'Ταϊλανδικά',
    'ti'    => 'Τιγκρίνυα',
    'tig'   => 'Τίγκρε',
    'tiv'   => 'Τιβ',
    'tk'    => 'Τουρκμενικά',
    'tkl'   => 'Τοκελάου',
    'tl'    => 'Ταγκαλόγκ',
    'tlh'   => 'Κλίνγκον',
    'tli'   => 'Τλίνγκιτ',
    'tmh'   => 'Ταμασέκ',
    'tn'    => 'Τσιγουάνα',
    'to'    => 'Τόνγκα',
    'tog'   => "Νιάσα\ Τόνγκα",
    'tpi'   => "Τοκ\ Πισίν",
    'tr'    => 'Τουρκικά',
    'trv'   => 'Taroko',
    'ts'    => 'Τσόνγκα',
    'tsi'   => 'Τσίμσιαν',
    'tt'    => 'Τατάρ',
    'tum'   => 'Τουμπούκα',
    'tup'   => "Γλώσσα\ Τούπι",
    'tut'   => "Αλταϊκή\ γλώσσα",
    'tvl'   => 'Τουβαλού',
    'tw'    => 'Τούι',
    'ty'    => 'Ταϊτιανά',
    'tyv'   => 'Τουβίνιαν',
    'udm'   => 'Ουντμούρτ',
    'ug'    => 'Ουιγουρικά',
    'uga'   => 'Ουγκαρίτικ',
    'uk'    => 'Ουκρανικά',
    'umb'   => 'Ουμπούντου',
    'und'   => "Άγνωστη\ ή\ ακατάλληλη\ γλώσσα",
    'ur'    => 'Ουρντού',
    'uz'    => 'Ουζμπεκικά',
    'vai'   => 'Βάι',
    've'    => 'Βένδα',
    'vi'    => 'Βιετναμεζικά',
    'vo'    => 'Βόλαπικ',
    'vot'   => 'Βότικ',
    'wa'    => 'Γουαλούν',
    'wak'   => "Γλώσσα\ Γουακασάν",
    'wal'   => 'Γουάλαμο',
    'war'   => 'Γουάρει',
    'was'   => 'Γουασό',
    'wen'   => "Διάλεκτος\ Άνω\ Λουσατίας",
    'wo'    => 'Γουόλοφ',
    'xal'   => 'Καλμίκ',
    'xh'    => 'Ζόσα',
    'yao'   => 'Γιάο',
    'yap'   => 'Γιαπίζ',
    'yi'    => 'Γίντις',
    'yo'    => 'Γιορούμπα',
    'ypk'   => "Γλώσσα\ Γιούπικ",
    'za'    => 'Ζουάνγκ',
    'zap'   => 'Ζάποτεκ',
    'zbl'   => "Σύμβολα\ Bliss",
    'zen'   => 'Ζενάγκα',
    'zh'    => 'Κινεζικά',
    'znd'   => 'Ζάντε',
    'zu'    => 'Ζουλού',
    'zun'   => 'Ζούνι',
    'zxx'   => "Χωρίς\ γλωσσολογικό\ περιεχόμενο",
    'zza'   => 'Ζάζα',
);

%Locales::DB::Language::el::name_to_code = (
    'morisyen'                                                           => 'mfe',
    'taroko'                                                             => 'trv',
    'Άβαρικ'                                                       => 'av',
    'Άγνωστηήακατάλληληγλώσσα'                   => 'und',
    'Έρζυα'                                                         => 'myv',
    'Ίγκμπο'                                                       => 'ig',
    'Ίντο'                                                           => 'io',
    'Αβεστάν'                                                     => 'ae',
    'Αγγλικά'                                                     => 'en',
    'ΑγγλικάΑυστραλίας'                                 => 'en_au',
    "ΑγγλικάΗ\.Π\.Α\."                                         => 'en_us',
    'ΑγγλικάΗνωμένουΒασιλείου'                   => 'en_gb',
    'ΑγγλικάΚαναδά'                                         => 'en_ca',
    'Αγουαντί'                                                   => 'awa',
    'Αζερμπαϊτζανικά'                                     => 'az',
    'Ακάν'                                                           => 'ak',
    'Ακάντιαν'                                                   => 'akk',
    'Ακολί'                                                         => 'ach',
    'Αλβανικά'                                                   => 'sq',
    'Αλούτ'                                                         => 'ale',
    'Αλταϊκήγλώσσα'                                         => 'tut',
    'Αμαρικά'                                                     => 'am',
    'Αμπχαζικά'                                                 => 'ab',
    'ΑνατολικάΦριζιανά'                                 => 'frs',
    'Ανγκικά'                                                     => 'anp',
    'Αντάνγκμε'                                                 => 'ada',
    'Αντιγκέα'                                                   => 'ady',
    'Αράπαχο'                                                     => 'arp',
    'Αραβικά'                                                     => 'ar',
    'Αραγκονικά'                                               => 'an',
    'Αραγουάκ'                                                   => 'arw',
    'Αραμαϊκά'                                                   => 'arc',
    'Αρμενικά'                                                   => 'hy',
    'Αρομανικά'                                                 => 'rup',
    'Αρουκάνιαν'                                               => 'arn',
    'ΑρχαίαΑιγυπτιακά'                                   => 'egy',
    'ΑρχαίαΕλληνικά'                                       => 'grc',
    'ΑρχαίαΠερσικά'                                         => 'peo',
    'Ασαμεζικά'                                                 => 'as',
    'Αστουριανά'                                               => 'ast',
    'Ατσάμ'                                                         => 'cch',
    'Αυστραλιανήγλώσσα'                                 => 'aus',
    'Αφάρ'                                                           => 'aa',
    'Αφρικάανς'                                                 => 'af',
    'Αφριχίλι'                                                   => 'afh',
    'Αφροασιατικήγλώσσα'                               => 'afa',
    'Αχινίζ'                                                       => 'ace',
    'Αϊμάρα'                                                       => 'ay',
    'Αϊνού'                                                         => 'ain',
    'Αϊτιανά'                                                     => 'ht',
    'Βάι'                                                             => 'vai',
    'Βένδα'                                                         => 've',
    'Βαλτικήγλώσσα'                                         => 'bat',
    'Βασκικά'                                                     => 'eu',
    'Βιετναμεζικά'                                           => 'vi',
    'Βιρμανικά'                                                 => 'my',
    'Βοσνιακά'                                                   => 'bs',
    'Βουλγαρικά'                                               => 'bg',
    'Βρετονικά'                                                 => 'br',
    'Βόλαπικ'                                                     => 'vo',
    'ΒόρειαΣάμι'                                               => 'se',
    'ΒόρειαΣόθο'                                               => 'nso',
    'ΒόρειαΦριζιανά'                                       => 'frr',
    'Βότικ'                                                         => 'vot',
    'Γίντις'                                                       => 'yi',
    'Γαλικιανά'                                                 => 'gl',
    'Γαλλικά'                                                     => 'fr',
    'ΓαλλικάΕλβετίας'                                     => 'fr_ch',
    'ΓαλλικάΚαναδά'                                         => 'fr_ca',
    'Γερμανικά'                                                 => 'de',
    'ΓερμανικάΑυστρίας'                                 => 'de_at',
    'ΓερμανικάΕλβετίας'                                 => 'de_ch',
    'Γερμανικήγλώσσα'                                     => 'gem',
    'Γεωργιανά'                                                 => 'ka',
    'Γι'                                                               => 'ee',
    'Γιάο'                                                           => 'yao',
    'Γιακούτ'                                                     => 'sah',
    'Γιαπίζ'                                                       => 'yap',
    'Γιορούμπα'                                                 => 'yo',
    'Γκάγιο'                                                       => 'gay',
    'Γκάντα'                                                       => 'lg',
    'Γκα'                                                             => 'gaa',
    'Γκιζ'                                                           => 'gez',
    'Γκιλμπερτίζ'                                             => 'gil',
    'Γκμπάγια'                                                   => 'gba',
    'Γκοροντάλο'                                               => 'gor',
    'Γκουίτσιν'                                                 => 'gwi',
    'Γκουαρανί'                                                 => 'gn',
    'Γκουγιαράτι'                                             => 'gu',
    'Γκρίμπο'                                                     => 'grb',
    'Γκόντι'                                                       => 'gon',
    'ΓλώσσαΆνωΛουσατίας'                               => 'hsb',
    'ΓλώσσαΑθαπάσκαν'                                     => 'ath',
    'ΓλώσσαΑλγκονκιάν'                                   => 'alg',
    'ΓλώσσαΑπάτσι'                                           => 'apa',
    'ΓλώσσαΓιούπικ'                                         => 'ypk',
    'ΓλώσσαΓουακασάν'                                     => 'wak',
    'ΓλώσσαΙροκόιαν'                                       => 'iro',
    'ΓλώσσαΚάτωΛουσατίας'                             => 'dsb',
    'ΓλώσσαΚουσιτίκ'                                       => 'cus',
    'ΓλώσσαΚοϊσάν'                                           => 'khi',
    'ΓλώσσαΜάγιαν'                                           => 'myn',
    'ΓλώσσαΜανόμπο'                                         => 'mno',
    'ΓλώσσαΜονΧμερ'                                         => 'mkh',
    'ΓλώσσαΜούντα'                                           => 'mun',
    'ΓλώσσαΜπαμιλέκ'                                       => 'bai',
    'ΓλώσσαΝίγηραΚορδοφάνιαν'                     => 'nic',
    'ΓλώσσαΝούμπιαν'                                       => 'nub',
    'ΓλώσσαΝτραβίδιαν'                                   => 'dra',
    'ΓλώσσαΠράκριτ'                                         => 'pra',
    'ΓλώσσαΣάμι'                                               => 'smi',
    'ΓλώσσαΣαλισάν'                                         => 'sal',
    'ΓλώσσαΣιουάν'                                           => 'sio',
    'ΓλώσσαΤούπι'                                             => 'tup',
    'Γοτθικά'                                                     => 'got',
    'Γουάλαμο'                                                   => 'wal',
    'Γουάρει'                                                     => 'war',
    'Γουαλούν'                                                   => 'wa',
    'Γουασό'                                                       => 'was',
    'Γουόλοφ'                                                     => 'wo',
    'Δανικά'                                                       => 'da',
    'ΔιάλεκτοςΆνωΛουσατίας'                         => 'wen',
    'Διάφορεςγλώσσες'                                     => 'mis',
    'ΔυτικάΦριζιανά'                                       => 'fy',
    'Εβραϊκά'                                                     => 'he',
    'Εγουόντο'                                                   => 'ewo',
    'Εκατζούκ'                                                   => 'eka',
    'ΕκκλησιαστικάΣλαβικά'                           => 'cu',
    'Ελαμάιτ'                                                     => 'elx',
    'ΕλβετικάΓερμανικά'                                 => 'gsw',
    'Ελληνικά'                                                   => 'el',
    'Εσθονικά'                                                   => 'et',
    'Εσπεράντο'                                                 => 'eo',
    'Εφίκ'                                                           => 'efi',
    'Ζάζα'                                                           => 'zza',
    'Ζάντε'                                                         => 'znd',
    'Ζάποτεκ'                                                     => 'zap',
    'Ζενάγκα'                                                     => 'zen',
    'Ζουάνγκ'                                                     => 'za',
    'Ζουλού'                                                       => 'zu',
    'Ζούνι'                                                         => 'zun',
    'Ζόσα'                                                           => 'xh',
    'Θιβετιανά'                                                 => 'bo',
    'Ιαβανεζικά'                                               => 'jv',
    'Ιαπωνικά'                                                   => 'ja',
    'ΙδιωματικάΣινούκ'                                   => 'chn',
    'Ιζό'                                                             => 'ijo',
    'Ιλόκο'                                                         => 'ilo',
    'Ιμπάν'                                                         => 'iba',
    'ΙνάριΣάμι'                                                 => 'smn',
    'Ινγκούς'                                                     => 'inh',
    'ΙνδιανικήγλώσσαΒόρειαςΑμερικής'       => 'nai',
    'ΙνδιανικήγλώσσαΚεντρικήςΑμερικής'   => 'cai',
    'ΙνδιανικήγλώσσαΝότιαςΑμερικής'         => 'sai',
    'Ινδικήγλώσσα'                                           => 'inc',
    'Ινδοευρωπαϊκήγλώσσα'                             => 'ine',
    'Ινδονησιακά'                                             => 'id',
    'Ινουκτιτούτ'                                             => 'iu',
    'Ινουπιάκ'                                                   => 'ik',
    'Ιντερλίνγκουα'                                         => 'ia',
    'Ιντερλίνγκουε'                                         => 'ie',
    'ΙουδαϊκάΑραβικά'                                     => 'jrb',
    'ΙουδαϊκάΠερσικά'                                     => 'jpr',
    'Ιρανικήγλώσσα'                                         => 'ira',
    'Ιρλανδικά'                                                 => 'ga',
    'Ισλανδικά'                                                 => 'is',
    'Ισπανικά'                                                   => 'es',
    'ΙσπανικάΙβηρικής'                                   => 'es_es',
    'Ιταλικά'                                                     => 'it',
    'Κάμπα'                                                         => 'kam',
    'Κάντο'                                                         => 'cad',
    'Κάουι'                                                         => 'kaw',
    'ΚάραΚαλπάκ'                                               => 'kaa',
    'Κάσι'                                                           => 'kha',
    'ΚάτωΓερμανικά'                                         => 'nds',
    'Καζακικά'                                                   => 'kk',
    'Καλααλισούτ'                                             => 'kl',
    'Καλμίκ'                                                       => 'xal',
    'Καμπίλε'                                                     => 'kab',
    'Καμπαρντιανά'                                           => 'kbd',
    'Καμποτζιανά'                                             => 'km',
    'Καμόρρο'                                                     => 'ch',
    'Κανάντα'                                                     => 'kn',
    'Κανούρι'                                                     => 'kr',
    'Καρέν'                                                         => 'kar',
    'Καρίμπ'                                                       => 'car',
    'ΚαρατσάιΜπαλκάρ'                                     => 'krc',
    'Καρελιακά'                                                 => 'krl',
    'Κασμίρι'                                                     => 'ks',
    'Κασούμπιαν'                                               => 'csb',
    'Καταλανικά'                                               => 'ca',
    'Κατσίν'                                                       => 'kac',
    'Καυκάσιαγλώσσα'                                       => 'cau',
    'Κελτικήγλώσσα'                                         => 'cel',
    'Κεμπουάνο'                                                 => 'ceb',
    'Κετσούα'                                                     => 'qu',
    'Κικούγιου'                                                 => 'ki',
    'Κιμπούντου'                                               => 'kmb',
    'Κινεζικά'                                                   => 'zh',
    'Κινιαρβάντα'                                             => 'rw',
    'Κλίνγκον'                                                   => 'tlh',
    'ΚλασικάΝεουάρι'                                       => 'nwc',
    'ΚλασικάΣυριακά'                                       => 'syc',
    'Κονγκό'                                                       => 'kg',
    'Κονκάνι'                                                     => 'kok',
    'Κοπτικά'                                                     => 'cop',
    'Κορεατικά'                                                 => 'ko',
    'Κορσικανικά'                                             => 'co',
    'Κοσραενικά'                                               => 'kos',
    'Κοτανικά'                                                   => 'kho',
    'Κουανιγιάμα'                                             => 'kj',
    'Κουμγιούκ'                                                 => 'kum',
    'Κουρδικά'                                                   => 'ku',
    'Κουρούχ'                                                     => 'kru',
    'Κουτενάι'                                                   => 'kut',
    'Κπέλε'                                                         => 'kpe',
    'ΚρεόλήΠίντγκιν'                                       => 'crp',
    'ΚρεόλήΠίντγκινβάσειΑγγλικών'             => 'cpe',
    'ΚρεόλήΠίντγκινβάσειΓαλλικών'             => 'cpf',
    'ΚρεόλκαιΠίντγκινβάσειΠορτογαλικών' => 'cpp',
    'Κρι'                                                             => 'cr',
    'Κρικ'                                                           => 'mus',
    'Κροατικά'                                                   => 'hr',
    'Κρου'                                                           => 'kro',
    'Κυργιζικά'                                                 => 'ky',
    'Κόμι'                                                           => 'kv',
    'Κόρνις'                                                       => 'kw',
    'Κόρο'                                                           => 'kfo',
    'Λάμπα'                                                         => 'lam',
    'Λάχδα'                                                         => 'lah',
    'Λαδίνο'                                                       => 'lad',
    'Λαζγκιάν'                                                   => 'lez',
    'Λαοθιανά'                                                   => 'lo',
    'Λατινικά'                                                   => 'la',
    'Λετονικά'                                                   => 'lv',
    'Λευκορωσικά'                                             => 'be',
    'Λιθουανικά'                                               => 'lt',
    'Λιμβουργιανά'                                           => 'li',
    'Λινγκάλα'                                                   => 'ln',
    'Λουισένο'                                                   => 'lui',
    'Λουξεμβουργικά'                                       => 'lb',
    'Λουσάι'                                                       => 'lus',
    'ΛούλεΣάμι'                                                 => 'smj',
    'ΛούμπαΚατάνγκα'                                       => 'lu',
    'ΛούμπαΛουλούα'                                         => 'lua',
    'Λούντα'                                                       => 'lun',
    'Λούο'                                                           => 'luo',
    'Λόζι'                                                           => 'loz',
    'Λόζμπαν'                                                     => 'jbo',
    'Μάορι'                                                         => 'mi',
    'Μάρι'                                                           => 'chm',
    'Μάρσαλ'                                                       => 'mh',
    'Μέντε'                                                         => 'men',
    'ΜέσαΆνωΓερμανικά'                                   => 'gmh',
    'ΜέσαΑγγλικά'                                             => 'enm',
    'ΜέσαΓαλλικά'                                             => 'frm',
    'ΜέσαΙρλανδικά'                                         => 'mga',
    'ΜέσαΟλλανδικά'                                         => 'dum',
    'Μαγκάχι'                                                     => 'mag',
    'Μακαζάρ'                                                     => 'mak',
    'Μαλάι'                                                         => 'ms',
    'Μαλαγάσι'                                                   => 'mg',
    'Μαλαγιαλάμ'                                               => 'ml',
    'Μαλτεζικά'                                                 => 'mt',
    'Μανδάρ'                                                       => 'mdr',
    'Μανιπούρι'                                                 => 'mni',
    'Μανξ'                                                           => 'gv',
    'Μαντίνγκο'                                                 => 'man',
    'Μαντουρίζ'                                                 => 'mad',
    'Μαντσού'                                                     => 'mnc',
    'Μαράθι'                                                       => 'mr',
    'Μαργουάρι'                                                 => 'mwr',
    'Μασάι'                                                         => 'mas',
    'Μαϊτχίλι'                                                   => 'mai',
    'Μικμάκ'                                                       => 'mic',
    'Μινανγκαμπάου'                                         => 'min',
    'Μιραντεζικά'                                             => 'mwl',
    'Μογγολικά'                                                 => 'mn',
    'Μολδαβικά'                                                 => 'mo',
    'Μοχόκ'                                                         => 'moh',
    'Μπάντα'                                                       => 'bad',
    'Μπάσα'                                                         => 'bas',
    'Μπέζα'                                                         => 'bej',
    'Μπέμπα'                                                       => 'bem',
    'Μπέρμπερ'                                                   => 'ber',
    'Μπίνι'                                                         => 'bin',
    'Μπαλινίζ'                                                   => 'ban',
    'Μπαλούτσι'                                                 => 'bal',
    'Μπαμπάρα'                                                   => 'bm',
    'Μπαντού'                                                     => 'bnt',
    'Μπασκίρ'                                                     => 'ba',
    'Μπατάκ'                                                       => 'btk',
    'Μπενγκάλι'                                                 => 'bn',
    'Μπικόλ'                                                       => 'bik',
    'Μπισλάμα'                                                   => 'bi',
    'Μπιχάρι'                                                     => 'bh',
    'Μπλιν'                                                         => 'byn',
    'Μποζπούρι'                                                 => 'bho',
    'Μπουγκίζ'                                                   => 'bug',
    'Μπουριάτ'                                                   => 'bua',
    'Μπρατζ'                                                       => 'bra',
    'Μόκσα'                                                         => 'mdf',
    'Μόνγκο'                                                       => 'lol',
    'Μόσι'                                                           => 'mos',
    'ΝΚο'                                                             => 'nqo',
    'Νάβαχο'                                                       => 'nv',
    'Νίας'                                                           => 'nia',
    'Ναούρου'                                                     => 'na',
    'Ναπολιτανικά'                                           => 'nap',
    'Ναχουάτλ'                                                   => 'nah',
    'Νεγουάρι'                                                   => 'new',
    'Νεπάλι'                                                       => 'ne',
    'Νζίμα'                                                         => 'nzi',
    'Νιάντζα'                                                     => 'ny',
    'ΝιάσαΤόνγκα'                                             => 'tog',
    'Νιαμγουέζι'                                               => 'nym',
    'Νιανκόλε'                                                   => 'nyn',
    'ΝιλοΣαχαριανήγλώσσα'                             => 'ssa',
    'Νιούεαν'                                                     => 'niu',
    'Νιόρο'                                                         => 'nyo',
    'Νογκάι'                                                       => 'nog',
    'Νοηματικήγλώσσα'                                     => 'sgn',
    'Νορβηγικά'                                                 => 'no',
    'ΝορβηγικάΜποκμάλ'                                   => 'nb',
    'ΝορβηγικάΝινόρσκ'                                   => 'nn',
    'Ντάργκουα'                                                 => 'dar',
    'Ντέλαγουερ'                                               => 'del',
    'Ντίνκα'                                                       => 'din',
    'Νταγιάκ'                                                     => 'day',
    'Ντακότα'                                                     => 'dak',
    'ΝτεμπέλεΒορρά'                                         => 'nd',
    'ΝτεμπέλεΝότου'                                         => 'nr',
    'Ντζόνγκχα'                                                 => 'dz',
    'Ντιβέχι'                                                     => 'dv',
    'Ντογιούλα'                                                 => 'dyu',
    'Ντουάλα'                                                     => 'dua',
    'Ντόγκρι'                                                     => 'doi',
    'Ντόγκριμπ'                                                 => 'dgr',
    'Ντόνγκα'                                                     => 'ng',
    'ΝότιαΑλαταϊκά'                                         => 'alt',
    'ΝότιαΣάμι'                                                 => 'sma',
    'ΝότιαΣόθο'                                                 => 'st',
    'Οζιβίγουα'                                                 => 'oj',
    'ΟθωμανικάΤουρκικά'                                 => 'ota',
    'Οθωμανικήγλώσσα'                                     => 'oto',
    'Οκσιτανικά'                                               => 'oc',
    'Ολλανδικά'                                                 => 'nl',
    'Ορίγια'                                                       => 'or',
    'Ορόμο'                                                         => 'om',
    'Οσάζ'                                                           => 'osa',
    'Οσετικά'                                                     => 'os',
    'Οστρονέζιαν'                                             => 'map',
    'Ουαλικά'                                                     => 'cy',
    'Ουγγρικά'                                                   => 'hu',
    'Ουγκαρίτικ'                                               => 'uga',
    'Ουζμπεκικά'                                               => 'uz',
    'Ουιγουρικά'                                               => 'ug',
    'Ουκρανικά'                                                 => 'uk',
    'Ουμπούντου'                                               => 'umb',
    'Ουντμούρτ'                                                 => 'udm',
    'Ουρντού'                                                     => 'ur',
    'Πάλι'                                                           => 'pi',
    'Πάστο'                                                         => 'ps',
    'Παλάουαν'                                                   => 'pau',
    'ΠαλαιάΆνωΓερμανικά'                               => 'goh',
    'ΠαλαιάΑγγλικά'                                         => 'ang',
    'ΠαλαιάΓαλλικά'                                         => 'fro',
    'ΠαλαιάΙρλανδικά'                                     => 'sga',
    'ΠαλαιάΝορβηγικά'                                     => 'non',
    'ΠαλαιάΠροβενσιάλ'                                   => 'pro',
    'Παμπάνγκα'                                                 => 'pam',
    'Πανγκασινάν'                                             => 'pag',
    'Παντζαπικά'                                               => 'pa',
    'Παπιαμέντο'                                               => 'pap',
    'Παπούα'                                                       => 'paa',
    'Παχλάβι'                                                     => 'pal',
    'Περσικά'                                                     => 'fa',
    'Πολλαπλέςγλώσσες'                                   => 'mul',
    'Πολωνικά'                                                   => 'pl',
    'Πορτογαλικά'                                             => 'pt',
    'ΠορτογαλικάΒραζιλίας'                           => 'pt_br',
    'ΠορτογαλικάΙβηρικής'                             => 'pt_pt',
    'Ποχπέιαν'                                                   => 'pon',
    'Ραζασθάνι'                                                 => 'raj',
    'Ραπανούι'                                                   => 'rap',
    'Ραροτονγκάν'                                             => 'rar',
    'ΡετοΡομανικά'                                           => 'rm',
    'Ρομανί'                                                       => 'rom',
    'Ρομανικήγλώσσα'                                       => 'roa',
    'Ρουμανικά'                                                 => 'ro',
    'Ρούντι'                                                       => 'rn',
    'Ρωσικά'                                                       => 'ru',
    'Σάνγκο'                                                       => 'sg',
    'Σίντι'                                                         => 'sd',
    'ΣαμαρίτικαΑραμαϊκά'                               => 'sam',
    'Σαμόαν'                                                       => 'sm',
    'Σαν'                                                             => 'shn',
    'Σανσκριτικά'                                             => 'sa',
    'Σαντάγουε'                                                 => 'sad',
    'Σαντάλι'                                                     => 'sat',
    'Σαρδινικά'                                                 => 'sc',
    'Σασάκ'                                                         => 'sas',
    'Σεγιέν'                                                       => 'chy',
    'Σελκούπ'                                                     => 'sel',
    'Σερέρ'                                                         => 'srr',
    'Σερβικά'                                                     => 'sr',
    'Σερβοκροατικά'                                         => 'sh',
    'Σημητικήγλώσσα'                                       => 'sem',
    'Σικελιανά'                                                 => 'scn',
    'ΣικουάνΓι'                                                 => 'ii',
    'Σικσίκα'                                                     => 'bla',
    'Σινοθιβετιανήγλώσσα'                             => 'sit',
    'Σιντάμο'                                                     => 'sid',
    'Σινχαλεζικά'                                             => 'si',
    'ΣκολτΣάμι'                                                 => 'sms',
    'Σκωτικά'                                                     => 'sco',
    'ΣκωτικάΚελτικά'                                       => 'gd',
    'Σλαβικά'                                                     => 'den',
    'Σλαβικήγλώσσα'                                         => 'sla',
    'Σλαβομακεδονικά'                                     => 'mk',
    'Σλοβακικά'                                                 => 'sk',
    'Σλοβενικά'                                                 => 'sl',
    'Σογκντιέν'                                                 => 'sog',
    'Σομάλι'                                                       => 'so',
    'Σονίνκε'                                                     => 'snk',
    'Σονγκχάι'                                                   => 'son',
    'Σουάτι'                                                       => 'ss',
    'Σουαχίλι'                                                   => 'sw',
    'Σουδανικά'                                                 => 'su',
    'Σουηδικά'                                                   => 'sv',
    'Σουκούμα'                                                   => 'suk',
    'Σουμερικά'                                                 => 'sux',
    'Σούσου'                                                       => 'sus',
    'ΣρανάρΤόνγκο'                                           => 'srn',
    'Συριακά'                                                     => 'syr',
    'Σχόνα'                                                         => 'sn',
    'Σύμβολαbliss'                                                => 'zbl',
    'Τέτουμ'                                                       => 'tet',
    'Τίγκρε'                                                       => 'tig',
    'Τίμνε'                                                         => 'tem',
    'Ταγκαλόγκ'                                                 => 'tl',
    'Ταμίλ'                                                         => 'ta',
    'Ταμασέκ'                                                     => 'tmh',
    'Τατάρ'                                                         => 'tt',
    'Τατζίκ'                                                       => 'tg',
    'Ταϊλανδικά'                                               => 'th',
    'Ταϊλανδικήγλώσσα'                                   => 'tai',
    'Ταϊτιανά'                                                   => 'ty',
    'Τελούγκου'                                                 => 'te',
    'Τερένο'                                                       => 'ter',
    'Τεχνητήγλώσσα'                                         => 'art',
    'Τζου'                                                           => 'kaj',
    'Τιβ'                                                             => 'tiv',
    'Τιγκρίνυα'                                                 => 'ti',
    'Τλίνγκιτ'                                                   => 'tli',
    'ΤοκΠισίν'                                                   => 'tpi',
    'Τοκελάου'                                                   => 'tkl',
    'Τουάπ'                                                         => 'kcg',
    'Τουβίνιαν'                                                 => 'tyv',
    'Τουβαλού'                                                   => 'tvl',
    'Τουμπούκα'                                                 => 'tum',
    'Τουρκικά'                                                   => 'tr',
    'ΤουρκικάΚριμαίας'                                   => 'crh',
    'Τουρκμενικά'                                             => 'tk',
    'Τούι'                                                           => 'tw',
    'Τσέτσνιαν'                                                 => 'ce',
    'Τσίμπτσα'                                                   => 'chb',
    'Τσίμσιαν'                                                   => 'tsi',
    'Τσίπιουαν'                                                 => 'chp',
    'Τσαγκατάι'                                                 => 'chg',
    'Τσερόκι'                                                     => 'chr',
    'Τσεχικά'                                                     => 'cs',
    'Τσιγουάνα'                                                 => 'tn',
    'Τσοκτάου'                                                   => 'cho',
    'Τσουκίζι'                                                   => 'chk',
    'Τσόνγκα'                                                     => 'ts',
    'Τόνγκα'                                                       => 'to',
    'Φάντι'                                                         => 'fat',
    'Φίτζι'                                                         => 'fj',
    'Φανγκ'                                                         => 'fan',
    'Φαρόε'                                                         => 'fo',
    'Φιλιππινεζικά'                                         => 'fil',
    'Φιλιππινεζικήγλώσσα'                             => 'phi',
    'Φινλανδικά'                                               => 'fi',
    'ΦιννοΟύγκριαν'                                         => 'fiu',
    'Φλαμανδικά'                                               => 'nl_be',
    'Φοινικικά'                                                 => 'phn',
    'Φον'                                                             => 'fon',
    'Φουλάχ'                                                       => 'ff',
    'Φριούλιαν'                                                 => 'fur',
    'Χάιντα'                                                       => 'hai',
    'Χάουσα'                                                       => 'ha',
    'Χίντι'                                                         => 'hi',
    'ΧίριΜότου'                                                 => 'ho',
    'Χαβανεζικά'                                               => 'haw',
    'Χαμικήγλώσσα'                                           => 'cmc',
    'Χερέρο'                                                       => 'hz',
    'Χιλιγκαγιόν'                                             => 'hil',
    'Χιματσάλι'                                                 => 'him',
    'Χιτίτε'                                                       => 'hit',
    'Χμονγκ'                                                       => 'hmn',
    'Χουβάς'                                                       => 'cv',
    'Χούπα'                                                         => 'hup',
    'Χωρίςγλωσσολογικόπεριεχόμενο'           => 'zxx',
);

1;
