package Locales::DB::Language::vi;

# Auto generated from CLDR

$Locales::DB::Language::vi::VERSION = '0.01';

$Locales::DB::Language::vi::cldr_version = '1.7.1';

%Locales::DB::Language::vi::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Ngôn\ ngữ\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Vùng\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "no\:n",
            'draft'   => 'contributed'
        },
        'yesstr' => {
            'content' => "yes\:y",
            'draft'   => 'contributed'
        }
    },
);

%Locales::DB::Language::vi::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => "Tiếng\ Nam\ Phi",
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => "Tiếng\ Amharic",
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => "Tiếng\ A\-rập",
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => "Tiếng\ Assam",
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => "Tiếng\ Aymara",
    'az'    => "Tiếng\ Ai\-déc\-bai\-gian",
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => "Tiếng\ Bê\-la\-rút",
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => "Tiếng\ Bun\-ga\-ri",
    'bh'    => "Tiếng\ Bihari",
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => "Tiếng\ Bengali\ \(Ấn\ Độ\)",
    'bnt'   => 'Bantu',
    'bo'    => "Tiếng\ Tây\ Tạng",
    'br'    => "Tiếng\ Breton",
    'bra'   => 'Braj',
    'bs'    => "Tiếng\ Nam\ Tư",
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => "Tiếng\ Ca\-ta\-lăng",
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => "Tiếng\ Séc",
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => "Tiếng\ Xentơ",
    'da'    => "Tiếng\ Đan\ Mạch",
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => "Tiếng\ Đức",
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => "Tiếng\ Hy\ Lạp",
    'elx'   => 'Elamite',
    'en'    => "Tiếng\ Anh",
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "Tiếng\ Anh\ \(Anh\)",
    'en_us' => "Tiếng\ Anh\ \(Mỹ\)",
    'enm'   => "Middle\ English",
    'eo'    => "Tiếng\ Quốc\ Tế\ Ngữ",
    'es'    => "Tiếng\ Tây\ Ban\ Nha",
    'es_es' => "Iberian\ Spanish",
    'et'    => "Tiếng\ E\-xtô\-ni\-a",
    'eu'    => "Tiếng\ Basque",
    'ewo'   => 'Ewondo',
    'fa'    => "Tiếng\ Ba\ Tư",
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => "Tiếng\ Phần\ Lan",
    'fil'   => "Tiếng\ Philipin",
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => "Tiếng\ Faore",
    'fon'   => 'Fon',
    'fr'    => "Tiếng\ Pháp",
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Tiếng\ Frisian",
    'ga'    => "Tiếng\ Ai\-len",
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Tiếng\ Xentơ\ \(Xcốt\ len\)",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => "Tiếng\ Galician",
    'gmh'   => "Middle\ High\ German",
    'gn'    => "Tiếng\ Guarani",
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => "Tiếng\ Gujarati",
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => "Tiếng\ Hê\-brơ",
    'hi'    => "Tiếng\ Hin\-đi",
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => "Tiếng\ Crô\-a\-ti\-a",
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => "Tiếng\ Hung\-ga\-ri",
    'hup'   => 'Hupa',
    'hy'    => "Tiếng\ Ác\-mê\-ni",
    'hz'    => 'Herero',
    'ia'    => "Tiếng\ Khoa\ Học\ Quốc\ Tế",
    'iba'   => 'Iban',
    'id'    => "Tiếng\ In\-đô\-nê\-xia",
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => "Tiếng\ Ai\-xơ\-len",
    'it'    => "Tiếng\ Ý",
    'iu'    => 'Inuktitut',
    'ja'    => "Tiếng\ Nhật",
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => "Tiếng\ Gia\-va",
    'ka'    => "Tiếng\ Georgian",
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => "Tiếng\ Campuchia",
    'kmb'   => 'Kimbundu',
    'kn'    => "Tiếng\ Kan\-na\-đa",
    'ko'    => "Tiếng\ Hàn\ Quốc",
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => "Tiếng\ Kashmiri",
    'ku'    => "Tiếng\ Kurd\ \(Iran\)",
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => "Tiếng\ Kyrgyz",
    'la'    => "Tiếng\ La\-tinh",
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => "Tiếng\ Lingala",
    'lo'    => "Tiếng\ Lào",
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => "Tiếng\ Lít\-va",
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => "Tiếng\ Lát\-vi\-a",
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => "Tiếng\ Ma\-xê\-đô\-ni\-a",
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => "Tiếng\ Malayalam",
    'mn'    => "Tiếng\ Mông\ Cổ",
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => "Tiếng\ Marathi",
    'ms'    => "Tiếng\ Ma\-lay\-xi\-a",
    'mt'    => "Tiếng\ Mantơ",
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => "Tiếng\ Nê\-pan",
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => "Tiếng\ Hà\ Lan",
    'nl_be' => 'Flemish',
    'nn'    => "Tiếng\ Na\ Uy\ \(Nynorsk\)",
    'no'    => "Tiếng\ Na\ Uy",
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => "Tiếng\ Occitan",
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => "Tiếng\ Ô\-ri\-a",
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => "Tiếng\ Punjabi",
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => "Tiếng\ Ba\ Lan",
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => "Tiếng\ Pa\-tô",
    'pt'    => "Tiếng\ Bồ\ Đào\ Nha",
    'pt_br' => "Tiếng\ Bồ\ Đào\ Nha\ \(Braxin\)",
    'pt_pt' => "Tiếng\ Bồ\ Đào\ Nha\ \(I\-bê\-ri\)",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Tiếng\ Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => "Tiếng\ Ru\-ma\-ni",
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => "Tiếng\ Nga",
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => "Tiếng\ Phạn",
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => "Tiếng\ Sin\-hi",
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "Tiếng\ Xéc\ bi\ \-\ Croatia",
    'shn'   => 'Shan',
    'si'    => "Tiếng\ Sinhala",
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => "Tiếng\ Xlô\-vác",
    'sl'    => "Tiếng\ Xlô\-ven",
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => "Tiếng\ Xô\-ma\-li",
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => "Tiếng\ An\-ba\-ni",
    'sr'    => "Tiếng\ Séc\-bi",
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => "Tiếng\ Sesotho",
    'su'    => "Tiếng\ Xu\ đăng",
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => "Tiếng\ Thụy\ Điển",
    'sw'    => "Tiếng\ Bantu\ \(Đông\ Phi\)",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => "Tiếng\ Tamil",
    'tai'   => "Tai\ Language",
    'te'    => "Tiếng\ Telugu",
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => "Tiếng\ Thái",
    'ti'    => "Tiếng\ Tigrigya",
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => "Tiếng\ Tuôc\-men",
    'tkl'   => 'Tokelau',
    'tl'    => "Tiếng\ Tagalog",
    'tlh'   => "Tiếng\ Klingon",
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => "Tiếng\ Thổ\ Nhĩ\ Kỳ",
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => "Tiếng\ Twi",
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => "Tiếng\ Uighur",
    'uga'   => 'Ugaritic',
    'uk'    => "Tiếng\ U\-crai\-na",
    'umb'   => 'Umbundu',
    'und'   => 'und',
    'ur'    => "Tiếng\ Uđu",
    'uz'    => "Tiếng\ U\-dơ\-bếch",
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => "Tiếng\ Việt",
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => "Tiếng\ Wolof",
    'xal'   => 'Kalmyk',
    'xh'    => "Tiếng\ Bantu",
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => "Tiếng\ Y\-đit",
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => "Tiếng\ Trung\ Quốc",
    'znd'   => 'Zande',
    'zu'    => "Tiếng\ Zulu",
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::vi::name_to_code = (
    'abkhazian'                           => 'ab',
    'achinese'                            => 'ace',
    'acoli'                               => 'ach',
    'adangme'                             => 'ada',
    'adyghe'                              => 'ady',
    'afar'                                => 'aa',
    'afrihili'                            => 'afh',
    "afroasiatic\ language"               => 'afa',
    'ainu'                                => 'ain',
    'akan'                                => 'ak',
    'akkadian'                            => 'akk',
    'aleut'                               => 'ale',
    "algonquian\ language"                => 'alg',
    "altaic\ language"                    => 'tut',
    "ancient\ egyptian"                   => 'egy',
    "ancient\ greek"                      => 'grc',
    'angika'                              => 'anp',
    "apache\ language"                    => 'apa',
    'aragonese'                           => 'an',
    'aramaic'                             => 'arc',
    'arapaho'                             => 'arp',
    'araucanian'                          => 'arn',
    'arawak'                              => 'arw',
    'aromanian'                           => 'rup',
    "artificial\ language"                => 'art',
    'asturian'                            => 'ast',
    "athapascan\ language"                => 'ath',
    'atsam'                               => 'cch',
    "australian\ english"                 => 'en_au',
    "australian\ language"                => 'aus',
    "austrian\ german"                    => 'de_at',
    "austronesian\ language"              => 'map',
    'avaric'                              => 'av',
    'avestan'                             => 'ae',
    'awadhi'                              => 'awa',
    'balinese'                            => 'ban',
    "baltic\ language"                    => 'bat',
    'baluchi'                             => 'bal',
    'bambara'                             => 'bm',
    "bamileke\ language"                  => 'bai',
    'banda'                               => 'bad',
    'bantu'                               => 'bnt',
    'basa'                                => 'bas',
    'bashkir'                             => 'ba',
    'batak'                               => 'btk',
    'beja'                                => 'bej',
    'bemba'                               => 'bem',
    'berber'                              => 'ber',
    'bhojpuri'                            => 'bho',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'bislama'                             => 'bi',
    'blin'                                => 'byn',
    'blissymbols'                         => 'zbl',
    'braj'                                => 'bra',
    'buginese'                            => 'bug',
    'buriat'                              => 'bua',
    'burmese'                             => 'my',
    'caddo'                               => 'cad',
    "canadian\ english"                   => 'en_ca',
    "canadian\ french"                    => 'fr_ca',
    'carib'                               => 'car',
    "caucasian\ language"                 => 'cau',
    'cebuano'                             => 'ceb',
    "celtic\ language"                    => 'cel',
    "central\ american\ indian\ language" => 'cai',
    'chagatai'                            => 'chg',
    "chamic\ language"                    => 'cmc',
    'chamorro'                            => 'ch',
    'chechen'                             => 'ce',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibcha'                             => 'chb',
    "chinook\ jargon"                     => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    "church\ slavic"                      => 'cu',
    'chuukese'                            => 'chk',
    'chuvash'                             => 'cv',
    "classical\ newari"                   => 'nwc',
    "classical\ syriac"                   => 'syc',
    'coptic'                              => 'cop',
    'cornish'                             => 'kw',
    'corsican'                            => 'co',
    'cree'                                => 'cr',
    'creek'                               => 'mus',
    "creole\ or\ pidgin"                  => 'crp',
    "crimean\ turkish"                    => 'crh',
    "cushitic\ language"                  => 'cus',
    'dakota'                              => 'dak',
    'dargwa'                              => 'dar',
    'dayak'                               => 'day',
    'delaware'                            => 'del',
    'dinka'                               => 'din',
    'divehi'                              => 'dv',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    "dravidian\ language"                 => 'dra',
    'duala'                               => 'dua',
    'dyula'                               => 'dyu',
    'dzongkha'                            => 'dz',
    "eastern\ frisian"                    => 'frs',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamite'                             => 'elx',
    "englishbased\ creole\ or\ pidgin"    => 'cpe',
    'erzya'                               => 'myv',
    'ewe'                                 => 'ee',
    'ewondo'                              => 'ewo',
    'fang'                                => 'fan',
    'fanti'                               => 'fat',
    'fijian'                              => 'fj',
    "finnougrian\ language"               => 'fiu',
    'flemish'                             => 'nl_be',
    'fon'                                 => 'fon',
    "frenchbased\ creole\ or\ pidgin"     => 'cpf',
    'friulian'                            => 'fur',
    'fulah'                               => 'ff',
    'ga'                                  => 'gaa',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'geez'                                => 'gez',
    "germanic\ language"                  => 'gem',
    'gilbertese'                          => 'gil',
    'gondi'                               => 'gon',
    'gorontalo'                           => 'gor',
    'gothic'                              => 'got',
    'grebo'                               => 'grb',
    'gwichin'                             => 'gwi',
    'haida'                               => 'hai',
    'haitian'                             => 'ht',
    'hausa'                               => 'ha',
    'hawaiian'                            => 'haw',
    'herero'                              => 'hz',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    "hiri\ motu"                          => 'ho',
    'hittite'                             => 'hit',
    'hmong'                               => 'hmn',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    "iberian\ spanish"                    => 'es_es',
    'ido'                                 => 'io',
    'igbo'                                => 'ig',
    'ijo'                                 => 'ijo',
    'iloko'                               => 'ilo',
    "inari\ sami"                         => 'smn',
    "indic\ language"                     => 'inc',
    "indoeuropean\ language"              => 'ine',
    'ingush'                              => 'inh',
    'interlingue'                         => 'ie',
    'inuktitut'                           => 'iu',
    'inupiaq'                             => 'ik',
    "iranian\ language"                   => 'ira',
    "iroquoian\ language"                 => 'iro',
    'jju'                                 => 'kaj',
    'judeoarabic'                         => 'jrb',
    'judeopersian'                        => 'jpr',
    'kabardian'                           => 'kbd',
    'kabyle'                              => 'kab',
    'kachin'                              => 'kac',
    'kalaallisut'                         => 'kl',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    'kanuri'                              => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpak'                          => 'kaa',
    'karelian'                            => 'krl',
    'karen'                               => 'kar',
    'kashubian'                           => 'csb',
    'kawi'                                => 'kaw',
    'kazakh'                              => 'kk',
    'khasi'                               => 'kha',
    "khoisan\ language"                   => 'khi',
    'khotanese'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'kinyarwanda'                         => 'rw',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'koro'                                => 'kfo',
    'kosraean'                            => 'kos',
    'kpelle'                              => 'kpe',
    'kru'                                 => 'kro',
    'kuanyama'                            => 'kj',
    'kumyk'                               => 'kum',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'lezghian'                            => 'lez',
    'limburgish'                          => 'li',
    'lojban'                              => 'jbo',
    "low\ german"                         => 'nds',
    "lower\ sorbian"                      => 'dsb',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    "lule\ sami"                          => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'luxembourgish'                       => 'lb',
    'madurese'                            => 'mad',
    'magahi'                              => 'mag',
    'maithili'                            => 'mai',
    'makasar'                             => 'mak',
    'malagasy'                            => 'mg',
    'manchu'                              => 'mnc',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    'manipuri'                            => 'mni',
    "manobo\ language"                    => 'mno',
    'manx'                                => 'gv',
    'maori'                               => 'mi',
    'mari'                                => 'chm',
    'marshallese'                         => 'mh',
    'marwari'                             => 'mwr',
    'masai'                               => 'mas',
    "mayan\ language"                     => 'myn',
    'mende'                               => 'men',
    'micmac'                              => 'mic',
    "middle\ dutch"                       => 'dum',
    "middle\ english"                     => 'enm',
    "middle\ french"                      => 'frm',
    "middle\ high\ german"                => 'gmh',
    "middle\ irish"                       => 'mga',
    'minangkabau'                         => 'min',
    'mirandese'                           => 'mwl',
    "miscellaneous\ language"             => 'mis',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'moldavian'                           => 'mo',
    'mongo'                               => 'lol',
    "monkhmer\ language"                  => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    "multiple\ languages"                 => 'mul',
    "munda\ language"                     => 'mun',
    'nahuatl'                             => 'nah',
    'nauru'                               => 'na',
    'navajo'                              => 'nv',
    'ndonga'                              => 'ng',
    'neapolitan'                          => 'nap',
    'newari'                              => 'new',
    'nias'                                => 'nia',
    "nigerkordofanian\ language"          => 'nic',
    "nilosaharan\ language"               => 'ssa',
    'niuean'                              => 'niu',
    'nko'                                 => 'nqo',
    "no\ linguistic\ content"             => 'zxx',
    'nogai'                               => 'nog',
    "north\ american\ indian\ language"   => 'nai',
    "north\ ndebele"                      => 'nd',
    "northern\ frisian"                   => 'frr',
    "northern\ sami"                      => 'se',
    "northern\ sotho"                     => 'nso',
    "norwegian\ bokml"                    => 'nb',
    "nubian\ language"                    => 'nub',
    'nyamwezi'                            => 'nym',
    'nyanja'                              => 'ny',
    'nyankole'                            => 'nyn',
    "nyasa\ tonga"                        => 'tog',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'ojibwa'                              => 'oj',
    "old\ english"                        => 'ang',
    "old\ french"                         => 'fro',
    "old\ high\ german"                   => 'goh',
    "old\ irish"                          => 'sga',
    "old\ norse"                          => 'non',
    "old\ persian"                        => 'peo',
    "old\ provenal"                       => 'pro',
    'oromo'                               => 'om',
    'osage'                               => 'osa',
    'ossetic'                             => 'os',
    "otomian\ language"                   => 'oto',
    "ottoman\ turkish"                    => 'ota',
    'pahlavi'                             => 'pal',
    'palauan'                             => 'pau',
    'pali'                                => 'pi',
    'pampanga'                            => 'pam',
    'pangasinan'                          => 'pag',
    'papiamento'                          => 'pap',
    "papuan\ language"                    => 'paa',
    "philippine\ language"                => 'phi',
    'phoenician'                          => 'phn',
    'pohnpeian'                           => 'pon',
    "portuguesebased\ creole\ or\ pidgin" => 'cpp',
    "prakrit\ language"                   => 'pra',
    'quechua'                             => 'qu',
    'rajasthani'                          => 'raj',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    "romance\ language"                   => 'roa',
    'romany'                              => 'rom',
    'rundi'                               => 'rn',
    "salishan\ language"                  => 'sal',
    "samaritan\ aramaic"                  => 'sam',
    "sami\ language"                      => 'smi',
    'samoan'                              => 'sm',
    'sandawe'                             => 'sad',
    'sango'                               => 'sg',
    'santali'                             => 'sat',
    'sardinian'                           => 'sc',
    'sasak'                               => 'sas',
    'scots'                               => 'sco',
    'selkup'                              => 'sel',
    "semitic\ language"                   => 'sem',
    'serer'                               => 'srr',
    'shan'                                => 'shn',
    'shona'                               => 'sn',
    "sichuan\ yi"                         => 'ii',
    'sicilian'                            => 'scn',
    'sidamo'                              => 'sid',
    "sign\ language"                      => 'sgn',
    'siksika'                             => 'bla',
    "sinotibetan\ language"               => 'sit',
    "siouan\ language"                    => 'sio',
    "skolt\ sami"                         => 'sms',
    'slave'                               => 'den',
    "slavic\ language"                    => 'sla',
    'sogdien'                             => 'sog',
    'songhai'                             => 'son',
    'soninke'                             => 'snk',
    "sorbian\ language"                   => 'wen',
    "south\ american\ indian\ language"   => 'sai',
    "south\ ndebele"                      => 'nr',
    "southern\ altai"                     => 'alt',
    "southern\ sami"                      => 'sma',
    "sranan\ tongo"                       => 'srn',
    'sukuma'                              => 'suk',
    'sumerian'                            => 'sux',
    'susu'                                => 'sus',
    'swati'                               => 'ss',
    "swiss\ french"                       => 'fr_ch',
    "swiss\ german"                       => 'gsw',
    "swiss\ high\ german"                 => 'de_ch',
    'syriac'                              => 'syr',
    'tahitian'                            => 'ty',
    "tai\ language"                       => 'tai',
    'tajik'                               => 'tg',
    'tamashek'                            => 'tmh',
    'taroko'                              => 'trv',
    'tatar'                               => 'tt',
    'tereno'                              => 'ter',
    'tetum'                               => 'tet',
    'tigre'                               => 'tig',
    'timne'                               => 'tem',
    "ting\ "                              => 'it',
    "ting\ aidcbaigian"                   => 'az',
    "ting\ ailen"                         => 'ga',
    "ting\ aixlen"                        => 'is',
    "ting\ amharic"                       => 'am',
    "ting\ an\ mch"                       => 'da',
    "ting\ anbani"                        => 'sq',
    "ting\ anh"                           => 'en',
    "ting\ anh\ anh"                      => 'en_gb',
    "ting\ anh\ m"                        => 'en_us',
    "ting\ arp"                           => 'ar',
    "ting\ assam"                         => 'as',
    "ting\ aymara"                        => 'ay',
    "ting\ b\ o\ nha"                     => 'pt',
    "ting\ b\ o\ nha\ braxin"             => 'pt_br',
    "ting\ b\ o\ nha\ ibri"               => 'pt_pt',
    "ting\ ba\ lan"                       => 'pl',
    "ting\ ba\ t"                         => 'fa',
    "ting\ bantu"                         => 'xh',
    "ting\ bantu\ ng\ phi"                => 'sw',
    "ting\ basque"                        => 'eu',
    "ting\ bengali\ n\ "                  => 'bn',
    "ting\ bihari"                        => 'bh',
    "ting\ blart"                         => 'be',
    "ting\ breton"                        => 'br',
    "ting\ bungari"                       => 'bg',
    "ting\ c"                             => 'de',
    "ting\ campuchia"                     => 'km',
    "ting\ catalng"                       => 'ca',
    "ting\ cmni"                          => 'hy',
    "ting\ cratia"                        => 'hr',
    "ting\ extnia"                        => 'et',
    "ting\ faore"                         => 'fo',
    "ting\ frisian"                       => 'fy',
    "ting\ galician"                      => 'gl',
    "ting\ georgian"                      => 'ka',
    "ting\ giava"                         => 'jv',
    "ting\ guarani"                       => 'gn',
    "ting\ gujarati"                      => 'gu',
    "ting\ h\ lan"                        => 'nl',
    "ting\ hbr"                           => 'he',
    "ting\ hini"                          => 'hi',
    "ting\ hn\ quc"                       => 'ko',
    "ting\ hunggari"                      => 'hu',
    "ting\ hy\ lp"                        => 'el',
    "ting\ innxia"                        => 'id',
    "ting\ kannaa"                        => 'kn',
    "ting\ kashmiri"                      => 'ks',
    "ting\ khoa\ hc\ quc\ t"              => 'ia',
    "ting\ klingon"                       => 'tlh',
    "ting\ kurd\ iran"                    => 'ku',
    "ting\ kyrgyz"                        => 'ky',
    "ting\ latinh"                        => 'la',
    "ting\ lingala"                       => 'ln',
    "ting\ lo"                            => 'lo',
    "ting\ ltva"                          => 'lt',
    "ting\ ltvia"                         => 'lv',
    "ting\ malayalam"                     => 'ml',
    "ting\ malayxia"                      => 'ms',
    "ting\ mant"                          => 'mt',
    "ting\ marathi"                       => 'mr',
    "ting\ maxnia"                        => 'mk',
    "ting\ mng\ c"                        => 'mn',
    "ting\ na\ uy"                        => 'no',
    "ting\ na\ uy\ nynorsk"               => 'nn',
    "ting\ nam\ phi"                      => 'af',
    "ting\ nam\ t"                        => 'bs',
    "ting\ nga"                           => 'ru',
    "ting\ nht"                           => 'ja',
    "ting\ npan"                          => 'ne',
    "ting\ occitan"                       => 'oc',
    "ting\ pat"                           => 'ps',
    "ting\ philipin"                      => 'fil',
    "ting\ phn"                           => 'sa',
    "ting\ phn\ lan"                      => 'fi',
    "ting\ php"                           => 'fr',
    "ting\ punjabi"                       => 'pa',
    "ting\ quc\ t\ ng"                    => 'eo',
    "ting\ rhaetoromance"                 => 'rm',
    "ting\ ria"                           => 'or',
    "ting\ rumani"                        => 'ro',
    "ting\ sc"                            => 'cs',
    "ting\ scbi"                          => 'sr',
    "ting\ sesotho"                       => 'st',
    "ting\ sinhala"                       => 'si',
    "ting\ sinhi"                         => 'sd',
    "ting\ tagalog"                       => 'tl',
    "ting\ tamil"                         => 'ta',
    "ting\ telugu"                        => 'te',
    "ting\ th\ nh\ k"                     => 'tr',
    "ting\ thi"                           => 'th',
    "ting\ thy\ in"                       => 'sv',
    "ting\ tigrigya"                      => 'ti',
    "ting\ trung\ quc"                    => 'zh',
    "ting\ tucmen"                        => 'tk',
    "ting\ twi"                           => 'tw',
    "ting\ ty\ ban\ nha"                  => 'es',
    "ting\ ty\ tng"                       => 'bo',
    "ting\ ucraina"                       => 'uk',
    "ting\ udbch"                         => 'uz',
    "ting\ uighur"                        => 'ug',
    "ting\ uu"                            => 'ur',
    "ting\ vit"                           => 'vi',
    "ting\ wolof"                         => 'wo',
    "ting\ xc\ bi\ \ croatia"             => 'sh',
    "ting\ xent"                          => 'cy',
    "ting\ xent\ xct\ len"                => 'gd',
    "ting\ xlvc"                          => 'sk',
    "ting\ xlven"                         => 'sl',
    "ting\ xmali"                         => 'so',
    "ting\ xu\ ng"                        => 'su',
    "ting\ yit"                           => 'yi',
    "ting\ zulu"                          => 'zu',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    "tok\ pisin"                          => 'tpi',
    'tokelau'                             => 'tkl',
    'tonga'                               => 'to',
    'tsimshian'                           => 'tsi',
    'tsonga'                              => 'ts',
    'tswana'                              => 'tn',
    'tumbuka'                             => 'tum',
    "tupi\ language"                      => 'tup',
    'tuvalu'                              => 'tvl',
    'tuvinian'                            => 'tyv',
    'tyap'                                => 'kcg',
    'udmurt'                              => 'udm',
    'ugaritic'                            => 'uga',
    'umbundu'                             => 'umb',
    'und'                                 => 'und',
    "upper\ sorbian"                      => 'hsb',
    'vai'                                 => 'vai',
    'venda'                               => 've',
    'volapk'                              => 'vo',
    'votic'                               => 'vot',
    "wakashan\ language"                  => 'wak',
    'walamo'                              => 'wal',
    'walloon'                             => 'wa',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'yakut'                               => 'sah',
    'yao'                                 => 'yao',
    'yapese'                              => 'yap',
    'yoruba'                              => 'yo',
    "yupik\ language"                     => 'ypk',
    'zande'                               => 'znd',
    'zapotec'                             => 'zap',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    'zhuang'                              => 'za',
    'zuni'                                => 'zun',
);

1;
