package Locales::DB::Language::sl;

# Auto generated from CLDR

$Locales::DB::Language::sl::VERSION = '0.01';

$Locales::DB::Language::sl::cldr_version = '1.7.1';

%Locales::DB::Language::sl::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Jezik\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Regija\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "ne\:n",
        'yesstr' => "da\:d"
    },
);

%Locales::DB::Language::sl::code_to_name = (
    'aa'    => 'afarščina',
    'ab'    => 'abhaščina',
    'ace'   => 'ačejščina',
    'ach'   => 'ačolijščina',
    'ada'   => 'adangmejščina',
    'ady'   => 'adigejščina',
    'ae'    => 'avestijščina',
    'af'    => 'afrikanščina',
    'afa'   => "afroazijski\ jezik",
    'afh'   => 'afrihili',
    'ain'   => 'ainujščina',
    'ak'    => 'akanščina',
    'akk'   => 'akadščina',
    'ale'   => 'aleutščina',
    'alg'   => "algonkinski\ jezik",
    'alt'   => "južna\ altajščina",
    'am'    => 'amharščina',
    'an'    => 'aragonščina',
    'ang'   => "stara\ angleščina",
    'anp'   => 'angikaščina',
    'apa'   => "apaški\ jezik",
    'ar'    => 'arabščina',
    'arc'   => 'aramejščina',
    'arn'   => 'aravkanščina',
    'arp'   => 'arapaščina',
    'art'   => "umetni\ jezik",
    'arw'   => 'aravaščina',
    'as'    => 'asamščina',
    'ast'   => 'asturijščina',
    'ath'   => "atabaški\ jezik",
    'aus'   => "avstralski\ jezik",
    'av'    => 'avarščina',
    'awa'   => 'avadščina',
    'ay'    => 'ajmarščina',
    'az'    => 'azerbajdžanščina',
    'ba'    => 'baškirščina',
    'bad'   => "bandaški\ jezik",
    'bai'   => "bamilekejski\ jezik",
    'bal'   => 'beludžijščina',
    'ban'   => 'balijščina',
    'bas'   => 'basa',
    'bat'   => "baltski\ jezik",
    'be'    => 'beloruščina',
    'bej'   => 'bedža',
    'bem'   => 'bemba',
    'ber'   => 'berberščina',
    'bg'    => 'bolgarščina',
    'bh'    => 'biharščina',
    'bho'   => 'bodžpuri',
    'bi'    => 'bislamščina',
    'bik'   => "bikolski\ jezik",
    'bin'   => 'edo',
    'bla'   => 'siksika',
    'bm'    => 'bambarščina',
    'bn'    => 'bengalščina',
    'bnt'   => 'bantujščina',
    'bo'    => 'tibetanščina',
    'br'    => 'bretonščina',
    'bra'   => 'bradžbakanščina',
    'bs'    => 'bosanščina',
    'btk'   => "bataški\ jezik",
    'bua'   => 'burjatščina',
    'bug'   => 'buginščina',
    'byn'   => 'blinščina',
    'ca'    => 'katalonščina',
    'cad'   => 'kadoščina',
    'cai'   => "srednjeameriški\ indijanski\ jezik",
    'car'   => "karibski\ jezik",
    'cau'   => "kavkaški\ jezik",
    'cch'   => 'Atsam',
    'ce'    => 'čečenščina',
    'ceb'   => 'sebuanščina',
    'cel'   => "keltski\ jezik",
    'ch'    => 'čamorščina',
    'chb'   => 'čibčevščina',
    'chg'   => 'čagatajščina',
    'chk'   => 'trukeščina',
    'chm'   => 'marijščina',
    'chn'   => "činuški\ žargon",
    'cho'   => 'čoktavščina',
    'chp'   => 'čipevščina',
    'chr'   => 'čerokeščina',
    'chy'   => 'čejenščina',
    'cmc'   => "camski\ jezik",
    'co'    => 'korziščina',
    'cop'   => 'koptščina',
    'cpe'   => "angleška\ kreolščina\ ali\ pidžinščina",
    'cpf'   => "francoska\ kreolščina\ ali\ pidžinščina",
    'cpp'   => "portugalska\ kreolščina\ ali\ pidžinščina",
    'cr'    => 'krijščina',
    'crh'   => "krimska\ tatarščina",
    'crp'   => "kreolščina\ ali\ pidžinščina",
    'cs'    => 'češčina',
    'csb'   => 'kašubščina',
    'cu'    => "stara\ cerkvena\ slovanščina",
    'cus'   => 'kušitščina',
    'cv'    => 'čuvaščina',
    'cy'    => 'valižanščina',
    'da'    => 'danščina',
    'dak'   => 'dakotščina',
    'dar'   => 'darginščina',
    'day'   => 'dajaščina',
    'de'    => 'nemščina',
    'de_at' => "Austrian\ German",
    'de_ch' => "visoka\ nemščina\ \(Švica\)",
    'del'   => 'delavarščina',
    'den'   => 'slavejščina',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => 'dogri',
    'dra'   => "dravidski\ jezik",
    'dsb'   => "dolnja\ lužiška\ srbščina",
    'dua'   => 'duala',
    'dum'   => "srednja\ nizozemščina",
    'dv'    => 'diveščina',
    'dyu'   => 'diula',
    'dz'    => 'dzonka',
    'ee'    => 'evenščina',
    'efi'   => 'efiščina',
    'egy'   => "stara\ egipčanščina",
    'eka'   => 'ekajuk',
    'el'    => 'grščina',
    'elx'   => 'elamščina',
    'en'    => 'angleščina',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "angleščina\ \(VB\)",
    'en_us' => "angleščina\ \(ZDA\)",
    'enm'   => "srednja\ angleščina",
    'eo'    => 'esperanto',
    'es'    => 'španščina',
    'es_es' => "iberska\ španščina",
    'et'    => 'estonščina',
    'eu'    => 'baskovščina',
    'ewo'   => 'evondovščina',
    'fa'    => 'perzijščina',
    'fan'   => 'fangijščina',
    'fat'   => 'fantijščina',
    'ff'    => 'fulščina',
    'fi'    => 'finščina',
    'fil'   => 'filipinščina',
    'fiu'   => "ugrofinski\ jezik",
    'fj'    => 'fidžijščina',
    'fo'    => 'ferščina',
    'fon'   => 'fonščina',
    'fr'    => 'francoščina',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "srednja\ francoščina",
    'fro'   => "stara\ francoščina",
    'frr'   => "severna\ frizijščina",
    'frs'   => "vzhodna\ frizijščina",
    'fur'   => 'furlanščina',
    'fy'    => 'frizijščina',
    'ga'    => 'irščina',
    'gaa'   => 'ga',
    'gay'   => 'gajščina',
    'gba'   => 'gbajščina',
    'gd'    => "škotska\ gelščina",
    'gem'   => "germanski\ jezik",
    'gez'   => 'etiopščina',
    'gil'   => 'kiribatščina',
    'gl'    => 'galicijščina',
    'gmh'   => "srednja\ visoka\ nemščina",
    'gn'    => 'gvaranijščina',
    'goh'   => "stara\ visoka\ nemščina",
    'gon'   => 'gondi',
    'gor'   => 'gorontalščina',
    'got'   => 'gotščina',
    'grb'   => 'grebščina',
    'grc'   => "stara\ grščina",
    'gsw'   => "nemščina\ \(Švica\)",
    'gu'    => 'gudžaratščina',
    'gv'    => 'manščina',
    'gwi'   => 'gwi',
    'ha'    => 'havščina',
    'hai'   => 'haidščina',
    'haw'   => 'havajščina',
    'he'    => 'hebrejščina',
    'hi'    => 'hindujščina',
    'hil'   => 'hiligajnonščina',
    'him'   => 'himačalščina',
    'hit'   => 'hetitščina',
    'hmn'   => 'hmonščina',
    'ho'    => "hiri\ motu",
    'hr'    => 'hrvaščina',
    'hsb'   => "gornja\ lužiška\ srbščina",
    'ht'    => "haitijska\ kreolščina",
    'hu'    => 'madžarščina',
    'hup'   => 'hupa',
    'hy'    => 'armenščina',
    'hz'    => 'herero',
    'ia'    => 'interlingva',
    'iba'   => 'ibanščina',
    'id'    => 'indonezijščina',
    'ie'    => 'interlingve',
    'ig'    => 'igboščina',
    'ii'    => 'ii',
    'ijo'   => 'ijo',
    'ik'    => 'inupiaščina',
    'ilo'   => 'ilokanščina',
    'inc'   => "indijski\ jezik",
    'ine'   => "indoevropski\ jezik",
    'inh'   => 'inguščina',
    'io'    => 'ido',
    'ira'   => "iranski\ jezik",
    'iro'   => "irokeški\ jezik",
    'is'    => 'islandščina',
    'it'    => 'italijanščina',
    'iu'    => 'inuktitutščina',
    'ja'    => 'japonščina',
    'jbo'   => 'lojban',
    'jpr'   => "judovska\ perzijščina",
    'jrb'   => "judovska\ arabščina",
    'jv'    => 'javanščina',
    'ka'    => 'gruzinščina',
    'kaa'   => 'karakalpaščina',
    'kab'   => 'kabilščina',
    'kac'   => 'kačinščina',
    'kaj'   => 'kaj',
    'kam'   => 'kamba',
    'kar'   => 'karenščina',
    'kaw'   => 'kavi',
    'kbd'   => 'kabardinščina',
    'kcg'   => "tjapska\ nigerijščina",
    'kfo'   => 'kfo',
    'kg'    => 'kongovščina',
    'kha'   => 'kasi',
    'khi'   => "koisanski\ jezik",
    'kho'   => 'kotanščina',
    'ki'    => 'kikujščina',
    'kj'    => 'kvanjama',
    'kk'    => 'kazaščina',
    'kl'    => 'grenlandščina',
    'km'    => 'kmerščina',
    'kmb'   => 'kimbundu',
    'kn'    => 'kanada',
    'ko'    => 'korejščina',
    'kok'   => 'konkanščina',
    'kos'   => 'kosrajščina',
    'kpe'   => 'kpelejščina',
    'kr'    => 'kanurščina',
    'krc'   => "karačaj\-balkarščina",
    'krl'   => 'karelščina',
    'kro'   => "jezik\ kru",
    'kru'   => 'kuruk',
    'ks'    => 'kašmirščina',
    'ku'    => 'kurdščina',
    'kum'   => 'kumiščina',
    'kut'   => 'kutenajščina',
    'kv'    => 'komijščina',
    'kw'    => 'kornijščina',
    'ky'    => 'kirgiščina',
    'la'    => 'latinščina',
    'lad'   => 'ladinščina',
    'lah'   => 'landa',
    'lam'   => 'lamba',
    'lb'    => 'luksemburščina',
    'lez'   => 'lezginščina',
    'lg'    => 'ganda',
    'li'    => 'limburščina',
    'ln'    => 'lingala',
    'lo'    => 'laoščina',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'litovščina',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luisenščina',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'lv'    => 'latvijščina',
    'mad'   => 'madurščina',
    'mag'   => 'magadščina',
    'mai'   => 'maitili',
    'mak'   => 'makasarščina',
    'man'   => 'mandingo',
    'map'   => "avstronezijski\ jezik",
    'mas'   => 'masajščina',
    'mdf'   => 'mokšavščina',
    'mdr'   => 'mandarščina',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagaščina',
    'mga'   => "srednja\ irščina",
    'mh'    => 'marshallovščina',
    'mi'    => 'maorščina',
    'mic'   => 'mikmaščina',
    'min'   => 'minangkabau',
    'mis'   => "drugi\ jeziki",
    'mk'    => 'makedonščina',
    'mkh'   => "monsko\-kmerski\ jezik",
    'ml'    => 'malajalamščina',
    'mn'    => 'mongolščina',
    'mnc'   => 'mandžurščina',
    'mni'   => 'manipurščina',
    'mno'   => "kotabatski\ manobo",
    'mo'    => 'moldavščina',
    'moh'   => 'mohoščina',
    'mos'   => 'mosijščina',
    'mr'    => 'maratščina',
    'ms'    => 'malajščina',
    'mt'    => 'malteščina',
    'mul'   => "več\ jezikov",
    'mun'   => "mundski\ jezik",
    'mus'   => 'mus',
    'mwl'   => 'mirandeščina',
    'mwr'   => 'marvarščina',
    'my'    => 'burmanščina',
    'myn'   => "majevski\ jezik",
    'myv'   => 'erzjanščina',
    'na'    => 'naurujščina',
    'nah'   => 'nahuatl',
    'nai'   => "severnoameriški\ indijanski\ jezik",
    'nap'   => 'napolitanščina',
    'nb'    => "knjižna\ norveščina",
    'nd'    => "severna\ ndebelščina",
    'nds'   => "nizka\ nemščina",
    'ne'    => 'nepalščina',
    'new'   => 'nevarščina',
    'ng'    => 'ng',
    'nia'   => 'niaščina',
    'nic'   => "nigrsko\-kordofanski\ jezik",
    'niu'   => 'niuejščina',
    'nl'    => 'nizozemščina',
    'nl_be' => 'flamščina',
    'nn'    => 'novonorveščina',
    'no'    => 'norveščina',
    'nog'   => 'nogajščina',
    'non'   => "stara\ nordijščina",
    'nqo'   => 'nqo',
    'nr'    => "južna\ ndebelščina",
    'nso'   => "severna\ sotščina",
    'nub'   => "nubijski\ jezik",
    'nv'    => 'navajščina',
    'nwc'   => "klasična\ nevarščina",
    'ny'    => 'njanščina',
    'nym'   => 'njamveščina',
    'nyn'   => 'njankole',
    'nyo'   => 'njoro',
    'nzi'   => 'nzima',
    'oc'    => 'okcitanščina',
    'oj'    => 'anašinabščina',
    'om'    => 'oromo',
    'or'    => 'orijščina',
    'os'    => 'osetinščina',
    'osa'   => 'osage',
    'ota'   => "otomanska\ turščina",
    'oto'   => "otomijski\ jezik",
    'pa'    => 'pandžabščina',
    'paa'   => "papuanski\ jezik",
    'pag'   => 'pangasinanščina',
    'pal'   => 'pal',
    'pam'   => 'pampanščina',
    'pap'   => 'papiamentu',
    'pau'   => 'palavanščina',
    'peo'   => "stara\ perzijščina",
    'phi'   => "filipinski\ jezik",
    'phn'   => 'feničanščina',
    'pi'    => 'palijščina',
    'pl'    => 'poljščina',
    'pon'   => 'ponpejščina',
    'pra'   => "prakritski\ jezik",
    'pro'   => "stara\ provansalščina",
    'ps'    => 'paštu',
    'pt'    => 'portugalščina',
    'pt_br' => "brazilska\ portugalščina",
    'pt_pt' => "iberska\ portugalščina",
    'qu'    => 'kečuanščina',
    'raj'   => 'radžastanščina',
    'rap'   => 'rapanujščina',
    'rar'   => 'rarotongščina',
    'rm'    => 'retoromanščina',
    'rn'    => 'rundščina',
    'ro'    => 'romunščina',
    'roa'   => "romanski\ jezik",
    'rom'   => 'romščina',
    'ru'    => 'ruščina',
    'rup'   => 'aromunščina',
    'rw'    => 'ruandščina',
    'sa'    => 'sanskrt',
    'sad'   => 'sad',
    'sah'   => 'jakutščina',
    'sai'   => 'sai',
    'sal'   => 'sal',
    'sam'   => "samaritanska\ aramejščina",
    'sas'   => 'sasaščina',
    'sat'   => 'santalščina',
    'sc'    => 'sardinščina',
    'scn'   => 'sicilijanščina',
    'sco'   => 'škotščina',
    'sd'    => 'sindščina',
    'se'    => "severna\ samijščina",
    'sel'   => 'selkupščina',
    'sem'   => "semitski\ jezik",
    'sg'    => 'sango',
    'sga'   => "stara\ irščina",
    'sgn'   => "znakovni\ jezik",
    'sh'    => 'srbohrvaščina',
    'shn'   => 'šanščina',
    'si'    => 'singalščina',
    'sid'   => 'sidamščina',
    'sio'   => 'sijuščina',
    'sit'   => "kitajsko\-tibetanski\ jezik",
    'sk'    => 'slovaščina',
    'sl'    => 'slovenščina',
    'sla'   => "slovanski\ jezik",
    'sm'    => 'samoanščina',
    'sma'   => "južna\ samijščina",
    'smi'   => "samijski\ jezik",
    'smj'   => "luleška\ samijščina",
    'smn'   => "inarska\ samijščina",
    'sms'   => "samijščina\ Skolt",
    'sn'    => 'šonščina',
    'snk'   => 'snk',
    'so'    => 'somalščina',
    'sog'   => 'sog',
    'son'   => 'songajščina',
    'sq'    => 'albanščina',
    'sr'    => 'srbščina',
    'srn'   => "surinamska\ kreolščina",
    'srr'   => 'sererščina',
    'ss'    => 'svazijščina',
    'ssa'   => "nilsko\-saharski\ jezik",
    'st'    => 'sesoto',
    'su'    => 'sundanščina',
    'suk'   => 'sukuma',
    'sus'   => 'susujščina',
    'sux'   => 'sumerščina',
    'sv'    => 'švedščina',
    'sw'    => 'svahili',
    'syc'   => "klasična\ sirščina",
    'syr'   => 'sirščina',
    'ta'    => 'tamilščina',
    'tai'   => "tajski\ jezik",
    'te'    => 'telugijščina',
    'tem'   => 'temnejščina',
    'ter'   => 'ter',
    'tet'   => 'tetumščina',
    'tg'    => 'tadžiščina',
    'th'    => 'tajščina',
    'ti'    => 'tigrajščina',
    'tig'   => "tigrejski\ jezik",
    'tiv'   => 'tivščina',
    'tk'    => 'turkmenščina',
    'tkl'   => 'tokelavščina',
    'tl'    => 'tagalogščina',
    'tlh'   => 'klingonščina',
    'tli'   => 'tlingitščina',
    'tmh'   => 'tamajaščina',
    'tn'    => 'cvanščina',
    'to'    => 'tongščina',
    'tog'   => "malavijska\ tongščina",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turščina',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimščina',
    'tt'    => 'tatarščina',
    'tum'   => 'tumbukščina',
    'tup'   => "tupijski\ jezik",
    'tut'   => "altajski\ jezik",
    'tvl'   => 'tuvalujščina',
    'tw'    => 'tvi',
    'ty'    => 'tahitščina',
    'tyv'   => 'tuvinščina',
    'udm'   => 'udmurtščina',
    'ug'    => 'ujgurščina',
    'uga'   => "ugaritski\ jezik",
    'uk'    => 'ukrajinščina',
    'umb'   => 'umbundščina',
    'und'   => "neznan\ ali\ neveljaven\ jezik",
    'ur'    => 'urdujščina',
    'uz'    => 'uzbeščina',
    'vai'   => 'vajščina',
    've'    => 'venda',
    'vi'    => 'vietnamščina',
    'vo'    => 'volapuk',
    'vot'   => 'votjaščina',
    'wa'    => 'valonščina',
    'wak'   => "vakaški\ jezik",
    'wal'   => 'valamščina',
    'war'   => 'varajščina',
    'was'   => 'vašajščina',
    'wen'   => "lužiško\ srbski\ jezik",
    'wo'    => 'volofščina',
    'xal'   => 'kalmiščina',
    'xh'    => 'xhosa',
    'yao'   => 'jaojščina',
    'yap'   => 'japščina',
    'yi'    => 'jidiš',
    'yo'    => 'jorubščina',
    'ypk'   => "jupiški\ jezik",
    'za'    => 'za',
    'zap'   => 'zapoteščina',
    'zbl'   => "znakovni\ jezik\ Bliss",
    'zen'   => 'zenaščina',
    'zh'    => 'kitajščina',
    'znd'   => 'zandejščina',
    'zu'    => 'zulujščina',
    'zun'   => 'zunijščina',
    'zxx'   => "brez\ jezikoslovne\ vsebine",
    'zza'   => 'zazajščina',
);

%Locales::DB::Language::sl::name_to_code = (
    'abhaina'                              => 'ab',
    'adangmejina'                          => 'ada',
    'adigejina'                            => 'ady',
    'aejina'                               => 'ace',
    'afarina'                              => 'aa',
    'afrihili'                             => 'afh',
    'afrikanina'                           => 'af',
    "afroazijski\ jezik"                   => 'afa',
    'agatajina'                            => 'chg',
    'ainujina'                             => 'ain',
    'ajmarina'                             => 'ay',
    'akadina'                              => 'akk',
    'akanina'                              => 'ak',
    'albanina'                             => 'sq',
    'aleutina'                             => 'ale',
    "algonkinski\ jezik"                   => 'alg',
    "altajski\ jezik"                      => 'tut',
    'amharina'                             => 'am',
    'amorina'                              => 'ch',
    'anainabina'                           => 'oj',
    'angikaina'                            => 'anp',
    'angleina'                             => 'en',
    "angleina\ vb"                         => 'en_gb',
    "angleina\ zda"                        => 'en_us',
    "angleka\ kreolina\ ali\ pidinina"     => 'cpe',
    'anina'                                => 'shn',
    'aolijina'                             => 'ach',
    "apaki\ jezik"                         => 'apa',
    'arabina'                              => 'ar',
    'aragonina'                            => 'an',
    'aramejina'                            => 'arc',
    'arapaina'                             => 'arp',
    'aravaina'                             => 'arw',
    'aravkanina'                           => 'arn',
    'armenina'                             => 'hy',
    'aromunina'                            => 'rup',
    'asamina'                              => 'as',
    'asturijina'                           => 'ast',
    "atabaki\ jezik"                       => 'ath',
    'atsam'                                => 'cch',
    "australian\ english"                  => 'en_au',
    "austrian\ german"                     => 'de_at',
    'avadina'                              => 'awa',
    'avarina'                              => 'av',
    'avestijina'                           => 'ae',
    "avstralski\ jezik"                    => 'aus',
    "avstronezijski\ jezik"                => 'map',
    'azerbajdanina'                        => 'az',
    'bakirina'                             => 'ba',
    'balijina'                             => 'ban',
    "baltski\ jezik"                       => 'bat',
    'bambarina'                            => 'bm',
    "bamilekejski\ jezik"                  => 'bai',
    "bandaki\ jezik"                       => 'bad',
    'bantujina'                            => 'bnt',
    'basa'                                 => 'bas',
    'baskovina'                            => 'eu',
    "bataki\ jezik"                        => 'btk',
    'beda'                                 => 'bej',
    'beloruina'                            => 'be',
    'beludijina'                           => 'bal',
    'bemba'                                => 'bem',
    'bengalina'                            => 'bn',
    'berberina'                            => 'ber',
    'biharina'                             => 'bh',
    "bikolski\ jezik"                      => 'bik',
    'bislamina'                            => 'bi',
    'blinina'                              => 'byn',
    'bodpuri'                              => 'bho',
    'bolgarina'                            => 'bg',
    'bosanina'                             => 'bs',
    'bradbakanina'                         => 'bra',
    "brazilska\ portugalina"               => 'pt_br',
    'bretonina'                            => 'br',
    "brez\ jezikoslovne\ vsebine"          => 'zxx',
    'buginina'                             => 'bug',
    'burjatina'                            => 'bua',
    'burmanina'                            => 'my',
    "camski\ jezik"                        => 'cmc',
    "canadian\ english"                    => 'en_ca',
    "canadian\ french"                     => 'fr_ca',
    'cvanina'                              => 'tn',
    'dajaina'                              => 'day',
    'dakotina'                             => 'dak',
    'danina'                               => 'da',
    'darginina'                            => 'dar',
    'delavarina'                           => 'del',
    'dinka'                                => 'din',
    'diula'                                => 'dyu',
    'diveina'                              => 'dv',
    'dogri'                                => 'doi',
    'dogrib'                               => 'dgr',
    "dolnja\ luika\ srbina"                => 'dsb',
    "dravidski\ jezik"                     => 'dra',
    "drugi\ jeziki"                        => 'mis',
    'duala'                                => 'dua',
    'dzonka'                               => 'dz',
    'edo'                                  => 'bin',
    'eenina'                               => 'ce',
    'efiina'                               => 'efi',
    'eina'                                 => 'cs',
    'ejenina'                              => 'chy',
    'ekajuk'                               => 'eka',
    'elamina'                              => 'elx',
    'erokeina'                             => 'chr',
    'erzjanina'                            => 'myv',
    'esperanto'                            => 'eo',
    'estonina'                             => 'et',
    'etiopina'                             => 'gez',
    'evenina'                              => 'ee',
    'evondovina'                           => 'ewo',
    'fangijina'                            => 'fan',
    'fantijina'                            => 'fat',
    'fenianina'                            => 'phn',
    'ferina'                               => 'fo',
    'fidijina'                             => 'fj',
    'filipinina'                           => 'fil',
    "filipinski\ jezik"                    => 'phi',
    'finina'                               => 'fi',
    'flamina'                              => 'nl_be',
    'fonina'                               => 'fon',
    'francoina'                            => 'fr',
    "francoska\ kreolina\ ali\ pidinina"   => 'cpf',
    'frizijina'                            => 'fy',
    'fulina'                               => 'ff',
    'furlanina'                            => 'fur',
    'ga'                                   => 'gaa',
    'gajina'                               => 'gay',
    'galicijina'                           => 'gl',
    'ganda'                                => 'lg',
    'gbajina'                              => 'gba',
    "germanski\ jezik"                     => 'gem',
    'gondi'                                => 'gon',
    "gornja\ luika\ srbina"                => 'hsb',
    'gorontalina'                          => 'gor',
    'gotina'                               => 'got',
    'grebina'                              => 'grb',
    'grenlandina'                          => 'kl',
    'grina'                                => 'el',
    'gruzinina'                            => 'ka',
    'gudaratina'                           => 'gu',
    'gvaranijina'                          => 'gn',
    'gwi'                                  => 'gwi',
    'haidina'                              => 'hai',
    "haitijska\ kreolina"                  => 'ht',
    'havajina'                             => 'haw',
    'havina'                               => 'ha',
    'hebrejina'                            => 'he',
    'herero'                               => 'hz',
    'hetitina'                             => 'hit',
    'hiligajnonina'                        => 'hil',
    'himaalina'                            => 'him',
    'hindujina'                            => 'hi',
    "hiri\ motu"                           => 'ho',
    'hmonina'                              => 'hmn',
    'hrvaina'                              => 'hr',
    'hupa'                                 => 'hup',
    'ibanina'                              => 'iba',
    "iberska\ panina"                      => 'es_es',
    "iberska\ portugalina"                 => 'pt_pt',
    'ibevina'                              => 'chb',
    'ido'                                  => 'io',
    'igboina'                              => 'ig',
    'ii'                                   => 'ii',
    'ijo'                                  => 'ijo',
    'ilokanina'                            => 'ilo',
    "inarska\ samijina"                    => 'smn',
    "indijski\ jezik"                      => 'inc',
    "indoevropski\ jezik"                  => 'ine',
    'indonezijina'                         => 'id',
    'inguina'                              => 'inh',
    'interlingva'                          => 'ia',
    'interlingve'                          => 'ie',
    "inuki\ argon"                         => 'chn',
    'inuktitutina'                         => 'iu',
    'inupiaina'                            => 'ik',
    'ipevina'                              => 'chp',
    "iranski\ jezik"                       => 'ira',
    'irina'                                => 'ga',
    "irokeki\ jezik"                       => 'iro',
    'islandina'                            => 'is',
    'italijanina'                          => 'it',
    'jakutina'                             => 'sah',
    'jaojina'                              => 'yao',
    'japina'                               => 'yap',
    'japonina'                             => 'ja',
    'javanina'                             => 'jv',
    "jezik\ kru"                           => 'kro',
    'jidi'                                 => 'yi',
    'jorubina'                             => 'yo',
    "judovska\ arabina"                    => 'jrb',
    "judovska\ perzijina"                  => 'jpr',
    "juna\ altajina"                       => 'alt',
    "juna\ ndebelina"                      => 'nr',
    "juna\ samijina"                       => 'sma',
    "jupiki\ jezik"                        => 'ypk',
    'kabardinina'                          => 'kbd',
    'kabilina'                             => 'kab',
    'kadoina'                              => 'cad',
    'kainina'                              => 'kac',
    'kaj'                                  => 'kaj',
    'kalmiina'                             => 'xal',
    'kamba'                                => 'kam',
    'kamirina'                             => 'ks',
    'kanada'                               => 'kn',
    'kanurina'                             => 'kr',
    'karaajbalkarina'                      => 'krc',
    'karakalpaina'                         => 'kaa',
    'karelina'                             => 'krl',
    'karenina'                             => 'kar',
    "karibski\ jezik"                      => 'car',
    'kasi'                                 => 'kha',
    'katalonina'                           => 'ca',
    'kaubina'                              => 'csb',
    'kavi'                                 => 'kaw',
    "kavkaki\ jezik"                       => 'cau',
    'kazaina'                              => 'kk',
    "keltski\ jezik"                       => 'cel',
    'keuanina'                             => 'qu',
    'kfo'                                  => 'kfo',
    'kikujina'                             => 'ki',
    'kimbundu'                             => 'kmb',
    'kirgiina'                             => 'ky',
    'kiribatina'                           => 'gil',
    'kitajina'                             => 'zh',
    "kitajskotibetanski\ jezik"            => 'sit',
    "klasina\ nevarina"                    => 'nwc',
    "klasina\ sirina"                      => 'syc',
    'klingonina'                           => 'tlh',
    'kmerina'                              => 'km',
    "knjina\ norveina"                     => 'nb',
    "koisanski\ jezik"                     => 'khi',
    'komijina'                             => 'kv',
    'kongovina'                            => 'kg',
    'konkanina'                            => 'kok',
    'koptina'                              => 'cop',
    'korejina'                             => 'ko',
    'kornijina'                            => 'kw',
    'korziina'                             => 'co',
    'kosrajina'                            => 'kos',
    "kotabatski\ manobo"                   => 'mno',
    'kotanina'                             => 'kho',
    'kotina'                               => 'sco',
    "kotska\ gelina"                       => 'gd',
    'kpelejina'                            => 'kpe',
    "kreolina\ ali\ pidinina"              => 'crp',
    'krijina'                              => 'cr',
    "krimska\ tatarina"                    => 'crh',
    'kuitina'                              => 'cus',
    'kumiina'                              => 'kum',
    'kurdina'                              => 'ku',
    'kuruk'                                => 'kru',
    'kutenajina'                           => 'kut',
    'kvanjama'                             => 'kj',
    'ladinina'                             => 'lad',
    'lamba'                                => 'lam',
    'landa'                                => 'lah',
    'laoina'                               => 'lo',
    'latinina'                             => 'la',
    'latvijina'                            => 'lv',
    'lezginina'                            => 'lez',
    'limburina'                            => 'li',
    'lingala'                              => 'ln',
    'litovina'                             => 'lt',
    'lojban'                               => 'jbo',
    'lozi'                                 => 'loz',
    'lubakatanga'                          => 'lu',
    'lubalulua'                            => 'lua',
    "luiko\ srbski\ jezik"                 => 'wen',
    'luisenina'                            => 'lui',
    'luksemburina'                         => 'lb',
    "luleka\ samijina"                     => 'smj',
    'lunda'                                => 'lun',
    'luo'                                  => 'luo',
    'lushai'                               => 'lus',
    'madarina'                             => 'hu',
    'madurina'                             => 'mad',
    'magadina'                             => 'mag',
    'maitili'                              => 'mai',
    "majevski\ jezik"                      => 'myn',
    'makasarina'                           => 'mak',
    'makedonina'                           => 'mk',
    'malagaina'                            => 'mg',
    'malajalamina'                         => 'ml',
    'malajina'                             => 'ms',
    "malavijska\ tongina"                  => 'tog',
    'malteina'                             => 'mt',
    'mandarina'                            => 'mdr',
    'mandingo'                             => 'man',
    'mandurina'                            => 'mnc',
    'manina'                               => 'gv',
    'manipurina'                           => 'mni',
    'maorina'                              => 'mi',
    'maratina'                             => 'mr',
    'marijina'                             => 'chm',
    'marshallovina'                        => 'mh',
    'marvarina'                            => 'mwr',
    'masajina'                             => 'mas',
    'mende'                                => 'men',
    'mikmaina'                             => 'mic',
    'minangkabau'                          => 'min',
    'mirandeina'                           => 'mwl',
    'mohoina'                              => 'moh',
    'mokavina'                             => 'mdf',
    'moldavina'                            => 'mo',
    'mongo'                                => 'lol',
    'mongolina'                            => 'mn',
    "monskokmerski\ jezik"                 => 'mkh',
    'morisyen'                             => 'mfe',
    'mosijina'                             => 'mos',
    "mundski\ jezik"                       => 'mun',
    'mus'                                  => 'mus',
    'nahuatl'                              => 'nah',
    'napolitanina'                         => 'nap',
    'naurujina'                            => 'na',
    'navajina'                             => 'nv',
    'nemina'                               => 'de',
    "nemina\ vica"                         => 'gsw',
    'nepalina'                             => 'ne',
    'nevarina'                             => 'new',
    "neznan\ ali\ neveljaven\ jezik"       => 'und',
    'ng'                                   => 'ng',
    'niaina'                               => 'nia',
    "nigrskokordofanski\ jezik"            => 'nic',
    "nilskosaharski\ jezik"                => 'ssa',
    'niuejina'                             => 'niu',
    "nizka\ nemina"                        => 'nds',
    'nizozemina'                           => 'nl',
    'njamveina'                            => 'nym',
    'njanina'                              => 'ny',
    'njankole'                             => 'nyn',
    'njoro'                                => 'nyo',
    'nogajina'                             => 'nog',
    'norveina'                             => 'no',
    'novonorveina'                         => 'nn',
    'nqo'                                  => 'nqo',
    "nubijski\ jezik"                      => 'nub',
    'nzima'                                => 'nzi',
    'okcitanina'                           => 'oc',
    'oktavina'                             => 'cho',
    'onina'                                => 'sn',
    'orijina'                              => 'or',
    'oromo'                                => 'om',
    'osage'                                => 'osa',
    'osetinina'                            => 'os',
    "otomanska\ turina"                    => 'ota',
    "otomijski\ jezik"                     => 'oto',
    'pal'                                  => 'pal',
    'palavanina'                           => 'pau',
    'palijina'                             => 'pi',
    'pampanina'                            => 'pam',
    'pandabina'                            => 'pa',
    'pangasinanina'                        => 'pag',
    'panina'                               => 'es',
    'papiamentu'                           => 'pap',
    "papuanski\ jezik"                     => 'paa',
    'patu'                                 => 'ps',
    'perzijina'                            => 'fa',
    'poljina'                              => 'pl',
    'ponpejina'                            => 'pon',
    'portugalina'                          => 'pt',
    "portugalska\ kreolina\ ali\ pidinina" => 'cpp',
    "prakritski\ jezik"                    => 'pra',
    'radastanina'                          => 'raj',
    'rapanujina'                           => 'rap',
    'rarotongina'                          => 'rar',
    'retoromanina'                         => 'rm',
    "romanski\ jezik"                      => 'roa',
    'romina'                               => 'rom',
    'romunina'                             => 'ro',
    'ruandina'                             => 'rw',
    'ruina'                                => 'ru',
    'rundina'                              => 'rn',
    'sad'                                  => 'sad',
    'sai'                                  => 'sai',
    'sal'                                  => 'sal',
    "samaritanska\ aramejina"              => 'sam',
    "samijina\ skolt"                      => 'sms',
    "samijski\ jezik"                      => 'smi',
    'samoanina'                            => 'sm',
    'sango'                                => 'sg',
    'sanskrt'                              => 'sa',
    'santalina'                            => 'sat',
    'sardinina'                            => 'sc',
    'sasaina'                              => 'sas',
    'sebuanina'                            => 'ceb',
    'selkupina'                            => 'sel',
    "semitski\ jezik"                      => 'sem',
    'sererina'                             => 'srr',
    'sesoto'                               => 'st',
    "severna\ frizijina"                   => 'frr',
    "severna\ ndebelina"                   => 'nd',
    "severna\ samijina"                    => 'se',
    "severna\ sotina"                      => 'nso',
    "severnoameriki\ indijanski\ jezik"    => 'nai',
    'sicilijanina'                         => 'scn',
    'sidamina'                             => 'sid',
    'sijuina'                              => 'sio',
    'siksika'                              => 'bla',
    'sindina'                              => 'sd',
    'singalina'                            => 'si',
    'sirina'                               => 'syr',
    'slavejina'                            => 'den',
    'slovaina'                             => 'sk',
    "slovanski\ jezik"                     => 'sla',
    'slovenina'                            => 'sl',
    'snk'                                  => 'snk',
    'sog'                                  => 'sog',
    'somalina'                             => 'so',
    'songajina'                            => 'son',
    'srbina'                               => 'sr',
    'srbohrvaina'                          => 'sh',
    "srednja\ angleina"                    => 'enm',
    "srednja\ francoina"                   => 'frm',
    "srednja\ irina"                       => 'mga',
    "srednja\ nizozemina"                  => 'dum',
    "srednja\ visoka\ nemina"              => 'gmh',
    "srednjeameriki\ indijanski\ jezik"    => 'cai',
    "stara\ angleina"                      => 'ang',
    "stara\ cerkvena\ slovanina"           => 'cu',
    "stara\ egipanina"                     => 'egy',
    "stara\ francoina"                     => 'fro',
    "stara\ grina"                         => 'grc',
    "stara\ irina"                         => 'sga',
    "stara\ nordijina"                     => 'non',
    "stara\ perzijina"                     => 'peo',
    "stara\ provansalina"                  => 'pro',
    "stara\ visoka\ nemina"                => 'goh',
    'sukuma'                               => 'suk',
    'sumerina'                             => 'sux',
    'sundanina'                            => 'su',
    "surinamska\ kreolina"                 => 'srn',
    'susujina'                             => 'sus',
    'svahili'                              => 'sw',
    'svazijina'                            => 'ss',
    "swiss\ french"                        => 'fr_ch',
    'tadiina'                              => 'tg',
    'tagalogina'                           => 'tl',
    'tahitina'                             => 'ty',
    'tajina'                               => 'th',
    "tajski\ jezik"                        => 'tai',
    'tamajaina'                            => 'tmh',
    'tamilina'                             => 'ta',
    'taroko'                               => 'trv',
    'tatarina'                             => 'tt',
    'telugijina'                           => 'te',
    'temnejina'                            => 'tem',
    'ter'                                  => 'ter',
    'tetumina'                             => 'tet',
    'tibetanina'                           => 'bo',
    'tigrajina'                            => 'ti',
    "tigrejski\ jezik"                     => 'tig',
    'tivina'                               => 'tiv',
    "tjapska\ nigerijina"                  => 'kcg',
    'tlingitina'                           => 'tli',
    "tok\ pisin"                           => 'tpi',
    'tokelavina'                           => 'tkl',
    'tongina'                              => 'to',
    'trukeina'                             => 'chk',
    'tsimina'                              => 'tsi',
    'tsonga'                               => 'ts',
    'tumbukina'                            => 'tum',
    "tupijski\ jezik"                      => 'tup',
    'turina'                               => 'tr',
    'turkmenina'                           => 'tk',
    'tuvalujina'                           => 'tvl',
    'tuvinina'                             => 'tyv',
    'tvi'                                  => 'tw',
    'udmurtina'                            => 'udm',
    "ugaritski\ jezik"                     => 'uga',
    "ugrofinski\ jezik"                    => 'fiu',
    'ujgurina'                             => 'ug',
    'ukrajinina'                           => 'uk',
    'umbundina'                            => 'umb',
    "umetni\ jezik"                        => 'art',
    'urdujina'                             => 'ur',
    'uvaina'                               => 'cv',
    'uzbeina'                              => 'uz',
    'vaajina'                              => 'was',
    'vajina'                               => 'vai',
    "vakaki\ jezik"                        => 'wak',
    'valamina'                             => 'wal',
    'valianina'                            => 'cy',
    'valonina'                             => 'wa',
    'varajina'                             => 'war',
    "ve\ jezikov"                          => 'mul',
    'vedina'                               => 'sv',
    'venda'                                => 've',
    'vietnamina'                           => 'vi',
    "visoka\ nemina\ vica"                 => 'de_ch',
    'volapuk'                              => 'vo',
    'volofina'                             => 'wo',
    'votjaina'                             => 'vot',
    "vzhodna\ frizijina"                   => 'frs',
    'xhosa'                                => 'xh',
    'za'                                   => 'za',
    'zandejina'                            => 'znd',
    'zapoteina'                            => 'zap',
    'zazajina'                             => 'zza',
    'zenaina'                              => 'zen',
    "znakovni\ jezik"                      => 'sgn',
    "znakovni\ jezik\ bliss"               => 'zbl',
    'zulujina'                             => 'zu',
    'zunijina'                             => 'zun',
);

1;
