package Locales::DB::Language::sk;

# Auto generated from CLDR

$Locales::DB::Language::sk::VERSION = '0.01';

$Locales::DB::Language::sk::cldr_version = '1.7.1';

%Locales::DB::Language::sk::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Jazyk\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Región\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "nie\:n",
        'yesstr' => "ano\:a"
    },
);

%Locales::DB::Language::sk::code_to_name = (
    'aa'    => 'afarčina',
    'ab'    => 'abcházština',
    'ace'   => 'Achinese',
    'ach'   => 'ačoli',
    'ada'   => 'adangme',
    'ady'   => 'adygčina',
    'ae'    => 'avestčina',
    'af'    => 'afrikánčina',
    'afa'   => "afroázijské\ jazyky",
    'afh'   => 'afrihili',
    'ain'   => 'ainčina',
    'ak'    => 'akančina',
    'akk'   => 'akkadčina',
    'ale'   => 'aleutčina',
    'alg'   => "algonkinské\ jazyky",
    'alt'   => "Southern\ Altai",
    'am'    => 'amharčina',
    'an'    => 'aragónčina',
    'ang'   => "Old\ English",
    'anp'   => 'angika',
    'apa'   => "apačské\ jazyky",
    'ar'    => 'arabčina',
    'arc'   => 'Aramaic',
    'arn'   => 'araukánčina',
    'arp'   => 'arapaho',
    'art'   => "umelý\ jazyk",
    'arw'   => 'arawačtina',
    'as'    => 'ásámčina',
    'ast'   => 'astúrčina',
    'ath'   => "athabaské\ jazyky",
    'aus'   => "austrálske\ jazyky",
    'av'    => 'avarčina',
    'awa'   => 'avadhčina',
    'ay'    => 'aymarčina',
    'az'    => 'azerbajdžančina',
    'ba'    => 'baskirčina',
    'bad'   => 'Banda',
    'bai'   => 'bamileke',
    'bal'   => 'balúčtina',
    'ban'   => 'balijčina',
    'bas'   => 'basa',
    'bat'   => "baltské\ jazyky",
    'be'    => 'bieloruština',
    'bej'   => 'bedža',
    'bem'   => 'bemba',
    'ber'   => "berberské\ jazyky",
    'bg'    => 'bulharčina',
    'bh'    => "bihárske\ jazyky",
    'bho'   => 'bhódžpurčina',
    'bi'    => 'bislama',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'Siksika',
    'bm'    => 'bambarčina',
    'bn'    => 'bengálčina',
    'bnt'   => "bantuské\ jazyky",
    'bo'    => 'tibetčina',
    'br'    => 'bretónčina',
    'bra'   => 'bradžčina',
    'bs'    => 'bosniačtina',
    'btk'   => "batacké\ jazyky",
    'bua'   => 'buriatčina',
    'bug'   => 'bugiština',
    'byn'   => 'blin',
    'ca'    => 'katalánčina',
    'cad'   => 'Caddo',
    'cai'   => "jazyk\ stredoamerických\ indiánov",
    'car'   => 'karibský',
    'cau'   => "kaukazské\ jazyky",
    'cch'   => 'Atsam',
    'ce'    => 'čečenčina',
    'ceb'   => 'cebuánčina',
    'cel'   => "keltské\ jazyky",
    'ch'    => 'čamorčina',
    'chb'   => 'čibča',
    'chg'   => 'čagatajčina',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "činucký\ žargón",
    'cho'   => 'čoktavčina',
    'chp'   => 'čipevajčina',
    'chr'   => 'čerokí',
    'chy'   => 'čejenčina',
    'cmc'   => "čamaské\ jazyky",
    'co'    => 'korzičtina',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'krí',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'čeština',
    'csb'   => 'Kashubian',
    'cu'    => "cirkevná\ slovančina",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'čuvaština',
    'cy'    => 'waleština',
    'da'    => 'dánčina',
    'dak'   => 'dakotčina',
    'dar'   => 'darginčina',
    'day'   => 'Dayak',
    'de'    => 'nemčina',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'delawarčina',
    'den'   => 'slovančina',
    'dgr'   => 'dogribčina',
    'din'   => 'dinka',
    'doi'   => 'dógrí',
    'dra'   => "drávidské\ jazyky",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'divehi',
    'dyu'   => 'ďula',
    'dz'    => 'dzongkä',
    'ee'    => 'eweština',
    'efi'   => 'efik',
    'egy'   => 'staroegyptský',
    'eka'   => 'ekadžuk',
    'el'    => 'gréčtina',
    'elx'   => 'elamčina',
    'en'    => 'angličtina',
    'en_au' => "austrálska\ angličtina",
    'en_ca' => "Canadian\ English",
    'en_gb' => "britská\ angličtina",
    'en_us' => "americká\ angličtina",
    'enm'   => "Middle\ English",
    'eo'    => 'esperanto',
    'es'    => 'španielčina',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'estónčina',
    'eu'    => 'baskičtina',
    'ewo'   => 'ewondo',
    'fa'    => 'perzština',
    'fan'   => 'fangčina',
    'fat'   => 'fanti',
    'ff'    => 'fulbčina',
    'fi'    => 'fínčina',
    'fil'   => 'filipínčina',
    'fiu'   => "ugrofínske\ jazyky",
    'fj'    => 'fidžijčina',
    'fo'    => 'faerčina',
    'fon'   => 'fončina',
    'fr'    => 'francúzština',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "východná\ frízština",
    'fur'   => 'friulčina',
    'fy'    => "západná\ frízština",
    'ga'    => 'írčina',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaja',
    'gd'    => 'škótčina',
    'gem'   => "germánske\ jazyky",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'galícijčina',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'guaraní',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'gótčina',
    'grb'   => 'Grebo',
    'grc'   => 'starogréčtina',
    'gsw'   => "švajčiarska\ nemčina",
    'gu'    => 'gudžarátčina',
    'gv'    => 'mančina',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'hauština',
    'hai'   => 'Haida',
    'haw'   => 'havajčina',
    'he'    => 'hebrejčina',
    'hi'    => 'hindčina',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'chorvátčina',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'haitský',
    'hu'    => 'maďarčina',
    'hup'   => 'Hupa',
    'hy'    => 'arménčina',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'Iban',
    'id'    => 'indonézština',
    'ie'    => 'interlingue',
    'ig'    => 'igboština',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "indoeurópske\ jazyky",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "iránske\ jazyky",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'islandčina',
    'it'    => 'taliančina',
    'iu'    => 'Inuktitut',
    'ja'    => 'japončina',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'jávčina',
    'ka'    => 'gruzínčina',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'konžština',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'kuaňama',
    'kk'    => 'kazaština',
    'kl'    => "grónska\ eskimáčtina",
    'km'    => "kambodžská\ khmérčina",
    'kmb'   => 'Kimbundu',
    'kn'    => 'kannadčina',
    'ko'    => 'kórejčina',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'kanurijčina',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'kašmírčina',
    'ku'    => 'kurdčina',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'komijčina',
    'kw'    => 'kornčina',
    'ky'    => 'kirgizština',
    'la'    => 'latinčina',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'luxemburčina',
    'lez'   => 'Lezghian',
    'lg'    => 'gandčina',
    'li'    => 'Limburgish',
    'ln'    => 'lingalčina',
    'lo'    => 'laoština',
    'lol'   => 'mongo',
    'loz'   => 'Lozi',
    'lt'    => 'litovčina',
    'lu'    => "luba\-katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'lotyština',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "austronézske\ jazyky",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaština',
    'mga'   => "Middle\ Irish",
    'mh'    => "kajin\-majol",
    'mi'    => 'maorijčina',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'macedónčina',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'malajálamčina',
    'mn'    => 'mongolčina',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'moldavčina',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'maráthčina',
    'ms'    => 'malajčina',
    'mt'    => 'maltčina',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'barmčina',
    'myn'   => "mayské\ jazyky",
    'myv'   => 'erzjančina',
    'na'    => 'nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "jazyk\ severoamerických\ indiánov",
    'nap'   => 'Neapolitan',
    'nb'    => 'bokmål',
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'nepálčina',
    'new'   => 'Newari',
    'ng'    => 'ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'holandčina',
    'nl_be' => 'Flemish',
    'nn'    => "nórsky\ nynorsk",
    'no'    => 'nórčina',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'čewa',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'okcitánčina',
    'oj'    => 'odžibva',
    'om'    => 'oromčina',
    'or'    => 'uríjčina',
    'os'    => 'osetčina',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'pandžábčina',
    'paa'   => 'papuánsky',
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'pálí',
    'pl'    => 'poľština',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'paštúnčina',
    'pt'    => 'portugalčina',
    'pt_br' => "brazílska\ portugalčina",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'kečuánčina',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'rétorománčina',
    'rn'    => 'rundčina',
    'ro'    => 'rumunčina',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'ruština',
    'rup'   => 'Aromanian',
    'rw'    => 'rwandčina',
    'sa'    => 'sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "jazyk\ juhoamerických\ indiánov",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'sardínčina',
    'scn'   => 'sicílčina',
    'sco'   => 'Scots',
    'sd'    => 'sindhčina',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "znaková\ reč",
    'sh'    => 'srbochorvátčina',
    'shn'   => 'Shan',
    'si'    => 'sinhalčina',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'slovenčina',
    'sl'    => 'slovinčina',
    'sla'   => "slovenský\ jazyk",
    'sm'    => 'samojčina',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'šončina',
    'snk'   => 'Soninke',
    'so'    => 'somálčina',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'albánčina',
    'sr'    => 'srbčina',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'svazijčina',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => "južná\ sothčina",
    'su'    => 'sundčina',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'sumerčina',
    'sv'    => 'švédčina',
    'sw'    => 'swahilčina',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'sýrčina',
    'ta'    => 'tamilčina',
    'tai'   => "Tai\ Language",
    'te'    => 'telugčina',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'tadžičtina',
    'th'    => 'thajčina',
    'ti'    => 'tigrejčina',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'turkménčina',
    'tkl'   => 'Tokelau',
    'tl'    => 'tagalčina',
    'tlh'   => 'klingónčina',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'tswančina',
    'to'    => 'tonžtina',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'turečtina',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'tatárčina',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "altajské\ jazyky",
    'tvl'   => 'Tuvalu',
    'tw'    => 'twi',
    'ty'    => 'tahitčina',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'ujgurčina',
    'uga'   => 'Ugaritic',
    'uk'    => 'ukrajinčina',
    'umb'   => 'Umbundu',
    'und'   => "neznámy\ alebo\ neplatný\ jazyk",
    'ur'    => 'urdčina',
    'uz'    => 'uzbečtina',
    'vai'   => 'Vai',
    've'    => 'vendčina',
    'vi'    => 'vietnamčina',
    'vo'    => 'volapük',
    'vot'   => 'Votic',
    'wa'    => 'valónčina',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'jidiš',
    'yo'    => 'jorubčina',
    'ypk'   => "Yupik\ Language",
    'za'    => 'čuangčina',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'čínština',
    'znd'   => 'Zande',
    'zu'    => 'zuluština',
    'zun'   => 'Zuni',
    'zxx'   => "bez\ jazykového\ obsahu",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::sk::name_to_code = (
    'abchztina'                           => 'ab',
    'achinese'                            => 'ace',
    'adangme'                             => 'ada',
    'adygina'                             => 'ady',
    'afarina'                             => 'aa',
    'afrihili'                            => 'afh',
    'afriknina'                           => 'af',
    "afrozijsk\ jazyky"                   => 'afa',
    'agatajina'                           => 'chg',
    'ainina'                              => 'ain',
    'akanina'                             => 'ak',
    'akkadina'                            => 'akk',
    'albnina'                             => 'sq',
    'aleutina'                            => 'ale',
    "algonkinsk\ jazyky"                  => 'alg',
    "altajsk\ jazyky"                     => 'tut',
    "amask\ jazyky"                       => 'cmc',
    "americk\ anglitina"                  => 'en_us',
    'amharina'                            => 'am',
    'amorina'                             => 'ch',
    'angika'                              => 'anp',
    'anglitina'                           => 'en',
    'aoli'                                => 'ach',
    "apask\ jazyky"                       => 'apa',
    'arabina'                             => 'ar',
    'aragnina'                            => 'an',
    'aramaic'                             => 'arc',
    'arapaho'                             => 'arp',
    'arauknina'                           => 'arn',
    'arawatina'                           => 'arw',
    'armnina'                             => 'hy',
    'aromanian'                           => 'rup',
    'astrina'                             => 'ast',
    "athabask\ jazyky"                    => 'ath',
    'atsam'                               => 'cch',
    "austrian\ german"                    => 'de_at',
    "austrlska\ anglitina"                => 'en_au',
    "austrlske\ jazyky"                   => 'aus',
    "austronzske\ jazyky"                 => 'map',
    'avadhina'                            => 'awa',
    'avarina'                             => 'av',
    'avestina'                            => 'ae',
    'aymarina'                            => 'ay',
    'azerbajdanina'                       => 'az',
    'balijina'                            => 'ban',
    'baltina'                             => 'bal',
    "baltsk\ jazyky"                      => 'bat',
    'bambarina'                           => 'bm',
    'bamileke'                            => 'bai',
    'banda'                               => 'bad',
    "bantusk\ jazyky"                     => 'bnt',
    'barmina'                             => 'my',
    'basa'                                => 'bas',
    'baskirina'                           => 'ba',
    'baskitina'                           => 'eu',
    "batack\ jazyky"                      => 'btk',
    'beda'                                => 'bej',
    'bemba'                               => 'bem',
    'benglina'                            => 'bn',
    "berbersk\ jazyky"                    => 'ber',
    "bez\ jazykovho\ obsahu"              => 'zxx',
    'bhdpurina'                           => 'bho',
    'bielorutina'                         => 'be',
    "bihrske\ jazyky"                     => 'bh',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'bislama'                             => 'bi',
    'blin'                                => 'byn',
    'blissymbols'                         => 'zbl',
    'bokml'                               => 'nb',
    'bosniatina'                          => 'bs',
    'bradina'                             => 'bra',
    "brazlska\ portugalina"               => 'pt_br',
    'bretnina'                            => 'br',
    "britsk\ anglitina"                   => 'en_gb',
    'bugitina'                            => 'bug',
    'bulharina'                           => 'bg',
    'buriatina'                           => 'bua',
    'caddo'                               => 'cad',
    "canadian\ english"                   => 'en_ca',
    "canadian\ french"                    => 'fr_ca',
    'cebunina'                            => 'ceb',
    'chorvtina'                           => 'hr',
    'chuukese'                            => 'chk',
    "cirkevn\ slovanina"                  => 'cu',
    "classical\ newari"                   => 'nwc',
    "classical\ syriac"                   => 'syc',
    'coptic'                              => 'cop',
    'creek'                               => 'mus',
    "creole\ or\ pidgin"                  => 'crp',
    "crimean\ turkish"                    => 'crh',
    "cushitic\ language"                  => 'cus',
    'dakotina'                            => 'dak',
    'darginina'                           => 'dar',
    'dayak'                               => 'day',
    'delawarina'                          => 'del',
    'dgr'                                 => 'doi',
    'dinka'                               => 'din',
    'divehi'                              => 'dv',
    'dnina'                               => 'da',
    'dogribina'                           => 'dgr',
    "drvidsk\ jazyky"                     => 'dra',
    'duala'                               => 'dua',
    'dzongk'                              => 'dz',
    'eenina'                              => 'ce',
    'efik'                                => 'efi',
    'ejenina'                             => 'chy',
    'ekaduk'                              => 'eka',
    'elamina'                             => 'elx',
    "englishbased\ creole\ or\ pidgin"    => 'cpe',
    'erok'                                => 'chr',
    'erzjanina'                           => 'myv',
    'esperanto'                           => 'eo',
    'estnina'                             => 'et',
    'etina'                               => 'cs',
    'ewa'                                 => 'ny',
    'ewetina'                             => 'ee',
    'ewondo'                              => 'ewo',
    'faerina'                             => 'fo',
    'fangina'                             => 'fan',
    'fanti'                               => 'fat',
    'fidijina'                            => 'fj',
    'filipnina'                           => 'fil',
    'flemish'                             => 'nl_be',
    'fnina'                               => 'fi',
    'fonina'                              => 'fon',
    'francztina'                          => 'fr',
    "frenchbased\ creole\ or\ pidgin"     => 'cpf',
    'friulina'                            => 'fur',
    'fulbina'                             => 'ff',
    'ga'                                  => 'gaa',
    'galcijina'                           => 'gl',
    'gandina'                             => 'lg',
    'gayo'                                => 'gay',
    'gbaja'                               => 'gba',
    'geez'                                => 'gez',
    "germnske\ jazyky"                    => 'gem',
    'gilbertese'                          => 'gil',
    'gondi'                               => 'gon',
    'gorontalo'                           => 'gor',
    'grebo'                               => 'grb',
    "grnska\ eskimtina"                   => 'kl',
    'grtina'                              => 'el',
    'gruznina'                            => 'ka',
    'gtina'                               => 'got',
    'guaran'                              => 'gn',
    'gudartina'                           => 'gu',
    'gwichin'                             => 'gwi',
    'haida'                               => 'hai',
    'haitsk'                              => 'ht',
    'hautina'                             => 'ha',
    'havajina'                            => 'haw',
    'hebrejina'                           => 'he',
    'herero'                              => 'hz',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    'hindina'                             => 'hi',
    "hiri\ motu"                          => 'ho',
    'hittite'                             => 'hit',
    'hmong'                               => 'hmn',
    'holandina'                           => 'nl',
    'hupa'                                => 'hup',
    'iba'                                 => 'chb',
    'iban'                                => 'iba',
    "iberian\ portuguese"                 => 'pt_pt',
    "iberian\ spanish"                    => 'es_es',
    'ido'                                 => 'io',
    'igbotina'                            => 'ig',
    'ijo'                                 => 'ijo',
    'iloko'                               => 'ilo',
    "inari\ sami"                         => 'smn',
    "indic\ language"                     => 'inc',
    "indoeurpske\ jazyky"                 => 'ine',
    'indonztina'                          => 'id',
    'ingush'                              => 'inh',
    'interlingua'                         => 'ia',
    'interlingue'                         => 'ie',
    "inuck\ argn"                         => 'chn',
    'inuktitut'                           => 'iu',
    'inupiaq'                             => 'ik',
    'ipevajina'                           => 'chp',
    "irnske\ jazyky"                      => 'ira',
    "iroquoian\ language"                 => 'iro',
    'islandina'                           => 'is',
    'japonina'                            => 'ja',
    "jazyk\ juhoamerickch\ indinov"       => 'sai',
    "jazyk\ severoamerickch\ indinov"     => 'nai',
    "jazyk\ stredoamerickch\ indinov"     => 'cai',
    'jidi'                                => 'yi',
    'jju'                                 => 'kaj',
    'jorubina'                            => 'yo',
    'judeoarabic'                         => 'jrb',
    'judeopersian'                        => 'jpr',
    "jun\ sothina"                        => 'st',
    'jvina'                               => 'jv',
    'kabardian'                           => 'kbd',
    'kabyle'                              => 'kab',
    'kachin'                              => 'kac',
    'kajinmajol'                          => 'mh',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    "kambodsk\ khmrina"                   => 'km',
    'kamrina'                             => 'ks',
    'kannadina'                           => 'kn',
    'kanurijina'                          => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpak'                          => 'kaa',
    'karelian'                            => 'krl',
    'karen'                               => 'kar',
    'karibsk'                             => 'car',
    'kashubian'                           => 'csb',
    'katalnina'                           => 'ca',
    "kaukazsk\ jazyky"                    => 'cau',
    'kawi'                                => 'kaw',
    'kazatina'                            => 'kk',
    "keltsk\ jazyky"                      => 'cel',
    'keunina'                             => 'qu',
    'khasi'                               => 'kha',
    "khoisan\ language"                   => 'khi',
    'khotanese'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'kirgiztina'                          => 'ky',
    'klingnina'                           => 'tlh',
    'komijina'                            => 'kv',
    'konkani'                             => 'kok',
    'kontina'                             => 'kg',
    'kornina'                             => 'kw',
    'koro'                                => 'kfo',
    'korzitina'                           => 'co',
    'kosraean'                            => 'kos',
    'kpelle'                              => 'kpe',
    'kr'                                  => 'cr',
    'krejina'                             => 'ko',
    'kru'                                 => 'kro',
    'ktina'                               => 'gd',
    'kuaama'                              => 'kj',
    'kumyk'                               => 'kum',
    'kurdina'                             => 'ku',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'laotina'                             => 'lo',
    'latinina'                            => 'la',
    'lezghian'                            => 'lez',
    'limburgish'                          => 'li',
    'lingalina'                           => 'ln',
    'litovina'                            => 'lt',
    'lojban'                              => 'jbo',
    'lotytina'                            => 'lv',
    "low\ german"                         => 'nds',
    "lower\ sorbian"                      => 'dsb',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    "lule\ sami"                          => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'luxemburina'                         => 'lb',
    'maarina'                             => 'hu',
    'macednina'                           => 'mk',
    'madurese'                            => 'mad',
    'magahi'                              => 'mag',
    'maithili'                            => 'mai',
    'makasar'                             => 'mak',
    'malajina'                            => 'ms',
    'malajlamina'                         => 'ml',
    'malgatina'                           => 'mg',
    'maltina'                             => 'mt',
    'manchu'                              => 'mnc',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    'manina'                              => 'gv',
    'manipuri'                            => 'mni',
    "manobo\ language"                    => 'mno',
    'maorijina'                           => 'mi',
    'mari'                                => 'chm',
    'marthina'                            => 'mr',
    'marwari'                             => 'mwr',
    'masai'                               => 'mas',
    "maysk\ jazyky"                       => 'myn',
    'mende'                               => 'men',
    'micmac'                              => 'mic',
    "middle\ dutch"                       => 'dum',
    "middle\ english"                     => 'enm',
    "middle\ french"                      => 'frm',
    "middle\ high\ german"                => 'gmh',
    "middle\ irish"                       => 'mga',
    'minangkabau'                         => 'min',
    'mirandese'                           => 'mwl',
    "miscellaneous\ language"             => 'mis',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'moldavina'                           => 'mo',
    'mongo'                               => 'lol',
    'mongolina'                           => 'mn',
    "monkhmer\ language"                  => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    "multiple\ languages"                 => 'mul',
    "munda\ language"                     => 'mun',
    'nahuatl'                             => 'nah',
    'nauru'                               => 'na',
    'navajo'                              => 'nv',
    'ndonga'                              => 'ng',
    'neapolitan'                          => 'nap',
    'nemina'                              => 'de',
    'neplina'                             => 'ne',
    'newari'                              => 'new',
    "neznmy\ alebo\ neplatn\ jazyk"       => 'und',
    'nias'                                => 'nia',
    "nigerkordofanian\ language"          => 'nic',
    "nilosaharan\ language"               => 'ssa',
    'niuean'                              => 'niu',
    'nko'                                 => 'nqo',
    'nogai'                               => 'nog',
    "north\ ndebele"                      => 'nd',
    "northern\ frisian"                   => 'frr',
    "northern\ sami"                      => 'se',
    "northern\ sotho"                     => 'nso',
    'nrina'                               => 'no',
    "nrsky\ nynorsk"                      => 'nn',
    'ntina'                               => 'zh',
    "nubian\ language"                    => 'nub',
    'nyamwezi'                            => 'nym',
    'nyankole'                            => 'nyn',
    "nyasa\ tonga"                        => 'tog',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'odibva'                              => 'oj',
    'okcitnina'                           => 'oc',
    'oktavina'                            => 'cho',
    "old\ english"                        => 'ang',
    "old\ french"                         => 'fro',
    "old\ high\ german"                   => 'goh',
    "old\ irish"                          => 'sga',
    "old\ norse"                          => 'non',
    "old\ persian"                        => 'peo',
    "old\ provenal"                       => 'pro',
    'onina'                               => 'sn',
    'oromina'                             => 'om',
    'osage'                               => 'osa',
    'osetina'                             => 'os',
    "otomian\ language"                   => 'oto',
    "ottoman\ turkish"                    => 'ota',
    'pahlavi'                             => 'pal',
    'palauan'                             => 'pau',
    'pampanga'                            => 'pam',
    'pandbina'                            => 'pa',
    'pangasinan'                          => 'pag',
    'panielina'                           => 'es',
    'papiamento'                          => 'pap',
    'papunsky'                            => 'paa',
    'patnina'                             => 'ps',
    'perztina'                            => 'fa',
    "philippine\ language"                => 'phi',
    'phoenician'                          => 'phn',
    'pl'                                  => 'pi',
    'pohnpeian'                           => 'pon',
    'portugalina'                         => 'pt',
    "portuguesebased\ creole\ or\ pidgin" => 'cpp',
    'potina'                              => 'pl',
    "prakrit\ language"                   => 'pra',
    'rajasthani'                          => 'raj',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    'rina'                                => 'ga',
    "romance\ language"                   => 'roa',
    'romany'                              => 'rom',
    'rtoromnina'                          => 'rm',
    'rumunina'                            => 'ro',
    'rundina'                             => 'rn',
    'rutina'                              => 'ru',
    'rwandina'                            => 'rw',
    "salishan\ language"                  => 'sal',
    "samaritan\ aramaic"                  => 'sam',
    "sami\ language"                      => 'smi',
    'samojina'                            => 'sm',
    'sandawe'                             => 'sad',
    'sango'                               => 'sg',
    'sanskrit'                            => 'sa',
    'santali'                             => 'sat',
    'sardnina'                            => 'sc',
    'sasak'                               => 'sas',
    'scots'                               => 'sco',
    'selkup'                              => 'sel',
    "semitic\ language"                   => 'sem',
    'serer'                               => 'srr',
    'shan'                                => 'shn',
    "sichuan\ yi"                         => 'ii',
    'siclina'                             => 'scn',
    'sidamo'                              => 'sid',
    'siksika'                             => 'bla',
    'sindhina'                            => 'sd',
    'sinhalina'                           => 'si',
    "sinotibetan\ language"               => 'sit',
    "siouan\ language"                    => 'sio',
    "skolt\ sami"                         => 'sms',
    'slovanina'                           => 'den',
    'slovenina'                           => 'sk',
    "slovensk\ jazyk"                     => 'sla',
    'slovinina'                           => 'sl',
    'smina'                               => 'as',
    'sogdien'                             => 'sog',
    'somlina'                             => 'so',
    'songhai'                             => 'son',
    'soninke'                             => 'snk',
    "sorbian\ language"                   => 'wen',
    "south\ ndebele"                      => 'nr',
    "southern\ altai"                     => 'alt',
    "southern\ sami"                      => 'sma',
    "sranan\ tongo"                       => 'srn',
    'srbina'                              => 'sr',
    'srbochorvtina'                       => 'sh',
    'srina'                               => 'syr',
    'staroegyptsk'                        => 'egy',
    'starogrtina'                         => 'grc',
    'sukuma'                              => 'suk',
    'sumerina'                            => 'sux',
    'sundina'                             => 'su',
    'susu'                                => 'sus',
    'svazijina'                           => 'ss',
    'swahilina'                           => 'sw',
    "swiss\ french"                       => 'fr_ch',
    "swiss\ high\ german"                 => 'de_ch',
    'taditina'                            => 'tg',
    'tagalina'                            => 'tl',
    'tahitina'                            => 'ty',
    "tai\ language"                       => 'tai',
    'talianina'                           => 'it',
    'tamashek'                            => 'tmh',
    'tamilina'                            => 'ta',
    'taroko'                              => 'trv',
    'tatrina'                             => 'tt',
    'telugina'                            => 'te',
    'tereno'                              => 'ter',
    'tetum'                               => 'tet',
    'thajina'                             => 'th',
    'tibetina'                            => 'bo',
    'tigre'                               => 'tig',
    'tigrejina'                           => 'ti',
    'timne'                               => 'tem',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    "tok\ pisin"                          => 'tpi',
    'tokelau'                             => 'tkl',
    'tontina'                             => 'to',
    'tsimshian'                           => 'tsi',
    'tsonga'                              => 'ts',
    'tswanina'                            => 'tn',
    'tumbuka'                             => 'tum',
    "tupi\ language"                      => 'tup',
    'turetina'                            => 'tr',
    'turkmnina'                           => 'tk',
    'tuvalu'                              => 'tvl',
    'tuvinian'                            => 'tyv',
    'twi'                                 => 'tw',
    'tyap'                                => 'kcg',
    'uangina'                             => 'za',
    'udmurt'                              => 'udm',
    'ugaritic'                            => 'uga',
    "ugrofnske\ jazyky"                   => 'fiu',
    'ujgurina'                            => 'ug',
    'ukrajinina'                          => 'uk',
    'ula'                                 => 'dyu',
    'umbundu'                             => 'umb',
    "umel\ jazyk"                         => 'art',
    "upper\ sorbian"                      => 'hsb',
    'urdina'                              => 'ur',
    'urjina'                              => 'or',
    'uvatina'                             => 'cv',
    'uzbetina'                            => 'uz',
    'vai'                                 => 'vai',
    "vajiarska\ nemina"                   => 'gsw',
    'valnina'                             => 'wa',
    "vchodn\ frztina"                     => 'frs',
    'vdina'                               => 'sv',
    'vendina'                             => 've',
    'vietnamina'                          => 'vi',
    'volapk'                              => 'vo',
    'votic'                               => 'vot',
    "wakashan\ language"                  => 'wak',
    'walamo'                              => 'wal',
    'waletina'                            => 'cy',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'wolof'                               => 'wo',
    'xhosa'                               => 'xh',
    'yakut'                               => 'sah',
    'yao'                                 => 'yao',
    'yapese'                              => 'yap',
    "yupik\ language"                     => 'ypk',
    'zande'                               => 'znd',
    'zapotec'                             => 'zap',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    "znakov\ re"                          => 'sgn',
    "zpadn\ frztina"                      => 'fy',
    'zulutina'                            => 'zu',
    'zuni'                                => 'zun',
);

1;
