package Locales::DB::Language::pl;

# Auto generated from CLDR

$Locales::DB::Language::pl::VERSION = '0.01';

$Locales::DB::Language::pl::cldr_version = '1.7.1';

%Locales::DB::Language::pl::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Język\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "nie\:n",
        'yesstr' => "tak\:t"
    },
);

%Locales::DB::Language::pl::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abchaski',
    'ace'   => 'aceh',
    'ach'   => 'aczoli',
    'ada'   => 'adangme',
    'ady'   => 'adygejski',
    'ae'    => 'awestyjski',
    'af'    => 'afrikaans',
    'afa'   => "afro\-azjatycki",
    'afh'   => 'afrihili',
    'ain'   => 'ajnu',
    'ak'    => 'akan',
    'akk'   => 'akadyjski',
    'ale'   => 'aleucki',
    'alg'   => "języki\ algonkin",
    'alt'   => 'południowoałtajski',
    'am'    => 'amharski',
    'an'    => 'aragoński',
    'ang'   => 'staroangielski',
    'anp'   => 'angika',
    'apa'   => "język\ Apaczów",
    'ar'    => 'arabski',
    'arc'   => 'aramejski',
    'arn'   => 'araukański',
    'arp'   => 'arapaho',
    'art'   => 'sztuczny',
    'arw'   => 'arawak',
    'as'    => 'asamski',
    'ast'   => 'asturyjski',
    'ath'   => "język\ Atapasków",
    'aus'   => "język\ australijski",
    'av'    => 'awarski',
    'awa'   => 'awadhi',
    'ay'    => 'ajmara',
    'az'    => 'azerski',
    'ba'    => 'baszkirski',
    'bad'   => "język\ banda",
    'bai'   => "język\ bamileke",
    'bal'   => 'beludżi',
    'ban'   => 'balijski',
    'bas'   => 'basa',
    'bat'   => 'bałtycki',
    'be'    => 'białoruski',
    'bej'   => 'bedża',
    'bem'   => 'bemba',
    'ber'   => 'berberski',
    'bg'    => 'bułgarski',
    'bh'    => 'biharski',
    'bho'   => 'bhodźpuri',
    'bi'    => 'Bislama',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalski',
    'bnt'   => 'bantu',
    'bo'    => 'tybetański',
    'br'    => 'bretoński',
    'bra'   => 'bradź',
    'bs'    => 'bośniacki',
    'btk'   => 'batak',
    'bua'   => 'buriacki',
    'bug'   => 'bugiński',
    'byn'   => 'blin',
    'ca'    => 'kataloński',
    'cad'   => 'kaddo',
    'cai'   => "język\ Indian\ środkowoamerykańskich",
    'car'   => 'karibi',
    'cau'   => 'kaukaski',
    'cch'   => 'atsam',
    'ce'    => 'czeczeński',
    'ceb'   => 'cebuano',
    'cel'   => 'celtycki',
    'ch'    => 'chamorro',
    'chb'   => 'czibcza',
    'chg'   => 'czagatajski',
    'chk'   => 'truk',
    'chm'   => 'maryjski',
    'chn'   => "żargon\ Chinook",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'czirokezki',
    'chy'   => "język\ Czejenów",
    'cmc'   => 'czam',
    'co'    => 'korsykański',
    'cop'   => 'koptyjski',
    'cpe'   => "angielski\ kreolski\ lub\ pidżin",
    'cpf'   => "francuski\ kreolski\ lub\ pidżin",
    'cpp'   => "portugalski\ kreolski\ lub\ pidżin",
    'cr'    => 'kri',
    'crh'   => "krymski\ turecki",
    'crp'   => "kreolski\ lub\ pidżin",
    'cs'    => 'czeski',
    'csb'   => 'kaszubski',
    'cu'    => "staro\-cerkiewno\-słowiański",
    'cus'   => 'kuszycki',
    'cv'    => 'czuwaski',
    'cy'    => 'walijski',
    'da'    => 'duński',
    'dak'   => 'dakota',
    'dar'   => 'dargwijski',
    'day'   => 'dajak',
    'de'    => 'niemiecki',
    'de_at' => "austriacki\ niemiecki",
    'de_ch' => "wysokoniemiecki\ \(Szwajcaria\)",
    'del'   => 'delaware',
    'den'   => 'slave',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => 'dogri',
    'dra'   => 'drawidyjski',
    'dsb'   => 'dolnołużycki',
    'dua'   => 'duala',
    'dum'   => "średniowieczny\ niderlandzki",
    'dv'    => 'malediwski',
    'dyu'   => 'dyula',
    'dz'    => 'dzongkha',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => "starożytny\ egipski",
    'eka'   => 'ekajuk',
    'el'    => 'grecki',
    'elx'   => 'elamicki',
    'en'    => 'angielski',
    'en_au' => "Australian\ English",
    'en_ca' => "kanadyjski\ angielski",
    'en_gb' => "brytyjski\ angielski",
    'en_us' => "angielski\ \(USA\)",
    'enm'   => 'średnioangielski',
    'eo'    => 'esperanto',
    'es'    => 'hiszpański',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'estoński',
    'eu'    => 'baskijski',
    'ewo'   => 'ewondo',
    'fa'    => 'perski',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulani',
    'fi'    => 'fiński',
    'fil'   => 'filipino',
    'fiu'   => 'ugrofiński',
    'fj'    => 'fidżijski',
    'fo'    => 'farerski',
    'fon'   => 'fon',
    'fr'    => 'francuski',
    'fr_ca' => "kanadyjski\ francuski",
    'fr_ch' => "Swiss\ French",
    'frm'   => 'średniofrancuski',
    'fro'   => 'starofrancuski',
    'frr'   => 'północnofryzyjski',
    'frs'   => "fryzyjski\ wschodni",
    'fur'   => 'friulijski',
    'fy'    => 'fryzyjski',
    'ga'    => 'irlandzki',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "szkocki\ gaelicki",
    'gem'   => 'germański',
    'gez'   => 'gyyz',
    'gil'   => 'gilbertański',
    'gl'    => 'galisyjski',
    'gmh'   => "średnio\-wysoko\-niemiecki",
    'gn'    => 'guarani',
    'goh'   => "staro\-wysoko\-niemiecki",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gocki',
    'grb'   => 'grebo',
    'grc'   => 'starogrecki',
    'gsw'   => "szwajcarski\ niemiecki",
    'gu'    => 'gudźaracki',
    'gv'    => 'manx',
    'gwi'   => 'Gwichʼin',
    'ha'    => 'hausa',
    'hai'   => 'haida',
    'haw'   => 'hawajski',
    'he'    => 'hebrajski',
    'hi'    => 'hindi',
    'hil'   => 'hiligajnon',
    'him'   => 'himachali',
    'hit'   => 'hetycki',
    'hmn'   => 'hmongijski',
    'ho'    => "hiri\ motu",
    'hr'    => 'chorwacki',
    'hsb'   => 'górnołużycki',
    'ht'    => 'haitański',
    'hu'    => 'węgierski',
    'hup'   => 'hupa',
    'hy'    => 'ormiański',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'ibanag',
    'id'    => 'indonezyjski',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => 'syczuański',
    'ijo'   => 'ijo',
    'ik'    => 'inupiak',
    'ilo'   => 'ilokano',
    'inc'   => 'indoaryjski',
    'ine'   => 'indoeuropejski',
    'inh'   => 'inguski',
    'io'    => 'ido',
    'ira'   => 'irański',
    'iro'   => 'irokeski',
    'is'    => 'islandzki',
    'it'    => 'włoski',
    'iu'    => 'inuktitut',
    'ja'    => 'japoński',
    'jbo'   => 'lojban',
    'jpr'   => 'judeoperski',
    'jrb'   => 'judeoarabski',
    'jv'    => 'jawajski',
    'ka'    => 'gruziński',
    'kaa'   => 'karakałpacki',
    'kab'   => 'kabylski',
    'kac'   => 'kaczin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'kareński',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardyjski',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => 'khoisan',
    'kho'   => 'chotański',
    'ki'    => 'kikuju',
    'kj'    => 'kwanyama',
    'kk'    => 'kazachski',
    'kl'    => 'grenlandzki',
    'km'    => 'khmerski',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'koreański',
    'kok'   => 'konkani',
    'kos'   => 'kosrae',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karaczajsko\-bałkarski",
    'krl'   => 'karelski',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'kaszmirski',
    'ku'    => 'kurdyjski',
    'kum'   => 'kumycki',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'kornijski',
    'ky'    => 'kirgiski',
    'la'    => 'łaciński',
    'lad'   => 'ladyński',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luksemburski',
    'lez'   => 'lezgijski',
    'lg'    => 'ganda',
    'li'    => 'limburgijski',
    'ln'    => 'lingala',
    'lo'    => 'laotański',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'litewski',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'lv'    => 'łotewski',
    'mad'   => 'madurajski',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasar',
    'man'   => 'mandingo',
    'map'   => 'austronezyjski',
    'mas'   => 'masajski',
    'mdf'   => 'moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaski',
    'mga'   => 'średnioirlandzki',
    'mh'    => 'marshall',
    'mi'    => 'maoryjski',
    'mic'   => 'micmac',
    'min'   => 'minangkabu',
    'mis'   => "inny\ język",
    'mk'    => 'macedoński',
    'mkh'   => "mon\-khmer",
    'ml'    => 'malajalam',
    'mn'    => 'mongolski',
    'mnc'   => 'manchu',
    'mni'   => 'manipuryjski',
    'mno'   => 'manobo',
    'mo'    => 'mołdawski',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malajski',
    'mt'    => 'maltański',
    'mul'   => "wiele\ języków",
    'mun'   => 'mundajski',
    'mus'   => 'creek',
    'mwl'   => 'mirandese',
    'mwr'   => 'marwari',
    'my'    => 'birmański',
    'myn'   => "język\ Majów",
    'myv'   => 'erzya',
    'na'    => 'nauru',
    'nah'   => 'nahuatl',
    'nai'   => "język\ Indian\ północnoamerykańskich",
    'nap'   => 'neapolitański',
    'nb'    => "norweski\ Bokmål",
    'nd'    => "ndebele\ północny",
    'nds'   => 'dolnosaksoński',
    'ne'    => 'nepalski',
    'new'   => 'newarski',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => 'nigrokordofański',
    'niu'   => 'niue',
    'nl'    => 'niderlandzki',
    'nl_be' => "flamandzki\ \(Belgia\)",
    'nn'    => "norweski\ Nynorsk",
    'no'    => 'norweski',
    'nog'   => 'nogajski',
    'non'   => 'staronordyjski',
    'nqo'   => 'n’ko',
    'nr'    => "ndebele\ południowy",
    'nso'   => "sotho\ północny",
    'nub'   => 'nubijski',
    'nv'    => 'nawaho',
    'nwc'   => "newarski\ klasyczny",
    'ny'    => 'njandża',
    'nym'   => 'niamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzema',
    'oc'    => 'prowansalski',
    'oj'    => 'odżibwa',
    'om'    => 'oromski',
    'or'    => 'orija',
    'os'    => 'osetyjski',
    'osa'   => 'osage',
    'ota'   => "osmańsko\-turecki",
    'oto'   => 'otomi',
    'pa'    => 'pendżabski',
    'paa'   => 'papuaski',
    'pag'   => 'pangasino',
    'pal'   => 'pahlavi',
    'pam'   => 'pampango',
    'pap'   => 'papiamento',
    'pau'   => 'palau',
    'peo'   => 'staroperski',
    'phi'   => 'filipiński',
    'phn'   => 'fenicki',
    'pi'    => 'palijski',
    'pl'    => 'polski',
    'pon'   => 'ponpejski',
    'pra'   => 'prakryty',
    'pro'   => 'staroprowansalski',
    'ps'    => 'paszto',
    'pt'    => 'portugalski',
    'pt_br' => "brazylyjski\ portugalski",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'keczua',
    'raj'   => 'radźasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotonga',
    'rm'    => 'retoromański',
    'rn'    => 'rundi',
    'ro'    => 'rumuński',
    'roa'   => 'romański',
    'rom'   => 'cygański',
    'ru'    => 'rosyjski',
    'rup'   => 'arumuński',
    'rw'    => "kinya\-ruanda",
    'sa'    => 'sanskryt',
    'sad'   => 'sandawe',
    'sah'   => 'jakucki',
    'sai'   => "język\ Indian\ południowoamerykańskich",
    'sal'   => 'salisz',
    'sam'   => "samarytański\ aramejski",
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sc'    => 'sardyński',
    'scn'   => 'sycylijski',
    'sco'   => 'szkocki',
    'sd'    => 'sindhi',
    'se'    => "lapoński\ północny",
    'sel'   => 'selkupski',
    'sem'   => 'semicki',
    'sg'    => 'sango',
    'sga'   => 'staroirlandzki',
    'sgn'   => 'migowy',
    'sh'    => "serbsko\-chorwacki",
    'shn'   => 'shan',
    'si'    => 'syngaleski',
    'sid'   => 'sidamo',
    'sio'   => 'siouański',
    'sit'   => "chińsko\-tybetański",
    'sk'    => 'słowacki',
    'sl'    => 'słoweński',
    'sla'   => 'słowiański',
    'sm'    => 'samoański',
    'sma'   => "lapoński\ południowy",
    'smi'   => 'lapoński',
    'smj'   => "lapoński\ Lule",
    'smn'   => "lapoński\ Inari",
    'sms'   => "lapoński\ Skolt",
    'sn'    => 'szona',
    'snk'   => 'soninke',
    'so'    => 'somalijski',
    'sog'   => 'sogdyjski',
    'son'   => 'songhaj',
    'sq'    => 'albański',
    'sr'    => 'serbski',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'siswati',
    'ssa'   => 'nilosaharyjski',
    'st'    => "sotho\ południowy",
    'su'    => 'sundajski',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumeryjski',
    'sv'    => 'szwedzki',
    'sw'    => 'suahili',
    'syc'   => 'syriacki',
    'syr'   => 'syryjski',
    'ta'    => 'tamilski',
    'tai'   => 'tai',
    'te'    => 'telugu',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tadżycki',
    'th'    => 'tajski',
    'ti'    => 'tigrinia',
    'tig'   => 'tigre',
    'tiv'   => 'tiw',
    'tk'    => 'turkmeński',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalski',
    'tlh'   => 'klingoński',
    'tli'   => 'tlingit',
    'tmh'   => 'tamaszek',
    'tn'    => 'setswana',
    'to'    => 'tonga',
    'tog'   => "tonga\ \(Niasa\)",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turecki',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatarski',
    'tum'   => 'tumbuka',
    'tup'   => 'tupi',
    'tut'   => 'ałtajski',
    'tvl'   => 'tuvalu',
    'tw'    => 'twi',
    'ty'    => 'tahitański',
    'tyv'   => 'tuwiński',
    'udm'   => 'udmurcki',
    'ug'    => 'ujgurski',
    'uga'   => 'ugarycki',
    'uk'    => 'ukraiński',
    'umb'   => 'umbundu',
    'und'   => "nieznany\ lub\ niepoprawny\ język",
    'ur'    => 'urdu',
    'uz'    => 'uzbecki',
    'vai'   => 'wai',
    've'    => 'venda',
    'vi'    => 'wietnamski',
    'vo'    => 'volapuk',
    'vot'   => 'wotiacki',
    'wa'    => 'waloński',
    'wak'   => 'wakasz',
    'wal'   => 'walamo',
    'war'   => 'waraj',
    'was'   => 'washo',
    'wen'   => 'łużycki',
    'wo'    => 'wolof',
    'xal'   => 'kałmucki',
    'xh'    => 'khosa',
    'yao'   => 'yao',
    'yap'   => 'japski',
    'yi'    => 'jidysz',
    'yo'    => 'joruba',
    'ypk'   => 'jupik',
    'za'    => 'czuang',
    'zap'   => 'zapotecki',
    'zbl'   => 'bliss',
    'zen'   => 'zenaga',
    'zh'    => 'chiński',
    'znd'   => 'azande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "brak\ treści\ o\ charakterze\ lingwistycznym",
    'zza'   => 'zazaki',
);

%Locales::DB::Language::pl::name_to_code = (
    'abchaski'                                    => 'ab',
    'aceh'                                        => 'ace',
    'aciski'                                      => 'la',
    'aczoli'                                      => 'ach',
    'adangme'                                     => 'ada',
    'adygejski'                                   => 'ady',
    'afar'                                        => 'aa',
    'afrihili'                                    => 'afh',
    'afrikaans'                                   => 'af',
    'afroazjatycki'                               => 'afa',
    'ajmara'                                      => 'ay',
    'ajnu'                                        => 'ain',
    'akadyjski'                                   => 'akk',
    'akan'                                        => 'ak',
    'albaski'                                     => 'sq',
    'aleucki'                                     => 'ale',
    'amharski'                                    => 'am',
    'angielski'                                   => 'en',
    "angielski\ kreolski\ lub\ pidin"             => 'cpe',
    "angielski\ usa"                              => 'en_us',
    'angika'                                      => 'anp',
    'arabski'                                     => 'ar',
    'aragoski'                                    => 'an',
    'aramejski'                                   => 'arc',
    'arapaho'                                     => 'arp',
    'araukaski'                                   => 'arn',
    'arawak'                                      => 'arw',
    "argon\ chinook"                              => 'chn',
    'arumuski'                                    => 'rup',
    'asamski'                                     => 'as',
    'asturyjski'                                  => 'ast',
    'atajski'                                     => 'tut',
    'atsam'                                       => 'cch',
    "australian\ english"                         => 'en_au',
    "austriacki\ niemiecki"                       => 'de_at',
    'austronezyjski'                              => 'map',
    'awadhi'                                      => 'awa',
    'awarski'                                     => 'av',
    'awestyjski'                                  => 'ae',
    'azande'                                      => 'znd',
    'azerski'                                     => 'az',
    'balijski'                                    => 'ban',
    'bambara'                                     => 'bm',
    'bantu'                                       => 'bnt',
    'basa'                                        => 'bas',
    'baskijski'                                   => 'eu',
    'baszkirski'                                  => 'ba',
    'batak'                                       => 'btk',
    'batycki'                                     => 'bat',
    'beda'                                        => 'bej',
    'beludi'                                      => 'bal',
    'bemba'                                       => 'bem',
    'bengalski'                                   => 'bn',
    'berberski'                                   => 'ber',
    'bhodpuri'                                    => 'bho',
    'biaoruski'                                   => 'be',
    'biharski'                                    => 'bh',
    'bikol'                                       => 'bik',
    'bini'                                        => 'bin',
    'birmaski'                                    => 'my',
    'bislama'                                     => 'bi',
    'blin'                                        => 'byn',
    'bliss'                                       => 'zbl',
    'boniacki'                                    => 'bs',
    'brad'                                        => 'bra',
    "brak\ treci\ o\ charakterze\ lingwistycznym" => 'zxx',
    "brazylyjski\ portugalski"                    => 'pt_br',
    'bretoski'                                    => 'br',
    "brytyjski\ angielski"                        => 'en_gb',
    'bugarski'                                    => 'bg',
    'bugiski'                                     => 'bug',
    'buriacki'                                    => 'bua',
    'cebuano'                                     => 'ceb',
    'celtycki'                                    => 'cel',
    'chamorro'                                    => 'ch',
    'chipewyan'                                   => 'chp',
    'chiski'                                      => 'zh',
    'chiskotybetaski'                             => 'sit',
    'choctaw'                                     => 'cho',
    'chorwacki'                                   => 'hr',
    'chotaski'                                    => 'kho',
    'creek'                                       => 'mus',
    'cygaski'                                     => 'rom',
    'czagatajski'                                 => 'chg',
    'czam'                                        => 'cmc',
    'czeczeski'                                   => 'ce',
    'czeski'                                      => 'cs',
    'czibcza'                                     => 'chb',
    'czirokezki'                                  => 'chr',
    'czuang'                                      => 'za',
    'czuwaski'                                    => 'cv',
    'dajak'                                       => 'day',
    'dakota'                                      => 'dak',
    'dargwijski'                                  => 'dar',
    'delaware'                                    => 'del',
    'dinka'                                       => 'din',
    'dogri'                                       => 'doi',
    'dogrib'                                      => 'dgr',
    'dolnosaksoski'                               => 'nds',
    'dolnouycki'                                  => 'dsb',
    'drawidyjski'                                 => 'dra',
    'duala'                                       => 'dua',
    'duski'                                       => 'da',
    'dyula'                                       => 'dyu',
    'dzongkha'                                    => 'dz',
    'efik'                                        => 'efi',
    'ekajuk'                                      => 'eka',
    'elamicki'                                    => 'elx',
    'erzya'                                       => 'myv',
    'esperanto'                                   => 'eo',
    'estoski'                                     => 'et',
    'ewe'                                         => 'ee',
    'ewondo'                                      => 'ewo',
    'fang'                                        => 'fan',
    'fanti'                                       => 'fat',
    'farerski'                                    => 'fo',
    'fenicki'                                     => 'phn',
    'fidijski'                                    => 'fj',
    'filipino'                                    => 'fil',
    'filipiski'                                   => 'phi',
    'fiski'                                       => 'fi',
    "flamandzki\ belgia"                          => 'nl_be',
    'fon'                                         => 'fon',
    'francuski'                                   => 'fr',
    "francuski\ kreolski\ lub\ pidin"             => 'cpf',
    'friulijski'                                  => 'fur',
    'fryzyjski'                                   => 'fy',
    "fryzyjski\ wschodni"                         => 'frs',
    'fulani'                                      => 'ff',
    'ga'                                          => 'gaa',
    'galisyjski'                                  => 'gl',
    'ganda'                                       => 'lg',
    'gayo'                                        => 'gay',
    'gbaya'                                       => 'gba',
    'germaski'                                    => 'gem',
    'gilbertaski'                                 => 'gil',
    'gocki'                                       => 'got',
    'gondi'                                       => 'gon',
    'gorontalo'                                   => 'gor',
    'grebo'                                       => 'grb',
    'grecki'                                      => 'el',
    'grenlandzki'                                 => 'kl',
    'grnouycki'                                   => 'hsb',
    'gruziski'                                    => 'ka',
    'guarani'                                     => 'gn',
    'gudaracki'                                   => 'gu',
    'gwichin'                                     => 'gwi',
    'gyyz'                                        => 'gez',
    'haida'                                       => 'hai',
    'haitaski'                                    => 'ht',
    'hausa'                                       => 'ha',
    'hawajski'                                    => 'haw',
    'hebrajski'                                   => 'he',
    'herero'                                      => 'hz',
    'hetycki'                                     => 'hit',
    'hiligajnon'                                  => 'hil',
    'himachali'                                   => 'him',
    'hindi'                                       => 'hi',
    "hiri\ motu"                                  => 'ho',
    'hiszpaski'                                   => 'es',
    'hmongijski'                                  => 'hmn',
    'hupa'                                        => 'hup',
    'ibanag'                                      => 'iba',
    "iberian\ portuguese"                         => 'pt_pt',
    "iberian\ spanish"                            => 'es_es',
    'ido'                                         => 'io',
    'igbo'                                        => 'ig',
    'ijo'                                         => 'ijo',
    'ilokano'                                     => 'ilo',
    'indoaryjski'                                 => 'inc',
    'indoeuropejski'                              => 'ine',
    'indonezyjski'                                => 'id',
    'inguski'                                     => 'inh',
    "inny\ jzyk"                                  => 'mis',
    'interlingua'                                 => 'ia',
    'interlingue'                                 => 'ie',
    'inuktitut'                                   => 'iu',
    'inupiak'                                     => 'ik',
    'iraski'                                      => 'ira',
    'irlandzki'                                   => 'ga',
    'irokeski'                                    => 'iro',
    'islandzki'                                   => 'is',
    'jakucki'                                     => 'sah',
    'japoski'                                     => 'ja',
    'japski'                                      => 'yap',
    'jawajski'                                    => 'jv',
    'jidysz'                                      => 'yi',
    'jju'                                         => 'kaj',
    'joruba'                                      => 'yo',
    'judeoarabski'                                => 'jrb',
    'judeoperski'                                 => 'jpr',
    'jupik'                                       => 'ypk',
    "jzyk\ apaczw"                                => 'apa',
    "jzyk\ atapaskw"                              => 'ath',
    "jzyk\ australijski"                          => 'aus',
    "jzyk\ bamileke"                              => 'bai',
    "jzyk\ banda"                                 => 'bad',
    "jzyk\ czejenw"                               => 'chy',
    "jzyk\ indian\ pnocnoamerykaskich"            => 'nai',
    "jzyk\ indian\ poudniowoamerykaskich"         => 'sai',
    "jzyk\ indian\ rodkowoamerykaskich"           => 'cai',
    "jzyk\ majw"                                  => 'myn',
    "jzyki\ algonkin"                             => 'alg',
    'kabardyjski'                                 => 'kbd',
    'kabylski'                                    => 'kab',
    'kaczin'                                      => 'kac',
    'kaddo'                                       => 'cad',
    'kamba'                                       => 'kam',
    'kamucki'                                     => 'xal',
    "kanadyjski\ angielski"                       => 'en_ca',
    "kanadyjski\ francuski"                       => 'fr_ca',
    'kannada'                                     => 'kn',
    'kanuri'                                      => 'kr',
    'karaczajskobakarski'                         => 'krc',
    'karakapacki'                                 => 'kaa',
    'karelski'                                    => 'krl',
    'kareski'                                     => 'kar',
    'karibi'                                      => 'car',
    'kaszmirski'                                  => 'ks',
    'kaszubski'                                   => 'csb',
    'kataloski'                                   => 'ca',
    'kaukaski'                                    => 'cau',
    'kawi'                                        => 'kaw',
    'kazachski'                                   => 'kk',
    'keczua'                                      => 'qu',
    'khasi'                                       => 'kha',
    'khmerski'                                    => 'km',
    'khoisan'                                     => 'khi',
    'khosa'                                       => 'xh',
    'kikuju'                                      => 'ki',
    'kimbundu'                                    => 'kmb',
    'kinyaruanda'                                 => 'rw',
    'kirgiski'                                    => 'ky',
    'klingoski'                                   => 'tlh',
    'komi'                                        => 'kv',
    'kongo'                                       => 'kg',
    'konkani'                                     => 'kok',
    'koptyjski'                                   => 'cop',
    'koreaski'                                    => 'ko',
    'kornijski'                                   => 'kw',
    'koro'                                        => 'kfo',
    'korsykaski'                                  => 'co',
    'kosrae'                                      => 'kos',
    'kpelle'                                      => 'kpe',
    "kreolski\ lub\ pidin"                        => 'crp',
    'kri'                                         => 'cr',
    'kru'                                         => 'kro',
    "krymski\ turecki"                            => 'crh',
    'kumycki'                                     => 'kum',
    'kurdyjski'                                   => 'ku',
    'kurukh'                                      => 'kru',
    'kuszycki'                                    => 'cus',
    'kutenai'                                     => 'kut',
    'kwanyama'                                    => 'kj',
    'ladyski'                                     => 'lad',
    'lahnda'                                      => 'lah',
    'lamba'                                       => 'lam',
    'laotaski'                                    => 'lo',
    'laposki'                                     => 'smi',
    "laposki\ inari"                              => 'smn',
    "laposki\ lule"                               => 'smj',
    "laposki\ pnocny"                             => 'se',
    "laposki\ poudniowy"                          => 'sma',
    "laposki\ skolt"                              => 'sms',
    'lezgijski'                                   => 'lez',
    'limburgijski'                                => 'li',
    'lingala'                                     => 'ln',
    'litewski'                                    => 'lt',
    'lojban'                                      => 'jbo',
    'lozi'                                        => 'loz',
    'lubakatanga'                                 => 'lu',
    'lubalulua'                                   => 'lua',
    'luiseno'                                     => 'lui',
    'luksemburski'                                => 'lb',
    'lunda'                                       => 'lun',
    'luo'                                         => 'luo',
    'lushai'                                      => 'lus',
    'macedoski'                                   => 'mk',
    'madurajski'                                  => 'mad',
    'magahi'                                      => 'mag',
    'maithili'                                    => 'mai',
    'makasar'                                     => 'mak',
    'malajalam'                                   => 'ml',
    'malajski'                                    => 'ms',
    'malediwski'                                  => 'dv',
    'malgaski'                                    => 'mg',
    'maltaski'                                    => 'mt',
    'manchu'                                      => 'mnc',
    'mandar'                                      => 'mdr',
    'mandingo'                                    => 'man',
    'manipuryjski'                                => 'mni',
    'manobo'                                      => 'mno',
    'manx'                                        => 'gv',
    'maoryjski'                                   => 'mi',
    'marathi'                                     => 'mr',
    'marshall'                                    => 'mh',
    'marwari'                                     => 'mwr',
    'maryjski'                                    => 'chm',
    'masajski'                                    => 'mas',
    'mende'                                       => 'men',
    'micmac'                                      => 'mic',
    'migowy'                                      => 'sgn',
    'minangkabu'                                  => 'min',
    'mirandese'                                   => 'mwl',
    'modawski'                                    => 'mo',
    'mohawk'                                      => 'moh',
    'moksha'                                      => 'mdf',
    'mongo'                                       => 'lol',
    'mongolski'                                   => 'mn',
    'monkhmer'                                    => 'mkh',
    'morisyen'                                    => 'mfe',
    'mossi'                                       => 'mos',
    'mundajski'                                   => 'mun',
    'nahuatl'                                     => 'nah',
    'nauru'                                       => 'na',
    'nawaho'                                      => 'nv',
    "ndebele\ pnocny"                             => 'nd',
    "ndebele\ poudniowy"                          => 'nr',
    'ndonga'                                      => 'ng',
    'neapolitaski'                                => 'nap',
    'nepalski'                                    => 'ne',
    'newarski'                                    => 'new',
    "newarski\ klasyczny"                         => 'nwc',
    'niamwezi'                                    => 'nym',
    'nias'                                        => 'nia',
    'niderlandzki'                                => 'nl',
    'niemiecki'                                   => 'de',
    "nieznany\ lub\ niepoprawny\ jzyk"            => 'und',
    'nigrokordofaski'                             => 'nic',
    'nilosaharyjski'                              => 'ssa',
    'niue'                                        => 'niu',
    'njanda'                                      => 'ny',
    'nko'                                         => 'nqo',
    'nogajski'                                    => 'nog',
    'norweski'                                    => 'no',
    "norweski\ bokml"                             => 'nb',
    "norweski\ nynorsk"                           => 'nn',
    'nubijski'                                    => 'nub',
    'nyankole'                                    => 'nyn',
    'nyoro'                                       => 'nyo',
    'nzema'                                       => 'nzi',
    'odibwa'                                      => 'oj',
    'orija'                                       => 'or',
    'ormiaski'                                    => 'hy',
    'oromski'                                     => 'om',
    'osage'                                       => 'osa',
    'osetyjski'                                   => 'os',
    'osmaskoturecki'                              => 'ota',
    'otewski'                                     => 'lv',
    'otomi'                                       => 'oto',
    'pahlavi'                                     => 'pal',
    'palau'                                       => 'pau',
    'palijski'                                    => 'pi',
    'pampango'                                    => 'pam',
    'pangasino'                                   => 'pag',
    'papiamento'                                  => 'pap',
    'papuaski'                                    => 'paa',
    'paszto'                                      => 'ps',
    'pendabski'                                   => 'pa',
    'perski'                                      => 'fa',
    'pnocnofryzyjski'                             => 'frr',
    'polski'                                      => 'pl',
    'ponpejski'                                   => 'pon',
    'portugalski'                                 => 'pt',
    "portugalski\ kreolski\ lub\ pidin"           => 'cpp',
    'poudniowoatajski'                            => 'alt',
    'prakryty'                                    => 'pra',
    'prowansalski'                                => 'oc',
    'radasthani'                                  => 'raj',
    'rapanui'                                     => 'rap',
    'rarotonga'                                   => 'rar',
    'rednioangielski'                             => 'enm',
    'redniofrancuski'                             => 'frm',
    'rednioirlandzki'                             => 'mga',
    "redniowieczny\ niderlandzki"                 => 'dum',
    'redniowysokoniemiecki'                       => 'gmh',
    'retoromaski'                                 => 'rm',
    'romaski'                                     => 'roa',
    'rosyjski'                                    => 'ru',
    'rumuski'                                     => 'ro',
    'rundi'                                       => 'rn',
    'salisz'                                      => 'sal',
    "samarytaski\ aramejski"                      => 'sam',
    'samoaski'                                    => 'sm',
    'sandawe'                                     => 'sad',
    'sango'                                       => 'sg',
    'sanskryt'                                    => 'sa',
    'santali'                                     => 'sat',
    'sardyski'                                    => 'sc',
    'sasak'                                       => 'sas',
    'selkupski'                                   => 'sel',
    'semicki'                                     => 'sem',
    'serbski'                                     => 'sr',
    'serbskochorwacki'                            => 'sh',
    'serer'                                       => 'srr',
    'setswana'                                    => 'tn',
    'shan'                                        => 'shn',
    'sidamo'                                      => 'sid',
    'siksika'                                     => 'bla',
    'sindhi'                                      => 'sd',
    'siouaski'                                    => 'sio',
    'siswati'                                     => 'ss',
    'slave'                                       => 'den',
    'sogdyjski'                                   => 'sog',
    'somalijski'                                  => 'so',
    'songhaj'                                     => 'son',
    'soninke'                                     => 'snk',
    "sotho\ pnocny"                               => 'nso',
    "sotho\ poudniowy"                            => 'st',
    'sowacki'                                     => 'sk',
    'soweski'                                     => 'sl',
    'sowiaski'                                    => 'sla',
    "sranan\ tongo"                               => 'srn',
    'staroangielski'                              => 'ang',
    'starocerkiewnosowiaski'                      => 'cu',
    'starofrancuski'                              => 'fro',
    'starogrecki'                                 => 'grc',
    'staroirlandzki'                              => 'sga',
    'staronordyjski'                              => 'non',
    'staroperski'                                 => 'peo',
    'staroprowansalski'                           => 'pro',
    'starowysokoniemiecki'                        => 'goh',
    "staroytny\ egipski"                          => 'egy',
    'suahili'                                     => 'sw',
    'sukuma'                                      => 'suk',
    'sumeryjski'                                  => 'sux',
    'sundajski'                                   => 'su',
    'susu'                                        => 'sus',
    "swiss\ french"                               => 'fr_ch',
    'sycylijski'                                  => 'scn',
    'syczuaski'                                   => 'ii',
    'syngaleski'                                  => 'si',
    'syriacki'                                    => 'syc',
    'syryjski'                                    => 'syr',
    'szkocki'                                     => 'sco',
    "szkocki\ gaelicki"                           => 'gd',
    'szona'                                       => 'sn',
    'sztuczny'                                    => 'art',
    "szwajcarski\ niemiecki"                      => 'gsw',
    'szwedzki'                                    => 'sv',
    'tadycki'                                     => 'tg',
    'tagalski'                                    => 'tl',
    'tahitaski'                                   => 'ty',
    'tai'                                         => 'tai',
    'tajski'                                      => 'th',
    'tamaszek'                                    => 'tmh',
    'tamilski'                                    => 'ta',
    'taroko'                                      => 'trv',
    'tatarski'                                    => 'tt',
    'telugu'                                      => 'te',
    'temne'                                       => 'tem',
    'tereno'                                      => 'ter',
    'tetum'                                       => 'tet',
    'tigre'                                       => 'tig',
    'tigrinia'                                    => 'ti',
    'tiw'                                         => 'tiv',
    'tlingit'                                     => 'tli',
    "tok\ pisin"                                  => 'tpi',
    'tokelau'                                     => 'tkl',
    'tonga'                                       => 'to',
    "tonga\ niasa"                                => 'tog',
    'truk'                                        => 'chk',
    'tsimshian'                                   => 'tsi',
    'tsonga'                                      => 'ts',
    'tumbuka'                                     => 'tum',
    'tupi'                                        => 'tup',
    'turecki'                                     => 'tr',
    'turkmeski'                                   => 'tk',
    'tuvalu'                                      => 'tvl',
    'tuwiski'                                     => 'tyv',
    'twi'                                         => 'tw',
    'tyap'                                        => 'kcg',
    'tybetaski'                                   => 'bo',
    'udmurcki'                                    => 'udm',
    'ugarycki'                                    => 'uga',
    'ugrofiski'                                   => 'fiu',
    'ujgurski'                                    => 'ug',
    'ukraiski'                                    => 'uk',
    'umbundu'                                     => 'umb',
    'urdu'                                        => 'ur',
    'uycki'                                       => 'wen',
    'uzbecki'                                     => 'uz',
    'venda'                                       => 've',
    'volapuk'                                     => 'vo',
    'wai'                                         => 'vai',
    'wakasz'                                      => 'wak',
    'walamo'                                      => 'wal',
    'walijski'                                    => 'cy',
    'waloski'                                     => 'wa',
    'waraj'                                       => 'war',
    'washo'                                       => 'was',
    'wgierski'                                    => 'hu',
    "wiele\ jzykw"                                => 'mul',
    'wietnamski'                                  => 'vi',
    'wolof'                                       => 'wo',
    'woski'                                       => 'it',
    'wotiacki'                                    => 'vot',
    "wysokoniemiecki\ szwajcaria"                 => 'de_ch',
    'yao'                                         => 'yao',
    'zapotecki'                                   => 'zap',
    'zazaki'                                      => 'zza',
    'zenaga'                                      => 'zen',
    'zulu'                                        => 'zu',
    'zuni'                                        => 'zun',
);

1;
