package Locales::DB::Language::is;

# Auto generated from CLDR

$Locales::DB::Language::is::VERSION = '0.01';

$Locales::DB::Language::is::cldr_version = '1.7.1';

%Locales::DB::Language::is::misc_info = (
    'cldr_formats' => {
        'decimal' => {
            'content' => "\#\,\#\#0\.\#\#\#",
            'draft'   => 'contributed'
        },
        'language' => "tungumál\:\ \{0\}",
        'locale'   => {
            'content' => "\{0\}\ \(\{1\}\)",
            'draft'   => 'contributed'
        },
        'percent' => [
            {
                'content' => "\#\,\#\#0\%",
                'draft'   => 'contributed'
            },
            {
                'alt'     => "proposed\-x1001",
                'content' => "\#\,\#\#0 \%",
                'draft'   => 'unconfirmed'
            }
        ],
        'territory' => "svæði\:\ \{0\}"
    },
    'fallback'    => [ "nn\ sv\ nb\ da\ en" ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "nei\:n",
            'draft'   => 'contributed'
        },
        'yesstr' => {
            'content' => "já\:j",
            'draft'   => 'contributed'
        }
    },
);

%Locales::DB::Language::is::code_to_name = (
    'aa'    => 'afár',
    'ab'    => 'abkasíska',
    'ace'   => 'akkíska',
    'ach'   => 'akólí',
    'ada'   => 'adangme',
    'ady'   => 'adýge',
    'ae'    => 'avestíska',
    'af'    => 'afríkanska',
    'afa'   => "afróasísk\ mál",
    'afh'   => 'afríhílí',
    'ain'   => "aínu\ \(Japan\)",
    'ak'    => 'akan',
    'akk'   => 'akkadíska',
    'ale'   => 'aleutíska',
    'alg'   => "algonkvínsk\ mál",
    'alt'   => 'suðuraltaíska',
    'am'    => 'amharíska',
    'an'    => 'aragonska',
    'ang'   => 'fornenska',
    'anp'   => 'angíka',
    'apa'   => 'apatsjamál',
    'ar'    => 'arabíska',
    'arc'   => "officiell\ arameíska",
    'arn'   => 'arákaníska',
    'arp'   => 'arapahó',
    'art'   => 'alþjóðamál',
    'arw'   => 'aravakska',
    'as'    => 'assameíska',
    'ast'   => 'astúríska',
    'ath'   => "atapaskísk\ mál",
    'aus'   => "áströlsk\ mál",
    'av'    => 'avaríska',
    'awa'   => 'avadí',
    'ay'    => 'aímara',
    'az'    => 'aserska',
    'ba'    => 'baskír',
    'bad'   => 'bandasmál',
    'bai'   => "bamilékísk\ mál",
    'bal'   => 'balúkí',
    'ban'   => 'balíska',
    'bas'   => "basa\ \(Kamerun\)",
    'bat'   => "baltnesk\ mál",
    'be'    => 'hvítrússneska',
    'bej'   => 'beja',
    'bem'   => "bemba\ \(Zambia\)",
    'ber'   => 'berbamál',
    'bg'    => 'búlgarska',
    'bh'    => "bíharísk\ mál",
    'bho'   => 'bojpúrí',
    'bi'    => 'bíslama',
    'bik'   => 'bícolano',
    'bin'   => 'bíní',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalska',
    'bnt'   => 'bantúmál',
    'bo'    => 'tíbeska',
    'br'    => 'bretónska',
    'bra'   => 'braí',
    'bs'    => 'bosníska',
    'btk'   => 'batakmál',
    'bua'   => 'búríat',
    'bug'   => 'búgíska',
    'byn'   => 'blín',
    'ca'    => 'katalónska',
    'cad'   => 'kaddó',
    'cai'   => "Mið\-Ameríku\ indíánamál",
    'car'   => 'galibíska',
    'cau'   => 'kákasusmál',
    'cch'   => 'atsam',
    'ce'    => 'tsjetsjenska',
    'ceb'   => 'kebúanó',
    'cel'   => "keltnesk\ mál",
    'ch'    => 'kamorró',
    'chb'   => 'síbsja',
    'chg'   => 'sjagataí',
    'chk'   => 'sjúkíska',
    'chm'   => "maríska\ \(Rusland\)",
    'chn'   => "sínúk\ pidginenska",
    'cho'   => 'sjoktá',
    'chp'   => 'sípevíska',
    'chr'   => 'sjerókí',
    'chy'   => 'sjeyen',
    'cmc'   => "kamísk\ mál",
    'co'    => 'korsíska',
    'cop'   => 'koptíska',
    'cpe'   => "kreól\-\ eða\ pidginmál\ á\ enskum\ grunni",
    'cpf'   => "kreól\-\ eða\ pidginmál\ á\ frönskum\ grunni",
    'cpp'   => "kreól\-\ eða\ pidginmál\ á\ portúgölskum\ grunni",
    'cr'    => 'krí',
    'crh'   => 'krímtyrkneska',
    'crp'   => "kreól\-\ eða\ pidginmál",
    'cs'    => 'tékkneska',
    'csb'   => 'kasúbíska',
    'cu'    => 'kirkjuslavneska',
    'cus'   => "kúsitísk\ mál",
    'cv'    => 'sjúvas',
    'cy'    => 'velska',
    'da'    => 'danska',
    'dak'   => 'dakóta',
    'dar'   => 'dargva',
    'day'   => 'bidayuhmál',
    'de'    => 'þýska',
    'de_at' => "austurrísk\ þýska",
    'de_ch' => "svissnesk\ háþýska",
    'del'   => 'delaver',
    'den'   => 'slavéj',
    'dgr'   => 'dogríb',
    'din'   => 'dinka',
    'doi'   => "dogri\-kangri",
    'dra'   => "dravidísk\ mál",
    'dsb'   => 'lágsorbneska',
    'dua'   => 'dúala',
    'dum'   => 'miðhollenska',
    'dv'    => 'dívehí',
    'dyu'   => 'djúla',
    'dz'    => 'dsongka',
    'ee'    => 'eve',
    'efi'   => 'efík',
    'egy'   => 'fornegypska',
    'eka'   => 'ekajúk',
    'el'    => 'gríska',
    'elx'   => 'elamít',
    'en'    => 'enska',
    'en_au' => "áströlsk\ enska",
    'en_ca' => "kanadísk\ enska",
    'en_gb' => "bresk\ enska",
    'en_us' => "bandarísk\ enska",
    'enm'   => 'miðenska',
    'eo'    => 'esperantó',
    'es'    => 'spænska',
    'es_es' => "íberísk\ spænska",
    'et'    => 'eistneska',
    'eu'    => 'baskneska',
    'ewo'   => 'evondó',
    'fa'    => 'persneska',
    'fan'   => 'fang',
    'fat'   => 'fantí',
    'ff'    => 'fulfulde',
    'fi'    => 'finnska',
    'fil'   => 'filipínska',
    'fiu'   => "finnskúgrísk\ mál",
    'fj'    => 'fídjeyska',
    'fo'    => 'færeyska',
    'fon'   => 'fón',
    'fr'    => 'franska',
    'fr_ca' => "kanadísk\ franska",
    'fr_ch' => "svissnesk\ franska",
    'frm'   => 'miðfranska',
    'fro'   => 'fornfranska',
    'frr'   => 'norðurfrísneska',
    'frs'   => 'austurfrísneska',
    'fur'   => 'fríúlska',
    'fy'    => 'frísneska',
    'ga'    => 'írska',
    'gaa'   => 'ga',
    'gay'   => 'gajó',
    'gba'   => 'gbaja',
    'gd'    => "skosk\ gelíska",
    'gem'   => "germönsk\ mál",
    'gez'   => 'gís',
    'gil'   => 'gilberska',
    'gl'    => 'gallegska',
    'gmh'   => 'miðháþýska',
    'gn'    => 'gvaraní',
    'goh'   => 'fornháþýska',
    'gon'   => 'gondí',
    'gor'   => 'gorontaló',
    'got'   => 'gotneska',
    'grb'   => 'gerbó',
    'grc'   => 'forngríska',
    'gsw'   => "svissnesk\ þýska",
    'gu'    => 'gújaratí',
    'gv'    => 'manx',
    'gwi'   => 'gvísín',
    'ha'    => 'hása',
    'hai'   => 'haída',
    'haw'   => 'havaíska',
    'he'    => 'hebreska',
    'hi'    => 'hindí',
    'hil'   => 'híligaínon',
    'him'   => "hímasjalísk\ mál",
    'hit'   => 'hettitíska',
    'hmn'   => 'hmong',
    'ho'    => 'hírímótú',
    'hr'    => 'króatíska',
    'hsb'   => 'hásorbneska',
    'ht'    => 'haítíska',
    'hu'    => 'ungverska',
    'hup'   => 'húpa',
    'hy'    => 'armenska',
    'hz'    => 'hereró',
    'ia'    => 'interlingva',
    'iba'   => 'íban',
    'id'    => 'indónesíska',
    'ie'    => 'interlingve',
    'ig'    => 'ígbó',
    'ii'    => 'sísúanjí',
    'ijo'   => 'íjómál',
    'ik'    => 'ínúpíak',
    'ilo'   => 'ílokó',
    'inc'   => "indversk\ mál",
    'ine'   => "indóevrópsk\ mál",
    'inh'   => 'ingús',
    'io'    => 'ídó',
    'ira'   => 'íranska',
    'iro'   => "írókesk\ mál",
    'is'    => 'íslenska',
    'it'    => 'ítalska',
    'iu'    => 'inúktitút',
    'ja'    => 'japanska',
    'jbo'   => 'lojban',
    'jpr'   => 'gyðingapersneska',
    'jrb'   => 'gyðingaarabíska',
    'jv'    => 'javanska',
    'ka'    => 'georgíska',
    'kaa'   => 'karakalpak',
    'kab'   => 'kabíle',
    'kac'   => 'kasín',
    'kaj'   => 'jju',
    'kam'   => "kamba\ \(Kenya\)",
    'kar'   => "karénsk\ mál",
    'kaw'   => 'kaví',
    'kbd'   => 'kabardíska',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongó',
    'kha'   => 'kasí',
    'khi'   => 'koímál',
    'kho'   => 'kotaska',
    'ki'    => 'kíkújú',
    'kj'    => 'kúanjama',
    'kk'    => 'kasakska',
    'kl'    => 'grænlenska',
    'km'    => 'kambodíska',
    'kmb'   => 'kimbúndú',
    'kn'    => 'kannada',
    'ko'    => 'kóreska',
    'kok'   => 'konkaní',
    'kos'   => 'kosraska',
    'kpe'   => 'kpèllé',
    'kr'    => 'kanúrí',
    'krc'   => 'karasaíbalkar',
    'krl'   => 'karélska',
    'kro'   => 'krúmál',
    'kru'   => 'kúrúk',
    'ks'    => 'kasmírska',
    'ku'    => 'kúrdneska',
    'kum'   => 'kúmík',
    'kut'   => 'kútenaí',
    'kv'    => 'komíska',
    'kw'    => 'korníska',
    'ky'    => 'kirgiska',
    'la'    => 'latína',
    'lad'   => 'ladínska',
    'lah'   => 'landa',
    'lam'   => 'lamba',
    'lb'    => 'lúxemborgíska',
    'lez'   => 'lesgíska',
    'lg'    => 'ganda',
    'li'    => 'limbúrgíska',
    'ln'    => 'lingala',
    'lo'    => 'laó',
    'lol'   => 'mongó',
    'loz'   => 'losí',
    'lt'    => 'litháíska',
    'lu'    => 'lúbakatanga',
    'lua'   => 'lúbalúlúa',
    'lui'   => 'lúisenó',
    'lun'   => 'lúnda',
    'luo'   => 'lúó',
    'lus'   => 'lúsaí',
    'lv'    => 'lettneska',
    'mad'   => 'madúrska',
    'mag'   => 'magahí',
    'mai'   => 'maítílí',
    'mak'   => 'makasar',
    'man'   => 'mandingó',
    'map'   => 'ástrónesíska',
    'mas'   => 'masaí',
    'mdf'   => 'moksa',
    'mdr'   => 'mandar',
    'men'   => "mende\ \(Sierra\ Leone\)",
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasíska',
    'mga'   => 'miðírska',
    'mh'    => 'marshallska',
    'mi'    => 'maórí',
    'mic'   => 'miʼkmak',
    'min'   => 'mínangkabá',
    'mis'   => "\(önnur\ mál\)",
    'mk'    => 'makedónska',
    'mkh'   => 'monkmermál',
    'ml'    => 'malajalam',
    'mn'    => 'mongólska',
    'mnc'   => 'mansjú',
    'mni'   => 'manípúrí',
    'mno'   => 'manóbómál',
    'mo'    => 'moldóvska',
    'moh'   => 'móhíska',
    'mos'   => 'mossí',
    'mr'    => 'maratí',
    'ms'    => 'malaíska',
    'mt'    => 'maltneska',
    'mul'   => "\(margvísleg\ mál\)",
    'mun'   => 'múndamál',
    'mus'   => 'krík',
    'mwl'   => 'mirandesíska',
    'mwr'   => 'marvarí',
    'my'    => 'búrmíska',
    'myn'   => 'majamál',
    'myv'   => 'ersja',
    'na'    => 'nárúska',
    'nah'   => "aztekísk\ mál",
    'nai'   => "Norður\-Ameríku\ indíánamál",
    'nap'   => 'napólíska',
    'nb'    => "norskt\ bókmál",
    'nd'    => 'norðurndebele',
    'nds'   => 'lágþýska',
    'ne'    => 'nepalska',
    'new'   => 'nevaríska',
    'ng'    => 'ndonga',
    'nia'   => 'nías',
    'nic'   => 'nígerkordófanmál',
    'niu'   => 'níveska',
    'nl'    => 'hollenska',
    'nl_be' => 'flæmska',
    'nn'    => 'nýnorska',
    'no'    => 'norska',
    'nog'   => 'nógaí',
    'non'   => 'norræna',
    'nqo'   => "n\-ká",
    'nr'    => 'suðurndebele',
    'nso'   => 'norðursótó',
    'nub'   => "núbísk\ mál",
    'nv'    => 'navahó',
    'nwc'   => "klassísk\ nevaríska",
    'ny'    => 'njanja',
    'nym'   => 'njamvesí',
    'nyn'   => 'njankóle',
    'nyo'   => 'njóró',
    'nzi'   => 'nsíma',
    'oc'    => 'oksítaníska',
    'oj'    => 'ojibva',
    'om'    => 'órómó',
    'or'    => 'óría',
    'os'    => 'ossetíska',
    'osa'   => 'ósage',
    'ota'   => 'osmánska',
    'oto'   => 'ótommál',
    'pa'    => 'púnjabí',
    'paa'   => "papúsk\ mál",
    'pag'   => 'pangasinán',
    'pal'   => 'palaví',
    'pam'   => 'pampanga',
    'pap'   => 'papíamentó',
    'pau'   => 'paláska',
    'peo'   => 'fornpersneska',
    'phi'   => "filippseysk\ mál",
    'phn'   => 'fönikíska',
    'pi'    => 'palí',
    'pl'    => 'pólska',
    'pon'   => 'ponpeiska',
    'pra'   => 'prakrítmál',
    'pro'   => 'fornpróvensalska',
    'ps'    => 'pastú',
    'pt'    => 'portúgalska',
    'pt_br' => "brasílísk\ portúgalska",
    'pt_pt' => "íberísk\ portúgalska",
    'qu'    => 'kvesjúa',
    'raj'   => 'rajastaní',
    'rap'   => 'rapanúí',
    'rar'   => 'rarótongska',
    'rm'    => 'retórómanska',
    'rn'    => 'rúndí',
    'ro'    => 'rúmenska',
    'roa'   => "rómönsk\ mál",
    'rom'   => 'romaní',
    'ru'    => 'rússneska',
    'rup'   => 'arúmenska',
    'rw'    => 'kínjarvanda',
    'sa'    => 'sanskrít',
    'sad'   => 'sandave',
    'sah'   => 'jakút',
    'sai'   => "Suður\-Ameríku\ indíánamál",
    'sal'   => 'salísmál',
    'sam'   => "samversk\ arameíska",
    'sas'   => 'sasak',
    'sat'   => 'santalí',
    'sc'    => 'sardínska',
    'scn'   => 'sikileyska',
    'sco'   => 'skoska',
    'sd'    => 'sindí',
    'se'    => 'norðursamíska',
    'sel'   => 'selkúp',
    'sem'   => "semísk\ mál",
    'sg'    => 'sangó',
    'sga'   => 'fornírska',
    'sgn'   => 'táknmál',
    'sh'    => 'serbókróatíska',
    'shn'   => 'sjan',
    'si'    => 'singalesíska',
    'sid'   => 'sídamó',
    'sio'   => 'síúmál',
    'sit'   => "sínótíbesk\ mál",
    'sk'    => 'slóvakíska',
    'sl'    => 'slóvenska',
    'sla'   => "slavnesk\ mál",
    'sm'    => 'samóska',
    'sma'   => 'suðursamíska',
    'smi'   => "samísk\ mál",
    'smj'   => 'lúlesamíska',
    'smn'   => 'enaresamíska',
    'sms'   => 'skoltesamíska',
    'sn'    => 'shóna',
    'snk'   => 'sóninke',
    'so'    => 'sómalska',
    'sog'   => 'sogdíen',
    'son'   => 'songhaímál',
    'sq'    => 'albanska',
    'sr'    => 'serbneska',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'svatí',
    'ssa'   => 'nílósaharamál',
    'st'    => 'suðursótó',
    'su'    => 'súndanska',
    'suk'   => 'súkúma',
    'sus'   => 'súsú',
    'sux'   => 'súmerska',
    'sv'    => 'sænska',
    'sw'    => 'svahílí',
    'syc'   => "klassisk\ sýrlenska",
    'syr'   => 'sýrlenska',
    'ta'    => 'tamílska',
    'tai'   => 'taímál',
    'te'    => 'telúgú',
    'tem'   => 'tímne',
    'ter'   => 'terenó',
    'tet'   => 'tetúm',
    'tg'    => 'tadsjikska',
    'th'    => 'taílenska',
    'ti'    => 'tígrinja',
    'tig'   => 'tígre',
    'tiv'   => 'tív',
    'tk'    => 'túrkmenska',
    'tkl'   => 'tókeláska',
    'tl'    => 'tagalog',
    'tlh'   => 'klingónska',
    'tli'   => 'tlingit',
    'tmh'   => 'tamasjek',
    'tn'    => 'tsúana',
    'to'    => "tongverska\ \(Tongaeyjar\)",
    'tog'   => "tongverska\ \(Niassa\ i\ Moçambique\)",
    'tpi'   => 'tokpisin',
    'tr'    => 'tyrkneska',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimsíska',
    'tt'    => 'tatarska',
    'tum'   => 'túmbúka',
    'tup'   => 'túpímál',
    'tut'   => "altaísk\ mál",
    'tvl'   => 'túvalúska',
    'tw'    => 'tví',
    'ty'    => 'tahítíska',
    'tyv'   => 'túvínska',
    'udm'   => 'údmúrt',
    'ug'    => 'úígúr',
    'uga'   => 'úgarítíska',
    'uk'    => 'úkraínska',
    'umb'   => 'úmbúndú',
    'und'   => "\(óþekkt\ mál\)",
    'ur'    => 'úrdú',
    'uz'    => 'úsbekska',
    'vai'   => 'vaí',
    've'    => 'venda',
    'vi'    => 'víetnamska',
    'vo'    => 'volapyk',
    'vot'   => 'votíska',
    'wa'    => 'vallónska',
    'wak'   => 'vakasmál',
    'wal'   => 'valamó',
    'war'   => 'varaí',
    'was'   => 'vasjó',
    'wen'   => "sorbnesk\ mál",
    'wo'    => 'volof',
    'xal'   => 'kalmúkska',
    'xh'    => 'sósa',
    'yao'   => 'jaó',
    'yap'   => 'japíska',
    'yi'    => 'jiddíska',
    'yo'    => 'jórúba',
    'ypk'   => "júpísk\ mál",
    'za'    => 'súang',
    'zap'   => 'sapótek',
    'zbl'   => 'blisstákn',
    'zen'   => 'senaga',
    'zh'    => 'kínverska',
    'znd'   => 'sande',
    'zu'    => 'súlú',
    'zun'   => 'súní',
    'zxx'   => "\(ekkert\ tungutengt\ efni\)",
    'zza'   => 'zázáíska',
);

%Locales::DB::Language::is::name_to_code = (
    'abkasska'                                 => 'ab',
    'adangme'                                  => 'ada',
    'adge'                                     => 'ady',
    'afr'                                      => 'aa',
    "afrassk\ ml"                              => 'afa',
    'afrhl'                                    => 'afh',
    'afrkanska'                                => 'af',
    'akan'                                     => 'ak',
    'akkadska'                                 => 'akk',
    'akkska'                                   => 'ace',
    'akl'                                      => 'ach',
    'albanska'                                 => 'sq',
    'aleutska'                                 => 'ale',
    "algonkvnsk\ ml"                           => 'alg',
    'aljaml'                                   => 'art',
    "altask\ ml"                               => 'tut',
    'amara'                                    => 'ay',
    'amharska'                                 => 'am',
    'angka'                                    => 'anp',
    "anu\ japan"                               => 'ain',
    'apatsjaml'                                => 'apa',
    'arabska'                                  => 'ar',
    'aragonska'                                => 'an',
    'arapah'                                   => 'arp',
    'aravakska'                                => 'arw',
    'arkanska'                                 => 'arn',
    'armenska'                                 => 'rup',
    'aserska'                                  => 'az',
    'assameska'                                => 'as',
    'astrska'                                  => 'ast',
    "atapasksk\ ml"                            => 'ath',
    'atsam'                                    => 'cch',
    'austurfrsneska'                           => 'frs',
    "austurrsk\ ska"                           => 'de_at',
    'avad'                                     => 'awa',
    'avarska'                                  => 'av',
    'avestska'                                 => 'ae',
    "azteksk\ ml"                              => 'nah',
    'balk'                                     => 'bal',
    'balska'                                   => 'ban',
    "baltnesk\ ml"                             => 'bat',
    'bambara'                                  => 'bm',
    "bamilksk\ ml"                             => 'bai',
    'ban'                                      => 'iba',
    "bandarsk\ enska"                          => 'en_us',
    'bandasml'                                 => 'bad',
    'bantml'                                   => 'bnt',
    "basa\ kamerun"                            => 'bas',
    'baskneska'                                => 'eu',
    'baskr'                                    => 'ba',
    'batakml'                                  => 'btk',
    'bcolano'                                  => 'bik',
    'beja'                                     => 'bej',
    "bemba\ zambia"                            => 'bem',
    'bengalska'                                => 'bn',
    'berbaml'                                  => 'ber',
    "bersk\ portgalska"                        => 'pt_pt',
    "bersk\ spnska"                            => 'es_es',
    'bgska'                                    => 'bug',
    "bharsk\ ml"                               => 'bh',
    'bidayuhml'                                => 'day',
    'blgarska'                                 => 'bg',
    'blisstkn'                                 => 'zbl',
    'bln'                                      => 'byn',
    'bn'                                       => 'bin',
    'bojpr'                                    => 'bho',
    'bosnska'                                  => 'bs',
    'bra'                                      => 'bra',
    "braslsk\ portgalska"                      => 'pt_br',
    'brat'                                     => 'bua',
    "bresk\ enska"                             => 'en_gb',
    'bretnska'                                 => 'br',
    'brmska'                                   => 'my',
    'bslama'                                   => 'bi',
    'd'                                        => 'io',
    'dakta'                                    => 'dak',
    'dala'                                     => 'dua',
    'danska'                                   => 'da',
    'dargva'                                   => 'dar',
    'delaver'                                  => 'del',
    'dinka'                                    => 'din',
    'djla'                                     => 'dyu',
    'dmrt'                                     => 'udm',
    'dogrb'                                    => 'dgr',
    'dogrikangri'                              => 'doi',
    "dravidsk\ ml"                             => 'dra',
    'dsongka'                                  => 'dz',
    'dveh'                                     => 'dv',
    'efk'                                      => 'efi',
    'eistneska'                                => 'et',
    'ekajk'                                    => 'eka',
    "ekkert\ tungutengt\ efni"                 => 'zxx',
    "ekkt\ ml"                                 => 'und',
    'elamt'                                    => 'elx',
    'enaresamska'                              => 'smn',
    'enska'                                    => 'en',
    'ersja'                                    => 'myv',
    'esperant'                                 => 'eo',
    'eve'                                      => 'ee',
    'evond'                                    => 'ewo',
    'fang'                                     => 'fan',
    'fant'                                     => 'fat',
    'fdjeyska'                                 => 'fj',
    'filipnska'                                => 'fil',
    "filippseysk\ ml"                          => 'phi',
    'finnska'                                  => 'fi',
    "finnskgrsk\ ml"                           => 'fiu',
    'flmska'                                   => 'nl_be',
    'fn'                                       => 'fon',
    'fnikska'                                  => 'phn',
    'fornegypska'                              => 'egy',
    'fornenska'                                => 'ang',
    'fornfranska'                              => 'fro',
    'forngrska'                                => 'grc',
    'fornhska'                                 => 'goh',
    'fornpersneska'                            => 'peo',
    'fornprvensalska'                          => 'pro',
    'fornrska'                                 => 'sga',
    'franska'                                  => 'fr',
    'freyska'                                  => 'fo',
    'frlska'                                   => 'fur',
    'frsneska'                                 => 'fy',
    'fulfulde'                                 => 'ff',
    'ga'                                       => 'gaa',
    'gaj'                                      => 'gay',
    'galibska'                                 => 'car',
    'gallegska'                                => 'gl',
    'ganda'                                    => 'lg',
    'gartska'                                  => 'uga',
    'gb'                                       => 'ig',
    'gbaja'                                    => 'gba',
    'georgska'                                 => 'ka',
    'gerb'                                     => 'grb',
    "germnsk\ ml"                              => 'gem',
    'gilberska'                                => 'gil',
    'gjarat'                                   => 'gu',
    'gond'                                     => 'gon',
    'gorontal'                                 => 'gor',
    'gotneska'                                 => 'got',
    'gr'                                       => 'ug',
    'grnlenska'                                => 'kl',
    'grska'                                    => 'el',
    'gs'                                       => 'gez',
    'gvaran'                                   => 'gn',
    'gvsn'                                     => 'gwi',
    'gyingaarabska'                            => 'jrb',
    'gyingapersneska'                          => 'jpr',
    'hada'                                     => 'hai',
    'hatska'                                   => 'ht',
    'havaska'                                  => 'haw',
    'hebreska'                                 => 'he',
    'herer'                                    => 'hz',
    'hettitska'                                => 'hit',
    'hind'                                     => 'hi',
    'hliganon'                                 => 'hil',
    "hmasjalsk\ ml"                            => 'him',
    'hmong'                                    => 'hmn',
    'hollenska'                                => 'nl',
    'hpa'                                      => 'hup',
    'hrmt'                                     => 'ho',
    'hsa'                                      => 'ha',
    'hsorbneska'                               => 'hsb',
    'hvtrssneska'                              => 'be',
    "indevrpsk\ ml"                            => 'ine',
    'indnesska'                                => 'id',
    "indversk\ ml"                             => 'inc',
    'ings'                                     => 'inh',
    'inktitt'                                  => 'iu',
    'interlingva'                              => 'ia',
    'interlingve'                              => 'ie',
    'ja'                                       => 'yao',
    'jakt'                                     => 'sah',
    'japanska'                                 => 'ja',
    'japska'                                   => 'yap',
    'javanska'                                 => 'jv',
    'jiddska'                                  => 'yi',
    'jju'                                      => 'kaj',
    'jml'                                      => 'ijo',
    "jpsk\ ml"                                 => 'ypk',
    'jrba'                                     => 'yo',
    'kabardska'                                => 'kbd',
    'kable'                                    => 'kab',
    'kadd'                                     => 'cad',
    'kalmkska'                                 => 'xal',
    "kamba\ kenya"                             => 'kam',
    'kambodska'                                => 'km',
    'kamorr'                                   => 'ch',
    "kamsk\ ml"                                => 'cmc',
    "kanadsk\ enska"                           => 'en_ca',
    "kanadsk\ franska"                         => 'fr_ca',
    'kanjama'                                  => 'kj',
    'kannada'                                  => 'kn',
    'kanr'                                     => 'kr',
    'karakalpak'                               => 'kaa',
    'karasabalkar'                             => 'krc',
    'karlska'                                  => 'krl',
    "karnsk\ ml"                               => 'kar',
    'kas'                                      => 'kha',
    'kasakska'                                 => 'kk',
    'kasbska'                                  => 'csb',
    'kasmrska'                                 => 'ks',
    'kasn'                                     => 'kac',
    'katalnska'                                => 'ca',
    'kav'                                      => 'kaw',
    'keban'                                    => 'ceb',
    "keltnesk\ ml"                             => 'cel',
    'kimbnd'                                   => 'kmb',
    'kirgiska'                                 => 'ky',
    'kirkjuslavneska'                          => 'cu',
    'kkasusml'                                 => 'cau',
    'kkj'                                      => 'ki',
    "klassisk\ srlenska"                       => 'syc',
    "klasssk\ nevarska"                        => 'nwc',
    'klingnska'                                => 'tlh',
    'kmk'                                      => 'kum',
    'knjarvanda'                               => 'rw',
    'knverska'                                 => 'zh',
    'koml'                                     => 'khi',
    'komska'                                   => 'kv',
    'kong'                                     => 'kg',
    'konkan'                                   => 'kok',
    'koptska'                                  => 'cop',
    'kornska'                                  => 'kw',
    'koro'                                     => 'kfo',
    'korsska'                                  => 'co',
    'kosraska'                                 => 'kos',
    'kotaska'                                  => 'kho',
    'kpll'                                     => 'kpe',
    'kr'                                       => 'cr',
    'kranska'                                  => 'uk',
    'kratska'                                  => 'hr',
    'krdneska'                                 => 'ku',
    "krel\ ea\ pidginml"                       => 'crp',
    "krel\ ea\ pidginml\ \ enskum\ grunni"     => 'cpe',
    "krel\ ea\ pidginml\ \ frnskum\ grunni"    => 'cpf',
    "krel\ ea\ pidginml\ \ portglskum\ grunni" => 'cpp',
    'kreska'                                   => 'ko',
    'krk'                                      => 'mus',
    'krml'                                     => 'kro',
    'krmtyrkneska'                             => 'crh',
    "ksitsk\ ml"                               => 'cus',
    'ktena'                                    => 'kut',
    'kvesja'                                   => 'qu',
    'l'                                        => 'luo',
    'la'                                       => 'lo',
    'ladnska'                                  => 'lad',
    'lamba'                                    => 'lam',
    'landa'                                    => 'lah',
    'latna'                                    => 'la',
    'lbakatanga'                               => 'lu',
    'lballa'                                   => 'lua',
    'lesgska'                                  => 'lez',
    'lettneska'                                => 'lv',
    'lgska'                                    => 'nds',
    'lgsorbneska'                              => 'dsb',
    'limbrgska'                                => 'li',
    'lingala'                                  => 'ln',
    'lisen'                                    => 'lui',
    'lithska'                                  => 'lt',
    'llesamska'                                => 'smj',
    'lnda'                                     => 'lun',
    'lojban'                                   => 'jbo',
    'lok'                                      => 'ilo',
    'los'                                      => 'loz',
    'lsa'                                      => 'lus',
    'lxemborgska'                              => 'lb',
    'madrska'                                  => 'mad',
    'magah'                                    => 'mag',
    'majaml'                                   => 'myn',
    'makasar'                                  => 'mak',
    'makednska'                                => 'mk',
    'malagasska'                               => 'mg',
    'malajalam'                                => 'ml',
    'malaska'                                  => 'ms',
    'maltneska'                                => 'mt',
    'manbml'                                   => 'mno',
    'mandar'                                   => 'mdr',
    'manding'                                  => 'man',
    'manpr'                                    => 'mni',
    'mansj'                                    => 'mnc',
    'manx'                                     => 'gv',
    'mar'                                      => 'mi',
    'marat'                                    => 'mr',
    "margvsleg\ ml"                            => 'mul',
    'marshallska'                              => 'mh',
    "marska\ rusland"                          => 'chm',
    'marvar'                                   => 'mwr',
    'masa'                                     => 'mas',
    'matl'                                     => 'mai',
    'mbnd'                                     => 'umb',
    "mende\ sierra\ leone"                     => 'men',
    'mhska'                                    => 'moh',
    "miamerku\ indnaml"                        => 'cai',
    'mienska'                                  => 'enm',
    'mifranska'                                => 'frm',
    'mihollenska'                              => 'dum',
    'mihska'                                   => 'gmh',
    'mikmak'                                   => 'mic',
    'mirandesska'                              => 'mwl',
    'mirska'                                   => 'mga',
    'mnangkab'                                 => 'min',
    'mndaml'                                   => 'mun',
    'moksa'                                    => 'mdf',
    'moldvska'                                 => 'mo',
    'mong'                                     => 'lol',
    'monglska'                                 => 'mn',
    'monkmerml'                                => 'mkh',
    'morisyen'                                 => 'mfe',
    'moss'                                     => 'mos',
    'naplska'                                  => 'nap',
    'nas'                                      => 'nia',
    'navah'                                    => 'nv',
    "nbsk\ ml"                                 => 'nub',
    'ndonga'                                   => 'ng',
    'nepalska'                                 => 'ne',
    'nevarska'                                 => 'new',
    'nga'                                      => 'nog',
    'ngerkordfanml'                            => 'nic',
    'njamves'                                  => 'nym',
    'njanja'                                   => 'ny',
    'njankle'                                  => 'nyn',
    'njr'                                      => 'nyo',
    'nk'                                       => 'nqo',
    'nlsaharaml'                               => 'ssa',
    'nnorska'                                  => 'nn',
    "nnur\ ml"                                 => 'mis',
    'norrna'                                   => 'non',
    'norska'                                   => 'no',
    "norskt\ bkml"                             => 'nb',
    "noruramerku\ indnaml"                     => 'nai',
    'norurfrsneska'                            => 'frr',
    'norurndebele'                             => 'nd',
    'norursamska'                              => 'se',
    'norurst'                                  => 'nso',
    'npak'                                     => 'ik',
    'nrska'                                    => 'na',
    'nsma'                                     => 'nzi',
    'nveska'                                   => 'niu',
    "officiell\ arameska"                      => 'arc',
    'ojibva'                                   => 'oj',
    'okstanska'                                => 'oc',
    'osmnska'                                  => 'ota',
    'ossetska'                                 => 'os',
    'pal'                                      => 'pi',
    'palav'                                    => 'pal',
    'palska'                                   => 'pau',
    'pampanga'                                 => 'pam',
    'pangasinn'                                => 'pag',
    'papament'                                 => 'pap',
    "papsk\ ml"                                => 'paa',
    'past'                                     => 'ps',
    'persneska'                                => 'fa',
    'plska'                                    => 'pl',
    'pnjab'                                    => 'pa',
    'ponpeiska'                                => 'pon',
    'portgalska'                               => 'pt',
    'prakrtml'                                 => 'pra',
    'ra'                                       => 'or',
    'rajastan'                                 => 'raj',
    'ranska'                                   => 'ira',
    'rapan'                                    => 'rap',
    'rartongska'                               => 'rar',
    'rd'                                       => 'ur',
    'retrmanska'                               => 'rm',
    "rkesk\ ml"                                => 'iro',
    'rm'                                       => 'om',
    'rmenska'                                  => 'ro',
    "rmnsk\ ml"                                => 'roa',
    'rnd'                                      => 'rn',
    'roman'                                    => 'rom',
    'rska'                                     => 'ga',
    'rssneska'                                 => 'ru',
    'sage'                                     => 'osa',
    'salsml'                                   => 'sal',
    "samsk\ ml"                                => 'smi',
    'samska'                                   => 'sm',
    "samversk\ arameska"                       => 'sam',
    'sandave'                                  => 'sad',
    'sande'                                    => 'znd',
    'sang'                                     => 'za',
    'sanskrt'                                  => 'sa',
    'santal'                                   => 'sat',
    'saptek'                                   => 'zap',
    'sardnska'                                 => 'sc',
    'sasak'                                    => 'sas',
    'sbekska'                                  => 'uz',
    'sbsja'                                    => 'chb',
    'sdam'                                     => 'sid',
    'selkp'                                    => 'sel',
    "semsk\ ml"                                => 'sem',
    'senaga'                                   => 'zen',
    'serbkratska'                              => 'sh',
    'serbneska'                                => 'sr',
    'serer'                                    => 'srr',
    'shna'                                     => 'sn',
    'sikileyska'                               => 'scn',
    'siksika'                                  => 'bla',
    'sind'                                     => 'sd',
    'singalesska'                              => 'si',
    'sjagata'                                  => 'chg',
    'sjan'                                     => 'shn',
    'sjerk'                                    => 'chr',
    'sjeyen'                                   => 'chy',
    'sjkska'                                   => 'chk',
    'sjokt'                                    => 'cho',
    'sjvas'                                    => 'cv',
    'ska'                                      => 'de',
    'skma'                                     => 'suk',
    'skoltesamska'                             => 'sms',
    "skosk\ gelska"                            => 'gd',
    'skoska'                                   => 'sco',
    'sl'                                       => 'zu',
    'slavj'                                    => 'den',
    "slavnesk\ ml"                             => 'sla',
    'slenska'                                  => 'is',
    'slvakska'                                 => 'sk',
    'slvenska'                                 => 'sl',
    'smalska'                                  => 'so',
    'smerska'                                  => 'sux',
    'sml'                                      => 'sio',
    'sn'                                       => 'zun',
    'sndanska'                                 => 'su',
    'sninke'                                   => 'snk',
    "snk\ pidginenska"                         => 'chn',
    'snska'                                    => 'sv',
    "sntbesk\ ml"                              => 'sit',
    'sogden'                                   => 'sog',
    'songhaml'                                 => 'son',
    "sorbnesk\ ml"                             => 'wen',
    'spevska'                                  => 'chp',
    'spnska'                                   => 'es',
    "sranan\ tongo"                            => 'srn',
    'srlenska'                                 => 'syr',
    'ss'                                       => 'sus',
    'ssa'                                      => 'xh',
    'ssanj'                                    => 'ii',
    "strlsk\ enska"                            => 'en_au',
    "strlsk\ ml"                               => 'aus',
    'strnesska'                                => 'map',
    'suuraltaska'                              => 'alt',
    "suuramerku\ indnaml"                      => 'sai',
    'suurndebele'                              => 'nr',
    'suursamska'                               => 'sma',
    'suurst'                                   => 'st',
    'svahl'                                    => 'sw',
    'svat'                                     => 'ss',
    "svissnesk\ franska"                       => 'fr_ch',
    "svissnesk\ hska"                          => 'de_ch',
    "svissnesk\ ska"                           => 'gsw',
    'tadsjikska'                               => 'tg',
    'tagalog'                                  => 'tl',
    'tahtska'                                  => 'ty',
    'talenska'                                 => 'th',
    'talska'                                   => 'it',
    'tamasjek'                                 => 'tmh',
    'taml'                                     => 'tai',
    'tamlska'                                  => 'ta',
    'taroko'                                   => 'trv',
    'tatarska'                                 => 'tt',
    'tbeska'                                   => 'bo',
    'telg'                                     => 'te',
    'teren'                                    => 'ter',
    'tetm'                                     => 'tet',
    'tgre'                                     => 'tig',
    'tgrinja'                                  => 'ti',
    'tkelska'                                  => 'tkl',
    'tkkneska'                                 => 'cs',
    'tknml'                                    => 'sgn',
    'tlingit'                                  => 'tli',
    'tmbka'                                    => 'tum',
    'tmne'                                     => 'tem',
    'tokpisin'                                 => 'tpi',
    'tomml'                                    => 'oto',
    "tongverska\ niassa\ i\ moambique"         => 'tog',
    "tongverska\ tongaeyjar"                   => 'to',
    'tpml'                                     => 'tup',
    'trkmenska'                                => 'tk',
    'tsana'                                    => 'tn',
    'tsimsska'                                 => 'tsi',
    'tsjetsjenska'                             => 'ce',
    'tsonga'                                   => 'ts',
    'tv'                                       => 'tw',
    'tvalska'                                  => 'tvl',
    'tvnska'                                   => 'tyv',
    'tyap'                                     => 'kcg',
    'tyrkneska'                                => 'tr',
    'ungverska'                                => 'hu',
    'va'                                       => 'vai',
    'vakasml'                                  => 'wak',
    'valam'                                    => 'wal',
    'vallnska'                                 => 'wa',
    'vara'                                     => 'war',
    'vasj'                                     => 'was',
    'velska'                                   => 'cy',
    'venda'                                    => 've',
    'vetnamska'                                => 'vi',
    'volapyk'                                  => 'vo',
    'volof'                                    => 'wo',
    'votska'                                   => 'vot',
    'zzska'                                    => 'zza',
);

1;
