package Locales::DB::Language::id;

# Auto generated from CLDR

$Locales::DB::Language::id::VERSION = '0.01';

$Locales::DB::Language::id::cldr_version = '1.7.1';

%Locales::DB::Language::id::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "tidak\:t",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => "ya\:y",
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::id::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhaz',
    'ace'   => 'Aceh',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikaans',
    'afa'   => "Afro\-Asiatik\ \(Lainnya\)",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadien',
    'ale'   => 'Aleut',
    'alg'   => "Bahasa\ Algonquia",
    'alt'   => "Altai\ Selatan",
    'am'    => 'Amharik',
    'an'    => 'Aragon',
    'ang'   => "Inggris\ Kuno\ \(kl\.450\-1100\)",
    'anp'   => 'Angika',
    'apa'   => "Bahasa\-bahasa\ Apache",
    'ar'    => 'Arab',
    'arc'   => 'Aram',
    'arn'   => 'Araucan',
    'arp'   => 'Arapaho',
    'art'   => "Buatan\ \(Lainnya\)",
    'arw'   => 'Arawak',
    'as'    => 'Assam',
    'ast'   => 'Astur',
    'ath'   => "Bahasa\-bahasa\ Athapaska",
    'aus'   => "Bahasa\-bahasa\ Australia",
    'av'    => 'Avarik',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azerbaijan',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bahasa\-bahasa\ Bamileke",
    'bal'   => 'Baluchi',
    'ban'   => 'Balin',
    'bas'   => 'Basa',
    'bat'   => "Baltik\ \(Lainnya\)",
    'be'    => 'Belarusia',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'Bulgaria',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengal',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibet',
    'br'    => 'Breton',
    'bra'   => 'Braj',
    'bs'    => 'Bosnia',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Bugis',
    'byn'   => 'Blin',
    'ca'    => 'Catalan',
    'cad'   => 'Caddo',
    'cai'   => "India\ Amerika\ Tengah\ \(Lainnnya\)",
    'car'   => 'Karib',
    'cau'   => "Kaukasia\ \(Lainnya\)",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ \(Lainnya\)",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuuke',
    'chm'   => 'Mari',
    'chn'   => "Jargon\ Chinook",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Bahasa\ Chamic",
    'co'    => 'Korsika',
    'cop'   => 'Koptik',
    'cpe'   => "Kreol\ dan\ Pidgins\ Lain\ Berbasis\ Inggris",
    'cpf'   => "Kreol\ dan\ Pidgins\ Lain\ berbasis\ Prancis",
    'cpp'   => "Kreol\ dan\ Pidgins\ Lain\ berbasis\ Portugis",
    'cr'    => 'Cree',
    'crh'   => "Turki\ Krimea",
    'crp'   => "Kreol\ dan\ Pidgins\ Lain",
    'cs'    => 'Ceko',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Lain",
    'cv'    => 'Chuvash',
    'cy'    => 'Welsh',
    'da'    => 'Denmark',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'Jerman',
    'de_at' => "Jerman\ Austria",
    'de_ch' => "Jerman\ Tinggi\ Swiss",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidia\ Lain",
    'dsb'   => "Sorbia\ Rendahan",
    'dua'   => 'Duala',
    'dum'   => "Belanda\ Menengah",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Mesir\ Kuno",
    'eka'   => 'Ekajuk',
    'el'    => 'Yunani',
    'elx'   => 'Elamite',
    'en'    => 'Inggris',
    'en_au' => "Inggris\ Australia",
    'en_ca' => "Inggris\ Kanada",
    'en_gb' => "Inggris\ \(British\)",
    'en_us' => "Inggris\ A\.S\.",
    'enm'   => "Inggris\,\ Abad\ Pertengahan\ \(1100\-1500\)",
    'eo'    => 'Esperanto',
    'es'    => 'Spanyol',
    'es_es' => "Spanyol\ \(Iberia\)",
    'et'    => 'Estonian',
    'eu'    => 'Basque',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persia',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Finlandia',
    'fil'   => 'Filipina',
    'fiu'   => "Finno\ \-\ Ugria\ Lain",
    'fj'    => 'Fiji',
    'fo'    => 'Faro',
    'fon'   => 'Fon',
    'fr'    => 'Perancis',
    'fr_ca' => "Prancis\ Kanada",
    'fr_ch' => "Prancis\ Swiss",
    'frm'   => "Perancis\,\ Abad\ Pertengahan\ \(kl\.1400\-1600\)",
    'fro'   => "Perancis\ Kuno\ \(842\-kl\.1400\)",
    'frr'   => "Frisia\ Utara",
    'frs'   => "Frisia\ Timur",
    'fur'   => 'Friuli',
    'fy'    => 'Frisi',
    'ga'    => 'Irlandia',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Gaelik\ Skotlandia",
    'gem'   => "Jermanik\ \(Lainnya\)",
    'gez'   => 'Geez',
    'gil'   => 'Gilbert',
    'gl'    => 'Gallegan',
    'gmh'   => "Jerman\,\ Abad\ Pertengahan\ \(kl\.1050\-1500\)",
    'gn'    => 'Guarani',
    'goh'   => "Jerman\ Kuno\ \(kl\.750\-1050\)",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothik',
    'grb'   => 'Grebo',
    'grc'   => "Yunani\ Kuno\ \(sd\ 1453\)",
    'gsw'   => "Jerman\ Swiss",
    'gu'    => 'Gujarati',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\'in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaii',
    'he'    => 'Ibrani',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Kroasia',
    'hsb'   => "Sorbia\ Atas",
    'ht'    => 'Haiti',
    'hu'    => 'Hungaria',
    'hup'   => 'Hupa',
    'hy'    => 'Armenia',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => "Bahasa\ Indonesia",
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Lain",
    'ine'   => "Indo\-Eropa\ Lain",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iran\ Lain",
    'iro'   => "Bahasa\ Iroquoia",
    'is'    => 'Icelandic',
    'it'    => 'Italian',
    'iu'    => 'Inuktitut',
    'ja'    => 'Japanese',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persia",
    'jrb'   => "Judeo\-Arab",
    'jv'    => 'Jawa',
    'ka'    => 'Georgian',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisa\ Lain",
    'kho'   => 'Khotan',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'Khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Korea',
    'kok'   => 'Konkani',
    'kos'   => 'Kosrae',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmir',
    'ku'    => 'Kurdi',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kirghiz',
    'la'    => 'Latin',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourg',
    'lez'   => 'Lezghia',
    'lg'    => 'Ganda',
    'li'    => 'Limburg',
    'ln'    => 'Lingala',
    'lo'    => 'Lao',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Lithuania',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Latvian',
    'mad'   => 'Madura',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makassar',
    'man'   => 'Mandingo',
    'map'   => 'Austronesia',
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasi',
    'mga'   => "Irlandia\ Abad\ Pertengahan\ \(900\-1200\)",
    'mh'    => 'Marshall',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Bahasa\ Lain\-lain",
    'mk'    => 'Macedonian',
    'mkh'   => "Mon\-Khmer\ \(Lainnya\)",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongolian',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Bahasa\ Manobo",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malay',
    'mt'    => 'Maltese',
    'mul'   => "Beberapa\ Bahasa",
    'mun'   => "Bahasa\ Munda",
    'mus'   => 'Creek',
    'mwl'   => 'Mirand',
    'mwr'   => 'Marwari',
    'my'    => 'Burma',
    'myn'   => "Bahasa\ Mayan",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuati',
    'nai'   => "Indian\ Amerika\ Utara\ Lain",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokmål",
    'nd'    => "Ndebele\ Utara",
    'nds'   => "Jerman\ Rendah",
    'ne'    => 'Nepal',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\ \-\ Kordofania\ Lain",
    'niu'   => 'Niuea',
    'nl'    => 'Belanda',
    'nl_be' => 'Flemish',
    'nn'    => "Norwegian\ Nynorsk",
    'no'    => 'Norwegian',
    'nog'   => 'Nogai',
    'non'   => "Norse\ Lama",
    'nqo'   => "N\'Ko",
    'nr'    => "Ndebele\ Selatan",
    'nso'   => "Sotho\ Utara",
    'nub'   => "Bahasa\ Nubia",
    'nv'    => 'Navajo',
    'nwc'   => "Newari\ Klasik",
    'ny'    => "Nyanja\;\ Chichewa\;\ Chewa",
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => "Bahasa\ Occit",
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Turki\ Ottoman",
    'oto'   => "Bahasa\ Otomia",
    'pa'    => 'Punjabi',
    'paa'   => "Papuan\ \(Lainnya\)",
    'pag'   => 'Pangasina',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palaua',
    'peo'   => "Persia\ Kuno\ \(kl\.600\-400\ SM\.\)",
    'phi'   => "Filipina\ \(Lainnya\)",
    'phn'   => 'Phoenicia',
    'pi'    => 'Pali',
    'pl'    => 'Polish',
    'pon'   => 'Pohnpeia',
    'pra'   => "Bahasa\ Prakrit",
    'pro'   => "Provençal\ Lama",
    'ps'    => "Pashto\ \(Pushto\)",
    'pt'    => 'Portugis',
    'pt_br' => "Portugis\ Brasil",
    'pt_pt' => "Portugis\ \(Iberia\)",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => 'Romanian',
    'roa'   => "Romance\ Lain",
    'rom'   => 'Romany',
    'ru'    => 'Russian',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "Indian\ Amerika\ Selatan\ Lain",
    'sal'   => "Bahasa\ Salisha",
    'sam'   => "Aramaic\ Samaritan",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sisilia',
    'sco'   => 'Skotlandia',
    'sd'    => 'Sindhi',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Lain",
    'sg'    => 'Sango',
    'sga'   => "Irlandia\ Lama",
    'sgn'   => "Bahasa\ Isyarat",
    'sh'    => "Serbo\-Croatian",
    'shn'   => 'Shan',
    'si'    => 'Sinhalese',
    'sid'   => 'Sidamo',
    'sio'   => "Bahasa\ Siouan",
    'sit'   => "Sino\-Tibet\ Lain",
    'sk'    => 'Slovak',
    'sl'    => 'Slovenian',
    'sla'   => "Slavic\ Lain",
    'sm'    => 'Samoan',
    'sma'   => "Sami\ Selatan",
    'smi'   => "Bahasa\ Sami\ Lain",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somali',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albanian',
    'sr'    => 'Serbian',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Sahara\ Lain",
    'st'    => "Sotho\ Selatan",
    'su'    => 'Sundan',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumeria',
    'sv'    => 'Swedia',
    'sw'    => 'Swahili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syria',
    'ta'    => 'Tamil',
    'tai'   => "Tai\ Lain",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'Thai',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turkish',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Bahasa\ Tupi",
    'tut'   => "Altaic\ Lain",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinia',
    'udm'   => 'Udmurt',
    'ug'    => 'Uighur',
    'uga'   => 'Ugaritik',
    'uk'    => 'Ukrainian',
    'umb'   => 'Umbundu',
    'und'   => "Bahasa\ Tidak\ Dikenal\ atau\ Tidak\ Valid",
    'ur'    => 'Urdu',
    'uz'    => 'Uzbek',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnamese',
    'vo'    => 'Volapük',
    'vot'   => 'Votik',
    'wa'    => 'Walloon',
    'wak'   => "Bahasa\ Wakasha",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Bahasa\ Serbia",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yap',
    'yi'    => 'Yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Bahasa\ Yupik",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotek',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Cina',
    'znd'   => 'Zande',
    'zu'    => 'Zulu',
    'zun'   => 'Zuni',
    'zxx'   => "Tidak\ ada\ konten\ linguistik",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::id::name_to_code = (
    'abkhaz'                                        => 'ab',
    'aceh'                                          => 'ace',
    'acoli'                                         => 'ach',
    'adangme'                                       => 'ada',
    'adyghe'                                        => 'ady',
    'afar'                                          => 'aa',
    'afrihili'                                      => 'afh',
    'afrikaans'                                     => 'af',
    "afroasiatik\ lainnya"                          => 'afa',
    'ainu'                                          => 'ain',
    'akan'                                          => 'ak',
    'akkadien'                                      => 'akk',
    'albanian'                                      => 'sq',
    'aleut'                                         => 'ale',
    "altai\ selatan"                                => 'alt',
    "altaic\ lain"                                  => 'tut',
    'amharik'                                       => 'am',
    'angika'                                        => 'anp',
    'arab'                                          => 'ar',
    'aragon'                                        => 'an',
    'aram'                                          => 'arc',
    "aramaic\ samaritan"                            => 'sam',
    'arapaho'                                       => 'arp',
    'araucan'                                       => 'arn',
    'arawak'                                        => 'arw',
    'armenia'                                       => 'hy',
    'aromanian'                                     => 'rup',
    'assam'                                         => 'as',
    'astur'                                         => 'ast',
    'atsam'                                         => 'cch',
    'austronesia'                                   => 'map',
    'avarik'                                        => 'av',
    'avestan'                                       => 'ae',
    'awadhi'                                        => 'awa',
    'aymara'                                        => 'ay',
    'azerbaijan'                                    => 'az',
    "bahasa\ algonquia"                             => 'alg',
    "bahasa\ chamic"                                => 'cmc',
    "bahasa\ indonesia"                             => 'id',
    "bahasa\ iroquoia"                              => 'iro',
    "bahasa\ isyarat"                               => 'sgn',
    "bahasa\ lainlain"                              => 'mis',
    "bahasa\ manobo"                                => 'mno',
    "bahasa\ mayan"                                 => 'myn',
    "bahasa\ munda"                                 => 'mun',
    "bahasa\ nubia"                                 => 'nub',
    "bahasa\ occit"                                 => 'oc',
    "bahasa\ otomia"                                => 'oto',
    "bahasa\ prakrit"                               => 'pra',
    "bahasa\ salisha"                               => 'sal',
    "bahasa\ sami\ lain"                            => 'smi',
    "bahasa\ serbia"                                => 'wen',
    "bahasa\ siouan"                                => 'sio',
    "bahasa\ tidak\ dikenal\ atau\ tidak\ valid"    => 'und',
    "bahasa\ tupi"                                  => 'tup',
    "bahasa\ wakasha"                               => 'wak',
    "bahasa\ yupik"                                 => 'ypk',
    "bahasabahasa\ apache"                          => 'apa',
    "bahasabahasa\ athapaska"                       => 'ath',
    "bahasabahasa\ australia"                       => 'aus',
    "bahasabahasa\ bamileke"                        => 'bai',
    'balin'                                         => 'ban',
    "baltik\ lainnya"                               => 'bat',
    'baluchi'                                       => 'bal',
    'bambara'                                       => 'bm',
    'banda'                                         => 'bad',
    'bantu'                                         => 'bnt',
    'basa'                                          => 'bas',
    'bashkir'                                       => 'ba',
    'basque'                                        => 'eu',
    'batak'                                         => 'btk',
    "beberapa\ bahasa"                              => 'mul',
    'beja'                                          => 'bej',
    'belanda'                                       => 'nl',
    "belanda\ menengah"                             => 'dum',
    'belarusia'                                     => 'be',
    'bemba'                                         => 'bem',
    'bengal'                                        => 'bn',
    'berber'                                        => 'ber',
    'bhojpuri'                                      => 'bho',
    'bihari'                                        => 'bh',
    'bikol'                                         => 'bik',
    'bini'                                          => 'bin',
    'bislama'                                       => 'bi',
    'blin'                                          => 'byn',
    'blissymbols'                                   => 'zbl',
    'bosnia'                                        => 'bs',
    'braj'                                          => 'bra',
    'breton'                                        => 'br',
    "buatan\ lainnya"                               => 'art',
    'bugis'                                         => 'bug',
    'bulgaria'                                      => 'bg',
    'buriat'                                        => 'bua',
    'burma'                                         => 'my',
    'caddo'                                         => 'cad',
    'catalan'                                       => 'ca',
    'cebuano'                                       => 'ceb',
    'ceko'                                          => 'cs',
    "celtic\ lainnya"                               => 'cel',
    'chagatai'                                      => 'chg',
    'chamorro'                                      => 'ch',
    'chechen'                                       => 'ce',
    'cherokee'                                      => 'chr',
    'cheyenne'                                      => 'chy',
    'chibcha'                                       => 'chb',
    'chipewyan'                                     => 'chp',
    'choctaw'                                       => 'cho',
    "church\ slavic"                                => 'cu',
    'chuuke'                                        => 'chk',
    'chuvash'                                       => 'cv',
    'cina'                                          => 'zh',
    "classical\ syriac"                             => 'syc',
    'cornish'                                       => 'kw',
    'cree'                                          => 'cr',
    'creek'                                         => 'mus',
    "cushitic\ lain"                                => 'cus',
    'dakota'                                        => 'dak',
    'dargwa'                                        => 'dar',
    'dayak'                                         => 'day',
    'delaware'                                      => 'del',
    'denmark'                                       => 'da',
    'dinka'                                         => 'din',
    'divehi'                                        => 'dv',
    'dogri'                                         => 'doi',
    'dogrib'                                        => 'dgr',
    "dravidia\ lain"                                => 'dra',
    'duala'                                         => 'dua',
    'dyula'                                         => 'dyu',
    'dzongkha'                                      => 'dz',
    'efik'                                          => 'efi',
    'ekajuk'                                        => 'eka',
    'elamite'                                       => 'elx',
    'erzya'                                         => 'myv',
    'esperanto'                                     => 'eo',
    'estonian'                                      => 'et',
    'ewe'                                           => 'ee',
    'ewondo'                                        => 'ewo',
    'fang'                                          => 'fan',
    'fanti'                                         => 'fat',
    'faro'                                          => 'fo',
    'fiji'                                          => 'fj',
    'filipina'                                      => 'fil',
    "filipina\ lainnya"                             => 'phi',
    'finlandia'                                     => 'fi',
    "finno\ \ ugria\ lain"                          => 'fiu',
    'flemish'                                       => 'nl_be',
    'fon'                                           => 'fon',
    'frisi'                                         => 'fy',
    "frisia\ timur"                                 => 'frs',
    "frisia\ utara"                                 => 'frr',
    'friuli'                                        => 'fur',
    'fulah'                                         => 'ff',
    'ga'                                            => 'gaa',
    "gaelik\ skotlandia"                            => 'gd',
    'gallegan'                                      => 'gl',
    'ganda'                                         => 'lg',
    'gayo'                                          => 'gay',
    'gbaya'                                         => 'gba',
    'geez'                                          => 'gez',
    'georgian'                                      => 'ka',
    'gilbert'                                       => 'gil',
    'gondi'                                         => 'gon',
    'gorontalo'                                     => 'gor',
    'gothik'                                        => 'got',
    'grebo'                                         => 'grb',
    'guarani'                                       => 'gn',
    'gujarati'                                      => 'gu',
    'gwichin'                                       => 'gwi',
    'haida'                                         => 'hai',
    'haiti'                                         => 'ht',
    'hausa'                                         => 'ha',
    'hawaii'                                        => 'haw',
    'herero'                                        => 'hz',
    'hiligaynon'                                    => 'hil',
    'himachali'                                     => 'him',
    'hindi'                                         => 'hi',
    "hiri\ motu"                                    => 'ho',
    'hittite'                                       => 'hit',
    'hmong'                                         => 'hmn',
    'hungaria'                                      => 'hu',
    'hupa'                                          => 'hup',
    'iban'                                          => 'iba',
    'ibrani'                                        => 'he',
    'icelandic'                                     => 'is',
    'ido'                                           => 'io',
    'igbo'                                          => 'ig',
    'ijo'                                           => 'ijo',
    'iloko'                                         => 'ilo',
    "inari\ sami"                                   => 'smn',
    "india\ amerika\ tengah\ lainnnya"              => 'cai',
    "indian\ amerika\ selatan\ lain"                => 'sai',
    "indian\ amerika\ utara\ lain"                  => 'nai',
    "indic\ lain"                                   => 'inc',
    "indoeropa\ lain"                               => 'ine',
    'inggris'                                       => 'en',
    "inggris\ abad\ pertengahan\ "                  => 'enm',
    "inggris\ as"                                   => 'en_us',
    "inggris\ australia"                            => 'en_au',
    "inggris\ british"                              => 'en_gb',
    "inggris\ kanada"                               => 'en_ca',
    "inggris\ kuno\ kl"                             => 'ang',
    'ingush'                                        => 'inh',
    'interlingua'                                   => 'ia',
    'interlingue'                                   => 'ie',
    'inuktitut'                                     => 'iu',
    'inupiaq'                                       => 'ik',
    "iran\ lain"                                    => 'ira',
    'irlandia'                                      => 'ga',
    "irlandia\ abad\ pertengahan\ "                 => 'mga',
    "irlandia\ lama"                                => 'sga',
    'italian'                                       => 'it',
    'japanese'                                      => 'ja',
    "jargon\ chinook"                               => 'chn',
    'jawa'                                          => 'jv',
    'jerman'                                        => 'de',
    "jerman\ abad\ pertengahan\ kl"                 => 'gmh',
    "jerman\ austria"                               => 'de_at',
    "jerman\ kuno\ kl"                              => 'goh',
    "jerman\ rendah"                                => 'nds',
    "jerman\ swiss"                                 => 'gsw',
    "jerman\ tinggi\ swiss"                         => 'de_ch',
    "jermanik\ lainnya"                             => 'gem',
    'jju'                                           => 'kaj',
    'judeoarab'                                     => 'jrb',
    'judeopersia'                                   => 'jpr',
    'kabardian'                                     => 'kbd',
    'kabyle'                                        => 'kab',
    'kachin'                                        => 'kac',
    'kalaallisut'                                   => 'kl',
    'kalmyk'                                        => 'xal',
    'kamba'                                         => 'kam',
    'kannada'                                       => 'kn',
    'kanuri'                                        => 'kr',
    'karachaybalkar'                                => 'krc',
    'karakalpak'                                    => 'kaa',
    'karelian'                                      => 'krl',
    'karen'                                         => 'kar',
    'karib'                                         => 'car',
    'kashmir'                                       => 'ks',
    'kashubian'                                     => 'csb',
    "kaukasia\ lainnya"                             => 'cau',
    'kawi'                                          => 'kaw',
    'kazakh'                                        => 'kk',
    'khasi'                                         => 'kha',
    'khmer'                                         => 'km',
    "khoisa\ lain"                                  => 'khi',
    'khotan'                                        => 'kho',
    'kikuyu'                                        => 'ki',
    'kimbundu'                                      => 'kmb',
    'kinyarwanda'                                   => 'rw',
    'kirghiz'                                       => 'ky',
    'klingon'                                       => 'tlh',
    'komi'                                          => 'kv',
    'kongo'                                         => 'kg',
    'konkani'                                       => 'kok',
    'koptik'                                        => 'cop',
    'korea'                                         => 'ko',
    'koro'                                          => 'kfo',
    'korsika'                                       => 'co',
    'kosrae'                                        => 'kos',
    'kpelle'                                        => 'kpe',
    "kreol\ dan\ pidgins\ lain"                     => 'crp',
    "kreol\ dan\ pidgins\ lain\ berbasis\ inggris"  => 'cpe',
    "kreol\ dan\ pidgins\ lain\ berbasis\ portugis" => 'cpp',
    "kreol\ dan\ pidgins\ lain\ berbasis\ prancis"  => 'cpf',
    'kroasia'                                       => 'hr',
    'kru'                                           => 'kro',
    'kuanyama'                                      => 'kj',
    'kumyk'                                         => 'kum',
    'kurdi'                                         => 'ku',
    'kurukh'                                        => 'kru',
    'kutenai'                                       => 'kut',
    'ladino'                                        => 'lad',
    'lahnda'                                        => 'lah',
    'lamba'                                         => 'lam',
    'lao'                                           => 'lo',
    'latin'                                         => 'la',
    'latvian'                                       => 'lv',
    'lezghia'                                       => 'lez',
    'limburg'                                       => 'li',
    'lingala'                                       => 'ln',
    'lithuania'                                     => 'lt',
    'lojban'                                        => 'jbo',
    'lozi'                                          => 'loz',
    'lubakatanga'                                   => 'lu',
    'lubalulua'                                     => 'lua',
    'luiseno'                                       => 'lui',
    "lule\ sami"                                    => 'smj',
    'lunda'                                         => 'lun',
    'luo'                                           => 'luo',
    'lushai'                                        => 'lus',
    'luxembourg'                                    => 'lb',
    'macedonian'                                    => 'mk',
    'madura'                                        => 'mad',
    'magahi'                                        => 'mag',
    'maithili'                                      => 'mai',
    'makassar'                                      => 'mak',
    'malagasi'                                      => 'mg',
    'malay'                                         => 'ms',
    'malayalam'                                     => 'ml',
    'maltese'                                       => 'mt',
    'manchu'                                        => 'mnc',
    'mandar'                                        => 'mdr',
    'mandingo'                                      => 'man',
    'manipuri'                                      => 'mni',
    'manx'                                          => 'gv',
    'maori'                                         => 'mi',
    'marathi'                                       => 'mr',
    'mari'                                          => 'chm',
    'marshall'                                      => 'mh',
    'marwari'                                       => 'mwr',
    'masai'                                         => 'mas',
    'mende'                                         => 'men',
    "mesir\ kuno"                                   => 'egy',
    'micmac'                                        => 'mic',
    'minangkabau'                                   => 'min',
    'mirand'                                        => 'mwl',
    'mohawk'                                        => 'moh',
    'moksha'                                        => 'mdf',
    'moldavian'                                     => 'mo',
    'mongo'                                         => 'lol',
    'mongolian'                                     => 'mn',
    "monkhmer\ lainnya"                             => 'mkh',
    'morisyen'                                      => 'mfe',
    'mossi'                                         => 'mos',
    'nahuati'                                       => 'nah',
    'nauru'                                         => 'na',
    'navajo'                                        => 'nv',
    "ndebele\ selatan"                              => 'nr',
    "ndebele\ utara"                                => 'nd',
    'ndonga'                                        => 'ng',
    'neapolitan'                                    => 'nap',
    'nepal'                                         => 'ne',
    'newari'                                        => 'new',
    "newari\ klasik"                                => 'nwc',
    'nias'                                          => 'nia',
    "niger\ \ kordofania\ lain"                     => 'nic',
    "nilosahara\ lain"                              => 'ssa',
    'niuea'                                         => 'niu',
    'nko'                                           => 'nqo',
    'nogai'                                         => 'nog',
    "norse\ lama"                                   => 'non',
    "northern\ sami"                                => 'se',
    'norwegian'                                     => 'no',
    "norwegian\ bokml"                              => 'nb',
    "norwegian\ nynorsk"                            => 'nn',
    'nyamwezi'                                      => 'nym',
    "nyanja\ chichewa\ chewa"                       => 'ny',
    'nyankole'                                      => 'nyn',
    "nyasa\ tonga"                                  => 'tog',
    'nyoro'                                         => 'nyo',
    'nzima'                                         => 'nzi',
    'ojibwa'                                        => 'oj',
    'oriya'                                         => 'or',
    'oromo'                                         => 'om',
    'osage'                                         => 'osa',
    'ossetic'                                       => 'os',
    'pahlavi'                                       => 'pal',
    'palaua'                                        => 'pau',
    'pali'                                          => 'pi',
    'pampanga'                                      => 'pam',
    'pangasina'                                     => 'pag',
    'papiamento'                                    => 'pap',
    "papuan\ lainnya"                               => 'paa',
    "pashto\ pushto"                                => 'ps',
    'perancis'                                      => 'fr',
    "perancis\ abad\ pertengahan\ kl"               => 'frm',
    "perancis\ kuno\ kl"                            => 'fro',
    'persia'                                        => 'fa',
    "persia\ kuno\ kl\ sm"                          => 'peo',
    'phoenicia'                                     => 'phn',
    'pohnpeia'                                      => 'pon',
    'polish'                                        => 'pl',
    'portugis'                                      => 'pt',
    "portugis\ brasil"                              => 'pt_br',
    "portugis\ iberia"                              => 'pt_pt',
    "prancis\ kanada"                               => 'fr_ca',
    "prancis\ swiss"                                => 'fr_ch',
    "provenal\ lama"                                => 'pro',
    'punjabi'                                       => 'pa',
    'quechua'                                       => 'qu',
    'rajasthani'                                    => 'raj',
    'rapanui'                                       => 'rap',
    'rarotongan'                                    => 'rar',
    'rhaetoromance'                                 => 'rm',
    "romance\ lain"                                 => 'roa',
    'romanian'                                      => 'ro',
    'romany'                                        => 'rom',
    'rundi'                                         => 'rn',
    'russian'                                       => 'ru',
    "sami\ selatan"                                 => 'sma',
    'samoan'                                        => 'sm',
    'sandawe'                                       => 'sad',
    'sango'                                         => 'sg',
    'sanskrit'                                      => 'sa',
    'santali'                                       => 'sat',
    'sardinian'                                     => 'sc',
    'sasak'                                         => 'sas',
    'selkup'                                        => 'sel',
    "semitic\ lain"                                 => 'sem',
    'serbian'                                       => 'sr',
    'serbocroatian'                                 => 'sh',
    'serer'                                         => 'srr',
    'shan'                                          => 'shn',
    'shona'                                         => 'sn',
    "sichuan\ yi"                                   => 'ii',
    'sidamo'                                        => 'sid',
    'siksika'                                       => 'bla',
    'sindhi'                                        => 'sd',
    'sinhalese'                                     => 'si',
    "sinotibet\ lain"                               => 'sit',
    'sisilia'                                       => 'scn',
    "skolt\ sami"                                   => 'sms',
    'skotlandia'                                    => 'sco',
    'slave'                                         => 'den',
    "slavic\ lain"                                  => 'sla',
    'slovak'                                        => 'sk',
    'slovenian'                                     => 'sl',
    'sogdien'                                       => 'sog',
    'somali'                                        => 'so',
    'songhai'                                       => 'son',
    'soninke'                                       => 'snk',
    "sorbia\ atas"                                  => 'hsb',
    "sorbia\ rendahan"                              => 'dsb',
    "sotho\ selatan"                                => 'st',
    "sotho\ utara"                                  => 'nso',
    'spanyol'                                       => 'es',
    "spanyol\ iberia"                               => 'es_es',
    "sranan\ tongo"                                 => 'srn',
    'sukuma'                                        => 'suk',
    'sumeria'                                       => 'sux',
    'sundan'                                        => 'su',
    'susu'                                          => 'sus',
    'swahili'                                       => 'sw',
    'swati'                                         => 'ss',
    'swedia'                                        => 'sv',
    'syria'                                         => 'syr',
    'tagalog'                                       => 'tl',
    'tahitian'                                      => 'ty',
    "tai\ lain"                                     => 'tai',
    'tajik'                                         => 'tg',
    'tamashek'                                      => 'tmh',
    'tamil'                                         => 'ta',
    'taroko'                                        => 'trv',
    'tatar'                                         => 'tt',
    'telugu'                                        => 'te',
    'tereno'                                        => 'ter',
    'tetum'                                         => 'tet',
    'thai'                                          => 'th',
    'tibet'                                         => 'bo',
    "tidak\ ada\ konten\ linguistik"                => 'zxx',
    'tigre'                                         => 'tig',
    'tigrinya'                                      => 'ti',
    'timne'                                         => 'tem',
    'tingit'                                        => 'tli',
    'tiv'                                           => 'tiv',
    "tok\ pisin"                                    => 'tpi',
    'tokelau'                                       => 'tkl',
    'tonga'                                         => 'to',
    'tsimshian'                                     => 'tsi',
    'tsonga'                                        => 'ts',
    'tswana'                                        => 'tn',
    'tumbuka'                                       => 'tum',
    "turki\ krimea"                                 => 'crh',
    "turki\ ottoman"                                => 'ota',
    'turkish'                                       => 'tr',
    'turkmen'                                       => 'tk',
    'tuvalu'                                        => 'tvl',
    'tuvinia'                                       => 'tyv',
    'twi'                                           => 'tw',
    'tyap'                                          => 'kcg',
    'udmurt'                                        => 'udm',
    'ugaritik'                                      => 'uga',
    'uighur'                                        => 'ug',
    'ukrainian'                                     => 'uk',
    'umbundu'                                       => 'umb',
    'urdu'                                          => 'ur',
    'uzbek'                                         => 'uz',
    'vai'                                           => 'vai',
    'venda'                                         => 've',
    'vietnamese'                                    => 'vi',
    'volapk'                                        => 'vo',
    'votik'                                         => 'vot',
    'walamo'                                        => 'wal',
    'walloon'                                       => 'wa',
    'waray'                                         => 'war',
    'washo'                                         => 'was',
    'welsh'                                         => 'cy',
    'wolof'                                         => 'wo',
    'xhosa'                                         => 'xh',
    'yakut'                                         => 'sah',
    'yao'                                           => 'yao',
    'yap'                                           => 'yap',
    'yiddish'                                       => 'yi',
    'yoruba'                                        => 'yo',
    'yunani'                                        => 'el',
    "yunani\ kuno\ sd\ "                            => 'grc',
    'zande'                                         => 'znd',
    'zapotek'                                       => 'zap',
    'zaza'                                          => 'zza',
    'zenaga'                                        => 'zen',
    'zhuang'                                        => 'za',
    'zulu'                                          => 'zu',
    'zuni'                                          => 'zun',
);

1;
