package Locales::DB::Language::hu;

# Auto generated from CLDR

$Locales::DB::Language::hu::VERSION = '0.01';

$Locales::DB::Language::hu::cldr_version = '1.7.1';

%Locales::DB::Language::hu::misc_info = (
    'cldr_formats' => {
        'decimal' => {
            'content'    => "\#\,\#\#0\.\#\#\#",
            'references' => 'R079'
        },
        'language'  => "Nyelv\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Régió\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "nem\:n",
        'yesstr' => "igen\:i"
    },
);

%Locales::DB::Language::hu::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abház',
    'ace'   => 'achinéz',
    'ach'   => 'akoli',
    'ada'   => 'adangme',
    'ady'   => 'adyghe',
    'ae'    => 'avesztán',
    'af'    => 'afrikaans',
    'afa'   => "afroázsiai\ nyelv",
    'afh'   => 'afrihili',
    'ain'   => 'ainu',
    'ak'    => 'akan',
    'akk'   => 'akkád',
    'ale'   => 'aleut',
    'alg'   => "algonkin\ nyelv",
    'alt'   => "dél\-altaji",
    'am'    => 'amhara',
    'an'    => 'aragonéz',
    'ang'   => 'óangol',
    'anp'   => 'angika',
    'apa'   => "apacs\ nyelvek",
    'ar'    => 'arab',
    'arc'   => 'arámi',
    'arn'   => 'araucani',
    'arp'   => 'arapaho',
    'art'   => "mesterséges\ nyelv",
    'arw'   => 'aravak',
    'as'    => 'asszámi',
    'ast'   => 'asztúr',
    'ath'   => "atapaszkan\ nyelvek",
    'aus'   => "ausztrál\ nyelvek",
    'av'    => 'avar',
    'awa'   => 'awádi',
    'ay'    => 'ajmara',
    'az'    => 'azerbajdzsáni',
    'ba'    => 'baskír',
    'bad'   => 'banda',
    'bai'   => "bamileke\ nyelvek",
    'bal'   => 'balucsi',
    'ban'   => 'balinéz',
    'bas'   => 'basza',
    'bat'   => "balti\ nyelv",
    'be'    => 'belorusz',
    'bej'   => 'bedzsa',
    'bem'   => 'bemba',
    'ber'   => 'berber',
    'bg'    => 'bolgár',
    'bh'    => 'bihari',
    'bho'   => 'bodzspuri',
    'bi'    => 'bislama',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengáli',
    'bnt'   => 'bantu',
    'bo'    => 'tibeti',
    'br'    => 'breton',
    'bra'   => 'braj',
    'bs'    => 'bosnyák',
    'btk'   => 'batak',
    'bua'   => 'burját',
    'bug'   => 'buginéz',
    'byn'   => 'blin',
    'ca'    => 'katalán',
    'cad'   => 'caddo',
    'cai'   => "egyéb\ közép\-amerikai\ indián",
    'car'   => 'karib',
    'cau'   => "egyéb\ kaukázusi",
    'cch'   => 'atszam',
    'ce'    => 'csecsen',
    'ceb'   => 'cebui',
    'cel'   => "egyéb\ kelta",
    'ch'    => 'csamoró',
    'chb'   => 'csibcsa',
    'chg'   => 'csagatáj',
    'chk'   => 'csukéz',
    'chm'   => 'mari',
    'chn'   => "csinuk\ zsargon",
    'cho'   => 'csoktó',
    'chp'   => 'csipevé',
    'chr'   => 'cseroki',
    'chy'   => 'csejen',
    'cmc'   => "csam\ nyelv",
    'co'    => 'korzikai',
    'cop'   => 'kopt',
    'cpe'   => "egyéb\ angol\ alapú\ kreol\ és\ pidgin",
    'cpf'   => "egyéb\ francia\ alapú\ kreol\ és\ pidgin",
    'cpp'   => "portugál\ alapú\ kreol\ vagy\ pidgin",
    'cr'    => 'krí',
    'crh'   => "krími\ tatár",
    'crp'   => "kreol\ és\ pidzsin",
    'cs'    => 'cseh',
    'csb'   => 'kasub',
    'cu'    => "egyházi\ szláv",
    'cus'   => "kusita\ nyelv",
    'cv'    => 'csuvas',
    'cy'    => 'walesi',
    'da'    => 'dán',
    'dak'   => 'dakota',
    'dar'   => 'dargva',
    'day'   => 'dajak',
    'de'    => 'német',
    'de_at' => "osztrák\ német",
    'de_ch' => "svájci\ felnémet",
    'del'   => 'delavár',
    'den'   => 'szlevi',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => 'dogri',
    'dra'   => "egyéb\ dravida",
    'dsb'   => "alsó\ szorb",
    'dua'   => 'duala',
    'dum'   => "közép\ holland",
    'dv'    => 'divehi',
    'dyu'   => 'diula',
    'dz'    => 'butáni',
    'ee'    => 'eve',
    'efi'   => 'efik',
    'egy'   => 'óegyiptomi',
    'eka'   => 'ekadzsuk',
    'el'    => 'görög',
    'elx'   => 'elamit',
    'en'    => 'angol',
    'en_au' => "ausztrál\ angol",
    'en_ca' => "kanadai\ angol",
    'en_gb' => "brit\ angol",
    'en_us' => "amerikai\ angol",
    'enm'   => "közép\ angol",
    'eo'    => 'eszperantó',
    'es'    => 'spanyol',
    'es_es' => "ibériai\ spanyol",
    'et'    => 'észt',
    'eu'    => 'baszk',
    'ewo'   => 'evondo',
    'fa'    => 'perzsa',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulani',
    'fi'    => 'finn',
    'fil'   => 'filippínó',
    'fiu'   => "finnugor\ nyelv",
    'fj'    => 'fidzsi',
    'fo'    => 'feröeri',
    'fon'   => 'fon',
    'fr'    => 'francia',
    'fr_ca' => "kanadai\ francia",
    'fr_ch' => "svájci\ francia",
    'frm'   => "közép\ francia",
    'fro'   => 'ófrancia',
    'frr'   => "északi\ fríz",
    'frs'   => "keleti\ fríz",
    'fur'   => 'friuli',
    'fy'    => 'fríz',
    'ga'    => 'ír',
    'gaa'   => 'ga',
    'gay'   => 'gajo',
    'gba'   => 'gbaja',
    'gd'    => "skót\ gael",
    'gem'   => "germán\ nyelv",
    'gez'   => 'geez',
    'gil'   => 'ikiribati',
    'gl'    => 'galíciai',
    'gmh'   => "közép\ felső\ német",
    'gn'    => 'guarani',
    'goh'   => "ófelső\ német",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gót',
    'grb'   => 'grebó',
    'grc'   => 'ógörög',
    'gsw'   => "svájci\ német",
    'gu'    => 'gudzsarati',
    'gv'    => "Man\-szigeti",
    'gwi'   => 'gvicsin',
    'ha'    => 'hausza',
    'hai'   => 'haida',
    'haw'   => 'hawaii',
    'he'    => 'héber',
    'hi'    => 'hindi',
    'hil'   => 'hiligajnon',
    'him'   => 'himaháli',
    'hit'   => 'hittite',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'horvát',
    'hsb'   => "felső\ szorb",
    'ht'    => 'haiti',
    'hu'    => 'magyar',
    'hup'   => 'hupa',
    'hy'    => 'örmény',
    'hz'    => 'herero',
    'ia'    => 'interlingva',
    'iba'   => 'iban',
    'id'    => 'indonéz',
    'ie'    => 'interlingue',
    'ig'    => 'igbó',
    'ii'    => "szecsuán\ ji",
    'ijo'   => 'idzsó',
    'ik'    => 'inupiak',
    'ilo'   => 'ilokó',
    'inc'   => "egyéb\ indiai",
    'ine'   => "indoeurópai\ nyelv",
    'inh'   => 'ingus',
    'io'    => 'idó',
    'ira'   => 'iráni',
    'iro'   => "irokéz\ nyelvek",
    'is'    => 'izlandi',
    'it'    => 'olasz',
    'iu'    => 'inuktitut',
    'ja'    => 'japán',
    'jbo'   => 'lojban',
    'jpr'   => "zsidó\-perzsa",
    'jrb'   => "zsidó\-arab",
    'jv'    => 'jávai',
    'ka'    => 'grúz',
    'kaa'   => "kara\-kalpak",
    'kab'   => 'kabije',
    'kac'   => 'kacsin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardi',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'kaszi',
    'khi'   => "egyéb\ koiszan",
    'kho'   => 'kotanéz',
    'ki'    => 'kikuju',
    'kj'    => 'kuanyama',
    'kk'    => 'kazah',
    'kl'    => 'grönlandi',
    'km'    => 'kambodzsai',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'koreai',
    'kok'   => 'konkani',
    'kos'   => 'kosrei',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karacsáj\-balkár",
    'krl'   => 'karelai',
    'kro'   => 'kru',
    'kru'   => 'kuruh',
    'ks'    => 'kásmíri',
    'ku'    => 'kurd',
    'kum'   => 'kumük',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'korni',
    'ky'    => 'kirgiz',
    'la'    => 'latin',
    'lad'   => 'ladino',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxemburgi',
    'lez'   => 'lezg',
    'lg'    => 'ganda',
    'li'    => 'limburgi',
    'ln'    => 'lingala',
    'lo'    => 'laoszi',
    'lol'   => 'mongó',
    'loz'   => 'lozi',
    'lt'    => 'litván',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'lv'    => 'lett',
    'mad'   => 'madurai',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makaszar',
    'man'   => 'mandingó',
    'map'   => 'ausztronéz',
    'mas'   => 'masai',
    'mdf'   => 'moksán',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'málgas',
    'mga'   => "közép\ ír",
    'mh'    => 'marshalli',
    'mi'    => 'maori',
    'mic'   => 'mikmak',
    'min'   => 'minangkabau',
    'mis'   => "egyéb\ nyelvek",
    'mk'    => 'macedón',
    'mkh'   => "egyéb\ mon\-khmer",
    'ml'    => 'malajálam',
    'mn'    => 'mongol',
    'mnc'   => 'mandzsu',
    'mni'   => 'manipuri',
    'mno'   => "manobó\ nyelvek",
    'mo'    => 'moldvai',
    'moh'   => 'mohawk',
    'mos'   => 'moszi',
    'mr'    => 'marathi',
    'ms'    => 'maláj',
    'mt'    => 'máltai',
    'mul'   => "többszörös\ nyelvek",
    'mun'   => "munda\ nyelvek",
    'mus'   => 'krík',
    'mwl'   => 'mirandéz',
    'mwr'   => 'marvari',
    'my'    => 'burmai',
    'myn'   => "maja\ nyelvek",
    'myv'   => 'erzjány',
    'na'    => 'naurui',
    'nah'   => 'nahuati',
    'nai'   => "észak\-amerikai\ indián\ nyelv",
    'nap'   => 'nápolyi',
    'nb'    => "norvég\ bokmal",
    'nd'    => "északi\ ndebele",
    'nds'   => 'alsónémet',
    'ne'    => 'nepáli',
    'new'   => 'nevari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "niger\-kordofan\ nyelv",
    'niu'   => 'niui',
    'nl'    => 'holland',
    'nl_be' => 'flamand',
    'nn'    => "norvég\ nynorsk",
    'no'    => 'norvég',
    'nog'   => 'nogaj',
    'non'   => 'óskandináv',
    'nqo'   => "n\'kó",
    'nr'    => "déli\ ndebele",
    'nso'   => "északi\ szotó",
    'nub'   => "núbiai\ nyelv",
    'nv'    => 'navahó',
    'nwc'   => "klasszikus\ newari",
    'ny'    => 'nyanja',
    'nym'   => 'nyamvézi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoró',
    'nzi'   => 'nzima',
    'oc'    => 'okszitán',
    'oj'    => 'ojibva',
    'om'    => 'oromói',
    'or'    => 'orija',
    'os'    => 'oszét',
    'osa'   => 'osage',
    'ota'   => "ottomán\ török",
    'oto'   => "otomi\ nyelv",
    'pa'    => 'pandzsábi',
    'paa'   => "pápuai\ nyelv",
    'pag'   => 'pangaszinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampangan',
    'pap'   => 'papiamentó',
    'pau'   => 'palaui',
    'peo'   => 'óperzsa',
    'phi'   => "Fülöp\-szigeteki\ nyelv",
    'phn'   => 'főniciai',
    'pi'    => 'pali',
    'pl'    => 'lengyel',
    'pon'   => 'pohnpei',
    'pra'   => "prakrit\ nyelvek",
    'pro'   => 'óprovánszi',
    'ps'    => 'pastu',
    'pt'    => 'portugál',
    'pt_br' => "brazíliai\ portugál",
    'pt_pt' => "ibériai\ portugál",
    'qu'    => 'kecsua',
    'raj'   => 'radzsasztáni',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongai',
    'rm'    => "réto\-román",
    'rn'    => 'kirundi',
    'ro'    => 'román',
    'roa'   => "román\ nyelv",
    'rom'   => 'roma',
    'ru'    => 'orosz',
    'rup'   => 'aromán',
    'rw'    => 'kiruanda',
    'sa'    => 'szanszkrit',
    'sad'   => 'szandave',
    'sah'   => 'jakut',
    'sai'   => "dél\-amerikai\ indián\ nyelv",
    'sal'   => "szelis\ nyelv",
    'sam'   => "szamaritánus\ arámi",
    'sas'   => 'sasak',
    'sat'   => 'szantáli',
    'sc'    => 'szardíniai',
    'scn'   => 'szicíliai',
    'sco'   => 'skót',
    'sd'    => 'szindhi',
    'se'    => "északi\ számi",
    'sel'   => 'szölkup',
    'sem'   => "egyéb\ szemita",
    'sg'    => 'szangó',
    'sga'   => 'óír',
    'sgn'   => 'jelnyelv',
    'sh'    => 'szerbhorvát',
    'shn'   => 'san',
    'si'    => 'szingaléz',
    'sid'   => 'szidamó',
    'sio'   => "sziú\ nyelvek",
    'sit'   => "sinotibeti\ nyelv",
    'sk'    => 'szlovák',
    'sl'    => 'szlovén',
    'sla'   => "szláv\ nyelv",
    'sm'    => 'szamoai',
    'sma'   => "déli\ számi",
    'smi'   => "lapp\ nyelv",
    'smj'   => "lule\ számi",
    'smn'   => "inar\ sami",
    'sms'   => "koltta\ lapp",
    'sn'    => 'sona',
    'snk'   => 'szoninke',
    'so'    => 'szomáliai',
    'sog'   => 'sogdien',
    'son'   => 'szongai',
    'sq'    => 'albán',
    'sr'    => 'szerb',
    'srn'   => "szranai\ tongó",
    'srr'   => 'szerer',
    'ss'    => 'sziszuati',
    'ssa'   => "nílusi\-szaharai\ nyelv",
    'st'    => 'szeszotó',
    'su'    => 'szundanéz',
    'suk'   => 'szukuma',
    'sus'   => 'szuszu',
    'sux'   => 'sumér',
    'sv'    => 'svéd',
    'sw'    => 'szuahéli',
    'syc'   => "klasszikus\ szír",
    'syr'   => 'szíriai',
    'ta'    => 'tamil',
    'tai'   => "thai\ nyelv",
    'te'    => 'telugu',
    'tem'   => 'temne',
    'ter'   => 'terenó',
    'tet'   => 'tetum',
    'tg'    => 'tadzsik',
    'th'    => 'thai',
    'ti'    => 'tigrinja',
    'tig'   => 'tigré',
    'tiv'   => 'tiv',
    'tk'    => 'türkmén',
    'tkl'   => 'tokelaui',
    'tl'    => 'tagalog',
    'tlh'   => 'klingon',
    'tli'   => 'tlingit',
    'tmh'   => 'tamasek',
    'tn'    => 'szecsuáni',
    'to'    => 'tonga',
    'tog'   => "nyasa\ tonga",
    'tpi'   => "tok\ pisin",
    'tr'    => 'török',
    'trv'   => 'Taroko',
    'ts'    => 'conga',
    'tsi'   => 'csimsiáni',
    'tt'    => 'tatár',
    'tum'   => 'tumbuka',
    'tup'   => "tupi\ nyelv",
    'tut'   => "altáji\ nyelv",
    'tvl'   => 'tuvalu',
    'tw'    => 'twi',
    'ty'    => 'tahiti',
    'tyv'   => 'tuvai',
    'udm'   => 'udmurt',
    'ug'    => 'ujgur',
    'uga'   => 'ugariti',
    'uk'    => 'ukrán',
    'umb'   => 'umbundu',
    'und'   => "ismeretlen\ vagy\ érvénytelen\ nyelv",
    'ur'    => 'urdu',
    'uz'    => 'üzbég',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnámi',
    'vo'    => 'volapük',
    'vot'   => 'votják',
    'wa'    => 'vallon',
    'wak'   => "vakas\ nyelv",
    'wal'   => 'valamo',
    'war'   => 'varaó',
    'was'   => 'vasó',
    'wen'   => "szorb\ nyelvek",
    'wo'    => 'volof',
    'xal'   => 'kalmük',
    'xh'    => 'hosza',
    'yao'   => 'jaó',
    'yap'   => 'japi',
    'yi'    => 'jiddis',
    'yo'    => 'joruba',
    'ypk'   => "jupik\ nyelv",
    'za'    => 'zsuang',
    'zap'   => 'zapoték',
    'zbl'   => "Bliss\ jelképrendszer",
    'zen'   => 'zenaga',
    'zh'    => 'kínai',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "nincs\ nyelvészeti\ tartalom",
    'zza'   => 'zaza',
);

%Locales::DB::Language::hu::name_to_code = (
    'abhz'                                  => 'ab',
    'achinz'                                => 'ace',
    'adangme'                               => 'ada',
    'adyghe'                                => 'ady',
    'afar'                                  => 'aa',
    'afrihili'                              => 'afh',
    'afrikaans'                             => 'af',
    "afrozsiai\ nyelv"                      => 'afa',
    'ainu'                                  => 'ain',
    'ajmara'                                => 'ay',
    'akan'                                  => 'ak',
    'akkd'                                  => 'akk',
    'akoli'                                 => 'ach',
    'albn'                                  => 'sq',
    'aleut'                                 => 'ale',
    "algonkin\ nyelv"                       => 'alg',
    "als\ szorb"                            => 'dsb',
    'alsnmet'                               => 'nds',
    "altji\ nyelv"                          => 'tut',
    "amerikai\ angol"                       => 'en_us',
    'amhara'                                => 'am',
    'angika'                                => 'anp',
    'angol'                                 => 'en',
    "apacs\ nyelvek"                        => 'apa',
    'arab'                                  => 'ar',
    'aragonz'                               => 'an',
    'arapaho'                               => 'arp',
    'araucani'                              => 'arn',
    'aravak'                                => 'arw',
    'armi'                                  => 'arc',
    'aromn'                                 => 'rup',
    'asszmi'                                => 'as',
    'asztr'                                 => 'ast',
    "atapaszkan\ nyelvek"                   => 'ath',
    'atszam'                                => 'cch',
    "ausztrl\ angol"                        => 'en_au',
    "ausztrl\ nyelvek"                      => 'aus',
    'ausztronz'                             => 'map',
    'avar'                                  => 'av',
    'avesztn'                               => 'ae',
    'awdi'                                  => 'awa',
    'azerbajdzsni'                          => 'az',
    'balinz'                                => 'ban',
    "balti\ nyelv"                          => 'bat',
    'balucsi'                               => 'bal',
    'bambara'                               => 'bm',
    "bamileke\ nyelvek"                     => 'bai',
    'banda'                                 => 'bad',
    'bantu'                                 => 'bnt',
    'baskr'                                 => 'ba',
    'basza'                                 => 'bas',
    'baszk'                                 => 'eu',
    'batak'                                 => 'btk',
    'bedzsa'                                => 'bej',
    'belorusz'                              => 'be',
    'bemba'                                 => 'bem',
    'bengli'                                => 'bn',
    'berber'                                => 'ber',
    'bihari'                                => 'bh',
    'bikol'                                 => 'bik',
    'bini'                                  => 'bin',
    'bislama'                               => 'bi',
    'blin'                                  => 'byn',
    "bliss\ jelkprendszer"                  => 'zbl',
    'bodzspuri'                             => 'bho',
    'bolgr'                                 => 'bg',
    'bosnyk'                                => 'bs',
    'braj'                                  => 'bra',
    "brazliai\ portugl"                     => 'pt_br',
    'breton'                                => 'br',
    "brit\ angol"                           => 'en_gb',
    'buginz'                                => 'bug',
    'burjt'                                 => 'bua',
    'burmai'                                => 'my',
    'butni'                                 => 'dz',
    'caddo'                                 => 'cad',
    'cebui'                                 => 'ceb',
    'conga'                                 => 'ts',
    'csagatj'                               => 'chg',
    "csam\ nyelv"                           => 'cmc',
    'csamor'                                => 'ch',
    'csecsen'                               => 'ce',
    'cseh'                                  => 'cs',
    'csejen'                                => 'chy',
    'cseroki'                               => 'chr',
    'csibcsa'                               => 'chb',
    'csimsini'                              => 'tsi',
    "csinuk\ zsargon"                       => 'chn',
    'csipev'                                => 'chp',
    'csokt'                                 => 'cho',
    'csukz'                                 => 'chk',
    'csuvas'                                => 'cv',
    'dajak'                                 => 'day',
    'dakota'                                => 'dak',
    'dargva'                                => 'dar',
    'delavr'                                => 'del',
    'dinka'                                 => 'din',
    'diula'                                 => 'dyu',
    'divehi'                                => 'dv',
    'dlaltaji'                              => 'alt',
    "dlamerikai\ indin\ nyelv"              => 'sai',
    "dli\ ndebele"                          => 'nr',
    "dli\ szmi"                             => 'sma',
    'dn'                                    => 'da',
    'dogri'                                 => 'doi',
    'dogrib'                                => 'dgr',
    'duala'                                 => 'dua',
    'efik'                                  => 'efi',
    "egyb\ angol\ alap\ kreol\ s\ pidgin"   => 'cpe',
    "egyb\ dravida"                         => 'dra',
    "egyb\ francia\ alap\ kreol\ s\ pidgin" => 'cpf',
    "egyb\ indiai"                          => 'inc',
    "egyb\ kaukzusi"                        => 'cau',
    "egyb\ kelta"                           => 'cel',
    "egyb\ koiszan"                         => 'khi',
    "egyb\ kzpamerikai\ indin"              => 'cai',
    "egyb\ monkhmer"                        => 'mkh',
    "egyb\ nyelvek"                         => 'mis',
    "egyb\ szemita"                         => 'sem',
    "egyhzi\ szlv"                          => 'cu',
    'egyiptomi'                             => 'egy',
    'ekadzsuk'                              => 'eka',
    'elamit'                                => 'elx',
    'erzjny'                                => 'myv',
    'eszperant'                             => 'eo',
    'eve'                                   => 'ee',
    'evondo'                                => 'ewo',
    'fang'                                  => 'fan',
    'fanti'                                 => 'fat',
    "fels\ nmet"                            => 'goh',
    "fels\ szorb"                           => 'hsb',
    'fereri'                                => 'fo',
    'fidzsi'                                => 'fj',
    'filippn'                               => 'fil',
    'finn'                                  => 'fi',
    "finnugor\ nyelv"                       => 'fiu',
    'flamand'                               => 'nl_be',
    "flpszigeteki\ nyelv"                   => 'phi',
    'fniciai'                               => 'phn',
    'fon'                                   => 'fon',
    'francia'                               => 'fro',
    'friuli'                                => 'fur',
    'frz'                                   => 'fy',
    'fulani'                                => 'ff',
    'ga'                                    => 'gaa',
    'gajo'                                  => 'gay',
    'galciai'                               => 'gl',
    'ganda'                                 => 'lg',
    'gbaja'                                 => 'gba',
    'geez'                                  => 'gez',
    "germn\ nyelv"                          => 'gem',
    'gondi'                                 => 'gon',
    'gorontalo'                             => 'gor',
    'greb'                                  => 'grb',
    'grg'                                   => 'grc',
    'grnlandi'                              => 'kl',
    'grz'                                   => 'ka',
    'gt'                                    => 'got',
    'guarani'                               => 'gn',
    'gudzsarati'                            => 'gu',
    'gvicsin'                               => 'gwi',
    'haida'                                 => 'hai',
    'haiti'                                 => 'ht',
    'hausza'                                => 'ha',
    'hawaii'                                => 'haw',
    'hber'                                  => 'he',
    'herero'                                => 'hz',
    'hiligajnon'                            => 'hil',
    'himahli'                               => 'him',
    'hindi'                                 => 'hi',
    "hiri\ motu"                            => 'ho',
    'hittite'                               => 'hit',
    'hmong'                                 => 'hmn',
    'holland'                               => 'nl',
    'horvt'                                 => 'hr',
    'hosza'                                 => 'xh',
    'hupa'                                  => 'hup',
    'iban'                                  => 'iba',
    "ibriai\ portugl"                       => 'pt_pt',
    "ibriai\ spanyol"                       => 'es_es',
    'id'                                    => 'io',
    'idzs'                                  => 'ijo',
    'igb'                                   => 'ig',
    'ikiribati'                             => 'gil',
    'ilok'                                  => 'ilo',
    "inar\ sami"                            => 'smn',
    "indoeurpai\ nyelv"                     => 'ine',
    'indonz'                                => 'id',
    'ingus'                                 => 'inh',
    'interlingue'                           => 'ie',
    'interlingva'                           => 'ia',
    'inuktitut'                             => 'iu',
    'inupiak'                               => 'ik',
    'irni'                                  => 'ira',
    "irokz\ nyelvek"                        => 'iro',
    "ismeretlen\ vagy\ rvnytelen\ nyelv"    => 'und',
    'izlandi'                               => 'is',
    'ja'                                    => 'yao',
    'jakut'                                 => 'sah',
    'japi'                                  => 'yap',
    'japn'                                  => 'ja',
    'jelnyelv'                              => 'sgn',
    'jiddis'                                => 'yi',
    'jju'                                   => 'kaj',
    'joruba'                                => 'yo',
    "jupik\ nyelv"                          => 'ypk',
    'jvai'                                  => 'jv',
    'kabardi'                               => 'kbd',
    'kabije'                                => 'kab',
    'kacsin'                                => 'kac',
    'kalmk'                                 => 'xal',
    'kamba'                                 => 'kam',
    'kambodzsai'                            => 'km',
    "kanadai\ angol"                        => 'en_ca',
    "kanadai\ francia"                      => 'fr_ca',
    'kannada'                               => 'kn',
    'kanuri'                                => 'kr',
    'karacsjbalkr'                          => 'krc',
    'karakalpak'                            => 'kaa',
    'karelai'                               => 'krl',
    'karen'                                 => 'kar',
    'karib'                                 => 'car',
    'kasub'                                 => 'csb',
    'kaszi'                                 => 'kha',
    'kataln'                                => 'ca',
    'kawi'                                  => 'kaw',
    'kazah'                                 => 'kk',
    'kecsua'                                => 'qu',
    "keleti\ frz"                           => 'frs',
    'kikuju'                                => 'ki',
    'kimbundu'                              => 'kmb',
    'kirgiz'                                => 'ky',
    'kiruanda'                              => 'rw',
    'kirundi'                               => 'rn',
    "klasszikus\ newari"                    => 'nwc',
    "klasszikus\ szr"                       => 'syc',
    'klingon'                               => 'tlh',
    'knai'                                  => 'zh',
    "koltta\ lapp"                          => 'sms',
    'komi'                                  => 'kv',
    'kongo'                                 => 'kg',
    'konkani'                               => 'kok',
    'kopt'                                  => 'cop',
    'koreai'                                => 'ko',
    'korni'                                 => 'kw',
    'koro'                                  => 'kfo',
    'korzikai'                              => 'co',
    'kosrei'                                => 'kos',
    'kotanz'                                => 'kho',
    'kpelle'                                => 'kpe',
    'kr'                                    => 'cr',
    "kreol\ s\ pidzsin"                     => 'crp',
    'krk'                                   => 'mus',
    "krmi\ tatr"                            => 'crh',
    'kru'                                   => 'kro',
    'ksmri'                                 => 'ks',
    'kuanyama'                              => 'kj',
    'kumk'                                  => 'kum',
    'kurd'                                  => 'ku',
    'kuruh'                                 => 'kru',
    "kusita\ nyelv"                         => 'cus',
    'kutenai'                               => 'kut',
    "kzp\ angol"                            => 'enm',
    "kzp\ fels\ nmet"                       => 'gmh',
    "kzp\ francia"                          => 'frm',
    "kzp\ holland"                          => 'dum',
    "kzp\ r"                                => 'mga',
    'ladino'                                => 'lad',
    'lahnda'                                => 'lah',
    'lamba'                                 => 'lam',
    'laoszi'                                => 'lo',
    "lapp\ nyelv"                           => 'smi',
    'latin'                                 => 'la',
    'lengyel'                               => 'pl',
    'lett'                                  => 'lv',
    'lezg'                                  => 'lez',
    'limburgi'                              => 'li',
    'lingala'                               => 'ln',
    'litvn'                                 => 'lt',
    'lojban'                                => 'jbo',
    'lozi'                                  => 'loz',
    'lubakatanga'                           => 'lu',
    'lubalulua'                             => 'lua',
    'luiseno'                               => 'lui',
    "lule\ szmi"                            => 'smj',
    'lunda'                                 => 'lun',
    'luo'                                   => 'luo',
    'lushai'                                => 'lus',
    'luxemburgi'                            => 'lb',
    'macedn'                                => 'mk',
    'madurai'                               => 'mad',
    'magahi'                                => 'mag',
    'magyar'                                => 'hu',
    'maithili'                              => 'mai',
    "maja\ nyelvek"                         => 'myn',
    'makaszar'                              => 'mak',
    'malajlam'                              => 'ml',
    'malj'                                  => 'ms',
    'mandar'                                => 'mdr',
    'manding'                               => 'man',
    'mandzsu'                               => 'mnc',
    'manipuri'                              => 'mni',
    "manob\ nyelvek"                        => 'mno',
    'manszigeti'                            => 'gv',
    'maori'                                 => 'mi',
    'marathi'                               => 'mr',
    'mari'                                  => 'chm',
    'marshalli'                             => 'mh',
    'marvari'                               => 'mwr',
    'masai'                                 => 'mas',
    'mende'                                 => 'men',
    "mestersges\ nyelv"                     => 'art',
    'mikmak'                                => 'mic',
    'minangkabau'                           => 'min',
    'mirandz'                               => 'mwl',
    'mlgas'                                 => 'mg',
    'mltai'                                 => 'mt',
    'mohawk'                                => 'moh',
    'moksn'                                 => 'mdf',
    'moldvai'                               => 'mo',
    'mong'                                  => 'lol',
    'mongol'                                => 'mn',
    'morisyen'                              => 'mfe',
    'moszi'                                 => 'mos',
    "munda\ nyelvek"                        => 'mun',
    'nahuati'                               => 'nah',
    'naurui'                                => 'na',
    'navah'                                 => 'nv',
    "nbiai\ nyelv"                          => 'nub',
    'ndonga'                                => 'ng',
    'nepli'                                 => 'ne',
    'nevari'                                => 'new',
    'nias'                                  => 'nia',
    "nigerkordofan\ nyelv"                  => 'nic',
    "nincs\ nyelvszeti\ tartalom"           => 'zxx',
    'niui'                                  => 'niu',
    'nk'                                    => 'nqo',
    "nlusiszaharai\ nyelv"                  => 'ssa',
    'nmet'                                  => 'de',
    'nogaj'                                 => 'nog',
    'norvg'                                 => 'no',
    "norvg\ bokmal"                         => 'nb',
    "norvg\ nynorsk"                        => 'nn',
    'npolyi'                                => 'nap',
    'nyamvzi'                               => 'nym',
    'nyanja'                                => 'ny',
    'nyankole'                              => 'nyn',
    "nyasa\ tonga"                          => 'tog',
    'nyor'                                  => 'nyo',
    'nzima'                                 => 'nzi',
    'ojibva'                                => 'oj',
    'okszitn'                               => 'oc',
    'olasz'                                 => 'it',
    'orija'                                 => 'or',
    'oromi'                                 => 'om',
    'orosz'                                 => 'ru',
    'osage'                                 => 'osa',
    'oszt'                                  => 'os',
    "osztrk\ nmet"                          => 'de_at',
    "otomi\ nyelv"                          => 'oto',
    "ottomn\ trk"                           => 'ota',
    'pahlavi'                               => 'pal',
    'palaui'                                => 'pau',
    'pali'                                  => 'pi',
    'pampangan'                             => 'pam',
    'pandzsbi'                              => 'pa',
    'pangaszinan'                           => 'pag',
    'papiament'                             => 'pap',
    'pastu'                                 => 'ps',
    'perzsa'                                => 'peo',
    'pohnpei'                               => 'pon',
    'portugl'                               => 'pt',
    "portugl\ alap\ kreol\ vagy\ pidgin"    => 'cpp',
    "ppuai\ nyelv"                          => 'paa',
    "prakrit\ nyelvek"                      => 'pra',
    'provnszi'                              => 'pro',
    'r'                                     => 'sga',
    'radzsasztni'                           => 'raj',
    'rapanui'                               => 'rap',
    'rarotongai'                            => 'rar',
    'rmny'                                  => 'hy',
    'roma'                                  => 'rom',
    'romn'                                  => 'ro',
    "romn\ nyelv"                           => 'roa',
    'rtoromn'                               => 'rm',
    'san'                                   => 'shn',
    'sasak'                                 => 'sas',
    'siksika'                               => 'bla',
    "sinotibeti\ nyelv"                     => 'sit',
    'skandinv'                              => 'non',
    'skt'                                   => 'sco',
    "skt\ gael"                             => 'gd',
    'sogdien'                               => 'sog',
    'sona'                                  => 'sn',
    'spanyol'                               => 'es',
    'sumr'                                  => 'sux',
    'svd'                                   => 'sv',
    "svjci\ felnmet"                        => 'de_ch',
    "svjci\ francia"                        => 'fr_ch',
    "svjci\ nmet"                           => 'gsw',
    "szakamerikai\ indin\ nyelv"            => 'nai',
    "szaki\ frz"                            => 'frr',
    "szaki\ ndebele"                        => 'nd',
    "szaki\ szmi"                           => 'se',
    "szaki\ szot"                           => 'nso',
    "szamaritnus\ armi"                     => 'sam',
    'szamoai'                               => 'sm',
    'szandave'                              => 'sad',
    'szang'                                 => 'sg',
    'szanszkrit'                            => 'sa',
    'szantli'                               => 'sat',
    'szardniai'                             => 'sc',
    "szecsun\ ji"                           => 'ii',
    'szecsuni'                              => 'tn',
    "szelis\ nyelv"                         => 'sal',
    'szerb'                                 => 'sr',
    'szerbhorvt'                            => 'sh',
    'szerer'                                => 'srr',
    'szeszot'                               => 'st',
    "szi\ nyelvek"                          => 'sio',
    'szicliai'                              => 'scn',
    'szidam'                                => 'sid',
    'szindhi'                               => 'sd',
    'szingalz'                              => 'si',
    'sziszuati'                             => 'ss',
    'szlevi'                                => 'den',
    'szlkup'                                => 'sel',
    'szlovk'                                => 'sk',
    'szlovn'                                => 'sl',
    "szlv\ nyelv"                           => 'sla',
    'szomliai'                              => 'so',
    'szongai'                               => 'son',
    'szoninke'                              => 'snk',
    "szorb\ nyelvek"                        => 'wen',
    "szranai\ tong"                         => 'srn',
    'szriai'                                => 'syr',
    'szt'                                   => 'et',
    'szuahli'                               => 'sw',
    'szukuma'                               => 'suk',
    'szundanz'                              => 'su',
    'szuszu'                                => 'sus',
    'tadzsik'                               => 'tg',
    'tagalog'                               => 'tl',
    'tahiti'                                => 'ty',
    'tamasek'                               => 'tmh',
    'tamil'                                 => 'ta',
    'taroko'                                => 'trv',
    'tatr'                                  => 'tt',
    "tbbszrs\ nyelvek"                      => 'mul',
    'telugu'                                => 'te',
    'temne'                                 => 'tem',
    'teren'                                 => 'ter',
    'tetum'                                 => 'tet',
    'thai'                                  => 'th',
    "thai\ nyelv"                           => 'tai',
    'tibeti'                                => 'bo',
    'tigr'                                  => 'tig',
    'tigrinja'                              => 'ti',
    'tiv'                                   => 'tiv',
    'tlingit'                               => 'tli',
    "tok\ pisin"                            => 'tpi',
    'tokelaui'                              => 'tkl',
    'tonga'                                 => 'to',
    'trk'                                   => 'tr',
    'trkmn'                                 => 'tk',
    'tumbuka'                               => 'tum',
    "tupi\ nyelv"                           => 'tup',
    'tuvai'                                 => 'tyv',
    'tuvalu'                                => 'tvl',
    'twi'                                   => 'tw',
    'tyap'                                  => 'kcg',
    'udmurt'                                => 'udm',
    'ugariti'                               => 'uga',
    'ujgur'                                 => 'ug',
    'ukrn'                                  => 'uk',
    'umbundu'                               => 'umb',
    'urdu'                                  => 'ur',
    'vai'                                   => 'vai',
    "vakas\ nyelv"                          => 'wak',
    'valamo'                                => 'wal',
    'vallon'                                => 'wa',
    'vara'                                  => 'war',
    'vas'                                   => 'was',
    'venda'                                 => 've',
    'vietnmi'                               => 'vi',
    'volapk'                                => 'vo',
    'volof'                                 => 'wo',
    'votjk'                                 => 'vot',
    'walesi'                                => 'cy',
    'zande'                                 => 'znd',
    'zapotk'                                => 'zap',
    'zaza'                                  => 'zza',
    'zbg'                                   => 'uz',
    'zenaga'                                => 'zen',
    'zsidarab'                              => 'jrb',
    'zsidperzsa'                            => 'jpr',
    'zsuang'                                => 'za',
    'zulu'                                  => 'zu',
    'zuni'                                  => 'zun',
);

1;
