no warnings;

use Number::Format;

################################################################################

sub fill_in_i18n {

	my ($lang, $entries) = @_;
   	$conf -> {i18n} ||= {};
   	$conf -> {i18n} -> {$lang} ||= {};
	return if $conf -> {i18n} -> {$lang} -> {_is_filled};
	
	while (my ($key, $value) = each %$entries) {
		$conf -> {i18n} -> {$lang} -> {$key} ||= $value;
	}
	
	$conf -> {i18n} -> {$lang} -> {_page_title} ||= $conf -> {page_title};

	$conf -> {i18n} -> {$lang} -> {_is_filled} = 1;

};

#################################################################################

sub handler {

	our $_PACKAGE = __PACKAGE__ . '::';
	
	my  $use_cgi = $ENV {SCRIPT_NAME} =~ m{index\.pl} || $ENV {GATEWAY_INTERFACE} =~ m{^CGI/} || $conf -> {use_cgi} || $preconf -> {use_cgi} || !$INC{'Apache/Request.pm'};
	
	our $r   = $use_cgi ? new Zanas::Request () : $_[0];

	our $apr = $use_cgi ? $r : Apache::Request -> new ($r);
		
	my $parms = $apr -> parms;
	our %_REQUEST = %{$parms};
	
	$_REQUEST {type} =~ s/_for_.*//;
	$_REQUEST {__uri} = $r -> uri;
	$_REQUEST {__uri} =~ s{\/\w+\.\w+$}{};
	
	$number_format or our $number_format = Number::Format -> new (%{$conf -> {number_format}});
	
   	sql_reconnect ();

	require_fresh ($_PACKAGE . '::Config');

   	$conf -> {dbf_dsn} and our $dbf = DBI -> connect ($conf -> {dbf_dsn}, {RaiseError => 1});
   	
   	$conf -> {lang} ||= 'RUS';
   	
   	$conf -> {i18n} ||= {};
   	
   	fill_in_i18n ('RUS', {
   		_charset                 => 'windows-1251',
		Exit                     => '',
		toolbar_pager_empty_list => ' ',		
		toolbar_pager_of         => '  ',
		confirm_ok               => ' ?',
		confirm_esc              => '   ?',
		ok                       => '', 
		cancel                   => '', 
		'close'                  => '',
		back                     => '&lt;&lt; ',
		'next'                   => ' &gt;&gt;',		
		User                     => '',
		not_logged_in		 => ' ',
		Print                    => '',
		F1                       => 'F1: ',
		Select                   => '',
   	});
   	
   	fill_in_i18n ('ENG', {
   		_charset                 => 'windows-1252',
		Exit                     => 'Exit',
		toolbar_pager_empty_list => 'empty list',		
		toolbar_pager_of         => ' of ',
		confirm_ok               => 'Commit changes?',
		confirm_esc              => 'Cancel changes?',
		ok                       => 'ok', 
		cancel                   => 'cancel', 
		'close'                  => 'close',
		back                     => '&lt;&lt; back',
		'next'                   => 'next &gt;&gt;',
		User                     => 'User',
		not_logged_in		 => 'not logged in',
		Print                    => 'Print',
		F1                       => 'F1: Help',
		Select                   => 'Select',
   	});
	
   	fill_in_i18n ('FRE', {
   		_charset                 => 'windows-1252',
		Exit                     => 'Quitter',
		toolbar_pager_empty_list => 'liste vide',
		toolbar_pager_of         => ' de ',
		confirm_ok               => 'Sauver des changements?',
		confirm_esc              => 'Quitter sans sauvegarde?',
		ok                       => 'appliquer', 
		cancel                   => 'annuler', 
		'close'                  => 'fermer',
		back                     => '&lt;&lt; pas prcdent',
		'next'                   => 'suite &gt;&gt;',
		User                     => 'Utilisateur',
		not_logged_in		 => 'indfini',
		Print                    => 'Imprimer',
		F1                       => 'F1: Aide',
		Select                   => 'Slection',
   	});

#	$_REQUEST {type} = '_static_files' if $r -> filename =~ /\w\.\w/;

#print STDERR Dumper (\%ENV);
	
	$_REQUEST {type} = '_static_files' if ($ENV{PATH_INFO} =~ /\w\.\w/ || $r -> filename =~ /\w\.\w/);

	$conf -> {include_js}  ||= ['js'];
   	
   	$_REQUEST {__include_js} = [];
   	push @{$_REQUEST {__include_js}}, @{$conf -> {include_js}};

   	$_REQUEST {__include_css} = [];
   	push @{$_REQUEST {__include_css}}, @{$conf -> {include_css}};
   	
	if ($_REQUEST {keepalive}) {
		my $timeout = 60 * $conf -> {session_timeout} - 1;
		keep_alive ($_REQUEST {keepalive});
		$r -> content_type ('text/html');
		$r -> send_http_header;
		print <<EOH;
			<html><head>
				<META HTTP-EQUIV=Refresh CONTENT="$timeout; URL=$_REQUEST {__uri}?keepalive=$_REQUEST{keepalive}">
			</head></html>			
EOH
		return;
	}	
   	
	my $action = $_REQUEST {action};
		
	our $_USER = get_user ();
	
	$_REQUEST {lang} ||= $_USER -> {lang} if $_USER;
	
	$_REQUEST {lang} ||= $preconf -> {lang} || $conf -> {lang}; # According to NISO Z39.53
	
	our $i18n = $conf -> {i18n} -> {$_REQUEST {lang}};
	
	require_fresh ($_PACKAGE . '::Calendar');
	
	eval "our \$_CALENDAR = new ${_PACKAGE}Calendar (\\\%_REQUEST)";
	
	if ((!$_USER and $_REQUEST {type} ne 'logon' and $_REQUEST {type} ne '_static_files')) {

		delete $_REQUEST {sid};
		delete $_REQUEST {salt};
		delete $_REQUEST {_salt};
		delete $_REQUEST {__include_js};
		delete $_REQUEST {__include_css};

		redirect ('/?type=logon&redirect_params=' . uri_escape (Dumper (\%_REQUEST)));
		
	}
	
	elsif (exists ($_USER -> {redirect})) {
		
		redirect (create_url ());
		
	}

	elsif ($_REQUEST {keepalive}) {
	
		redirect ("/\?type=logon&_frame=$_REQUEST{_frame}");
		
	}
	else {
	
		my $user_agent = $r->header_in ('User-Agent');

		$_USER -> {drawer_name} = 
			$user_agent =~ /MSIE [56]/  ? 'MSIE_5':
			$user_agent =~ /Mozilla\/3/ ? 'Mozilla_3':
			$user_agent =~ /Mozilla\/5/ ? 'MSIE_5':
			'Unsupported';
		
		require_fresh ("${_PACKAGE}Content::menu");
		require_fresh ("${_PACKAGE}Content::page");

		$page = get_page ();
	
		unless ($page -> {type} =~ /^_/) {
			require_fresh ("${_PACKAGE}Content::$$page{type}");
			require_fresh ("${_PACKAGE}Presentation::$$page{type}");
		};
		
		if ($action) {
		
			my $sub_name = "validate_${action}_$$page{type}";		
			
			my $error_code = call_for_role ($sub_name);
			
			if ($error_code) {		
				my $error_message_template = $error_messages -> {"${action}_$$page{type}_${error_code}"} || $error_code;
				$_REQUEST {error} = interpolate ($error_message_template);
			}
			
			if ($_REQUEST {error}) {
				out_html ({}, draw_page ($page));
			}
			else {
			
				delete $_REQUEST {__response_sent};

				eval {	
					delete_fakes () if $action eq 'create';
					call_for_role ("do_${action}_$$page{type}");
					
					if (($action eq 'execute') and ($$page{type} eq 'logon') and $_REQUEST {redirect_params}) {
					
						my $VAR1;

						eval $_REQUEST {redirect_params};
						
						while (my ($key, $value) = each %$VAR1) {
							$_REQUEST {$key} = $value;
						}					
						
					}
					
				};	
				
				if ($@) {
					$_REQUEST {error} = $@;
					out_html ({}, draw_page ($page));
				}
				else {
				
					$_REQUEST {__response_sent} or redirect ({action => '', redirect_params => ''}, {kind => 'js'});
				
#					unless ($_REQUEST {__response_sent}) {
				
#						my $url = create_url (action => '', redirect_params => '');
#						out_html ({}, qq {<body onLoad="window.open ('$url&salt=' + Math.random (), '_parent', 'location=0,menubar=0,status=0,toolbar=0')"></body>});
				
#					}
				
				}
				
			}
			
			log_action ($_USER -> {id}, $$page{type}, $action, $_REQUEST {error}, $_REQUEST {id});

		}
		else {

			out_html ({}, draw_page ($page));

		}   

	}
   
   	$db -> disconnect;
	
	return OK;

}

################################################################################

sub out_html {

	my ($options, $html) = @_;
		
	$html or return;
	
	if ($_REQUEST {dbf}) {
		redirect ("/$html");
	}
	
	if ($_REQUEST {xls}) {
	
		my $fn_local = '/i/xls/' . time . "$$.xls";
		my $fn = $r -> document_root . $fn_local;
		open (O, ">$fn") or die "Can't write to $fn: $!";
		print O $html;
		close (O);
		
		download_file ({
			path => $fn_local,
			file_name => "file.xls",
		});
		
		unlink $fn;
		
	}	
	else {
	
		if ($conf -> {core_sweep_spaces}) {
			$html =~ s{^\s+}{}gsm; 
			$html =~ s{[ \t]+}{ }g;
		}

		$_REQUEST {__content_type} ||= 'text/html; charset=' . $i18n -> {_charset};
		$r -> content_type ($_REQUEST {__content_type});
		
		if (($conf -> {core_gzip} or $preconf -> {core_gzip}) and $r -> header_in ('Accept-Encoding') =~ /gzip/) {
			$r -> header_out ('Content-Encoding' => 'gzip');
			$html = Compress::Zlib::memGzip ($html);
		}		

		$r -> header_out ('Content-Length' => length $html);
		$r -> header_out ('Set-Cookie' => "sid=$_REQUEST{sid};path=/;") if $_REQUEST{sid};
		
		$r -> send_http_header;
		print $html;
	}	

}

1;