# $Id: /mirror/coderepos/lang/perl/Senna/trunk/lib/Senna/Constants.pm 38383 2008-01-10T06:50:02.963300Z jiro  $
#
# Copyright (c) 2008 Daisuke Maki daisuke@endeworks.jp>
# all rights reserved.

package Senna::Constants;
use strict;
use warnings;
use Exporter 'import';

our @EXPORT_OK = (
    (map { "SEN_ENC_$_" }   qw(DEFAULT NONE EUCJP UTF8 SJIS)),
    (map { "SEN_RC_$_"  }   qw(SUCCESS MEMORY_EXHAUSTED INVALID_FORMAT FILE_OPERATION_ERR INVALID_ARGUMENT OTHER)),
    (map { "SEN_INDEX_$_" } qw(NORMALIZE SPLIT_ALPHA SPLIT_DIGIT SPLIT_SYMBOL MORPH_ANALYSE NGRAM DELIMITED ENABLE_SUFFIX_SEARCH DISABLE_SUFFIX_SEARCH WITH_VGRAM SHARED_LEXICON WITH_VACUUM)),
    (map { "SEN_SORT_$_" }  qw(ASCENDING DESCENDING)),
    (map { "SEN_SEL_$_" }   qw(OR AND BUT ADJUST)),
    (map { "SEN_CTX_$_" }   qw(USEQL BATCHMODE MORE)),
);

1;

__END__

=head1 NAME

Senna::Constants

=head1 CONSTANTS

=head2 LIBSENNA_VERSION

=head2 LIBSENNA_MAJOR_VERSION

=head2 LIBSENNA_MINOR_VERSION

=head2 LIBSENNA_MICRO_VERSION

senna library version that Senna.pm was built against.

=head2 SEN_ENC_DEFAULT

=head2 SEN_ENC_EUCJP

=head2 SEN_ENC_KOI8R

=head2 SEN_ENC_LATIN1

=head2 SEN_ENC_NONE

=head2 SEN_ENC_SJIS

=head2 SEN_ENC_UTF8

=head2 SEN_RC_SUCCESS

=head2 SEN_RC_MEMORY_EXHAUSTED

=head2 SEN_RC_INVALID_FORMAT

=head2 SEN_RC_FILE_OPERATION_ERR

=head2 SEN_RC_INVALID_ARG

=head2 SEN_RC_OTHER

=head2 SEN_INDEX_DELIMITED

=head2 SEN_INDEX_DISABLE_SUFFIX_SEARCH

=head2 SEN_INDEX_ENABLE_SUFFIX_SEARCH

=head2 SEN_INDEX_MORPH_ANALYSE

=head2 SEN_INDEX_NGRAM

=head2 SEN_INDEX_NORMALIZE

=head2 SEN_INDEX_SPLIT_ALPHA

=head2 SEN_INDEX_SPLIT_DIGIT

=head2 SEN_INDEX_SPLIT_SYMBOL

=head2 SEN_INDEX_WITH_VACUUM

=head2 SEN_SORT_ASCENDING

=head2 SEN_SORT_DESCENDING

=head2 SEN_SYM_MAX_KEY_SIZE

=head2 SEN_SYM_WITH_SIS

=head2 SEN_SYM_NIL

=head2 SEN_SEL_ADJUST

=head2 SEN_SEL_AND

=head2 SEN_SEL_BUT

=head2 SEN_SEL_OR

=head2 SEN_CTX_USEQL

=head2 SEN_CTX_BATCHMODE

=head2 SEN_CTX_MORE

=cut
