package Catan::Map::Intersection;
$Catan::Map::Intersection::VERSION = '0.03';
use strict;
use warnings;

use overload
  '""' => 'uuid',
  fallback => 1;

sub new
{
  my ($class, $tiles) = @_;

  die 'Intersection->new() requires an arrayref of 3 tiles'
    unless $tiles && ref $tiles eq 'ARRAY' && @$tiles == 3;

  # check tiles are joined
  for my $t1 (@$tiles)
  {
    for my $t2 (@$tiles)
    {
      die 'Invalid intersection - all 3 tiles must be next to each other'
        unless $t1 eq $t2 || $t1->hex_distance($t2) == 1;
    }
  }

  bless {
    location => $tiles,
    uuid     => join('|', map {$_->id} sort {$a->id cmp $b->id}  @$tiles),
  }, $class;
}

sub uuid { $_[0]->{uuid} }

sub is_colliding
{
  my ($self, $location) = @_;

  die 'is_colliding requires an Intersection or Path object as an argument'
    unless $location && ($location->isa('Catan::Map::Intersection')
                         || $location->isa('Catan::Map::Path'));
  return $location->isa('Catan::Map::Path')
          ? $location->is_colliding($self)
          : $self eq $location;
}

sub is_adjacent
{
  my ($self, $location) = @_;

  die 'is_adjacent requires an Intersection or tile object as an argument'
    unless $location
      && ( $location->isa('Catan::Map::Intersection')
           || $location->isa('Catan::Map::Tile'));

  my ($matching_tiles, $tiles_to_match) = (0);
  if ($location->isa('Catan::Map::Intersection'))
  {
    $tiles_to_match = 2;

    # intersections are adjacent if they share 2 coordinates with the intersection
    for my $hex (@{$self->{location}})
    {
      $matching_tiles += grep($hex eq $_, @{$location->{location}});
    }
  }
  else
  {
    $tiles_to_match = 1;
    # tiles are adjacent if they share 1 coordinate with the intersection
    for my $tile (@{$self->{location}})
    {
      $matching_tiles += $tile eq $location ? 1 : 0;
    }
  }
  return $matching_tiles == $tiles_to_match;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Catan::Map::Intersection

=head1 VERSION

version 0.03

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
