package Net::SSLLabs::StatusCodes;

use strict;
use warnings;

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    return $self;
}

sub status_details {
    my ($self) = @_;
    return %{ $self->{statusDetails} };
}

1;
__END__

=head1 NAME

Net::SSLLabs::StatusCodes - StatusCodes object

=head1 METHODS

=head2 new

a new C<Net::SSLLabs::StatusCodes> object, accepts a JSON object as it's parameter.

=head2 status_details

a hash containing all status details codes and the corresponding English translations. Please note that, once in use, the codes will not change, whereas the translations may change at any time.
